"""2024.2.0 Ajout de la catégorie des types de dépenses

Revision ID: 7c3bc9b26029
Revises: 8a238e064197
Create Date: 2024-03-07 17:02:00.641212

"""

# revision identifiers, used by Alembic.
revision = "7c3bc9b26029"
down_revision = "8a238e064197"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("expense_type", sa.Column("category", sa.String(1), nullable=True))
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("expense_type", "category")
    # ### end Alembic commands ###
