"""2025.5.0 ajout sepa_transfer_id

Create Date: 2025-04-18 08:42:40.163654

"""

# revision identifiers, used by Alembic.

# Revision ID:
revision = "4aef2193c0e9"

# Revises (previous revision or revisions):
down_revision = "88700e5b4360"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic import utils


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    if utils.column_exists("business", "closed"):
        op.drop_column("business", "closed")
    if utils.column_exists("groups", "primary"):
        op.drop_column("groups", "primary")
    op.add_column(
        "expense_sheet",
        sa.Column("sepa_credit_transfer_id", sa.Integer(), nullable=True),
    )
    op.create_foreign_key(
        op.f("fk_expense_sheet_sepa_credit_transfer_id"),
        "expense_sheet",
        "sepa_credit_transfer",
        ["sepa_credit_transfer_id"],
        ["id"],
        ondelete="SET NULL",
    )

    op.add_column(
        "supplier_invoice",
        sa.Column("sepa_credit_transfer_id", sa.Integer(), nullable=True),
    )
    op.create_foreign_key(
        op.f("fk_supplier_invoice_sepa_credit_transfer_id"),
        "supplier_invoice",
        "sepa_credit_transfer",
        ["sepa_credit_transfer_id"],
        ["id"],
        ondelete="SET NULL",
    )

    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    # Prevent that SQL crash on schema migration:
    # > Incorrect datetime value: '0000-00-00 00:00:00' for column 'status_date' at row 145")
    # (bug has been triggered at least on Ouvre-Boites data)
    op.execute(
        "UPDATE supplier_invoice SET paid_status_date=date WHERE paid_status_date LIKE '0000%'"
    )

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    migrate_datas()
    update_database_structure()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        op.f("fk_supplier_invoice_sepa_credit_transfer_id"),
        "supplier_invoice",
        type_="foreignkey",
    )
    op.drop_column("supplier_invoice", "sepa_credit_transfer_id")
    op.drop_constraint(
        op.f("fk_expense_sheet_sepa_credit_transfer_id"),
        "expense_sheet",
        type_="foreignkey",
    )
    op.drop_column("expense_sheet", "sepa_credit_transfer_id")
    # ### end Alembic commands ###
