"""4.2.0 Cascade delete workshop trainers

Either removal of an user or a workshop would have to delete the many-to-many
table entry.

Revision ID: 2ab20c4414aa
Revises: 3fa09c31c2ac
Create Date: 2018-11-07 11:37:27.692806

"""

# revision identifiers, used by Alembic.
revision = "2ab20c4414aa"
down_revision = "3fa09c31c2ac"

from alembic import op


def update_database_structure():
    op.drop_constraint(
        "fk_workshop_trainer_user_id", "workshop_trainer", type_="foreignkey"
    )
    op.drop_constraint(
        "fk_workshop_trainer_workshop_id", "workshop_trainer", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_workshop_trainer_user_id"),
        "workshop_trainer",
        "accounts",
        ["user_id"],
        ["id"],
        ondelete="cascade",
    )
    op.create_foreign_key(
        op.f("fk_workshop_trainer_workshop_id"),
        "workshop_trainer",
        "workshop",
        ["workshop_id"],
        ["id"],
        ondelete="cascade",
    )


def upgrade():
    update_database_structure()


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        op.f("fk_workshop_trainer_workshop_id"), "workshop_trainer", type_="foreignkey"
    )
    op.drop_constraint(
        op.f("fk_workshop_trainer_user_id"), "workshop_trainer", type_="foreignkey"
    )
    op.create_foreign_key(
        "fk_workshop_trainer_workshop_id",
        "workshop_trainer",
        "workshop",
        ["workshop_id"],
        ["id"],
    )
    op.create_foreign_key(
        "fk_workshop_trainer_user_id",
        "workshop_trainer",
        "accounts",
        ["user_id"],
        ["id"],
    )
    ### end Alembic commands ###
