# -*-coding:utf-8-*-
"""4.3 add Task_pdf_file_hash

Revision ID: 432e6cd0752c
Revises: 24119bbaeaad
Create Date: 2019-01-17 17:49:18.814046

"""

# revision identifiers, used by Alembic.
revision = "432e6cd0752c"
down_revision = "24119bbaeaad"

from zope.sqlalchemy import mark_changed
import hashlib
import logging
from alembic import op
import sqlalchemy as sa


def update_database_structure():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "task", sa.Column("pdf_file_hash", sa.String(length=40), nullable=True)
    )
    ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()
    from caerp.models.files import File

    logger = logging.getLogger(__name__)

    for row in list(
        conn.execute("select id, pdf_file_id from task where pdf_file_id is not NULL")
    ):
        try:
            datas = File.get(row.pdf_file_id).data_obj
            if not datas:
                # La classe File intercepte les IOError et remplace le data_obj
                # (l'objet File attendu) par une string vide, ici on regénère
                # l'exception
                raise IOError("File {0} not existing on disk".format(row.pdf_file_id))
            hash = hashlib.sha1(datas.read()).hexdigest()
            req = sa.text("update task set pdf_file_hash=:hash where id=:id_")
            conn.execute(req, id_=row.id, hash=hash)
        except IOError:
            logger.exception("Attention fichier manquant sur disque !!! ")
            req = sa.text("update task set pdf_file_id = NULL where id=:id_")
            conn.execute(req, id_=row.id)
    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("task", "pdf_file_hash")
    ### end Alembic commands ###
