"""4.3 Update workshops company_manager

Revision ID: 3c03cea7c1b5
Revises: 4f37cb2ebd97
Create Date: 2019-03-01 15:08:29.207900

"""

# revision identifiers, used by Alembic.
revision = "3c03cea7c1b5"
down_revision = "4f37cb2ebd97"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    ### commands auto generated by Alembic - please adjust! ###
    ### end Alembic commands ###
    pass


def get_company_id_by_employee_account_id(account_id):
    cnx = op.get_bind()
    company_id = None
    companies = cnx.execute(
        "SELECT company_id from company_employee WHERE account_id=%s" % account_id
    )
    if companies is not None and companies.rowcount < 2:
        for company in companies:
            company_id = company.company_id
    return company_id


def is_user_in_EA_group(user_id):
    cnx = op.get_bind()
    user_groups = cnx.execute(
        "SELECT g.name from login l JOIN user_groups ug on l.id = ug.login_id "
        "JOIN groups g on ug.group_id = g.id WHERE l.user_id=%s" % user_id
    )
    groups = []
    if user_groups is not None:
        for user_group in user_groups:
            groups.append(user_group)

    is_ea = "manager" in groups
    return is_ea


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    cnx = op.get_bind()
    workshops = cnx.execute(
        "SELECT w.id, w.company_manager_id, e.owner_id FROM workshop AS w JOIN event as e on w.id=e.id WHERE w.company_manager_id IS null"
    )
    for workshop in workshops:
        if workshop.owner_id is not None:
            is_user_ea = is_user_in_EA_group(workshop.owner_id)
            company_manager_id = get_company_id_by_employee_account_id(
                workshop.owner_id
            )
            if company_manager_id is not None and not is_user_ea:
                cnx.execute(
                    "UPDATE workshop SET company_manager_id=%s WHERE id=%s"
                    % (company_manager_id, workshop.id)
                )

    from zope.sqlalchemy import mark_changed

    mark_changed(session)


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    ### end Alembic commands ###
    pass
