"""5.1 facturation_avancement

Revision ID: e4151c91ccfb
Revises: 13bbeb791326
Create Date: 2019-10-16 11:44:46.506847

"""

# revision identifiers, used by Alembic.
revision = "e4151c91ccfb"
down_revision = "13bbeb791326"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "accounts", "civilite", existing_type=mysql.VARCHAR(length=10), nullable=False
    )
    op.add_column(
        "business", sa.Column("invoicing_mode", sa.String(length=20), nullable=True)
    )
    op.add_column(
        "invoice", sa.Column("invoicing_mode", sa.String(length=20), nullable=True)
    )
    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()
    conn.execute("update business set invoicing_mode='classic';")
    conn.execute("update invoice set invoicing_mode='classic';")
    from zope.sqlalchemy import mark_changed

    mark_changed(session)


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    print("NO DOWNGRADE AVAILABLE")
