"""6.0 add_cascading_strategies

Revision ID: 701c65a78b84
Revises: c521ac577082
Create Date: 2019-12-26 16:33:55.676102

"""

# revision identifiers, used by Alembic.
revision = "701c65a78b84"
down_revision = "c521ac577082"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import (
    drop_index_if_exists,
    drop_foreign_key_if_exists,
)


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        "alter ignore table project_customer add unique index idx_uniq (customer_id, project_id);"
    )

    # Task status_person devient nul quand le compte est supprime
    op.execute("alter table task modify `status_person_id` int(11) default NULL;")
    op.execute(
        "update task set status_person_id = NULL where not exists (select 1 from accounts where accounts.id=task.status_person_id)"
    )
    drop_index_if_exists("task", "statusPerson")
    drop_foreign_key_if_exists("task", "fk_task_statusPerson_accounts")
    drop_foreign_key_if_exists("task", "fk_task_status_person_id")
    op.create_foreign_key(
        op.f("fk_task_status_person_id"),
        "task",
        "accounts",
        ["status_person_id"],
        ["id"],
        ondelete="SET NULL",
    )

    # Expense status_person devient nul quand le compte est supprime
    op.execute(
        "alter table expense_sheet modify `status_user_id` int(11) default NULL;"
    )
    op.execute(
        "update expense_sheet set status_user_id = NULL where not exists (select 1 from accounts where accounts.id=expense_sheet.status_user_id)"
    )

    op.drop_constraint(
        "fk_expense_sheet_status_user_id", "expense_sheet", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_expense_sheet_status_user_id"),
        "expense_sheet",
        "accounts",
        ["status_user_id"],
        ["id"],
        ondelete="SET NULL",
    )

    # Le user_id d'un expense_payment est mise a NULL
    op.execute(
        "update expense_payment set user_id= NULL where not exists (select 1 from accounts where accounts.id=expense_payment.user_id)"
    )
    op.drop_constraint(
        "fk_expense_payment_user_id", "expense_payment", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_expense_payment_user_id"),
        "expense_payment",
        "accounts",
        ["user_id"],
        ["id"],
        ondelete="SET NULL",
    )

    # Le user_id d'un payment est mis a NULL
    op.execute(
        "update payment set user_id= NULL where not exists (select 1 from accounts where accounts.id=payment.user_id)"
    )
    op.drop_constraint("fk_payment_user_id", "payment", type_="foreignkey")
    op.create_foreign_key(
        op.f("fk_payment_user_id"),
        "payment",
        "accounts",
        ["user_id"],
        ["id"],
        ondelete="SET NULL",
    )

    drop_foreign_key_if_exists("sale_product_category", "sale_product_category_ibfk_1")
    drop_foreign_key_if_exists(
        "sale_product_category", "fk_sale_product_category_company_id"
    )
    op.create_foreign_key(
        op.f("fk_sale_product_category_company_id"),
        "sale_product_category",
        "company",
        ["company_id"],
        ["id"],
        ondelete="cascade",
    )

    op.drop_constraint(
        "fk_business_bpf_data_income_source_business_bpf_data_id",
        "business_bpf_data_income_source",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_business_bpf_data_income_source_business_bpf_data_id"),
        "business_bpf_data_income_source",
        "business_bpf_data",
        ["business_bpf_data_id"],
        ["id"],
        ondelete="cascade",
    )

    op.drop_constraint(
        "fk_business_bpf_data_trainee_count_business_bpf_data_id",
        "business_bpf_data_trainee_count",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_business_bpf_data_trainee_count_business_bpf_data_id"),
        "business_bpf_data_trainee_count",
        "business_bpf_data",
        ["business_bpf_data_id"],
        ["id"],
        ondelete="cascade",
    )
    op.drop_constraint(
        "fk_supplier_payment_supplier_invoice_id",
        "supplier_payment",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_supplier_payment_supplier_invoice_id"),
        "supplier_payment",
        "supplier_invoice",
        ["supplier_invoice_id"],
        ["id"],
        ondelete="cascade",
    )

    op.drop_constraint(
        "fk_business_payment_deadline_estimation_id",
        "business_payment_deadline",
        type_="foreignkey",
    )
    op.drop_constraint(
        "fk_business_payment_deadline_estimation_payment_id",
        "business_payment_deadline",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_business_payment_deadline_estimation_id"),
        "business_payment_deadline",
        "estimation",
        ["estimation_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.create_foreign_key(
        op.f("fk_business_payment_deadline_estimation_payment_id"),
        "business_payment_deadline",
        "estimation_payment",
        ["estimation_payment_id"],
        ["id"],
        ondelete="CASCADE",
    )
    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    print("No downgrade available")
