"""6.1.0 ajout de cascade

Revision ID: 0a7b4ce1193a
Revises: 8b8ac63f8333
Create Date: 2021-01-18 16:28:23.559407

"""

# revision identifiers, used by Alembic.
revision = "0a7b4ce1193a"
down_revision = "8b8ac63f8333"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic import utils


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "career_path",
        "hourly_rate_string",
        existing_type=mysql.VARCHAR(length=48),
        type_=sa.String(length=100),
        existing_nullable=True,
    )
    op.alter_column("company", "updated_at", existing_type=sa.DATE(), nullable=False)
    op.alter_column("config", "value", existing_type=mysql.TEXT(), nullable=True)

    if utils.foreign_key_exists(
        "progress_invoicing_base_status",
        "fk_progress_invoicing_base_status_business_id",
    ):
        op.drop_constraint(
            "fk_progress_invoicing_base_status_business_id",
            "progress_invoicing_base_status",
            type_="foreignkey",
        )
    op.create_foreign_key(
        op.f("fk_progress_invoicing_base_status_business_id"),
        "progress_invoicing_base_status",
        "business",
        ["business_id"],
        ["id"],
        ondelete="CASCADE",
    )

    utils.drop_foreign_key_if_exists("project_customer", "project_customer_ibfk_1")
    utils.drop_foreign_key_if_exists("project_customer", "project_customer_ibfk_2")
    utils.drop_foreign_key_if_exists(
        "project_customer", "fk_project_customer_customer_id"
    )
    utils.drop_foreign_key_if_exists(
        "project_customer", "fk_project_customer_project_id"
    )
    utils.drop_index_if_exists("project_customer", "client_id")

    utils.drop_foreign_key_if_exists("project_customer", "idx_uniq")
    utils.drop_index_if_exists("project_customer", "idx_uniq")

    if not utils.index_exists("project_customer", "uniq_idx"):
        op.create_unique_constraint(
            "uniq_idx", "project_customer", ["project_id", "customer_id"]
        )

    op.alter_column(
        "project_customer",
        "customer_id",
        existing_type=mysql.INTEGER(display_width=11),
        nullable=True,
    )

    utils.drop_foreign_key_if_exists(
        "sale_product_service_delivery", "fk_sale_product_service_delivery_id"
    )
    op.create_foreign_key(
        op.f("fk_sale_product_service_delivery_id"),
        "sale_product_service_delivery",
        "base_sale_product",
        ["id"],
        ["id"],
        ondelete="cascade",
    )

    utils.drop_foreign_key_if_exists(
        "sale_product_stock_operation",
        "fk_sale_product_stock_operation_base_sale_product_id",
    )
    op.create_foreign_key(
        op.f("fk_sale_product_stock_operation_base_sale_product_id"),
        "sale_product_stock_operation",
        "base_sale_product",
        ["base_sale_product_id"],
        ["id"],
        ondelete="CASCADE",
    )

    op.alter_column(
        "task",
        "frozen_settings",
        existing_type=mysql.LONGTEXT(charset="utf8mb4", collation="utf8mb4_bin"),
        type_=sa.JSON(),
        existing_nullable=True,
    )

    if not utils.foreign_key_exists("task", "fk_task_phase_id"):
        op.create_foreign_key(
            op.f("fk_task_phase_id"), "task", "phase", ["phase_id"], ["id"]
        )
    if not utils.foreign_key_exists("task", "fk_task_id"):
        op.create_foreign_key(op.f("fk_task_id"), "task", "node", ["id"], ["id"])

    if not utils.foreign_key_exists("task", "fk_task_owner_id"):
        op.create_foreign_key(
            op.f("fk_task_owner_id"), "task", "accounts", ["owner_id"], ["id"]
        )

    if utils.column_exists("task", "version"):
        op.drop_column("task", "version")

    op.alter_column(
        "task_status",
        "status_code",
        existing_type=mysql.VARCHAR(length=10),
        nullable=True,
    )
    op.alter_column(
        "task_status", "status_comment", existing_type=mysql.TEXT(), nullable=True
    )

    op.alter_column(
        "task_status",
        "status_person_id",
        existing_type=mysql.INTEGER(display_width=11),
        nullable=True,
    )

    utils.raw_sql(
        "update task_status set status_person_id=Null where " "status_person_id=0;"
    )
    if utils.index_exists("task_status", "statusPerson"):
        op.drop_index("statusPerson", table_name="task_status")

    if not utils.foreign_key_exists("task_status", "fk_task_status_status_person_id"):
        op.create_foreign_key(
            op.f("fk_task_status_status_person_id"),
            "task_status",
            "accounts",
            ["status_person_id"],
            ["id"],
            ondelete="set null",
        )

    op.alter_column(
        "tva", "name", existing_type=mysql.VARCHAR(length=15), nullable=False
    )
    if not utils.foreign_key_exists("user_datas", "fk_user_datas_id"):
        op.create_foreign_key(
            op.f("fk_user_datas_id"), "user_datas", "node", ["id"], ["id"]
        )

    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    pass
