"""6.1.0 typage des custombookentry

Revision ID: 8742fe30a7c0
Revises: a623cf307603
Create Date: 2021-03-15 12:44:13.182625

"""

# revision identifiers, used by Alembic.
revision = "8742fe30a7c0"
down_revision = "a623cf307603"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import (
    drop_index_if_exists,
    drop_foreign_key_if_exists,
)


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "custom_invoice_book_entry_module",
        sa.Column("doctype", sa.String(length=50), nullable=False),
    )

    drop_foreign_key_if_exists("payment", "fk_payment_bank_id")
    drop_index_if_exists("payment", "fk_payment_bank_id_bank_account")
    result = drop_index_if_exists("payment", "fk_payment_bank_remittance")
    if result:
        op.create_foreign_key(
            op.f("fk_payment_bank_remittance_id"),
            "payment",
            "bank_remittance",
            ["bank_remittance_id"],
            ["id"],
        )
    drop_foreign_key_if_exists(
        "sale_product_category", "fk_sale_product_category_company_id_company"
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()
    conn.execute("update custom_invoice_book_entry_module set doctype='invoice'")

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("custom_invoice_book_entry_module", "doctype")
    # ### end Alembic commands ###
