"""6.2.0 Ajout d'un markeur autovalidate au modèle Task

Revision ID: 6ea8700cae45
Revises: 522f4e21cacf
Create Date: 2021-05-31 12:53:49.346688

"""

# revision identifiers, used by Alembic.
revision = "6ea8700cae45"
down_revision = "522f4e21cacf"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("task", sa.Column("auto_validated", sa.Boolean(), nullable=True))
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()
    op.execute("UPDATE task SET auto_validated=0 WHERE auto_validated is NULL")

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("task", "auto_validated")
    # ### end Alembic commands ###
