"""6.2.0 Ajoute SupplierInvoice.worker_paid_status et SupplierInvoice.supplier_paid_status

Revision ID: 522f4e21cacf
Revises: 9c91fbe01305
Create Date: 2021-06-11 10:12:37.100255

"""

# revision identifiers, used by Alembic.
revision = "522f4e21cacf"
down_revision = "9c91fbe01305"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "supplier_invoice",
        sa.Column("worker_paid_status", sa.String(length=10), nullable=True),
    )
    op.add_column(
        "supplier_invoice",
        sa.Column("supplier_paid_status", sa.String(length=10), nullable=True),
    )


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()
    # worker payments did not exist before, so no pre-existing DB entries.
    op.execute("UPDATE supplier_invoice SET worker_paid_status = 'waiting'")
    # supplier payment was the only available payment before
    op.execute("UPDATE supplier_invoice SET supplier_paid_status = paid_status")
    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    op.drop_column("supplier_invoice", "supplier_paid_status")
    op.drop_column("supplier_invoice", "worker_paid_status")
