"""6.3.0 ajout du first visit

Revision ID: b1b7468b8889
Revises: 6dfc1e2ae23c
Create Date: 2021-10-14 22:39:44.743456

"""

# revision identifiers, used by Alembic.
revision = "b1b7468b8889"
down_revision = "6dfc1e2ae23c"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("task", sa.Column("first_visit", sa.Date(), nullable=True))
    op.add_column("task", sa.Column("end_date", sa.String(length=255), nullable=True))
    # ### end Alembic commands ###


def migrate_datas():
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from caerp.models.form_options import FormFieldDefinition

    for field in (
        {
            "field_name": "workplace",
            "title": "Lieu d’exécution",
            "visible": True,
            "required": False,
        },
        {
            "field_name": "validity_duration",
            "title": "Durée de validité du devis",
            "required": True,
        },
        {
            "field_name": "start_date",
            "title": "Date de début de prestation",
            "visible": True,
            "required": False,
        },
    ):
        if (
            FormFieldDefinition.query()
            .filter_by(field_name=field["field_name"])
            .count()
            == 0
        ):
            field_def = FormFieldDefinition(form="task", **field)
            session.add(field_def)
            session.flush()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("task", "first_visit")
    op.drop_column("task", "end_date")
    # ### end Alembic commands ###
