"""6.3.0 utilisation du format numeric pour les contributions d'enseigne

Revision ID: 6dfc1e2ae23c
Revises: 197085e72d54
Create Date: 2021-10-07 18:00:19.015735

"""

# revision identifiers, used by Alembic.
revision = "6dfc1e2ae23c"
down_revision = "197085e72d54"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

from caerp.alembic.utils import rename_column


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "company",
        "custom_insurance_rate",
        existing_type=mysql.FLOAT(),
        type_=sa.Numeric(precision=5, scale=2),
        existing_nullable=True,
    )
    op.alter_column(
        "company",
        "contribution",
        existing_type=mysql.FLOAT(),
        type_=sa.Numeric(precision=5, scale=2),
        existing_nullable=True,
    )
    op.alter_column(
        "company",
        "internalcontribution",
        existing_type=mysql.FLOAT(),
        type_=sa.Numeric(precision=5, scale=2),
        existing_nullable=True,
    )
    op.alter_column(
        "custom_invoice_book_entry_module",
        "percentage",
        existing_type=mysql.FLOAT(),
        type_=sa.Numeric(precision=5, scale=2),
        existing_nullable=False,
    )
    op.add_column(
        "custom_invoice_book_entry_module",
        sa.Column(
            "custom",
            sa.Boolean(),
        ),
    )
    op.add_column(
        "custom_invoice_book_entry_module",
        sa.Column("name", sa.String(100), nullable=True),
    )

    op.add_column(
        "company",
        sa.Column(
            "internalinsurance",
            sa.Numeric(precision=5, scale=2),
            nullable=True,
        ),
    )
    rename_column(
        "company",
        "custom_insurance_rate",
        "insurance",
        type_=sa.Numeric(precision=5, scale=2),
        nullable=True,
    )
    # ### end Alembic commands ###


def migrate_data():
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    op.execute("UPDATE custom_invoice_book_entry_module SET custom=1;")
    op.execute("DELETE from custom_invoice_book_entry_module where active=0;")

    from caerp.models.config import Config
    from caerp.models.accounting.bookeeping import CustomInvoiceBookEntryModule

    label_key = "bookentry_contribution_label_template"
    cg_credit_key = "compte_cg_contribution"
    cg_debit_key = "compte_cg_contribution"  # Le même compte
    enabled_key = "sage_contribution"
    percentage_key = "contribution_cae"

    for (prefix, doctype) in (
        ("internal", "internalinvoice"),
        ("", "invoice"),
    ):
        label_template = Config.get_value("%s%s" % (prefix, label_key))
        cg_credit = Config.get_value("%s%s" % (prefix, cg_credit_key))
        cg_debit = Config.get_value("%s%s" % (prefix, cg_debit_key))
        enabled = Config.get_value("%s%s" % (prefix, enabled_key), type_=bool)
        percentage = Config.get_value(
            "%s%s" % (prefix, percentage_key), default=0, type_=float
        )

        if label_template and cg_credit and percentage:
            bookentry = CustomInvoiceBookEntryModule(
                title="Contribution à la CAE",
                name="contribution",
                label_template=label_template,
                compte_cg_credit=cg_credit,
                compte_cg_debit=cg_debit,
                enabled=enabled == 1,
                doctype=doctype,
                custom=False,
                percentage=percentage,
            )
            session.add(bookentry)

    op.execute("""Delete from config where name LIKE "%contribution%";""")

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_data()


def downgrade():
    op.alter_column(
        "company",
        "internalcontribution",
        existing_type=sa.Numeric(precision=5, scale=2),
        type_=mysql.FLOAT(),
        existing_nullable=True,
    )
    op.alter_column(
        "company",
        "contribution",
        existing_type=sa.Numeric(precision=5, scale=2),
        type_=mysql.FLOAT(),
        existing_nullable=True,
    )
    op.alter_column(
        "company",
        "custom_insurance_rate",
        existing_type=sa.Numeric(precision=5, scale=2),
        type_=mysql.FLOAT(),
        existing_nullable=True,
    )
    op.alter_column(
        "custom_invoice_book_entry_module",
        "percentage",
        existing_type=sa.Numeric(precision=5, scale=2),
        type=mysql.FLOAT(),
        existing_nullable=False,
    )
    op.drop_column("custom_invoice_book_entry_module", "custom")
    # ### end Alembic commands ###
