"""6.5 ajout de champ numero de voie urssaf_3p

Revision ID: e26f31c51194
Revises: aef809bffbc3
Create Date: 2023-02-07 16:12:25.057756

"""

# revision identifiers, used by Alembic.
revision = "e26f31c51194"
down_revision = "aef809bffbc3"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import column_exists


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    if not column_exists("urssaf_customer_data", "street_number"):
        op.add_column(
            "urssaf_customer_data",
            sa.Column("street_number", sa.String(length=12), nullable=True),
        )
    if not column_exists("urssaf_customer_data", "street_number_complement"):
        op.add_column(
            "urssaf_customer_data",
            sa.Column("street_number_complement", sa.String(length=5), nullable=True),
        )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("urssaf_customer_data", "street_number_complement")
    op.drop_column("urssaf_customer_data", "street_number")
    # ### end Alembic commands ###
