"""
List of Countries from INSEE

We are not using the original list from INSEE (kept for reference commented)
 but a reworked version without multiple entries for a given code.

"""
from typing import List


# _COUNTRIES = [
#     {"code_insee": "99319", "name": "ACORES, MADERE"},
#     {"code_insee": "99212", "name": "AFGHANISTAN"},
#     {"code_insee": "99303", "name": "AFRIQUE DU SUD"},
#     {"code_insee": "99404", "name": "ALASKA"},
#     {"code_insee": "99125", "name": "ALBANIE"},
#     {"code_insee": "99352", "name": "ALGERIE"},
#     {"code_insee": "99109", "name": "ALLEMAGNE"},
#     {"code_insee": "99130", "name": "ANDORRE"},
#     {"code_insee": "99395", "name": "ANGOLA"},
#     {"code_insee": "99425", "name": "ANGUILLA"},
#     {"code_insee": "99441", "name": "ANTIGUA-ET-BARBUDA"},
#     {"code_insee": "99431", "name": "ANTILLES NEERLANDAISES"},
#     {"code_insee": "99201", "name": "ARABIE SAOUDITE"},
#     {"code_insee": "99415", "name": "ARGENTINE"},
#     {"code_insee": "99252", "name": "ARMENIE"},
#     {"code_insee": "99135", "name": "ARUBA"},
#     {"code_insee": "99501", "name": "AUSTRALIE"},
#     {"code_insee": "99110", "name": "AUTRICHE"},
#     {"code_insee": "99253", "name": "AZERBAIDJAN"},
#     {"code_insee": "99436", "name": "BAHAMAS"},
#     {"code_insee": "99249", "name": "BAHREIN"},
#     {"code_insee": "99246", "name": "BANGLADESH"},
#     {"code_insee": "99434", "name": "BARBADE"},
#     {"code_insee": "99131", "name": "BELGIQUE"},
#     {"code_insee": "99429", "name": "BELIZE"},
#     {"code_insee": "99327", "name": "BENIN"},
#     {"code_insee": "99425", "name": "BERMUDES"},
#     {"code_insee": "99214", "name": "BHOUTAN"},
#     {"code_insee": "99148", "name": "BIELORUSSIE"},
#     {"code_insee": "99224", "name": "BIRMANIE"},
#     {"code_insee": "99418", "name": "BOLIVIE"},
#     {"code_insee": "99443", "name": "BONAIRE, SAINT EUSTACHE ET SABA"},
#     {"code_insee": "99118", "name": "BOSNIE-HERZEGOVINE"},
#     {"code_insee": "99347", "name": "BOTSWANA"},
#     {"code_insee": "99103", "name": "BOUVET (ILE)"},
#     {"code_insee": "99416", "name": "BRESIL"},
#     {"code_insee": "99225", "name": "BRUNEI"},
#     {"code_insee": "99111", "name": "BULGARIE"},
#     {"code_insee": "99331", "name": "BURKINA"},
#     {"code_insee": "99321", "name": "BURUNDI"},
#     {"code_insee": "99425", "name": "CAIMANES (ILES)"},
#     {"code_insee": "99234", "name": "CAMBODGE"},
#     {"code_insee": "99322", "name": "CAMEROUN"},
#     {"code_insee": "99305", "name": "CAMEROUN ET TOGO"},
#     {"code_insee": "99401", "name": "CANADA"},
#     {"code_insee": "99313", "name": "CANARIES (ILES)"},
#     {"code_insee": "99396", "name": "CAP-VERT"},
#     {"code_insee": "99323", "name": "CENTRAFRICAINE (REPUBLIQUE)"},
#     {"code_insee": "99417", "name": "CHILI"},
#     {"code_insee": "99216", "name": "CHINE"},
#     {"code_insee": "99501", "name": "CHRISTMAS (ILE)"},
#     {"code_insee": "99254", "name": "CHYPRE"},
#     {"code_insee": "99501", "name": "COCOS ou KEELING (ILES)"},
#     {"code_insee": "99419", "name": "COLOMBIE"},
#     {"code_insee": "99397", "name": "COMORES"},
#     {"code_insee": "99324", "name": "CONGO"},
#     {"code_insee": "99312", "name": "CONGO (REPUBLIQUE DEMOCRATIQUE)"},
#     {"code_insee": "99502", "name": "COOK (ILES)"},
#     {"code_insee": "99237", "name": "COREE"},
#     {"code_insee": "99239", "name": "COREE (REPUBLIQUE DE)"},
#     {"code_insee": "99238", "name": "COREE (REPUBLIQUE POPULAIRE DEMOCRATIQUE DE)"},
#     {"code_insee": "99406", "name": "COSTA RICA"},
#     {"code_insee": "99326", "name": "COTE D'IVOIRE"},
#     {"code_insee": "99119", "name": "CROATIE"},
#     {"code_insee": "99407", "name": "CUBA"},
#     {"code_insee": "99444", "name": "CURA\u00c7AO"},
#     {"code_insee": "99101", "name": "DANEMARK"},
#     {"code_insee": "99399", "name": "DJIBOUTI"},
#     {"code_insee": "99408", "name": "DOMINICAINE (REPUBLIQUE)"},
#     {"code_insee": "99438", "name": "DOMINIQUE"},
#     {"code_insee": "99301", "name": "EGYPTE"},
#     {"code_insee": "99414", "name": "EL SALVADOR"},
#     {"code_insee": "99247", "name": "EMIRATS ARABES UNIS"},
#     {"code_insee": "99420", "name": "EQUATEUR"},
#     {"code_insee": "99317", "name": "ERYTHREE"},
#     {"code_insee": "99134", "name": "ESPAGNE"},
#     {"code_insee": "99106", "name": "ESTONIE"},
#     {"code_insee": "99391", "name": "ESWATINI"},
#     {"code_insee": "99228", "name": "ETATS MALAIS NON FEDERES"},
#     {"code_insee": "99404", "name": "ETATS-UNIS"},
#     {"code_insee": "99315", "name": "ETHIOPIE"},
#     {"code_insee": "99101", "name": "FEROE (ILES)"},
#     {"code_insee": "99508", "name": "FIDJI"},
#     {"code_insee": "99105", "name": "FINLANDE"},
#     {"code_insee": "99100", "name": "FRANCE"},
#     {"code_insee": "99328", "name": "GABON"},
#     {"code_insee": "99304", "name": "GAMBIE"},
#     {"code_insee": "99255", "name": "GEORGIE"},
#     {"code_insee": "99427", "name": "GEORGIE DU SUD ET LES ILES SANDWICH DU SUD"},
#     {"code_insee": "99329", "name": "GHANA"},
#     {"code_insee": "99133", "name": "GIBRALTAR"},
#     {"code_insee": "99223", "name": "GOA"},
#     {"code_insee": "99126", "name": "GRECE"},
#     {"code_insee": "99435", "name": "GRENADE"},
#     {"code_insee": "99430", "name": "GROENLAND"},
#     {"code_insee": "99505", "name": "GUAM"},
#     {"code_insee": "99409", "name": "GUATEMALA"},
#     {"code_insee": "99132", "name": "GUERNESEY"},
#     {"code_insee": "99330", "name": "GUINEE"},
#     {"code_insee": "99314", "name": "GUINEE EQUATORIALE"},
#     {"code_insee": "99392", "name": "GUINEE-BISSAU"},
#     {"code_insee": "99428", "name": "GUYANA"},
#     {"code_insee": "99410", "name": "HAITI"},
#     {"code_insee": "99504", "name": "HAWAII (ILES)"},
#     {"code_insee": "99501", "name": "HEARD ET MACDONALD (ILES)"},
#     {"code_insee": "99411", "name": "HONDURAS"},
#     {"code_insee": "99230", "name": "HONG-KONG"},
#     {"code_insee": "99112", "name": "HONGRIE"},
#     {"code_insee": "99320", "name": "ILES PORTUGAISES DE L'OCEAN INDIEN"},
#     {"code_insee": "99223", "name": "INDE"},
#     {"code_insee": "99231", "name": "INDONESIE"},
#     {"code_insee": "99204", "name": "IRAN"},
#     {"code_insee": "99203", "name": "IRAQ"},
#     {"code_insee": "99136", "name": "IRLANDE, ou EIRE"},
#     {"code_insee": "99102", "name": "ISLANDE"},
#     {"code_insee": "99207", "name": "ISRAEL"},
#     {"code_insee": "99127", "name": "ITALIE"},
#     {"code_insee": "99426", "name": "JAMAIQUE"},
#     {"code_insee": "99217", "name": "JAPON"},
#     {"code_insee": "99132", "name": "JERSEY"},
#     {"code_insee": "99222", "name": "JORDANIE"},
#     {"code_insee": "99211", "name": "KAMTCHATKA"},
#     {"code_insee": "99256", "name": "KAZAKHSTAN"},
#     {"code_insee": "99332", "name": "KENYA"},
#     {"code_insee": "99257", "name": "KIRGHIZISTAN"},
#     {"code_insee": "99513", "name": "KIRIBATI"},
#     {"code_insee": "99157", "name": "KOSOVO"},
#     {"code_insee": "99240", "name": "KOWEIT"},
#     {"code_insee": "99403", "name": "LABRADOR"},
#     {"code_insee": "99241", "name": "LAOS"},
#     {"code_insee": "99348", "name": "LESOTHO"},
#     {"code_insee": "99107", "name": "LETTONIE"},
#     {"code_insee": "99205", "name": "LIBAN"},
#     {"code_insee": "99302", "name": "LIBERIA"},
#     {"code_insee": "99316", "name": "LIBYE"},
#     {"code_insee": "99113", "name": "LIECHTENSTEIN"},
#     {"code_insee": "99108", "name": "LITUANIE"},
#     {"code_insee": "99137", "name": "LUXEMBOURG"},
#     {"code_insee": "99232", "name": "MACAO"},
#     {"code_insee": "99156", "name": "MACEDOINE DU NORD"},
#     {"code_insee": "99333", "name": "MADAGASCAR"},
#     {"code_insee": "99227", "name": "MALAISIE"},
#     {"code_insee": "99334", "name": "MALAWI"},
#     {"code_insee": "99229", "name": "MALDIVES"},
#     {"code_insee": "99335", "name": "MALI"},
#     {"code_insee": "99427", "name": "MALOUINES, OU FALKLAND (ILES)"},
#     {"code_insee": "99144", "name": "MALTE"},
#     {"code_insee": "99132", "name": "MAN (ILE)"},
#     {"code_insee": "99218", "name": "MANDCHOURIE"},
#     {"code_insee": "99505", "name": "MARIANNES DU NORD (ILES)"},
#     {"code_insee": "99350", "name": "MAROC"},
#     {"code_insee": "99515", "name": "MARSHALL (ILES)"},
#     {"code_insee": "99390", "name": "MAURICE"},
#     {"code_insee": "99336", "name": "MAURITANIE"},
#     {"code_insee": "99405", "name": "MEXIQUE"},
#     {"code_insee": "99516", "name": "MICRONESIE (ETATS FEDERES DE)"},
#     {"code_insee": "99151", "name": "MOLDAVIE"},
#     {"code_insee": "99138", "name": "MONACO"},
#     {"code_insee": "99242", "name": "MONGOLIE"},
#     {"code_insee": "99120", "name": "MONTENEGRO"},
#     {"code_insee": "99425", "name": "MONTSERRAT"},
#     {"code_insee": "99393", "name": "MOZAMBIQUE"},
#     {"code_insee": "99311", "name": "NAMIBIE"},
#     {"code_insee": "99507", "name": "NAURU"},
#     {"code_insee": "99215", "name": "NEPAL"},
#     {"code_insee": "99412", "name": "NICARAGUA"},
#     {"code_insee": "99337", "name": "NIGER"},
#     {"code_insee": "99338", "name": "NIGERIA"},
#     {"code_insee": "99502", "name": "NIUE"},
#     {"code_insee": "99501", "name": "NORFOLK (ILE)"},
#     {"code_insee": "99103", "name": "NORVEGE"},
#     {"code_insee": "99502", "name": "NOUVELLE-ZELANDE"},
#     {"code_insee": "99308", "name": "OCEAN INDIEN (TERRITOIRE BRITANNIQUE DE L')"},
#     {"code_insee": "99250", "name": "OMAN"},
#     {"code_insee": "99339", "name": "OUGANDA"},
#     {"code_insee": "99258", "name": "OUZBEKISTAN"},
#     {"code_insee": "99213", "name": "PAKISTAN"},
#     {"code_insee": "99517", "name": "PALAOS (ILES)"},
#     {"code_insee": "99261", "name": "PALESTINE (Etat de)"},
#     {"code_insee": "99413", "name": "PANAMA"},
#     {"code_insee": "99510", "name": "PAPOUASIE-NOUVELLE-GUINEE"},
#     {"code_insee": "99421", "name": "PARAGUAY"},
#     {"code_insee": "99135", "name": "PAYS-BAS"},
#     {"code_insee": "99422", "name": "PEROU"},
#     {"code_insee": "99220", "name": "PHILIPPINES"},
#     {"code_insee": "99503", "name": "PITCAIRN (ILE)"},
#     {"code_insee": "99122", "name": "POLOGNE"},
#     {"code_insee": "99432", "name": "PORTO RICO"},
#     {"code_insee": "99139", "name": "PORTUGAL"},
#     {"code_insee": "99221", "name": "POSSESSIONS BRITANNIQUES AU PROCHE-ORIENT"},
#     {"code_insee": "99313", "name": "PRESIDES"},
#     {"code_insee": "99313", "name": "PROVINCES ESPAGNOLES D'AFRIQUE"},
#     {"code_insee": "99248", "name": "QATAR"},
#     {"code_insee": "99141", "name": "REPUBLIQUE DEMOCRATIQUE ALLEMANDE"},
#     {"code_insee": "99142", "name": "REPUBLIQUE FEDERALE D'ALLEMAGNE"},
#     {"code_insee": "99114", "name": "ROUMANIE"},
#     {"code_insee": "99132", "name": "ROYAUME-UNI"},
#     {"code_insee": "99123", "name": "RUSSIE"},
#     {"code_insee": "99340", "name": "RWANDA"},
#     {"code_insee": "99389", "name": "SAHARA OCCIDENTAL"},
#     {"code_insee": "99442", "name": "SAINT-CHRISTOPHE-ET-NIEVES"},
#     {"code_insee": "99128", "name": "SAINT-MARIN"},
#     {"code_insee": "99445", "name": "SAINT-MARTIN (PARTIE NEERLANDAISE)"},
#     {"code_insee": "99440", "name": "SAINT-VINCENT-ET-LES GRENADINES"},
#     {"code_insee": "99306", "name": "SAINTE HELENE, ASCENSION ET TRISTAN DA CUNHA"},
#     {"code_insee": "99439", "name": "SAINTE-LUCIE"},
#     {"code_insee": "99512", "name": "SALOMON (ILES)"},
#     {"code_insee": "99505", "name": "SAMOA AMERICAINES"},
#     {"code_insee": "99506", "name": "SAMOA OCCIDENTALES"},
#     {"code_insee": "99394", "name": "SAO TOME-ET-PRINCIPE"},
#     {"code_insee": "99341", "name": "SENEGAL"},
#     {"code_insee": "99121", "name": "SERBIE"},
#     {"code_insee": "99398", "name": "SEYCHELLES"},
#     {"code_insee": "99209", "name": "SIBERIE"},
#     {"code_insee": "99342", "name": "SIERRA LEONE"},
#     {"code_insee": "99226", "name": "SINGAPOUR"},
#     {"code_insee": "99117", "name": "SLOVAQUIE"},
#     {"code_insee": "99145", "name": "SLOVENIE"},
#     {"code_insee": "99318", "name": "SOMALIE"},
#     {"code_insee": "99343", "name": "SOUDAN"},
#     {"code_insee": "99307", "name": "SOUDAN ANGLO-EGYPTIEN, KENYA, OUGANDA"},
#     {"code_insee": "99349", "name": "SOUDAN DU SUD"},
#     {"code_insee": "99235", "name": "SRI LANKA"},
#     {"code_insee": "99104", "name": "SUEDE"},
#     {"code_insee": "99140", "name": "SUISSE"},
#     {"code_insee": "99437", "name": "SURINAME"},
#     {"code_insee": "99103", "name": "SVALBARD et ILE JAN MAYEN"},
#     {"code_insee": "99206", "name": "SYRIE"},
#     {"code_insee": "99259", "name": "TADJIKISTAN"},
#     {"code_insee": "99236", "name": "TAIWAN"},
#     {"code_insee": "99325", "name": "TANGER"},
#     {"code_insee": "99309", "name": "TANZANIE"},
#     {"code_insee": "99344", "name": "TCHAD"},
#     {"code_insee": "99115", "name": "TCHECOSLOVAQUIE"},
#     {"code_insee": "99116", "name": "TCHEQUIE"},
#     {"code_insee": "99432", "name": "TERR. DES ETATS-UNIS D'AMERIQUE EN AMERIQUE"},
#     {"code_insee": "99505", "name": "TERR. DES ETATS-UNIS D'AMERIQUE EN OCEANIE"},
#     {"code_insee": "99427", "name": "TERR. DU ROYAUME-UNI DANS L'ATLANTIQUE SUD"},
#     {"code_insee": "99402", "name": "TERRE-NEUVE"},
#     {"code_insee": "99425", "name": "TERRITOIRES DU ROYAUME-UNI AUX ANTILLES"},
#     {"code_insee": "99219", "name": "THAILANDE"},
#     {"code_insee": "99262", "name": "TIMOR ORIENTAL"},
#     {"code_insee": "99345", "name": "TOGO"},
#     {"code_insee": "99502", "name": "TOKELAU"},
#     {"code_insee": "99509", "name": "TONGA"},
#     {"code_insee": "99433", "name": "TRINITE-ET-TOBAGO"},
#     {"code_insee": "99351", "name": "TUNISIE"},
#     {"code_insee": "99210", "name": "TURKESTAN RUSSE"},
#     {"code_insee": "99260", "name": "TURKMENISTAN"},
#     {"code_insee": "99425", "name": "TURKS ET CAIQUES (ILES)"},
#     {"code_insee": "99208", "name": "TURQUIE"},
#     {"code_insee": "99124", "name": "TURQUIE D'EUROPE"},
#     {"code_insee": "99511", "name": "TUVALU"},
#     {"code_insee": "99155", "name": "UKRAINE"},
#     {"code_insee": "99423", "name": "URUGUAY"},
#     {"code_insee": "99514", "name": "VANUATU"},
#     {"code_insee": "99129", "name": "VATICAN, ou SAINT-SIEGE"},
#     {"code_insee": "99424", "name": "VENEZUELA"},
#     {"code_insee": "99425", "name": "VIERGES BRITANNIQUES (ILES)"},
#     {"code_insee": "99432", "name": "VIERGES DES ETATS-UNIS (ILES)"},
#     {"code_insee": "99243", "name": "VIET NAM"},
#     {"code_insee": "99244", "name": "VIET NAM DU NORD"},
#     {"code_insee": "99245", "name": "VIET NAM DU SUD"},
#     {"code_insee": "99251", "name": "YEMEN"},
#     {"code_insee": "99202", "name": "YEMEN (REPUBLIQUE ARABE DU)"},
#     {"code_insee": "99233", "name": "YEMEN DEMOCRATIQUE"},
#     {"code_insee": "99346", "name": "ZAMBIE"},
#     {"code_insee": "99308", "name": "ZANZIBAR"},
#     {"code_insee": "99310", "name": "ZIMBABWE"},
# ]
#
# code used to agregate entries sharing a code, used to generte COUNTRIES from _COUNTRIES.


# Kept for reference in case we update our import:
def _dedup_countries(insee_list: List[dict]) -> List[dict]:
    """
    Merge the entries sharing a same code_insee.

    >>> _dedup_countries([{"code_insee": "1", "name": "a"}, {"code_insee": "1", "name": "b"}])
    [{'code_insee': '1', 'name': 'a / b'}]

    :param insee_list: each entry has two keys: name and code_insee
    """
    _index = {}

    for entry in insee_list:
        code = entry["code_insee"]
        if code in _index:
            _index[code].append(entry["name"])
        else:
            _index[code] = [entry["name"]]
    return [{"code_insee": k, "name": " / ".join(v)} for k, v in _index.items()]


# Some entries are re-ordered by hand for easier use (ex: ROYAUME-UNI appearing before GUERNESEY)
COUNTRIES = [
    {"code_insee": "99100", "name": "FRANCE"},
    {"code_insee": "99319", "name": "ACORES, MADERE"},
    {"code_insee": "99212", "name": "AFGHANISTAN"},
    {"code_insee": "99303", "name": "AFRIQUE DU SUD"},
    {"code_insee": "99404", "name": "ETATS-UNIS / ALASKA"},
    {"code_insee": "99125", "name": "ALBANIE"},
    {"code_insee": "99352", "name": "ALGERIE"},
    {"code_insee": "99109", "name": "ALLEMAGNE"},
    {"code_insee": "99130", "name": "ANDORRE"},
    {"code_insee": "99395", "name": "ANGOLA"},
    {
        "code_insee": "99425",
        "name": "ANGUILLA / BERMUDES / CAIMANES (ILES) / MONTSERRAT / TERRITOIRES DU "
        "ROYAUME-UNI AUX ANTILLES / TURKS ET CAIQUES (ILES) / VIERGES "
        "BRITANNIQUES (ILES)",
    },
    {"code_insee": "99441", "name": "ANTIGUA-ET-BARBUDA"},
    {"code_insee": "99431", "name": "ANTILLES NEERLANDAISES"},
    {"code_insee": "99201", "name": "ARABIE SAOUDITE"},
    {"code_insee": "99415", "name": "ARGENTINE"},
    {"code_insee": "99252", "name": "ARMENIE"},
    {"code_insee": "99135", "name": "PAYS-BAS / ARUBA"},
    {
        "code_insee": "99501",
        "name": "AUSTRALIE / CHRISTMAS (ILE) / COCOS ou KEELING (ILES) / HEARD ET "
        "MACDONALD (ILES) / NORFOLK (ILE)",
    },
    {"code_insee": "99110", "name": "AUTRICHE"},
    {"code_insee": "99253", "name": "AZERBAIDJAN"},
    {"code_insee": "99436", "name": "BAHAMAS"},
    {"code_insee": "99249", "name": "BAHREIN"},
    {"code_insee": "99246", "name": "BANGLADESH"},
    {"code_insee": "99434", "name": "BARBADE"},
    {"code_insee": "99131", "name": "BELGIQUE"},
    {"code_insee": "99429", "name": "BELIZE"},
    {"code_insee": "99327", "name": "BENIN"},
    {"code_insee": "99214", "name": "BHOUTAN"},
    {"code_insee": "99148", "name": "BIELORUSSIE"},
    {"code_insee": "99224", "name": "BIRMANIE"},
    {"code_insee": "99418", "name": "BOLIVIE"},
    {"code_insee": "99443", "name": "BONAIRE, SAINT EUSTACHE ET SABA"},
    {"code_insee": "99118", "name": "BOSNIE-HERZEGOVINE"},
    {"code_insee": "99347", "name": "BOTSWANA"},
    {
        "code_insee": "99103",
        "name": "NORVEGE / BOUVET (ILE) / SVALBARD et ILE JAN MAYEN",
    },
    {"code_insee": "99416", "name": "BRESIL"},
    {"code_insee": "99225", "name": "BRUNEI"},
    {"code_insee": "99111", "name": "BULGARIE"},
    {"code_insee": "99331", "name": "BURKINA"},
    {"code_insee": "99321", "name": "BURUNDI"},
    {"code_insee": "99234", "name": "CAMBODGE"},
    {"code_insee": "99322", "name": "CAMEROUN"},
    {"code_insee": "99305", "name": "CAMEROUN ET TOGO"},
    {"code_insee": "99401", "name": "CANADA"},
    {
        "code_insee": "99313",
        "name": "CANARIES (ILES) / PRESIDES / PROVINCES ESPAGNOLES D'AFRIQUE",
    },
    {"code_insee": "99396", "name": "CAP-VERT"},
    {"code_insee": "99323", "name": "CENTRAFRICAINE (REPUBLIQUE)"},
    {"code_insee": "99417", "name": "CHILI"},
    {"code_insee": "99216", "name": "CHINE"},
    {"code_insee": "99254", "name": "CHYPRE"},
    {"code_insee": "99419", "name": "COLOMBIE"},
    {"code_insee": "99397", "name": "COMORES"},
    {"code_insee": "99324", "name": "CONGO"},
    {"code_insee": "99312", "name": "CONGO (REPUBLIQUE DEMOCRATIQUE)"},
    {"code_insee": "99502", "name": "NOUVELLE-ZELANDE / COOK (ILES) / NIUE / TOKELAU"},
    {"code_insee": "99237", "name": "COREE"},
    {"code_insee": "99239", "name": "COREE (REPUBLIQUE DE)"},
    {"code_insee": "99238", "name": "COREE (REPUBLIQUE POPULAIRE DEMOCRATIQUE DE)"},
    {"code_insee": "99406", "name": "COSTA RICA"},
    {"code_insee": "99326", "name": "COTE D'IVOIRE"},
    {"code_insee": "99119", "name": "CROATIE"},
    {"code_insee": "99407", "name": "CUBA"},
    {"code_insee": "99444", "name": "CURA\u00c7AO"},
    {"code_insee": "99101", "name": "DANEMARK / FEROE (ILES)"},
    {"code_insee": "99399", "name": "DJIBOUTI"},
    {"code_insee": "99408", "name": "DOMINICAINE (REPUBLIQUE)"},
    {"code_insee": "99438", "name": "DOMINIQUE"},
    {"code_insee": "99301", "name": "EGYPTE"},
    {"code_insee": "99414", "name": "EL SALVADOR"},
    {"code_insee": "99247", "name": "EMIRATS ARABES UNIS"},
    {"code_insee": "99420", "name": "EQUATEUR"},
    {"code_insee": "99317", "name": "ERYTHREE"},
    {"code_insee": "99134", "name": "ESPAGNE"},
    {"code_insee": "99106", "name": "ESTONIE"},
    {"code_insee": "99391", "name": "ESWATINI"},
    {"code_insee": "99228", "name": "ETATS MALAIS NON FEDERES"},
    {"code_insee": "99315", "name": "ETHIOPIE"},
    {"code_insee": "99508", "name": "FIDJI"},
    {"code_insee": "99105", "name": "FINLANDE"},
    {"code_insee": "99328", "name": "GABON"},
    {"code_insee": "99304", "name": "GAMBIE"},
    {"code_insee": "99255", "name": "GEORGIE"},
    {
        "code_insee": "99427",
        "name": "GEORGIE DU SUD ET LES ILES SANDWICH DU SUD / MALOUINES, OU FALKLAND "
        "(ILES) / TERR. DU ROYAUME-UNI DANS L'ATLANTIQUE SUD",
    },
    {"code_insee": "99329", "name": "GHANA"},
    {"code_insee": "99133", "name": "GIBRALTAR"},
    {"code_insee": "99223", "name": "INDE / GOA"},
    {"code_insee": "99126", "name": "GRECE"},
    {"code_insee": "99435", "name": "GRENADE"},
    {"code_insee": "99430", "name": "GROENLAND"},
    {
        "code_insee": "99505",
        "name": "GUAM / MARIANNES DU NORD (ILES) / SAMOA AMERICAINES / TERR. DES "
        "ETATS-UNIS D'AMERIQUE EN OCEANIE",
    },
    {"code_insee": "99409", "name": "GUATEMALA"},
    {"code_insee": "99132", "name": "ROYAUME-UNI / GUERNESEY / JERSEY / MAN (ILE)"},
    {"code_insee": "99330", "name": "GUINEE"},
    {"code_insee": "99314", "name": "GUINEE EQUATORIALE"},
    {"code_insee": "99392", "name": "GUINEE-BISSAU"},
    {"code_insee": "99428", "name": "GUYANA"},
    {"code_insee": "99410", "name": "HAITI"},
    {"code_insee": "99504", "name": "HAWAII (ILES)"},
    {"code_insee": "99411", "name": "HONDURAS"},
    {"code_insee": "99230", "name": "HONG-KONG"},
    {"code_insee": "99112", "name": "HONGRIE"},
    {"code_insee": "99320", "name": "ILES PORTUGAISES DE L'OCEAN INDIEN"},
    {"code_insee": "99231", "name": "INDONESIE"},
    {"code_insee": "99204", "name": "IRAN"},
    {"code_insee": "99203", "name": "IRAQ"},
    {"code_insee": "99136", "name": "IRLANDE, ou EIRE"},
    {"code_insee": "99102", "name": "ISLANDE"},
    {"code_insee": "99207", "name": "ISRAEL"},
    {"code_insee": "99127", "name": "ITALIE"},
    {"code_insee": "99426", "name": "JAMAIQUE"},
    {"code_insee": "99217", "name": "JAPON"},
    {"code_insee": "99222", "name": "JORDANIE"},
    {"code_insee": "99211", "name": "KAMTCHATKA"},
    {"code_insee": "99256", "name": "KAZAKHSTAN"},
    {"code_insee": "99332", "name": "KENYA"},
    {"code_insee": "99257", "name": "KIRGHIZISTAN"},
    {"code_insee": "99513", "name": "KIRIBATI"},
    {"code_insee": "99157", "name": "KOSOVO"},
    {"code_insee": "99240", "name": "KOWEIT"},
    {"code_insee": "99403", "name": "LABRADOR"},
    {"code_insee": "99241", "name": "LAOS"},
    {"code_insee": "99348", "name": "LESOTHO"},
    {"code_insee": "99107", "name": "LETTONIE"},
    {"code_insee": "99205", "name": "LIBAN"},
    {"code_insee": "99302", "name": "LIBERIA"},
    {"code_insee": "99316", "name": "LIBYE"},
    {"code_insee": "99113", "name": "LIECHTENSTEIN"},
    {"code_insee": "99108", "name": "LITUANIE"},
    {"code_insee": "99137", "name": "LUXEMBOURG"},
    {"code_insee": "99232", "name": "MACAO"},
    {"code_insee": "99156", "name": "MACEDOINE DU NORD"},
    {"code_insee": "99333", "name": "MADAGASCAR"},
    {"code_insee": "99227", "name": "MALAISIE"},
    {"code_insee": "99334", "name": "MALAWI"},
    {"code_insee": "99229", "name": "MALDIVES"},
    {"code_insee": "99335", "name": "MALI"},
    {"code_insee": "99144", "name": "MALTE"},
    {"code_insee": "99218", "name": "MANDCHOURIE"},
    {"code_insee": "99350", "name": "MAROC"},
    {"code_insee": "99515", "name": "MARSHALL (ILES)"},
    {"code_insee": "99390", "name": "MAURICE"},
    {"code_insee": "99336", "name": "MAURITANIE"},
    {"code_insee": "99405", "name": "MEXIQUE"},
    {"code_insee": "99516", "name": "MICRONESIE (ETATS FEDERES DE)"},
    {"code_insee": "99151", "name": "MOLDAVIE"},
    {"code_insee": "99138", "name": "MONACO"},
    {"code_insee": "99242", "name": "MONGOLIE"},
    {"code_insee": "99120", "name": "MONTENEGRO"},
    {"code_insee": "99393", "name": "MOZAMBIQUE"},
    {"code_insee": "99311", "name": "NAMIBIE"},
    {"code_insee": "99507", "name": "NAURU"},
    {"code_insee": "99215", "name": "NEPAL"},
    {"code_insee": "99412", "name": "NICARAGUA"},
    {"code_insee": "99337", "name": "NIGER"},
    {"code_insee": "99338", "name": "NIGERIA"},
    {
        "code_insee": "99308",
        "name": "OCEAN INDIEN (TERRITOIRE BRITANNIQUE DE L') / ZANZIBAR",
    },
    {"code_insee": "99250", "name": "OMAN"},
    {"code_insee": "99339", "name": "OUGANDA"},
    {"code_insee": "99258", "name": "OUZBEKISTAN"},
    {"code_insee": "99213", "name": "PAKISTAN"},
    {"code_insee": "99517", "name": "PALAOS (ILES)"},
    {"code_insee": "99261", "name": "PALESTINE (Etat de)"},
    {"code_insee": "99413", "name": "PANAMA"},
    {"code_insee": "99510", "name": "PAPOUASIE-NOUVELLE-GUINEE"},
    {"code_insee": "99421", "name": "PARAGUAY"},
    {"code_insee": "99422", "name": "PEROU"},
    {"code_insee": "99220", "name": "PHILIPPINES"},
    {"code_insee": "99503", "name": "PITCAIRN (ILE)"},
    {"code_insee": "99122", "name": "POLOGNE"},
    {
        "code_insee": "99432",
        "name": "PORTO RICO / TERR. DES ETATS-UNIS D'AMERIQUE EN AMERIQUE / VIERGES "
        "DES ETATS-UNIS (ILES)",
    },
    {"code_insee": "99139", "name": "PORTUGAL"},
    {"code_insee": "99221", "name": "POSSESSIONS BRITANNIQUES AU PROCHE-ORIENT"},
    {"code_insee": "99248", "name": "QATAR"},
    {"code_insee": "99141", "name": "REPUBLIQUE DEMOCRATIQUE ALLEMANDE"},
    {"code_insee": "99142", "name": "REPUBLIQUE FEDERALE D'ALLEMAGNE"},
    {"code_insee": "99114", "name": "ROUMANIE"},
    {"code_insee": "99123", "name": "RUSSIE"},
    {"code_insee": "99340", "name": "RWANDA"},
    {"code_insee": "99389", "name": "SAHARA OCCIDENTAL"},
    {"code_insee": "99442", "name": "SAINT-CHRISTOPHE-ET-NIEVES"},
    {"code_insee": "99128", "name": "SAINT-MARIN"},
    {"code_insee": "99445", "name": "SAINT-MARTIN (PARTIE NEERLANDAISE)"},
    {"code_insee": "99440", "name": "SAINT-VINCENT-ET-LES GRENADINES"},
    {"code_insee": "99306", "name": "SAINTE HELENE, ASCENSION ET TRISTAN DA CUNHA"},
    {"code_insee": "99439", "name": "SAINTE-LUCIE"},
    {"code_insee": "99512", "name": "SALOMON (ILES)"},
    {"code_insee": "99506", "name": "SAMOA OCCIDENTALES"},
    {"code_insee": "99394", "name": "SAO TOME-ET-PRINCIPE"},
    {"code_insee": "99341", "name": "SENEGAL"},
    {"code_insee": "99121", "name": "SERBIE"},
    {"code_insee": "99398", "name": "SEYCHELLES"},
    {"code_insee": "99209", "name": "SIBERIE"},
    {"code_insee": "99342", "name": "SIERRA LEONE"},
    {"code_insee": "99226", "name": "SINGAPOUR"},
    {"code_insee": "99117", "name": "SLOVAQUIE"},
    {"code_insee": "99145", "name": "SLOVENIE"},
    {"code_insee": "99318", "name": "SOMALIE"},
    {"code_insee": "99343", "name": "SOUDAN"},
    {"code_insee": "99307", "name": "SOUDAN ANGLO-EGYPTIEN, KENYA, OUGANDA"},
    {"code_insee": "99349", "name": "SOUDAN DU SUD"},
    {"code_insee": "99235", "name": "SRI LANKA"},
    {"code_insee": "99104", "name": "SUEDE"},
    {"code_insee": "99140", "name": "SUISSE"},
    {"code_insee": "99437", "name": "SURINAME"},
    {"code_insee": "99206", "name": "SYRIE"},
    {"code_insee": "99259", "name": "TADJIKISTAN"},
    {"code_insee": "99236", "name": "TAIWAN"},
    {"code_insee": "99325", "name": "TANGER"},
    {"code_insee": "99309", "name": "TANZANIE"},
    {"code_insee": "99344", "name": "TCHAD"},
    {"code_insee": "99115", "name": "TCHECOSLOVAQUIE"},
    {"code_insee": "99116", "name": "TCHEQUIE"},
    {"code_insee": "99402", "name": "TERRE-NEUVE"},
    {"code_insee": "99219", "name": "THAILANDE"},
    {"code_insee": "99262", "name": "TIMOR ORIENTAL"},
    {"code_insee": "99345", "name": "TOGO"},
    {"code_insee": "99509", "name": "TONGA"},
    {"code_insee": "99433", "name": "TRINITE-ET-TOBAGO"},
    {"code_insee": "99351", "name": "TUNISIE"},
    {"code_insee": "99210", "name": "TURKESTAN RUSSE"},
    {"code_insee": "99260", "name": "TURKMENISTAN"},
    {"code_insee": "99208", "name": "TURQUIE"},
    {"code_insee": "99124", "name": "TURQUIE D'EUROPE"},
    {"code_insee": "99511", "name": "TUVALU"},
    {"code_insee": "99155", "name": "UKRAINE"},
    {"code_insee": "99423", "name": "URUGUAY"},
    {"code_insee": "99514", "name": "VANUATU"},
    {"code_insee": "99129", "name": "VATICAN, ou SAINT-SIEGE"},
    {"code_insee": "99424", "name": "VENEZUELA"},
    {"code_insee": "99243", "name": "VIET NAM"},
    {"code_insee": "99244", "name": "VIET NAM DU NORD"},
    {"code_insee": "99245", "name": "VIET NAM DU SUD"},
    {"code_insee": "99251", "name": "YEMEN"},
    {"code_insee": "99202", "name": "YEMEN (REPUBLIQUE ARABE DU)"},
    {"code_insee": "99233", "name": "YEMEN DEMOCRATIQUE"},
    {"code_insee": "99346", "name": "ZAMBIE"},
    {"code_insee": "99310", "name": "ZIMBABWE"},
]


def find_country_insee_code(country_name):
    """
    Retrieve a country code from a country name.
    """
    country_name = country_name.upper()
    for country in COUNTRIES:
        if country["name"] == country_name:
            return country["code_insee"]
    return None
