DEPARTMENTS = [
    {"code_insee": "1", "name": "Ain"},
    {"code_insee": "2", "name": "Aisne"},
    {"code_insee": "3", "name": "Allier"},
    {"code_insee": "4", "name": "Alpes-de-Haute-Provence"},
    {"code_insee": "5", "name": "Hautes-Alpes"},
    {"code_insee": "6", "name": "Alpes-Maritimes"},
    {"code_insee": "7", "name": "Ardèche"},
    {"code_insee": "8", "name": "Ardennes"},
    {"code_insee": "9", "name": "Ariège"},
    {"code_insee": "10", "name": "Aube"},
    {"code_insee": "11", "name": "Aude"},
    {"code_insee": "12", "name": "Aveyron"},
    {"code_insee": "13", "name": "Bouches-du-Rhône"},
    {"code_insee": "14", "name": "Calvados"},
    {"code_insee": "15", "name": "Cantal"},
    {"code_insee": "16", "name": "Charente"},
    {"code_insee": "17", "name": "Charente-Maritime"},
    {"code_insee": "18", "name": "Cher"},
    {"code_insee": "19", "name": "Corrèze"},
    {"code_insee": "21", "name": "Côte-d'Or"},
    {"code_insee": "22", "name": "Côtes-d'Armor"},
    {"code_insee": "23", "name": "Creuse"},
    {"code_insee": "24", "name": "Dordogne"},
    {"code_insee": "25", "name": "Doubs"},
    {"code_insee": "26", "name": "Drôme"},
    {"code_insee": "27", "name": "Eure"},
    {"code_insee": "28", "name": "Eure-et-Loir"},
    {"code_insee": "29", "name": "Finistère"},
    {"code_insee": "2A", "name": "Corse-du-Sud"},
    {"code_insee": "2B", "name": "Haute-Corse"},
    {"code_insee": "30", "name": "Gard"},
    {"code_insee": "31", "name": "Haute-Garonne"},
    {"code_insee": "32", "name": "Gers"},
    {"code_insee": "33", "name": "Gironde"},
    {"code_insee": "34", "name": "Hérault"},
    {"code_insee": "35", "name": "Ille-et-Vilaine"},
    {"code_insee": "36", "name": "Indre"},
    {"code_insee": "37", "name": "Indre-et-Loire"},
    {"code_insee": "38", "name": "Isère"},
    {"code_insee": "39", "name": "Jura"},
    {"code_insee": "40", "name": "Landes"},
    {"code_insee": "41", "name": "Loir-et-Cher"},
    {"code_insee": "42", "name": "Loire"},
    {"code_insee": "43", "name": "Haute-Loire"},
    {"code_insee": "44", "name": "Loire-Atlantique"},
    {"code_insee": "45", "name": "Loiret"},
    {"code_insee": "46", "name": "Lot"},
    {"code_insee": "47", "name": "Lot-et-Garonne"},
    {"code_insee": "48", "name": "Lozère"},
    {"code_insee": "49", "name": "Maine-et-Loire"},
    {"code_insee": "50", "name": "Manche"},
    {"code_insee": "51", "name": "Marne"},
    {"code_insee": "52", "name": "Haute-Marne"},
    {"code_insee": "53", "name": "Mayenne"},
    {"code_insee": "54", "name": "Meurthe-et-Moselle"},
    {"code_insee": "55", "name": "Meuse"},
    {"code_insee": "56", "name": "Morbihan"},
    {"code_insee": "57", "name": "Moselle"},
    {"code_insee": "58", "name": "Nièvre"},
    {"code_insee": "59", "name": "Nord"},
    {"code_insee": "60", "name": "Oise"},
    {"code_insee": "61", "name": "Orne"},
    {"code_insee": "62", "name": "Pas-de-Calais"},
    {"code_insee": "63", "name": "Puy-de-Dôme"},
    {"code_insee": "64", "name": "Pyrénées-Atlantiques"},
    {"code_insee": "65", "name": "Hautes-Pyrénées"},
    {"code_insee": "66", "name": "Pyrénées-Orientales"},
    {"code_insee": "67", "name": "Bas-Rhin"},
    {"code_insee": "68", "name": "Haut-Rhin"},
    {"code_insee": "69", "name": "Rhône"},
    {"code_insee": "70", "name": "Haute-Saône"},
    {"code_insee": "71", "name": "Saône-et-Loire"},
    {"code_insee": "72", "name": "Sarthe"},
    {"code_insee": "73", "name": "Savoie"},
    {"code_insee": "74", "name": "Haute-Savoie"},
    {"code_insee": "75", "name": "Paris"},
    {"code_insee": "76", "name": "Seine-Maritime"},
    {"code_insee": "77", "name": "Seine-et-Marne"},
    {"code_insee": "78", "name": "Yvelines"},
    {"code_insee": "79", "name": "Deux-Sèvres"},
    {"code_insee": "80", "name": "Somme"},
    {"code_insee": "81", "name": "Tarn"},
    {"code_insee": "82", "name": "Tarn-et-Garonne"},
    {"code_insee": "83", "name": "Var"},
    {"code_insee": "84", "name": "Vaucluse"},
    {"code_insee": "85", "name": "Vendée"},
    {"code_insee": "86", "name": "Vienne"},
    {"code_insee": "87", "name": "Haute-Vienne"},
    {"code_insee": "88", "name": "Vosges"},
    {"code_insee": "89", "name": "Yonne"},
    {"code_insee": "90", "name": "Territoire de Belfort"},
    {"code_insee": "91", "name": "Essonne"},
    {"code_insee": "92", "name": "Hauts-de-Seine"},
    {"code_insee": "93", "name": "Seine-Saint-Denis"},
    {"code_insee": "94", "name": "Val-de-Marne"},
    {"code_insee": "95", "name": "Val-d'Oise"},
    {"code_insee": "971", "name": "Guadeloupe"},
    {"code_insee": "972", "name": "Martinique"},
    {"code_insee": "973", "name": "Guyane"},
    {"code_insee": "974", "name": "La Réunion"},
    {"code_insee": "976", "name": "Mayotte"},
    # Collectivités d'outre-mer
    {"code_insee": "975", "name": "Saint-Pierre-et-Miquelon"},
    {"code_insee": "977", "name": "Saint-Barthélemy"},
    {"code_insee": "978", "name": "Saint-Martin"},
    {"code_insee": "986", "name": "Wallis et Futuna"},
    {"code_insee": "987", "name": "Polynésie française"},
    {"code_insee": "988", "name": "Nouvelle-Calédonie"},
    {"code_insee": "989", "name": "Clipperton"},
    # Territoires d'outre-mer (inhabité…)
    {"code_insee": "984", "name": "Terres australes et antarctiques françaises"},
]


def find_departement_insee_code(departement_name):
    """Retrieve the insee code for a given departement name."""
    for departement in DEPARTMENTS:
        if departement["name"].lower() == departement_name.lower():
            return departement["code_insee"]
    return None
