/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/pdfjs-dist/build/pdf.worker.js":
/*!*****************************************************!*\
  !*** ./node_modules/pdfjs-dist/build/pdf.worker.js ***!
  \*****************************************************/
/***/ (function(module) {

/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */

(function webpackUniversalModuleDefinition(root, factory) {
	if(true)
		module.exports = factory();
	else {}
})(this, function() {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WorkerTask = exports.WorkerMessageHandler = void 0;

var _util = __w_pdfjs_require__(2);

var _primitives = __w_pdfjs_require__(5);

var _pdf_manager = __w_pdfjs_require__(7);

var _writer = __w_pdfjs_require__(71);

var _is_node = __w_pdfjs_require__(4);

var _message_handler = __w_pdfjs_require__(99);

var _worker_stream = __w_pdfjs_require__(100);

var _core_utils = __w_pdfjs_require__(9);

class WorkerTask {
  constructor(name) {
    this.name = name;
    this.terminated = false;
    this._capability = (0, _util.createPromiseCapability)();
  }

  get finished() {
    return this._capability.promise;
  }

  finish() {
    this._capability.resolve();
  }

  terminate() {
    this.terminated = true;
  }

  ensureNotTerminated() {
    if (this.terminated) {
      throw new Error("Worker task was terminated");
    }
  }

}

exports.WorkerTask = WorkerTask;

class WorkerMessageHandler {
  static setup(handler, port) {
    let testMessageProcessed = false;
    handler.on("test", function wphSetupTest(data) {
      if (testMessageProcessed) {
        return;
      }

      testMessageProcessed = true;
      handler.send("test", data instanceof Uint8Array && data[0] === 255);
    });
    handler.on("configure", function wphConfigure(data) {
      (0, _util.setVerbosityLevel)(data.verbosity);
    });
    handler.on("GetDocRequest", function wphSetupDoc(data) {
      return WorkerMessageHandler.createDocumentHandler(data, port);
    });
  }

  static createDocumentHandler(docParams, port) {
    let pdfManager;
    let terminated = false;
    let cancelXHRs = null;
    const WorkerTasks = [];
    const verbosity = (0, _util.getVerbosityLevel)();
    const apiVersion = docParams.apiVersion;
    const workerVersion = '2.12.313';

    if (apiVersion !== workerVersion) {
      throw new Error(`The API version "${apiVersion}" does not match ` + `the Worker version "${workerVersion}".`);
    }

    const enumerableProperties = [];

    for (const property in []) {
      enumerableProperties.push(property);
    }

    if (enumerableProperties.length) {
      throw new Error("The `Array.prototype` contains unexpected enumerable properties: " + enumerableProperties.join(", ") + "; thus breaking e.g. `for...in` iteration of `Array`s.");
    }

    if (typeof ReadableStream === "undefined") {
      throw new Error("The browser/environment lacks native support for critical " + "functionality used by the PDF.js library (e.g. `ReadableStream`); " + "please use a `legacy`-build instead.");
    }

    const docId = docParams.docId;
    const docBaseUrl = docParams.docBaseUrl;
    const workerHandlerName = docParams.docId + "_worker";
    let handler = new _message_handler.MessageHandler(workerHandlerName, docId, port);

    function ensureNotTerminated() {
      if (terminated) {
        throw new Error("Worker was terminated");
      }
    }

    function startWorkerTask(task) {
      WorkerTasks.push(task);
    }

    function finishWorkerTask(task) {
      task.finish();
      const i = WorkerTasks.indexOf(task);
      WorkerTasks.splice(i, 1);
    }

    async function loadDocument(recoveryMode) {
      await pdfManager.ensureDoc("checkHeader");
      await pdfManager.ensureDoc("parseStartXRef");
      await pdfManager.ensureDoc("parse", [recoveryMode]);
      await pdfManager.ensureDoc("checkFirstPage", [recoveryMode]);
      await pdfManager.ensureDoc("checkLastPage", [recoveryMode]);
      const isPureXfa = await pdfManager.ensureDoc("isPureXfa");

      if (isPureXfa) {
        const task = new WorkerTask("loadXfaFonts");
        startWorkerTask(task);
        await Promise.all([pdfManager.loadXfaFonts(handler, task).catch(reason => {}).then(() => finishWorkerTask(task)), pdfManager.loadXfaImages()]);
      }

      const [numPages, fingerprints] = await Promise.all([pdfManager.ensureDoc("numPages"), pdfManager.ensureDoc("fingerprints")]);
      const htmlForXfa = isPureXfa ? await pdfManager.ensureDoc("htmlForXfa") : null;
      return {
        numPages,
        fingerprints,
        htmlForXfa
      };
    }

    function getPdfManager(data, evaluatorOptions, enableXfa) {
      const pdfManagerCapability = (0, _util.createPromiseCapability)();
      let newPdfManager;
      const source = data.source;

      if (source.data) {
        try {
          newPdfManager = new _pdf_manager.LocalPdfManager(docId, source.data, source.password, handler, evaluatorOptions, enableXfa, docBaseUrl);
          pdfManagerCapability.resolve(newPdfManager);
        } catch (ex) {
          pdfManagerCapability.reject(ex);
        }

        return pdfManagerCapability.promise;
      }

      let pdfStream,
          cachedChunks = [];

      try {
        pdfStream = new _worker_stream.PDFWorkerStream(handler);
      } catch (ex) {
        pdfManagerCapability.reject(ex);
        return pdfManagerCapability.promise;
      }

      const fullRequest = pdfStream.getFullReader();
      fullRequest.headersReady.then(function () {
        if (!fullRequest.isRangeSupported) {
          return;
        }

        const disableAutoFetch = source.disableAutoFetch || fullRequest.isStreamingSupported;
        newPdfManager = new _pdf_manager.NetworkPdfManager(docId, pdfStream, {
          msgHandler: handler,
          password: source.password,
          length: fullRequest.contentLength,
          disableAutoFetch,
          rangeChunkSize: source.rangeChunkSize
        }, evaluatorOptions, enableXfa, docBaseUrl);

        for (let i = 0; i < cachedChunks.length; i++) {
          newPdfManager.sendProgressiveData(cachedChunks[i]);
        }

        cachedChunks = [];
        pdfManagerCapability.resolve(newPdfManager);
        cancelXHRs = null;
      }).catch(function (reason) {
        pdfManagerCapability.reject(reason);
        cancelXHRs = null;
      });
      let loaded = 0;

      const flushChunks = function () {
        const pdfFile = (0, _util.arraysToBytes)(cachedChunks);

        if (source.length && pdfFile.length !== source.length) {
          (0, _util.warn)("reported HTTP length is different from actual");
        }

        try {
          newPdfManager = new _pdf_manager.LocalPdfManager(docId, pdfFile, source.password, handler, evaluatorOptions, enableXfa, docBaseUrl);
          pdfManagerCapability.resolve(newPdfManager);
        } catch (ex) {
          pdfManagerCapability.reject(ex);
        }

        cachedChunks = [];
      };

      const readPromise = new Promise(function (resolve, reject) {
        const readChunk = function ({
          value,
          done
        }) {
          try {
            ensureNotTerminated();

            if (done) {
              if (!newPdfManager) {
                flushChunks();
              }

              cancelXHRs = null;
              return;
            }

            loaded += (0, _util.arrayByteLength)(value);

            if (!fullRequest.isStreamingSupported) {
              handler.send("DocProgress", {
                loaded,
                total: Math.max(loaded, fullRequest.contentLength || 0)
              });
            }

            if (newPdfManager) {
              newPdfManager.sendProgressiveData(value);
            } else {
              cachedChunks.push(value);
            }

            fullRequest.read().then(readChunk, reject);
          } catch (e) {
            reject(e);
          }
        };

        fullRequest.read().then(readChunk, reject);
      });
      readPromise.catch(function (e) {
        pdfManagerCapability.reject(e);
        cancelXHRs = null;
      });

      cancelXHRs = function (reason) {
        pdfStream.cancelAllRequests(reason);
      };

      return pdfManagerCapability.promise;
    }

    function setupDoc(data) {
      function onSuccess(doc) {
        ensureNotTerminated();
        handler.send("GetDoc", {
          pdfInfo: doc
        });
      }

      function onFailure(ex) {
        ensureNotTerminated();

        if (ex instanceof _util.PasswordException) {
          const task = new WorkerTask(`PasswordException: response ${ex.code}`);
          startWorkerTask(task);
          handler.sendWithPromise("PasswordRequest", ex).then(function ({
            password
          }) {
            finishWorkerTask(task);
            pdfManager.updatePassword(password);
            pdfManagerReady();
          }).catch(function () {
            finishWorkerTask(task);
            handler.send("DocException", ex);
          });
        } else if (ex instanceof _util.InvalidPDFException || ex instanceof _util.MissingPDFException || ex instanceof _util.UnexpectedResponseException || ex instanceof _util.UnknownErrorException) {
          handler.send("DocException", ex);
        } else {
          handler.send("DocException", new _util.UnknownErrorException(ex.message, ex.toString()));
        }
      }

      function pdfManagerReady() {
        ensureNotTerminated();
        loadDocument(false).then(onSuccess, function (reason) {
          ensureNotTerminated();

          if (!(reason instanceof _core_utils.XRefParseException)) {
            onFailure(reason);
            return;
          }

          pdfManager.requestLoadedStream();
          pdfManager.onLoadedStream().then(function () {
            ensureNotTerminated();
            loadDocument(true).then(onSuccess, onFailure);
          });
        });
      }

      ensureNotTerminated();
      const evaluatorOptions = {
        maxImageSize: data.maxImageSize,
        disableFontFace: data.disableFontFace,
        ignoreErrors: data.ignoreErrors,
        isEvalSupported: data.isEvalSupported,
        fontExtraProperties: data.fontExtraProperties,
        useSystemFonts: data.useSystemFonts,
        cMapUrl: data.cMapUrl,
        standardFontDataUrl: data.standardFontDataUrl
      };
      getPdfManager(data, evaluatorOptions, data.enableXfa).then(function (newPdfManager) {
        if (terminated) {
          newPdfManager.terminate(new _util.AbortException("Worker was terminated."));
          throw new Error("Worker was terminated");
        }

        pdfManager = newPdfManager;
        pdfManager.onLoadedStream().then(function (stream) {
          handler.send("DataLoaded", {
            length: stream.bytes.byteLength
          });
        });
      }).then(pdfManagerReady, onFailure);
    }

    handler.on("GetPage", function wphSetupGetPage(data) {
      return pdfManager.getPage(data.pageIndex).then(function (page) {
        return Promise.all([pdfManager.ensure(page, "rotate"), pdfManager.ensure(page, "ref"), pdfManager.ensure(page, "userUnit"), pdfManager.ensure(page, "view")]).then(function ([rotate, ref, userUnit, view]) {
          return {
            rotate,
            ref,
            userUnit,
            view
          };
        });
      });
    });
    handler.on("GetPageIndex", function wphSetupGetPageIndex({
      ref
    }) {
      const pageRef = _primitives.Ref.get(ref.num, ref.gen);

      return pdfManager.ensureCatalog("getPageIndex", [pageRef]);
    });
    handler.on("GetDestinations", function wphSetupGetDestinations(data) {
      return pdfManager.ensureCatalog("destinations");
    });
    handler.on("GetDestination", function wphSetupGetDestination(data) {
      return pdfManager.ensureCatalog("getDestination", [data.id]);
    });
    handler.on("GetPageLabels", function wphSetupGetPageLabels(data) {
      return pdfManager.ensureCatalog("pageLabels");
    });
    handler.on("GetPageLayout", function wphSetupGetPageLayout(data) {
      return pdfManager.ensureCatalog("pageLayout");
    });
    handler.on("GetPageMode", function wphSetupGetPageMode(data) {
      return pdfManager.ensureCatalog("pageMode");
    });
    handler.on("GetViewerPreferences", function (data) {
      return pdfManager.ensureCatalog("viewerPreferences");
    });
    handler.on("GetOpenAction", function (data) {
      return pdfManager.ensureCatalog("openAction");
    });
    handler.on("GetAttachments", function wphSetupGetAttachments(data) {
      return pdfManager.ensureCatalog("attachments");
    });
    handler.on("GetJavaScript", function wphSetupGetJavaScript(data) {
      return pdfManager.ensureCatalog("javaScript");
    });
    handler.on("GetDocJSActions", function wphSetupGetDocJSActions(data) {
      return pdfManager.ensureCatalog("jsActions");
    });
    handler.on("GetPageJSActions", function ({
      pageIndex
    }) {
      return pdfManager.getPage(pageIndex).then(function (page) {
        return pdfManager.ensure(page, "jsActions");
      });
    });
    handler.on("GetOutline", function wphSetupGetOutline(data) {
      return pdfManager.ensureCatalog("documentOutline");
    });
    handler.on("GetOptionalContentConfig", function (data) {
      return pdfManager.ensureCatalog("optionalContentConfig");
    });
    handler.on("GetPermissions", function (data) {
      return pdfManager.ensureCatalog("permissions");
    });
    handler.on("GetMetadata", function wphSetupGetMetadata(data) {
      return Promise.all([pdfManager.ensureDoc("documentInfo"), pdfManager.ensureCatalog("metadata")]);
    });
    handler.on("GetMarkInfo", function wphSetupGetMarkInfo(data) {
      return pdfManager.ensureCatalog("markInfo");
    });
    handler.on("GetData", function wphSetupGetData(data) {
      pdfManager.requestLoadedStream();
      return pdfManager.onLoadedStream().then(function (stream) {
        return stream.bytes;
      });
    });
    handler.on("GetAnnotations", function ({
      pageIndex,
      intent
    }) {
      return pdfManager.getPage(pageIndex).then(function (page) {
        return page.getAnnotationsData(intent);
      });
    });
    handler.on("GetFieldObjects", function (data) {
      return pdfManager.ensureDoc("fieldObjects");
    });
    handler.on("HasJSActions", function (data) {
      return pdfManager.ensureDoc("hasJSActions");
    });
    handler.on("GetCalculationOrderIds", function (data) {
      return pdfManager.ensureDoc("calculationOrderIds");
    });
    handler.on("SaveDocument", function ({
      isPureXfa,
      numPages,
      annotationStorage,
      filename
    }) {
      pdfManager.requestLoadedStream();
      const promises = [pdfManager.onLoadedStream(), pdfManager.ensureCatalog("acroForm"), pdfManager.ensureCatalog("acroFormRef"), pdfManager.ensureDoc("xref"), pdfManager.ensureDoc("startXRef")];

      if (isPureXfa) {
        promises.push(pdfManager.serializeXfaData(annotationStorage));
      } else {
        for (let pageIndex = 0; pageIndex < numPages; pageIndex++) {
          promises.push(pdfManager.getPage(pageIndex).then(function (page) {
            const task = new WorkerTask(`Save: page ${pageIndex}`);
            return page.save(handler, task, annotationStorage).finally(function () {
              finishWorkerTask(task);
            });
          }));
        }
      }

      return Promise.all(promises).then(function ([stream, acroForm, acroFormRef, xref, startXRef, ...refs]) {
        let newRefs = [];
        let xfaData = null;

        if (isPureXfa) {
          xfaData = refs[0];

          if (!xfaData) {
            return stream.bytes;
          }
        } else {
          for (const ref of refs) {
            newRefs = ref.filter(x => x !== null).reduce((a, b) => a.concat(b), newRefs);
          }

          if (newRefs.length === 0) {
            return stream.bytes;
          }
        }

        const xfa = acroForm instanceof _primitives.Dict && acroForm.get("XFA") || null;
        let xfaDatasetsRef = null;
        let hasXfaDatasetsEntry = false;

        if (Array.isArray(xfa)) {
          for (let i = 0, ii = xfa.length; i < ii; i += 2) {
            if (xfa[i] === "datasets") {
              xfaDatasetsRef = xfa[i + 1];
              acroFormRef = null;
              hasXfaDatasetsEntry = true;
            }
          }

          if (xfaDatasetsRef === null) {
            xfaDatasetsRef = xref.getNewRef();
          }
        } else if (xfa) {
          acroFormRef = null;
          (0, _util.warn)("Unsupported XFA type.");
        }

        let newXrefInfo = Object.create(null);

        if (xref.trailer) {
          const infoObj = Object.create(null);
          const xrefInfo = xref.trailer.get("Info") || null;

          if (xrefInfo instanceof _primitives.Dict) {
            xrefInfo.forEach((key, value) => {
              if ((0, _util.isString)(key) && (0, _util.isString)(value)) {
                infoObj[key] = (0, _util.stringToPDFString)(value);
              }
            });
          }

          newXrefInfo = {
            rootRef: xref.trailer.getRaw("Root") || null,
            encryptRef: xref.trailer.getRaw("Encrypt") || null,
            newRef: xref.getNewRef(),
            infoRef: xref.trailer.getRaw("Info") || null,
            info: infoObj,
            fileIds: xref.trailer.get("ID") || null,
            startXRef,
            filename
          };
        }

        xref.resetNewRef();
        return (0, _writer.incrementalUpdate)({
          originalData: stream.bytes,
          xrefInfo: newXrefInfo,
          newRefs,
          xref,
          hasXfa: !!xfa,
          xfaDatasetsRef,
          hasXfaDatasetsEntry,
          acroFormRef,
          acroForm,
          xfaData
        });
      });
    });
    handler.on("GetOperatorList", function wphSetupRenderPage(data, sink) {
      const pageIndex = data.pageIndex;
      pdfManager.getPage(pageIndex).then(function (page) {
        const task = new WorkerTask(`GetOperatorList: page ${pageIndex}`);
        startWorkerTask(task);
        const start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
        page.getOperatorList({
          handler,
          sink,
          task,
          intent: data.intent,
          cacheKey: data.cacheKey,
          annotationStorage: data.annotationStorage
        }).then(function (operatorListInfo) {
          finishWorkerTask(task);

          if (start) {
            (0, _util.info)(`page=${pageIndex + 1} - getOperatorList: time=` + `${Date.now() - start}ms, len=${operatorListInfo.length}`);
          }

          sink.close();
        }, function (reason) {
          finishWorkerTask(task);

          if (task.terminated) {
            return;
          }

          handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorOperatorList
          });
          sink.error(reason);
        });
      });
    });
    handler.on("GetTextContent", function wphExtractText(data, sink) {
      const pageIndex = data.pageIndex;
      pdfManager.getPage(pageIndex).then(function (page) {
        const task = new WorkerTask("GetTextContent: page " + pageIndex);
        startWorkerTask(task);
        const start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
        page.extractTextContent({
          handler,
          task,
          sink,
          normalizeWhitespace: data.normalizeWhitespace,
          includeMarkedContent: data.includeMarkedContent,
          combineTextItems: data.combineTextItems
        }).then(function () {
          finishWorkerTask(task);

          if (start) {
            (0, _util.info)(`page=${pageIndex + 1} - getTextContent: time=` + `${Date.now() - start}ms`);
          }

          sink.close();
        }, function (reason) {
          finishWorkerTask(task);

          if (task.terminated) {
            return;
          }

          sink.error(reason);
        });
      });
    });
    handler.on("GetStructTree", function wphGetStructTree(data) {
      return pdfManager.getPage(data.pageIndex).then(function (page) {
        return pdfManager.ensure(page, "getStructTree");
      });
    });
    handler.on("FontFallback", function (data) {
      return pdfManager.fontFallback(data.id, handler);
    });
    handler.on("Cleanup", function wphCleanup(data) {
      return pdfManager.cleanup(true);
    });
    handler.on("Terminate", function wphTerminate(data) {
      terminated = true;
      const waitOn = [];

      if (pdfManager) {
        pdfManager.terminate(new _util.AbortException("Worker was terminated."));
        const cleanupPromise = pdfManager.cleanup();
        waitOn.push(cleanupPromise);
        pdfManager = null;
      } else {
        (0, _primitives.clearPrimitiveCaches)();
      }

      if (cancelXHRs) {
        cancelXHRs(new _util.AbortException("Worker was terminated."));
      }

      for (const task of WorkerTasks) {
        waitOn.push(task.finished);
        task.terminate();
      }

      return Promise.all(waitOn).then(function () {
        handler.destroy();
        handler = null;
      });
    });
    handler.on("Ready", function wphReady(data) {
      setupDoc(docParams);
      docParams = null;
    });
    return workerHandlerName;
  }

  static initializeFromPort(port) {
    const handler = new _message_handler.MessageHandler("worker", "main", port);
    WorkerMessageHandler.setup(handler, port);
    handler.send("ready", null);
  }

}

exports.WorkerMessageHandler = WorkerMessageHandler;

function isMessagePort(maybePort) {
  return typeof maybePort.postMessage === "function" && "onmessage" in maybePort;
}

if (typeof window === "undefined" && !_is_node.isNodeJS && typeof self !== "undefined" && isMessagePort(self)) {
  WorkerMessageHandler.initializeFromPort(self);
}

/***/ }),
/* 2 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.VerbosityLevel = exports.Util = exports.UnknownErrorException = exports.UnexpectedResponseException = exports.UNSUPPORTED_FEATURES = exports.TextRenderingMode = exports.StreamType = exports.RenderingIntentFlag = exports.PermissionFlag = exports.PasswordResponses = exports.PasswordException = exports.PageActionEventType = exports.OPS = exports.MissingPDFException = exports.IsLittleEndianCached = exports.IsEvalSupportedCached = exports.InvalidPDFException = exports.ImageKind = exports.IDENTITY_MATRIX = exports.FormatError = exports.FontType = exports.FONT_IDENTITY_MATRIX = exports.DocumentActionEventType = exports.CMapCompressionType = exports.BaseException = exports.AnnotationType = exports.AnnotationStateModelType = exports.AnnotationReviewState = exports.AnnotationReplyType = exports.AnnotationMode = exports.AnnotationMarkedState = exports.AnnotationFlag = exports.AnnotationFieldFlag = exports.AnnotationBorderStyleType = exports.AnnotationActionEventType = exports.AbortException = void 0;
exports.arrayByteLength = arrayByteLength;
exports.arraysToBytes = arraysToBytes;
exports.assert = assert;
exports.bytesToString = bytesToString;
exports.createObjectURL = createObjectURL;
exports.createPromiseCapability = createPromiseCapability;
exports.createValidAbsoluteUrl = createValidAbsoluteUrl;
exports.escapeString = escapeString;
exports.getModificationDate = getModificationDate;
exports.getVerbosityLevel = getVerbosityLevel;
exports.info = info;
exports.isArrayBuffer = isArrayBuffer;
exports.isArrayEqual = isArrayEqual;
exports.isAscii = isAscii;
exports.isBool = isBool;
exports.isNum = isNum;
exports.isSameOrigin = isSameOrigin;
exports.isString = isString;
exports.objectFromMap = objectFromMap;
exports.objectSize = objectSize;
exports.removeNullCharacters = removeNullCharacters;
exports.setVerbosityLevel = setVerbosityLevel;
exports.shadow = shadow;
exports.string32 = string32;
exports.stringToBytes = stringToBytes;
exports.stringToPDFString = stringToPDFString;
exports.stringToUTF16BEString = stringToUTF16BEString;
exports.stringToUTF8String = stringToUTF8String;
exports.unreachable = unreachable;
exports.utf8StringToString = utf8StringToString;
exports.warn = warn;

__w_pdfjs_require__(3);

const IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];
exports.IDENTITY_MATRIX = IDENTITY_MATRIX;
const FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
exports.FONT_IDENTITY_MATRIX = FONT_IDENTITY_MATRIX;
const RenderingIntentFlag = {
  ANY: 0x01,
  DISPLAY: 0x02,
  PRINT: 0x04,
  ANNOTATIONS_FORMS: 0x10,
  ANNOTATIONS_STORAGE: 0x20,
  ANNOTATIONS_DISABLE: 0x40,
  OPLIST: 0x100
};
exports.RenderingIntentFlag = RenderingIntentFlag;
const AnnotationMode = {
  DISABLE: 0,
  ENABLE: 1,
  ENABLE_FORMS: 2,
  ENABLE_STORAGE: 3
};
exports.AnnotationMode = AnnotationMode;
const PermissionFlag = {
  PRINT: 0x04,
  MODIFY_CONTENTS: 0x08,
  COPY: 0x10,
  MODIFY_ANNOTATIONS: 0x20,
  FILL_INTERACTIVE_FORMS: 0x100,
  COPY_FOR_ACCESSIBILITY: 0x200,
  ASSEMBLE: 0x400,
  PRINT_HIGH_QUALITY: 0x800
};
exports.PermissionFlag = PermissionFlag;
const TextRenderingMode = {
  FILL: 0,
  STROKE: 1,
  FILL_STROKE: 2,
  INVISIBLE: 3,
  FILL_ADD_TO_PATH: 4,
  STROKE_ADD_TO_PATH: 5,
  FILL_STROKE_ADD_TO_PATH: 6,
  ADD_TO_PATH: 7,
  FILL_STROKE_MASK: 3,
  ADD_TO_PATH_FLAG: 4
};
exports.TextRenderingMode = TextRenderingMode;
const ImageKind = {
  GRAYSCALE_1BPP: 1,
  RGB_24BPP: 2,
  RGBA_32BPP: 3
};
exports.ImageKind = ImageKind;
const AnnotationType = {
  TEXT: 1,
  LINK: 2,
  FREETEXT: 3,
  LINE: 4,
  SQUARE: 5,
  CIRCLE: 6,
  POLYGON: 7,
  POLYLINE: 8,
  HIGHLIGHT: 9,
  UNDERLINE: 10,
  SQUIGGLY: 11,
  STRIKEOUT: 12,
  STAMP: 13,
  CARET: 14,
  INK: 15,
  POPUP: 16,
  FILEATTACHMENT: 17,
  SOUND: 18,
  MOVIE: 19,
  WIDGET: 20,
  SCREEN: 21,
  PRINTERMARK: 22,
  TRAPNET: 23,
  WATERMARK: 24,
  THREED: 25,
  REDACT: 26
};
exports.AnnotationType = AnnotationType;
const AnnotationStateModelType = {
  MARKED: "Marked",
  REVIEW: "Review"
};
exports.AnnotationStateModelType = AnnotationStateModelType;
const AnnotationMarkedState = {
  MARKED: "Marked",
  UNMARKED: "Unmarked"
};
exports.AnnotationMarkedState = AnnotationMarkedState;
const AnnotationReviewState = {
  ACCEPTED: "Accepted",
  REJECTED: "Rejected",
  CANCELLED: "Cancelled",
  COMPLETED: "Completed",
  NONE: "None"
};
exports.AnnotationReviewState = AnnotationReviewState;
const AnnotationReplyType = {
  GROUP: "Group",
  REPLY: "R"
};
exports.AnnotationReplyType = AnnotationReplyType;
const AnnotationFlag = {
  INVISIBLE: 0x01,
  HIDDEN: 0x02,
  PRINT: 0x04,
  NOZOOM: 0x08,
  NOROTATE: 0x10,
  NOVIEW: 0x20,
  READONLY: 0x40,
  LOCKED: 0x80,
  TOGGLENOVIEW: 0x100,
  LOCKEDCONTENTS: 0x200
};
exports.AnnotationFlag = AnnotationFlag;
const AnnotationFieldFlag = {
  READONLY: 0x0000001,
  REQUIRED: 0x0000002,
  NOEXPORT: 0x0000004,
  MULTILINE: 0x0001000,
  PASSWORD: 0x0002000,
  NOTOGGLETOOFF: 0x0004000,
  RADIO: 0x0008000,
  PUSHBUTTON: 0x0010000,
  COMBO: 0x0020000,
  EDIT: 0x0040000,
  SORT: 0x0080000,
  FILESELECT: 0x0100000,
  MULTISELECT: 0x0200000,
  DONOTSPELLCHECK: 0x0400000,
  DONOTSCROLL: 0x0800000,
  COMB: 0x1000000,
  RICHTEXT: 0x2000000,
  RADIOSINUNISON: 0x2000000,
  COMMITONSELCHANGE: 0x4000000
};
exports.AnnotationFieldFlag = AnnotationFieldFlag;
const AnnotationBorderStyleType = {
  SOLID: 1,
  DASHED: 2,
  BEVELED: 3,
  INSET: 4,
  UNDERLINE: 5
};
exports.AnnotationBorderStyleType = AnnotationBorderStyleType;
const AnnotationActionEventType = {
  E: "Mouse Enter",
  X: "Mouse Exit",
  D: "Mouse Down",
  U: "Mouse Up",
  Fo: "Focus",
  Bl: "Blur",
  PO: "PageOpen",
  PC: "PageClose",
  PV: "PageVisible",
  PI: "PageInvisible",
  K: "Keystroke",
  F: "Format",
  V: "Validate",
  C: "Calculate"
};
exports.AnnotationActionEventType = AnnotationActionEventType;
const DocumentActionEventType = {
  WC: "WillClose",
  WS: "WillSave",
  DS: "DidSave",
  WP: "WillPrint",
  DP: "DidPrint"
};
exports.DocumentActionEventType = DocumentActionEventType;
const PageActionEventType = {
  O: "PageOpen",
  C: "PageClose"
};
exports.PageActionEventType = PageActionEventType;
const StreamType = {
  UNKNOWN: "UNKNOWN",
  FLATE: "FLATE",
  LZW: "LZW",
  DCT: "DCT",
  JPX: "JPX",
  JBIG: "JBIG",
  A85: "A85",
  AHX: "AHX",
  CCF: "CCF",
  RLX: "RLX"
};
exports.StreamType = StreamType;
const FontType = {
  UNKNOWN: "UNKNOWN",
  TYPE1: "TYPE1",
  TYPE1STANDARD: "TYPE1STANDARD",
  TYPE1C: "TYPE1C",
  CIDFONTTYPE0: "CIDFONTTYPE0",
  CIDFONTTYPE0C: "CIDFONTTYPE0C",
  TRUETYPE: "TRUETYPE",
  CIDFONTTYPE2: "CIDFONTTYPE2",
  TYPE3: "TYPE3",
  OPENTYPE: "OPENTYPE",
  TYPE0: "TYPE0",
  MMTYPE1: "MMTYPE1"
};
exports.FontType = FontType;
const VerbosityLevel = {
  ERRORS: 0,
  WARNINGS: 1,
  INFOS: 5
};
exports.VerbosityLevel = VerbosityLevel;
const CMapCompressionType = {
  NONE: 0,
  BINARY: 1,
  STREAM: 2
};
exports.CMapCompressionType = CMapCompressionType;
const OPS = {
  dependency: 1,
  setLineWidth: 2,
  setLineCap: 3,
  setLineJoin: 4,
  setMiterLimit: 5,
  setDash: 6,
  setRenderingIntent: 7,
  setFlatness: 8,
  setGState: 9,
  save: 10,
  restore: 11,
  transform: 12,
  moveTo: 13,
  lineTo: 14,
  curveTo: 15,
  curveTo2: 16,
  curveTo3: 17,
  closePath: 18,
  rectangle: 19,
  stroke: 20,
  closeStroke: 21,
  fill: 22,
  eoFill: 23,
  fillStroke: 24,
  eoFillStroke: 25,
  closeFillStroke: 26,
  closeEOFillStroke: 27,
  endPath: 28,
  clip: 29,
  eoClip: 30,
  beginText: 31,
  endText: 32,
  setCharSpacing: 33,
  setWordSpacing: 34,
  setHScale: 35,
  setLeading: 36,
  setFont: 37,
  setTextRenderingMode: 38,
  setTextRise: 39,
  moveText: 40,
  setLeadingMoveText: 41,
  setTextMatrix: 42,
  nextLine: 43,
  showText: 44,
  showSpacedText: 45,
  nextLineShowText: 46,
  nextLineSetSpacingShowText: 47,
  setCharWidth: 48,
  setCharWidthAndBounds: 49,
  setStrokeColorSpace: 50,
  setFillColorSpace: 51,
  setStrokeColor: 52,
  setStrokeColorN: 53,
  setFillColor: 54,
  setFillColorN: 55,
  setStrokeGray: 56,
  setFillGray: 57,
  setStrokeRGBColor: 58,
  setFillRGBColor: 59,
  setStrokeCMYKColor: 60,
  setFillCMYKColor: 61,
  shadingFill: 62,
  beginInlineImage: 63,
  beginImageData: 64,
  endInlineImage: 65,
  paintXObject: 66,
  markPoint: 67,
  markPointProps: 68,
  beginMarkedContent: 69,
  beginMarkedContentProps: 70,
  endMarkedContent: 71,
  beginCompat: 72,
  endCompat: 73,
  paintFormXObjectBegin: 74,
  paintFormXObjectEnd: 75,
  beginGroup: 76,
  endGroup: 77,
  beginAnnotations: 78,
  endAnnotations: 79,
  beginAnnotation: 80,
  endAnnotation: 81,
  paintJpegXObject: 82,
  paintImageMaskXObject: 83,
  paintImageMaskXObjectGroup: 84,
  paintImageXObject: 85,
  paintInlineImageXObject: 86,
  paintInlineImageXObjectGroup: 87,
  paintImageXObjectRepeat: 88,
  paintImageMaskXObjectRepeat: 89,
  paintSolidColorImageMask: 90,
  constructPath: 91
};
exports.OPS = OPS;
const UNSUPPORTED_FEATURES = {
  unknown: "unknown",
  forms: "forms",
  javaScript: "javaScript",
  signatures: "signatures",
  smask: "smask",
  shadingPattern: "shadingPattern",
  font: "font",
  errorTilingPattern: "errorTilingPattern",
  errorExtGState: "errorExtGState",
  errorXObject: "errorXObject",
  errorFontLoadType3: "errorFontLoadType3",
  errorFontState: "errorFontState",
  errorFontMissing: "errorFontMissing",
  errorFontTranslate: "errorFontTranslate",
  errorColorSpace: "errorColorSpace",
  errorOperatorList: "errorOperatorList",
  errorFontToUnicode: "errorFontToUnicode",
  errorFontLoadNative: "errorFontLoadNative",
  errorFontBuildPath: "errorFontBuildPath",
  errorFontGetPath: "errorFontGetPath",
  errorMarkedContent: "errorMarkedContent",
  errorContentSubStream: "errorContentSubStream"
};
exports.UNSUPPORTED_FEATURES = UNSUPPORTED_FEATURES;
const PasswordResponses = {
  NEED_PASSWORD: 1,
  INCORRECT_PASSWORD: 2
};
exports.PasswordResponses = PasswordResponses;
let verbosity = VerbosityLevel.WARNINGS;

function setVerbosityLevel(level) {
  if (Number.isInteger(level)) {
    verbosity = level;
  }
}

function getVerbosityLevel() {
  return verbosity;
}

function info(msg) {
  if (verbosity >= VerbosityLevel.INFOS) {
    console.log(`Info: ${msg}`);
  }
}

function warn(msg) {
  if (verbosity >= VerbosityLevel.WARNINGS) {
    console.log(`Warning: ${msg}`);
  }
}

function unreachable(msg) {
  throw new Error(msg);
}

function assert(cond, msg) {
  if (!cond) {
    unreachable(msg);
  }
}

function isSameOrigin(baseUrl, otherUrl) {
  let base;

  try {
    base = new URL(baseUrl);

    if (!base.origin || base.origin === "null") {
      return false;
    }
  } catch (e) {
    return false;
  }

  const other = new URL(otherUrl, base);
  return base.origin === other.origin;
}

function _isValidProtocol(url) {
  if (!url) {
    return false;
  }

  switch (url.protocol) {
    case "http:":
    case "https:":
    case "ftp:":
    case "mailto:":
    case "tel:":
      return true;

    default:
      return false;
  }
}

function createValidAbsoluteUrl(url, baseUrl = null, options = null) {
  if (!url) {
    return null;
  }

  try {
    if (options && typeof url === "string") {
      if (options.addDefaultProtocol && url.startsWith("www.")) {
        const dots = url.match(/\./g);

        if (dots && dots.length >= 2) {
          url = `http://${url}`;
        }
      }

      if (options.tryConvertEncoding) {
        try {
          url = stringToUTF8String(url);
        } catch (ex) {}
      }
    }

    const absoluteUrl = baseUrl ? new URL(url, baseUrl) : new URL(url);

    if (_isValidProtocol(absoluteUrl)) {
      return absoluteUrl;
    }
  } catch (ex) {}

  return null;
}

function shadow(obj, prop, value) {
  Object.defineProperty(obj, prop, {
    value,
    enumerable: true,
    configurable: true,
    writable: false
  });
  return value;
}

const BaseException = function BaseExceptionClosure() {
  function BaseException(message, name) {
    if (this.constructor === BaseException) {
      unreachable("Cannot initialize BaseException.");
    }

    this.message = message;
    this.name = name;
  }

  BaseException.prototype = new Error();
  BaseException.constructor = BaseException;
  return BaseException;
}();

exports.BaseException = BaseException;

class PasswordException extends BaseException {
  constructor(msg, code) {
    super(msg, "PasswordException");
    this.code = code;
  }

}

exports.PasswordException = PasswordException;

class UnknownErrorException extends BaseException {
  constructor(msg, details) {
    super(msg, "UnknownErrorException");
    this.details = details;
  }

}

exports.UnknownErrorException = UnknownErrorException;

class InvalidPDFException extends BaseException {
  constructor(msg) {
    super(msg, "InvalidPDFException");
  }

}

exports.InvalidPDFException = InvalidPDFException;

class MissingPDFException extends BaseException {
  constructor(msg) {
    super(msg, "MissingPDFException");
  }

}

exports.MissingPDFException = MissingPDFException;

class UnexpectedResponseException extends BaseException {
  constructor(msg, status) {
    super(msg, "UnexpectedResponseException");
    this.status = status;
  }

}

exports.UnexpectedResponseException = UnexpectedResponseException;

class FormatError extends BaseException {
  constructor(msg) {
    super(msg, "FormatError");
  }

}

exports.FormatError = FormatError;

class AbortException extends BaseException {
  constructor(msg) {
    super(msg, "AbortException");
  }

}

exports.AbortException = AbortException;
const NullCharactersRegExp = /\x00+/g;
const InvisibleCharactersRegExp = /[\x01-\x1F]/g;

function removeNullCharacters(str, replaceInvisible = false) {
  if (typeof str !== "string") {
    warn("The argument for removeNullCharacters must be a string.");
    return str;
  }

  if (replaceInvisible) {
    str = str.replace(InvisibleCharactersRegExp, " ");
  }

  return str.replace(NullCharactersRegExp, "");
}

function bytesToString(bytes) {
  assert(bytes !== null && typeof bytes === "object" && bytes.length !== undefined, "Invalid argument for bytesToString");
  const length = bytes.length;
  const MAX_ARGUMENT_COUNT = 8192;

  if (length < MAX_ARGUMENT_COUNT) {
    return String.fromCharCode.apply(null, bytes);
  }

  const strBuf = [];

  for (let i = 0; i < length; i += MAX_ARGUMENT_COUNT) {
    const chunkEnd = Math.min(i + MAX_ARGUMENT_COUNT, length);
    const chunk = bytes.subarray(i, chunkEnd);
    strBuf.push(String.fromCharCode.apply(null, chunk));
  }

  return strBuf.join("");
}

function stringToBytes(str) {
  assert(typeof str === "string", "Invalid argument for stringToBytes");
  const length = str.length;
  const bytes = new Uint8Array(length);

  for (let i = 0; i < length; ++i) {
    bytes[i] = str.charCodeAt(i) & 0xff;
  }

  return bytes;
}

function arrayByteLength(arr) {
  if (arr.length !== undefined) {
    return arr.length;
  }

  assert(arr.byteLength !== undefined, "arrayByteLength - invalid argument.");
  return arr.byteLength;
}

function arraysToBytes(arr) {
  const length = arr.length;

  if (length === 1 && arr[0] instanceof Uint8Array) {
    return arr[0];
  }

  let resultLength = 0;

  for (let i = 0; i < length; i++) {
    resultLength += arrayByteLength(arr[i]);
  }

  let pos = 0;
  const data = new Uint8Array(resultLength);

  for (let i = 0; i < length; i++) {
    let item = arr[i];

    if (!(item instanceof Uint8Array)) {
      if (typeof item === "string") {
        item = stringToBytes(item);
      } else {
        item = new Uint8Array(item);
      }
    }

    const itemLength = item.byteLength;
    data.set(item, pos);
    pos += itemLength;
  }

  return data;
}

function string32(value) {
  return String.fromCharCode(value >> 24 & 0xff, value >> 16 & 0xff, value >> 8 & 0xff, value & 0xff);
}

function objectSize(obj) {
  return Object.keys(obj).length;
}

function objectFromMap(map) {
  const obj = Object.create(null);

  for (const [key, value] of map) {
    obj[key] = value;
  }

  return obj;
}

function isLittleEndian() {
  const buffer8 = new Uint8Array(4);
  buffer8[0] = 1;
  const view32 = new Uint32Array(buffer8.buffer, 0, 1);
  return view32[0] === 1;
}

const IsLittleEndianCached = {
  get value() {
    return shadow(this, "value", isLittleEndian());
  }

};
exports.IsLittleEndianCached = IsLittleEndianCached;

function isEvalSupported() {
  try {
    new Function("");
    return true;
  } catch (e) {
    return false;
  }
}

const IsEvalSupportedCached = {
  get value() {
    return shadow(this, "value", isEvalSupported());
  }

};
exports.IsEvalSupportedCached = IsEvalSupportedCached;
const hexNumbers = [...Array(256).keys()].map(n => n.toString(16).padStart(2, "0"));

class Util {
  static makeHexColor(r, g, b) {
    return `#${hexNumbers[r]}${hexNumbers[g]}${hexNumbers[b]}`;
  }

  static transform(m1, m2) {
    return [m1[0] * m2[0] + m1[2] * m2[1], m1[1] * m2[0] + m1[3] * m2[1], m1[0] * m2[2] + m1[2] * m2[3], m1[1] * m2[2] + m1[3] * m2[3], m1[0] * m2[4] + m1[2] * m2[5] + m1[4], m1[1] * m2[4] + m1[3] * m2[5] + m1[5]];
  }

  static applyTransform(p, m) {
    const xt = p[0] * m[0] + p[1] * m[2] + m[4];
    const yt = p[0] * m[1] + p[1] * m[3] + m[5];
    return [xt, yt];
  }

  static applyInverseTransform(p, m) {
    const d = m[0] * m[3] - m[1] * m[2];
    const xt = (p[0] * m[3] - p[1] * m[2] + m[2] * m[5] - m[4] * m[3]) / d;
    const yt = (-p[0] * m[1] + p[1] * m[0] + m[4] * m[1] - m[5] * m[0]) / d;
    return [xt, yt];
  }

  static getAxialAlignedBoundingBox(r, m) {
    const p1 = Util.applyTransform(r, m);
    const p2 = Util.applyTransform(r.slice(2, 4), m);
    const p3 = Util.applyTransform([r[0], r[3]], m);
    const p4 = Util.applyTransform([r[2], r[1]], m);
    return [Math.min(p1[0], p2[0], p3[0], p4[0]), Math.min(p1[1], p2[1], p3[1], p4[1]), Math.max(p1[0], p2[0], p3[0], p4[0]), Math.max(p1[1], p2[1], p3[1], p4[1])];
  }

  static inverseTransform(m) {
    const d = m[0] * m[3] - m[1] * m[2];
    return [m[3] / d, -m[1] / d, -m[2] / d, m[0] / d, (m[2] * m[5] - m[4] * m[3]) / d, (m[4] * m[1] - m[5] * m[0]) / d];
  }

  static apply3dTransform(m, v) {
    return [m[0] * v[0] + m[1] * v[1] + m[2] * v[2], m[3] * v[0] + m[4] * v[1] + m[5] * v[2], m[6] * v[0] + m[7] * v[1] + m[8] * v[2]];
  }

  static singularValueDecompose2dScale(m) {
    const transpose = [m[0], m[2], m[1], m[3]];
    const a = m[0] * transpose[0] + m[1] * transpose[2];
    const b = m[0] * transpose[1] + m[1] * transpose[3];
    const c = m[2] * transpose[0] + m[3] * transpose[2];
    const d = m[2] * transpose[1] + m[3] * transpose[3];
    const first = (a + d) / 2;
    const second = Math.sqrt((a + d) ** 2 - 4 * (a * d - c * b)) / 2;
    const sx = first + second || 1;
    const sy = first - second || 1;
    return [Math.sqrt(sx), Math.sqrt(sy)];
  }

  static normalizeRect(rect) {
    const r = rect.slice(0);

    if (rect[0] > rect[2]) {
      r[0] = rect[2];
      r[2] = rect[0];
    }

    if (rect[1] > rect[3]) {
      r[1] = rect[3];
      r[3] = rect[1];
    }

    return r;
  }

  static intersect(rect1, rect2) {
    function compare(a, b) {
      return a - b;
    }

    const orderedX = [rect1[0], rect1[2], rect2[0], rect2[2]].sort(compare);
    const orderedY = [rect1[1], rect1[3], rect2[1], rect2[3]].sort(compare);
    const result = [];
    rect1 = Util.normalizeRect(rect1);
    rect2 = Util.normalizeRect(rect2);

    if (orderedX[0] === rect1[0] && orderedX[1] === rect2[0] || orderedX[0] === rect2[0] && orderedX[1] === rect1[0]) {
      result[0] = orderedX[1];
      result[2] = orderedX[2];
    } else {
      return null;
    }

    if (orderedY[0] === rect1[1] && orderedY[1] === rect2[1] || orderedY[0] === rect2[1] && orderedY[1] === rect1[1]) {
      result[1] = orderedY[1];
      result[3] = orderedY[2];
    } else {
      return null;
    }

    return result;
  }

  static bezierBoundingBox(x0, y0, x1, y1, x2, y2, x3, y3) {
    const tvalues = [],
          bounds = [[], []];
    let a, b, c, t, t1, t2, b2ac, sqrtb2ac;

    for (let i = 0; i < 2; ++i) {
      if (i === 0) {
        b = 6 * x0 - 12 * x1 + 6 * x2;
        a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
        c = 3 * x1 - 3 * x0;
      } else {
        b = 6 * y0 - 12 * y1 + 6 * y2;
        a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
        c = 3 * y1 - 3 * y0;
      }

      if (Math.abs(a) < 1e-12) {
        if (Math.abs(b) < 1e-12) {
          continue;
        }

        t = -c / b;

        if (0 < t && t < 1) {
          tvalues.push(t);
        }

        continue;
      }

      b2ac = b * b - 4 * c * a;
      sqrtb2ac = Math.sqrt(b2ac);

      if (b2ac < 0) {
        continue;
      }

      t1 = (-b + sqrtb2ac) / (2 * a);

      if (0 < t1 && t1 < 1) {
        tvalues.push(t1);
      }

      t2 = (-b - sqrtb2ac) / (2 * a);

      if (0 < t2 && t2 < 1) {
        tvalues.push(t2);
      }
    }

    let j = tvalues.length,
        mt;
    const jlen = j;

    while (j--) {
      t = tvalues[j];
      mt = 1 - t;
      bounds[0][j] = mt * mt * mt * x0 + 3 * mt * mt * t * x1 + 3 * mt * t * t * x2 + t * t * t * x3;
      bounds[1][j] = mt * mt * mt * y0 + 3 * mt * mt * t * y1 + 3 * mt * t * t * y2 + t * t * t * y3;
    }

    bounds[0][jlen] = x0;
    bounds[1][jlen] = y0;
    bounds[0][jlen + 1] = x3;
    bounds[1][jlen + 1] = y3;
    bounds[0].length = bounds[1].length = jlen + 2;
    return [Math.min(...bounds[0]), Math.min(...bounds[1]), Math.max(...bounds[0]), Math.max(...bounds[1])];
  }

}

exports.Util = Util;
const PDFStringTranslateTable = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2d8, 0x2c7, 0x2c6, 0x2d9, 0x2dd, 0x2db, 0x2da, 0x2dc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2022, 0x2020, 0x2021, 0x2026, 0x2014, 0x2013, 0x192, 0x2044, 0x2039, 0x203a, 0x2212, 0x2030, 0x201e, 0x201c, 0x201d, 0x2018, 0x2019, 0x201a, 0x2122, 0xfb01, 0xfb02, 0x141, 0x152, 0x160, 0x178, 0x17d, 0x131, 0x142, 0x153, 0x161, 0x17e, 0, 0x20ac];

function stringToPDFString(str) {
  const length = str.length,
        strBuf = [];

  if (str[0] === "\xFE" && str[1] === "\xFF") {
    for (let i = 2; i < length; i += 2) {
      strBuf.push(String.fromCharCode(str.charCodeAt(i) << 8 | str.charCodeAt(i + 1)));
    }
  } else if (str[0] === "\xFF" && str[1] === "\xFE") {
    for (let i = 2; i < length; i += 2) {
      strBuf.push(String.fromCharCode(str.charCodeAt(i + 1) << 8 | str.charCodeAt(i)));
    }
  } else {
    for (let i = 0; i < length; ++i) {
      const code = PDFStringTranslateTable[str.charCodeAt(i)];
      strBuf.push(code ? String.fromCharCode(code) : str.charAt(i));
    }
  }

  return strBuf.join("");
}

function escapeString(str) {
  return str.replace(/([()\\\n\r])/g, match => {
    if (match === "\n") {
      return "\\n";
    } else if (match === "\r") {
      return "\\r";
    }

    return `\\${match}`;
  });
}

function isAscii(str) {
  return /^[\x00-\x7F]*$/.test(str);
}

function stringToUTF16BEString(str) {
  const buf = ["\xFE\xFF"];

  for (let i = 0, ii = str.length; i < ii; i++) {
    const char = str.charCodeAt(i);
    buf.push(String.fromCharCode(char >> 8 & 0xff), String.fromCharCode(char & 0xff));
  }

  return buf.join("");
}

function stringToUTF8String(str) {
  return decodeURIComponent(escape(str));
}

function utf8StringToString(str) {
  return unescape(encodeURIComponent(str));
}

function isBool(v) {
  return typeof v === "boolean";
}

function isNum(v) {
  return typeof v === "number";
}

function isString(v) {
  return typeof v === "string";
}

function isArrayBuffer(v) {
  return typeof v === "object" && v !== null && v.byteLength !== undefined;
}

function isArrayEqual(arr1, arr2) {
  if (arr1.length !== arr2.length) {
    return false;
  }

  for (let i = 0, ii = arr1.length; i < ii; i++) {
    if (arr1[i] !== arr2[i]) {
      return false;
    }
  }

  return true;
}

function getModificationDate(date = new Date()) {
  const buffer = [date.getUTCFullYear().toString(), (date.getUTCMonth() + 1).toString().padStart(2, "0"), date.getUTCDate().toString().padStart(2, "0"), date.getUTCHours().toString().padStart(2, "0"), date.getUTCMinutes().toString().padStart(2, "0"), date.getUTCSeconds().toString().padStart(2, "0")];
  return buffer.join("");
}

function createPromiseCapability() {
  const capability = Object.create(null);
  let isSettled = false;
  Object.defineProperty(capability, "settled", {
    get() {
      return isSettled;
    }

  });
  capability.promise = new Promise(function (resolve, reject) {
    capability.resolve = function (data) {
      isSettled = true;
      resolve(data);
    };

    capability.reject = function (reason) {
      isSettled = true;
      reject(reason);
    };
  });
  return capability;
}

function createObjectURL(data, contentType = "", forceDataSchema = false) {
  if (URL.createObjectURL && typeof Blob !== "undefined" && !forceDataSchema) {
    return URL.createObjectURL(new Blob([data], {
      type: contentType
    }));
  }

  const digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  let buffer = `data:${contentType};base64,`;

  for (let i = 0, ii = data.length; i < ii; i += 3) {
    const b1 = data[i] & 0xff;
    const b2 = data[i + 1] & 0xff;
    const b3 = data[i + 2] & 0xff;
    const d1 = b1 >> 2,
          d2 = (b1 & 3) << 4 | b2 >> 4;
    const d3 = i + 1 < ii ? (b2 & 0xf) << 2 | b3 >> 6 : 64;
    const d4 = i + 2 < ii ? b3 & 0x3f : 64;
    buffer += digits[d1] + digits[d2] + digits[d3] + digits[d4];
  }

  return buffer;
}

/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {



var _is_node = __w_pdfjs_require__(4);

;

/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isNodeJS = void 0;
const isNodeJS = typeof process === "object" && process + "" === "[object process]" && !process.versions.nw && !(process.versions.electron && process.type && process.type !== "browser");
exports.isNodeJS = isNodeJS;

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.RefSetCache = exports.RefSet = exports.Ref = exports.Name = exports.EOF = exports.Dict = exports.Cmd = exports.CIRCULAR_REF = void 0;
exports.clearPrimitiveCaches = clearPrimitiveCaches;
exports.isCmd = isCmd;
exports.isDict = isDict;
exports.isName = isName;
exports.isRef = isRef;
exports.isRefsEqual = isRefsEqual;
exports.isStream = isStream;

var _util = __w_pdfjs_require__(2);

var _base_stream = __w_pdfjs_require__(6);

const CIRCULAR_REF = Symbol("CIRCULAR_REF");
exports.CIRCULAR_REF = CIRCULAR_REF;
const EOF = Symbol("EOF");
exports.EOF = EOF;

const Name = function NameClosure() {
  let nameCache = Object.create(null);

  class Name {
    constructor(name) {
      this.name = name;
    }

    static get(name) {
      const nameValue = nameCache[name];
      return nameValue ? nameValue : nameCache[name] = new Name(name);
    }

    static _clearCache() {
      nameCache = Object.create(null);
    }

  }

  return Name;
}();

exports.Name = Name;

const Cmd = function CmdClosure() {
  let cmdCache = Object.create(null);

  class Cmd {
    constructor(cmd) {
      this.cmd = cmd;
    }

    static get(cmd) {
      const cmdValue = cmdCache[cmd];
      return cmdValue ? cmdValue : cmdCache[cmd] = new Cmd(cmd);
    }

    static _clearCache() {
      cmdCache = Object.create(null);
    }

  }

  return Cmd;
}();

exports.Cmd = Cmd;

const nonSerializable = function nonSerializableClosure() {
  return nonSerializable;
};

class Dict {
  constructor(xref = null) {
    this._map = Object.create(null);
    this.xref = xref;
    this.objId = null;
    this.suppressEncryption = false;
    this.__nonSerializable__ = nonSerializable;
  }

  assignXref(newXref) {
    this.xref = newXref;
  }

  get size() {
    return Object.keys(this._map).length;
  }

  get(key1, key2, key3) {
    let value = this._map[key1];

    if (value === undefined && key2 !== undefined) {
      value = this._map[key2];

      if (value === undefined && key3 !== undefined) {
        value = this._map[key3];
      }
    }

    if (value instanceof Ref && this.xref) {
      return this.xref.fetch(value, this.suppressEncryption);
    }

    return value;
  }

  async getAsync(key1, key2, key3) {
    let value = this._map[key1];

    if (value === undefined && key2 !== undefined) {
      value = this._map[key2];

      if (value === undefined && key3 !== undefined) {
        value = this._map[key3];
      }
    }

    if (value instanceof Ref && this.xref) {
      return this.xref.fetchAsync(value, this.suppressEncryption);
    }

    return value;
  }

  getArray(key1, key2, key3) {
    let value = this._map[key1];

    if (value === undefined && key2 !== undefined) {
      value = this._map[key2];

      if (value === undefined && key3 !== undefined) {
        value = this._map[key3];
      }
    }

    if (value instanceof Ref && this.xref) {
      value = this.xref.fetch(value, this.suppressEncryption);
    }

    if (Array.isArray(value)) {
      value = value.slice();

      for (let i = 0, ii = value.length; i < ii; i++) {
        if (value[i] instanceof Ref && this.xref) {
          value[i] = this.xref.fetch(value[i], this.suppressEncryption);
        }
      }
    }

    return value;
  }

  getRaw(key) {
    return this._map[key];
  }

  getKeys() {
    return Object.keys(this._map);
  }

  getRawValues() {
    return Object.values(this._map);
  }

  set(key, value) {
    this._map[key] = value;
  }

  has(key) {
    return this._map[key] !== undefined;
  }

  forEach(callback) {
    for (const key in this._map) {
      callback(key, this.get(key));
    }
  }

  static get empty() {
    const emptyDict = new Dict(null);

    emptyDict.set = (key, value) => {
      (0, _util.unreachable)("Should not call `set` on the empty dictionary.");
    };

    return (0, _util.shadow)(this, "empty", emptyDict);
  }

  static merge({
    xref,
    dictArray,
    mergeSubDicts = false
  }) {
    const mergedDict = new Dict(xref),
          properties = new Map();

    for (const dict of dictArray) {
      if (!(dict instanceof Dict)) {
        continue;
      }

      for (const [key, value] of Object.entries(dict._map)) {
        let property = properties.get(key);

        if (property === undefined) {
          property = [];
          properties.set(key, property);
        } else if (!mergeSubDicts || !(value instanceof Dict)) {
          continue;
        }

        property.push(value);
      }
    }

    for (const [name, values] of properties) {
      if (values.length === 1 || !(values[0] instanceof Dict)) {
        mergedDict._map[name] = values[0];
        continue;
      }

      const subDict = new Dict(xref);

      for (const dict of values) {
        for (const [key, value] of Object.entries(dict._map)) {
          if (subDict._map[key] === undefined) {
            subDict._map[key] = value;
          }
        }
      }

      if (subDict.size > 0) {
        mergedDict._map[name] = subDict;
      }
    }

    properties.clear();
    return mergedDict.size > 0 ? mergedDict : Dict.empty;
  }

}

exports.Dict = Dict;

const Ref = function RefClosure() {
  let refCache = Object.create(null);

  class Ref {
    constructor(num, gen) {
      this.num = num;
      this.gen = gen;
    }

    toString() {
      if (this.gen === 0) {
        return `${this.num}R`;
      }

      return `${this.num}R${this.gen}`;
    }

    static get(num, gen) {
      const key = gen === 0 ? `${num}R` : `${num}R${gen}`;
      const refValue = refCache[key];
      return refValue ? refValue : refCache[key] = new Ref(num, gen);
    }

    static _clearCache() {
      refCache = Object.create(null);
    }

  }

  return Ref;
}();

exports.Ref = Ref;

class RefSet {
  constructor(parent = null) {
    this._set = new Set(parent && parent._set);
  }

  has(ref) {
    return this._set.has(ref.toString());
  }

  put(ref) {
    this._set.add(ref.toString());
  }

  remove(ref) {
    this._set.delete(ref.toString());
  }

  forEach(callback) {
    for (const ref of this._set.values()) {
      callback(ref);
    }
  }

  clear() {
    this._set.clear();
  }

}

exports.RefSet = RefSet;

class RefSetCache {
  constructor() {
    this._map = new Map();
  }

  get size() {
    return this._map.size;
  }

  get(ref) {
    return this._map.get(ref.toString());
  }

  has(ref) {
    return this._map.has(ref.toString());
  }

  put(ref, obj) {
    this._map.set(ref.toString(), obj);
  }

  putAlias(ref, aliasRef) {
    this._map.set(ref.toString(), this.get(aliasRef));
  }

  forEach(callback) {
    for (const value of this._map.values()) {
      callback(value);
    }
  }

  clear() {
    this._map.clear();
  }

}

exports.RefSetCache = RefSetCache;

function isName(v, name) {
  return v instanceof Name && (name === undefined || v.name === name);
}

function isCmd(v, cmd) {
  return v instanceof Cmd && (cmd === undefined || v.cmd === cmd);
}

function isDict(v, type) {
  return v instanceof Dict && (type === undefined || isName(v.get("Type"), type));
}

function isRef(v) {
  return v instanceof Ref;
}

function isRefsEqual(v1, v2) {
  return v1.num === v2.num && v1.gen === v2.gen;
}

function isStream(v) {
  return v instanceof _base_stream.BaseStream;
}

function clearPrimitiveCaches() {
  Cmd._clearCache();

  Name._clearCache();

  Ref._clearCache();
}

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.BaseStream = void 0;

var _util = __w_pdfjs_require__(2);

class BaseStream {
  constructor() {
    if (this.constructor === BaseStream) {
      (0, _util.unreachable)("Cannot initialize BaseStream.");
    }
  }

  get length() {
    (0, _util.unreachable)("Abstract getter `length` accessed");
  }

  get isEmpty() {
    (0, _util.unreachable)("Abstract getter `isEmpty` accessed");
  }

  get isDataLoaded() {
    return (0, _util.shadow)(this, "isDataLoaded", true);
  }

  getByte() {
    (0, _util.unreachable)("Abstract method `getByte` called");
  }

  getBytes(length, forceClamped = false) {
    (0, _util.unreachable)("Abstract method `getBytes` called");
  }

  peekByte() {
    const peekedByte = this.getByte();

    if (peekedByte !== -1) {
      this.pos--;
    }

    return peekedByte;
  }

  peekBytes(length, forceClamped = false) {
    const bytes = this.getBytes(length, forceClamped);
    this.pos -= bytes.length;
    return bytes;
  }

  getUint16() {
    const b0 = this.getByte();
    const b1 = this.getByte();

    if (b0 === -1 || b1 === -1) {
      return -1;
    }

    return (b0 << 8) + b1;
  }

  getInt32() {
    const b0 = this.getByte();
    const b1 = this.getByte();
    const b2 = this.getByte();
    const b3 = this.getByte();
    return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
  }

  getByteRange(begin, end) {
    (0, _util.unreachable)("Abstract method `getByteRange` called");
  }

  getString(length) {
    return (0, _util.bytesToString)(this.getBytes(length, false));
  }

  skip(n) {
    this.pos += n || 1;
  }

  reset() {
    (0, _util.unreachable)("Abstract method `reset` called");
  }

  moveStart() {
    (0, _util.unreachable)("Abstract method `moveStart` called");
  }

  makeSubStream(start, length, dict = null) {
    (0, _util.unreachable)("Abstract method `makeSubStream` called");
  }

  getBaseStreams() {
    return null;
  }

}

exports.BaseStream = BaseStream;

/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.NetworkPdfManager = exports.LocalPdfManager = void 0;

var _util = __w_pdfjs_require__(2);

var _chunked_stream = __w_pdfjs_require__(8);

var _core_utils = __w_pdfjs_require__(9);

var _document = __w_pdfjs_require__(11);

var _stream = __w_pdfjs_require__(10);

function parseDocBaseUrl(url) {
  if (url) {
    const absoluteUrl = (0, _util.createValidAbsoluteUrl)(url);

    if (absoluteUrl) {
      return absoluteUrl.href;
    }

    (0, _util.warn)(`Invalid absolute docBaseUrl: "${url}".`);
  }

  return null;
}

class BasePdfManager {
  constructor() {
    if (this.constructor === BasePdfManager) {
      (0, _util.unreachable)("Cannot initialize BasePdfManager.");
    }
  }

  get docId() {
    return this._docId;
  }

  get password() {
    return this._password;
  }

  get docBaseUrl() {
    return this._docBaseUrl;
  }

  onLoadedStream() {
    (0, _util.unreachable)("Abstract method `onLoadedStream` called");
  }

  ensureDoc(prop, args) {
    return this.ensure(this.pdfDocument, prop, args);
  }

  ensureXRef(prop, args) {
    return this.ensure(this.pdfDocument.xref, prop, args);
  }

  ensureCatalog(prop, args) {
    return this.ensure(this.pdfDocument.catalog, prop, args);
  }

  getPage(pageIndex) {
    return this.pdfDocument.getPage(pageIndex);
  }

  fontFallback(id, handler) {
    return this.pdfDocument.fontFallback(id, handler);
  }

  loadXfaFonts(handler, task) {
    return this.pdfDocument.loadXfaFonts(handler, task);
  }

  loadXfaImages() {
    return this.pdfDocument.loadXfaImages();
  }

  serializeXfaData(annotationStorage) {
    return this.pdfDocument.serializeXfaData(annotationStorage);
  }

  cleanup(manuallyTriggered = false) {
    return this.pdfDocument.cleanup(manuallyTriggered);
  }

  async ensure(obj, prop, args) {
    (0, _util.unreachable)("Abstract method `ensure` called");
  }

  requestRange(begin, end) {
    (0, _util.unreachable)("Abstract method `requestRange` called");
  }

  requestLoadedStream() {
    (0, _util.unreachable)("Abstract method `requestLoadedStream` called");
  }

  sendProgressiveData(chunk) {
    (0, _util.unreachable)("Abstract method `sendProgressiveData` called");
  }

  updatePassword(password) {
    this._password = password;
  }

  terminate(reason) {
    (0, _util.unreachable)("Abstract method `terminate` called");
  }

}

class LocalPdfManager extends BasePdfManager {
  constructor(docId, data, password, msgHandler, evaluatorOptions, enableXfa, docBaseUrl) {
    super();
    this._docId = docId;
    this._password = password;
    this._docBaseUrl = parseDocBaseUrl(docBaseUrl);
    this.msgHandler = msgHandler;
    this.evaluatorOptions = evaluatorOptions;
    this.enableXfa = enableXfa;
    const stream = new _stream.Stream(data);
    this.pdfDocument = new _document.PDFDocument(this, stream);
    this._loadedStreamPromise = Promise.resolve(stream);
  }

  async ensure(obj, prop, args) {
    const value = obj[prop];

    if (typeof value === "function") {
      return value.apply(obj, args);
    }

    return value;
  }

  requestRange(begin, end) {
    return Promise.resolve();
  }

  requestLoadedStream() {}

  onLoadedStream() {
    return this._loadedStreamPromise;
  }

  terminate(reason) {}

}

exports.LocalPdfManager = LocalPdfManager;

class NetworkPdfManager extends BasePdfManager {
  constructor(docId, pdfNetworkStream, args, evaluatorOptions, enableXfa, docBaseUrl) {
    super();
    this._docId = docId;
    this._password = args.password;
    this._docBaseUrl = parseDocBaseUrl(docBaseUrl);
    this.msgHandler = args.msgHandler;
    this.evaluatorOptions = evaluatorOptions;
    this.enableXfa = enableXfa;
    this.streamManager = new _chunked_stream.ChunkedStreamManager(pdfNetworkStream, {
      msgHandler: args.msgHandler,
      length: args.length,
      disableAutoFetch: args.disableAutoFetch,
      rangeChunkSize: args.rangeChunkSize
    });
    this.pdfDocument = new _document.PDFDocument(this, this.streamManager.getStream());
  }

  async ensure(obj, prop, args) {
    try {
      const value = obj[prop];

      if (typeof value === "function") {
        return value.apply(obj, args);
      }

      return value;
    } catch (ex) {
      if (!(ex instanceof _core_utils.MissingDataException)) {
        throw ex;
      }

      await this.requestRange(ex.begin, ex.end);
      return this.ensure(obj, prop, args);
    }
  }

  requestRange(begin, end) {
    return this.streamManager.requestRange(begin, end);
  }

  requestLoadedStream() {
    this.streamManager.requestAllChunks();
  }

  sendProgressiveData(chunk) {
    this.streamManager.onReceiveData({
      chunk
    });
  }

  onLoadedStream() {
    return this.streamManager.onLoadedStream();
  }

  terminate(reason) {
    this.streamManager.abort(reason);
  }

}

exports.NetworkPdfManager = NetworkPdfManager;

/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ChunkedStreamManager = exports.ChunkedStream = void 0;

var _util = __w_pdfjs_require__(2);

var _core_utils = __w_pdfjs_require__(9);

var _stream = __w_pdfjs_require__(10);

class ChunkedStream extends _stream.Stream {
  constructor(length, chunkSize, manager) {
    super(new Uint8Array(length), 0, length, null);
    this.chunkSize = chunkSize;
    this._loadedChunks = new Set();
    this.numChunks = Math.ceil(length / chunkSize);
    this.manager = manager;
    this.progressiveDataLength = 0;
    this.lastSuccessfulEnsureByteChunk = -1;
  }

  getMissingChunks() {
    const chunks = [];

    for (let chunk = 0, n = this.numChunks; chunk < n; ++chunk) {
      if (!this._loadedChunks.has(chunk)) {
        chunks.push(chunk);
      }
    }

    return chunks;
  }

  get numChunksLoaded() {
    return this._loadedChunks.size;
  }

  get isDataLoaded() {
    return this.numChunksLoaded === this.numChunks;
  }

  onReceiveData(begin, chunk) {
    const chunkSize = this.chunkSize;

    if (begin % chunkSize !== 0) {
      throw new Error(`Bad begin offset: ${begin}`);
    }

    const end = begin + chunk.byteLength;

    if (end % chunkSize !== 0 && end !== this.bytes.length) {
      throw new Error(`Bad end offset: ${end}`);
    }

    this.bytes.set(new Uint8Array(chunk), begin);
    const beginChunk = Math.floor(begin / chunkSize);
    const endChunk = Math.floor((end - 1) / chunkSize) + 1;

    for (let curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
      this._loadedChunks.add(curChunk);
    }
  }

  onReceiveProgressiveData(data) {
    let position = this.progressiveDataLength;
    const beginChunk = Math.floor(position / this.chunkSize);
    this.bytes.set(new Uint8Array(data), position);
    position += data.byteLength;
    this.progressiveDataLength = position;
    const endChunk = position >= this.end ? this.numChunks : Math.floor(position / this.chunkSize);

    for (let curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
      this._loadedChunks.add(curChunk);
    }
  }

  ensureByte(pos) {
    if (pos < this.progressiveDataLength) {
      return;
    }

    const chunk = Math.floor(pos / this.chunkSize);

    if (chunk > this.numChunks) {
      return;
    }

    if (chunk === this.lastSuccessfulEnsureByteChunk) {
      return;
    }

    if (!this._loadedChunks.has(chunk)) {
      throw new _core_utils.MissingDataException(pos, pos + 1);
    }

    this.lastSuccessfulEnsureByteChunk = chunk;
  }

  ensureRange(begin, end) {
    if (begin >= end) {
      return;
    }

    if (end <= this.progressiveDataLength) {
      return;
    }

    const beginChunk = Math.floor(begin / this.chunkSize);

    if (beginChunk > this.numChunks) {
      return;
    }

    const endChunk = Math.min(Math.floor((end - 1) / this.chunkSize) + 1, this.numChunks);

    for (let chunk = beginChunk; chunk < endChunk; ++chunk) {
      if (!this._loadedChunks.has(chunk)) {
        throw new _core_utils.MissingDataException(begin, end);
      }
    }
  }

  nextEmptyChunk(beginChunk) {
    const numChunks = this.numChunks;

    for (let i = 0; i < numChunks; ++i) {
      const chunk = (beginChunk + i) % numChunks;

      if (!this._loadedChunks.has(chunk)) {
        return chunk;
      }
    }

    return null;
  }

  hasChunk(chunk) {
    return this._loadedChunks.has(chunk);
  }

  getByte() {
    const pos = this.pos;

    if (pos >= this.end) {
      return -1;
    }

    if (pos >= this.progressiveDataLength) {
      this.ensureByte(pos);
    }

    return this.bytes[this.pos++];
  }

  getBytes(length, forceClamped = false) {
    const bytes = this.bytes;
    const pos = this.pos;
    const strEnd = this.end;

    if (!length) {
      if (strEnd > this.progressiveDataLength) {
        this.ensureRange(pos, strEnd);
      }

      const subarray = bytes.subarray(pos, strEnd);
      return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
    }

    let end = pos + length;

    if (end > strEnd) {
      end = strEnd;
    }

    if (end > this.progressiveDataLength) {
      this.ensureRange(pos, end);
    }

    this.pos = end;
    const subarray = bytes.subarray(pos, end);
    return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
  }

  getByteRange(begin, end) {
    if (begin < 0) {
      begin = 0;
    }

    if (end > this.end) {
      end = this.end;
    }

    if (end > this.progressiveDataLength) {
      this.ensureRange(begin, end);
    }

    return this.bytes.subarray(begin, end);
  }

  makeSubStream(start, length, dict = null) {
    if (length) {
      if (start + length > this.progressiveDataLength) {
        this.ensureRange(start, start + length);
      }
    } else {
      if (start >= this.progressiveDataLength) {
        this.ensureByte(start);
      }
    }

    function ChunkedStreamSubstream() {}

    ChunkedStreamSubstream.prototype = Object.create(this);

    ChunkedStreamSubstream.prototype.getMissingChunks = function () {
      const chunkSize = this.chunkSize;
      const beginChunk = Math.floor(this.start / chunkSize);
      const endChunk = Math.floor((this.end - 1) / chunkSize) + 1;
      const missingChunks = [];

      for (let chunk = beginChunk; chunk < endChunk; ++chunk) {
        if (!this._loadedChunks.has(chunk)) {
          missingChunks.push(chunk);
        }
      }

      return missingChunks;
    };

    Object.defineProperty(ChunkedStreamSubstream.prototype, "isDataLoaded", {
      get() {
        if (this.numChunksLoaded === this.numChunks) {
          return true;
        }

        return this.getMissingChunks().length === 0;
      },

      configurable: true
    });
    const subStream = new ChunkedStreamSubstream();
    subStream.pos = subStream.start = start;
    subStream.end = start + length || this.end;
    subStream.dict = dict;
    return subStream;
  }

  getBaseStreams() {
    return [this];
  }

}

exports.ChunkedStream = ChunkedStream;

class ChunkedStreamManager {
  constructor(pdfNetworkStream, args) {
    this.length = args.length;
    this.chunkSize = args.rangeChunkSize;
    this.stream = new ChunkedStream(this.length, this.chunkSize, this);
    this.pdfNetworkStream = pdfNetworkStream;
    this.disableAutoFetch = args.disableAutoFetch;
    this.msgHandler = args.msgHandler;
    this.currRequestId = 0;
    this._chunksNeededByRequest = new Map();
    this._requestsByChunk = new Map();
    this._promisesByRequest = new Map();
    this.progressiveDataLength = 0;
    this.aborted = false;
    this._loadedStreamCapability = (0, _util.createPromiseCapability)();
  }

  onLoadedStream() {
    return this._loadedStreamCapability.promise;
  }

  sendRequest(begin, end) {
    const rangeReader = this.pdfNetworkStream.getRangeReader(begin, end);

    if (!rangeReader.isStreamingSupported) {
      rangeReader.onProgress = this.onProgress.bind(this);
    }

    let chunks = [],
        loaded = 0;
    return new Promise((resolve, reject) => {
      const readChunk = chunk => {
        try {
          if (!chunk.done) {
            const data = chunk.value;
            chunks.push(data);
            loaded += (0, _util.arrayByteLength)(data);

            if (rangeReader.isStreamingSupported) {
              this.onProgress({
                loaded
              });
            }

            rangeReader.read().then(readChunk, reject);
            return;
          }

          const chunkData = (0, _util.arraysToBytes)(chunks);
          chunks = null;
          resolve(chunkData);
        } catch (e) {
          reject(e);
        }
      };

      rangeReader.read().then(readChunk, reject);
    }).then(data => {
      if (this.aborted) {
        return;
      }

      this.onReceiveData({
        chunk: data,
        begin
      });
    });
  }

  requestAllChunks() {
    const missingChunks = this.stream.getMissingChunks();

    this._requestChunks(missingChunks);

    return this._loadedStreamCapability.promise;
  }

  _requestChunks(chunks) {
    const requestId = this.currRequestId++;
    const chunksNeeded = new Set();

    this._chunksNeededByRequest.set(requestId, chunksNeeded);

    for (const chunk of chunks) {
      if (!this.stream.hasChunk(chunk)) {
        chunksNeeded.add(chunk);
      }
    }

    if (chunksNeeded.size === 0) {
      return Promise.resolve();
    }

    const capability = (0, _util.createPromiseCapability)();

    this._promisesByRequest.set(requestId, capability);

    const chunksToRequest = [];

    for (const chunk of chunksNeeded) {
      let requestIds = this._requestsByChunk.get(chunk);

      if (!requestIds) {
        requestIds = [];

        this._requestsByChunk.set(chunk, requestIds);

        chunksToRequest.push(chunk);
      }

      requestIds.push(requestId);
    }

    if (chunksToRequest.length > 0) {
      const groupedChunksToRequest = this.groupChunks(chunksToRequest);

      for (const groupedChunk of groupedChunksToRequest) {
        const begin = groupedChunk.beginChunk * this.chunkSize;
        const end = Math.min(groupedChunk.endChunk * this.chunkSize, this.length);
        this.sendRequest(begin, end).catch(capability.reject);
      }
    }

    return capability.promise.catch(reason => {
      if (this.aborted) {
        return;
      }

      throw reason;
    });
  }

  getStream() {
    return this.stream;
  }

  requestRange(begin, end) {
    end = Math.min(end, this.length);
    const beginChunk = this.getBeginChunk(begin);
    const endChunk = this.getEndChunk(end);
    const chunks = [];

    for (let chunk = beginChunk; chunk < endChunk; ++chunk) {
      chunks.push(chunk);
    }

    return this._requestChunks(chunks);
  }

  requestRanges(ranges = []) {
    const chunksToRequest = [];

    for (const range of ranges) {
      const beginChunk = this.getBeginChunk(range.begin);
      const endChunk = this.getEndChunk(range.end);

      for (let chunk = beginChunk; chunk < endChunk; ++chunk) {
        if (!chunksToRequest.includes(chunk)) {
          chunksToRequest.push(chunk);
        }
      }
    }

    chunksToRequest.sort(function (a, b) {
      return a - b;
    });
    return this._requestChunks(chunksToRequest);
  }

  groupChunks(chunks) {
    const groupedChunks = [];
    let beginChunk = -1;
    let prevChunk = -1;

    for (let i = 0, ii = chunks.length; i < ii; ++i) {
      const chunk = chunks[i];

      if (beginChunk < 0) {
        beginChunk = chunk;
      }

      if (prevChunk >= 0 && prevChunk + 1 !== chunk) {
        groupedChunks.push({
          beginChunk,
          endChunk: prevChunk + 1
        });
        beginChunk = chunk;
      }

      if (i + 1 === chunks.length) {
        groupedChunks.push({
          beginChunk,
          endChunk: chunk + 1
        });
      }

      prevChunk = chunk;
    }

    return groupedChunks;
  }

  onProgress(args) {
    this.msgHandler.send("DocProgress", {
      loaded: this.stream.numChunksLoaded * this.chunkSize + args.loaded,
      total: this.length
    });
  }

  onReceiveData(args) {
    const chunk = args.chunk;
    const isProgressive = args.begin === undefined;
    const begin = isProgressive ? this.progressiveDataLength : args.begin;
    const end = begin + chunk.byteLength;
    const beginChunk = Math.floor(begin / this.chunkSize);
    const endChunk = end < this.length ? Math.floor(end / this.chunkSize) : Math.ceil(end / this.chunkSize);

    if (isProgressive) {
      this.stream.onReceiveProgressiveData(chunk);
      this.progressiveDataLength = end;
    } else {
      this.stream.onReceiveData(begin, chunk);
    }

    if (this.stream.isDataLoaded) {
      this._loadedStreamCapability.resolve(this.stream);
    }

    const loadedRequests = [];

    for (let curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
      const requestIds = this._requestsByChunk.get(curChunk);

      if (!requestIds) {
        continue;
      }

      this._requestsByChunk.delete(curChunk);

      for (const requestId of requestIds) {
        const chunksNeeded = this._chunksNeededByRequest.get(requestId);

        if (chunksNeeded.has(curChunk)) {
          chunksNeeded.delete(curChunk);
        }

        if (chunksNeeded.size > 0) {
          continue;
        }

        loadedRequests.push(requestId);
      }
    }

    if (!this.disableAutoFetch && this._requestsByChunk.size === 0) {
      let nextEmptyChunk;

      if (this.stream.numChunksLoaded === 1) {
        const lastChunk = this.stream.numChunks - 1;

        if (!this.stream.hasChunk(lastChunk)) {
          nextEmptyChunk = lastChunk;
        }
      } else {
        nextEmptyChunk = this.stream.nextEmptyChunk(endChunk);
      }

      if (Number.isInteger(nextEmptyChunk)) {
        this._requestChunks([nextEmptyChunk]);
      }
    }

    for (const requestId of loadedRequests) {
      const capability = this._promisesByRequest.get(requestId);

      this._promisesByRequest.delete(requestId);

      capability.resolve();
    }

    this.msgHandler.send("DocProgress", {
      loaded: this.stream.numChunksLoaded * this.chunkSize,
      total: this.length
    });
  }

  onError(err) {
    this._loadedStreamCapability.reject(err);
  }

  getBeginChunk(begin) {
    return Math.floor(begin / this.chunkSize);
  }

  getEndChunk(end) {
    return Math.floor((end - 1) / this.chunkSize) + 1;
  }

  abort(reason) {
    this.aborted = true;

    if (this.pdfNetworkStream) {
      this.pdfNetworkStream.cancelAllRequests(reason);
    }

    for (const capability of this._promisesByRequest.values()) {
      capability.reject(reason);
    }
  }

}

exports.ChunkedStreamManager = ChunkedStreamManager;

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.XRefParseException = exports.XRefEntryException = exports.ParserEOFException = exports.MissingDataException = exports.DocStats = void 0;
exports.collectActions = collectActions;
exports.encodeToXmlString = encodeToXmlString;
exports.escapePDFName = escapePDFName;
exports.getArrayLookupTableFactory = getArrayLookupTableFactory;
exports.getInheritableProperty = getInheritableProperty;
exports.getLookupTableFactory = getLookupTableFactory;
exports.isWhiteSpace = isWhiteSpace;
exports.log2 = log2;
exports.parseXFAPath = parseXFAPath;
exports.readInt8 = readInt8;
exports.readUint16 = readUint16;
exports.readUint32 = readUint32;
exports.recoverJsURL = recoverJsURL;
exports.toRomanNumerals = toRomanNumerals;
exports.validateCSSFont = validateCSSFont;

var _util = __w_pdfjs_require__(2);

var _primitives = __w_pdfjs_require__(5);

function getLookupTableFactory(initializer) {
  let lookup;
  return function () {
    if (initializer) {
      lookup = Object.create(null);
      initializer(lookup);
      initializer = null;
    }

    return lookup;
  };
}

function getArrayLookupTableFactory(initializer) {
  let lookup;
  return function () {
    if (initializer) {
      let arr = initializer();
      initializer = null;
      lookup = Object.create(null);

      for (let i = 0, ii = arr.length; i < ii; i += 2) {
        lookup[arr[i]] = arr[i + 1];
      }

      arr = null;
    }

    return lookup;
  };
}

class MissingDataException extends _util.BaseException {
  constructor(begin, end) {
    super(`Missing data [${begin}, ${end})`, "MissingDataException");
    this.begin = begin;
    this.end = end;
  }

}

exports.MissingDataException = MissingDataException;

class ParserEOFException extends _util.BaseException {
  constructor(msg) {
    super(msg, "ParserEOFException");
  }

}

exports.ParserEOFException = ParserEOFException;

class XRefEntryException extends _util.BaseException {
  constructor(msg) {
    super(msg, "XRefEntryException");
  }

}

exports.XRefEntryException = XRefEntryException;

class XRefParseException extends _util.BaseException {
  constructor(msg) {
    super(msg, "XRefParseException");
  }

}

exports.XRefParseException = XRefParseException;

class DocStats {
  constructor(handler) {
    this._handler = handler;
    this._streamTypes = new Set();
    this._fontTypes = new Set();
  }

  _send() {
    const streamTypes = Object.create(null),
          fontTypes = Object.create(null);

    for (const type of this._streamTypes) {
      streamTypes[type] = true;
    }

    for (const type of this._fontTypes) {
      fontTypes[type] = true;
    }

    this._handler.send("DocStats", {
      streamTypes,
      fontTypes
    });
  }

  addStreamType(type) {
    if (this._streamTypes.has(type)) {
      return;
    }

    this._streamTypes.add(type);

    this._send();
  }

  addFontType(type) {
    if (this._fontTypes.has(type)) {
      return;
    }

    this._fontTypes.add(type);

    this._send();
  }

}

exports.DocStats = DocStats;

function getInheritableProperty({
  dict,
  key,
  getArray = false,
  stopWhenFound = true
}) {
  let values;
  const visited = new _primitives.RefSet();

  while (dict instanceof _primitives.Dict && !(dict.objId && visited.has(dict.objId))) {
    if (dict.objId) {
      visited.put(dict.objId);
    }

    const value = getArray ? dict.getArray(key) : dict.get(key);

    if (value !== undefined) {
      if (stopWhenFound) {
        return value;
      }

      if (!values) {
        values = [];
      }

      values.push(value);
    }

    dict = dict.get("Parent");
  }

  return values;
}

const ROMAN_NUMBER_MAP = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM", "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC", "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"];

function toRomanNumerals(number, lowerCase = false) {
  (0, _util.assert)(Number.isInteger(number) && number > 0, "The number should be a positive integer.");
  const romanBuf = [];
  let pos;

  while (number >= 1000) {
    number -= 1000;
    romanBuf.push("M");
  }

  pos = number / 100 | 0;
  number %= 100;
  romanBuf.push(ROMAN_NUMBER_MAP[pos]);
  pos = number / 10 | 0;
  number %= 10;
  romanBuf.push(ROMAN_NUMBER_MAP[10 + pos]);
  romanBuf.push(ROMAN_NUMBER_MAP[20 + number]);
  const romanStr = romanBuf.join("");
  return lowerCase ? romanStr.toLowerCase() : romanStr;
}

function log2(x) {
  if (x <= 0) {
    return 0;
  }

  return Math.ceil(Math.log2(x));
}

function readInt8(data, offset) {
  return data[offset] << 24 >> 24;
}

function readUint16(data, offset) {
  return data[offset] << 8 | data[offset + 1];
}

function readUint32(data, offset) {
  return (data[offset] << 24 | data[offset + 1] << 16 | data[offset + 2] << 8 | data[offset + 3]) >>> 0;
}

function isWhiteSpace(ch) {
  return ch === 0x20 || ch === 0x09 || ch === 0x0d || ch === 0x0a;
}

function parseXFAPath(path) {
  const positionPattern = /(.+)\[(\d+)\]$/;
  return path.split(".").map(component => {
    const m = component.match(positionPattern);

    if (m) {
      return {
        name: m[1],
        pos: parseInt(m[2], 10)
      };
    }

    return {
      name: component,
      pos: 0
    };
  });
}

function escapePDFName(str) {
  const buffer = [];
  let start = 0;

  for (let i = 0, ii = str.length; i < ii; i++) {
    const char = str.charCodeAt(i);

    if (char < 0x21 || char > 0x7e || char === 0x23 || char === 0x28 || char === 0x29 || char === 0x3c || char === 0x3e || char === 0x5b || char === 0x5d || char === 0x7b || char === 0x7d || char === 0x2f || char === 0x25) {
      if (start < i) {
        buffer.push(str.substring(start, i));
      }

      buffer.push(`#${char.toString(16)}`);
      start = i + 1;
    }
  }

  if (buffer.length === 0) {
    return str;
  }

  if (start < str.length) {
    buffer.push(str.substring(start, str.length));
  }

  return buffer.join("");
}

function _collectJS(entry, xref, list, parents) {
  if (!entry) {
    return;
  }

  let parent = null;

  if ((0, _primitives.isRef)(entry)) {
    if (parents.has(entry)) {
      return;
    }

    parent = entry;
    parents.put(parent);
    entry = xref.fetch(entry);
  }

  if (Array.isArray(entry)) {
    for (const element of entry) {
      _collectJS(element, xref, list, parents);
    }
  } else if (entry instanceof _primitives.Dict) {
    if ((0, _primitives.isName)(entry.get("S"), "JavaScript") && entry.has("JS")) {
      const js = entry.get("JS");
      let code;

      if ((0, _primitives.isStream)(js)) {
        code = js.getString();
      } else {
        code = js;
      }

      code = (0, _util.stringToPDFString)(code);

      if (code) {
        list.push(code);
      }
    }

    _collectJS(entry.getRaw("Next"), xref, list, parents);
  }

  if (parent) {
    parents.remove(parent);
  }
}

function collectActions(xref, dict, eventType) {
  const actions = Object.create(null);
  const additionalActionsDicts = getInheritableProperty({
    dict,
    key: "AA",
    stopWhenFound: false
  });

  if (additionalActionsDicts) {
    for (let i = additionalActionsDicts.length - 1; i >= 0; i--) {
      const additionalActions = additionalActionsDicts[i];

      if (!(additionalActions instanceof _primitives.Dict)) {
        continue;
      }

      for (const key of additionalActions.getKeys()) {
        const action = eventType[key];

        if (!action) {
          continue;
        }

        const actionDict = additionalActions.getRaw(key);
        const parents = new _primitives.RefSet();
        const list = [];

        _collectJS(actionDict, xref, list, parents);

        if (list.length > 0) {
          actions[action] = list;
        }
      }
    }
  }

  if (dict.has("A")) {
    const actionDict = dict.get("A");
    const parents = new _primitives.RefSet();
    const list = [];

    _collectJS(actionDict, xref, list, parents);

    if (list.length > 0) {
      actions.Action = list;
    }
  }

  return (0, _util.objectSize)(actions) > 0 ? actions : null;
}

const XMLEntities = {
  0x3c: "&lt;",
  0x3e: "&gt;",
  0x26: "&amp;",
  0x22: "&quot;",
  0x27: "&apos;"
};

function encodeToXmlString(str) {
  const buffer = [];
  let start = 0;

  for (let i = 0, ii = str.length; i < ii; i++) {
    const char = str.codePointAt(i);

    if (0x20 <= char && char <= 0x7e) {
      const entity = XMLEntities[char];

      if (entity) {
        if (start < i) {
          buffer.push(str.substring(start, i));
        }

        buffer.push(entity);
        start = i + 1;
      }
    } else {
      if (start < i) {
        buffer.push(str.substring(start, i));
      }

      buffer.push(`&#x${char.toString(16).toUpperCase()};`);

      if (char > 0xd7ff && (char < 0xe000 || char > 0xfffd)) {
        i++;
      }

      start = i + 1;
    }
  }

  if (buffer.length === 0) {
    return str;
  }

  if (start < str.length) {
    buffer.push(str.substring(start, str.length));
  }

  return buffer.join("");
}

function validateCSSFont(cssFontInfo) {
  const DEFAULT_CSS_FONT_OBLIQUE = "14";
  const DEFAULT_CSS_FONT_WEIGHT = "400";
  const CSS_FONT_WEIGHT_VALUES = new Set(["100", "200", "300", "400", "500", "600", "700", "800", "900", "1000", "normal", "bold", "bolder", "lighter"]);
  const {
    fontFamily,
    fontWeight,
    italicAngle
  } = cssFontInfo;

  if (/^".*"$/.test(fontFamily)) {
    if (/[^\\]"/.test(fontFamily.slice(1, fontFamily.length - 1))) {
      (0, _util.warn)(`XFA - FontFamily contains some unescaped ": ${fontFamily}.`);
      return false;
    }
  } else if (/^'.*'$/.test(fontFamily)) {
    if (/[^\\]'/.test(fontFamily.slice(1, fontFamily.length - 1))) {
      (0, _util.warn)(`XFA - FontFamily contains some unescaped ': ${fontFamily}.`);
      return false;
    }
  } else {
    for (const ident of fontFamily.split(/[ \t]+/)) {
      if (/^(\d|(-(\d|-)))/.test(ident) || !/^[\w-\\]+$/.test(ident)) {
        (0, _util.warn)(`XFA - FontFamily contains some invalid <custom-ident>: ${fontFamily}.`);
        return false;
      }
    }
  }

  const weight = fontWeight ? fontWeight.toString() : "";
  cssFontInfo.fontWeight = CSS_FONT_WEIGHT_VALUES.has(weight) ? weight : DEFAULT_CSS_FONT_WEIGHT;
  const angle = parseFloat(italicAngle);
  cssFontInfo.italicAngle = isNaN(angle) || angle < -90 || angle > 90 ? DEFAULT_CSS_FONT_OBLIQUE : italicAngle.toString();
  return true;
}

function recoverJsURL(str) {
  const URL_OPEN_METHODS = ["app.launchURL", "window.open", "xfa.host.gotoURL"];
  const regex = new RegExp("^\\s*(" + URL_OPEN_METHODS.join("|").split(".").join("\\.") + ")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))", "i");
  const jsUrl = regex.exec(str);

  if (jsUrl && jsUrl[2]) {
    const url = jsUrl[2];
    let newWindow = false;

    if (jsUrl[3] === "true" && jsUrl[1] === "app.launchURL") {
      newWindow = true;
    }

    return {
      url,
      newWindow
    };
  }

  return null;
}

/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.StringStream = exports.Stream = exports.NullStream = void 0;

var _base_stream = __w_pdfjs_require__(6);

var _util = __w_pdfjs_require__(2);

class Stream extends _base_stream.BaseStream {
  constructor(arrayBuffer, start, length, dict) {
    super();
    this.bytes = arrayBuffer instanceof Uint8Array ? arrayBuffer : new Uint8Array(arrayBuffer);
    this.start = start || 0;
    this.pos = this.start;
    this.end = start + length || this.bytes.length;
    this.dict = dict;
  }

  get length() {
    return this.end - this.start;
  }

  get isEmpty() {
    return this.length === 0;
  }

  getByte() {
    if (this.pos >= this.end) {
      return -1;
    }

    return this.bytes[this.pos++];
  }

  getBytes(length, forceClamped = false) {
    const bytes = this.bytes;
    const pos = this.pos;
    const strEnd = this.end;

    if (!length) {
      const subarray = bytes.subarray(pos, strEnd);
      return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
    }

    let end = pos + length;

    if (end > strEnd) {
      end = strEnd;
    }

    this.pos = end;
    const subarray = bytes.subarray(pos, end);
    return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
  }

  getByteRange(begin, end) {
    if (begin < 0) {
      begin = 0;
    }

    if (end > this.end) {
      end = this.end;
    }

    return this.bytes.subarray(begin, end);
  }

  reset() {
    this.pos = this.start;
  }

  moveStart() {
    this.start = this.pos;
  }

  makeSubStream(start, length, dict = null) {
    return new Stream(this.bytes.buffer, start, length, dict);
  }

}

exports.Stream = Stream;

class StringStream extends Stream {
  constructor(str) {
    super((0, _util.stringToBytes)(str));
  }

}

exports.StringStream = StringStream;

class NullStream extends Stream {
  constructor() {
    super(new Uint8Array(0));
  }

}

exports.NullStream = NullStream;

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Page = exports.PDFDocument = void 0;

var _util = __w_pdfjs_require__(2);

var _primitives = __w_pdfjs_require__(5);

var _core_utils = __w_pdfjs_require__(9);

var _xfa_fonts = __w_pdfjs_require__(12);

var _stream = __w_pdfjs_require__(10);

var _annotation = __w_pdfjs_require__(22);

var _base_stream = __w_pdfjs_require__(6);

var _crypto = __w_pdfjs_require__(72);

var _catalog = __w_pdfjs_require__(64);

var _parser = __w_pdfjs_require__(27);

var _object_loader = __w_pdfjs_require__(70);

var _operator_list = __w_pdfjs_require__(62);

var _evaluator = __w_pdfjs_require__(25);

var _decode_stream = __w_pdfjs_require__(29);

var _struct_tree = __w_pdfjs_require__(69);

var _factory = __w_pdfjs_require__(74);

var _xref = __w_pdfjs_require__(98);

const DEFAULT_USER_UNIT = 1.0;
const LETTER_SIZE_MEDIABOX = [0, 0, 612, 792];

class Page {
  constructor({
    pdfManager,
    xref,
    pageIndex,
    pageDict,
    ref,
    globalIdFactory,
    fontCache,
    builtInCMapCache,
    standardFontDataCache,
    globalImageCache,
    nonBlendModesSet,
    xfaFactory
  }) {
    this.pdfManager = pdfManager;
    this.pageIndex = pageIndex;
    this.pageDict = pageDict;
    this.xref = xref;
    this.ref = ref;
    this.fontCache = fontCache;
    this.builtInCMapCache = builtInCMapCache;
    this.standardFontDataCache = standardFontDataCache;
    this.globalImageCache = globalImageCache;
    this.nonBlendModesSet = nonBlendModesSet;
    this.evaluatorOptions = pdfManager.evaluatorOptions;
    this.resourcesPromise = null;
    this.xfaFactory = xfaFactory;
    const idCounters = {
      obj: 0
    };
    this._localIdFactory = class extends globalIdFactory {
      static createObjId() {
        return `p${pageIndex}_${++idCounters.obj}`;
      }

      static getPageObjId() {
        return `page${ref.toString()}`;
      }

    };
  }

  _getInheritableProperty(key, getArray = false) {
    const value = (0, _core_utils.getInheritableProperty)({
      dict: this.pageDict,
      key,
      getArray,
      stopWhenFound: false
    });

    if (!Array.isArray(value)) {
      return value;
    }

    if (value.length === 1 || !(0, _primitives.isDict)(value[0])) {
      return value[0];
    }

    return _primitives.Dict.merge({
      xref: this.xref,
      dictArray: value
    });
  }

  get content() {
    return this.pageDict.getArray("Contents");
  }

  get resources() {
    return (0, _util.shadow)(this, "resources", this._getInheritableProperty("Resources") || _primitives.Dict.empty);
  }

  _getBoundingBox(name) {
    if (this.xfaData) {
      return this.xfaData.bbox;
    }

    const box = this._getInheritableProperty(name, true);

    if (Array.isArray(box) && box.length === 4) {
      if (box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
        return box;
      }

      (0, _util.warn)(`Empty /${name} entry.`);
    }

    return null;
  }

  get mediaBox() {
    return (0, _util.shadow)(this, "mediaBox", this._getBoundingBox("MediaBox") || LETTER_SIZE_MEDIABOX);
  }

  get cropBox() {
    return (0, _util.shadow)(this, "cropBox", this._getBoundingBox("CropBox") || this.mediaBox);
  }

  get userUnit() {
    let obj = this.pageDict.get("UserUnit");

    if (!(0, _util.isNum)(obj) || obj <= 0) {
      obj = DEFAULT_USER_UNIT;
    }

    return (0, _util.shadow)(this, "userUnit", obj);
  }

  get view() {
    const {
      cropBox,
      mediaBox
    } = this;
    let view;

    if (cropBox === mediaBox || (0, _util.isArrayEqual)(cropBox, mediaBox)) {
      view = mediaBox;
    } else {
      const box = _util.Util.intersect(cropBox, mediaBox);

      if (box && box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
        view = box;
      } else {
        (0, _util.warn)("Empty /CropBox and /MediaBox intersection.");
      }
    }

    return (0, _util.shadow)(this, "view", view || mediaBox);
  }

  get rotate() {
    let rotate = this._getInheritableProperty("Rotate") || 0;

    if (rotate % 90 !== 0) {
      rotate = 0;
    } else if (rotate >= 360) {
      rotate %= 360;
    } else if (rotate < 0) {
      rotate = (rotate % 360 + 360) % 360;
    }

    return (0, _util.shadow)(this, "rotate", rotate);
  }

  _onSubStreamError(handler, reason, objId) {
    if (this.evaluatorOptions.ignoreErrors) {
      handler.send("UnsupportedFeature", {
        featureId: _util.UNSUPPORTED_FEATURES.errorContentSubStream
      });
      (0, _util.warn)(`getContentStream - ignoring sub-stream (${objId}): "${reason}".`);
      return;
    }

    throw reason;
  }

  getContentStream(handler) {
    return this.pdfManager.ensure(this, "content").then(content => {
      if (content instanceof _base_stream.BaseStream) {
        return content;
      }

      if (Array.isArray(content)) {
        return new _decode_stream.StreamsSequenceStream(content, this._onSubStreamError.bind(this, handler));
      }

      return new _stream.NullStream();
    });
  }

  get xfaData() {
    return (0, _util.shadow)(this, "xfaData", this.xfaFactory ? {
      bbox: this.xfaFactory.getBoundingBox(this.pageIndex)
    } : null);
  }

  save(handler, task, annotationStorage) {
    const partialEvaluator = new _evaluator.PartialEvaluator({
      xref: this.xref,
      handler,
      pageIndex: this.pageIndex,
      idFactory: this._localIdFactory,
      fontCache: this.fontCache,
      builtInCMapCache: this.builtInCMapCache,
      standardFontDataCache: this.standardFontDataCache,
      globalImageCache: this.globalImageCache,
      options: this.evaluatorOptions
    });
    return this._parsedAnnotations.then(function (annotations) {
      const newRefsPromises = [];

      for (const annotation of annotations) {
        if (!annotation.mustBePrinted(annotationStorage)) {
          continue;
        }

        newRefsPromises.push(annotation.save(partialEvaluator, task, annotationStorage).catch(function (reason) {
          (0, _util.warn)("save - ignoring annotation data during " + `"${task.name}" task: "${reason}".`);
          return null;
        }));
      }

      return Promise.all(newRefsPromises);
    });
  }

  loadResources(keys) {
    if (!this.resourcesPromise) {
      this.resourcesPromise = this.pdfManager.ensure(this, "resources");
    }

    return this.resourcesPromise.then(() => {
      const objectLoader = new _object_loader.ObjectLoader(this.resources, keys, this.xref);
      return objectLoader.load();
    });
  }

  getOperatorList({
    handler,
    sink,
    task,
    intent,
    cacheKey,
    annotationStorage = null
  }) {
    const contentStreamPromise = this.getContentStream(handler);
    const resourcesPromise = this.loadResources(["ColorSpace", "ExtGState", "Font", "Pattern", "Properties", "Shading", "XObject"]);
    const partialEvaluator = new _evaluator.PartialEvaluator({
      xref: this.xref,
      handler,
      pageIndex: this.pageIndex,
      idFactory: this._localIdFactory,
      fontCache: this.fontCache,
      builtInCMapCache: this.builtInCMapCache,
      standardFontDataCache: this.standardFontDataCache,
      globalImageCache: this.globalImageCache,
      options: this.evaluatorOptions
    });
    const dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
    const pageListPromise = dataPromises.then(([contentStream]) => {
      const opList = new _operator_list.OperatorList(intent, sink);
      handler.send("StartRenderPage", {
        transparency: partialEvaluator.hasBlendModes(this.resources, this.nonBlendModesSet),
        pageIndex: this.pageIndex,
        cacheKey
      });
      return partialEvaluator.getOperatorList({
        stream: contentStream,
        task,
        resources: this.resources,
        operatorList: opList
      }).then(function () {
        return opList;
      });
    });
    return Promise.all([pageListPromise, this._parsedAnnotations]).then(function ([pageOpList, annotations]) {
      if (annotations.length === 0 || intent & _util.RenderingIntentFlag.ANNOTATIONS_DISABLE) {
        pageOpList.flush(true);
        return {
          length: pageOpList.totalLength
        };
      }

      const renderForms = !!(intent & _util.RenderingIntentFlag.ANNOTATIONS_FORMS),
            intentAny = !!(intent & _util.RenderingIntentFlag.ANY),
            intentDisplay = !!(intent & _util.RenderingIntentFlag.DISPLAY),
            intentPrint = !!(intent & _util.RenderingIntentFlag.PRINT);
      const opListPromises = [];

      for (const annotation of annotations) {
        if (intentAny || intentDisplay && annotation.mustBeViewed(annotationStorage) || intentPrint && annotation.mustBePrinted(annotationStorage)) {
          opListPromises.push(annotation.getOperatorList(partialEvaluator, task, intent, renderForms, annotationStorage).catch(function (reason) {
            (0, _util.warn)("getOperatorList - ignoring annotation data during " + `"${task.name}" task: "${reason}".`);
            return null;
          }));
        }
      }

      return Promise.all(opListPromises).then(function (opLists) {
        pageOpList.addOp(_util.OPS.beginAnnotations, []);

        for (const opList of opLists) {
          pageOpList.addOpList(opList);
        }

        pageOpList.addOp(_util.OPS.endAnnotations, []);
        pageOpList.flush(true);
        return {
          length: pageOpList.totalLength
        };
      });
    });
  }

  extractTextContent({
    handler,
    task,
    normalizeWhitespace,
    includeMarkedContent,
    sink,
    combineTextItems
  }) {
    const contentStreamPromise = this.getContentStream(handler);
    const resourcesPromise = this.loadResources(["ExtGState", "Font", "Properties", "XObject"]);
    const dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
    return dataPromises.then(([contentStream]) => {
      const partialEvaluator = new _evaluator.PartialEvaluator({
        xref: this.xref,
        handler,
        pageIndex: this.pageIndex,
        idFactory: this._localIdFactory,
        fontCache: this.fontCache,
        builtInCMapCache: this.builtInCMapCache,
        standardFontDataCache: this.standardFontDataCache,
        globalImageCache: this.globalImageCache,
        options: this.evaluatorOptions
      });
      return partialEvaluator.getTextContent({
        stream: contentStream,
        task,
        resources: this.resources,
        normalizeWhitespace,
        includeMarkedContent,
        combineTextItems,
        sink
      });
    });
  }

  async getStructTree() {
    const structTreeRoot = await this.pdfManager.ensureCatalog("structTreeRoot");

    if (!structTreeRoot) {
      return null;
    }

    const structTree = await this.pdfManager.ensure(this, "_parseStructTree", [structTreeRoot]);
    return structTree.serializable;
  }

  _parseStructTree(structTreeRoot) {
    const tree = new _struct_tree.StructTreePage(structTreeRoot, this.pageDict);
    tree.parse();
    return tree;
  }

  getAnnotationsData(intent) {
    return this._parsedAnnotations.then(function (annotations) {
      const annotationsData = [];

      if (annotations.length === 0) {
        return annotationsData;
      }

      const intentAny = !!(intent & _util.RenderingIntentFlag.ANY),
            intentDisplay = !!(intent & _util.RenderingIntentFlag.DISPLAY),
            intentPrint = !!(intent & _util.RenderingIntentFlag.PRINT);

      for (const annotation of annotations) {
        if (intentAny || intentDisplay && annotation.viewable || intentPrint && annotation.printable) {
          annotationsData.push(annotation.data);
        }
      }

      return annotationsData;
    });
  }

  get annotations() {
    const annots = this._getInheritableProperty("Annots");

    return (0, _util.shadow)(this, "annotations", Array.isArray(annots) ? annots : []);
  }

  get _parsedAnnotations() {
    const parsedAnnotations = this.pdfManager.ensure(this, "annotations").then(() => {
      const annotationPromises = [];

      for (const annotationRef of this.annotations) {
        annotationPromises.push(_annotation.AnnotationFactory.create(this.xref, annotationRef, this.pdfManager, this._localIdFactory, false).catch(function (reason) {
          (0, _util.warn)(`_parsedAnnotations: "${reason}".`);
          return null;
        }));
      }

      return Promise.all(annotationPromises).then(function (annotations) {
        return annotations.filter(annotation => !!annotation);
      });
    });
    return (0, _util.shadow)(this, "_parsedAnnotations", parsedAnnotations);
  }

  get jsActions() {
    const actions = (0, _core_utils.collectActions)(this.xref, this.pageDict, _util.PageActionEventType);
    return (0, _util.shadow)(this, "jsActions", actions);
  }

}

exports.Page = Page;
const PDF_HEADER_SIGNATURE = new Uint8Array([0x25, 0x50, 0x44, 0x46, 0x2d]);
const STARTXREF_SIGNATURE = new Uint8Array([0x73, 0x74, 0x61, 0x72, 0x74, 0x78, 0x72, 0x65, 0x66]);
const ENDOBJ_SIGNATURE = new Uint8Array([0x65, 0x6e, 0x64, 0x6f, 0x62, 0x6a]);
const FINGERPRINT_FIRST_BYTES = 1024;
const EMPTY_FINGERPRINT = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
const PDF_HEADER_VERSION_REGEXP = /^[1-9]\.\d$/;

function find(stream, signature, limit = 1024, backwards = false) {
  const signatureLength = signature.length;
  const scanBytes = stream.peekBytes(limit);
  const scanLength = scanBytes.length - signatureLength;

  if (scanLength <= 0) {
    return false;
  }

  if (backwards) {
    const signatureEnd = signatureLength - 1;
    let pos = scanBytes.length - 1;

    while (pos >= signatureEnd) {
      let j = 0;

      while (j < signatureLength && scanBytes[pos - j] === signature[signatureEnd - j]) {
        j++;
      }

      if (j >= signatureLength) {
        stream.pos += pos - signatureEnd;
        return true;
      }

      pos--;
    }
  } else {
    let pos = 0;

    while (pos <= scanLength) {
      let j = 0;

      while (j < signatureLength && scanBytes[pos + j] === signature[j]) {
        j++;
      }

      if (j >= signatureLength) {
        stream.pos += pos;
        return true;
      }

      pos++;
    }
  }

  return false;
}

class PDFDocument {
  constructor(pdfManager, arg) {
    let stream;

    if ((0, _primitives.isStream)(arg)) {
      stream = arg;
    } else if ((0, _util.isArrayBuffer)(arg)) {
      stream = new _stream.Stream(arg);
    } else {
      throw new Error("PDFDocument: Unknown argument type");
    }

    if (stream.length <= 0) {
      throw new _util.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");
    }

    this.pdfManager = pdfManager;
    this.stream = stream;
    this.xref = new _xref.XRef(stream, pdfManager);
    this._pagePromises = new Map();
    this._version = null;
    const idCounters = {
      font: 0
    };
    this._globalIdFactory = class {
      static getDocId() {
        return `g_${pdfManager.docId}`;
      }

      static createFontId() {
        return `f${++idCounters.font}`;
      }

      static createObjId() {
        (0, _util.unreachable)("Abstract method `createObjId` called.");
      }

      static getPageObjId() {
        (0, _util.unreachable)("Abstract method `getPageObjId` called.");
      }

    };
  }

  parse(recoveryMode) {
    this.xref.parse(recoveryMode);
    this.catalog = new _catalog.Catalog(this.pdfManager, this.xref);

    if (this.catalog.version) {
      this._version = this.catalog.version;
    }
  }

  get linearization() {
    let linearization = null;

    try {
      linearization = _parser.Linearization.create(this.stream);
    } catch (err) {
      if (err instanceof _core_utils.MissingDataException) {
        throw err;
      }

      (0, _util.info)(err);
    }

    return (0, _util.shadow)(this, "linearization", linearization);
  }

  get startXRef() {
    const stream = this.stream;
    let startXRef = 0;

    if (this.linearization) {
      stream.reset();

      if (find(stream, ENDOBJ_SIGNATURE)) {
        startXRef = stream.pos + 6 - stream.start;
      }
    } else {
      const step = 1024;
      const startXRefLength = STARTXREF_SIGNATURE.length;
      let found = false,
          pos = stream.end;

      while (!found && pos > 0) {
        pos -= step - startXRefLength;

        if (pos < 0) {
          pos = 0;
        }

        stream.pos = pos;
        found = find(stream, STARTXREF_SIGNATURE, step, true);
      }

      if (found) {
        stream.skip(9);
        let ch;

        do {
          ch = stream.getByte();
        } while ((0, _core_utils.isWhiteSpace)(ch));

        let str = "";

        while (ch >= 0x20 && ch <= 0x39) {
          str += String.fromCharCode(ch);
          ch = stream.getByte();
        }

        startXRef = parseInt(str, 10);

        if (isNaN(startXRef)) {
          startXRef = 0;
        }
      }
    }

    return (0, _util.shadow)(this, "startXRef", startXRef);
  }

  checkHeader() {
    const stream = this.stream;
    stream.reset();

    if (!find(stream, PDF_HEADER_SIGNATURE)) {
      return;
    }

    stream.moveStart();
    const MAX_PDF_VERSION_LENGTH = 12;
    let version = "",
        ch;

    while ((ch = stream.getByte()) > 0x20) {
      if (version.length >= MAX_PDF_VERSION_LENGTH) {
        break;
      }

      version += String.fromCharCode(ch);
    }

    if (!this._version) {
      this._version = version.substring(5);
    }
  }

  parseStartXRef() {
    this.xref.setStartXRef(this.startXRef);
  }

  get numPages() {
    let num = 0;

    if (this.catalog.hasActualNumPages) {
      num = this.catalog.numPages;
    } else if (this.xfaFactory) {
      num = this.xfaFactory.getNumPages();
    } else if (this.linearization) {
      num = this.linearization.numPages;
    } else {
      num = this.catalog.numPages;
    }

    return (0, _util.shadow)(this, "numPages", num);
  }

  _hasOnlyDocumentSignatures(fields, recursionDepth = 0) {
    const RECURSION_LIMIT = 10;

    if (!Array.isArray(fields)) {
      return false;
    }

    return fields.every(field => {
      field = this.xref.fetchIfRef(field);

      if (!(field instanceof _primitives.Dict)) {
        return false;
      }

      if (field.has("Kids")) {
        if (++recursionDepth > RECURSION_LIMIT) {
          (0, _util.warn)("_hasOnlyDocumentSignatures: maximum recursion depth reached");
          return false;
        }

        return this._hasOnlyDocumentSignatures(field.get("Kids"), recursionDepth);
      }

      const isSignature = (0, _primitives.isName)(field.get("FT"), "Sig");
      const rectangle = field.get("Rect");
      const isInvisible = Array.isArray(rectangle) && rectangle.every(value => value === 0);
      return isSignature && isInvisible;
    });
  }

  get xfaData() {
    const acroForm = this.catalog.acroForm;

    if (!acroForm) {
      return null;
    }

    const xfa = acroForm.get("XFA");
    const entries = {
      "xdp:xdp": "",
      template: "",
      datasets: "",
      config: "",
      connectionSet: "",
      localeSet: "",
      stylesheet: "",
      "/xdp:xdp": ""
    };

    if ((0, _primitives.isStream)(xfa) && !xfa.isEmpty) {
      try {
        entries["xdp:xdp"] = (0, _util.stringToUTF8String)(xfa.getString());
        return entries;
      } catch (_) {
        (0, _util.warn)("XFA - Invalid utf-8 string.");
        return null;
      }
    }

    if (!Array.isArray(xfa) || xfa.length === 0) {
      return null;
    }

    for (let i = 0, ii = xfa.length; i < ii; i += 2) {
      let name;

      if (i === 0) {
        name = "xdp:xdp";
      } else if (i === ii - 2) {
        name = "/xdp:xdp";
      } else {
        name = xfa[i];
      }

      if (!entries.hasOwnProperty(name)) {
        continue;
      }

      const data = this.xref.fetchIfRef(xfa[i + 1]);

      if (!(0, _primitives.isStream)(data) || data.isEmpty) {
        continue;
      }

      try {
        entries[name] = (0, _util.stringToUTF8String)(data.getString());
      } catch (_) {
        (0, _util.warn)("XFA - Invalid utf-8 string.");
        return null;
      }
    }

    return entries;
  }

  get xfaFactory() {
    let data;

    if (this.pdfManager.enableXfa && this.catalog.needsRendering && this.formInfo.hasXfa && !this.formInfo.hasAcroForm) {
      data = this.xfaData;
    }

    return (0, _util.shadow)(this, "xfaFactory", data ? new _factory.XFAFactory(data) : null);
  }

  get isPureXfa() {
    return this.xfaFactory ? this.xfaFactory.isValid() : false;
  }

  get htmlForXfa() {
    return this.xfaFactory ? this.xfaFactory.getPages() : null;
  }

  async loadXfaImages() {
    const xfaImagesDict = await this.pdfManager.ensureCatalog("xfaImages");

    if (!xfaImagesDict) {
      return;
    }

    const keys = xfaImagesDict.getKeys();
    const objectLoader = new _object_loader.ObjectLoader(xfaImagesDict, keys, this.xref);
    await objectLoader.load();
    const xfaImages = new Map();

    for (const key of keys) {
      const stream = xfaImagesDict.get(key);

      if (!(0, _primitives.isStream)(stream)) {
        continue;
      }

      xfaImages.set(key, stream.getBytes());
    }

    this.xfaFactory.setImages(xfaImages);
  }

  async loadXfaFonts(handler, task) {
    const acroForm = await this.pdfManager.ensureCatalog("acroForm");

    if (!acroForm) {
      return;
    }

    const resources = await acroForm.getAsync("DR");

    if (!(resources instanceof _primitives.Dict)) {
      return;
    }

    const objectLoader = new _object_loader.ObjectLoader(resources, ["Font"], this.xref);
    await objectLoader.load();
    const fontRes = resources.get("Font");

    if (!(fontRes instanceof _primitives.Dict)) {
      return;
    }

    const options = Object.assign(Object.create(null), this.pdfManager.evaluatorOptions);
    options.useSystemFonts = false;
    const partialEvaluator = new _evaluator.PartialEvaluator({
      xref: this.xref,
      handler,
      pageIndex: -1,
      idFactory: this._globalIdFactory,
      fontCache: this.catalog.fontCache,
      builtInCMapCache: this.catalog.builtInCMapCache,
      standardFontDataCache: this.catalog.standardFontDataCache,
      options
    });
    const operatorList = new _operator_list.OperatorList();
    const pdfFonts = [];
    const initialState = {
      get font() {
        return pdfFonts[pdfFonts.length - 1];
      },

      set font(font) {
        pdfFonts.push(font);
      },

      clone() {
        return this;
      }

    };
    const fonts = new Map();
    fontRes.forEach((fontName, font) => {
      fonts.set(fontName, font);
    });
    const promises = [];

    for (const [fontName, font] of fonts) {
      const descriptor = font.get("FontDescriptor");

      if (!(descriptor instanceof _primitives.Dict)) {
        continue;
      }

      let fontFamily = descriptor.get("FontFamily");
      fontFamily = fontFamily.replace(/[ ]+(\d)/g, "$1");
      const fontWeight = descriptor.get("FontWeight");
      const italicAngle = -descriptor.get("ItalicAngle");
      const cssFontInfo = {
        fontFamily,
        fontWeight,
        italicAngle
      };

      if (!(0, _core_utils.validateCSSFont)(cssFontInfo)) {
        continue;
      }

      promises.push(partialEvaluator.handleSetFont(resources, [_primitives.Name.get(fontName), 1], null, operatorList, task, initialState, null, cssFontInfo).catch(function (reason) {
        (0, _util.warn)(`loadXfaFonts: "${reason}".`);
        return null;
      }));
    }

    await Promise.all(promises);
    const missingFonts = this.xfaFactory.setFonts(pdfFonts);

    if (!missingFonts) {
      return;
    }

    options.ignoreErrors = true;
    promises.length = 0;
    pdfFonts.length = 0;
    const reallyMissingFonts = new Set();

    for (const missing of missingFonts) {
      if (!(0, _xfa_fonts.getXfaFontName)(`${missing}-Regular`)) {
        reallyMissingFonts.add(missing);
      }
    }

    if (reallyMissingFonts.size) {
      missingFonts.push("PdfJS-Fallback");
    }

    for (const missing of missingFonts) {
      if (reallyMissingFonts.has(missing)) {
        continue;
      }

      for (const fontInfo of [{
        name: "Regular",
        fontWeight: 400,
        italicAngle: 0
      }, {
        name: "Bold",
        fontWeight: 700,
        italicAngle: 0
      }, {
        name: "Italic",
        fontWeight: 400,
        italicAngle: 12
      }, {
        name: "BoldItalic",
        fontWeight: 700,
        italicAngle: 12
      }]) {
        const name = `${missing}-${fontInfo.name}`;
        const dict = (0, _xfa_fonts.getXfaFontDict)(name);
        promises.push(partialEvaluator.handleSetFont(resources, [_primitives.Name.get(name), 1], null, operatorList, task, initialState, dict, {
          fontFamily: missing,
          fontWeight: fontInfo.fontWeight,
          italicAngle: fontInfo.italicAngle
        }).catch(function (reason) {
          (0, _util.warn)(`loadXfaFonts: "${reason}".`);
          return null;
        }));
      }
    }

    await Promise.all(promises);
    this.xfaFactory.appendFonts(pdfFonts, reallyMissingFonts);
  }

  async serializeXfaData(annotationStorage) {
    return this.xfaFactory ? this.xfaFactory.serializeData(annotationStorage) : null;
  }

  get formInfo() {
    const formInfo = {
      hasFields: false,
      hasAcroForm: false,
      hasXfa: false,
      hasSignatures: false
    };
    const acroForm = this.catalog.acroForm;

    if (!acroForm) {
      return (0, _util.shadow)(this, "formInfo", formInfo);
    }

    try {
      const fields = acroForm.get("Fields");
      const hasFields = Array.isArray(fields) && fields.length > 0;
      formInfo.hasFields = hasFields;
      const xfa = acroForm.get("XFA");
      formInfo.hasXfa = Array.isArray(xfa) && xfa.length > 0 || (0, _primitives.isStream)(xfa) && !xfa.isEmpty;
      const sigFlags = acroForm.get("SigFlags");
      const hasSignatures = !!(sigFlags & 0x1);

      const hasOnlyDocumentSignatures = hasSignatures && this._hasOnlyDocumentSignatures(fields);

      formInfo.hasAcroForm = hasFields && !hasOnlyDocumentSignatures;
      formInfo.hasSignatures = hasSignatures;
    } catch (ex) {
      if (ex instanceof _core_utils.MissingDataException) {
        throw ex;
      }

      (0, _util.warn)(`Cannot fetch form information: "${ex}".`);
    }

    return (0, _util.shadow)(this, "formInfo", formInfo);
  }

  get documentInfo() {
    const DocumentInfoValidators = {
      Title: _util.isString,
      Author: _util.isString,
      Subject: _util.isString,
      Keywords: _util.isString,
      Creator: _util.isString,
      Producer: _util.isString,
      CreationDate: _util.isString,
      ModDate: _util.isString,
      Trapped: _primitives.isName
    };
    let version = this._version;

    if (typeof version !== "string" || !PDF_HEADER_VERSION_REGEXP.test(version)) {
      (0, _util.warn)(`Invalid PDF header version number: ${version}`);
      version = null;
    }

    const docInfo = {
      PDFFormatVersion: version,
      Language: this.catalog.lang,
      EncryptFilterName: this.xref.encrypt ? this.xref.encrypt.filterName : null,
      IsLinearized: !!this.linearization,
      IsAcroFormPresent: this.formInfo.hasAcroForm,
      IsXFAPresent: this.formInfo.hasXfa,
      IsCollectionPresent: !!this.catalog.collection,
      IsSignaturesPresent: this.formInfo.hasSignatures
    };
    let infoDict;

    try {
      infoDict = this.xref.trailer.get("Info");
    } catch (err) {
      if (err instanceof _core_utils.MissingDataException) {
        throw err;
      }

      (0, _util.info)("The document information dictionary is invalid.");
    }

    if ((0, _primitives.isDict)(infoDict)) {
      for (const key of infoDict.getKeys()) {
        const value = infoDict.get(key);

        if (DocumentInfoValidators[key]) {
          if (DocumentInfoValidators[key](value)) {
            docInfo[key] = typeof value !== "string" ? value : (0, _util.stringToPDFString)(value);
          } else {
            (0, _util.info)(`Bad value in document info for "${key}".`);
          }
        } else if (typeof key === "string") {
          let customValue;

          if ((0, _util.isString)(value)) {
            customValue = (0, _util.stringToPDFString)(value);
          } else if ((0, _primitives.isName)(value) || (0, _util.isNum)(value) || (0, _util.isBool)(value)) {
            customValue = value;
          } else {
            (0, _util.info)(`Unsupported value in document info for (custom) "${key}".`);
            continue;
          }

          if (!docInfo.Custom) {
            docInfo.Custom = Object.create(null);
          }

          docInfo.Custom[key] = customValue;
        }
      }
    }

    return (0, _util.shadow)(this, "documentInfo", docInfo);
  }

  get fingerprints() {
    function validate(data) {
      return typeof data === "string" && data.length > 0 && data !== EMPTY_FINGERPRINT;
    }

    function hexString(hash) {
      const buf = [];

      for (let i = 0, ii = hash.length; i < ii; i++) {
        const hex = hash[i].toString(16);
        buf.push(hex.padStart(2, "0"));
      }

      return buf.join("");
    }

    const idArray = this.xref.trailer.get("ID");
    let hashOriginal, hashModified;

    if (Array.isArray(idArray) && validate(idArray[0])) {
      hashOriginal = (0, _util.stringToBytes)(idArray[0]);

      if (idArray[1] !== idArray[0] && validate(idArray[1])) {
        hashModified = (0, _util.stringToBytes)(idArray[1]);
      }
    } else {
      hashOriginal = (0, _crypto.calculateMD5)(this.stream.getByteRange(0, FINGERPRINT_FIRST_BYTES), 0, FINGERPRINT_FIRST_BYTES);
    }

    return (0, _util.shadow)(this, "fingerprints", [hexString(hashOriginal), hashModified ? hexString(hashModified) : null]);
  }

  async _getLinearizationPage(pageIndex) {
    const {
      catalog,
      linearization
    } = this;

    const ref = _primitives.Ref.get(linearization.objectNumberFirst, 0);

    try {
      const obj = await this.xref.fetchAsync(ref);

      if ((0, _primitives.isDict)(obj, "Page") || (0, _primitives.isDict)(obj) && !obj.has("Type") && obj.has("Contents")) {
        if (ref && !catalog.pageKidsCountCache.has(ref)) {
          catalog.pageKidsCountCache.put(ref, 1);
        }

        return [obj, ref];
      }

      throw new _util.FormatError("The Linearization dictionary doesn't point to a valid Page dictionary.");
    } catch (reason) {
      (0, _util.info)(reason);
      return catalog.getPageDict(pageIndex);
    }
  }

  getPage(pageIndex) {
    const cachedPromise = this._pagePromises.get(pageIndex);

    if (cachedPromise) {
      return cachedPromise;
    }

    const {
      catalog,
      linearization,
      xfaFactory
    } = this;
    let promise;

    if (xfaFactory) {
      promise = Promise.resolve([_primitives.Dict.empty, null]);
    } else if (linearization && linearization.pageFirst === pageIndex) {
      promise = this._getLinearizationPage(pageIndex);
    } else {
      promise = catalog.getPageDict(pageIndex);
    }

    promise = promise.then(([pageDict, ref]) => {
      return new Page({
        pdfManager: this.pdfManager,
        xref: this.xref,
        pageIndex,
        pageDict,
        ref,
        globalIdFactory: this._globalIdFactory,
        fontCache: catalog.fontCache,
        builtInCMapCache: catalog.builtInCMapCache,
        standardFontDataCache: catalog.standardFontDataCache,
        globalImageCache: catalog.globalImageCache,
        nonBlendModesSet: catalog.nonBlendModesSet,
        xfaFactory
      });
    });

    this._pagePromises.set(pageIndex, promise);

    return promise;
  }

  async checkFirstPage(recoveryMode = false) {
    if (recoveryMode) {
      return;
    }

    try {
      await this.getPage(0);
    } catch (reason) {
      if (reason instanceof _core_utils.XRefEntryException) {
        this._pagePromises.delete(0);

        await this.cleanup();
        throw new _core_utils.XRefParseException();
      }
    }
  }

  async checkLastPage(recoveryMode = false) {
    const {
      catalog,
      pdfManager
    } = this;
    catalog.setActualNumPages();
    let numPages;

    try {
      await Promise.all([pdfManager.ensureDoc("xfaFactory"), pdfManager.ensureDoc("linearization"), pdfManager.ensureCatalog("numPages")]);

      if (this.xfaFactory) {
        return;
      } else if (this.linearization) {
        numPages = this.linearization.numPages;
      } else {
        numPages = catalog.numPages;
      }

      if (!Number.isInteger(numPages)) {
        throw new _util.FormatError("Page count is not an integer.");
      } else if (numPages <= 1) {
        return;
      }

      await this.getPage(numPages - 1);
    } catch (reason) {
      this._pagePromises.delete(numPages - 1);

      await this.cleanup();

      if (reason instanceof _core_utils.XRefEntryException && !recoveryMode) {
        throw new _core_utils.XRefParseException();
      }

      (0, _util.warn)(`checkLastPage - invalid /Pages tree /Count: ${numPages}.`);
      let pagesTree;

      try {
        pagesTree = await pdfManager.ensureCatalog("getAllPageDicts", [recoveryMode]);
      } catch (reasonAll) {
        if (reasonAll instanceof _core_utils.XRefEntryException && !recoveryMode) {
          throw new _core_utils.XRefParseException();
        }

        catalog.setActualNumPages(1);
        return;
      }

      for (const [pageIndex, [pageDict, ref]] of pagesTree) {
        let promise;

        if (pageDict instanceof Error) {
          promise = Promise.reject(pageDict);
          promise.catch(() => {});
        } else {
          promise = Promise.resolve(new Page({
            pdfManager,
            xref: this.xref,
            pageIndex,
            pageDict,
            ref,
            globalIdFactory: this._globalIdFactory,
            fontCache: catalog.fontCache,
            builtInCMapCache: catalog.builtInCMapCache,
            standardFontDataCache: catalog.standardFontDataCache,
            globalImageCache: catalog.globalImageCache,
            nonBlendModesSet: catalog.nonBlendModesSet,
            xfaFactory: null
          }));
        }

        this._pagePromises.set(pageIndex, promise);
      }

      catalog.setActualNumPages(pagesTree.size);
    }
  }

  fontFallback(id, handler) {
    return this.catalog.fontFallback(id, handler);
  }

  async cleanup(manuallyTriggered = false) {
    return this.catalog ? this.catalog.cleanup(manuallyTriggered) : (0, _primitives.clearPrimitiveCaches)();
  }

  _collectFieldObjects(name, fieldRef, promises) {
    const field = this.xref.fetchIfRef(fieldRef);

    if (field.has("T")) {
      const partName = (0, _util.stringToPDFString)(field.get("T"));

      if (name === "") {
        name = partName;
      } else {
        name = `${name}.${partName}`;
      }
    }

    if (!promises.has(name)) {
      promises.set(name, []);
    }

    promises.get(name).push(_annotation.AnnotationFactory.create(this.xref, fieldRef, this.pdfManager, this._localIdFactory, true).then(annotation => annotation && annotation.getFieldObject()).catch(function (reason) {
      (0, _util.warn)(`_collectFieldObjects: "${reason}".`);
      return null;
    }));

    if (field.has("Kids")) {
      const kids = field.get("Kids");

      for (const kid of kids) {
        this._collectFieldObjects(name, kid, promises);
      }
    }
  }

  get fieldObjects() {
    if (!this.formInfo.hasFields) {
      return (0, _util.shadow)(this, "fieldObjects", Promise.resolve(null));
    }

    const allFields = Object.create(null);
    const fieldPromises = new Map();

    for (const fieldRef of this.catalog.acroForm.get("Fields")) {
      this._collectFieldObjects("", fieldRef, fieldPromises);
    }

    const allPromises = [];

    for (const [name, promises] of fieldPromises) {
      allPromises.push(Promise.all(promises).then(fields => {
        fields = fields.filter(field => !!field);

        if (fields.length > 0) {
          allFields[name] = fields;
        }
      }));
    }

    return (0, _util.shadow)(this, "fieldObjects", Promise.all(allPromises).then(() => allFields));
  }

  get hasJSActions() {
    const promise = this.pdfManager.ensureDoc("_parseHasJSActions");
    return (0, _util.shadow)(this, "hasJSActions", promise);
  }

  async _parseHasJSActions() {
    const [catalogJsActions, fieldObjects] = await Promise.all([this.pdfManager.ensureCatalog("jsActions"), this.pdfManager.ensureDoc("fieldObjects")]);

    if (catalogJsActions) {
      return true;
    }

    if (fieldObjects) {
      return Object.values(fieldObjects).some(fieldObject => fieldObject.some(object => object.actions !== null));
    }

    return false;
  }

  get calculationOrderIds() {
    const acroForm = this.catalog.acroForm;

    if (!acroForm || !acroForm.has("CO")) {
      return (0, _util.shadow)(this, "calculationOrderIds", null);
    }

    const calculationOrder = acroForm.get("CO");

    if (!Array.isArray(calculationOrder) || calculationOrder.length === 0) {
      return (0, _util.shadow)(this, "calculationOrderIds", null);
    }

    const ids = calculationOrder.filter(_primitives.isRef).map(ref => ref.toString());

    if (ids.length === 0) {
      return (0, _util.shadow)(this, "calculationOrderIds", null);
    }

    return (0, _util.shadow)(this, "calculationOrderIds", ids);
  }

}

exports.PDFDocument = PDFDocument;

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getXfaFontDict = getXfaFontDict;
exports.getXfaFontName = getXfaFontName;

var _calibri_factors = __w_pdfjs_require__(13);

var _primitives = __w_pdfjs_require__(5);

var _helvetica_factors = __w_pdfjs_require__(14);

var _liberationsans_widths = __w_pdfjs_require__(15);

var _myriadpro_factors = __w_pdfjs_require__(16);

var _segoeui_factors = __w_pdfjs_require__(17);

var _core_utils = __w_pdfjs_require__(9);

var _fonts_utils = __w_pdfjs_require__(18);

const getXFAFontMap = (0, _core_utils.getLookupTableFactory)(function (t) {
  t["MyriadPro-Regular"] = t["PdfJS-Fallback-Regular"] = {
    name: "LiberationSans-Regular",
    factors: _myriadpro_factors.MyriadProRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _myriadpro_factors.MyriadProRegularMetrics
  };
  t["MyriadPro-Bold"] = t["PdfJS-Fallback-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _myriadpro_factors.MyriadProBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _myriadpro_factors.MyriadProBoldMetrics
  };
  t["MyriadPro-It"] = t["MyriadPro-Italic"] = t["PdfJS-Fallback-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _myriadpro_factors.MyriadProItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _myriadpro_factors.MyriadProItalicMetrics
  };
  t["MyriadPro-BoldIt"] = t["MyriadPro-BoldItalic"] = t["PdfJS-Fallback-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _myriadpro_factors.MyriadProBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _myriadpro_factors.MyriadProBoldItalicMetrics
  };
  t.ArialMT = t.Arial = t["Arial-Regular"] = {
    name: "LiberationSans-Regular",
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping
  };
  t["Arial-BoldMT"] = t["Arial-Bold"] = {
    name: "LiberationSans-Bold",
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping
  };
  t["Arial-ItalicMT"] = t["Arial-Italic"] = {
    name: "LiberationSans-Italic",
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping
  };
  t["Arial-BoldItalicMT"] = t["Arial-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping
  };
  t["Calibri-Regular"] = {
    name: "LiberationSans-Regular",
    factors: _calibri_factors.CalibriRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _calibri_factors.CalibriRegularMetrics
  };
  t["Calibri-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _calibri_factors.CalibriBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _calibri_factors.CalibriBoldMetrics
  };
  t["Calibri-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _calibri_factors.CalibriItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _calibri_factors.CalibriItalicMetrics
  };
  t["Calibri-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _calibri_factors.CalibriBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _calibri_factors.CalibriBoldItalicMetrics
  };
  t["Segoeui-Regular"] = {
    name: "LiberationSans-Regular",
    factors: _segoeui_factors.SegoeuiRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _segoeui_factors.SegoeuiRegularMetrics
  };
  t["Segoeui-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _segoeui_factors.SegoeuiBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _segoeui_factors.SegoeuiBoldMetrics
  };
  t["Segoeui-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _segoeui_factors.SegoeuiItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _segoeui_factors.SegoeuiItalicMetrics
  };
  t["Segoeui-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _segoeui_factors.SegoeuiBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _segoeui_factors.SegoeuiBoldItalicMetrics
  };
  t["Helvetica-Regular"] = t.Helvetica = {
    name: "LiberationSans-Regular",
    factors: _helvetica_factors.HelveticaRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _helvetica_factors.HelveticaRegularMetrics
  };
  t["Helvetica-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _helvetica_factors.HelveticaBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _helvetica_factors.HelveticaBoldMetrics
  };
  t["Helvetica-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _helvetica_factors.HelveticaItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _helvetica_factors.HelveticaItalicMetrics
  };
  t["Helvetica-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _helvetica_factors.HelveticaBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _helvetica_factors.HelveticaBoldItalicMetrics
  };
});

function getXfaFontName(name) {
  const fontName = (0, _fonts_utils.normalizeFontName)(name);
  const fontMap = getXFAFontMap();
  return fontMap[fontName];
}

function getXfaFontWidths(name) {
  const info = getXfaFontName(name);

  if (!info) {
    return null;
  }

  const {
    baseWidths,
    baseMapping,
    factors
  } = info;
  let rescaledBaseWidths;

  if (!factors) {
    rescaledBaseWidths = baseWidths;
  } else {
    rescaledBaseWidths = baseWidths.map((w, i) => w * factors[i]);
  }

  let currentCode = -2;
  let currentArray;
  const newWidths = [];

  for (const [unicode, glyphIndex] of baseMapping.map((charUnicode, index) => [charUnicode, index]).sort(([unicode1], [unicode2]) => unicode1 - unicode2)) {
    if (unicode === -1) {
      continue;
    }

    if (unicode === currentCode + 1) {
      currentArray.push(rescaledBaseWidths[glyphIndex]);
      currentCode += 1;
    } else {
      currentCode = unicode;
      currentArray = [rescaledBaseWidths[glyphIndex]];
      newWidths.push(unicode, currentArray);
    }
  }

  return newWidths;
}

function getXfaFontDict(name) {
  const widths = getXfaFontWidths(name);
  const dict = new _primitives.Dict(null);
  dict.set("BaseFont", _primitives.Name.get(name));
  dict.set("Type", _primitives.Name.get("Font"));
  dict.set("Subtype", _primitives.Name.get("CIDFontType2"));
  dict.set("Encoding", _primitives.Name.get("Identity-H"));
  dict.set("CIDToGIDMap", _primitives.Name.get("Identity"));
  dict.set("W", widths);
  dict.set("FirstChar", widths[0]);
  dict.set("LastChar", widths[widths.length - 2] + widths[widths.length - 1].length - 1);
  const descriptor = new _primitives.Dict(null);
  dict.set("FontDescriptor", descriptor);
  const systemInfo = new _primitives.Dict(null);
  systemInfo.set("Ordering", "Identity");
  systemInfo.set("Registry", "Adobe");
  systemInfo.set("Supplement", 0);
  dict.set("CIDSystemInfo", systemInfo);
  return dict;
}

/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CalibriRegularMetrics = exports.CalibriRegularFactors = exports.CalibriItalicMetrics = exports.CalibriItalicFactors = exports.CalibriBoldMetrics = exports.CalibriBoldItalicMetrics = exports.CalibriBoldItalicFactors = exports.CalibriBoldFactors = void 0;
const CalibriBoldFactors = [1.3877, 1, 1, 1, 0.97801, 0.92482, 0.89552, 0.91133, 0.81988, 0.97566, 0.98152, 0.93548, 0.93548, 1.2798, 0.85284, 0.92794, 1, 0.96134, 1.54657, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.82845, 0.82845, 0.85284, 0.85284, 0.85284, 0.75859, 0.92138, 0.83908, 0.7762, 0.73293, 0.87289, 0.73133, 0.7514, 0.81921, 0.87356, 0.95958, 0.59526, 0.75727, 0.69225, 1.04924, 0.9121, 0.86943, 0.79795, 0.88198, 0.77958, 0.70864, 0.81055, 0.90399, 0.88653, 0.96017, 0.82577, 0.77892, 0.78257, 0.97507, 1.54657, 0.97507, 0.85284, 0.89552, 0.90176, 0.88762, 0.8785, 0.75241, 0.8785, 0.90518, 0.95015, 0.77618, 0.8785, 0.88401, 0.91916, 0.86304, 0.88401, 0.91488, 0.8785, 0.8801, 0.8785, 0.8785, 0.91343, 0.7173, 1.04106, 0.8785, 0.85075, 0.95794, 0.82616, 0.85162, 0.79492, 0.88331, 1.69808, 0.88331, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.7801, 0.89552, 1.24487, 1.13254, 1.12401, 0.96839, 0.85284, 0.68787, 0.70645, 0.85592, 0.90747, 1.01466, 1.0088, 0.90323, 1, 1.07463, 1, 0.91056, 0.75806, 1.19118, 0.96839, 0.78864, 0.82845, 0.84133, 0.75859, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.77539, 0.73293, 0.73133, 0.73133, 0.73133, 0.73133, 0.95958, 0.95958, 0.95958, 0.95958, 0.88506, 0.9121, 0.86943, 0.86943, 0.86943, 0.86943, 0.86943, 0.85284, 0.87508, 0.90399, 0.90399, 0.90399, 0.90399, 0.77892, 0.79795, 0.90807, 0.88762, 0.88762, 0.88762, 0.88762, 0.88762, 0.88762, 0.8715, 0.75241, 0.90518, 0.90518, 0.90518, 0.90518, 0.88401, 0.88401, 0.88401, 0.88401, 0.8785, 0.8785, 0.8801, 0.8801, 0.8801, 0.8801, 0.8801, 0.90747, 0.89049, 0.8785, 0.8785, 0.8785, 0.8785, 0.85162, 0.8785, 0.85162, 0.83908, 0.88762, 0.83908, 0.88762, 0.83908, 0.88762, 0.73293, 0.75241, 0.73293, 0.75241, 0.73293, 0.75241, 0.73293, 0.75241, 0.87289, 0.83016, 0.88506, 0.93125, 0.73133, 0.90518, 0.73133, 0.90518, 0.73133, 0.90518, 0.73133, 0.90518, 0.73133, 0.90518, 0.81921, 0.77618, 0.81921, 0.77618, 0.81921, 0.77618, 1, 1, 0.87356, 0.8785, 0.91075, 0.89608, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.76229, 0.90167, 0.59526, 0.91916, 1, 1, 0.86304, 0.69225, 0.88401, 1, 1, 0.70424, 0.79468, 0.91926, 0.88175, 0.70823, 0.94903, 0.9121, 0.8785, 1, 1, 0.9121, 0.8785, 0.87802, 0.88656, 0.8785, 0.86943, 0.8801, 0.86943, 0.8801, 0.86943, 0.8801, 0.87402, 0.89291, 0.77958, 0.91343, 1, 1, 0.77958, 0.91343, 0.70864, 0.7173, 0.70864, 0.7173, 0.70864, 0.7173, 0.70864, 0.7173, 1, 1, 0.81055, 0.75841, 0.81055, 1.06452, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.96017, 0.95794, 0.77892, 0.85162, 0.77892, 0.78257, 0.79492, 0.78257, 0.79492, 0.78257, 0.79492, 0.9297, 0.56892, 0.83908, 0.88762, 0.77539, 0.8715, 0.87508, 0.89049, 1, 1, 0.81055, 1.04106, 1.20528, 1.20528, 1, 1.15543, 0.70674, 0.98387, 0.94721, 1.33431, 1.45894, 0.95161, 1.06303, 0.83908, 0.80352, 0.57184, 0.6965, 0.56289, 0.82001, 0.56029, 0.81235, 1.02988, 0.83908, 0.7762, 0.68156, 0.80367, 0.73133, 0.78257, 0.87356, 0.86943, 0.95958, 0.75727, 0.89019, 1.04924, 0.9121, 0.7648, 0.86943, 0.87356, 0.79795, 0.78275, 0.81055, 0.77892, 0.9762, 0.82577, 0.99819, 0.84896, 0.95958, 0.77892, 0.96108, 1.01407, 0.89049, 1.02988, 0.94211, 0.96108, 0.8936, 0.84021, 0.87842, 0.96399, 0.79109, 0.89049, 1.00813, 1.02988, 0.86077, 0.87445, 0.92099, 0.84723, 0.86513, 0.8801, 0.75638, 0.85714, 0.78216, 0.79586, 0.87965, 0.94211, 0.97747, 0.78287, 0.97926, 0.84971, 1.02988, 0.94211, 0.8801, 0.94211, 0.84971, 0.73133, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90264, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90518, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90548, 1, 1, 1, 1, 1, 1, 0.96017, 0.95794, 0.96017, 0.95794, 0.96017, 0.95794, 0.77892, 0.85162, 1, 1, 0.89552, 0.90527, 1, 0.90363, 0.92794, 0.92794, 0.92794, 0.92794, 0.87012, 0.87012, 0.87012, 0.89552, 0.89552, 1.42259, 0.71143, 1.06152, 1, 1, 1.03372, 1.03372, 0.97171, 1.4956, 2.2807, 0.93835, 0.83406, 0.91133, 0.84107, 0.91133, 1, 1, 1, 0.72021, 1, 1.23108, 0.83489, 0.88525, 0.88525, 0.81499, 0.90527, 1.81055, 0.90527, 1.81055, 1.31006, 1.53711, 0.94434, 1.08696, 1, 0.95018, 0.77192, 0.85284, 0.90747, 1.17534, 0.69825, 0.9716, 1.37077, 0.90747, 0.90747, 0.85356, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.08004, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90727, 0.90727, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriBoldFactors = CalibriBoldFactors;
const CalibriBoldMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriBoldMetrics = CalibriBoldMetrics;
const CalibriBoldItalicFactors = [1.3877, 1, 1, 1, 0.97801, 0.92482, 0.89552, 0.91133, 0.81988, 0.97566, 0.98152, 0.93548, 0.93548, 1.2798, 0.85284, 0.92794, 1, 0.96134, 1.56239, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.82845, 0.82845, 0.85284, 0.85284, 0.85284, 0.75859, 0.92138, 0.83908, 0.7762, 0.71805, 0.87289, 0.73133, 0.7514, 0.81921, 0.87356, 0.95958, 0.59526, 0.75727, 0.69225, 1.04924, 0.90872, 0.85938, 0.79795, 0.87068, 0.77958, 0.69766, 0.81055, 0.90399, 0.88653, 0.96068, 0.82577, 0.77892, 0.78257, 0.97507, 1.529, 0.97507, 0.85284, 0.89552, 0.90176, 0.94908, 0.86411, 0.74012, 0.86411, 0.88323, 0.95015, 0.86411, 0.86331, 0.88401, 0.91916, 0.86304, 0.88401, 0.9039, 0.86331, 0.86331, 0.86411, 0.86411, 0.90464, 0.70852, 1.04106, 0.86331, 0.84372, 0.95794, 0.82616, 0.84548, 0.79492, 0.88331, 1.69808, 0.88331, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.7801, 0.89552, 1.24487, 1.13254, 1.19129, 0.96839, 0.85284, 0.68787, 0.70645, 0.85592, 0.90747, 1.01466, 1.0088, 0.90323, 1, 1.07463, 1, 0.91056, 0.75806, 1.19118, 0.96839, 0.78864, 0.82845, 0.84133, 0.75859, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.77539, 0.71805, 0.73133, 0.73133, 0.73133, 0.73133, 0.95958, 0.95958, 0.95958, 0.95958, 0.88506, 0.90872, 0.85938, 0.85938, 0.85938, 0.85938, 0.85938, 0.85284, 0.87068, 0.90399, 0.90399, 0.90399, 0.90399, 0.77892, 0.79795, 0.90807, 0.94908, 0.94908, 0.94908, 0.94908, 0.94908, 0.94908, 0.85887, 0.74012, 0.88323, 0.88323, 0.88323, 0.88323, 0.88401, 0.88401, 0.88401, 0.88401, 0.8785, 0.86331, 0.86331, 0.86331, 0.86331, 0.86331, 0.86331, 0.90747, 0.89049, 0.86331, 0.86331, 0.86331, 0.86331, 0.84548, 0.86411, 0.84548, 0.83908, 0.94908, 0.83908, 0.94908, 0.83908, 0.94908, 0.71805, 0.74012, 0.71805, 0.74012, 0.71805, 0.74012, 0.71805, 0.74012, 0.87289, 0.79538, 0.88506, 0.92726, 0.73133, 0.88323, 0.73133, 0.88323, 0.73133, 0.88323, 0.73133, 0.88323, 0.73133, 0.88323, 0.81921, 0.86411, 0.81921, 0.86411, 0.81921, 0.86411, 1, 1, 0.87356, 0.86331, 0.91075, 0.8777, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.76467, 0.90167, 0.59526, 0.91916, 1, 1, 0.86304, 0.69225, 0.88401, 1, 1, 0.70424, 0.77312, 0.91926, 0.88175, 0.70823, 0.94903, 0.90872, 0.86331, 1, 1, 0.90872, 0.86331, 0.86906, 0.88116, 0.86331, 0.85938, 0.86331, 0.85938, 0.86331, 0.85938, 0.86331, 0.87402, 0.86549, 0.77958, 0.90464, 1, 1, 0.77958, 0.90464, 0.69766, 0.70852, 0.69766, 0.70852, 0.69766, 0.70852, 0.69766, 0.70852, 1, 1, 0.81055, 0.75841, 0.81055, 1.06452, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.96068, 0.95794, 0.77892, 0.84548, 0.77892, 0.78257, 0.79492, 0.78257, 0.79492, 0.78257, 0.79492, 0.9297, 0.56892, 0.83908, 0.94908, 0.77539, 0.85887, 0.87068, 0.89049, 1, 1, 0.81055, 1.04106, 1.20528, 1.20528, 1, 1.15543, 0.70088, 0.98387, 0.94721, 1.33431, 1.45894, 0.95161, 1.48387, 0.83908, 0.80352, 0.57118, 0.6965, 0.56347, 0.79179, 0.55853, 0.80346, 1.02988, 0.83908, 0.7762, 0.67174, 0.86036, 0.73133, 0.78257, 0.87356, 0.86441, 0.95958, 0.75727, 0.89019, 1.04924, 0.90872, 0.74889, 0.85938, 0.87891, 0.79795, 0.7957, 0.81055, 0.77892, 0.97447, 0.82577, 0.97466, 0.87179, 0.95958, 0.77892, 0.94252, 0.95612, 0.8753, 1.02988, 0.92733, 0.94252, 0.87411, 0.84021, 0.8728, 0.95612, 0.74081, 0.8753, 1.02189, 1.02988, 0.84814, 0.87445, 0.91822, 0.84723, 0.85668, 0.86331, 0.81344, 0.87581, 0.76422, 0.82046, 0.96057, 0.92733, 0.99375, 0.78022, 0.95452, 0.86015, 1.02988, 0.92733, 0.86331, 0.92733, 0.86015, 0.73133, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90631, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.88323, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.85174, 1, 1, 1, 1, 1, 1, 0.96068, 0.95794, 0.96068, 0.95794, 0.96068, 0.95794, 0.77892, 0.84548, 1, 1, 0.89552, 0.90527, 1, 0.90363, 0.92794, 0.92794, 0.92794, 0.89807, 0.87012, 0.87012, 0.87012, 0.89552, 0.89552, 1.42259, 0.71094, 1.06152, 1, 1, 1.03372, 1.03372, 0.97171, 1.4956, 2.2807, 0.92972, 0.83406, 0.91133, 0.83326, 0.91133, 1, 1, 1, 0.72021, 1, 1.23108, 0.83489, 0.88525, 0.88525, 0.81499, 0.90616, 1.81055, 0.90527, 1.81055, 1.3107, 1.53711, 0.94434, 1.08696, 1, 0.95018, 0.77192, 0.85284, 0.90747, 1.17534, 0.69825, 0.9716, 1.37077, 0.90747, 0.90747, 0.85356, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.08004, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90727, 0.90727, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriBoldItalicFactors = CalibriBoldItalicFactors;
const CalibriBoldItalicMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriBoldItalicMetrics = CalibriBoldItalicMetrics;
const CalibriItalicFactors = [1.3877, 1, 1, 1, 1.17223, 1.1293, 0.89552, 0.91133, 0.80395, 1.02269, 1.15601, 0.91056, 0.91056, 1.2798, 0.85284, 0.89807, 1, 0.90861, 1.39543, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.96309, 0.96309, 0.85284, 0.85284, 0.85284, 0.83319, 0.88071, 0.8675, 0.81552, 0.72346, 0.85193, 0.73206, 0.7522, 0.81105, 0.86275, 0.90685, 0.6377, 0.77892, 0.75593, 1.02638, 0.89249, 0.84118, 0.77452, 0.85374, 0.75186, 0.67789, 0.79776, 0.88844, 0.85066, 0.94309, 0.77818, 0.7306, 0.76659, 1.10369, 1.38313, 1.10369, 1.06139, 0.89552, 0.8739, 0.9245, 0.9245, 0.83203, 0.9245, 0.85865, 1.09842, 0.9245, 0.9245, 1.03297, 1.07692, 0.90918, 1.03297, 0.94959, 0.9245, 0.92274, 0.9245, 0.9245, 1.02933, 0.77832, 1.20562, 0.9245, 0.8916, 0.98986, 0.86621, 0.89453, 0.79004, 0.94152, 1.77256, 0.94152, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.91729, 0.89552, 1.17889, 1.13254, 1.16359, 0.92098, 0.85284, 0.68787, 0.71353, 0.84737, 0.90747, 1.0088, 1.0044, 0.87683, 1, 1.09091, 1, 0.92229, 0.739, 1.15642, 0.92098, 0.76288, 0.80504, 0.80972, 0.75859, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.76318, 0.72346, 0.73206, 0.73206, 0.73206, 0.73206, 0.90685, 0.90685, 0.90685, 0.90685, 0.86477, 0.89249, 0.84118, 0.84118, 0.84118, 0.84118, 0.84118, 0.85284, 0.84557, 0.88844, 0.88844, 0.88844, 0.88844, 0.7306, 0.77452, 0.86331, 0.9245, 0.9245, 0.9245, 0.9245, 0.9245, 0.9245, 0.84843, 0.83203, 0.85865, 0.85865, 0.85865, 0.85865, 0.82601, 0.82601, 0.82601, 0.82601, 0.94469, 0.9245, 0.92274, 0.92274, 0.92274, 0.92274, 0.92274, 0.90747, 0.86651, 0.9245, 0.9245, 0.9245, 0.9245, 0.89453, 0.9245, 0.89453, 0.8675, 0.9245, 0.8675, 0.9245, 0.8675, 0.9245, 0.72346, 0.83203, 0.72346, 0.83203, 0.72346, 0.83203, 0.72346, 0.83203, 0.85193, 0.8875, 0.86477, 0.99034, 0.73206, 0.85865, 0.73206, 0.85865, 0.73206, 0.85865, 0.73206, 0.85865, 0.73206, 0.85865, 0.81105, 0.9245, 0.81105, 0.9245, 0.81105, 0.9245, 1, 1, 0.86275, 0.9245, 0.90872, 0.93591, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 1.03297, 0.90685, 0.82601, 0.77896, 1.05611, 0.6377, 1.07692, 1, 1, 0.90918, 0.75593, 1.03297, 1, 1, 0.76032, 0.9375, 0.98156, 0.93407, 0.77261, 1.11429, 0.89249, 0.9245, 1, 1, 0.89249, 0.9245, 0.92534, 0.86698, 0.9245, 0.84118, 0.92274, 0.84118, 0.92274, 0.84118, 0.92274, 0.8667, 0.86291, 0.75186, 1.02933, 1, 1, 0.75186, 1.02933, 0.67789, 0.77832, 0.67789, 0.77832, 0.67789, 0.77832, 0.67789, 0.77832, 1, 1, 0.79776, 0.97655, 0.79776, 1.23023, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.94309, 0.98986, 0.7306, 0.89453, 0.7306, 0.76659, 0.79004, 0.76659, 0.79004, 0.76659, 0.79004, 1.09231, 0.54873, 0.8675, 0.9245, 0.76318, 0.84843, 0.84557, 0.86651, 1, 1, 0.79776, 1.20562, 1.18622, 1.18622, 1, 1.1437, 0.67009, 0.96334, 0.93695, 1.35191, 1.40909, 0.95161, 1.48387, 0.8675, 0.90861, 0.6192, 0.7363, 0.64824, 0.82411, 0.56321, 0.85696, 1.23516, 0.8675, 0.81552, 0.7286, 0.84134, 0.73206, 0.76659, 0.86275, 0.84369, 0.90685, 0.77892, 0.85871, 1.02638, 0.89249, 0.75828, 0.84118, 0.85984, 0.77452, 0.76466, 0.79776, 0.7306, 0.90782, 0.77818, 0.903, 0.87291, 0.90685, 0.7306, 0.99058, 1.03667, 0.94635, 1.23516, 0.9849, 0.99058, 0.92393, 0.8916, 0.942, 1.03667, 0.75026, 0.94635, 1.0297, 1.23516, 0.90918, 0.94048, 0.98217, 0.89746, 0.84153, 0.92274, 0.82507, 0.88832, 0.84438, 0.88178, 1.03525, 0.9849, 1.00225, 0.78086, 0.97248, 0.89404, 1.23516, 0.9849, 0.92274, 0.9849, 0.89404, 0.73206, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.89693, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.85865, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90933, 1, 1, 1, 1, 1, 1, 0.94309, 0.98986, 0.94309, 0.98986, 0.94309, 0.98986, 0.7306, 0.89453, 1, 1, 0.89552, 0.90527, 1, 0.90186, 1.12308, 1.12308, 1.12308, 1.12308, 1.2566, 1.2566, 1.2566, 0.89552, 0.89552, 1.42259, 0.68994, 1.03809, 1, 1, 1.0176, 1.0176, 1.11523, 1.4956, 2.01462, 0.97858, 0.82616, 0.91133, 0.83437, 0.91133, 1, 1, 1, 0.70508, 1, 1.23108, 0.79801, 0.84426, 0.84426, 0.774, 0.90572, 1.81055, 0.90749, 1.81055, 1.28809, 1.55469, 0.94434, 1.07806, 1, 0.97094, 0.7589, 0.85284, 0.90747, 1.19658, 0.69825, 0.97622, 1.33512, 0.90747, 0.90747, 0.85284, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.0336, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05859, 1.05859, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriItalicFactors = CalibriItalicFactors;
const CalibriItalicMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriItalicMetrics = CalibriItalicMetrics;
const CalibriRegularFactors = [1.3877, 1, 1, 1, 1.17223, 1.1293, 0.89552, 0.91133, 0.80395, 1.02269, 1.15601, 0.91056, 0.91056, 1.2798, 0.85284, 0.89807, 1, 0.90861, 1.39016, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.96309, 0.96309, 0.85284, 0.85284, 0.85284, 0.83319, 0.88071, 0.8675, 0.81552, 0.73834, 0.85193, 0.73206, 0.7522, 0.81105, 0.86275, 0.90685, 0.6377, 0.77892, 0.75593, 1.02638, 0.89385, 0.85122, 0.77452, 0.86503, 0.75186, 0.68887, 0.79776, 0.88844, 0.85066, 0.94258, 0.77818, 0.7306, 0.76659, 1.10369, 1.39016, 1.10369, 1.06139, 0.89552, 0.8739, 0.86128, 0.94469, 0.8457, 0.94469, 0.89464, 1.09842, 0.84636, 0.94469, 1.03297, 1.07692, 0.90918, 1.03297, 0.95897, 0.94469, 0.9482, 0.94469, 0.94469, 1.04692, 0.78223, 1.20562, 0.94469, 0.90332, 0.98986, 0.86621, 0.90527, 0.79004, 0.94152, 1.77256, 0.94152, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.91729, 0.89552, 1.17889, 1.13254, 1.08707, 0.92098, 0.85284, 0.68787, 0.71353, 0.84737, 0.90747, 1.0088, 1.0044, 0.87683, 1, 1.09091, 1, 0.92229, 0.739, 1.15642, 0.92098, 0.76288, 0.80504, 0.80972, 0.75859, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.76318, 0.73834, 0.73206, 0.73206, 0.73206, 0.73206, 0.90685, 0.90685, 0.90685, 0.90685, 0.86477, 0.89385, 0.85122, 0.85122, 0.85122, 0.85122, 0.85122, 0.85284, 0.85311, 0.88844, 0.88844, 0.88844, 0.88844, 0.7306, 0.77452, 0.86331, 0.86128, 0.86128, 0.86128, 0.86128, 0.86128, 0.86128, 0.8693, 0.8457, 0.89464, 0.89464, 0.89464, 0.89464, 0.82601, 0.82601, 0.82601, 0.82601, 0.94469, 0.94469, 0.9482, 0.9482, 0.9482, 0.9482, 0.9482, 0.90747, 0.86651, 0.94469, 0.94469, 0.94469, 0.94469, 0.90527, 0.94469, 0.90527, 0.8675, 0.86128, 0.8675, 0.86128, 0.8675, 0.86128, 0.73834, 0.8457, 0.73834, 0.8457, 0.73834, 0.8457, 0.73834, 0.8457, 0.85193, 0.92454, 0.86477, 0.9921, 0.73206, 0.89464, 0.73206, 0.89464, 0.73206, 0.89464, 0.73206, 0.89464, 0.73206, 0.89464, 0.81105, 0.84636, 0.81105, 0.84636, 0.81105, 0.84636, 1, 1, 0.86275, 0.94469, 0.90872, 0.95786, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 1.03297, 0.90685, 0.82601, 0.77741, 1.05611, 0.6377, 1.07692, 1, 1, 0.90918, 0.75593, 1.03297, 1, 1, 0.76032, 0.90452, 0.98156, 1.11842, 0.77261, 1.11429, 0.89385, 0.94469, 1, 1, 0.89385, 0.94469, 0.95877, 0.86901, 0.94469, 0.85122, 0.9482, 0.85122, 0.9482, 0.85122, 0.9482, 0.8667, 0.90016, 0.75186, 1.04692, 1, 1, 0.75186, 1.04692, 0.68887, 0.78223, 0.68887, 0.78223, 0.68887, 0.78223, 0.68887, 0.78223, 1, 1, 0.79776, 0.92188, 0.79776, 1.23023, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.94258, 0.98986, 0.7306, 0.90527, 0.7306, 0.76659, 0.79004, 0.76659, 0.79004, 0.76659, 0.79004, 1.09231, 0.54873, 0.8675, 0.86128, 0.76318, 0.8693, 0.85311, 0.86651, 1, 1, 0.79776, 1.20562, 1.18622, 1.18622, 1, 1.1437, 0.67742, 0.96334, 0.93695, 1.35191, 1.40909, 0.95161, 1.48387, 0.86686, 0.90861, 0.62267, 0.74359, 0.65649, 0.85498, 0.56963, 0.88254, 1.23516, 0.8675, 0.81552, 0.75443, 0.84503, 0.73206, 0.76659, 0.86275, 0.85122, 0.90685, 0.77892, 0.85746, 1.02638, 0.89385, 0.75657, 0.85122, 0.86275, 0.77452, 0.74171, 0.79776, 0.7306, 0.95165, 0.77818, 0.89772, 0.88831, 0.90685, 0.7306, 0.98142, 1.02191, 0.96576, 1.23516, 0.99018, 0.98142, 0.9236, 0.89258, 0.94035, 1.02191, 0.78848, 0.96576, 0.9561, 1.23516, 0.90918, 0.92578, 0.95424, 0.89746, 0.83969, 0.9482, 0.80113, 0.89442, 0.85208, 0.86155, 0.98022, 0.99018, 1.00452, 0.81209, 0.99247, 0.89181, 1.23516, 0.99018, 0.9482, 0.99018, 0.89181, 0.73206, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.88844, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.89464, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.96766, 1, 1, 1, 1, 1, 1, 0.94258, 0.98986, 0.94258, 0.98986, 0.94258, 0.98986, 0.7306, 0.90527, 1, 1, 0.89552, 0.90527, 1, 0.90186, 1.12308, 1.12308, 1.12308, 1.12308, 1.2566, 1.2566, 1.2566, 0.89552, 0.89552, 1.42259, 0.69043, 1.03809, 1, 1, 1.0176, 1.0176, 1.11523, 1.4956, 2.01462, 0.99331, 0.82616, 0.91133, 0.84286, 0.91133, 1, 1, 1, 0.70508, 1, 1.23108, 0.79801, 0.84426, 0.84426, 0.774, 0.90527, 1.81055, 0.90527, 1.81055, 1.28809, 1.55469, 0.94434, 1.07806, 1, 0.97094, 0.7589, 0.85284, 0.90747, 1.19658, 0.69825, 0.97622, 1.33512, 0.90747, 0.90747, 0.85356, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.0336, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05859, 1.05859, 1, 1, 1, 1.07185, 0.99413, 0.96334, 1.08065, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriRegularFactors = CalibriRegularFactors;
const CalibriRegularMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriRegularMetrics = CalibriRegularMetrics;

/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.HelveticaRegularMetrics = exports.HelveticaRegularFactors = exports.HelveticaItalicMetrics = exports.HelveticaItalicFactors = exports.HelveticaBoldMetrics = exports.HelveticaBoldItalicMetrics = exports.HelveticaBoldItalicFactors = exports.HelveticaBoldFactors = void 0;
const HelveticaBoldFactors = [0.76116, 1, 1, 1.0006, 0.99998, 0.99974, 0.99973, 0.99973, 0.99982, 0.99977, 1.00087, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.00003, 1.00003, 1.00003, 1.00026, 0.9999, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 0.99973, 0.99977, 1.00026, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 0.99998, 1.0006, 0.99998, 1.00003, 0.99973, 0.99998, 0.99973, 1.00026, 0.99973, 1.00026, 0.99973, 0.99998, 1.00026, 1.00026, 1.0006, 1.0006, 0.99973, 1.0006, 0.99982, 1.00026, 1.00026, 1.00026, 1.00026, 0.99959, 0.99973, 0.99998, 1.00026, 0.99973, 1.00022, 0.99973, 0.99973, 1, 0.99959, 1.00077, 0.99959, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.00077, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.99973, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.06409, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 0.99973, 1.00026, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 1.03374, 0.99977, 1.00026, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.00042, 0.99973, 0.99973, 1.0006, 0.99977, 0.99973, 0.99973, 1.00026, 1.0006, 1.00026, 1.0006, 1.00026, 1.03828, 1.00026, 0.99999, 1.00026, 1.0006, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.9993, 0.9998, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1, 1.00016, 0.99977, 0.99959, 0.99977, 0.99959, 0.99977, 0.99959, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00026, 0.99998, 1.00026, 0.8121, 1.00026, 0.99998, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.00016, 1.00022, 1.00001, 0.99973, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 1.0006, 0.99973, 0.99977, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 0.99973, 1.00026, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 1.00034, 0.99977, 1, 0.99997, 1.00026, 1.00078, 1.00036, 0.99973, 1.00013, 1.0006, 0.99977, 0.99977, 0.99988, 0.85148, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 0.99977, 1.00001, 0.99999, 0.99977, 1.00069, 1.00022, 0.99977, 1.00001, 0.99984, 1.00026, 1.00001, 1.00024, 1.00001, 0.9999, 1, 1.0006, 1.00001, 1.00041, 0.99962, 1.00026, 1.0006, 0.99995, 1.00041, 0.99942, 0.99973, 0.99927, 1.00082, 0.99902, 1.00026, 1.00087, 1.0006, 1.00069, 0.99973, 0.99867, 0.99973, 0.9993, 1.00026, 1.00049, 1.00056, 1, 0.99988, 0.99935, 0.99995, 0.99954, 1.00055, 0.99945, 1.00032, 1.0006, 0.99995, 1.00026, 0.99995, 1.00032, 1.00001, 1.00008, 0.99971, 1.00019, 0.9994, 1.00001, 1.0006, 1.00044, 0.99973, 1.00023, 1.00047, 1, 0.99942, 0.99561, 0.99989, 1.00035, 0.99977, 1.00035, 0.99977, 1.00019, 0.99944, 1.00001, 1.00021, 0.99926, 1.00035, 1.00035, 0.99942, 1.00048, 0.99999, 0.99977, 1.00022, 1.00035, 1.00001, 0.99977, 1.00026, 0.99989, 1.00057, 1.00001, 0.99936, 1.00052, 1.00012, 0.99996, 1.00043, 1, 1.00035, 0.9994, 0.99976, 1.00035, 0.99973, 1.00052, 1.00041, 1.00119, 1.00037, 0.99973, 1.00002, 0.99986, 1.00041, 1.00041, 0.99902, 0.9996, 1.00034, 0.99999, 1.00026, 0.99999, 1.00026, 0.99973, 1.00052, 0.99973, 1, 0.99973, 1.00041, 1.00075, 0.9994, 1.0003, 0.99999, 1, 1.00041, 0.99955, 1, 0.99915, 0.99973, 0.99973, 1.00026, 1.00119, 0.99955, 0.99973, 1.0006, 0.99911, 1.0006, 1.00026, 0.99972, 1.00026, 0.99902, 1.00041, 0.99973, 0.99999, 1, 1, 1.00038, 1.0005, 1.00016, 1.00022, 1.00016, 1.00022, 1.00016, 1.00022, 1.00001, 0.99973, 1, 1, 0.99973, 1, 1, 0.99955, 1.0006, 1.0006, 1.0006, 1.0006, 1, 1, 1, 0.99973, 0.99973, 0.99972, 1, 1, 1.00106, 0.99999, 0.99998, 0.99998, 0.99999, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1.00023, 0.99973, 0.99971, 1.00047, 1.00023, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1, 1, 1, 1, 1, 1, 1, 0.99972, 1, 1.20985, 1.39713, 1.00003, 1.00031, 1.00015, 1, 0.99561, 1.00027, 1.00031, 1.00031, 0.99915, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.99972, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 0.99998, 0.99998, 0.99998, 0.99998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaBoldFactors = HelveticaBoldFactors;
const HelveticaBoldMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.HelveticaBoldMetrics = HelveticaBoldMetrics;
const HelveticaBoldItalicFactors = [0.76116, 1, 1, 1.0006, 0.99998, 0.99974, 0.99973, 0.99973, 0.99982, 0.99977, 1.00087, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.00003, 1.00003, 1.00003, 1.00026, 0.9999, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 0.99973, 0.99977, 1.00026, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 0.99998, 1.0006, 0.99998, 1.00003, 0.99973, 0.99998, 0.99973, 1.00026, 0.99973, 1.00026, 0.99973, 0.99998, 1.00026, 1.00026, 1.0006, 1.0006, 0.99973, 1.0006, 0.99982, 1.00026, 1.00026, 1.00026, 1.00026, 0.99959, 0.99973, 0.99998, 1.00026, 0.99973, 1.00022, 0.99973, 0.99973, 1, 0.99959, 1.00077, 0.99959, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.00077, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.99973, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.06409, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 0.99973, 1.00026, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 1.0044, 0.99977, 1.00026, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 0.99971, 0.99973, 0.99973, 1.0006, 0.99977, 0.99973, 0.99973, 1.00026, 1.0006, 1.00026, 1.0006, 1.00026, 1.01011, 1.00026, 0.99999, 1.00026, 1.0006, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.9993, 0.9998, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1, 1.00016, 0.99977, 0.99959, 0.99977, 0.99959, 0.99977, 0.99959, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00026, 0.99998, 1.00026, 0.8121, 1.00026, 0.99998, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.00016, 1.00022, 1.00001, 0.99973, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 1.0006, 0.99973, 0.99977, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 0.99973, 1.00026, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99977, 1, 1, 1.00026, 0.99969, 0.99972, 0.99981, 0.9998, 1.0006, 0.99977, 0.99977, 1.00022, 0.91155, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 0.99977, 1.00001, 0.99999, 0.99977, 0.99966, 1.00022, 1.00032, 1.00001, 0.99944, 1.00026, 1.00001, 0.99968, 1.00001, 1.00047, 1, 1.0006, 1.00001, 0.99981, 1.00101, 1.00026, 1.0006, 0.99948, 0.99981, 1.00064, 0.99973, 0.99942, 1.00101, 1.00061, 1.00026, 1.00069, 1.0006, 1.00014, 0.99973, 1.01322, 0.99973, 1.00065, 1.00026, 1.00012, 0.99923, 1, 1.00064, 1.00076, 0.99948, 1.00055, 1.00063, 1.00007, 0.99943, 1.0006, 0.99948, 1.00026, 0.99948, 0.99943, 1.00001, 1.00001, 1.00029, 1.00038, 1.00035, 1.00001, 1.0006, 1.0006, 0.99973, 0.99978, 1.00001, 1.00057, 0.99989, 0.99967, 0.99964, 0.99967, 0.99977, 0.99999, 0.99977, 1.00038, 0.99977, 1.00001, 0.99973, 1.00066, 0.99967, 0.99967, 1.00041, 0.99998, 0.99999, 0.99977, 1.00022, 0.99967, 1.00001, 0.99977, 1.00026, 0.99964, 1.00031, 1.00001, 0.99999, 0.99999, 1, 1.00023, 1, 1, 0.99999, 1.00035, 1.00001, 0.99999, 0.99973, 0.99977, 0.99999, 1.00058, 0.99973, 0.99973, 0.99955, 0.9995, 1.00026, 1.00026, 1.00032, 0.99989, 1.00034, 0.99999, 1.00026, 1.00026, 1.00026, 0.99973, 0.45998, 0.99973, 1.00026, 0.99973, 1.00001, 0.99999, 0.99982, 0.99994, 0.99996, 1, 1.00042, 1.00044, 1.00029, 1.00023, 0.99973, 0.99973, 1.00026, 0.99949, 1.00002, 0.99973, 1.0006, 1.0006, 1.0006, 0.99975, 1.00026, 1.00026, 1.00032, 0.98685, 0.99973, 1.00026, 1, 1, 0.99966, 1.00044, 1.00016, 1.00022, 1.00016, 1.00022, 1.00016, 1.00022, 1.00001, 0.99973, 1, 1, 0.99973, 1, 1, 0.99955, 1.0006, 1.0006, 1.0006, 1.0006, 1, 1, 1, 0.99973, 0.99973, 0.99972, 1, 1, 1.00106, 0.99999, 0.99998, 0.99998, 0.99999, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1, 0.99973, 0.99971, 0.99978, 1, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1.00098, 1, 1, 1, 1.00049, 1, 1, 0.99972, 1, 1.20985, 1.39713, 1.00003, 1.00031, 1.00015, 1, 0.99561, 1.00027, 1.00031, 1.00031, 0.99915, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.99972, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 0.99998, 0.99998, 0.99998, 0.99998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaBoldItalicFactors = HelveticaBoldItalicFactors;
const HelveticaBoldItalicMetrics = {
  lineHeight: 1.35,
  lineGap: 0.2
};
exports.HelveticaBoldItalicMetrics = HelveticaBoldItalicMetrics;
const HelveticaItalicFactors = [0.76116, 1, 1, 1.0006, 1.0006, 1.00006, 0.99973, 0.99973, 0.99982, 1.00001, 1.00043, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1, 1.00003, 1.00003, 1.00003, 0.99973, 0.99987, 1.00001, 1.00001, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 1, 1.00001, 0.99973, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 1.0006, 1.0006, 1.0006, 0.99949, 0.99973, 0.99998, 0.99973, 0.99973, 1, 0.99973, 0.99973, 1.0006, 0.99973, 0.99973, 0.99924, 0.99924, 1, 0.99924, 0.99999, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.0006, 0.99973, 1, 0.99977, 1, 1, 1, 1.00005, 1.0009, 1.00005, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.0009, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.9998, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 1, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.06409, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 1, 0.99973, 1, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1.0288, 0.99977, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 0.99924, 1.0006, 1.0006, 0.99946, 1.00034, 1, 0.99924, 1.00001, 1, 1, 0.99973, 0.99924, 0.99973, 0.99924, 0.99973, 1.06311, 0.99973, 1.00024, 0.99973, 0.99924, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.00041, 0.9998, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1, 1.00016, 0.99977, 0.99998, 0.99977, 0.99998, 0.99977, 0.99998, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00026, 1.0006, 1.00026, 0.89547, 1.00026, 1.0006, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.00016, 0.99977, 1.00001, 1, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 0.99924, 0.99973, 1.00001, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 1, 1.00026, 1.0006, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 1.00001, 1, 1.00054, 0.99977, 1.00084, 1.00007, 0.99973, 1.00013, 0.99924, 1.00001, 1.00001, 0.99945, 0.91221, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 1.00001, 1.00001, 0.99999, 0.99977, 0.99933, 1.00022, 1.00054, 1.00001, 1.00065, 1.00026, 1.00001, 1.0001, 1.00001, 1.00052, 1, 1.0006, 1.00001, 0.99945, 0.99897, 0.99968, 0.99924, 1.00036, 0.99945, 0.99949, 1, 1.0006, 0.99897, 0.99918, 0.99968, 0.99911, 0.99924, 1, 0.99962, 1.01487, 1, 1.0005, 0.99973, 1.00012, 1.00043, 1, 0.99995, 0.99994, 1.00036, 0.99947, 1.00019, 1.00063, 1.00025, 0.99924, 1.00036, 0.99973, 1.00036, 1.00025, 1.00001, 1.00001, 1.00027, 1.0001, 1.00068, 1.00001, 1.0006, 1.0006, 1, 1.00008, 0.99957, 0.99972, 0.9994, 0.99954, 0.99975, 1.00051, 1.00001, 1.00019, 1.00001, 1.0001, 0.99986, 1.00001, 1.00001, 1.00038, 0.99954, 0.99954, 0.9994, 1.00066, 0.99999, 0.99977, 1.00022, 1.00054, 1.00001, 0.99977, 1.00026, 0.99975, 1.0001, 1.00001, 0.99993, 0.9995, 0.99955, 1.00016, 0.99978, 0.99974, 1.00019, 1.00022, 0.99955, 1.00053, 0.99973, 1.00089, 1.00005, 0.99967, 1.00048, 0.99973, 1.00002, 1.00034, 0.99973, 0.99973, 0.99964, 1.00006, 1.00066, 0.99947, 0.99973, 0.98894, 0.99973, 1, 0.44898, 1, 0.99946, 1, 1.00039, 1.00082, 0.99991, 0.99991, 0.99985, 1.00022, 1.00023, 1.00061, 1.00006, 0.99966, 0.99973, 0.99973, 0.99973, 1.00019, 1.0008, 1, 0.99924, 0.99924, 0.99924, 0.99983, 1.00044, 0.99973, 0.99964, 0.98332, 1, 0.99973, 1, 1, 0.99962, 0.99895, 1.00016, 0.99977, 1.00016, 0.99977, 1.00016, 0.99977, 1.00001, 1, 1, 1, 0.99973, 1, 1, 0.99955, 0.99924, 0.99924, 0.99924, 0.99924, 0.99998, 0.99998, 0.99998, 0.99973, 0.99973, 0.99972, 1, 1, 1.00267, 0.99999, 0.99998, 0.99998, 1, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1.00023, 0.99973, 1.00423, 0.99925, 0.99999, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1.00049, 1, 1.00245, 1, 1, 1, 1, 0.96329, 1, 1.20985, 1.39713, 1.00003, 0.8254, 1.00015, 1, 1.00035, 1.00027, 1.00031, 1.00031, 1.00003, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.95317, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 0.99998, 0.99998, 0.99998, 0.99998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaItalicFactors = HelveticaItalicFactors;
const HelveticaItalicMetrics = {
  lineHeight: 1.35,
  lineGap: 0.2
};
exports.HelveticaItalicMetrics = HelveticaItalicMetrics;
const HelveticaRegularFactors = [0.76116, 1, 1, 1.0006, 1.0006, 1.00006, 0.99973, 0.99973, 0.99982, 1.00001, 1.00043, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1, 1.00003, 1.00003, 1.00003, 0.99973, 0.99987, 1.00001, 1.00001, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 1, 1.00001, 0.99973, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 1.0006, 1.0006, 1.0006, 0.99949, 0.99973, 0.99998, 0.99973, 0.99973, 1, 0.99973, 0.99973, 1.0006, 0.99973, 0.99973, 0.99924, 0.99924, 1, 0.99924, 0.99999, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.0006, 0.99973, 1, 0.99977, 1, 1, 1, 1.00005, 1.0009, 1.00005, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.0009, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.9998, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 1, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.06409, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 1, 0.99973, 1, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1.04596, 0.99977, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 0.99924, 1.0006, 1.0006, 1.00019, 1.00034, 1, 0.99924, 1.00001, 1, 1, 0.99973, 0.99924, 0.99973, 0.99924, 0.99973, 1.02572, 0.99973, 1.00005, 0.99973, 0.99924, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99999, 0.9998, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1, 1.00016, 0.99977, 0.99998, 0.99977, 0.99998, 0.99977, 0.99998, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00026, 1.0006, 1.00026, 0.84533, 1.00026, 1.0006, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.00016, 0.99977, 1.00001, 1, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 0.99924, 0.99973, 1.00001, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 1, 1.00026, 1.0006, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99928, 1, 0.99977, 1.00013, 1.00055, 0.99947, 0.99945, 0.99941, 0.99924, 1.00001, 1.00001, 1.0004, 0.91621, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 1.00001, 1.00005, 0.99999, 0.99977, 1.00015, 1.00022, 0.99977, 1.00001, 0.99973, 1.00026, 1.00001, 1.00019, 1.00001, 0.99946, 1, 1.0006, 1.00001, 0.99978, 1.00045, 0.99973, 0.99924, 1.00023, 0.99978, 0.99966, 1, 1.00065, 1.00045, 1.00019, 0.99973, 0.99973, 0.99924, 1, 1, 0.96499, 1, 1.00055, 0.99973, 1.00008, 1.00027, 1, 0.9997, 0.99995, 1.00023, 0.99933, 1.00019, 1.00015, 1.00031, 0.99924, 1.00023, 0.99973, 1.00023, 1.00031, 1.00001, 0.99928, 1.00029, 1.00092, 1.00035, 1.00001, 1.0006, 1.0006, 1, 0.99988, 0.99975, 1, 1.00082, 0.99561, 0.9996, 1.00035, 1.00001, 0.99962, 1.00001, 1.00092, 0.99964, 1.00001, 0.99963, 0.99999, 1.00035, 1.00035, 1.00082, 0.99962, 0.99999, 0.99977, 1.00022, 1.00035, 1.00001, 0.99977, 1.00026, 0.9996, 0.99967, 1.00001, 1.00034, 1.00074, 1.00054, 1.00053, 1.00063, 0.99971, 0.99962, 1.00035, 0.99975, 0.99977, 0.99973, 1.00043, 0.99953, 1.0007, 0.99915, 0.99973, 1.00008, 0.99892, 1.00073, 1.00073, 1.00114, 0.99915, 1.00073, 0.99955, 0.99973, 1.00092, 0.99973, 1, 0.99998, 1, 1.0003, 1, 1.00043, 1.00001, 0.99969, 1.0003, 1, 1.00035, 1.00001, 0.9995, 1, 1.00092, 0.99973, 0.99973, 0.99973, 1.0007, 0.9995, 1, 0.99924, 1.0006, 0.99924, 0.99972, 1.00062, 0.99973, 1.00114, 1.00073, 1, 0.99955, 1, 1, 1.00047, 0.99968, 1.00016, 0.99977, 1.00016, 0.99977, 1.00016, 0.99977, 1.00001, 1, 1, 1, 0.99973, 1, 1, 0.99955, 0.99924, 0.99924, 0.99924, 0.99924, 0.99998, 0.99998, 0.99998, 0.99973, 0.99973, 0.99972, 1, 1, 1.00267, 0.99999, 0.99998, 0.99998, 1, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1.00023, 0.99973, 0.99971, 0.99925, 1.00023, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1, 1, 1, 1, 1, 1, 1, 0.96329, 1, 1.20985, 1.39713, 1.00003, 0.8254, 1.00015, 1, 1.00035, 1.00027, 1.00031, 1.00031, 0.99915, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.95317, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaRegularFactors = HelveticaRegularFactors;
const HelveticaRegularMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.HelveticaRegularMetrics = HelveticaRegularMetrics;

/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LiberationSansRegularWidths = exports.LiberationSansRegularMapping = exports.LiberationSansItalicWidths = exports.LiberationSansItalicMapping = exports.LiberationSansBoldWidths = exports.LiberationSansBoldMapping = exports.LiberationSansBoldItalicWidths = exports.LiberationSansBoldItalicMapping = void 0;
const LiberationSansBoldWidths = [365, 0, 333, 278, 333, 474, 556, 556, 889, 722, 238, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 584, 584, 584, 611, 975, 722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556, 333, 556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611, 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389, 584, 333, 556, 556, 556, 556, 280, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 556, 278, 333, 333, 365, 556, 834, 834, 834, 611, 722, 722, 722, 722, 722, 722, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 278, 278, 278, 278, 611, 611, 611, 611, 611, 611, 611, 549, 611, 611, 611, 611, 611, 556, 611, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 719, 722, 611, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 611, 778, 611, 778, 611, 778, 611, 722, 611, 722, 611, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 785, 556, 556, 278, 722, 556, 556, 611, 278, 611, 278, 611, 385, 611, 479, 611, 278, 722, 611, 722, 611, 722, 611, 708, 723, 611, 778, 611, 778, 611, 778, 611, 1000, 944, 722, 389, 722, 389, 722, 389, 667, 556, 667, 556, 667, 556, 667, 556, 611, 333, 611, 479, 611, 333, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 944, 778, 667, 556, 667, 611, 500, 611, 500, 611, 500, 278, 556, 722, 556, 1000, 889, 778, 611, 667, 556, 611, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 465, 722, 333, 853, 906, 474, 825, 927, 838, 278, 722, 722, 601, 719, 667, 611, 722, 778, 278, 722, 667, 833, 722, 644, 778, 722, 667, 600, 611, 667, 821, 667, 809, 802, 278, 667, 615, 451, 611, 278, 582, 615, 610, 556, 606, 475, 460, 611, 541, 278, 558, 556, 612, 556, 445, 611, 766, 619, 520, 684, 446, 582, 715, 576, 753, 845, 278, 582, 611, 582, 845, 667, 669, 885, 567, 711, 667, 278, 276, 556, 1094, 1062, 875, 610, 722, 622, 719, 722, 719, 722, 567, 712, 667, 904, 626, 719, 719, 610, 702, 833, 722, 778, 719, 667, 722, 611, 622, 854, 667, 730, 703, 1005, 1019, 870, 979, 719, 711, 1031, 719, 556, 618, 615, 417, 635, 556, 709, 497, 615, 615, 500, 635, 740, 604, 611, 604, 611, 556, 490, 556, 875, 556, 615, 581, 833, 844, 729, 854, 615, 552, 854, 583, 556, 556, 611, 417, 552, 556, 278, 281, 278, 969, 906, 611, 500, 615, 556, 604, 778, 611, 487, 447, 944, 778, 944, 778, 944, 778, 667, 556, 333, 333, 556, 1000, 1000, 552, 278, 278, 278, 278, 500, 500, 500, 556, 556, 350, 1000, 1000, 240, 479, 333, 333, 604, 333, 167, 396, 556, 556, 1094, 556, 885, 489, 1115, 1000, 768, 600, 834, 834, 834, 834, 1000, 500, 1000, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 722, 274, 549, 549, 583, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 611, 611, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 333, 333, 333, 333, 333, 333, 333, 333];
exports.LiberationSansBoldWidths = LiberationSansBoldWidths;
const LiberationSansBoldMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansBoldMapping = LiberationSansBoldMapping;
const LiberationSansBoldItalicWidths = [365, 0, 333, 278, 333, 474, 556, 556, 889, 722, 238, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 584, 584, 584, 611, 975, 722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556, 333, 556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611, 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389, 584, 333, 556, 556, 556, 556, 280, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 556, 278, 333, 333, 365, 556, 834, 834, 834, 611, 722, 722, 722, 722, 722, 722, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 278, 278, 278, 278, 611, 611, 611, 611, 611, 611, 611, 549, 611, 611, 611, 611, 611, 556, 611, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 740, 722, 611, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 611, 778, 611, 778, 611, 778, 611, 722, 611, 722, 611, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 782, 556, 556, 278, 722, 556, 556, 611, 278, 611, 278, 611, 396, 611, 479, 611, 278, 722, 611, 722, 611, 722, 611, 708, 723, 611, 778, 611, 778, 611, 778, 611, 1000, 944, 722, 389, 722, 389, 722, 389, 667, 556, 667, 556, 667, 556, 667, 556, 611, 333, 611, 479, 611, 333, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 944, 778, 667, 556, 667, 611, 500, 611, 500, 611, 500, 278, 556, 722, 556, 1000, 889, 778, 611, 667, 556, 611, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 722, 333, 854, 906, 473, 844, 930, 847, 278, 722, 722, 610, 671, 667, 611, 722, 778, 278, 722, 667, 833, 722, 657, 778, 718, 667, 590, 611, 667, 822, 667, 829, 781, 278, 667, 620, 479, 611, 278, 591, 620, 621, 556, 610, 479, 492, 611, 558, 278, 566, 556, 603, 556, 450, 611, 712, 605, 532, 664, 409, 591, 704, 578, 773, 834, 278, 591, 611, 591, 834, 667, 667, 886, 614, 719, 667, 278, 278, 556, 1094, 1042, 854, 622, 719, 677, 719, 722, 708, 722, 614, 722, 667, 927, 643, 719, 719, 615, 687, 833, 722, 778, 719, 667, 722, 611, 677, 781, 667, 729, 708, 979, 989, 854, 1000, 708, 719, 1042, 729, 556, 619, 604, 534, 618, 556, 736, 510, 611, 611, 507, 622, 740, 604, 611, 611, 611, 556, 889, 556, 885, 556, 646, 583, 889, 935, 707, 854, 594, 552, 865, 589, 556, 556, 611, 469, 563, 556, 278, 278, 278, 969, 906, 611, 507, 619, 556, 611, 778, 611, 575, 467, 944, 778, 944, 778, 944, 778, 667, 556, 333, 333, 556, 1000, 1000, 552, 278, 278, 278, 278, 500, 500, 500, 556, 556, 350, 1000, 1000, 240, 479, 333, 333, 604, 333, 167, 396, 556, 556, 1104, 556, 885, 516, 1146, 1000, 768, 600, 834, 834, 834, 834, 999, 500, 1000, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 722, 274, 549, 549, 583, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 611, 611, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 333, 333, 333, 333, 333, 333, 333, 333];
exports.LiberationSansBoldItalicWidths = LiberationSansBoldItalicWidths;
const LiberationSansBoldItalicMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansBoldItalicMapping = LiberationSansBoldItalicMapping;
const LiberationSansItalicWidths = [365, 0, 333, 278, 278, 355, 556, 556, 889, 667, 191, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 584, 584, 584, 556, 1015, 667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556, 333, 556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556, 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334, 584, 333, 556, 556, 556, 556, 260, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 537, 278, 333, 333, 365, 556, 834, 834, 834, 611, 667, 667, 667, 667, 667, 667, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 278, 278, 278, 278, 556, 556, 556, 556, 556, 556, 556, 549, 611, 556, 556, 556, 556, 500, 556, 500, 667, 556, 667, 556, 667, 556, 722, 500, 722, 500, 722, 500, 722, 500, 722, 625, 722, 556, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 556, 778, 556, 778, 556, 778, 556, 722, 556, 722, 556, 278, 278, 278, 278, 278, 278, 278, 222, 278, 278, 733, 444, 500, 222, 667, 500, 500, 556, 222, 556, 222, 556, 281, 556, 400, 556, 222, 722, 556, 722, 556, 722, 556, 615, 723, 556, 778, 556, 778, 556, 778, 556, 1000, 944, 722, 333, 722, 333, 722, 333, 667, 500, 667, 500, 667, 500, 667, 500, 611, 278, 611, 354, 611, 278, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 944, 722, 667, 500, 667, 611, 500, 611, 500, 611, 500, 222, 556, 667, 556, 1000, 889, 778, 611, 667, 500, 611, 278, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 667, 278, 789, 846, 389, 794, 865, 775, 222, 667, 667, 570, 671, 667, 611, 722, 778, 278, 667, 667, 833, 722, 648, 778, 725, 667, 600, 611, 667, 837, 667, 831, 761, 278, 667, 570, 439, 555, 222, 550, 570, 571, 500, 556, 439, 463, 555, 542, 222, 500, 492, 548, 500, 447, 556, 670, 573, 486, 603, 374, 550, 652, 546, 728, 779, 222, 550, 556, 550, 779, 667, 667, 843, 544, 708, 667, 278, 278, 500, 1066, 982, 844, 589, 715, 639, 724, 667, 651, 667, 544, 704, 667, 917, 614, 715, 715, 589, 686, 833, 722, 778, 725, 667, 722, 611, 639, 795, 667, 727, 673, 920, 923, 805, 886, 651, 694, 1022, 682, 556, 562, 522, 493, 553, 556, 688, 465, 556, 556, 472, 564, 686, 550, 556, 556, 556, 500, 833, 500, 835, 500, 572, 518, 830, 851, 621, 736, 526, 492, 752, 534, 556, 556, 556, 378, 496, 500, 222, 222, 222, 910, 828, 556, 472, 565, 500, 556, 778, 556, 492, 339, 944, 722, 944, 722, 944, 722, 667, 500, 333, 333, 556, 1000, 1000, 552, 222, 222, 222, 222, 333, 333, 333, 556, 556, 350, 1000, 1000, 188, 354, 333, 333, 500, 333, 167, 365, 556, 556, 1094, 556, 885, 323, 1083, 1000, 768, 600, 834, 834, 834, 834, 1000, 500, 998, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 719, 274, 549, 549, 584, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 500, 500, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 294, 294, 324, 324, 316, 328, 398, 285];
exports.LiberationSansItalicWidths = LiberationSansItalicWidths;
const LiberationSansItalicMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansItalicMapping = LiberationSansItalicMapping;
const LiberationSansRegularWidths = [365, 0, 333, 278, 278, 355, 556, 556, 889, 667, 191, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 584, 584, 584, 556, 1015, 667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556, 333, 556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556, 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334, 584, 333, 556, 556, 556, 556, 260, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 537, 278, 333, 333, 365, 556, 834, 834, 834, 611, 667, 667, 667, 667, 667, 667, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 278, 278, 278, 278, 556, 556, 556, 556, 556, 556, 556, 549, 611, 556, 556, 556, 556, 500, 556, 500, 667, 556, 667, 556, 667, 556, 722, 500, 722, 500, 722, 500, 722, 500, 722, 615, 722, 556, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 556, 778, 556, 778, 556, 778, 556, 722, 556, 722, 556, 278, 278, 278, 278, 278, 278, 278, 222, 278, 278, 735, 444, 500, 222, 667, 500, 500, 556, 222, 556, 222, 556, 292, 556, 334, 556, 222, 722, 556, 722, 556, 722, 556, 604, 723, 556, 778, 556, 778, 556, 778, 556, 1000, 944, 722, 333, 722, 333, 722, 333, 667, 500, 667, 500, 667, 500, 667, 500, 611, 278, 611, 375, 611, 278, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 944, 722, 667, 500, 667, 611, 500, 611, 500, 611, 500, 222, 556, 667, 556, 1000, 889, 778, 611, 667, 500, 611, 278, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 667, 278, 784, 838, 384, 774, 855, 752, 222, 667, 667, 551, 668, 667, 611, 722, 778, 278, 667, 668, 833, 722, 650, 778, 722, 667, 618, 611, 667, 798, 667, 835, 748, 278, 667, 578, 446, 556, 222, 547, 578, 575, 500, 557, 446, 441, 556, 556, 222, 500, 500, 576, 500, 448, 556, 690, 569, 482, 617, 395, 547, 648, 525, 713, 781, 222, 547, 556, 547, 781, 667, 667, 865, 542, 719, 667, 278, 278, 500, 1057, 1010, 854, 583, 722, 635, 719, 667, 656, 667, 542, 677, 667, 923, 604, 719, 719, 583, 656, 833, 722, 778, 719, 667, 722, 611, 635, 760, 667, 740, 667, 917, 938, 792, 885, 656, 719, 1010, 722, 556, 573, 531, 365, 583, 556, 669, 458, 559, 559, 438, 583, 688, 552, 556, 542, 556, 500, 458, 500, 823, 500, 573, 521, 802, 823, 625, 719, 521, 510, 750, 542, 556, 556, 556, 365, 510, 500, 222, 278, 222, 906, 812, 556, 438, 559, 500, 552, 778, 556, 489, 411, 944, 722, 944, 722, 944, 722, 667, 500, 333, 333, 556, 1000, 1000, 552, 222, 222, 222, 222, 333, 333, 333, 556, 556, 350, 1000, 1000, 188, 354, 333, 333, 500, 333, 167, 365, 556, 556, 1094, 556, 885, 323, 1073, 1000, 768, 600, 834, 834, 834, 834, 1000, 500, 1000, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 719, 274, 549, 549, 583, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 500, 500, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 294, 294, 324, 324, 316, 328, 398, 285];
exports.LiberationSansRegularWidths = LiberationSansRegularWidths;
const LiberationSansRegularMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansRegularMapping = LiberationSansRegularMapping;

/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MyriadProRegularMetrics = exports.MyriadProRegularFactors = exports.MyriadProItalicMetrics = exports.MyriadProItalicFactors = exports.MyriadProBoldMetrics = exports.MyriadProBoldItalicMetrics = exports.MyriadProBoldItalicFactors = exports.MyriadProBoldFactors = void 0;
const MyriadProBoldFactors = [1.36898, 1, 1, 0.72706, 0.80479, 0.83734, 0.98894, 0.99793, 0.9897, 0.93884, 0.86209, 0.94292, 0.94292, 1.16661, 1.02058, 0.93582, 0.96694, 0.93582, 1.19137, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.78076, 0.78076, 1.02058, 1.02058, 1.02058, 0.72851, 0.78966, 0.90838, 0.83637, 0.82391, 0.96376, 0.80061, 0.86275, 0.8768, 0.95407, 1.0258, 0.73901, 0.85022, 0.83655, 1.0156, 0.95546, 0.92179, 0.87107, 0.92179, 0.82114, 0.8096, 0.89713, 0.94438, 0.95353, 0.94083, 0.91905, 0.90406, 0.9446, 0.94292, 1.18777, 0.94292, 1.02058, 0.89903, 0.90088, 0.94938, 0.97898, 0.81093, 0.97571, 0.94938, 1.024, 0.9577, 0.95933, 0.98621, 1.0474, 0.97455, 0.98981, 0.9672, 0.95933, 0.9446, 0.97898, 0.97407, 0.97646, 0.78036, 1.10208, 0.95442, 0.95298, 0.97579, 0.9332, 0.94039, 0.938, 0.80687, 1.01149, 0.80687, 1.02058, 0.80479, 0.99793, 0.99793, 0.99793, 0.99793, 1.01149, 1.00872, 0.90088, 0.91882, 1.0213, 0.8361, 1.02058, 0.62295, 0.54324, 0.89022, 1.08595, 1, 1, 0.90088, 1, 0.97455, 0.93582, 0.90088, 1, 1.05686, 0.8361, 0.99642, 0.99642, 0.99642, 0.72851, 0.90838, 0.90838, 0.90838, 0.90838, 0.90838, 0.90838, 0.868, 0.82391, 0.80061, 0.80061, 0.80061, 0.80061, 1.0258, 1.0258, 1.0258, 1.0258, 0.97484, 0.95546, 0.92179, 0.92179, 0.92179, 0.92179, 0.92179, 1.02058, 0.92179, 0.94438, 0.94438, 0.94438, 0.94438, 0.90406, 0.86958, 0.98225, 0.94938, 0.94938, 0.94938, 0.94938, 0.94938, 0.94938, 0.9031, 0.81093, 0.94938, 0.94938, 0.94938, 0.94938, 0.98621, 0.98621, 0.98621, 0.98621, 0.93969, 0.95933, 0.9446, 0.9446, 0.9446, 0.9446, 0.9446, 1.08595, 0.9446, 0.95442, 0.95442, 0.95442, 0.95442, 0.94039, 0.97898, 0.94039, 0.90838, 0.94938, 0.90838, 0.94938, 0.90838, 0.94938, 0.82391, 0.81093, 0.82391, 0.81093, 0.82391, 0.81093, 0.82391, 0.81093, 0.96376, 0.84313, 0.97484, 0.97571, 0.80061, 0.94938, 0.80061, 0.94938, 0.80061, 0.94938, 0.80061, 0.94938, 0.80061, 0.94938, 0.8768, 0.9577, 0.8768, 0.9577, 0.8768, 0.9577, 1, 1, 0.95407, 0.95933, 0.97069, 0.95933, 1.0258, 0.98621, 1.0258, 0.98621, 1.0258, 0.98621, 1.0258, 0.98621, 1.0258, 0.98621, 0.887, 1.01591, 0.73901, 1.0474, 1, 1, 0.97455, 0.83655, 0.98981, 1, 1, 0.83655, 0.73977, 0.83655, 0.73903, 0.84638, 1.033, 0.95546, 0.95933, 1, 1, 0.95546, 0.95933, 0.8271, 0.95417, 0.95933, 0.92179, 0.9446, 0.92179, 0.9446, 0.92179, 0.9446, 0.936, 0.91964, 0.82114, 0.97646, 1, 1, 0.82114, 0.97646, 0.8096, 0.78036, 0.8096, 0.78036, 1, 1, 0.8096, 0.78036, 1, 1, 0.89713, 0.77452, 0.89713, 1.10208, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94083, 0.97579, 0.90406, 0.94039, 0.90406, 0.9446, 0.938, 0.9446, 0.938, 0.9446, 0.938, 1, 0.99793, 0.90838, 0.94938, 0.868, 0.9031, 0.92179, 0.9446, 1, 1, 0.89713, 1.10208, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90989, 0.9358, 0.91945, 0.83181, 0.75261, 0.87992, 0.82976, 0.96034, 0.83689, 0.97268, 1.0078, 0.90838, 0.83637, 0.8019, 0.90157, 0.80061, 0.9446, 0.95407, 0.92436, 1.0258, 0.85022, 0.97153, 1.0156, 0.95546, 0.89192, 0.92179, 0.92361, 0.87107, 0.96318, 0.89713, 0.93704, 0.95638, 0.91905, 0.91709, 0.92796, 1.0258, 0.93704, 0.94836, 1.0373, 0.95933, 1.0078, 0.95871, 0.94836, 0.96174, 0.92601, 0.9498, 0.98607, 0.95776, 0.95933, 1.05453, 1.0078, 0.98275, 0.9314, 0.95617, 0.91701, 1.05993, 0.9446, 0.78367, 0.9553, 1, 0.86832, 1.0128, 0.95871, 0.99394, 0.87548, 0.96361, 0.86774, 1.0078, 0.95871, 0.9446, 0.95871, 0.86774, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.94083, 0.97579, 0.94083, 0.97579, 0.94083, 0.97579, 0.90406, 0.94039, 0.96694, 1, 0.89903, 1, 1, 1, 0.93582, 0.93582, 0.93582, 1, 0.908, 0.908, 0.918, 0.94219, 0.94219, 0.96544, 1, 1.285, 1, 1, 0.81079, 0.81079, 1, 1, 0.74854, 1, 1, 1, 1, 0.99793, 1, 1, 1, 0.65, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.17173, 1, 0.80535, 0.76169, 1.02058, 1.0732, 1.05486, 1, 1, 1.30692, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.16161, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProBoldFactors = MyriadProBoldFactors;
const MyriadProBoldMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProBoldMetrics = MyriadProBoldMetrics;
const MyriadProBoldItalicFactors = [1.36898, 1, 1, 0.66227, 0.80779, 0.81625, 0.97276, 0.97276, 0.97733, 0.92222, 0.83266, 0.94292, 0.94292, 1.16148, 1.02058, 0.93582, 0.96694, 0.93582, 1.17337, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.78076, 0.78076, 1.02058, 1.02058, 1.02058, 0.71541, 0.76813, 0.85576, 0.80591, 0.80729, 0.94299, 0.77512, 0.83655, 0.86523, 0.92222, 0.98621, 0.71743, 0.81698, 0.79726, 0.98558, 0.92222, 0.90637, 0.83809, 0.90637, 0.80729, 0.76463, 0.86275, 0.90699, 0.91605, 0.9154, 0.85308, 0.85458, 0.90531, 0.94292, 1.21296, 0.94292, 1.02058, 0.89903, 1.18616, 0.99613, 0.91677, 0.78216, 0.91677, 0.90083, 0.98796, 0.9135, 0.92168, 0.95381, 0.98981, 0.95298, 0.95381, 0.93459, 0.92168, 0.91513, 0.92004, 0.91677, 0.95077, 0.748, 1.04502, 0.91677, 0.92061, 0.94236, 0.89544, 0.89364, 0.9, 0.80687, 0.8578, 0.80687, 1.02058, 0.80779, 0.97276, 0.97276, 0.97276, 0.97276, 0.8578, 0.99973, 1.18616, 0.91339, 1.08074, 0.82891, 1.02058, 0.55509, 0.71526, 0.89022, 1.08595, 1, 1, 1.18616, 1, 0.96736, 0.93582, 1.18616, 1, 1.04864, 0.82711, 0.99043, 0.99043, 0.99043, 0.71541, 0.85576, 0.85576, 0.85576, 0.85576, 0.85576, 0.85576, 0.845, 0.80729, 0.77512, 0.77512, 0.77512, 0.77512, 0.98621, 0.98621, 0.98621, 0.98621, 0.95961, 0.92222, 0.90637, 0.90637, 0.90637, 0.90637, 0.90637, 1.02058, 0.90251, 0.90699, 0.90699, 0.90699, 0.90699, 0.85458, 0.83659, 0.94951, 0.99613, 0.99613, 0.99613, 0.99613, 0.99613, 0.99613, 0.85811, 0.78216, 0.90083, 0.90083, 0.90083, 0.90083, 0.95381, 0.95381, 0.95381, 0.95381, 0.9135, 0.92168, 0.91513, 0.91513, 0.91513, 0.91513, 0.91513, 1.08595, 0.91677, 0.91677, 0.91677, 0.91677, 0.91677, 0.89364, 0.92332, 0.89364, 0.85576, 0.99613, 0.85576, 0.99613, 0.85576, 0.99613, 0.80729, 0.78216, 0.80729, 0.78216, 0.80729, 0.78216, 0.80729, 0.78216, 0.94299, 0.76783, 0.95961, 0.91677, 0.77512, 0.90083, 0.77512, 0.90083, 0.77512, 0.90083, 0.77512, 0.90083, 0.77512, 0.90083, 0.86523, 0.9135, 0.86523, 0.9135, 0.86523, 0.9135, 1, 1, 0.92222, 0.92168, 0.92222, 0.92168, 0.98621, 0.95381, 0.98621, 0.95381, 0.98621, 0.95381, 0.98621, 0.95381, 0.98621, 0.95381, 0.86036, 0.97096, 0.71743, 0.98981, 1, 1, 0.95298, 0.79726, 0.95381, 1, 1, 0.79726, 0.6894, 0.79726, 0.74321, 0.81691, 1.0006, 0.92222, 0.92168, 1, 1, 0.92222, 0.92168, 0.79464, 0.92098, 0.92168, 0.90637, 0.91513, 0.90637, 0.91513, 0.90637, 0.91513, 0.909, 0.87514, 0.80729, 0.95077, 1, 1, 0.80729, 0.95077, 0.76463, 0.748, 0.76463, 0.748, 1, 1, 0.76463, 0.748, 1, 1, 0.86275, 0.72651, 0.86275, 1.04502, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.9154, 0.94236, 0.85458, 0.89364, 0.85458, 0.90531, 0.9, 0.90531, 0.9, 0.90531, 0.9, 1, 0.97276, 0.85576, 0.99613, 0.845, 0.85811, 0.90251, 0.91677, 1, 1, 0.86275, 1.04502, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.00899, 1.30628, 0.85576, 0.80178, 0.66862, 0.7927, 0.69323, 0.88127, 0.72459, 0.89711, 0.95381, 0.85576, 0.80591, 0.7805, 0.94729, 0.77512, 0.90531, 0.92222, 0.90637, 0.98621, 0.81698, 0.92655, 0.98558, 0.92222, 0.85359, 0.90637, 0.90976, 0.83809, 0.94523, 0.86275, 0.83509, 0.93157, 0.85308, 0.83392, 0.92346, 0.98621, 0.83509, 0.92886, 0.91324, 0.92168, 0.95381, 0.90646, 0.92886, 0.90557, 0.86847, 0.90276, 0.91324, 0.86842, 0.92168, 0.99531, 0.95381, 0.9224, 0.85408, 0.92699, 0.86847, 1.0051, 0.91513, 0.80487, 0.93481, 1, 0.88159, 1.05214, 0.90646, 0.97355, 0.81539, 0.89398, 0.85923, 0.95381, 0.90646, 0.91513, 0.90646, 0.85923, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.9154, 0.94236, 0.9154, 0.94236, 0.9154, 0.94236, 0.85458, 0.89364, 0.96694, 1, 0.89903, 1, 1, 1, 0.91782, 0.91782, 0.91782, 1, 0.896, 0.896, 0.896, 0.9332, 0.9332, 0.95973, 1, 1.26, 1, 1, 0.80479, 0.80178, 1, 1, 0.85633, 1, 1, 1, 1, 0.97276, 1, 1, 1, 0.698, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.14542, 1, 0.79199, 0.78694, 1.02058, 1.03493, 1.05486, 1, 1, 1.23026, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.20006, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProBoldItalicFactors = MyriadProBoldItalicFactors;
const MyriadProBoldItalicMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProBoldItalicMetrics = MyriadProBoldItalicMetrics;
const MyriadProItalicFactors = [1.36898, 1, 1, 0.65507, 0.84943, 0.85639, 0.88465, 0.88465, 0.86936, 0.88307, 0.86948, 0.85283, 0.85283, 1.06383, 1.02058, 0.75945, 0.9219, 0.75945, 1.17337, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.75945, 0.75945, 1.02058, 1.02058, 1.02058, 0.69046, 0.70926, 0.85158, 0.77812, 0.76852, 0.89591, 0.70466, 0.76125, 0.80094, 0.86822, 0.83864, 0.728, 0.77212, 0.79475, 0.93637, 0.87514, 0.8588, 0.76013, 0.8588, 0.72421, 0.69866, 0.77598, 0.85991, 0.80811, 0.87832, 0.78112, 0.77512, 0.8562, 1.0222, 1.18417, 1.0222, 1.27014, 0.89903, 1.15012, 0.93859, 0.94399, 0.846, 0.94399, 0.81453, 1.0186, 0.94219, 0.96017, 1.03075, 1.02175, 0.912, 1.03075, 0.96998, 0.96017, 0.93859, 0.94399, 0.94399, 0.95493, 0.746, 1.12658, 0.94578, 0.91, 0.979, 0.882, 0.882, 0.83, 0.85034, 0.83537, 0.85034, 1.02058, 0.70869, 0.88465, 0.88465, 0.88465, 0.88465, 0.83537, 0.90083, 1.15012, 0.9161, 0.94565, 0.73541, 1.02058, 0.53609, 0.69353, 0.79519, 1.08595, 1, 1, 1.15012, 1, 0.91974, 0.75945, 1.15012, 1, 0.9446, 0.73361, 0.9005, 0.9005, 0.9005, 0.62864, 0.85158, 0.85158, 0.85158, 0.85158, 0.85158, 0.85158, 0.773, 0.76852, 0.70466, 0.70466, 0.70466, 0.70466, 0.83864, 0.83864, 0.83864, 0.83864, 0.90561, 0.87514, 0.8588, 0.8588, 0.8588, 0.8588, 0.8588, 1.02058, 0.85751, 0.85991, 0.85991, 0.85991, 0.85991, 0.77512, 0.76013, 0.88075, 0.93859, 0.93859, 0.93859, 0.93859, 0.93859, 0.93859, 0.8075, 0.846, 0.81453, 0.81453, 0.81453, 0.81453, 0.82424, 0.82424, 0.82424, 0.82424, 0.9278, 0.96017, 0.93859, 0.93859, 0.93859, 0.93859, 0.93859, 1.08595, 0.8562, 0.94578, 0.94578, 0.94578, 0.94578, 0.882, 0.94578, 0.882, 0.85158, 0.93859, 0.85158, 0.93859, 0.85158, 0.93859, 0.76852, 0.846, 0.76852, 0.846, 0.76852, 0.846, 0.76852, 0.846, 0.89591, 0.8544, 0.90561, 0.94399, 0.70466, 0.81453, 0.70466, 0.81453, 0.70466, 0.81453, 0.70466, 0.81453, 0.70466, 0.81453, 0.80094, 0.94219, 0.80094, 0.94219, 0.80094, 0.94219, 1, 1, 0.86822, 0.96017, 0.86822, 0.96017, 0.83864, 0.82424, 0.83864, 0.82424, 0.83864, 0.82424, 0.83864, 1.03075, 0.83864, 0.82424, 0.81402, 1.02738, 0.728, 1.02175, 1, 1, 0.912, 0.79475, 1.03075, 1, 1, 0.79475, 0.83911, 0.79475, 0.66266, 0.80553, 1.06676, 0.87514, 0.96017, 1, 1, 0.87514, 0.96017, 0.86865, 0.87396, 0.96017, 0.8588, 0.93859, 0.8588, 0.93859, 0.8588, 0.93859, 0.867, 0.84759, 0.72421, 0.95493, 1, 1, 0.72421, 0.95493, 0.69866, 0.746, 0.69866, 0.746, 1, 1, 0.69866, 0.746, 1, 1, 0.77598, 0.88417, 0.77598, 1.12658, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.87832, 0.979, 0.77512, 0.882, 0.77512, 0.8562, 0.83, 0.8562, 0.83, 0.8562, 0.83, 1, 0.88465, 0.85158, 0.93859, 0.773, 0.8075, 0.85751, 0.8562, 1, 1, 0.77598, 1.12658, 1.15012, 1.15012, 1.15012, 1.15012, 1.15012, 1.15313, 1.15012, 1.15012, 1.15012, 1.08106, 1.03901, 0.85158, 0.77025, 0.62264, 0.7646, 0.65351, 0.86026, 0.69461, 0.89947, 1.03075, 0.85158, 0.77812, 0.76449, 0.88836, 0.70466, 0.8562, 0.86822, 0.8588, 0.83864, 0.77212, 0.85308, 0.93637, 0.87514, 0.82352, 0.8588, 0.85701, 0.76013, 0.89058, 0.77598, 0.8156, 0.82565, 0.78112, 0.77899, 0.89386, 0.83864, 0.8156, 0.9486, 0.92388, 0.96186, 1.03075, 0.91123, 0.9486, 0.93298, 0.878, 0.93942, 0.92388, 0.84596, 0.96186, 0.95119, 1.03075, 0.922, 0.88787, 0.95829, 0.88, 0.93559, 0.93859, 0.78815, 0.93758, 1, 0.89217, 1.03737, 0.91123, 0.93969, 0.77487, 0.85769, 0.86799, 1.03075, 0.91123, 0.93859, 0.91123, 0.86799, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.87832, 0.979, 0.87832, 0.979, 0.87832, 0.979, 0.77512, 0.882, 0.9219, 1, 0.89903, 1, 1, 1, 0.87321, 0.87321, 0.87321, 1, 1.027, 1.027, 1.027, 0.86847, 0.86847, 0.79121, 1, 1.124, 1, 1, 0.73572, 0.73572, 1, 1, 0.85034, 1, 1, 1, 1, 0.88465, 1, 1, 1, 0.669, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.04828, 1, 0.74948, 0.75187, 1.02058, 0.98391, 1.02119, 1, 1, 1.06233, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05233, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProItalicFactors = MyriadProItalicFactors;
const MyriadProItalicMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProItalicMetrics = MyriadProItalicMetrics;
const MyriadProRegularFactors = [1.36898, 1, 1, 0.76305, 0.82784, 0.94935, 0.89364, 0.92241, 0.89073, 0.90706, 0.98472, 0.85283, 0.85283, 1.0664, 1.02058, 0.74505, 0.9219, 0.74505, 1.23456, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.74505, 0.74505, 1.02058, 1.02058, 1.02058, 0.73002, 0.72601, 0.91755, 0.8126, 0.80314, 0.92222, 0.73764, 0.79726, 0.83051, 0.90284, 0.86023, 0.74, 0.8126, 0.84869, 0.96518, 0.91115, 0.8858, 0.79761, 0.8858, 0.74498, 0.73914, 0.81363, 0.89591, 0.83659, 0.89633, 0.85608, 0.8111, 0.90531, 1.0222, 1.22736, 1.0222, 1.27014, 0.89903, 0.90088, 0.86667, 1.0231, 0.896, 1.01411, 0.90083, 1.05099, 1.00512, 0.99793, 1.05326, 1.09377, 0.938, 1.06226, 1.00119, 0.99793, 0.98714, 1.0231, 1.01231, 0.98196, 0.792, 1.19137, 0.99074, 0.962, 1.01915, 0.926, 0.942, 0.856, 0.85034, 0.92006, 0.85034, 1.02058, 0.69067, 0.92241, 0.92241, 0.92241, 0.92241, 0.92006, 0.9332, 0.90088, 0.91882, 0.93484, 0.75339, 1.02058, 0.56866, 0.54324, 0.79519, 1.08595, 1, 1, 0.90088, 1, 0.95325, 0.74505, 0.90088, 1, 0.97198, 0.75339, 0.91009, 0.91009, 0.91009, 0.66466, 0.91755, 0.91755, 0.91755, 0.91755, 0.91755, 0.91755, 0.788, 0.80314, 0.73764, 0.73764, 0.73764, 0.73764, 0.86023, 0.86023, 0.86023, 0.86023, 0.92915, 0.91115, 0.8858, 0.8858, 0.8858, 0.8858, 0.8858, 1.02058, 0.8858, 0.89591, 0.89591, 0.89591, 0.89591, 0.8111, 0.79611, 0.89713, 0.86667, 0.86667, 0.86667, 0.86667, 0.86667, 0.86667, 0.86936, 0.896, 0.90083, 0.90083, 0.90083, 0.90083, 0.84224, 0.84224, 0.84224, 0.84224, 0.97276, 0.99793, 0.98714, 0.98714, 0.98714, 0.98714, 0.98714, 1.08595, 0.89876, 0.99074, 0.99074, 0.99074, 0.99074, 0.942, 1.0231, 0.942, 0.91755, 0.86667, 0.91755, 0.86667, 0.91755, 0.86667, 0.80314, 0.896, 0.80314, 0.896, 0.80314, 0.896, 0.80314, 0.896, 0.92222, 0.93372, 0.92915, 1.01411, 0.73764, 0.90083, 0.73764, 0.90083, 0.73764, 0.90083, 0.73764, 0.90083, 0.73764, 0.90083, 0.83051, 1.00512, 0.83051, 1.00512, 0.83051, 1.00512, 1, 1, 0.90284, 0.99793, 0.90976, 0.99793, 0.86023, 0.84224, 0.86023, 0.84224, 0.86023, 0.84224, 0.86023, 1.05326, 0.86023, 0.84224, 0.82873, 1.07469, 0.74, 1.09377, 1, 1, 0.938, 0.84869, 1.06226, 1, 1, 0.84869, 0.83704, 0.84869, 0.81441, 0.85588, 1.08927, 0.91115, 0.99793, 1, 1, 0.91115, 0.99793, 0.91887, 0.90991, 0.99793, 0.8858, 0.98714, 0.8858, 0.98714, 0.8858, 0.98714, 0.894, 0.91434, 0.74498, 0.98196, 1, 1, 0.74498, 0.98196, 0.73914, 0.792, 0.73914, 0.792, 1, 1, 0.73914, 0.792, 1, 1, 0.81363, 0.904, 0.81363, 1.19137, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89633, 1.01915, 0.8111, 0.942, 0.8111, 0.90531, 0.856, 0.90531, 0.856, 0.90531, 0.856, 1, 0.92241, 0.91755, 0.86667, 0.788, 0.86936, 0.8858, 0.89876, 1, 1, 0.81363, 1.19137, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90388, 1.03901, 0.92138, 0.78105, 0.7154, 0.86169, 0.80513, 0.94007, 0.82528, 0.98612, 1.06226, 0.91755, 0.8126, 0.81884, 0.92819, 0.73764, 0.90531, 0.90284, 0.8858, 0.86023, 0.8126, 0.91172, 0.96518, 0.91115, 0.83089, 0.8858, 0.87791, 0.79761, 0.89297, 0.81363, 0.88157, 0.89992, 0.85608, 0.81992, 0.94307, 0.86023, 0.88157, 0.95308, 0.98699, 0.99793, 1.06226, 0.95817, 0.95308, 0.97358, 0.928, 0.98088, 0.98699, 0.92761, 0.99793, 0.96017, 1.06226, 0.986, 0.944, 0.95978, 0.938, 0.96705, 0.98714, 0.80442, 0.98972, 1, 0.89762, 1.04552, 0.95817, 0.99007, 0.87064, 0.91879, 0.88888, 1.06226, 0.95817, 0.98714, 0.95817, 0.88888, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.89633, 1.01915, 0.89633, 1.01915, 0.89633, 1.01915, 0.8111, 0.942, 0.9219, 1, 0.89903, 1, 1, 1, 0.93173, 0.93173, 0.93173, 1, 1.06304, 1.06304, 1.06904, 0.89903, 0.89903, 0.80549, 1, 1.156, 1, 1, 0.76575, 0.76575, 1, 1, 0.72458, 1, 1, 1, 1, 0.92241, 1, 1, 1, 0.619, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.07257, 1, 0.74705, 0.71119, 1.02058, 1.024, 1.02119, 1, 1, 1.1536, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05638, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProRegularFactors = MyriadProRegularFactors;
const MyriadProRegularMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProRegularMetrics = MyriadProRegularMetrics;

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SegoeuiRegularMetrics = exports.SegoeuiRegularFactors = exports.SegoeuiItalicMetrics = exports.SegoeuiItalicFactors = exports.SegoeuiBoldMetrics = exports.SegoeuiBoldItalicMetrics = exports.SegoeuiBoldItalicFactors = exports.SegoeuiBoldFactors = void 0;
const SegoeuiBoldFactors = [1.76738, 1, 1, 0.99297, 0.9824, 1.04016, 1.06497, 1.03424, 0.97529, 1.17647, 1.23203, 1.1085, 1.1085, 1.16939, 1.2107, 0.9754, 1.21408, 0.9754, 1.59578, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 0.81378, 0.81378, 1.2107, 1.2107, 1.2107, 0.71703, 0.97847, 0.97363, 0.88776, 0.8641, 1.02096, 0.79795, 0.85132, 0.914, 1.06085, 1.1406, 0.8007, 0.89858, 0.83693, 1.14889, 1.09398, 0.97489, 0.92094, 0.97489, 0.90399, 0.84041, 0.95923, 1.00135, 1, 1.06467, 0.98243, 0.90996, 0.99361, 1.1085, 1.56942, 1.1085, 1.2107, 0.74627, 0.94282, 0.96752, 1.01519, 0.86304, 1.01359, 0.97278, 1.15103, 1.01359, 0.98561, 1.02285, 1.02285, 1.00527, 1.02285, 1.0302, 0.99041, 1.0008, 1.01519, 1.01359, 1.02258, 0.79104, 1.16862, 0.99041, 0.97454, 1.02511, 0.99298, 0.96752, 0.95801, 0.94856, 1.16579, 0.94856, 1.2107, 0.9824, 1.03424, 1.03424, 1, 1.03424, 1.16579, 0.8727, 1.3871, 1.18622, 1.10818, 1.04478, 1.2107, 1.18622, 0.75155, 0.94994, 1.28826, 1.21408, 1.21408, 0.91056, 1, 0.91572, 0.9754, 0.64663, 1.18328, 1.24866, 1.04478, 1.14169, 1.15749, 1.17389, 0.71703, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.93506, 0.8641, 0.79795, 0.79795, 0.79795, 0.79795, 1.1406, 1.1406, 1.1406, 1.1406, 1.02096, 1.09398, 0.97426, 0.97426, 0.97426, 0.97426, 0.97426, 1.2107, 0.97489, 1.00135, 1.00135, 1.00135, 1.00135, 0.90996, 0.92094, 1.02798, 0.96752, 0.96752, 0.96752, 0.96752, 0.96752, 0.96752, 0.93136, 0.86304, 0.97278, 0.97278, 0.97278, 0.97278, 1.02285, 1.02285, 1.02285, 1.02285, 0.97122, 0.99041, 1, 1, 1, 1, 1, 1.28826, 1.0008, 0.99041, 0.99041, 0.99041, 0.99041, 0.96752, 1.01519, 0.96752, 0.97363, 0.96752, 0.97363, 0.96752, 0.97363, 0.96752, 0.8641, 0.86304, 0.8641, 0.86304, 0.8641, 0.86304, 0.8641, 0.86304, 1.02096, 1.03057, 1.02096, 1.03517, 0.79795, 0.97278, 0.79795, 0.97278, 0.79795, 0.97278, 0.79795, 0.97278, 0.79795, 0.97278, 0.914, 1.01359, 0.914, 1.01359, 0.914, 1.01359, 1, 1, 1.06085, 0.98561, 1.06085, 1.00879, 1.1406, 1.02285, 1.1406, 1.02285, 1.1406, 1.02285, 1.1406, 1.02285, 1.1406, 1.02285, 0.97138, 1.08692, 0.8007, 1.02285, 1, 1, 1.00527, 0.83693, 1.02285, 1, 1, 0.83693, 0.9455, 0.83693, 0.90418, 0.83693, 1.13005, 1.09398, 0.99041, 1, 1, 1.09398, 0.99041, 0.96692, 1.09251, 0.99041, 0.97489, 1.0008, 0.97489, 1.0008, 0.97489, 1.0008, 0.93994, 0.97931, 0.90399, 1.02258, 1, 1, 0.90399, 1.02258, 0.84041, 0.79104, 0.84041, 0.79104, 0.84041, 0.79104, 0.84041, 0.79104, 1, 1, 0.95923, 1.07034, 0.95923, 1.16862, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.06467, 1.02511, 0.90996, 0.96752, 0.90996, 0.99361, 0.95801, 0.99361, 0.95801, 0.99361, 0.95801, 1.07733, 1.03424, 0.97363, 0.96752, 0.93506, 0.93136, 0.97489, 1.0008, 1, 1, 0.95923, 1.16862, 1.15103, 1.15103, 1.01173, 1.03959, 0.75953, 0.81378, 0.79912, 1.15103, 1.21994, 0.95161, 0.87815, 1.01149, 0.81525, 0.7676, 0.98167, 1.01134, 1.02546, 0.84097, 1.03089, 1.18102, 0.97363, 0.88776, 0.85134, 0.97826, 0.79795, 0.99361, 1.06085, 0.97489, 1.1406, 0.89858, 1.0388, 1.14889, 1.09398, 0.86039, 0.97489, 1.0595, 0.92094, 0.94793, 0.95923, 0.90996, 0.99346, 0.98243, 1.02112, 0.95493, 1.1406, 0.90996, 1.03574, 1.02597, 1.0008, 1.18102, 1.06628, 1.03574, 1.0192, 1.01932, 1.00886, 0.97531, 1.0106, 1.0008, 1.13189, 1.18102, 1.02277, 0.98683, 1.0016, 0.99561, 1.07237, 1.0008, 0.90434, 0.99921, 0.93803, 0.8965, 1.23085, 1.06628, 1.04983, 0.96268, 1.0499, 0.98439, 1.18102, 1.06628, 1.0008, 1.06628, 0.98439, 0.79795, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.09466, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.97278, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.02065, 1, 1, 1, 1, 1, 1, 1.06467, 1.02511, 1.06467, 1.02511, 1.06467, 1.02511, 0.90996, 0.96752, 1, 1.21408, 0.89903, 1, 1, 0.75155, 1.04394, 1.04394, 1.04394, 1.04394, 0.98633, 0.98633, 0.98633, 0.73047, 0.73047, 1.20642, 0.91211, 1.25635, 1.222, 1.02956, 1.03372, 1.03372, 0.96039, 1.24633, 1, 1.12454, 0.93503, 1.03424, 1.19687, 1.03424, 1, 1, 1, 0.771, 1, 1, 1.15749, 1.15749, 1.15749, 1.10948, 0.86279, 0.94434, 0.86279, 0.94434, 0.86182, 1, 1, 1.16897, 1, 0.96085, 0.90137, 1.2107, 1.18416, 1.13973, 0.69825, 0.9716, 2.10339, 1.29004, 1.29004, 1.21172, 1.29004, 1.29004, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.18874, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.09193, 1.09193, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiBoldFactors = SegoeuiBoldFactors;
const SegoeuiBoldMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiBoldMetrics = SegoeuiBoldMetrics;
const SegoeuiBoldItalicFactors = [1.76738, 1, 1, 0.98946, 1.03959, 1.04016, 1.02809, 1.036, 0.97639, 1.10953, 1.23203, 1.11144, 1.11144, 1.16939, 1.21237, 0.9754, 1.21261, 0.9754, 1.59754, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 0.81378, 0.81378, 1.21237, 1.21237, 1.21237, 0.73541, 0.97847, 0.97363, 0.89723, 0.87897, 1.0426, 0.79429, 0.85292, 0.91149, 1.05815, 1.1406, 0.79631, 0.90128, 0.83853, 1.04396, 1.10615, 0.97552, 0.94436, 0.97552, 0.88641, 0.80527, 0.96083, 1.00135, 1, 1.06777, 0.9817, 0.91142, 0.99361, 1.11144, 1.57293, 1.11144, 1.21237, 0.74627, 1.31818, 1.06585, 0.97042, 0.83055, 0.97042, 0.93503, 1.1261, 0.97042, 0.97922, 1.14236, 0.94552, 1.01054, 1.14236, 1.02471, 0.97922, 0.94165, 0.97042, 0.97042, 1.0276, 0.78929, 1.1261, 0.97922, 0.95874, 1.02197, 0.98507, 0.96752, 0.97168, 0.95107, 1.16579, 0.95107, 1.21237, 1.03959, 1.036, 1.036, 1, 1.036, 1.16579, 0.87357, 1.31818, 1.18754, 1.26781, 1.05356, 1.21237, 1.18622, 0.79487, 0.94994, 1.29004, 1.24047, 1.24047, 1.31818, 1, 0.91484, 0.9754, 1.31818, 1.1349, 1.24866, 1.05356, 1.13934, 1.15574, 1.17389, 0.73541, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.94385, 0.87897, 0.79429, 0.79429, 0.79429, 0.79429, 1.1406, 1.1406, 1.1406, 1.1406, 1.0426, 1.10615, 0.97552, 0.97552, 0.97552, 0.97552, 0.97552, 1.21237, 0.97552, 1.00135, 1.00135, 1.00135, 1.00135, 0.91142, 0.94436, 0.98721, 1.06585, 1.06585, 1.06585, 1.06585, 1.06585, 1.06585, 0.96705, 0.83055, 0.93503, 0.93503, 0.93503, 0.93503, 1.14236, 1.14236, 1.14236, 1.14236, 0.93125, 0.97922, 0.94165, 0.94165, 0.94165, 0.94165, 0.94165, 1.29004, 0.94165, 0.97922, 0.97922, 0.97922, 0.97922, 0.96752, 0.97042, 0.96752, 0.97363, 1.06585, 0.97363, 1.06585, 0.97363, 1.06585, 0.87897, 0.83055, 0.87897, 0.83055, 0.87897, 0.83055, 0.87897, 0.83055, 1.0426, 1.0033, 1.0426, 0.97042, 0.79429, 0.93503, 0.79429, 0.93503, 0.79429, 0.93503, 0.79429, 0.93503, 0.79429, 0.93503, 0.91149, 0.97042, 0.91149, 0.97042, 0.91149, 0.97042, 1, 1, 1.05815, 0.97922, 1.05815, 0.97922, 1.1406, 1.14236, 1.1406, 1.14236, 1.1406, 1.14236, 1.1406, 1.14236, 1.1406, 1.14236, 0.97441, 1.04302, 0.79631, 1.01582, 1, 1, 1.01054, 0.83853, 1.14236, 1, 1, 0.83853, 1.09125, 0.83853, 0.90418, 0.83853, 1.19508, 1.10615, 0.97922, 1, 1, 1.10615, 0.97922, 1.01034, 1.10466, 0.97922, 0.97552, 0.94165, 0.97552, 0.94165, 0.97552, 0.94165, 0.91602, 0.91981, 0.88641, 1.0276, 1, 1, 0.88641, 1.0276, 0.80527, 0.78929, 0.80527, 0.78929, 0.80527, 0.78929, 0.80527, 0.78929, 1, 1, 0.96083, 1.05403, 0.95923, 1.16862, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.06777, 1.02197, 0.91142, 0.96752, 0.91142, 0.99361, 0.97168, 0.99361, 0.97168, 0.99361, 0.97168, 1.23199, 1.036, 0.97363, 1.06585, 0.94385, 0.96705, 0.97552, 0.94165, 1, 1, 0.96083, 1.1261, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 0.95161, 1.27126, 1.00811, 0.83284, 0.77702, 0.99137, 0.95253, 1.0347, 0.86142, 1.07205, 1.14236, 0.97363, 0.89723, 0.86869, 1.09818, 0.79429, 0.99361, 1.05815, 0.97552, 1.1406, 0.90128, 1.06662, 1.04396, 1.10615, 0.84918, 0.97552, 1.04694, 0.94436, 0.98015, 0.96083, 0.91142, 1.00356, 0.9817, 1.01945, 0.98999, 1.1406, 0.91142, 1.04961, 0.9898, 1.00639, 1.14236, 1.07514, 1.04961, 0.99607, 1.02897, 1.008, 0.9898, 0.95134, 1.00639, 1.11121, 1.14236, 1.00518, 0.97981, 1.02186, 1, 1.08578, 0.94165, 0.99314, 0.98387, 0.93028, 0.93377, 1.35125, 1.07514, 1.10687, 0.93491, 1.04232, 1.00351, 1.14236, 1.07514, 0.94165, 1.07514, 1.00351, 0.79429, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.09097, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.93503, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.96609, 1, 1, 1, 1, 1, 1, 1.06777, 1.02197, 1.06777, 1.02197, 1.06777, 1.02197, 0.91142, 0.96752, 1, 1.21261, 0.89903, 1, 1, 0.75155, 1.04745, 1.04745, 1.04745, 1.04394, 0.98633, 0.98633, 0.98633, 0.72959, 0.72959, 1.20502, 0.91406, 1.26514, 1.222, 1.02956, 1.03372, 1.03372, 0.96039, 1.24633, 1, 1.09125, 0.93327, 1.03336, 1.16541, 1.036, 1, 1, 1, 0.771, 1, 1, 1.15574, 1.15574, 1.15574, 1.15574, 0.86364, 0.94434, 0.86279, 0.94434, 0.86224, 1, 1, 1.16798, 1, 0.96085, 0.90068, 1.21237, 1.18416, 1.13904, 0.69825, 0.9716, 2.10339, 1.29004, 1.29004, 1.21339, 1.29004, 1.29004, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.18775, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.13269, 1.13269, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiBoldItalicFactors = SegoeuiBoldItalicFactors;
const SegoeuiBoldItalicMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiBoldItalicMetrics = SegoeuiBoldItalicMetrics;
const SegoeuiItalicFactors = [1.76738, 1, 1, 0.98946, 1.14763, 1.05365, 1.06234, 0.96927, 0.92586, 1.15373, 1.18414, 0.91349, 0.91349, 1.07403, 1.17308, 0.78383, 1.20088, 0.78383, 1.42531, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.78383, 0.78383, 1.17308, 1.17308, 1.17308, 0.77349, 0.94565, 0.94729, 0.85944, 0.88506, 0.9858, 0.74817, 0.80016, 0.88449, 0.98039, 0.95782, 0.69238, 0.89898, 0.83231, 0.98183, 1.03989, 0.96924, 0.86237, 0.96924, 0.80595, 0.74524, 0.86091, 0.95402, 0.94143, 0.98448, 0.8858, 0.83089, 0.93285, 1.0949, 1.39016, 1.0949, 1.45994, 0.74627, 1.04839, 0.97454, 0.97454, 0.87207, 0.97454, 0.87533, 1.06151, 0.97454, 1.00176, 1.16484, 1.08132, 0.98047, 1.16484, 1.02989, 1.01054, 0.96225, 0.97454, 0.97454, 1.06598, 0.79004, 1.16344, 1.00351, 0.94629, 0.9973, 0.91016, 0.96777, 0.9043, 0.91082, 0.92481, 0.91082, 1.17308, 0.95748, 0.96927, 0.96927, 1, 0.96927, 0.92481, 0.80597, 1.04839, 1.23393, 1.1781, 0.9245, 1.17308, 1.20808, 0.63218, 0.94261, 1.24822, 1.09971, 1.09971, 1.04839, 1, 0.85273, 0.78032, 1.04839, 1.09971, 1.22326, 0.9245, 1.09836, 1.13525, 1.15222, 0.70424, 0.94729, 0.94729, 0.94729, 0.94729, 0.94729, 0.94729, 0.85498, 0.88506, 0.74817, 0.74817, 0.74817, 0.74817, 0.95782, 0.95782, 0.95782, 0.95782, 0.9858, 1.03989, 0.96924, 0.96924, 0.96924, 0.96924, 0.96924, 1.17308, 0.96924, 0.95402, 0.95402, 0.95402, 0.95402, 0.83089, 0.86237, 0.88409, 0.97454, 0.97454, 0.97454, 0.97454, 0.97454, 0.97454, 0.92916, 0.87207, 0.87533, 0.87533, 0.87533, 0.87533, 0.93146, 0.93146, 0.93146, 0.93146, 0.93854, 1.01054, 0.96225, 0.96225, 0.96225, 0.96225, 0.96225, 1.24822, 0.8761, 1.00351, 1.00351, 1.00351, 1.00351, 0.96777, 0.97454, 0.96777, 0.94729, 0.97454, 0.94729, 0.97454, 0.94729, 0.97454, 0.88506, 0.87207, 0.88506, 0.87207, 0.88506, 0.87207, 0.88506, 0.87207, 0.9858, 0.95391, 0.9858, 0.97454, 0.74817, 0.87533, 0.74817, 0.87533, 0.74817, 0.87533, 0.74817, 0.87533, 0.74817, 0.87533, 0.88449, 0.97454, 0.88449, 0.97454, 0.88449, 0.97454, 1, 1, 0.98039, 1.00176, 0.98039, 1.00176, 0.95782, 0.93146, 0.95782, 0.93146, 0.95782, 0.93146, 0.95782, 1.16484, 0.95782, 0.93146, 0.84421, 1.12761, 0.69238, 1.08132, 1, 1, 0.98047, 0.83231, 1.16484, 1, 1, 0.84723, 1.04861, 0.84723, 0.78755, 0.83231, 1.23736, 1.03989, 1.01054, 1, 1, 1.03989, 1.01054, 0.9857, 1.03849, 1.01054, 0.96924, 0.96225, 0.96924, 0.96225, 0.96924, 0.96225, 0.92383, 0.90171, 0.80595, 1.06598, 1, 1, 0.80595, 1.06598, 0.74524, 0.79004, 0.74524, 0.79004, 0.74524, 0.79004, 0.74524, 0.79004, 1, 1, 0.86091, 1.02759, 0.85771, 1.16344, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.98448, 0.9973, 0.83089, 0.96777, 0.83089, 0.93285, 0.9043, 0.93285, 0.9043, 0.93285, 0.9043, 1.31868, 0.96927, 0.94729, 0.97454, 0.85498, 0.92916, 0.96924, 0.8761, 1, 1, 0.86091, 1.16344, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 0.81965, 0.81965, 0.94729, 0.78032, 0.71022, 0.90883, 0.84171, 0.99877, 0.77596, 1.05734, 1.2, 0.94729, 0.85944, 0.82791, 0.9607, 0.74817, 0.93285, 0.98039, 0.96924, 0.95782, 0.89898, 0.98316, 0.98183, 1.03989, 0.78614, 0.96924, 0.97642, 0.86237, 0.86075, 0.86091, 0.83089, 0.90082, 0.8858, 0.97296, 1.01284, 0.95782, 0.83089, 1.0976, 1.04, 1.03342, 1.2, 1.0675, 1.0976, 0.98205, 1.03809, 1.05097, 1.04, 0.95364, 1.03342, 1.05401, 1.2, 1.02148, 1.0119, 1.04724, 1.0127, 1.02732, 0.96225, 0.8965, 0.97783, 0.93574, 0.94818, 1.30679, 1.0675, 1.11826, 0.99821, 1.0557, 1.0326, 1.2, 1.0675, 0.96225, 1.0675, 1.0326, 0.74817, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.03754, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.87533, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.98705, 1, 1, 1, 1, 1, 1, 0.98448, 0.9973, 0.98448, 0.9973, 0.98448, 0.9973, 0.83089, 0.96777, 1, 1.20088, 0.89903, 1, 1, 0.75155, 0.94945, 0.94945, 0.94945, 0.94945, 1.12317, 1.12317, 1.12317, 0.67603, 0.67603, 1.15621, 0.73584, 1.21191, 1.22135, 1.06483, 0.94868, 0.94868, 0.95996, 1.24633, 1, 1.07497, 0.87709, 0.96927, 1.01473, 0.96927, 1, 1, 1, 0.77295, 1, 1, 1.09836, 1.09836, 1.09836, 1.01522, 0.86321, 0.94434, 0.8649, 0.94434, 0.86182, 1, 1, 1.083, 1, 0.91578, 0.86438, 1.17308, 1.18416, 1.14589, 0.69825, 0.97622, 1.96791, 1.24822, 1.24822, 1.17308, 1.24822, 1.24822, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.17984, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.10742, 1.10742, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiItalicFactors = SegoeuiItalicFactors;
const SegoeuiItalicMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiItalicMetrics = SegoeuiItalicMetrics;
const SegoeuiRegularFactors = [1.76738, 1, 1, 0.98594, 1.02285, 1.10454, 1.06234, 0.96927, 0.92037, 1.19985, 1.2046, 0.90616, 0.90616, 1.07152, 1.1714, 0.78032, 1.20088, 0.78032, 1.40246, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.78032, 0.78032, 1.1714, 1.1714, 1.1714, 0.80597, 0.94084, 0.96706, 0.85944, 0.85734, 0.97093, 0.75842, 0.79936, 0.88198, 0.9831, 0.95782, 0.71387, 0.86969, 0.84636, 1.07796, 1.03584, 0.96924, 0.83968, 0.96924, 0.82826, 0.79649, 0.85771, 0.95132, 0.93119, 0.98965, 0.88433, 0.8287, 0.93365, 1.08612, 1.3638, 1.08612, 1.45786, 0.74627, 0.80499, 0.91484, 1.05707, 0.92383, 1.05882, 0.9403, 1.12654, 1.05882, 1.01756, 1.09011, 1.09011, 0.99414, 1.09011, 1.034, 1.01756, 1.05356, 1.05707, 1.05882, 1.04399, 0.84863, 1.21968, 1.01756, 0.95801, 1.00068, 0.91797, 0.96777, 0.9043, 0.90351, 0.92105, 0.90351, 1.1714, 0.85337, 0.96927, 0.96927, 0.99912, 0.96927, 0.92105, 0.80597, 1.2434, 1.20808, 1.05937, 0.90957, 1.1714, 1.20808, 0.75155, 0.94261, 1.24644, 1.09971, 1.09971, 0.84751, 1, 0.85273, 0.78032, 0.61584, 1.05425, 1.17914, 0.90957, 1.08665, 1.11593, 1.14169, 0.73381, 0.96706, 0.96706, 0.96706, 0.96706, 0.96706, 0.96706, 0.86035, 0.85734, 0.75842, 0.75842, 0.75842, 0.75842, 0.95782, 0.95782, 0.95782, 0.95782, 0.97093, 1.03584, 0.96924, 0.96924, 0.96924, 0.96924, 0.96924, 1.1714, 0.96924, 0.95132, 0.95132, 0.95132, 0.95132, 0.8287, 0.83968, 0.89049, 0.91484, 0.91484, 0.91484, 0.91484, 0.91484, 0.91484, 0.93575, 0.92383, 0.9403, 0.9403, 0.9403, 0.9403, 0.8717, 0.8717, 0.8717, 0.8717, 1.00527, 1.01756, 1.05356, 1.05356, 1.05356, 1.05356, 1.05356, 1.24644, 0.95923, 1.01756, 1.01756, 1.01756, 1.01756, 0.96777, 1.05707, 0.96777, 0.96706, 0.91484, 0.96706, 0.91484, 0.96706, 0.91484, 0.85734, 0.92383, 0.85734, 0.92383, 0.85734, 0.92383, 0.85734, 0.92383, 0.97093, 1.0969, 0.97093, 1.05882, 0.75842, 0.9403, 0.75842, 0.9403, 0.75842, 0.9403, 0.75842, 0.9403, 0.75842, 0.9403, 0.88198, 1.05882, 0.88198, 1.05882, 0.88198, 1.05882, 1, 1, 0.9831, 1.01756, 0.9831, 1.01756, 0.95782, 0.8717, 0.95782, 0.8717, 0.95782, 0.8717, 0.95782, 1.09011, 0.95782, 0.8717, 0.84784, 1.11551, 0.71387, 1.09011, 1, 1, 0.99414, 0.84636, 1.09011, 1, 1, 0.84636, 1.0536, 0.84636, 0.94298, 0.84636, 1.23297, 1.03584, 1.01756, 1, 1, 1.03584, 1.01756, 1.00323, 1.03444, 1.01756, 0.96924, 1.05356, 0.96924, 1.05356, 0.96924, 1.05356, 0.93066, 0.98293, 0.82826, 1.04399, 1, 1, 0.82826, 1.04399, 0.79649, 0.84863, 0.79649, 0.84863, 0.79649, 0.84863, 0.79649, 0.84863, 1, 1, 0.85771, 1.17318, 0.85771, 1.21968, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.98965, 1.00068, 0.8287, 0.96777, 0.8287, 0.93365, 0.9043, 0.93365, 0.9043, 0.93365, 0.9043, 1.08571, 0.96927, 0.96706, 0.91484, 0.86035, 0.93575, 0.96924, 0.95923, 1, 1, 0.85771, 1.21968, 1.11437, 1.11437, 0.93109, 0.91202, 0.60411, 0.84164, 0.55572, 1.01173, 0.97361, 0.81818, 0.81818, 0.96635, 0.78032, 0.72727, 0.92366, 0.98601, 1.03405, 0.77968, 1.09799, 1.2, 0.96706, 0.85944, 0.85638, 0.96491, 0.75842, 0.93365, 0.9831, 0.96924, 0.95782, 0.86969, 0.94152, 1.07796, 1.03584, 0.78437, 0.96924, 0.98715, 0.83968, 0.83491, 0.85771, 0.8287, 0.94492, 0.88433, 0.9287, 1.0098, 0.95782, 0.8287, 1.0625, 0.98248, 1.03424, 1.2, 1.01071, 1.0625, 0.95246, 1.03809, 1.04912, 0.98248, 1.00221, 1.03424, 1.05443, 1.2, 1.04785, 0.99609, 1.00169, 1.05176, 0.99346, 1.05356, 0.9087, 1.03004, 0.95542, 0.93117, 1.23362, 1.01071, 1.07831, 1.02512, 1.05205, 1.03502, 1.2, 1.01071, 1.05356, 1.01071, 1.03502, 0.75842, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.03719, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.9403, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.04021, 1, 1, 1, 1, 1, 1, 0.98965, 1.00068, 0.98965, 1.00068, 0.98965, 1.00068, 0.8287, 0.96777, 1, 1.20088, 0.89903, 1, 1, 0.75155, 1.03077, 1.03077, 1.03077, 1.03077, 1.13196, 1.13196, 1.13196, 0.67428, 0.67428, 1.16039, 0.73291, 1.20996, 1.22135, 1.06483, 0.94868, 0.94868, 0.95996, 1.24633, 1, 1.07497, 0.87796, 0.96927, 1.01518, 0.96927, 1, 1, 1, 0.77295, 1, 1, 1.10539, 1.10539, 1.11358, 1.06967, 0.86279, 0.94434, 0.86279, 0.94434, 0.86182, 1, 1, 1.083, 1, 0.91578, 0.86507, 1.1714, 1.18416, 1.14589, 0.69825, 0.97622, 1.9697, 1.24822, 1.24822, 1.17238, 1.24822, 1.24822, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.18083, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.10938, 1.10938, 1, 1, 1, 1.05425, 1.09971, 1.09971, 1.09971, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiRegularFactors = SegoeuiRegularFactors;
const SegoeuiRegularMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiRegularMetrics = SegoeuiRegularMetrics;

/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SEAC_ANALYSIS_ENABLED = exports.MacStandardGlyphOrdering = exports.FontFlags = void 0;
exports.getFontType = getFontType;
exports.normalizeFontName = normalizeFontName;
exports.recoverGlyphName = recoverGlyphName;
exports.type1FontGlyphMapping = type1FontGlyphMapping;

var _util = __w_pdfjs_require__(2);

var _encodings = __w_pdfjs_require__(19);

var _glyphlist = __w_pdfjs_require__(20);

var _unicode = __w_pdfjs_require__(21);

const SEAC_ANALYSIS_ENABLED = true;
exports.SEAC_ANALYSIS_ENABLED = SEAC_ANALYSIS_ENABLED;
const FontFlags = {
  FixedPitch: 1,
  Serif: 2,
  Symbolic: 4,
  Script: 8,
  Nonsymbolic: 32,
  Italic: 64,
  AllCap: 65536,
  SmallCap: 131072,
  ForceBold: 262144
};
exports.FontFlags = FontFlags;
const MacStandardGlyphOrdering = [".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"];
exports.MacStandardGlyphOrdering = MacStandardGlyphOrdering;

function getFontType(type, subtype, isStandardFont = false) {
  switch (type) {
    case "Type1":
      if (isStandardFont) {
        return _util.FontType.TYPE1STANDARD;
      }

      return subtype === "Type1C" ? _util.FontType.TYPE1C : _util.FontType.TYPE1;

    case "CIDFontType0":
      return subtype === "CIDFontType0C" ? _util.FontType.CIDFONTTYPE0C : _util.FontType.CIDFONTTYPE0;

    case "OpenType":
      return _util.FontType.OPENTYPE;

    case "TrueType":
      return _util.FontType.TRUETYPE;

    case "CIDFontType2":
      return _util.FontType.CIDFONTTYPE2;

    case "MMType1":
      return _util.FontType.MMTYPE1;

    case "Type0":
      return _util.FontType.TYPE0;

    default:
      return _util.FontType.UNKNOWN;
  }
}

function recoverGlyphName(name, glyphsUnicodeMap) {
  if (glyphsUnicodeMap[name] !== undefined) {
    return name;
  }

  const unicode = (0, _unicode.getUnicodeForGlyph)(name, glyphsUnicodeMap);

  if (unicode !== -1) {
    for (const key in glyphsUnicodeMap) {
      if (glyphsUnicodeMap[key] === unicode) {
        return key;
      }
    }
  }

  (0, _util.info)("Unable to recover a standard glyph name for: " + name);
  return name;
}

function type1FontGlyphMapping(properties, builtInEncoding, glyphNames) {
  const charCodeToGlyphId = Object.create(null);
  let glyphId, charCode, baseEncoding;
  const isSymbolicFont = !!(properties.flags & FontFlags.Symbolic);

  if (properties.isInternalFont) {
    baseEncoding = builtInEncoding;

    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  } else if (properties.baseEncodingName) {
    baseEncoding = (0, _encodings.getEncoding)(properties.baseEncodingName);

    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  } else if (isSymbolicFont) {
    for (charCode in builtInEncoding) {
      charCodeToGlyphId[charCode] = builtInEncoding[charCode];
    }
  } else {
    baseEncoding = _encodings.StandardEncoding;

    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  }

  const differences = properties.differences;
  let glyphsUnicodeMap;

  if (differences) {
    for (charCode in differences) {
      const glyphName = differences[charCode];
      glyphId = glyphNames.indexOf(glyphName);

      if (glyphId === -1) {
        if (!glyphsUnicodeMap) {
          glyphsUnicodeMap = (0, _glyphlist.getGlyphsUnicode)();
        }

        const standardGlyphName = recoverGlyphName(glyphName, glyphsUnicodeMap);

        if (standardGlyphName !== glyphName) {
          glyphId = glyphNames.indexOf(standardGlyphName);
        }
      }

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  }

  return charCodeToGlyphId;
}

function normalizeFontName(name) {
  return name.replace(/[,_]/g, "-").replace(/\s/g, "");
}

/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ZapfDingbatsEncoding = exports.WinAnsiEncoding = exports.SymbolSetEncoding = exports.StandardEncoding = exports.MacRomanEncoding = exports.ExpertEncoding = void 0;
exports.getEncoding = getEncoding;
const ExpertEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclamsmall", "Hungarumlautsmall", "", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "comma", "hyphen", "period", "fraction", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "colon", "semicolon", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "", "", "", "isuperior", "", "", "lsuperior", "msuperior", "nsuperior", "osuperior", "", "", "rsuperior", "ssuperior", "tsuperior", "", "ff", "fi", "fl", "ffi", "ffl", "parenleftinferior", "", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "exclamdownsmall", "centoldstyle", "Lslashsmall", "", "", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "", "Dotaccentsmall", "", "", "Macronsmall", "", "", "figuredash", "hypheninferior", "", "", "Ogoneksmall", "Ringsmall", "Cedillasmall", "", "", "", "onequarter", "onehalf", "threequarters", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "", "", "zerosuperior", "onesuperior", "twosuperior", "threesuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall"];
exports.ExpertEncoding = ExpertEncoding;
const MacExpertEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclamsmall", "Hungarumlautsmall", "centoldstyle", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "comma", "hyphen", "period", "fraction", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "colon", "semicolon", "", "threequartersemdash", "", "questionsmall", "", "", "", "", "Ethsmall", "", "", "onequarter", "onehalf", "threequarters", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "", "", "", "", "", "", "ff", "fi", "fl", "ffi", "ffl", "parenleftinferior", "", "parenrightinferior", "Circumflexsmall", "hypheninferior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "", "", "asuperior", "centsuperior", "", "", "", "", "Aacutesmall", "Agravesmall", "Acircumflexsmall", "Adieresissmall", "Atildesmall", "Aringsmall", "Ccedillasmall", "Eacutesmall", "Egravesmall", "Ecircumflexsmall", "Edieresissmall", "Iacutesmall", "Igravesmall", "Icircumflexsmall", "Idieresissmall", "Ntildesmall", "Oacutesmall", "Ogravesmall", "Ocircumflexsmall", "Odieresissmall", "Otildesmall", "Uacutesmall", "Ugravesmall", "Ucircumflexsmall", "Udieresissmall", "", "eightsuperior", "fourinferior", "threeinferior", "sixinferior", "eightinferior", "seveninferior", "Scaronsmall", "", "centinferior", "twoinferior", "", "Dieresissmall", "", "Caronsmall", "osuperior", "fiveinferior", "", "commainferior", "periodinferior", "Yacutesmall", "", "dollarinferior", "", "", "Thornsmall", "", "nineinferior", "zeroinferior", "Zcaronsmall", "AEsmall", "Oslashsmall", "questiondownsmall", "oneinferior", "Lslashsmall", "", "", "", "", "", "", "Cedillasmall", "", "", "", "", "", "OEsmall", "figuredash", "hyphensuperior", "", "", "", "", "exclamdownsmall", "", "Ydieresissmall", "", "onesuperior", "twosuperior", "threesuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "ninesuperior", "zerosuperior", "", "esuperior", "rsuperior", "tsuperior", "", "", "isuperior", "ssuperior", "dsuperior", "", "", "", "", "", "lsuperior", "Ogoneksmall", "Brevesmall", "Macronsmall", "bsuperior", "nsuperior", "msuperior", "commasuperior", "periodsuperior", "Dotaccentsmall", "Ringsmall", "", "", "", ""];
const MacRomanEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "space", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron"];
exports.MacRomanEncoding = MacRomanEncoding;
const StandardEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "", "endash", "dagger", "daggerdbl", "periodcentered", "", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "", "questiondown", "", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "", "ring", "cedilla", "", "hungarumlaut", "ogonek", "caron", "emdash", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "AE", "", "ordfeminine", "", "", "", "", "Lslash", "Oslash", "OE", "ordmasculine", "", "", "", "", "", "ae", "", "", "", "dotlessi", "", "", "lslash", "oslash", "oe", "germandbls", "", "", "", ""];
exports.StandardEncoding = StandardEncoding;
const WinAnsiEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "bullet", "Euro", "bullet", "quotesinglbase", "florin", "quotedblbase", "ellipsis", "dagger", "daggerdbl", "circumflex", "perthousand", "Scaron", "guilsinglleft", "OE", "bullet", "Zcaron", "bullet", "bullet", "quoteleft", "quoteright", "quotedblleft", "quotedblright", "bullet", "endash", "emdash", "tilde", "trademark", "scaron", "guilsinglright", "oe", "bullet", "zcaron", "Ydieresis", "space", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"];
exports.WinAnsiEncoding = WinAnsiEncoding;
const SymbolSetEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "universal", "numbersign", "existential", "percent", "ampersand", "suchthat", "parenleft", "parenright", "asteriskmath", "plus", "comma", "minus", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "congruent", "Alpha", "Beta", "Chi", "Delta", "Epsilon", "Phi", "Gamma", "Eta", "Iota", "theta1", "Kappa", "Lambda", "Mu", "Nu", "Omicron", "Pi", "Theta", "Rho", "Sigma", "Tau", "Upsilon", "sigma1", "Omega", "Xi", "Psi", "Zeta", "bracketleft", "therefore", "bracketright", "perpendicular", "underscore", "radicalex", "alpha", "beta", "chi", "delta", "epsilon", "phi", "gamma", "eta", "iota", "phi1", "kappa", "lambda", "mu", "nu", "omicron", "pi", "theta", "rho", "sigma", "tau", "upsilon", "omega1", "omega", "xi", "psi", "zeta", "braceleft", "bar", "braceright", "similar", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "Euro", "Upsilon1", "minute", "lessequal", "fraction", "infinity", "florin", "club", "diamond", "heart", "spade", "arrowboth", "arrowleft", "arrowup", "arrowright", "arrowdown", "degree", "plusminus", "second", "greaterequal", "multiply", "proportional", "partialdiff", "bullet", "divide", "notequal", "equivalence", "approxequal", "ellipsis", "arrowvertex", "arrowhorizex", "carriagereturn", "aleph", "Ifraktur", "Rfraktur", "weierstrass", "circlemultiply", "circleplus", "emptyset", "intersection", "union", "propersuperset", "reflexsuperset", "notsubset", "propersubset", "reflexsubset", "element", "notelement", "angle", "gradient", "registerserif", "copyrightserif", "trademarkserif", "product", "radical", "dotmath", "logicalnot", "logicaland", "logicalor", "arrowdblboth", "arrowdblleft", "arrowdblup", "arrowdblright", "arrowdbldown", "lozenge", "angleleft", "registersans", "copyrightsans", "trademarksans", "summation", "parenlefttp", "parenleftex", "parenleftbt", "bracketlefttp", "bracketleftex", "bracketleftbt", "bracelefttp", "braceleftmid", "braceleftbt", "braceex", "", "angleright", "integral", "integraltp", "integralex", "integralbt", "parenrighttp", "parenrightex", "parenrightbt", "bracketrighttp", "bracketrightex", "bracketrightbt", "bracerighttp", "bracerightmid", "bracerightbt", ""];
exports.SymbolSetEncoding = SymbolSetEncoding;
const ZapfDingbatsEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "a1", "a2", "a202", "a3", "a4", "a5", "a119", "a118", "a117", "a11", "a12", "a13", "a14", "a15", "a16", "a105", "a17", "a18", "a19", "a20", "a21", "a22", "a23", "a24", "a25", "a26", "a27", "a28", "a6", "a7", "a8", "a9", "a10", "a29", "a30", "a31", "a32", "a33", "a34", "a35", "a36", "a37", "a38", "a39", "a40", "a41", "a42", "a43", "a44", "a45", "a46", "a47", "a48", "a49", "a50", "a51", "a52", "a53", "a54", "a55", "a56", "a57", "a58", "a59", "a60", "a61", "a62", "a63", "a64", "a65", "a66", "a67", "a68", "a69", "a70", "a71", "a72", "a73", "a74", "a203", "a75", "a204", "a76", "a77", "a78", "a79", "a81", "a82", "a83", "a84", "a97", "a98", "a99", "a100", "", "a89", "a90", "a93", "a94", "a91", "a92", "a205", "a85", "a206", "a86", "a87", "a88", "a95", "a96", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "a101", "a102", "a103", "a104", "a106", "a107", "a108", "a112", "a111", "a110", "a109", "a120", "a121", "a122", "a123", "a124", "a125", "a126", "a127", "a128", "a129", "a130", "a131", "a132", "a133", "a134", "a135", "a136", "a137", "a138", "a139", "a140", "a141", "a142", "a143", "a144", "a145", "a146", "a147", "a148", "a149", "a150", "a151", "a152", "a153", "a154", "a155", "a156", "a157", "a158", "a159", "a160", "a161", "a163", "a164", "a196", "a165", "a192", "a166", "a167", "a168", "a169", "a170", "a171", "a172", "a173", "a162", "a174", "a175", "a176", "a177", "a178", "a179", "a193", "a180", "a199", "a181", "a200", "a182", "", "a201", "a183", "a184", "a197", "a185", "a194", "a198", "a186", "a195", "a187", "a188", "a189", "a190", "a191", ""];
exports.ZapfDingbatsEncoding = ZapfDingbatsEncoding;

function getEncoding(encodingName) {
  switch (encodingName) {
    case "WinAnsiEncoding":
      return WinAnsiEncoding;

    case "StandardEncoding":
      return StandardEncoding;

    case "MacRomanEncoding":
      return MacRomanEncoding;

    case "SymbolSetEncoding":
      return SymbolSetEncoding;

    case "ZapfDingbatsEncoding":
      return ZapfDingbatsEncoding;

    case "ExpertEncoding":
      return ExpertEncoding;

    case "MacExpertEncoding":
      return MacExpertEncoding;

    default:
      return null;
  }
}

/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, __webpack_exports__, __w_pdfjs_require__) => {

__w_pdfjs_require__.r(__webpack_exports__);
/* harmony export */ __w_pdfjs_require__.d(__webpack_exports__, {
/* harmony export */   "getDingbatsGlyphsUnicode": () => (/* binding */ getDingbatsGlyphsUnicode),
/* harmony export */   "getGlyphsUnicode": () => (/* binding */ getGlyphsUnicode)
/* harmony export */ });
/* harmony import */ var _core_utils_js__WEBPACK_IMPORTED_MODULE_0__ = __w_pdfjs_require__(9);

const getGlyphsUnicode = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getArrayLookupTableFactory)(function () {
 return [
  "A",
  0x0041,
  "AE",
  0x00c6,
  "AEacute",
  0x01fc,
  "AEmacron",
  0x01e2,
  "AEsmall",
  0xf7e6,
  "Aacute",
  0x00c1,
  "Aacutesmall",
  0xf7e1,
  "Abreve",
  0x0102,
  "Abreveacute",
  0x1eae,
  "Abrevecyrillic",
  0x04d0,
  "Abrevedotbelow",
  0x1eb6,
  "Abrevegrave",
  0x1eb0,
  "Abrevehookabove",
  0x1eb2,
  "Abrevetilde",
  0x1eb4,
  "Acaron",
  0x01cd,
  "Acircle",
  0x24b6,
  "Acircumflex",
  0x00c2,
  "Acircumflexacute",
  0x1ea4,
  "Acircumflexdotbelow",
  0x1eac,
  "Acircumflexgrave",
  0x1ea6,
  "Acircumflexhookabove",
  0x1ea8,
  "Acircumflexsmall",
  0xf7e2,
  "Acircumflextilde",
  0x1eaa,
  "Acute",
  0xf6c9,
  "Acutesmall",
  0xf7b4,
  "Acyrillic",
  0x0410,
  "Adblgrave",
  0x0200,
  "Adieresis",
  0x00c4,
  "Adieresiscyrillic",
  0x04d2,
  "Adieresismacron",
  0x01de,
  "Adieresissmall",
  0xf7e4,
  "Adotbelow",
  0x1ea0,
  "Adotmacron",
  0x01e0,
  "Agrave",
  0x00c0,
  "Agravesmall",
  0xf7e0,
  "Ahookabove",
  0x1ea2,
  "Aiecyrillic",
  0x04d4,
  "Ainvertedbreve",
  0x0202,
  "Alpha",
  0x0391,
  "Alphatonos",
  0x0386,
  "Amacron",
  0x0100,
  "Amonospace",
  0xff21,
  "Aogonek",
  0x0104,
  "Aring",
  0x00c5,
  "Aringacute",
  0x01fa,
  "Aringbelow",
  0x1e00,
  "Aringsmall",
  0xf7e5,
  "Asmall",
  0xf761,
  "Atilde",
  0x00c3,
  "Atildesmall",
  0xf7e3,
  "Aybarmenian",
  0x0531,
  "B",
  0x0042,
  "Bcircle",
  0x24b7,
  "Bdotaccent",
  0x1e02,
  "Bdotbelow",
  0x1e04,
  "Becyrillic",
  0x0411,
  "Benarmenian",
  0x0532,
  "Beta",
  0x0392,
  "Bhook",
  0x0181,
  "Blinebelow",
  0x1e06,
  "Bmonospace",
  0xff22,
  "Brevesmall",
  0xf6f4,
  "Bsmall",
  0xf762,
  "Btopbar",
  0x0182,
  "C",
  0x0043,
  "Caarmenian",
  0x053e,
  "Cacute",
  0x0106,
  "Caron",
  0xf6ca,
  "Caronsmall",
  0xf6f5,
  "Ccaron",
  0x010c,
  "Ccedilla",
  0x00c7,
  "Ccedillaacute",
  0x1e08,
  "Ccedillasmall",
  0xf7e7,
  "Ccircle",
  0x24b8,
  "Ccircumflex",
  0x0108,
  "Cdot",
  0x010a,
  "Cdotaccent",
  0x010a,
  "Cedillasmall",
  0xf7b8,
  "Chaarmenian",
  0x0549,
  "Cheabkhasiancyrillic",
  0x04bc,
  "Checyrillic",
  0x0427,
  "Chedescenderabkhasiancyrillic",
  0x04be,
  "Chedescendercyrillic",
  0x04b6,
  "Chedieresiscyrillic",
  0x04f4,
  "Cheharmenian",
  0x0543,
  "Chekhakassiancyrillic",
  0x04cb,
  "Cheverticalstrokecyrillic",
  0x04b8,
  "Chi",
  0x03a7,
  "Chook",
  0x0187,
  "Circumflexsmall",
  0xf6f6,
  "Cmonospace",
  0xff23,
  "Coarmenian",
  0x0551,
  "Csmall",
  0xf763,
  "D",
  0x0044,
  "DZ",
  0x01f1,
  "DZcaron",
  0x01c4,
  "Daarmenian",
  0x0534,
  "Dafrican",
  0x0189,
  "Dcaron",
  0x010e,
  "Dcedilla",
  0x1e10,
  "Dcircle",
  0x24b9,
  "Dcircumflexbelow",
  0x1e12,
  "Dcroat",
  0x0110,
  "Ddotaccent",
  0x1e0a,
  "Ddotbelow",
  0x1e0c,
  "Decyrillic",
  0x0414,
  "Deicoptic",
  0x03ee,
  "Delta",
  0x2206,
  "Deltagreek",
  0x0394,
  "Dhook",
  0x018a,
  "Dieresis",
  0xf6cb,
  "DieresisAcute",
  0xf6cc,
  "DieresisGrave",
  0xf6cd,
  "Dieresissmall",
  0xf7a8,
  "Digammagreek",
  0x03dc,
  "Djecyrillic",
  0x0402,
  "Dlinebelow",
  0x1e0e,
  "Dmonospace",
  0xff24,
  "Dotaccentsmall",
  0xf6f7,
  "Dslash",
  0x0110,
  "Dsmall",
  0xf764,
  "Dtopbar",
  0x018b,
  "Dz",
  0x01f2,
  "Dzcaron",
  0x01c5,
  "Dzeabkhasiancyrillic",
  0x04e0,
  "Dzecyrillic",
  0x0405,
  "Dzhecyrillic",
  0x040f,
  "E",
  0x0045,
  "Eacute",
  0x00c9,
  "Eacutesmall",
  0xf7e9,
  "Ebreve",
  0x0114,
  "Ecaron",
  0x011a,
  "Ecedillabreve",
  0x1e1c,
  "Echarmenian",
  0x0535,
  "Ecircle",
  0x24ba,
  "Ecircumflex",
  0x00ca,
  "Ecircumflexacute",
  0x1ebe,
  "Ecircumflexbelow",
  0x1e18,
  "Ecircumflexdotbelow",
  0x1ec6,
  "Ecircumflexgrave",
  0x1ec0,
  "Ecircumflexhookabove",
  0x1ec2,
  "Ecircumflexsmall",
  0xf7ea,
  "Ecircumflextilde",
  0x1ec4,
  "Ecyrillic",
  0x0404,
  "Edblgrave",
  0x0204,
  "Edieresis",
  0x00cb,
  "Edieresissmall",
  0xf7eb,
  "Edot",
  0x0116,
  "Edotaccent",
  0x0116,
  "Edotbelow",
  0x1eb8,
  "Efcyrillic",
  0x0424,
  "Egrave",
  0x00c8,
  "Egravesmall",
  0xf7e8,
  "Eharmenian",
  0x0537,
  "Ehookabove",
  0x1eba,
  "Eightroman",
  0x2167,
  "Einvertedbreve",
  0x0206,
  "Eiotifiedcyrillic",
  0x0464,
  "Elcyrillic",
  0x041b,
  "Elevenroman",
  0x216a,
  "Emacron",
  0x0112,
  "Emacronacute",
  0x1e16,
  "Emacrongrave",
  0x1e14,
  "Emcyrillic",
  0x041c,
  "Emonospace",
  0xff25,
  "Encyrillic",
  0x041d,
  "Endescendercyrillic",
  0x04a2,
  "Eng",
  0x014a,
  "Enghecyrillic",
  0x04a4,
  "Enhookcyrillic",
  0x04c7,
  "Eogonek",
  0x0118,
  "Eopen",
  0x0190,
  "Epsilon",
  0x0395,
  "Epsilontonos",
  0x0388,
  "Ercyrillic",
  0x0420,
  "Ereversed",
  0x018e,
  "Ereversedcyrillic",
  0x042d,
  "Escyrillic",
  0x0421,
  "Esdescendercyrillic",
  0x04aa,
  "Esh",
  0x01a9,
  "Esmall",
  0xf765,
  "Eta",
  0x0397,
  "Etarmenian",
  0x0538,
  "Etatonos",
  0x0389,
  "Eth",
  0x00d0,
  "Ethsmall",
  0xf7f0,
  "Etilde",
  0x1ebc,
  "Etildebelow",
  0x1e1a,
  "Euro",
  0x20ac,
  "Ezh",
  0x01b7,
  "Ezhcaron",
  0x01ee,
  "Ezhreversed",
  0x01b8,
  "F",
  0x0046,
  "Fcircle",
  0x24bb,
  "Fdotaccent",
  0x1e1e,
  "Feharmenian",
  0x0556,
  "Feicoptic",
  0x03e4,
  "Fhook",
  0x0191,
  "Fitacyrillic",
  0x0472,
  "Fiveroman",
  0x2164,
  "Fmonospace",
  0xff26,
  "Fourroman",
  0x2163,
  "Fsmall",
  0xf766,
  "G",
  0x0047,
  "GBsquare",
  0x3387,
  "Gacute",
  0x01f4,
  "Gamma",
  0x0393,
  "Gammaafrican",
  0x0194,
  "Gangiacoptic",
  0x03ea,
  "Gbreve",
  0x011e,
  "Gcaron",
  0x01e6,
  "Gcedilla",
  0x0122,
  "Gcircle",
  0x24bc,
  "Gcircumflex",
  0x011c,
  "Gcommaaccent",
  0x0122,
  "Gdot",
  0x0120,
  "Gdotaccent",
  0x0120,
  "Gecyrillic",
  0x0413,
  "Ghadarmenian",
  0x0542,
  "Ghemiddlehookcyrillic",
  0x0494,
  "Ghestrokecyrillic",
  0x0492,
  "Gheupturncyrillic",
  0x0490,
  "Ghook",
  0x0193,
  "Gimarmenian",
  0x0533,
  "Gjecyrillic",
  0x0403,
  "Gmacron",
  0x1e20,
  "Gmonospace",
  0xff27,
  "Grave",
  0xf6ce,
  "Gravesmall",
  0xf760,
  "Gsmall",
  0xf767,
  "Gsmallhook",
  0x029b,
  "Gstroke",
  0x01e4,
  "H",
  0x0048,
  "H18533",
  0x25cf,
  "H18543",
  0x25aa,
  "H18551",
  0x25ab,
  "H22073",
  0x25a1,
  "HPsquare",
  0x33cb,
  "Haabkhasiancyrillic",
  0x04a8,
  "Hadescendercyrillic",
  0x04b2,
  "Hardsigncyrillic",
  0x042a,
  "Hbar",
  0x0126,
  "Hbrevebelow",
  0x1e2a,
  "Hcedilla",
  0x1e28,
  "Hcircle",
  0x24bd,
  "Hcircumflex",
  0x0124,
  "Hdieresis",
  0x1e26,
  "Hdotaccent",
  0x1e22,
  "Hdotbelow",
  0x1e24,
  "Hmonospace",
  0xff28,
  "Hoarmenian",
  0x0540,
  "Horicoptic",
  0x03e8,
  "Hsmall",
  0xf768,
  "Hungarumlaut",
  0xf6cf,
  "Hungarumlautsmall",
  0xf6f8,
  "Hzsquare",
  0x3390,
  "I",
  0x0049,
  "IAcyrillic",
  0x042f,
  "IJ",
  0x0132,
  "IUcyrillic",
  0x042e,
  "Iacute",
  0x00cd,
  "Iacutesmall",
  0xf7ed,
  "Ibreve",
  0x012c,
  "Icaron",
  0x01cf,
  "Icircle",
  0x24be,
  "Icircumflex",
  0x00ce,
  "Icircumflexsmall",
  0xf7ee,
  "Icyrillic",
  0x0406,
  "Idblgrave",
  0x0208,
  "Idieresis",
  0x00cf,
  "Idieresisacute",
  0x1e2e,
  "Idieresiscyrillic",
  0x04e4,
  "Idieresissmall",
  0xf7ef,
  "Idot",
  0x0130,
  "Idotaccent",
  0x0130,
  "Idotbelow",
  0x1eca,
  "Iebrevecyrillic",
  0x04d6,
  "Iecyrillic",
  0x0415,
  "Ifraktur",
  0x2111,
  "Igrave",
  0x00cc,
  "Igravesmall",
  0xf7ec,
  "Ihookabove",
  0x1ec8,
  "Iicyrillic",
  0x0418,
  "Iinvertedbreve",
  0x020a,
  "Iishortcyrillic",
  0x0419,
  "Imacron",
  0x012a,
  "Imacroncyrillic",
  0x04e2,
  "Imonospace",
  0xff29,
  "Iniarmenian",
  0x053b,
  "Iocyrillic",
  0x0401,
  "Iogonek",
  0x012e,
  "Iota",
  0x0399,
  "Iotaafrican",
  0x0196,
  "Iotadieresis",
  0x03aa,
  "Iotatonos",
  0x038a,
  "Ismall",
  0xf769,
  "Istroke",
  0x0197,
  "Itilde",
  0x0128,
  "Itildebelow",
  0x1e2c,
  "Izhitsacyrillic",
  0x0474,
  "Izhitsadblgravecyrillic",
  0x0476,
  "J",
  0x004a,
  "Jaarmenian",
  0x0541,
  "Jcircle",
  0x24bf,
  "Jcircumflex",
  0x0134,
  "Jecyrillic",
  0x0408,
  "Jheharmenian",
  0x054b,
  "Jmonospace",
  0xff2a,
  "Jsmall",
  0xf76a,
  "K",
  0x004b,
  "KBsquare",
  0x3385,
  "KKsquare",
  0x33cd,
  "Kabashkircyrillic",
  0x04a0,
  "Kacute",
  0x1e30,
  "Kacyrillic",
  0x041a,
  "Kadescendercyrillic",
  0x049a,
  "Kahookcyrillic",
  0x04c3,
  "Kappa",
  0x039a,
  "Kastrokecyrillic",
  0x049e,
  "Kaverticalstrokecyrillic",
  0x049c,
  "Kcaron",
  0x01e8,
  "Kcedilla",
  0x0136,
  "Kcircle",
  0x24c0,
  "Kcommaaccent",
  0x0136,
  "Kdotbelow",
  0x1e32,
  "Keharmenian",
  0x0554,
  "Kenarmenian",
  0x053f,
  "Khacyrillic",
  0x0425,
  "Kheicoptic",
  0x03e6,
  "Khook",
  0x0198,
  "Kjecyrillic",
  0x040c,
  "Klinebelow",
  0x1e34,
  "Kmonospace",
  0xff2b,
  "Koppacyrillic",
  0x0480,
  "Koppagreek",
  0x03de,
  "Ksicyrillic",
  0x046e,
  "Ksmall",
  0xf76b,
  "L",
  0x004c,
  "LJ",
  0x01c7,
  "LL",
  0xf6bf,
  "Lacute",
  0x0139,
  "Lambda",
  0x039b,
  "Lcaron",
  0x013d,
  "Lcedilla",
  0x013b,
  "Lcircle",
  0x24c1,
  "Lcircumflexbelow",
  0x1e3c,
  "Lcommaaccent",
  0x013b,
  "Ldot",
  0x013f,
  "Ldotaccent",
  0x013f,
  "Ldotbelow",
  0x1e36,
  "Ldotbelowmacron",
  0x1e38,
  "Liwnarmenian",
  0x053c,
  "Lj",
  0x01c8,
  "Ljecyrillic",
  0x0409,
  "Llinebelow",
  0x1e3a,
  "Lmonospace",
  0xff2c,
  "Lslash",
  0x0141,
  "Lslashsmall",
  0xf6f9,
  "Lsmall",
  0xf76c,
  "M",
  0x004d,
  "MBsquare",
  0x3386,
  "Macron",
  0xf6d0,
  "Macronsmall",
  0xf7af,
  "Macute",
  0x1e3e,
  "Mcircle",
  0x24c2,
  "Mdotaccent",
  0x1e40,
  "Mdotbelow",
  0x1e42,
  "Menarmenian",
  0x0544,
  "Mmonospace",
  0xff2d,
  "Msmall",
  0xf76d,
  "Mturned",
  0x019c,
  "Mu",
  0x039c,
  "N",
  0x004e,
  "NJ",
  0x01ca,
  "Nacute",
  0x0143,
  "Ncaron",
  0x0147,
  "Ncedilla",
  0x0145,
  "Ncircle",
  0x24c3,
  "Ncircumflexbelow",
  0x1e4a,
  "Ncommaaccent",
  0x0145,
  "Ndotaccent",
  0x1e44,
  "Ndotbelow",
  0x1e46,
  "Nhookleft",
  0x019d,
  "Nineroman",
  0x2168,
  "Nj",
  0x01cb,
  "Njecyrillic",
  0x040a,
  "Nlinebelow",
  0x1e48,
  "Nmonospace",
  0xff2e,
  "Nowarmenian",
  0x0546,
  "Nsmall",
  0xf76e,
  "Ntilde",
  0x00d1,
  "Ntildesmall",
  0xf7f1,
  "Nu",
  0x039d,
  "O",
  0x004f,
  "OE",
  0x0152,
  "OEsmall",
  0xf6fa,
  "Oacute",
  0x00d3,
  "Oacutesmall",
  0xf7f3,
  "Obarredcyrillic",
  0x04e8,
  "Obarreddieresiscyrillic",
  0x04ea,
  "Obreve",
  0x014e,
  "Ocaron",
  0x01d1,
  "Ocenteredtilde",
  0x019f,
  "Ocircle",
  0x24c4,
  "Ocircumflex",
  0x00d4,
  "Ocircumflexacute",
  0x1ed0,
  "Ocircumflexdotbelow",
  0x1ed8,
  "Ocircumflexgrave",
  0x1ed2,
  "Ocircumflexhookabove",
  0x1ed4,
  "Ocircumflexsmall",
  0xf7f4,
  "Ocircumflextilde",
  0x1ed6,
  "Ocyrillic",
  0x041e,
  "Odblacute",
  0x0150,
  "Odblgrave",
  0x020c,
  "Odieresis",
  0x00d6,
  "Odieresiscyrillic",
  0x04e6,
  "Odieresissmall",
  0xf7f6,
  "Odotbelow",
  0x1ecc,
  "Ogoneksmall",
  0xf6fb,
  "Ograve",
  0x00d2,
  "Ogravesmall",
  0xf7f2,
  "Oharmenian",
  0x0555,
  "Ohm",
  0x2126,
  "Ohookabove",
  0x1ece,
  "Ohorn",
  0x01a0,
  "Ohornacute",
  0x1eda,
  "Ohorndotbelow",
  0x1ee2,
  "Ohorngrave",
  0x1edc,
  "Ohornhookabove",
  0x1ede,
  "Ohorntilde",
  0x1ee0,
  "Ohungarumlaut",
  0x0150,
  "Oi",
  0x01a2,
  "Oinvertedbreve",
  0x020e,
  "Omacron",
  0x014c,
  "Omacronacute",
  0x1e52,
  "Omacrongrave",
  0x1e50,
  "Omega",
  0x2126,
  "Omegacyrillic",
  0x0460,
  "Omegagreek",
  0x03a9,
  "Omegaroundcyrillic",
  0x047a,
  "Omegatitlocyrillic",
  0x047c,
  "Omegatonos",
  0x038f,
  "Omicron",
  0x039f,
  "Omicrontonos",
  0x038c,
  "Omonospace",
  0xff2f,
  "Oneroman",
  0x2160,
  "Oogonek",
  0x01ea,
  "Oogonekmacron",
  0x01ec,
  "Oopen",
  0x0186,
  "Oslash",
  0x00d8,
  "Oslashacute",
  0x01fe,
  "Oslashsmall",
  0xf7f8,
  "Osmall",
  0xf76f,
  "Ostrokeacute",
  0x01fe,
  "Otcyrillic",
  0x047e,
  "Otilde",
  0x00d5,
  "Otildeacute",
  0x1e4c,
  "Otildedieresis",
  0x1e4e,
  "Otildesmall",
  0xf7f5,
  "P",
  0x0050,
  "Pacute",
  0x1e54,
  "Pcircle",
  0x24c5,
  "Pdotaccent",
  0x1e56,
  "Pecyrillic",
  0x041f,
  "Peharmenian",
  0x054a,
  "Pemiddlehookcyrillic",
  0x04a6,
  "Phi",
  0x03a6,
  "Phook",
  0x01a4,
  "Pi",
  0x03a0,
  "Piwrarmenian",
  0x0553,
  "Pmonospace",
  0xff30,
  "Psi",
  0x03a8,
  "Psicyrillic",
  0x0470,
  "Psmall",
  0xf770,
  "Q",
  0x0051,
  "Qcircle",
  0x24c6,
  "Qmonospace",
  0xff31,
  "Qsmall",
  0xf771,
  "R",
  0x0052,
  "Raarmenian",
  0x054c,
  "Racute",
  0x0154,
  "Rcaron",
  0x0158,
  "Rcedilla",
  0x0156,
  "Rcircle",
  0x24c7,
  "Rcommaaccent",
  0x0156,
  "Rdblgrave",
  0x0210,
  "Rdotaccent",
  0x1e58,
  "Rdotbelow",
  0x1e5a,
  "Rdotbelowmacron",
  0x1e5c,
  "Reharmenian",
  0x0550,
  "Rfraktur",
  0x211c,
  "Rho",
  0x03a1,
  "Ringsmall",
  0xf6fc,
  "Rinvertedbreve",
  0x0212,
  "Rlinebelow",
  0x1e5e,
  "Rmonospace",
  0xff32,
  "Rsmall",
  0xf772,
  "Rsmallinverted",
  0x0281,
  "Rsmallinvertedsuperior",
  0x02b6,
  "S",
  0x0053,
  "SF010000",
  0x250c,
  "SF020000",
  0x2514,
  "SF030000",
  0x2510,
  "SF040000",
  0x2518,
  "SF050000",
  0x253c,
  "SF060000",
  0x252c,
  "SF070000",
  0x2534,
  "SF080000",
  0x251c,
  "SF090000",
  0x2524,
  "SF100000",
  0x2500,
  "SF110000",
  0x2502,
  "SF190000",
  0x2561,
  "SF200000",
  0x2562,
  "SF210000",
  0x2556,
  "SF220000",
  0x2555,
  "SF230000",
  0x2563,
  "SF240000",
  0x2551,
  "SF250000",
  0x2557,
  "SF260000",
  0x255d,
  "SF270000",
  0x255c,
  "SF280000",
  0x255b,
  "SF360000",
  0x255e,
  "SF370000",
  0x255f,
  "SF380000",
  0x255a,
  "SF390000",
  0x2554,
  "SF400000",
  0x2569,
  "SF410000",
  0x2566,
  "SF420000",
  0x2560,
  "SF430000",
  0x2550,
  "SF440000",
  0x256c,
  "SF450000",
  0x2567,
  "SF460000",
  0x2568,
  "SF470000",
  0x2564,
  "SF480000",
  0x2565,
  "SF490000",
  0x2559,
  "SF500000",
  0x2558,
  "SF510000",
  0x2552,
  "SF520000",
  0x2553,
  "SF530000",
  0x256b,
  "SF540000",
  0x256a,
  "Sacute",
  0x015a,
  "Sacutedotaccent",
  0x1e64,
  "Sampigreek",
  0x03e0,
  "Scaron",
  0x0160,
  "Scarondotaccent",
  0x1e66,
  "Scaronsmall",
  0xf6fd,
  "Scedilla",
  0x015e,
  "Schwa",
  0x018f,
  "Schwacyrillic",
  0x04d8,
  "Schwadieresiscyrillic",
  0x04da,
  "Scircle",
  0x24c8,
  "Scircumflex",
  0x015c,
  "Scommaaccent",
  0x0218,
  "Sdotaccent",
  0x1e60,
  "Sdotbelow",
  0x1e62,
  "Sdotbelowdotaccent",
  0x1e68,
  "Seharmenian",
  0x054d,
  "Sevenroman",
  0x2166,
  "Shaarmenian",
  0x0547,
  "Shacyrillic",
  0x0428,
  "Shchacyrillic",
  0x0429,
  "Sheicoptic",
  0x03e2,
  "Shhacyrillic",
  0x04ba,
  "Shimacoptic",
  0x03ec,
  "Sigma",
  0x03a3,
  "Sixroman",
  0x2165,
  "Smonospace",
  0xff33,
  "Softsigncyrillic",
  0x042c,
  "Ssmall",
  0xf773,
  "Stigmagreek",
  0x03da,
  "T",
  0x0054,
  "Tau",
  0x03a4,
  "Tbar",
  0x0166,
  "Tcaron",
  0x0164,
  "Tcedilla",
  0x0162,
  "Tcircle",
  0x24c9,
  "Tcircumflexbelow",
  0x1e70,
  "Tcommaaccent",
  0x0162,
  "Tdotaccent",
  0x1e6a,
  "Tdotbelow",
  0x1e6c,
  "Tecyrillic",
  0x0422,
  "Tedescendercyrillic",
  0x04ac,
  "Tenroman",
  0x2169,
  "Tetsecyrillic",
  0x04b4,
  "Theta",
  0x0398,
  "Thook",
  0x01ac,
  "Thorn",
  0x00de,
  "Thornsmall",
  0xf7fe,
  "Threeroman",
  0x2162,
  "Tildesmall",
  0xf6fe,
  "Tiwnarmenian",
  0x054f,
  "Tlinebelow",
  0x1e6e,
  "Tmonospace",
  0xff34,
  "Toarmenian",
  0x0539,
  "Tonefive",
  0x01bc,
  "Tonesix",
  0x0184,
  "Tonetwo",
  0x01a7,
  "Tretroflexhook",
  0x01ae,
  "Tsecyrillic",
  0x0426,
  "Tshecyrillic",
  0x040b,
  "Tsmall",
  0xf774,
  "Twelveroman",
  0x216b,
  "Tworoman",
  0x2161,
  "U",
  0x0055,
  "Uacute",
  0x00da,
  "Uacutesmall",
  0xf7fa,
  "Ubreve",
  0x016c,
  "Ucaron",
  0x01d3,
  "Ucircle",
  0x24ca,
  "Ucircumflex",
  0x00db,
  "Ucircumflexbelow",
  0x1e76,
  "Ucircumflexsmall",
  0xf7fb,
  "Ucyrillic",
  0x0423,
  "Udblacute",
  0x0170,
  "Udblgrave",
  0x0214,
  "Udieresis",
  0x00dc,
  "Udieresisacute",
  0x01d7,
  "Udieresisbelow",
  0x1e72,
  "Udieresiscaron",
  0x01d9,
  "Udieresiscyrillic",
  0x04f0,
  "Udieresisgrave",
  0x01db,
  "Udieresismacron",
  0x01d5,
  "Udieresissmall",
  0xf7fc,
  "Udotbelow",
  0x1ee4,
  "Ugrave",
  0x00d9,
  "Ugravesmall",
  0xf7f9,
  "Uhookabove",
  0x1ee6,
  "Uhorn",
  0x01af,
  "Uhornacute",
  0x1ee8,
  "Uhorndotbelow",
  0x1ef0,
  "Uhorngrave",
  0x1eea,
  "Uhornhookabove",
  0x1eec,
  "Uhorntilde",
  0x1eee,
  "Uhungarumlaut",
  0x0170,
  "Uhungarumlautcyrillic",
  0x04f2,
  "Uinvertedbreve",
  0x0216,
  "Ukcyrillic",
  0x0478,
  "Umacron",
  0x016a,
  "Umacroncyrillic",
  0x04ee,
  "Umacrondieresis",
  0x1e7a,
  "Umonospace",
  0xff35,
  "Uogonek",
  0x0172,
  "Upsilon",
  0x03a5,
  "Upsilon1",
  0x03d2,
  "Upsilonacutehooksymbolgreek",
  0x03d3,
  "Upsilonafrican",
  0x01b1,
  "Upsilondieresis",
  0x03ab,
  "Upsilondieresishooksymbolgreek",
  0x03d4,
  "Upsilonhooksymbol",
  0x03d2,
  "Upsilontonos",
  0x038e,
  "Uring",
  0x016e,
  "Ushortcyrillic",
  0x040e,
  "Usmall",
  0xf775,
  "Ustraightcyrillic",
  0x04ae,
  "Ustraightstrokecyrillic",
  0x04b0,
  "Utilde",
  0x0168,
  "Utildeacute",
  0x1e78,
  "Utildebelow",
  0x1e74,
  "V",
  0x0056,
  "Vcircle",
  0x24cb,
  "Vdotbelow",
  0x1e7e,
  "Vecyrillic",
  0x0412,
  "Vewarmenian",
  0x054e,
  "Vhook",
  0x01b2,
  "Vmonospace",
  0xff36,
  "Voarmenian",
  0x0548,
  "Vsmall",
  0xf776,
  "Vtilde",
  0x1e7c,
  "W",
  0x0057,
  "Wacute",
  0x1e82,
  "Wcircle",
  0x24cc,
  "Wcircumflex",
  0x0174,
  "Wdieresis",
  0x1e84,
  "Wdotaccent",
  0x1e86,
  "Wdotbelow",
  0x1e88,
  "Wgrave",
  0x1e80,
  "Wmonospace",
  0xff37,
  "Wsmall",
  0xf777,
  "X",
  0x0058,
  "Xcircle",
  0x24cd,
  "Xdieresis",
  0x1e8c,
  "Xdotaccent",
  0x1e8a,
  "Xeharmenian",
  0x053d,
  "Xi",
  0x039e,
  "Xmonospace",
  0xff38,
  "Xsmall",
  0xf778,
  "Y",
  0x0059,
  "Yacute",
  0x00dd,
  "Yacutesmall",
  0xf7fd,
  "Yatcyrillic",
  0x0462,
  "Ycircle",
  0x24ce,
  "Ycircumflex",
  0x0176,
  "Ydieresis",
  0x0178,
  "Ydieresissmall",
  0xf7ff,
  "Ydotaccent",
  0x1e8e,
  "Ydotbelow",
  0x1ef4,
  "Yericyrillic",
  0x042b,
  "Yerudieresiscyrillic",
  0x04f8,
  "Ygrave",
  0x1ef2,
  "Yhook",
  0x01b3,
  "Yhookabove",
  0x1ef6,
  "Yiarmenian",
  0x0545,
  "Yicyrillic",
  0x0407,
  "Yiwnarmenian",
  0x0552,
  "Ymonospace",
  0xff39,
  "Ysmall",
  0xf779,
  "Ytilde",
  0x1ef8,
  "Yusbigcyrillic",
  0x046a,
  "Yusbigiotifiedcyrillic",
  0x046c,
  "Yuslittlecyrillic",
  0x0466,
  "Yuslittleiotifiedcyrillic",
  0x0468,
  "Z",
  0x005a,
  "Zaarmenian",
  0x0536,
  "Zacute",
  0x0179,
  "Zcaron",
  0x017d,
  "Zcaronsmall",
  0xf6ff,
  "Zcircle",
  0x24cf,
  "Zcircumflex",
  0x1e90,
  "Zdot",
  0x017b,
  "Zdotaccent",
  0x017b,
  "Zdotbelow",
  0x1e92,
  "Zecyrillic",
  0x0417,
  "Zedescendercyrillic",
  0x0498,
  "Zedieresiscyrillic",
  0x04de,
  "Zeta",
  0x0396,
  "Zhearmenian",
  0x053a,
  "Zhebrevecyrillic",
  0x04c1,
  "Zhecyrillic",
  0x0416,
  "Zhedescendercyrillic",
  0x0496,
  "Zhedieresiscyrillic",
  0x04dc,
  "Zlinebelow",
  0x1e94,
  "Zmonospace",
  0xff3a,
  "Zsmall",
  0xf77a,
  "Zstroke",
  0x01b5,
  "a",
  0x0061,
  "aabengali",
  0x0986,
  "aacute",
  0x00e1,
  "aadeva",
  0x0906,
  "aagujarati",
  0x0a86,
  "aagurmukhi",
  0x0a06,
  "aamatragurmukhi",
  0x0a3e,
  "aarusquare",
  0x3303,
  "aavowelsignbengali",
  0x09be,
  "aavowelsigndeva",
  0x093e,
  "aavowelsigngujarati",
  0x0abe,
  "abbreviationmarkarmenian",
  0x055f,
  "abbreviationsigndeva",
  0x0970,
  "abengali",
  0x0985,
  "abopomofo",
  0x311a,
  "abreve",
  0x0103,
  "abreveacute",
  0x1eaf,
  "abrevecyrillic",
  0x04d1,
  "abrevedotbelow",
  0x1eb7,
  "abrevegrave",
  0x1eb1,
  "abrevehookabove",
  0x1eb3,
  "abrevetilde",
  0x1eb5,
  "acaron",
  0x01ce,
  "acircle",
  0x24d0,
  "acircumflex",
  0x00e2,
  "acircumflexacute",
  0x1ea5,
  "acircumflexdotbelow",
  0x1ead,
  "acircumflexgrave",
  0x1ea7,
  "acircumflexhookabove",
  0x1ea9,
  "acircumflextilde",
  0x1eab,
  "acute",
  0x00b4,
  "acutebelowcmb",
  0x0317,
  "acutecmb",
  0x0301,
  "acutecomb",
  0x0301,
  "acutedeva",
  0x0954,
  "acutelowmod",
  0x02cf,
  "acutetonecmb",
  0x0341,
  "acyrillic",
  0x0430,
  "adblgrave",
  0x0201,
  "addakgurmukhi",
  0x0a71,
  "adeva",
  0x0905,
  "adieresis",
  0x00e4,
  "adieresiscyrillic",
  0x04d3,
  "adieresismacron",
  0x01df,
  "adotbelow",
  0x1ea1,
  "adotmacron",
  0x01e1,
  "ae",
  0x00e6,
  "aeacute",
  0x01fd,
  "aekorean",
  0x3150,
  "aemacron",
  0x01e3,
  "afii00208",
  0x2015,
  "afii08941",
  0x20a4,
  "afii10017",
  0x0410,
  "afii10018",
  0x0411,
  "afii10019",
  0x0412,
  "afii10020",
  0x0413,
  "afii10021",
  0x0414,
  "afii10022",
  0x0415,
  "afii10023",
  0x0401,
  "afii10024",
  0x0416,
  "afii10025",
  0x0417,
  "afii10026",
  0x0418,
  "afii10027",
  0x0419,
  "afii10028",
  0x041a,
  "afii10029",
  0x041b,
  "afii10030",
  0x041c,
  "afii10031",
  0x041d,
  "afii10032",
  0x041e,
  "afii10033",
  0x041f,
  "afii10034",
  0x0420,
  "afii10035",
  0x0421,
  "afii10036",
  0x0422,
  "afii10037",
  0x0423,
  "afii10038",
  0x0424,
  "afii10039",
  0x0425,
  "afii10040",
  0x0426,
  "afii10041",
  0x0427,
  "afii10042",
  0x0428,
  "afii10043",
  0x0429,
  "afii10044",
  0x042a,
  "afii10045",
  0x042b,
  "afii10046",
  0x042c,
  "afii10047",
  0x042d,
  "afii10048",
  0x042e,
  "afii10049",
  0x042f,
  "afii10050",
  0x0490,
  "afii10051",
  0x0402,
  "afii10052",
  0x0403,
  "afii10053",
  0x0404,
  "afii10054",
  0x0405,
  "afii10055",
  0x0406,
  "afii10056",
  0x0407,
  "afii10057",
  0x0408,
  "afii10058",
  0x0409,
  "afii10059",
  0x040a,
  "afii10060",
  0x040b,
  "afii10061",
  0x040c,
  "afii10062",
  0x040e,
  "afii10063",
  0xf6c4,
  "afii10064",
  0xf6c5,
  "afii10065",
  0x0430,
  "afii10066",
  0x0431,
  "afii10067",
  0x0432,
  "afii10068",
  0x0433,
  "afii10069",
  0x0434,
  "afii10070",
  0x0435,
  "afii10071",
  0x0451,
  "afii10072",
  0x0436,
  "afii10073",
  0x0437,
  "afii10074",
  0x0438,
  "afii10075",
  0x0439,
  "afii10076",
  0x043a,
  "afii10077",
  0x043b,
  "afii10078",
  0x043c,
  "afii10079",
  0x043d,
  "afii10080",
  0x043e,
  "afii10081",
  0x043f,
  "afii10082",
  0x0440,
  "afii10083",
  0x0441,
  "afii10084",
  0x0442,
  "afii10085",
  0x0443,
  "afii10086",
  0x0444,
  "afii10087",
  0x0445,
  "afii10088",
  0x0446,
  "afii10089",
  0x0447,
  "afii10090",
  0x0448,
  "afii10091",
  0x0449,
  "afii10092",
  0x044a,
  "afii10093",
  0x044b,
  "afii10094",
  0x044c,
  "afii10095",
  0x044d,
  "afii10096",
  0x044e,
  "afii10097",
  0x044f,
  "afii10098",
  0x0491,
  "afii10099",
  0x0452,
  "afii10100",
  0x0453,
  "afii10101",
  0x0454,
  "afii10102",
  0x0455,
  "afii10103",
  0x0456,
  "afii10104",
  0x0457,
  "afii10105",
  0x0458,
  "afii10106",
  0x0459,
  "afii10107",
  0x045a,
  "afii10108",
  0x045b,
  "afii10109",
  0x045c,
  "afii10110",
  0x045e,
  "afii10145",
  0x040f,
  "afii10146",
  0x0462,
  "afii10147",
  0x0472,
  "afii10148",
  0x0474,
  "afii10192",
  0xf6c6,
  "afii10193",
  0x045f,
  "afii10194",
  0x0463,
  "afii10195",
  0x0473,
  "afii10196",
  0x0475,
  "afii10831",
  0xf6c7,
  "afii10832",
  0xf6c8,
  "afii10846",
  0x04d9,
  "afii299",
  0x200e,
  "afii300",
  0x200f,
  "afii301",
  0x200d,
  "afii57381",
  0x066a,
  "afii57388",
  0x060c,
  "afii57392",
  0x0660,
  "afii57393",
  0x0661,
  "afii57394",
  0x0662,
  "afii57395",
  0x0663,
  "afii57396",
  0x0664,
  "afii57397",
  0x0665,
  "afii57398",
  0x0666,
  "afii57399",
  0x0667,
  "afii57400",
  0x0668,
  "afii57401",
  0x0669,
  "afii57403",
  0x061b,
  "afii57407",
  0x061f,
  "afii57409",
  0x0621,
  "afii57410",
  0x0622,
  "afii57411",
  0x0623,
  "afii57412",
  0x0624,
  "afii57413",
  0x0625,
  "afii57414",
  0x0626,
  "afii57415",
  0x0627,
  "afii57416",
  0x0628,
  "afii57417",
  0x0629,
  "afii57418",
  0x062a,
  "afii57419",
  0x062b,
  "afii57420",
  0x062c,
  "afii57421",
  0x062d,
  "afii57422",
  0x062e,
  "afii57423",
  0x062f,
  "afii57424",
  0x0630,
  "afii57425",
  0x0631,
  "afii57426",
  0x0632,
  "afii57427",
  0x0633,
  "afii57428",
  0x0634,
  "afii57429",
  0x0635,
  "afii57430",
  0x0636,
  "afii57431",
  0x0637,
  "afii57432",
  0x0638,
  "afii57433",
  0x0639,
  "afii57434",
  0x063a,
  "afii57440",
  0x0640,
  "afii57441",
  0x0641,
  "afii57442",
  0x0642,
  "afii57443",
  0x0643,
  "afii57444",
  0x0644,
  "afii57445",
  0x0645,
  "afii57446",
  0x0646,
  "afii57448",
  0x0648,
  "afii57449",
  0x0649,
  "afii57450",
  0x064a,
  "afii57451",
  0x064b,
  "afii57452",
  0x064c,
  "afii57453",
  0x064d,
  "afii57454",
  0x064e,
  "afii57455",
  0x064f,
  "afii57456",
  0x0650,
  "afii57457",
  0x0651,
  "afii57458",
  0x0652,
  "afii57470",
  0x0647,
  "afii57505",
  0x06a4,
  "afii57506",
  0x067e,
  "afii57507",
  0x0686,
  "afii57508",
  0x0698,
  "afii57509",
  0x06af,
  "afii57511",
  0x0679,
  "afii57512",
  0x0688,
  "afii57513",
  0x0691,
  "afii57514",
  0x06ba,
  "afii57519",
  0x06d2,
  "afii57534",
  0x06d5,
  "afii57636",
  0x20aa,
  "afii57645",
  0x05be,
  "afii57658",
  0x05c3,
  "afii57664",
  0x05d0,
  "afii57665",
  0x05d1,
  "afii57666",
  0x05d2,
  "afii57667",
  0x05d3,
  "afii57668",
  0x05d4,
  "afii57669",
  0x05d5,
  "afii57670",
  0x05d6,
  "afii57671",
  0x05d7,
  "afii57672",
  0x05d8,
  "afii57673",
  0x05d9,
  "afii57674",
  0x05da,
  "afii57675",
  0x05db,
  "afii57676",
  0x05dc,
  "afii57677",
  0x05dd,
  "afii57678",
  0x05de,
  "afii57679",
  0x05df,
  "afii57680",
  0x05e0,
  "afii57681",
  0x05e1,
  "afii57682",
  0x05e2,
  "afii57683",
  0x05e3,
  "afii57684",
  0x05e4,
  "afii57685",
  0x05e5,
  "afii57686",
  0x05e6,
  "afii57687",
  0x05e7,
  "afii57688",
  0x05e8,
  "afii57689",
  0x05e9,
  "afii57690",
  0x05ea,
  "afii57694",
  0xfb2a,
  "afii57695",
  0xfb2b,
  "afii57700",
  0xfb4b,
  "afii57705",
  0xfb1f,
  "afii57716",
  0x05f0,
  "afii57717",
  0x05f1,
  "afii57718",
  0x05f2,
  "afii57723",
  0xfb35,
  "afii57793",
  0x05b4,
  "afii57794",
  0x05b5,
  "afii57795",
  0x05b6,
  "afii57796",
  0x05bb,
  "afii57797",
  0x05b8,
  "afii57798",
  0x05b7,
  "afii57799",
  0x05b0,
  "afii57800",
  0x05b2,
  "afii57801",
  0x05b1,
  "afii57802",
  0x05b3,
  "afii57803",
  0x05c2,
  "afii57804",
  0x05c1,
  "afii57806",
  0x05b9,
  "afii57807",
  0x05bc,
  "afii57839",
  0x05bd,
  "afii57841",
  0x05bf,
  "afii57842",
  0x05c0,
  "afii57929",
  0x02bc,
  "afii61248",
  0x2105,
  "afii61289",
  0x2113,
  "afii61352",
  0x2116,
  "afii61573",
  0x202c,
  "afii61574",
  0x202d,
  "afii61575",
  0x202e,
  "afii61664",
  0x200c,
  "afii63167",
  0x066d,
  "afii64937",
  0x02bd,
  "agrave",
  0x00e0,
  "agujarati",
  0x0a85,
  "agurmukhi",
  0x0a05,
  "ahiragana",
  0x3042,
  "ahookabove",
  0x1ea3,
  "aibengali",
  0x0990,
  "aibopomofo",
  0x311e,
  "aideva",
  0x0910,
  "aiecyrillic",
  0x04d5,
  "aigujarati",
  0x0a90,
  "aigurmukhi",
  0x0a10,
  "aimatragurmukhi",
  0x0a48,
  "ainarabic",
  0x0639,
  "ainfinalarabic",
  0xfeca,
  "aininitialarabic",
  0xfecb,
  "ainmedialarabic",
  0xfecc,
  "ainvertedbreve",
  0x0203,
  "aivowelsignbengali",
  0x09c8,
  "aivowelsigndeva",
  0x0948,
  "aivowelsigngujarati",
  0x0ac8,
  "akatakana",
  0x30a2,
  "akatakanahalfwidth",
  0xff71,
  "akorean",
  0x314f,
  "alef",
  0x05d0,
  "alefarabic",
  0x0627,
  "alefdageshhebrew",
  0xfb30,
  "aleffinalarabic",
  0xfe8e,
  "alefhamzaabovearabic",
  0x0623,
  "alefhamzaabovefinalarabic",
  0xfe84,
  "alefhamzabelowarabic",
  0x0625,
  "alefhamzabelowfinalarabic",
  0xfe88,
  "alefhebrew",
  0x05d0,
  "aleflamedhebrew",
  0xfb4f,
  "alefmaddaabovearabic",
  0x0622,
  "alefmaddaabovefinalarabic",
  0xfe82,
  "alefmaksuraarabic",
  0x0649,
  "alefmaksurafinalarabic",
  0xfef0,
  "alefmaksurainitialarabic",
  0xfef3,
  "alefmaksuramedialarabic",
  0xfef4,
  "alefpatahhebrew",
  0xfb2e,
  "alefqamatshebrew",
  0xfb2f,
  "aleph",
  0x2135,
  "allequal",
  0x224c,
  "alpha",
  0x03b1,
  "alphatonos",
  0x03ac,
  "amacron",
  0x0101,
  "amonospace",
  0xff41,
  "ampersand",
  0x0026,
  "ampersandmonospace",
  0xff06,
  "ampersandsmall",
  0xf726,
  "amsquare",
  0x33c2,
  "anbopomofo",
  0x3122,
  "angbopomofo",
  0x3124,
  "angbracketleft",
  0x3008,
  "angbracketright",
  0x3009,
  "angkhankhuthai",
  0x0e5a,
  "angle",
  0x2220,
  "anglebracketleft",
  0x3008,
  "anglebracketleftvertical",
  0xfe3f,
  "anglebracketright",
  0x3009,
  "anglebracketrightvertical",
  0xfe40,
  "angleleft",
  0x2329,
  "angleright",
  0x232a,
  "angstrom",
  0x212b,
  "anoteleia",
  0x0387,
  "anudattadeva",
  0x0952,
  "anusvarabengali",
  0x0982,
  "anusvaradeva",
  0x0902,
  "anusvaragujarati",
  0x0a82,
  "aogonek",
  0x0105,
  "apaatosquare",
  0x3300,
  "aparen",
  0x249c,
  "apostrophearmenian",
  0x055a,
  "apostrophemod",
  0x02bc,
  "apple",
  0xf8ff,
  "approaches",
  0x2250,
  "approxequal",
  0x2248,
  "approxequalorimage",
  0x2252,
  "approximatelyequal",
  0x2245,
  "araeaekorean",
  0x318e,
  "araeakorean",
  0x318d,
  "arc",
  0x2312,
  "arighthalfring",
  0x1e9a,
  "aring",
  0x00e5,
  "aringacute",
  0x01fb,
  "aringbelow",
  0x1e01,
  "arrowboth",
  0x2194,
  "arrowdashdown",
  0x21e3,
  "arrowdashleft",
  0x21e0,
  "arrowdashright",
  0x21e2,
  "arrowdashup",
  0x21e1,
  "arrowdblboth",
  0x21d4,
  "arrowdbldown",
  0x21d3,
  "arrowdblleft",
  0x21d0,
  "arrowdblright",
  0x21d2,
  "arrowdblup",
  0x21d1,
  "arrowdown",
  0x2193,
  "arrowdownleft",
  0x2199,
  "arrowdownright",
  0x2198,
  "arrowdownwhite",
  0x21e9,
  "arrowheaddownmod",
  0x02c5,
  "arrowheadleftmod",
  0x02c2,
  "arrowheadrightmod",
  0x02c3,
  "arrowheadupmod",
  0x02c4,
  "arrowhorizex",
  0xf8e7,
  "arrowleft",
  0x2190,
  "arrowleftdbl",
  0x21d0,
  "arrowleftdblstroke",
  0x21cd,
  "arrowleftoverright",
  0x21c6,
  "arrowleftwhite",
  0x21e6,
  "arrowright",
  0x2192,
  "arrowrightdblstroke",
  0x21cf,
  "arrowrightheavy",
  0x279e,
  "arrowrightoverleft",
  0x21c4,
  "arrowrightwhite",
  0x21e8,
  "arrowtableft",
  0x21e4,
  "arrowtabright",
  0x21e5,
  "arrowup",
  0x2191,
  "arrowupdn",
  0x2195,
  "arrowupdnbse",
  0x21a8,
  "arrowupdownbase",
  0x21a8,
  "arrowupleft",
  0x2196,
  "arrowupleftofdown",
  0x21c5,
  "arrowupright",
  0x2197,
  "arrowupwhite",
  0x21e7,
  "arrowvertex",
  0xf8e6,
  "asciicircum",
  0x005e,
  "asciicircummonospace",
  0xff3e,
  "asciitilde",
  0x007e,
  "asciitildemonospace",
  0xff5e,
  "ascript",
  0x0251,
  "ascriptturned",
  0x0252,
  "asmallhiragana",
  0x3041,
  "asmallkatakana",
  0x30a1,
  "asmallkatakanahalfwidth",
  0xff67,
  "asterisk",
  0x002a,
  "asteriskaltonearabic",
  0x066d,
  "asteriskarabic",
  0x066d,
  "asteriskmath",
  0x2217,
  "asteriskmonospace",
  0xff0a,
  "asterisksmall",
  0xfe61,
  "asterism",
  0x2042,
  "asuperior",
  0xf6e9,
  "asymptoticallyequal",
  0x2243,
  "at",
  0x0040,
  "atilde",
  0x00e3,
  "atmonospace",
  0xff20,
  "atsmall",
  0xfe6b,
  "aturned",
  0x0250,
  "aubengali",
  0x0994,
  "aubopomofo",
  0x3120,
  "audeva",
  0x0914,
  "augujarati",
  0x0a94,
  "augurmukhi",
  0x0a14,
  "aulengthmarkbengali",
  0x09d7,
  "aumatragurmukhi",
  0x0a4c,
  "auvowelsignbengali",
  0x09cc,
  "auvowelsigndeva",
  0x094c,
  "auvowelsigngujarati",
  0x0acc,
  "avagrahadeva",
  0x093d,
  "aybarmenian",
  0x0561,
  "ayin",
  0x05e2,
  "ayinaltonehebrew",
  0xfb20,
  "ayinhebrew",
  0x05e2,
  "b",
  0x0062,
  "babengali",
  0x09ac,
  "backslash",
  0x005c,
  "backslashmonospace",
  0xff3c,
  "badeva",
  0x092c,
  "bagujarati",
  0x0aac,
  "bagurmukhi",
  0x0a2c,
  "bahiragana",
  0x3070,
  "bahtthai",
  0x0e3f,
  "bakatakana",
  0x30d0,
  "bar",
  0x007c,
  "barmonospace",
  0xff5c,
  "bbopomofo",
  0x3105,
  "bcircle",
  0x24d1,
  "bdotaccent",
  0x1e03,
  "bdotbelow",
  0x1e05,
  "beamedsixteenthnotes",
  0x266c,
  "because",
  0x2235,
  "becyrillic",
  0x0431,
  "beharabic",
  0x0628,
  "behfinalarabic",
  0xfe90,
  "behinitialarabic",
  0xfe91,
  "behiragana",
  0x3079,
  "behmedialarabic",
  0xfe92,
  "behmeeminitialarabic",
  0xfc9f,
  "behmeemisolatedarabic",
  0xfc08,
  "behnoonfinalarabic",
  0xfc6d,
  "bekatakana",
  0x30d9,
  "benarmenian",
  0x0562,
  "bet",
  0x05d1,
  "beta",
  0x03b2,
  "betasymbolgreek",
  0x03d0,
  "betdagesh",
  0xfb31,
  "betdageshhebrew",
  0xfb31,
  "bethebrew",
  0x05d1,
  "betrafehebrew",
  0xfb4c,
  "bhabengali",
  0x09ad,
  "bhadeva",
  0x092d,
  "bhagujarati",
  0x0aad,
  "bhagurmukhi",
  0x0a2d,
  "bhook",
  0x0253,
  "bihiragana",
  0x3073,
  "bikatakana",
  0x30d3,
  "bilabialclick",
  0x0298,
  "bindigurmukhi",
  0x0a02,
  "birusquare",
  0x3331,
  "blackcircle",
  0x25cf,
  "blackdiamond",
  0x25c6,
  "blackdownpointingtriangle",
  0x25bc,
  "blackleftpointingpointer",
  0x25c4,
  "blackleftpointingtriangle",
  0x25c0,
  "blacklenticularbracketleft",
  0x3010,
  "blacklenticularbracketleftvertical",
  0xfe3b,
  "blacklenticularbracketright",
  0x3011,
  "blacklenticularbracketrightvertical",
  0xfe3c,
  "blacklowerlefttriangle",
  0x25e3,
  "blacklowerrighttriangle",
  0x25e2,
  "blackrectangle",
  0x25ac,
  "blackrightpointingpointer",
  0x25ba,
  "blackrightpointingtriangle",
  0x25b6,
  "blacksmallsquare",
  0x25aa,
  "blacksmilingface",
  0x263b,
  "blacksquare",
  0x25a0,
  "blackstar",
  0x2605,
  "blackupperlefttriangle",
  0x25e4,
  "blackupperrighttriangle",
  0x25e5,
  "blackuppointingsmalltriangle",
  0x25b4,
  "blackuppointingtriangle",
  0x25b2,
  "blank",
  0x2423,
  "blinebelow",
  0x1e07,
  "block",
  0x2588,
  "bmonospace",
  0xff42,
  "bobaimaithai",
  0x0e1a,
  "bohiragana",
  0x307c,
  "bokatakana",
  0x30dc,
  "bparen",
  0x249d,
  "bqsquare",
  0x33c3,
  "braceex",
  0xf8f4,
  "braceleft",
  0x007b,
  "braceleftbt",
  0xf8f3,
  "braceleftmid",
  0xf8f2,
  "braceleftmonospace",
  0xff5b,
  "braceleftsmall",
  0xfe5b,
  "bracelefttp",
  0xf8f1,
  "braceleftvertical",
  0xfe37,
  "braceright",
  0x007d,
  "bracerightbt",
  0xf8fe,
  "bracerightmid",
  0xf8fd,
  "bracerightmonospace",
  0xff5d,
  "bracerightsmall",
  0xfe5c,
  "bracerighttp",
  0xf8fc,
  "bracerightvertical",
  0xfe38,
  "bracketleft",
  0x005b,
  "bracketleftbt",
  0xf8f0,
  "bracketleftex",
  0xf8ef,
  "bracketleftmonospace",
  0xff3b,
  "bracketlefttp",
  0xf8ee,
  "bracketright",
  0x005d,
  "bracketrightbt",
  0xf8fb,
  "bracketrightex",
  0xf8fa,
  "bracketrightmonospace",
  0xff3d,
  "bracketrighttp",
  0xf8f9,
  "breve",
  0x02d8,
  "brevebelowcmb",
  0x032e,
  "brevecmb",
  0x0306,
  "breveinvertedbelowcmb",
  0x032f,
  "breveinvertedcmb",
  0x0311,
  "breveinverteddoublecmb",
  0x0361,
  "bridgebelowcmb",
  0x032a,
  "bridgeinvertedbelowcmb",
  0x033a,
  "brokenbar",
  0x00a6,
  "bstroke",
  0x0180,
  "bsuperior",
  0xf6ea,
  "btopbar",
  0x0183,
  "buhiragana",
  0x3076,
  "bukatakana",
  0x30d6,
  "bullet",
  0x2022,
  "bulletinverse",
  0x25d8,
  "bulletoperator",
  0x2219,
  "bullseye",
  0x25ce,
  "c",
  0x0063,
  "caarmenian",
  0x056e,
  "cabengali",
  0x099a,
  "cacute",
  0x0107,
  "cadeva",
  0x091a,
  "cagujarati",
  0x0a9a,
  "cagurmukhi",
  0x0a1a,
  "calsquare",
  0x3388,
  "candrabindubengali",
  0x0981,
  "candrabinducmb",
  0x0310,
  "candrabindudeva",
  0x0901,
  "candrabindugujarati",
  0x0a81,
  "capslock",
  0x21ea,
  "careof",
  0x2105,
  "caron",
  0x02c7,
  "caronbelowcmb",
  0x032c,
  "caroncmb",
  0x030c,
  "carriagereturn",
  0x21b5,
  "cbopomofo",
  0x3118,
  "ccaron",
  0x010d,
  "ccedilla",
  0x00e7,
  "ccedillaacute",
  0x1e09,
  "ccircle",
  0x24d2,
  "ccircumflex",
  0x0109,
  "ccurl",
  0x0255,
  "cdot",
  0x010b,
  "cdotaccent",
  0x010b,
  "cdsquare",
  0x33c5,
  "cedilla",
  0x00b8,
  "cedillacmb",
  0x0327,
  "cent",
  0x00a2,
  "centigrade",
  0x2103,
  "centinferior",
  0xf6df,
  "centmonospace",
  0xffe0,
  "centoldstyle",
  0xf7a2,
  "centsuperior",
  0xf6e0,
  "chaarmenian",
  0x0579,
  "chabengali",
  0x099b,
  "chadeva",
  0x091b,
  "chagujarati",
  0x0a9b,
  "chagurmukhi",
  0x0a1b,
  "chbopomofo",
  0x3114,
  "cheabkhasiancyrillic",
  0x04bd,
  "checkmark",
  0x2713,
  "checyrillic",
  0x0447,
  "chedescenderabkhasiancyrillic",
  0x04bf,
  "chedescendercyrillic",
  0x04b7,
  "chedieresiscyrillic",
  0x04f5,
  "cheharmenian",
  0x0573,
  "chekhakassiancyrillic",
  0x04cc,
  "cheverticalstrokecyrillic",
  0x04b9,
  "chi",
  0x03c7,
  "chieuchacirclekorean",
  0x3277,
  "chieuchaparenkorean",
  0x3217,
  "chieuchcirclekorean",
  0x3269,
  "chieuchkorean",
  0x314a,
  "chieuchparenkorean",
  0x3209,
  "chochangthai",
  0x0e0a,
  "chochanthai",
  0x0e08,
  "chochingthai",
  0x0e09,
  "chochoethai",
  0x0e0c,
  "chook",
  0x0188,
  "cieucacirclekorean",
  0x3276,
  "cieucaparenkorean",
  0x3216,
  "cieuccirclekorean",
  0x3268,
  "cieuckorean",
  0x3148,
  "cieucparenkorean",
  0x3208,
  "cieucuparenkorean",
  0x321c,
  "circle",
  0x25cb,
  "circlecopyrt",
  0x00a9,
  "circlemultiply",
  0x2297,
  "circleot",
  0x2299,
  "circleplus",
  0x2295,
  "circlepostalmark",
  0x3036,
  "circlewithlefthalfblack",
  0x25d0,
  "circlewithrighthalfblack",
  0x25d1,
  "circumflex",
  0x02c6,
  "circumflexbelowcmb",
  0x032d,
  "circumflexcmb",
  0x0302,
  "clear",
  0x2327,
  "clickalveolar",
  0x01c2,
  "clickdental",
  0x01c0,
  "clicklateral",
  0x01c1,
  "clickretroflex",
  0x01c3,
  "club",
  0x2663,
  "clubsuitblack",
  0x2663,
  "clubsuitwhite",
  0x2667,
  "cmcubedsquare",
  0x33a4,
  "cmonospace",
  0xff43,
  "cmsquaredsquare",
  0x33a0,
  "coarmenian",
  0x0581,
  "colon",
  0x003a,
  "colonmonetary",
  0x20a1,
  "colonmonospace",
  0xff1a,
  "colonsign",
  0x20a1,
  "colonsmall",
  0xfe55,
  "colontriangularhalfmod",
  0x02d1,
  "colontriangularmod",
  0x02d0,
  "comma",
  0x002c,
  "commaabovecmb",
  0x0313,
  "commaaboverightcmb",
  0x0315,
  "commaaccent",
  0xf6c3,
  "commaarabic",
  0x060c,
  "commaarmenian",
  0x055d,
  "commainferior",
  0xf6e1,
  "commamonospace",
  0xff0c,
  "commareversedabovecmb",
  0x0314,
  "commareversedmod",
  0x02bd,
  "commasmall",
  0xfe50,
  "commasuperior",
  0xf6e2,
  "commaturnedabovecmb",
  0x0312,
  "commaturnedmod",
  0x02bb,
  "compass",
  0x263c,
  "congruent",
  0x2245,
  "contourintegral",
  0x222e,
  "control",
  0x2303,
  "controlACK",
  0x0006,
  "controlBEL",
  0x0007,
  "controlBS",
  0x0008,
  "controlCAN",
  0x0018,
  "controlCR",
  0x000d,
  "controlDC1",
  0x0011,
  "controlDC2",
  0x0012,
  "controlDC3",
  0x0013,
  "controlDC4",
  0x0014,
  "controlDEL",
  0x007f,
  "controlDLE",
  0x0010,
  "controlEM",
  0x0019,
  "controlENQ",
  0x0005,
  "controlEOT",
  0x0004,
  "controlESC",
  0x001b,
  "controlETB",
  0x0017,
  "controlETX",
  0x0003,
  "controlFF",
  0x000c,
  "controlFS",
  0x001c,
  "controlGS",
  0x001d,
  "controlHT",
  0x0009,
  "controlLF",
  0x000a,
  "controlNAK",
  0x0015,
  "controlNULL",
  0x0000,
  "controlRS",
  0x001e,
  "controlSI",
  0x000f,
  "controlSO",
  0x000e,
  "controlSOT",
  0x0002,
  "controlSTX",
  0x0001,
  "controlSUB",
  0x001a,
  "controlSYN",
  0x0016,
  "controlUS",
  0x001f,
  "controlVT",
  0x000b,
  "copyright",
  0x00a9,
  "copyrightsans",
  0xf8e9,
  "copyrightserif",
  0xf6d9,
  "cornerbracketleft",
  0x300c,
  "cornerbracketlefthalfwidth",
  0xff62,
  "cornerbracketleftvertical",
  0xfe41,
  "cornerbracketright",
  0x300d,
  "cornerbracketrighthalfwidth",
  0xff63,
  "cornerbracketrightvertical",
  0xfe42,
  "corporationsquare",
  0x337f,
  "cosquare",
  0x33c7,
  "coverkgsquare",
  0x33c6,
  "cparen",
  0x249e,
  "cruzeiro",
  0x20a2,
  "cstretched",
  0x0297,
  "curlyand",
  0x22cf,
  "curlyor",
  0x22ce,
  "currency",
  0x00a4,
  "cyrBreve",
  0xf6d1,
  "cyrFlex",
  0xf6d2,
  "cyrbreve",
  0xf6d4,
  "cyrflex",
  0xf6d5,
  "d",
  0x0064,
  "daarmenian",
  0x0564,
  "dabengali",
  0x09a6,
  "dadarabic",
  0x0636,
  "dadeva",
  0x0926,
  "dadfinalarabic",
  0xfebe,
  "dadinitialarabic",
  0xfebf,
  "dadmedialarabic",
  0xfec0,
  "dagesh",
  0x05bc,
  "dageshhebrew",
  0x05bc,
  "dagger",
  0x2020,
  "daggerdbl",
  0x2021,
  "dagujarati",
  0x0aa6,
  "dagurmukhi",
  0x0a26,
  "dahiragana",
  0x3060,
  "dakatakana",
  0x30c0,
  "dalarabic",
  0x062f,
  "dalet",
  0x05d3,
  "daletdagesh",
  0xfb33,
  "daletdageshhebrew",
  0xfb33,
  "dalethebrew",
  0x05d3,
  "dalfinalarabic",
  0xfeaa,
  "dammaarabic",
  0x064f,
  "dammalowarabic",
  0x064f,
  "dammatanaltonearabic",
  0x064c,
  "dammatanarabic",
  0x064c,
  "danda",
  0x0964,
  "dargahebrew",
  0x05a7,
  "dargalefthebrew",
  0x05a7,
  "dasiapneumatacyrilliccmb",
  0x0485,
  "dblGrave",
  0xf6d3,
  "dblanglebracketleft",
  0x300a,
  "dblanglebracketleftvertical",
  0xfe3d,
  "dblanglebracketright",
  0x300b,
  "dblanglebracketrightvertical",
  0xfe3e,
  "dblarchinvertedbelowcmb",
  0x032b,
  "dblarrowleft",
  0x21d4,
  "dblarrowright",
  0x21d2,
  "dbldanda",
  0x0965,
  "dblgrave",
  0xf6d6,
  "dblgravecmb",
  0x030f,
  "dblintegral",
  0x222c,
  "dbllowline",
  0x2017,
  "dbllowlinecmb",
  0x0333,
  "dbloverlinecmb",
  0x033f,
  "dblprimemod",
  0x02ba,
  "dblverticalbar",
  0x2016,
  "dblverticallineabovecmb",
  0x030e,
  "dbopomofo",
  0x3109,
  "dbsquare",
  0x33c8,
  "dcaron",
  0x010f,
  "dcedilla",
  0x1e11,
  "dcircle",
  0x24d3,
  "dcircumflexbelow",
  0x1e13,
  "dcroat",
  0x0111,
  "ddabengali",
  0x09a1,
  "ddadeva",
  0x0921,
  "ddagujarati",
  0x0aa1,
  "ddagurmukhi",
  0x0a21,
  "ddalarabic",
  0x0688,
  "ddalfinalarabic",
  0xfb89,
  "dddhadeva",
  0x095c,
  "ddhabengali",
  0x09a2,
  "ddhadeva",
  0x0922,
  "ddhagujarati",
  0x0aa2,
  "ddhagurmukhi",
  0x0a22,
  "ddotaccent",
  0x1e0b,
  "ddotbelow",
  0x1e0d,
  "decimalseparatorarabic",
  0x066b,
  "decimalseparatorpersian",
  0x066b,
  "decyrillic",
  0x0434,
  "degree",
  0x00b0,
  "dehihebrew",
  0x05ad,
  "dehiragana",
  0x3067,
  "deicoptic",
  0x03ef,
  "dekatakana",
  0x30c7,
  "deleteleft",
  0x232b,
  "deleteright",
  0x2326,
  "delta",
  0x03b4,
  "deltaturned",
  0x018d,
  "denominatorminusonenumeratorbengali",
  0x09f8,
  "dezh",
  0x02a4,
  "dhabengali",
  0x09a7,
  "dhadeva",
  0x0927,
  "dhagujarati",
  0x0aa7,
  "dhagurmukhi",
  0x0a27,
  "dhook",
  0x0257,
  "dialytikatonos",
  0x0385,
  "dialytikatonoscmb",
  0x0344,
  "diamond",
  0x2666,
  "diamondsuitwhite",
  0x2662,
  "dieresis",
  0x00a8,
  "dieresisacute",
  0xf6d7,
  "dieresisbelowcmb",
  0x0324,
  "dieresiscmb",
  0x0308,
  "dieresisgrave",
  0xf6d8,
  "dieresistonos",
  0x0385,
  "dihiragana",
  0x3062,
  "dikatakana",
  0x30c2,
  "dittomark",
  0x3003,
  "divide",
  0x00f7,
  "divides",
  0x2223,
  "divisionslash",
  0x2215,
  "djecyrillic",
  0x0452,
  "dkshade",
  0x2593,
  "dlinebelow",
  0x1e0f,
  "dlsquare",
  0x3397,
  "dmacron",
  0x0111,
  "dmonospace",
  0xff44,
  "dnblock",
  0x2584,
  "dochadathai",
  0x0e0e,
  "dodekthai",
  0x0e14,
  "dohiragana",
  0x3069,
  "dokatakana",
  0x30c9,
  "dollar",
  0x0024,
  "dollarinferior",
  0xf6e3,
  "dollarmonospace",
  0xff04,
  "dollaroldstyle",
  0xf724,
  "dollarsmall",
  0xfe69,
  "dollarsuperior",
  0xf6e4,
  "dong",
  0x20ab,
  "dorusquare",
  0x3326,
  "dotaccent",
  0x02d9,
  "dotaccentcmb",
  0x0307,
  "dotbelowcmb",
  0x0323,
  "dotbelowcomb",
  0x0323,
  "dotkatakana",
  0x30fb,
  "dotlessi",
  0x0131,
  "dotlessj",
  0xf6be,
  "dotlessjstrokehook",
  0x0284,
  "dotmath",
  0x22c5,
  "dottedcircle",
  0x25cc,
  "doubleyodpatah",
  0xfb1f,
  "doubleyodpatahhebrew",
  0xfb1f,
  "downtackbelowcmb",
  0x031e,
  "downtackmod",
  0x02d5,
  "dparen",
  0x249f,
  "dsuperior",
  0xf6eb,
  "dtail",
  0x0256,
  "dtopbar",
  0x018c,
  "duhiragana",
  0x3065,
  "dukatakana",
  0x30c5,
  "dz",
  0x01f3,
  "dzaltone",
  0x02a3,
  "dzcaron",
  0x01c6,
  "dzcurl",
  0x02a5,
  "dzeabkhasiancyrillic",
  0x04e1,
  "dzecyrillic",
  0x0455,
  "dzhecyrillic",
  0x045f,
  "e",
  0x0065,
  "eacute",
  0x00e9,
  "earth",
  0x2641,
  "ebengali",
  0x098f,
  "ebopomofo",
  0x311c,
  "ebreve",
  0x0115,
  "ecandradeva",
  0x090d,
  "ecandragujarati",
  0x0a8d,
  "ecandravowelsigndeva",
  0x0945,
  "ecandravowelsigngujarati",
  0x0ac5,
  "ecaron",
  0x011b,
  "ecedillabreve",
  0x1e1d,
  "echarmenian",
  0x0565,
  "echyiwnarmenian",
  0x0587,
  "ecircle",
  0x24d4,
  "ecircumflex",
  0x00ea,
  "ecircumflexacute",
  0x1ebf,
  "ecircumflexbelow",
  0x1e19,
  "ecircumflexdotbelow",
  0x1ec7,
  "ecircumflexgrave",
  0x1ec1,
  "ecircumflexhookabove",
  0x1ec3,
  "ecircumflextilde",
  0x1ec5,
  "ecyrillic",
  0x0454,
  "edblgrave",
  0x0205,
  "edeva",
  0x090f,
  "edieresis",
  0x00eb,
  "edot",
  0x0117,
  "edotaccent",
  0x0117,
  "edotbelow",
  0x1eb9,
  "eegurmukhi",
  0x0a0f,
  "eematragurmukhi",
  0x0a47,
  "efcyrillic",
  0x0444,
  "egrave",
  0x00e8,
  "egujarati",
  0x0a8f,
  "eharmenian",
  0x0567,
  "ehbopomofo",
  0x311d,
  "ehiragana",
  0x3048,
  "ehookabove",
  0x1ebb,
  "eibopomofo",
  0x311f,
  "eight",
  0x0038,
  "eightarabic",
  0x0668,
  "eightbengali",
  0x09ee,
  "eightcircle",
  0x2467,
  "eightcircleinversesansserif",
  0x2791,
  "eightdeva",
  0x096e,
  "eighteencircle",
  0x2471,
  "eighteenparen",
  0x2485,
  "eighteenperiod",
  0x2499,
  "eightgujarati",
  0x0aee,
  "eightgurmukhi",
  0x0a6e,
  "eighthackarabic",
  0x0668,
  "eighthangzhou",
  0x3028,
  "eighthnotebeamed",
  0x266b,
  "eightideographicparen",
  0x3227,
  "eightinferior",
  0x2088,
  "eightmonospace",
  0xff18,
  "eightoldstyle",
  0xf738,
  "eightparen",
  0x247b,
  "eightperiod",
  0x248f,
  "eightpersian",
  0x06f8,
  "eightroman",
  0x2177,
  "eightsuperior",
  0x2078,
  "eightthai",
  0x0e58,
  "einvertedbreve",
  0x0207,
  "eiotifiedcyrillic",
  0x0465,
  "ekatakana",
  0x30a8,
  "ekatakanahalfwidth",
  0xff74,
  "ekonkargurmukhi",
  0x0a74,
  "ekorean",
  0x3154,
  "elcyrillic",
  0x043b,
  "element",
  0x2208,
  "elevencircle",
  0x246a,
  "elevenparen",
  0x247e,
  "elevenperiod",
  0x2492,
  "elevenroman",
  0x217a,
  "ellipsis",
  0x2026,
  "ellipsisvertical",
  0x22ee,
  "emacron",
  0x0113,
  "emacronacute",
  0x1e17,
  "emacrongrave",
  0x1e15,
  "emcyrillic",
  0x043c,
  "emdash",
  0x2014,
  "emdashvertical",
  0xfe31,
  "emonospace",
  0xff45,
  "emphasismarkarmenian",
  0x055b,
  "emptyset",
  0x2205,
  "enbopomofo",
  0x3123,
  "encyrillic",
  0x043d,
  "endash",
  0x2013,
  "endashvertical",
  0xfe32,
  "endescendercyrillic",
  0x04a3,
  "eng",
  0x014b,
  "engbopomofo",
  0x3125,
  "enghecyrillic",
  0x04a5,
  "enhookcyrillic",
  0x04c8,
  "enspace",
  0x2002,
  "eogonek",
  0x0119,
  "eokorean",
  0x3153,
  "eopen",
  0x025b,
  "eopenclosed",
  0x029a,
  "eopenreversed",
  0x025c,
  "eopenreversedclosed",
  0x025e,
  "eopenreversedhook",
  0x025d,
  "eparen",
  0x24a0,
  "epsilon",
  0x03b5,
  "epsilontonos",
  0x03ad,
  "equal",
  0x003d,
  "equalmonospace",
  0xff1d,
  "equalsmall",
  0xfe66,
  "equalsuperior",
  0x207c,
  "equivalence",
  0x2261,
  "erbopomofo",
  0x3126,
  "ercyrillic",
  0x0440,
  "ereversed",
  0x0258,
  "ereversedcyrillic",
  0x044d,
  "escyrillic",
  0x0441,
  "esdescendercyrillic",
  0x04ab,
  "esh",
  0x0283,
  "eshcurl",
  0x0286,
  "eshortdeva",
  0x090e,
  "eshortvowelsigndeva",
  0x0946,
  "eshreversedloop",
  0x01aa,
  "eshsquatreversed",
  0x0285,
  "esmallhiragana",
  0x3047,
  "esmallkatakana",
  0x30a7,
  "esmallkatakanahalfwidth",
  0xff6a,
  "estimated",
  0x212e,
  "esuperior",
  0xf6ec,
  "eta",
  0x03b7,
  "etarmenian",
  0x0568,
  "etatonos",
  0x03ae,
  "eth",
  0x00f0,
  "etilde",
  0x1ebd,
  "etildebelow",
  0x1e1b,
  "etnahtafoukhhebrew",
  0x0591,
  "etnahtafoukhlefthebrew",
  0x0591,
  "etnahtahebrew",
  0x0591,
  "etnahtalefthebrew",
  0x0591,
  "eturned",
  0x01dd,
  "eukorean",
  0x3161,
  "euro",
  0x20ac,
  "evowelsignbengali",
  0x09c7,
  "evowelsigndeva",
  0x0947,
  "evowelsigngujarati",
  0x0ac7,
  "exclam",
  0x0021,
  "exclamarmenian",
  0x055c,
  "exclamdbl",
  0x203c,
  "exclamdown",
  0x00a1,
  "exclamdownsmall",
  0xf7a1,
  "exclammonospace",
  0xff01,
  "exclamsmall",
  0xf721,
  "existential",
  0x2203,
  "ezh",
  0x0292,
  "ezhcaron",
  0x01ef,
  "ezhcurl",
  0x0293,
  "ezhreversed",
  0x01b9,
  "ezhtail",
  0x01ba,
  "f",
  0x0066,
  "fadeva",
  0x095e,
  "fagurmukhi",
  0x0a5e,
  "fahrenheit",
  0x2109,
  "fathaarabic",
  0x064e,
  "fathalowarabic",
  0x064e,
  "fathatanarabic",
  0x064b,
  "fbopomofo",
  0x3108,
  "fcircle",
  0x24d5,
  "fdotaccent",
  0x1e1f,
  "feharabic",
  0x0641,
  "feharmenian",
  0x0586,
  "fehfinalarabic",
  0xfed2,
  "fehinitialarabic",
  0xfed3,
  "fehmedialarabic",
  0xfed4,
  "feicoptic",
  0x03e5,
  "female",
  0x2640,
  "ff",
  0xfb00,
  "f_f",
  0xfb00,
  "ffi",
  0xfb03,
  "ffl",
  0xfb04,
  "fi",
  0xfb01,
  "fifteencircle",
  0x246e,
  "fifteenparen",
  0x2482,
  "fifteenperiod",
  0x2496,
  "figuredash",
  0x2012,
  "filledbox",
  0x25a0,
  "filledrect",
  0x25ac,
  "finalkaf",
  0x05da,
  "finalkafdagesh",
  0xfb3a,
  "finalkafdageshhebrew",
  0xfb3a,
  "finalkafhebrew",
  0x05da,
  "finalmem",
  0x05dd,
  "finalmemhebrew",
  0x05dd,
  "finalnun",
  0x05df,
  "finalnunhebrew",
  0x05df,
  "finalpe",
  0x05e3,
  "finalpehebrew",
  0x05e3,
  "finaltsadi",
  0x05e5,
  "finaltsadihebrew",
  0x05e5,
  "firsttonechinese",
  0x02c9,
  "fisheye",
  0x25c9,
  "fitacyrillic",
  0x0473,
  "five",
  0x0035,
  "fivearabic",
  0x0665,
  "fivebengali",
  0x09eb,
  "fivecircle",
  0x2464,
  "fivecircleinversesansserif",
  0x278e,
  "fivedeva",
  0x096b,
  "fiveeighths",
  0x215d,
  "fivegujarati",
  0x0aeb,
  "fivegurmukhi",
  0x0a6b,
  "fivehackarabic",
  0x0665,
  "fivehangzhou",
  0x3025,
  "fiveideographicparen",
  0x3224,
  "fiveinferior",
  0x2085,
  "fivemonospace",
  0xff15,
  "fiveoldstyle",
  0xf735,
  "fiveparen",
  0x2478,
  "fiveperiod",
  0x248c,
  "fivepersian",
  0x06f5,
  "fiveroman",
  0x2174,
  "fivesuperior",
  0x2075,
  "fivethai",
  0x0e55,
  "fl",
  0xfb02,
  "florin",
  0x0192,
  "fmonospace",
  0xff46,
  "fmsquare",
  0x3399,
  "fofanthai",
  0x0e1f,
  "fofathai",
  0x0e1d,
  "fongmanthai",
  0x0e4f,
  "forall",
  0x2200,
  "four",
  0x0034,
  "fourarabic",
  0x0664,
  "fourbengali",
  0x09ea,
  "fourcircle",
  0x2463,
  "fourcircleinversesansserif",
  0x278d,
  "fourdeva",
  0x096a,
  "fourgujarati",
  0x0aea,
  "fourgurmukhi",
  0x0a6a,
  "fourhackarabic",
  0x0664,
  "fourhangzhou",
  0x3024,
  "fourideographicparen",
  0x3223,
  "fourinferior",
  0x2084,
  "fourmonospace",
  0xff14,
  "fournumeratorbengali",
  0x09f7,
  "fouroldstyle",
  0xf734,
  "fourparen",
  0x2477,
  "fourperiod",
  0x248b,
  "fourpersian",
  0x06f4,
  "fourroman",
  0x2173,
  "foursuperior",
  0x2074,
  "fourteencircle",
  0x246d,
  "fourteenparen",
  0x2481,
  "fourteenperiod",
  0x2495,
  "fourthai",
  0x0e54,
  "fourthtonechinese",
  0x02cb,
  "fparen",
  0x24a1,
  "fraction",
  0x2044,
  "franc",
  0x20a3,
  "g",
  0x0067,
  "gabengali",
  0x0997,
  "gacute",
  0x01f5,
  "gadeva",
  0x0917,
  "gafarabic",
  0x06af,
  "gaffinalarabic",
  0xfb93,
  "gafinitialarabic",
  0xfb94,
  "gafmedialarabic",
  0xfb95,
  "gagujarati",
  0x0a97,
  "gagurmukhi",
  0x0a17,
  "gahiragana",
  0x304c,
  "gakatakana",
  0x30ac,
  "gamma",
  0x03b3,
  "gammalatinsmall",
  0x0263,
  "gammasuperior",
  0x02e0,
  "gangiacoptic",
  0x03eb,
  "gbopomofo",
  0x310d,
  "gbreve",
  0x011f,
  "gcaron",
  0x01e7,
  "gcedilla",
  0x0123,
  "gcircle",
  0x24d6,
  "gcircumflex",
  0x011d,
  "gcommaaccent",
  0x0123,
  "gdot",
  0x0121,
  "gdotaccent",
  0x0121,
  "gecyrillic",
  0x0433,
  "gehiragana",
  0x3052,
  "gekatakana",
  0x30b2,
  "geometricallyequal",
  0x2251,
  "gereshaccenthebrew",
  0x059c,
  "gereshhebrew",
  0x05f3,
  "gereshmuqdamhebrew",
  0x059d,
  "germandbls",
  0x00df,
  "gershayimaccenthebrew",
  0x059e,
  "gershayimhebrew",
  0x05f4,
  "getamark",
  0x3013,
  "ghabengali",
  0x0998,
  "ghadarmenian",
  0x0572,
  "ghadeva",
  0x0918,
  "ghagujarati",
  0x0a98,
  "ghagurmukhi",
  0x0a18,
  "ghainarabic",
  0x063a,
  "ghainfinalarabic",
  0xfece,
  "ghaininitialarabic",
  0xfecf,
  "ghainmedialarabic",
  0xfed0,
  "ghemiddlehookcyrillic",
  0x0495,
  "ghestrokecyrillic",
  0x0493,
  "gheupturncyrillic",
  0x0491,
  "ghhadeva",
  0x095a,
  "ghhagurmukhi",
  0x0a5a,
  "ghook",
  0x0260,
  "ghzsquare",
  0x3393,
  "gihiragana",
  0x304e,
  "gikatakana",
  0x30ae,
  "gimarmenian",
  0x0563,
  "gimel",
  0x05d2,
  "gimeldagesh",
  0xfb32,
  "gimeldageshhebrew",
  0xfb32,
  "gimelhebrew",
  0x05d2,
  "gjecyrillic",
  0x0453,
  "glottalinvertedstroke",
  0x01be,
  "glottalstop",
  0x0294,
  "glottalstopinverted",
  0x0296,
  "glottalstopmod",
  0x02c0,
  "glottalstopreversed",
  0x0295,
  "glottalstopreversedmod",
  0x02c1,
  "glottalstopreversedsuperior",
  0x02e4,
  "glottalstopstroke",
  0x02a1,
  "glottalstopstrokereversed",
  0x02a2,
  "gmacron",
  0x1e21,
  "gmonospace",
  0xff47,
  "gohiragana",
  0x3054,
  "gokatakana",
  0x30b4,
  "gparen",
  0x24a2,
  "gpasquare",
  0x33ac,
  "gradient",
  0x2207,
  "grave",
  0x0060,
  "gravebelowcmb",
  0x0316,
  "gravecmb",
  0x0300,
  "gravecomb",
  0x0300,
  "gravedeva",
  0x0953,
  "gravelowmod",
  0x02ce,
  "gravemonospace",
  0xff40,
  "gravetonecmb",
  0x0340,
  "greater",
  0x003e,
  "greaterequal",
  0x2265,
  "greaterequalorless",
  0x22db,
  "greatermonospace",
  0xff1e,
  "greaterorequivalent",
  0x2273,
  "greaterorless",
  0x2277,
  "greateroverequal",
  0x2267,
  "greatersmall",
  0xfe65,
  "gscript",
  0x0261,
  "gstroke",
  0x01e5,
  "guhiragana",
  0x3050,
  "guillemotleft",
  0x00ab,
  "guillemotright",
  0x00bb,
  "guilsinglleft",
  0x2039,
  "guilsinglright",
  0x203a,
  "gukatakana",
  0x30b0,
  "guramusquare",
  0x3318,
  "gysquare",
  0x33c9,
  "h",
  0x0068,
  "haabkhasiancyrillic",
  0x04a9,
  "haaltonearabic",
  0x06c1,
  "habengali",
  0x09b9,
  "hadescendercyrillic",
  0x04b3,
  "hadeva",
  0x0939,
  "hagujarati",
  0x0ab9,
  "hagurmukhi",
  0x0a39,
  "haharabic",
  0x062d,
  "hahfinalarabic",
  0xfea2,
  "hahinitialarabic",
  0xfea3,
  "hahiragana",
  0x306f,
  "hahmedialarabic",
  0xfea4,
  "haitusquare",
  0x332a,
  "hakatakana",
  0x30cf,
  "hakatakanahalfwidth",
  0xff8a,
  "halantgurmukhi",
  0x0a4d,
  "hamzaarabic",
  0x0621,
  "hamzalowarabic",
  0x0621,
  "hangulfiller",
  0x3164,
  "hardsigncyrillic",
  0x044a,
  "harpoonleftbarbup",
  0x21bc,
  "harpoonrightbarbup",
  0x21c0,
  "hasquare",
  0x33ca,
  "hatafpatah",
  0x05b2,
  "hatafpatah16",
  0x05b2,
  "hatafpatah23",
  0x05b2,
  "hatafpatah2f",
  0x05b2,
  "hatafpatahhebrew",
  0x05b2,
  "hatafpatahnarrowhebrew",
  0x05b2,
  "hatafpatahquarterhebrew",
  0x05b2,
  "hatafpatahwidehebrew",
  0x05b2,
  "hatafqamats",
  0x05b3,
  "hatafqamats1b",
  0x05b3,
  "hatafqamats28",
  0x05b3,
  "hatafqamats34",
  0x05b3,
  "hatafqamatshebrew",
  0x05b3,
  "hatafqamatsnarrowhebrew",
  0x05b3,
  "hatafqamatsquarterhebrew",
  0x05b3,
  "hatafqamatswidehebrew",
  0x05b3,
  "hatafsegol",
  0x05b1,
  "hatafsegol17",
  0x05b1,
  "hatafsegol24",
  0x05b1,
  "hatafsegol30",
  0x05b1,
  "hatafsegolhebrew",
  0x05b1,
  "hatafsegolnarrowhebrew",
  0x05b1,
  "hatafsegolquarterhebrew",
  0x05b1,
  "hatafsegolwidehebrew",
  0x05b1,
  "hbar",
  0x0127,
  "hbopomofo",
  0x310f,
  "hbrevebelow",
  0x1e2b,
  "hcedilla",
  0x1e29,
  "hcircle",
  0x24d7,
  "hcircumflex",
  0x0125,
  "hdieresis",
  0x1e27,
  "hdotaccent",
  0x1e23,
  "hdotbelow",
  0x1e25,
  "he",
  0x05d4,
  "heart",
  0x2665,
  "heartsuitblack",
  0x2665,
  "heartsuitwhite",
  0x2661,
  "hedagesh",
  0xfb34,
  "hedageshhebrew",
  0xfb34,
  "hehaltonearabic",
  0x06c1,
  "heharabic",
  0x0647,
  "hehebrew",
  0x05d4,
  "hehfinalaltonearabic",
  0xfba7,
  "hehfinalalttwoarabic",
  0xfeea,
  "hehfinalarabic",
  0xfeea,
  "hehhamzaabovefinalarabic",
  0xfba5,
  "hehhamzaaboveisolatedarabic",
  0xfba4,
  "hehinitialaltonearabic",
  0xfba8,
  "hehinitialarabic",
  0xfeeb,
  "hehiragana",
  0x3078,
  "hehmedialaltonearabic",
  0xfba9,
  "hehmedialarabic",
  0xfeec,
  "heiseierasquare",
  0x337b,
  "hekatakana",
  0x30d8,
  "hekatakanahalfwidth",
  0xff8d,
  "hekutaarusquare",
  0x3336,
  "henghook",
  0x0267,
  "herutusquare",
  0x3339,
  "het",
  0x05d7,
  "hethebrew",
  0x05d7,
  "hhook",
  0x0266,
  "hhooksuperior",
  0x02b1,
  "hieuhacirclekorean",
  0x327b,
  "hieuhaparenkorean",
  0x321b,
  "hieuhcirclekorean",
  0x326d,
  "hieuhkorean",
  0x314e,
  "hieuhparenkorean",
  0x320d,
  "hihiragana",
  0x3072,
  "hikatakana",
  0x30d2,
  "hikatakanahalfwidth",
  0xff8b,
  "hiriq",
  0x05b4,
  "hiriq14",
  0x05b4,
  "hiriq21",
  0x05b4,
  "hiriq2d",
  0x05b4,
  "hiriqhebrew",
  0x05b4,
  "hiriqnarrowhebrew",
  0x05b4,
  "hiriqquarterhebrew",
  0x05b4,
  "hiriqwidehebrew",
  0x05b4,
  "hlinebelow",
  0x1e96,
  "hmonospace",
  0xff48,
  "hoarmenian",
  0x0570,
  "hohipthai",
  0x0e2b,
  "hohiragana",
  0x307b,
  "hokatakana",
  0x30db,
  "hokatakanahalfwidth",
  0xff8e,
  "holam",
  0x05b9,
  "holam19",
  0x05b9,
  "holam26",
  0x05b9,
  "holam32",
  0x05b9,
  "holamhebrew",
  0x05b9,
  "holamnarrowhebrew",
  0x05b9,
  "holamquarterhebrew",
  0x05b9,
  "holamwidehebrew",
  0x05b9,
  "honokhukthai",
  0x0e2e,
  "hookabovecomb",
  0x0309,
  "hookcmb",
  0x0309,
  "hookpalatalizedbelowcmb",
  0x0321,
  "hookretroflexbelowcmb",
  0x0322,
  "hoonsquare",
  0x3342,
  "horicoptic",
  0x03e9,
  "horizontalbar",
  0x2015,
  "horncmb",
  0x031b,
  "hotsprings",
  0x2668,
  "house",
  0x2302,
  "hparen",
  0x24a3,
  "hsuperior",
  0x02b0,
  "hturned",
  0x0265,
  "huhiragana",
  0x3075,
  "huiitosquare",
  0x3333,
  "hukatakana",
  0x30d5,
  "hukatakanahalfwidth",
  0xff8c,
  "hungarumlaut",
  0x02dd,
  "hungarumlautcmb",
  0x030b,
  "hv",
  0x0195,
  "hyphen",
  0x002d,
  "hypheninferior",
  0xf6e5,
  "hyphenmonospace",
  0xff0d,
  "hyphensmall",
  0xfe63,
  "hyphensuperior",
  0xf6e6,
  "hyphentwo",
  0x2010,
  "i",
  0x0069,
  "iacute",
  0x00ed,
  "iacyrillic",
  0x044f,
  "ibengali",
  0x0987,
  "ibopomofo",
  0x3127,
  "ibreve",
  0x012d,
  "icaron",
  0x01d0,
  "icircle",
  0x24d8,
  "icircumflex",
  0x00ee,
  "icyrillic",
  0x0456,
  "idblgrave",
  0x0209,
  "ideographearthcircle",
  0x328f,
  "ideographfirecircle",
  0x328b,
  "ideographicallianceparen",
  0x323f,
  "ideographiccallparen",
  0x323a,
  "ideographiccentrecircle",
  0x32a5,
  "ideographicclose",
  0x3006,
  "ideographiccomma",
  0x3001,
  "ideographiccommaleft",
  0xff64,
  "ideographiccongratulationparen",
  0x3237,
  "ideographiccorrectcircle",
  0x32a3,
  "ideographicearthparen",
  0x322f,
  "ideographicenterpriseparen",
  0x323d,
  "ideographicexcellentcircle",
  0x329d,
  "ideographicfestivalparen",
  0x3240,
  "ideographicfinancialcircle",
  0x3296,
  "ideographicfinancialparen",
  0x3236,
  "ideographicfireparen",
  0x322b,
  "ideographichaveparen",
  0x3232,
  "ideographichighcircle",
  0x32a4,
  "ideographiciterationmark",
  0x3005,
  "ideographiclaborcircle",
  0x3298,
  "ideographiclaborparen",
  0x3238,
  "ideographicleftcircle",
  0x32a7,
  "ideographiclowcircle",
  0x32a6,
  "ideographicmedicinecircle",
  0x32a9,
  "ideographicmetalparen",
  0x322e,
  "ideographicmoonparen",
  0x322a,
  "ideographicnameparen",
  0x3234,
  "ideographicperiod",
  0x3002,
  "ideographicprintcircle",
  0x329e,
  "ideographicreachparen",
  0x3243,
  "ideographicrepresentparen",
  0x3239,
  "ideographicresourceparen",
  0x323e,
  "ideographicrightcircle",
  0x32a8,
  "ideographicsecretcircle",
  0x3299,
  "ideographicselfparen",
  0x3242,
  "ideographicsocietyparen",
  0x3233,
  "ideographicspace",
  0x3000,
  "ideographicspecialparen",
  0x3235,
  "ideographicstockparen",
  0x3231,
  "ideographicstudyparen",
  0x323b,
  "ideographicsunparen",
  0x3230,
  "ideographicsuperviseparen",
  0x323c,
  "ideographicwaterparen",
  0x322c,
  "ideographicwoodparen",
  0x322d,
  "ideographiczero",
  0x3007,
  "ideographmetalcircle",
  0x328e,
  "ideographmooncircle",
  0x328a,
  "ideographnamecircle",
  0x3294,
  "ideographsuncircle",
  0x3290,
  "ideographwatercircle",
  0x328c,
  "ideographwoodcircle",
  0x328d,
  "ideva",
  0x0907,
  "idieresis",
  0x00ef,
  "idieresisacute",
  0x1e2f,
  "idieresiscyrillic",
  0x04e5,
  "idotbelow",
  0x1ecb,
  "iebrevecyrillic",
  0x04d7,
  "iecyrillic",
  0x0435,
  "ieungacirclekorean",
  0x3275,
  "ieungaparenkorean",
  0x3215,
  "ieungcirclekorean",
  0x3267,
  "ieungkorean",
  0x3147,
  "ieungparenkorean",
  0x3207,
  "igrave",
  0x00ec,
  "igujarati",
  0x0a87,
  "igurmukhi",
  0x0a07,
  "ihiragana",
  0x3044,
  "ihookabove",
  0x1ec9,
  "iibengali",
  0x0988,
  "iicyrillic",
  0x0438,
  "iideva",
  0x0908,
  "iigujarati",
  0x0a88,
  "iigurmukhi",
  0x0a08,
  "iimatragurmukhi",
  0x0a40,
  "iinvertedbreve",
  0x020b,
  "iishortcyrillic",
  0x0439,
  "iivowelsignbengali",
  0x09c0,
  "iivowelsigndeva",
  0x0940,
  "iivowelsigngujarati",
  0x0ac0,
  "ij",
  0x0133,
  "ikatakana",
  0x30a4,
  "ikatakanahalfwidth",
  0xff72,
  "ikorean",
  0x3163,
  "ilde",
  0x02dc,
  "iluyhebrew",
  0x05ac,
  "imacron",
  0x012b,
  "imacroncyrillic",
  0x04e3,
  "imageorapproximatelyequal",
  0x2253,
  "imatragurmukhi",
  0x0a3f,
  "imonospace",
  0xff49,
  "increment",
  0x2206,
  "infinity",
  0x221e,
  "iniarmenian",
  0x056b,
  "integral",
  0x222b,
  "integralbottom",
  0x2321,
  "integralbt",
  0x2321,
  "integralex",
  0xf8f5,
  "integraltop",
  0x2320,
  "integraltp",
  0x2320,
  "intersection",
  0x2229,
  "intisquare",
  0x3305,
  "invbullet",
  0x25d8,
  "invcircle",
  0x25d9,
  "invsmileface",
  0x263b,
  "iocyrillic",
  0x0451,
  "iogonek",
  0x012f,
  "iota",
  0x03b9,
  "iotadieresis",
  0x03ca,
  "iotadieresistonos",
  0x0390,
  "iotalatin",
  0x0269,
  "iotatonos",
  0x03af,
  "iparen",
  0x24a4,
  "irigurmukhi",
  0x0a72,
  "ismallhiragana",
  0x3043,
  "ismallkatakana",
  0x30a3,
  "ismallkatakanahalfwidth",
  0xff68,
  "issharbengali",
  0x09fa,
  "istroke",
  0x0268,
  "isuperior",
  0xf6ed,
  "iterationhiragana",
  0x309d,
  "iterationkatakana",
  0x30fd,
  "itilde",
  0x0129,
  "itildebelow",
  0x1e2d,
  "iubopomofo",
  0x3129,
  "iucyrillic",
  0x044e,
  "ivowelsignbengali",
  0x09bf,
  "ivowelsigndeva",
  0x093f,
  "ivowelsigngujarati",
  0x0abf,
  "izhitsacyrillic",
  0x0475,
  "izhitsadblgravecyrillic",
  0x0477,
  "j",
  0x006a,
  "jaarmenian",
  0x0571,
  "jabengali",
  0x099c,
  "jadeva",
  0x091c,
  "jagujarati",
  0x0a9c,
  "jagurmukhi",
  0x0a1c,
  "jbopomofo",
  0x3110,
  "jcaron",
  0x01f0,
  "jcircle",
  0x24d9,
  "jcircumflex",
  0x0135,
  "jcrossedtail",
  0x029d,
  "jdotlessstroke",
  0x025f,
  "jecyrillic",
  0x0458,
  "jeemarabic",
  0x062c,
  "jeemfinalarabic",
  0xfe9e,
  "jeeminitialarabic",
  0xfe9f,
  "jeemmedialarabic",
  0xfea0,
  "jeharabic",
  0x0698,
  "jehfinalarabic",
  0xfb8b,
  "jhabengali",
  0x099d,
  "jhadeva",
  0x091d,
  "jhagujarati",
  0x0a9d,
  "jhagurmukhi",
  0x0a1d,
  "jheharmenian",
  0x057b,
  "jis",
  0x3004,
  "jmonospace",
  0xff4a,
  "jparen",
  0x24a5,
  "jsuperior",
  0x02b2,
  "k",
  0x006b,
  "kabashkircyrillic",
  0x04a1,
  "kabengali",
  0x0995,
  "kacute",
  0x1e31,
  "kacyrillic",
  0x043a,
  "kadescendercyrillic",
  0x049b,
  "kadeva",
  0x0915,
  "kaf",
  0x05db,
  "kafarabic",
  0x0643,
  "kafdagesh",
  0xfb3b,
  "kafdageshhebrew",
  0xfb3b,
  "kaffinalarabic",
  0xfeda,
  "kafhebrew",
  0x05db,
  "kafinitialarabic",
  0xfedb,
  "kafmedialarabic",
  0xfedc,
  "kafrafehebrew",
  0xfb4d,
  "kagujarati",
  0x0a95,
  "kagurmukhi",
  0x0a15,
  "kahiragana",
  0x304b,
  "kahookcyrillic",
  0x04c4,
  "kakatakana",
  0x30ab,
  "kakatakanahalfwidth",
  0xff76,
  "kappa",
  0x03ba,
  "kappasymbolgreek",
  0x03f0,
  "kapyeounmieumkorean",
  0x3171,
  "kapyeounphieuphkorean",
  0x3184,
  "kapyeounpieupkorean",
  0x3178,
  "kapyeounssangpieupkorean",
  0x3179,
  "karoriisquare",
  0x330d,
  "kashidaautoarabic",
  0x0640,
  "kashidaautonosidebearingarabic",
  0x0640,
  "kasmallkatakana",
  0x30f5,
  "kasquare",
  0x3384,
  "kasraarabic",
  0x0650,
  "kasratanarabic",
  0x064d,
  "kastrokecyrillic",
  0x049f,
  "katahiraprolongmarkhalfwidth",
  0xff70,
  "kaverticalstrokecyrillic",
  0x049d,
  "kbopomofo",
  0x310e,
  "kcalsquare",
  0x3389,
  "kcaron",
  0x01e9,
  "kcedilla",
  0x0137,
  "kcircle",
  0x24da,
  "kcommaaccent",
  0x0137,
  "kdotbelow",
  0x1e33,
  "keharmenian",
  0x0584,
  "kehiragana",
  0x3051,
  "kekatakana",
  0x30b1,
  "kekatakanahalfwidth",
  0xff79,
  "kenarmenian",
  0x056f,
  "kesmallkatakana",
  0x30f6,
  "kgreenlandic",
  0x0138,
  "khabengali",
  0x0996,
  "khacyrillic",
  0x0445,
  "khadeva",
  0x0916,
  "khagujarati",
  0x0a96,
  "khagurmukhi",
  0x0a16,
  "khaharabic",
  0x062e,
  "khahfinalarabic",
  0xfea6,
  "khahinitialarabic",
  0xfea7,
  "khahmedialarabic",
  0xfea8,
  "kheicoptic",
  0x03e7,
  "khhadeva",
  0x0959,
  "khhagurmukhi",
  0x0a59,
  "khieukhacirclekorean",
  0x3278,
  "khieukhaparenkorean",
  0x3218,
  "khieukhcirclekorean",
  0x326a,
  "khieukhkorean",
  0x314b,
  "khieukhparenkorean",
  0x320a,
  "khokhaithai",
  0x0e02,
  "khokhonthai",
  0x0e05,
  "khokhuatthai",
  0x0e03,
  "khokhwaithai",
  0x0e04,
  "khomutthai",
  0x0e5b,
  "khook",
  0x0199,
  "khorakhangthai",
  0x0e06,
  "khzsquare",
  0x3391,
  "kihiragana",
  0x304d,
  "kikatakana",
  0x30ad,
  "kikatakanahalfwidth",
  0xff77,
  "kiroguramusquare",
  0x3315,
  "kiromeetorusquare",
  0x3316,
  "kirosquare",
  0x3314,
  "kiyeokacirclekorean",
  0x326e,
  "kiyeokaparenkorean",
  0x320e,
  "kiyeokcirclekorean",
  0x3260,
  "kiyeokkorean",
  0x3131,
  "kiyeokparenkorean",
  0x3200,
  "kiyeoksioskorean",
  0x3133,
  "kjecyrillic",
  0x045c,
  "klinebelow",
  0x1e35,
  "klsquare",
  0x3398,
  "kmcubedsquare",
  0x33a6,
  "kmonospace",
  0xff4b,
  "kmsquaredsquare",
  0x33a2,
  "kohiragana",
  0x3053,
  "kohmsquare",
  0x33c0,
  "kokaithai",
  0x0e01,
  "kokatakana",
  0x30b3,
  "kokatakanahalfwidth",
  0xff7a,
  "kooposquare",
  0x331e,
  "koppacyrillic",
  0x0481,
  "koreanstandardsymbol",
  0x327f,
  "koroniscmb",
  0x0343,
  "kparen",
  0x24a6,
  "kpasquare",
  0x33aa,
  "ksicyrillic",
  0x046f,
  "ktsquare",
  0x33cf,
  "kturned",
  0x029e,
  "kuhiragana",
  0x304f,
  "kukatakana",
  0x30af,
  "kukatakanahalfwidth",
  0xff78,
  "kvsquare",
  0x33b8,
  "kwsquare",
  0x33be,
  "l",
  0x006c,
  "labengali",
  0x09b2,
  "lacute",
  0x013a,
  "ladeva",
  0x0932,
  "lagujarati",
  0x0ab2,
  "lagurmukhi",
  0x0a32,
  "lakkhangyaothai",
  0x0e45,
  "lamaleffinalarabic",
  0xfefc,
  "lamalefhamzaabovefinalarabic",
  0xfef8,
  "lamalefhamzaaboveisolatedarabic",
  0xfef7,
  "lamalefhamzabelowfinalarabic",
  0xfefa,
  "lamalefhamzabelowisolatedarabic",
  0xfef9,
  "lamalefisolatedarabic",
  0xfefb,
  "lamalefmaddaabovefinalarabic",
  0xfef6,
  "lamalefmaddaaboveisolatedarabic",
  0xfef5,
  "lamarabic",
  0x0644,
  "lambda",
  0x03bb,
  "lambdastroke",
  0x019b,
  "lamed",
  0x05dc,
  "lameddagesh",
  0xfb3c,
  "lameddageshhebrew",
  0xfb3c,
  "lamedhebrew",
  0x05dc,
  "lamfinalarabic",
  0xfede,
  "lamhahinitialarabic",
  0xfcca,
  "laminitialarabic",
  0xfedf,
  "lamjeeminitialarabic",
  0xfcc9,
  "lamkhahinitialarabic",
  0xfccb,
  "lamlamhehisolatedarabic",
  0xfdf2,
  "lammedialarabic",
  0xfee0,
  "lammeemhahinitialarabic",
  0xfd88,
  "lammeeminitialarabic",
  0xfccc,
  "largecircle",
  0x25ef,
  "lbar",
  0x019a,
  "lbelt",
  0x026c,
  "lbopomofo",
  0x310c,
  "lcaron",
  0x013e,
  "lcedilla",
  0x013c,
  "lcircle",
  0x24db,
  "lcircumflexbelow",
  0x1e3d,
  "lcommaaccent",
  0x013c,
  "ldot",
  0x0140,
  "ldotaccent",
  0x0140,
  "ldotbelow",
  0x1e37,
  "ldotbelowmacron",
  0x1e39,
  "leftangleabovecmb",
  0x031a,
  "lefttackbelowcmb",
  0x0318,
  "less",
  0x003c,
  "lessequal",
  0x2264,
  "lessequalorgreater",
  0x22da,
  "lessmonospace",
  0xff1c,
  "lessorequivalent",
  0x2272,
  "lessorgreater",
  0x2276,
  "lessoverequal",
  0x2266,
  "lesssmall",
  0xfe64,
  "lezh",
  0x026e,
  "lfblock",
  0x258c,
  "lhookretroflex",
  0x026d,
  "lira",
  0x20a4,
  "liwnarmenian",
  0x056c,
  "lj",
  0x01c9,
  "ljecyrillic",
  0x0459,
  "ll",
  0xf6c0,
  "lladeva",
  0x0933,
  "llagujarati",
  0x0ab3,
  "llinebelow",
  0x1e3b,
  "llladeva",
  0x0934,
  "llvocalicbengali",
  0x09e1,
  "llvocalicdeva",
  0x0961,
  "llvocalicvowelsignbengali",
  0x09e3,
  "llvocalicvowelsigndeva",
  0x0963,
  "lmiddletilde",
  0x026b,
  "lmonospace",
  0xff4c,
  "lmsquare",
  0x33d0,
  "lochulathai",
  0x0e2c,
  "logicaland",
  0x2227,
  "logicalnot",
  0x00ac,
  "logicalnotreversed",
  0x2310,
  "logicalor",
  0x2228,
  "lolingthai",
  0x0e25,
  "longs",
  0x017f,
  "lowlinecenterline",
  0xfe4e,
  "lowlinecmb",
  0x0332,
  "lowlinedashed",
  0xfe4d,
  "lozenge",
  0x25ca,
  "lparen",
  0x24a7,
  "lslash",
  0x0142,
  "lsquare",
  0x2113,
  "lsuperior",
  0xf6ee,
  "ltshade",
  0x2591,
  "luthai",
  0x0e26,
  "lvocalicbengali",
  0x098c,
  "lvocalicdeva",
  0x090c,
  "lvocalicvowelsignbengali",
  0x09e2,
  "lvocalicvowelsigndeva",
  0x0962,
  "lxsquare",
  0x33d3,
  "m",
  0x006d,
  "mabengali",
  0x09ae,
  "macron",
  0x00af,
  "macronbelowcmb",
  0x0331,
  "macroncmb",
  0x0304,
  "macronlowmod",
  0x02cd,
  "macronmonospace",
  0xffe3,
  "macute",
  0x1e3f,
  "madeva",
  0x092e,
  "magujarati",
  0x0aae,
  "magurmukhi",
  0x0a2e,
  "mahapakhhebrew",
  0x05a4,
  "mahapakhlefthebrew",
  0x05a4,
  "mahiragana",
  0x307e,
  "maichattawalowleftthai",
  0xf895,
  "maichattawalowrightthai",
  0xf894,
  "maichattawathai",
  0x0e4b,
  "maichattawaupperleftthai",
  0xf893,
  "maieklowleftthai",
  0xf88c,
  "maieklowrightthai",
  0xf88b,
  "maiekthai",
  0x0e48,
  "maiekupperleftthai",
  0xf88a,
  "maihanakatleftthai",
  0xf884,
  "maihanakatthai",
  0x0e31,
  "maitaikhuleftthai",
  0xf889,
  "maitaikhuthai",
  0x0e47,
  "maitholowleftthai",
  0xf88f,
  "maitholowrightthai",
  0xf88e,
  "maithothai",
  0x0e49,
  "maithoupperleftthai",
  0xf88d,
  "maitrilowleftthai",
  0xf892,
  "maitrilowrightthai",
  0xf891,
  "maitrithai",
  0x0e4a,
  "maitriupperleftthai",
  0xf890,
  "maiyamokthai",
  0x0e46,
  "makatakana",
  0x30de,
  "makatakanahalfwidth",
  0xff8f,
  "male",
  0x2642,
  "mansyonsquare",
  0x3347,
  "maqafhebrew",
  0x05be,
  "mars",
  0x2642,
  "masoracirclehebrew",
  0x05af,
  "masquare",
  0x3383,
  "mbopomofo",
  0x3107,
  "mbsquare",
  0x33d4,
  "mcircle",
  0x24dc,
  "mcubedsquare",
  0x33a5,
  "mdotaccent",
  0x1e41,
  "mdotbelow",
  0x1e43,
  "meemarabic",
  0x0645,
  "meemfinalarabic",
  0xfee2,
  "meeminitialarabic",
  0xfee3,
  "meemmedialarabic",
  0xfee4,
  "meemmeeminitialarabic",
  0xfcd1,
  "meemmeemisolatedarabic",
  0xfc48,
  "meetorusquare",
  0x334d,
  "mehiragana",
  0x3081,
  "meizierasquare",
  0x337e,
  "mekatakana",
  0x30e1,
  "mekatakanahalfwidth",
  0xff92,
  "mem",
  0x05de,
  "memdagesh",
  0xfb3e,
  "memdageshhebrew",
  0xfb3e,
  "memhebrew",
  0x05de,
  "menarmenian",
  0x0574,
  "merkhahebrew",
  0x05a5,
  "merkhakefulahebrew",
  0x05a6,
  "merkhakefulalefthebrew",
  0x05a6,
  "merkhalefthebrew",
  0x05a5,
  "mhook",
  0x0271,
  "mhzsquare",
  0x3392,
  "middledotkatakanahalfwidth",
  0xff65,
  "middot",
  0x00b7,
  "mieumacirclekorean",
  0x3272,
  "mieumaparenkorean",
  0x3212,
  "mieumcirclekorean",
  0x3264,
  "mieumkorean",
  0x3141,
  "mieumpansioskorean",
  0x3170,
  "mieumparenkorean",
  0x3204,
  "mieumpieupkorean",
  0x316e,
  "mieumsioskorean",
  0x316f,
  "mihiragana",
  0x307f,
  "mikatakana",
  0x30df,
  "mikatakanahalfwidth",
  0xff90,
  "minus",
  0x2212,
  "minusbelowcmb",
  0x0320,
  "minuscircle",
  0x2296,
  "minusmod",
  0x02d7,
  "minusplus",
  0x2213,
  "minute",
  0x2032,
  "miribaarusquare",
  0x334a,
  "mirisquare",
  0x3349,
  "mlonglegturned",
  0x0270,
  "mlsquare",
  0x3396,
  "mmcubedsquare",
  0x33a3,
  "mmonospace",
  0xff4d,
  "mmsquaredsquare",
  0x339f,
  "mohiragana",
  0x3082,
  "mohmsquare",
  0x33c1,
  "mokatakana",
  0x30e2,
  "mokatakanahalfwidth",
  0xff93,
  "molsquare",
  0x33d6,
  "momathai",
  0x0e21,
  "moverssquare",
  0x33a7,
  "moverssquaredsquare",
  0x33a8,
  "mparen",
  0x24a8,
  "mpasquare",
  0x33ab,
  "mssquare",
  0x33b3,
  "msuperior",
  0xf6ef,
  "mturned",
  0x026f,
  "mu",
  0x00b5,
  "mu1",
  0x00b5,
  "muasquare",
  0x3382,
  "muchgreater",
  0x226b,
  "muchless",
  0x226a,
  "mufsquare",
  0x338c,
  "mugreek",
  0x03bc,
  "mugsquare",
  0x338d,
  "muhiragana",
  0x3080,
  "mukatakana",
  0x30e0,
  "mukatakanahalfwidth",
  0xff91,
  "mulsquare",
  0x3395,
  "multiply",
  0x00d7,
  "mumsquare",
  0x339b,
  "munahhebrew",
  0x05a3,
  "munahlefthebrew",
  0x05a3,
  "musicalnote",
  0x266a,
  "musicalnotedbl",
  0x266b,
  "musicflatsign",
  0x266d,
  "musicsharpsign",
  0x266f,
  "mussquare",
  0x33b2,
  "muvsquare",
  0x33b6,
  "muwsquare",
  0x33bc,
  "mvmegasquare",
  0x33b9,
  "mvsquare",
  0x33b7,
  "mwmegasquare",
  0x33bf,
  "mwsquare",
  0x33bd,
  "n",
  0x006e,
  "nabengali",
  0x09a8,
  "nabla",
  0x2207,
  "nacute",
  0x0144,
  "nadeva",
  0x0928,
  "nagujarati",
  0x0aa8,
  "nagurmukhi",
  0x0a28,
  "nahiragana",
  0x306a,
  "nakatakana",
  0x30ca,
  "nakatakanahalfwidth",
  0xff85,
  "napostrophe",
  0x0149,
  "nasquare",
  0x3381,
  "nbopomofo",
  0x310b,
  "nbspace",
  0x00a0,
  "ncaron",
  0x0148,
  "ncedilla",
  0x0146,
  "ncircle",
  0x24dd,
  "ncircumflexbelow",
  0x1e4b,
  "ncommaaccent",
  0x0146,
  "ndotaccent",
  0x1e45,
  "ndotbelow",
  0x1e47,
  "nehiragana",
  0x306d,
  "nekatakana",
  0x30cd,
  "nekatakanahalfwidth",
  0xff88,
  "newsheqelsign",
  0x20aa,
  "nfsquare",
  0x338b,
  "ngabengali",
  0x0999,
  "ngadeva",
  0x0919,
  "ngagujarati",
  0x0a99,
  "ngagurmukhi",
  0x0a19,
  "ngonguthai",
  0x0e07,
  "nhiragana",
  0x3093,
  "nhookleft",
  0x0272,
  "nhookretroflex",
  0x0273,
  "nieunacirclekorean",
  0x326f,
  "nieunaparenkorean",
  0x320f,
  "nieuncieuckorean",
  0x3135,
  "nieuncirclekorean",
  0x3261,
  "nieunhieuhkorean",
  0x3136,
  "nieunkorean",
  0x3134,
  "nieunpansioskorean",
  0x3168,
  "nieunparenkorean",
  0x3201,
  "nieunsioskorean",
  0x3167,
  "nieuntikeutkorean",
  0x3166,
  "nihiragana",
  0x306b,
  "nikatakana",
  0x30cb,
  "nikatakanahalfwidth",
  0xff86,
  "nikhahitleftthai",
  0xf899,
  "nikhahitthai",
  0x0e4d,
  "nine",
  0x0039,
  "ninearabic",
  0x0669,
  "ninebengali",
  0x09ef,
  "ninecircle",
  0x2468,
  "ninecircleinversesansserif",
  0x2792,
  "ninedeva",
  0x096f,
  "ninegujarati",
  0x0aef,
  "ninegurmukhi",
  0x0a6f,
  "ninehackarabic",
  0x0669,
  "ninehangzhou",
  0x3029,
  "nineideographicparen",
  0x3228,
  "nineinferior",
  0x2089,
  "ninemonospace",
  0xff19,
  "nineoldstyle",
  0xf739,
  "nineparen",
  0x247c,
  "nineperiod",
  0x2490,
  "ninepersian",
  0x06f9,
  "nineroman",
  0x2178,
  "ninesuperior",
  0x2079,
  "nineteencircle",
  0x2472,
  "nineteenparen",
  0x2486,
  "nineteenperiod",
  0x249a,
  "ninethai",
  0x0e59,
  "nj",
  0x01cc,
  "njecyrillic",
  0x045a,
  "nkatakana",
  0x30f3,
  "nkatakanahalfwidth",
  0xff9d,
  "nlegrightlong",
  0x019e,
  "nlinebelow",
  0x1e49,
  "nmonospace",
  0xff4e,
  "nmsquare",
  0x339a,
  "nnabengali",
  0x09a3,
  "nnadeva",
  0x0923,
  "nnagujarati",
  0x0aa3,
  "nnagurmukhi",
  0x0a23,
  "nnnadeva",
  0x0929,
  "nohiragana",
  0x306e,
  "nokatakana",
  0x30ce,
  "nokatakanahalfwidth",
  0xff89,
  "nonbreakingspace",
  0x00a0,
  "nonenthai",
  0x0e13,
  "nonuthai",
  0x0e19,
  "noonarabic",
  0x0646,
  "noonfinalarabic",
  0xfee6,
  "noonghunnaarabic",
  0x06ba,
  "noonghunnafinalarabic",
  0xfb9f,
  "nooninitialarabic",
  0xfee7,
  "noonjeeminitialarabic",
  0xfcd2,
  "noonjeemisolatedarabic",
  0xfc4b,
  "noonmedialarabic",
  0xfee8,
  "noonmeeminitialarabic",
  0xfcd5,
  "noonmeemisolatedarabic",
  0xfc4e,
  "noonnoonfinalarabic",
  0xfc8d,
  "notcontains",
  0x220c,
  "notelement",
  0x2209,
  "notelementof",
  0x2209,
  "notequal",
  0x2260,
  "notgreater",
  0x226f,
  "notgreaternorequal",
  0x2271,
  "notgreaternorless",
  0x2279,
  "notidentical",
  0x2262,
  "notless",
  0x226e,
  "notlessnorequal",
  0x2270,
  "notparallel",
  0x2226,
  "notprecedes",
  0x2280,
  "notsubset",
  0x2284,
  "notsucceeds",
  0x2281,
  "notsuperset",
  0x2285,
  "nowarmenian",
  0x0576,
  "nparen",
  0x24a9,
  "nssquare",
  0x33b1,
  "nsuperior",
  0x207f,
  "ntilde",
  0x00f1,
  "nu",
  0x03bd,
  "nuhiragana",
  0x306c,
  "nukatakana",
  0x30cc,
  "nukatakanahalfwidth",
  0xff87,
  "nuktabengali",
  0x09bc,
  "nuktadeva",
  0x093c,
  "nuktagujarati",
  0x0abc,
  "nuktagurmukhi",
  0x0a3c,
  "numbersign",
  0x0023,
  "numbersignmonospace",
  0xff03,
  "numbersignsmall",
  0xfe5f,
  "numeralsigngreek",
  0x0374,
  "numeralsignlowergreek",
  0x0375,
  "numero",
  0x2116,
  "nun",
  0x05e0,
  "nundagesh",
  0xfb40,
  "nundageshhebrew",
  0xfb40,
  "nunhebrew",
  0x05e0,
  "nvsquare",
  0x33b5,
  "nwsquare",
  0x33bb,
  "nyabengali",
  0x099e,
  "nyadeva",
  0x091e,
  "nyagujarati",
  0x0a9e,
  "nyagurmukhi",
  0x0a1e,
  "o",
  0x006f,
  "oacute",
  0x00f3,
  "oangthai",
  0x0e2d,
  "obarred",
  0x0275,
  "obarredcyrillic",
  0x04e9,
  "obarreddieresiscyrillic",
  0x04eb,
  "obengali",
  0x0993,
  "obopomofo",
  0x311b,
  "obreve",
  0x014f,
  "ocandradeva",
  0x0911,
  "ocandragujarati",
  0x0a91,
  "ocandravowelsigndeva",
  0x0949,
  "ocandravowelsigngujarati",
  0x0ac9,
  "ocaron",
  0x01d2,
  "ocircle",
  0x24de,
  "ocircumflex",
  0x00f4,
  "ocircumflexacute",
  0x1ed1,
  "ocircumflexdotbelow",
  0x1ed9,
  "ocircumflexgrave",
  0x1ed3,
  "ocircumflexhookabove",
  0x1ed5,
  "ocircumflextilde",
  0x1ed7,
  "ocyrillic",
  0x043e,
  "odblacute",
  0x0151,
  "odblgrave",
  0x020d,
  "odeva",
  0x0913,
  "odieresis",
  0x00f6,
  "odieresiscyrillic",
  0x04e7,
  "odotbelow",
  0x1ecd,
  "oe",
  0x0153,
  "oekorean",
  0x315a,
  "ogonek",
  0x02db,
  "ogonekcmb",
  0x0328,
  "ograve",
  0x00f2,
  "ogujarati",
  0x0a93,
  "oharmenian",
  0x0585,
  "ohiragana",
  0x304a,
  "ohookabove",
  0x1ecf,
  "ohorn",
  0x01a1,
  "ohornacute",
  0x1edb,
  "ohorndotbelow",
  0x1ee3,
  "ohorngrave",
  0x1edd,
  "ohornhookabove",
  0x1edf,
  "ohorntilde",
  0x1ee1,
  "ohungarumlaut",
  0x0151,
  "oi",
  0x01a3,
  "oinvertedbreve",
  0x020f,
  "okatakana",
  0x30aa,
  "okatakanahalfwidth",
  0xff75,
  "okorean",
  0x3157,
  "olehebrew",
  0x05ab,
  "omacron",
  0x014d,
  "omacronacute",
  0x1e53,
  "omacrongrave",
  0x1e51,
  "omdeva",
  0x0950,
  "omega",
  0x03c9,
  "omega1",
  0x03d6,
  "omegacyrillic",
  0x0461,
  "omegalatinclosed",
  0x0277,
  "omegaroundcyrillic",
  0x047b,
  "omegatitlocyrillic",
  0x047d,
  "omegatonos",
  0x03ce,
  "omgujarati",
  0x0ad0,
  "omicron",
  0x03bf,
  "omicrontonos",
  0x03cc,
  "omonospace",
  0xff4f,
  "one",
  0x0031,
  "onearabic",
  0x0661,
  "onebengali",
  0x09e7,
  "onecircle",
  0x2460,
  "onecircleinversesansserif",
  0x278a,
  "onedeva",
  0x0967,
  "onedotenleader",
  0x2024,
  "oneeighth",
  0x215b,
  "onefitted",
  0xf6dc,
  "onegujarati",
  0x0ae7,
  "onegurmukhi",
  0x0a67,
  "onehackarabic",
  0x0661,
  "onehalf",
  0x00bd,
  "onehangzhou",
  0x3021,
  "oneideographicparen",
  0x3220,
  "oneinferior",
  0x2081,
  "onemonospace",
  0xff11,
  "onenumeratorbengali",
  0x09f4,
  "oneoldstyle",
  0xf731,
  "oneparen",
  0x2474,
  "oneperiod",
  0x2488,
  "onepersian",
  0x06f1,
  "onequarter",
  0x00bc,
  "oneroman",
  0x2170,
  "onesuperior",
  0x00b9,
  "onethai",
  0x0e51,
  "onethird",
  0x2153,
  "oogonek",
  0x01eb,
  "oogonekmacron",
  0x01ed,
  "oogurmukhi",
  0x0a13,
  "oomatragurmukhi",
  0x0a4b,
  "oopen",
  0x0254,
  "oparen",
  0x24aa,
  "openbullet",
  0x25e6,
  "option",
  0x2325,
  "ordfeminine",
  0x00aa,
  "ordmasculine",
  0x00ba,
  "orthogonal",
  0x221f,
  "oshortdeva",
  0x0912,
  "oshortvowelsigndeva",
  0x094a,
  "oslash",
  0x00f8,
  "oslashacute",
  0x01ff,
  "osmallhiragana",
  0x3049,
  "osmallkatakana",
  0x30a9,
  "osmallkatakanahalfwidth",
  0xff6b,
  "ostrokeacute",
  0x01ff,
  "osuperior",
  0xf6f0,
  "otcyrillic",
  0x047f,
  "otilde",
  0x00f5,
  "otildeacute",
  0x1e4d,
  "otildedieresis",
  0x1e4f,
  "oubopomofo",
  0x3121,
  "overline",
  0x203e,
  "overlinecenterline",
  0xfe4a,
  "overlinecmb",
  0x0305,
  "overlinedashed",
  0xfe49,
  "overlinedblwavy",
  0xfe4c,
  "overlinewavy",
  0xfe4b,
  "overscore",
  0x00af,
  "ovowelsignbengali",
  0x09cb,
  "ovowelsigndeva",
  0x094b,
  "ovowelsigngujarati",
  0x0acb,
  "p",
  0x0070,
  "paampssquare",
  0x3380,
  "paasentosquare",
  0x332b,
  "pabengali",
  0x09aa,
  "pacute",
  0x1e55,
  "padeva",
  0x092a,
  "pagedown",
  0x21df,
  "pageup",
  0x21de,
  "pagujarati",
  0x0aaa,
  "pagurmukhi",
  0x0a2a,
  "pahiragana",
  0x3071,
  "paiyannoithai",
  0x0e2f,
  "pakatakana",
  0x30d1,
  "palatalizationcyrilliccmb",
  0x0484,
  "palochkacyrillic",
  0x04c0,
  "pansioskorean",
  0x317f,
  "paragraph",
  0x00b6,
  "parallel",
  0x2225,
  "parenleft",
  0x0028,
  "parenleftaltonearabic",
  0xfd3e,
  "parenleftbt",
  0xf8ed,
  "parenleftex",
  0xf8ec,
  "parenleftinferior",
  0x208d,
  "parenleftmonospace",
  0xff08,
  "parenleftsmall",
  0xfe59,
  "parenleftsuperior",
  0x207d,
  "parenlefttp",
  0xf8eb,
  "parenleftvertical",
  0xfe35,
  "parenright",
  0x0029,
  "parenrightaltonearabic",
  0xfd3f,
  "parenrightbt",
  0xf8f8,
  "parenrightex",
  0xf8f7,
  "parenrightinferior",
  0x208e,
  "parenrightmonospace",
  0xff09,
  "parenrightsmall",
  0xfe5a,
  "parenrightsuperior",
  0x207e,
  "parenrighttp",
  0xf8f6,
  "parenrightvertical",
  0xfe36,
  "partialdiff",
  0x2202,
  "paseqhebrew",
  0x05c0,
  "pashtahebrew",
  0x0599,
  "pasquare",
  0x33a9,
  "patah",
  0x05b7,
  "patah11",
  0x05b7,
  "patah1d",
  0x05b7,
  "patah2a",
  0x05b7,
  "patahhebrew",
  0x05b7,
  "patahnarrowhebrew",
  0x05b7,
  "patahquarterhebrew",
  0x05b7,
  "patahwidehebrew",
  0x05b7,
  "pazerhebrew",
  0x05a1,
  "pbopomofo",
  0x3106,
  "pcircle",
  0x24df,
  "pdotaccent",
  0x1e57,
  "pe",
  0x05e4,
  "pecyrillic",
  0x043f,
  "pedagesh",
  0xfb44,
  "pedageshhebrew",
  0xfb44,
  "peezisquare",
  0x333b,
  "pefinaldageshhebrew",
  0xfb43,
  "peharabic",
  0x067e,
  "peharmenian",
  0x057a,
  "pehebrew",
  0x05e4,
  "pehfinalarabic",
  0xfb57,
  "pehinitialarabic",
  0xfb58,
  "pehiragana",
  0x307a,
  "pehmedialarabic",
  0xfb59,
  "pekatakana",
  0x30da,
  "pemiddlehookcyrillic",
  0x04a7,
  "perafehebrew",
  0xfb4e,
  "percent",
  0x0025,
  "percentarabic",
  0x066a,
  "percentmonospace",
  0xff05,
  "percentsmall",
  0xfe6a,
  "period",
  0x002e,
  "periodarmenian",
  0x0589,
  "periodcentered",
  0x00b7,
  "periodhalfwidth",
  0xff61,
  "periodinferior",
  0xf6e7,
  "periodmonospace",
  0xff0e,
  "periodsmall",
  0xfe52,
  "periodsuperior",
  0xf6e8,
  "perispomenigreekcmb",
  0x0342,
  "perpendicular",
  0x22a5,
  "perthousand",
  0x2030,
  "peseta",
  0x20a7,
  "pfsquare",
  0x338a,
  "phabengali",
  0x09ab,
  "phadeva",
  0x092b,
  "phagujarati",
  0x0aab,
  "phagurmukhi",
  0x0a2b,
  "phi",
  0x03c6,
  "phi1",
  0x03d5,
  "phieuphacirclekorean",
  0x327a,
  "phieuphaparenkorean",
  0x321a,
  "phieuphcirclekorean",
  0x326c,
  "phieuphkorean",
  0x314d,
  "phieuphparenkorean",
  0x320c,
  "philatin",
  0x0278,
  "phinthuthai",
  0x0e3a,
  "phisymbolgreek",
  0x03d5,
  "phook",
  0x01a5,
  "phophanthai",
  0x0e1e,
  "phophungthai",
  0x0e1c,
  "phosamphaothai",
  0x0e20,
  "pi",
  0x03c0,
  "pieupacirclekorean",
  0x3273,
  "pieupaparenkorean",
  0x3213,
  "pieupcieuckorean",
  0x3176,
  "pieupcirclekorean",
  0x3265,
  "pieupkiyeokkorean",
  0x3172,
  "pieupkorean",
  0x3142,
  "pieupparenkorean",
  0x3205,
  "pieupsioskiyeokkorean",
  0x3174,
  "pieupsioskorean",
  0x3144,
  "pieupsiostikeutkorean",
  0x3175,
  "pieupthieuthkorean",
  0x3177,
  "pieuptikeutkorean",
  0x3173,
  "pihiragana",
  0x3074,
  "pikatakana",
  0x30d4,
  "pisymbolgreek",
  0x03d6,
  "piwrarmenian",
  0x0583,
  "plus",
  0x002b,
  "plusbelowcmb",
  0x031f,
  "pluscircle",
  0x2295,
  "plusminus",
  0x00b1,
  "plusmod",
  0x02d6,
  "plusmonospace",
  0xff0b,
  "plussmall",
  0xfe62,
  "plussuperior",
  0x207a,
  "pmonospace",
  0xff50,
  "pmsquare",
  0x33d8,
  "pohiragana",
  0x307d,
  "pointingindexdownwhite",
  0x261f,
  "pointingindexleftwhite",
  0x261c,
  "pointingindexrightwhite",
  0x261e,
  "pointingindexupwhite",
  0x261d,
  "pokatakana",
  0x30dd,
  "poplathai",
  0x0e1b,
  "postalmark",
  0x3012,
  "postalmarkface",
  0x3020,
  "pparen",
  0x24ab,
  "precedes",
  0x227a,
  "prescription",
  0x211e,
  "primemod",
  0x02b9,
  "primereversed",
  0x2035,
  "product",
  0x220f,
  "projective",
  0x2305,
  "prolongedkana",
  0x30fc,
  "propellor",
  0x2318,
  "propersubset",
  0x2282,
  "propersuperset",
  0x2283,
  "proportion",
  0x2237,
  "proportional",
  0x221d,
  "psi",
  0x03c8,
  "psicyrillic",
  0x0471,
  "psilipneumatacyrilliccmb",
  0x0486,
  "pssquare",
  0x33b0,
  "puhiragana",
  0x3077,
  "pukatakana",
  0x30d7,
  "pvsquare",
  0x33b4,
  "pwsquare",
  0x33ba,
  "q",
  0x0071,
  "qadeva",
  0x0958,
  "qadmahebrew",
  0x05a8,
  "qafarabic",
  0x0642,
  "qaffinalarabic",
  0xfed6,
  "qafinitialarabic",
  0xfed7,
  "qafmedialarabic",
  0xfed8,
  "qamats",
  0x05b8,
  "qamats10",
  0x05b8,
  "qamats1a",
  0x05b8,
  "qamats1c",
  0x05b8,
  "qamats27",
  0x05b8,
  "qamats29",
  0x05b8,
  "qamats33",
  0x05b8,
  "qamatsde",
  0x05b8,
  "qamatshebrew",
  0x05b8,
  "qamatsnarrowhebrew",
  0x05b8,
  "qamatsqatanhebrew",
  0x05b8,
  "qamatsqatannarrowhebrew",
  0x05b8,
  "qamatsqatanquarterhebrew",
  0x05b8,
  "qamatsqatanwidehebrew",
  0x05b8,
  "qamatsquarterhebrew",
  0x05b8,
  "qamatswidehebrew",
  0x05b8,
  "qarneyparahebrew",
  0x059f,
  "qbopomofo",
  0x3111,
  "qcircle",
  0x24e0,
  "qhook",
  0x02a0,
  "qmonospace",
  0xff51,
  "qof",
  0x05e7,
  "qofdagesh",
  0xfb47,
  "qofdageshhebrew",
  0xfb47,
  "qofhebrew",
  0x05e7,
  "qparen",
  0x24ac,
  "quarternote",
  0x2669,
  "qubuts",
  0x05bb,
  "qubuts18",
  0x05bb,
  "qubuts25",
  0x05bb,
  "qubuts31",
  0x05bb,
  "qubutshebrew",
  0x05bb,
  "qubutsnarrowhebrew",
  0x05bb,
  "qubutsquarterhebrew",
  0x05bb,
  "qubutswidehebrew",
  0x05bb,
  "question",
  0x003f,
  "questionarabic",
  0x061f,
  "questionarmenian",
  0x055e,
  "questiondown",
  0x00bf,
  "questiondownsmall",
  0xf7bf,
  "questiongreek",
  0x037e,
  "questionmonospace",
  0xff1f,
  "questionsmall",
  0xf73f,
  "quotedbl",
  0x0022,
  "quotedblbase",
  0x201e,
  "quotedblleft",
  0x201c,
  "quotedblmonospace",
  0xff02,
  "quotedblprime",
  0x301e,
  "quotedblprimereversed",
  0x301d,
  "quotedblright",
  0x201d,
  "quoteleft",
  0x2018,
  "quoteleftreversed",
  0x201b,
  "quotereversed",
  0x201b,
  "quoteright",
  0x2019,
  "quoterightn",
  0x0149,
  "quotesinglbase",
  0x201a,
  "quotesingle",
  0x0027,
  "quotesinglemonospace",
  0xff07,
  "r",
  0x0072,
  "raarmenian",
  0x057c,
  "rabengali",
  0x09b0,
  "racute",
  0x0155,
  "radeva",
  0x0930,
  "radical",
  0x221a,
  "radicalex",
  0xf8e5,
  "radoverssquare",
  0x33ae,
  "radoverssquaredsquare",
  0x33af,
  "radsquare",
  0x33ad,
  "rafe",
  0x05bf,
  "rafehebrew",
  0x05bf,
  "ragujarati",
  0x0ab0,
  "ragurmukhi",
  0x0a30,
  "rahiragana",
  0x3089,
  "rakatakana",
  0x30e9,
  "rakatakanahalfwidth",
  0xff97,
  "ralowerdiagonalbengali",
  0x09f1,
  "ramiddlediagonalbengali",
  0x09f0,
  "ramshorn",
  0x0264,
  "ratio",
  0x2236,
  "rbopomofo",
  0x3116,
  "rcaron",
  0x0159,
  "rcedilla",
  0x0157,
  "rcircle",
  0x24e1,
  "rcommaaccent",
  0x0157,
  "rdblgrave",
  0x0211,
  "rdotaccent",
  0x1e59,
  "rdotbelow",
  0x1e5b,
  "rdotbelowmacron",
  0x1e5d,
  "referencemark",
  0x203b,
  "reflexsubset",
  0x2286,
  "reflexsuperset",
  0x2287,
  "registered",
  0x00ae,
  "registersans",
  0xf8e8,
  "registerserif",
  0xf6da,
  "reharabic",
  0x0631,
  "reharmenian",
  0x0580,
  "rehfinalarabic",
  0xfeae,
  "rehiragana",
  0x308c,
  "rekatakana",
  0x30ec,
  "rekatakanahalfwidth",
  0xff9a,
  "resh",
  0x05e8,
  "reshdageshhebrew",
  0xfb48,
  "reshhebrew",
  0x05e8,
  "reversedtilde",
  0x223d,
  "reviahebrew",
  0x0597,
  "reviamugrashhebrew",
  0x0597,
  "revlogicalnot",
  0x2310,
  "rfishhook",
  0x027e,
  "rfishhookreversed",
  0x027f,
  "rhabengali",
  0x09dd,
  "rhadeva",
  0x095d,
  "rho",
  0x03c1,
  "rhook",
  0x027d,
  "rhookturned",
  0x027b,
  "rhookturnedsuperior",
  0x02b5,
  "rhosymbolgreek",
  0x03f1,
  "rhotichookmod",
  0x02de,
  "rieulacirclekorean",
  0x3271,
  "rieulaparenkorean",
  0x3211,
  "rieulcirclekorean",
  0x3263,
  "rieulhieuhkorean",
  0x3140,
  "rieulkiyeokkorean",
  0x313a,
  "rieulkiyeoksioskorean",
  0x3169,
  "rieulkorean",
  0x3139,
  "rieulmieumkorean",
  0x313b,
  "rieulpansioskorean",
  0x316c,
  "rieulparenkorean",
  0x3203,
  "rieulphieuphkorean",
  0x313f,
  "rieulpieupkorean",
  0x313c,
  "rieulpieupsioskorean",
  0x316b,
  "rieulsioskorean",
  0x313d,
  "rieulthieuthkorean",
  0x313e,
  "rieultikeutkorean",
  0x316a,
  "rieulyeorinhieuhkorean",
  0x316d,
  "rightangle",
  0x221f,
  "righttackbelowcmb",
  0x0319,
  "righttriangle",
  0x22bf,
  "rihiragana",
  0x308a,
  "rikatakana",
  0x30ea,
  "rikatakanahalfwidth",
  0xff98,
  "ring",
  0x02da,
  "ringbelowcmb",
  0x0325,
  "ringcmb",
  0x030a,
  "ringhalfleft",
  0x02bf,
  "ringhalfleftarmenian",
  0x0559,
  "ringhalfleftbelowcmb",
  0x031c,
  "ringhalfleftcentered",
  0x02d3,
  "ringhalfright",
  0x02be,
  "ringhalfrightbelowcmb",
  0x0339,
  "ringhalfrightcentered",
  0x02d2,
  "rinvertedbreve",
  0x0213,
  "rittorusquare",
  0x3351,
  "rlinebelow",
  0x1e5f,
  "rlongleg",
  0x027c,
  "rlonglegturned",
  0x027a,
  "rmonospace",
  0xff52,
  "rohiragana",
  0x308d,
  "rokatakana",
  0x30ed,
  "rokatakanahalfwidth",
  0xff9b,
  "roruathai",
  0x0e23,
  "rparen",
  0x24ad,
  "rrabengali",
  0x09dc,
  "rradeva",
  0x0931,
  "rragurmukhi",
  0x0a5c,
  "rreharabic",
  0x0691,
  "rrehfinalarabic",
  0xfb8d,
  "rrvocalicbengali",
  0x09e0,
  "rrvocalicdeva",
  0x0960,
  "rrvocalicgujarati",
  0x0ae0,
  "rrvocalicvowelsignbengali",
  0x09c4,
  "rrvocalicvowelsigndeva",
  0x0944,
  "rrvocalicvowelsigngujarati",
  0x0ac4,
  "rsuperior",
  0xf6f1,
  "rtblock",
  0x2590,
  "rturned",
  0x0279,
  "rturnedsuperior",
  0x02b4,
  "ruhiragana",
  0x308b,
  "rukatakana",
  0x30eb,
  "rukatakanahalfwidth",
  0xff99,
  "rupeemarkbengali",
  0x09f2,
  "rupeesignbengali",
  0x09f3,
  "rupiah",
  0xf6dd,
  "ruthai",
  0x0e24,
  "rvocalicbengali",
  0x098b,
  "rvocalicdeva",
  0x090b,
  "rvocalicgujarati",
  0x0a8b,
  "rvocalicvowelsignbengali",
  0x09c3,
  "rvocalicvowelsigndeva",
  0x0943,
  "rvocalicvowelsigngujarati",
  0x0ac3,
  "s",
  0x0073,
  "sabengali",
  0x09b8,
  "sacute",
  0x015b,
  "sacutedotaccent",
  0x1e65,
  "sadarabic",
  0x0635,
  "sadeva",
  0x0938,
  "sadfinalarabic",
  0xfeba,
  "sadinitialarabic",
  0xfebb,
  "sadmedialarabic",
  0xfebc,
  "sagujarati",
  0x0ab8,
  "sagurmukhi",
  0x0a38,
  "sahiragana",
  0x3055,
  "sakatakana",
  0x30b5,
  "sakatakanahalfwidth",
  0xff7b,
  "sallallahoualayhewasallamarabic",
  0xfdfa,
  "samekh",
  0x05e1,
  "samekhdagesh",
  0xfb41,
  "samekhdageshhebrew",
  0xfb41,
  "samekhhebrew",
  0x05e1,
  "saraaathai",
  0x0e32,
  "saraaethai",
  0x0e41,
  "saraaimaimalaithai",
  0x0e44,
  "saraaimaimuanthai",
  0x0e43,
  "saraamthai",
  0x0e33,
  "saraathai",
  0x0e30,
  "saraethai",
  0x0e40,
  "saraiileftthai",
  0xf886,
  "saraiithai",
  0x0e35,
  "saraileftthai",
  0xf885,
  "saraithai",
  0x0e34,
  "saraothai",
  0x0e42,
  "saraueeleftthai",
  0xf888,
  "saraueethai",
  0x0e37,
  "saraueleftthai",
  0xf887,
  "sarauethai",
  0x0e36,
  "sarauthai",
  0x0e38,
  "sarauuthai",
  0x0e39,
  "sbopomofo",
  0x3119,
  "scaron",
  0x0161,
  "scarondotaccent",
  0x1e67,
  "scedilla",
  0x015f,
  "schwa",
  0x0259,
  "schwacyrillic",
  0x04d9,
  "schwadieresiscyrillic",
  0x04db,
  "schwahook",
  0x025a,
  "scircle",
  0x24e2,
  "scircumflex",
  0x015d,
  "scommaaccent",
  0x0219,
  "sdotaccent",
  0x1e61,
  "sdotbelow",
  0x1e63,
  "sdotbelowdotaccent",
  0x1e69,
  "seagullbelowcmb",
  0x033c,
  "second",
  0x2033,
  "secondtonechinese",
  0x02ca,
  "section",
  0x00a7,
  "seenarabic",
  0x0633,
  "seenfinalarabic",
  0xfeb2,
  "seeninitialarabic",
  0xfeb3,
  "seenmedialarabic",
  0xfeb4,
  "segol",
  0x05b6,
  "segol13",
  0x05b6,
  "segol1f",
  0x05b6,
  "segol2c",
  0x05b6,
  "segolhebrew",
  0x05b6,
  "segolnarrowhebrew",
  0x05b6,
  "segolquarterhebrew",
  0x05b6,
  "segoltahebrew",
  0x0592,
  "segolwidehebrew",
  0x05b6,
  "seharmenian",
  0x057d,
  "sehiragana",
  0x305b,
  "sekatakana",
  0x30bb,
  "sekatakanahalfwidth",
  0xff7e,
  "semicolon",
  0x003b,
  "semicolonarabic",
  0x061b,
  "semicolonmonospace",
  0xff1b,
  "semicolonsmall",
  0xfe54,
  "semivoicedmarkkana",
  0x309c,
  "semivoicedmarkkanahalfwidth",
  0xff9f,
  "sentisquare",
  0x3322,
  "sentosquare",
  0x3323,
  "seven",
  0x0037,
  "sevenarabic",
  0x0667,
  "sevenbengali",
  0x09ed,
  "sevencircle",
  0x2466,
  "sevencircleinversesansserif",
  0x2790,
  "sevendeva",
  0x096d,
  "seveneighths",
  0x215e,
  "sevengujarati",
  0x0aed,
  "sevengurmukhi",
  0x0a6d,
  "sevenhackarabic",
  0x0667,
  "sevenhangzhou",
  0x3027,
  "sevenideographicparen",
  0x3226,
  "seveninferior",
  0x2087,
  "sevenmonospace",
  0xff17,
  "sevenoldstyle",
  0xf737,
  "sevenparen",
  0x247a,
  "sevenperiod",
  0x248e,
  "sevenpersian",
  0x06f7,
  "sevenroman",
  0x2176,
  "sevensuperior",
  0x2077,
  "seventeencircle",
  0x2470,
  "seventeenparen",
  0x2484,
  "seventeenperiod",
  0x2498,
  "seventhai",
  0x0e57,
  "sfthyphen",
  0x00ad,
  "shaarmenian",
  0x0577,
  "shabengali",
  0x09b6,
  "shacyrillic",
  0x0448,
  "shaddaarabic",
  0x0651,
  "shaddadammaarabic",
  0xfc61,
  "shaddadammatanarabic",
  0xfc5e,
  "shaddafathaarabic",
  0xfc60,
  "shaddakasraarabic",
  0xfc62,
  "shaddakasratanarabic",
  0xfc5f,
  "shade",
  0x2592,
  "shadedark",
  0x2593,
  "shadelight",
  0x2591,
  "shademedium",
  0x2592,
  "shadeva",
  0x0936,
  "shagujarati",
  0x0ab6,
  "shagurmukhi",
  0x0a36,
  "shalshelethebrew",
  0x0593,
  "shbopomofo",
  0x3115,
  "shchacyrillic",
  0x0449,
  "sheenarabic",
  0x0634,
  "sheenfinalarabic",
  0xfeb6,
  "sheeninitialarabic",
  0xfeb7,
  "sheenmedialarabic",
  0xfeb8,
  "sheicoptic",
  0x03e3,
  "sheqel",
  0x20aa,
  "sheqelhebrew",
  0x20aa,
  "sheva",
  0x05b0,
  "sheva115",
  0x05b0,
  "sheva15",
  0x05b0,
  "sheva22",
  0x05b0,
  "sheva2e",
  0x05b0,
  "shevahebrew",
  0x05b0,
  "shevanarrowhebrew",
  0x05b0,
  "shevaquarterhebrew",
  0x05b0,
  "shevawidehebrew",
  0x05b0,
  "shhacyrillic",
  0x04bb,
  "shimacoptic",
  0x03ed,
  "shin",
  0x05e9,
  "shindagesh",
  0xfb49,
  "shindageshhebrew",
  0xfb49,
  "shindageshshindot",
  0xfb2c,
  "shindageshshindothebrew",
  0xfb2c,
  "shindageshsindot",
  0xfb2d,
  "shindageshsindothebrew",
  0xfb2d,
  "shindothebrew",
  0x05c1,
  "shinhebrew",
  0x05e9,
  "shinshindot",
  0xfb2a,
  "shinshindothebrew",
  0xfb2a,
  "shinsindot",
  0xfb2b,
  "shinsindothebrew",
  0xfb2b,
  "shook",
  0x0282,
  "sigma",
  0x03c3,
  "sigma1",
  0x03c2,
  "sigmafinal",
  0x03c2,
  "sigmalunatesymbolgreek",
  0x03f2,
  "sihiragana",
  0x3057,
  "sikatakana",
  0x30b7,
  "sikatakanahalfwidth",
  0xff7c,
  "siluqhebrew",
  0x05bd,
  "siluqlefthebrew",
  0x05bd,
  "similar",
  0x223c,
  "sindothebrew",
  0x05c2,
  "siosacirclekorean",
  0x3274,
  "siosaparenkorean",
  0x3214,
  "sioscieuckorean",
  0x317e,
  "sioscirclekorean",
  0x3266,
  "sioskiyeokkorean",
  0x317a,
  "sioskorean",
  0x3145,
  "siosnieunkorean",
  0x317b,
  "siosparenkorean",
  0x3206,
  "siospieupkorean",
  0x317d,
  "siostikeutkorean",
  0x317c,
  "six",
  0x0036,
  "sixarabic",
  0x0666,
  "sixbengali",
  0x09ec,
  "sixcircle",
  0x2465,
  "sixcircleinversesansserif",
  0x278f,
  "sixdeva",
  0x096c,
  "sixgujarati",
  0x0aec,
  "sixgurmukhi",
  0x0a6c,
  "sixhackarabic",
  0x0666,
  "sixhangzhou",
  0x3026,
  "sixideographicparen",
  0x3225,
  "sixinferior",
  0x2086,
  "sixmonospace",
  0xff16,
  "sixoldstyle",
  0xf736,
  "sixparen",
  0x2479,
  "sixperiod",
  0x248d,
  "sixpersian",
  0x06f6,
  "sixroman",
  0x2175,
  "sixsuperior",
  0x2076,
  "sixteencircle",
  0x246f,
  "sixteencurrencydenominatorbengali",
  0x09f9,
  "sixteenparen",
  0x2483,
  "sixteenperiod",
  0x2497,
  "sixthai",
  0x0e56,
  "slash",
  0x002f,
  "slashmonospace",
  0xff0f,
  "slong",
  0x017f,
  "slongdotaccent",
  0x1e9b,
  "smileface",
  0x263a,
  "smonospace",
  0xff53,
  "sofpasuqhebrew",
  0x05c3,
  "softhyphen",
  0x00ad,
  "softsigncyrillic",
  0x044c,
  "sohiragana",
  0x305d,
  "sokatakana",
  0x30bd,
  "sokatakanahalfwidth",
  0xff7f,
  "soliduslongoverlaycmb",
  0x0338,
  "solidusshortoverlaycmb",
  0x0337,
  "sorusithai",
  0x0e29,
  "sosalathai",
  0x0e28,
  "sosothai",
  0x0e0b,
  "sosuathai",
  0x0e2a,
  "space",
  0x0020,
  "spacehackarabic",
  0x0020,
  "spade",
  0x2660,
  "spadesuitblack",
  0x2660,
  "spadesuitwhite",
  0x2664,
  "sparen",
  0x24ae,
  "squarebelowcmb",
  0x033b,
  "squarecc",
  0x33c4,
  "squarecm",
  0x339d,
  "squarediagonalcrosshatchfill",
  0x25a9,
  "squarehorizontalfill",
  0x25a4,
  "squarekg",
  0x338f,
  "squarekm",
  0x339e,
  "squarekmcapital",
  0x33ce,
  "squareln",
  0x33d1,
  "squarelog",
  0x33d2,
  "squaremg",
  0x338e,
  "squaremil",
  0x33d5,
  "squaremm",
  0x339c,
  "squaremsquared",
  0x33a1,
  "squareorthogonalcrosshatchfill",
  0x25a6,
  "squareupperlefttolowerrightfill",
  0x25a7,
  "squareupperrighttolowerleftfill",
  0x25a8,
  "squareverticalfill",
  0x25a5,
  "squarewhitewithsmallblack",
  0x25a3,
  "srsquare",
  0x33db,
  "ssabengali",
  0x09b7,
  "ssadeva",
  0x0937,
  "ssagujarati",
  0x0ab7,
  "ssangcieuckorean",
  0x3149,
  "ssanghieuhkorean",
  0x3185,
  "ssangieungkorean",
  0x3180,
  "ssangkiyeokkorean",
  0x3132,
  "ssangnieunkorean",
  0x3165,
  "ssangpieupkorean",
  0x3143,
  "ssangsioskorean",
  0x3146,
  "ssangtikeutkorean",
  0x3138,
  "ssuperior",
  0xf6f2,
  "sterling",
  0x00a3,
  "sterlingmonospace",
  0xffe1,
  "strokelongoverlaycmb",
  0x0336,
  "strokeshortoverlaycmb",
  0x0335,
  "subset",
  0x2282,
  "subsetnotequal",
  0x228a,
  "subsetorequal",
  0x2286,
  "succeeds",
  0x227b,
  "suchthat",
  0x220b,
  "suhiragana",
  0x3059,
  "sukatakana",
  0x30b9,
  "sukatakanahalfwidth",
  0xff7d,
  "sukunarabic",
  0x0652,
  "summation",
  0x2211,
  "sun",
  0x263c,
  "superset",
  0x2283,
  "supersetnotequal",
  0x228b,
  "supersetorequal",
  0x2287,
  "svsquare",
  0x33dc,
  "syouwaerasquare",
  0x337c,
  "t",
  0x0074,
  "tabengali",
  0x09a4,
  "tackdown",
  0x22a4,
  "tackleft",
  0x22a3,
  "tadeva",
  0x0924,
  "tagujarati",
  0x0aa4,
  "tagurmukhi",
  0x0a24,
  "taharabic",
  0x0637,
  "tahfinalarabic",
  0xfec2,
  "tahinitialarabic",
  0xfec3,
  "tahiragana",
  0x305f,
  "tahmedialarabic",
  0xfec4,
  "taisyouerasquare",
  0x337d,
  "takatakana",
  0x30bf,
  "takatakanahalfwidth",
  0xff80,
  "tatweelarabic",
  0x0640,
  "tau",
  0x03c4,
  "tav",
  0x05ea,
  "tavdages",
  0xfb4a,
  "tavdagesh",
  0xfb4a,
  "tavdageshhebrew",
  0xfb4a,
  "tavhebrew",
  0x05ea,
  "tbar",
  0x0167,
  "tbopomofo",
  0x310a,
  "tcaron",
  0x0165,
  "tccurl",
  0x02a8,
  "tcedilla",
  0x0163,
  "tcheharabic",
  0x0686,
  "tchehfinalarabic",
  0xfb7b,
  "tchehinitialarabic",
  0xfb7c,
  "tchehmedialarabic",
  0xfb7d,
  "tcircle",
  0x24e3,
  "tcircumflexbelow",
  0x1e71,
  "tcommaaccent",
  0x0163,
  "tdieresis",
  0x1e97,
  "tdotaccent",
  0x1e6b,
  "tdotbelow",
  0x1e6d,
  "tecyrillic",
  0x0442,
  "tedescendercyrillic",
  0x04ad,
  "teharabic",
  0x062a,
  "tehfinalarabic",
  0xfe96,
  "tehhahinitialarabic",
  0xfca2,
  "tehhahisolatedarabic",
  0xfc0c,
  "tehinitialarabic",
  0xfe97,
  "tehiragana",
  0x3066,
  "tehjeeminitialarabic",
  0xfca1,
  "tehjeemisolatedarabic",
  0xfc0b,
  "tehmarbutaarabic",
  0x0629,
  "tehmarbutafinalarabic",
  0xfe94,
  "tehmedialarabic",
  0xfe98,
  "tehmeeminitialarabic",
  0xfca4,
  "tehmeemisolatedarabic",
  0xfc0e,
  "tehnoonfinalarabic",
  0xfc73,
  "tekatakana",
  0x30c6,
  "tekatakanahalfwidth",
  0xff83,
  "telephone",
  0x2121,
  "telephoneblack",
  0x260e,
  "telishagedolahebrew",
  0x05a0,
  "telishaqetanahebrew",
  0x05a9,
  "tencircle",
  0x2469,
  "tenideographicparen",
  0x3229,
  "tenparen",
  0x247d,
  "tenperiod",
  0x2491,
  "tenroman",
  0x2179,
  "tesh",
  0x02a7,
  "tet",
  0x05d8,
  "tetdagesh",
  0xfb38,
  "tetdageshhebrew",
  0xfb38,
  "tethebrew",
  0x05d8,
  "tetsecyrillic",
  0x04b5,
  "tevirhebrew",
  0x059b,
  "tevirlefthebrew",
  0x059b,
  "thabengali",
  0x09a5,
  "thadeva",
  0x0925,
  "thagujarati",
  0x0aa5,
  "thagurmukhi",
  0x0a25,
  "thalarabic",
  0x0630,
  "thalfinalarabic",
  0xfeac,
  "thanthakhatlowleftthai",
  0xf898,
  "thanthakhatlowrightthai",
  0xf897,
  "thanthakhatthai",
  0x0e4c,
  "thanthakhatupperleftthai",
  0xf896,
  "theharabic",
  0x062b,
  "thehfinalarabic",
  0xfe9a,
  "thehinitialarabic",
  0xfe9b,
  "thehmedialarabic",
  0xfe9c,
  "thereexists",
  0x2203,
  "therefore",
  0x2234,
  "theta",
  0x03b8,
  "theta1",
  0x03d1,
  "thetasymbolgreek",
  0x03d1,
  "thieuthacirclekorean",
  0x3279,
  "thieuthaparenkorean",
  0x3219,
  "thieuthcirclekorean",
  0x326b,
  "thieuthkorean",
  0x314c,
  "thieuthparenkorean",
  0x320b,
  "thirteencircle",
  0x246c,
  "thirteenparen",
  0x2480,
  "thirteenperiod",
  0x2494,
  "thonangmonthothai",
  0x0e11,
  "thook",
  0x01ad,
  "thophuthaothai",
  0x0e12,
  "thorn",
  0x00fe,
  "thothahanthai",
  0x0e17,
  "thothanthai",
  0x0e10,
  "thothongthai",
  0x0e18,
  "thothungthai",
  0x0e16,
  "thousandcyrillic",
  0x0482,
  "thousandsseparatorarabic",
  0x066c,
  "thousandsseparatorpersian",
  0x066c,
  "three",
  0x0033,
  "threearabic",
  0x0663,
  "threebengali",
  0x09e9,
  "threecircle",
  0x2462,
  "threecircleinversesansserif",
  0x278c,
  "threedeva",
  0x0969,
  "threeeighths",
  0x215c,
  "threegujarati",
  0x0ae9,
  "threegurmukhi",
  0x0a69,
  "threehackarabic",
  0x0663,
  "threehangzhou",
  0x3023,
  "threeideographicparen",
  0x3222,
  "threeinferior",
  0x2083,
  "threemonospace",
  0xff13,
  "threenumeratorbengali",
  0x09f6,
  "threeoldstyle",
  0xf733,
  "threeparen",
  0x2476,
  "threeperiod",
  0x248a,
  "threepersian",
  0x06f3,
  "threequarters",
  0x00be,
  "threequartersemdash",
  0xf6de,
  "threeroman",
  0x2172,
  "threesuperior",
  0x00b3,
  "threethai",
  0x0e53,
  "thzsquare",
  0x3394,
  "tihiragana",
  0x3061,
  "tikatakana",
  0x30c1,
  "tikatakanahalfwidth",
  0xff81,
  "tikeutacirclekorean",
  0x3270,
  "tikeutaparenkorean",
  0x3210,
  "tikeutcirclekorean",
  0x3262,
  "tikeutkorean",
  0x3137,
  "tikeutparenkorean",
  0x3202,
  "tilde",
  0x02dc,
  "tildebelowcmb",
  0x0330,
  "tildecmb",
  0x0303,
  "tildecomb",
  0x0303,
  "tildedoublecmb",
  0x0360,
  "tildeoperator",
  0x223c,
  "tildeoverlaycmb",
  0x0334,
  "tildeverticalcmb",
  0x033e,
  "timescircle",
  0x2297,
  "tipehahebrew",
  0x0596,
  "tipehalefthebrew",
  0x0596,
  "tippigurmukhi",
  0x0a70,
  "titlocyrilliccmb",
  0x0483,
  "tiwnarmenian",
  0x057f,
  "tlinebelow",
  0x1e6f,
  "tmonospace",
  0xff54,
  "toarmenian",
  0x0569,
  "tohiragana",
  0x3068,
  "tokatakana",
  0x30c8,
  "tokatakanahalfwidth",
  0xff84,
  "tonebarextrahighmod",
  0x02e5,
  "tonebarextralowmod",
  0x02e9,
  "tonebarhighmod",
  0x02e6,
  "tonebarlowmod",
  0x02e8,
  "tonebarmidmod",
  0x02e7,
  "tonefive",
  0x01bd,
  "tonesix",
  0x0185,
  "tonetwo",
  0x01a8,
  "tonos",
  0x0384,
  "tonsquare",
  0x3327,
  "topatakthai",
  0x0e0f,
  "tortoiseshellbracketleft",
  0x3014,
  "tortoiseshellbracketleftsmall",
  0xfe5d,
  "tortoiseshellbracketleftvertical",
  0xfe39,
  "tortoiseshellbracketright",
  0x3015,
  "tortoiseshellbracketrightsmall",
  0xfe5e,
  "tortoiseshellbracketrightvertical",
  0xfe3a,
  "totaothai",
  0x0e15,
  "tpalatalhook",
  0x01ab,
  "tparen",
  0x24af,
  "trademark",
  0x2122,
  "trademarksans",
  0xf8ea,
  "trademarkserif",
  0xf6db,
  "tretroflexhook",
  0x0288,
  "triagdn",
  0x25bc,
  "triaglf",
  0x25c4,
  "triagrt",
  0x25ba,
  "triagup",
  0x25b2,
  "ts",
  0x02a6,
  "tsadi",
  0x05e6,
  "tsadidagesh",
  0xfb46,
  "tsadidageshhebrew",
  0xfb46,
  "tsadihebrew",
  0x05e6,
  "tsecyrillic",
  0x0446,
  "tsere",
  0x05b5,
  "tsere12",
  0x05b5,
  "tsere1e",
  0x05b5,
  "tsere2b",
  0x05b5,
  "tserehebrew",
  0x05b5,
  "tserenarrowhebrew",
  0x05b5,
  "tserequarterhebrew",
  0x05b5,
  "tserewidehebrew",
  0x05b5,
  "tshecyrillic",
  0x045b,
  "tsuperior",
  0xf6f3,
  "ttabengali",
  0x099f,
  "ttadeva",
  0x091f,
  "ttagujarati",
  0x0a9f,
  "ttagurmukhi",
  0x0a1f,
  "tteharabic",
  0x0679,
  "ttehfinalarabic",
  0xfb67,
  "ttehinitialarabic",
  0xfb68,
  "ttehmedialarabic",
  0xfb69,
  "tthabengali",
  0x09a0,
  "tthadeva",
  0x0920,
  "tthagujarati",
  0x0aa0,
  "tthagurmukhi",
  0x0a20,
  "tturned",
  0x0287,
  "tuhiragana",
  0x3064,
  "tukatakana",
  0x30c4,
  "tukatakanahalfwidth",
  0xff82,
  "tusmallhiragana",
  0x3063,
  "tusmallkatakana",
  0x30c3,
  "tusmallkatakanahalfwidth",
  0xff6f,
  "twelvecircle",
  0x246b,
  "twelveparen",
  0x247f,
  "twelveperiod",
  0x2493,
  "twelveroman",
  0x217b,
  "twentycircle",
  0x2473,
  "twentyhangzhou",
  0x5344,
  "twentyparen",
  0x2487,
  "twentyperiod",
  0x249b,
  "two",
  0x0032,
  "twoarabic",
  0x0662,
  "twobengali",
  0x09e8,
  "twocircle",
  0x2461,
  "twocircleinversesansserif",
  0x278b,
  "twodeva",
  0x0968,
  "twodotenleader",
  0x2025,
  "twodotleader",
  0x2025,
  "twodotleadervertical",
  0xfe30,
  "twogujarati",
  0x0ae8,
  "twogurmukhi",
  0x0a68,
  "twohackarabic",
  0x0662,
  "twohangzhou",
  0x3022,
  "twoideographicparen",
  0x3221,
  "twoinferior",
  0x2082,
  "twomonospace",
  0xff12,
  "twonumeratorbengali",
  0x09f5,
  "twooldstyle",
  0xf732,
  "twoparen",
  0x2475,
  "twoperiod",
  0x2489,
  "twopersian",
  0x06f2,
  "tworoman",
  0x2171,
  "twostroke",
  0x01bb,
  "twosuperior",
  0x00b2,
  "twothai",
  0x0e52,
  "twothirds",
  0x2154,
  "u",
  0x0075,
  "uacute",
  0x00fa,
  "ubar",
  0x0289,
  "ubengali",
  0x0989,
  "ubopomofo",
  0x3128,
  "ubreve",
  0x016d,
  "ucaron",
  0x01d4,
  "ucircle",
  0x24e4,
  "ucircumflex",
  0x00fb,
  "ucircumflexbelow",
  0x1e77,
  "ucyrillic",
  0x0443,
  "udattadeva",
  0x0951,
  "udblacute",
  0x0171,
  "udblgrave",
  0x0215,
  "udeva",
  0x0909,
  "udieresis",
  0x00fc,
  "udieresisacute",
  0x01d8,
  "udieresisbelow",
  0x1e73,
  "udieresiscaron",
  0x01da,
  "udieresiscyrillic",
  0x04f1,
  "udieresisgrave",
  0x01dc,
  "udieresismacron",
  0x01d6,
  "udotbelow",
  0x1ee5,
  "ugrave",
  0x00f9,
  "ugujarati",
  0x0a89,
  "ugurmukhi",
  0x0a09,
  "uhiragana",
  0x3046,
  "uhookabove",
  0x1ee7,
  "uhorn",
  0x01b0,
  "uhornacute",
  0x1ee9,
  "uhorndotbelow",
  0x1ef1,
  "uhorngrave",
  0x1eeb,
  "uhornhookabove",
  0x1eed,
  "uhorntilde",
  0x1eef,
  "uhungarumlaut",
  0x0171,
  "uhungarumlautcyrillic",
  0x04f3,
  "uinvertedbreve",
  0x0217,
  "ukatakana",
  0x30a6,
  "ukatakanahalfwidth",
  0xff73,
  "ukcyrillic",
  0x0479,
  "ukorean",
  0x315c,
  "umacron",
  0x016b,
  "umacroncyrillic",
  0x04ef,
  "umacrondieresis",
  0x1e7b,
  "umatragurmukhi",
  0x0a41,
  "umonospace",
  0xff55,
  "underscore",
  0x005f,
  "underscoredbl",
  0x2017,
  "underscoremonospace",
  0xff3f,
  "underscorevertical",
  0xfe33,
  "underscorewavy",
  0xfe4f,
  "union",
  0x222a,
  "universal",
  0x2200,
  "uogonek",
  0x0173,
  "uparen",
  0x24b0,
  "upblock",
  0x2580,
  "upperdothebrew",
  0x05c4,
  "upsilon",
  0x03c5,
  "upsilondieresis",
  0x03cb,
  "upsilondieresistonos",
  0x03b0,
  "upsilonlatin",
  0x028a,
  "upsilontonos",
  0x03cd,
  "uptackbelowcmb",
  0x031d,
  "uptackmod",
  0x02d4,
  "uragurmukhi",
  0x0a73,
  "uring",
  0x016f,
  "ushortcyrillic",
  0x045e,
  "usmallhiragana",
  0x3045,
  "usmallkatakana",
  0x30a5,
  "usmallkatakanahalfwidth",
  0xff69,
  "ustraightcyrillic",
  0x04af,
  "ustraightstrokecyrillic",
  0x04b1,
  "utilde",
  0x0169,
  "utildeacute",
  0x1e79,
  "utildebelow",
  0x1e75,
  "uubengali",
  0x098a,
  "uudeva",
  0x090a,
  "uugujarati",
  0x0a8a,
  "uugurmukhi",
  0x0a0a,
  "uumatragurmukhi",
  0x0a42,
  "uuvowelsignbengali",
  0x09c2,
  "uuvowelsigndeva",
  0x0942,
  "uuvowelsigngujarati",
  0x0ac2,
  "uvowelsignbengali",
  0x09c1,
  "uvowelsigndeva",
  0x0941,
  "uvowelsigngujarati",
  0x0ac1,
  "v",
  0x0076,
  "vadeva",
  0x0935,
  "vagujarati",
  0x0ab5,
  "vagurmukhi",
  0x0a35,
  "vakatakana",
  0x30f7,
  "vav",
  0x05d5,
  "vavdagesh",
  0xfb35,
  "vavdagesh65",
  0xfb35,
  "vavdageshhebrew",
  0xfb35,
  "vavhebrew",
  0x05d5,
  "vavholam",
  0xfb4b,
  "vavholamhebrew",
  0xfb4b,
  "vavvavhebrew",
  0x05f0,
  "vavyodhebrew",
  0x05f1,
  "vcircle",
  0x24e5,
  "vdotbelow",
  0x1e7f,
  "vecyrillic",
  0x0432,
  "veharabic",
  0x06a4,
  "vehfinalarabic",
  0xfb6b,
  "vehinitialarabic",
  0xfb6c,
  "vehmedialarabic",
  0xfb6d,
  "vekatakana",
  0x30f9,
  "venus",
  0x2640,
  "verticalbar",
  0x007c,
  "verticallineabovecmb",
  0x030d,
  "verticallinebelowcmb",
  0x0329,
  "verticallinelowmod",
  0x02cc,
  "verticallinemod",
  0x02c8,
  "vewarmenian",
  0x057e,
  "vhook",
  0x028b,
  "vikatakana",
  0x30f8,
  "viramabengali",
  0x09cd,
  "viramadeva",
  0x094d,
  "viramagujarati",
  0x0acd,
  "visargabengali",
  0x0983,
  "visargadeva",
  0x0903,
  "visargagujarati",
  0x0a83,
  "vmonospace",
  0xff56,
  "voarmenian",
  0x0578,
  "voicediterationhiragana",
  0x309e,
  "voicediterationkatakana",
  0x30fe,
  "voicedmarkkana",
  0x309b,
  "voicedmarkkanahalfwidth",
  0xff9e,
  "vokatakana",
  0x30fa,
  "vparen",
  0x24b1,
  "vtilde",
  0x1e7d,
  "vturned",
  0x028c,
  "vuhiragana",
  0x3094,
  "vukatakana",
  0x30f4,
  "w",
  0x0077,
  "wacute",
  0x1e83,
  "waekorean",
  0x3159,
  "wahiragana",
  0x308f,
  "wakatakana",
  0x30ef,
  "wakatakanahalfwidth",
  0xff9c,
  "wakorean",
  0x3158,
  "wasmallhiragana",
  0x308e,
  "wasmallkatakana",
  0x30ee,
  "wattosquare",
  0x3357,
  "wavedash",
  0x301c,
  "wavyunderscorevertical",
  0xfe34,
  "wawarabic",
  0x0648,
  "wawfinalarabic",
  0xfeee,
  "wawhamzaabovearabic",
  0x0624,
  "wawhamzaabovefinalarabic",
  0xfe86,
  "wbsquare",
  0x33dd,
  "wcircle",
  0x24e6,
  "wcircumflex",
  0x0175,
  "wdieresis",
  0x1e85,
  "wdotaccent",
  0x1e87,
  "wdotbelow",
  0x1e89,
  "wehiragana",
  0x3091,
  "weierstrass",
  0x2118,
  "wekatakana",
  0x30f1,
  "wekorean",
  0x315e,
  "weokorean",
  0x315d,
  "wgrave",
  0x1e81,
  "whitebullet",
  0x25e6,
  "whitecircle",
  0x25cb,
  "whitecircleinverse",
  0x25d9,
  "whitecornerbracketleft",
  0x300e,
  "whitecornerbracketleftvertical",
  0xfe43,
  "whitecornerbracketright",
  0x300f,
  "whitecornerbracketrightvertical",
  0xfe44,
  "whitediamond",
  0x25c7,
  "whitediamondcontainingblacksmalldiamond",
  0x25c8,
  "whitedownpointingsmalltriangle",
  0x25bf,
  "whitedownpointingtriangle",
  0x25bd,
  "whiteleftpointingsmalltriangle",
  0x25c3,
  "whiteleftpointingtriangle",
  0x25c1,
  "whitelenticularbracketleft",
  0x3016,
  "whitelenticularbracketright",
  0x3017,
  "whiterightpointingsmalltriangle",
  0x25b9,
  "whiterightpointingtriangle",
  0x25b7,
  "whitesmallsquare",
  0x25ab,
  "whitesmilingface",
  0x263a,
  "whitesquare",
  0x25a1,
  "whitestar",
  0x2606,
  "whitetelephone",
  0x260f,
  "whitetortoiseshellbracketleft",
  0x3018,
  "whitetortoiseshellbracketright",
  0x3019,
  "whiteuppointingsmalltriangle",
  0x25b5,
  "whiteuppointingtriangle",
  0x25b3,
  "wihiragana",
  0x3090,
  "wikatakana",
  0x30f0,
  "wikorean",
  0x315f,
  "wmonospace",
  0xff57,
  "wohiragana",
  0x3092,
  "wokatakana",
  0x30f2,
  "wokatakanahalfwidth",
  0xff66,
  "won",
  0x20a9,
  "wonmonospace",
  0xffe6,
  "wowaenthai",
  0x0e27,
  "wparen",
  0x24b2,
  "wring",
  0x1e98,
  "wsuperior",
  0x02b7,
  "wturned",
  0x028d,
  "wynn",
  0x01bf,
  "x",
  0x0078,
  "xabovecmb",
  0x033d,
  "xbopomofo",
  0x3112,
  "xcircle",
  0x24e7,
  "xdieresis",
  0x1e8d,
  "xdotaccent",
  0x1e8b,
  "xeharmenian",
  0x056d,
  "xi",
  0x03be,
  "xmonospace",
  0xff58,
  "xparen",
  0x24b3,
  "xsuperior",
  0x02e3,
  "y",
  0x0079,
  "yaadosquare",
  0x334e,
  "yabengali",
  0x09af,
  "yacute",
  0x00fd,
  "yadeva",
  0x092f,
  "yaekorean",
  0x3152,
  "yagujarati",
  0x0aaf,
  "yagurmukhi",
  0x0a2f,
  "yahiragana",
  0x3084,
  "yakatakana",
  0x30e4,
  "yakatakanahalfwidth",
  0xff94,
  "yakorean",
  0x3151,
  "yamakkanthai",
  0x0e4e,
  "yasmallhiragana",
  0x3083,
  "yasmallkatakana",
  0x30e3,
  "yasmallkatakanahalfwidth",
  0xff6c,
  "yatcyrillic",
  0x0463,
  "ycircle",
  0x24e8,
  "ycircumflex",
  0x0177,
  "ydieresis",
  0x00ff,
  "ydotaccent",
  0x1e8f,
  "ydotbelow",
  0x1ef5,
  "yeharabic",
  0x064a,
  "yehbarreearabic",
  0x06d2,
  "yehbarreefinalarabic",
  0xfbaf,
  "yehfinalarabic",
  0xfef2,
  "yehhamzaabovearabic",
  0x0626,
  "yehhamzaabovefinalarabic",
  0xfe8a,
  "yehhamzaaboveinitialarabic",
  0xfe8b,
  "yehhamzaabovemedialarabic",
  0xfe8c,
  "yehinitialarabic",
  0xfef3,
  "yehmedialarabic",
  0xfef4,
  "yehmeeminitialarabic",
  0xfcdd,
  "yehmeemisolatedarabic",
  0xfc58,
  "yehnoonfinalarabic",
  0xfc94,
  "yehthreedotsbelowarabic",
  0x06d1,
  "yekorean",
  0x3156,
  "yen",
  0x00a5,
  "yenmonospace",
  0xffe5,
  "yeokorean",
  0x3155,
  "yeorinhieuhkorean",
  0x3186,
  "yerahbenyomohebrew",
  0x05aa,
  "yerahbenyomolefthebrew",
  0x05aa,
  "yericyrillic",
  0x044b,
  "yerudieresiscyrillic",
  0x04f9,
  "yesieungkorean",
  0x3181,
  "yesieungpansioskorean",
  0x3183,
  "yesieungsioskorean",
  0x3182,
  "yetivhebrew",
  0x059a,
  "ygrave",
  0x1ef3,
  "yhook",
  0x01b4,
  "yhookabove",
  0x1ef7,
  "yiarmenian",
  0x0575,
  "yicyrillic",
  0x0457,
  "yikorean",
  0x3162,
  "yinyang",
  0x262f,
  "yiwnarmenian",
  0x0582,
  "ymonospace",
  0xff59,
  "yod",
  0x05d9,
  "yoddagesh",
  0xfb39,
  "yoddageshhebrew",
  0xfb39,
  "yodhebrew",
  0x05d9,
  "yodyodhebrew",
  0x05f2,
  "yodyodpatahhebrew",
  0xfb1f,
  "yohiragana",
  0x3088,
  "yoikorean",
  0x3189,
  "yokatakana",
  0x30e8,
  "yokatakanahalfwidth",
  0xff96,
  "yokorean",
  0x315b,
  "yosmallhiragana",
  0x3087,
  "yosmallkatakana",
  0x30e7,
  "yosmallkatakanahalfwidth",
  0xff6e,
  "yotgreek",
  0x03f3,
  "yoyaekorean",
  0x3188,
  "yoyakorean",
  0x3187,
  "yoyakthai",
  0x0e22,
  "yoyingthai",
  0x0e0d,
  "yparen",
  0x24b4,
  "ypogegrammeni",
  0x037a,
  "ypogegrammenigreekcmb",
  0x0345,
  "yr",
  0x01a6,
  "yring",
  0x1e99,
  "ysuperior",
  0x02b8,
  "ytilde",
  0x1ef9,
  "yturned",
  0x028e,
  "yuhiragana",
  0x3086,
  "yuikorean",
  0x318c,
  "yukatakana",
  0x30e6,
  "yukatakanahalfwidth",
  0xff95,
  "yukorean",
  0x3160,
  "yusbigcyrillic",
  0x046b,
  "yusbigiotifiedcyrillic",
  0x046d,
  "yuslittlecyrillic",
  0x0467,
  "yuslittleiotifiedcyrillic",
  0x0469,
  "yusmallhiragana",
  0x3085,
  "yusmallkatakana",
  0x30e5,
  "yusmallkatakanahalfwidth",
  0xff6d,
  "yuyekorean",
  0x318b,
  "yuyeokorean",
  0x318a,
  "yyabengali",
  0x09df,
  "yyadeva",
  0x095f,
  "z",
  0x007a,
  "zaarmenian",
  0x0566,
  "zacute",
  0x017a,
  "zadeva",
  0x095b,
  "zagurmukhi",
  0x0a5b,
  "zaharabic",
  0x0638,
  "zahfinalarabic",
  0xfec6,
  "zahinitialarabic",
  0xfec7,
  "zahiragana",
  0x3056,
  "zahmedialarabic",
  0xfec8,
  "zainarabic",
  0x0632,
  "zainfinalarabic",
  0xfeb0,
  "zakatakana",
  0x30b6,
  "zaqefgadolhebrew",
  0x0595,
  "zaqefqatanhebrew",
  0x0594,
  "zarqahebrew",
  0x0598,
  "zayin",
  0x05d6,
  "zayindagesh",
  0xfb36,
  "zayindageshhebrew",
  0xfb36,
  "zayinhebrew",
  0x05d6,
  "zbopomofo",
  0x3117,
  "zcaron",
  0x017e,
  "zcircle",
  0x24e9,
  "zcircumflex",
  0x1e91,
  "zcurl",
  0x0291,
  "zdot",
  0x017c,
  "zdotaccent",
  0x017c,
  "zdotbelow",
  0x1e93,
  "zecyrillic",
  0x0437,
  "zedescendercyrillic",
  0x0499,
  "zedieresiscyrillic",
  0x04df,
  "zehiragana",
  0x305c,
  "zekatakana",
  0x30bc,
  "zero",
  0x0030,
  "zeroarabic",
  0x0660,
  "zerobengali",
  0x09e6,
  "zerodeva",
  0x0966,
  "zerogujarati",
  0x0ae6,
  "zerogurmukhi",
  0x0a66,
  "zerohackarabic",
  0x0660,
  "zeroinferior",
  0x2080,
  "zeromonospace",
  0xff10,
  "zerooldstyle",
  0xf730,
  "zeropersian",
  0x06f0,
  "zerosuperior",
  0x2070,
  "zerothai",
  0x0e50,
  "zerowidthjoiner",
  0xfeff,
  "zerowidthnonjoiner",
  0x200c,
  "zerowidthspace",
  0x200b,
  "zeta",
  0x03b6,
  "zhbopomofo",
  0x3113,
  "zhearmenian",
  0x056a,
  "zhebrevecyrillic",
  0x04c2,
  "zhecyrillic",
  0x0436,
  "zhedescendercyrillic",
  0x0497,
  "zhedieresiscyrillic",
  0x04dd,
  "zihiragana",
  0x3058,
  "zikatakana",
  0x30b8,
  "zinorhebrew",
  0x05ae,
  "zlinebelow",
  0x1e95,
  "zmonospace",
  0xff5a,
  "zohiragana",
  0x305e,
  "zokatakana",
  0x30be,
  "zparen",
  0x24b5,
  "zretroflexhook",
  0x0290,
  "zstroke",
  0x01b6,
  "zuhiragana",
  0x305a,
  "zukatakana",
  0x30ba,
  ".notdef",
  0x0000,
  "angbracketleftbig",
  0x2329,
  "angbracketleftBig",
  0x2329,
  "angbracketleftbigg",
  0x2329,
  "angbracketleftBigg",
  0x2329,
  "angbracketrightBig",
  0x232a,
  "angbracketrightbig",
  0x232a,
  "angbracketrightBigg",
  0x232a,
  "angbracketrightbigg",
  0x232a,
  "arrowhookleft",
  0x21aa,
  "arrowhookright",
  0x21a9,
  "arrowlefttophalf",
  0x21bc,
  "arrowleftbothalf",
  0x21bd,
  "arrownortheast",
  0x2197,
  "arrownorthwest",
  0x2196,
  "arrowrighttophalf",
  0x21c0,
  "arrowrightbothalf",
  0x21c1,
  "arrowsoutheast",
  0x2198,
  "arrowsouthwest",
  0x2199,
  "backslashbig",
  0x2216,
  "backslashBig",
  0x2216,
  "backslashBigg",
  0x2216,
  "backslashbigg",
  0x2216,
  "bardbl",
  0x2016,
  "bracehtipdownleft",
  0xfe37,
  "bracehtipdownright",
  0xfe37,
  "bracehtipupleft",
  0xfe38,
  "bracehtipupright",
  0xfe38,
  "braceleftBig",
  0x007b,
  "braceleftbig",
  0x007b,
  "braceleftbigg",
  0x007b,
  "braceleftBigg",
  0x007b,
  "bracerightBig",
  0x007d,
  "bracerightbig",
  0x007d,
  "bracerightbigg",
  0x007d,
  "bracerightBigg",
  0x007d,
  "bracketleftbig",
  0x005b,
  "bracketleftBig",
  0x005b,
  "bracketleftbigg",
  0x005b,
  "bracketleftBigg",
  0x005b,
  "bracketrightBig",
  0x005d,
  "bracketrightbig",
  0x005d,
  "bracketrightbigg",
  0x005d,
  "bracketrightBigg",
  0x005d,
  "ceilingleftbig",
  0x2308,
  "ceilingleftBig",
  0x2308,
  "ceilingleftBigg",
  0x2308,
  "ceilingleftbigg",
  0x2308,
  "ceilingrightbig",
  0x2309,
  "ceilingrightBig",
  0x2309,
  "ceilingrightbigg",
  0x2309,
  "ceilingrightBigg",
  0x2309,
  "circledotdisplay",
  0x2299,
  "circledottext",
  0x2299,
  "circlemultiplydisplay",
  0x2297,
  "circlemultiplytext",
  0x2297,
  "circleplusdisplay",
  0x2295,
  "circleplustext",
  0x2295,
  "contintegraldisplay",
  0x222e,
  "contintegraltext",
  0x222e,
  "coproductdisplay",
  0x2210,
  "coproducttext",
  0x2210,
  "floorleftBig",
  0x230a,
  "floorleftbig",
  0x230a,
  "floorleftbigg",
  0x230a,
  "floorleftBigg",
  0x230a,
  "floorrightbig",
  0x230b,
  "floorrightBig",
  0x230b,
  "floorrightBigg",
  0x230b,
  "floorrightbigg",
  0x230b,
  "hatwide",
  0x0302,
  "hatwider",
  0x0302,
  "hatwidest",
  0x0302,
  "intercal",
  0x1d40,
  "integraldisplay",
  0x222b,
  "integraltext",
  0x222b,
  "intersectiondisplay",
  0x22c2,
  "intersectiontext",
  0x22c2,
  "logicalanddisplay",
  0x2227,
  "logicalandtext",
  0x2227,
  "logicalordisplay",
  0x2228,
  "logicalortext",
  0x2228,
  "parenleftBig",
  0x0028,
  "parenleftbig",
  0x0028,
  "parenleftBigg",
  0x0028,
  "parenleftbigg",
  0x0028,
  "parenrightBig",
  0x0029,
  "parenrightbig",
  0x0029,
  "parenrightBigg",
  0x0029,
  "parenrightbigg",
  0x0029,
  "prime",
  0x2032,
  "productdisplay",
  0x220f,
  "producttext",
  0x220f,
  "radicalbig",
  0x221a,
  "radicalBig",
  0x221a,
  "radicalBigg",
  0x221a,
  "radicalbigg",
  0x221a,
  "radicalbt",
  0x221a,
  "radicaltp",
  0x221a,
  "radicalvertex",
  0x221a,
  "slashbig",
  0x002f,
  "slashBig",
  0x002f,
  "slashBigg",
  0x002f,
  "slashbigg",
  0x002f,
  "summationdisplay",
  0x2211,
  "summationtext",
  0x2211,
  "tildewide",
  0x02dc,
  "tildewider",
  0x02dc,
  "tildewidest",
  0x02dc,
  "uniondisplay",
  0x22c3,
  "unionmultidisplay",
  0x228e,
  "unionmultitext",
  0x228e,
  "unionsqdisplay",
  0x2294,
  "unionsqtext",
  0x2294,
  "uniontext",
  0x22c3,
  "vextenddouble",
  0x2225,
  "vextendsingle",
  0x2223
 ];
});
const getDingbatsGlyphsUnicode = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getArrayLookupTableFactory)(function () {
 return [
  "space",
  0x0020,
  "a1",
  0x2701,
  "a2",
  0x2702,
  "a202",
  0x2703,
  "a3",
  0x2704,
  "a4",
  0x260e,
  "a5",
  0x2706,
  "a119",
  0x2707,
  "a118",
  0x2708,
  "a117",
  0x2709,
  "a11",
  0x261b,
  "a12",
  0x261e,
  "a13",
  0x270c,
  "a14",
  0x270d,
  "a15",
  0x270e,
  "a16",
  0x270f,
  "a105",
  0x2710,
  "a17",
  0x2711,
  "a18",
  0x2712,
  "a19",
  0x2713,
  "a20",
  0x2714,
  "a21",
  0x2715,
  "a22",
  0x2716,
  "a23",
  0x2717,
  "a24",
  0x2718,
  "a25",
  0x2719,
  "a26",
  0x271a,
  "a27",
  0x271b,
  "a28",
  0x271c,
  "a6",
  0x271d,
  "a7",
  0x271e,
  "a8",
  0x271f,
  "a9",
  0x2720,
  "a10",
  0x2721,
  "a29",
  0x2722,
  "a30",
  0x2723,
  "a31",
  0x2724,
  "a32",
  0x2725,
  "a33",
  0x2726,
  "a34",
  0x2727,
  "a35",
  0x2605,
  "a36",
  0x2729,
  "a37",
  0x272a,
  "a38",
  0x272b,
  "a39",
  0x272c,
  "a40",
  0x272d,
  "a41",
  0x272e,
  "a42",
  0x272f,
  "a43",
  0x2730,
  "a44",
  0x2731,
  "a45",
  0x2732,
  "a46",
  0x2733,
  "a47",
  0x2734,
  "a48",
  0x2735,
  "a49",
  0x2736,
  "a50",
  0x2737,
  "a51",
  0x2738,
  "a52",
  0x2739,
  "a53",
  0x273a,
  "a54",
  0x273b,
  "a55",
  0x273c,
  "a56",
  0x273d,
  "a57",
  0x273e,
  "a58",
  0x273f,
  "a59",
  0x2740,
  "a60",
  0x2741,
  "a61",
  0x2742,
  "a62",
  0x2743,
  "a63",
  0x2744,
  "a64",
  0x2745,
  "a65",
  0x2746,
  "a66",
  0x2747,
  "a67",
  0x2748,
  "a68",
  0x2749,
  "a69",
  0x274a,
  "a70",
  0x274b,
  "a71",
  0x25cf,
  "a72",
  0x274d,
  "a73",
  0x25a0,
  "a74",
  0x274f,
  "a203",
  0x2750,
  "a75",
  0x2751,
  "a204",
  0x2752,
  "a76",
  0x25b2,
  "a77",
  0x25bc,
  "a78",
  0x25c6,
  "a79",
  0x2756,
  "a81",
  0x25d7,
  "a82",
  0x2758,
  "a83",
  0x2759,
  "a84",
  0x275a,
  "a97",
  0x275b,
  "a98",
  0x275c,
  "a99",
  0x275d,
  "a100",
  0x275e,
  "a101",
  0x2761,
  "a102",
  0x2762,
  "a103",
  0x2763,
  "a104",
  0x2764,
  "a106",
  0x2765,
  "a107",
  0x2766,
  "a108",
  0x2767,
  "a112",
  0x2663,
  "a111",
  0x2666,
  "a110",
  0x2665,
  "a109",
  0x2660,
  "a120",
  0x2460,
  "a121",
  0x2461,
  "a122",
  0x2462,
  "a123",
  0x2463,
  "a124",
  0x2464,
  "a125",
  0x2465,
  "a126",
  0x2466,
  "a127",
  0x2467,
  "a128",
  0x2468,
  "a129",
  0x2469,
  "a130",
  0x2776,
  "a131",
  0x2777,
  "a132",
  0x2778,
  "a133",
  0x2779,
  "a134",
  0x277a,
  "a135",
  0x277b,
  "a136",
  0x277c,
  "a137",
  0x277d,
  "a138",
  0x277e,
  "a139",
  0x277f,
  "a140",
  0x2780,
  "a141",
  0x2781,
  "a142",
  0x2782,
  "a143",
  0x2783,
  "a144",
  0x2784,
  "a145",
  0x2785,
  "a146",
  0x2786,
  "a147",
  0x2787,
  "a148",
  0x2788,
  "a149",
  0x2789,
  "a150",
  0x278a,
  "a151",
  0x278b,
  "a152",
  0x278c,
  "a153",
  0x278d,
  "a154",
  0x278e,
  "a155",
  0x278f,
  "a156",
  0x2790,
  "a157",
  0x2791,
  "a158",
  0x2792,
  "a159",
  0x2793,
  "a160",
  0x2794,
  "a161",
  0x2192,
  "a163",
  0x2194,
  "a164",
  0x2195,
  "a196",
  0x2798,
  "a165",
  0x2799,
  "a192",
  0x279a,
  "a166",
  0x279b,
  "a167",
  0x279c,
  "a168",
  0x279d,
  "a169",
  0x279e,
  "a170",
  0x279f,
  "a171",
  0x27a0,
  "a172",
  0x27a1,
  "a173",
  0x27a2,
  "a162",
  0x27a3,
  "a174",
  0x27a4,
  "a175",
  0x27a5,
  "a176",
  0x27a6,
  "a177",
  0x27a7,
  "a178",
  0x27a8,
  "a179",
  0x27a9,
  "a193",
  0x27aa,
  "a180",
  0x27ab,
  "a199",
  0x27ac,
  "a181",
  0x27ad,
  "a200",
  0x27ae,
  "a182",
  0x27af,
  "a201",
  0x27b1,
  "a183",
  0x27b2,
  "a184",
  0x27b3,
  "a197",
  0x27b4,
  "a185",
  0x27b5,
  "a194",
  0x27b6,
  "a198",
  0x27b7,
  "a186",
  0x27b8,
  "a195",
  0x27b9,
  "a187",
  0x27ba,
  "a188",
  0x27bb,
  "a189",
  0x27bc,
  "a190",
  0x27bd,
  "a191",
  0x27be,
  "a89",
  0x2768,
  "a90",
  0x2769,
  "a93",
  0x276a,
  "a94",
  0x276b,
  "a91",
  0x276c,
  "a92",
  0x276d,
  "a205",
  0x276e,
  "a85",
  0x276f,
  "a206",
  0x2770,
  "a86",
  0x2771,
  "a87",
  0x2772,
  "a88",
  0x2773,
  "a95",
  0x2774,
  "a96",
  0x2775,
  ".notdef",
  0x0000
 ];
});


/***/ }),
/* 21 */
/***/ ((__unused_webpack_module, __webpack_exports__, __w_pdfjs_require__) => {

__w_pdfjs_require__.r(__webpack_exports__);
/* harmony export */ __w_pdfjs_require__.d(__webpack_exports__, {
/* harmony export */   "getNormalizedUnicodes": () => (/* binding */ getNormalizedUnicodes),
/* harmony export */   "getUnicodeForGlyph": () => (/* binding */ getUnicodeForGlyph),
/* harmony export */   "getUnicodeRangeFor": () => (/* binding */ getUnicodeRangeFor),
/* harmony export */   "mapSpecialUnicodeValues": () => (/* binding */ mapSpecialUnicodeValues),
/* harmony export */   "reverseIfRtl": () => (/* binding */ reverseIfRtl)
/* harmony export */ });
/* harmony import */ var _core_utils_js__WEBPACK_IMPORTED_MODULE_0__ = __w_pdfjs_require__(9);

const getSpecialPUASymbols = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getLookupTableFactory)(function (t) {
 t[63721] = 0x00a9;
 t[63193] = 0x00a9;
 t[63720] = 0x00ae;
 t[63194] = 0x00ae;
 t[63722] = 0x2122;
 t[63195] = 0x2122;
 t[63729] = 0x23a7;
 t[63730] = 0x23a8;
 t[63731] = 0x23a9;
 t[63740] = 0x23ab;
 t[63741] = 0x23ac;
 t[63742] = 0x23ad;
 t[63726] = 0x23a1;
 t[63727] = 0x23a2;
 t[63728] = 0x23a3;
 t[63737] = 0x23a4;
 t[63738] = 0x23a5;
 t[63739] = 0x23a6;
 t[63723] = 0x239b;
 t[63724] = 0x239c;
 t[63725] = 0x239d;
 t[63734] = 0x239e;
 t[63735] = 0x239f;
 t[63736] = 0x23a0;
});
function mapSpecialUnicodeValues(code) {
 if (code >= 0xfff0 && code <= 0xffff) {
  return 0;
 } else if (code >= 0xf600 && code <= 0xf8ff) {
  return getSpecialPUASymbols()[code] || code;
 } else if (code === 0x00ad) {
  return 0x002d;
 }
 return code;
}
function getUnicodeForGlyph(name, glyphsUnicodeMap) {
 let unicode = glyphsUnicodeMap[name];
 if (unicode !== undefined) {
  return unicode;
 }
 if (!name) {
  return -1;
 }
 if (name[0] === "u") {
  const nameLen = name.length;
  let hexStr;
  if (nameLen === 7 && name[1] === "n" && name[2] === "i") {
   hexStr = name.substring(3);
  } else if (nameLen >= 5 && nameLen <= 7) {
   hexStr = name.substring(1);
  } else {
   return -1;
  }
  if (hexStr === hexStr.toUpperCase()) {
   unicode = parseInt(hexStr, 16);
   if (unicode >= 0) {
    return unicode;
   }
  }
 }
 return -1;
}
const UnicodeRanges = [
 {
  begin: 0x0000,
  end: 0x007f
 },
 {
  begin: 0x0080,
  end: 0x00ff
 },
 {
  begin: 0x0100,
  end: 0x017f
 },
 {
  begin: 0x0180,
  end: 0x024f
 },
 {
  begin: 0x0250,
  end: 0x02af
 },
 {
  begin: 0x02b0,
  end: 0x02ff
 },
 {
  begin: 0x0300,
  end: 0x036f
 },
 {
  begin: 0x0370,
  end: 0x03ff
 },
 {
  begin: 0x2c80,
  end: 0x2cff
 },
 {
  begin: 0x0400,
  end: 0x04ff
 },
 {
  begin: 0x0530,
  end: 0x058f
 },
 {
  begin: 0x0590,
  end: 0x05ff
 },
 {
  begin: 0xa500,
  end: 0xa63f
 },
 {
  begin: 0x0600,
  end: 0x06ff
 },
 {
  begin: 0x07c0,
  end: 0x07ff
 },
 {
  begin: 0x0900,
  end: 0x097f
 },
 {
  begin: 0x0980,
  end: 0x09ff
 },
 {
  begin: 0x0a00,
  end: 0x0a7f
 },
 {
  begin: 0x0a80,
  end: 0x0aff
 },
 {
  begin: 0x0b00,
  end: 0x0b7f
 },
 {
  begin: 0x0b80,
  end: 0x0bff
 },
 {
  begin: 0x0c00,
  end: 0x0c7f
 },
 {
  begin: 0x0c80,
  end: 0x0cff
 },
 {
  begin: 0x0d00,
  end: 0x0d7f
 },
 {
  begin: 0x0e00,
  end: 0x0e7f
 },
 {
  begin: 0x0e80,
  end: 0x0eff
 },
 {
  begin: 0x10a0,
  end: 0x10ff
 },
 {
  begin: 0x1b00,
  end: 0x1b7f
 },
 {
  begin: 0x1100,
  end: 0x11ff
 },
 {
  begin: 0x1e00,
  end: 0x1eff
 },
 {
  begin: 0x1f00,
  end: 0x1fff
 },
 {
  begin: 0x2000,
  end: 0x206f
 },
 {
  begin: 0x2070,
  end: 0x209f
 },
 {
  begin: 0x20a0,
  end: 0x20cf
 },
 {
  begin: 0x20d0,
  end: 0x20ff
 },
 {
  begin: 0x2100,
  end: 0x214f
 },
 {
  begin: 0x2150,
  end: 0x218f
 },
 {
  begin: 0x2190,
  end: 0x21ff
 },
 {
  begin: 0x2200,
  end: 0x22ff
 },
 {
  begin: 0x2300,
  end: 0x23ff
 },
 {
  begin: 0x2400,
  end: 0x243f
 },
 {
  begin: 0x2440,
  end: 0x245f
 },
 {
  begin: 0x2460,
  end: 0x24ff
 },
 {
  begin: 0x2500,
  end: 0x257f
 },
 {
  begin: 0x2580,
  end: 0x259f
 },
 {
  begin: 0x25a0,
  end: 0x25ff
 },
 {
  begin: 0x2600,
  end: 0x26ff
 },
 {
  begin: 0x2700,
  end: 0x27bf
 },
 {
  begin: 0x3000,
  end: 0x303f
 },
 {
  begin: 0x3040,
  end: 0x309f
 },
 {
  begin: 0x30a0,
  end: 0x30ff
 },
 {
  begin: 0x3100,
  end: 0x312f
 },
 {
  begin: 0x3130,
  end: 0x318f
 },
 {
  begin: 0xa840,
  end: 0xa87f
 },
 {
  begin: 0x3200,
  end: 0x32ff
 },
 {
  begin: 0x3300,
  end: 0x33ff
 },
 {
  begin: 0xac00,
  end: 0xd7af
 },
 {
  begin: 0xd800,
  end: 0xdfff
 },
 {
  begin: 0x10900,
  end: 0x1091f
 },
 {
  begin: 0x4e00,
  end: 0x9fff
 },
 {
  begin: 0xe000,
  end: 0xf8ff
 },
 {
  begin: 0x31c0,
  end: 0x31ef
 },
 {
  begin: 0xfb00,
  end: 0xfb4f
 },
 {
  begin: 0xfb50,
  end: 0xfdff
 },
 {
  begin: 0xfe20,
  end: 0xfe2f
 },
 {
  begin: 0xfe10,
  end: 0xfe1f
 },
 {
  begin: 0xfe50,
  end: 0xfe6f
 },
 {
  begin: 0xfe70,
  end: 0xfeff
 },
 {
  begin: 0xff00,
  end: 0xffef
 },
 {
  begin: 0xfff0,
  end: 0xffff
 },
 {
  begin: 0x0f00,
  end: 0x0fff
 },
 {
  begin: 0x0700,
  end: 0x074f
 },
 {
  begin: 0x0780,
  end: 0x07bf
 },
 {
  begin: 0x0d80,
  end: 0x0dff
 },
 {
  begin: 0x1000,
  end: 0x109f
 },
 {
  begin: 0x1200,
  end: 0x137f
 },
 {
  begin: 0x13a0,
  end: 0x13ff
 },
 {
  begin: 0x1400,
  end: 0x167f
 },
 {
  begin: 0x1680,
  end: 0x169f
 },
 {
  begin: 0x16a0,
  end: 0x16ff
 },
 {
  begin: 0x1780,
  end: 0x17ff
 },
 {
  begin: 0x1800,
  end: 0x18af
 },
 {
  begin: 0x2800,
  end: 0x28ff
 },
 {
  begin: 0xa000,
  end: 0xa48f
 },
 {
  begin: 0x1700,
  end: 0x171f
 },
 {
  begin: 0x10300,
  end: 0x1032f
 },
 {
  begin: 0x10330,
  end: 0x1034f
 },
 {
  begin: 0x10400,
  end: 0x1044f
 },
 {
  begin: 0x1d000,
  end: 0x1d0ff
 },
 {
  begin: 0x1d400,
  end: 0x1d7ff
 },
 {
  begin: 0xff000,
  end: 0xffffd
 },
 {
  begin: 0xfe00,
  end: 0xfe0f
 },
 {
  begin: 0xe0000,
  end: 0xe007f
 },
 {
  begin: 0x1900,
  end: 0x194f
 },
 {
  begin: 0x1950,
  end: 0x197f
 },
 {
  begin: 0x1980,
  end: 0x19df
 },
 {
  begin: 0x1a00,
  end: 0x1a1f
 },
 {
  begin: 0x2c00,
  end: 0x2c5f
 },
 {
  begin: 0x2d30,
  end: 0x2d7f
 },
 {
  begin: 0x4dc0,
  end: 0x4dff
 },
 {
  begin: 0xa800,
  end: 0xa82f
 },
 {
  begin: 0x10000,
  end: 0x1007f
 },
 {
  begin: 0x10140,
  end: 0x1018f
 },
 {
  begin: 0x10380,
  end: 0x1039f
 },
 {
  begin: 0x103a0,
  end: 0x103df
 },
 {
  begin: 0x10450,
  end: 0x1047f
 },
 {
  begin: 0x10480,
  end: 0x104af
 },
 {
  begin: 0x10800,
  end: 0x1083f
 },
 {
  begin: 0x10a00,
  end: 0x10a5f
 },
 {
  begin: 0x1d300,
  end: 0x1d35f
 },
 {
  begin: 0x12000,
  end: 0x123ff
 },
 {
  begin: 0x1d360,
  end: 0x1d37f
 },
 {
  begin: 0x1b80,
  end: 0x1bbf
 },
 {
  begin: 0x1c00,
  end: 0x1c4f
 },
 {
  begin: 0x1c50,
  end: 0x1c7f
 },
 {
  begin: 0xa880,
  end: 0xa8df
 },
 {
  begin: 0xa900,
  end: 0xa92f
 },
 {
  begin: 0xa930,
  end: 0xa95f
 },
 {
  begin: 0xaa00,
  end: 0xaa5f
 },
 {
  begin: 0x10190,
  end: 0x101cf
 },
 {
  begin: 0x101d0,
  end: 0x101ff
 },
 {
  begin: 0x102a0,
  end: 0x102df
 },
 {
  begin: 0x1f030,
  end: 0x1f09f
 }
];
function getUnicodeRangeFor(value) {
 for (let i = 0, ii = UnicodeRanges.length; i < ii; i++) {
  const range = UnicodeRanges[i];
  if (value >= range.begin && value < range.end) {
   return i;
  }
 }
 return -1;
}
function isRTLRangeFor(value) {
 let range = UnicodeRanges[13];
 if (value >= range.begin && value < range.end) {
  return true;
 }
 range = UnicodeRanges[11];
 if (value >= range.begin && value < range.end) {
  return true;
 }
 return false;
}
const getNormalizedUnicodes = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getArrayLookupTableFactory)(function () {
 return [
  "\u00A8",
  "\u0020\u0308",
  "\u00AF",
  "\u0020\u0304",
  "\u00B4",
  "\u0020\u0301",
  "\u00B5",
  "\u03BC",
  "\u00B8",
  "\u0020\u0327",
  "\u0132",
  "\u0049\u004A",
  "\u0133",
  "\u0069\u006A",
  "\u013F",
  "\u004C\u00B7",
  "\u0140",
  "\u006C\u00B7",
  "\u0149",
  "\u02BC\u006E",
  "\u017F",
  "\u0073",
  "\u01C4",
  "\u0044\u017D",
  "\u01C5",
  "\u0044\u017E",
  "\u01C6",
  "\u0064\u017E",
  "\u01C7",
  "\u004C\u004A",
  "\u01C8",
  "\u004C\u006A",
  "\u01C9",
  "\u006C\u006A",
  "\u01CA",
  "\u004E\u004A",
  "\u01CB",
  "\u004E\u006A",
  "\u01CC",
  "\u006E\u006A",
  "\u01F1",
  "\u0044\u005A",
  "\u01F2",
  "\u0044\u007A",
  "\u01F3",
  "\u0064\u007A",
  "\u02D8",
  "\u0020\u0306",
  "\u02D9",
  "\u0020\u0307",
  "\u02DA",
  "\u0020\u030A",
  "\u02DB",
  "\u0020\u0328",
  "\u02DC",
  "\u0020\u0303",
  "\u02DD",
  "\u0020\u030B",
  "\u037A",
  "\u0020\u0345",
  "\u0384",
  "\u0020\u0301",
  "\u03D0",
  "\u03B2",
  "\u03D1",
  "\u03B8",
  "\u03D2",
  "\u03A5",
  "\u03D5",
  "\u03C6",
  "\u03D6",
  "\u03C0",
  "\u03F0",
  "\u03BA",
  "\u03F1",
  "\u03C1",
  "\u03F2",
  "\u03C2",
  "\u03F4",
  "\u0398",
  "\u03F5",
  "\u03B5",
  "\u03F9",
  "\u03A3",
  "\u0587",
  "\u0565\u0582",
  "\u0675",
  "\u0627\u0674",
  "\u0676",
  "\u0648\u0674",
  "\u0677",
  "\u06C7\u0674",
  "\u0678",
  "\u064A\u0674",
  "\u0E33",
  "\u0E4D\u0E32",
  "\u0EB3",
  "\u0ECD\u0EB2",
  "\u0EDC",
  "\u0EAB\u0E99",
  "\u0EDD",
  "\u0EAB\u0EA1",
  "\u0F77",
  "\u0FB2\u0F81",
  "\u0F79",
  "\u0FB3\u0F81",
  "\u1E9A",
  "\u0061\u02BE",
  "\u1FBD",
  "\u0020\u0313",
  "\u1FBF",
  "\u0020\u0313",
  "\u1FC0",
  "\u0020\u0342",
  "\u1FFE",
  "\u0020\u0314",
  "\u2002",
  "\u0020",
  "\u2003",
  "\u0020",
  "\u2004",
  "\u0020",
  "\u2005",
  "\u0020",
  "\u2006",
  "\u0020",
  "\u2008",
  "\u0020",
  "\u2009",
  "\u0020",
  "\u200A",
  "\u0020",
  "\u2017",
  "\u0020\u0333",
  "\u2024",
  "\u002E",
  "\u2025",
  "\u002E\u002E",
  "\u2026",
  "\u002E\u002E\u002E",
  "\u2033",
  "\u2032\u2032",
  "\u2034",
  "\u2032\u2032\u2032",
  "\u2036",
  "\u2035\u2035",
  "\u2037",
  "\u2035\u2035\u2035",
  "\u203C",
  "\u0021\u0021",
  "\u203E",
  "\u0020\u0305",
  "\u2047",
  "\u003F\u003F",
  "\u2048",
  "\u003F\u0021",
  "\u2049",
  "\u0021\u003F",
  "\u2057",
  "\u2032\u2032\u2032\u2032",
  "\u205F",
  "\u0020",
  "\u20A8",
  "\u0052\u0073",
  "\u2100",
  "\u0061\u002F\u0063",
  "\u2101",
  "\u0061\u002F\u0073",
  "\u2103",
  "\u00B0\u0043",
  "\u2105",
  "\u0063\u002F\u006F",
  "\u2106",
  "\u0063\u002F\u0075",
  "\u2107",
  "\u0190",
  "\u2109",
  "\u00B0\u0046",
  "\u2116",
  "\u004E\u006F",
  "\u2121",
  "\u0054\u0045\u004C",
  "\u2135",
  "\u05D0",
  "\u2136",
  "\u05D1",
  "\u2137",
  "\u05D2",
  "\u2138",
  "\u05D3",
  "\u213B",
  "\u0046\u0041\u0058",
  "\u2160",
  "\u0049",
  "\u2161",
  "\u0049\u0049",
  "\u2162",
  "\u0049\u0049\u0049",
  "\u2163",
  "\u0049\u0056",
  "\u2164",
  "\u0056",
  "\u2165",
  "\u0056\u0049",
  "\u2166",
  "\u0056\u0049\u0049",
  "\u2167",
  "\u0056\u0049\u0049\u0049",
  "\u2168",
  "\u0049\u0058",
  "\u2169",
  "\u0058",
  "\u216A",
  "\u0058\u0049",
  "\u216B",
  "\u0058\u0049\u0049",
  "\u216C",
  "\u004C",
  "\u216D",
  "\u0043",
  "\u216E",
  "\u0044",
  "\u216F",
  "\u004D",
  "\u2170",
  "\u0069",
  "\u2171",
  "\u0069\u0069",
  "\u2172",
  "\u0069\u0069\u0069",
  "\u2173",
  "\u0069\u0076",
  "\u2174",
  "\u0076",
  "\u2175",
  "\u0076\u0069",
  "\u2176",
  "\u0076\u0069\u0069",
  "\u2177",
  "\u0076\u0069\u0069\u0069",
  "\u2178",
  "\u0069\u0078",
  "\u2179",
  "\u0078",
  "\u217A",
  "\u0078\u0069",
  "\u217B",
  "\u0078\u0069\u0069",
  "\u217C",
  "\u006C",
  "\u217D",
  "\u0063",
  "\u217E",
  "\u0064",
  "\u217F",
  "\u006D",
  "\u222C",
  "\u222B\u222B",
  "\u222D",
  "\u222B\u222B\u222B",
  "\u222F",
  "\u222E\u222E",
  "\u2230",
  "\u222E\u222E\u222E",
  "\u2474",
  "\u0028\u0031\u0029",
  "\u2475",
  "\u0028\u0032\u0029",
  "\u2476",
  "\u0028\u0033\u0029",
  "\u2477",
  "\u0028\u0034\u0029",
  "\u2478",
  "\u0028\u0035\u0029",
  "\u2479",
  "\u0028\u0036\u0029",
  "\u247A",
  "\u0028\u0037\u0029",
  "\u247B",
  "\u0028\u0038\u0029",
  "\u247C",
  "\u0028\u0039\u0029",
  "\u247D",
  "\u0028\u0031\u0030\u0029",
  "\u247E",
  "\u0028\u0031\u0031\u0029",
  "\u247F",
  "\u0028\u0031\u0032\u0029",
  "\u2480",
  "\u0028\u0031\u0033\u0029",
  "\u2481",
  "\u0028\u0031\u0034\u0029",
  "\u2482",
  "\u0028\u0031\u0035\u0029",
  "\u2483",
  "\u0028\u0031\u0036\u0029",
  "\u2484",
  "\u0028\u0031\u0037\u0029",
  "\u2485",
  "\u0028\u0031\u0038\u0029",
  "\u2486",
  "\u0028\u0031\u0039\u0029",
  "\u2487",
  "\u0028\u0032\u0030\u0029",
  "\u2488",
  "\u0031\u002E",
  "\u2489",
  "\u0032\u002E",
  "\u248A",
  "\u0033\u002E",
  "\u248B",
  "\u0034\u002E",
  "\u248C",
  "\u0035\u002E",
  "\u248D",
  "\u0036\u002E",
  "\u248E",
  "\u0037\u002E",
  "\u248F",
  "\u0038\u002E",
  "\u2490",
  "\u0039\u002E",
  "\u2491",
  "\u0031\u0030\u002E",
  "\u2492",
  "\u0031\u0031\u002E",
  "\u2493",
  "\u0031\u0032\u002E",
  "\u2494",
  "\u0031\u0033\u002E",
  "\u2495",
  "\u0031\u0034\u002E",
  "\u2496",
  "\u0031\u0035\u002E",
  "\u2497",
  "\u0031\u0036\u002E",
  "\u2498",
  "\u0031\u0037\u002E",
  "\u2499",
  "\u0031\u0038\u002E",
  "\u249A",
  "\u0031\u0039\u002E",
  "\u249B",
  "\u0032\u0030\u002E",
  "\u249C",
  "\u0028\u0061\u0029",
  "\u249D",
  "\u0028\u0062\u0029",
  "\u249E",
  "\u0028\u0063\u0029",
  "\u249F",
  "\u0028\u0064\u0029",
  "\u24A0",
  "\u0028\u0065\u0029",
  "\u24A1",
  "\u0028\u0066\u0029",
  "\u24A2",
  "\u0028\u0067\u0029",
  "\u24A3",
  "\u0028\u0068\u0029",
  "\u24A4",
  "\u0028\u0069\u0029",
  "\u24A5",
  "\u0028\u006A\u0029",
  "\u24A6",
  "\u0028\u006B\u0029",
  "\u24A7",
  "\u0028\u006C\u0029",
  "\u24A8",
  "\u0028\u006D\u0029",
  "\u24A9",
  "\u0028\u006E\u0029",
  "\u24AA",
  "\u0028\u006F\u0029",
  "\u24AB",
  "\u0028\u0070\u0029",
  "\u24AC",
  "\u0028\u0071\u0029",
  "\u24AD",
  "\u0028\u0072\u0029",
  "\u24AE",
  "\u0028\u0073\u0029",
  "\u24AF",
  "\u0028\u0074\u0029",
  "\u24B0",
  "\u0028\u0075\u0029",
  "\u24B1",
  "\u0028\u0076\u0029",
  "\u24B2",
  "\u0028\u0077\u0029",
  "\u24B3",
  "\u0028\u0078\u0029",
  "\u24B4",
  "\u0028\u0079\u0029",
  "\u24B5",
  "\u0028\u007A\u0029",
  "\u2A0C",
  "\u222B\u222B\u222B\u222B",
  "\u2A74",
  "\u003A\u003A\u003D",
  "\u2A75",
  "\u003D\u003D",
  "\u2A76",
  "\u003D\u003D\u003D",
  "\u2E9F",
  "\u6BCD",
  "\u2EF3",
  "\u9F9F",
  "\u2F00",
  "\u4E00",
  "\u2F01",
  "\u4E28",
  "\u2F02",
  "\u4E36",
  "\u2F03",
  "\u4E3F",
  "\u2F04",
  "\u4E59",
  "\u2F05",
  "\u4E85",
  "\u2F06",
  "\u4E8C",
  "\u2F07",
  "\u4EA0",
  "\u2F08",
  "\u4EBA",
  "\u2F09",
  "\u513F",
  "\u2F0A",
  "\u5165",
  "\u2F0B",
  "\u516B",
  "\u2F0C",
  "\u5182",
  "\u2F0D",
  "\u5196",
  "\u2F0E",
  "\u51AB",
  "\u2F0F",
  "\u51E0",
  "\u2F10",
  "\u51F5",
  "\u2F11",
  "\u5200",
  "\u2F12",
  "\u529B",
  "\u2F13",
  "\u52F9",
  "\u2F14",
  "\u5315",
  "\u2F15",
  "\u531A",
  "\u2F16",
  "\u5338",
  "\u2F17",
  "\u5341",
  "\u2F18",
  "\u535C",
  "\u2F19",
  "\u5369",
  "\u2F1A",
  "\u5382",
  "\u2F1B",
  "\u53B6",
  "\u2F1C",
  "\u53C8",
  "\u2F1D",
  "\u53E3",
  "\u2F1E",
  "\u56D7",
  "\u2F1F",
  "\u571F",
  "\u2F20",
  "\u58EB",
  "\u2F21",
  "\u5902",
  "\u2F22",
  "\u590A",
  "\u2F23",
  "\u5915",
  "\u2F24",
  "\u5927",
  "\u2F25",
  "\u5973",
  "\u2F26",
  "\u5B50",
  "\u2F27",
  "\u5B80",
  "\u2F28",
  "\u5BF8",
  "\u2F29",
  "\u5C0F",
  "\u2F2A",
  "\u5C22",
  "\u2F2B",
  "\u5C38",
  "\u2F2C",
  "\u5C6E",
  "\u2F2D",
  "\u5C71",
  "\u2F2E",
  "\u5DDB",
  "\u2F2F",
  "\u5DE5",
  "\u2F30",
  "\u5DF1",
  "\u2F31",
  "\u5DFE",
  "\u2F32",
  "\u5E72",
  "\u2F33",
  "\u5E7A",
  "\u2F34",
  "\u5E7F",
  "\u2F35",
  "\u5EF4",
  "\u2F36",
  "\u5EFE",
  "\u2F37",
  "\u5F0B",
  "\u2F38",
  "\u5F13",
  "\u2F39",
  "\u5F50",
  "\u2F3A",
  "\u5F61",
  "\u2F3B",
  "\u5F73",
  "\u2F3C",
  "\u5FC3",
  "\u2F3D",
  "\u6208",
  "\u2F3E",
  "\u6236",
  "\u2F3F",
  "\u624B",
  "\u2F40",
  "\u652F",
  "\u2F41",
  "\u6534",
  "\u2F42",
  "\u6587",
  "\u2F43",
  "\u6597",
  "\u2F44",
  "\u65A4",
  "\u2F45",
  "\u65B9",
  "\u2F46",
  "\u65E0",
  "\u2F47",
  "\u65E5",
  "\u2F48",
  "\u66F0",
  "\u2F49",
  "\u6708",
  "\u2F4A",
  "\u6728",
  "\u2F4B",
  "\u6B20",
  "\u2F4C",
  "\u6B62",
  "\u2F4D",
  "\u6B79",
  "\u2F4E",
  "\u6BB3",
  "\u2F4F",
  "\u6BCB",
  "\u2F50",
  "\u6BD4",
  "\u2F51",
  "\u6BDB",
  "\u2F52",
  "\u6C0F",
  "\u2F53",
  "\u6C14",
  "\u2F54",
  "\u6C34",
  "\u2F55",
  "\u706B",
  "\u2F56",
  "\u722A",
  "\u2F57",
  "\u7236",
  "\u2F58",
  "\u723B",
  "\u2F59",
  "\u723F",
  "\u2F5A",
  "\u7247",
  "\u2F5B",
  "\u7259",
  "\u2F5C",
  "\u725B",
  "\u2F5D",
  "\u72AC",
  "\u2F5E",
  "\u7384",
  "\u2F5F",
  "\u7389",
  "\u2F60",
  "\u74DC",
  "\u2F61",
  "\u74E6",
  "\u2F62",
  "\u7518",
  "\u2F63",
  "\u751F",
  "\u2F64",
  "\u7528",
  "\u2F65",
  "\u7530",
  "\u2F66",
  "\u758B",
  "\u2F67",
  "\u7592",
  "\u2F68",
  "\u7676",
  "\u2F69",
  "\u767D",
  "\u2F6A",
  "\u76AE",
  "\u2F6B",
  "\u76BF",
  "\u2F6C",
  "\u76EE",
  "\u2F6D",
  "\u77DB",
  "\u2F6E",
  "\u77E2",
  "\u2F6F",
  "\u77F3",
  "\u2F70",
  "\u793A",
  "\u2F71",
  "\u79B8",
  "\u2F72",
  "\u79BE",
  "\u2F73",
  "\u7A74",
  "\u2F74",
  "\u7ACB",
  "\u2F75",
  "\u7AF9",
  "\u2F76",
  "\u7C73",
  "\u2F77",
  "\u7CF8",
  "\u2F78",
  "\u7F36",
  "\u2F79",
  "\u7F51",
  "\u2F7A",
  "\u7F8A",
  "\u2F7B",
  "\u7FBD",
  "\u2F7C",
  "\u8001",
  "\u2F7D",
  "\u800C",
  "\u2F7E",
  "\u8012",
  "\u2F7F",
  "\u8033",
  "\u2F80",
  "\u807F",
  "\u2F81",
  "\u8089",
  "\u2F82",
  "\u81E3",
  "\u2F83",
  "\u81EA",
  "\u2F84",
  "\u81F3",
  "\u2F85",
  "\u81FC",
  "\u2F86",
  "\u820C",
  "\u2F87",
  "\u821B",
  "\u2F88",
  "\u821F",
  "\u2F89",
  "\u826E",
  "\u2F8A",
  "\u8272",
  "\u2F8B",
  "\u8278",
  "\u2F8C",
  "\u864D",
  "\u2F8D",
  "\u866B",
  "\u2F8E",
  "\u8840",
  "\u2F8F",
  "\u884C",
  "\u2F90",
  "\u8863",
  "\u2F91",
  "\u897E",
  "\u2F92",
  "\u898B",
  "\u2F93",
  "\u89D2",
  "\u2F94",
  "\u8A00",
  "\u2F95",
  "\u8C37",
  "\u2F96",
  "\u8C46",
  "\u2F97",
  "\u8C55",
  "\u2F98",
  "\u8C78",
  "\u2F99",
  "\u8C9D",
  "\u2F9A",
  "\u8D64",
  "\u2F9B",
  "\u8D70",
  "\u2F9C",
  "\u8DB3",
  "\u2F9D",
  "\u8EAB",
  "\u2F9E",
  "\u8ECA",
  "\u2F9F",
  "\u8F9B",
  "\u2FA0",
  "\u8FB0",
  "\u2FA1",
  "\u8FB5",
  "\u2FA2",
  "\u9091",
  "\u2FA3",
  "\u9149",
  "\u2FA4",
  "\u91C6",
  "\u2FA5",
  "\u91CC",
  "\u2FA6",
  "\u91D1",
  "\u2FA7",
  "\u9577",
  "\u2FA8",
  "\u9580",
  "\u2FA9",
  "\u961C",
  "\u2FAA",
  "\u96B6",
  "\u2FAB",
  "\u96B9",
  "\u2FAC",
  "\u96E8",
  "\u2FAD",
  "\u9751",
  "\u2FAE",
  "\u975E",
  "\u2FAF",
  "\u9762",
  "\u2FB0",
  "\u9769",
  "\u2FB1",
  "\u97CB",
  "\u2FB2",
  "\u97ED",
  "\u2FB3",
  "\u97F3",
  "\u2FB4",
  "\u9801",
  "\u2FB5",
  "\u98A8",
  "\u2FB6",
  "\u98DB",
  "\u2FB7",
  "\u98DF",
  "\u2FB8",
  "\u9996",
  "\u2FB9",
  "\u9999",
  "\u2FBA",
  "\u99AC",
  "\u2FBB",
  "\u9AA8",
  "\u2FBC",
  "\u9AD8",
  "\u2FBD",
  "\u9ADF",
  "\u2FBE",
  "\u9B25",
  "\u2FBF",
  "\u9B2F",
  "\u2FC0",
  "\u9B32",
  "\u2FC1",
  "\u9B3C",
  "\u2FC2",
  "\u9B5A",
  "\u2FC3",
  "\u9CE5",
  "\u2FC4",
  "\u9E75",
  "\u2FC5",
  "\u9E7F",
  "\u2FC6",
  "\u9EA5",
  "\u2FC7",
  "\u9EBB",
  "\u2FC8",
  "\u9EC3",
  "\u2FC9",
  "\u9ECD",
  "\u2FCA",
  "\u9ED1",
  "\u2FCB",
  "\u9EF9",
  "\u2FCC",
  "\u9EFD",
  "\u2FCD",
  "\u9F0E",
  "\u2FCE",
  "\u9F13",
  "\u2FCF",
  "\u9F20",
  "\u2FD0",
  "\u9F3B",
  "\u2FD1",
  "\u9F4A",
  "\u2FD2",
  "\u9F52",
  "\u2FD3",
  "\u9F8D",
  "\u2FD4",
  "\u9F9C",
  "\u2FD5",
  "\u9FA0",
  "\u3036",
  "\u3012",
  "\u3038",
  "\u5341",
  "\u3039",
  "\u5344",
  "\u303A",
  "\u5345",
  "\u309B",
  "\u0020\u3099",
  "\u309C",
  "\u0020\u309A",
  "\u3131",
  "\u1100",
  "\u3132",
  "\u1101",
  "\u3133",
  "\u11AA",
  "\u3134",
  "\u1102",
  "\u3135",
  "\u11AC",
  "\u3136",
  "\u11AD",
  "\u3137",
  "\u1103",
  "\u3138",
  "\u1104",
  "\u3139",
  "\u1105",
  "\u313A",
  "\u11B0",
  "\u313B",
  "\u11B1",
  "\u313C",
  "\u11B2",
  "\u313D",
  "\u11B3",
  "\u313E",
  "\u11B4",
  "\u313F",
  "\u11B5",
  "\u3140",
  "\u111A",
  "\u3141",
  "\u1106",
  "\u3142",
  "\u1107",
  "\u3143",
  "\u1108",
  "\u3144",
  "\u1121",
  "\u3145",
  "\u1109",
  "\u3146",
  "\u110A",
  "\u3147",
  "\u110B",
  "\u3148",
  "\u110C",
  "\u3149",
  "\u110D",
  "\u314A",
  "\u110E",
  "\u314B",
  "\u110F",
  "\u314C",
  "\u1110",
  "\u314D",
  "\u1111",
  "\u314E",
  "\u1112",
  "\u314F",
  "\u1161",
  "\u3150",
  "\u1162",
  "\u3151",
  "\u1163",
  "\u3152",
  "\u1164",
  "\u3153",
  "\u1165",
  "\u3154",
  "\u1166",
  "\u3155",
  "\u1167",
  "\u3156",
  "\u1168",
  "\u3157",
  "\u1169",
  "\u3158",
  "\u116A",
  "\u3159",
  "\u116B",
  "\u315A",
  "\u116C",
  "\u315B",
  "\u116D",
  "\u315C",
  "\u116E",
  "\u315D",
  "\u116F",
  "\u315E",
  "\u1170",
  "\u315F",
  "\u1171",
  "\u3160",
  "\u1172",
  "\u3161",
  "\u1173",
  "\u3162",
  "\u1174",
  "\u3163",
  "\u1175",
  "\u3164",
  "\u1160",
  "\u3165",
  "\u1114",
  "\u3166",
  "\u1115",
  "\u3167",
  "\u11C7",
  "\u3168",
  "\u11C8",
  "\u3169",
  "\u11CC",
  "\u316A",
  "\u11CE",
  "\u316B",
  "\u11D3",
  "\u316C",
  "\u11D7",
  "\u316D",
  "\u11D9",
  "\u316E",
  "\u111C",
  "\u316F",
  "\u11DD",
  "\u3170",
  "\u11DF",
  "\u3171",
  "\u111D",
  "\u3172",
  "\u111E",
  "\u3173",
  "\u1120",
  "\u3174",
  "\u1122",
  "\u3175",
  "\u1123",
  "\u3176",
  "\u1127",
  "\u3177",
  "\u1129",
  "\u3178",
  "\u112B",
  "\u3179",
  "\u112C",
  "\u317A",
  "\u112D",
  "\u317B",
  "\u112E",
  "\u317C",
  "\u112F",
  "\u317D",
  "\u1132",
  "\u317E",
  "\u1136",
  "\u317F",
  "\u1140",
  "\u3180",
  "\u1147",
  "\u3181",
  "\u114C",
  "\u3182",
  "\u11F1",
  "\u3183",
  "\u11F2",
  "\u3184",
  "\u1157",
  "\u3185",
  "\u1158",
  "\u3186",
  "\u1159",
  "\u3187",
  "\u1184",
  "\u3188",
  "\u1185",
  "\u3189",
  "\u1188",
  "\u318A",
  "\u1191",
  "\u318B",
  "\u1192",
  "\u318C",
  "\u1194",
  "\u318D",
  "\u119E",
  "\u318E",
  "\u11A1",
  "\u3200",
  "\u0028\u1100\u0029",
  "\u3201",
  "\u0028\u1102\u0029",
  "\u3202",
  "\u0028\u1103\u0029",
  "\u3203",
  "\u0028\u1105\u0029",
  "\u3204",
  "\u0028\u1106\u0029",
  "\u3205",
  "\u0028\u1107\u0029",
  "\u3206",
  "\u0028\u1109\u0029",
  "\u3207",
  "\u0028\u110B\u0029",
  "\u3208",
  "\u0028\u110C\u0029",
  "\u3209",
  "\u0028\u110E\u0029",
  "\u320A",
  "\u0028\u110F\u0029",
  "\u320B",
  "\u0028\u1110\u0029",
  "\u320C",
  "\u0028\u1111\u0029",
  "\u320D",
  "\u0028\u1112\u0029",
  "\u320E",
  "\u0028\u1100\u1161\u0029",
  "\u320F",
  "\u0028\u1102\u1161\u0029",
  "\u3210",
  "\u0028\u1103\u1161\u0029",
  "\u3211",
  "\u0028\u1105\u1161\u0029",
  "\u3212",
  "\u0028\u1106\u1161\u0029",
  "\u3213",
  "\u0028\u1107\u1161\u0029",
  "\u3214",
  "\u0028\u1109\u1161\u0029",
  "\u3215",
  "\u0028\u110B\u1161\u0029",
  "\u3216",
  "\u0028\u110C\u1161\u0029",
  "\u3217",
  "\u0028\u110E\u1161\u0029",
  "\u3218",
  "\u0028\u110F\u1161\u0029",
  "\u3219",
  "\u0028\u1110\u1161\u0029",
  "\u321A",
  "\u0028\u1111\u1161\u0029",
  "\u321B",
  "\u0028\u1112\u1161\u0029",
  "\u321C",
  "\u0028\u110C\u116E\u0029",
  "\u321D",
  "\u0028\u110B\u1169\u110C\u1165\u11AB\u0029",
  "\u321E",
  "\u0028\u110B\u1169\u1112\u116E\u0029",
  "\u3220",
  "\u0028\u4E00\u0029",
  "\u3221",
  "\u0028\u4E8C\u0029",
  "\u3222",
  "\u0028\u4E09\u0029",
  "\u3223",
  "\u0028\u56DB\u0029",
  "\u3224",
  "\u0028\u4E94\u0029",
  "\u3225",
  "\u0028\u516D\u0029",
  "\u3226",
  "\u0028\u4E03\u0029",
  "\u3227",
  "\u0028\u516B\u0029",
  "\u3228",
  "\u0028\u4E5D\u0029",
  "\u3229",
  "\u0028\u5341\u0029",
  "\u322A",
  "\u0028\u6708\u0029",
  "\u322B",
  "\u0028\u706B\u0029",
  "\u322C",
  "\u0028\u6C34\u0029",
  "\u322D",
  "\u0028\u6728\u0029",
  "\u322E",
  "\u0028\u91D1\u0029",
  "\u322F",
  "\u0028\u571F\u0029",
  "\u3230",
  "\u0028\u65E5\u0029",
  "\u3231",
  "\u0028\u682A\u0029",
  "\u3232",
  "\u0028\u6709\u0029",
  "\u3233",
  "\u0028\u793E\u0029",
  "\u3234",
  "\u0028\u540D\u0029",
  "\u3235",
  "\u0028\u7279\u0029",
  "\u3236",
  "\u0028\u8CA1\u0029",
  "\u3237",
  "\u0028\u795D\u0029",
  "\u3238",
  "\u0028\u52B4\u0029",
  "\u3239",
  "\u0028\u4EE3\u0029",
  "\u323A",
  "\u0028\u547C\u0029",
  "\u323B",
  "\u0028\u5B66\u0029",
  "\u323C",
  "\u0028\u76E3\u0029",
  "\u323D",
  "\u0028\u4F01\u0029",
  "\u323E",
  "\u0028\u8CC7\u0029",
  "\u323F",
  "\u0028\u5354\u0029",
  "\u3240",
  "\u0028\u796D\u0029",
  "\u3241",
  "\u0028\u4F11\u0029",
  "\u3242",
  "\u0028\u81EA\u0029",
  "\u3243",
  "\u0028\u81F3\u0029",
  "\u32C0",
  "\u0031\u6708",
  "\u32C1",
  "\u0032\u6708",
  "\u32C2",
  "\u0033\u6708",
  "\u32C3",
  "\u0034\u6708",
  "\u32C4",
  "\u0035\u6708",
  "\u32C5",
  "\u0036\u6708",
  "\u32C6",
  "\u0037\u6708",
  "\u32C7",
  "\u0038\u6708",
  "\u32C8",
  "\u0039\u6708",
  "\u32C9",
  "\u0031\u0030\u6708",
  "\u32CA",
  "\u0031\u0031\u6708",
  "\u32CB",
  "\u0031\u0032\u6708",
  "\u3358",
  "\u0030\u70B9",
  "\u3359",
  "\u0031\u70B9",
  "\u335A",
  "\u0032\u70B9",
  "\u335B",
  "\u0033\u70B9",
  "\u335C",
  "\u0034\u70B9",
  "\u335D",
  "\u0035\u70B9",
  "\u335E",
  "\u0036\u70B9",
  "\u335F",
  "\u0037\u70B9",
  "\u3360",
  "\u0038\u70B9",
  "\u3361",
  "\u0039\u70B9",
  "\u3362",
  "\u0031\u0030\u70B9",
  "\u3363",
  "\u0031\u0031\u70B9",
  "\u3364",
  "\u0031\u0032\u70B9",
  "\u3365",
  "\u0031\u0033\u70B9",
  "\u3366",
  "\u0031\u0034\u70B9",
  "\u3367",
  "\u0031\u0035\u70B9",
  "\u3368",
  "\u0031\u0036\u70B9",
  "\u3369",
  "\u0031\u0037\u70B9",
  "\u336A",
  "\u0031\u0038\u70B9",
  "\u336B",
  "\u0031\u0039\u70B9",
  "\u336C",
  "\u0032\u0030\u70B9",
  "\u336D",
  "\u0032\u0031\u70B9",
  "\u336E",
  "\u0032\u0032\u70B9",
  "\u336F",
  "\u0032\u0033\u70B9",
  "\u3370",
  "\u0032\u0034\u70B9",
  "\u33E0",
  "\u0031\u65E5",
  "\u33E1",
  "\u0032\u65E5",
  "\u33E2",
  "\u0033\u65E5",
  "\u33E3",
  "\u0034\u65E5",
  "\u33E4",
  "\u0035\u65E5",
  "\u33E5",
  "\u0036\u65E5",
  "\u33E6",
  "\u0037\u65E5",
  "\u33E7",
  "\u0038\u65E5",
  "\u33E8",
  "\u0039\u65E5",
  "\u33E9",
  "\u0031\u0030\u65E5",
  "\u33EA",
  "\u0031\u0031\u65E5",
  "\u33EB",
  "\u0031\u0032\u65E5",
  "\u33EC",
  "\u0031\u0033\u65E5",
  "\u33ED",
  "\u0031\u0034\u65E5",
  "\u33EE",
  "\u0031\u0035\u65E5",
  "\u33EF",
  "\u0031\u0036\u65E5",
  "\u33F0",
  "\u0031\u0037\u65E5",
  "\u33F1",
  "\u0031\u0038\u65E5",
  "\u33F2",
  "\u0031\u0039\u65E5",
  "\u33F3",
  "\u0032\u0030\u65E5",
  "\u33F4",
  "\u0032\u0031\u65E5",
  "\u33F5",
  "\u0032\u0032\u65E5",
  "\u33F6",
  "\u0032\u0033\u65E5",
  "\u33F7",
  "\u0032\u0034\u65E5",
  "\u33F8",
  "\u0032\u0035\u65E5",
  "\u33F9",
  "\u0032\u0036\u65E5",
  "\u33FA",
  "\u0032\u0037\u65E5",
  "\u33FB",
  "\u0032\u0038\u65E5",
  "\u33FC",
  "\u0032\u0039\u65E5",
  "\u33FD",
  "\u0033\u0030\u65E5",
  "\u33FE",
  "\u0033\u0031\u65E5",
  "\uFB00",
  "\u0066\u0066",
  "\uFB01",
  "\u0066\u0069",
  "\uFB02",
  "\u0066\u006C",
  "\uFB03",
  "\u0066\u0066\u0069",
  "\uFB04",
  "\u0066\u0066\u006C",
  "\uFB05",
  "\u017F\u0074",
  "\uFB06",
  "\u0073\u0074",
  "\uFB13",
  "\u0574\u0576",
  "\uFB14",
  "\u0574\u0565",
  "\uFB15",
  "\u0574\u056B",
  "\uFB16",
  "\u057E\u0576",
  "\uFB17",
  "\u0574\u056D",
  "\uFB4F",
  "\u05D0\u05DC",
  "\uFB50",
  "\u0671",
  "\uFB51",
  "\u0671",
  "\uFB52",
  "\u067B",
  "\uFB53",
  "\u067B",
  "\uFB54",
  "\u067B",
  "\uFB55",
  "\u067B",
  "\uFB56",
  "\u067E",
  "\uFB57",
  "\u067E",
  "\uFB58",
  "\u067E",
  "\uFB59",
  "\u067E",
  "\uFB5A",
  "\u0680",
  "\uFB5B",
  "\u0680",
  "\uFB5C",
  "\u0680",
  "\uFB5D",
  "\u0680",
  "\uFB5E",
  "\u067A",
  "\uFB5F",
  "\u067A",
  "\uFB60",
  "\u067A",
  "\uFB61",
  "\u067A",
  "\uFB62",
  "\u067F",
  "\uFB63",
  "\u067F",
  "\uFB64",
  "\u067F",
  "\uFB65",
  "\u067F",
  "\uFB66",
  "\u0679",
  "\uFB67",
  "\u0679",
  "\uFB68",
  "\u0679",
  "\uFB69",
  "\u0679",
  "\uFB6A",
  "\u06A4",
  "\uFB6B",
  "\u06A4",
  "\uFB6C",
  "\u06A4",
  "\uFB6D",
  "\u06A4",
  "\uFB6E",
  "\u06A6",
  "\uFB6F",
  "\u06A6",
  "\uFB70",
  "\u06A6",
  "\uFB71",
  "\u06A6",
  "\uFB72",
  "\u0684",
  "\uFB73",
  "\u0684",
  "\uFB74",
  "\u0684",
  "\uFB75",
  "\u0684",
  "\uFB76",
  "\u0683",
  "\uFB77",
  "\u0683",
  "\uFB78",
  "\u0683",
  "\uFB79",
  "\u0683",
  "\uFB7A",
  "\u0686",
  "\uFB7B",
  "\u0686",
  "\uFB7C",
  "\u0686",
  "\uFB7D",
  "\u0686",
  "\uFB7E",
  "\u0687",
  "\uFB7F",
  "\u0687",
  "\uFB80",
  "\u0687",
  "\uFB81",
  "\u0687",
  "\uFB82",
  "\u068D",
  "\uFB83",
  "\u068D",
  "\uFB84",
  "\u068C",
  "\uFB85",
  "\u068C",
  "\uFB86",
  "\u068E",
  "\uFB87",
  "\u068E",
  "\uFB88",
  "\u0688",
  "\uFB89",
  "\u0688",
  "\uFB8A",
  "\u0698",
  "\uFB8B",
  "\u0698",
  "\uFB8C",
  "\u0691",
  "\uFB8D",
  "\u0691",
  "\uFB8E",
  "\u06A9",
  "\uFB8F",
  "\u06A9",
  "\uFB90",
  "\u06A9",
  "\uFB91",
  "\u06A9",
  "\uFB92",
  "\u06AF",
  "\uFB93",
  "\u06AF",
  "\uFB94",
  "\u06AF",
  "\uFB95",
  "\u06AF",
  "\uFB96",
  "\u06B3",
  "\uFB97",
  "\u06B3",
  "\uFB98",
  "\u06B3",
  "\uFB99",
  "\u06B3",
  "\uFB9A",
  "\u06B1",
  "\uFB9B",
  "\u06B1",
  "\uFB9C",
  "\u06B1",
  "\uFB9D",
  "\u06B1",
  "\uFB9E",
  "\u06BA",
  "\uFB9F",
  "\u06BA",
  "\uFBA0",
  "\u06BB",
  "\uFBA1",
  "\u06BB",
  "\uFBA2",
  "\u06BB",
  "\uFBA3",
  "\u06BB",
  "\uFBA4",
  "\u06C0",
  "\uFBA5",
  "\u06C0",
  "\uFBA6",
  "\u06C1",
  "\uFBA7",
  "\u06C1",
  "\uFBA8",
  "\u06C1",
  "\uFBA9",
  "\u06C1",
  "\uFBAA",
  "\u06BE",
  "\uFBAB",
  "\u06BE",
  "\uFBAC",
  "\u06BE",
  "\uFBAD",
  "\u06BE",
  "\uFBAE",
  "\u06D2",
  "\uFBAF",
  "\u06D2",
  "\uFBB0",
  "\u06D3",
  "\uFBB1",
  "\u06D3",
  "\uFBD3",
  "\u06AD",
  "\uFBD4",
  "\u06AD",
  "\uFBD5",
  "\u06AD",
  "\uFBD6",
  "\u06AD",
  "\uFBD7",
  "\u06C7",
  "\uFBD8",
  "\u06C7",
  "\uFBD9",
  "\u06C6",
  "\uFBDA",
  "\u06C6",
  "\uFBDB",
  "\u06C8",
  "\uFBDC",
  "\u06C8",
  "\uFBDD",
  "\u0677",
  "\uFBDE",
  "\u06CB",
  "\uFBDF",
  "\u06CB",
  "\uFBE0",
  "\u06C5",
  "\uFBE1",
  "\u06C5",
  "\uFBE2",
  "\u06C9",
  "\uFBE3",
  "\u06C9",
  "\uFBE4",
  "\u06D0",
  "\uFBE5",
  "\u06D0",
  "\uFBE6",
  "\u06D0",
  "\uFBE7",
  "\u06D0",
  "\uFBE8",
  "\u0649",
  "\uFBE9",
  "\u0649",
  "\uFBEA",
  "\u0626\u0627",
  "\uFBEB",
  "\u0626\u0627",
  "\uFBEC",
  "\u0626\u06D5",
  "\uFBED",
  "\u0626\u06D5",
  "\uFBEE",
  "\u0626\u0648",
  "\uFBEF",
  "\u0626\u0648",
  "\uFBF0",
  "\u0626\u06C7",
  "\uFBF1",
  "\u0626\u06C7",
  "\uFBF2",
  "\u0626\u06C6",
  "\uFBF3",
  "\u0626\u06C6",
  "\uFBF4",
  "\u0626\u06C8",
  "\uFBF5",
  "\u0626\u06C8",
  "\uFBF6",
  "\u0626\u06D0",
  "\uFBF7",
  "\u0626\u06D0",
  "\uFBF8",
  "\u0626\u06D0",
  "\uFBF9",
  "\u0626\u0649",
  "\uFBFA",
  "\u0626\u0649",
  "\uFBFB",
  "\u0626\u0649",
  "\uFBFC",
  "\u06CC",
  "\uFBFD",
  "\u06CC",
  "\uFBFE",
  "\u06CC",
  "\uFBFF",
  "\u06CC",
  "\uFC00",
  "\u0626\u062C",
  "\uFC01",
  "\u0626\u062D",
  "\uFC02",
  "\u0626\u0645",
  "\uFC03",
  "\u0626\u0649",
  "\uFC04",
  "\u0626\u064A",
  "\uFC05",
  "\u0628\u062C",
  "\uFC06",
  "\u0628\u062D",
  "\uFC07",
  "\u0628\u062E",
  "\uFC08",
  "\u0628\u0645",
  "\uFC09",
  "\u0628\u0649",
  "\uFC0A",
  "\u0628\u064A",
  "\uFC0B",
  "\u062A\u062C",
  "\uFC0C",
  "\u062A\u062D",
  "\uFC0D",
  "\u062A\u062E",
  "\uFC0E",
  "\u062A\u0645",
  "\uFC0F",
  "\u062A\u0649",
  "\uFC10",
  "\u062A\u064A",
  "\uFC11",
  "\u062B\u062C",
  "\uFC12",
  "\u062B\u0645",
  "\uFC13",
  "\u062B\u0649",
  "\uFC14",
  "\u062B\u064A",
  "\uFC15",
  "\u062C\u062D",
  "\uFC16",
  "\u062C\u0645",
  "\uFC17",
  "\u062D\u062C",
  "\uFC18",
  "\u062D\u0645",
  "\uFC19",
  "\u062E\u062C",
  "\uFC1A",
  "\u062E\u062D",
  "\uFC1B",
  "\u062E\u0645",
  "\uFC1C",
  "\u0633\u062C",
  "\uFC1D",
  "\u0633\u062D",
  "\uFC1E",
  "\u0633\u062E",
  "\uFC1F",
  "\u0633\u0645",
  "\uFC20",
  "\u0635\u062D",
  "\uFC21",
  "\u0635\u0645",
  "\uFC22",
  "\u0636\u062C",
  "\uFC23",
  "\u0636\u062D",
  "\uFC24",
  "\u0636\u062E",
  "\uFC25",
  "\u0636\u0645",
  "\uFC26",
  "\u0637\u062D",
  "\uFC27",
  "\u0637\u0645",
  "\uFC28",
  "\u0638\u0645",
  "\uFC29",
  "\u0639\u062C",
  "\uFC2A",
  "\u0639\u0645",
  "\uFC2B",
  "\u063A\u062C",
  "\uFC2C",
  "\u063A\u0645",
  "\uFC2D",
  "\u0641\u062C",
  "\uFC2E",
  "\u0641\u062D",
  "\uFC2F",
  "\u0641\u062E",
  "\uFC30",
  "\u0641\u0645",
  "\uFC31",
  "\u0641\u0649",
  "\uFC32",
  "\u0641\u064A",
  "\uFC33",
  "\u0642\u062D",
  "\uFC34",
  "\u0642\u0645",
  "\uFC35",
  "\u0642\u0649",
  "\uFC36",
  "\u0642\u064A",
  "\uFC37",
  "\u0643\u0627",
  "\uFC38",
  "\u0643\u062C",
  "\uFC39",
  "\u0643\u062D",
  "\uFC3A",
  "\u0643\u062E",
  "\uFC3B",
  "\u0643\u0644",
  "\uFC3C",
  "\u0643\u0645",
  "\uFC3D",
  "\u0643\u0649",
  "\uFC3E",
  "\u0643\u064A",
  "\uFC3F",
  "\u0644\u062C",
  "\uFC40",
  "\u0644\u062D",
  "\uFC41",
  "\u0644\u062E",
  "\uFC42",
  "\u0644\u0645",
  "\uFC43",
  "\u0644\u0649",
  "\uFC44",
  "\u0644\u064A",
  "\uFC45",
  "\u0645\u062C",
  "\uFC46",
  "\u0645\u062D",
  "\uFC47",
  "\u0645\u062E",
  "\uFC48",
  "\u0645\u0645",
  "\uFC49",
  "\u0645\u0649",
  "\uFC4A",
  "\u0645\u064A",
  "\uFC4B",
  "\u0646\u062C",
  "\uFC4C",
  "\u0646\u062D",
  "\uFC4D",
  "\u0646\u062E",
  "\uFC4E",
  "\u0646\u0645",
  "\uFC4F",
  "\u0646\u0649",
  "\uFC50",
  "\u0646\u064A",
  "\uFC51",
  "\u0647\u062C",
  "\uFC52",
  "\u0647\u0645",
  "\uFC53",
  "\u0647\u0649",
  "\uFC54",
  "\u0647\u064A",
  "\uFC55",
  "\u064A\u062C",
  "\uFC56",
  "\u064A\u062D",
  "\uFC57",
  "\u064A\u062E",
  "\uFC58",
  "\u064A\u0645",
  "\uFC59",
  "\u064A\u0649",
  "\uFC5A",
  "\u064A\u064A",
  "\uFC5B",
  "\u0630\u0670",
  "\uFC5C",
  "\u0631\u0670",
  "\uFC5D",
  "\u0649\u0670",
  "\uFC5E",
  "\u0020\u064C\u0651",
  "\uFC5F",
  "\u0020\u064D\u0651",
  "\uFC60",
  "\u0020\u064E\u0651",
  "\uFC61",
  "\u0020\u064F\u0651",
  "\uFC62",
  "\u0020\u0650\u0651",
  "\uFC63",
  "\u0020\u0651\u0670",
  "\uFC64",
  "\u0626\u0631",
  "\uFC65",
  "\u0626\u0632",
  "\uFC66",
  "\u0626\u0645",
  "\uFC67",
  "\u0626\u0646",
  "\uFC68",
  "\u0626\u0649",
  "\uFC69",
  "\u0626\u064A",
  "\uFC6A",
  "\u0628\u0631",
  "\uFC6B",
  "\u0628\u0632",
  "\uFC6C",
  "\u0628\u0645",
  "\uFC6D",
  "\u0628\u0646",
  "\uFC6E",
  "\u0628\u0649",
  "\uFC6F",
  "\u0628\u064A",
  "\uFC70",
  "\u062A\u0631",
  "\uFC71",
  "\u062A\u0632",
  "\uFC72",
  "\u062A\u0645",
  "\uFC73",
  "\u062A\u0646",
  "\uFC74",
  "\u062A\u0649",
  "\uFC75",
  "\u062A\u064A",
  "\uFC76",
  "\u062B\u0631",
  "\uFC77",
  "\u062B\u0632",
  "\uFC78",
  "\u062B\u0645",
  "\uFC79",
  "\u062B\u0646",
  "\uFC7A",
  "\u062B\u0649",
  "\uFC7B",
  "\u062B\u064A",
  "\uFC7C",
  "\u0641\u0649",
  "\uFC7D",
  "\u0641\u064A",
  "\uFC7E",
  "\u0642\u0649",
  "\uFC7F",
  "\u0642\u064A",
  "\uFC80",
  "\u0643\u0627",
  "\uFC81",
  "\u0643\u0644",
  "\uFC82",
  "\u0643\u0645",
  "\uFC83",
  "\u0643\u0649",
  "\uFC84",
  "\u0643\u064A",
  "\uFC85",
  "\u0644\u0645",
  "\uFC86",
  "\u0644\u0649",
  "\uFC87",
  "\u0644\u064A",
  "\uFC88",
  "\u0645\u0627",
  "\uFC89",
  "\u0645\u0645",
  "\uFC8A",
  "\u0646\u0631",
  "\uFC8B",
  "\u0646\u0632",
  "\uFC8C",
  "\u0646\u0645",
  "\uFC8D",
  "\u0646\u0646",
  "\uFC8E",
  "\u0646\u0649",
  "\uFC8F",
  "\u0646\u064A",
  "\uFC90",
  "\u0649\u0670",
  "\uFC91",
  "\u064A\u0631",
  "\uFC92",
  "\u064A\u0632",
  "\uFC93",
  "\u064A\u0645",
  "\uFC94",
  "\u064A\u0646",
  "\uFC95",
  "\u064A\u0649",
  "\uFC96",
  "\u064A\u064A",
  "\uFC97",
  "\u0626\u062C",
  "\uFC98",
  "\u0626\u062D",
  "\uFC99",
  "\u0626\u062E",
  "\uFC9A",
  "\u0626\u0645",
  "\uFC9B",
  "\u0626\u0647",
  "\uFC9C",
  "\u0628\u062C",
  "\uFC9D",
  "\u0628\u062D",
  "\uFC9E",
  "\u0628\u062E",
  "\uFC9F",
  "\u0628\u0645",
  "\uFCA0",
  "\u0628\u0647",
  "\uFCA1",
  "\u062A\u062C",
  "\uFCA2",
  "\u062A\u062D",
  "\uFCA3",
  "\u062A\u062E",
  "\uFCA4",
  "\u062A\u0645",
  "\uFCA5",
  "\u062A\u0647",
  "\uFCA6",
  "\u062B\u0645",
  "\uFCA7",
  "\u062C\u062D",
  "\uFCA8",
  "\u062C\u0645",
  "\uFCA9",
  "\u062D\u062C",
  "\uFCAA",
  "\u062D\u0645",
  "\uFCAB",
  "\u062E\u062C",
  "\uFCAC",
  "\u062E\u0645",
  "\uFCAD",
  "\u0633\u062C",
  "\uFCAE",
  "\u0633\u062D",
  "\uFCAF",
  "\u0633\u062E",
  "\uFCB0",
  "\u0633\u0645",
  "\uFCB1",
  "\u0635\u062D",
  "\uFCB2",
  "\u0635\u062E",
  "\uFCB3",
  "\u0635\u0645",
  "\uFCB4",
  "\u0636\u062C",
  "\uFCB5",
  "\u0636\u062D",
  "\uFCB6",
  "\u0636\u062E",
  "\uFCB7",
  "\u0636\u0645",
  "\uFCB8",
  "\u0637\u062D",
  "\uFCB9",
  "\u0638\u0645",
  "\uFCBA",
  "\u0639\u062C",
  "\uFCBB",
  "\u0639\u0645",
  "\uFCBC",
  "\u063A\u062C",
  "\uFCBD",
  "\u063A\u0645",
  "\uFCBE",
  "\u0641\u062C",
  "\uFCBF",
  "\u0641\u062D",
  "\uFCC0",
  "\u0641\u062E",
  "\uFCC1",
  "\u0641\u0645",
  "\uFCC2",
  "\u0642\u062D",
  "\uFCC3",
  "\u0642\u0645",
  "\uFCC4",
  "\u0643\u062C",
  "\uFCC5",
  "\u0643\u062D",
  "\uFCC6",
  "\u0643\u062E",
  "\uFCC7",
  "\u0643\u0644",
  "\uFCC8",
  "\u0643\u0645",
  "\uFCC9",
  "\u0644\u062C",
  "\uFCCA",
  "\u0644\u062D",
  "\uFCCB",
  "\u0644\u062E",
  "\uFCCC",
  "\u0644\u0645",
  "\uFCCD",
  "\u0644\u0647",
  "\uFCCE",
  "\u0645\u062C",
  "\uFCCF",
  "\u0645\u062D",
  "\uFCD0",
  "\u0645\u062E",
  "\uFCD1",
  "\u0645\u0645",
  "\uFCD2",
  "\u0646\u062C",
  "\uFCD3",
  "\u0646\u062D",
  "\uFCD4",
  "\u0646\u062E",
  "\uFCD5",
  "\u0646\u0645",
  "\uFCD6",
  "\u0646\u0647",
  "\uFCD7",
  "\u0647\u062C",
  "\uFCD8",
  "\u0647\u0645",
  "\uFCD9",
  "\u0647\u0670",
  "\uFCDA",
  "\u064A\u062C",
  "\uFCDB",
  "\u064A\u062D",
  "\uFCDC",
  "\u064A\u062E",
  "\uFCDD",
  "\u064A\u0645",
  "\uFCDE",
  "\u064A\u0647",
  "\uFCDF",
  "\u0626\u0645",
  "\uFCE0",
  "\u0626\u0647",
  "\uFCE1",
  "\u0628\u0645",
  "\uFCE2",
  "\u0628\u0647",
  "\uFCE3",
  "\u062A\u0645",
  "\uFCE4",
  "\u062A\u0647",
  "\uFCE5",
  "\u062B\u0645",
  "\uFCE6",
  "\u062B\u0647",
  "\uFCE7",
  "\u0633\u0645",
  "\uFCE8",
  "\u0633\u0647",
  "\uFCE9",
  "\u0634\u0645",
  "\uFCEA",
  "\u0634\u0647",
  "\uFCEB",
  "\u0643\u0644",
  "\uFCEC",
  "\u0643\u0645",
  "\uFCED",
  "\u0644\u0645",
  "\uFCEE",
  "\u0646\u0645",
  "\uFCEF",
  "\u0646\u0647",
  "\uFCF0",
  "\u064A\u0645",
  "\uFCF1",
  "\u064A\u0647",
  "\uFCF2",
  "\u0640\u064E\u0651",
  "\uFCF3",
  "\u0640\u064F\u0651",
  "\uFCF4",
  "\u0640\u0650\u0651",
  "\uFCF5",
  "\u0637\u0649",
  "\uFCF6",
  "\u0637\u064A",
  "\uFCF7",
  "\u0639\u0649",
  "\uFCF8",
  "\u0639\u064A",
  "\uFCF9",
  "\u063A\u0649",
  "\uFCFA",
  "\u063A\u064A",
  "\uFCFB",
  "\u0633\u0649",
  "\uFCFC",
  "\u0633\u064A",
  "\uFCFD",
  "\u0634\u0649",
  "\uFCFE",
  "\u0634\u064A",
  "\uFCFF",
  "\u062D\u0649",
  "\uFD00",
  "\u062D\u064A",
  "\uFD01",
  "\u062C\u0649",
  "\uFD02",
  "\u062C\u064A",
  "\uFD03",
  "\u062E\u0649",
  "\uFD04",
  "\u062E\u064A",
  "\uFD05",
  "\u0635\u0649",
  "\uFD06",
  "\u0635\u064A",
  "\uFD07",
  "\u0636\u0649",
  "\uFD08",
  "\u0636\u064A",
  "\uFD09",
  "\u0634\u062C",
  "\uFD0A",
  "\u0634\u062D",
  "\uFD0B",
  "\u0634\u062E",
  "\uFD0C",
  "\u0634\u0645",
  "\uFD0D",
  "\u0634\u0631",
  "\uFD0E",
  "\u0633\u0631",
  "\uFD0F",
  "\u0635\u0631",
  "\uFD10",
  "\u0636\u0631",
  "\uFD11",
  "\u0637\u0649",
  "\uFD12",
  "\u0637\u064A",
  "\uFD13",
  "\u0639\u0649",
  "\uFD14",
  "\u0639\u064A",
  "\uFD15",
  "\u063A\u0649",
  "\uFD16",
  "\u063A\u064A",
  "\uFD17",
  "\u0633\u0649",
  "\uFD18",
  "\u0633\u064A",
  "\uFD19",
  "\u0634\u0649",
  "\uFD1A",
  "\u0634\u064A",
  "\uFD1B",
  "\u062D\u0649",
  "\uFD1C",
  "\u062D\u064A",
  "\uFD1D",
  "\u062C\u0649",
  "\uFD1E",
  "\u062C\u064A",
  "\uFD1F",
  "\u062E\u0649",
  "\uFD20",
  "\u062E\u064A",
  "\uFD21",
  "\u0635\u0649",
  "\uFD22",
  "\u0635\u064A",
  "\uFD23",
  "\u0636\u0649",
  "\uFD24",
  "\u0636\u064A",
  "\uFD25",
  "\u0634\u062C",
  "\uFD26",
  "\u0634\u062D",
  "\uFD27",
  "\u0634\u062E",
  "\uFD28",
  "\u0634\u0645",
  "\uFD29",
  "\u0634\u0631",
  "\uFD2A",
  "\u0633\u0631",
  "\uFD2B",
  "\u0635\u0631",
  "\uFD2C",
  "\u0636\u0631",
  "\uFD2D",
  "\u0634\u062C",
  "\uFD2E",
  "\u0634\u062D",
  "\uFD2F",
  "\u0634\u062E",
  "\uFD30",
  "\u0634\u0645",
  "\uFD31",
  "\u0633\u0647",
  "\uFD32",
  "\u0634\u0647",
  "\uFD33",
  "\u0637\u0645",
  "\uFD34",
  "\u0633\u062C",
  "\uFD35",
  "\u0633\u062D",
  "\uFD36",
  "\u0633\u062E",
  "\uFD37",
  "\u0634\u062C",
  "\uFD38",
  "\u0634\u062D",
  "\uFD39",
  "\u0634\u062E",
  "\uFD3A",
  "\u0637\u0645",
  "\uFD3B",
  "\u0638\u0645",
  "\uFD3C",
  "\u0627\u064B",
  "\uFD3D",
  "\u0627\u064B",
  "\uFD50",
  "\u062A\u062C\u0645",
  "\uFD51",
  "\u062A\u062D\u062C",
  "\uFD52",
  "\u062A\u062D\u062C",
  "\uFD53",
  "\u062A\u062D\u0645",
  "\uFD54",
  "\u062A\u062E\u0645",
  "\uFD55",
  "\u062A\u0645\u062C",
  "\uFD56",
  "\u062A\u0645\u062D",
  "\uFD57",
  "\u062A\u0645\u062E",
  "\uFD58",
  "\u062C\u0645\u062D",
  "\uFD59",
  "\u062C\u0645\u062D",
  "\uFD5A",
  "\u062D\u0645\u064A",
  "\uFD5B",
  "\u062D\u0645\u0649",
  "\uFD5C",
  "\u0633\u062D\u062C",
  "\uFD5D",
  "\u0633\u062C\u062D",
  "\uFD5E",
  "\u0633\u062C\u0649",
  "\uFD5F",
  "\u0633\u0645\u062D",
  "\uFD60",
  "\u0633\u0645\u062D",
  "\uFD61",
  "\u0633\u0645\u062C",
  "\uFD62",
  "\u0633\u0645\u0645",
  "\uFD63",
  "\u0633\u0645\u0645",
  "\uFD64",
  "\u0635\u062D\u062D",
  "\uFD65",
  "\u0635\u062D\u062D",
  "\uFD66",
  "\u0635\u0645\u0645",
  "\uFD67",
  "\u0634\u062D\u0645",
  "\uFD68",
  "\u0634\u062D\u0645",
  "\uFD69",
  "\u0634\u062C\u064A",
  "\uFD6A",
  "\u0634\u0645\u062E",
  "\uFD6B",
  "\u0634\u0645\u062E",
  "\uFD6C",
  "\u0634\u0645\u0645",
  "\uFD6D",
  "\u0634\u0645\u0645",
  "\uFD6E",
  "\u0636\u062D\u0649",
  "\uFD6F",
  "\u0636\u062E\u0645",
  "\uFD70",
  "\u0636\u062E\u0645",
  "\uFD71",
  "\u0637\u0645\u062D",
  "\uFD72",
  "\u0637\u0645\u062D",
  "\uFD73",
  "\u0637\u0645\u0645",
  "\uFD74",
  "\u0637\u0645\u064A",
  "\uFD75",
  "\u0639\u062C\u0645",
  "\uFD76",
  "\u0639\u0645\u0645",
  "\uFD77",
  "\u0639\u0645\u0645",
  "\uFD78",
  "\u0639\u0645\u0649",
  "\uFD79",
  "\u063A\u0645\u0645",
  "\uFD7A",
  "\u063A\u0645\u064A",
  "\uFD7B",
  "\u063A\u0645\u0649",
  "\uFD7C",
  "\u0641\u062E\u0645",
  "\uFD7D",
  "\u0641\u062E\u0645",
  "\uFD7E",
  "\u0642\u0645\u062D",
  "\uFD7F",
  "\u0642\u0645\u0645",
  "\uFD80",
  "\u0644\u062D\u0645",
  "\uFD81",
  "\u0644\u062D\u064A",
  "\uFD82",
  "\u0644\u062D\u0649",
  "\uFD83",
  "\u0644\u062C\u062C",
  "\uFD84",
  "\u0644\u062C\u062C",
  "\uFD85",
  "\u0644\u062E\u0645",
  "\uFD86",
  "\u0644\u062E\u0645",
  "\uFD87",
  "\u0644\u0645\u062D",
  "\uFD88",
  "\u0644\u0645\u062D",
  "\uFD89",
  "\u0645\u062D\u062C",
  "\uFD8A",
  "\u0645\u062D\u0645",
  "\uFD8B",
  "\u0645\u062D\u064A",
  "\uFD8C",
  "\u0645\u062C\u062D",
  "\uFD8D",
  "\u0645\u062C\u0645",
  "\uFD8E",
  "\u0645\u062E\u062C",
  "\uFD8F",
  "\u0645\u062E\u0645",
  "\uFD92",
  "\u0645\u062C\u062E",
  "\uFD93",
  "\u0647\u0645\u062C",
  "\uFD94",
  "\u0647\u0645\u0645",
  "\uFD95",
  "\u0646\u062D\u0645",
  "\uFD96",
  "\u0646\u062D\u0649",
  "\uFD97",
  "\u0646\u062C\u0645",
  "\uFD98",
  "\u0646\u062C\u0645",
  "\uFD99",
  "\u0646\u062C\u0649",
  "\uFD9A",
  "\u0646\u0645\u064A",
  "\uFD9B",
  "\u0646\u0645\u0649",
  "\uFD9C",
  "\u064A\u0645\u0645",
  "\uFD9D",
  "\u064A\u0645\u0645",
  "\uFD9E",
  "\u0628\u062E\u064A",
  "\uFD9F",
  "\u062A\u062C\u064A",
  "\uFDA0",
  "\u062A\u062C\u0649",
  "\uFDA1",
  "\u062A\u062E\u064A",
  "\uFDA2",
  "\u062A\u062E\u0649",
  "\uFDA3",
  "\u062A\u0645\u064A",
  "\uFDA4",
  "\u062A\u0645\u0649",
  "\uFDA5",
  "\u062C\u0645\u064A",
  "\uFDA6",
  "\u062C\u062D\u0649",
  "\uFDA7",
  "\u062C\u0645\u0649",
  "\uFDA8",
  "\u0633\u062E\u0649",
  "\uFDA9",
  "\u0635\u062D\u064A",
  "\uFDAA",
  "\u0634\u062D\u064A",
  "\uFDAB",
  "\u0636\u062D\u064A",
  "\uFDAC",
  "\u0644\u062C\u064A",
  "\uFDAD",
  "\u0644\u0645\u064A",
  "\uFDAE",
  "\u064A\u062D\u064A",
  "\uFDAF",
  "\u064A\u062C\u064A",
  "\uFDB0",
  "\u064A\u0645\u064A",
  "\uFDB1",
  "\u0645\u0645\u064A",
  "\uFDB2",
  "\u0642\u0645\u064A",
  "\uFDB3",
  "\u0646\u062D\u064A",
  "\uFDB4",
  "\u0642\u0645\u062D",
  "\uFDB5",
  "\u0644\u062D\u0645",
  "\uFDB6",
  "\u0639\u0645\u064A",
  "\uFDB7",
  "\u0643\u0645\u064A",
  "\uFDB8",
  "\u0646\u062C\u062D",
  "\uFDB9",
  "\u0645\u062E\u064A",
  "\uFDBA",
  "\u0644\u062C\u0645",
  "\uFDBB",
  "\u0643\u0645\u0645",
  "\uFDBC",
  "\u0644\u062C\u0645",
  "\uFDBD",
  "\u0646\u062C\u062D",
  "\uFDBE",
  "\u062C\u062D\u064A",
  "\uFDBF",
  "\u062D\u062C\u064A",
  "\uFDC0",
  "\u0645\u062C\u064A",
  "\uFDC1",
  "\u0641\u0645\u064A",
  "\uFDC2",
  "\u0628\u062D\u064A",
  "\uFDC3",
  "\u0643\u0645\u0645",
  "\uFDC4",
  "\u0639\u062C\u0645",
  "\uFDC5",
  "\u0635\u0645\u0645",
  "\uFDC6",
  "\u0633\u062E\u064A",
  "\uFDC7",
  "\u0646\u062C\u064A",
  "\uFE49",
  "\u203E",
  "\uFE4A",
  "\u203E",
  "\uFE4B",
  "\u203E",
  "\uFE4C",
  "\u203E",
  "\uFE4D",
  "\u005F",
  "\uFE4E",
  "\u005F",
  "\uFE4F",
  "\u005F",
  "\uFE80",
  "\u0621",
  "\uFE81",
  "\u0622",
  "\uFE82",
  "\u0622",
  "\uFE83",
  "\u0623",
  "\uFE84",
  "\u0623",
  "\uFE85",
  "\u0624",
  "\uFE86",
  "\u0624",
  "\uFE87",
  "\u0625",
  "\uFE88",
  "\u0625",
  "\uFE89",
  "\u0626",
  "\uFE8A",
  "\u0626",
  "\uFE8B",
  "\u0626",
  "\uFE8C",
  "\u0626",
  "\uFE8D",
  "\u0627",
  "\uFE8E",
  "\u0627",
  "\uFE8F",
  "\u0628",
  "\uFE90",
  "\u0628",
  "\uFE91",
  "\u0628",
  "\uFE92",
  "\u0628",
  "\uFE93",
  "\u0629",
  "\uFE94",
  "\u0629",
  "\uFE95",
  "\u062A",
  "\uFE96",
  "\u062A",
  "\uFE97",
  "\u062A",
  "\uFE98",
  "\u062A",
  "\uFE99",
  "\u062B",
  "\uFE9A",
  "\u062B",
  "\uFE9B",
  "\u062B",
  "\uFE9C",
  "\u062B",
  "\uFE9D",
  "\u062C",
  "\uFE9E",
  "\u062C",
  "\uFE9F",
  "\u062C",
  "\uFEA0",
  "\u062C",
  "\uFEA1",
  "\u062D",
  "\uFEA2",
  "\u062D",
  "\uFEA3",
  "\u062D",
  "\uFEA4",
  "\u062D",
  "\uFEA5",
  "\u062E",
  "\uFEA6",
  "\u062E",
  "\uFEA7",
  "\u062E",
  "\uFEA8",
  "\u062E",
  "\uFEA9",
  "\u062F",
  "\uFEAA",
  "\u062F",
  "\uFEAB",
  "\u0630",
  "\uFEAC",
  "\u0630",
  "\uFEAD",
  "\u0631",
  "\uFEAE",
  "\u0631",
  "\uFEAF",
  "\u0632",
  "\uFEB0",
  "\u0632",
  "\uFEB1",
  "\u0633",
  "\uFEB2",
  "\u0633",
  "\uFEB3",
  "\u0633",
  "\uFEB4",
  "\u0633",
  "\uFEB5",
  "\u0634",
  "\uFEB6",
  "\u0634",
  "\uFEB7",
  "\u0634",
  "\uFEB8",
  "\u0634",
  "\uFEB9",
  "\u0635",
  "\uFEBA",
  "\u0635",
  "\uFEBB",
  "\u0635",
  "\uFEBC",
  "\u0635",
  "\uFEBD",
  "\u0636",
  "\uFEBE",
  "\u0636",
  "\uFEBF",
  "\u0636",
  "\uFEC0",
  "\u0636",
  "\uFEC1",
  "\u0637",
  "\uFEC2",
  "\u0637",
  "\uFEC3",
  "\u0637",
  "\uFEC4",
  "\u0637",
  "\uFEC5",
  "\u0638",
  "\uFEC6",
  "\u0638",
  "\uFEC7",
  "\u0638",
  "\uFEC8",
  "\u0638",
  "\uFEC9",
  "\u0639",
  "\uFECA",
  "\u0639",
  "\uFECB",
  "\u0639",
  "\uFECC",
  "\u0639",
  "\uFECD",
  "\u063A",
  "\uFECE",
  "\u063A",
  "\uFECF",
  "\u063A",
  "\uFED0",
  "\u063A",
  "\uFED1",
  "\u0641",
  "\uFED2",
  "\u0641",
  "\uFED3",
  "\u0641",
  "\uFED4",
  "\u0641",
  "\uFED5",
  "\u0642",
  "\uFED6",
  "\u0642",
  "\uFED7",
  "\u0642",
  "\uFED8",
  "\u0642",
  "\uFED9",
  "\u0643",
  "\uFEDA",
  "\u0643",
  "\uFEDB",
  "\u0643",
  "\uFEDC",
  "\u0643",
  "\uFEDD",
  "\u0644",
  "\uFEDE",
  "\u0644",
  "\uFEDF",
  "\u0644",
  "\uFEE0",
  "\u0644",
  "\uFEE1",
  "\u0645",
  "\uFEE2",
  "\u0645",
  "\uFEE3",
  "\u0645",
  "\uFEE4",
  "\u0645",
  "\uFEE5",
  "\u0646",
  "\uFEE6",
  "\u0646",
  "\uFEE7",
  "\u0646",
  "\uFEE8",
  "\u0646",
  "\uFEE9",
  "\u0647",
  "\uFEEA",
  "\u0647",
  "\uFEEB",
  "\u0647",
  "\uFEEC",
  "\u0647",
  "\uFEED",
  "\u0648",
  "\uFEEE",
  "\u0648",
  "\uFEEF",
  "\u0649",
  "\uFEF0",
  "\u0649",
  "\uFEF1",
  "\u064A",
  "\uFEF2",
  "\u064A",
  "\uFEF3",
  "\u064A",
  "\uFEF4",
  "\u064A",
  "\uFEF5",
  "\u0644\u0622",
  "\uFEF6",
  "\u0644\u0622",
  "\uFEF7",
  "\u0644\u0623",
  "\uFEF8",
  "\u0644\u0623",
  "\uFEF9",
  "\u0644\u0625",
  "\uFEFA",
  "\u0644\u0625",
  "\uFEFB",
  "\u0644\u0627",
  "\uFEFC",
  "\u0644\u0627"
 ];
});
function reverseIfRtl(chars) {
 const charsLength = chars.length;
 if (charsLength <= 1 || !isRTLRangeFor(chars.charCodeAt(0))) {
  return chars;
 }
 const buf = [];
 for (let ii = charsLength - 1; ii >= 0; ii--) {
  buf.push(chars[ii]);
 }
 return buf.join("");
}


/***/ }),
/* 22 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MarkupAnnotation = exports.AnnotationFactory = exports.AnnotationBorderStyle = exports.Annotation = void 0;
exports.getQuadPoints = getQuadPoints;

var _util = __w_pdfjs_require__(2);

var _core_utils = __w_pdfjs_require__(9);

var _default_appearance = __w_pdfjs_require__(23);

var _primitives = __w_pdfjs_require__(5);

var _bidi = __w_pdfjs_require__(59);

var _catalog = __w_pdfjs_require__(64);

var _colorspace = __w_pdfjs_require__(24);

var _file_spec = __w_pdfjs_require__(66);

var _object_loader = __w_pdfjs_require__(70);

var _operator_list = __w_pdfjs_require__(62);

var _stream = __w_pdfjs_require__(10);

var _writer = __w_pdfjs_require__(71);

var _factory = __w_pdfjs_require__(74);

class AnnotationFactory {
  static create(xref, ref, pdfManager, idFactory, collectFields) {
    return Promise.all([pdfManager.ensureCatalog("acroForm"), collectFields ? this._getPageIndex(xref, ref, pdfManager) : -1]).then(([acroForm, pageIndex]) => pdfManager.ensure(this, "_create", [xref, ref, pdfManager, idFactory, acroForm, collectFields, pageIndex]));
  }

  static _create(xref, ref, pdfManager, idFactory, acroForm, collectFields, pageIndex = -1) {
    const dict = xref.fetchIfRef(ref);

    if (!(0, _primitives.isDict)(dict)) {
      return undefined;
    }

    const id = (0, _primitives.isRef)(ref) ? ref.toString() : `annot_${idFactory.createObjId()}`;
    let subtype = dict.get("Subtype");
    subtype = (0, _primitives.isName)(subtype) ? subtype.name : null;
    const parameters = {
      xref,
      ref,
      dict,
      subtype,
      id,
      pdfManager,
      acroForm: acroForm instanceof _primitives.Dict ? acroForm : _primitives.Dict.empty,
      collectFields,
      pageIndex
    };

    switch (subtype) {
      case "Link":
        return new LinkAnnotation(parameters);

      case "Text":
        return new TextAnnotation(parameters);

      case "Widget":
        let fieldType = (0, _core_utils.getInheritableProperty)({
          dict,
          key: "FT"
        });
        fieldType = (0, _primitives.isName)(fieldType) ? fieldType.name : null;

        switch (fieldType) {
          case "Tx":
            return new TextWidgetAnnotation(parameters);

          case "Btn":
            return new ButtonWidgetAnnotation(parameters);

          case "Ch":
            return new ChoiceWidgetAnnotation(parameters);

          case "Sig":
            return new SignatureWidgetAnnotation(parameters);
        }

        (0, _util.warn)(`Unimplemented widget field type "${fieldType}", ` + "falling back to base field type.");
        return new WidgetAnnotation(parameters);

      case "Popup":
        return new PopupAnnotation(parameters);

      case "FreeText":
        return new FreeTextAnnotation(parameters);

      case "Line":
        return new LineAnnotation(parameters);

      case "Square":
        return new SquareAnnotation(parameters);

      case "Circle":
        return new CircleAnnotation(parameters);

      case "PolyLine":
        return new PolylineAnnotation(parameters);

      case "Polygon":
        return new PolygonAnnotation(parameters);

      case "Caret":
        return new CaretAnnotation(parameters);

      case "Ink":
        return new InkAnnotation(parameters);

      case "Highlight":
        return new HighlightAnnotation(parameters);

      case "Underline":
        return new UnderlineAnnotation(parameters);

      case "Squiggly":
        return new SquigglyAnnotation(parameters);

      case "StrikeOut":
        return new StrikeOutAnnotation(parameters);

      case "Stamp":
        return new StampAnnotation(parameters);

      case "FileAttachment":
        return new FileAttachmentAnnotation(parameters);

      default:
        if (!collectFields) {
          if (!subtype) {
            (0, _util.warn)("Annotation is missing the required /Subtype.");
          } else {
            (0, _util.warn)(`Unimplemented annotation type "${subtype}", ` + "falling back to base annotation.");
          }
        }

        return new Annotation(parameters);
    }
  }

  static async _getPageIndex(xref, ref, pdfManager) {
    try {
      const annotDict = await xref.fetchIfRefAsync(ref);

      if (!(0, _primitives.isDict)(annotDict)) {
        return -1;
      }

      const pageRef = annotDict.getRaw("P");

      if (!(0, _primitives.isRef)(pageRef)) {
        return -1;
      }

      const pageIndex = await pdfManager.ensureCatalog("getPageIndex", [pageRef]);
      return pageIndex;
    } catch (ex) {
      (0, _util.warn)(`_getPageIndex: "${ex}".`);
      return -1;
    }
  }

}

exports.AnnotationFactory = AnnotationFactory;

function getRgbColor(color, defaultColor = new Uint8ClampedArray(3)) {
  if (!Array.isArray(color)) {
    return defaultColor;
  }

  const rgbColor = defaultColor || new Uint8ClampedArray(3);

  switch (color.length) {
    case 0:
      return null;

    case 1:
      _colorspace.ColorSpace.singletons.gray.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    case 3:
      _colorspace.ColorSpace.singletons.rgb.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    case 4:
      _colorspace.ColorSpace.singletons.cmyk.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    default:
      return defaultColor;
  }
}

function getQuadPoints(dict, rect) {
  if (!dict.has("QuadPoints")) {
    return null;
  }

  const quadPoints = dict.getArray("QuadPoints");

  if (!Array.isArray(quadPoints) || quadPoints.length === 0 || quadPoints.length % 8 > 0) {
    return null;
  }

  const quadPointsLists = [];

  for (let i = 0, ii = quadPoints.length / 8; i < ii; i++) {
    quadPointsLists.push([]);

    for (let j = i * 8, jj = i * 8 + 8; j < jj; j += 2) {
      const x = quadPoints[j];
      const y = quadPoints[j + 1];

      if (rect !== null && (x < rect[0] || x > rect[2] || y < rect[1] || y > rect[3])) {
        return null;
      }

      quadPointsLists[i].push({
        x,
        y
      });
    }
  }

  return quadPointsLists.map(quadPointsList => {
    const [minX, maxX, minY, maxY] = quadPointsList.reduce(([mX, MX, mY, MY], quadPoint) => [Math.min(mX, quadPoint.x), Math.max(MX, quadPoint.x), Math.min(mY, quadPoint.y), Math.max(MY, quadPoint.y)], [Number.MAX_VALUE, Number.MIN_VALUE, Number.MAX_VALUE, Number.MIN_VALUE]);
    return [{
      x: minX,
      y: maxY
    }, {
      x: maxX,
      y: maxY
    }, {
      x: minX,
      y: minY
    }, {
      x: maxX,
      y: minY
    }];
  });
}

function getTransformMatrix(rect, bbox, matrix) {
  const [minX, minY, maxX, maxY] = _util.Util.getAxialAlignedBoundingBox(bbox, matrix);

  if (minX === maxX || minY === maxY) {
    return [1, 0, 0, 1, rect[0], rect[1]];
  }

  const xRatio = (rect[2] - rect[0]) / (maxX - minX);
  const yRatio = (rect[3] - rect[1]) / (maxY - minY);
  return [xRatio, 0, 0, yRatio, rect[0] - minX * xRatio, rect[1] - minY * yRatio];
}

class Annotation {
  constructor(params) {
    const dict = params.dict;
    this.setTitle(dict.get("T"));
    this.setContents(dict.get("Contents"));
    this.setModificationDate(dict.get("M"));
    this.setFlags(dict.get("F"));
    this.setRectangle(dict.getArray("Rect"));
    this.setColor(dict.getArray("C"));
    this.setBorderStyle(dict);
    this.setAppearance(dict);
    this.setBorderAndBackgroundColors(dict.get("MK"));
    this._streams = [];

    if (this.appearance) {
      this._streams.push(this.appearance);
    }

    this.data = {
      annotationFlags: this.flags,
      borderStyle: this.borderStyle,
      color: this.color,
      backgroundColor: this.backgroundColor,
      borderColor: this.borderColor,
      contentsObj: this._contents,
      hasAppearance: !!this.appearance,
      id: params.id,
      modificationDate: this.modificationDate,
      rect: this.rectangle,
      subtype: params.subtype,
      hasOwnCanvas: false
    };

    if (params.collectFields) {
      const kids = dict.get("Kids");

      if (Array.isArray(kids)) {
        const kidIds = [];

        for (const kid of kids) {
          if ((0, _primitives.isRef)(kid)) {
            kidIds.push(kid.toString());
          }
        }

        if (kidIds.length !== 0) {
          this.data.kidIds = kidIds;
        }
      }

      this.data.actions = (0, _core_utils.collectActions)(params.xref, dict, _util.AnnotationActionEventType);
      this.data.fieldName = this._constructFieldName(dict);
      this.data.pageIndex = params.pageIndex;
    }

    this._fallbackFontDict = null;
  }

  _hasFlag(flags, flag) {
    return !!(flags & flag);
  }

  _isViewable(flags) {
    return !this._hasFlag(flags, _util.AnnotationFlag.INVISIBLE) && !this._hasFlag(flags, _util.AnnotationFlag.NOVIEW);
  }

  _isPrintable(flags) {
    return this._hasFlag(flags, _util.AnnotationFlag.PRINT) && !this._hasFlag(flags, _util.AnnotationFlag.INVISIBLE);
  }

  mustBeViewed(annotationStorage) {
    const storageEntry = annotationStorage && annotationStorage.get(this.data.id);

    if (storageEntry && storageEntry.hidden !== undefined) {
      return !storageEntry.hidden;
    }

    return this.viewable && !this._hasFlag(this.flags, _util.AnnotationFlag.HIDDEN);
  }

  mustBePrinted(annotationStorage) {
    const storageEntry = annotationStorage && annotationStorage.get(this.data.id);

    if (storageEntry && storageEntry.print !== undefined) {
      return storageEntry.print;
    }

    return this.printable;
  }

  get viewable() {
    if (this.data.quadPoints === null) {
      return false;
    }

    if (this.flags === 0) {
      return true;
    }

    return this._isViewable(this.flags);
  }

  get printable() {
    if (this.data.quadPoints === null) {
      return false;
    }

    if (this.flags === 0) {
      return false;
    }

    return this._isPrintable(this.flags);
  }

  _parseStringHelper(data) {
    const str = typeof data === "string" ? (0, _util.stringToPDFString)(data) : "";
    const dir = str && (0, _bidi.bidi)(str).dir === "rtl" ? "rtl" : "ltr";
    return {
      str,
      dir
    };
  }

  setTitle(title) {
    this._title = this._parseStringHelper(title);
  }

  setContents(contents) {
    this._contents = this._parseStringHelper(contents);
  }

  setModificationDate(modificationDate) {
    this.modificationDate = (0, _util.isString)(modificationDate) ? modificationDate : null;
  }

  setFlags(flags) {
    this.flags = Number.isInteger(flags) && flags > 0 ? flags : 0;
  }

  hasFlag(flag) {
    return this._hasFlag(this.flags, flag);
  }

  setRectangle(rectangle) {
    if (Array.isArray(rectangle) && rectangle.length === 4) {
      this.rectangle = _util.Util.normalizeRect(rectangle);
    } else {
      this.rectangle = [0, 0, 0, 0];
    }
  }

  setColor(color) {
    this.color = getRgbColor(color);
  }

  setBorderAndBackgroundColors(mk) {
    if (mk instanceof _primitives.Dict) {
      this.borderColor = getRgbColor(mk.getArray("BC"), null);
      this.backgroundColor = getRgbColor(mk.getArray("BG"), null);
    } else {
      this.borderColor = this.backgroundColor = null;
    }
  }

  setBorderStyle(borderStyle) {
    this.borderStyle = new AnnotationBorderStyle();

    if (!(0, _primitives.isDict)(borderStyle)) {
      return;
    }

    if (borderStyle.has("BS")) {
      const dict = borderStyle.get("BS");
      const dictType = dict.get("Type");

      if (!dictType || (0, _primitives.isName)(dictType, "Border")) {
        this.borderStyle.setWidth(dict.get("W"), this.rectangle);
        this.borderStyle.setStyle(dict.get("S"));
        this.borderStyle.setDashArray(dict.getArray("D"));
      }
    } else if (borderStyle.has("Border")) {
      const array = borderStyle.getArray("Border");

      if (Array.isArray(array) && array.length >= 3) {
        this.borderStyle.setHorizontalCornerRadius(array[0]);
        this.borderStyle.setVerticalCornerRadius(array[1]);
        this.borderStyle.setWidth(array[2], this.rectangle);

        if (array.length === 4) {
          this.borderStyle.setDashArray(array[3], true);
        }
      }
    } else {
      this.borderStyle.setWidth(0);
    }
  }

  setAppearance(dict) {
    this.appearance = null;
    const appearanceStates = dict.get("AP");

    if (!(0, _primitives.isDict)(appearanceStates)) {
      return;
    }

    const normalAppearanceState = appearanceStates.get("N");

    if ((0, _primitives.isStream)(normalAppearanceState)) {
      this.appearance = normalAppearanceState;
      return;
    }

    if (!(0, _primitives.isDict)(normalAppearanceState)) {
      return;
    }

    const as = dict.get("AS");

    if (!(0, _primitives.isName)(as) || !normalAppearanceState.has(as.name)) {
      return;
    }

    this.appearance = normalAppearanceState.get(as.name);
  }

  loadResources(keys, appearance) {
    return appearance.dict.getAsync("Resources").then(resources => {
      if (!resources) {
        return undefined;
      }

      const objectLoader = new _object_loader.ObjectLoader(resources, keys, resources.xref);
      return objectLoader.load().then(function () {
        return resources;
      });
    });
  }

  getOperatorList(evaluator, task, intent, renderForms, annotationStorage) {
    const data = this.data;
    let appearance = this.appearance;
    const isUsingOwnCanvas = data.hasOwnCanvas && intent & _util.RenderingIntentFlag.DISPLAY;

    if (!appearance) {
      if (!isUsingOwnCanvas) {
        return Promise.resolve(new _operator_list.OperatorList());
      }

      appearance = new _stream.StringStream("");
      appearance.dict = new _primitives.Dict();
    }

    const appearanceDict = appearance.dict;
    const resourcesPromise = this.loadResources(["ExtGState", "ColorSpace", "Pattern", "Shading", "XObject", "Font"], appearance);
    const bbox = appearanceDict.getArray("BBox") || [0, 0, 1, 1];
    const matrix = appearanceDict.getArray("Matrix") || [1, 0, 0, 1, 0, 0];
    const transform = getTransformMatrix(data.rect, bbox, matrix);
    return resourcesPromise.then(resources => {
      const opList = new _operator_list.OperatorList();
      opList.addOp(_util.OPS.beginAnnotation, [data.id, data.rect, transform, matrix, isUsingOwnCanvas]);
      return evaluator.getOperatorList({
        stream: appearance,
        task,
        resources,
        operatorList: opList,
        fallbackFontDict: this._fallbackFontDict
      }).then(() => {
        opList.addOp(_util.OPS.endAnnotation, []);
        this.reset();
        return opList;
      });
    });
  }

  async save(evaluator, task, annotationStorage) {
    return null;
  }

  getFieldObject() {
    if (this.data.kidIds) {
      return {
        id: this.data.id,
        actions: this.data.actions,
        name: this.data.fieldName,
        strokeColor: this.data.borderColor,
        fillColor: this.data.backgroundColor,
        type: "",
        kidIds: this.data.kidIds,
        page: this.data.pageIndex
      };
    }

    return null;
  }

  reset() {
    for (const stream of this._streams) {
      stream.reset();
    }
  }

  _constructFieldName(dict) {
    if (!dict.has("T") && !dict.has("Parent")) {
      (0, _util.warn)("Unknown field name, falling back to empty field name.");
      return "";
    }

    if (!dict.has("Parent")) {
      return (0, _util.stringToPDFString)(dict.get("T"));
    }

    const fieldName = [];

    if (dict.has("T")) {
      fieldName.unshift((0, _util.stringToPDFString)(dict.get("T")));
    }

    let loopDict = dict;
    const visited = new _primitives.RefSet();

    if (dict.objId) {
      visited.put(dict.objId);
    }

    while (loopDict.has("Parent")) {
      loopDict = loopDict.get("Parent");

      if (!(loopDict instanceof _primitives.Dict) || loopDict.objId && visited.has(loopDict.objId)) {
        break;
      }

      if (loopDict.objId) {
        visited.put(loopDict.objId);
      }

      if (loopDict.has("T")) {
        fieldName.unshift((0, _util.stringToPDFString)(loopDict.get("T")));
      }
    }

    return fieldName.join(".");
  }

}

exports.Annotation = Annotation;

class AnnotationBorderStyle {
  constructor() {
    this.width = 1;
    this.style = _util.AnnotationBorderStyleType.SOLID;
    this.dashArray = [3];
    this.horizontalCornerRadius = 0;
    this.verticalCornerRadius = 0;
  }

  setWidth(width, rect = [0, 0, 0, 0]) {
    if ((0, _primitives.isName)(width)) {
      this.width = 0;
      return;
    }

    if (Number.isInteger(width)) {
      if (width > 0) {
        const maxWidth = (rect[2] - rect[0]) / 2;
        const maxHeight = (rect[3] - rect[1]) / 2;

        if (maxWidth > 0 && maxHeight > 0 && (width > maxWidth || width > maxHeight)) {
          (0, _util.warn)(`AnnotationBorderStyle.setWidth - ignoring width: ${width}`);
          width = 1;
        }
      }

      this.width = width;
    }
  }

  setStyle(style) {
    if (!(0, _primitives.isName)(style)) {
      return;
    }

    switch (style.name) {
      case "S":
        this.style = _util.AnnotationBorderStyleType.SOLID;
        break;

      case "D":
        this.style = _util.AnnotationBorderStyleType.DASHED;
        break;

      case "B":
        this.style = _util.AnnotationBorderStyleType.BEVELED;
        break;

      case "I":
        this.style = _util.AnnotationBorderStyleType.INSET;
        break;

      case "U":
        this.style = _util.AnnotationBorderStyleType.UNDERLINE;
        break;

      default:
        break;
    }
  }

  setDashArray(dashArray, forceStyle = false) {
    if (Array.isArray(dashArray) && dashArray.length > 0) {
      let isValid = true;
      let allZeros = true;

      for (const element of dashArray) {
        const validNumber = +element >= 0;

        if (!validNumber) {
          isValid = false;
          break;
        } else if (element > 0) {
          allZeros = false;
        }
      }

      if (isValid && !allZeros) {
        this.dashArray = dashArray;

        if (forceStyle) {
          this.setStyle(_primitives.Name.get("D"));
        }
      } else {
        this.width = 0;
      }
    } else if (dashArray) {
      this.width = 0;
    }
  }

  setHorizontalCornerRadius(radius) {
    if (Number.isInteger(radius)) {
      this.horizontalCornerRadius = radius;
    }
  }

  setVerticalCornerRadius(radius) {
    if (Number.isInteger(radius)) {
      this.verticalCornerRadius = radius;
    }
  }

}

exports.AnnotationBorderStyle = AnnotationBorderStyle;

class MarkupAnnotation extends Annotation {
  constructor(parameters) {
    super(parameters);
    const dict = parameters.dict;

    if (dict.has("IRT")) {
      const rawIRT = dict.getRaw("IRT");
      this.data.inReplyTo = (0, _primitives.isRef)(rawIRT) ? rawIRT.toString() : null;
      const rt = dict.get("RT");
      this.data.replyType = (0, _primitives.isName)(rt) ? rt.name : _util.AnnotationReplyType.REPLY;
    }

    if (this.data.replyType === _util.AnnotationReplyType.GROUP) {
      const parent = dict.get("IRT");
      this.setTitle(parent.get("T"));
      this.data.titleObj = this._title;
      this.setContents(parent.get("Contents"));
      this.data.contentsObj = this._contents;

      if (!parent.has("CreationDate")) {
        this.data.creationDate = null;
      } else {
        this.setCreationDate(parent.get("CreationDate"));
        this.data.creationDate = this.creationDate;
      }

      if (!parent.has("M")) {
        this.data.modificationDate = null;
      } else {
        this.setModificationDate(parent.get("M"));
        this.data.modificationDate = this.modificationDate;
      }

      this.data.hasPopup = parent.has("Popup");

      if (!parent.has("C")) {
        this.data.color = null;
      } else {
        this.setColor(parent.getArray("C"));
        this.data.color = this.color;
      }
    } else {
      this.data.titleObj = this._title;
      this.setCreationDate(dict.get("CreationDate"));
      this.data.creationDate = this.creationDate;
      this.data.hasPopup = dict.has("Popup");

      if (!dict.has("C")) {
        this.data.color = null;
      }
    }

    if (dict.has("RC")) {
      this.data.richText = _factory.XFAFactory.getRichTextAsHtml(dict.get("RC"));
    }
  }

  setCreationDate(creationDate) {
    this.creationDate = (0, _util.isString)(creationDate) ? creationDate : null;
  }

  _setDefaultAppearance({
    xref,
    extra,
    strokeColor,
    fillColor,
    blendMode,
    strokeAlpha,
    fillAlpha,
    pointsCallback
  }) {
    let minX = Number.MAX_VALUE;
    let minY = Number.MAX_VALUE;
    let maxX = Number.MIN_VALUE;
    let maxY = Number.MIN_VALUE;
    const buffer = ["q"];

    if (extra) {
      buffer.push(extra);
    }

    if (strokeColor) {
      buffer.push(`${strokeColor[0]} ${strokeColor[1]} ${strokeColor[2]} RG`);
    }

    if (fillColor) {
      buffer.push(`${fillColor[0]} ${fillColor[1]} ${fillColor[2]} rg`);
    }

    let pointsArray = this.data.quadPoints;

    if (!pointsArray) {
      pointsArray = [[{
        x: this.rectangle[0],
        y: this.rectangle[3]
      }, {
        x: this.rectangle[2],
        y: this.rectangle[3]
      }, {
        x: this.rectangle[0],
        y: this.rectangle[1]
      }, {
        x: this.rectangle[2],
        y: this.rectangle[1]
      }]];
    }

    for (const points of pointsArray) {
      const [mX, MX, mY, MY] = pointsCallback(buffer, points);
      minX = Math.min(minX, mX);
      maxX = Math.max(maxX, MX);
      minY = Math.min(minY, mY);
      maxY = Math.max(maxY, MY);
    }

    buffer.push("Q");
    const formDict = new _primitives.Dict(xref);
    const appearanceStreamDict = new _primitives.Dict(xref);
    appearanceStreamDict.set("Subtype", _primitives.Name.get("Form"));
    const appearanceStream = new _stream.StringStream(buffer.join(" "));
    appearanceStream.dict = appearanceStreamDict;
    formDict.set("Fm0", appearanceStream);
    const gsDict = new _primitives.Dict(xref);

    if (blendMode) {
      gsDict.set("BM", _primitives.Name.get(blendMode));
    }

    if (typeof strokeAlpha === "number") {
      gsDict.set("CA", strokeAlpha);
    }

    if (typeof fillAlpha === "number") {
      gsDict.set("ca", fillAlpha);
    }

    const stateDict = new _primitives.Dict(xref);
    stateDict.set("GS0", gsDict);
    const resources = new _primitives.Dict(xref);
    resources.set("ExtGState", stateDict);
    resources.set("XObject", formDict);
    const appearanceDict = new _primitives.Dict(xref);
    appearanceDict.set("Resources", resources);
    const bbox = this.data.rect = [minX, minY, maxX, maxY];
    appearanceDict.set("BBox", bbox);
    this.appearance = new _stream.StringStream("/GS0 gs /Fm0 Do");
    this.appearance.dict = appearanceDict;

    this._streams.push(this.appearance, appearanceStream);
  }

}

exports.MarkupAnnotation = MarkupAnnotation;

class WidgetAnnotation extends Annotation {
  constructor(params) {
    super(params);
    const dict = params.dict;
    const data = this.data;
    this.ref = params.ref;
    data.annotationType = _util.AnnotationType.WIDGET;

    if (data.fieldName === undefined) {
      data.fieldName = this._constructFieldName(dict);
    }

    if (data.actions === undefined) {
      data.actions = (0, _core_utils.collectActions)(params.xref, dict, _util.AnnotationActionEventType);
    }

    const fieldValue = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "V",
      getArray: true
    });
    data.fieldValue = this._decodeFormValue(fieldValue);
    const defaultFieldValue = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "DV",
      getArray: true
    });
    data.defaultFieldValue = this._decodeFormValue(defaultFieldValue);

    if (fieldValue === undefined && data.defaultFieldValue !== null) {
      data.fieldValue = data.defaultFieldValue;
    }

    data.alternativeText = (0, _util.stringToPDFString)(dict.get("TU") || "");
    const defaultAppearance = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "DA"
    }) || params.acroForm.get("DA");
    this._defaultAppearance = (0, _util.isString)(defaultAppearance) ? defaultAppearance : "";
    data.defaultAppearanceData = (0, _default_appearance.parseDefaultAppearance)(this._defaultAppearance);
    const fieldType = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "FT"
    });
    data.fieldType = (0, _primitives.isName)(fieldType) ? fieldType.name : null;
    const localResources = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "DR"
    });
    const acroFormResources = params.acroForm.get("DR");
    const appearanceResources = this.appearance && this.appearance.dict.get("Resources");
    this._fieldResources = {
      localResources,
      acroFormResources,
      appearanceResources,
      mergedResources: _primitives.Dict.merge({
        xref: params.xref,
        dictArray: [localResources, appearanceResources, acroFormResources],
        mergeSubDicts: true
      })
    };
    data.fieldFlags = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "Ff"
    });

    if (!Number.isInteger(data.fieldFlags) || data.fieldFlags < 0) {
      data.fieldFlags = 0;
    }

    data.readOnly = this.hasFieldFlag(_util.AnnotationFieldFlag.READONLY);
    data.hidden = this._hasFlag(data.annotationFlags, _util.AnnotationFlag.HIDDEN);
  }

  _decodeFormValue(formValue) {
    if (Array.isArray(formValue)) {
      return formValue.filter(item => (0, _util.isString)(item)).map(item => (0, _util.stringToPDFString)(item));
    } else if ((0, _primitives.isName)(formValue)) {
      return (0, _util.stringToPDFString)(formValue.name);
    } else if ((0, _util.isString)(formValue)) {
      return (0, _util.stringToPDFString)(formValue);
    }

    return null;
  }

  hasFieldFlag(flag) {
    return !!(this.data.fieldFlags & flag);
  }

  getOperatorList(evaluator, task, intent, renderForms, annotationStorage) {
    if (renderForms && !(this instanceof SignatureWidgetAnnotation)) {
      return Promise.resolve(new _operator_list.OperatorList());
    }

    if (!this._hasText) {
      return super.getOperatorList(evaluator, task, intent, renderForms, annotationStorage);
    }

    return this._getAppearance(evaluator, task, annotationStorage).then(content => {
      if (this.appearance && content === null) {
        return super.getOperatorList(evaluator, task, intent, renderForms, annotationStorage);
      }

      const operatorList = new _operator_list.OperatorList();

      if (!this._defaultAppearance || content === null) {
        return operatorList;
      }

      const matrix = [1, 0, 0, 1, 0, 0];
      const bbox = [0, 0, this.data.rect[2] - this.data.rect[0], this.data.rect[3] - this.data.rect[1]];
      const transform = getTransformMatrix(this.data.rect, bbox, matrix);
      operatorList.addOp(_util.OPS.beginAnnotation, [this.data.id, this.data.rect, transform, matrix]);
      const stream = new _stream.StringStream(content);
      return evaluator.getOperatorList({
        stream,
        task,
        resources: this._fieldResources.mergedResources,
        operatorList
      }).then(function () {
        operatorList.addOp(_util.OPS.endAnnotation, []);
        return operatorList;
      });
    });
  }

  async save(evaluator, task, annotationStorage) {
    if (!annotationStorage) {
      return null;
    }

    const storageEntry = annotationStorage.get(this.data.id);
    const value = storageEntry && storageEntry.value;

    if (value === this.data.fieldValue || value === undefined) {
      return null;
    }

    let appearance = await this._getAppearance(evaluator, task, annotationStorage);

    if (appearance === null) {
      return null;
    }

    const {
      xref
    } = evaluator;
    const dict = xref.fetchIfRef(this.ref);

    if (!(0, _primitives.isDict)(dict)) {
      return null;
    }

    const bbox = [0, 0, this.data.rect[2] - this.data.rect[0], this.data.rect[3] - this.data.rect[1]];
    const xfa = {
      path: (0, _util.stringToPDFString)(dict.get("T") || ""),
      value
    };
    const newRef = xref.getNewRef();
    const AP = new _primitives.Dict(xref);
    AP.set("N", newRef);
    const encrypt = xref.encrypt;
    let originalTransform = null;
    let newTransform = null;

    if (encrypt) {
      originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
      newTransform = encrypt.createCipherTransform(newRef.num, newRef.gen);
      appearance = newTransform.encryptString(appearance);
    }

    dict.set("V", (0, _util.isAscii)(value) ? value : (0, _util.stringToUTF16BEString)(value));
    dict.set("AP", AP);
    dict.set("M", `D:${(0, _util.getModificationDate)()}`);
    const appearanceDict = new _primitives.Dict(xref);
    appearanceDict.set("Length", appearance.length);
    appearanceDict.set("Subtype", _primitives.Name.get("Form"));
    appearanceDict.set("Resources", this._getSaveFieldResources(xref));
    appearanceDict.set("BBox", bbox);
    const bufferOriginal = [`${this.ref.num} ${this.ref.gen} obj\n`];
    (0, _writer.writeDict)(dict, bufferOriginal, originalTransform);
    bufferOriginal.push("\nendobj\n");
    const bufferNew = [`${newRef.num} ${newRef.gen} obj\n`];
    (0, _writer.writeDict)(appearanceDict, bufferNew, newTransform);
    bufferNew.push(" stream\n", appearance, "\nendstream\nendobj\n");
    return [{
      ref: this.ref,
      data: bufferOriginal.join(""),
      xfa
    }, {
      ref: newRef,
      data: bufferNew.join(""),
      xfa: null
    }];
  }

  async _getAppearance(evaluator, task, annotationStorage) {
    const isPassword = this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD);

    if (!annotationStorage || isPassword) {
      return null;
    }

    const storageEntry = annotationStorage.get(this.data.id);
    let value = storageEntry && storageEntry.value;

    if (value === undefined) {
      return null;
    }

    value = value.trim();

    if (value === "") {
      return "";
    }

    let lineCount = -1;

    if (this.data.multiLine) {
      lineCount = value.split(/\r\n|\r|\n/).length;
    }

    const defaultPadding = 2;
    const hPadding = defaultPadding;
    const totalHeight = this.data.rect[3] - this.data.rect[1];
    const totalWidth = this.data.rect[2] - this.data.rect[0];

    if (!this._defaultAppearance) {
      this.data.defaultAppearanceData = (0, _default_appearance.parseDefaultAppearance)(this._defaultAppearance = "/Helvetica 0 Tf 0 g");
    }

    const [defaultAppearance, fontSize] = this._computeFontSize(totalHeight, lineCount);

    const font = await this._getFontData(evaluator, task);
    let descent = font.descent;

    if (isNaN(descent)) {
      descent = 0;
    }

    const vPadding = defaultPadding + Math.abs(descent) * fontSize;
    const alignment = this.data.textAlignment;

    if (this.data.multiLine) {
      return this._getMultilineAppearance(defaultAppearance, value, font, fontSize, totalWidth, totalHeight, alignment, hPadding, vPadding);
    }

    const encodedString = font.encodeString(value).join("");

    if (this.data.comb) {
      return this._getCombAppearance(defaultAppearance, font, encodedString, totalWidth, hPadding, vPadding);
    }

    if (alignment === 0 || alignment > 2) {
      return "/Tx BMC q BT " + defaultAppearance + ` 1 0 0 1 ${hPadding} ${vPadding} Tm (${(0, _util.escapeString)(encodedString)}) Tj` + " ET Q EMC";
    }

    const renderedText = this._renderText(encodedString, font, fontSize, totalWidth, alignment, hPadding, vPadding);

    return "/Tx BMC q BT " + defaultAppearance + ` 1 0 0 1 0 0 Tm ${renderedText}` + " ET Q EMC";
  }

  async _getFontData(evaluator, task) {
    const operatorList = new _operator_list.OperatorList();
    const initialState = {
      font: null,

      clone() {
        return this;
      }

    };
    const {
      fontName,
      fontSize
    } = this.data.defaultAppearanceData;
    await evaluator.handleSetFont(this._fieldResources.mergedResources, [fontName && _primitives.Name.get(fontName), fontSize], null, operatorList, task, initialState, null);
    return initialState.font;
  }

  _computeFontSize(height, lineCount) {
    let {
      fontSize
    } = this.data.defaultAppearanceData;

    if (!fontSize) {
      const roundWithOneDigit = x => Math.round(x * 10) / 10;

      const FONT_FACTOR = 0.8;

      if (lineCount === -1) {
        fontSize = roundWithOneDigit(FONT_FACTOR * height);
      } else {
        fontSize = 10;
        let lineHeight = fontSize / FONT_FACTOR;
        let numberOfLines = Math.round(height / lineHeight);
        numberOfLines = Math.max(numberOfLines, lineCount);
        lineHeight = height / numberOfLines;
        fontSize = roundWithOneDigit(FONT_FACTOR * lineHeight);
      }

      const {
        fontName,
        fontColor
      } = this.data.defaultAppearanceData;
      this._defaultAppearance = (0, _default_appearance.createDefaultAppearance)({
        fontSize,
        fontName,
        fontColor
      });
    }

    return [this._defaultAppearance, fontSize];
  }

  _renderText(text, font, fontSize, totalWidth, alignment, hPadding, vPadding) {
    const glyphs = font.charsToGlyphs(text);
    const scale = fontSize / 1000;
    let width = 0;

    for (const glyph of glyphs) {
      width += glyph.width * scale;
    }

    let shift;

    if (alignment === 1) {
      shift = (totalWidth - width) / 2;
    } else if (alignment === 2) {
      shift = totalWidth - width - hPadding;
    } else {
      shift = hPadding;
    }

    shift = shift.toFixed(2);
    vPadding = vPadding.toFixed(2);
    return `${shift} ${vPadding} Td (${(0, _util.escapeString)(text)}) Tj`;
  }

  _getSaveFieldResources(xref) {
    const {
      localResources,
      appearanceResources,
      acroFormResources
    } = this._fieldResources;
    const fontName = this.data.defaultAppearanceData && this.data.defaultAppearanceData.fontName;

    if (!fontName) {
      return localResources || _primitives.Dict.empty;
    }

    for (const resources of [localResources, appearanceResources]) {
      if (resources instanceof _primitives.Dict) {
        const localFont = resources.get("Font");

        if (localFont instanceof _primitives.Dict && localFont.has(fontName)) {
          return resources;
        }
      }
    }

    if (acroFormResources instanceof _primitives.Dict) {
      const acroFormFont = acroFormResources.get("Font");

      if (acroFormFont instanceof _primitives.Dict && acroFormFont.has(fontName)) {
        const subFontDict = new _primitives.Dict(xref);
        subFontDict.set(fontName, acroFormFont.getRaw(fontName));
        const subResourcesDict = new _primitives.Dict(xref);
        subResourcesDict.set("Font", subFontDict);
        return _primitives.Dict.merge({
          xref,
          dictArray: [subResourcesDict, localResources],
          mergeSubDicts: true
        });
      }
    }

    return localResources || _primitives.Dict.empty;
  }

  getFieldObject() {
    return null;
  }

}

class TextWidgetAnnotation extends WidgetAnnotation {
  constructor(params) {
    super(params);
    this._hasText = true;
    const dict = params.dict;

    if (!(0, _util.isString)(this.data.fieldValue)) {
      this.data.fieldValue = "";
    }

    let alignment = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "Q"
    });

    if (!Number.isInteger(alignment) || alignment < 0 || alignment > 2) {
      alignment = null;
    }

    this.data.textAlignment = alignment;
    let maximumLength = (0, _core_utils.getInheritableProperty)({
      dict,
      key: "MaxLen"
    });

    if (!Number.isInteger(maximumLength) || maximumLength < 0) {
      maximumLength = null;
    }

    this.data.maxLen = maximumLength;
    this.data.multiLine = this.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE);
    this.data.comb = this.hasFieldFlag(_util.AnnotationFieldFlag.COMB) && !this.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE) && !this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD) && !this.hasFieldFlag(_util.AnnotationFieldFlag.FILESELECT) && this.data.maxLen !== null;
  }

  _getCombAppearance(defaultAppearance, font, text, width, hPadding, vPadding) {
    const combWidth = (width / this.data.maxLen).toFixed(2);
    const buf = [];
    const positions = font.getCharPositions(text);

    for (const [start, end] of positions) {
      buf.push(`(${(0, _util.escapeString)(text.substring(start, end))}) Tj`);
    }

    const renderedComb = buf.join(` ${combWidth} 0 Td `);
    return "/Tx BMC q BT " + defaultAppearance + ` 1 0 0 1 ${hPadding} ${vPadding} Tm ${renderedComb}` + " ET Q EMC";
  }

  _getMultilineAppearance(defaultAppearance, text, font, fontSize, width, height, alignment, hPadding, vPadding) {
    const lines = text.split(/\r\n|\r|\n/);
    const buf = [];
    const totalWidth = width - 2 * hPadding;

    for (const line of lines) {
      const chunks = this._splitLine(line, font, fontSize, totalWidth);

      for (const chunk of chunks) {
        const padding = buf.length === 0 ? hPadding : 0;
        buf.push(this._renderText(chunk, font, fontSize, width, alignment, padding, -fontSize));
      }
    }

    const renderedText = buf.join("\n");
    return "/Tx BMC q BT " + defaultAppearance + ` 1 0 0 1 0 ${height} Tm ${renderedText}` + " ET Q EMC";
  }

  _splitLine(line, font, fontSize, width) {
    line = font.encodeString(line).join("");
    const glyphs = font.charsToGlyphs(line);

    if (glyphs.length <= 1) {
      return [line];
    }

    const positions = font.getCharPositions(line);
    const scale = fontSize / 1000;
    const chunks = [];
    let lastSpacePosInStringStart = -1,
        lastSpacePosInStringEnd = -1,
        lastSpacePos = -1,
        startChunk = 0,
        currentWidth = 0;

    for (let i = 0, ii = glyphs.length; i < ii; i++) {
      const [start, end] = positions[i];
      const glyph = glyphs[i];
      const glyphWidth = glyph.width * scale;

      if (glyph.unicode === " ") {
        if (currentWidth + glyphWidth > width) {
          chunks.push(line.substring(startChunk, start));
          startChunk = start;
          currentWidth = glyphWidth;
          lastSpacePosInStringStart = -1;
          lastSpacePos = -1;
        } else {
          currentWidth += glyphWidth;
          lastSpacePosInStringStart = start;
          lastSpacePosInStringEnd = end;
          lastSpacePos = i;
        }
      } else {
        if (currentWidth + glyphWidth > width) {
          if (lastSpacePosInStringStart !== -1) {
            chunks.push(line.substring(startChunk, lastSpacePosInStringEnd));
            startChunk = lastSpacePosInStringEnd;
            i = lastSpacePos + 1;
            lastSpacePosInStringStart = -1;
            currentWidth = 0;
          } else {
            chunks.push(line.substring(startChunk, start));
            startChunk = start;
            currentWidth = glyphWidth;
          }
        } else {
          currentWidth += glyphWidth;
        }
      }
    }

    if (startChunk < line.length) {
      chunks.push(line.substring(startChunk, line.length));
    }

    return chunks;
  }

  getFieldObject() {
    return {
      id: this.data.id,
      value: this.data.fieldValue,
      defaultValue: this.data.defaultFieldValue,
      multiline: this.data.multiLine,
      password: this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD),
      charLimit: this.data.maxLen,
      comb: this.data.comb,
      editable: !this.data.readOnly,
      hidden: this.data.hidden,
      name: this.data.fieldName,
      rect: this.data.rect,
      actions: this.data.actions,
      page: this.data.pageIndex,
      strokeColor: this.data.borderColor,
      fillColor: this.data.backgroundColor,
      type: "text"
    };
  }

}

class ButtonWidgetAnnotation extends WidgetAnnotation {
  constructor(params) {
    super(params);
    this.checkedAppearance = null;
    this.uncheckedAppearance = null;
    this.data.checkBox = !this.hasFieldFlag(_util.AnnotationFieldFlag.RADIO) && !this.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    this.data.radioButton = this.hasFieldFlag(_util.AnnotationFieldFlag.RADIO) && !this.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    this.data.pushButton = this.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    this.data.isTooltipOnly = false;

    if (this.data.checkBox) {
      this._processCheckBox(params);
    } else if (this.data.radioButton) {
      this._processRadioButton(params);
    } else if (this.data.pushButton) {
      this.data.hasOwnCanvas = true;

      this._processPushButton(params);
    } else {
      (0, _util.warn)("Invalid field flags for button widget annotation");
    }
  }

  async getOperatorList(evaluator, task, intent, renderForms, annotationStorage) {
    if (this.data.pushButton) {
      return super.getOperatorList(evaluator, task, intent, false, annotationStorage);
    }

    let value = null;

    if (annotationStorage) {
      const storageEntry = annotationStorage.get(this.data.id);
      value = storageEntry ? storageEntry.value : null;
    }

    if (value === null) {
      if (this.appearance) {
        return super.getOperatorList(evaluator, task, intent, renderForms, annotationStorage);
      }

      if (this.data.checkBox) {
        value = this.data.fieldValue === this.data.exportValue;
      } else {
        value = this.data.fieldValue === this.data.buttonValue;
      }
    }

    const appearance = value ? this.checkedAppearance : this.uncheckedAppearance;

    if (appearance) {
      const savedAppearance = this.appearance;
      this.appearance = appearance;
      const operatorList = super.getOperatorList(evaluator, task, intent, renderForms, annotationStorage);
      this.appearance = savedAppearance;
      return operatorList;
    }

    return new _operator_list.OperatorList();
  }

  async save(evaluator, task, annotationStorage) {
    if (this.data.checkBox) {
      return this._saveCheckbox(evaluator, task, annotationStorage);
    }

    if (this.data.radioButton) {
      return this._saveRadioButton(evaluator, task, annotationStorage);
    }

    return null;
  }

  async _saveCheckbox(evaluator, task, annotationStorage) {
    if (!annotationStorage) {
      return null;
    }

    const storageEntry = annotationStorage.get(this.data.id);
    const value = storageEntry && storageEntry.value;

    if (value === undefined) {
      return null;
    }

    const defaultValue = this.data.fieldValue === this.data.exportValue;

    if (defaultValue === value) {
      return null;
    }

    const dict = evaluator.xref.fetchIfRef(this.ref);

    if (!(0, _primitives.isDict)(dict)) {
      return null;
    }

    const xfa = {
      path: (0, _util.stringToPDFString)(dict.get("T") || ""),
      value: value ? this.data.exportValue : ""
    };

    const name = _primitives.Name.get(value ? this.data.exportValue : "Off");

    dict.set("V", name);
    dict.set("AS", name);
    dict.set("M", `D:${(0, _util.getModificationDate)()}`);
    const encrypt = evaluator.xref.encrypt;
    let originalTransform = null;

    if (encrypt) {
      originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
    }

    const buffer = [`${this.ref.num} ${this.ref.gen} obj\n`];
    (0, _writer.writeDict)(dict, buffer, originalTransform);
    buffer.push("\nendobj\n");
    return [{
      ref: this.ref,
      data: buffer.join(""),
      xfa
    }];
  }

  async _saveRadioButton(evaluator, task, annotationStorage) {
    if (!annotationStorage) {
      return null;
    }

    const storageEntry = annotationStorage.get(this.data.id);
    const value = storageEntry && storageEntry.value;

    if (value === undefined) {
      return null;
    }

    const defaultValue = this.data.fieldValue === this.data.buttonValue;

    if (defaultValue === value) {
      return null;
    }

    const dict = evaluator.xref.fetchIfRef(this.ref);

    if (!(0, _primitives.isDict)(dict)) {
      return null;
    }

    const xfa = {
      path: (0, _util.stringToPDFString)(dict.get("T") || ""),
      value: value ? this.data.buttonValue : ""
    };

    const name = _primitives.Name.get(value ? this.data.buttonValue : "Off");

    let parentBuffer = null;
    const encrypt = evaluator.xref.encrypt;

    if (value) {
      if ((0, _primitives.isRef)(this.parent)) {
        const parent = evaluator.xref.fetch(this.parent);
        let parentTransform = null;

        if (encrypt) {
          parentTransform = encrypt.createCipherTransform(this.parent.num, this.parent.gen);
        }

        parent.set("V", name);
        parentBuffer = [`${this.parent.num} ${this.parent.gen} obj\n`];
        (0, _writer.writeDict)(parent, parentBuffer, parentTransform);
        parentBuffer.push("\nendobj\n");
      } else if ((0, _primitives.isDict)(this.parent)) {
        this.parent.set("V", name);
      }
    }

    dict.set("AS", name);
    dict.set("M", `D:${(0, _util.getModificationDate)()}`);
    let originalTransform = null;

    if (encrypt) {
      originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
    }

    const buffer = [`${this.ref.num} ${this.ref.gen} obj\n`];
    (0, _writer.writeDict)(dict, buffer, originalTransform);
    buffer.push("\nendobj\n");
    const newRefs = [{
      ref: this.ref,
      data: buffer.join(""),
      xfa
    }];

    if (parentBuffer !== null) {
      newRefs.push({
        ref: this.parent,
        data: parentBuffer.join(""),
        xfa: null
      });
    }

    return newRefs;
  }

  _getDefaultCheckedAppearance(params, type) {
    const width = this.data.rect[2] - this.data.rect[0];
    const height = this.data.rect[3] - this.data.rect[1];
    const bbox = [0, 0, width, height];
    const FONT_RATIO = 0.8;
    const fontSize = Math.min(width, height) * FONT_RATIO;
    let metrics, char;

    if (type === "check") {
      metrics = {
        width: 0.755 * fontSize,
        height: 0.705 * fontSize
      };
      char = "\x33";
    } else if (type === "disc") {
      metrics = {
        width: 0.791 * fontSize,
        height: 0.705 * fontSize
      };
      char = "\x6C";
    } else {
      (0, _util.unreachable)(`_getDefaultCheckedAppearance - unsupported type: ${type}`);
    }

    const xShift = (width - metrics.width) / 2;
    const yShift = (height - metrics.height) / 2;
    const appearance = `q BT /PdfJsZaDb ${fontSize} Tf 0 g ${xShift} ${yShift} Td (${char}) Tj ET Q`;
    const appearanceStreamDict = new _primitives.Dict(params.xref);
    appearanceStreamDict.set("FormType", 1);
    appearanceStreamDict.set("Subtype", _primitives.Name.get("Form"));
    appearanceStreamDict.set("Type", _primitives.Name.get("XObject"));
    appearanceStreamDict.set("BBox", bbox);
    appearanceStreamDict.set("Matrix", [1, 0, 0, 1, 0, 0]);
    appearanceStreamDict.set("Length", appearance.length);
    const resources = new _primitives.Dict(params.xref);
    const font = new _primitives.Dict(params.xref);
    font.set("PdfJsZaDb", this.fallbackFontDict);
    resources.set("Font", font);
    appearanceStreamDict.set("Resources", resources);
    this.checkedAppearance = new _stream.StringStream(appearance);
    this.checkedAppearance.dict = appearanceStreamDict;

    this._streams.push(this.checkedAppearance);
  }

  _processCheckBox(params) {
    const customAppearance = params.dict.get("AP");

    if (!(0, _primitives.isDict)(customAppearance)) {
      return;
    }

    const normalAppearance = customAppearance.get("N");

    if (!(0, _primitives.isDict)(normalAppearance)) {
      return;
    }

    const asValue = this._decodeFormValue(params.dict.get("AS"));

    if (typeof asValue === "string") {
      this.data.fieldValue = asValue;
    }

    const yes = this.data.fieldValue !== null && this.data.fieldValue !== "Off" ? this.data.fieldValue : "Yes";
    const exportValues = normalAppearance.getKeys();

    if (exportValues.length === 0) {
      exportValues.push("Off", yes);
    } else if (exportValues.length === 1) {
      if (exportValues[0] === "Off") {
        exportValues.push(yes);
      } else {
        exportValues.unshift("Off");
      }
    } else if (exportValues.includes(yes)) {
      exportValues.length = 0;
      exportValues.push("Off", yes);
    } else {
      const otherYes = exportValues.find(v => v !== "Off");
      exportValues.length = 0;
      exportValues.push("Off", otherYes);
    }

    if (!exportValues.includes(this.data.fieldValue)) {
      this.data.fieldValue = "Off";
    }

    this.data.exportValue = exportValues[1];
    this.checkedAppearance = normalAppearance.get(this.data.exportValue) || null;
    this.uncheckedAppearance = normalAppearance.get("Off") || null;

    if (this.checkedAppearance) {
      this._streams.push(this.checkedAppearance);
    } else {
      this._getDefaultCheckedAppearance(params, "check");
    }

    if (this.uncheckedAppearance) {
      this._streams.push(this.uncheckedAppearance);
    }

    this._fallbackFontDict = this.fallbackFontDict;
  }

  _processRadioButton(params) {
    this.data.fieldValue = this.data.buttonValue = null;
    const fieldParent = params.dict.get("Parent");

    if ((0, _primitives.isDict)(fieldParent)) {
      this.parent = params.dict.getRaw("Parent");
      const fieldParentValue = fieldParent.get("V");

      if ((0, _primitives.isName)(fieldParentValue)) {
        this.data.fieldValue = this._decodeFormValue(fieldParentValue);
      }
    }

    const appearanceStates = params.dict.get("AP");

    if (!(0, _primitives.isDict)(appearanceStates)) {
      return;
    }

    const normalAppearance = appearanceStates.get("N");

    if (!(0, _primitives.isDict)(normalAppearance)) {
      return;
    }

    for (const key of normalAppearance.getKeys()) {
      if (key !== "Off") {
        this.data.buttonValue = this._decodeFormValue(key);
        break;
      }
    }

    this.checkedAppearance = normalAppearance.get(this.data.buttonValue) || null;
    this.uncheckedAppearance = normalAppearance.get("Off") || null;

    if (this.checkedAppearance) {
      this._streams.push(this.checkedAppearance);
    } else {
      this._getDefaultCheckedAppearance(params, "disc");
    }

    if (this.uncheckedAppearance) {
      this._streams.push(this.uncheckedAppearance);
    }

    this._fallbackFontDict = this.fallbackFontDict;
  }

  _processPushButton(params) {
    if (!params.dict.has("A") && !params.dict.has("AA") && !this.data.alternativeText) {
      (0, _util.warn)("Push buttons without action dictionaries are not supported");
      return;
    }

    this.data.isTooltipOnly = !params.dict.has("A") && !params.dict.has("AA");

    _catalog.Catalog.parseDestDictionary({
      destDict: params.dict,
      resultObj: this.data,
      docBaseUrl: params.pdfManager.docBaseUrl
    });
  }

  getFieldObject() {
    let type = "button";
    let exportValues;

    if (this.data.checkBox) {
      type = "checkbox";
      exportValues = this.data.exportValue;
    } else if (this.data.radioButton) {
      type = "radiobutton";
      exportValues = this.data.buttonValue;
    }

    return {
      id: this.data.id,
      value: this.data.fieldValue || "Off",
      defaultValue: this.data.defaultFieldValue,
      exportValues,
      editable: !this.data.readOnly,
      name: this.data.fieldName,
      rect: this.data.rect,
      hidden: this.data.hidden,
      actions: this.data.actions,
      page: this.data.pageIndex,
      strokeColor: this.data.borderColor,
      fillColor: this.data.backgroundColor,
      type
    };
  }

  get fallbackFontDict() {
    const dict = new _primitives.Dict();
    dict.set("BaseFont", _primitives.Name.get("ZapfDingbats"));
    dict.set("Type", _primitives.Name.get("FallbackType"));
    dict.set("Subtype", _primitives.Name.get("FallbackType"));
    dict.set("Encoding", _primitives.Name.get("ZapfDingbatsEncoding"));
    return (0, _util.shadow)(this, "fallbackFontDict", dict);
  }

}

class ChoiceWidgetAnnotation extends WidgetAnnotation {
  constructor(params) {
    super(params);
    this.data.options = [];
    const options = (0, _core_utils.getInheritableProperty)({
      dict: params.dict,
      key: "Opt"
    });

    if (Array.isArray(options)) {
      const xref = params.xref;

      for (let i = 0, ii = options.length; i < ii; i++) {
        const option = xref.fetchIfRef(options[i]);
        const isOptionArray = Array.isArray(option);
        this.data.options[i] = {
          exportValue: this._decodeFormValue(isOptionArray ? xref.fetchIfRef(option[0]) : option),
          displayValue: this._decodeFormValue(isOptionArray ? xref.fetchIfRef(option[1]) : option)
        };
      }
    }

    if ((0, _util.isString)(this.data.fieldValue)) {
      this.data.fieldValue = [this.data.fieldValue];
    } else if (!this.data.fieldValue) {
      this.data.fieldValue = [];
    }

    this.data.combo = this.hasFieldFlag(_util.AnnotationFieldFlag.COMBO);
    this.data.multiSelect = this.hasFieldFlag(_util.AnnotationFieldFlag.MULTISELECT);
    this._hasText = true;
  }

  getFieldObject() {
    const type = this.data.combo ? "combobox" : "listbox";
    const value = this.data.fieldValue.length > 0 ? this.data.fieldValue[0] : null;
    return {
      id: this.data.id,
      value,
      defaultValue: this.data.defaultFieldValue,
      editable: !this.data.readOnly,
      name: this.data.fieldName,
      rect: this.data.rect,
      numItems: this.data.fieldValue.length,
      multipleSelection: this.data.multiSelect,
      hidden: this.data.hidden,
      actions: this.data.actions,
      items: this.data.options,
      page: this.data.pageIndex,
      strokeColor: this.data.borderColor,
      fillColor: this.data.backgroundColor,
      type
    };
  }

}

class SignatureWidgetAnnotation extends WidgetAnnotation {
  constructor(params) {
    super(params);
    this.data.fieldValue = null;
  }

  getFieldObject() {
    return {
      id: this.data.id,
      value: null,
      page: this.data.pageIndex,
      type: "signature"
    };
  }

}

class TextAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    const DEFAULT_ICON_SIZE = 22;
    super(parameters);
    const dict = parameters.dict;
    this.data.annotationType = _util.AnnotationType.TEXT;

    if (this.data.hasAppearance) {
      this.data.name = "NoIcon";
    } else {
      this.data.rect[1] = this.data.rect[3] - DEFAULT_ICON_SIZE;
      this.data.rect[2] = this.data.rect[0] + DEFAULT_ICON_SIZE;
      this.data.name = dict.has("Name") ? dict.get("Name").name : "Note";
    }

    if (dict.has("State")) {
      this.data.state = dict.get("State") || null;
      this.data.stateModel = dict.get("StateModel") || null;
    } else {
      this.data.state = null;
      this.data.stateModel = null;
    }
  }

}

class LinkAnnotation extends Annotation {
  constructor(params) {
    super(params);
    this.data.annotationType = _util.AnnotationType.LINK;
    const quadPoints = getQuadPoints(params.dict, this.rectangle);

    if (quadPoints) {
      this.data.quadPoints = quadPoints;
    }

    _catalog.Catalog.parseDestDictionary({
      destDict: params.dict,
      resultObj: this.data,
      docBaseUrl: params.pdfManager.docBaseUrl
    });
  }

}

class PopupAnnotation extends Annotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.POPUP;
    let parentItem = parameters.dict.get("Parent");

    if (!parentItem) {
      (0, _util.warn)("Popup annotation has a missing or invalid parent annotation.");
      return;
    }

    const parentSubtype = parentItem.get("Subtype");
    this.data.parentType = (0, _primitives.isName)(parentSubtype) ? parentSubtype.name : null;
    const rawParent = parameters.dict.getRaw("Parent");
    this.data.parentId = (0, _primitives.isRef)(rawParent) ? rawParent.toString() : null;
    const parentRect = parentItem.getArray("Rect");

    if (Array.isArray(parentRect) && parentRect.length === 4) {
      this.data.parentRect = _util.Util.normalizeRect(parentRect);
    } else {
      this.data.parentRect = [0, 0, 0, 0];
    }

    const rt = parentItem.get("RT");

    if ((0, _primitives.isName)(rt, _util.AnnotationReplyType.GROUP)) {
      parentItem = parentItem.get("IRT");
    }

    if (!parentItem.has("M")) {
      this.data.modificationDate = null;
    } else {
      this.setModificationDate(parentItem.get("M"));
      this.data.modificationDate = this.modificationDate;
    }

    if (!parentItem.has("C")) {
      this.data.color = null;
    } else {
      this.setColor(parentItem.getArray("C"));
      this.data.color = this.color;
    }

    if (!this.viewable) {
      const parentFlags = parentItem.get("F");

      if (this._isViewable(parentFlags)) {
        this.setFlags(parentFlags);
      }
    }

    this.setTitle(parentItem.get("T"));
    this.data.titleObj = this._title;
    this.setContents(parentItem.get("Contents"));
    this.data.contentsObj = this._contents;

    if (parentItem.has("RC")) {
      this.data.richText = _factory.XFAFactory.getRichTextAsHtml(parentItem.get("RC"));
    }
  }

}

class FreeTextAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.FREETEXT;
  }

}

class LineAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.LINE;
    const lineCoordinates = parameters.dict.getArray("L");
    this.data.lineCoordinates = _util.Util.normalizeRect(lineCoordinates);

    if (!this.appearance) {
      const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
      const strokeAlpha = parameters.dict.get("CA");
      let fillColor = null,
          interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor, null);
        fillColor = interiorColor ? Array.from(interiorColor).map(c => c / 255) : null;
      }

      const fillAlpha = fillColor ? strokeAlpha : null;
      const borderWidth = this.borderStyle.width || 1,
            borderAdjust = 2 * borderWidth;
      const bbox = [this.data.lineCoordinates[0] - borderAdjust, this.data.lineCoordinates[1] - borderAdjust, this.data.lineCoordinates[2] + borderAdjust, this.data.lineCoordinates[3] + borderAdjust];

      if (!_util.Util.intersect(this.rectangle, bbox)) {
        this.rectangle = bbox;
      }

      this._setDefaultAppearance({
        xref: parameters.xref,
        extra: `${borderWidth} w`,
        strokeColor,
        fillColor,
        strokeAlpha,
        fillAlpha,
        pointsCallback: (buffer, points) => {
          buffer.push(`${lineCoordinates[0]} ${lineCoordinates[1]} m`, `${lineCoordinates[2]} ${lineCoordinates[3]} l`, "S");
          return [points[0].x - borderWidth, points[1].x + borderWidth, points[3].y - borderWidth, points[1].y + borderWidth];
        }
      });
    }
  }

}

class SquareAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.SQUARE;

    if (!this.appearance) {
      const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
      const strokeAlpha = parameters.dict.get("CA");
      let fillColor = null,
          interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor, null);
        fillColor = interiorColor ? Array.from(interiorColor).map(c => c / 255) : null;
      }

      const fillAlpha = fillColor ? strokeAlpha : null;

      if (this.borderStyle.width === 0 && !fillColor) {
        return;
      }

      this._setDefaultAppearance({
        xref: parameters.xref,
        extra: `${this.borderStyle.width} w`,
        strokeColor,
        fillColor,
        strokeAlpha,
        fillAlpha,
        pointsCallback: (buffer, points) => {
          const x = points[2].x + this.borderStyle.width / 2;
          const y = points[2].y + this.borderStyle.width / 2;
          const width = points[3].x - points[2].x - this.borderStyle.width;
          const height = points[1].y - points[3].y - this.borderStyle.width;
          buffer.push(`${x} ${y} ${width} ${height} re`);

          if (fillColor) {
            buffer.push("B");
          } else {
            buffer.push("S");
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }
  }

}

class CircleAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.CIRCLE;

    if (!this.appearance) {
      const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
      const strokeAlpha = parameters.dict.get("CA");
      let fillColor = null;
      let interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor, null);
        fillColor = interiorColor ? Array.from(interiorColor).map(c => c / 255) : null;
      }

      const fillAlpha = fillColor ? strokeAlpha : null;

      if (this.borderStyle.width === 0 && !fillColor) {
        return;
      }

      const controlPointsDistance = 4 / 3 * Math.tan(Math.PI / (2 * 4));

      this._setDefaultAppearance({
        xref: parameters.xref,
        extra: `${this.borderStyle.width} w`,
        strokeColor,
        fillColor,
        strokeAlpha,
        fillAlpha,
        pointsCallback: (buffer, points) => {
          const x0 = points[0].x + this.borderStyle.width / 2;
          const y0 = points[0].y - this.borderStyle.width / 2;
          const x1 = points[3].x - this.borderStyle.width / 2;
          const y1 = points[3].y + this.borderStyle.width / 2;
          const xMid = x0 + (x1 - x0) / 2;
          const yMid = y0 + (y1 - y0) / 2;
          const xOffset = (x1 - x0) / 2 * controlPointsDistance;
          const yOffset = (y1 - y0) / 2 * controlPointsDistance;
          buffer.push(`${xMid} ${y1} m`, `${xMid + xOffset} ${y1} ${x1} ${yMid + yOffset} ${x1} ${yMid} c`, `${x1} ${yMid - yOffset} ${xMid + xOffset} ${y0} ${xMid} ${y0} c`, `${xMid - xOffset} ${y0} ${x0} ${yMid - yOffset} ${x0} ${yMid} c`, `${x0} ${yMid + yOffset} ${xMid - xOffset} ${y1} ${xMid} ${y1} c`, "h");

          if (fillColor) {
            buffer.push("B");
          } else {
            buffer.push("S");
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }
  }

}

class PolylineAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.POLYLINE;
    this.data.vertices = [];
    const rawVertices = parameters.dict.getArray("Vertices");

    if (!Array.isArray(rawVertices)) {
      return;
    }

    for (let i = 0, ii = rawVertices.length; i < ii; i += 2) {
      this.data.vertices.push({
        x: rawVertices[i],
        y: rawVertices[i + 1]
      });
    }

    if (!this.appearance) {
      const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
      const strokeAlpha = parameters.dict.get("CA");
      const borderWidth = this.borderStyle.width || 1,
            borderAdjust = 2 * borderWidth;
      const bbox = [Infinity, Infinity, -Infinity, -Infinity];

      for (const vertex of this.data.vertices) {
        bbox[0] = Math.min(bbox[0], vertex.x - borderAdjust);
        bbox[1] = Math.min(bbox[1], vertex.y - borderAdjust);
        bbox[2] = Math.max(bbox[2], vertex.x + borderAdjust);
        bbox[3] = Math.max(bbox[3], vertex.y + borderAdjust);
      }

      if (!_util.Util.intersect(this.rectangle, bbox)) {
        this.rectangle = bbox;
      }

      this._setDefaultAppearance({
        xref: parameters.xref,
        extra: `${borderWidth} w`,
        strokeColor,
        strokeAlpha,
        pointsCallback: (buffer, points) => {
          const vertices = this.data.vertices;

          for (let i = 0, ii = vertices.length; i < ii; i++) {
            buffer.push(`${vertices[i].x} ${vertices[i].y} ${i === 0 ? "m" : "l"}`);
          }

          buffer.push("S");
          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }
  }

}

class PolygonAnnotation extends PolylineAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.POLYGON;
  }

}

class CaretAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.CARET;
  }

}

class InkAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.INK;
    this.data.inkLists = [];
    const rawInkLists = parameters.dict.getArray("InkList");

    if (!Array.isArray(rawInkLists)) {
      return;
    }

    const xref = parameters.xref;

    for (let i = 0, ii = rawInkLists.length; i < ii; ++i) {
      this.data.inkLists.push([]);

      for (let j = 0, jj = rawInkLists[i].length; j < jj; j += 2) {
        this.data.inkLists[i].push({
          x: xref.fetchIfRef(rawInkLists[i][j]),
          y: xref.fetchIfRef(rawInkLists[i][j + 1])
        });
      }
    }

    if (!this.appearance) {
      const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
      const strokeAlpha = parameters.dict.get("CA");
      const borderWidth = this.borderStyle.width || 1,
            borderAdjust = 2 * borderWidth;
      const bbox = [Infinity, Infinity, -Infinity, -Infinity];

      for (const inkLists of this.data.inkLists) {
        for (const vertex of inkLists) {
          bbox[0] = Math.min(bbox[0], vertex.x - borderAdjust);
          bbox[1] = Math.min(bbox[1], vertex.y - borderAdjust);
          bbox[2] = Math.max(bbox[2], vertex.x + borderAdjust);
          bbox[3] = Math.max(bbox[3], vertex.y + borderAdjust);
        }
      }

      if (!_util.Util.intersect(this.rectangle, bbox)) {
        this.rectangle = bbox;
      }

      this._setDefaultAppearance({
        xref: parameters.xref,
        extra: `${borderWidth} w`,
        strokeColor,
        strokeAlpha,
        pointsCallback: (buffer, points) => {
          for (const inkList of this.data.inkLists) {
            for (let i = 0, ii = inkList.length; i < ii; i++) {
              buffer.push(`${inkList[i].x} ${inkList[i].y} ${i === 0 ? "m" : "l"}`);
            }

            buffer.push("S");
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }
  }

}

class HighlightAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.HIGHLIGHT;
    const quadPoints = this.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      const resources = this.appearance && this.appearance.dict.get("Resources");

      if (!this.appearance || !(resources && resources.has("ExtGState"))) {
        if (this.appearance) {
          (0, _util.warn)("HighlightAnnotation - ignoring built-in appearance stream.");
        }

        const fillColor = this.color ? Array.from(this.color).map(c => c / 255) : [1, 1, 0];
        const fillAlpha = parameters.dict.get("CA");

        this._setDefaultAppearance({
          xref: parameters.xref,
          fillColor,
          blendMode: "Multiply",
          fillAlpha,
          pointsCallback: (buffer, points) => {
            buffer.push(`${points[0].x} ${points[0].y} m`, `${points[1].x} ${points[1].y} l`, `${points[3].x} ${points[3].y} l`, `${points[2].x} ${points[2].y} l`, "f");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      this.data.hasPopup = false;
    }
  }

}

class UnderlineAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.UNDERLINE;
    const quadPoints = this.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!this.appearance) {
        const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
        const strokeAlpha = parameters.dict.get("CA");

        this._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor,
          strokeAlpha,
          pointsCallback: (buffer, points) => {
            buffer.push(`${points[2].x} ${points[2].y} m`, `${points[3].x} ${points[3].y} l`, "S");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      this.data.hasPopup = false;
    }
  }

}

class SquigglyAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.SQUIGGLY;
    const quadPoints = this.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!this.appearance) {
        const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
        const strokeAlpha = parameters.dict.get("CA");

        this._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor,
          strokeAlpha,
          pointsCallback: (buffer, points) => {
            const dy = (points[0].y - points[2].y) / 6;
            let shift = dy;
            let x = points[2].x;
            const y = points[2].y;
            const xEnd = points[3].x;
            buffer.push(`${x} ${y + shift} m`);

            do {
              x += 2;
              shift = shift === 0 ? dy : 0;
              buffer.push(`${x} ${y + shift} l`);
            } while (x < xEnd);

            buffer.push("S");
            return [points[2].x, xEnd, y - 2 * dy, y + 2 * dy];
          }
        });
      }
    } else {
      this.data.hasPopup = false;
    }
  }

}

class StrikeOutAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.STRIKEOUT;
    const quadPoints = this.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!this.appearance) {
        const strokeColor = this.color ? Array.from(this.color).map(c => c / 255) : [0, 0, 0];
        const strokeAlpha = parameters.dict.get("CA");

        this._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor,
          strokeAlpha,
          pointsCallback: (buffer, points) => {
            buffer.push(`${(points[0].x + points[2].x) / 2} ` + `${(points[0].y + points[2].y) / 2} m`, `${(points[1].x + points[3].x) / 2} ` + `${(points[1].y + points[3].y) / 2} l`, "S");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      this.data.hasPopup = false;
    }
  }

}

class StampAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    this.data.annotationType = _util.AnnotationType.STAMP;
  }

}

class FileAttachmentAnnotation extends MarkupAnnotation {
  constructor(parameters) {
    super(parameters);
    const file = new _file_spec.FileSpec(parameters.dict.get("FS"), parameters.xref);
    this.data.annotationType = _util.AnnotationType.FILEATTACHMENT;
    this.data.file = file.serializable;
  }

}

/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createDefaultAppearance = createDefaultAppearance;
exports.parseDefaultAppearance = parseDefaultAppearance;

var _util = __w_pdfjs_require__(2);

var _colorspace = __w_pdfjs_require__(24);

var _core_utils = __w_pdfjs_require__(9);

var _evaluator = __w_pdfjs_require__(25);

var _primitives = __w_pdfjs_require__(5);

var _stream = __w_pdfjs_require__(10);

class DefaultAppearanceEvaluator extends _evaluator.EvaluatorPreprocessor {
  constructor(str) {
    super(new _stream.StringStream(str));
  }

  parse() {
    const operation = {
      fn: 0,
      args: []
    };
    const result = {
      fontSize: 0,
      fontName: "",
      fontColor: new Uint8ClampedArray(3)
    };

    try {
      while (true) {
        operation.args.length = 0;

        if (!this.read(operation)) {
          break;
        }

        if (this.savedStatesDepth !== 0) {
          continue;
        }

        const {
          fn,
          args
        } = operation;

        switch (fn | 0) {
          case _util.OPS.setFont:
            const [fontName, fontSize] = args;

            if (fontName instanceof _primitives.Name) {
              result.fontName = fontName.name;
            }

            if (typeof fontSize === "number" && fontSize > 0) {
              result.fontSize = fontSize;
            }

            break;

          case _util.OPS.setFillRGBColor:
            _colorspace.ColorSpace.singletons.rgb.getRgbItem(args, 0, result.fontColor, 0);

            break;

          case _util.OPS.setFillGray:
            _colorspace.ColorSpace.singletons.gray.getRgbItem(args, 0, result.fontColor, 0);

            break;

          case _util.OPS.setFillColorSpace:
            _colorspace.ColorSpace.singletons.cmyk.getRgbItem(args, 0, result.fontColor, 0);

            break;
        }
      }
    } catch (reason) {
      (0, _util.warn)(`parseDefaultAppearance - ignoring errors: "${reason}".`);
    }

    return result;
  }

}

function parseDefaultAppearance(str) {
  return new DefaultAppearanceEvaluator(str).parse();
}

function createDefaultAppearance({
  fontSize,
  fontName,
  fontColor
}) {
  let colorCmd;

  if (fontColor.every(c => c === 0)) {
    colorCmd = "0 g";
  } else {
    colorCmd = Array.from(fontColor).map(c => (c / 255).toFixed(2)).join(" ") + " rg";
  }

  return `/${(0, _core_utils.escapePDFName)(fontName)} ${fontSize} Tf ${colorCmd}`;
}

/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ColorSpace = void 0;

var _util = __w_pdfjs_require__(2);

var _primitives = __w_pdfjs_require__(5);

var _core_utils = __w_pdfjs_require__(9);

function resizeRgbImage(src, dest, w1, h1, w2, h2, alpha01) {
  const COMPONENTS = 3;
  alpha01 = alpha01 !== 1 ? 0 : alpha01;
  const xRatio = w1 / w2;
  const yRatio = h1 / h2;
  let newIndex = 0,
      oldIndex;
  const xScaled = new Uint16Array(w2);
  const w1Scanline = w1 * COMPONENTS;

  for (let i = 0; i < w2; i++) {
    xScaled[i] = Math.floor(i * xRatio) * COMPONENTS;
  }

  for (let i = 0; i < h2; i++) {
    const py = Math.floor(i * yRatio) * w1Scanline;

    for (let j = 0; j < w2; j++) {
      oldIndex = py + xScaled[j];
      dest[newIndex++] = src[oldIndex++];
      dest[newIndex++] = src[oldIndex++];
      dest[newIndex++] = src[oldIndex++];
      newIndex += alpha01;
    }
  }
}

class ColorSpace {
  constructor(name, numComps) {
    if (this.constructor === ColorSpace) {
      (0, _util.unreachable)("Cannot initialize ColorSpace.");
    }

    this.name = name;
    this.numComps = numComps;
  }

  getRgb(src, srcOffset) {
    const rgb = new Uint8ClampedArray(3);
    this.getRgbItem(src, srcOffset, rgb, 0);
    return rgb;
  }

  getRgbItem(src, srcOffset, dest, destOffset) {
    (0, _util.unreachable)("Should not call ColorSpace.getRgbItem");
  }

  getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
    (0, _util.unreachable)("Should not call ColorSpace.getRgbBuffer");
  }

  getOutputLength(inputLength, alpha01) {
    (0, _util.unreachable)("Should not call ColorSpace.getOutputLength");
  }

  isPassthrough(bits) {
    return false;
  }

  isDefaultDecode(decodeMap, bpc) {
    return ColorSpace.isDefaultDecode(decodeMap, this.numComps);
  }

  fillRgb(dest, originalWidth, originalHeight, width, height, actualHeight, bpc, comps, alpha01) {
    const count = originalWidth * originalHeight;
    let rgbBuf = null;
    const numComponentColors = 1 << bpc;
    const needsResizing = originalHeight !== height || originalWidth !== width;

    if (this.isPassthrough(bpc)) {
      rgbBuf = comps;
    } else if (this.numComps === 1 && count > numComponentColors && this.name !== "DeviceGray" && this.name !== "DeviceRGB") {
      const allColors = bpc <= 8 ? new Uint8Array(numComponentColors) : new Uint16Array(numComponentColors);

      for (let i = 0; i < numComponentColors; i++) {
        allColors[i] = i;
      }

      const colorMap = new Uint8ClampedArray(numComponentColors * 3);
      this.getRgbBuffer(allColors, 0, numComponentColors, colorMap, 0, bpc, 0);

      if (!needsResizing) {
        let destPos = 0;

        for (let i = 0; i < count; ++i) {
          const key = comps[i] * 3;
          dest[destPos++] = colorMap[key];
          dest[destPos++] = colorMap[key + 1];
          dest[destPos++] = colorMap[key + 2];
          destPos += alpha01;
        }
      } else {
        rgbBuf = new Uint8Array(count * 3);
        let rgbPos = 0;

        for (let i = 0; i < count; ++i) {
          const key = comps[i] * 3;
          rgbBuf[rgbPos++] = colorMap[key];
          rgbBuf[rgbPos++] = colorMap[key + 1];
          rgbBuf[rgbPos++] = colorMap[key + 2];
        }
      }
    } else {
      if (!needsResizing) {
        this.getRgbBuffer(comps, 0, width * actualHeight, dest, 0, bpc, alpha01);
      } else {
        rgbBuf = new Uint8ClampedArray(count * 3);
        this.getRgbBuffer(comps, 0, count, rgbBuf, 0, bpc, 0);
      }
    }

    if (rgbBuf) {
      if (needsResizing) {
        resizeRgbImage(rgbBuf, dest, originalWidth, originalHeight, width, height, alpha01);
      } else {
        let destPos = 0,
            rgbPos = 0;

        for (let i = 0, ii = width * actualHeight; i < ii; i++) {
          dest[destPos++] = rgbBuf[rgbPos++];
          dest[destPos++] = rgbBuf[rgbPos++];
          dest[destPos++] = rgbBuf[rgbPos++];
          destPos += alpha01;
        }
      }
    }
  }

  get usesZeroToOneRange() {
    return (0, _util.shadow)(this, "usesZeroToOneRange", true);
  }

  static _cache(cacheKey, xref, localColorSpaceCache, parsedColorSpace) {
    if (!localColorSpaceCache) {
      throw new Error('ColorSpace._cache - expected "localColorSpaceCache" argument.');
    }

    if (!parsedColorSpace) {
      throw new Error('ColorSpace._cache - expected "parsedColorSpace" argument.');
    }

    let csName, csRef;

    if (cacheKey instanceof _primitives.Ref) {
      csRef = cacheKey;
      cacheKey = xref.fetch(cacheKey);
    }

    if (cacheKey instanceof _primitives.Name) {
      csName = cacheKey.name;
    }

    if (csName || csRef) {
      localColorSpaceCache.set(csName, csRef, parsedColorSpace);
    }
  }

  static getCached(cacheKey, xref, localColorSpaceCache) {
    if (!localColorSpaceCache) {
      throw new Error('ColorSpace.getCached - expected "localColorSpaceCache" argument.');
    }

    if (cacheKey instanceof _primitives.Ref) {
      const localColorSpace = localColorSpaceCache.getByRef(cacheKey);

      if (localColorSpace) {
        return localColorSpace;
      }

      try {
        cacheKey = xref.fetch(cacheKey);
      } catch (ex) {
        if (ex instanceof _core_utils.MissingDataException) {
          throw ex;
        }
      }
    }

    if (cacheKey instanceof _primitives.Name) {
      const localColorSpace = localColorSpaceCache.getByName(cacheKey.name);

      if (localColorSpace) {
        return localColorSpace;
      }
    }

    return null;
  }

  static async parseAsync({
    cs,
    xref,
    resources = null,
    pdfFunctionFactory,
    localColorSpaceCache
  }) {
    const parsedColorSpace = this._parse(cs, xref, resources, pdfFunctionFactory);

    this._cache(cs, xref, localColorSpaceCache, parsedColorSpace);

    return parsedColorSpace;
  }

  static parse({
    cs,
    xref,
    resources = null,
    pdfFunctionFactory,
    localColorSpaceCache
  }) {
    const cachedColorSpace = this.getCached(cs, xref, localColorSpaceCache);

    if (cachedColorSpace) {
      return cachedColorSpace;
    }

    const parsedColorSpace = this._parse(cs, xref, resources, pdfFunctionFactory);

    this._cache(cs, xref, localColorSpaceCache, parsedColorSpace);

    return parsedColorSpace;
  }

  static _parse(cs, xref, resources = null, pdfFunctionFactory) {
    cs = xref.fetchIfRef(cs);

    if ((0, _primitives.isName)(cs)) {
      switch (cs.name) {
        case "G":
        case "DeviceGray":
          return this.singletons.gray;

        case "RGB":
        case "DeviceRGB":
          return this.singletons.rgb;

        case "CMYK":
        case "DeviceCMYK":
          return this.singletons.cmyk;

        case "Pattern":
          return new PatternCS(null);

        default:
          if ((0, _primitives.isDict)(resources)) {
            const colorSpaces = resources.get("ColorSpace");

            if ((0, _primitives.isDict)(colorSpaces)) {
              const resourcesCS = colorSpaces.get(cs.name);

              if (resourcesCS) {
                if ((0, _primitives.isName)(resourcesCS)) {
                  return this._parse(resourcesCS, xref, resources, pdfFunctionFactory);
                }

                cs = resourcesCS;
                break;
              }
            }
          }

          throw new _util.FormatError(`Unrecognized ColorSpace: ${cs.name}`);
      }
    }

    if (Array.isArray(cs)) {
      const mode = xref.fetchIfRef(cs[0]).name;
      let params, numComps, baseCS, whitePoint, blackPoint, gamma;

      switch (mode) {
        case "G":
        case "DeviceGray":
          return this.singletons.gray;

        case "RGB":
        case "DeviceRGB":
          return this.singletons.rgb;

        case "CMYK":
        case "DeviceCMYK":
          return this.singletons.cmyk;

        case "CalGray":
          params = xref.fetchIfRef(cs[1]);
          whitePoint = params.getArray("WhitePoint");
          blackPoint = params.getArray("BlackPoint");
          gamma = params.get("Gamma");
          return new CalGrayCS(whitePoint, blackPoint, gamma);

        case "CalRGB":
          params = xref.fetchIfRef(cs[1]);
          whitePoint = params.getArray("WhitePoint");
          blackPoint = params.getArray("BlackPoint");
          gamma = params.getArray("Gamma");
          const matrix = params.getArray("Matrix");
          return new CalRGBCS(whitePoint, blackPoint, gamma, matrix);

        case "ICCBased":
          const stream = xref.fetchIfRef(cs[1]);
          const dict = stream.dict;
          numComps = dict.get("N");
          const alt = dict.get("Alternate");

          if (alt) {
            const altCS = this._parse(alt, xref, resources, pdfFunctionFactory);

            if (altCS.numComps === numComps) {
              return altCS;
            }

            (0, _util.warn)("ICCBased color space: Ignoring incorrect /Alternate entry.");
          }

          if (numComps === 1) {
            return this.singletons.gray;
          } else if (numComps === 3) {
            return this.singletons.rgb;
          } else if (numComps === 4) {
            return this.singletons.cmyk;
          }

          break;

        case "Pattern":
          baseCS = cs[1] || null;

          if (baseCS) {
            baseCS = this._parse(baseCS, xref, resources, pdfFunctionFactory);
          }

          return new PatternCS(baseCS);

        case "I":
        case "Indexed":
          baseCS = this._parse(cs[1], xref, resources, pdfFunctionFactory);
          const hiVal = xref.fetchIfRef(cs[2]) + 1;
          const lookup = xref.fetchIfRef(cs[3]);
          return new IndexedCS(baseCS, hiVal, lookup);

        case "Separation":
        case "DeviceN":
          const name = xref.fetchIfRef(cs[1]);
          numComps = Array.isArray(name) ? name.length : 1;
          baseCS = this._parse(cs[2], xref, resources, pdfFunctionFactory);
          const tintFn = pdfFunctionFactory.create(cs[3]);
          return new AlternateCS(numComps, baseCS, tintFn);

        case "Lab":
          params = xref.fetchIfRef(cs[1]);
          whitePoint = params.getArray("WhitePoint");
          blackPoint = params.getArray("BlackPoint");
          const range = params.getArray("Range");
          return new LabCS(whitePoint, blackPoint, range);

        default:
          throw new _util.FormatError(`Unimplemented ColorSpace object: ${mode}`);
      }
    }

    throw new _util.FormatError(`Unrecognized ColorSpace object: ${cs}`);
  }

  static isDefaultDecode(decode, numComps) {
    if (!Array.isArray(decode)) {
      return true;
    }

    if (numComps * 2 !== decode.length) {
      (0, _util.warn)("The decode map is not the correct length");
      return true;
    }

    for (let i = 0, ii = decode.length; i < ii; i += 2) {
      if (decode[i] !== 0 || decode[i + 1] !== 1) {
        return false;
      }
    }

    return true;
  }

  static get singletons() {
    return (0, _util.shadow)(this, "singletons", {
      get gray() {
        return (0, _util.shadow)(this, "gray", new DeviceGrayCS());
      },

      get rgb() {
        return (0, _util.shadow)(this, "rgb", new DeviceRgbCS());
      },

      get cmyk() {
        return (0, _util.shadow)(this, "cmyk", new DeviceCmykCS());
      }

    });
  }

}

exports.ColorSpace = ColorSpace;

class AlternateCS extends ColorSpace {
  constructor(numComps, base, tintFn) {
    super("Alternate", numComps);
    this.base = base;
    this.tintFn = tintFn;
    this.tmpBuf = new Float32Array(base.numComps);
  }

  getRgbItem(src, srcOffset, dest, destOffset) {
    const tmpBuf = this.tmpBuf;
    this.tintFn(src, srcOffset, tmpBuf, 0);
    this.base.getRgbItem(tmpBuf, 0, dest, destOffset);
  }

  getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
    const tintFn = this.tintFn;
    const base = this.base;
    const scale = 1 / ((1 << bits) - 1);
    const baseNumComps = base.numComps;
    const usesZeroToOneRange = base.usesZeroToOneRange;
    const isPassthrough = (base.isPassthrough(8) || !usesZeroToOneRange) && alpha01 === 0;
    let pos = isPassthrough ? destOffset : 0;
    const baseBuf = isPassthrough ? dest : new Uint8ClampedArray(baseNumComps * count);
    const numComps = this.numComps;
    const scaled = new Float32Array(numComps);
    const tinted = new Float32Array(baseNumComps);
    let i, j;

    for (i = 0; i < count; i++) {
      for (j = 0; j < numComps; j++) {
        scaled[j] = src[srcOffset++] * scale;
      }

      tintFn(scaled, 0, tinted, 0);

      if (usesZeroToOneRange) {
        for (j = 0; j < baseNumComps; j++) {
          baseBuf[pos++] = tinted[j] * 255;
        }
      } else {
        base.getRgbItem(tinted, 0, baseBuf, pos);
        pos += baseNumComps;
      }
    }

    if (!isPassthrough) {
      base.getRgbBuffer(baseBuf, 0, count, dest, destOffset, 8, alpha01);
    }
  }

  getOutputLength(inputLength, alpha01) {
    return this.base.getOutputLength(inputLength * this.base.numComps / this.numComps, alpha01);
  }

}

class PatternCS extends ColorSpace {
  constructor(baseCS) {
    super("Pattern", null);
    this.base = baseCS;
  }

  isDefaultDecode(decodeMap, bpc) {
    (0, _util.unreachable)("Should not call PatternCS.isDefaultDecode");
  }

}

class IndexedCS extends ColorSpace {
  constructor(base, highVal, lookup) {
    super("Indexed", 1);
    this.base = base;
    this.highVal = highVal;
    const length = base.numComps * highVal;
    this.lookup = new Uint8Array(length);

    if ((0, _primitives.isStream)(lookup)) {
      const bytes = lookup.getBytes(length);
      this.lookup.set(bytes);
    } else if (typeof lookup === "string") {
      for (let i = 0; i < length; ++i) {
        this.lookup[i] = lookup.charCodeAt(i) & 0xff;
      }
    } else {
      throw new _util.FormatError(`IndexedCS - unrecognized lookup table: ${lookup}`);
    }
  }

  getRgbItem(src, srcOffset, dest, destOffset) {
    const numComps = this.base.numComps;
    const start = src[srcOffset] * numComps;
    this.base.getRgbBuffer(this.lookup, start, 1, dest, destOffset, 8, 0);
  }

  getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
    const base = this.base;
    const numComps = base.numComps;
    const outputDelta = base.getOutputLength(numComps, alpha01);
    const lookup = this.lookup;

    for (let i = 0; i < count; ++i) {
      const lookupPos = src[srcOffset++] * numComps;
      base.getRgbBuffer(lookup, lookupPos, 1, dest, destOffset, 8, alpha01);
      destOffset += outputDelta;
    }
  }

  getOutputLength(inputLength, alpha01) {
    return this.base.getOutputLength(inputLength * this.base.numComps, alpha01);
  }

  isDefaultDecode(decodeMap, bpc) {
    if (!Array.isArray(decodeMap)) {
      return true;
    }

    if (decodeMap.length !== 2) {
      (0, _util.warn)("Decode map length is not correct");
      return true;
    }

    if (!Number.isInteger(bpc) || bpc < 1) {
      (0, _util.warn)("Bits per component is not correct");
      return true;
    }

    return decodeMap[0] === 0 && decodeMap[1] === (1 << bpc) - 1;
  }

}

class DeviceGrayCS extends ColorSpace {
  constructor() {
    super("DeviceGray", 1);
  }

  getRgbItem(src, srcOffset, dest, destOffset) {
    const c = src[srcOffset] * 255;
    dest[destOffset] = dest[destOffset + 1] = dest[destOffset + 2] = c;
  }

  getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
    const scale = 255 / ((1 << bits) - 1);
    let j = srcOffset,
        q = destOffset;

    for (let i = 0; i < count; ++i) {
      const c = scale * src[j++];
      dest[q++] = c;
      dest[q++] = c;
      dest[q++] = c;
      q += alpha01;
    }
  }

  getOutputLength(inputLength, alpha01) {
    return inputLength * (3 + alpha01);
  }

}

class DeviceRgbCS extends ColorSpace {
  constructor() {
    super("DeviceRGB", 3);
  }

  getRgbItem(src, srcOffset, dest, destOffset) {
    dest[destOffset] = src[srcOffset] * 255;
    dest[destOffset + 1] = src[srcOffset + 1] * 255;
    dest[destOffset + 2] = src[srcOffset + 2] * 255;
  }

  getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
    if (bits === 8 && alpha01 === 0) {
      dest.set(src.subarray(srcOffset, srcOffset + count * 3), destOffset);
      return;
    }

    const scale = 255 / ((1 << bits) - 1);
    let j = srcOffset,
        q = destOffset;

    for (let i = 0; i < count; ++i) {
      dest[q++] = scale * src[j++];
      dest[q++] = scale * src[j++];
      dest[q++] = scale * src[j++];
      q += alpha01;
    }
  }

  getOutputLength(inputLength, alpha01) {
    return inputLength * (3 + alpha01) / 3 | 0;
  }

  isPassthrough(bits) {
    return bits === 8;
  }

}

const DeviceCmykCS = function DeviceCmykCSClosure() {
  function convertToRgb(src, srcOffset, srcScale, dest, destOffset) {
    const c = src[srcOffset] * srcScale;
    const m = src[srcOffset + 1] * srcScale;
    const y = src[srcOffset + 2] * srcScale;
    const k = src[srcOffset + 3] * srcScale;
    dest[destOffset] = 255 + c * (-4.387332384609988 * c + 54.48615194189176 * m + 18.82290502165302 * y + 212.25662451639585 * k + -285.2331026137004) + m * (1.7149763477362134 * m - 5.6096736904047315 * y + -17.873870861415444 * k - 5.497006427196366) + y * (-2.5217340131683033 * y - 21.248923337353073 * k + 17.5119270841813) + k * (-21.86122147463605 * k - 189.48180835922747);
    dest[destOffset + 1] = 255 + c * (8.841041422036149 * c + 60.118027045597366 * m + 6.871425592049007 * y + 31.159100130055922 * k + -79.2970844816548) + m * (-15.310361306967817 * m + 17.575251261109482 * y + 131.35250912493976 * k - 190.9453302588951) + y * (4.444339102852739 * y + 9.8632861493405 * k - 24.86741582555878) + k * (-20.737325471181034 * k - 187.80453709719578);
    dest[destOffset + 2] = 255 + c * (0.8842522430003296 * c + 8.078677503112928 * m + 30.89978309703729 * y - 0.23883238689178934 * k + -14.183576799673286) + m * (10.49593273432072 * m + 63.02378494754052 * y + 50.606957656360734 * k - 112.23884253719248) + y * (0.03296041114873217 * y + 115.60384449646641 * k + -193.58209356861505) + k * (-22.33816807309886 * k - 180.12613974708367);
  }

  class DeviceCmykCS extends ColorSpace {
    constructor() {
      super("DeviceCMYK", 4);
    }

    getRgbItem(src, srcOffset, dest, destOffset) {
      convertToRgb(src, srcOffset, 1, dest, destOffset);
    }

    getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      const scale = 1 / ((1 << bits) - 1);

      for (let i = 0; i < count; i++) {
        convertToRgb(src, srcOffset, scale, dest, destOffset);
        srcOffset += 4;
        destOffset += 3 + alpha01;
      }
    }

    getOutputLength(inputLength, alpha01) {
      return inputLength / 4 * (3 + alpha01) | 0;
    }

  }

  return DeviceCmykCS;
}();

const CalGrayCS = function CalGrayCSClosure() {
  function convertToRgb(cs, src, srcOffset, dest, destOffset, scale) {
    const A = src[srcOffset] * scale;
    const AG = A ** cs.G;
    const L = cs.YW * AG;
    const val = Math.max(295.8 * L ** 0.3333333333333333 - 40.8, 0);
    dest[destOffset] = val;
    dest[destOffset + 1] = val;
    dest[destOffset + 2] = val;
  }

  class CalGrayCS extends ColorSpace {
    constructor(whitePoint, blackPoint, gamma) {
      super("CalGray", 1);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space CalGray");
      }

      blackPoint = blackPoint || [0, 0, 0];
      gamma = gamma || 1;
      this.XW = whitePoint[0];
      this.YW = whitePoint[1];
      this.ZW = whitePoint[2];
      this.XB = blackPoint[0];
      this.YB = blackPoint[1];
      this.ZB = blackPoint[2];
      this.G = gamma;

      if (this.XW < 0 || this.ZW < 0 || this.YW !== 1) {
        throw new _util.FormatError(`Invalid WhitePoint components for ${this.name}` + ", no fallback available");
      }

      if (this.XB < 0 || this.YB < 0 || this.ZB < 0) {
        (0, _util.info)(`Invalid BlackPoint for ${this.name}, falling back to default.`);
        this.XB = this.YB = this.ZB = 0;
      }

      if (this.XB !== 0 || this.YB !== 0 || this.ZB !== 0) {
        (0, _util.warn)(`${this.name}, BlackPoint: XB: ${this.XB}, YB: ${this.YB}, ` + `ZB: ${this.ZB}, only default values are supported.`);
      }

      if (this.G < 1) {
        (0, _util.info)(`Invalid Gamma: ${this.G} for ${this.name}, ` + "falling back to default.");
        this.G = 1;
      }
    }

    getRgbItem(src, srcOffset, dest, destOffset) {
      convertToRgb(this, src, srcOffset, dest, destOffset, 1);
    }

    getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      const scale = 1 / ((1 << bits) - 1);

      for (let i = 0; i < count; ++i) {
        convertToRgb(this, src, srcOffset, dest, destOffset, scale);
        srcOffset += 1;
        destOffset += 3 + alpha01;
      }
    }

    getOutputLength(inputLength, alpha01) {
      return inputLength * (3 + alpha01);
    }

  }

  return CalGrayCS;
}();

const CalRGBCS = function CalRGBCSClosure() {
  const BRADFORD_SCALE_MATRIX = new Float32Array([0.8951, 0.2664, -0.1614, -0.7502, 1.7135, 0.0367, 0.0389, -0.0685, 1.0296]);
  const BRADFORD_SCALE_INVERSE_MATRIX = new Float32Array([0.9869929, -0.1470543, 0.1599627, 0.4323053, 0.5183603, 0.0492912, -0.0085287, 0.0400428, 0.9684867]);
  const SRGB_D65_XYZ_TO_RGB_MATRIX = new Float32Array([3.2404542, -1.5371385, -0.4985314, -0.9692660, 1.8760108, 0.0415560, 0.0556434, -0.2040259, 1.0572252]);
  const FLAT_WHITEPOINT_MATRIX = new Float32Array([1, 1, 1]);
  const tempNormalizeMatrix = new Float32Array(3);
  const tempConvertMatrix1 = new Float32Array(3);
  const tempConvertMatrix2 = new Float32Array(3);
  const DECODE_L_CONSTANT = ((8 + 16) / 116) ** 3 / 8.0;

  function matrixProduct(a, b, result) {
    result[0] = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    result[1] = a[3] * b[0] + a[4] * b[1] + a[5] * b[2];
    result[2] = a[6] * b[0] + a[7] * b[1] + a[8] * b[2];
  }

  function convertToFlat(sourceWhitePoint, LMS, result) {
    result[0] = LMS[0] * 1 / sourceWhitePoint[0];
    result[1] = LMS[1] * 1 / sourceWhitePoint[1];
    result[2] = LMS[2] * 1 / sourceWhitePoint[2];
  }

  function convertToD65(sourceWhitePoint, LMS, result) {
    const D65X = 0.95047;
    const D65Y = 1;
    const D65Z = 1.08883;
    result[0] = LMS[0] * D65X / sourceWhitePoint[0];
    result[1] = LMS[1] * D65Y / sourceWhitePoint[1];
    result[2] = LMS[2] * D65Z / sourceWhitePoint[2];
  }

  function sRGBTransferFunction(color) {
    if (color <= 0.0031308) {
      return adjustToRange(0, 1, 12.92 * color);
    }

    if (color >= 0.99554525) {
      return 1;
    }

    return adjustToRange(0, 1, (1 + 0.055) * color ** (1 / 2.4) - 0.055);
  }

  function adjustToRange(min, max, value) {
    return Math.max(min, Math.min(max, value));
  }

  function decodeL(L) {
    if (L < 0) {
      return -decodeL(-L);
    }

    if (L > 8.0) {
      return ((L + 16) / 116) ** 3;
    }

    return L * DECODE_L_CONSTANT;
  }

  function compensateBlackPoint(sourceBlackPoint, XYZ_Flat, result) {
    if (sourceBlackPoint[0] === 0 && sourceBlackPoint[1] === 0 && sourceBlackPoint[2] === 0) {
      result[0] = XYZ_Flat[0];
      result[1] = XYZ_Flat[1];
      result[2] = XYZ_Flat[2];
      return;
    }

    const zeroDecodeL = decodeL(0);
    const X_DST = zeroDecodeL;
    const X_SRC = decodeL(sourceBlackPoint[0]);
    const Y_DST = zeroDecodeL;
    const Y_SRC = decodeL(sourceBlackPoint[1]);
    const Z_DST = zeroDecodeL;
    const Z_SRC = decodeL(sourceBlackPoint[2]);
    const X_Scale = (1 - X_DST) / (1 - X_SRC);
    const X_Offset = 1 - X_Scale;
    const Y_Scale = (1 - Y_DST) / (1 - Y_SRC);
    const Y_Offset = 1 - Y_Scale;
    const Z_Scale = (1 - Z_DST) / (1 - Z_SRC);
    const Z_Offset = 1 - Z_Scale;
    result[0] = XYZ_Flat[0] * X_Scale + X_Offset;
    result[1] = XYZ_Flat[1] * Y_Scale + Y_Offset;
    result[2] = XYZ_Flat[2] * Z_Scale + Z_Offset;
  }

  function normalizeWhitePointToFlat(sourceWhitePoint, XYZ_In, result) {
    if (sourceWhitePoint[0] === 1 && sourceWhitePoint[2] === 1) {
      result[0] = XYZ_In[0];
      result[1] = XYZ_In[1];
      result[2] = XYZ_In[2];
      return;
    }

    const LMS = result;
    matrixProduct(BRADFORD_SCALE_MATRIX, XYZ_In, LMS);
    const LMS_Flat = tempNormalizeMatrix;
    convertToFlat(sourceWhitePoint, LMS, LMS_Flat);
    matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX, LMS_Flat, result);
  }

  function normalizeWhitePointToD65(sourceWhitePoint, XYZ_In, result) {
    const LMS = result;
    matrixProduct(BRADFORD_SCALE_MATRIX, XYZ_In, LMS);
    const LMS_D65 = tempNormalizeMatrix;
    convertToD65(sourceWhitePoint, LMS, LMS_D65);
    matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX, LMS_D65, result);
  }

  function convertToRgb(cs, src, srcOffset, dest, destOffset, scale) {
    const A = adjustToRange(0, 1, src[srcOffset] * scale);
    const B = adjustToRange(0, 1, src[srcOffset + 1] * scale);
    const C = adjustToRange(0, 1, src[srcOffset + 2] * scale);
    const AGR = A === 1 ? 1 : A ** cs.GR;
    const BGG = B === 1 ? 1 : B ** cs.GG;
    const CGB = C === 1 ? 1 : C ** cs.GB;
    const X = cs.MXA * AGR + cs.MXB * BGG + cs.MXC * CGB;
    const Y = cs.MYA * AGR + cs.MYB * BGG + cs.MYC * CGB;
    const Z = cs.MZA * AGR + cs.MZB * BGG + cs.MZC * CGB;
    const XYZ = tempConvertMatrix1;
    XYZ[0] = X;
    XYZ[1] = Y;
    XYZ[2] = Z;
    const XYZ_Flat = tempConvertMatrix2;
    normalizeWhitePointToFlat(cs.whitePoint, XYZ, XYZ_Flat);
    const XYZ_Black = tempConvertMatrix1;
    compensateBlackPoint(cs.blackPoint, XYZ_Flat, XYZ_Black);
    const XYZ_D65 = tempConvertMatrix2;
    normalizeWhitePointToD65(FLAT_WHITEPOINT_MATRIX, XYZ_Black, XYZ_D65);
    const SRGB = tempConvertMatrix1;
    matrixProduct(SRGB_D65_XYZ_TO_RGB_MATRIX, XYZ_D65, SRGB);
    dest[destOffset] = sRGBTransferFunction(SRGB[0]) * 255;
    dest[destOffset + 1] = sRGBTransferFunction(SRGB[1]) * 255;
    dest[destOffset + 2] = sRGBTransferFunction(SRGB[2]) * 255;
  }

  class CalRGBCS extends ColorSpace {
    constructor(whitePoint, blackPoint, gamma, matrix) {
      super("CalRGB", 3);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space CalRGB");
      }

      blackPoint = blackPoint || new Float32Array(3);
      gamma = gamma || new Float32Array([1, 1, 1]);
      matrix = matrix || new Float32Array([1, 0, 0, 0, 1, 0, 0, 0, 1]);
      const XW = whitePoint[0];
      const YW = whitePoint[1];
      const ZW = whitePoint[2];
      this.whitePoint = whitePoint;
      const XB = blackPoint[0];
      const YB = blackPoint[1];
      const ZB = blackPoint[2];
      this.blackPoint = blackPoint;
      this.GR = gamma[0];
      this.GG = gamma[1];
      this.GB = gamma[2];
      this.MXA = matrix[0];
      this.MYA = matrix[1];
      this.MZA = matrix[2];
      this.MXB = matrix[3];
      this.MYB = matrix[4];
      this.MZB = matrix[5];
      this.MXC = matrix[6];
      this.MYC = matrix[7];
      this.MZC = matrix[8];

      if (XW < 0 || ZW < 0 || YW !== 1) {
        throw new _util.FormatError(`Invalid WhitePoint components for ${this.name}` + ", no fallback available");
      }

      if (XB < 0 || YB < 0 || ZB < 0) {
        (0, _util.info)(`Invalid BlackPoint for ${this.name} [${XB}, ${YB}, ${ZB}], ` + "falling back to default.");
        this.blackPoint = new Float32Array(3);
      }

      if (this.GR < 0 || this.GG < 0 || this.GB < 0) {
        (0, _util.info)(`Invalid Gamma [${this.GR}, ${this.GG}, ${this.GB}] for ` + `${this.name}, falling back to default.`);
        this.GR = this.GG = this.GB = 1;
      }
    }

    getRgbItem(src, srcOffset, dest, destOffset) {
      convertToRgb(this, src, srcOffset, dest, destOffset, 1);
    }

    getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      const scale = 1 / ((1 << bits) - 1);

      for (let i = 0; i < count; ++i) {
        convertToRgb(this, src, srcOffset, dest, destOffset, scale);
        srcOffset += 3;
        destOffset += 3 + alpha01;
      }
    }

    getOutputLength(inputLength, alpha01) {
      return inputLength * (3 + alpha01) / 3 | 0;
    }

  }

  return CalRGBCS;
}();

const LabCS = function LabCSClosure() {
  function fn_g(x) {
    let result;

    if (x >= 6 / 29) {
      result = x ** 3;
    } else {
      result = 108 / 841 * (x - 4 / 29);
    }

    return result;
  }

  function decode(value, high1, low2, high2) {
    return low2 + value * (high2 - low2) / high1;
  }

  function convertToRgb(cs, src, srcOffset, maxVal, dest, destOffset) {
    let Ls = src[srcOffset];
    let as = src[srcOffset + 1];
    let bs = src[srcOffset + 2];

    if (maxVal !== false) {
      Ls = decode(Ls, maxVal, 0, 100);
      as = decode(as, maxVal, cs.amin, cs.amax);
      bs = decode(bs, maxVal, cs.bmin, cs.bmax);
    }

    if (as > cs.amax) {
      as = cs.amax;
    } else if (as < cs.amin) {
      as = cs.amin;
    }

    if (bs > cs.bmax) {
      bs = cs.bmax;
    } else if (bs < cs.bmin) {
      bs = cs.bmin;
    }

    const M = (Ls + 16) / 116;
    const L = M + as / 500;
    const N = M - bs / 200;
    const X = cs.XW * fn_g(L);
    const Y = cs.YW * fn_g(M);
    const Z = cs.ZW * fn_g(N);
    let r, g, b;

    if (cs.ZW < 1) {
      r = X * 3.1339 + Y * -1.617 + Z * -0.4906;
      g = X * -0.9785 + Y * 1.916 + Z * 0.0333;
      b = X * 0.072 + Y * -0.229 + Z * 1.4057;
    } else {
      r = X * 3.2406 + Y * -1.5372 + Z * -0.4986;
      g = X * -0.9689 + Y * 1.8758 + Z * 0.0415;
      b = X * 0.0557 + Y * -0.204 + Z * 1.057;
    }

    dest[destOffset] = Math.sqrt(r) * 255;
    dest[destOffset + 1] = Math.sqrt(g) * 255;
    dest[destOffset + 2] = Math.sqrt(b) * 255;
  }

  class LabCS extends ColorSpace {
    constructor(whitePoint, blackPoint, range) {
      super("Lab", 3);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space Lab");
      }

      blackPoint = blackPoint || [0, 0, 0];
      range = range || [-100, 100, -100, 100];
      this.XW = whitePoint[0];
      this.YW = whitePoint[1];
      this.ZW = whitePoint[2];
      this.amin = range[0];
      this.amax = range[1];
      this.bmin = range[2];
      this.bmax = range[3];
      this.XB = blackPoint[0];
      this.YB = blackPoint[1];
      this.ZB = blackPoint[2];

      if (this.XW < 0 || this.ZW < 0 || this.YW !== 1) {
        throw new _util.FormatError("Invalid WhitePoint components, no fallback available");
      }

      if (this.XB < 0 || this.YB < 0 || this.ZB < 0) {
        (0, _util.info)("Invalid BlackPoint, falling back to default");
        this.XB = this.YB = this.ZB = 0;
      }

      if (this.amin > this.amax || this.bmin > this.bmax) {
        (0, _util.info)("Invalid Range, falling back to defaults");
        this.amin = -100;
        this.amax = 100;
        this.bmin = -100;
        this.bmax = 100;
      }
    }

    getRgbItem(src, srcOffset, dest, destOffset) {
      convertToRgb(this, src, srcOffset, false, dest, destOffset);
    }

    getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      const maxVal = (1 << bits) - 1;

      for (let i = 0; i < count; i++) {
        convertToRgb(this, src, srcOffset, maxVal, dest, destOffset);
        srcOffset += 3;
        destOffset += 3 + alpha01;
      }
    }

    getOutputLength(inputLength, alpha01) {
      return inputLength * (3 + alpha01) / 3 | 0;
    }

    isDefaultDecode(decodeMap, bpc) {
      return true;
    }

    get usesZeroToOneRange() {
      return (0, _util.shadow)(this, "usesZeroToOneRange", false);
    }

  }

  return LabCS;
}();

/***/ }),
/* 25 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PartialEvaluator = exports.EvaluatorPreprocessor = void 0;

var _util = __w_pdfjs_require__(2);

var _cmap = __w_pdfjs_require__(26);

var _primitives = __w_pdfjs_require__(5);

var _fonts = __w_pdfjs_require__(44);

var _fonts_utils = __w_pdfjs_require__(18);

var _encodings = __w_pdfjs_require__(19);

var _standard_fonts = __w_pdfjs_require__(47);

var _unicode = __w_pdfjs_require__(21);

var _pattern = __w_pdfjs_require__(55);

var _xfa_fonts = __w_pdfjs_require__(12);

var _to_unicode_map = __w_pdfjs_require__(48);

var _function = __w_pdfjs_require__(56);

var _parser = __w_pdfjs_require__(27);

var _image_utils = __w_pdfjs_require__(58);

var _stream = __w_pdfjs_require__(10);

var _base_stream = __w_pdfjs_require__(6);

var _bidi = __w_pdfjs_require__(59);

var _colorspace = __w_pdfjs_require__(24);

var _decode_stream = __w_pdfjs_require__(29);

var _glyphlist = __w_pdfjs_require__(20);

var _core_utils = __w_pdfjs_require__(9);

var _metrics = __w_pdfjs_require__(60);

var _murmurhash = __w_pdfjs_require__(61);

var _operator_list = __w_pdfjs_require__(62);

var _image = __w_pdfjs_require__(63);

const DefaultPartialEvaluatorOptions = Object.freeze({
  maxImageSize: -1,
  disableFontFace: false,
  ignoreErrors: false,
  isEvalSupported: true,
  fontExtraProperties: false,
  useSystemFonts: true,
  cMapUrl: null,
  standardFontDataUrl: null
});
const PatternType = {
  TILING: 1,
  SHADING: 2
};
const TEXT_CHUNK_BATCH_SIZE = 10;
const deferred = Promise.resolve();

function normalizeBlendMode(value, parsingArray = false) {
  if (Array.isArray(value)) {
    for (let i = 0, ii = value.length; i < ii; i++) {
      const maybeBM = normalizeBlendMode(value[i], true);

      if (maybeBM) {
        return maybeBM;
      }
    }

    (0, _util.warn)(`Unsupported blend mode Array: ${value}`);
    return "source-over";
  }

  if (!(0, _primitives.isName)(value)) {
    if (parsingArray) {
      return null;
    }

    return "source-over";
  }

  switch (value.name) {
    case "Normal":
    case "Compatible":
      return "source-over";

    case "Multiply":
      return "multiply";

    case "Screen":
      return "screen";

    case "Overlay":
      return "overlay";

    case "Darken":
      return "darken";

    case "Lighten":
      return "lighten";

    case "ColorDodge":
      return "color-dodge";

    case "ColorBurn":
      return "color-burn";

    case "HardLight":
      return "hard-light";

    case "SoftLight":
      return "soft-light";

    case "Difference":
      return "difference";

    case "Exclusion":
      return "exclusion";

    case "Hue":
      return "hue";

    case "Saturation":
      return "saturation";

    case "Color":
      return "color";

    case "Luminosity":
      return "luminosity";
  }

  if (parsingArray) {
    return null;
  }

  (0, _util.warn)(`Unsupported blend mode: ${value.name}`);
  return "source-over";
}

class TimeSlotManager {
  static get TIME_SLOT_DURATION_MS() {
    return (0, _util.shadow)(this, "TIME_SLOT_DURATION_MS", 20);
  }

  static get CHECK_TIME_EVERY() {
    return (0, _util.shadow)(this, "CHECK_TIME_EVERY", 100);
  }

  constructor() {
    this.reset();
  }

  check() {
    if (++this.checked < TimeSlotManager.CHECK_TIME_EVERY) {
      return false;
    }

    this.checked = 0;
    return this.endTime <= Date.now();
  }

  reset() {
    this.endTime = Date.now() + TimeSlotManager.TIME_SLOT_DURATION_MS;
    this.checked = 0;
  }

}

class PartialEvaluator {
  constructor({
    xref,
    handler,
    pageIndex,
    idFactory,
    fontCache,
    builtInCMapCache,
    standardFontDataCache,
    globalImageCache,
    options = null
  }) {
    this.xref = xref;
    this.handler = handler;
    this.pageIndex = pageIndex;
    this.idFactory = idFactory;
    this.fontCache = fontCache;
    this.builtInCMapCache = builtInCMapCache;
    this.standardFontDataCache = standardFontDataCache;
    this.globalImageCache = globalImageCache;
    this.options = options || DefaultPartialEvaluatorOptions;
    this.parsingType3Font = false;
    this._fetchBuiltInCMapBound = this.fetchBuiltInCMap.bind(this);
  }

  get _pdfFunctionFactory() {
    const pdfFunctionFactory = new _function.PDFFunctionFactory({
      xref: this.xref,
      isEvalSupported: this.options.isEvalSupported
    });
    return (0, _util.shadow)(this, "_pdfFunctionFactory", pdfFunctionFactory);
  }

  clone(newOptions = null) {
    const newEvaluator = Object.create(this);
    newEvaluator.options = Object.assign(Object.create(null), this.options, newOptions);
    return newEvaluator;
  }

  hasBlendModes(resources, nonBlendModesSet) {
    if (!(resources instanceof _primitives.Dict)) {
      return false;
    }

    if (resources.objId && nonBlendModesSet.has(resources.objId)) {
      return false;
    }

    const processed = new _primitives.RefSet(nonBlendModesSet);

    if (resources.objId) {
      processed.put(resources.objId);
    }

    const nodes = [resources],
          xref = this.xref;

    while (nodes.length) {
      const node = nodes.shift();
      const graphicStates = node.get("ExtGState");

      if (graphicStates instanceof _primitives.Dict) {
        for (let graphicState of graphicStates.getRawValues()) {
          if (graphicState instanceof _primitives.Ref) {
            if (processed.has(graphicState)) {
              continue;
            }

            try {
              graphicState = xref.fetch(graphicState);
            } catch (ex) {
              processed.put(graphicState);
              (0, _util.info)(`hasBlendModes - ignoring ExtGState: "${ex}".`);
              continue;
            }
          }

          if (!(graphicState instanceof _primitives.Dict)) {
            continue;
          }

          if (graphicState.objId) {
            processed.put(graphicState.objId);
          }

          const bm = graphicState.get("BM");

          if (bm instanceof _primitives.Name) {
            if (bm.name !== "Normal") {
              return true;
            }

            continue;
          }

          if (bm !== undefined && Array.isArray(bm)) {
            for (const element of bm) {
              if (element instanceof _primitives.Name && element.name !== "Normal") {
                return true;
              }
            }
          }
        }
      }

      const xObjects = node.get("XObject");

      if (!(xObjects instanceof _primitives.Dict)) {
        continue;
      }

      for (let xObject of xObjects.getRawValues()) {
        if (xObject instanceof _primitives.Ref) {
          if (processed.has(xObject)) {
            continue;
          }

          try {
            xObject = xref.fetch(xObject);
          } catch (ex) {
            processed.put(xObject);
            (0, _util.info)(`hasBlendModes - ignoring XObject: "${ex}".`);
            continue;
          }
        }

        if (!(0, _primitives.isStream)(xObject)) {
          continue;
        }

        if (xObject.dict.objId) {
          processed.put(xObject.dict.objId);
        }

        const xResources = xObject.dict.get("Resources");

        if (!(xResources instanceof _primitives.Dict)) {
          continue;
        }

        if (xResources.objId && processed.has(xResources.objId)) {
          continue;
        }

        nodes.push(xResources);

        if (xResources.objId) {
          processed.put(xResources.objId);
        }
      }
    }

    processed.forEach(ref => {
      nonBlendModesSet.put(ref);
    });
    return false;
  }

  async fetchBuiltInCMap(name) {
    const cachedData = this.builtInCMapCache.get(name);

    if (cachedData) {
      return cachedData;
    }

    let data;

    if (this.options.cMapUrl !== null) {
      const url = `${this.options.cMapUrl}${name}.bcmap`;
      const response = await fetch(url);

      if (!response.ok) {
        throw new Error(`fetchBuiltInCMap: failed to fetch file "${url}" with "${response.statusText}".`);
      }

      data = {
        cMapData: new Uint8Array(await response.arrayBuffer()),
        compressionType: _util.CMapCompressionType.BINARY
      };
    } else {
      data = await this.handler.sendWithPromise("FetchBuiltInCMap", {
        name
      });
    }

    if (data.compressionType !== _util.CMapCompressionType.NONE) {
      this.builtInCMapCache.set(name, data);
    }

    return data;
  }

  async fetchStandardFontData(name) {
    const cachedData = this.standardFontDataCache.get(name);

    if (cachedData) {
      return new _stream.Stream(cachedData);
    }

    if (this.options.useSystemFonts && name !== "Symbol" && name !== "ZapfDingbats") {
      return null;
    }

    const standardFontNameToFileName = (0, _standard_fonts.getFontNameToFileMap)(),
          filename = standardFontNameToFileName[name];
    let data;

    if (this.options.standardFontDataUrl !== null) {
      const url = `${this.options.standardFontDataUrl}${filename}`;
      const response = await fetch(url);

      if (!response.ok) {
        (0, _util.warn)(`fetchStandardFontData: failed to fetch file "${url}" with "${response.statusText}".`);
      } else {
        data = await response.arrayBuffer();
      }
    } else {
      try {
        data = await this.handler.sendWithPromise("FetchStandardFontData", {
          filename
        });
      } catch (e) {
        (0, _util.warn)(`fetchStandardFontData: failed to fetch file "${filename}" with "${e}".`);
      }
    }

    if (!data) {
      return null;
    }

    this.standardFontDataCache.set(name, data);
    return new _stream.Stream(data);
  }

  async buildFormXObject(resources, xobj, smask, operatorList, task, initialState, localColorSpaceCache) {
    const dict = xobj.dict;
    const matrix = dict.getArray("Matrix");
    let bbox = dict.getArray("BBox");

    if (Array.isArray(bbox) && bbox.length === 4) {
      bbox = _util.Util.normalizeRect(bbox);
    } else {
      bbox = null;
    }

    let optionalContent, groupOptions;

    if (dict.has("OC")) {
      optionalContent = await this.parseMarkedContentProps(dict.get("OC"), resources);
    }

    if (optionalContent !== undefined) {
      operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", optionalContent]);
    }

    const group = dict.get("Group");

    if (group) {
      groupOptions = {
        matrix,
        bbox,
        smask,
        isolated: false,
        knockout: false
      };
      const groupSubtype = group.get("S");
      let colorSpace = null;

      if ((0, _primitives.isName)(groupSubtype, "Transparency")) {
        groupOptions.isolated = group.get("I") || false;
        groupOptions.knockout = group.get("K") || false;

        if (group.has("CS")) {
          const cs = group.getRaw("CS");

          const cachedColorSpace = _colorspace.ColorSpace.getCached(cs, this.xref, localColorSpaceCache);

          if (cachedColorSpace) {
            colorSpace = cachedColorSpace;
          } else {
            colorSpace = await this.parseColorSpace({
              cs,
              resources,
              localColorSpaceCache
            });
          }
        }
      }

      if (smask && smask.backdrop) {
        colorSpace = colorSpace || _colorspace.ColorSpace.singletons.rgb;
        smask.backdrop = colorSpace.getRgb(smask.backdrop, 0);
      }

      operatorList.addOp(_util.OPS.beginGroup, [groupOptions]);
    }

    const args = group ? [matrix, null] : [matrix, bbox];
    operatorList.addOp(_util.OPS.paintFormXObjectBegin, args);
    return this.getOperatorList({
      stream: xobj,
      task,
      resources: dict.get("Resources") || resources,
      operatorList,
      initialState
    }).then(function () {
      operatorList.addOp(_util.OPS.paintFormXObjectEnd, []);

      if (group) {
        operatorList.addOp(_util.OPS.endGroup, [groupOptions]);
      }

      if (optionalContent !== undefined) {
        operatorList.addOp(_util.OPS.endMarkedContent, []);
      }
    });
  }

  _sendImgData(objId, imgData, cacheGlobally = false) {
    const transfers = imgData ? [imgData.data.buffer] : null;

    if (this.parsingType3Font || cacheGlobally) {
      return this.handler.send("commonobj", [objId, "Image", imgData], transfers);
    }

    return this.handler.send("obj", [objId, this.pageIndex, "Image", imgData], transfers);
  }

  async buildPaintImageXObject({
    resources,
    image,
    isInline = false,
    operatorList,
    cacheKey,
    localImageCache,
    localColorSpaceCache
  }) {
    const dict = image.dict;
    const imageRef = dict.objId;
    const w = dict.get("W", "Width");
    const h = dict.get("H", "Height");

    if (!(w && (0, _util.isNum)(w)) || !(h && (0, _util.isNum)(h))) {
      (0, _util.warn)("Image dimensions are missing, or not numbers.");
      return;
    }

    const maxImageSize = this.options.maxImageSize;

    if (maxImageSize !== -1 && w * h > maxImageSize) {
      (0, _util.warn)("Image exceeded maximum allowed size and was removed.");
      return;
    }

    let optionalContent;

    if (dict.has("OC")) {
      optionalContent = await this.parseMarkedContentProps(dict.get("OC"), resources);
    }

    if (optionalContent !== undefined) {
      operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", optionalContent]);
    }

    const imageMask = dict.get("IM", "ImageMask") || false;
    const interpolate = dict.get("I", "Interpolate");
    let imgData, args;

    if (imageMask) {
      const bitStrideLength = w + 7 >> 3;
      const imgArray = image.getBytes(bitStrideLength * h, true);
      const decode = dict.getArray("D", "Decode");
      imgData = _image.PDFImage.createMask({
        imgArray,
        width: w,
        height: h,
        imageIsFromDecodeStream: image instanceof _decode_stream.DecodeStream,
        inverseDecode: !!decode && decode[0] > 0,
        interpolate
      });
      imgData.cached = !!cacheKey;
      args = [imgData];
      operatorList.addOp(_util.OPS.paintImageMaskXObject, args);

      if (cacheKey) {
        localImageCache.set(cacheKey, imageRef, {
          fn: _util.OPS.paintImageMaskXObject,
          args
        });
      }

      if (optionalContent !== undefined) {
        operatorList.addOp(_util.OPS.endMarkedContent, []);
      }

      return;
    }

    const softMask = dict.get("SM", "SMask") || false;
    const mask = dict.get("Mask") || false;
    const SMALL_IMAGE_DIMENSIONS = 200;

    if (isInline && !softMask && !mask && w + h < SMALL_IMAGE_DIMENSIONS) {
      const imageObj = new _image.PDFImage({
        xref: this.xref,
        res: resources,
        image,
        isInline,
        pdfFunctionFactory: this._pdfFunctionFactory,
        localColorSpaceCache
      });
      imgData = imageObj.createImageData(true);
      operatorList.addOp(_util.OPS.paintInlineImageXObject, [imgData]);

      if (optionalContent !== undefined) {
        operatorList.addOp(_util.OPS.endMarkedContent, []);
      }

      return;
    }

    let objId = `img_${this.idFactory.createObjId()}`,
        cacheGlobally = false;

    if (this.parsingType3Font) {
      objId = `${this.idFactory.getDocId()}_type3_${objId}`;
    } else if (imageRef) {
      cacheGlobally = this.globalImageCache.shouldCache(imageRef, this.pageIndex);

      if (cacheGlobally) {
        objId = `${this.idFactory.getDocId()}_${objId}`;
      }
    }

    operatorList.addDependency(objId);
    args = [objId, w, h];

    _image.PDFImage.buildImage({
      xref: this.xref,
      res: resources,
      image,
      isInline,
      pdfFunctionFactory: this._pdfFunctionFactory,
      localColorSpaceCache
    }).then(imageObj => {
      imgData = imageObj.createImageData(false);

      if (cacheKey && imageRef && cacheGlobally) {
        this.globalImageCache.addByteSize(imageRef, imgData.data.length);
      }

      return this._sendImgData(objId, imgData, cacheGlobally);
    }).catch(reason => {
      (0, _util.warn)(`Unable to decode image "${objId}": "${reason}".`);
      return this._sendImgData(objId, null, cacheGlobally);
    });

    operatorList.addOp(_util.OPS.paintImageXObject, args);

    if (cacheKey) {
      localImageCache.set(cacheKey, imageRef, {
        fn: _util.OPS.paintImageXObject,
        args
      });

      if (imageRef) {
        (0, _util.assert)(!isInline, "Cannot cache an inline image globally.");
        this.globalImageCache.addPageIndex(imageRef, this.pageIndex);

        if (cacheGlobally) {
          this.globalImageCache.setData(imageRef, {
            objId,
            fn: _util.OPS.paintImageXObject,
            args,
            byteSize: 0
          });
        }
      }
    }

    if (optionalContent !== undefined) {
      operatorList.addOp(_util.OPS.endMarkedContent, []);
    }
  }

  handleSMask(smask, resources, operatorList, task, stateManager, localColorSpaceCache) {
    const smaskContent = smask.get("G");
    const smaskOptions = {
      subtype: smask.get("S").name,
      backdrop: smask.get("BC")
    };
    const transferObj = smask.get("TR");

    if ((0, _function.isPDFFunction)(transferObj)) {
      const transferFn = this._pdfFunctionFactory.create(transferObj);

      const transferMap = new Uint8Array(256);
      const tmp = new Float32Array(1);

      for (let i = 0; i < 256; i++) {
        tmp[0] = i / 255;
        transferFn(tmp, 0, tmp, 0);
        transferMap[i] = tmp[0] * 255 | 0;
      }

      smaskOptions.transferMap = transferMap;
    }

    return this.buildFormXObject(resources, smaskContent, smaskOptions, operatorList, task, stateManager.state.clone(), localColorSpaceCache);
  }

  handleTransferFunction(tr) {
    let transferArray;

    if (Array.isArray(tr)) {
      transferArray = tr;
    } else if ((0, _function.isPDFFunction)(tr)) {
      transferArray = [tr];
    } else {
      return null;
    }

    const transferMaps = [];
    let numFns = 0,
        numEffectfulFns = 0;

    for (const entry of transferArray) {
      const transferObj = this.xref.fetchIfRef(entry);
      numFns++;

      if ((0, _primitives.isName)(transferObj, "Identity")) {
        transferMaps.push(null);
        continue;
      } else if (!(0, _function.isPDFFunction)(transferObj)) {
        return null;
      }

      const transferFn = this._pdfFunctionFactory.create(transferObj);

      const transferMap = new Uint8Array(256),
            tmp = new Float32Array(1);

      for (let j = 0; j < 256; j++) {
        tmp[0] = j / 255;
        transferFn(tmp, 0, tmp, 0);
        transferMap[j] = tmp[0] * 255 | 0;
      }

      transferMaps.push(transferMap);
      numEffectfulFns++;
    }

    if (!(numFns === 1 || numFns === 4)) {
      return null;
    }

    if (numEffectfulFns === 0) {
      return null;
    }

    return transferMaps;
  }

  handleTilingType(fn, color, resources, pattern, patternDict, operatorList, task, localTilingPatternCache) {
    const tilingOpList = new _operator_list.OperatorList();

    const patternResources = _primitives.Dict.merge({
      xref: this.xref,
      dictArray: [patternDict.get("Resources"), resources]
    });

    return this.getOperatorList({
      stream: pattern,
      task,
      resources: patternResources,
      operatorList: tilingOpList
    }).then(function () {
      const operatorListIR = tilingOpList.getIR();
      const tilingPatternIR = (0, _pattern.getTilingPatternIR)(operatorListIR, patternDict, color);
      operatorList.addDependencies(tilingOpList.dependencies);
      operatorList.addOp(fn, tilingPatternIR);

      if (patternDict.objId) {
        localTilingPatternCache.set(null, patternDict.objId, {
          operatorListIR,
          dict: patternDict
        });
      }
    }).catch(reason => {
      if (reason instanceof _util.AbortException) {
        return;
      }

      if (this.options.ignoreErrors) {
        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorTilingPattern
        });
        (0, _util.warn)(`handleTilingType - ignoring pattern: "${reason}".`);
        return;
      }

      throw reason;
    });
  }

  handleSetFont(resources, fontArgs, fontRef, operatorList, task, state, fallbackFontDict = null, cssFontInfo = null) {
    const fontName = fontArgs && fontArgs[0] instanceof _primitives.Name ? fontArgs[0].name : null;
    return this.loadFont(fontName, fontRef, resources, fallbackFontDict, cssFontInfo).then(translated => {
      if (!translated.font.isType3Font) {
        return translated;
      }

      return translated.loadType3Data(this, resources, task).then(function () {
        operatorList.addDependencies(translated.type3Dependencies);
        return translated;
      }).catch(reason => {
        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorFontLoadType3
        });
        return new TranslatedFont({
          loadedName: "g_font_error",
          font: new _fonts.ErrorFont(`Type3 font load error: ${reason}`),
          dict: translated.font,
          evaluatorOptions: this.options
        });
      });
    }).then(translated => {
      state.font = translated.font;
      translated.send(this.handler);
      return translated.loadedName;
    });
  }

  handleText(chars, state) {
    const font = state.font;
    const glyphs = font.charsToGlyphs(chars);

    if (font.data) {
      const isAddToPathSet = !!(state.textRenderingMode & _util.TextRenderingMode.ADD_TO_PATH_FLAG);

      if (isAddToPathSet || state.fillColorSpace.name === "Pattern" || font.disableFontFace || this.options.disableFontFace) {
        PartialEvaluator.buildFontPaths(font, glyphs, this.handler, this.options);
      }
    }

    return glyphs;
  }

  ensureStateFont(state) {
    if (state.font) {
      return;
    }

    const reason = new _util.FormatError("Missing setFont (Tf) operator before text rendering operator.");

    if (this.options.ignoreErrors) {
      this.handler.send("UnsupportedFeature", {
        featureId: _util.UNSUPPORTED_FEATURES.errorFontState
      });
      (0, _util.warn)(`ensureStateFont: "${reason}".`);
      return;
    }

    throw reason;
  }

  async setGState({
    resources,
    gState,
    operatorList,
    cacheKey,
    task,
    stateManager,
    localGStateCache,
    localColorSpaceCache
  }) {
    const gStateRef = gState.objId;
    let isSimpleGState = true;
    const gStateObj = [];
    const gStateKeys = gState.getKeys();
    let promise = Promise.resolve();

    for (let i = 0, ii = gStateKeys.length; i < ii; i++) {
      const key = gStateKeys[i];
      const value = gState.get(key);

      switch (key) {
        case "Type":
          break;

        case "LW":
        case "LC":
        case "LJ":
        case "ML":
        case "D":
        case "RI":
        case "FL":
        case "CA":
        case "ca":
          gStateObj.push([key, value]);
          break;

        case "Font":
          isSimpleGState = false;
          promise = promise.then(() => {
            return this.handleSetFont(resources, null, value[0], operatorList, task, stateManager.state).then(function (loadedName) {
              operatorList.addDependency(loadedName);
              gStateObj.push([key, [loadedName, value[1]]]);
            });
          });
          break;

        case "BM":
          gStateObj.push([key, normalizeBlendMode(value)]);
          break;

        case "SMask":
          if ((0, _primitives.isName)(value, "None")) {
            gStateObj.push([key, false]);
            break;
          }

          if ((0, _primitives.isDict)(value)) {
            isSimpleGState = false;
            promise = promise.then(() => {
              return this.handleSMask(value, resources, operatorList, task, stateManager, localColorSpaceCache);
            });
            gStateObj.push([key, true]);
          } else {
            (0, _util.warn)("Unsupported SMask type");
          }

          break;

        case "TR":
          const transferMaps = this.handleTransferFunction(value);
          gStateObj.push([key, transferMaps]);
          break;

        case "OP":
        case "op":
        case "OPM":
        case "BG":
        case "BG2":
        case "UCR":
        case "UCR2":
        case "TR2":
        case "HT":
        case "SM":
        case "SA":
        case "AIS":
        case "TK":
          (0, _util.info)("graphic state operator " + key);
          break;

        default:
          (0, _util.info)("Unknown graphic state operator " + key);
          break;
      }
    }

    return promise.then(function () {
      if (gStateObj.length > 0) {
        operatorList.addOp(_util.OPS.setGState, [gStateObj]);
      }

      if (isSimpleGState) {
        localGStateCache.set(cacheKey, gStateRef, gStateObj);
      }
    });
  }

  loadFont(fontName, font, resources, fallbackFontDict = null, cssFontInfo = null) {
    const errorFont = async () => {
      return new TranslatedFont({
        loadedName: "g_font_error",
        font: new _fonts.ErrorFont(`Font "${fontName}" is not available.`),
        dict: font,
        evaluatorOptions: this.options
      });
    };

    const xref = this.xref;
    let fontRef;

    if (font) {
      if (!(0, _primitives.isRef)(font)) {
        throw new _util.FormatError('The "font" object should be a reference.');
      }

      fontRef = font;
    } else {
      const fontRes = resources.get("Font");

      if (fontRes) {
        fontRef = fontRes.getRaw(fontName);
      }
    }

    if (!fontRef) {
      const partialMsg = `Font "${fontName || font && font.toString()}" is not available`;

      if (!this.options.ignoreErrors && !this.parsingType3Font) {
        (0, _util.warn)(`${partialMsg}.`);
        return errorFont();
      }

      this.handler.send("UnsupportedFeature", {
        featureId: _util.UNSUPPORTED_FEATURES.errorFontMissing
      });
      (0, _util.warn)(`${partialMsg} -- attempting to fallback to a default font.`);

      if (fallbackFontDict) {
        fontRef = fallbackFontDict;
      } else {
        fontRef = PartialEvaluator.fallbackFontDict;
      }
    }

    if (this.fontCache.has(fontRef)) {
      return this.fontCache.get(fontRef);
    }

    font = xref.fetchIfRef(fontRef);

    if (!(0, _primitives.isDict)(font)) {
      return errorFont();
    }

    if (font.cacheKey && this.fontCache.has(font.cacheKey)) {
      return this.fontCache.get(font.cacheKey);
    }

    const fontCapability = (0, _util.createPromiseCapability)();
    let preEvaluatedFont;

    try {
      preEvaluatedFont = this.preEvaluateFont(font);
      preEvaluatedFont.cssFontInfo = cssFontInfo;
    } catch (reason) {
      (0, _util.warn)(`loadFont - preEvaluateFont failed: "${reason}".`);
      return errorFont();
    }

    const {
      descriptor,
      hash
    } = preEvaluatedFont;
    const fontRefIsRef = (0, _primitives.isRef)(fontRef);
    let fontID;

    if (fontRefIsRef) {
      fontID = `f${fontRef.toString()}`;
    }

    if (hash && (0, _primitives.isDict)(descriptor)) {
      if (!descriptor.fontAliases) {
        descriptor.fontAliases = Object.create(null);
      }

      const fontAliases = descriptor.fontAliases;

      if (fontAliases[hash]) {
        const aliasFontRef = fontAliases[hash].aliasRef;

        if (fontRefIsRef && aliasFontRef && this.fontCache.has(aliasFontRef)) {
          this.fontCache.putAlias(fontRef, aliasFontRef);
          return this.fontCache.get(fontRef);
        }
      } else {
        fontAliases[hash] = {
          fontID: this.idFactory.createFontId()
        };
      }

      if (fontRefIsRef) {
        fontAliases[hash].aliasRef = fontRef;
      }

      fontID = fontAliases[hash].fontID;
    }

    if (fontRefIsRef) {
      this.fontCache.put(fontRef, fontCapability.promise);
    } else {
      if (!fontID) {
        fontID = this.idFactory.createFontId();
      }

      font.cacheKey = `cacheKey_${fontID}`;
      this.fontCache.put(font.cacheKey, fontCapability.promise);
    }

    (0, _util.assert)(fontID && fontID.startsWith("f"), 'The "fontID" must be (correctly) defined.');
    font.loadedName = `${this.idFactory.getDocId()}_${fontID}`;
    this.translateFont(preEvaluatedFont).then(translatedFont => {
      if (translatedFont.fontType !== undefined) {
        xref.stats.addFontType(translatedFont.fontType);
      }

      fontCapability.resolve(new TranslatedFont({
        loadedName: font.loadedName,
        font: translatedFont,
        dict: font,
        evaluatorOptions: this.options
      }));
    }).catch(reason => {
      this.handler.send("UnsupportedFeature", {
        featureId: _util.UNSUPPORTED_FEATURES.errorFontTranslate
      });
      (0, _util.warn)(`loadFont - translateFont failed: "${reason}".`);

      try {
        const fontFile3 = descriptor && descriptor.get("FontFile3");
        const subtype = fontFile3 && fontFile3.get("Subtype");
        const fontType = (0, _fonts_utils.getFontType)(preEvaluatedFont.type, subtype && subtype.name);

        if (fontType !== undefined) {
          xref.stats.addFontType(fontType);
        }
      } catch (ex) {}

      fontCapability.resolve(new TranslatedFont({
        loadedName: font.loadedName,
        font: new _fonts.ErrorFont(reason instanceof Error ? reason.message : reason),
        dict: font,
        evaluatorOptions: this.options
      }));
    });
    return fontCapability.promise;
  }

  buildPath(operatorList, fn, args, parsingText = false) {
    const lastIndex = operatorList.length - 1;

    if (!args) {
      args = [];
    }

    if (lastIndex < 0 || operatorList.fnArray[lastIndex] !== _util.OPS.constructPath) {
      if (parsingText) {
        (0, _util.warn)(`Encountered path operator "${fn}" inside of a text object.`);
        operatorList.addOp(_util.OPS.save, null);
      }

      operatorList.addOp(_util.OPS.constructPath, [[fn], args]);

      if (parsingText) {
        operatorList.addOp(_util.OPS.restore, null);
      }
    } else {
      const opArgs = operatorList.argsArray[lastIndex];
      opArgs[0].push(fn);
      Array.prototype.push.apply(opArgs[1], args);
    }
  }

  parseColorSpace({
    cs,
    resources,
    localColorSpaceCache
  }) {
    return _colorspace.ColorSpace.parseAsync({
      cs,
      xref: this.xref,
      resources,
      pdfFunctionFactory: this._pdfFunctionFactory,
      localColorSpaceCache
    }).catch(reason => {
      if (reason instanceof _util.AbortException) {
        return null;
      }

      if (this.options.ignoreErrors) {
        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorColorSpace
        });
        (0, _util.warn)(`parseColorSpace - ignoring ColorSpace: "${reason}".`);
        return null;
      }

      throw reason;
    });
  }

  parseShading({
    shading,
    resources,
    localColorSpaceCache,
    localShadingPatternCache
  }) {
    let id = localShadingPatternCache.get(shading);

    if (!id) {
      var shadingFill = _pattern.Pattern.parseShading(shading, this.xref, resources, this.handler, this._pdfFunctionFactory, localColorSpaceCache);

      const patternIR = shadingFill.getIR();
      id = `pattern_${this.idFactory.createObjId()}`;
      localShadingPatternCache.set(shading, id);
      this.handler.send("obj", [id, this.pageIndex, "Pattern", patternIR]);
    }

    return id;
  }

  handleColorN(operatorList, fn, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache, localShadingPatternCache) {
    const patternName = args.pop();

    if (patternName instanceof _primitives.Name) {
      const rawPattern = patterns.getRaw(patternName.name);
      const localTilingPattern = rawPattern instanceof _primitives.Ref && localTilingPatternCache.getByRef(rawPattern);

      if (localTilingPattern) {
        try {
          const color = cs.base ? cs.base.getRgb(args, 0) : null;
          const tilingPatternIR = (0, _pattern.getTilingPatternIR)(localTilingPattern.operatorListIR, localTilingPattern.dict, color);
          operatorList.addOp(fn, tilingPatternIR);
          return undefined;
        } catch (ex) {}
      }

      const pattern = this.xref.fetchIfRef(rawPattern);

      if (pattern) {
        const dict = (0, _primitives.isStream)(pattern) ? pattern.dict : pattern;
        const typeNum = dict.get("PatternType");

        if (typeNum === PatternType.TILING) {
          const color = cs.base ? cs.base.getRgb(args, 0) : null;
          return this.handleTilingType(fn, color, resources, pattern, dict, operatorList, task, localTilingPatternCache);
        } else if (typeNum === PatternType.SHADING) {
          const shading = dict.get("Shading");
          const matrix = dict.getArray("Matrix");
          const objId = this.parseShading({
            shading,
            resources,
            localColorSpaceCache,
            localShadingPatternCache
          });
          operatorList.addOp(fn, ["Shading", objId, matrix]);
          return undefined;
        }

        throw new _util.FormatError(`Unknown PatternType: ${typeNum}`);
      }
    }

    throw new _util.FormatError(`Unknown PatternName: ${patternName}`);
  }

  _parseVisibilityExpression(array, nestingCounter, currentResult) {
    const MAX_NESTING = 10;

    if (++nestingCounter > MAX_NESTING) {
      (0, _util.warn)("Visibility expression is too deeply nested");
      return;
    }

    const length = array.length;
    const operator = this.xref.fetchIfRef(array[0]);

    if (length < 2 || !(0, _primitives.isName)(operator)) {
      (0, _util.warn)("Invalid visibility expression");
      return;
    }

    switch (operator.name) {
      case "And":
      case "Or":
      case "Not":
        currentResult.push(operator.name);
        break;

      default:
        (0, _util.warn)(`Invalid operator ${operator.name} in visibility expression`);
        return;
    }

    for (let i = 1; i < length; i++) {
      const raw = array[i];
      const object = this.xref.fetchIfRef(raw);

      if (Array.isArray(object)) {
        const nestedResult = [];
        currentResult.push(nestedResult);

        this._parseVisibilityExpression(object, nestingCounter, nestedResult);
      } else if ((0, _primitives.isRef)(raw)) {
        currentResult.push(raw.toString());
      }
    }
  }

  async parseMarkedContentProps(contentProperties, resources) {
    let optionalContent;

    if ((0, _primitives.isName)(contentProperties)) {
      const properties = resources.get("Properties");
      optionalContent = properties.get(contentProperties.name);
    } else if ((0, _primitives.isDict)(contentProperties)) {
      optionalContent = contentProperties;
    } else {
      throw new _util.FormatError("Optional content properties malformed.");
    }

    const optionalContentType = optionalContent.get("Type").name;

    if (optionalContentType === "OCG") {
      return {
        type: optionalContentType,
        id: optionalContent.objId
      };
    } else if (optionalContentType === "OCMD") {
      const expression = optionalContent.get("VE");

      if (Array.isArray(expression)) {
        const result = [];

        this._parseVisibilityExpression(expression, 0, result);

        if (result.length > 0) {
          return {
            type: "OCMD",
            expression: result
          };
        }
      }

      const optionalContentGroups = optionalContent.get("OCGs");

      if (Array.isArray(optionalContentGroups) || (0, _primitives.isDict)(optionalContentGroups)) {
        const groupIds = [];

        if (Array.isArray(optionalContentGroups)) {
          for (const ocg of optionalContentGroups) {
            groupIds.push(ocg.toString());
          }
        } else {
          groupIds.push(optionalContentGroups.objId);
        }

        return {
          type: optionalContentType,
          ids: groupIds,
          policy: (0, _primitives.isName)(optionalContent.get("P")) ? optionalContent.get("P").name : null,
          expression: null
        };
      } else if ((0, _primitives.isRef)(optionalContentGroups)) {
        return {
          type: optionalContentType,
          id: optionalContentGroups.toString()
        };
      }
    }

    return null;
  }

  getOperatorList({
    stream,
    task,
    resources,
    operatorList,
    initialState = null,
    fallbackFontDict = null
  }) {
    resources = resources || _primitives.Dict.empty;
    initialState = initialState || new EvalState();

    if (!operatorList) {
      throw new Error('getOperatorList: missing "operatorList" parameter');
    }

    const self = this;
    const xref = this.xref;
    let parsingText = false;
    const localImageCache = new _image_utils.LocalImageCache();
    const localColorSpaceCache = new _image_utils.LocalColorSpaceCache();
    const localGStateCache = new _image_utils.LocalGStateCache();
    const localTilingPatternCache = new _image_utils.LocalTilingPatternCache();
    const localShadingPatternCache = new Map();

    const xobjs = resources.get("XObject") || _primitives.Dict.empty;

    const patterns = resources.get("Pattern") || _primitives.Dict.empty;

    const stateManager = new StateManager(initialState);
    const preprocessor = new EvaluatorPreprocessor(stream, xref, stateManager);
    const timeSlotManager = new TimeSlotManager();

    function closePendingRestoreOPS(argument) {
      for (let i = 0, ii = preprocessor.savedStatesDepth; i < ii; i++) {
        operatorList.addOp(_util.OPS.restore, []);
      }
    }

    return new Promise(function promiseBody(resolve, reject) {
      const next = function (promise) {
        Promise.all([promise, operatorList.ready]).then(function () {
          try {
            promiseBody(resolve, reject);
          } catch (ex) {
            reject(ex);
          }
        }, reject);
      };

      task.ensureNotTerminated();
      timeSlotManager.reset();
      const operation = {};
      let stop, i, ii, cs, name, isValidName;

      while (!(stop = timeSlotManager.check())) {
        operation.args = null;

        if (!preprocessor.read(operation)) {
          break;
        }

        let args = operation.args;
        let fn = operation.fn;

        switch (fn | 0) {
          case _util.OPS.paintXObject:
            isValidName = args[0] instanceof _primitives.Name;
            name = args[0].name;

            if (isValidName) {
              const localImage = localImageCache.getByName(name);

              if (localImage) {
                operatorList.addOp(localImage.fn, localImage.args);
                args = null;
                continue;
              }
            }

            next(new Promise(function (resolveXObject, rejectXObject) {
              if (!isValidName) {
                throw new _util.FormatError("XObject must be referred to by name.");
              }

              let xobj = xobjs.getRaw(name);

              if (xobj instanceof _primitives.Ref) {
                const localImage = localImageCache.getByRef(xobj);

                if (localImage) {
                  operatorList.addOp(localImage.fn, localImage.args);
                  resolveXObject();
                  return;
                }

                const globalImage = self.globalImageCache.getData(xobj, self.pageIndex);

                if (globalImage) {
                  operatorList.addDependency(globalImage.objId);
                  operatorList.addOp(globalImage.fn, globalImage.args);
                  resolveXObject();
                  return;
                }

                xobj = xref.fetch(xobj);
              }

              if (!(0, _primitives.isStream)(xobj)) {
                throw new _util.FormatError("XObject should be a stream");
              }

              const type = xobj.dict.get("Subtype");

              if (!(0, _primitives.isName)(type)) {
                throw new _util.FormatError("XObject should have a Name subtype");
              }

              if (type.name === "Form") {
                stateManager.save();
                self.buildFormXObject(resources, xobj, null, operatorList, task, stateManager.state.clone(), localColorSpaceCache).then(function () {
                  stateManager.restore();
                  resolveXObject();
                }, rejectXObject);
                return;
              } else if (type.name === "Image") {
                self.buildPaintImageXObject({
                  resources,
                  image: xobj,
                  operatorList,
                  cacheKey: name,
                  localImageCache,
                  localColorSpaceCache
                }).then(resolveXObject, rejectXObject);
                return;
              } else if (type.name === "PS") {
                (0, _util.info)("Ignored XObject subtype PS");
              } else {
                throw new _util.FormatError(`Unhandled XObject subtype ${type.name}`);
              }

              resolveXObject();
            }).catch(function (reason) {
              if (reason instanceof _util.AbortException) {
                return;
              }

              if (self.options.ignoreErrors) {
                self.handler.send("UnsupportedFeature", {
                  featureId: _util.UNSUPPORTED_FEATURES.errorXObject
                });
                (0, _util.warn)(`getOperatorList - ignoring XObject: "${reason}".`);
                return;
              }

              throw reason;
            }));
            return;

          case _util.OPS.setFont:
            var fontSize = args[1];
            next(self.handleSetFont(resources, args, null, operatorList, task, stateManager.state, fallbackFontDict).then(function (loadedName) {
              operatorList.addDependency(loadedName);
              operatorList.addOp(_util.OPS.setFont, [loadedName, fontSize]);
            }));
            return;

          case _util.OPS.beginText:
            parsingText = true;
            break;

          case _util.OPS.endText:
            parsingText = false;
            break;

          case _util.OPS.endInlineImage:
            var cacheKey = args[0].cacheKey;

            if (cacheKey) {
              const localImage = localImageCache.getByName(cacheKey);

              if (localImage) {
                operatorList.addOp(localImage.fn, localImage.args);
                args = null;
                continue;
              }
            }

            next(self.buildPaintImageXObject({
              resources,
              image: args[0],
              isInline: true,
              operatorList,
              cacheKey,
              localImageCache,
              localColorSpaceCache
            }));
            return;

          case _util.OPS.showText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            args[0] = self.handleText(args[0], stateManager.state);
            break;

          case _util.OPS.showSpacedText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            var arr = args[0];
            var combinedGlyphs = [];
            var arrLength = arr.length;
            var state = stateManager.state;

            for (i = 0; i < arrLength; ++i) {
              const arrItem = arr[i];

              if ((0, _util.isString)(arrItem)) {
                Array.prototype.push.apply(combinedGlyphs, self.handleText(arrItem, state));
              } else if ((0, _util.isNum)(arrItem)) {
                combinedGlyphs.push(arrItem);
              }
            }

            args[0] = combinedGlyphs;
            fn = _util.OPS.showText;
            break;

          case _util.OPS.nextLineShowText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            operatorList.addOp(_util.OPS.nextLine);
            args[0] = self.handleText(args[0], stateManager.state);
            fn = _util.OPS.showText;
            break;

          case _util.OPS.nextLineSetSpacingShowText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            operatorList.addOp(_util.OPS.nextLine);
            operatorList.addOp(_util.OPS.setWordSpacing, [args.shift()]);
            operatorList.addOp(_util.OPS.setCharSpacing, [args.shift()]);
            args[0] = self.handleText(args[0], stateManager.state);
            fn = _util.OPS.showText;
            break;

          case _util.OPS.setTextRenderingMode:
            stateManager.state.textRenderingMode = args[0];
            break;

          case _util.OPS.setFillColorSpace:
            {
              const cachedColorSpace = _colorspace.ColorSpace.getCached(args[0], xref, localColorSpaceCache);

              if (cachedColorSpace) {
                stateManager.state.fillColorSpace = cachedColorSpace;
                continue;
              }

              next(self.parseColorSpace({
                cs: args[0],
                resources,
                localColorSpaceCache
              }).then(function (colorSpace) {
                if (colorSpace) {
                  stateManager.state.fillColorSpace = colorSpace;
                }
              }));
              return;
            }

          case _util.OPS.setStrokeColorSpace:
            {
              const cachedColorSpace = _colorspace.ColorSpace.getCached(args[0], xref, localColorSpaceCache);

              if (cachedColorSpace) {
                stateManager.state.strokeColorSpace = cachedColorSpace;
                continue;
              }

              next(self.parseColorSpace({
                cs: args[0],
                resources,
                localColorSpaceCache
              }).then(function (colorSpace) {
                if (colorSpace) {
                  stateManager.state.strokeColorSpace = colorSpace;
                }
              }));
              return;
            }

          case _util.OPS.setFillColor:
            cs = stateManager.state.fillColorSpace;
            args = cs.getRgb(args, 0);
            fn = _util.OPS.setFillRGBColor;
            break;

          case _util.OPS.setStrokeColor:
            cs = stateManager.state.strokeColorSpace;
            args = cs.getRgb(args, 0);
            fn = _util.OPS.setStrokeRGBColor;
            break;

          case _util.OPS.setFillGray:
            stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.gray;
            args = _colorspace.ColorSpace.singletons.gray.getRgb(args, 0);
            fn = _util.OPS.setFillRGBColor;
            break;

          case _util.OPS.setStrokeGray:
            stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.gray;
            args = _colorspace.ColorSpace.singletons.gray.getRgb(args, 0);
            fn = _util.OPS.setStrokeRGBColor;
            break;

          case _util.OPS.setFillCMYKColor:
            stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.cmyk;
            args = _colorspace.ColorSpace.singletons.cmyk.getRgb(args, 0);
            fn = _util.OPS.setFillRGBColor;
            break;

          case _util.OPS.setStrokeCMYKColor:
            stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.cmyk;
            args = _colorspace.ColorSpace.singletons.cmyk.getRgb(args, 0);
            fn = _util.OPS.setStrokeRGBColor;
            break;

          case _util.OPS.setFillRGBColor:
            stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.rgb;
            args = _colorspace.ColorSpace.singletons.rgb.getRgb(args, 0);
            break;

          case _util.OPS.setStrokeRGBColor:
            stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.rgb;
            args = _colorspace.ColorSpace.singletons.rgb.getRgb(args, 0);
            break;

          case _util.OPS.setFillColorN:
            cs = stateManager.state.fillColorSpace;

            if (cs.name === "Pattern") {
              next(self.handleColorN(operatorList, _util.OPS.setFillColorN, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache, localShadingPatternCache));
              return;
            }

            args = cs.getRgb(args, 0);
            fn = _util.OPS.setFillRGBColor;
            break;

          case _util.OPS.setStrokeColorN:
            cs = stateManager.state.strokeColorSpace;

            if (cs.name === "Pattern") {
              next(self.handleColorN(operatorList, _util.OPS.setStrokeColorN, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache, localShadingPatternCache));
              return;
            }

            args = cs.getRgb(args, 0);
            fn = _util.OPS.setStrokeRGBColor;
            break;

          case _util.OPS.shadingFill:
            var shadingRes = resources.get("Shading");

            if (!shadingRes) {
              throw new _util.FormatError("No shading resource found");
            }

            var shading = shadingRes.get(args[0].name);

            if (!shading) {
              throw new _util.FormatError("No shading object found");
            }

            const patternId = self.parseShading({
              shading,
              resources,
              localColorSpaceCache,
              localShadingPatternCache
            });
            args = [patternId];
            fn = _util.OPS.shadingFill;
            break;

          case _util.OPS.setGState:
            isValidName = args[0] instanceof _primitives.Name;
            name = args[0].name;

            if (isValidName) {
              const localGStateObj = localGStateCache.getByName(name);

              if (localGStateObj) {
                if (localGStateObj.length > 0) {
                  operatorList.addOp(_util.OPS.setGState, [localGStateObj]);
                }

                args = null;
                continue;
              }
            }

            next(new Promise(function (resolveGState, rejectGState) {
              if (!isValidName) {
                throw new _util.FormatError("GState must be referred to by name.");
              }

              const extGState = resources.get("ExtGState");

              if (!(extGState instanceof _primitives.Dict)) {
                throw new _util.FormatError("ExtGState should be a dictionary.");
              }

              const gState = extGState.get(name);

              if (!(gState instanceof _primitives.Dict)) {
                throw new _util.FormatError("GState should be a dictionary.");
              }

              self.setGState({
                resources,
                gState,
                operatorList,
                cacheKey: name,
                task,
                stateManager,
                localGStateCache,
                localColorSpaceCache
              }).then(resolveGState, rejectGState);
            }).catch(function (reason) {
              if (reason instanceof _util.AbortException) {
                return;
              }

              if (self.options.ignoreErrors) {
                self.handler.send("UnsupportedFeature", {
                  featureId: _util.UNSUPPORTED_FEATURES.errorExtGState
                });
                (0, _util.warn)(`getOperatorList - ignoring ExtGState: "${reason}".`);
                return;
              }

              throw reason;
            }));
            return;

          case _util.OPS.moveTo:
          case _util.OPS.lineTo:
          case _util.OPS.curveTo:
          case _util.OPS.curveTo2:
          case _util.OPS.curveTo3:
          case _util.OPS.closePath:
          case _util.OPS.rectangle:
            self.buildPath(operatorList, fn, args, parsingText);
            continue;

          case _util.OPS.markPoint:
          case _util.OPS.markPointProps:
          case _util.OPS.beginCompat:
          case _util.OPS.endCompat:
            continue;

          case _util.OPS.beginMarkedContentProps:
            if (!(0, _primitives.isName)(args[0])) {
              (0, _util.warn)(`Expected name for beginMarkedContentProps arg0=${args[0]}`);
              continue;
            }

            if (args[0].name === "OC") {
              next(self.parseMarkedContentProps(args[1], resources).then(data => {
                operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", data]);
              }).catch(reason => {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  self.handler.send("UnsupportedFeature", {
                    featureId: _util.UNSUPPORTED_FEATURES.errorMarkedContent
                  });
                  (0, _util.warn)(`getOperatorList - ignoring beginMarkedContentProps: "${reason}".`);
                  return;
                }

                throw reason;
              }));
              return;
            }

            args = [args[0].name, args[1] instanceof _primitives.Dict ? args[1].get("MCID") : null];
            break;

          case _util.OPS.beginMarkedContent:
          case _util.OPS.endMarkedContent:
          default:
            if (args !== null) {
              for (i = 0, ii = args.length; i < ii; i++) {
                if (args[i] instanceof _primitives.Dict) {
                  break;
                }
              }

              if (i < ii) {
                (0, _util.warn)("getOperatorList - ignoring operator: " + fn);
                continue;
              }
            }

        }

        operatorList.addOp(fn, args);
      }

      if (stop) {
        next(deferred);
        return;
      }

      closePendingRestoreOPS();
      resolve();
    }).catch(reason => {
      if (reason instanceof _util.AbortException) {
        return;
      }

      if (this.options.ignoreErrors) {
        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorOperatorList
        });
        (0, _util.warn)(`getOperatorList - ignoring errors during "${task.name}" ` + `task: "${reason}".`);
        closePendingRestoreOPS();
        return;
      }

      throw reason;
    });
  }

  getTextContent({
    stream,
    task,
    resources,
    stateManager = null,
    normalizeWhitespace = false,
    combineTextItems = false,
    includeMarkedContent = false,
    sink,
    seenStyles = new Set()
  }) {
    resources = resources || _primitives.Dict.empty;
    stateManager = stateManager || new StateManager(new TextState());
    const WhitespaceRegexp = /\s/g;
    const DiacriticRegExp = new RegExp("^\\p{Mn}$", "u");
    const NormalizedUnicodes = (0, _unicode.getNormalizedUnicodes)();
    const textContent = {
      items: [],
      styles: Object.create(null)
    };
    const textContentItem = {
      initialized: false,
      str: [],
      totalWidth: 0,
      totalHeight: 0,
      width: 0,
      height: 0,
      vertical: false,
      prevTransform: null,
      textAdvanceScale: 0,
      spaceInFlowMin: 0,
      spaceInFlowMax: 0,
      trackingSpaceMin: Infinity,
      negativeSpaceMax: -Infinity,
      transform: null,
      fontName: null,
      hasEOL: false
    };
    const TRACKING_SPACE_FACTOR = 0.1;
    const NEGATIVE_SPACE_FACTOR = -0.2;
    const SPACE_IN_FLOW_MIN_FACTOR = 0.1;
    const SPACE_IN_FLOW_MAX_FACTOR = 0.6;
    const self = this;
    const xref = this.xref;
    const showSpacedTextBuffer = [];
    let xobjs = null;
    const emptyXObjectCache = new _image_utils.LocalImageCache();
    const emptyGStateCache = new _image_utils.LocalGStateCache();
    const preprocessor = new EvaluatorPreprocessor(stream, xref, stateManager);
    let textState;

    function getCurrentTextTransform() {
      const font = textState.font;
      const tsm = [textState.fontSize * textState.textHScale, 0, 0, textState.fontSize, 0, textState.textRise];

      if (font.isType3Font && (textState.fontSize <= 1 || font.isCharBBox) && !(0, _util.isArrayEqual)(textState.fontMatrix, _util.FONT_IDENTITY_MATRIX)) {
        const glyphHeight = font.bbox[3] - font.bbox[1];

        if (glyphHeight > 0) {
          tsm[3] *= glyphHeight * textState.fontMatrix[3];
        }
      }

      return _util.Util.transform(textState.ctm, _util.Util.transform(textState.textMatrix, tsm));
    }

    function ensureTextContentItem() {
      if (textContentItem.initialized) {
        return textContentItem;
      }

      const font = textState.font,
            loadedName = font.loadedName;

      if (!seenStyles.has(loadedName)) {
        seenStyles.add(loadedName);
        textContent.styles[loadedName] = {
          fontFamily: font.fallbackName,
          ascent: font.ascent,
          descent: font.descent,
          vertical: font.vertical
        };
      }

      textContentItem.fontName = loadedName;
      const trm = textContentItem.transform = getCurrentTextTransform();

      if (!font.vertical) {
        textContentItem.width = textContentItem.totalWidth = 0;
        textContentItem.height = textContentItem.totalHeight = Math.hypot(trm[2], trm[3]);
        textContentItem.vertical = false;
      } else {
        textContentItem.width = textContentItem.totalWidth = Math.hypot(trm[0], trm[1]);
        textContentItem.height = textContentItem.totalHeight = 0;
        textContentItem.vertical = true;
      }

      const scaleLineX = Math.hypot(textState.textLineMatrix[0], textState.textLineMatrix[1]);
      const scaleCtmX = Math.hypot(textState.ctm[0], textState.ctm[1]);
      textContentItem.textAdvanceScale = scaleCtmX * scaleLineX;
      textContentItem.trackingSpaceMin = textState.fontSize * TRACKING_SPACE_FACTOR;
      textContentItem.negativeSpaceMax = textState.fontSize * NEGATIVE_SPACE_FACTOR;
      textContentItem.spaceInFlowMin = textState.fontSize * SPACE_IN_FLOW_MIN_FACTOR;
      textContentItem.spaceInFlowMax = textState.fontSize * SPACE_IN_FLOW_MAX_FACTOR;
      textContentItem.hasEOL = false;
      textContentItem.initialized = true;
      return textContentItem;
    }

    function updateAdvanceScale() {
      if (!textContentItem.initialized) {
        return;
      }

      const scaleLineX = Math.hypot(textState.textLineMatrix[0], textState.textLineMatrix[1]);
      const scaleCtmX = Math.hypot(textState.ctm[0], textState.ctm[1]);
      const scaleFactor = scaleCtmX * scaleLineX;

      if (scaleFactor === textContentItem.textAdvanceScale) {
        return;
      }

      if (!textContentItem.vertical) {
        textContentItem.totalWidth += textContentItem.width * textContentItem.textAdvanceScale;
        textContentItem.width = 0;
      } else {
        textContentItem.totalHeight += textContentItem.height * textContentItem.textAdvanceScale;
        textContentItem.height = 0;
      }

      textContentItem.textAdvanceScale = scaleFactor;
    }

    function replaceWhitespace(str) {
      const ii = str.length;
      let i = 0,
          code;

      while (i < ii && (code = str.charCodeAt(i)) >= 0x20 && code <= 0x7f) {
        i++;
      }

      return i < ii ? str.replace(WhitespaceRegexp, " ") : str;
    }

    function runBidiTransform(textChunk) {
      const text = textChunk.str.join("");
      const bidiResult = (0, _bidi.bidi)(text, -1, textChunk.vertical);
      const str = normalizeWhitespace ? replaceWhitespace(bidiResult.str) : bidiResult.str;
      return {
        str,
        dir: bidiResult.dir,
        width: textChunk.totalWidth,
        height: textChunk.totalHeight,
        transform: textChunk.transform,
        fontName: textChunk.fontName,
        hasEOL: textChunk.hasEOL
      };
    }

    function handleSetFont(fontName, fontRef) {
      return self.loadFont(fontName, fontRef, resources).then(function (translated) {
        if (!translated.font.isType3Font) {
          return translated;
        }

        return translated.loadType3Data(self, resources, task).catch(function () {}).then(function () {
          return translated;
        });
      }).then(function (translated) {
        textState.font = translated.font;
        textState.fontMatrix = translated.font.fontMatrix || _util.FONT_IDENTITY_MATRIX;
      });
    }

    function compareWithLastPosition() {
      if (!combineTextItems || !textState.font || !textContentItem.prevTransform) {
        return;
      }

      const currentTransform = getCurrentTextTransform();
      let posX = currentTransform[4];
      let posY = currentTransform[5];
      let lastPosX = textContentItem.prevTransform[4];
      let lastPosY = textContentItem.prevTransform[5];

      if (lastPosX === posX && lastPosY === posY) {
        return;
      }

      let rotate = 0;

      if (currentTransform[0] && currentTransform[1] === 0 && currentTransform[2] === 0) {
        rotate = currentTransform[0] > 0 ? 0 : 180;
      } else if (currentTransform[1] && currentTransform[0] === 0 && currentTransform[3] === 0) {
        rotate += currentTransform[1] > 0 ? 90 : 270;
      }

      if (rotate !== 0) {
        switch (rotate) {
          case 90:
            [posX, posY] = [posY, posX];
            [lastPosX, lastPosY] = [lastPosY, lastPosX];
            break;

          case 180:
            [posX, posY, lastPosX, lastPosY] = [-posX, -posY, -lastPosX, -lastPosY];
            break;

          case 270:
            [posX, posY] = [-posY, -posX];
            [lastPosX, lastPosY] = [-lastPosY, -lastPosX];
            break;
        }
      }

      if (textState.font.vertical) {
        const advanceY = (lastPosY - posY) / textContentItem.textAdvanceScale;
        const advanceX = posX - lastPosX;

        if (advanceY < textContentItem.negativeSpaceMax) {
          if (Math.abs(advanceX) > 0.5 * textContentItem.width) {
            appendEOL();
            return;
          }

          flushTextContentItem();
          return;
        }

        if (Math.abs(advanceX) > textContentItem.height) {
          appendEOL();
          return;
        }

        if (advanceY <= textContentItem.trackingSpaceMin) {
          textContentItem.height += advanceY;
        } else if (!addFakeSpaces(advanceY, textContentItem.prevTransform)) {
          if (textContentItem.str.length === 0) {
            textContent.items.push({
              str: " ",
              dir: "ltr",
              width: 0,
              height: advanceY,
              transform: textContentItem.prevTransform,
              fontName: textContentItem.fontName,
              hasEOL: false
            });
          } else {
            textContentItem.height += advanceY;
          }
        }

        return;
      }

      const advanceX = (posX - lastPosX) / textContentItem.textAdvanceScale;
      const advanceY = posY - lastPosY;

      if (advanceX < textContentItem.negativeSpaceMax) {
        if (Math.abs(advanceY) > 0.5 * textContentItem.height) {
          appendEOL();
          return;
        }

        flushTextContentItem();
        return;
      }

      if (Math.abs(advanceY) > textContentItem.height) {
        appendEOL();
        return;
      }

      if (advanceX <= textContentItem.trackingSpaceMin) {
        textContentItem.width += advanceX;
      } else if (!addFakeSpaces(advanceX, textContentItem.prevTransform)) {
        if (textContentItem.str.length === 0) {
          textContent.items.push({
            str: " ",
            dir: "ltr",
            width: advanceX,
            height: 0,
            transform: textContentItem.prevTransform,
            fontName: textContentItem.fontName,
            hasEOL: false
          });
        } else {
          textContentItem.width += advanceX;
        }
      }
    }

    function buildTextContentItem({
      chars,
      extraSpacing
    }) {
      const font = textState.font;

      if (!chars) {
        const charSpacing = textState.charSpacing + extraSpacing;

        if (charSpacing) {
          if (!font.vertical) {
            textState.translateTextMatrix(charSpacing * textState.textHScale, 0);
          } else {
            textState.translateTextMatrix(0, -charSpacing);
          }
        }

        return;
      }

      const glyphs = font.charsToGlyphs(chars);
      const scale = textState.fontMatrix[0] * textState.fontSize;

      for (let i = 0, ii = glyphs.length; i < ii; i++) {
        const glyph = glyphs[i];
        let charSpacing = textState.charSpacing + (i + 1 === ii ? extraSpacing : 0);
        let glyphWidth = glyph.width;

        if (font.vertical) {
          glyphWidth = glyph.vmetric ? glyph.vmetric[0] : -glyphWidth;
        }

        let scaledDim = glyphWidth * scale;
        let glyphUnicode = glyph.unicode;

        if (glyphUnicode === " " && (i === 0 || i + 1 === ii || glyphs[i - 1].unicode === " " || glyphs[i + 1].unicode === " " || extraSpacing)) {
          if (!font.vertical) {
            charSpacing += scaledDim + textState.wordSpacing;
            textState.translateTextMatrix(charSpacing * textState.textHScale, 0);
          } else {
            charSpacing += -scaledDim + textState.wordSpacing;
            textState.translateTextMatrix(0, -charSpacing);
          }

          continue;
        }

        compareWithLastPosition();
        const textChunk = ensureTextContentItem();

        if (DiacriticRegExp.test(glyph.unicode)) {
          scaledDim = 0;
        }

        if (!font.vertical) {
          scaledDim *= textState.textHScale;
          textState.translateTextMatrix(scaledDim, 0);
          textChunk.width += scaledDim;
        } else {
          textState.translateTextMatrix(0, scaledDim);
          scaledDim = Math.abs(scaledDim);
          textChunk.height += scaledDim;
        }

        if (scaledDim) {
          textChunk.prevTransform = getCurrentTextTransform();
        }

        glyphUnicode = NormalizedUnicodes[glyphUnicode] || glyphUnicode;
        glyphUnicode = (0, _unicode.reverseIfRtl)(glyphUnicode);
        textChunk.str.push(glyphUnicode);

        if (charSpacing) {
          if (!font.vertical) {
            textState.translateTextMatrix(charSpacing * textState.textHScale, 0);
          } else {
            textState.translateTextMatrix(0, -charSpacing);
          }
        }
      }
    }

    function appendEOL() {
      if (textContentItem.initialized) {
        textContentItem.hasEOL = true;
        flushTextContentItem();
      } else {
        textContent.items.push({
          str: "",
          dir: "ltr",
          width: 0,
          height: 0,
          transform: getCurrentTextTransform(),
          fontName: textState.font.loadedName,
          hasEOL: true
        });
      }
    }

    function addFakeSpaces(width, transf) {
      if (textContentItem.spaceInFlowMin <= width && width <= textContentItem.spaceInFlowMax) {
        if (textContentItem.initialized) {
          textContentItem.str.push(" ");
        }

        return false;
      }

      const fontName = textContentItem.fontName;
      let height = 0;

      if (textContentItem.vertical) {
        height = width;
        width = 0;
      }

      flushTextContentItem();
      textContent.items.push({
        str: " ",
        dir: "ltr",
        width,
        height,
        transform: transf || getCurrentTextTransform(),
        fontName,
        hasEOL: false
      });
      return true;
    }

    function flushTextContentItem() {
      if (!textContentItem.initialized || !textContentItem.str) {
        return;
      }

      if (!textContentItem.vertical) {
        textContentItem.totalWidth += textContentItem.width * textContentItem.textAdvanceScale;
      } else {
        textContentItem.totalHeight += textContentItem.height * textContentItem.textAdvanceScale;
      }

      textContent.items.push(runBidiTransform(textContentItem));
      textContentItem.initialized = false;
      textContentItem.str.length = 0;
    }

    function enqueueChunk(batch = false) {
      const length = textContent.items.length;

      if (length === 0) {
        return;
      }

      if (batch && length < TEXT_CHUNK_BATCH_SIZE) {
        return;
      }

      sink.enqueue(textContent, length);
      textContent.items = [];
      textContent.styles = Object.create(null);
    }

    const timeSlotManager = new TimeSlotManager();
    return new Promise(function promiseBody(resolve, reject) {
      const next = function (promise) {
        enqueueChunk(true);
        Promise.all([promise, sink.ready]).then(function () {
          try {
            promiseBody(resolve, reject);
          } catch (ex) {
            reject(ex);
          }
        }, reject);
      };

      task.ensureNotTerminated();
      timeSlotManager.reset();
      const operation = {};
      let stop,
          args = [];

      while (!(stop = timeSlotManager.check())) {
        args.length = 0;
        operation.args = args;

        if (!preprocessor.read(operation)) {
          break;
        }

        textState = stateManager.state;
        const fn = operation.fn;
        args = operation.args;

        switch (fn | 0) {
          case _util.OPS.setFont:
            var fontNameArg = args[0].name,
                fontSizeArg = args[1];

            if (textState.font && fontNameArg === textState.fontName && fontSizeArg === textState.fontSize) {
              break;
            }

            flushTextContentItem();
            textState.fontName = fontNameArg;
            textState.fontSize = fontSizeArg;
            next(handleSetFont(fontNameArg, null));
            return;

          case _util.OPS.setTextRise:
            textState.textRise = args[0];
            break;

          case _util.OPS.setHScale:
            textState.textHScale = args[0] / 100;
            break;

          case _util.OPS.setLeading:
            textState.leading = args[0];
            break;

          case _util.OPS.moveText:
            textState.translateTextLineMatrix(args[0], args[1]);
            textState.textMatrix = textState.textLineMatrix.slice();
            break;

          case _util.OPS.setLeadingMoveText:
            textState.leading = -args[1];
            textState.translateTextLineMatrix(args[0], args[1]);
            textState.textMatrix = textState.textLineMatrix.slice();
            break;

          case _util.OPS.nextLine:
            textState.carriageReturn();
            break;

          case _util.OPS.setTextMatrix:
            textState.setTextMatrix(args[0], args[1], args[2], args[3], args[4], args[5]);
            textState.setTextLineMatrix(args[0], args[1], args[2], args[3], args[4], args[5]);
            updateAdvanceScale();
            break;

          case _util.OPS.setCharSpacing:
            textState.charSpacing = args[0];
            break;

          case _util.OPS.setWordSpacing:
            textState.wordSpacing = args[0];
            break;

          case _util.OPS.beginText:
            textState.textMatrix = _util.IDENTITY_MATRIX.slice();
            textState.textLineMatrix = _util.IDENTITY_MATRIX.slice();
            break;

          case _util.OPS.showSpacedText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            const spaceFactor = (textState.font.vertical ? 1 : -1) * textState.fontSize / 1000;
            const elements = args[0];

            for (let i = 0, ii = elements.length; i < ii - 1; i++) {
              const item = elements[i];

              if (typeof item === "string") {
                showSpacedTextBuffer.push(item);
              } else if (typeof item === "number" && item !== 0) {
                const str = showSpacedTextBuffer.join("");
                showSpacedTextBuffer.length = 0;
                buildTextContentItem({
                  chars: str,
                  extraSpacing: item * spaceFactor
                });
              }
            }

            const item = elements[elements.length - 1];

            if (typeof item === "string") {
              showSpacedTextBuffer.push(item);
            }

            if (showSpacedTextBuffer.length > 0) {
              const str = showSpacedTextBuffer.join("");
              showSpacedTextBuffer.length = 0;
              buildTextContentItem({
                chars: str,
                extraSpacing: 0
              });
            }

            break;

          case _util.OPS.showText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            buildTextContentItem({
              chars: args[0],
              extraSpacing: 0
            });
            break;

          case _util.OPS.nextLineShowText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            textState.carriageReturn();
            buildTextContentItem({
              chars: args[0],
              extraSpacing: 0
            });
            break;

          case _util.OPS.nextLineSetSpacingShowText:
            if (!stateManager.state.font) {
              self.ensureStateFont(stateManager.state);
              continue;
            }

            textState.wordSpacing = args[0];
            textState.charSpacing = args[1];
            textState.carriageReturn();
            buildTextContentItem({
              chars: args[2],
              extraSpacing: 0
            });
            break;

          case _util.OPS.paintXObject:
            flushTextContentItem();

            if (!xobjs) {
              xobjs = resources.get("XObject") || _primitives.Dict.empty;
            }

            var isValidName = args[0] instanceof _primitives.Name;
            var name = args[0].name;

            if (isValidName && emptyXObjectCache.getByName(name)) {
              break;
            }

            next(new Promise(function (resolveXObject, rejectXObject) {
              if (!isValidName) {
                throw new _util.FormatError("XObject must be referred to by name.");
              }

              let xobj = xobjs.getRaw(name);

              if (xobj instanceof _primitives.Ref) {
                if (emptyXObjectCache.getByRef(xobj)) {
                  resolveXObject();
                  return;
                }

                const globalImage = self.globalImageCache.getData(xobj, self.pageIndex);

                if (globalImage) {
                  resolveXObject();
                  return;
                }

                xobj = xref.fetch(xobj);
              }

              if (!(0, _primitives.isStream)(xobj)) {
                throw new _util.FormatError("XObject should be a stream");
              }

              const type = xobj.dict.get("Subtype");

              if (!(0, _primitives.isName)(type)) {
                throw new _util.FormatError("XObject should have a Name subtype");
              }

              if (type.name !== "Form") {
                emptyXObjectCache.set(name, xobj.dict.objId, true);
                resolveXObject();
                return;
              }

              const currentState = stateManager.state.clone();
              const xObjStateManager = new StateManager(currentState);
              const matrix = xobj.dict.getArray("Matrix");

              if (Array.isArray(matrix) && matrix.length === 6) {
                xObjStateManager.transform(matrix);
              }

              enqueueChunk();
              const sinkWrapper = {
                enqueueInvoked: false,

                enqueue(chunk, size) {
                  this.enqueueInvoked = true;
                  sink.enqueue(chunk, size);
                },

                get desiredSize() {
                  return sink.desiredSize;
                },

                get ready() {
                  return sink.ready;
                }

              };
              self.getTextContent({
                stream: xobj,
                task,
                resources: xobj.dict.get("Resources") || resources,
                stateManager: xObjStateManager,
                normalizeWhitespace,
                combineTextItems,
                includeMarkedContent,
                sink: sinkWrapper,
                seenStyles
              }).then(function () {
                if (!sinkWrapper.enqueueInvoked) {
                  emptyXObjectCache.set(name, xobj.dict.objId, true);
                }

                resolveXObject();
              }, rejectXObject);
            }).catch(function (reason) {
              if (reason instanceof _util.AbortException) {
                return;
              }

              if (self.options.ignoreErrors) {
                (0, _util.warn)(`getTextContent - ignoring XObject: "${reason}".`);
                return;
              }

              throw reason;
            }));
            return;

          case _util.OPS.setGState:
            isValidName = args[0] instanceof _primitives.Name;
            name = args[0].name;

            if (isValidName && emptyGStateCache.getByName(name)) {
              break;
            }

            next(new Promise(function (resolveGState, rejectGState) {
              if (!isValidName) {
                throw new _util.FormatError("GState must be referred to by name.");
              }

              const extGState = resources.get("ExtGState");

              if (!(extGState instanceof _primitives.Dict)) {
                throw new _util.FormatError("ExtGState should be a dictionary.");
              }

              const gState = extGState.get(name);

              if (!(gState instanceof _primitives.Dict)) {
                throw new _util.FormatError("GState should be a dictionary.");
              }

              const gStateFont = gState.get("Font");

              if (!gStateFont) {
                emptyGStateCache.set(name, gState.objId, true);
                resolveGState();
                return;
              }

              flushTextContentItem();
              textState.fontName = null;
              textState.fontSize = gStateFont[1];
              handleSetFont(null, gStateFont[0]).then(resolveGState, rejectGState);
            }).catch(function (reason) {
              if (reason instanceof _util.AbortException) {
                return;
              }

              if (self.options.ignoreErrors) {
                (0, _util.warn)(`getTextContent - ignoring ExtGState: "${reason}".`);
                return;
              }

              throw reason;
            }));
            return;

          case _util.OPS.beginMarkedContent:
            if (includeMarkedContent) {
              textContent.items.push({
                type: "beginMarkedContent",
                tag: (0, _primitives.isName)(args[0]) ? args[0].name : null
              });
            }

            break;

          case _util.OPS.beginMarkedContentProps:
            if (includeMarkedContent) {
              flushTextContentItem();
              let mcid = null;

              if ((0, _primitives.isDict)(args[1])) {
                mcid = args[1].get("MCID");
              }

              textContent.items.push({
                type: "beginMarkedContentProps",
                id: Number.isInteger(mcid) ? `${self.idFactory.getPageObjId()}_mcid${mcid}` : null,
                tag: (0, _primitives.isName)(args[0]) ? args[0].name : null
              });
            }

            break;

          case _util.OPS.endMarkedContent:
            if (includeMarkedContent) {
              flushTextContentItem();
              textContent.items.push({
                type: "endMarkedContent"
              });
            }

            break;
        }

        if (textContent.items.length >= sink.desiredSize) {
          stop = true;
          break;
        }
      }

      if (stop) {
        next(deferred);
        return;
      }

      flushTextContentItem();
      enqueueChunk();
      resolve();
    }).catch(reason => {
      if (reason instanceof _util.AbortException) {
        return;
      }

      if (this.options.ignoreErrors) {
        (0, _util.warn)(`getTextContent - ignoring errors during "${task.name}" ` + `task: "${reason}".`);
        flushTextContentItem();
        enqueueChunk();
        return;
      }

      throw reason;
    });
  }

  extractDataStructures(dict, baseDict, properties) {
    const xref = this.xref;
    let cidToGidBytes;
    const toUnicodePromise = this.readToUnicode(properties.toUnicode || dict.get("ToUnicode") || baseDict.get("ToUnicode"));

    if (properties.composite) {
      const cidSystemInfo = dict.get("CIDSystemInfo");

      if ((0, _primitives.isDict)(cidSystemInfo)) {
        properties.cidSystemInfo = {
          registry: (0, _util.stringToPDFString)(cidSystemInfo.get("Registry")),
          ordering: (0, _util.stringToPDFString)(cidSystemInfo.get("Ordering")),
          supplement: cidSystemInfo.get("Supplement")
        };
      }

      const cidToGidMap = dict.get("CIDToGIDMap");

      if (cidToGidMap instanceof _base_stream.BaseStream) {
        cidToGidBytes = cidToGidMap.getBytes();
      }
    }

    const differences = [];
    let baseEncodingName = null;
    let encoding;

    if (dict.has("Encoding")) {
      encoding = dict.get("Encoding");

      if ((0, _primitives.isDict)(encoding)) {
        baseEncodingName = encoding.get("BaseEncoding");
        baseEncodingName = (0, _primitives.isName)(baseEncodingName) ? baseEncodingName.name : null;

        if (encoding.has("Differences")) {
          const diffEncoding = encoding.get("Differences");
          let index = 0;

          for (let j = 0, jj = diffEncoding.length; j < jj; j++) {
            const data = xref.fetchIfRef(diffEncoding[j]);

            if ((0, _util.isNum)(data)) {
              index = data;
            } else if ((0, _primitives.isName)(data)) {
              differences[index++] = data.name;
            } else {
              throw new _util.FormatError(`Invalid entry in 'Differences' array: ${data}`);
            }
          }
        }
      } else if ((0, _primitives.isName)(encoding)) {
        baseEncodingName = encoding.name;
      } else {
        throw new _util.FormatError("Encoding is not a Name nor a Dict");
      }

      if (baseEncodingName !== "MacRomanEncoding" && baseEncodingName !== "MacExpertEncoding" && baseEncodingName !== "WinAnsiEncoding") {
        baseEncodingName = null;
      }
    }

    if (baseEncodingName) {
      properties.defaultEncoding = (0, _encodings.getEncoding)(baseEncodingName);
    } else {
      const isSymbolicFont = !!(properties.flags & _fonts_utils.FontFlags.Symbolic);
      const isNonsymbolicFont = !!(properties.flags & _fonts_utils.FontFlags.Nonsymbolic);
      encoding = _encodings.StandardEncoding;

      if (properties.type === "TrueType" && !isNonsymbolicFont) {
        encoding = _encodings.WinAnsiEncoding;
      }

      if (isSymbolicFont) {
        encoding = _encodings.MacRomanEncoding;

        if (!properties.file || properties.isInternalFont) {
          if (/Symbol/i.test(properties.name)) {
            encoding = _encodings.SymbolSetEncoding;
          } else if (/Dingbats|Wingdings/i.test(properties.name)) {
            encoding = _encodings.ZapfDingbatsEncoding;
          }
        }
      }

      properties.defaultEncoding = encoding;
    }

    properties.differences = differences;
    properties.baseEncodingName = baseEncodingName;
    properties.hasEncoding = !!baseEncodingName || differences.length > 0;
    properties.dict = dict;
    return toUnicodePromise.then(readToUnicode => {
      properties.toUnicode = readToUnicode;
      return this.buildToUnicode(properties);
    }).then(builtToUnicode => {
      properties.toUnicode = builtToUnicode;

      if (cidToGidBytes) {
        properties.cidToGidMap = this.readCidToGidMap(cidToGidBytes, builtToUnicode);
      }

      return properties;
    });
  }

  _simpleFontToUnicode(properties, forceGlyphs = false) {
    (0, _util.assert)(!properties.composite, "Must be a simple font.");
    const toUnicode = [];
    const encoding = properties.defaultEncoding.slice();
    const baseEncodingName = properties.baseEncodingName;
    const differences = properties.differences;

    for (const charcode in differences) {
      const glyphName = differences[charcode];

      if (glyphName === ".notdef") {
        continue;
      }

      encoding[charcode] = glyphName;
    }

    const glyphsUnicodeMap = (0, _glyphlist.getGlyphsUnicode)();

    for (const charcode in encoding) {
      let glyphName = encoding[charcode];

      if (glyphName === "") {
        continue;
      } else if (glyphsUnicodeMap[glyphName] === undefined) {
        let code = 0;

        switch (glyphName[0]) {
          case "G":
            if (glyphName.length === 3) {
              code = parseInt(glyphName.substring(1), 16);
            }

            break;

          case "g":
            if (glyphName.length === 5) {
              code = parseInt(glyphName.substring(1), 16);
            }

            break;

          case "C":
          case "c":
            if (glyphName.length >= 3 && glyphName.length <= 4) {
              const codeStr = glyphName.substring(1);

              if (forceGlyphs) {
                code = parseInt(codeStr, 16);
                break;
              }

              code = +codeStr;

              if (Number.isNaN(code) && Number.isInteger(parseInt(codeStr, 16))) {
                return this._simpleFontToUnicode(properties, true);
              }
            }

            break;

          default:
            const unicode = (0, _unicode.getUnicodeForGlyph)(glyphName, glyphsUnicodeMap);

            if (unicode !== -1) {
              code = unicode;
            }

        }

        if (code > 0 && code <= 0x10ffff && Number.isInteger(code)) {
          if (baseEncodingName && code === +charcode) {
            const baseEncoding = (0, _encodings.getEncoding)(baseEncodingName);

            if (baseEncoding && (glyphName = baseEncoding[charcode])) {
              toUnicode[charcode] = String.fromCharCode(glyphsUnicodeMap[glyphName]);
              continue;
            }
          }

          toUnicode[charcode] = String.fromCodePoint(code);
        }

        continue;
      }

      toUnicode[charcode] = String.fromCharCode(glyphsUnicodeMap[glyphName]);
    }

    return toUnicode;
  }

  async buildToUnicode(properties) {
    properties.hasIncludedToUnicodeMap = !!properties.toUnicode && properties.toUnicode.length > 0;

    if (properties.hasIncludedToUnicodeMap) {
      if (!properties.composite && properties.hasEncoding) {
        properties.fallbackToUnicode = this._simpleFontToUnicode(properties);
      }

      return properties.toUnicode;
    }

    if (!properties.composite) {
      return new _to_unicode_map.ToUnicodeMap(this._simpleFontToUnicode(properties));
    }

    if (properties.composite && (properties.cMap.builtInCMap && !(properties.cMap instanceof _cmap.IdentityCMap) || properties.cidSystemInfo.registry === "Adobe" && (properties.cidSystemInfo.ordering === "GB1" || properties.cidSystemInfo.ordering === "CNS1" || properties.cidSystemInfo.ordering === "Japan1" || properties.cidSystemInfo.ordering === "Korea1"))) {
      const {
        registry,
        ordering
      } = properties.cidSystemInfo;

      const ucs2CMapName = _primitives.Name.get(`${registry}-${ordering}-UCS2`);

      const ucs2CMap = await _cmap.CMapFactory.create({
        encoding: ucs2CMapName,
        fetchBuiltInCMap: this._fetchBuiltInCMapBound,
        useCMap: null
      });
      const toUnicode = [];
      properties.cMap.forEach(function (charcode, cid) {
        if (cid > 0xffff) {
          throw new _util.FormatError("Max size of CID is 65,535");
        }

        const ucs2 = ucs2CMap.lookup(cid);

        if (ucs2) {
          toUnicode[charcode] = String.fromCharCode((ucs2.charCodeAt(0) << 8) + ucs2.charCodeAt(1));
        }
      });
      return new _to_unicode_map.ToUnicodeMap(toUnicode);
    }

    return new _to_unicode_map.IdentityToUnicodeMap(properties.firstChar, properties.lastChar);
  }

  readToUnicode(cmapObj) {
    if (!cmapObj) {
      return Promise.resolve(null);
    }

    if ((0, _primitives.isName)(cmapObj)) {
      return _cmap.CMapFactory.create({
        encoding: cmapObj,
        fetchBuiltInCMap: this._fetchBuiltInCMapBound,
        useCMap: null
      }).then(function (cmap) {
        if (cmap instanceof _cmap.IdentityCMap) {
          return new _to_unicode_map.IdentityToUnicodeMap(0, 0xffff);
        }

        return new _to_unicode_map.ToUnicodeMap(cmap.getMap());
      });
    } else if ((0, _primitives.isStream)(cmapObj)) {
      return _cmap.CMapFactory.create({
        encoding: cmapObj,
        fetchBuiltInCMap: this._fetchBuiltInCMapBound,
        useCMap: null
      }).then(function (cmap) {
        if (cmap instanceof _cmap.IdentityCMap) {
          return new _to_unicode_map.IdentityToUnicodeMap(0, 0xffff);
        }

        const map = new Array(cmap.length);
        cmap.forEach(function (charCode, token) {
          if (typeof token === "number") {
            map[charCode] = String.fromCodePoint(token);
            return;
          }

          const str = [];

          for (let k = 0; k < token.length; k += 2) {
            const w1 = token.charCodeAt(k) << 8 | token.charCodeAt(k + 1);

            if ((w1 & 0xf800) !== 0xd800) {
              str.push(w1);
              continue;
            }

            k += 2;
            const w2 = token.charCodeAt(k) << 8 | token.charCodeAt(k + 1);
            str.push(((w1 & 0x3ff) << 10) + (w2 & 0x3ff) + 0x10000);
          }

          map[charCode] = String.fromCodePoint.apply(String, str);
        });
        return new _to_unicode_map.ToUnicodeMap(map);
      }, reason => {
        if (reason instanceof _util.AbortException) {
          return null;
        }

        if (this.options.ignoreErrors) {
          this.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorFontToUnicode
          });
          (0, _util.warn)(`readToUnicode - ignoring ToUnicode data: "${reason}".`);
          return null;
        }

        throw reason;
      });
    }

    return Promise.resolve(null);
  }

  readCidToGidMap(glyphsData, toUnicode) {
    const result = [];

    for (let j = 0, jj = glyphsData.length; j < jj; j++) {
      const glyphID = glyphsData[j++] << 8 | glyphsData[j];
      const code = j >> 1;

      if (glyphID === 0 && !toUnicode.has(code)) {
        continue;
      }

      result[code] = glyphID;
    }

    return result;
  }

  extractWidths(dict, descriptor, properties) {
    const xref = this.xref;
    let glyphsWidths = [];
    let defaultWidth = 0;
    const glyphsVMetrics = [];
    let defaultVMetrics;
    let i, ii, j, jj, start, code, widths;

    if (properties.composite) {
      defaultWidth = dict.has("DW") ? dict.get("DW") : 1000;
      widths = dict.get("W");

      if (widths) {
        for (i = 0, ii = widths.length; i < ii; i++) {
          start = xref.fetchIfRef(widths[i++]);
          code = xref.fetchIfRef(widths[i]);

          if (Array.isArray(code)) {
            for (j = 0, jj = code.length; j < jj; j++) {
              glyphsWidths[start++] = xref.fetchIfRef(code[j]);
            }
          } else {
            const width = xref.fetchIfRef(widths[++i]);

            for (j = start; j <= code; j++) {
              glyphsWidths[j] = width;
            }
          }
        }
      }

      if (properties.vertical) {
        let vmetrics = dict.getArray("DW2") || [880, -1000];
        defaultVMetrics = [vmetrics[1], defaultWidth * 0.5, vmetrics[0]];
        vmetrics = dict.get("W2");

        if (vmetrics) {
          for (i = 0, ii = vmetrics.length; i < ii; i++) {
            start = xref.fetchIfRef(vmetrics[i++]);
            code = xref.fetchIfRef(vmetrics[i]);

            if (Array.isArray(code)) {
              for (j = 0, jj = code.length; j < jj; j++) {
                glyphsVMetrics[start++] = [xref.fetchIfRef(code[j++]), xref.fetchIfRef(code[j++]), xref.fetchIfRef(code[j])];
              }
            } else {
              const vmetric = [xref.fetchIfRef(vmetrics[++i]), xref.fetchIfRef(vmetrics[++i]), xref.fetchIfRef(vmetrics[++i])];

              for (j = start; j <= code; j++) {
                glyphsVMetrics[j] = vmetric;
              }
            }
          }
        }
      }
    } else {
      const firstChar = properties.firstChar;
      widths = dict.get("Widths");

      if (widths) {
        j = firstChar;

        for (i = 0, ii = widths.length; i < ii; i++) {
          glyphsWidths[j++] = xref.fetchIfRef(widths[i]);
        }

        defaultWidth = parseFloat(descriptor.get("MissingWidth")) || 0;
      } else {
        const baseFontName = dict.get("BaseFont");

        if ((0, _primitives.isName)(baseFontName)) {
          const metrics = this.getBaseFontMetrics(baseFontName.name);
          glyphsWidths = this.buildCharCodeToWidth(metrics.widths, properties);
          defaultWidth = metrics.defaultWidth;
        }
      }
    }

    let isMonospace = true;
    let firstWidth = defaultWidth;

    for (const glyph in glyphsWidths) {
      const glyphWidth = glyphsWidths[glyph];

      if (!glyphWidth) {
        continue;
      }

      if (!firstWidth) {
        firstWidth = glyphWidth;
        continue;
      }

      if (firstWidth !== glyphWidth) {
        isMonospace = false;
        break;
      }
    }

    if (isMonospace) {
      properties.flags |= _fonts_utils.FontFlags.FixedPitch;
    }

    properties.defaultWidth = defaultWidth;
    properties.widths = glyphsWidths;
    properties.defaultVMetrics = defaultVMetrics;
    properties.vmetrics = glyphsVMetrics;
  }

  isSerifFont(baseFontName) {
    const fontNameWoStyle = baseFontName.split("-")[0];
    return fontNameWoStyle in (0, _standard_fonts.getSerifFonts)() || fontNameWoStyle.search(/serif/gi) !== -1;
  }

  getBaseFontMetrics(name) {
    let defaultWidth = 0;
    let widths = Object.create(null);
    let monospace = false;
    const stdFontMap = (0, _standard_fonts.getStdFontMap)();
    let lookupName = stdFontMap[name] || name;
    const Metrics = (0, _metrics.getMetrics)();

    if (!(lookupName in Metrics)) {
      if (this.isSerifFont(name)) {
        lookupName = "Times-Roman";
      } else {
        lookupName = "Helvetica";
      }
    }

    const glyphWidths = Metrics[lookupName];

    if ((0, _util.isNum)(glyphWidths)) {
      defaultWidth = glyphWidths;
      monospace = true;
    } else {
      widths = glyphWidths();
    }

    return {
      defaultWidth,
      monospace,
      widths
    };
  }

  buildCharCodeToWidth(widthsByGlyphName, properties) {
    const widths = Object.create(null);
    const differences = properties.differences;
    const encoding = properties.defaultEncoding;

    for (let charCode = 0; charCode < 256; charCode++) {
      if (charCode in differences && widthsByGlyphName[differences[charCode]]) {
        widths[charCode] = widthsByGlyphName[differences[charCode]];
        continue;
      }

      if (charCode in encoding && widthsByGlyphName[encoding[charCode]]) {
        widths[charCode] = widthsByGlyphName[encoding[charCode]];
        continue;
      }
    }

    return widths;
  }

  preEvaluateFont(dict) {
    const baseDict = dict;
    let type = dict.get("Subtype");

    if (!(0, _primitives.isName)(type)) {
      throw new _util.FormatError("invalid font Subtype");
    }

    let composite = false;
    let hash, toUnicode;

    if (type.name === "Type0") {
      const df = dict.get("DescendantFonts");

      if (!df) {
        throw new _util.FormatError("Descendant fonts are not specified");
      }

      dict = Array.isArray(df) ? this.xref.fetchIfRef(df[0]) : df;

      if (!(dict instanceof _primitives.Dict)) {
        throw new _util.FormatError("Descendant font is not a dictionary.");
      }

      type = dict.get("Subtype");

      if (!(0, _primitives.isName)(type)) {
        throw new _util.FormatError("invalid font Subtype");
      }

      composite = true;
    }

    const firstChar = dict.get("FirstChar") || 0,
          lastChar = dict.get("LastChar") || (composite ? 0xffff : 0xff);
    const descriptor = dict.get("FontDescriptor");

    if (descriptor) {
      hash = new _murmurhash.MurmurHash3_64();
      const encoding = baseDict.getRaw("Encoding");

      if ((0, _primitives.isName)(encoding)) {
        hash.update(encoding.name);
      } else if ((0, _primitives.isRef)(encoding)) {
        hash.update(encoding.toString());
      } else if ((0, _primitives.isDict)(encoding)) {
        for (const entry of encoding.getRawValues()) {
          if ((0, _primitives.isName)(entry)) {
            hash.update(entry.name);
          } else if ((0, _primitives.isRef)(entry)) {
            hash.update(entry.toString());
          } else if (Array.isArray(entry)) {
            const diffLength = entry.length,
                  diffBuf = new Array(diffLength);

            for (let j = 0; j < diffLength; j++) {
              const diffEntry = entry[j];

              if ((0, _primitives.isName)(diffEntry)) {
                diffBuf[j] = diffEntry.name;
              } else if ((0, _util.isNum)(diffEntry) || (0, _primitives.isRef)(diffEntry)) {
                diffBuf[j] = diffEntry.toString();
              }
            }

            hash.update(diffBuf.join());
          }
        }
      }

      hash.update(`${firstChar}-${lastChar}`);
      toUnicode = dict.get("ToUnicode") || baseDict.get("ToUnicode");

      if ((0, _primitives.isStream)(toUnicode)) {
        const stream = toUnicode.str || toUnicode;
        const uint8array = stream.buffer ? new Uint8Array(stream.buffer.buffer, 0, stream.bufferLength) : new Uint8Array(stream.bytes.buffer, stream.start, stream.end - stream.start);
        hash.update(uint8array);
      } else if ((0, _primitives.isName)(toUnicode)) {
        hash.update(toUnicode.name);
      }

      const widths = dict.get("Widths") || baseDict.get("Widths");

      if (Array.isArray(widths)) {
        const widthsBuf = [];

        for (const entry of widths) {
          if ((0, _util.isNum)(entry) || (0, _primitives.isRef)(entry)) {
            widthsBuf.push(entry.toString());
          }
        }

        hash.update(widthsBuf.join());
      }

      if (composite) {
        hash.update("compositeFont");
        const compositeWidths = dict.get("W") || baseDict.get("W");

        if (Array.isArray(compositeWidths)) {
          const widthsBuf = [];

          for (const entry of compositeWidths) {
            if ((0, _util.isNum)(entry) || (0, _primitives.isRef)(entry)) {
              widthsBuf.push(entry.toString());
            } else if (Array.isArray(entry)) {
              const subWidthsBuf = [];

              for (const element of entry) {
                if ((0, _util.isNum)(element) || (0, _primitives.isRef)(element)) {
                  subWidthsBuf.push(element.toString());
                }
              }

              widthsBuf.push(`[${subWidthsBuf.join()}]`);
            }
          }

          hash.update(widthsBuf.join());
        }

        const cidToGidMap = dict.getRaw("CIDToGIDMap") || baseDict.getRaw("CIDToGIDMap");

        if (cidToGidMap instanceof _primitives.Name) {
          hash.update(cidToGidMap.name);
        } else if (cidToGidMap instanceof _primitives.Ref) {
          hash.update(cidToGidMap.toString());
        } else if (cidToGidMap instanceof _base_stream.BaseStream) {
          hash.update(cidToGidMap.peekBytes());
        }
      }
    }

    return {
      descriptor,
      dict,
      baseDict,
      composite,
      type: type.name,
      firstChar,
      lastChar,
      toUnicode,
      hash: hash ? hash.hexdigest() : ""
    };
  }

  async translateFont({
    descriptor,
    dict,
    baseDict,
    composite,
    type,
    firstChar,
    lastChar,
    toUnicode,
    cssFontInfo
  }) {
    const isType3Font = type === "Type3";
    let properties;

    if (!descriptor) {
      if (isType3Font) {
        descriptor = new _primitives.Dict(null);
        descriptor.set("FontName", _primitives.Name.get(type));
        descriptor.set("FontBBox", dict.getArray("FontBBox") || [0, 0, 0, 0]);
      } else {
        let baseFontName = dict.get("BaseFont");

        if (!(0, _primitives.isName)(baseFontName)) {
          throw new _util.FormatError("Base font is not specified");
        }

        baseFontName = baseFontName.name.replace(/[,_]/g, "-");
        const metrics = this.getBaseFontMetrics(baseFontName);
        const fontNameWoStyle = baseFontName.split("-")[0];
        const flags = (this.isSerifFont(fontNameWoStyle) ? _fonts_utils.FontFlags.Serif : 0) | (metrics.monospace ? _fonts_utils.FontFlags.FixedPitch : 0) | ((0, _standard_fonts.getSymbolsFonts)()[fontNameWoStyle] ? _fonts_utils.FontFlags.Symbolic : _fonts_utils.FontFlags.Nonsymbolic);
        properties = {
          type,
          name: baseFontName,
          loadedName: baseDict.loadedName,
          widths: metrics.widths,
          defaultWidth: metrics.defaultWidth,
          isSimulatedFlags: true,
          flags,
          firstChar,
          lastChar,
          toUnicode,
          xHeight: 0,
          capHeight: 0,
          italicAngle: 0,
          isType3Font
        };
        const widths = dict.get("Widths");
        const standardFontName = (0, _standard_fonts.getStandardFontName)(baseFontName);
        let file = null;

        if (standardFontName) {
          properties.isStandardFont = true;
          file = await this.fetchStandardFontData(standardFontName);
          properties.isInternalFont = !!file;
        }

        return this.extractDataStructures(dict, dict, properties).then(newProperties => {
          if (widths) {
            const glyphWidths = [];
            let j = firstChar;

            for (let i = 0, ii = widths.length; i < ii; i++) {
              glyphWidths[j++] = this.xref.fetchIfRef(widths[i]);
            }

            newProperties.widths = glyphWidths;
          } else {
            newProperties.widths = this.buildCharCodeToWidth(metrics.widths, newProperties);
          }

          return new _fonts.Font(baseFontName, file, newProperties);
        });
      }
    }

    let fontName = descriptor.get("FontName");
    let baseFont = dict.get("BaseFont");

    if ((0, _util.isString)(fontName)) {
      fontName = _primitives.Name.get(fontName);
    }

    if ((0, _util.isString)(baseFont)) {
      baseFont = _primitives.Name.get(baseFont);
    }

    if (!isType3Font) {
      const fontNameStr = fontName && fontName.name;
      const baseFontStr = baseFont && baseFont.name;

      if (fontNameStr !== baseFontStr) {
        (0, _util.info)(`The FontDescriptor's FontName is "${fontNameStr}" but ` + `should be the same as the Font's BaseFont "${baseFontStr}".`);

        if (fontNameStr && baseFontStr && baseFontStr.startsWith(fontNameStr)) {
          fontName = baseFont;
        }
      }
    }

    fontName = fontName || baseFont;

    if (!(0, _primitives.isName)(fontName)) {
      throw new _util.FormatError("invalid font name");
    }

    let fontFile, subtype, length1, length2, length3;

    try {
      fontFile = descriptor.get("FontFile", "FontFile2", "FontFile3");
    } catch (ex) {
      if (!this.options.ignoreErrors) {
        throw ex;
      }

      (0, _util.warn)(`translateFont - fetching "${fontName.name}" font file: "${ex}".`);
      fontFile = new _stream.NullStream();
    }

    let isStandardFont = false;
    let isInternalFont = false;
    let glyphScaleFactors = null;

    if (fontFile) {
      if (fontFile.dict) {
        const subtypeEntry = fontFile.dict.get("Subtype");

        if (subtypeEntry instanceof _primitives.Name) {
          subtype = subtypeEntry.name;
        }

        length1 = fontFile.dict.get("Length1");
        length2 = fontFile.dict.get("Length2");
        length3 = fontFile.dict.get("Length3");
      }
    } else if (cssFontInfo) {
      const standardFontName = (0, _xfa_fonts.getXfaFontName)(fontName.name);

      if (standardFontName) {
        cssFontInfo.fontFamily = `${cssFontInfo.fontFamily}-PdfJS-XFA`;
        cssFontInfo.metrics = standardFontName.metrics || null;
        glyphScaleFactors = standardFontName.factors || null;
        fontFile = await this.fetchStandardFontData(standardFontName.name);
        isInternalFont = !!fontFile;
        baseDict = dict = (0, _xfa_fonts.getXfaFontDict)(fontName.name);
        composite = true;
      }
    } else if (!isType3Font) {
      const standardFontName = (0, _standard_fonts.getStandardFontName)(fontName.name);

      if (standardFontName) {
        isStandardFont = true;
        fontFile = await this.fetchStandardFontData(standardFontName);
        isInternalFont = !!fontFile;
      }
    }

    properties = {
      type,
      name: fontName.name,
      subtype,
      file: fontFile,
      length1,
      length2,
      length3,
      isStandardFont,
      isInternalFont,
      loadedName: baseDict.loadedName,
      composite,
      fixedPitch: false,
      fontMatrix: dict.getArray("FontMatrix") || _util.FONT_IDENTITY_MATRIX,
      firstChar,
      lastChar,
      toUnicode,
      bbox: descriptor.getArray("FontBBox") || dict.getArray("FontBBox"),
      ascent: descriptor.get("Ascent"),
      descent: descriptor.get("Descent"),
      xHeight: descriptor.get("XHeight") || 0,
      capHeight: descriptor.get("CapHeight") || 0,
      flags: descriptor.get("Flags"),
      italicAngle: descriptor.get("ItalicAngle") || 0,
      isType3Font,
      cssFontInfo,
      scaleFactors: glyphScaleFactors
    };

    if (composite) {
      const cidEncoding = baseDict.get("Encoding");

      if ((0, _primitives.isName)(cidEncoding)) {
        properties.cidEncoding = cidEncoding.name;
      }

      const cMap = await _cmap.CMapFactory.create({
        encoding: cidEncoding,
        fetchBuiltInCMap: this._fetchBuiltInCMapBound,
        useCMap: null
      });
      properties.cMap = cMap;
      properties.vertical = properties.cMap.vertical;
    }

    return this.extractDataStructures(dict, baseDict, properties).then(newProperties => {
      this.extractWidths(dict, descriptor, newProperties);
      return new _fonts.Font(fontName.name, fontFile, newProperties);
    });
  }

  static buildFontPaths(font, glyphs, handler, evaluatorOptions) {
    function buildPath(fontChar) {
      const glyphName = `${font.loadedName}_path_${fontChar}`;

      try {
        if (font.renderer.hasBuiltPath(fontChar)) {
          return;
        }

        handler.send("commonobj", [glyphName, "FontPath", font.renderer.getPathJs(fontChar)]);
      } catch (reason) {
        if (evaluatorOptions.ignoreErrors) {
          handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorFontBuildPath
          });
          (0, _util.warn)(`buildFontPaths - ignoring ${glyphName} glyph: "${reason}".`);
          return;
        }

        throw reason;
      }
    }

    for (const glyph of glyphs) {
      buildPath(glyph.fontChar);
      const accent = glyph.accent;

      if (accent && accent.fontChar) {
        buildPath(accent.fontChar);
      }
    }
  }

  static get fallbackFontDict() {
    const dict = new _primitives.Dict();
    dict.set("BaseFont", _primitives.Name.get("PDFJS-FallbackFont"));
    dict.set("Type", _primitives.Name.get("FallbackType"));
    dict.set("Subtype", _primitives.Name.get("FallbackType"));
    dict.set("Encoding", _primitives.Name.get("WinAnsiEncoding"));
    return (0, _util.shadow)(this, "fallbackFontDict", dict);
  }

}

exports.PartialEvaluator = PartialEvaluator;

class TranslatedFont {
  constructor({
    loadedName,
    font,
    dict,
    evaluatorOptions
  }) {
    this.loadedName = loadedName;
    this.font = font;
    this.dict = dict;
    this._evaluatorOptions = evaluatorOptions || DefaultPartialEvaluatorOptions;
    this.type3Loaded = null;
    this.type3Dependencies = font.isType3Font ? new Set() : null;
    this.sent = false;
  }

  send(handler) {
    if (this.sent) {
      return;
    }

    this.sent = true;
    handler.send("commonobj", [this.loadedName, "Font", this.font.exportData(this._evaluatorOptions.fontExtraProperties)]);
  }

  fallback(handler) {
    if (!this.font.data) {
      return;
    }

    this.font.disableFontFace = true;
    PartialEvaluator.buildFontPaths(this.font, this.font.glyphCacheValues, handler, this._evaluatorOptions);
  }

  loadType3Data(evaluator, resources, task) {
    if (this.type3Loaded) {
      return this.type3Loaded;
    }

    if (!this.font.isType3Font) {
      throw new Error("Must be a Type3 font.");
    }

    const type3Evaluator = evaluator.clone({
      ignoreErrors: false
    });
    type3Evaluator.parsingType3Font = true;
    const translatedFont = this.font,
          type3Dependencies = this.type3Dependencies;
    let loadCharProcsPromise = Promise.resolve();
    const charProcs = this.dict.get("CharProcs");
    const fontResources = this.dict.get("Resources") || resources;
    const charProcOperatorList = Object.create(null);
    const isEmptyBBox = !translatedFont.bbox || (0, _util.isArrayEqual)(translatedFont.bbox, [0, 0, 0, 0]);

    for (const key of charProcs.getKeys()) {
      loadCharProcsPromise = loadCharProcsPromise.then(() => {
        const glyphStream = charProcs.get(key);
        const operatorList = new _operator_list.OperatorList();
        return type3Evaluator.getOperatorList({
          stream: glyphStream,
          task,
          resources: fontResources,
          operatorList
        }).then(() => {
          if (operatorList.fnArray[0] === _util.OPS.setCharWidthAndBounds) {
            this._removeType3ColorOperators(operatorList, isEmptyBBox);
          }

          charProcOperatorList[key] = operatorList.getIR();

          for (const dependency of operatorList.dependencies) {
            type3Dependencies.add(dependency);
          }
        }).catch(function (reason) {
          (0, _util.warn)(`Type3 font resource "${key}" is not available.`);
          const dummyOperatorList = new _operator_list.OperatorList();
          charProcOperatorList[key] = dummyOperatorList.getIR();
        });
      });
    }

    this.type3Loaded = loadCharProcsPromise.then(() => {
      translatedFont.charProcOperatorList = charProcOperatorList;

      if (this._bbox) {
        translatedFont.isCharBBox = true;
        translatedFont.bbox = this._bbox;
      }
    });
    return this.type3Loaded;
  }

  _removeType3ColorOperators(operatorList, isEmptyBBox = false) {
    if (isEmptyBBox) {
      if (!this._bbox) {
        this._bbox = [Infinity, Infinity, -Infinity, -Infinity];
      }

      const charBBox = _util.Util.normalizeRect(operatorList.argsArray[0].slice(2));

      this._bbox[0] = Math.min(this._bbox[0], charBBox[0]);
      this._bbox[1] = Math.min(this._bbox[1], charBBox[1]);
      this._bbox[2] = Math.max(this._bbox[2], charBBox[2]);
      this._bbox[3] = Math.max(this._bbox[3], charBBox[3]);
    }

    let i = 1,
        ii = operatorList.length;

    while (i < ii) {
      switch (operatorList.fnArray[i]) {
        case _util.OPS.setStrokeColorSpace:
        case _util.OPS.setFillColorSpace:
        case _util.OPS.setStrokeColor:
        case _util.OPS.setStrokeColorN:
        case _util.OPS.setFillColor:
        case _util.OPS.setFillColorN:
        case _util.OPS.setStrokeGray:
        case _util.OPS.setFillGray:
        case _util.OPS.setStrokeRGBColor:
        case _util.OPS.setFillRGBColor:
        case _util.OPS.setStrokeCMYKColor:
        case _util.OPS.setFillCMYKColor:
        case _util.OPS.shadingFill:
        case _util.OPS.setRenderingIntent:
          operatorList.fnArray.splice(i, 1);
          operatorList.argsArray.splice(i, 1);
          ii--;
          continue;

        case _util.OPS.setGState:
          const [gStateObj] = operatorList.argsArray[i];
          let j = 0,
              jj = gStateObj.length;

          while (j < jj) {
            const [gStateKey] = gStateObj[j];

            switch (gStateKey) {
              case "TR":
              case "TR2":
              case "HT":
              case "BG":
              case "BG2":
              case "UCR":
              case "UCR2":
                gStateObj.splice(j, 1);
                jj--;
                continue;
            }

            j++;
          }

          break;
      }

      i++;
    }
  }

}

class StateManager {
  constructor(initialState = new EvalState()) {
    this.state = initialState;
    this.stateStack = [];
  }

  save() {
    const old = this.state;
    this.stateStack.push(this.state);
    this.state = old.clone();
  }

  restore() {
    const prev = this.stateStack.pop();

    if (prev) {
      this.state = prev;
    }
  }

  transform(args) {
    this.state.ctm = _util.Util.transform(this.state.ctm, args);
  }

}

class TextState {
  constructor() {
    this.ctm = new Float32Array(_util.IDENTITY_MATRIX);
    this.fontName = null;
    this.fontSize = 0;
    this.font = null;
    this.fontMatrix = _util.FONT_IDENTITY_MATRIX;
    this.textMatrix = _util.IDENTITY_MATRIX.slice();
    this.textLineMatrix = _util.IDENTITY_MATRIX.slice();
    this.charSpacing = 0;
    this.wordSpacing = 0;
    this.leading = 0;
    this.textHScale = 1;
    this.textRise = 0;
  }

  setTextMatrix(a, b, c, d, e, f) {
    const m = this.textMatrix;
    m[0] = a;
    m[1] = b;
    m[2] = c;
    m[3] = d;
    m[4] = e;
    m[5] = f;
  }

  setTextLineMatrix(a, b, c, d, e, f) {
    const m = this.textLineMatrix;
    m[0] = a;
    m[1] = b;
    m[2] = c;
    m[3] = d;
    m[4] = e;
    m[5] = f;
  }

  translateTextMatrix(x, y) {
    const m = this.textMatrix;
    m[4] = m[0] * x + m[2] * y + m[4];
    m[5] = m[1] * x + m[3] * y + m[5];
  }

  translateTextLineMatrix(x, y) {
    const m = this.textLineMatrix;
    m[4] = m[0] * x + m[2] * y + m[4];
    m[5] = m[1] * x + m[3] * y + m[5];
  }

  carriageReturn() {
    this.translateTextLineMatrix(0, -this.leading);
    this.textMatrix = this.textLineMatrix.slice();
  }

  clone() {
    const clone = Object.create(this);
    clone.textMatrix = this.textMatrix.slice();
    clone.textLineMatrix = this.textLineMatrix.slice();
    clone.fontMatrix = this.fontMatrix.slice();
    return clone;
  }

}

class EvalState {
  constructor() {
    this.ctm = new Float32Array(_util.IDENTITY_MATRIX);
    this.font = null;
    this.textRenderingMode = _util.TextRenderingMode.FILL;
    this.fillColorSpace = _colorspace.ColorSpace.singletons.gray;
    this.strokeColorSpace = _colorspace.ColorSpace.singletons.gray;
  }

  clone() {
    return Object.create(this);
  }

}

class EvaluatorPreprocessor {
  static get opMap() {
    const getOPMap = (0, _core_utils.getLookupTableFactory)(function (t) {
      t.w = {
        id: _util.OPS.setLineWidth,
        numArgs: 1,
        variableArgs: false
      };
      t.J = {
        id: _util.OPS.setLineCap,
        numArgs: 1,
        variableArgs: false
      };
      t.j = {
        id: _util.OPS.setLineJoin,
        numArgs: 1,
        variableArgs: false
      };
      t.M = {
        id: _util.OPS.setMiterLimit,
        numArgs: 1,
        variableArgs: false
      };
      t.d = {
        id: _util.OPS.setDash,
        numArgs: 2,
        variableArgs: false
      };
      t.ri = {
        id: _util.OPS.setRenderingIntent,
        numArgs: 1,
        variableArgs: false
      };
      t.i = {
        id: _util.OPS.setFlatness,
        numArgs: 1,
        variableArgs: false
      };
      t.gs = {
        id: _util.OPS.setGState,
        numArgs: 1,
        variableArgs: false
      };
      t.q = {
        id: _util.OPS.save,
        numArgs: 0,
        variableArgs: false
      };
      t.Q = {
        id: _util.OPS.restore,
        numArgs: 0,
        variableArgs: false
      };
      t.cm = {
        id: _util.OPS.transform,
        numArgs: 6,
        variableArgs: false
      };
      t.m = {
        id: _util.OPS.moveTo,
        numArgs: 2,
        variableArgs: false
      };
      t.l = {
        id: _util.OPS.lineTo,
        numArgs: 2,
        variableArgs: false
      };
      t.c = {
        id: _util.OPS.curveTo,
        numArgs: 6,
        variableArgs: false
      };
      t.v = {
        id: _util.OPS.curveTo2,
        numArgs: 4,
        variableArgs: false
      };
      t.y = {
        id: _util.OPS.curveTo3,
        numArgs: 4,
        variableArgs: false
      };
      t.h = {
        id: _util.OPS.closePath,
        numArgs: 0,
        variableArgs: false
      };
      t.re = {
        id: _util.OPS.rectangle,
        numArgs: 4,
        variableArgs: false
      };
      t.S = {
        id: _util.OPS.stroke,
        numArgs: 0,
        variableArgs: false
      };
      t.s = {
        id: _util.OPS.closeStroke,
        numArgs: 0,
        variableArgs: false
      };
      t.f = {
        id: _util.OPS.fill,
        numArgs: 0,
        variableArgs: false
      };
      t.F = {
        id: _util.OPS.fill,
        numArgs: 0,
        variableArgs: false
      };
      t["f*"] = {
        id: _util.OPS.eoFill,
        numArgs: 0,
        variableArgs: false
      };
      t.B = {
        id: _util.OPS.fillStroke,
        numArgs: 0,
        variableArgs: false
      };
      t["B*"] = {
        id: _util.OPS.eoFillStroke,
        numArgs: 0,
        variableArgs: false
      };
      t.b = {
        id: _util.OPS.closeFillStroke,
        numArgs: 0,
        variableArgs: false
      };
      t["b*"] = {
        id: _util.OPS.closeEOFillStroke,
        numArgs: 0,
        variableArgs: false
      };
      t.n = {
        id: _util.OPS.endPath,
        numArgs: 0,
        variableArgs: false
      };
      t.W = {
        id: _util.OPS.clip,
        numArgs: 0,
        variableArgs: false
      };
      t["W*"] = {
        id: _util.OPS.eoClip,
        numArgs: 0,
        variableArgs: false
      };
      t.BT = {
        id: _util.OPS.beginText,
        numArgs: 0,
        variableArgs: false
      };
      t.ET = {
        id: _util.OPS.endText,
        numArgs: 0,
        variableArgs: false
      };
      t.Tc = {
        id: _util.OPS.setCharSpacing,
        numArgs: 1,
        variableArgs: false
      };
      t.Tw = {
        id: _util.OPS.setWordSpacing,
        numArgs: 1,
        variableArgs: false
      };
      t.Tz = {
        id: _util.OPS.setHScale,
        numArgs: 1,
        variableArgs: false
      };
      t.TL = {
        id: _util.OPS.setLeading,
        numArgs: 1,
        variableArgs: false
      };
      t.Tf = {
        id: _util.OPS.setFont,
        numArgs: 2,
        variableArgs: false
      };
      t.Tr = {
        id: _util.OPS.setTextRenderingMode,
        numArgs: 1,
        variableArgs: false
      };
      t.Ts = {
        id: _util.OPS.setTextRise,
        numArgs: 1,
        variableArgs: false
      };
      t.Td = {
        id: _util.OPS.moveText,
        numArgs: 2,
        variableArgs: false
      };
      t.TD = {
        id: _util.OPS.setLeadingMoveText,
        numArgs: 2,
        variableArgs: false
      };
      t.Tm = {
        id: _util.OPS.setTextMatrix,
        numArgs: 6,
        variableArgs: false
      };
      t["T*"] = {
        id: _util.OPS.nextLine,
        numArgs: 0,
        variableArgs: false
      };
      t.Tj = {
        id: _util.OPS.showText,
        numArgs: 1,
        variableArgs: false
      };
      t.TJ = {
        id: _util.OPS.showSpacedText,
        numArgs: 1,
        variableArgs: false
      };
      t["'"] = {
        id: _util.OPS.nextLineShowText,
        numArgs: 1,
        variableArgs: false
      };
      t['"'] = {
        id: _util.OPS.nextLineSetSpacingShowText,
        numArgs: 3,
        variableArgs: false
      };
      t.d0 = {
        id: _util.OPS.setCharWidth,
        numArgs: 2,
        variableArgs: false
      };
      t.d1 = {
        id: _util.OPS.setCharWidthAndBounds,
        numArgs: 6,
        variableArgs: false
      };
      t.CS = {
        id: _util.OPS.setStrokeColorSpace,
        numArgs: 1,
        variableArgs: false
      };
      t.cs = {
        id: _util.OPS.setFillColorSpace,
        numArgs: 1,
        variableArgs: false
      };
      t.SC = {
        id: _util.OPS.setStrokeColor,
        numArgs: 4,
        variableArgs: true
      };
      t.SCN = {
        id: _util.OPS.setStrokeColorN,
        numArgs: 33,
        variableArgs: true
      };
      t.sc = {
        id: _util.OPS.setFillColor,
        numArgs: 4,
        variableArgs: true
      };
      t.scn = {
        id: _util.OPS.setFillColorN,
        numArgs: 33,
        variableArgs: true
      };
      t.G = {
        id: _util.OPS.setStrokeGray,
        numArgs: 1,
        variableArgs: false
      };
      t.g = {
        id: _util.OPS.setFillGray,
        numArgs: 1,
        variableArgs: false
      };
      t.RG = {
        id: _util.OPS.setStrokeRGBColor,
        numArgs: 3,
        variableArgs: false
      };
      t.rg = {
        id: _util.OPS.setFillRGBColor,
        numArgs: 3,
        variableArgs: false
      };
      t.K = {
        id: _util.OPS.setStrokeCMYKColor,
        numArgs: 4,
        variableArgs: false
      };
      t.k = {
        id: _util.OPS.setFillCMYKColor,
        numArgs: 4,
        variableArgs: false
      };
      t.sh = {
        id: _util.OPS.shadingFill,
        numArgs: 1,
        variableArgs: false
      };
      t.BI = {
        id: _util.OPS.beginInlineImage,
        numArgs: 0,
        variableArgs: false
      };
      t.ID = {
        id: _util.OPS.beginImageData,
        numArgs: 0,
        variableArgs: false
      };
      t.EI = {
        id: _util.OPS.endInlineImage,
        numArgs: 1,
        variableArgs: false
      };
      t.Do = {
        id: _util.OPS.paintXObject,
        numArgs: 1,
        variableArgs: false
      };
      t.MP = {
        id: _util.OPS.markPoint,
        numArgs: 1,
        variableArgs: false
      };
      t.DP = {
        id: _util.OPS.markPointProps,
        numArgs: 2,
        variableArgs: false
      };
      t.BMC = {
        id: _util.OPS.beginMarkedContent,
        numArgs: 1,
        variableArgs: false
      };
      t.BDC = {
        id: _util.OPS.beginMarkedContentProps,
        numArgs: 2,
        variableArgs: false
      };
      t.EMC = {
        id: _util.OPS.endMarkedContent,
        numArgs: 0,
        variableArgs: false
      };
      t.BX = {
        id: _util.OPS.beginCompat,
        numArgs: 0,
        variableArgs: false
      };
      t.EX = {
        id: _util.OPS.endCompat,
        numArgs: 0,
        variableArgs: false
      };
      t.BM = null;
      t.BD = null;
      t.true = null;
      t.fa = null;
      t.fal = null;
      t.fals = null;
      t.false = null;
      t.nu = null;
      t.nul = null;
      t.null = null;
    });
    return (0, _util.shadow)(this, "opMap", getOPMap());
  }

  static get MAX_INVALID_PATH_OPS() {
    return (0, _util.shadow)(this, "MAX_INVALID_PATH_OPS", 20);
  }

  constructor(stream, xref, stateManager = new StateManager()) {
    this.parser = new _parser.Parser({
      lexer: new _parser.Lexer(stream, EvaluatorPreprocessor.opMap),
      xref
    });
    this.stateManager = stateManager;
    this.nonProcessedArgs = [];
    this._numInvalidPathOPS = 0;
  }

  get savedStatesDepth() {
    return this.stateManager.stateStack.length;
  }

  read(operation) {
    let args = operation.args;

    while (true) {
      const obj = this.parser.getObj();

      if (obj instanceof _primitives.Cmd) {
        const cmd = obj.cmd;
        const opSpec = EvaluatorPreprocessor.opMap[cmd];

        if (!opSpec) {
          (0, _util.warn)(`Unknown command "${cmd}".`);
          continue;
        }

        const fn = opSpec.id;
        const numArgs = opSpec.numArgs;
        let argsLength = args !== null ? args.length : 0;

        if (!opSpec.variableArgs) {
          if (argsLength !== numArgs) {
            const nonProcessedArgs = this.nonProcessedArgs;

            while (argsLength > numArgs) {
              nonProcessedArgs.push(args.shift());
              argsLength--;
            }

            while (argsLength < numArgs && nonProcessedArgs.length !== 0) {
              if (args === null) {
                args = [];
              }

              args.unshift(nonProcessedArgs.pop());
              argsLength++;
            }
          }

          if (argsLength < numArgs) {
            const partialMsg = `command ${cmd}: expected ${numArgs} args, ` + `but received ${argsLength} args.`;

            if (fn >= _util.OPS.moveTo && fn <= _util.OPS.endPath && ++this._numInvalidPathOPS > EvaluatorPreprocessor.MAX_INVALID_PATH_OPS) {
              throw new _util.FormatError(`Invalid ${partialMsg}`);
            }

            (0, _util.warn)(`Skipping ${partialMsg}`);

            if (args !== null) {
              args.length = 0;
            }

            continue;
          }
        } else if (argsLength > numArgs) {
          (0, _util.info)(`Command ${cmd}: expected [0, ${numArgs}] args, ` + `but received ${argsLength} args.`);
        }

        this.preprocessCommand(fn, args);
        operation.fn = fn;
        operation.args = args;
        return true;
      }

      if (obj === _primitives.EOF) {
        return false;
      }

      if (obj !== null) {
        if (args === null) {
          args = [];
        }

        args.push(obj);

        if (args.length > 33) {
          throw new _util.FormatError("Too many arguments");
        }
      }
    }
  }

  preprocessCommand(fn, args) {
    switch (fn | 0) {
      case _util.OPS.save:
        this.stateManager.save();
        break;

      case _util.OPS.restore:
        this.stateManager.restore();
        break;

      case _util.OPS.transform:
        this.stateManager.transform(args);
        break;
    }
  }

}

exports.EvaluatorPreprocessor = EvaluatorPreprocessor;

/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.IdentityCMap = exports.CMapFactory = exports.CMap = void 0;

var _util = __w_pdfjs_require__(2);

var _primitives = __w_pdfjs_require__(5);

var _parser = __w_pdfjs_require__(27);

var _core_utils = __w_pdfjs_require__(9);

var _stream = __w_pdfjs_require__(10);

const BUILT_IN_CMAPS = ["Adobe-GB1-UCS2", "Adobe-CNS1-UCS2", "Adobe-Japan1-UCS2", "Adobe-Korea1-UCS2", "78-EUC-H", "78-EUC-V", "78-H", "78-RKSJ-H", "78-RKSJ-V", "78-V", "78ms-RKSJ-H", "78ms-RKSJ-V", "83pv-RKSJ-H", "90ms-RKSJ-H", "90ms-RKSJ-V", "90msp-RKSJ-H", "90msp-RKSJ-V", "90pv-RKSJ-H", "90pv-RKSJ-V", "Add-H", "Add-RKSJ-H", "Add-RKSJ-V", "Add-V", "Adobe-CNS1-0", "Adobe-CNS1-1", "Adobe-CNS1-2", "Adobe-CNS1-3", "Adobe-CNS1-4", "Adobe-CNS1-5", "Adobe-CNS1-6", "Adobe-GB1-0", "Adobe-GB1-1", "Adobe-GB1-2", "Adobe-GB1-3", "Adobe-GB1-4", "Adobe-GB1-5", "Adobe-Japan1-0", "Adobe-Japan1-1", "Adobe-Japan1-2", "Adobe-Japan1-3", "Adobe-Japan1-4", "Adobe-Japan1-5", "Adobe-Japan1-6", "Adobe-Korea1-0", "Adobe-Korea1-1", "Adobe-Korea1-2", "B5-H", "B5-V", "B5pc-H", "B5pc-V", "CNS-EUC-H", "CNS-EUC-V", "CNS1-H", "CNS1-V", "CNS2-H", "CNS2-V", "ETHK-B5-H", "ETHK-B5-V", "ETen-B5-H", "ETen-B5-V", "ETenms-B5-H", "ETenms-B5-V", "EUC-H", "EUC-V", "Ext-H", "Ext-RKSJ-H", "Ext-RKSJ-V", "Ext-V", "GB-EUC-H", "GB-EUC-V", "GB-H", "GB-V", "GBK-EUC-H", "GBK-EUC-V", "GBK2K-H", "GBK2K-V", "GBKp-EUC-H", "GBKp-EUC-V", "GBT-EUC-H", "GBT-EUC-V", "GBT-H", "GBT-V", "GBTpc-EUC-H", "GBTpc-EUC-V", "GBpc-EUC-H", "GBpc-EUC-V", "H", "HKdla-B5-H", "HKdla-B5-V", "HKdlb-B5-H", "HKdlb-B5-V", "HKgccs-B5-H", "HKgccs-B5-V", "HKm314-B5-H", "HKm314-B5-V", "HKm471-B5-H", "HKm471-B5-V", "HKscs-B5-H", "HKscs-B5-V", "Hankaku", "Hiragana", "KSC-EUC-H", "KSC-EUC-V", "KSC-H", "KSC-Johab-H", "KSC-Johab-V", "KSC-V", "KSCms-UHC-H", "KSCms-UHC-HW-H", "KSCms-UHC-HW-V", "KSCms-UHC-V", "KSCpc-EUC-H", "KSCpc-EUC-V", "Katakana", "NWP-H", "NWP-V", "RKSJ-H", "RKSJ-V", "Roman", "UniCNS-UCS2-H", "UniCNS-UCS2-V", "UniCNS-UTF16-H", "UniCNS-UTF16-V", "UniCNS-UTF32-H", "UniCNS-UTF32-V", "UniCNS-UTF8-H", "UniCNS-UTF8-V", "UniGB-UCS2-H", "UniGB-UCS2-V", "UniGB-UTF16-H", "UniGB-UTF16-V", "UniGB-UTF32-H", "UniGB-UTF32-V", "UniGB-UTF8-H", "UniGB-UTF8-V", "UniJIS-UCS2-H", "UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-V", "UniJIS-UCS2-V", "UniJIS-UTF16-H", "UniJIS-UTF16-V", "UniJIS-UTF32-H", "UniJIS-UTF32-V", "UniJIS-UTF8-H", "UniJIS-UTF8-V", "UniJIS2004-UTF16-H", "UniJIS2004-UTF16-V", "UniJIS2004-UTF32-H", "UniJIS2004-UTF32-V", "UniJIS2004-UTF8-H", "UniJIS2004-UTF8-V", "UniJISPro-UCS2-HW-V", "UniJISPro-UCS2-V", "UniJISPro-UTF8-V", "UniJISX0213-UTF32-H", "UniJISX0213-UTF32-V", "UniJISX02132004-UTF32-H", "UniJISX02132004-UTF32-V", "UniKS-UCS2-H", "UniKS-UCS2-V", "UniKS-UTF16-H", "UniKS-UTF16-V", "UniKS-UTF32-H", "UniKS-UTF32-V", "UniKS-UTF8-H", "UniKS-UTF8-V", "V", "WP-Symbol"];
const MAX_MAP_RANGE = 2 ** 24 - 1;

class CMap {
  constructor(builtInCMap = false) {
    this.codespaceRanges = [[], [], [], []];
    this.numCodespaceRanges = 0;
    this._map = [];
    this.name = "";
    this.vertical = false;
    this.useCMap = null;
    this.builtInCMap = builtInCMap;
  }

  addCodespaceRange(n, low, high) {
    this.codespaceRanges[n - 1].push(low, high);
    this.numCodespaceRanges++;
  }

  mapCidRange(low, high, dstLow) {
    if (high - low > MAX_MAP_RANGE) {
      throw new Error("mapCidRange - ignoring data above MAX_MAP_RANGE.");
    }

    while (low <= high) {
      this._map[low++] = dstLow++;
    }
  }

  mapBfRange(low, high, dstLow) {
    if (high - low > MAX_MAP_RANGE) {
      throw new Error("mapBfRange - ignoring data above MAX_MAP_RANGE.");
    }

    const lastByte = dstLow.length - 1;

    while (low <= high) {
      this._map[low++] = dstLow;
      const nextCharCode = dstLow.charCodeAt(lastByte) + 1;

      if (nextCharCode > 0xff) {
        dstLow = dstLow.substring(0, lastByte - 1) + String.fromCharCode(dstLow.charCodeAt(lastByte - 1) + 1) + "\x00";
        continue;
      }

      dstLow = dstLow.substring(0, lastByte) + String.fromCharCode(nextCharCode);
    }
  }

  mapBfRangeToArray(low, high, array) {
    if (high - low > MAX_MAP_RANGE) {
      throw new Error("mapBfRangeToArray - ignoring data above MAX_MAP_RANGE.");
    }

    const ii = array.length;
    let i = 0;

    while (low <= high && i < ii) {
      this._map[low] = array[i++];
      ++low;
    }
  }

  mapOne(src, dst) {
    this._map[src] = dst;
  }

  lookup(code) {
    return this._map[code];
  }

  contains(code) {
    return this._map[code] !== undefined;
  }

  forEach(callback) {
    const map = this._map;
    const length = map.length;

    if (length <= 0x10000) {
      for (let i = 0; i < length; i++) {
        if (map[i] !== undefined) {
          callback(i, map[i]);
        }
      }
    } else {
      for (const i in map) {
        callback(i, map[i]);
      }
    }
  }

  charCodeOf(value) {
    const map = this._map;

    if (map.length <= 0x10000) {
      return map.indexOf(value);
    }

    for (const charCode in map) {
      if (map[charCode] === value) {
        return charCode | 0;
      }
    }

    return -1;
  }

  getMap() {
    return this._map;
  }

  readCharCode(str, offset, out) {
    let c = 0;
    const codespaceRanges = this.codespaceRanges;

    for (let n = 0, nn = codespaceRanges.length; n < nn; n++) {
      c = (c << 8 | str.charCodeAt(offset + n)) >>> 0;
      const codespaceRange = codespaceRanges[n];

      for (let k = 0, kk = codespaceRange.length; k < kk;) {
        const low = codespaceRange[k++];
        const high = codespaceRange[k++];

        if (c >= low && c <= high) {
          out.charcode = c;
          out.length = n + 1;
          return;
        }
      }
    }

    out.charcode = 0;
    out.length = 1;
  }

  getCharCodeLength(charCode) {
    const codespaceRanges = this.codespaceRanges;

    for (let n = 0, nn = codespaceRanges.length; n < nn; n++) {
      const codespaceRange = codespaceRanges[n];

      for (let k = 0, kk = codespaceRange.length; k < kk;) {
        const low = codespaceRange[k++];
        const high = codespaceRange[k++];

        if (charCode >= low && charCode <= high) {
          return n + 1;
        }
      }
    }

    return 1;
  }

  get length() {
    return this._map.length;
  }

  get isIdentityCMap() {
    if (!(this.name === "Identity-H" || this.name === "Identity-V")) {
      return false;
    }

    if (this._map.length !== 0x10000) {
      return false;
    }

    for (let i = 0; i < 0x10000; i++) {
      if (this._map[i] !== i) {
        return false;
      }
    }

    return true;
  }

}

exports.CMap = CMap;

class IdentityCMap extends CMap {
  constructor(vertical, n) {
    super();
    this.vertical = vertical;
    this.addCodespaceRange(n, 0, 0xffff);
  }

  mapCidRange(low, high, dstLow) {
    (0, _util.unreachable)("should not call mapCidRange");
  }

  mapBfRange(low, high, dstLow) {
    (0, _util.unreachable)("should not call mapBfRange");
  }

  mapBfRangeToArray(low, high, array) {
    (0, _util.unreachable)("should not call mapBfRangeToArray");
  }

  mapOne(src, dst) {
    (0, _util.unreachable)("should not call mapCidOne");
  }

  lookup(code) {
    return Number.isInteger(code) && code <= 0xffff ? code : undefined;
  }

  contains(code) {
    return Number.isInteger(code) && code <= 0xffff;
  }

  forEach(callback) {
    for (let i = 0; i <= 0xffff; i++) {
      callback(i, i);
    }
  }

  charCodeOf(value) {
    return Number.isInteger(value) && value <= 0xffff ? value : -1;
  }

  getMap() {
    const map = new Array(0x10000);

    for (let i = 0; i <= 0xffff; i++) {
      map[i] = i;
    }

    return map;
  }

  get length() {
    return 0x10000;
  }

  get isIdentityCMap() {
    (0, _util.unreachable)("should not access .isIdentityCMap");
  }

}

exports.IdentityCMap = IdentityCMap;

const BinaryCMapReader = function BinaryCMapReaderClosure() {
  function hexToInt(a, size) {
    let n = 0;

    for (let i = 0; i <= size; i++) {
      n = n << 8 | a[i];
    }

    return n >>> 0;
  }

  function hexToStr(a, size) {
    if (size === 1) {
      return String.fromCharCode(a[0], a[1]);
    }

    if (size === 3) {
      return String.fromCharCode(a[0], a[1], a[2], a[3]);
    }

    return String.fromCharCode.apply(null, a.subarray(0, size + 1));
  }

  function addHex(a, b, size) {
    let c = 0;

    for (let i = size; i >= 0; i--) {
      c += a[i] + b[i];
      a[i] = c & 255;
      c >>= 8;
    }
  }

  function incHex(a, size) {
    let c = 1;

    for (let i = size; i >= 0 && c > 0; i--) {
      c += a[i];
      a[i] = c & 255;
      c >>= 8;
    }
  }

  const MAX_NUM_SIZE = 16;
  const MAX_ENCODED_NUM_SIZE = 19;

  class BinaryCMapStream {
    constructor(data) {
      this.buffer = data;
      this.pos = 0;
      this.end = data.length;
      this.tmpBuf = new Uint8Array(MAX_ENCODED_NUM_SIZE);
    }

    readByte() {
      if (this.pos >= this.end) {
        return -1;
      }

      return this.buffer[this.pos++];
    }

    readNumber() {
      let n = 0;
      let last;

      do {
        const b = this.readByte();

        if (b < 0) {
          throw new _util.FormatError("unexpected EOF in bcmap");
        }

        last = !(b & 0x80);
        n = n << 7 | b & 0x7f;
      } while (!last);

      return n;
    }

    readSigned() {
      const n = this.readNumber();
      return n & 1 ? ~(n >>> 1) : n >>> 1;
    }

    readHex(num, size) {
      num.set(this.buffer.subarray(this.pos, this.pos + size + 1));
      this.pos += size + 1;
    }

    readHexNumber(num, size) {
      let last;
      const stack = this.tmpBuf;
      let sp = 0;

      do {
        const b = this.readByte();

        if (b < 0) {
          throw new _util.FormatError("unexpected EOF in bcmap");
        }

        last = !(b & 0x80);
        stack[sp++] = b & 0x7f;
      } while (!last);

      let i = size,
          buffer = 0,
          bufferSize = 0;

      while (i >= 0) {
        while (bufferSize < 8 && stack.length > 0) {
          buffer |= stack[--sp] << bufferSize;
          bufferSize += 7;
        }

        num[i] = buffer & 255;
        i--;
        buffer >>= 8;
        bufferSize -= 8;
      }
    }

    readHexSigned(num, size) {
      this.readHexNumber(num, size);
      const sign = num[size] & 1 ? 255 : 0;
      let c = 0;

      for (let i = 0; i <= size; i++) {
        c = (c & 1) << 8 | num[i];
        num[i] = c >> 1 ^ sign;
      }
    }

    readString() {
      const len = this.readNumber();
      let s = "";

      for (let i = 0; i < len; i++) {
        s += String.fromCharCode(this.readNumber());
      }

      return s;
    }

  }

  class BinaryCMapReader {
    async process(data, cMap, extend) {
      const stream = new BinaryCMapStream(data);
      const header = stream.readByte();
      cMap.vertical = !!(header & 1);
      let useCMap = null;
      const start = new Uint8Array(MAX_NUM_SIZE);
      const end = new Uint8Array(MAX_NUM_SIZE);
      const char = new Uint8Array(MAX_NUM_SIZE);
      const charCode = new Uint8Array(MAX_NUM_SIZE);
      const tmp = new Uint8Array(MAX_NUM_SIZE);
      let code;
      let b;

      while ((b = stream.readByte()) >= 0) {
        const type = b >> 5;

        if (type === 7) {
          switch (b & 0x1f) {
            case 0:
              stream.readString();
              break;

            case 1:
              useCMap = stream.readString();
              break;
          }

          continue;
        }

        const sequence = !!(b & 0x10);
        const dataSize = b & 15;

        if (dataSize + 1 > MAX_NUM_SIZE) {
          throw new Error("BinaryCMapReader.process: Invalid dataSize.");
        }

        const ucs2DataSize = 1;
        const subitemsCount = stream.readNumber();

        switch (type) {
          case 0:
            stream.readHex(start, dataSize);
            stream.readHexNumber(end, dataSize);
            addHex(end, start, dataSize);
            cMap.addCodespaceRange(dataSize + 1, hexToInt(start, dataSize), hexToInt(end, dataSize));

            for (let i = 1; i < subitemsCount; i++) {
              incHex(end, dataSize);
              stream.readHexNumber(start, dataSize);
              addHex(start, end, dataSize);
              stream.readHexNumber(end, dataSize);
              addHex(end, start, dataSize);
              cMap.addCodespaceRange(dataSize + 1, hexToInt(start, dataSize), hexToInt(end, dataSize));
            }

            break;

          case 1:
            stream.readHex(start, dataSize);
            stream.readHexNumber(end, dataSize);
            addHex(end, start, dataSize);
            stream.readNumber();

            for (let i = 1; i < subitemsCount; i++) {
              incHex(end, dataSize);
              stream.readHexNumber(start, dataSize);
              addHex(start, end, dataSize);
              stream.readHexNumber(end, dataSize);
              addHex(end, start, dataSize);
              stream.readNumber();
            }

            break;

          case 2:
            stream.readHex(char, dataSize);
            code = stream.readNumber();
            cMap.mapOne(hexToInt(char, dataSize), code);

            for (let i = 1; i < subitemsCount; i++) {
              incHex(char, dataSize);

              if (!sequence) {
                stream.readHexNumber(tmp, dataSize);
                addHex(char, tmp, dataSize);
              }

              code = stream.readSigned() + (code + 1);
              cMap.mapOne(hexToInt(char, dataSize), code);
            }

            break;

          case 3:
            stream.readHex(start, dataSize);
            stream.readHexNumber(end, dataSize);
            addHex(end, start, dataSize);
            code = stream.readNumber();
            cMap.mapCidRange(hexToInt(start, dataSize), hexToInt(end, dataSize), code);

            for (let i = 1; i < subitemsCount; i++) {
              incHex(end, dataSize);

              if (!sequence) {
                stream.readHexNumber(start, dataSize);
                addHex(start, end, dataSize);
              } else {
                start.set(end);
              }

              stream.readHexNumber(end, dataSize);
              addHex(end, start, dataSize);
              code = stream.readNumber();
              cMap.mapCidRange(hexToInt(start, dataSize), hexToInt(end, dataSize), code);
            }

            break;

          case 4:
            stream.readHex(char, ucs2DataSize);
            stream.readHex(charCode, dataSize);
            cMap.mapOne(hexToInt(char, ucs2DataSize), hexToStr(charCode, dataSize));

            for (let i = 1; i < subitemsCount; i++) {
              incHex(char, ucs2DataSize);

              if (!sequence) {
                stream.readHexNumber(tmp, ucs2DataSize);
                addHex(char, tmp, ucs2DataSize);
              }

              incHex(charCode, dataSize);
              stream.readHexSigned(tmp, dataSize);
              addHex(charCode, tmp, dataSize);
              cMap.mapOne(hexToInt(char, ucs2DataSize), hexToStr(charCode, dataSize));
            }

            break;

          case 5:
            stream.readHex(start, ucs2DataSize);
            stream.readHexNumber(end, ucs2DataSize);
            addHex(end, start, ucs2DataSize);
            stream.readHex(charCode, dataSize);
            cMap.mapBfRange(hexToInt(start, ucs2DataSize), hexToInt(end, ucs2DataSize), hexToStr(charCode, dataSize));

            for (let i = 1; i < subitemsCount; i++) {
              incHex(end, ucs2DataSize);

              if (!sequence) {
                stream.readHexNumber(start, ucs2DataSize);
                addHex(start, end, ucs2DataSize);
              } else {
                start.set(end);
              }

              stream.readHexNumber(end, ucs2DataSize);
              addHex(end, start, ucs2DataSize);
              stream.readHex(charCode, dataSize);
              cMap.mapBfRange(hexToInt(start, ucs2DataSize), hexToInt(end, ucs2DataSize), hexToStr(charCode, dataSize));
            }

            break;

          default:
            throw new Error(`BinaryCMapReader.process - unknown type: ${type}`);
        }
      }

      if (useCMap) {
        return extend(useCMap);
      }

      return cMap;
    }

  }

  return BinaryCMapReader;
}();

const CMapFactory = function CMapFactoryClosure() {
  function strToInt(str) {
    let a = 0;

    for (let i = 0; i < str.length; i++) {
      a = a << 8 | str.charCodeAt(i);
    }

    return a >>> 0;
  }

  function expectString(obj) {
    if (!(0, _util.isString)(obj)) {
      throw new _util.FormatError("Malformed CMap: expected string.");
    }
  }

  function expectInt(obj) {
    if (!Number.isInteger(obj)) {
      throw new _util.FormatError("Malformed CMap: expected int.");
    }
  }

  function parseBfChar(cMap, lexer) {
    while (true) {
      let obj = lexer.getObj();

      if (obj === _primitives.EOF) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endbfchar")) {
        return;
      }

      expectString(obj);
      const src = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      const dst = obj;
      cMap.mapOne(src, dst);
    }
  }

  function parseBfRange(cMap, lexer) {
    while (true) {
      let obj = lexer.getObj();

      if (obj === _primitives.EOF) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endbfrange")) {
        return;
      }

      expectString(obj);
      const low = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      const high = strToInt(obj);
      obj = lexer.getObj();

      if (Number.isInteger(obj) || (0, _util.isString)(obj)) {
        const dstLow = Number.isInteger(obj) ? String.fromCharCode(obj) : obj;
        cMap.mapBfRange(low, high, dstLow);
      } else if ((0, _primitives.isCmd)(obj, "[")) {
        obj = lexer.getObj();
        const array = [];

        while (!(0, _primitives.isCmd)(obj, "]") && obj !== _primitives.EOF) {
          array.push(obj);
          obj = lexer.getObj();
        }

        cMap.mapBfRangeToArray(low, high, array);
      } else {
        break;
      }
    }

    throw new _util.FormatError("Invalid bf range.");
  }

  function parseCidChar(cMap, lexer) {
    while (true) {
      let obj = lexer.getObj();

      if (obj === _primitives.EOF) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endcidchar")) {
        return;
      }

      expectString(obj);
      const src = strToInt(obj);
      obj = lexer.getObj();
      expectInt(obj);
      const dst = obj;
      cMap.mapOne(src, dst);
    }
  }

  function parseCidRange(cMap, lexer) {
    while (true) {
      let obj = lexer.getObj();

      if (obj === _primitives.EOF) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endcidrange")) {
        return;
      }

      expectString(obj);
      const low = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      const high = strToInt(obj);
      obj = lexer.getObj();
      expectInt(obj);
      const dstLow = obj;
      cMap.mapCidRange(low, high, dstLow);
    }
  }

  function parseCodespaceRange(cMap, lexer) {
    while (true) {
      let obj = lexer.getObj();

      if (obj === _primitives.EOF) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endcodespacerange")) {
        return;
      }

      if (!(0, _util.isString)(obj)) {
        break;
      }

      const low = strToInt(obj);
      obj = lexer.getObj();

      if (!(0, _util.isString)(obj)) {
        break;
      }

      const high = strToInt(obj);
      cMap.addCodespaceRange(obj.length, low, high);
    }

    throw new _util.FormatError("Invalid codespace range.");
  }

  function parseWMode(cMap, lexer) {
    const obj = lexer.getObj();

    if (Number.isInteger(obj)) {
      cMap.vertical = !!obj;
    }
  }

  function parseCMapName(cMap, lexer) {
    const obj = lexer.getObj();

    if ((0, _primitives.isName)(obj) && (0, _util.isString)(obj.name)) {
      cMap.name = obj.name;
    }
  }

  async function parseCMap(cMap, lexer, fetchBuiltInCMap, useCMap) {
    let previous, embeddedUseCMap;

    objLoop: while (true) {
      try {
        const obj = lexer.getObj();

        if (obj === _primitives.EOF) {
          break;
        } else if ((0, _primitives.isName)(obj)) {
          if (obj.name === "WMode") {
            parseWMode(cMap, lexer);
          } else if (obj.name === "CMapName") {
            parseCMapName(cMap, lexer);
          }

          previous = obj;
        } else if ((0, _primitives.isCmd)(obj)) {
          switch (obj.cmd) {
            case "endcmap":
              break objLoop;

            case "usecmap":
              if ((0, _primitives.isName)(previous)) {
                embeddedUseCMap = previous.name;
              }

              break;

            case "begincodespacerange":
              parseCodespaceRange(cMap, lexer);
              break;

            case "beginbfchar":
              parseBfChar(cMap, lexer);
              break;

            case "begincidchar":
              parseCidChar(cMap, lexer);
              break;

            case "beginbfrange":
              parseBfRange(cMap, lexer);
              break;

            case "begincidrange":
              parseCidRange(cMap, lexer);
              break;
          }
        }
      } catch (ex) {
        if (ex instanceof _core_utils.MissingDataException) {
          throw ex;
        }

        (0, _util.warn)("Invalid cMap data: " + ex);
        continue;
      }
    }

    if (!useCMap && embeddedUseCMap) {
      useCMap = embeddedUseCMap;
    }

    if (useCMap) {
      return extendCMap(cMap, fetchBuiltInCMap, useCMap);
    }

    return cMap;
  }

  async function extendCMap(cMap, fetchBuiltInCMap, useCMap) {
    cMap.useCMap = await createBuiltInCMap(useCMap, fetchBuiltInCMap);

    if (cMap.numCodespaceRanges === 0) {
      const useCodespaceRanges = cMap.useCMap.codespaceRanges;

      for (let i = 0; i < useCodespaceRanges.length; i++) {
        cMap.codespaceRanges[i] = useCodespaceRanges[i].slice();
      }

      cMap.numCodespaceRanges = cMap.useCMap.numCodespaceRanges;
    }

    cMap.useCMap.forEach(function (key, value) {
      if (!cMap.contains(key)) {
        cMap.mapOne(key, cMap.useCMap.lookup(key));
      }
    });
    return cMap;
  }

  async function createBuiltInCMap(name, fetchBuiltInCMap) {
    if (name === "Identity-H") {
      return new IdentityCMap(false, 2);
    } else if (name === "Identity-V") {
      return new IdentityCMap(true, 2);
    }

    if (!BUILT_IN_CMAPS.includes(name)) {
      throw new Error("Unknown CMap name: " + name);
    }

    if (!fetchBuiltInCMap) {
      throw new Error("Built-in CMap parameters are not provided.");
    }

    const {
      cMapData,
      compressionType
    } = await fetchBuiltInCMap(name);
    const cMap = new CMap(true);

    if (compressionType === _util.CMapCompressionType.BINARY) {
      return new BinaryCMapReader().process(cMapData, cMap, useCMap => {
        return extendCMap(cMap, fetchBuiltInCMap, useCMap);
      });
    }

    if (compressionType === _util.CMapCompressionType.NONE) {
      const lexer = new _parser.Lexer(new _stream.Stream(cMapData));
      return parseCMap(cMap, lexer, fetchBuiltInCMap, null);
    }

    throw new Error("TODO: Only BINARY/NONE CMap compression is currently supported.");
  }

  return {
    async create(params) {
      const encoding = params.encoding;
      const fetchBuiltInCMap = params.fetchBuiltInCMap;
      const useCMap = params.useCMap;

      if ((0, _primitives.isName)(encoding)) {
        return createBuiltInCMap(encoding.name, fetchBuiltInCMap);
      } else if ((0, _primitives.isStream)(encoding)) {
        const parsedCMap = await parseCMap(new CMap(), new _parser.Lexer(encoding), fetchBuiltInCMap, useCMap);

        if (parsedCMap.isIdentityCMap) {
          return createBuiltInCMap(parsedCMap.name, fetchBuiltInCMap);
        }

        return parsedCMap;
      }

      throw new Error("Encoding required.");
    }

  };
}();

exports.CMapFactory = CMapFactory;

/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Parser = exports.Linearization = exports.Lexer = void 0;

var _util = __w_pdfjs_require__(2);

var _primitives = __w_pdfjs_require__(5);

var _core_utils = __w_pdfjs_require__(9);

var _ascii_85_stream = __w_pdfjs_require__(28);

var _ascii_hex_stream = __w_pdfjs_require__(30);

var _ccitt_stream = __w_pdfjs_require__(31);

var _flate_stream = __w_pdfjs_require__(33);

var _jbig2_stream = __w_pdfjs_require__(34);

var _jpeg_stream = __w_pdfjs_require__(37);

var _jpx_stream = __w_pdfjs_require__(39);

var _lzw_stream = __w_pdfjs_require__(41);

var _stream = __w_pdfjs_require__(10);

var _predictor_stream = __w_pdfjs_require__(42);

var _run_length_stream = __w_pdfjs_require__(43);

const MAX_LENGTH_TO_CACHE = 1000;
const MAX_ADLER32_LENGTH = 5552;

function computeAdler32(bytes) {
  const bytesLength = bytes.length;
  let a = 1,
      b = 0;

  for (let i = 0; i < bytesLength; ++i) {
    a += bytes[i] & 0xff;
    b += a;
  }

  return b % 65521 << 16 | a % 65521;
}

class Parser {
  constructor({
    lexer,
    xref,
    allowStreams = false,
    recoveryMode = false
  }) {
    this.lexer = lexer;
    this.xref = xref;
    this.allowStreams = allowStreams;
    this.recoveryMode = recoveryMode;
    this.imageCache = Object.create(null);
    this.refill();
  }

  refill() {
    this.buf1 = this.lexer.getObj();
    this.buf2 = this.lexer.getObj();
  }

  shift() {
    if (this.buf2 instanceof _primitives.Cmd && this.buf2.cmd === "ID") {
      this.buf1 = this.buf2;
      this.buf2 = null;
    } else {
      this.buf1 = this.buf2;
      this.buf2 = this.lexer.getObj();
    }
  }

  tryShift() {
    try {
      this.shift();
      return true;
    } catch (e) {
      if (e instanceof _core_utils.MissingDataException) {
        throw e;
      }

      return false;
    }
  }

  getObj(cipherTransform = null) {
    const buf1 = this.buf1;
    this.shift();

    if (buf1 instanceof _primitives.Cmd) {
      switch (buf1.cmd) {
        case "BI":
          return this.makeInlineImage(cipherTransform);

        case "[":
          const array = [];

          while (!(0, _primitives.isCmd)(this.buf1, "]") && this.buf1 !== _primitives.EOF) {
            array.push(this.getObj(cipherTransform));
          }

          if (this.buf1 === _primitives.EOF) {
            if (this.recoveryMode) {
              return array;
            }

            throw new _core_utils.ParserEOFException("End of file inside array.");
          }

          this.shift();
          return array;

        case "<<":
          const dict = new _primitives.Dict(this.xref);

          while (!(0, _primitives.isCmd)(this.buf1, ">>") && this.buf1 !== _primitives.EOF) {
            if (!(0, _primitives.isName)(this.buf1)) {
              (0, _util.info)("Malformed dictionary: key must be a name object");
              this.shift();
              continue;
            }

            const key = this.buf1.name;
            this.shift();

            if (this.buf1 === _primitives.EOF) {
              break;
            }

            dict.set(key, this.getObj(cipherTransform));
          }

          if (this.buf1 === _primitives.EOF) {
            if (this.recoveryMode) {
              return dict;
            }

            throw new _core_utils.ParserEOFException("End of file inside dictionary.");
          }

          if ((0, _primitives.isCmd)(this.buf2, "stream")) {
            return this.allowStreams ? this.makeStream(dict, cipherTransform) : dict;
          }

          this.shift();
          return dict;

        default:
          return buf1;
      }
    }

    if (Number.isInteger(buf1)) {
      if (Number.isInteger(this.buf1) && (0, _primitives.isCmd)(this.buf2, "R")) {
        const ref = _primitives.Ref.get(buf1, this.buf1);

        this.shift();
        this.shift();
        return ref;
      }

      return buf1;
    }

    if (typeof buf1 === "string") {
      if (cipherTransform) {
        return cipherTransform.decryptString(buf1);
      }

      return buf1;
    }

    return buf1;
  }

  findDefaultInlineStreamEnd(stream) {
    const E = 0x45,
          I = 0x49,
          SPACE = 0x20,
          LF = 0xa,
          CR = 0xd,
          NUL = 0x0;
    const lexer = this.lexer,
          startPos = stream.pos,
          n = 10;
    let state = 0,
        ch,
        maybeEIPos;

    while ((ch = stream.getByte()) !== -1) {
      if (state === 0) {
        state = ch === E ? 1 : 0;
      } else if (state === 1) {
        state = ch === I ? 2 : 0;
      } else {
        (0, _util.assert)(state === 2, "findDefaultInlineStreamEnd - invalid state.");

        if (ch === SPACE || ch === LF || ch === CR) {
          maybeEIPos = stream.pos;
          const followingBytes = stream.peekBytes(n);

          for (let i = 0, ii = followingBytes.length; i < ii; i++) {
            ch = followingBytes[i];

            if (ch === NUL && followingBytes[i + 1] !== NUL) {
              continue;
            }

            if (ch !== LF && ch !== CR && (ch < SPACE || ch > 0x7f)) {
              state = 0;
              break;
            }
          }

          if (state !== 2) {
            continue;
          }

          if (lexer.knownCommands) {
            const nextObj = lexer.peekObj();

            if (nextObj instanceof _primitives.Cmd && !lexer.knownCommands[nextObj.cmd]) {
              state = 0;
            }
          } else {
            (0, _util.warn)("findDefaultInlineStreamEnd - `lexer.knownCommands` is undefined.");
          }

          if (state === 2) {
            break;
          }
        } else {
          state = 0;
        }
      }
    }

    if (ch === -1) {
      (0, _util.warn)("findDefaultInlineStreamEnd: " + "Reached the end of the stream without finding a valid EI marker");

      if (maybeEIPos) {
        (0, _util.warn)('... trying to recover by using the last "EI" occurrence.');
        stream.skip(-(stream.pos - maybeEIPos));
      }
    }

    let endOffset = 4;
    stream.skip(-endOffset);
    ch = stream.peekByte();
    stream.skip(endOffset);

    if (!(0, _core_utils.isWhiteSpace)(ch)) {
      endOffset--;
    }

    return stream.pos - endOffset - startPos;
  }

  findDCTDecodeInlineStreamEnd(stream) {
    const startPos = stream.pos;
    let foundEOI = false,
        b,
        markerLength;

    while ((b = stream.getByte()) !== -1) {
      if (b !== 0xff) {
        continue;
      }

      switch (stream.getByte()) {
        case 0x00:
          break;

        case 0xff:
          stream.skip(-1);
          break;

        case 0xd9:
          foundEOI = true;
          break;

        case 0xc0:
        case 0xc1:
        case 0xc2:
        case 0xc3:
        case 0xc5:
        case 0xc6:
        case 0xc7:
        case 0xc9:
        case 0xca:
        case 0xcb:
        case 0xcd:
        case 0xce:
        case 0xcf:
        case 0xc4:
        case 0xcc:
        case 0xda:
        case 0xdb:
        case 0xdc:
        case 0xdd:
        case 0xde:
        case 0xdf:
        case 0xe0:
        case 0xe1:
        case 0xe2:
        case 0xe3:
        case 0xe4:
        case 0xe5:
        case 0xe6:
        case 0xe7:
        case 0xe8:
        case 0xe9:
        case 0xea:
        case 0xeb:
        case 0xec:
        case 0xed:
        case 0xee:
        case 0xef:
        case 0xfe:
          markerLength = stream.getUint16();

          if (markerLength > 2) {
            stream.skip(markerLength - 2);
          } else {
            stream.skip(-2);
          }

          break;
      }

      if (foundEOI) {
        break;
      }
    }

    const length = stream.pos - startPos;

    if (b === -1) {
      (0, _util.warn)("Inline DCTDecode image stream: " + "EOI marker not found, searching for /EI/ instead.");
      stream.skip(-length);
      return this.findDefaultInlineStreamEnd(stream);
    }

    this.inlineStreamSkipEI(stream);
    return length;
  }

  findASCII85DecodeInlineStreamEnd(stream) {
    const TILDE = 0x7e,
          GT = 0x3e;
    const startPos = stream.pos;
    let ch;

    while ((ch = stream.getByte()) !== -1) {
      if (ch === TILDE) {
        const tildePos = stream.pos;
        ch = stream.peekByte();

        while ((0, _core_utils.isWhiteSpace)(ch)) {
          stream.skip();
          ch = stream.peekByte();
        }

        if (ch === GT) {
          stream.skip();
          break;
        }

        if (stream.pos > tildePos) {
          const maybeEI = stream.peekBytes(2);

          if (maybeEI[0] === 0x45 && maybeEI[1] === 0x49) {
            break;
          }
        }
      }
    }

    const length = stream.pos - startPos;

    if (ch === -1) {
      (0, _util.warn)("Inline ASCII85Decode image stream: " + "EOD marker not found, searching for /EI/ instead.");
      stream.skip(-length);
      return this.findDefaultInlineStreamEnd(stream);
    }

    this.inlineStreamSkipEI(stream);
    return length;
  }

  findASCIIHexDecodeInlineStreamEnd(stream) {
    const GT = 0x3e;
    const startPos = stream.pos;
    let ch;

    while ((ch = stream.getByte()) !== -1) {
      if (ch === GT) {
        break;
      }
    }

    const length = stream.pos - startPos;

    if (ch === -1) {
      (0, _util.warn)("Inline ASCIIHexDecode image stream: " + "EOD marker not found, searching for /EI/ instead.");
      stream.skip(-length);
      return this.findDefaultInlineStreamEnd(stream);
    }

    this.inlineStreamSkipEI(stream);
    return length;
  }

  inlineStreamSkipEI(stream) {
    const E = 0x45,
          I = 0x49;
    let state = 0,
        ch;

    while ((ch = stream.getByte()) !== -1) {
      if (state === 0) {
        state = ch === E ? 1 : 0;
      } else if (state === 1) {
        state = ch === I ? 2 : 0;
      } else if (state === 2) {
        break;
      }
    }
  }

  makeInlineImage(cipherTransform) {
    const lexer = this.lexer;
    const stream = lexer.stream;
    const dict = new _primitives.Dict(this.xref);
    let dictLength;

    while (!(0, _primitives.isCmd)(this.buf1, "ID") && this.buf1 !== _primitives.EOF) {
      if (!(0, _primitives.isName)(this.buf1)) {
        throw new _util.FormatError("Dictionary key must be a name object");
      }

      const key = this.buf1.name;
      this.shift();

      if (this.buf1 === _primitives.EOF) {
        break;
      }

      dict.set(key, this.getObj(cipherTransform));
    }

    if (lexer.beginInlineImagePos !== -1) {
      dictLength = stream.pos - lexer.beginInlineImagePos;
    }

    const filter = dict.get("F", "Filter");
    let filterName;

    if ((0, _primitives.isName)(filter)) {
      filterName = filter.name;
    } else if (Array.isArray(filter)) {
      const filterZero = this.xref.fetchIfRef(filter[0]);

      if ((0, _primitives.isName)(filterZero)) {
        filterName = filterZero.name;
      }
    }

    const startPos = stream.pos;
    let length;

    switch (filterName) {
      case "DCT":
      case "DCTDecode":
        length = this.findDCTDecodeInlineStreamEnd(stream);
        break;

      case "A85":
      case "ASCII85Decode":
        length = this.findASCII85DecodeInlineStreamEnd(stream);
        break;

      case "AHx":
      case "ASCIIHexDecode":
        length = this.findASCIIHexDecodeInlineStreamEnd(stream);
        break;

      default:
        length = this.findDefaultInlineStreamEnd(stream);
    }

    let imageStream = stream.makeSubStream(startPos, length, dict);
    let cacheKey;

    if (length < MAX_LENGTH_TO_CACHE && dictLength < MAX_ADLER32_LENGTH) {
      const imageBytes = imageStream.getBytes();
      imageStream.reset();
      const initialStreamPos = stream.pos;
      stream.pos = lexer.beginInlineImagePos;
      const dictBytes = stream.getBytes(dictLength);
      stream.pos = initialStreamPos;
      cacheKey = computeAdler32(imageBytes) + "_" + computeAdler32(dictBytes);
      const cacheEntry = this.imageCache[cacheKey];

      if (cacheEntry !== undefined) {
        this.buf2 = _primitives.Cmd.get("EI");
        this.shift();
        cacheEntry.reset();
        return cacheEntry;
      }
    }

    if (cipherTransform) {
      imageStream = cipherTransform.createStream(imageStream, length);
    }

    imageStream = this.filter(imageStream, dict, length);
    imageStream.dict = dict;

    if (cacheKey !== undefined) {
      imageStream.cacheKey = `inline_${length}_${cacheKey}`;
      this.imageCache[cacheKey] = imageStream;
    }

    this.buf2 = _primitives.Cmd.get("EI");
    this.shift();
    return imageStream;
  }

  _findStreamLength(startPos, signature) {
    const {
      stream
    } = this.lexer;
    stream.pos = startPos;
    const SCAN_BLOCK_LENGTH = 2048;
    const signatureLength = signature.length;

    while (stream.pos < stream.end) {
      const scanBytes = stream.peekBytes(SCAN_BLOCK_LENGTH);
      const scanLength = scanBytes.length - signatureLength;

      if (scanLength <= 0) {
        break;
      }

      let pos = 0;

      while (pos < scanLength) {
        let j = 0;

        while (j < signatureLength && scanBytes[pos + j] === signature[j]) {
          j++;
        }

        if (j >= signatureLength) {
          stream.pos += pos;
          return stream.pos - startPos;
        }

        pos++;
      }

      stream.pos += scanLength;
    }

    return -1;
  }

  makeStream(dict, cipherTransform) {
    const lexer = this.lexer;
    let stream = lexer.stream;
    lexer.skipToNextLine();
    const startPos = stream.pos - 1;
    let length = dict.get("Length");

    if (!Number.isInteger(length)) {
      (0, _util.info)(`Bad length "${length && length.toString()}" in stream.`);
      length = 0;
    }

    stream.pos = startPos + length;
    lexer.nextChar();

    if (this.tryShift() && (0, _primitives.isCmd)(this.buf2, "endstream")) {
      this.shift();
    } else {
      const ENDSTREAM_SIGNATURE = new Uint8Array([0x65, 0x6e, 0x64, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d]);

      let actualLength = this._findStreamLength(startPos, ENDSTREAM_SIGNATURE);

      if (actualLength < 0) {
        const MAX_TRUNCATION = 1;

        for (let i = 1; i <= MAX_TRUNCATION; i++) {
          const end = ENDSTREAM_SIGNATURE.length - i;
          const TRUNCATED_SIGNATURE = ENDSTREAM_SIGNATURE.slice(0, end);

          const maybeLength = this._findStreamLength(startPos, TRUNCATED_SIGNATURE);

          if (maybeLength >= 0) {
            const lastByte = stream.peekBytes(end + 1)[end];

            if (!(0, _core_utils.isWhiteSpace)(lastByte)) {
              break;
            }

            (0, _util.info)(`Found "${(0, _util.bytesToString)(TRUNCATED_SIGNATURE)}" when ` + "searching for endstream command.");
            actualLength = maybeLength;
            break;
          }
        }

        if (actualLength < 0) {
          throw new _util.FormatError("Missing endstream command.");
        }
      }

      length = actualLength;
      lexer.nextChar();
      this.shift();
      this.shift();
    }

    this.shift();
    stream = stream.makeSubStream(startPos, length, dict);

    if (cipherTransform) {
      stream = cipherTransform.createStream(stream, length);
    }

    stream = this.filter(stream, dict, length);
    stream.dict = dict;
    return stream;
  }

  filter(stream, dict, length) {
    let filter = dict.get("F", "Filter");
    let params = dict.get("DP", "DecodeParms");

    if ((0, _primitives.isName)(filter)) {
      if (Array.isArray(params)) {
        (0, _util.warn)("/DecodeParms should not be an Array, when /Filter is a Name.");
      }

      return this.makeFilter(stream, filter.name, length, params);
    }

    let maybeLength = length;

    if (Array.isArray(filter)) {
      const filterArray = filter;
      const paramsArray = params;

      for (let i = 0, ii = filterArray.length; i < ii; ++i) {
        filter = this.xref.fetchIfRef(filterArray[i]);

        if (!(0, _primitives.isName)(filter)) {
          throw new _util.FormatError(`Bad filter name "${filter}"`);
        }

        params = null;

        if (Array.isArray(paramsArray) && i in paramsArray) {
          params = this.xref.fetchIfRef(paramsArray[i]);
        }

        stream = this.makeFilter(stream, filter.name, maybeLength, params);
        maybeLength = null;
      }
    }

    return stream;
  }

  makeFilter(stream, name, maybeLength, params) {
    if (maybeLength === 0) {
      (0, _util.warn)(`Empty "${name}" stream.`);
      return new _stream.NullStream();
    }

    const xrefStats = this.xref.stats;

    try {
      switch (name) {
        case "Fl":
        case "FlateDecode":
          xrefStats.addStreamType(_util.StreamType.FLATE);

          if (params) {
            return new _predictor_stream.PredictorStream(new _flate_stream.FlateStream(stream, maybeLength), maybeLength, params);
          }

          return new _flate_stream.FlateStream(stream, maybeLength);

        case "LZW":
        case "LZWDecode":
          xrefStats.addStreamType(_util.StreamType.LZW);
          let earlyChange = 1;

          if (params) {
            if (params.has("EarlyChange")) {
              earlyChange = params.get("EarlyChange");
            }

            return new _predictor_stream.PredictorStream(new _lzw_stream.LZWStream(stream, maybeLength, earlyChange), maybeLength, params);
          }

          return new _lzw_stream.LZWStream(stream, maybeLength, earlyChange);

        case "DCT":
        case "DCTDecode":
          xrefStats.addStreamType(_util.StreamType.DCT);
          return new _jpeg_stream.JpegStream(stream, maybeLength, params);

        case "JPX":
        case "JPXDecode":
          xrefStats.addStreamType(_util.StreamType.JPX);
          return new _jpx_stream.JpxStream(stream, maybeLength, params);

        case "A85":
        case "ASCII85Decode":
          xrefStats.addStreamType(_util.StreamType.A85);
          return new _ascii_85_stream.Ascii85Stream(stream, maybeLength);

        case "AHx":
        case "ASCIIHexDecode":
          xrefStats.addStreamType(_util.StreamType.AHX);
          return new _ascii_hex_stream.AsciiHexStream(stream, maybeLength);

        case "CCF":
        case "CCITTFaxDecode":
          xrefStats.addStreamType(_util.StreamType.CCF);
          return new _ccitt_stream.CCITTFaxStream(stream, maybeLength, params);

        case "RL":
        case "RunLengthDecode":
          xrefStats.addStreamType(_util.StreamType.RLX);
          return new _run_length_stream.RunLengthStream(stream, maybeLength);

        case "JBIG2Decode":
          xrefStats.addStreamType(_util.StreamType.JBIG);
          return new _jbig2_stream.Jbig2Stream(stream, maybeLength, params);
      }

      (0, _util.warn)(`Filter "${name}" is not supported.`);
      return stream;
    } catch (ex) {
      if (ex instanceof _core_utils.MissingDataException) {
        throw ex;
      }

      (0, _util.warn)(`Invalid stream: "${ex}"`);
      return new _stream.NullStream();
    }
  }

}

exports.Parser = Parser;
const specialChars = [1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

function toHexDigit(ch) {
  if (ch >= 0x30 && ch <= 0x39) {
    return ch & 0x0f;
  }

  if (ch >= 0x41 && ch <= 0x46 || ch >= 0x61 && ch <= 0x66) {
    return (ch & 0x0f) + 9;
  }

  return -1;
}

class Lexer {
  constructor(stream, knownCommands = null) {
    this.stream = stream;
    this.nextChar();
    this.strBuf = [];
    this.knownCommands = knownCommands;
    this._hexStringNumWarn = 0;
    this.beginInlineImagePos = -1;
  }

  nextChar() {
    return this.currentChar = this.stream.getByte();
  }

  peekChar() {
    return this.stream.peekByte();
  }

  getNumber() {
    let ch = this.currentChar;
    let eNotation = false;
    let divideBy = 0;
    let sign = 0;

    if (ch === 0x2d) {
      sign = -1;
      ch = this.nextChar();

      if (ch === 0x2d) {
        ch = this.nextChar();
      }
    } else if (ch === 0x2b) {
      sign = 1;
      ch = this.nextChar();
    }

    if (ch === 0x0a || ch === 0x0d) {
      do {
        ch = this.nextChar();
      } while (ch === 0x0a || ch === 0x0d);
    }

    if (ch === 0x2e) {
      divideBy = 10;
      ch = this.nextChar();
    }

    if (ch < 0x30 || ch > 0x39) {
      if (divideBy === 10 && sign === 0 && ((0, _core_utils.isWhiteSpace)(ch) || ch === -1)) {
        (0, _util.warn)("Lexer.getNumber - treating a single decimal point as zero.");
        return 0;
      }

      throw new _util.FormatError(`Invalid number: ${String.fromCharCode(ch)} (charCode ${ch})`);
    }

    sign = sign || 1;
    let baseValue = ch - 0x30;
    let powerValue = 0;
    let powerValueSign = 1;

    while ((ch = this.nextChar()) >= 0) {
      if (ch >= 0x30 && ch <= 0x39) {
        const currentDigit = ch - 0x30;

        if (eNotation) {
          powerValue = powerValue * 10 + currentDigit;
        } else {
          if (divideBy !== 0) {
            divideBy *= 10;
          }

          baseValue = baseValue * 10 + currentDigit;
        }
      } else if (ch === 0x2e) {
        if (divideBy === 0) {
          divideBy = 1;
        } else {
          break;
        }
      } else if (ch === 0x2d) {
        (0, _util.warn)("Badly formatted number: minus sign in the middle");
      } else if (ch === 0x45 || ch === 0x65) {
        ch = this.peekChar();

        if (ch === 0x2b || ch === 0x2d) {
          powerValueSign = ch === 0x2d ? -1 : 1;
          this.nextChar();
        } else if (ch < 0x30 || ch > 0x39) {
          break;
        }

        eNotation = true;
      } else {
        break;
      }
    }

    if (divideBy !== 0) {
      baseValue /= divideBy;
    }

    if (eNotation) {
      baseValue *= 10 ** (powerValueSign * powerValue);
    }

    return sign * baseValue;
  }

  getString() {
    let numParen = 1;
    let done = false;
    const strBuf = this.strBuf;
    strBuf.length = 0;
    let ch = this.nextChar();

    while (true) {
      let charBuffered = false;

      switch (ch | 0) {
        case -1:
          (0, _util.warn)("Unterminated string");
          done = true;
          break;

        case 0x28:
          ++numParen;
          strBuf.push("(");
          break;

        case 0x29:
          if (--numParen === 0) {
            this.nextChar();
            done = true;
          } else {
            strBuf.push(")");
          }

          break;

        case 0x5c:
          ch = this.nextChar();

          switch (ch) {
            case -1:
              (0, _util.warn)("Unterminated string");
              done = true;
              break;

            case 0x6e:
              strBuf.push("\n");
              break;

            case 0x72:
              strBuf.push("\r");
              break;

            case 0x74:
              strBuf.push("\t");
              break;

            case 0x62:
              strBuf.push("\b");
              break;

            case 0x66:
              strBuf.push("\f");
              break;

            case 0x5c:
            case 0x28:
            case 0x29:
              strBuf.push(String.fromCharCode(ch));
              break;

            case 0x30:
            case 0x31:
            case 0x32:
            case 0x33:
            case 0x34:
            case 0x35:
            case 0x36:
            case 0x37:
              let x = ch & 0x0f;
              ch = this.nextChar();
              charBuffered = true;

              if (ch >= 0x30 && ch <= 0x37) {
                x = (x << 3) + (ch & 0x0f);
                ch = this.nextChar();

                if (ch >= 0x30 && ch <= 0x37) {
                  charBuffered = false;
                  x = (x << 3) + (ch & 0x0f);
                }
              }

              strBuf.push(String.fromCharCode(x));
              break;

            case 0x0d:
              if (this.peekChar() === 0x0a) {
                this.nextChar();
              }

              break;

            case 0x0a:
              break;

            default:
              strBuf.push(String.fromCharCode(ch));
              break;
          }

          break;

        default:
          strBuf.push(String.fromCharCode(ch));
          break;
      }

      if (done) {
        break;
      }

      if (!charBuffered) {
        ch = this.nextChar();
      }
    }

    return strBuf.join("");
  }

  getName() {
    let ch, previousCh;
    const strBuf = this.strBuf;
    strBuf.length = 0;

    while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
      if (ch === 0x23) {
        ch = this.nextChar();

        if (specialChars[ch]) {
          (0, _util.warn)("Lexer_getName: " + "NUMBER SIGN (#) should be followed by a hexadecimal number.");
          strBuf.push("#");
          break;
        }

        const x = toHexDigit(ch);

        if (x !== -1) {
          previousCh = ch;
          ch = this.nextChar();
          const x2 = toHexDigit(ch);

          if (x2 === -1) {
            (0, _util.warn)(`Lexer_getName: Illegal digit (${String.fromCharCode(ch)}) ` + "in hexadecimal number.");
            strBuf.push("#", String.fromCharCode(previousCh));

            if (specialChars[ch]) {
              break;
            }

            strBuf.push(String.fromCharCode(ch));
            continue;
          }

          strBuf.push(String.fromCharCode(x << 4 | x2));
        } else {
          strBuf.push("#", String.fromCharCode(ch));
        }
      } else {
        strBuf.push(String.fromCharCode(ch));
      }
    }

    if (strBuf.length > 127) {
      (0, _util.warn)(`Name token is longer than allowed by the spec: ${strBuf.length}`);
    }

    return _primitives.Name.get(strBuf.join(""));
  }

  _hexStringWarn(ch) {
    const MAX_HEX_STRING_NUM_WARN = 5;

    if (this._hexStringNumWarn++ === MAX_HEX_STRING_NUM_WARN) {
      (0, _util.warn)("getHexString - ignoring additional invalid characters.");
      return;
    }

    if (this._hexStringNumWarn > MAX_HEX_STRING_NUM_WARN) {
      return;
    }

    (0, _util.warn)(`getHexString - ignoring invalid character: ${ch}`);
  }

  getHexString() {
    const strBuf = this.strBuf;
    strBuf.length = 0;
    let ch = this.currentChar;
    let isFirstHex = true;
    let firstDigit, secondDigit;
    this._hexStringNumWarn = 0;

    while (true) {
      if (ch < 0) {
        (0, _util.warn)("Unterminated hex string");
        break;
      } else if (ch === 0x3e) {
        this.nextChar();
        break;
      } else if (specialChars[ch] === 1) {
        ch = this.nextChar();
        continue;
      } else {
        if (isFirstHex) {
          firstDigit = toHexDigit(ch);

          if (firstDigit === -1) {
            this._hexStringWarn(ch);

            ch = this.nextChar();
            continue;
          }
        } else {
          secondDigit = toHexDigit(ch);

          if (secondDigit === -1) {
            this._hexStringWarn(ch);

            ch = this.nextChar();
            continue;
          }

          strBuf.push(String.fromCharCode(firstDigit << 4 | secondDigit));
        }

        isFirstHex = !isFirstHex;
        ch = this.nextChar();
      }
    }

    return strBuf.join("");
  }

  getObj() {
    let comment = false;
    let ch = this.currentChar;

    while (true) {
      if (ch < 0) {
        return _primitives.EOF;
      }

      if (comment) {
        if (ch === 0x0a || ch === 0x0d) {
          comment = false;
        }
      } else if (ch === 0x25) {
        comment = true;
      } else if (specialChars[ch] !== 1) {
        break;
      }

      ch = this.nextChar();
    }

    switch (ch | 0) {
      case 0x30:
      case 0x31:
      case 0x32:
      case 0x33:
      case 0x34:
      case 0x35:
      case 0x36:
      case 0x37:
      case 0x38:
      case 0x39:
      case 0x2b:
      case 0x2d:
      case 0x2e:
        return this.getNumber();

      case 0x28:
        return this.getString();

      case 0x2f:
        return this.getName();

      case 0x5b:
        this.nextChar();
        return _primitives.Cmd.get("[");

      case 0x5d:
        this.nextChar();
        return _primitives.Cmd.get("]");

      case 0x3c:
        ch = this.nextChar();

        if (ch === 0x3c) {
          this.nextChar();
          return _primitives.Cmd.get("<<");
        }

        return this.getHexString();

      case 0x3e:
        ch = this.nextChar();

        if (ch === 0x3e) {
          this.nextChar();
          return _primitives.Cmd.get(">>");
        }

        return _primitives.Cmd.get(">");

      case 0x7b:
        this.nextChar();
        return _primitives.Cmd.get("{");

      case 0x7d:
        this.nextChar();
        return _primitives.Cmd.get("}");

      case 0x29:
        this.nextChar();
        throw new _util.FormatError(`Illegal character: ${ch}`);
    }

    let str = String.fromCharCode(ch);

    if (ch < 0x20 || ch > 0x7f) {
      const nextCh = this.peekChar();

      if (nextCh >= 0x20 && nextCh <= 0x7f) {
        this.nextChar();
        return _primitives.Cmd.get(str);
      }
    }

    const knownCommands = this.knownCommands;
    let knownCommandFound = knownCommands && knownCommands[str] !== undefined;

    while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
      const possibleCommand = str + String.fromCharCode(ch);

      if (knownCommandFound && knownCommands[possibleCommand] === undefined) {
        break;
      }

      if (str.length === 128) {
        throw new _util.FormatError(`Command token too long: ${str.length}`);
      }

      str = possibleCommand;
      knownCommandFound = knownCommands && knownCommands[str] !== undefined;
    }

    if (str === "true") {
      return true;
    }

    if (str === "false") {
      return false;
    }

    if (str === "null") {
      return null;
    }

    if (str === "BI") {
      this.beginInlineImagePos = this.stream.pos;
    }

    return _primitives.Cmd.get(str);
  }

  peekObj() {
    const streamPos = this.stream.pos,
          currentChar = this.currentChar,
          beginInlineImagePos = this.beginInlineImagePos;
    let nextObj;

    try {
      nextObj = this.getObj();
    } catch (ex) {
      if (ex instanceof _core_utils.MissingDataException) {
        throw ex;
      }

      (0, _util.warn)(`peekObj: ${ex}`);
    }

    this.stream.pos = streamPos;
    this.currentChar = currentChar;
    this.beginInlineImagePos = beginInlineImagePos;
    return nextObj;
  }

  skipToNextLine() {
    let ch = this.currentChar;

    while (ch >= 0) {
      if (ch === 0x0d) {
        ch = this.nextChar();

        if (ch === 0x0a) {
          this.nextChar();
        }

        break;
      } else if (ch === 0x0a) {
        this.nextChar();
        break;
      }

      ch = this.nextChar();
    }
  }

}

exports.Lexer = Lexer;

class Linearization {
  static create(stream) {
    function getInt(linDict, name, allowZeroValue = false) {
      const obj = linDict.get(name);

      if (Number.isInteger(obj) && (allowZeroValue ? obj >= 0 : obj > 0)) {
        return obj;
      }

      throw new Error(`The "${name}" parameter in the linearization ` + "dictionary is invalid.");
    }

    function getHints(linDict) {
      const hints = linDict.get("H");
      let hintsLength;

      if (Array.isArray(hints) && ((hintsLength = hints.length) === 2 || hintsLength === 4)) {
        for (let index = 0; index < hintsLength; index++) {
          const hint = hints[index];

          if (!(Number.isInteger(hint) && hint > 0)) {
            throw new Error(`Hint (${index}) in the linearization dictionary is invalid.`);
          }
        }

        return hints;
      }

      throw new Error("Hint array in the linearization dictionary is invalid.");
    }

    const parser = new Parser({
      lexer: new Lexer(stream),
      xref: null
    });
    const obj1 = parser.getObj();
    const obj2 = parser.getObj();
    const obj3 = parser.getObj();
    const linDict = parser.getObj();
    let obj, length;

    if (!(Number.isInteger(obj1) && Number.isInteger(obj2) && (0, _primitives.isCmd)(obj3, "obj") && (0, _primitives.isDict)(linDict) && (0, _util.isNum)(obj = linDict.get("Linearized")) && obj > 0)) {
      return null;
    } else if ((length = getInt(linDict, "L")) !== stream.length) {
      throw new Error('The "L" parameter in the linearization dictionary ' + "does not equal the stream length.");
    }

    return {
      length,
      hints: getHints(linDict),
      objectNumberFirst: getInt(linDict, "O"),
      endFirst: getInt(linDict, "E"),
      numPages: getInt(linDict, "N"),
      mainXRefEntriesOffset: getInt(linDict, "T"),
      pageFirst: linDict.has("P") ? getInt(linDict, "P", true) : 0
    };
  }

}

exports.Linearization = Linearization;

/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Ascii85Stream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

var _core_utils = __w_pdfjs_require__(9);

class Ascii85Stream extends _decode_stream.DecodeStream {
  constructor(str, maybeLength) {
    if (maybeLength) {
      maybeLength *= 0.8;
    }

    super(maybeLength);
    this.str = str;
    this.dict = str.dict;
    this.input = new Uint8Array(5);
  }

  readBlock() {
    const TILDA_CHAR = 0x7e;
    const Z_LOWER_CHAR = 0x7a;
    const EOF = -1;
    const str = this.str;
    let c = str.getByte();

    while ((0, _core_utils.isWhiteSpace)(c)) {
      c = str.getByte();
    }

    if (c === EOF || c === TILDA_CHAR) {
      this.eof = true;
      return;
    }

    const bufferLength = this.bufferLength;
    let buffer, i;

    if (c === Z_LOWER_CHAR) {
      buffer = this.ensureBuffer(bufferLength + 4);

      for (i = 0; i < 4; ++i) {
        buffer[bufferLength + i] = 0;
      }

      this.bufferLength += 4;
    } else {
      const input = this.input;
      input[0] = c;

      for (i = 1; i < 5; ++i) {
        c = str.getByte();

        while ((0, _core_utils.isWhiteSpace)(c)) {
          c = str.getByte();
        }

        input[i] = c;

        if (c === EOF || c === TILDA_CHAR) {
          break;
        }
      }

      buffer = this.ensureBuffer(bufferLength + i - 1);
      this.bufferLength += i - 1;

      if (i < 5) {
        for (; i < 5; ++i) {
          input[i] = 0x21 + 84;
        }

        this.eof = true;
      }

      let t = 0;

      for (i = 0; i < 5; ++i) {
        t = t * 85 + (input[i] - 0x21);
      }

      for (i = 3; i >= 0; --i) {
        buffer[bufferLength + i] = t & 0xff;
        t >>= 8;
      }
    }
  }

}

exports.Ascii85Stream = Ascii85Stream;

/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.StreamsSequenceStream = exports.DecodeStream = void 0;

var _base_stream = __w_pdfjs_require__(6);

var _stream = __w_pdfjs_require__(10);

const emptyBuffer = new Uint8Array(0);

class DecodeStream extends _base_stream.BaseStream {
  constructor(maybeMinBufferLength) {
    super();
    this._rawMinBufferLength = maybeMinBufferLength || 0;
    this.pos = 0;
    this.bufferLength = 0;
    this.eof = false;
    this.buffer = emptyBuffer;
    this.minBufferLength = 512;

    if (maybeMinBufferLength) {
      while (this.minBufferLength < maybeMinBufferLength) {
        this.minBufferLength *= 2;
      }
    }
  }

  get isEmpty() {
    while (!this.eof && this.bufferLength === 0) {
      this.readBlock();
    }

    return this.bufferLength === 0;
  }

  ensureBuffer(requested) {
    const buffer = this.buffer;

    if (requested <= buffer.byteLength) {
      return buffer;
    }

    let size = this.minBufferLength;

    while (size < requested) {
      size *= 2;
    }

    const buffer2 = new Uint8Array(size);
    buffer2.set(buffer);
    return this.buffer = buffer2;
  }

  getByte() {
    const pos = this.pos;

    while (this.bufferLength <= pos) {
      if (this.eof) {
        return -1;
      }

      this.readBlock();
    }

    return this.buffer[this.pos++];
  }

  getBytes(length, forceClamped = false) {
    const pos = this.pos;
    let end;

    if (length) {
      this.ensureBuffer(pos + length);
      end = pos + length;

      while (!this.eof && this.bufferLength < end) {
        this.readBlock();
      }

      const bufEnd = this.bufferLength;

      if (end > bufEnd) {
        end = bufEnd;
      }
    } else {
      while (!this.eof) {
        this.readBlock();
      }

      end = this.bufferLength;
    }

    this.pos = end;
    const subarray = this.buffer.subarray(pos, end);
    return forceClamped && !(subarray instanceof Uint8ClampedArray) ? new Uint8ClampedArray(subarray) : subarray;
  }

  reset() {
    this.pos = 0;
  }

  makeSubStream(start, length, dict = null) {
    if (length === undefined) {
      while (!this.eof) {
        this.readBlock();
      }
    } else {
      const end = start + length;

      while (this.bufferLength <= end && !this.eof) {
        this.readBlock();
      }
    }

    return new _stream.Stream(this.buffer, start, length, dict);
  }

  getBaseStreams() {
    return this.str ? this.str.getBaseStreams() : null;
  }

}

exports.DecodeStream = DecodeStream;

class StreamsSequenceStream extends DecodeStream {
  constructor(streams, onError = null) {
    let maybeLength = 0;

    for (const stream of streams) {
      maybeLength += stream instanceof DecodeStream ? stream._rawMinBufferLength : stream.length;
    }

    super(maybeLength);
    this.streams = streams;
    this._onError = onError;
  }

  readBlock() {
    const streams = this.streams;

    if (streams.length === 0) {
      this.eof = true;
      return;
    }

    const stream = streams.shift();
    let chunk;

    try {
      chunk = stream.getBytes();
    } catch (reason) {
      if (this._onError) {
        this._onError(reason, stream.dict && stream.dict.objId);

        return;
      }

      throw reason;
    }

    const bufferLength = this.bufferLength;
    const newLength = bufferLength + chunk.length;
    const buffer = this.ensureBuffer(newLength);
    buffer.set(chunk, bufferLength);
    this.bufferLength = newLength;
  }

  getBaseStreams() {
    const baseStreamsBuf = [];

    for (const stream of this.streams) {
      const baseStreams = stream.getBaseStreams();

      if (baseStreams) {
        baseStreamsBuf.push(...baseStreams);
      }
    }

    return baseStreamsBuf.length > 0 ? baseStreamsBuf : null;
  }

}

exports.StreamsSequenceStream = StreamsSequenceStream;

/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AsciiHexStream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

class AsciiHexStream extends _decode_stream.DecodeStream {
  constructor(str, maybeLength) {
    if (maybeLength) {
      maybeLength *= 0.5;
    }

    super(maybeLength);
    this.str = str;
    this.dict = str.dict;
    this.firstDigit = -1;
  }

  readBlock() {
    const UPSTREAM_BLOCK_SIZE = 8000;
    const bytes = this.str.getBytes(UPSTREAM_BLOCK_SIZE);

    if (!bytes.length) {
      this.eof = true;
      return;
    }

    const maxDecodeLength = bytes.length + 1 >> 1;
    const buffer = this.ensureBuffer(this.bufferLength + maxDecodeLength);
    let bufferLength = this.bufferLength;
    let firstDigit = this.firstDigit;

    for (const ch of bytes) {
      let digit;

      if (ch >= 0x30 && ch <= 0x39) {
        digit = ch & 0x0f;
      } else if (ch >= 0x41 && ch <= 0x46 || ch >= 0x61 && ch <= 0x66) {
        digit = (ch & 0x0f) + 9;
      } else if (ch === 0x3e) {
        this.eof = true;
        break;
      } else {
        continue;
      }

      if (firstDigit < 0) {
        firstDigit = digit;
      } else {
        buffer[bufferLength++] = firstDigit << 4 | digit;
        firstDigit = -1;
      }
    }

    if (firstDigit >= 0 && this.eof) {
      buffer[bufferLength++] = firstDigit << 4;
      firstDigit = -1;
    }

    this.firstDigit = firstDigit;
    this.bufferLength = bufferLength;
  }

}

exports.AsciiHexStream = AsciiHexStream;

/***/ }),
/* 31 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CCITTFaxStream = void 0;

var _primitives = __w_pdfjs_require__(5);

var _ccitt = __w_pdfjs_require__(32);

var _decode_stream = __w_pdfjs_require__(29);

class CCITTFaxStream extends _decode_stream.DecodeStream {
  constructor(str, maybeLength, params) {
    super(maybeLength);
    this.str = str;
    this.dict = str.dict;

    if (!(0, _primitives.isDict)(params)) {
      params = _primitives.Dict.empty;
    }

    const source = {
      next() {
        return str.getByte();
      }

    };
    this.ccittFaxDecoder = new _ccitt.CCITTFaxDecoder(source, {
      K: params.get("K"),
      EndOfLine: params.get("EndOfLine"),
      EncodedByteAlign: params.get("EncodedByteAlign"),
      Columns: params.get("Columns"),
      Rows: params.get("Rows"),
      EndOfBlock: params.get("EndOfBlock"),
      BlackIs1: params.get("BlackIs1")
    });
  }

  readBlock() {
    while (!this.eof) {
      const c = this.ccittFaxDecoder.readNextChar();

      if (c === -1) {
        this.eof = true;
        return;
      }

      this.ensureBuffer(this.bufferLength + 1);
      this.buffer[this.bufferLength++] = c;
    }
  }

}

exports.CCITTFaxStream = CCITTFaxStream;

/***/ }),
/* 32 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CCITTFaxDecoder = void 0;

var _util = __w_pdfjs_require__(2);

const ccittEOL = -2;
const ccittEOF = -1;
const twoDimPass = 0;
const twoDimHoriz = 1;
const twoDimVert0 = 2;
const twoDimVertR1 = 3;
const twoDimVertL1 = 4;
const twoDimVertR2 = 5;
const twoDimVertL2 = 6;
const twoDimVertR3 = 7;
const twoDimVertL3 = 8;
const twoDimTable = [[-1, -1], [-1, -1], [7, twoDimVertL3], [7, twoDimVertR3], [6, twoDimVertL2], [6, twoDimVertL2], [6, twoDimVertR2], [6, twoDimVertR2], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0]];
const whiteTable1 = [[-1, -1], [12, ccittEOL], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [11, 1792], [11, 1792], [12, 1984], [12, 2048], [12, 2112], [12, 2176], [12, 2240], [12, 2304], [11, 1856], [11, 1856], [11, 1920], [11, 1920], [12, 2368], [12, 2432], [12, 2496], [12, 2560]];
const whiteTable2 = [[-1, -1], [-1, -1], [-1, -1], [-1, -1], [8, 29], [8, 29], [8, 30], [8, 30], [8, 45], [8, 45], [8, 46], [8, 46], [7, 22], [7, 22], [7, 22], [7, 22], [7, 23], [7, 23], [7, 23], [7, 23], [8, 47], [8, 47], [8, 48], [8, 48], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [7, 20], [7, 20], [7, 20], [7, 20], [8, 33], [8, 33], [8, 34], [8, 34], [8, 35], [8, 35], [8, 36], [8, 36], [8, 37], [8, 37], [8, 38], [8, 38], [7, 19], [7, 19], [7, 19], [7, 19], [8, 31], [8, 31], [8, 32], [8, 32], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [8, 53], [8, 53], [8, 54], [8, 54], [7, 26], [7, 26], [7, 26], [7, 26], [8, 39], [8, 39], [8, 40], [8, 40], [8, 41], [8, 41], [8, 42], [8, 42], [8, 43], [8, 43], [8, 44], [8, 44], [7, 21], [7, 21], [7, 21], [7, 21], [7, 28], [7, 28], [7, 28], [7, 28], [8, 61], [8, 61], [8, 62], [8, 62], [8, 63], [8, 63], [8, 0], [8, 0], [8, 320], [8, 320], [8, 384], [8, 384], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [7, 27], [7, 27], [7, 27], [7, 27], [8, 59], [8, 59], [8, 60], [8, 60], [9, 1472], [9, 1536], [9, 1600], [9, 1728], [7, 18], [7, 18], [7, 18], [7, 18], [7, 24], [7, 24], [7, 24], [7, 24], [8, 49], [8, 49], [8, 50], [8, 50], [8, 51], [8, 51], [8, 52], [8, 52], [7, 25], [7, 25], [7, 25], [7, 25], [8, 55], [8, 55], [8, 56], [8, 56], [8, 57], [8, 57], [8, 58], [8, 58], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [8, 448], [8, 448], [8, 512], [8, 512], [9, 704], [9, 768], [8, 640], [8, 640], [8, 576], [8, 576], [9, 832], [9, 896], [9, 960], [9, 1024], [9, 1088], [9, 1152], [9, 1216], [9, 1280], [9, 1344], [9, 1408], [7, 256], [7, 256], [7, 256], [7, 256], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7]];
const blackTable1 = [[-1, -1], [-1, -1], [12, ccittEOL], [12, ccittEOL], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [11, 1792], [11, 1792], [11, 1792], [11, 1792], [12, 1984], [12, 1984], [12, 2048], [12, 2048], [12, 2112], [12, 2112], [12, 2176], [12, 2176], [12, 2240], [12, 2240], [12, 2304], [12, 2304], [11, 1856], [11, 1856], [11, 1856], [11, 1856], [11, 1920], [11, 1920], [11, 1920], [11, 1920], [12, 2368], [12, 2368], [12, 2432], [12, 2432], [12, 2496], [12, 2496], [12, 2560], [12, 2560], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [12, 52], [12, 52], [13, 640], [13, 704], [13, 768], [13, 832], [12, 55], [12, 55], [12, 56], [12, 56], [13, 1280], [13, 1344], [13, 1408], [13, 1472], [12, 59], [12, 59], [12, 60], [12, 60], [13, 1536], [13, 1600], [11, 24], [11, 24], [11, 24], [11, 24], [11, 25], [11, 25], [11, 25], [11, 25], [13, 1664], [13, 1728], [12, 320], [12, 320], [12, 384], [12, 384], [12, 448], [12, 448], [13, 512], [13, 576], [12, 53], [12, 53], [12, 54], [12, 54], [13, 896], [13, 960], [13, 1024], [13, 1088], [13, 1152], [13, 1216], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64]];
const blackTable2 = [[8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [11, 23], [11, 23], [12, 50], [12, 51], [12, 44], [12, 45], [12, 46], [12, 47], [12, 57], [12, 58], [12, 61], [12, 256], [10, 16], [10, 16], [10, 16], [10, 16], [10, 17], [10, 17], [10, 17], [10, 17], [12, 48], [12, 49], [12, 62], [12, 63], [12, 30], [12, 31], [12, 32], [12, 33], [12, 40], [12, 41], [11, 22], [11, 22], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [12, 128], [12, 192], [12, 26], [12, 27], [12, 28], [12, 29], [11, 19], [11, 19], [11, 20], [11, 20], [12, 34], [12, 35], [12, 36], [12, 37], [12, 38], [12, 39], [11, 21], [11, 21], [12, 42], [12, 43], [10, 0], [10, 0], [10, 0], [10, 0], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12]];
const blackTable3 = [[-1, -1], [-1, -1], [-1, -1], [-1, -1], [6, 9], [6, 8], [5, 7], [5, 7], [4, 6], [4, 6], [4, 6], [4, 6], [4, 5], [4, 5], [4, 5], [4, 5], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2]];

class CCITTFaxDecoder {
  constructor(source, options = {}) {
    if (!source || typeof source.next !== "function") {
      throw new Error('CCITTFaxDecoder - invalid "source" parameter.');
    }

    this.source = source;
    this.eof = false;
    this.encoding = options.K || 0;
    this.eoline = options.EndOfLine || false;
    this.byteAlign = options.EncodedByteAlign || false;
    this.columns = options.Columns || 1728;
    this.rows = options.Rows || 0;
    let eoblock = options.EndOfBlock;

    if (eoblock === null || eoblock === undefined) {
      eoblock = true;
    }

    this.eoblock = eoblock;
    this.black = options.BlackIs1 || false;
    this.codingLine = new Uint32Array(this.columns + 1);
    this.refLine = new Uint32Array(this.columns + 2);
    this.codingLine[0] = this.columns;
    this.codingPos = 0;
    this.row = 0;
    this.nextLine2D = this.encoding < 0;
    this.inputBits = 0;
    this.inputBuf = 0;
    this.outputBits = 0;
    this.rowsDone = false;
    let code1;

    while ((code1 = this._lookBits(12)) === 0) {
      this._eatBits(1);
    }

    if (code1 === 1) {
      this._eatBits(12);
    }

    if (this.encoding > 0) {
      this.nextLine2D = !this._lookBits(1);

      this._eatBits(1);
    }
  }

  readNextChar() {
    if (this.eof) {
      return -1;
    }

    const refLine = this.refLine;
    const codingLine = this.codingLine;
    const columns = this.columns;
    let refPos, blackPixels, bits, i;

    if (this.outputBits === 0) {
      if (this.rowsDone) {
        this.eof = true;
      }

      if (this.eof) {
        return -1;
      }

      this.err = false;
      let code1, code2, code3;

      if (this.nextLine2D) {
        for (i = 0; codingLine[i] < columns; ++i) {
          refLine[i] = codingLine[i];
        }

        refLine[i++] = columns;
        refLine[i] = columns;
        codingLine[0] = 0;
        this.codingPos = 0;
        refPos = 0;
        blackPixels = 0;

        while (codingLine[this.codingPos] < columns) {
          code1 = this._getTwoDimCode();

          switch (code1) {
            case twoDimPass:
              this._addPixels(refLine[refPos + 1], blackPixels);

              if (refLine[refPos + 1] < columns) {
                refPos += 2;
              }

              break;

            case twoDimHoriz:
              code1 = code2 = 0;

              if (blackPixels) {
                do {
                  code1 += code3 = this._getBlackCode();
                } while (code3 >= 64);

                do {
                  code2 += code3 = this._getWhiteCode();
                } while (code3 >= 64);
              } else {
                do {
                  code1 += code3 = this._getWhiteCode();
                } while (code3 >= 64);

                do {
                  code2 += code3 = this._getBlackCode();
                } while (code3 >= 64);
              }

              this._addPixels(codingLine[this.codingPos] + code1, blackPixels);

              if (codingLine[this.codingPos] < columns) {
                this._addPixels(codingLine[this.codingPos] + code2, blackPixels ^ 1);
              }

              while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                refPos += 2;
              }

              break;

            case twoDimVertR3:
              this._addPixels(refLine[refPos] + 3, blackPixels);

              blackPixels ^= 1;

              if (codingLine[this.codingPos] < columns) {
                ++refPos;

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }
              }

              break;

            case twoDimVertR2:
              this._addPixels(refLine[refPos] + 2, blackPixels);

              blackPixels ^= 1;

              if (codingLine[this.codingPos] < columns) {
                ++refPos;

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }
              }

              break;

            case twoDimVertR1:
              this._addPixels(refLine[refPos] + 1, blackPixels);

              blackPixels ^= 1;

              if (codingLine[this.codingPos] < columns) {
                ++refPos;

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }
              }

              break;

            case twoDimVert0:
              this._addPixels(refLine[refPos], blackPixels);

              blackPixels ^= 1;

              if (codingLine[this.codingPos] < columns) {
                ++refPos;

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }
              }

              break;

            case twoDimVertL3:
              this._addPixelsNeg(refLine[refPos] - 3, blackPixels);

              blackPixels ^= 1;

              if (codingLine[this.codingPos] < columns) {
                if (refPos > 0) {
                  --refPos;
                } else {
                  ++refPos;
                }

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }
              }

              break;

            case twoDimVertL2:
              this._addPixelsNeg(refLine[refPos] - 2, blackPixels);

              blackPixels ^= 1;

              if (codingLine[this.codingPos] < columns) {
                if (refPos > 0) {
                  --refPos;
                } else {
                  ++refPos;
                }

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }
              }

              break;

            case twoDimVertL1:
              this._addPixelsNeg(refLine[refPos] - 1, blackPixels);

              blackPixels ^= 1;

              if (codingLine[this.codingPos] < columns) {
                if (refPos > 0) {
                  --refPos;
                } else {
                  ++refPos;
                }

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }
              }

              break;

            case ccittEOF:
              this._addPixels(columns, 0);

              this.eof = true;
              break;

            default:
              (0, _util.info)("bad 2d code");

              this._addPixels(columns, 0);

              this.err = true;
          }
        }
      } else {
        codingLine[0] = 0;
        this.codingPos = 0;
        blackPixels = 0;

        while (codingLine[this.codingPos] < columns) {
          code1 = 0;

          if (blackPixels) {
            do {
              code1 += code3 = this._getBlackCode();
            } while (code3 >= 64);
          } else {
            do {
              code1 += code3 = this._getWhiteCode();
            } while (code3 >= 64);
          }

          this._addPixels(codingLine[this.codingPos] + code1, blackPixels);

          blackPixels ^= 1;
        }
      }

      let gotEOL = false;

      if (this.byteAlign) {
        this.inputBits &= ~7;
      }

      if (!this.eoblock && this.row === this.rows - 1) {
        this.rowsDone = true;
      } else {
        code1 = this._lookBits(12);

        if (this.eoline) {
          while (code1 !== ccittEOF && code1 !== 1) {
            this._eatBits(1);

            code1 = this._lookBits(12);
          }
        } else {
          while (code1 === 0) {
            this._eatBits(1);

            code1 = this._lookBits(12);
          }
        }

        if (code1 === 1) {
          this._eatBits(12);

          gotEOL = true;
        } else if (code1 === ccittEOF) {
          this.eof = true;
        }
      }

      if (!this.eof && this.encoding > 0 && !this.rowsDone) {
        this.nextLine2D = !this._lookBits(1);

        this._eatBits(1);
      }

      if (this.eoblock && gotEOL && this.byteAlign) {
        code1 = this._lookBits(12);

        if (code1 === 1) {
          this._eatBits(12);

          if (this.encoding > 0) {
            this._lookBits(1);

            this._eatBits(1);
          }

          if (this.encoding >= 0) {
            for (i = 0; i < 4; ++i) {
              code1 = this._lookBits(12);

              if (code1 !== 1) {
                (0, _util.info)("bad rtc code: " + code1);
              }

              this._eatBits(12);

              if (this.encoding > 0) {
                this._lookBits(1);

                this._eatBits(1);
              }
            }
          }

          this.eof = true;
        }
      } else if (this.err && this.eoline) {
        while (true) {
          code1 = this._lookBits(13);

          if (code1 === ccittEOF) {
            this.eof = true;
            return -1;
          }

          if (code1 >> 1 === 1) {
            break;
          }

          this._eatBits(1);
        }

        this._eatBits(12);

        if (this.encoding > 0) {
          this._eatBits(1);

          this.nextLine2D = !(code1 & 1);
        }
      }

      if (codingLine[0] > 0) {
        this.outputBits = codingLine[this.codingPos = 0];
      } else {
        this.outputBits = codingLine[this.codingPos = 1];
      }

      this.row++;
    }

    let c;

    if (this.outputBits >= 8) {
      c = this.codingPos & 1 ? 0 : 0xff;
      this.outputBits -= 8;

      if (this.outputBits === 0 && codingLine[this.codingPos] < columns) {
        this.codingPos++;
        this.outputBits = codingLine[this.codingPos] - codingLine[this.codingPos - 1];
      }
    } else {
      bits = 8;
      c = 0;

      do {
        if (typeof this.outputBits !== "number") {
          throw new _util.FormatError('Invalid /CCITTFaxDecode data, "outputBits" must be a number.');
        }

        if (this.outputBits > bits) {
          c <<= bits;

          if (!(this.codingPos & 1)) {
            c |= 0xff >> 8 - bits;
          }

          this.outputBits -= bits;
          bits = 0;
        } else {
          c <<= this.outputBits;

          if (!(this.codingPos & 1)) {
            c |= 0xff >> 8 - this.outputBits;
          }

          bits -= this.outputBits;
          this.outputBits = 0;

          if (codingLine[this.codingPos] < columns) {
            this.codingPos++;
            this.outputBits = codingLine[this.codingPos] - codingLine[this.codingPos - 1];
          } else if (bits > 0) {
            c <<= bits;
            bits = 0;
          }
        }
      } while (bits);
    }

    if (this.black) {
      c ^= 0xff;
    }

    return c;
  }

  _addPixels(a1, blackPixels) {
    const codingLine = this.codingLine;
    let codingPos = this.codingPos;

    if (a1 > codingLine[codingPos]) {
      if (a1 > this.columns) {
        (0, _util.info)("row is wrong length");
        this.err = true;
        a1 = this.columns;
      }

      if (codingPos & 1 ^ blackPixels) {
        ++codingPos;
      }

      codingLine[codingPos] = a1;
    }

    this.codingPos = codingPos;
  }

  _addPixelsNeg(a1, blackPixels) {
    const codingLine = this.codingLine;
    let codingPos = this.codingPos;

    if (a1 > codingLine[codingPos]) {
      if (a1 > this.columns) {
        (0, _util.info)("row is wrong length");
        this.err = true;
        a1 = this.columns;
      }

      if (codingPos & 1 ^ blackPixels) {
        ++codingPos;
      }

      codingLine[codingPos] = a1;
    } else if (a1 < codingLine[codingPos]) {
      if (a1 < 0) {
        (0, _util.info)("invalid code");
        this.err = true;
        a1 = 0;
      }

      while (codingPos > 0 && a1 < codingLine[codingPos - 1]) {
        --codingPos;
      }

      codingLine[codingPos] = a1;
    }

    this.codingPos = codingPos;
  }

  _findTableCode(start, end, table, limit) {
    const limitValue = limit || 0;

    for (let i = start; i <= end; ++i) {
      let code = this._lookBits(i);

      if (code === ccittEOF) {
        return [true, 1, false];
      }

      if (i < end) {
        code <<= end - i;
      }

      if (!limitValue || code >= limitValue) {
        const p = table[code - limitValue];

        if (p[0] === i) {
          this._eatBits(i);

          return [true, p[1], true];
        }
      }
    }

    return [false, 0, false];
  }

  _getTwoDimCode() {
    let code = 0;
    let p;

    if (this.eoblock) {
      code = this._lookBits(7);
      p = twoDimTable[code];

      if (p && p[0] > 0) {
        this._eatBits(p[0]);

        return p[1];
      }
    } else {
      const result = this._findTableCode(1, 7, twoDimTable);

      if (result[0] && result[2]) {
        return result[1];
      }
    }

    (0, _util.info)("Bad two dim code");
    return ccittEOF;
  }

  _getWhiteCode() {
    let code = 0;
    let p;

    if (this.eoblock) {
      code = this._lookBits(12);

      if (code === ccittEOF) {
        return 1;
      }

      if (code >> 5 === 0) {
        p = whiteTable1[code];
      } else {
        p = whiteTable2[code >> 3];
      }

      if (p[0] > 0) {
        this._eatBits(p[0]);

        return p[1];
      }
    } else {
      let result = this._findTableCode(1, 9, whiteTable2);

      if (result[0]) {
        return result[1];
      }

      result = this._findTableCode(11, 12, whiteTable1);

      if (result[0]) {
        return result[1];
      }
    }

    (0, _util.info)("bad white code");

    this._eatBits(1);

    return 1;
  }

  _getBlackCode() {
    let code, p;

    if (this.eoblock) {
      code = this._lookBits(13);

      if (code === ccittEOF) {
        return 1;
      }

      if (code >> 7 === 0) {
        p = blackTable1[code];
      } else if (code >> 9 === 0 && code >> 7 !== 0) {
        p = blackTable2[(code >> 1) - 64];
      } else {
        p = blackTable3[code >> 7];
      }

      if (p[0] > 0) {
        this._eatBits(p[0]);

        return p[1];
      }
    } else {
      let result = this._findTableCode(2, 6, blackTable3);

      if (result[0]) {
        return result[1];
      }

      result = this._findTableCode(7, 12, blackTable2, 64);

      if (result[0]) {
        return result[1];
      }

      result = this._findTableCode(10, 13, blackTable1);

      if (result[0]) {
        return result[1];
      }
    }

    (0, _util.info)("bad black code");

    this._eatBits(1);

    return 1;
  }

  _lookBits(n) {
    let c;

    while (this.inputBits < n) {
      if ((c = this.source.next()) === -1) {
        if (this.inputBits === 0) {
          return ccittEOF;
        }

        return this.inputBuf << n - this.inputBits & 0xffff >> 16 - n;
      }

      this.inputBuf = this.inputBuf << 8 | c;
      this.inputBits += 8;
    }

    return this.inputBuf >> this.inputBits - n & 0xffff >> 16 - n;
  }

  _eatBits(n) {
    if ((this.inputBits -= n) < 0) {
      this.inputBits = 0;
    }
  }

}

exports.CCITTFaxDecoder = CCITTFaxDecoder;

/***/ }),
/* 33 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FlateStream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

var _util = __w_pdfjs_require__(2);

const codeLenCodeMap = new Int32Array([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
const lengthDecode = new Int32Array([0x00003, 0x00004, 0x00005, 0x00006, 0x00007, 0x00008, 0x00009, 0x0000a, 0x1000b, 0x1000d, 0x1000f, 0x10011, 0x20013, 0x20017, 0x2001b, 0x2001f, 0x30023, 0x3002b, 0x30033, 0x3003b, 0x40043, 0x40053, 0x40063, 0x40073, 0x50083, 0x500a3, 0x500c3, 0x500e3, 0x00102, 0x00102, 0x00102]);
const distDecode = new Int32Array([0x00001, 0x00002, 0x00003, 0x00004, 0x10005, 0x10007, 0x20009, 0x2000d, 0x30011, 0x30019, 0x40021, 0x40031, 0x50041, 0x50061, 0x60081, 0x600c1, 0x70101, 0x70181, 0x80201, 0x80301, 0x90401, 0x90601, 0xa0801, 0xa0c01, 0xb1001, 0xb1801, 0xc2001, 0xc3001, 0xd4001, 0xd6001]);
const fixedLitCodeTab = [new Int32Array([0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c0, 0x70108, 0x80060, 0x80020, 0x900a0, 0x80000, 0x80080, 0x80040, 0x900e0, 0x70104, 0x80058, 0x80018, 0x90090, 0x70114, 0x80078, 0x80038, 0x900d0, 0x7010c, 0x80068, 0x80028, 0x900b0, 0x80008, 0x80088, 0x80048, 0x900f0, 0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c8, 0x7010a, 0x80064, 0x80024, 0x900a8, 0x80004, 0x80084, 0x80044, 0x900e8, 0x70106, 0x8005c, 0x8001c, 0x90098, 0x70116, 0x8007c, 0x8003c, 0x900d8, 0x7010e, 0x8006c, 0x8002c, 0x900b8, 0x8000c, 0x8008c, 0x8004c, 0x900f8, 0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c4, 0x70109, 0x80062, 0x80022, 0x900a4, 0x80002, 0x80082, 0x80042, 0x900e4, 0x70105, 0x8005a, 0x8001a, 0x90094, 0x70115, 0x8007a, 0x8003a, 0x900d4, 0x7010d, 0x8006a, 0x8002a, 0x900b4, 0x8000a, 0x8008a, 0x8004a, 0x900f4, 0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cc, 0x7010b, 0x80066, 0x80026, 0x900ac, 0x80006, 0x80086, 0x80046, 0x900ec, 0x70107, 0x8005e, 0x8001e, 0x9009c, 0x70117, 0x8007e, 0x8003e, 0x900dc, 0x7010f, 0x8006e, 0x8002e, 0x900bc, 0x8000e, 0x8008e, 0x8004e, 0x900fc, 0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c2, 0x70108, 0x80061, 0x80021, 0x900a2, 0x80001, 0x80081, 0x80041, 0x900e2, 0x70104, 0x80059, 0x80019, 0x90092, 0x70114, 0x80079, 0x80039, 0x900d2, 0x7010c, 0x80069, 0x80029, 0x900b2, 0x80009, 0x80089, 0x80049, 0x900f2, 0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900ca, 0x7010a, 0x80065, 0x80025, 0x900aa, 0x80005, 0x80085, 0x80045, 0x900ea, 0x70106, 0x8005d, 0x8001d, 0x9009a, 0x70116, 0x8007d, 0x8003d, 0x900da, 0x7010e, 0x8006d, 0x8002d, 0x900ba, 0x8000d, 0x8008d, 0x8004d, 0x900fa, 0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c6, 0x70109, 0x80063, 0x80023, 0x900a6, 0x80003, 0x80083, 0x80043, 0x900e6, 0x70105, 0x8005b, 0x8001b, 0x90096, 0x70115, 0x8007b, 0x8003b, 0x900d6, 0x7010d, 0x8006b, 0x8002b, 0x900b6, 0x8000b, 0x8008b, 0x8004b, 0x900f6, 0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900ce, 0x7010b, 0x80067, 0x80027, 0x900ae, 0x80007, 0x80087, 0x80047, 0x900ee, 0x70107, 0x8005f, 0x8001f, 0x9009e, 0x70117, 0x8007f, 0x8003f, 0x900de, 0x7010f, 0x8006f, 0x8002f, 0x900be, 0x8000f, 0x8008f, 0x8004f, 0x900fe, 0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c1, 0x70108, 0x80060, 0x80020, 0x900a1, 0x80000, 0x80080, 0x80040, 0x900e1, 0x70104, 0x80058, 0x80018, 0x90091, 0x70114, 0x80078, 0x80038, 0x900d1, 0x7010c, 0x80068, 0x80028, 0x900b1, 0x80008, 0x80088, 0x80048, 0x900f1, 0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c9, 0x7010a, 0x80064, 0x80024, 0x900a9, 0x80004, 0x80084, 0x80044, 0x900e9, 0x70106, 0x8005c, 0x8001c, 0x90099, 0x70116, 0x8007c, 0x8003c, 0x900d9, 0x7010e, 0x8006c, 0x8002c, 0x900b9, 0x8000c, 0x8008c, 0x8004c, 0x900f9, 0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c5, 0x70109, 0x80062, 0x80022, 0x900a5, 0x80002, 0x80082, 0x80042, 0x900e5, 0x70105, 0x8005a, 0x8001a, 0x90095, 0x70115, 0x8007a, 0x8003a, 0x900d5, 0x7010d, 0x8006a, 0x8002a, 0x900b5, 0x8000a, 0x8008a, 0x8004a, 0x900f5, 0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cd, 0x7010b, 0x80066, 0x80026, 0x900ad, 0x80006, 0x80086, 0x80046, 0x900ed, 0x70107, 0x8005e, 0x8001e, 0x9009d, 0x70117, 0x8007e, 0x8003e, 0x900dd, 0x7010f, 0x8006e, 0x8002e, 0x900bd, 0x8000e, 0x8008e, 0x8004e, 0x900fd, 0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c3, 0x70108, 0x80061, 0x80021, 0x900a3, 0x80001, 0x80081, 0x80041, 0x900e3, 0x70104, 0x80059, 0x80019, 0x90093, 0x70114, 0x80079, 0x80039, 0x900d3, 0x7010c, 0x80069, 0x80029, 0x900b3, 0x80009, 0x80089, 0x80049, 0x900f3, 0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900cb, 0x7010a, 0x80065, 0x80025, 0x900ab, 0x80005, 0x80085, 0x80045, 0x900eb, 0x70106, 0x8005d, 0x8001d, 0x9009b, 0x70116, 0x8007d, 0x8003d, 0x900db, 0x7010e, 0x8006d, 0x8002d, 0x900bb, 0x8000d, 0x8008d, 0x8004d, 0x900fb, 0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c7, 0x70109, 0x80063, 0x80023, 0x900a7, 0x80003, 0x80083, 0x80043, 0x900e7, 0x70105, 0x8005b, 0x8001b, 0x90097, 0x70115, 0x8007b, 0x8003b, 0x900d7, 0x7010d, 0x8006b, 0x8002b, 0x900b7, 0x8000b, 0x8008b, 0x8004b, 0x900f7, 0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900cf, 0x7010b, 0x80067, 0x80027, 0x900af, 0x80007, 0x80087, 0x80047, 0x900ef, 0x70107, 0x8005f, 0x8001f, 0x9009f, 0x70117, 0x8007f, 0x8003f, 0x900df, 0x7010f, 0x8006f, 0x8002f, 0x900bf, 0x8000f, 0x8008f, 0x8004f, 0x900ff]), 9];
const fixedDistCodeTab = [new Int32Array([0x50000, 0x50010, 0x50008, 0x50018, 0x50004, 0x50014, 0x5000c, 0x5001c, 0x50002, 0x50012, 0x5000a, 0x5001a, 0x50006, 0x50016, 0x5000e, 0x00000, 0x50001, 0x50011, 0x50009, 0x50019, 0x50005, 0x50015, 0x5000d, 0x5001d, 0x50003, 0x50013, 0x5000b, 0x5001b, 0x50007, 0x50017, 0x5000f, 0x00000]), 5];

class FlateStream extends _decode_stream.DecodeStream {
  constructor(str, maybeLength) {
    super(maybeLength);
    this.str = str;
    this.dict = str.dict;
    const cmf = str.getByte();
    const flg = str.getByte();

    if (cmf === -1 || flg === -1) {
      throw new _util.FormatError(`Invalid header in flate stream: ${cmf}, ${flg}`);
    }

    if ((cmf & 0x0f) !== 0x08) {
      throw new _util.FormatError(`Unknown compression method in flate stream: ${cmf}, ${flg}`);
    }

    if (((cmf << 8) + flg) % 31 !== 0) {
      throw new _util.FormatError(`Bad FCHECK in flate stream: ${cmf}, ${flg}`);
    }

    if (flg & 0x20) {
      throw new _util.FormatError(`FDICT bit set in flate stream: ${cmf}, ${flg}`);
    }

    this.codeSize = 0;
    this.codeBuf = 0;
  }

  getBits(bits) {
    const str = this.str;
    let codeSize = this.codeSize;
    let codeBuf = this.codeBuf;
    let b;

    while (codeSize < bits) {
      if ((b = str.getByte()) === -1) {
        throw new _util.FormatError("Bad encoding in flate stream");
      }

      codeBuf |= b << codeSize;
      codeSize += 8;
    }

    b = codeBuf & (1 << bits) - 1;
    this.codeBuf = codeBuf >> bits;
    this.codeSize = codeSize -= bits;
    return b;
  }

  getCode(table) {
    const str = this.str;
    const codes = table[0];
    const maxLen = table[1];
    let codeSize = this.codeSize;
    let codeBuf = this.codeBuf;
    let b;

    while (codeSize < maxLen) {
      if ((b = str.getByte()) === -1) {
        break;
      }

      codeBuf |= b << codeSize;
      codeSize += 8;
    }

    const code = codes[codeBuf & (1 << maxLen) - 1];
    const codeLen = code >> 16;
    const codeVal = code & 0xffff;

    if (codeLen < 1 || codeSize < codeLen) {
      throw new _util.FormatError("Bad encoding in flate stream");
    }

    this.codeBuf = codeBuf >> codeLen;
    this.codeSize = codeSize - codeLen;
    return codeVal;
  }

  generateHuffmanTable(lengths) {
    const n = lengths.length;
    let maxLen = 0;
    let i;

    for (i = 0; i < n; ++i) {
      if (lengths[i] > maxLen) {
        maxLen = lengths[i];
      }
    }

    const size = 1 << maxLen;
    const codes = new Int32Array(size);

    for (let len = 1, code = 0, skip = 2; len <= maxLen; ++len, code <<= 1, skip <<= 1) {
      for (let val = 0; val < n; ++val) {
        if (lengths[val] === len) {
          let code2 = 0;
          let t = code;

          for (i = 0; i < len; ++i) {
            code2 = code2 << 1 | t & 1;
            t >>= 1;
          }

          for (i = code2; i < size; i += skip) {
            codes[i] = len << 16 | val;
          }

          ++code;
        }
      }
    }

    return [codes, maxLen];
  }

  readBlock() {
    let buffer, len;
    const str = this.str;
    let hdr = this.getBits(3);

    if (hdr & 1) {
      this.eof = true;
    }

    hdr >>= 1;

    if (hdr === 0) {
      let b;

      if ((b = str.getByte()) === -1) {
        throw new _util.FormatError("Bad block header in flate stream");
      }

      let blockLen = b;

      if ((b = str.getByte()) === -1) {
        throw new _util.FormatError("Bad block header in flate stream");
      }

      blockLen |= b << 8;

      if ((b = str.getByte()) === -1) {
        throw new _util.FormatError("Bad block header in flate stream");
      }

      let check = b;

      if ((b = str.getByte()) === -1) {
        throw new _util.FormatError("Bad block header in flate stream");
      }

      check |= b << 8;

      if (check !== (~blockLen & 0xffff) && (blockLen !== 0 || check !== 0)) {
        throw new _util.FormatError("Bad uncompressed block length in flate stream");
      }

      this.codeBuf = 0;
      this.codeSize = 0;
      const bufferLength = this.bufferLength,
            end = bufferLength + blockLen;
      buffer = this.ensureBuffer(end);
      this.bufferLength = end;

      if (blockLen === 0) {
        if (str.peekByte() === -1) {
          this.eof = true;
        }
      } else {
        const block = str.getBytes(blockLen);
        buffer.set(block, bufferLength);

        if (block.length < blockLen) {
          this.eof = true;
        }
      }

      return;
    }

    let litCodeTable;
    let distCodeTable;

    if (hdr === 1) {
      litCodeTable = fixedLitCodeTab;
      distCodeTable = fixedDistCodeTab;
    } else if (hdr === 2) {
      const numLitCodes = this.getBits(5) + 257;
      const numDistCodes = this.getBits(5) + 1;
      const numCodeLenCodes = this.getBits(4) + 4;
      const codeLenCodeLengths = new Uint8Array(codeLenCodeMap.length);
      let i;

      for (i = 0; i < numCodeLenCodes; ++i) {
        codeLenCodeLengths[codeLenCodeMap[i]] = this.getBits(3);
      }

      const codeLenCodeTab = this.generateHuffmanTable(codeLenCodeLengths);
      len = 0;
      i = 0;
      const codes = numLitCodes + numDistCodes;
      const codeLengths = new Uint8Array(codes);
      let bitsLength, bitsOffset, what;

      while (i < codes) {
        const code = this.getCode(codeLenCodeTab);

        if (code === 16) {
          bitsLength = 2;
          bitsOffset = 3;
          what = len;
        } else if (code === 17) {
          bitsLength = 3;
          bitsOffset = 3;
          what = len = 0;
        } else if (code === 18) {
          bitsLength = 7;
          bitsOffset = 11;
          what = len = 0;
        } else {
          codeLengths[i++] = len = code;
          continue;
        }

        let repeatLength = this.getBits(bitsLength) + bitsOffset;

        while (repeatLength-- > 0) {
          codeLengths[i++] = what;
        }
      }

      litCodeTable = this.generateHuffmanTable(codeLengths.subarray(0, numLitCodes));
      distCodeTable = this.generateHuffmanTable(codeLengths.subarray(numLitCodes, codes));
    } else {
      throw new _util.FormatError("Unknown block type in flate stream");
    }

    buffer = this.buffer;
    let limit = buffer ? buffer.length : 0;
    let pos = this.bufferLength;

    while (true) {
      let code1 = this.getCode(litCodeTable);

      if (code1 < 256) {
        if (pos + 1 >= limit) {
          buffer = this.ensureBuffer(pos + 1);
          limit = buffer.length;
        }

        buffer[pos++] = code1;
        continue;
      }

      if (code1 === 256) {
        this.bufferLength = pos;
        return;
      }

      code1 -= 257;
      code1 = lengthDecode[code1];
      let code2 = code1 >> 16;

      if (code2 > 0) {
        code2 = this.getBits(code2);
      }

      len = (code1 & 0xffff) + code2;
      code1 = this.getCode(distCodeTable);
      code1 = distDecode[code1];
      code2 = code1 >> 16;

      if (code2 > 0) {
        code2 = this.getBits(code2);
      }

      const dist = (code1 & 0xffff) + code2;

      if (pos + len >= limit) {
        buffer = this.ensureBuffer(pos + len);
        limit = buffer.length;
      }

      for (let k = 0; k < len; ++k, ++pos) {
        buffer[pos] = buffer[pos - dist];
      }
    }
  }

}

exports.FlateStream = FlateStream;

/***/ }),
/* 34 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Jbig2Stream = void 0;

var _primitives = __w_pdfjs_require__(5);

var _decode_stream = __w_pdfjs_require__(29);

var _jbig = __w_pdfjs_require__(35);

var _util = __w_pdfjs_require__(2);

class Jbig2Stream extends _decode_stream.DecodeStream {
  constructor(stream, maybeLength, params) {
    super(maybeLength);
    this.stream = stream;
    this.dict = stream.dict;
    this.maybeLength = maybeLength;
    this.params = params;
  }

  get bytes() {
    return (0, _util.shadow)(this, "bytes", this.stream.getBytes(this.maybeLength));
  }

  ensureBuffer(requested) {}

  readBlock() {
    if (this.eof) {
      return;
    }

    const jbig2Image = new _jbig.Jbig2Image();
    const chunks = [];

    if ((0, _primitives.isDict)(this.params)) {
      const globalsStream = this.params.get("JBIG2Globals");

      if ((0, _primitives.isStream)(globalsStream)) {
        const globals = globalsStream.getBytes();
        chunks.push({
          data: globals,
          start: 0,
          end: globals.length
        });
      }
    }

    chunks.push({
      data: this.bytes,
      start: 0,
      end: this.bytes.length
    });
    const data = jbig2Image.parseChunks(chunks);
    const dataLength = data.length;

    for (let i = 0; i < dataLength; i++) {
      data[i] ^= 0xff;
    }

    this.buffer = data;
    this.bufferLength = dataLength;
    this.eof = true;
  }

}

exports.Jbig2Stream = Jbig2Stream;

/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Jbig2Image = void 0;

var _util = __w_pdfjs_require__(2);

var _core_utils = __w_pdfjs_require__(9);

var _arithmetic_decoder = __w_pdfjs_require__(36);

var _ccitt = __w_pdfjs_require__(32);

class Jbig2Error extends _util.BaseException {
  constructor(msg) {
    super(`JBIG2 error: ${msg}`, "Jbig2Error");
  }

}

class ContextCache {
  getContexts(id) {
    if (id in this) {
      return this[id];
    }

    return this[id] = new Int8Array(1 << 16);
  }

}

class DecodingContext {
  constructor(data, start, end) {
    this.data = data;
    this.start = start;
    this.end = end;
  }

  get decoder() {
    const decoder = new _arithmetic_decoder.ArithmeticDecoder(this.data, this.start, this.end);
    return (0, _util.shadow)(this, "decoder", decoder);
  }

  get contextCache() {
    const cache = new ContextCache();
    return (0, _util.shadow)(this, "contextCache", cache);
  }

}

function decodeInteger(contextCache, procedure, decoder) {
  const contexts = contextCache.getContexts(procedure);
  let prev = 1;

  function readBits(length) {
    let v = 0;

    for (let i = 0; i < length; i++) {
      const bit = decoder.readBit(contexts, prev);
      prev = prev < 256 ? prev << 1 | bit : (prev << 1 | bit) & 511 | 256;
      v = v << 1 | bit;
    }

    return v >>> 0;
  }

  const sign = readBits(1);
  const value = readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(32) + 4436 : readBits(12) + 340 : readBits(8) + 84 : readBits(6) + 20 : readBits(4) + 4 : readBits(2);

  if (sign === 0) {
    return value;
  } else if (value > 0) {
    return -value;
  }

  return null;
}

function decodeIAID(contextCache, decoder, codeLength) {
  const contexts = contextCache.getContexts("IAID");
  let prev = 1;

  for (let i = 0; i < codeLength; i++) {
    const bit = decoder.readBit(contexts, prev);
    prev = prev << 1 | bit;
  }

  if (codeLength < 31) {
    return prev & (1 << codeLength) - 1;
  }

  return prev & 0x7fffffff;
}

const SegmentTypes = ["SymbolDictionary", null, null, null, "IntermediateTextRegion", null, "ImmediateTextRegion", "ImmediateLosslessTextRegion", null, null, null, null, null, null, null, null, "PatternDictionary", null, null, null, "IntermediateHalftoneRegion", null, "ImmediateHalftoneRegion", "ImmediateLosslessHalftoneRegion", null, null, null, null, null, null, null, null, null, null, null, null, "IntermediateGenericRegion", null, "ImmediateGenericRegion", "ImmediateLosslessGenericRegion", "IntermediateGenericRefinementRegion", null, "ImmediateGenericRefinementRegion", "ImmediateLosslessGenericRefinementRegion", null, null, null, null, "PageInformation", "EndOfPage", "EndOfStripe", "EndOfFile", "Profiles", "Tables", null, null, null, null, null, null, null, null, "Extension"];
const CodingTemplates = [[{
  x: -1,
  y: -2
}, {
  x: 0,
  y: -2
}, {
  x: 1,
  y: -2
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: 2,
  y: -1
}, {
  x: -4,
  y: 0
}, {
  x: -3,
  y: 0
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}], [{
  x: -1,
  y: -2
}, {
  x: 0,
  y: -2
}, {
  x: 1,
  y: -2
}, {
  x: 2,
  y: -2
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: 2,
  y: -1
}, {
  x: -3,
  y: 0
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}], [{
  x: -1,
  y: -2
}, {
  x: 0,
  y: -2
}, {
  x: 1,
  y: -2
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}], [{
  x: -3,
  y: -1
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: -4,
  y: 0
}, {
  x: -3,
  y: 0
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}]];
const RefinementTemplates = [{
  coding: [{
    x: 0,
    y: -1
  }, {
    x: 1,
    y: -1
  }, {
    x: -1,
    y: 0
  }],
  reference: [{
    x: 0,
    y: -1
  }, {
    x: 1,
    y: -1
  }, {
    x: -1,
    y: 0
  }, {
    x: 0,
    y: 0
  }, {
    x: 1,
    y: 0
  }, {
    x: -1,
    y: 1
  }, {
    x: 0,
    y: 1
  }, {
    x: 1,
    y: 1
  }]
}, {
  coding: [{
    x: -1,
    y: -1
  }, {
    x: 0,
    y: -1
  }, {
    x: 1,
    y: -1
  }, {
    x: -1,
    y: 0
  }],
  reference: [{
    x: 0,
    y: -1
  }, {
    x: -1,
    y: 0
  }, {
    x: 0,
    y: 0
  }, {
    x: 1,
    y: 0
  }, {
    x: 0,
    y: 1
  }, {
    x: 1,
    y: 1
  }]
}];
const ReusedContexts = [0x9b25, 0x0795, 0x00e5, 0x0195];
const RefinementReusedContexts = [0x0020, 0x0008];

function decodeBitmapTemplate0(width, height, decodingContext) {
  const decoder = decodingContext.decoder;
  const contexts = decodingContext.contextCache.getContexts("GB");
  const bitmap = [];
  let contextLabel, i, j, pixel, row, row1, row2;
  const OLD_PIXEL_MASK = 0x7bf7;

  for (i = 0; i < height; i++) {
    row = bitmap[i] = new Uint8Array(width);
    row1 = i < 1 ? row : bitmap[i - 1];
    row2 = i < 2 ? row : bitmap[i - 2];
    contextLabel = row2[0] << 13 | row2[1] << 12 | row2[2] << 11 | row1[0] << 7 | row1[1] << 6 | row1[2] << 5 | row1[3] << 4;

    for (j = 0; j < width; j++) {
      row[j] = pixel = decoder.readBit(contexts, contextLabel);
      contextLabel = (contextLabel & OLD_PIXEL_MASK) << 1 | (j + 3 < width ? row2[j + 3] << 11 : 0) | (j + 4 < width ? row1[j + 4] << 4 : 0) | pixel;
    }
  }

  return bitmap;
}

function decodeBitmap(mmr, width, height, templateIndex, prediction, skip, at, decodingContext) {
  if (mmr) {
    const input = new Reader(decodingContext.data, decodingContext.start, decodingContext.end);
    return decodeMMRBitmap(input, width, height, false);
  }

  if (templateIndex === 0 && !skip && !prediction && at.length === 4 && at[0].x === 3 && at[0].y === -1 && at[1].x === -3 && at[1].y === -1 && at[2].x === 2 && at[2].y === -2 && at[3].x === -2 && at[3].y === -2) {
    return decodeBitmapTemplate0(width, height, decodingContext);
  }

  const useskip = !!skip;
  const template = CodingTemplates[templateIndex].concat(at);
  template.sort(function (a, b) {
    return a.y - b.y || a.x - b.x;
  });
  const templateLength = template.length;
  const templateX = new Int8Array(templateLength);
  const templateY = new Int8Array(templateLength);
  const changingTemplateEntries = [];
  let reuseMask = 0,
      minX = 0,
      maxX = 0,
      minY = 0;
  let c, k;

  for (k = 0; k < templateLength; k++) {
    templateX[k] = template[k].x;
    templateY[k] = template[k].y;
    minX = Math.min(minX, template[k].x);
    maxX = Math.max(maxX, template[k].x);
    minY = Math.min(minY, template[k].y);

    if (k < templateLength - 1 && template[k].y === template[k + 1].y && template[k].x === template[k + 1].x - 1) {
      reuseMask |= 1 << templateLength - 1 - k;
    } else {
      changingTemplateEntries.push(k);
    }
  }

  const changingEntriesLength = changingTemplateEntries.length;
  const changingTemplateX = new Int8Array(changingEntriesLength);
  const changingTemplateY = new Int8Array(changingEntriesLength);
  const changingTemplateBit = new Uint16Array(changingEntriesLength);

  for (c = 0; c < changingEntriesLength; c++) {
    k = changingTemplateEntries[c];
    changingTemplateX[c] = template[k].x;
    changingTemplateY[c] = template[k].y;
    changingTemplateBit[c] = 1 << templateLength - 1 - k;
  }

  const sbb_left = -minX;
  const sbb_top = -minY;
  const sbb_right = width - maxX;
  const pseudoPixelContext = ReusedContexts[templateIndex];
  let row = new Uint8Array(width);
  const bitmap = [];
  const decoder = decodingContext.decoder;
  const contexts = decodingContext.contextCache.getContexts("GB");
  let ltp = 0,
      j,
      i0,
      j0,
      contextLabel = 0,
      bit,
      shift;

  for (let i = 0; i < height; i++) {
    if (prediction) {
      const sltp = decoder.readBit(contexts, pseudoPixelContext);
      ltp ^= sltp;

      if (ltp) {
        bitmap.push(row);
        continue;
      }
    }

    row = new Uint8Array(row);
    bitmap.push(row);

    for (j = 0; j < width; j++) {
      if (useskip && skip[i][j]) {
        row[j] = 0;
        continue;
      }

      if (j >= sbb_left && j < sbb_right && i >= sbb_top) {
        contextLabel = contextLabel << 1 & reuseMask;

        for (k = 0; k < changingEntriesLength; k++) {
          i0 = i + changingTemplateY[k];
          j0 = j + changingTemplateX[k];
          bit = bitmap[i0][j0];

          if (bit) {
            bit = changingTemplateBit[k];
            contextLabel |= bit;
          }
        }
      } else {
        contextLabel = 0;
        shift = templateLength - 1;

        for (k = 0; k < templateLength; k++, shift--) {
          j0 = j + templateX[k];

          if (j0 >= 0 && j0 < width) {
            i0 = i + templateY[k];

            if (i0 >= 0) {
              bit = bitmap[i0][j0];

              if (bit) {
                contextLabel |= bit << shift;
              }
            }
          }
        }
      }

      const pixel = decoder.readBit(contexts, contextLabel);
      row[j] = pixel;
    }
  }

  return bitmap;
}

function decodeRefinement(width, height, templateIndex, referenceBitmap, offsetX, offsetY, prediction, at, decodingContext) {
  let codingTemplate = RefinementTemplates[templateIndex].coding;

  if (templateIndex === 0) {
    codingTemplate = codingTemplate.concat([at[0]]);
  }

  const codingTemplateLength = codingTemplate.length;
  const codingTemplateX = new Int32Array(codingTemplateLength);
  const codingTemplateY = new Int32Array(codingTemplateLength);
  let k;

  for (k = 0; k < codingTemplateLength; k++) {
    codingTemplateX[k] = codingTemplate[k].x;
    codingTemplateY[k] = codingTemplate[k].y;
  }

  let referenceTemplate = RefinementTemplates[templateIndex].reference;

  if (templateIndex === 0) {
    referenceTemplate = referenceTemplate.concat([at[1]]);
  }

  const referenceTemplateLength = referenceTemplate.length;
  const referenceTemplateX = new Int32Array(referenceTemplateLength);
  const referenceTemplateY = new Int32Array(referenceTemplateLength);

  for (k = 0; k < referenceTemplateLength; k++) {
    referenceTemplateX[k] = referenceTemplate[k].x;
    referenceTemplateY[k] = referenceTemplate[k].y;
  }

  const referenceWidth = referenceBitmap[0].length;
  const referenceHeight = referenceBitmap.length;
  const pseudoPixelContext = RefinementReusedContexts[templateIndex];
  const bitmap = [];
  const decoder = decodingContext.decoder;
  const contexts = decodingContext.contextCache.getContexts("GR");
  let ltp = 0;

  for (let i = 0; i < height; i++) {
    if (prediction) {
      const sltp = decoder.readBit(contexts, pseudoPixelContext);
      ltp ^= sltp;

      if (ltp) {
        throw new Jbig2Error("prediction is not supported");
      }
    }

    const row = new Uint8Array(width);
    bitmap.push(row);

    for (let j = 0; j < width; j++) {
      let i0, j0;
      let contextLabel = 0;

      for (k = 0; k < codingTemplateLength; k++) {
        i0 = i + codingTemplateY[k];
        j0 = j + codingTemplateX[k];

        if (i0 < 0 || j0 < 0 || j0 >= width) {
          contextLabel <<= 1;
        } else {
          contextLabel = contextLabel << 1 | bitmap[i0][j0];
        }
      }

      for (k = 0; k < referenceTemplateLength; k++) {
        i0 = i + referenceTemplateY[k] - offsetY;
        j0 = j + referenceTemplateX[k] - offsetX;

        if (i0 < 0 || i0 >= referenceHeight || j0 < 0 || j0 >= referenceWidth) {
          contextLabel <<= 1;
        } else {
          contextLabel = contextLabel << 1 | referenceBitmap[i0][j0];
        }
      }

      const pixel = decoder.readBit(contexts, contextLabel);
      row[j] = pixel;
    }
  }

  return bitmap;
}

function decodeSymbolDictionary(huffman, refinement, symbols, numberOfNewSymbols, numberOfExportedSymbols, huffmanTables, templateIndex, at, refinementTemplateIndex, refinementAt, decodingContext, huffmanInput) {
  if (huffman && refinement) {
    throw new Jbig2Error("symbol refinement with Huffman is not supported");
  }

  const newSymbols = [];
  let currentHeight = 0;
  let symbolCodeLength = (0, _core_utils.log2)(symbols.length + numberOfNewSymbols);
  const decoder = decodingContext.decoder;
  const contextCache = decodingContext.contextCache;
  let tableB1, symbolWidths;

  if (huffman) {
    tableB1 = getStandardTable(1);
    symbolWidths = [];
    symbolCodeLength = Math.max(symbolCodeLength, 1);
  }

  while (newSymbols.length < numberOfNewSymbols) {
    const deltaHeight = huffman ? huffmanTables.tableDeltaHeight.decode(huffmanInput) : decodeInteger(contextCache, "IADH", decoder);
    currentHeight += deltaHeight;
    let currentWidth = 0,
        totalWidth = 0;
    const firstSymbol = huffman ? symbolWidths.length : 0;

    while (true) {
      const deltaWidth = huffman ? huffmanTables.tableDeltaWidth.decode(huffmanInput) : decodeInteger(contextCache, "IADW", decoder);

      if (deltaWidth === null) {
        break;
      }

      currentWidth += deltaWidth;
      totalWidth += currentWidth;
      let bitmap;

      if (refinement) {
        const numberOfInstances = decodeInteger(contextCache, "IAAI", decoder);

        if (numberOfInstances > 1) {
          bitmap = decodeTextRegion(huffman, refinement, currentWidth, currentHeight, 0, numberOfInstances, 1, symbols.concat(newSymbols), symbolCodeLength, 0, 0, 1, 0, huffmanTables, refinementTemplateIndex, refinementAt, decodingContext, 0, huffmanInput);
        } else {
          const symbolId = decodeIAID(contextCache, decoder, symbolCodeLength);
          const rdx = decodeInteger(contextCache, "IARDX", decoder);
          const rdy = decodeInteger(contextCache, "IARDY", decoder);
          const symbol = symbolId < symbols.length ? symbols[symbolId] : newSymbols[symbolId - symbols.length];
          bitmap = decodeRefinement(currentWidth, currentHeight, refinementTemplateIndex, symbol, rdx, rdy, false, refinementAt, decodingContext);
        }

        newSymbols.push(bitmap);
      } else if (huffman) {
        symbolWidths.push(currentWidth);
      } else {
        bitmap = decodeBitmap(false, currentWidth, currentHeight, templateIndex, false, null, at, decodingContext);
        newSymbols.push(bitmap);
      }
    }

    if (huffman && !refinement) {
      const bitmapSize = huffmanTables.tableBitmapSize.decode(huffmanInput);
      huffmanInput.byteAlign();
      let collectiveBitmap;

      if (bitmapSize === 0) {
        collectiveBitmap = readUncompressedBitmap(huffmanInput, totalWidth, currentHeight);
      } else {
        const originalEnd = huffmanInput.end;
        const bitmapEnd = huffmanInput.position + bitmapSize;
        huffmanInput.end = bitmapEnd;
        collectiveBitmap = decodeMMRBitmap(huffmanInput, totalWidth, currentHeight, false);
        huffmanInput.end = originalEnd;
        huffmanInput.position = bitmapEnd;
      }

      const numberOfSymbolsDecoded = symbolWidths.length;

      if (firstSymbol === numberOfSymbolsDecoded - 1) {
        newSymbols.push(collectiveBitmap);
      } else {
        let i,
            y,
            xMin = 0,
            xMax,
            bitmapWidth,
            symbolBitmap;

        for (i = firstSymbol; i < numberOfSymbolsDecoded; i++) {
          bitmapWidth = symbolWidths[i];
          xMax = xMin + bitmapWidth;
          symbolBitmap = [];

          for (y = 0; y < currentHeight; y++) {
            symbolBitmap.push(collectiveBitmap[y].subarray(xMin, xMax));
          }

          newSymbols.push(symbolBitmap);
          xMin = xMax;
        }
      }
    }
  }

  const exportedSymbols = [],
        flags = [];
  let currentFlag = false,
      i,
      ii;
  const totalSymbolsLength = symbols.length + numberOfNewSymbols;

  while (flags.length < totalSymbolsLength) {
    let runLength = huffman ? tableB1.decode(huffmanInput) : decodeInteger(contextCache, "IAEX", decoder);

    while (runLength--) {
      flags.push(currentFlag);
    }

    currentFlag = !currentFlag;
  }

  for (i = 0, ii = symbols.length; i < ii; i++) {
    if (flags[i]) {
      exportedSymbols.push(symbols[i]);
    }
  }

  for (let j = 0; j < numberOfNewSymbols; i++, j++) {
    if (flags[i]) {
      exportedSymbols.push(newSymbols[j]);
    }
  }

  return exportedSymbols;
}

function decodeTextRegion(huffman, refinement, width, height, defaultPixelValue, numberOfSymbolInstances, stripSize, inputSymbols, symbolCodeLength, transposed, dsOffset, referenceCorner, combinationOperator, huffmanTables, refinementTemplateIndex, refinementAt, decodingContext, logStripSize, huffmanInput) {
  if (huffman && refinement) {
    throw new Jbig2Error("refinement with Huffman is not supported");
  }

  const bitmap = [];
  let i, row;

  for (i = 0; i < height; i++) {
    row = new Uint8Array(width);

    if (defaultPixelValue) {
      for (let j = 0; j < width; j++) {
        row[j] = defaultPixelValue;
      }
    }

    bitmap.push(row);
  }

  const decoder = decodingContext.decoder;
  const contextCache = decodingContext.contextCache;
  let stripT = huffman ? -huffmanTables.tableDeltaT.decode(huffmanInput) : -decodeInteger(contextCache, "IADT", decoder);
  let firstS = 0;
  i = 0;

  while (i < numberOfSymbolInstances) {
    const deltaT = huffman ? huffmanTables.tableDeltaT.decode(huffmanInput) : decodeInteger(contextCache, "IADT", decoder);
    stripT += deltaT;
    const deltaFirstS = huffman ? huffmanTables.tableFirstS.decode(huffmanInput) : decodeInteger(contextCache, "IAFS", decoder);
    firstS += deltaFirstS;
    let currentS = firstS;

    do {
      let currentT = 0;

      if (stripSize > 1) {
        currentT = huffman ? huffmanInput.readBits(logStripSize) : decodeInteger(contextCache, "IAIT", decoder);
      }

      const t = stripSize * stripT + currentT;
      const symbolId = huffman ? huffmanTables.symbolIDTable.decode(huffmanInput) : decodeIAID(contextCache, decoder, symbolCodeLength);
      const applyRefinement = refinement && (huffman ? huffmanInput.readBit() : decodeInteger(contextCache, "IARI", decoder));
      let symbolBitmap = inputSymbols[symbolId];
      let symbolWidth = symbolBitmap[0].length;
      let symbolHeight = symbolBitmap.length;

      if (applyRefinement) {
        const rdw = decodeInteger(contextCache, "IARDW", decoder);
        const rdh = decodeInteger(contextCache, "IARDH", decoder);
        const rdx = decodeInteger(contextCache, "IARDX", decoder);
        const rdy = decodeInteger(contextCache, "IARDY", decoder);
        symbolWidth += rdw;
        symbolHeight += rdh;
        symbolBitmap = decodeRefinement(symbolWidth, symbolHeight, refinementTemplateIndex, symbolBitmap, (rdw >> 1) + rdx, (rdh >> 1) + rdy, false, refinementAt, decodingContext);
      }

      const offsetT = t - (referenceCorner & 1 ? 0 : symbolHeight - 1);
      const offsetS = currentS - (referenceCorner & 2 ? symbolWidth - 1 : 0);
      let s2, t2, symbolRow;

      if (transposed) {
        for (s2 = 0; s2 < symbolHeight; s2++) {
          row = bitmap[offsetS + s2];

          if (!row) {
            continue;
          }

          symbolRow = symbolBitmap[s2];
          const maxWidth = Math.min(width - offsetT, symbolWidth);

          switch (combinationOperator) {
            case 0:
              for (t2 = 0; t2 < maxWidth; t2++) {
                row[offsetT + t2] |= symbolRow[t2];
              }

              break;

            case 2:
              for (t2 = 0; t2 < maxWidth; t2++) {
                row[offsetT + t2] ^= symbolRow[t2];
              }

              break;

            default:
              throw new Jbig2Error(`operator ${combinationOperator} is not supported`);
          }
        }

        currentS += symbolHeight - 1;
      } else {
        for (t2 = 0; t2 < symbolHeight; t2++) {
          row = bitmap[offsetT + t2];

          if (!row) {
            continue;
          }

          symbolRow = symbolBitmap[t2];

          switch (combinationOperator) {
            case 0:
              for (s2 = 0; s2 < symbolWidth; s2++) {
                row[offsetS + s2] |= symbolRow[s2];
              }

              break;

            case 2:
              for (s2 = 0; s2 < symbolWidth; s2++) {
                row[offsetS + s2] ^= symbolRow[s2];
              }

              break;

            default:
              throw new Jbig2Error(`operator ${combinationOperator} is not supported`);
          }
        }

        currentS += symbolWidth - 1;
      }

      i++;
      const deltaS = huffman ? huffmanTables.tableDeltaS.decode(huffmanInput) : decodeInteger(contextCache, "IADS", decoder);

      if (deltaS === null) {
        break;
      }

      currentS += deltaS + dsOffset;
    } while (true);
  }

  return bitmap;
}

function decodePatternDictionary(mmr, patternWidth, patternHeight, maxPatternIndex, template, decodingContext) {
  const at = [];

  if (!mmr) {
    at.push({
      x: -patternWidth,
      y: 0
    });

    if (template === 0) {
      at.push({
        x: -3,
        y: -1
      }, {
        x: 2,
        y: -2
      }, {
        x: -2,
        y: -2
      });
    }
  }

  const collectiveWidth = (maxPatternIndex + 1) * patternWidth;
  const collectiveBitmap = decodeBitmap(mmr, collectiveWidth, patternHeight, template, false, null, at, decodingContext);
  const patterns = [];

  for (let i = 0; i <= maxPatternIndex; i++) {
    const patternBitmap = [];
    const xMin = patternWidth * i;
    const xMax = xMin + patternWidth;

    for (let y = 0; y < patternHeight; y++) {
      patternBitmap.push(collectiveBitmap[y].subarray(xMin, xMax));
    }

    patterns.push(patternBitmap);
  }

  return patterns;
}

function decodeHalftoneRegion(mmr, patterns, template, regionWidth, regionHeight, defaultPixelValue, enableSkip, combinationOperator, gridWidth, gridHeight, gridOffsetX, gridOffsetY, gridVectorX, gridVectorY, decodingContext) {
  const skip = null;

  if (enableSkip) {
    throw new Jbig2Error("skip is not supported");
  }

  if (combinationOperator !== 0) {
    throw new Jbig2Error(`operator "${combinationOperator}" is not supported in halftone region`);
  }

  const regionBitmap = [];
  let i, j, row;

  for (i = 0; i < regionHeight; i++) {
    row = new Uint8Array(regionWidth);

    if (defaultPixelValue) {
      for (j = 0; j < regionWidth; j++) {
        row[j] = defaultPixelValue;
      }
    }

    regionBitmap.push(row);
  }

  const numberOfPatterns = patterns.length;
  const pattern0 = patterns[0];
  const patternWidth = pattern0[0].length,
        patternHeight = pattern0.length;
  const bitsPerValue = (0, _core_utils.log2)(numberOfPatterns);
  const at = [];

  if (!mmr) {
    at.push({
      x: template <= 1 ? 3 : 2,
      y: -1
    });

    if (template === 0) {
      at.push({
        x: -3,
        y: -1
      }, {
        x: 2,
        y: -2
      }, {
        x: -2,
        y: -2
      });
    }
  }

  const grayScaleBitPlanes = [];
  let mmrInput, bitmap;

  if (mmr) {
    mmrInput = new Reader(decodingContext.data, decodingContext.start, decodingContext.end);
  }

  for (i = bitsPerValue - 1; i >= 0; i--) {
    if (mmr) {
      bitmap = decodeMMRBitmap(mmrInput, gridWidth, gridHeight, true);
    } else {
      bitmap = decodeBitmap(false, gridWidth, gridHeight, template, false, skip, at, decodingContext);
    }

    grayScaleBitPlanes[i] = bitmap;
  }

  let mg, ng, bit, patternIndex, patternBitmap, x, y, patternRow, regionRow;

  for (mg = 0; mg < gridHeight; mg++) {
    for (ng = 0; ng < gridWidth; ng++) {
      bit = 0;
      patternIndex = 0;

      for (j = bitsPerValue - 1; j >= 0; j--) {
        bit ^= grayScaleBitPlanes[j][mg][ng];
        patternIndex |= bit << j;
      }

      patternBitmap = patterns[patternIndex];
      x = gridOffsetX + mg * gridVectorY + ng * gridVectorX >> 8;
      y = gridOffsetY + mg * gridVectorX - ng * gridVectorY >> 8;

      if (x >= 0 && x + patternWidth <= regionWidth && y >= 0 && y + patternHeight <= regionHeight) {
        for (i = 0; i < patternHeight; i++) {
          regionRow = regionBitmap[y + i];
          patternRow = patternBitmap[i];

          for (j = 0; j < patternWidth; j++) {
            regionRow[x + j] |= patternRow[j];
          }
        }
      } else {
        let regionX, regionY;

        for (i = 0; i < patternHeight; i++) {
          regionY = y + i;

          if (regionY < 0 || regionY >= regionHeight) {
            continue;
          }

          regionRow = regionBitmap[regionY];
          patternRow = patternBitmap[i];

          for (j = 0; j < patternWidth; j++) {
            regionX = x + j;

            if (regionX >= 0 && regionX < regionWidth) {
              regionRow[regionX] |= patternRow[j];
            }
          }
        }
      }
    }
  }

  return regionBitmap;
}

function readSegmentHeader(data, start) {
  const segmentHeader = {};
  segmentHeader.number = (0, _core_utils.readUint32)(data, start);
  const flags = data[start + 4];
  const segmentType = flags & 0x3f;

  if (!SegmentTypes[segmentType]) {
    throw new Jbig2Error("invalid segment type: " + segmentType);
  }

  segmentHeader.type = segmentType;
  segmentHeader.typeName = SegmentTypes[segmentType];
  segmentHeader.deferredNonRetain = !!(flags & 0x80);
  const pageAssociationFieldSize = !!(flags & 0x40);
  const referredFlags = data[start + 5];
  let referredToCount = referredFlags >> 5 & 7;
  const retainBits = [referredFlags & 31];
  let position = start + 6;

  if (referredFlags === 7) {
    referredToCount = (0, _core_utils.readUint32)(data, position - 1) & 0x1fffffff;
    position += 3;
    let bytes = referredToCount + 7 >> 3;
    retainBits[0] = data[position++];

    while (--bytes > 0) {
      retainBits.push(data[position++]);
    }
  } else if (referredFlags === 5 || referredFlags === 6) {
    throw new Jbig2Error("invalid referred-to flags");
  }

  segmentHeader.retainBits = retainBits;
  let referredToSegmentNumberSize = 4;

  if (segmentHeader.number <= 256) {
    referredToSegmentNumberSize = 1;
  } else if (segmentHeader.number <= 65536) {
    referredToSegmentNumberSize = 2;
  }

  const referredTo = [];
  let i, ii;

  for (i = 0; i < referredToCount; i++) {
    let number;

    if (referredToSegmentNumberSize === 1) {
      number = data[position];
    } else if (referredToSegmentNumberSize === 2) {
      number = (0, _core_utils.readUint16)(data, position);
    } else {
      number = (0, _core_utils.readUint32)(data, position);
    }

    referredTo.push(number);
    position += referredToSegmentNumberSize;
  }

  segmentHeader.referredTo = referredTo;

  if (!pageAssociationFieldSize) {
    segmentHeader.pageAssociation = data[position++];
  } else {
    segmentHeader.pageAssociation = (0, _core_utils.readUint32)(data, position);
    position += 4;
  }

  segmentHeader.length = (0, _core_utils.readUint32)(data, position);
  position += 4;

  if (segmentHeader.length === 0xffffffff) {
    if (segmentType === 38) {
      const genericRegionInfo = readRegionSegmentInformation(data, position);
      const genericRegionSegmentFlags = data[position + RegionSegmentInformationFieldLength];
      const genericRegionMmr = !!(genericRegionSegmentFlags & 1);
      const searchPatternLength = 6;
      const searchPattern = new Uint8Array(searchPatternLength);

      if (!genericRegionMmr) {
        searchPattern[0] = 0xff;
        searchPattern[1] = 0xac;
      }

      searchPattern[2] = genericRegionInfo.height >>> 24 & 0xff;
      searchPattern[3] = genericRegionInfo.height >> 16 & 0xff;
      searchPattern[4] = genericRegionInfo.height >> 8 & 0xff;
      searchPattern[5] = genericRegionInfo.height & 0xff;

      for (i = position, ii = data.length; i < ii; i++) {
        let j = 0;

        while (j < searchPatternLength && searchPattern[j] === data[i + j]) {
          j++;
        }

        if (j === searchPatternLength) {
          segmentHeader.length = i + searchPatternLength;
          break;
        }
      }

      if (segmentHeader.length === 0xffffffff) {
        throw new Jbig2Error("segment end was not found");
      }
    } else {
      throw new Jbig2Error("invalid unknown segment length");
    }
  }

  segmentHeader.headerEnd = position;
  return segmentHeader;
}

function readSegments(header, data, start, end) {
  const segments = [];
  let position = start;

  while (position < end) {
    const segmentHeader = readSegmentHeader(data, position);
    position = segmentHeader.headerEnd;
    const segment = {
      header: segmentHeader,
      data
    };

    if (!header.randomAccess) {
      segment.start = position;
      position += segmentHeader.length;
      segment.end = position;
    }

    segments.push(segment);

    if (segmentHeader.type === 51) {
      break;
    }
  }

  if (header.randomAccess) {
    for (let i = 0, ii = segments.length; i < ii; i++) {
      segments[i].start = position;
      position += segments[i].header.length;
      segments[i].end = position;
    }
  }

  return segments;
}

function readRegionSegmentInformation(data, start) {
  return {
    width: (0, _core_utils.readUint32)(data, start),
    height: (0, _core_utils.readUint32)(data, start + 4),
    x: (0, _core_utils.readUint32)(data, start + 8),
    y: (0, _core_utils.readUint32)(data, start + 12),
    combinationOperator: data[start + 16] & 7
  };
}

const RegionSegmentInformationFieldLength = 17;

function processSegment(segment, visitor) {
  const header = segment.header;
  const data = segment.data,
        end = segment.end;
  let position = segment.start;
  let args, at, i, atLength;

  switch (header.type) {
    case 0:
      const dictionary = {};
      const dictionaryFlags = (0, _core_utils.readUint16)(data, position);
      dictionary.huffman = !!(dictionaryFlags & 1);
      dictionary.refinement = !!(dictionaryFlags & 2);
      dictionary.huffmanDHSelector = dictionaryFlags >> 2 & 3;
      dictionary.huffmanDWSelector = dictionaryFlags >> 4 & 3;
      dictionary.bitmapSizeSelector = dictionaryFlags >> 6 & 1;
      dictionary.aggregationInstancesSelector = dictionaryFlags >> 7 & 1;
      dictionary.bitmapCodingContextUsed = !!(dictionaryFlags & 256);
      dictionary.bitmapCodingContextRetained = !!(dictionaryFlags & 512);
      dictionary.template = dictionaryFlags >> 10 & 3;
      dictionary.refinementTemplate = dictionaryFlags >> 12 & 1;
      position += 2;

      if (!dictionary.huffman) {
        atLength = dictionary.template === 0 ? 4 : 1;
        at = [];

        for (i = 0; i < atLength; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        dictionary.at = at;
      }

      if (dictionary.refinement && !dictionary.refinementTemplate) {
        at = [];

        for (i = 0; i < 2; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        dictionary.refinementAt = at;
      }

      dictionary.numberOfExportedSymbols = (0, _core_utils.readUint32)(data, position);
      position += 4;
      dictionary.numberOfNewSymbols = (0, _core_utils.readUint32)(data, position);
      position += 4;
      args = [dictionary, header.number, header.referredTo, data, position, end];
      break;

    case 6:
    case 7:
      const textRegion = {};
      textRegion.info = readRegionSegmentInformation(data, position);
      position += RegionSegmentInformationFieldLength;
      const textRegionSegmentFlags = (0, _core_utils.readUint16)(data, position);
      position += 2;
      textRegion.huffman = !!(textRegionSegmentFlags & 1);
      textRegion.refinement = !!(textRegionSegmentFlags & 2);
      textRegion.logStripSize = textRegionSegmentFlags >> 2 & 3;
      textRegion.stripSize = 1 << textRegion.logStripSize;
      textRegion.referenceCorner = textRegionSegmentFlags >> 4 & 3;
      textRegion.transposed = !!(textRegionSegmentFlags & 64);
      textRegion.combinationOperator = textRegionSegmentFlags >> 7 & 3;
      textRegion.defaultPixelValue = textRegionSegmentFlags >> 9 & 1;
      textRegion.dsOffset = textRegionSegmentFlags << 17 >> 27;
      textRegion.refinementTemplate = textRegionSegmentFlags >> 15 & 1;

      if (textRegion.huffman) {
        const textRegionHuffmanFlags = (0, _core_utils.readUint16)(data, position);
        position += 2;
        textRegion.huffmanFS = textRegionHuffmanFlags & 3;
        textRegion.huffmanDS = textRegionHuffmanFlags >> 2 & 3;
        textRegion.huffmanDT = textRegionHuffmanFlags >> 4 & 3;
        textRegion.huffmanRefinementDW = textRegionHuffmanFlags >> 6 & 3;
        textRegion.huffmanRefinementDH = textRegionHuffmanFlags >> 8 & 3;
        textRegion.huffmanRefinementDX = textRegionHuffmanFlags >> 10 & 3;
        textRegion.huffmanRefinementDY = textRegionHuffmanFlags >> 12 & 3;
        textRegion.huffmanRefinementSizeSelector = !!(textRegionHuffmanFlags & 0x4000);
      }

      if (textRegion.refinement && !textRegion.refinementTemplate) {
        at = [];

        for (i = 0; i < 2; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        textRegion.refinementAt = at;
      }

      textRegion.numberOfSymbolInstances = (0, _core_utils.readUint32)(data, position);
      position += 4;
      args = [textRegion, header.referredTo, data, position, end];
      break;

    case 16:
      const patternDictionary = {};
      const patternDictionaryFlags = data[position++];
      patternDictionary.mmr = !!(patternDictionaryFlags & 1);
      patternDictionary.template = patternDictionaryFlags >> 1 & 3;
      patternDictionary.patternWidth = data[position++];
      patternDictionary.patternHeight = data[position++];
      patternDictionary.maxPatternIndex = (0, _core_utils.readUint32)(data, position);
      position += 4;
      args = [patternDictionary, header.number, data, position, end];
      break;

    case 22:
    case 23:
      const halftoneRegion = {};
      halftoneRegion.info = readRegionSegmentInformation(data, position);
      position += RegionSegmentInformationFieldLength;
      const halftoneRegionFlags = data[position++];
      halftoneRegion.mmr = !!(halftoneRegionFlags & 1);
      halftoneRegion.template = halftoneRegionFlags >> 1 & 3;
      halftoneRegion.enableSkip = !!(halftoneRegionFlags & 8);
      halftoneRegion.combinationOperator = halftoneRegionFlags >> 4 & 7;
      halftoneRegion.defaultPixelValue = halftoneRegionFlags >> 7 & 1;
      halftoneRegion.gridWidth = (0, _core_utils.readUint32)(data, position);
      position += 4;
      halftoneRegion.gridHeight = (0, _core_utils.readUint32)(data, position);
      position += 4;
      halftoneRegion.gridOffsetX = (0, _core_utils.readUint32)(data, position) & 0xffffffff;
      position += 4;
      halftoneRegion.gridOffsetY = (0, _core_utils.readUint32)(data, position) & 0xffffffff;
      position += 4;
      halftoneRegion.gridVectorX = (0, _core_utils.readUint16)(data, position);
      position += 2;
      halftoneRegion.gridVectorY = (0, _core_utils.readUint16)(data, position);
      position += 2;
      args = [halftoneRegion, header.referredTo, data, position, end];
      break;

    case 38:
    case 39:
      const genericRegion = {};
      genericRegion.info = readRegionSegmentInformation(data, position);
      position += RegionSegmentInformationFieldLength;
      const genericRegionSegmentFlags = data[position++];
      genericRegion.mmr = !!(genericRegionSegmentFlags & 1);
      genericRegion.template = genericRegionSegmentFlags >> 1 & 3;
      genericRegion.prediction = !!(genericRegionSegmentFlags & 8);

      if (!genericRegion.mmr) {
        atLength = genericRegion.template === 0 ? 4 : 1;
        at = [];

        for (i = 0; i < atLength; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        genericRegion.at = at;
      }

      args = [genericRegion, data, position, end];
      break;

    case 48:
      const pageInfo = {
        width: (0, _core_utils.readUint32)(data, position),
        height: (0, _core_utils.readUint32)(data, position + 4),
        resolutionX: (0, _core_utils.readUint32)(data, position + 8),
        resolutionY: (0, _core_utils.readUint32)(data, position + 12)
      };

      if (pageInfo.height === 0xffffffff) {
        delete pageInfo.height;
      }

      const pageSegmentFlags = data[position + 16];
      (0, _core_utils.readUint16)(data, position + 17);
      pageInfo.lossless = !!(pageSegmentFlags & 1);
      pageInfo.refinement = !!(pageSegmentFlags & 2);
      pageInfo.defaultPixelValue = pageSegmentFlags >> 2 & 1;
      pageInfo.combinationOperator = pageSegmentFlags >> 3 & 3;
      pageInfo.requiresBuffer = !!(pageSegmentFlags & 32);
      pageInfo.combinationOperatorOverride = !!(pageSegmentFlags & 64);
      args = [pageInfo];
      break;

    case 49:
      break;

    case 50:
      break;

    case 51:
      break;

    case 53:
      args = [header.number, data, position, end];
      break;

    case 62:
      break;

    default:
      throw new Jbig2Error(`segment type ${header.typeName}(${header.type})` + " is not implemented");
  }

  const callbackName = "on" + header.typeName;

  if (callbackName in visitor) {
    visitor[callbackName].apply(visitor, args);
  }
}

function processSegments(segments, visitor) {
  for (let i = 0, ii = segments.length; i < ii; i++) {
    processSegment(segments[i], visitor);
  }
}

function parseJbig2Chunks(chunks) {
  const visitor = new SimpleSegmentVisitor();

  for (let i = 0, ii = chunks.length; i < ii; i++) {
    const chunk = chunks[i];
    const segments = readSegments({}, chunk.data, chunk.start, chunk.end);
    processSegments(segments, visitor);
  }

  return visitor.buffer;
}

function parseJbig2(data) {
  const end = data.length;
  let position = 0;

  if (data[position] !== 0x97 || data[position + 1] !== 0x4a || data[position + 2] !== 0x42 || data[position + 3] !== 0x32 || data[position + 4] !== 0x0d || data[position + 5] !== 0x0a || data[position + 6] !== 0x1a || data[position + 7] !== 0x0a) {
    throw new Jbig2Error("parseJbig2 - invalid header.");
  }

  const header = Object.create(null);
  position += 8;
  const flags = data[position++];
  header.randomAccess = !(flags & 1);

  if (!(flags & 2)) {
    header.numberOfPages = (0, _core_utils.readUint32)(data, position);
    position += 4;
  }

  const segments = readSegments(header, data, position, end);
  const visitor = new SimpleSegmentVisitor();
  processSegments(segments, visitor);
  const {
    width,
    height
  } = visitor.currentPageInfo;
  const bitPacked = visitor.buffer;
  const imgData = new Uint8ClampedArray(width * height);
  let q = 0,
      k = 0;

  for (let i = 0; i < height; i++) {
    let mask = 0,
        buffer;

    for (let j = 0; j < width; j++) {
      if (!mask) {
        mask = 128;
        buffer = bitPacked[k++];
      }

      imgData[q++] = buffer & mask ? 0 : 255;
      mask >>= 1;
    }
  }

  return {
    imgData,
    width,
    height
  };
}

class SimpleSegmentVisitor {
  onPageInformation(info) {
    this.currentPageInfo = info;
    const rowSize = info.width + 7 >> 3;
    const buffer = new Uint8ClampedArray(rowSize * info.height);

    if (info.defaultPixelValue) {
      for (let i = 0, ii = buffer.length; i < ii; i++) {
        buffer[i] = 0xff;
      }
    }

    this.buffer = buffer;
  }

  drawBitmap(regionInfo, bitmap) {
    const pageInfo = this.currentPageInfo;
    const width = regionInfo.width,
          height = regionInfo.height;
    const rowSize = pageInfo.width + 7 >> 3;
    const combinationOperator = pageInfo.combinationOperatorOverride ? regionInfo.combinationOperator : pageInfo.combinationOperator;
    const buffer = this.buffer;
    const mask0 = 128 >> (regionInfo.x & 7);
    let offset0 = regionInfo.y * rowSize + (regionInfo.x >> 3);
    let i, j, mask, offset;

    switch (combinationOperator) {
      case 0:
        for (i = 0; i < height; i++) {
          mask = mask0;
          offset = offset0;

          for (j = 0; j < width; j++) {
            if (bitmap[i][j]) {
              buffer[offset] |= mask;
            }

            mask >>= 1;

            if (!mask) {
              mask = 128;
              offset++;
            }
          }

          offset0 += rowSize;
        }

        break;

      case 2:
        for (i = 0; i < height; i++) {
          mask = mask0;
          offset = offset0;

          for (j = 0; j < width; j++) {
            if (bitmap[i][j]) {
              buffer[offset] ^= mask;
            }

            mask >>= 1;

            if (!mask) {
              mask = 128;
              offset++;
            }
          }

          offset0 += rowSize;
        }

        break;

      default:
        throw new Jbig2Error(`operator ${combinationOperator} is not supported`);
    }
  }

  onImmediateGenericRegion(region, data, start, end) {
    const regionInfo = region.info;
    const decodingContext = new DecodingContext(data, start, end);
    const bitmap = decodeBitmap(region.mmr, regionInfo.width, regionInfo.height, region.template, region.prediction, null, region.at, decodingContext);
    this.drawBitmap(regionInfo, bitmap);
  }

  onImmediateLosslessGenericRegion() {
    this.onImmediateGenericRegion.apply(this, arguments);
  }

  onSymbolDictionary(dictionary, currentSegment, referredSegments, data, start, end) {
    let huffmanTables, huffmanInput;

    if (dictionary.huffman) {
      huffmanTables = getSymbolDictionaryHuffmanTables(dictionary, referredSegments, this.customTables);
      huffmanInput = new Reader(data, start, end);
    }

    let symbols = this.symbols;

    if (!symbols) {
      this.symbols = symbols = {};
    }

    let inputSymbols = [];

    for (let i = 0, ii = referredSegments.length; i < ii; i++) {
      const referredSymbols = symbols[referredSegments[i]];

      if (referredSymbols) {
        inputSymbols = inputSymbols.concat(referredSymbols);
      }
    }

    const decodingContext = new DecodingContext(data, start, end);
    symbols[currentSegment] = decodeSymbolDictionary(dictionary.huffman, dictionary.refinement, inputSymbols, dictionary.numberOfNewSymbols, dictionary.numberOfExportedSymbols, huffmanTables, dictionary.template, dictionary.at, dictionary.refinementTemplate, dictionary.refinementAt, decodingContext, huffmanInput);
  }

  onImmediateTextRegion(region, referredSegments, data, start, end) {
    const regionInfo = region.info;
    let huffmanTables, huffmanInput;
    const symbols = this.symbols;
    let inputSymbols = [];

    for (let i = 0, ii = referredSegments.length; i < ii; i++) {
      const referredSymbols = symbols[referredSegments[i]];

      if (referredSymbols) {
        inputSymbols = inputSymbols.concat(referredSymbols);
      }
    }

    const symbolCodeLength = (0, _core_utils.log2)(inputSymbols.length);

    if (region.huffman) {
      huffmanInput = new Reader(data, start, end);
      huffmanTables = getTextRegionHuffmanTables(region, referredSegments, this.customTables, inputSymbols.length, huffmanInput);
    }

    const decodingContext = new DecodingContext(data, start, end);
    const bitmap = decodeTextRegion(region.huffman, region.refinement, regionInfo.width, regionInfo.height, region.defaultPixelValue, region.numberOfSymbolInstances, region.stripSize, inputSymbols, symbolCodeLength, region.transposed, region.dsOffset, region.referenceCorner, region.combinationOperator, huffmanTables, region.refinementTemplate, region.refinementAt, decodingContext, region.logStripSize, huffmanInput);
    this.drawBitmap(regionInfo, bitmap);
  }

  onImmediateLosslessTextRegion() {
    this.onImmediateTextRegion.apply(this, arguments);
  }

  onPatternDictionary(dictionary, currentSegment, data, start, end) {
    let patterns = this.patterns;

    if (!patterns) {
      this.patterns = patterns = {};
    }

    const decodingContext = new DecodingContext(data, start, end);
    patterns[currentSegment] = decodePatternDictionary(dictionary.mmr, dictionary.patternWidth, dictionary.patternHeight, dictionary.maxPatternIndex, dictionary.template, decodingContext);
  }

  onImmediateHalftoneRegion(region, referredSegments, data, start, end) {
    const patterns = this.patterns[referredSegments[0]];
    const regionInfo = region.info;
    const decodingContext = new DecodingContext(data, start, end);
    const bitmap = decodeHalftoneRegion(region.mmr, patterns, region.template, regionInfo.width, regionInfo.height, region.defaultPixelValue, region.enableSkip, region.combinationOperator, region.gridWidth, region.gridHeight, region.gridOffsetX, region.gridOffsetY, region.gridVectorX, region.gridVectorY, decodingContext);
    this.drawBitmap(regionInfo, bitmap);
  }

  onImmediateLosslessHalftoneRegion() {
    this.onImmediateHalftoneRegion.apply(this, arguments);
  }

  onTables(currentSegment, data, start, end) {
    let customTables = this.customTables;

    if (!customTables) {
      this.customTables = customTables = {};
    }

    customTables[currentSegment] = decodeTablesSegment(data, start, end);
  }

}

class HuffmanLine {
  constructor(lineData) {
    if (lineData.length === 2) {
      this.isOOB = true;
      this.rangeLow = 0;
      this.prefixLength = lineData[0];
      this.rangeLength = 0;
      this.prefixCode = lineData[1];
      this.isLowerRange = false;
    } else {
      this.isOOB = false;
      this.rangeLow = lineData[0];
      this.prefixLength = lineData[1];
      this.rangeLength = lineData[2];
      this.prefixCode = lineData[3];
      this.isLowerRange = lineData[4] === "lower";
    }
  }

}

class HuffmanTreeNode {
  constructor(line) {
    this.children = [];

    if (line) {
      this.isLeaf = true;
      this.rangeLength = line.rangeLength;
      this.rangeLow = line.rangeLow;
      this.isLowerRange = line.isLowerRange;
      this.isOOB = line.isOOB;
    } else {
      this.isLeaf = false;
    }
  }

  buildTree(line, shift) {
    const bit = line.prefixCode >> shift & 1;

    if (shift <= 0) {
      this.children[bit] = new HuffmanTreeNode(line);
    } else {
      let node = this.children[bit];

      if (!node) {
        this.children[bit] = node = new HuffmanTreeNode(null);
      }

      node.buildTree(line, shift - 1);
    }
  }

  decodeNode(reader) {
    if (this.isLeaf) {
      if (this.isOOB) {
        return null;
      }

      const htOffset = reader.readBits(this.rangeLength);
      return this.rangeLow + (this.isLowerRange ? -htOffset : htOffset);
    }

    const node = this.children[reader.readBit()];

    if (!node) {
      throw new Jbig2Error("invalid Huffman data");
    }

    return node.decodeNode(reader);
  }

}

class HuffmanTable {
  constructor(lines, prefixCodesDone) {
    if (!prefixCodesDone) {
      this.assignPrefixCodes(lines);
    }

    this.rootNode = new HuffmanTreeNode(null);

    for (let i = 0, ii = lines.length; i < ii; i++) {
      const line = lines[i];

      if (line.prefixLength > 0) {
        this.rootNode.buildTree(line, line.prefixLength - 1);
      }
    }
  }

  decode(reader) {
    return this.rootNode.decodeNode(reader);
  }

  assignPrefixCodes(lines) {
    const linesLength = lines.length;
    let prefixLengthMax = 0;

    for (let i = 0; i < linesLength; i++) {
      prefixLengthMax = Math.max(prefixLengthMax, lines[i].prefixLength);
    }

    const histogram = new Uint32Array(prefixLengthMax + 1);

    for (let i = 0; i < linesLength; i++) {
      histogram[lines[i].prefixLength]++;
    }

    let currentLength = 1,
        firstCode = 0,
        currentCode,
        currentTemp,
        line;
    histogram[0] = 0;

    while (currentLength <= prefixLengthMax) {
      firstCode = firstCode + histogram[currentLength - 1] << 1;
      currentCode = firstCode;
      currentTemp = 0;

      while (currentTemp < linesLength) {
        line = lines[currentTemp];

        if (line.prefixLength === currentLength) {
          line.prefixCode = currentCode;
          currentCode++;
        }

        currentTemp++;
      }

      currentLength++;
    }
  }

}

function decodeTablesSegment(data, start, end) {
  const flags = data[start];
  const lowestValue = (0, _core_utils.readUint32)(data, start + 1) & 0xffffffff;
  const highestValue = (0, _core_utils.readUint32)(data, start + 5) & 0xffffffff;
  const reader = new Reader(data, start + 9, end);
  const prefixSizeBits = (flags >> 1 & 7) + 1;
  const rangeSizeBits = (flags >> 4 & 7) + 1;
  const lines = [];
  let prefixLength,
      rangeLength,
      currentRangeLow = lowestValue;

  do {
    prefixLength = reader.readBits(prefixSizeBits);
    rangeLength = reader.readBits(rangeSizeBits);
    lines.push(new HuffmanLine([currentRangeLow, prefixLength, rangeLength, 0]));
    currentRangeLow += 1 << rangeLength;
  } while (currentRangeLow < highestValue);

  prefixLength = reader.readBits(prefixSizeBits);
  lines.push(new HuffmanLine([lowestValue - 1, prefixLength, 32, 0, "lower"]));
  prefixLength = reader.readBits(prefixSizeBits);
  lines.push(new HuffmanLine([highestValue, prefixLength, 32, 0]));

  if (flags & 1) {
    prefixLength = reader.readBits(prefixSizeBits);
    lines.push(new HuffmanLine([prefixLength, 0]));
  }

  return new HuffmanTable(lines, false);
}

const standardTablesCache = {};

function getStandardTable(number) {
  let table = standardTablesCache[number];

  if (table) {
    return table;
  }

  let lines;

  switch (number) {
    case 1:
      lines = [[0, 1, 4, 0x0], [16, 2, 8, 0x2], [272, 3, 16, 0x6], [65808, 3, 32, 0x7]];
      break;

    case 2:
      lines = [[0, 1, 0, 0x0], [1, 2, 0, 0x2], [2, 3, 0, 0x6], [3, 4, 3, 0xe], [11, 5, 6, 0x1e], [75, 6, 32, 0x3e], [6, 0x3f]];
      break;

    case 3:
      lines = [[-256, 8, 8, 0xfe], [0, 1, 0, 0x0], [1, 2, 0, 0x2], [2, 3, 0, 0x6], [3, 4, 3, 0xe], [11, 5, 6, 0x1e], [-257, 8, 32, 0xff, "lower"], [75, 7, 32, 0x7e], [6, 0x3e]];
      break;

    case 4:
      lines = [[1, 1, 0, 0x0], [2, 2, 0, 0x2], [3, 3, 0, 0x6], [4, 4, 3, 0xe], [12, 5, 6, 0x1e], [76, 5, 32, 0x1f]];
      break;

    case 5:
      lines = [[-255, 7, 8, 0x7e], [1, 1, 0, 0x0], [2, 2, 0, 0x2], [3, 3, 0, 0x6], [4, 4, 3, 0xe], [12, 5, 6, 0x1e], [-256, 7, 32, 0x7f, "lower"], [76, 6, 32, 0x3e]];
      break;

    case 6:
      lines = [[-2048, 5, 10, 0x1c], [-1024, 4, 9, 0x8], [-512, 4, 8, 0x9], [-256, 4, 7, 0xa], [-128, 5, 6, 0x1d], [-64, 5, 5, 0x1e], [-32, 4, 5, 0xb], [0, 2, 7, 0x0], [128, 3, 7, 0x2], [256, 3, 8, 0x3], [512, 4, 9, 0xc], [1024, 4, 10, 0xd], [-2049, 6, 32, 0x3e, "lower"], [2048, 6, 32, 0x3f]];
      break;

    case 7:
      lines = [[-1024, 4, 9, 0x8], [-512, 3, 8, 0x0], [-256, 4, 7, 0x9], [-128, 5, 6, 0x1a], [-64, 5, 5, 0x1b], [-32, 4, 5, 0xa], [0, 4, 5, 0xb], [32, 5, 5, 0x1c], [64, 5, 6, 0x1d], [128, 4, 7, 0xc], [256, 3, 8, 0x1], [512, 3, 9, 0x2], [1024, 3, 10, 0x3], [-1025, 5, 32, 0x1e, "lower"], [2048, 5, 32, 0x1f]];
      break;

    case 8:
      lines = [[-15, 8, 3, 0xfc], [-7, 9, 1, 0x1fc], [-5, 8, 1, 0xfd], [-3, 9, 0, 0x1fd], [-2, 7, 0, 0x7c], [-1, 4, 0, 0xa], [0, 2, 1, 0x0], [2, 5, 0, 0x1a], [3, 6, 0, 0x3a], [4, 3, 4, 0x4], [20, 6, 1, 0x3b], [22, 4, 4, 0xb], [38, 4, 5, 0xc], [70, 5, 6, 0x1b], [134, 5, 7, 0x1c], [262, 6, 7, 0x3c], [390, 7, 8, 0x7d], [646, 6, 10, 0x3d], [-16, 9, 32, 0x1fe, "lower"], [1670, 9, 32, 0x1ff], [2, 0x1]];
      break;

    case 9:
      lines = [[-31, 8, 4, 0xfc], [-15, 9, 2, 0x1fc], [-11, 8, 2, 0xfd], [-7, 9, 1, 0x1fd], [-5, 7, 1, 0x7c], [-3, 4, 1, 0xa], [-1, 3, 1, 0x2], [1, 3, 1, 0x3], [3, 5, 1, 0x1a], [5, 6, 1, 0x3a], [7, 3, 5, 0x4], [39, 6, 2, 0x3b], [43, 4, 5, 0xb], [75, 4, 6, 0xc], [139, 5, 7, 0x1b], [267, 5, 8, 0x1c], [523, 6, 8, 0x3c], [779, 7, 9, 0x7d], [1291, 6, 11, 0x3d], [-32, 9, 32, 0x1fe, "lower"], [3339, 9, 32, 0x1ff], [2, 0x0]];
      break;

    case 10:
      lines = [[-21, 7, 4, 0x7a], [-5, 8, 0, 0xfc], [-4, 7, 0, 0x7b], [-3, 5, 0, 0x18], [-2, 2, 2, 0x0], [2, 5, 0, 0x19], [3, 6, 0, 0x36], [4, 7, 0, 0x7c], [5, 8, 0, 0xfd], [6, 2, 6, 0x1], [70, 5, 5, 0x1a], [102, 6, 5, 0x37], [134, 6, 6, 0x38], [198, 6, 7, 0x39], [326, 6, 8, 0x3a], [582, 6, 9, 0x3b], [1094, 6, 10, 0x3c], [2118, 7, 11, 0x7d], [-22, 8, 32, 0xfe, "lower"], [4166, 8, 32, 0xff], [2, 0x2]];
      break;

    case 11:
      lines = [[1, 1, 0, 0x0], [2, 2, 1, 0x2], [4, 4, 0, 0xc], [5, 4, 1, 0xd], [7, 5, 1, 0x1c], [9, 5, 2, 0x1d], [13, 6, 2, 0x3c], [17, 7, 2, 0x7a], [21, 7, 3, 0x7b], [29, 7, 4, 0x7c], [45, 7, 5, 0x7d], [77, 7, 6, 0x7e], [141, 7, 32, 0x7f]];
      break;

    case 12:
      lines = [[1, 1, 0, 0x0], [2, 2, 0, 0x2], [3, 3, 1, 0x6], [5, 5, 0, 0x1c], [6, 5, 1, 0x1d], [8, 6, 1, 0x3c], [10, 7, 0, 0x7a], [11, 7, 1, 0x7b], [13, 7, 2, 0x7c], [17, 7, 3, 0x7d], [25, 7, 4, 0x7e], [41, 8, 5, 0xfe], [73, 8, 32, 0xff]];
      break;

    case 13:
      lines = [[1, 1, 0, 0x0], [2, 3, 0, 0x4], [3, 4, 0, 0xc], [4, 5, 0, 0x1c], [5, 4, 1, 0xd], [7, 3, 3, 0x5], [15, 6, 1, 0x3a], [17, 6, 2, 0x3b], [21, 6, 3, 0x3c], [29, 6, 4, 0x3d], [45, 6, 5, 0x3e], [77, 7, 6, 0x7e], [141, 7, 32, 0x7f]];
      break;

    case 14:
      lines = [[-2, 3, 0, 0x4], [-1, 3, 0, 0x5], [0, 1, 0, 0x0], [1, 3, 0, 0x6], [2, 3, 0, 0x7]];
      break;

    case 15:
      lines = [[-24, 7, 4, 0x7c], [-8, 6, 2, 0x3c], [-4, 5, 1, 0x1c], [-2, 4, 0, 0xc], [-1, 3, 0, 0x4], [0, 1, 0, 0x0], [1, 3, 0, 0x5], [2, 4, 0, 0xd], [3, 5, 1, 0x1d], [5, 6, 2, 0x3d], [9, 7, 4, 0x7d], [-25, 7, 32, 0x7e, "lower"], [25, 7, 32, 0x7f]];
      break;

    default:
      throw new Jbig2Error(`standard table B.${number} does not exist`);
  }

  for (let i = 0, ii = lines.length; i < ii; i++) {
    lines[i] = new HuffmanLine(lines[i]);
  }

  table = new HuffmanTable(lines, true);
  standardTablesCache[number] = table;
  return table;
}

class Reader {
  constructor(data, start, end) {
    this.data = data;
    this.start = start;
    this.end = end;
    this.position = start;
    this.shift = -1;
    this.currentByte = 0;
  }

  readBit() {
    if (this.shift < 0) {
      if (this.position >= this.end) {
        throw new Jbig2Error("end of data while reading bit");
      }

      this.currentByte = this.data[this.position++];
      this.shift = 7;
    }

    const bit = this.currentByte >> this.shift & 1;
    this.shift--;
    return bit;
  }

  readBits(numBits) {
    let result = 0,
        i;

    for (i = numBits - 1; i >= 0; i--) {
      result |= this.readBit() << i;
    }

    return result;
  }

  byteAlign() {
    this.shift = -1;
  }

  next() {
    if (this.position >= this.end) {
      return -1;
    }

    return this.data[this.position++];
  }

}

function getCustomHuffmanTable(index, referredTo, customTables) {
  let currentIndex = 0;

  for (let i = 0, ii = referredTo.length; i < ii; i++) {
    const table = customTables[referredTo[i]];

    if (table) {
      if (index === currentIndex) {
        return table;
      }

      currentIndex++;
    }
  }

  throw new Jbig2Error("can't find custom Huffman table");
}

function getTextRegionHuffmanTables(textRegion, referredTo, customTables, numberOfSymbols, reader) {
  const codes = [];

  for (let i = 0; i <= 34; i++) {
    const codeLength = reader.readBits(4);
    codes.push(new HuffmanLine([i, codeLength, 0, 0]));
  }

  const runCodesTable = new HuffmanTable(codes, false);
  codes.length = 0;

  for (let i = 0; i < numberOfSymbols;) {
    const codeLength = runCodesTable.decode(reader);

    if (codeLength >= 32) {
      let repeatedLength, numberOfRepeats, j;

      switch (codeLength) {
        case 32:
          if (i === 0) {
            throw new Jbig2Error("no previous value in symbol ID table");
          }

          numberOfRepeats = reader.readBits(2) + 3;
          repeatedLength = codes[i - 1].prefixLength;
          break;

        case 33:
          numberOfRepeats = reader.readBits(3) + 3;
          repeatedLength = 0;
          break;

        case 34:
          numberOfRepeats = reader.readBits(7) + 11;
          repeatedLength = 0;
          break;

        default:
          throw new Jbig2Error("invalid code length in symbol ID table");
      }

      for (j = 0; j < numberOfRepeats; j++) {
        codes.push(new HuffmanLine([i, repeatedLength, 0, 0]));
        i++;
      }
    } else {
      codes.push(new HuffmanLine([i, codeLength, 0, 0]));
      i++;
    }
  }

  reader.byteAlign();
  const symbolIDTable = new HuffmanTable(codes, false);
  let customIndex = 0,
      tableFirstS,
      tableDeltaS,
      tableDeltaT;

  switch (textRegion.huffmanFS) {
    case 0:
    case 1:
      tableFirstS = getStandardTable(textRegion.huffmanFS + 6);
      break;

    case 3:
      tableFirstS = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman FS selector");
  }

  switch (textRegion.huffmanDS) {
    case 0:
    case 1:
    case 2:
      tableDeltaS = getStandardTable(textRegion.huffmanDS + 8);
      break;

    case 3:
      tableDeltaS = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DS selector");
  }

  switch (textRegion.huffmanDT) {
    case 0:
    case 1:
    case 2:
      tableDeltaT = getStandardTable(textRegion.huffmanDT + 11);
      break;

    case 3:
      tableDeltaT = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DT selector");
  }

  if (textRegion.refinement) {
    throw new Jbig2Error("refinement with Huffman is not supported");
  }

  return {
    symbolIDTable,
    tableFirstS,
    tableDeltaS,
    tableDeltaT
  };
}

function getSymbolDictionaryHuffmanTables(dictionary, referredTo, customTables) {
  let customIndex = 0,
      tableDeltaHeight,
      tableDeltaWidth;

  switch (dictionary.huffmanDHSelector) {
    case 0:
    case 1:
      tableDeltaHeight = getStandardTable(dictionary.huffmanDHSelector + 4);
      break;

    case 3:
      tableDeltaHeight = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DH selector");
  }

  switch (dictionary.huffmanDWSelector) {
    case 0:
    case 1:
      tableDeltaWidth = getStandardTable(dictionary.huffmanDWSelector + 2);
      break;

    case 3:
      tableDeltaWidth = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DW selector");
  }

  let tableBitmapSize, tableAggregateInstances;

  if (dictionary.bitmapSizeSelector) {
    tableBitmapSize = getCustomHuffmanTable(customIndex, referredTo, customTables);
    customIndex++;
  } else {
    tableBitmapSize = getStandardTable(1);
  }

  if (dictionary.aggregationInstancesSelector) {
    tableAggregateInstances = getCustomHuffmanTable(customIndex, referredTo, customTables);
  } else {
    tableAggregateInstances = getStandardTable(1);
  }

  return {
    tableDeltaHeight,
    tableDeltaWidth,
    tableBitmapSize,
    tableAggregateInstances
  };
}

function readUncompressedBitmap(reader, width, height) {
  const bitmap = [];

  for (let y = 0; y < height; y++) {
    const row = new Uint8Array(width);
    bitmap.push(row);

    for (let x = 0; x < width; x++) {
      row[x] = reader.readBit();
    }

    reader.byteAlign();
  }

  return bitmap;
}

function decodeMMRBitmap(input, width, height, endOfBlock) {
  const params = {
    K: -1,
    Columns: width,
    Rows: height,
    BlackIs1: true,
    EndOfBlock: endOfBlock
  };
  const decoder = new _ccitt.CCITTFaxDecoder(input, params);
  const bitmap = [];
  let currentByte,
      eof = false;

  for (let y = 0; y < height; y++) {
    const row = new Uint8Array(width);
    bitmap.push(row);
    let shift = -1;

    for (let x = 0; x < width; x++) {
      if (shift < 0) {
        currentByte = decoder.readNextChar();

        if (currentByte === -1) {
          currentByte = 0;
          eof = true;
        }

        shift = 7;
      }

      row[x] = currentByte >> shift & 1;
      shift--;
    }
  }

  if (endOfBlock && !eof) {
    const lookForEOFLimit = 5;

    for (let i = 0; i < lookForEOFLimit; i++) {
      if (decoder.readNextChar() === -1) {
        break;
      }
    }
  }

  return bitmap;
}

class Jbig2Image {
  parseChunks(chunks) {
    return parseJbig2Chunks(chunks);
  }

  parse(data) {
    const {
      imgData,
      width,
      height
    } = parseJbig2(data);
    this.width = width;
    this.height = height;
    return imgData;
  }

}

exports.Jbig2Image = Jbig2Image;

/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ArithmeticDecoder = void 0;
const QeTable = [{
  qe: 0x5601,
  nmps: 1,
  nlps: 1,
  switchFlag: 1
}, {
  qe: 0x3401,
  nmps: 2,
  nlps: 6,
  switchFlag: 0
}, {
  qe: 0x1801,
  nmps: 3,
  nlps: 9,
  switchFlag: 0
}, {
  qe: 0x0ac1,
  nmps: 4,
  nlps: 12,
  switchFlag: 0
}, {
  qe: 0x0521,
  nmps: 5,
  nlps: 29,
  switchFlag: 0
}, {
  qe: 0x0221,
  nmps: 38,
  nlps: 33,
  switchFlag: 0
}, {
  qe: 0x5601,
  nmps: 7,
  nlps: 6,
  switchFlag: 1
}, {
  qe: 0x5401,
  nmps: 8,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x4801,
  nmps: 9,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x3801,
  nmps: 10,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x3001,
  nmps: 11,
  nlps: 17,
  switchFlag: 0
}, {
  qe: 0x2401,
  nmps: 12,
  nlps: 18,
  switchFlag: 0
}, {
  qe: 0x1c01,
  nmps: 13,
  nlps: 20,
  switchFlag: 0
}, {
  qe: 0x1601,
  nmps: 29,
  nlps: 21,
  switchFlag: 0
}, {
  qe: 0x5601,
  nmps: 15,
  nlps: 14,
  switchFlag: 1
}, {
  qe: 0x5401,
  nmps: 16,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x5101,
  nmps: 17,
  nlps: 15,
  switchFlag: 0
}, {
  qe: 0x4801,
  nmps: 18,
  nlps: 16,
  switchFlag: 0
}, {
  qe: 0x3801,
  nmps: 19,
  nlps: 17,
  switchFlag: 0
}, {
  qe: 0x3401,
  nmps: 20,
  nlps: 18,
  switchFlag: 0
}, {
  qe: 0x3001,
  nmps: 21,
  nlps: 19,
  switchFlag: 0
}, {
  qe: 0x2801,
  nmps: 22,
  nlps: 19,
  switchFlag: 0
}, {
  qe: 0x2401,
  nmps: 23,
  nlps: 20,
  switchFlag: 0
}, {
  qe: 0x2201,
  nmps: 24,
  nlps: 21,
  switchFlag: 0
}, {
  qe: 0x1c01,
  nmps: 25,
  nlps: 22,
  switchFlag: 0
}, {
  qe: 0x1801,
  nmps: 26,
  nlps: 23,
  switchFlag: 0
}, {
  qe: 0x1601,
  nmps: 27,
  nlps: 24,
  switchFlag: 0
}, {
  qe: 0x1401,
  nmps: 28,
  nlps: 25,
  switchFlag: 0
}, {
  qe: 0x1201,
  nmps: 29,
  nlps: 26,
  switchFlag: 0
}, {
  qe: 0x1101,
  nmps: 30,
  nlps: 27,
  switchFlag: 0
}, {
  qe: 0x0ac1,
  nmps: 31,
  nlps: 28,
  switchFlag: 0
}, {
  qe: 0x09c1,
  nmps: 32,
  nlps: 29,
  switchFlag: 0
}, {
  qe: 0x08a1,
  nmps: 33,
  nlps: 30,
  switchFlag: 0
}, {
  qe: 0x0521,
  nmps: 34,
  nlps: 31,
  switchFlag: 0
}, {
  qe: 0x0441,
  nmps: 35,
  nlps: 32,
  switchFlag: 0
}, {
  qe: 0x02a1,
  nmps: 36,
  nlps: 33,
  switchFlag: 0
}, {
  qe: 0x0221,
  nmps: 37,
  nlps: 34,
  switchFlag: 0
}, {
  qe: 0x0141,
  nmps: 38,
  nlps: 35,
  switchFlag: 0
}, {
  qe: 0x0111,
  nmps: 39,
  nlps: 36,
  switchFlag: 0
}, {
  qe: 0x0085,
  nmps: 40,
  nlps: 37,
  switchFlag: 0
}, {
  qe: 0x0049,
  nmps: 41,
  nlps: 38,
  switchFlag: 0
}, {
  qe: 0x0025,
  nmps: 42,
  nlps: 39,
  switchFlag: 0
}, {
  qe: 0x0015,
  nmps: 43,
  nlps: 40,
  switchFlag: 0
}, {
  qe: 0x0009,
  nmps: 44,
  nlps: 41,
  switchFlag: 0
}, {
  qe: 0x0005,
  nmps: 45,
  nlps: 42,
  switchFlag: 0
}, {
  qe: 0x0001,
  nmps: 45,
  nlps: 43,
  switchFlag: 0
}, {
  qe: 0x5601,
  nmps: 46,
  nlps: 46,
  switchFlag: 0
}];

class ArithmeticDecoder {
  constructor(data, start, end) {
    this.data = data;
    this.bp = start;
    this.dataEnd = end;
    this.chigh = data[start];
    this.clow = 0;
    this.byteIn();
    this.chigh = this.chigh << 7 & 0xffff | this.clow >> 9 & 0x7f;
    this.clow = this.clow << 7 & 0xffff;
    this.ct -= 7;
    this.a = 0x8000;
  }

  byteIn() {
    const data = this.data;
    let bp = this.bp;

    if (data[bp] === 0xff) {
      if (data[bp + 1] > 0x8f) {
        this.clow += 0xff00;
        this.ct = 8;
      } else {
        bp++;
        this.clow += data[bp] << 9;
        this.ct = 7;
        this.bp = bp;
      }
    } else {
      bp++;
      this.clow += bp < this.dataEnd ? data[bp] << 8 : 0xff00;
      this.ct = 8;
      this.bp = bp;
    }

    if (this.clow > 0xffff) {
      this.chigh += this.clow >> 16;
      this.clow &= 0xffff;
    }
  }

  readBit(contexts, pos) {
    let cx_index = contexts[pos] >> 1,
        cx_mps = contexts[pos] & 1;
    const qeTableIcx = QeTable[cx_index];
    const qeIcx = qeTableIcx.qe;
    let d;
    let a = this.a - qeIcx;

    if (this.chigh < qeIcx) {
      if (a < qeIcx) {
        a = qeIcx;
        d = cx_mps;
        cx_index = qeTableIcx.nmps;
      } else {
        a = qeIcx;
        d = 1 ^ cx_mps;

        if (qeTableIcx.switchFlag === 1) {
          cx_mps = d;
        }

        cx_index = qeTableIcx.nlps;
      }
    } else {
      this.chigh -= qeIcx;

      if ((a & 0x8000) !== 0) {
        this.a = a;
        return cx_mps;
      }

      if (a < qeIcx) {
        d = 1 ^ cx_mps;

        if (qeTableIcx.switchFlag === 1) {
          cx_mps = d;
        }

        cx_index = qeTableIcx.nlps;
      } else {
        d = cx_mps;
        cx_index = qeTableIcx.nmps;
      }
    }

    do {
      if (this.ct === 0) {
        this.byteIn();
      }

      a <<= 1;
      this.chigh = this.chigh << 1 & 0xffff | this.clow >> 15 & 1;
      this.clow = this.clow << 1 & 0xffff;
      this.ct--;
    } while ((a & 0x8000) === 0);

    this.a = a;
    contexts[pos] = cx_index << 1 | cx_mps;
    return d;
  }

}

exports.ArithmeticDecoder = ArithmeticDecoder;

/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JpegStream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

var _primitives = __w_pdfjs_require__(5);

var _jpg = __w_pdfjs_require__(38);

var _util = __w_pdfjs_require__(2);

class JpegStream extends _decode_stream.DecodeStream {
  constructor(stream, maybeLength, params) {
    let ch;

    while ((ch = stream.getByte()) !== -1) {
      if (ch === 0xff) {
        stream.skip(-1);
        break;
      }
    }

    super(maybeLength);
    this.stream = stream;
    this.dict = stream.dict;
    this.maybeLength = maybeLength;
    this.params = params;
  }

  get bytes() {
    return (0, _util.shadow)(this, "bytes", this.stream.getBytes(this.maybeLength));
  }

  ensureBuffer(requested) {}

  readBlock() {
    if (this.eof) {
      return;
    }

    const jpegOptions = {
      decodeTransform: undefined,
      colorTransform: undefined
    };
    const decodeArr = this.dict.getArray("D", "Decode");

    if (this.forceRGB && Array.isArray(decodeArr)) {
      const bitsPerComponent = this.dict.get("BPC", "BitsPerComponent") || 8;
      const decodeArrLength = decodeArr.length;
      const transform = new Int32Array(decodeArrLength);
      let transformNeeded = false;
      const maxValue = (1 << bitsPerComponent) - 1;

      for (let i = 0; i < decodeArrLength; i += 2) {
        transform[i] = (decodeArr[i + 1] - decodeArr[i]) * 256 | 0;
        transform[i + 1] = decodeArr[i] * maxValue | 0;

        if (transform[i] !== 256 || transform[i + 1] !== 0) {
          transformNeeded = true;
        }
      }

      if (transformNeeded) {
        jpegOptions.decodeTransform = transform;
      }
    }

    if ((0, _primitives.isDict)(this.params)) {
      const colorTransform = this.params.get("ColorTransform");

      if (Number.isInteger(colorTransform)) {
        jpegOptions.colorTransform = colorTransform;
      }
    }

    const jpegImage = new _jpg.JpegImage(jpegOptions);
    jpegImage.parse(this.bytes);
    const data = jpegImage.getData({
      width: this.drawWidth,
      height: this.drawHeight,
      forceRGB: this.forceRGB,
      isSourcePDF: true
    });
    this.buffer = data;
    this.bufferLength = data.length;
    this.eof = true;
  }

}

exports.JpegStream = JpegStream;

/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JpegImage = void 0;

var _util = __w_pdfjs_require__(2);

var _core_utils = __w_pdfjs_require__(9);

class JpegError extends _util.BaseException {
  constructor(msg) {
    super(`JPEG error: ${msg}`, "JpegError");
  }

}

class DNLMarkerError extends _util.BaseException {
  constructor(message, scanLines) {
    super(message, "DNLMarkerError");
    this.scanLines = scanLines;
  }

}

class EOIMarkerError extends _util.BaseException {
  constructor(msg) {
    super(msg, "EOIMarkerError");
  }

}

const dctZigZag = new Uint8Array([0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63]);
const dctCos1 = 4017;
const dctSin1 = 799;
const dctCos3 = 3406;
const dctSin3 = 2276;
const dctCos6 = 1567;
const dctSin6 = 3784;
const dctSqrt2 = 5793;
const dctSqrt1d2 = 2896;

function buildHuffmanTable(codeLengths, values) {
  let k = 0,
      i,
      j,
      length = 16;

  while (length > 0 && !codeLengths[length - 1]) {
    length--;
  }

  const code = [{
    children: [],
    index: 0
  }];
  let p = code[0],
      q;

  for (i = 0; i < length; i++) {
    for (j = 0; j < codeLengths[i]; j++) {
      p = code.pop();
      p.children[p.index] = values[k];

      while (p.index > 0) {
        p = code.pop();
      }

      p.index++;
      code.push(p);

      while (code.length <= i) {
        code.push(q = {
          children: [],
          index: 0
        });
        p.children[p.index] = q.children;
        p = q;
      }

      k++;
    }

    if (i + 1 < length) {
      code.push(q = {
        children: [],
        index: 0
      });
      p.children[p.index] = q.children;
      p = q;
    }
  }

  return code[0].children;
}

function getBlockBufferOffset(component, row, col) {
  return 64 * ((component.blocksPerLine + 1) * row + col);
}

function decodeScan(data, offset, frame, components, resetInterval, spectralStart, spectralEnd, successivePrev, successive, parseDNLMarker = false) {
  const mcusPerLine = frame.mcusPerLine;
  const progressive = frame.progressive;
  const startOffset = offset;
  let bitsData = 0,
      bitsCount = 0;

  function readBit() {
    if (bitsCount > 0) {
      bitsCount--;
      return bitsData >> bitsCount & 1;
    }

    bitsData = data[offset++];

    if (bitsData === 0xff) {
      const nextByte = data[offset++];

      if (nextByte) {
        if (nextByte === 0xdc && parseDNLMarker) {
          offset += 2;
          const scanLines = (0, _core_utils.readUint16)(data, offset);
          offset += 2;

          if (scanLines > 0 && scanLines !== frame.scanLines) {
            throw new DNLMarkerError("Found DNL marker (0xFFDC) while parsing scan data", scanLines);
          }
        } else if (nextByte === 0xd9) {
          if (parseDNLMarker) {
            const maybeScanLines = blockRow * (frame.precision === 8 ? 8 : 0);

            if (maybeScanLines > 0 && Math.round(frame.scanLines / maybeScanLines) >= 10) {
              throw new DNLMarkerError("Found EOI marker (0xFFD9) while parsing scan data, " + "possibly caused by incorrect `scanLines` parameter", maybeScanLines);
            }
          }

          throw new EOIMarkerError("Found EOI marker (0xFFD9) while parsing scan data");
        }

        throw new JpegError(`unexpected marker ${(bitsData << 8 | nextByte).toString(16)}`);
      }
    }

    bitsCount = 7;
    return bitsData >>> 7;
  }

  function decodeHuffman(tree) {
    let node = tree;

    while (true) {
      node = node[readBit()];

      switch (typeof node) {
        case "number":
          return node;

        case "object":
          continue;
      }

      throw new JpegError("invalid huffman sequence");
    }
  }

  function receive(length) {
    let n = 0;

    while (length > 0) {
      n = n << 1 | readBit();
      length--;
    }

    return n;
  }

  function receiveAndExtend(length) {
    if (length === 1) {
      return readBit() === 1 ? 1 : -1;
    }

    const n = receive(length);

    if (n >= 1 << length - 1) {
      return n;
    }

    return n + (-1 << length) + 1;
  }

  function decodeBaseline(component, blockOffset) {
    const t = decodeHuffman(component.huffmanTableDC);
    const diff = t === 0 ? 0 : receiveAndExtend(t);
    component.blockData[blockOffset] = component.pred += diff;
    let k = 1;

    while (k < 64) {
      const rs = decodeHuffman(component.huffmanTableAC);
      const s = rs & 15,
            r = rs >> 4;

      if (s === 0) {
        if (r < 15) {
          break;
        }

        k += 16;
        continue;
      }

      k += r;
      const z = dctZigZag[k];
      component.blockData[blockOffset + z] = receiveAndExtend(s);
      k++;
    }
  }

  function decodeDCFirst(component, blockOffset) {
    const t = decodeHuffman(component.huffmanTableDC);
    const diff = t === 0 ? 0 : receiveAndExtend(t) << successive;
    component.blockData[blockOffset] = component.pred += diff;
  }

  function decodeDCSuccessive(component, blockOffset) {
    component.blockData[blockOffset] |= readBit() << successive;
  }

  let eobrun = 0;

  function decodeACFirst(component, blockOffset) {
    if (eobrun > 0) {
      eobrun--;
      return;
    }

    let k = spectralStart;
    const e = spectralEnd;

    while (k <= e) {
      const rs = decodeHuffman(component.huffmanTableAC);
      const s = rs & 15,
            r = rs >> 4;

      if (s === 0) {
        if (r < 15) {
          eobrun = receive(r) + (1 << r) - 1;
          break;
        }

        k += 16;
        continue;
      }

      k += r;
      const z = dctZigZag[k];
      component.blockData[blockOffset + z] = receiveAndExtend(s) * (1 << successive);
      k++;
    }
  }

  let successiveACState = 0,
      successiveACNextValue;

  function decodeACSuccessive(component, blockOffset) {
    let k = spectralStart;
    const e = spectralEnd;
    let r = 0;
    let s;
    let rs;

    while (k <= e) {
      const offsetZ = blockOffset + dctZigZag[k];
      const sign = component.blockData[offsetZ] < 0 ? -1 : 1;

      switch (successiveACState) {
        case 0:
          rs = decodeHuffman(component.huffmanTableAC);
          s = rs & 15;
          r = rs >> 4;

          if (s === 0) {
            if (r < 15) {
              eobrun = receive(r) + (1 << r);
              successiveACState = 4;
            } else {
              r = 16;
              successiveACState = 1;
            }
          } else {
            if (s !== 1) {
              throw new JpegError("invalid ACn encoding");
            }

            successiveACNextValue = receiveAndExtend(s);
            successiveACState = r ? 2 : 3;
          }

          continue;

        case 1:
        case 2:
          if (component.blockData[offsetZ]) {
            component.blockData[offsetZ] += sign * (readBit() << successive);
          } else {
            r--;

            if (r === 0) {
              successiveACState = successiveACState === 2 ? 3 : 0;
            }
          }

          break;

        case 3:
          if (component.blockData[offsetZ]) {
            component.blockData[offsetZ] += sign * (readBit() << successive);
          } else {
            component.blockData[offsetZ] = successiveACNextValue << successive;
            successiveACState = 0;
          }

          break;

        case 4:
          if (component.blockData[offsetZ]) {
            component.blockData[offsetZ] += sign * (readBit() << successive);
          }

          break;
      }

      k++;
    }

    if (successiveACState === 4) {
      eobrun--;

      if (eobrun === 0) {
        successiveACState = 0;
      }
    }
  }

  let blockRow = 0;

  function decodeMcu(component, decode, mcu, row, col) {
    const mcuRow = mcu / mcusPerLine | 0;
    const mcuCol = mcu % mcusPerLine;
    blockRow = mcuRow * component.v + row;
    const blockCol = mcuCol * component.h + col;
    const blockOffset = getBlockBufferOffset(component, blockRow, blockCol);
    decode(component, blockOffset);
  }

  function decodeBlock(component, decode, mcu) {
    blockRow = mcu / component.blocksPerLine | 0;
    const blockCol = mcu % component.blocksPerLine;
    const blockOffset = getBlockBufferOffset(component, blockRow, blockCol);
    decode(component, blockOffset);
  }

  const componentsLength = components.length;
  let component, i, j, k, n;
  let decodeFn;

  if (progressive) {
    if (spectralStart === 0) {
      decodeFn = successivePrev === 0 ? decodeDCFirst : decodeDCSuccessive;
    } else {
      decodeFn = successivePrev === 0 ? decodeACFirst : decodeACSuccessive;
    }
  } else {
    decodeFn = decodeBaseline;
  }

  let mcu = 0,
      fileMarker;
  let mcuExpected;

  if (componentsLength === 1) {
    mcuExpected = components[0].blocksPerLine * components[0].blocksPerColumn;
  } else {
    mcuExpected = mcusPerLine * frame.mcusPerColumn;
  }

  let h, v;

  while (mcu <= mcuExpected) {
    const mcuToRead = resetInterval ? Math.min(mcuExpected - mcu, resetInterval) : mcuExpected;

    if (mcuToRead > 0) {
      for (i = 0; i < componentsLength; i++) {
        components[i].pred = 0;
      }

      eobrun = 0;

      if (componentsLength === 1) {
        component = components[0];

        for (n = 0; n < mcuToRead; n++) {
          decodeBlock(component, decodeFn, mcu);
          mcu++;
        }
      } else {
        for (n = 0; n < mcuToRead; n++) {
          for (i = 0; i < componentsLength; i++) {
            component = components[i];
            h = component.h;
            v = component.v;

            for (j = 0; j < v; j++) {
              for (k = 0; k < h; k++) {
                decodeMcu(component, decodeFn, mcu, j, k);
              }
            }
          }

          mcu++;
        }
      }
    }

    bitsCount = 0;
    fileMarker = findNextFileMarker(data, offset);

    if (!fileMarker) {
      break;
    }

    if (fileMarker.invalid) {
      const partialMsg = mcuToRead > 0 ? "unexpected" : "excessive";
      (0, _util.warn)(`decodeScan - ${partialMsg} MCU data, current marker is: ${fileMarker.invalid}`);
      offset = fileMarker.offset;
    }

    if (fileMarker.marker >= 0xffd0 && fileMarker.marker <= 0xffd7) {
      offset += 2;
    } else {
      break;
    }
  }

  return offset - startOffset;
}

function quantizeAndInverse(component, blockBufferOffset, p) {
  const qt = component.quantizationTable,
        blockData = component.blockData;
  let v0, v1, v2, v3, v4, v5, v6, v7;
  let p0, p1, p2, p3, p4, p5, p6, p7;
  let t;

  if (!qt) {
    throw new JpegError("missing required Quantization Table.");
  }

  for (let row = 0; row < 64; row += 8) {
    p0 = blockData[blockBufferOffset + row];
    p1 = blockData[blockBufferOffset + row + 1];
    p2 = blockData[blockBufferOffset + row + 2];
    p3 = blockData[blockBufferOffset + row + 3];
    p4 = blockData[blockBufferOffset + row + 4];
    p5 = blockData[blockBufferOffset + row + 5];
    p6 = blockData[blockBufferOffset + row + 6];
    p7 = blockData[blockBufferOffset + row + 7];
    p0 *= qt[row];

    if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
      t = dctSqrt2 * p0 + 512 >> 10;
      p[row] = t;
      p[row + 1] = t;
      p[row + 2] = t;
      p[row + 3] = t;
      p[row + 4] = t;
      p[row + 5] = t;
      p[row + 6] = t;
      p[row + 7] = t;
      continue;
    }

    p1 *= qt[row + 1];
    p2 *= qt[row + 2];
    p3 *= qt[row + 3];
    p4 *= qt[row + 4];
    p5 *= qt[row + 5];
    p6 *= qt[row + 6];
    p7 *= qt[row + 7];
    v0 = dctSqrt2 * p0 + 128 >> 8;
    v1 = dctSqrt2 * p4 + 128 >> 8;
    v2 = p2;
    v3 = p6;
    v4 = dctSqrt1d2 * (p1 - p7) + 128 >> 8;
    v7 = dctSqrt1d2 * (p1 + p7) + 128 >> 8;
    v5 = p3 << 4;
    v6 = p5 << 4;
    v0 = v0 + v1 + 1 >> 1;
    v1 = v0 - v1;
    t = v2 * dctSin6 + v3 * dctCos6 + 128 >> 8;
    v2 = v2 * dctCos6 - v3 * dctSin6 + 128 >> 8;
    v3 = t;
    v4 = v4 + v6 + 1 >> 1;
    v6 = v4 - v6;
    v7 = v7 + v5 + 1 >> 1;
    v5 = v7 - v5;
    v0 = v0 + v3 + 1 >> 1;
    v3 = v0 - v3;
    v1 = v1 + v2 + 1 >> 1;
    v2 = v1 - v2;
    t = v4 * dctSin3 + v7 * dctCos3 + 2048 >> 12;
    v4 = v4 * dctCos3 - v7 * dctSin3 + 2048 >> 12;
    v7 = t;
    t = v5 * dctSin1 + v6 * dctCos1 + 2048 >> 12;
    v5 = v5 * dctCos1 - v6 * dctSin1 + 2048 >> 12;
    v6 = t;
    p[row] = v0 + v7;
    p[row + 7] = v0 - v7;
    p[row + 1] = v1 + v6;
    p[row + 6] = v1 - v6;
    p[row + 2] = v2 + v5;
    p[row + 5] = v2 - v5;
    p[row + 3] = v3 + v4;
    p[row + 4] = v3 - v4;
  }

  for (let col = 0; col < 8; ++col) {
    p0 = p[col];
    p1 = p[col + 8];
    p2 = p[col + 16];
    p3 = p[col + 24];
    p4 = p[col + 32];
    p5 = p[col + 40];
    p6 = p[col + 48];
    p7 = p[col + 56];

    if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
      t = dctSqrt2 * p0 + 8192 >> 14;

      if (t < -2040) {
        t = 0;
      } else if (t >= 2024) {
        t = 255;
      } else {
        t = t + 2056 >> 4;
      }

      blockData[blockBufferOffset + col] = t;
      blockData[blockBufferOffset + col + 8] = t;
      blockData[blockBufferOffset + col + 16] = t;
      blockData[blockBufferOffset + col + 24] = t;
      blockData[blockBufferOffset + col + 32] = t;
      blockData[blockBufferOffset + col + 40] = t;
      blockData[blockBufferOffset + col + 48] = t;
      blockData[blockBufferOffset + col + 56] = t;
      continue;
    }

    v0 = dctSqrt2 * p0 + 2048 >> 12;
    v1 = dctSqrt2 * p4 + 2048 >> 12;
    v2 = p2;
    v3 = p6;
    v4 = dctSqrt1d2 * (p1 - p7) + 2048 >> 12;
    v7 = dctSqrt1d2 * (p1 + p7) + 2048 >> 12;
    v5 = p3;
    v6 = p5;
    v0 = (v0 + v1 + 1 >> 1) + 4112;
    v1 = v0 - v1;
    t = v2 * dctSin6 + v3 * dctCos6 + 2048 >> 12;
    v2 = v2 * dctCos6 - v3 * dctSin6 + 2048 >> 12;
    v3 = t;
    v4 = v4 + v6 + 1 >> 1;
    v6 = v4 - v6;
    v7 = v7 + v5 + 1 >> 1;
    v5 = v7 - v5;
    v0 = v0 + v3 + 1 >> 1;
    v3 = v0 - v3;
    v1 = v1 + v2 + 1 >> 1;
    v2 = v1 - v2;
    t = v4 * dctSin3 + v7 * dctCos3 + 2048 >> 12;
    v4 = v4 * dctCos3 - v7 * dctSin3 + 2048 >> 12;
    v7 = t;
    t = v5 * dctSin1 + v6 * dctCos1 + 2048 >> 12;
    v5 = v5 * dctCos1 - v6 * dctSin1 + 2048 >> 12;
    v6 = t;
    p0 = v0 + v7;
    p7 = v0 - v7;
    p1 = v1 + v6;
    p6 = v1 - v6;
    p2 = v2 + v5;
    p5 = v2 - v5;
    p3 = v3 + v4;
    p4 = v3 - v4;

    if (p0 < 16) {
      p0 = 0;
    } else if (p0 >= 4080) {
      p0 = 255;
    } else {
      p0 >>= 4;
    }

    if (p1 < 16) {
      p1 = 0;
    } else if (p1 >= 4080) {
      p1 = 255;
    } else {
      p1 >>= 4;
    }

    if (p2 < 16) {
      p2 = 0;
    } else if (p2 >= 4080) {
      p2 = 255;
    } else {
      p2 >>= 4;
    }

    if (p3 < 16) {
      p3 = 0;
    } else if (p3 >= 4080) {
      p3 = 255;
    } else {
      p3 >>= 4;
    }

    if (p4 < 16) {
      p4 = 0;
    } else if (p4 >= 4080) {
      p4 = 255;
    } else {
      p4 >>= 4;
    }

    if (p5 < 16) {
      p5 = 0;
    } else if (p5 >= 4080) {
      p5 = 255;
    } else {
      p5 >>= 4;
    }

    if (p6 < 16) {
      p6 = 0;
    } else if (p6 >= 4080) {
      p6 = 255;
    } else {
      p6 >>= 4;
    }

    if (p7 < 16) {
      p7 = 0;
    } else if (p7 >= 4080) {
      p7 = 255;
    } else {
      p7 >>= 4;
    }

    blockData[blockBufferOffset + col] = p0;
    blockData[blockBufferOffset + col + 8] = p1;
    blockData[blockBufferOffset + col + 16] = p2;
    blockData[blockBufferOffset + col + 24] = p3;
    blockData[blockBufferOffset + col + 32] = p4;
    blockData[blockBufferOffset + col + 40] = p5;
    blockData[blockBufferOffset + col + 48] = p6;
    blockData[blockBufferOffset + col + 56] = p7;
  }
}

function buildComponentData(frame, component) {
  const blocksPerLine = component.blocksPerLine;
  const blocksPerColumn = component.blocksPerColumn;
  const computationBuffer = new Int16Array(64);

  for (let blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
    for (let blockCol = 0; blockCol < blocksPerLine; blockCol++) {
      const offset = getBlockBufferOffset(component, blockRow, blockCol);
      quantizeAndInverse(component, offset, computationBuffer);
    }
  }

  return component.blockData;
}

function findNextFileMarker(data, currentPos, startPos = currentPos) {
  const maxPos = data.length - 1;
  let newPos = startPos < currentPos ? startPos : currentPos;

  if (currentPos >= maxPos) {
    return null;
  }

  const currentMarker = (0, _core_utils.readUint16)(data, currentPos);

  if (currentMarker >= 0xffc0 && currentMarker <= 0xfffe) {
    return {
      invalid: null,
      marker: currentMarker,
      offset: currentPos
    };
  }

  let newMarker = (0, _core_utils.readUint16)(data, newPos);

  while (!(newMarker >= 0xffc0 && newMarker <= 0xfffe)) {
    if (++newPos >= maxPos) {
      return null;
    }

    newMarker = (0, _core_utils.readUint16)(data, newPos);
  }

  return {
    invalid: currentMarker.toString(16),
    marker: newMarker,
    offset: newPos
  };
}

class JpegImage {
  constructor({
    decodeTransform = null,
    colorTransform = -1
  } = {}) {
    this._decodeTransform = decodeTransform;
    this._colorTransform = colorTransform;
  }

  parse(data, {
    dnlScanLines = null
  } = {}) {
    function readDataBlock() {
      const length = (0, _core_utils.readUint16)(data, offset);
      offset += 2;
      let endOffset = offset + length - 2;
      const fileMarker = findNextFileMarker(data, endOffset, offset);

      if (fileMarker && fileMarker.invalid) {
        (0, _util.warn)("readDataBlock - incorrect length, current marker is: " + fileMarker.invalid);
        endOffset = fileMarker.offset;
      }

      const array = data.subarray(offset, endOffset);
      offset += array.length;
      return array;
    }

    function prepareComponents(frame) {
      const mcusPerLine = Math.ceil(frame.samplesPerLine / 8 / frame.maxH);
      const mcusPerColumn = Math.ceil(frame.scanLines / 8 / frame.maxV);

      for (let i = 0, ii = frame.components.length; i < ii; i++) {
        const component = frame.components[i];
        const blocksPerLine = Math.ceil(Math.ceil(frame.samplesPerLine / 8) * component.h / frame.maxH);
        const blocksPerColumn = Math.ceil(Math.ceil(frame.scanLines / 8) * component.v / frame.maxV);
        const blocksPerLineForMcu = mcusPerLine * component.h;
        const blocksPerColumnForMcu = mcusPerColumn * component.v;
        const blocksBufferSize = 64 * blocksPerColumnForMcu * (blocksPerLineForMcu + 1);
        component.blockData = new Int16Array(blocksBufferSize);
        component.blocksPerLine = blocksPerLine;
        component.blocksPerColumn = blocksPerColumn;
      }

      frame.mcusPerLine = mcusPerLine;
      frame.mcusPerColumn = mcusPerColumn;
    }

    let offset = 0;
    let jfif = null;
    let adobe = null;
    let frame, resetInterval;
    let numSOSMarkers = 0;
    const quantizationTables = [];
    const huffmanTablesAC = [],
          huffmanTablesDC = [];
    let fileMarker = (0, _core_utils.readUint16)(data, offset);
    offset += 2;

    if (fileMarker !== 0xffd8) {
      throw new JpegError("SOI not found");
    }

    fileMarker = (0, _core_utils.readUint16)(data, offset);
    offset += 2;

    markerLoop: while (fileMarker !== 0xffd9) {
      let i, j, l;

      switch (fileMarker) {
        case 0xffe0:
        case 0xffe1:
        case 0xffe2:
        case 0xffe3:
        case 0xffe4:
        case 0xffe5:
        case 0xffe6:
        case 0xffe7:
        case 0xffe8:
        case 0xffe9:
        case 0xffea:
        case 0xffeb:
        case 0xffec:
        case 0xffed:
        case 0xffee:
        case 0xffef:
        case 0xfffe:
          const appData = readDataBlock();

          if (fileMarker === 0xffe0) {
            if (appData[0] === 0x4a && appData[1] === 0x46 && appData[2] === 0x49 && appData[3] === 0x46 && appData[4] === 0) {
              jfif = {
                version: {
                  major: appData[5],
                  minor: appData[6]
                },
                densityUnits: appData[7],
                xDensity: appData[8] << 8 | appData[9],
                yDensity: appData[10] << 8 | appData[11],
                thumbWidth: appData[12],
                thumbHeight: appData[13],
                thumbData: appData.subarray(14, 14 + 3 * appData[12] * appData[13])
              };
            }
          }

          if (fileMarker === 0xffee) {
            if (appData[0] === 0x41 && appData[1] === 0x64 && appData[2] === 0x6f && appData[3] === 0x62 && appData[4] === 0x65) {
              adobe = {
                version: appData[5] << 8 | appData[6],
                flags0: appData[7] << 8 | appData[8],
                flags1: appData[9] << 8 | appData[10],
                transformCode: appData[11]
              };
            }
          }

          break;

        case 0xffdb:
          const quantizationTablesLength = (0, _core_utils.readUint16)(data, offset);
          offset += 2;
          const quantizationTablesEnd = quantizationTablesLength + offset - 2;
          let z;

          while (offset < quantizationTablesEnd) {
            const quantizationTableSpec = data[offset++];
            const tableData = new Uint16Array(64);

            if (quantizationTableSpec >> 4 === 0) {
              for (j = 0; j < 64; j++) {
                z = dctZigZag[j];
                tableData[z] = data[offset++];
              }
            } else if (quantizationTableSpec >> 4 === 1) {
              for (j = 0; j < 64; j++) {
                z = dctZigZag[j];
                tableData[z] = (0, _core_utils.readUint16)(data, offset);
                offset += 2;
              }
            } else {
              throw new JpegError("DQT - invalid table spec");
            }

            quantizationTables[quantizationTableSpec & 15] = tableData;
          }

          break;

        case 0xffc0:
        case 0xffc1:
        case 0xffc2:
          if (frame) {
            throw new JpegError("Only single frame JPEGs supported");
          }

          offset += 2;
          frame = {};
          frame.extended = fileMarker === 0xffc1;
          frame.progressive = fileMarker === 0xffc2;
          frame.precision = data[offset++];
          const sofScanLines = (0, _core_utils.readUint16)(data, offset);
          offset += 2;
          frame.scanLines = dnlScanLines || sofScanLines;
          frame.samplesPerLine = (0, _core_utils.readUint16)(data, offset);
          offset += 2;
          frame.components = [];
          frame.componentIds = {};
          const componentsCount = data[offset++];
          let maxH = 0,
              maxV = 0;

          for (i = 0; i < componentsCount; i++) {
            const componentId = data[offset];
            const h = data[offset + 1] >> 4;
            const v = data[offset + 1] & 15;

            if (maxH < h) {
              maxH = h;
            }

            if (maxV < v) {
              maxV = v;
            }

            const qId = data[offset + 2];
            l = frame.components.push({
              h,
              v,
              quantizationId: qId,
              quantizationTable: null
            });
            frame.componentIds[componentId] = l - 1;
            offset += 3;
          }

          frame.maxH = maxH;
          frame.maxV = maxV;
          prepareComponents(frame);
          break;

        case 0xffc4:
          const huffmanLength = (0, _core_utils.readUint16)(data, offset);
          offset += 2;

          for (i = 2; i < huffmanLength;) {
            const huffmanTableSpec = data[offset++];
            const codeLengths = new Uint8Array(16);
            let codeLengthSum = 0;

            for (j = 0; j < 16; j++, offset++) {
              codeLengthSum += codeLengths[j] = data[offset];
            }

            const huffmanValues = new Uint8Array(codeLengthSum);

            for (j = 0; j < codeLengthSum; j++, offset++) {
              huffmanValues[j] = data[offset];
            }

            i += 17 + codeLengthSum;
            (huffmanTableSpec >> 4 === 0 ? huffmanTablesDC : huffmanTablesAC)[huffmanTableSpec & 15] = buildHuffmanTable(codeLengths, huffmanValues);
          }

          break;

        case 0xffdd:
          offset += 2;
          resetInterval = (0, _core_utils.readUint16)(data, offset);
          offset += 2;
          break;

        case 0xffda:
          const parseDNLMarker = ++numSOSMarkers === 1 && !dnlScanLines;
          offset += 2;
          const selectorsCount = data[offset++],
                components = [];

          for (i = 0; i < selectorsCount; i++) {
            const index = data[offset++];
            const componentIndex = frame.componentIds[index];
            const component = frame.components[componentIndex];
            component.index = index;
            const tableSpec = data[offset++];
            component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
            component.huffmanTableAC = huffmanTablesAC[tableSpec & 15];
            components.push(component);
          }

          const spectralStart = data[offset++],
                spectralEnd = data[offset++],
                successiveApproximation = data[offset++];

          try {
            const processed = decodeScan(data, offset, frame, components, resetInterval, spectralStart, spectralEnd, successiveApproximation >> 4, successiveApproximation & 15, parseDNLMarker);
            offset += processed;
          } catch (ex) {
            if (ex instanceof DNLMarkerError) {
              (0, _util.warn)(`${ex.message} -- attempting to re-parse the JPEG image.`);
              return this.parse(data, {
                dnlScanLines: ex.scanLines
              });
            } else if (ex instanceof EOIMarkerError) {
              (0, _util.warn)(`${ex.message} -- ignoring the rest of the image data.`);
              break markerLoop;
            }

            throw ex;
          }

          break;

        case 0xffdc:
          offset += 4;
          break;

        case 0xffff:
          if (data[offset] !== 0xff) {
            offset--;
          }

          break;

        default:
          const nextFileMarker = findNextFileMarker(data, offset - 2, offset - 3);

          if (nextFileMarker && nextFileMarker.invalid) {
            (0, _util.warn)("JpegImage.parse - unexpected data, current marker is: " + nextFileMarker.invalid);
            offset = nextFileMarker.offset;
            break;
          }

          if (!nextFileMarker || offset >= data.length - 1) {
            (0, _util.warn)("JpegImage.parse - reached the end of the image data " + "without finding an EOI marker (0xFFD9).");
            break markerLoop;
          }

          throw new JpegError("JpegImage.parse - unknown marker: " + fileMarker.toString(16));
      }

      fileMarker = (0, _core_utils.readUint16)(data, offset);
      offset += 2;
    }

    this.width = frame.samplesPerLine;
    this.height = frame.scanLines;
    this.jfif = jfif;
    this.adobe = adobe;
    this.components = [];

    for (let i = 0, ii = frame.components.length; i < ii; i++) {
      const component = frame.components[i];
      const quantizationTable = quantizationTables[component.quantizationId];

      if (quantizationTable) {
        component.quantizationTable = quantizationTable;
      }

      this.components.push({
        index: component.index,
        output: buildComponentData(frame, component),
        scaleX: component.h / frame.maxH,
        scaleY: component.v / frame.maxV,
        blocksPerLine: component.blocksPerLine,
        blocksPerColumn: component.blocksPerColumn
      });
    }

    this.numComponents = this.components.length;
    return undefined;
  }

  _getLinearizedBlockData(width, height, isSourcePDF = false) {
    const scaleX = this.width / width,
          scaleY = this.height / height;
    let component, componentScaleX, componentScaleY, blocksPerScanline;
    let x, y, i, j, k;
    let index;
    let offset = 0;
    let output;
    const numComponents = this.components.length;
    const dataLength = width * height * numComponents;
    const data = new Uint8ClampedArray(dataLength);
    const xScaleBlockOffset = new Uint32Array(width);
    const mask3LSB = 0xfffffff8;
    let lastComponentScaleX;

    for (i = 0; i < numComponents; i++) {
      component = this.components[i];
      componentScaleX = component.scaleX * scaleX;
      componentScaleY = component.scaleY * scaleY;
      offset = i;
      output = component.output;
      blocksPerScanline = component.blocksPerLine + 1 << 3;

      if (componentScaleX !== lastComponentScaleX) {
        for (x = 0; x < width; x++) {
          j = 0 | x * componentScaleX;
          xScaleBlockOffset[x] = (j & mask3LSB) << 3 | j & 7;
        }

        lastComponentScaleX = componentScaleX;
      }

      for (y = 0; y < height; y++) {
        j = 0 | y * componentScaleY;
        index = blocksPerScanline * (j & mask3LSB) | (j & 7) << 3;

        for (x = 0; x < width; x++) {
          data[offset] = output[index + xScaleBlockOffset[x]];
          offset += numComponents;
        }
      }
    }

    let transform = this._decodeTransform;

    if (!isSourcePDF && numComponents === 4 && !transform) {
      transform = new Int32Array([-256, 255, -256, 255, -256, 255, -256, 255]);
    }

    if (transform) {
      for (i = 0; i < dataLength;) {
        for (j = 0, k = 0; j < numComponents; j++, i++, k += 2) {
          data[i] = (data[i] * transform[k] >> 8) + transform[k + 1];
        }
      }
    }

    return data;
  }

  get _isColorConversionNeeded() {
    if (this.adobe) {
      return !!this.adobe.transformCode;
    }

    if (this.numComponents === 3) {
      if (this._colorTransform === 0) {
        return false;
      } else if (this.components[0].index === 0x52 && this.components[1].index === 0x47 && this.components[2].index === 0x42) {
        return false;
      }

      return true;
    }

    if (this._colorTransform === 1) {
      return true;
    }

    return false;
  }

  _convertYccToRgb(data) {
    let Y, Cb, Cr;

    for (let i = 0, length = data.length; i < length; i += 3) {
      Y = data[i];
      Cb = data[i + 1];
      Cr = data[i + 2];
      data[i] = Y - 179.456 + 1.402 * Cr;
      data[i + 1] = Y + 135.459 - 0.344 * Cb - 0.714 * Cr;
      data[i + 2] = Y - 226.816 + 1.772 * Cb;
    }

    return data;
  }

  _convertYcckToRgb(data) {
    let Y, Cb, Cr, k;
    let offset = 0;

    for (let i = 0, length = data.length; i < length; i += 4) {
      Y = data[i];
      Cb = data[i + 1];
      Cr = data[i + 2];
      k = data[i + 3];
      data[offset++] = -122.67195406894 + Cb * (-6.60635669420364e-5 * Cb + 0.000437130475926232 * Cr - 5.4080610064599e-5 * Y + 0.00048449797120281 * k - 0.154362151871126) + Cr * (-0.000957964378445773 * Cr + 0.000817076911346625 * Y - 0.00477271405408747 * k + 1.53380253221734) + Y * (0.000961250184130688 * Y - 0.00266257332283933 * k + 0.48357088451265) + k * (-0.000336197177618394 * k + 0.484791561490776);
      data[offset++] = 107.268039397724 + Cb * (2.19927104525741e-5 * Cb - 0.000640992018297945 * Cr + 0.000659397001245577 * Y + 0.000426105652938837 * k - 0.176491792462875) + Cr * (-0.000778269941513683 * Cr + 0.00130872261408275 * Y + 0.000770482631801132 * k - 0.151051492775562) + Y * (0.00126935368114843 * Y - 0.00265090189010898 * k + 0.25802910206845) + k * (-0.000318913117588328 * k - 0.213742400323665);
      data[offset++] = -20.810012546947 + Cb * (-0.000570115196973677 * Cb - 2.63409051004589e-5 * Cr + 0.0020741088115012 * Y - 0.00288260236853442 * k + 0.814272968359295) + Cr * (-1.53496057440975e-5 * Cr - 0.000132689043961446 * Y + 0.000560833691242812 * k - 0.195152027534049) + Y * (0.00174418132927582 * Y - 0.00255243321439347 * k + 0.116935020465145) + k * (-0.000343531996510555 * k + 0.24165260232407);
    }

    return data.subarray(0, offset);
  }

  _convertYcckToCmyk(data) {
    let Y, Cb, Cr;

    for (let i = 0, length = data.length; i < length; i += 4) {
      Y = data[i];
      Cb = data[i + 1];
      Cr = data[i + 2];
      data[i] = 434.456 - Y - 1.402 * Cr;
      data[i + 1] = 119.541 - Y + 0.344 * Cb + 0.714 * Cr;
      data[i + 2] = 481.816 - Y - 1.772 * Cb;
    }

    return data;
  }

  _convertCmykToRgb(data) {
    let c, m, y, k;
    let offset = 0;

    for (let i = 0, length = data.length; i < length; i += 4) {
      c = data[i];
      m = data[i + 1];
      y = data[i + 2];
      k = data[i + 3];
      data[offset++] = 255 + c * (-0.00006747147073602441 * c + 0.0008379262121013727 * m + 0.0002894718188643294 * y + 0.003264231057537806 * k - 1.1185611867203937) + m * (0.000026374107616089405 * m - 0.00008626949158638572 * y - 0.0002748769067499491 * k - 0.02155688794978967) + y * (-0.00003878099212869363 * y - 0.0003267808279485286 * k + 0.0686742238595345) - k * (0.0003361971776183937 * k + 0.7430659151342254);
      data[offset++] = 255 + c * (0.00013596372813588848 * c + 0.000924537132573585 * m + 0.00010567359618683593 * y + 0.0004791864687436512 * k - 0.3109689587515875) + m * (-0.00023545346108370344 * m + 0.0002702845253534714 * y + 0.0020200308977307156 * k - 0.7488052167015494) + y * (0.00006834815998235662 * y + 0.00015168452363460973 * k - 0.09751927774728933) - k * (0.0003189131175883281 * k + 0.7364883807733168);
      data[offset++] = 255 + c * (0.000013598650411385307 * c + 0.00012423956175490851 * m + 0.0004751985097583589 * y - 0.0000036729317476630422 * k - 0.05562186980264034) + m * (0.00016141380598724676 * m + 0.0009692239130725186 * y + 0.0007782692450036253 * k - 0.44015232367526463) + y * (5.068882914068769e-7 * y + 0.0017778369011375071 * k - 0.7591454649749609) - k * (0.0003435319965105553 * k + 0.7063770186160144);
    }

    return data.subarray(0, offset);
  }

  getData({
    width,
    height,
    forceRGB = false,
    isSourcePDF = false
  }) {
    if (this.numComponents > 4) {
      throw new JpegError("Unsupported color mode");
    }

    const data = this._getLinearizedBlockData(width, height, isSourcePDF);

    if (this.numComponents === 1 && forceRGB) {
      const dataLength = data.length;
      const rgbData = new Uint8ClampedArray(dataLength * 3);
      let offset = 0;

      for (let i = 0; i < dataLength; i++) {
        const grayColor = data[i];
        rgbData[offset++] = grayColor;
        rgbData[offset++] = grayColor;
        rgbData[offset++] = grayColor;
      }

      return rgbData;
    } else if (this.numComponents === 3 && this._isColorConversionNeeded) {
      return this._convertYccToRgb(data);
    } else if (this.numComponents === 4) {
      if (this._isColorConversionNeeded) {
        if (forceRGB) {
          return this._convertYcckToRgb(data);
        }

        return this._convertYcckToCmyk(data);
      } else if (forceRGB) {
        return this._convertCmykToRgb(data);
      }
    }

    return data;
  }

}

exports.JpegImage = JpegImage;

/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JpxStream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

var _jpx = __w_pdfjs_require__(40);

var _util = __w_pdfjs_require__(2);

class JpxStream extends _decode_stream.DecodeStream {
  constructor(stream, maybeLength, params) {
    super(maybeLength);
    this.stream = stream;
    this.dict = stream.dict;
    this.maybeLength = maybeLength;
    this.params = params;
  }

  get bytes() {
    return (0, _util.shadow)(this, "bytes", this.stream.getBytes(this.maybeLength));
  }

  ensureBuffer(requested) {}

  readBlock() {
    if (this.eof) {
      return;
    }

    const jpxImage = new _jpx.JpxImage();
    jpxImage.parse(this.bytes);
    const width = jpxImage.width;
    const height = jpxImage.height;
    const componentsCount = jpxImage.componentsCount;
    const tileCount = jpxImage.tiles.length;

    if (tileCount === 1) {
      this.buffer = jpxImage.tiles[0].items;
    } else {
      const data = new Uint8ClampedArray(width * height * componentsCount);

      for (let k = 0; k < tileCount; k++) {
        const tileComponents = jpxImage.tiles[k];
        const tileWidth = tileComponents.width;
        const tileHeight = tileComponents.height;
        const tileLeft = tileComponents.left;
        const tileTop = tileComponents.top;
        const src = tileComponents.items;
        let srcPosition = 0;
        let dataPosition = (width * tileTop + tileLeft) * componentsCount;
        const imgRowSize = width * componentsCount;
        const tileRowSize = tileWidth * componentsCount;

        for (let j = 0; j < tileHeight; j++) {
          const rowBytes = src.subarray(srcPosition, srcPosition + tileRowSize);
          data.set(rowBytes, dataPosition);
          srcPosition += tileRowSize;
          dataPosition += imgRowSize;
        }
      }

      this.buffer = data;
    }

    this.bufferLength = this.buffer.length;
    this.eof = true;
  }

}

exports.JpxStream = JpxStream;

/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JpxImage = void 0;

var _util = __w_pdfjs_require__(2);

var _core_utils = __w_pdfjs_require__(9);

var _arithmetic_decoder = __w_pdfjs_require__(36);

class JpxError extends _util.BaseException {
  constructor(msg) {
    super(`JPX error: ${msg}`, "JpxError");
  }

}

const SubbandsGainLog2 = {
  LL: 0,
  LH: 1,
  HL: 1,
  HH: 2
};

class JpxImage {
  constructor() {
    this.failOnCorruptedImage = false;
  }

  parse(data) {
    const head = (0, _core_utils.readUint16)(data, 0);

    if (head === 0xff4f) {
      this.parseCodestream(data, 0, data.length);
      return;
    }

    const length = data.length;
    let position = 0;

    while (position < length) {
      let headerSize = 8;
      let lbox = (0, _core_utils.readUint32)(data, position);
      const tbox = (0, _core_utils.readUint32)(data, position + 4);
      position += headerSize;

      if (lbox === 1) {
        lbox = (0, _core_utils.readUint32)(data, position) * 4294967296 + (0, _core_utils.readUint32)(data, position + 4);
        position += 8;
        headerSize += 8;
      }

      if (lbox === 0) {
        lbox = length - position + headerSize;
      }

      if (lbox < headerSize) {
        throw new JpxError("Invalid box field size");
      }

      const dataLength = lbox - headerSize;
      let jumpDataLength = true;

      switch (tbox) {
        case 0x6a703268:
          jumpDataLength = false;
          break;

        case 0x636f6c72:
          const method = data[position];

          if (method === 1) {
            const colorspace = (0, _core_utils.readUint32)(data, position + 3);

            switch (colorspace) {
              case 16:
              case 17:
              case 18:
                break;

              default:
                (0, _util.warn)("Unknown colorspace " + colorspace);
                break;
            }
          } else if (method === 2) {
            (0, _util.info)("ICC profile not supported");
          }

          break;

        case 0x6a703263:
          this.parseCodestream(data, position, position + dataLength);
          break;

        case 0x6a502020:
          if ((0, _core_utils.readUint32)(data, position) !== 0x0d0a870a) {
            (0, _util.warn)("Invalid JP2 signature");
          }

          break;

        case 0x6a501a1a:
        case 0x66747970:
        case 0x72726571:
        case 0x72657320:
        case 0x69686472:
          break;

        default:
          const headerType = String.fromCharCode(tbox >> 24 & 0xff, tbox >> 16 & 0xff, tbox >> 8 & 0xff, tbox & 0xff);
          (0, _util.warn)(`Unsupported header type ${tbox} (${headerType}).`);
          break;
      }

      if (jumpDataLength) {
        position += dataLength;
      }
    }
  }

  parseImageProperties(stream) {
    let newByte = stream.getByte();

    while (newByte >= 0) {
      const oldByte = newByte;
      newByte = stream.getByte();
      const code = oldByte << 8 | newByte;

      if (code === 0xff51) {
        stream.skip(4);
        const Xsiz = stream.getInt32() >>> 0;
        const Ysiz = stream.getInt32() >>> 0;
        const XOsiz = stream.getInt32() >>> 0;
        const YOsiz = stream.getInt32() >>> 0;
        stream.skip(16);
        const Csiz = stream.getUint16();
        this.width = Xsiz - XOsiz;
        this.height = Ysiz - YOsiz;
        this.componentsCount = Csiz;
        this.bitsPerComponent = 8;
        return;
      }
    }

    throw new JpxError("No size marker found in JPX stream");
  }

  parseCodestream(data, start, end) {
    const context = {};
    let doNotRecover = false;

    try {
      let position = start;

      while (position + 1 < end) {
        const code = (0, _core_utils.readUint16)(data, position);
        position += 2;
        let length = 0,
            j,
            sqcd,
            spqcds,
            spqcdSize,
            scalarExpounded,
            tile;

        switch (code) {
          case 0xff4f:
            context.mainHeader = true;
            break;

          case 0xffd9:
            break;

          case 0xff51:
            length = (0, _core_utils.readUint16)(data, position);
            const siz = {};
            siz.Xsiz = (0, _core_utils.readUint32)(data, position + 4);
            siz.Ysiz = (0, _core_utils.readUint32)(data, position + 8);
            siz.XOsiz = (0, _core_utils.readUint32)(data, position + 12);
            siz.YOsiz = (0, _core_utils.readUint32)(data, position + 16);
            siz.XTsiz = (0, _core_utils.readUint32)(data, position + 20);
            siz.YTsiz = (0, _core_utils.readUint32)(data, position + 24);
            siz.XTOsiz = (0, _core_utils.readUint32)(data, position + 28);
            siz.YTOsiz = (0, _core_utils.readUint32)(data, position + 32);
            const componentsCount = (0, _core_utils.readUint16)(data, position + 36);
            siz.Csiz = componentsCount;
            const components = [];
            j = position + 38;

            for (let i = 0; i < componentsCount; i++) {
              const component = {
                precision: (data[j] & 0x7f) + 1,
                isSigned: !!(data[j] & 0x80),
                XRsiz: data[j + 1],
                YRsiz: data[j + 2]
              };
              j += 3;
              calculateComponentDimensions(component, siz);
              components.push(component);
            }

            context.SIZ = siz;
            context.components = components;
            calculateTileGrids(context, components);
            context.QCC = [];
            context.COC = [];
            break;

          case 0xff5c:
            length = (0, _core_utils.readUint16)(data, position);
            const qcd = {};
            j = position + 2;
            sqcd = data[j++];

            switch (sqcd & 0x1f) {
              case 0:
                spqcdSize = 8;
                scalarExpounded = true;
                break;

              case 1:
                spqcdSize = 16;
                scalarExpounded = false;
                break;

              case 2:
                spqcdSize = 16;
                scalarExpounded = true;
                break;

              default:
                throw new Error("Invalid SQcd value " + sqcd);
            }

            qcd.noQuantization = spqcdSize === 8;
            qcd.scalarExpounded = scalarExpounded;
            qcd.guardBits = sqcd >> 5;
            spqcds = [];

            while (j < length + position) {
              const spqcd = {};

              if (spqcdSize === 8) {
                spqcd.epsilon = data[j++] >> 3;
                spqcd.mu = 0;
              } else {
                spqcd.epsilon = data[j] >> 3;
                spqcd.mu = (data[j] & 0x7) << 8 | data[j + 1];
                j += 2;
              }

              spqcds.push(spqcd);
            }

            qcd.SPqcds = spqcds;

            if (context.mainHeader) {
              context.QCD = qcd;
            } else {
              context.currentTile.QCD = qcd;
              context.currentTile.QCC = [];
            }

            break;

          case 0xff5d:
            length = (0, _core_utils.readUint16)(data, position);
            const qcc = {};
            j = position + 2;
            let cqcc;

            if (context.SIZ.Csiz < 257) {
              cqcc = data[j++];
            } else {
              cqcc = (0, _core_utils.readUint16)(data, j);
              j += 2;
            }

            sqcd = data[j++];

            switch (sqcd & 0x1f) {
              case 0:
                spqcdSize = 8;
                scalarExpounded = true;
                break;

              case 1:
                spqcdSize = 16;
                scalarExpounded = false;
                break;

              case 2:
                spqcdSize = 16;
                scalarExpounded = true;
                break;

              default:
                throw new Error("Invalid SQcd value " + sqcd);
            }

            qcc.noQuantization = spqcdSize === 8;
            qcc.scalarExpounded = scalarExpounded;
            qcc.guardBits = sqcd >> 5;
            spqcds = [];

            while (j < length + position) {
              const spqcd = {};

              if (spqcdSize === 8) {
                spqcd.epsilon = data[j++] >> 3;
                spqcd.mu = 0;
              } else {
                spqcd.epsilon = data[j] >> 3;
                spqcd.mu = (data[j] & 0x7) << 8 | data[j + 1];
                j += 2;
              }

              spqcds.push(spqcd);
            }

            qcc.SPqcds = spqcds;

            if (context.mainHeader) {
              context.QCC[cqcc] = qcc;
            } else {
              context.currentTile.QCC[cqcc] = qcc;
            }

            break;

          case 0xff52:
            length = (0, _core_utils.readUint16)(data, position);
            const cod = {};
            j = position + 2;
            const scod = data[j++];
            cod.entropyCoderWithCustomPrecincts = !!(scod & 1);
            cod.sopMarkerUsed = !!(scod & 2);
            cod.ephMarkerUsed = !!(scod & 4);
            cod.progressionOrder = data[j++];
            cod.layersCount = (0, _core_utils.readUint16)(data, j);
            j += 2;
            cod.multipleComponentTransform = data[j++];
            cod.decompositionLevelsCount = data[j++];
            cod.xcb = (data[j++] & 0xf) + 2;
            cod.ycb = (data[j++] & 0xf) + 2;
            const blockStyle = data[j++];
            cod.selectiveArithmeticCodingBypass = !!(blockStyle & 1);
            cod.resetContextProbabilities = !!(blockStyle & 2);
            cod.terminationOnEachCodingPass = !!(blockStyle & 4);
            cod.verticallyStripe = !!(blockStyle & 8);
            cod.predictableTermination = !!(blockStyle & 16);
            cod.segmentationSymbolUsed = !!(blockStyle & 32);
            cod.reversibleTransformation = data[j++];

            if (cod.entropyCoderWithCustomPrecincts) {
              const precinctsSizes = [];

              while (j < length + position) {
                const precinctsSize = data[j++];
                precinctsSizes.push({
                  PPx: precinctsSize & 0xf,
                  PPy: precinctsSize >> 4
                });
              }

              cod.precinctsSizes = precinctsSizes;
            }

            const unsupported = [];

            if (cod.selectiveArithmeticCodingBypass) {
              unsupported.push("selectiveArithmeticCodingBypass");
            }

            if (cod.resetContextProbabilities) {
              unsupported.push("resetContextProbabilities");
            }

            if (cod.terminationOnEachCodingPass) {
              unsupported.push("terminationOnEachCodingPass");
            }

            if (cod.verticallyStripe) {
              unsupported.push("verticallyStripe");
            }

            if (cod.predictableTermination) {
              unsupported.push("predictableTermination");
            }

            if (unsupported.length > 0) {
              doNotRecover = true;
              (0, _util.warn)(`JPX: Unsupported COD options (${unsupported.join(", ")}).`);
            }

            if (context.mainHeader) {
              context.COD = cod;
            } else {
              context.currentTile.COD = cod;
              context.currentTile.COC = [];
            }

            break;

          case 0xff90:
            length = (0, _core_utils.readUint16)(data, position);
            tile = {};
            tile.index = (0, _core_utils.readUint16)(data, position + 2);
            tile.length = (0, _core_utils.readUint32)(data, position + 4);
            tile.dataEnd = tile.length + position - 2;
            tile.partIndex = data[position + 8];
            tile.partsCount = data[position + 9];
            context.mainHeader = false;

            if (tile.partIndex === 0) {
              tile.COD = context.COD;
              tile.COC = context.COC.slice(0);
              tile.QCD = context.QCD;
              tile.QCC = context.QCC.slice(0);
            }

            context.currentTile = tile;
            break;

          case 0xff93:
            tile = context.currentTile;

            if (tile.partIndex === 0) {
              initializeTile(context, tile.index);
              buildPackets(context);
            }

            length = tile.dataEnd - position;
            parseTilePackets(context, data, position, length);
            break;

          case 0xff53:
            (0, _util.warn)("JPX: Codestream code 0xFF53 (COC) is not implemented.");

          case 0xff55:
          case 0xff57:
          case 0xff58:
          case 0xff64:
            length = (0, _core_utils.readUint16)(data, position);
            break;

          default:
            throw new Error("Unknown codestream code: " + code.toString(16));
        }

        position += length;
      }
    } catch (e) {
      if (doNotRecover || this.failOnCorruptedImage) {
        throw new JpxError(e.message);
      } else {
        (0, _util.warn)(`JPX: Trying to recover from: "${e.message}".`);
      }
    }

    this.tiles = transformComponents(context);
    this.width = context.SIZ.Xsiz - context.SIZ.XOsiz;
    this.height = context.SIZ.Ysiz - context.SIZ.YOsiz;
    this.componentsCount = context.SIZ.Csiz;
  }

}

exports.JpxImage = JpxImage;

function calculateComponentDimensions(component, siz) {
  component.x0 = Math.ceil(siz.XOsiz / component.XRsiz);
  component.x1 = Math.ceil(siz.Xsiz / component.XRsiz);
  component.y0 = Math.ceil(siz.YOsiz / component.YRsiz);
  component.y1 = Math.ceil(siz.Ysiz / component.YRsiz);
  component.width = component.x1 - component.x0;
  component.height = component.y1 - component.y0;
}

function calculateTileGrids(context, components) {
  const siz = context.SIZ;
  const tiles = [];
  let tile;
  const numXtiles = Math.ceil((siz.Xsiz - siz.XTOsiz) / siz.XTsiz);
  const numYtiles = Math.ceil((siz.Ysiz - siz.YTOsiz) / siz.YTsiz);

  for (let q = 0; q < numYtiles; q++) {
    for (let p = 0; p < numXtiles; p++) {
      tile = {};
      tile.tx0 = Math.max(siz.XTOsiz + p * siz.XTsiz, siz.XOsiz);
      tile.ty0 = Math.max(siz.YTOsiz + q * siz.YTsiz, siz.YOsiz);
      tile.tx1 = Math.min(siz.XTOsiz + (p + 1) * siz.XTsiz, siz.Xsiz);
      tile.ty1 = Math.min(siz.YTOsiz + (q + 1) * siz.YTsiz, siz.Ysiz);
      tile.width = tile.tx1 - tile.tx0;
      tile.height = tile.ty1 - tile.ty0;
      tile.components = [];
      tiles.push(tile);
    }
  }

  context.tiles = tiles;
  const componentsCount = siz.Csiz;

  for (let i = 0, ii = componentsCount; i < ii; i++) {
    const component = components[i];

    for (let j = 0, jj = tiles.length; j < jj; j++) {
      const tileComponent = {};
      tile = tiles[j];
      tileComponent.tcx0 = Math.ceil(tile.tx0 / component.XRsiz);
      tileComponent.tcy0 = Math.ceil(tile.ty0 / component.YRsiz);
      tileComponent.tcx1 = Math.ceil(tile.tx1 / component.XRsiz);
      tileComponent.tcy1 = Math.ceil(tile.ty1 / component.YRsiz);
      tileComponent.width = tileComponent.tcx1 - tileComponent.tcx0;
      tileComponent.height = tileComponent.tcy1 - tileComponent.tcy0;
      tile.components[i] = tileComponent;
    }
  }
}

function getBlocksDimensions(context, component, r) {
  const codOrCoc = component.codingStyleParameters;
  const result = {};

  if (!codOrCoc.entropyCoderWithCustomPrecincts) {
    result.PPx = 15;
    result.PPy = 15;
  } else {
    result.PPx = codOrCoc.precinctsSizes[r].PPx;
    result.PPy = codOrCoc.precinctsSizes[r].PPy;
  }

  result.xcb_ = r > 0 ? Math.min(codOrCoc.xcb, result.PPx - 1) : Math.min(codOrCoc.xcb, result.PPx);
  result.ycb_ = r > 0 ? Math.min(codOrCoc.ycb, result.PPy - 1) : Math.min(codOrCoc.ycb, result.PPy);
  return result;
}

function buildPrecincts(context, resolution, dimensions) {
  const precinctWidth = 1 << dimensions.PPx;
  const precinctHeight = 1 << dimensions.PPy;
  const isZeroRes = resolution.resLevel === 0;
  const precinctWidthInSubband = 1 << dimensions.PPx + (isZeroRes ? 0 : -1);
  const precinctHeightInSubband = 1 << dimensions.PPy + (isZeroRes ? 0 : -1);
  const numprecinctswide = resolution.trx1 > resolution.trx0 ? Math.ceil(resolution.trx1 / precinctWidth) - Math.floor(resolution.trx0 / precinctWidth) : 0;
  const numprecinctshigh = resolution.try1 > resolution.try0 ? Math.ceil(resolution.try1 / precinctHeight) - Math.floor(resolution.try0 / precinctHeight) : 0;
  const numprecincts = numprecinctswide * numprecinctshigh;
  resolution.precinctParameters = {
    precinctWidth,
    precinctHeight,
    numprecinctswide,
    numprecinctshigh,
    numprecincts,
    precinctWidthInSubband,
    precinctHeightInSubband
  };
}

function buildCodeblocks(context, subband, dimensions) {
  const xcb_ = dimensions.xcb_;
  const ycb_ = dimensions.ycb_;
  const codeblockWidth = 1 << xcb_;
  const codeblockHeight = 1 << ycb_;
  const cbx0 = subband.tbx0 >> xcb_;
  const cby0 = subband.tby0 >> ycb_;
  const cbx1 = subband.tbx1 + codeblockWidth - 1 >> xcb_;
  const cby1 = subband.tby1 + codeblockHeight - 1 >> ycb_;
  const precinctParameters = subband.resolution.precinctParameters;
  const codeblocks = [];
  const precincts = [];
  let i, j, codeblock, precinctNumber;

  for (j = cby0; j < cby1; j++) {
    for (i = cbx0; i < cbx1; i++) {
      codeblock = {
        cbx: i,
        cby: j,
        tbx0: codeblockWidth * i,
        tby0: codeblockHeight * j,
        tbx1: codeblockWidth * (i + 1),
        tby1: codeblockHeight * (j + 1)
      };
      codeblock.tbx0_ = Math.max(subband.tbx0, codeblock.tbx0);
      codeblock.tby0_ = Math.max(subband.tby0, codeblock.tby0);
      codeblock.tbx1_ = Math.min(subband.tbx1, codeblock.tbx1);
      codeblock.tby1_ = Math.min(subband.tby1, codeblock.tby1);
      const pi = Math.floor((codeblock.tbx0_ - subband.tbx0) / precinctParameters.precinctWidthInSubband);
      const pj = Math.floor((codeblock.tby0_ - subband.tby0) / precinctParameters.precinctHeightInSubband);
      precinctNumber = pi + pj * precinctParameters.numprecinctswide;
      codeblock.precinctNumber = precinctNumber;
      codeblock.subbandType = subband.type;
      codeblock.Lblock = 3;

      if (codeblock.tbx1_ <= codeblock.tbx0_ || codeblock.tby1_ <= codeblock.tby0_) {
        continue;
      }

      codeblocks.push(codeblock);
      let precinct = precincts[precinctNumber];

      if (precinct !== undefined) {
        if (i < precinct.cbxMin) {
          precinct.cbxMin = i;
        } else if (i > precinct.cbxMax) {
          precinct.cbxMax = i;
        }

        if (j < precinct.cbyMin) {
          precinct.cbxMin = j;
        } else if (j > precinct.cbyMax) {
          precinct.cbyMax = j;
        }
      } else {
        precincts[precinctNumber] = precinct = {
          cbxMin: i,
          cbyMin: j,
          cbxMax: i,
          cbyMax: j
        };
      }

      codeblock.precinct = precinct;
    }
  }

  subband.codeblockParameters = {
    codeblockWidth: xcb_,
    codeblockHeight: ycb_,
    numcodeblockwide: cbx1 - cbx0 + 1,
    numcodeblockhigh: cby1 - cby0 + 1
  };
  subband.codeblocks = codeblocks;
  subband.precincts = precincts;
}

function createPacket(resolution, precinctNumber, layerNumber) {
  const precinctCodeblocks = [];
  const subbands = resolution.subbands;

  for (let i = 0, ii = subbands.length; i < ii; i++) {
    const subband = subbands[i];
    const codeblocks = subband.codeblocks;

    for (let j = 0, jj = codeblocks.length; j < jj; j++) {
      const codeblock = codeblocks[j];

      if (codeblock.precinctNumber !== precinctNumber) {
        continue;
      }

      precinctCodeblocks.push(codeblock);
    }
  }

  return {
    layerNumber,
    codeblocks: precinctCodeblocks
  };
}

function LayerResolutionComponentPositionIterator(context) {
  const siz = context.SIZ;
  const tileIndex = context.currentTile.index;
  const tile = context.tiles[tileIndex];
  const layersCount = tile.codingStyleDefaultParameters.layersCount;
  const componentsCount = siz.Csiz;
  let maxDecompositionLevelsCount = 0;

  for (let q = 0; q < componentsCount; q++) {
    maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount, tile.components[q].codingStyleParameters.decompositionLevelsCount);
  }

  let l = 0,
      r = 0,
      i = 0,
      k = 0;

  this.nextPacket = function JpxImage_nextPacket() {
    for (; l < layersCount; l++) {
      for (; r <= maxDecompositionLevelsCount; r++) {
        for (; i < componentsCount; i++) {
          const component = tile.components[i];

          if (r > component.codingStyleParameters.decompositionLevelsCount) {
            continue;
          }

          const resolution = component.resolutions[r];
          const numprecincts = resolution.precinctParameters.numprecincts;

          for (; k < numprecincts;) {
            const packet = createPacket(resolution, k, l);
            k++;
            return packet;
          }

          k = 0;
        }

        i = 0;
      }

      r = 0;
    }

    throw new JpxError("Out of packets");
  };
}

function ResolutionLayerComponentPositionIterator(context) {
  const siz = context.SIZ;
  const tileIndex = context.currentTile.index;
  const tile = context.tiles[tileIndex];
  const layersCount = tile.codingStyleDefaultParameters.layersCount;
  const componentsCount = siz.Csiz;
  let maxDecompositionLevelsCount = 0;

  for (let q = 0; q < componentsCount; q++) {
    maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount, tile.components[q].codingStyleParameters.decompositionLevelsCount);
  }

  let r = 0,
      l = 0,
      i = 0,
      k = 0;

  this.nextPacket = function JpxImage_nextPacket() {
    for (; r <= maxDecompositionLevelsCount; r++) {
      for (; l < layersCount; l++) {
        for (; i < componentsCount; i++) {
          const component = tile.components[i];

          if (r > component.codingStyleParameters.decompositionLevelsCount) {
            continue;
          }

          const resolution = component.resolutions[r];
          const numprecincts = resolution.precinctParameters.numprecincts;

          for (; k < numprecincts;) {
            const packet = createPacket(resolution, k, l);
            k++;
            return packet;
          }

          k = 0;
        }

        i = 0;
      }

      l = 0;
    }

    throw new JpxError("Out of packets");
  };
}

function ResolutionPositionComponentLayerIterator(context) {
  const siz = context.SIZ;
  const tileIndex = context.currentTile.index;
  const tile = context.tiles[tileIndex];
  const layersCount = tile.codingStyleDefaultParameters.layersCount;
  const componentsCount = siz.Csiz;
  let l, r, c, p;
  let maxDecompositionLevelsCount = 0;

  for (c = 0; c < componentsCount; c++) {
    const component = tile.components[c];
    maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount, component.codingStyleParameters.decompositionLevelsCount);
  }

  const maxNumPrecinctsInLevel = new Int32Array(maxDecompositionLevelsCount + 1);

  for (r = 0; r <= maxDecompositionLevelsCount; ++r) {
    let maxNumPrecincts = 0;

    for (c = 0; c < componentsCount; ++c) {
      const resolutions = tile.components[c].resolutions;

      if (r < resolutions.length) {
        maxNumPrecincts = Math.max(maxNumPrecincts, resolutions[r].precinctParameters.numprecincts);
      }
    }

    maxNumPrecinctsInLevel[r] = maxNumPrecincts;
  }

  l = 0;
  r = 0;
  c = 0;
  p = 0;

  this.nextPacket = function JpxImage_nextPacket() {
    for (; r <= maxDecompositionLevelsCount; r++) {
      for (; p < maxNumPrecinctsInLevel[r]; p++) {
        for (; c < componentsCount; c++) {
          const component = tile.components[c];

          if (r > component.codingStyleParameters.decompositionLevelsCount) {
            continue;
          }

          const resolution = component.resolutions[r];
          const numprecincts = resolution.precinctParameters.numprecincts;

          if (p >= numprecincts) {
            continue;
          }

          for (; l < layersCount;) {
            const packet = createPacket(resolution, p, l);
            l++;
            return packet;
          }

          l = 0;
        }

        c = 0;
      }

      p = 0;
    }

    throw new JpxError("Out of packets");
  };
}

function PositionComponentResolutionLayerIterator(context) {
  const siz = context.SIZ;
  const tileIndex = context.currentTile.index;
  const tile = context.tiles[tileIndex];
  const layersCount = tile.codingStyleDefaultParameters.layersCount;
  const componentsCount = siz.Csiz;
  const precinctsSizes = getPrecinctSizesInImageScale(tile);
  const precinctsIterationSizes = precinctsSizes;
  let l = 0,
      r = 0,
      c = 0,
      px = 0,
      py = 0;

  this.nextPacket = function JpxImage_nextPacket() {
    for (; py < precinctsIterationSizes.maxNumHigh; py++) {
      for (; px < precinctsIterationSizes.maxNumWide; px++) {
        for (; c < componentsCount; c++) {
          const component = tile.components[c];
          const decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;

          for (; r <= decompositionLevelsCount; r++) {
            const resolution = component.resolutions[r];
            const sizeInImageScale = precinctsSizes.components[c].resolutions[r];
            const k = getPrecinctIndexIfExist(px, py, sizeInImageScale, precinctsIterationSizes, resolution);

            if (k === null) {
              continue;
            }

            for (; l < layersCount;) {
              const packet = createPacket(resolution, k, l);
              l++;
              return packet;
            }

            l = 0;
          }

          r = 0;
        }

        c = 0;
      }

      px = 0;
    }

    throw new JpxError("Out of packets");
  };
}

function ComponentPositionResolutionLayerIterator(context) {
  const siz = context.SIZ;
  const tileIndex = context.currentTile.index;
  const tile = context.tiles[tileIndex];
  const layersCount = tile.codingStyleDefaultParameters.layersCount;
  const componentsCount = siz.Csiz;
  const precinctsSizes = getPrecinctSizesInImageScale(tile);
  let l = 0,
      r = 0,
      c = 0,
      px = 0,
      py = 0;

  this.nextPacket = function JpxImage_nextPacket() {
    for (; c < componentsCount; ++c) {
      const component = tile.components[c];
      const precinctsIterationSizes = precinctsSizes.components[c];
      const decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;

      for (; py < precinctsIterationSizes.maxNumHigh; py++) {
        for (; px < precinctsIterationSizes.maxNumWide; px++) {
          for (; r <= decompositionLevelsCount; r++) {
            const resolution = component.resolutions[r];
            const sizeInImageScale = precinctsIterationSizes.resolutions[r];
            const k = getPrecinctIndexIfExist(px, py, sizeInImageScale, precinctsIterationSizes, resolution);

            if (k === null) {
              continue;
            }

            for (; l < layersCount;) {
              const packet = createPacket(resolution, k, l);
              l++;
              return packet;
            }

            l = 0;
          }

          r = 0;
        }

        px = 0;
      }

      py = 0;
    }

    throw new JpxError("Out of packets");
  };
}

function getPrecinctIndexIfExist(pxIndex, pyIndex, sizeInImageScale, precinctIterationSizes, resolution) {
  const posX = pxIndex * precinctIterationSizes.minWidth;
  const posY = pyIndex * precinctIterationSizes.minHeight;

  if (posX % sizeInImageScale.width !== 0 || posY % sizeInImageScale.height !== 0) {
    return null;
  }

  const startPrecinctRowIndex = posY / sizeInImageScale.width * resolution.precinctParameters.numprecinctswide;
  return posX / sizeInImageScale.height + startPrecinctRowIndex;
}

function getPrecinctSizesInImageScale(tile) {
  const componentsCount = tile.components.length;
  let minWidth = Number.MAX_VALUE;
  let minHeight = Number.MAX_VALUE;
  let maxNumWide = 0;
  let maxNumHigh = 0;
  const sizePerComponent = new Array(componentsCount);

  for (let c = 0; c < componentsCount; c++) {
    const component = tile.components[c];
    const decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;
    const sizePerResolution = new Array(decompositionLevelsCount + 1);
    let minWidthCurrentComponent = Number.MAX_VALUE;
    let minHeightCurrentComponent = Number.MAX_VALUE;
    let maxNumWideCurrentComponent = 0;
    let maxNumHighCurrentComponent = 0;
    let scale = 1;

    for (let r = decompositionLevelsCount; r >= 0; --r) {
      const resolution = component.resolutions[r];
      const widthCurrentResolution = scale * resolution.precinctParameters.precinctWidth;
      const heightCurrentResolution = scale * resolution.precinctParameters.precinctHeight;
      minWidthCurrentComponent = Math.min(minWidthCurrentComponent, widthCurrentResolution);
      minHeightCurrentComponent = Math.min(minHeightCurrentComponent, heightCurrentResolution);
      maxNumWideCurrentComponent = Math.max(maxNumWideCurrentComponent, resolution.precinctParameters.numprecinctswide);
      maxNumHighCurrentComponent = Math.max(maxNumHighCurrentComponent, resolution.precinctParameters.numprecinctshigh);
      sizePerResolution[r] = {
        width: widthCurrentResolution,
        height: heightCurrentResolution
      };
      scale <<= 1;
    }

    minWidth = Math.min(minWidth, minWidthCurrentComponent);
    minHeight = Math.min(minHeight, minHeightCurrentComponent);
    maxNumWide = Math.max(maxNumWide, maxNumWideCurrentComponent);
    maxNumHigh = Math.max(maxNumHigh, maxNumHighCurrentComponent);
    sizePerComponent[c] = {
      resolutions: sizePerResolution,
      minWidth: minWidthCurrentComponent,
      minHeight: minHeightCurrentComponent,
      maxNumWide: maxNumWideCurrentComponent,
      maxNumHigh: maxNumHighCurrentComponent
    };
  }

  return {
    components: sizePerComponent,
    minWidth,
    minHeight,
    maxNumWide,
    maxNumHigh
  };
}

function buildPackets(context) {
  const siz = context.SIZ;
  const tileIndex = context.currentTile.index;
  const tile = context.tiles[tileIndex];
  const componentsCount = siz.Csiz;

  for (let c = 0; c < componentsCount; c++) {
    const component = tile.components[c];
    const decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;
    const resolutions = [];
    const subbands = [];

    for (let r = 0; r <= decompositionLevelsCount; r++) {
      const blocksDimensions = getBlocksDimensions(context, component, r);
      const resolution = {};
      const scale = 1 << decompositionLevelsCount - r;
      resolution.trx0 = Math.ceil(component.tcx0 / scale);
      resolution.try0 = Math.ceil(component.tcy0 / scale);
      resolution.trx1 = Math.ceil(component.tcx1 / scale);
      resolution.try1 = Math.ceil(component.tcy1 / scale);
      resolution.resLevel = r;
      buildPrecincts(context, resolution, blocksDimensions);
      resolutions.push(resolution);
      let subband;

      if (r === 0) {
        subband = {};
        subband.type = "LL";
        subband.tbx0 = Math.ceil(component.tcx0 / scale);
        subband.tby0 = Math.ceil(component.tcy0 / scale);
        subband.tbx1 = Math.ceil(component.tcx1 / scale);
        subband.tby1 = Math.ceil(component.tcy1 / scale);
        subband.resolution = resolution;
        buildCodeblocks(context, subband, blocksDimensions);
        subbands.push(subband);
        resolution.subbands = [subband];
      } else {
        const bscale = 1 << decompositionLevelsCount - r + 1;
        const resolutionSubbands = [];
        subband = {};
        subband.type = "HL";
        subband.tbx0 = Math.ceil(component.tcx0 / bscale - 0.5);
        subband.tby0 = Math.ceil(component.tcy0 / bscale);
        subband.tbx1 = Math.ceil(component.tcx1 / bscale - 0.5);
        subband.tby1 = Math.ceil(component.tcy1 / bscale);
        subband.resolution = resolution;
        buildCodeblocks(context, subband, blocksDimensions);
        subbands.push(subband);
        resolutionSubbands.push(subband);
        subband = {};
        subband.type = "LH";
        subband.tbx0 = Math.ceil(component.tcx0 / bscale);
        subband.tby0 = Math.ceil(component.tcy0 / bscale - 0.5);
        subband.tbx1 = Math.ceil(component.tcx1 / bscale);
        subband.tby1 = Math.ceil(component.tcy1 / bscale - 0.5);
        subband.resolution = resolution;
        buildCodeblocks(context, subband, blocksDimensions);
        subbands.push(subband);
        resolutionSubbands.push(subband);
        subband = {};
        subband.type = "HH";
        subband.tbx0 = Math.ceil(component.tcx0 / bscale - 0.5);
        subband.tby0 = Math.ceil(component.tcy0 / bscale - 0.5);
        subband.tbx1 = Math.ceil(component.tcx1 / bscale - 0.5);
        subband.tby1 = Math.ceil(component.tcy1 / bscale - 0.5);
        subband.resolution = resolution;
        buildCodeblocks(context, subband, blocksDimensions);
        subbands.push(subband);
        resolutionSubbands.push(subband);
        resolution.subbands = resolutionSubbands;
      }
    }

    component.resolutions = resolutions;
    component.subbands = subbands;
  }

  const progressionOrder = tile.codingStyleDefaultParameters.progressionOrder;

  switch (progressionOrder) {
    case 0:
      tile.packetsIterator = new LayerResolutionComponentPositionIterator(context);
      break;

    case 1:
      tile.packetsIterator = new ResolutionLayerComponentPositionIterator(context);
      break;

    case 2:
      tile.packetsIterator = new ResolutionPositionComponentLayerIterator(context);
      break;

    case 3:
      tile.packetsIterator = new PositionComponentResolutionLayerIterator(context);
      break;

    case 4:
      tile.packetsIterator = new ComponentPositionResolutionLayerIterator(context);
      break;

    default:
      throw new JpxError(`Unsupported progression order ${progressionOrder}`);
  }
}

function parseTilePackets(context, data, offset, dataLength) {
  let position = 0;
  let buffer,
      bufferSize = 0,
      skipNextBit = false;

  function readBits(count) {
    while (bufferSize < count) {
      const b = data[offset + position];
      position++;

      if (skipNextBit) {
        buffer = buffer << 7 | b;
        bufferSize += 7;
        skipNextBit = false;
      } else {
        buffer = buffer << 8 | b;
        bufferSize += 8;
      }

      if (b === 0xff) {
        skipNextBit = true;
      }
    }

    bufferSize -= count;
    return buffer >>> bufferSize & (1 << count) - 1;
  }

  function skipMarkerIfEqual(value) {
    if (data[offset + position - 1] === 0xff && data[offset + position] === value) {
      skipBytes(1);
      return true;
    } else if (data[offset + position] === 0xff && data[offset + position + 1] === value) {
      skipBytes(2);
      return true;
    }

    return false;
  }

  function skipBytes(count) {
    position += count;
  }

  function alignToByte() {
    bufferSize = 0;

    if (skipNextBit) {
      position++;
      skipNextBit = false;
    }
  }

  function readCodingpasses() {
    if (readBits(1) === 0) {
      return 1;
    }

    if (readBits(1) === 0) {
      return 2;
    }

    let value = readBits(2);

    if (value < 3) {
      return value + 3;
    }

    value = readBits(5);

    if (value < 31) {
      return value + 6;
    }

    value = readBits(7);
    return value + 37;
  }

  const tileIndex = context.currentTile.index;
  const tile = context.tiles[tileIndex];
  const sopMarkerUsed = context.COD.sopMarkerUsed;
  const ephMarkerUsed = context.COD.ephMarkerUsed;
  const packetsIterator = tile.packetsIterator;

  while (position < dataLength) {
    alignToByte();

    if (sopMarkerUsed && skipMarkerIfEqual(0x91)) {
      skipBytes(4);
    }

    const packet = packetsIterator.nextPacket();

    if (!readBits(1)) {
      continue;
    }

    const layerNumber = packet.layerNumber,
          queue = [];
    let codeblock;

    for (let i = 0, ii = packet.codeblocks.length; i < ii; i++) {
      codeblock = packet.codeblocks[i];
      let precinct = codeblock.precinct;
      const codeblockColumn = codeblock.cbx - precinct.cbxMin;
      const codeblockRow = codeblock.cby - precinct.cbyMin;
      let codeblockIncluded = false;
      let firstTimeInclusion = false;
      let valueReady, zeroBitPlanesTree;

      if (codeblock.included !== undefined) {
        codeblockIncluded = !!readBits(1);
      } else {
        precinct = codeblock.precinct;
        let inclusionTree;

        if (precinct.inclusionTree !== undefined) {
          inclusionTree = precinct.inclusionTree;
        } else {
          const width = precinct.cbxMax - precinct.cbxMin + 1;
          const height = precinct.cbyMax - precinct.cbyMin + 1;
          inclusionTree = new InclusionTree(width, height, layerNumber);
          zeroBitPlanesTree = new TagTree(width, height);
          precinct.inclusionTree = inclusionTree;
          precinct.zeroBitPlanesTree = zeroBitPlanesTree;

          for (let l = 0; l < layerNumber; l++) {
            if (readBits(1) !== 0) {
              throw new JpxError("Invalid tag tree");
            }
          }
        }

        if (inclusionTree.reset(codeblockColumn, codeblockRow, layerNumber)) {
          while (true) {
            if (readBits(1)) {
              valueReady = !inclusionTree.nextLevel();

              if (valueReady) {
                codeblock.included = true;
                codeblockIncluded = firstTimeInclusion = true;
                break;
              }
            } else {
              inclusionTree.incrementValue(layerNumber);
              break;
            }
          }
        }
      }

      if (!codeblockIncluded) {
        continue;
      }

      if (firstTimeInclusion) {
        zeroBitPlanesTree = precinct.zeroBitPlanesTree;
        zeroBitPlanesTree.reset(codeblockColumn, codeblockRow);

        while (true) {
          if (readBits(1)) {
            valueReady = !zeroBitPlanesTree.nextLevel();

            if (valueReady) {
              break;
            }
          } else {
            zeroBitPlanesTree.incrementValue();
          }
        }

        codeblock.zeroBitPlanes = zeroBitPlanesTree.value;
      }

      const codingpasses = readCodingpasses();

      while (readBits(1)) {
        codeblock.Lblock++;
      }

      const codingpassesLog2 = (0, _core_utils.log2)(codingpasses);
      const bits = (codingpasses < 1 << codingpassesLog2 ? codingpassesLog2 - 1 : codingpassesLog2) + codeblock.Lblock;
      const codedDataLength = readBits(bits);
      queue.push({
        codeblock,
        codingpasses,
        dataLength: codedDataLength
      });
    }

    alignToByte();

    if (ephMarkerUsed) {
      skipMarkerIfEqual(0x92);
    }

    while (queue.length > 0) {
      const packetItem = queue.shift();
      codeblock = packetItem.codeblock;

      if (codeblock.data === undefined) {
        codeblock.data = [];
      }

      codeblock.data.push({
        data,
        start: offset + position,
        end: offset + position + packetItem.dataLength,
        codingpasses: packetItem.codingpasses
      });
      position += packetItem.dataLength;
    }
  }

  return position;
}

function copyCoefficients(coefficients, levelWidth, levelHeight, subband, delta, mb, reversible, segmentationSymbolUsed) {
  const x0 = subband.tbx0;
  const y0 = subband.tby0;
  const width = subband.tbx1 - subband.tbx0;
  const codeblocks = subband.codeblocks;
  const right = subband.type.charAt(0) === "H" ? 1 : 0;
  const bottom = subband.type.charAt(1) === "H" ? levelWidth : 0;

  for (let i = 0, ii = codeblocks.length; i < ii; ++i) {
    const codeblock = codeblocks[i];
    const blockWidth = codeblock.tbx1_ - codeblock.tbx0_;
    const blockHeight = codeblock.tby1_ - codeblock.tby0_;

    if (blockWidth === 0 || blockHeight === 0) {
      continue;
    }

    if (codeblock.data === undefined) {
      continue;
    }

    const bitModel = new BitModel(blockWidth, blockHeight, codeblock.subbandType, codeblock.zeroBitPlanes, mb);
    let currentCodingpassType = 2;
    const data = codeblock.data;
    let totalLength = 0,
        codingpasses = 0;
    let j, jj, dataItem;

    for (j = 0, jj = data.length; j < jj; j++) {
      dataItem = data[j];
      totalLength += dataItem.end - dataItem.start;
      codingpasses += dataItem.codingpasses;
    }

    const encodedData = new Uint8Array(totalLength);
    let position = 0;

    for (j = 0, jj = data.length; j < jj; j++) {
      dataItem = data[j];
      const chunk = dataItem.data.subarray(dataItem.start, dataItem.end);
      encodedData.set(chunk, position);
      position += chunk.length;
    }

    const decoder = new _arithmetic_decoder.ArithmeticDecoder(encodedData, 0, totalLength);
    bitModel.setDecoder(decoder);

    for (j = 0; j < codingpasses; j++) {
      switch (currentCodingpassType) {
        case 0:
          bitModel.runSignificancePropagationPass();
          break;

        case 1:
          bitModel.runMagnitudeRefinementPass();
          break;

        case 2:
          bitModel.runCleanupPass();

          if (segmentationSymbolUsed) {
            bitModel.checkSegmentationSymbol();
          }

          break;
      }

      currentCodingpassType = (currentCodingpassType + 1) % 3;
    }

    let offset = codeblock.tbx0_ - x0 + (codeblock.tby0_ - y0) * width;
    const sign = bitModel.coefficentsSign;
    const magnitude = bitModel.coefficentsMagnitude;
    const bitsDecoded = bitModel.bitsDecoded;
    const magnitudeCorrection = reversible ? 0 : 0.5;
    let k, n, nb;
    position = 0;
    const interleave = subband.type !== "LL";

    for (j = 0; j < blockHeight; j++) {
      const row = offset / width | 0;
      const levelOffset = 2 * row * (levelWidth - width) + right + bottom;

      for (k = 0; k < blockWidth; k++) {
        n = magnitude[position];

        if (n !== 0) {
          n = (n + magnitudeCorrection) * delta;

          if (sign[position] !== 0) {
            n = -n;
          }

          nb = bitsDecoded[position];
          const pos = interleave ? levelOffset + (offset << 1) : offset;

          if (reversible && nb >= mb) {
            coefficients[pos] = n;
          } else {
            coefficients[pos] = n * (1 << mb - nb);
          }
        }

        offset++;
        position++;
      }

      offset += width - blockWidth;
    }
  }
}

function transformTile(context, tile, c) {
  const component = tile.components[c];
  const codingStyleParameters = component.codingStyleParameters;
  const quantizationParameters = component.quantizationParameters;
  const decompositionLevelsCount = codingStyleParameters.decompositionLevelsCount;
  const spqcds = quantizationParameters.SPqcds;
  const scalarExpounded = quantizationParameters.scalarExpounded;
  const guardBits = quantizationParameters.guardBits;
  const segmentationSymbolUsed = codingStyleParameters.segmentationSymbolUsed;
  const precision = context.components[c].precision;
  const reversible = codingStyleParameters.reversibleTransformation;
  const transform = reversible ? new ReversibleTransform() : new IrreversibleTransform();
  const subbandCoefficients = [];
  let b = 0;

  for (let i = 0; i <= decompositionLevelsCount; i++) {
    const resolution = component.resolutions[i];
    const width = resolution.trx1 - resolution.trx0;
    const height = resolution.try1 - resolution.try0;
    const coefficients = new Float32Array(width * height);

    for (let j = 0, jj = resolution.subbands.length; j < jj; j++) {
      let mu, epsilon;

      if (!scalarExpounded) {
        mu = spqcds[0].mu;
        epsilon = spqcds[0].epsilon + (i > 0 ? 1 - i : 0);
      } else {
        mu = spqcds[b].mu;
        epsilon = spqcds[b].epsilon;
        b++;
      }

      const subband = resolution.subbands[j];
      const gainLog2 = SubbandsGainLog2[subband.type];
      const delta = reversible ? 1 : 2 ** (precision + gainLog2 - epsilon) * (1 + mu / 2048);
      const mb = guardBits + epsilon - 1;
      copyCoefficients(coefficients, width, height, subband, delta, mb, reversible, segmentationSymbolUsed);
    }

    subbandCoefficients.push({
      width,
      height,
      items: coefficients
    });
  }

  const result = transform.calculate(subbandCoefficients, component.tcx0, component.tcy0);
  return {
    left: component.tcx0,
    top: component.tcy0,
    width: result.width,
    height: result.height,
    items: result.items
  };
}

function transformComponents(context) {
  const siz = context.SIZ;
  const components = context.components;
  const componentsCount = siz.Csiz;
  const resultImages = [];

  for (let i = 0, ii = context.tiles.length; i < ii; i++) {
    const tile = context.tiles[i];
    const transformedTiles = [];

    for (let c = 0; c < componentsCount; c++) {
      transformedTiles[c] = transformTile(context, tile, c);
    }

    const tile0 = transformedTiles[0];
    const out = new Uint8ClampedArray(tile0.items.length * componentsCount);
    const result = {
      left: tile0.left,
      top: tile0.top,
      width: tile0.width,
      height: tile0.height,
      items: out
    };
    let shift, offset;
    let pos = 0,
        j,
        jj,
        y0,
        y1,
        y2;

    if (tile.codingStyleDefaultParameters.multipleComponentTransform) {
      const fourComponents = componentsCount === 4;
      const y0items = transformedTiles[0].items;
      const y1items = transformedTiles[1].items;
      const y2items = transformedTiles[2].items;
      const y3items = fourComponents ? transformedTiles[3].items : null;
      shift = components[0].precision - 8;
      offset = (128 << shift) + 0.5;
      const component0 = tile.components[0];
      const alpha01 = componentsCount - 3;
      jj = y0items.length;

      if (!component0.codingStyleParameters.reversibleTransformation) {
        for (j = 0; j < jj; j++, pos += alpha01) {
          y0 = y0items[j] + offset;
          y1 = y1items[j];
          y2 = y2items[j];
          out[pos++] = y0 + 1.402 * y2 >> shift;
          out[pos++] = y0 - 0.34413 * y1 - 0.71414 * y2 >> shift;
          out[pos++] = y0 + 1.772 * y1 >> shift;
        }
      } else {
        for (j = 0; j < jj; j++, pos += alpha01) {
          y0 = y0items[j] + offset;
          y1 = y1items[j];
          y2 = y2items[j];
          const g = y0 - (y2 + y1 >> 2);
          out[pos++] = g + y2 >> shift;
          out[pos++] = g >> shift;
          out[pos++] = g + y1 >> shift;
        }
      }

      if (fourComponents) {
        for (j = 0, pos = 3; j < jj; j++, pos += 4) {
          out[pos] = y3items[j] + offset >> shift;
        }
      }
    } else {
      for (let c = 0; c < componentsCount; c++) {
        const items = transformedTiles[c].items;
        shift = components[c].precision - 8;
        offset = (128 << shift) + 0.5;

        for (pos = c, j = 0, jj = items.length; j < jj; j++) {
          out[pos] = items[j] + offset >> shift;
          pos += componentsCount;
        }
      }
    }

    resultImages.push(result);
  }

  return resultImages;
}

function initializeTile(context, tileIndex) {
  const siz = context.SIZ;
  const componentsCount = siz.Csiz;
  const tile = context.tiles[tileIndex];

  for (let c = 0; c < componentsCount; c++) {
    const component = tile.components[c];
    const qcdOrQcc = context.currentTile.QCC[c] !== undefined ? context.currentTile.QCC[c] : context.currentTile.QCD;
    component.quantizationParameters = qcdOrQcc;
    const codOrCoc = context.currentTile.COC[c] !== undefined ? context.currentTile.COC[c] : context.currentTile.COD;
    component.codingStyleParameters = codOrCoc;
  }

  tile.codingStyleDefaultParameters = context.currentTile.COD;
}

class TagTree {
  constructor(width, height) {
    const levelsLength = (0, _core_utils.log2)(Math.max(width, height)) + 1;
    this.levels = [];

    for (let i = 0; i < levelsLength; i++) {
      const level = {
        width,
        height,
        items: []
      };
      this.levels.push(level);
      width = Math.ceil(width / 2);
      height = Math.ceil(height / 2);
    }
  }

  reset(i, j) {
    let currentLevel = 0,
        value = 0,
        level;

    while (currentLevel < this.levels.length) {
      level = this.levels[currentLevel];
      const index = i + j * level.width;

      if (level.items[index] !== undefined) {
        value = level.items[index];
        break;
      }

      level.index = index;
      i >>= 1;
      j >>= 1;
      currentLevel++;
    }

    currentLevel--;
    level = this.levels[currentLevel];
    level.items[level.index] = value;
    this.currentLevel = currentLevel;
    delete this.value;
  }

  incrementValue() {
    const level = this.levels[this.currentLevel];
    level.items[level.index]++;
  }

  nextLevel() {
    let currentLevel = this.currentLevel;
    let level = this.levels[currentLevel];
    const value = level.items[level.index];
    currentLevel--;

    if (currentLevel < 0) {
      this.value = value;
      return false;
    }

    this.currentLevel = currentLevel;
    level = this.levels[currentLevel];
    level.items[level.index] = value;
    return true;
  }

}

class InclusionTree {
  constructor(width, height, defaultValue) {
    const levelsLength = (0, _core_utils.log2)(Math.max(width, height)) + 1;
    this.levels = [];

    for (let i = 0; i < levelsLength; i++) {
      const items = new Uint8Array(width * height);

      for (let j = 0, jj = items.length; j < jj; j++) {
        items[j] = defaultValue;
      }

      const level = {
        width,
        height,
        items
      };
      this.levels.push(level);
      width = Math.ceil(width / 2);
      height = Math.ceil(height / 2);
    }
  }

  reset(i, j, stopValue) {
    let currentLevel = 0;

    while (currentLevel < this.levels.length) {
      const level = this.levels[currentLevel];
      const index = i + j * level.width;
      level.index = index;
      const value = level.items[index];

      if (value === 0xff) {
        break;
      }

      if (value > stopValue) {
        this.currentLevel = currentLevel;
        this.propagateValues();
        return false;
      }

      i >>= 1;
      j >>= 1;
      currentLevel++;
    }

    this.currentLevel = currentLevel - 1;
    return true;
  }

  incrementValue(stopValue) {
    const level = this.levels[this.currentLevel];
    level.items[level.index] = stopValue + 1;
    this.propagateValues();
  }

  propagateValues() {
    let levelIndex = this.currentLevel;
    let level = this.levels[levelIndex];
    const currentValue = level.items[level.index];

    while (--levelIndex >= 0) {
      level = this.levels[levelIndex];
      level.items[level.index] = currentValue;
    }
  }

  nextLevel() {
    let currentLevel = this.currentLevel;
    let level = this.levels[currentLevel];
    const value = level.items[level.index];
    level.items[level.index] = 0xff;
    currentLevel--;

    if (currentLevel < 0) {
      return false;
    }

    this.currentLevel = currentLevel;
    level = this.levels[currentLevel];
    level.items[level.index] = value;
    return true;
  }

}

const BitModel = function BitModelClosure() {
  const UNIFORM_CONTEXT = 17;
  const RUNLENGTH_CONTEXT = 18;
  const LLAndLHContextsLabel = new Uint8Array([0, 5, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 1, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8]);
  const HLContextLabel = new Uint8Array([0, 3, 4, 0, 5, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 1, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8]);
  const HHContextLabel = new Uint8Array([0, 1, 2, 0, 1, 2, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 3, 4, 5, 0, 4, 5, 5, 0, 5, 5, 5, 0, 0, 0, 0, 0, 6, 7, 7, 0, 7, 7, 7, 0, 7, 7, 7, 0, 0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8, 8, 0, 0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8, 8]);

  class BitModel {
    constructor(width, height, subband, zeroBitPlanes, mb) {
      this.width = width;
      this.height = height;
      let contextLabelTable;

      if (subband === "HH") {
        contextLabelTable = HHContextLabel;
      } else if (subband === "HL") {
        contextLabelTable = HLContextLabel;
      } else {
        contextLabelTable = LLAndLHContextsLabel;
      }

      this.contextLabelTable = contextLabelTable;
      const coefficientCount = width * height;
      this.neighborsSignificance = new Uint8Array(coefficientCount);
      this.coefficentsSign = new Uint8Array(coefficientCount);
      let coefficentsMagnitude;

      if (mb > 14) {
        coefficentsMagnitude = new Uint32Array(coefficientCount);
      } else if (mb > 6) {
        coefficentsMagnitude = new Uint16Array(coefficientCount);
      } else {
        coefficentsMagnitude = new Uint8Array(coefficientCount);
      }

      this.coefficentsMagnitude = coefficentsMagnitude;
      this.processingFlags = new Uint8Array(coefficientCount);
      const bitsDecoded = new Uint8Array(coefficientCount);

      if (zeroBitPlanes !== 0) {
        for (let i = 0; i < coefficientCount; i++) {
          bitsDecoded[i] = zeroBitPlanes;
        }
      }

      this.bitsDecoded = bitsDecoded;
      this.reset();
    }

    setDecoder(decoder) {
      this.decoder = decoder;
    }

    reset() {
      this.contexts = new Int8Array(19);
      this.contexts[0] = 4 << 1 | 0;
      this.contexts[UNIFORM_CONTEXT] = 46 << 1 | 0;
      this.contexts[RUNLENGTH_CONTEXT] = 3 << 1 | 0;
    }

    setNeighborsSignificance(row, column, index) {
      const neighborsSignificance = this.neighborsSignificance;
      const width = this.width,
            height = this.height;
      const left = column > 0;
      const right = column + 1 < width;
      let i;

      if (row > 0) {
        i = index - width;

        if (left) {
          neighborsSignificance[i - 1] += 0x10;
        }

        if (right) {
          neighborsSignificance[i + 1] += 0x10;
        }

        neighborsSignificance[i] += 0x04;
      }

      if (row + 1 < height) {
        i = index + width;

        if (left) {
          neighborsSignificance[i - 1] += 0x10;
        }

        if (right) {
          neighborsSignificance[i + 1] += 0x10;
        }

        neighborsSignificance[i] += 0x04;
      }

      if (left) {
        neighborsSignificance[index - 1] += 0x01;
      }

      if (right) {
        neighborsSignificance[index + 1] += 0x01;
      }

      neighborsSignificance[index] |= 0x80;
    }

    runSignificancePropagationPass() {
      const decoder = this.decoder;
      const width = this.width,
            height = this.height;
      const coefficentsMagnitude = this.coefficentsMagnitude;
      const coefficentsSign = this.coefficentsSign;
      const neighborsSignificance = this.neighborsSignificance;
      const processingFlags = this.processingFlags;
      const contexts = this.contexts;
      const labels = this.contextLabelTable;
      const bitsDecoded = this.bitsDecoded;
      const processedInverseMask = ~1;
      const processedMask = 1;
      const firstMagnitudeBitMask = 2;

      for (let i0 = 0; i0 < height; i0 += 4) {
        for (let j = 0; j < width; j++) {
          let index = i0 * width + j;

          for (let i1 = 0; i1 < 4; i1++, index += width) {
            const i = i0 + i1;

            if (i >= height) {
              break;
            }

            processingFlags[index] &= processedInverseMask;

            if (coefficentsMagnitude[index] || !neighborsSignificance[index]) {
              continue;
            }

            const contextLabel = labels[neighborsSignificance[index]];
            const decision = decoder.readBit(contexts, contextLabel);

            if (decision) {
              const sign = this.decodeSignBit(i, j, index);
              coefficentsSign[index] = sign;
              coefficentsMagnitude[index] = 1;
              this.setNeighborsSignificance(i, j, index);
              processingFlags[index] |= firstMagnitudeBitMask;
            }

            bitsDecoded[index]++;
            processingFlags[index] |= processedMask;
          }
        }
      }
    }

    decodeSignBit(row, column, index) {
      const width = this.width,
            height = this.height;
      const coefficentsMagnitude = this.coefficentsMagnitude;
      const coefficentsSign = this.coefficentsSign;
      let contribution, sign0, sign1, significance1;
      let contextLabel, decoded;
      significance1 = column > 0 && coefficentsMagnitude[index - 1] !== 0;

      if (column + 1 < width && coefficentsMagnitude[index + 1] !== 0) {
        sign1 = coefficentsSign[index + 1];

        if (significance1) {
          sign0 = coefficentsSign[index - 1];
          contribution = 1 - sign1 - sign0;
        } else {
          contribution = 1 - sign1 - sign1;
        }
      } else if (significance1) {
        sign0 = coefficentsSign[index - 1];
        contribution = 1 - sign0 - sign0;
      } else {
        contribution = 0;
      }

      const horizontalContribution = 3 * contribution;
      significance1 = row > 0 && coefficentsMagnitude[index - width] !== 0;

      if (row + 1 < height && coefficentsMagnitude[index + width] !== 0) {
        sign1 = coefficentsSign[index + width];

        if (significance1) {
          sign0 = coefficentsSign[index - width];
          contribution = 1 - sign1 - sign0 + horizontalContribution;
        } else {
          contribution = 1 - sign1 - sign1 + horizontalContribution;
        }
      } else if (significance1) {
        sign0 = coefficentsSign[index - width];
        contribution = 1 - sign0 - sign0 + horizontalContribution;
      } else {
        contribution = horizontalContribution;
      }

      if (contribution >= 0) {
        contextLabel = 9 + contribution;
        decoded = this.decoder.readBit(this.contexts, contextLabel);
      } else {
        contextLabel = 9 - contribution;
        decoded = this.decoder.readBit(this.contexts, contextLabel) ^ 1;
      }

      return decoded;
    }

    runMagnitudeRefinementPass() {
      const decoder = this.decoder;
      const width = this.width,
            height = this.height;
      const coefficentsMagnitude = this.coefficentsMagnitude;
      const neighborsSignificance = this.neighborsSignificance;
      const contexts = this.contexts;
      const bitsDecoded = this.bitsDecoded;
      const processingFlags = this.processingFlags;
      const processedMask = 1;
      const firstMagnitudeBitMask = 2;
      const length = width * height;
      const width4 = width * 4;

      for (let index0 = 0, indexNext; index0 < length; index0 = indexNext) {
        indexNext = Math.min(length, index0 + width4);

        for (let j = 0; j < width; j++) {
          for (let index = index0 + j; index < indexNext; index += width) {
            if (!coefficentsMagnitude[index] || (processingFlags[index] & processedMask) !== 0) {
              continue;
            }

            let contextLabel = 16;

            if ((processingFlags[index] & firstMagnitudeBitMask) !== 0) {
              processingFlags[index] ^= firstMagnitudeBitMask;
              const significance = neighborsSignificance[index] & 127;
              contextLabel = significance === 0 ? 15 : 14;
            }

            const bit = decoder.readBit(contexts, contextLabel);
            coefficentsMagnitude[index] = coefficentsMagnitude[index] << 1 | bit;
            bitsDecoded[index]++;
            processingFlags[index] |= processedMask;
          }
        }
      }
    }

    runCleanupPass() {
      const decoder = this.decoder;
      const width = this.width,
            height = this.height;
      const neighborsSignificance = this.neighborsSignificance;
      const coefficentsMagnitude = this.coefficentsMagnitude;
      const coefficentsSign = this.coefficentsSign;
      const contexts = this.contexts;
      const labels = this.contextLabelTable;
      const bitsDecoded = this.bitsDecoded;
      const processingFlags = this.processingFlags;
      const processedMask = 1;
      const firstMagnitudeBitMask = 2;
      const oneRowDown = width;
      const twoRowsDown = width * 2;
      const threeRowsDown = width * 3;
      let iNext;

      for (let i0 = 0; i0 < height; i0 = iNext) {
        iNext = Math.min(i0 + 4, height);
        const indexBase = i0 * width;
        const checkAllEmpty = i0 + 3 < height;

        for (let j = 0; j < width; j++) {
          const index0 = indexBase + j;
          const allEmpty = checkAllEmpty && processingFlags[index0] === 0 && processingFlags[index0 + oneRowDown] === 0 && processingFlags[index0 + twoRowsDown] === 0 && processingFlags[index0 + threeRowsDown] === 0 && neighborsSignificance[index0] === 0 && neighborsSignificance[index0 + oneRowDown] === 0 && neighborsSignificance[index0 + twoRowsDown] === 0 && neighborsSignificance[index0 + threeRowsDown] === 0;
          let i1 = 0,
              index = index0;
          let i = i0,
              sign;

          if (allEmpty) {
            const hasSignificantCoefficent = decoder.readBit(contexts, RUNLENGTH_CONTEXT);

            if (!hasSignificantCoefficent) {
              bitsDecoded[index0]++;
              bitsDecoded[index0 + oneRowDown]++;
              bitsDecoded[index0 + twoRowsDown]++;
              bitsDecoded[index0 + threeRowsDown]++;
              continue;
            }

            i1 = decoder.readBit(contexts, UNIFORM_CONTEXT) << 1 | decoder.readBit(contexts, UNIFORM_CONTEXT);

            if (i1 !== 0) {
              i = i0 + i1;
              index += i1 * width;
            }

            sign = this.decodeSignBit(i, j, index);
            coefficentsSign[index] = sign;
            coefficentsMagnitude[index] = 1;
            this.setNeighborsSignificance(i, j, index);
            processingFlags[index] |= firstMagnitudeBitMask;
            index = index0;

            for (let i2 = i0; i2 <= i; i2++, index += width) {
              bitsDecoded[index]++;
            }

            i1++;
          }

          for (i = i0 + i1; i < iNext; i++, index += width) {
            if (coefficentsMagnitude[index] || (processingFlags[index] & processedMask) !== 0) {
              continue;
            }

            const contextLabel = labels[neighborsSignificance[index]];
            const decision = decoder.readBit(contexts, contextLabel);

            if (decision === 1) {
              sign = this.decodeSignBit(i, j, index);
              coefficentsSign[index] = sign;
              coefficentsMagnitude[index] = 1;
              this.setNeighborsSignificance(i, j, index);
              processingFlags[index] |= firstMagnitudeBitMask;
            }

            bitsDecoded[index]++;
          }
        }
      }
    }

    checkSegmentationSymbol() {
      const decoder = this.decoder;
      const contexts = this.contexts;
      const symbol = decoder.readBit(contexts, UNIFORM_CONTEXT) << 3 | decoder.readBit(contexts, UNIFORM_CONTEXT) << 2 | decoder.readBit(contexts, UNIFORM_CONTEXT) << 1 | decoder.readBit(contexts, UNIFORM_CONTEXT);

      if (symbol !== 0xa) {
        throw new JpxError("Invalid segmentation symbol");
      }
    }

  }

  return BitModel;
}();

class Transform {
  constructor() {
    if (this.constructor === Transform) {
      (0, _util.unreachable)("Cannot initialize Transform.");
    }
  }

  calculate(subbands, u0, v0) {
    let ll = subbands[0];

    for (let i = 1, ii = subbands.length; i < ii; i++) {
      ll = this.iterate(ll, subbands[i], u0, v0);
    }

    return ll;
  }

  extend(buffer, offset, size) {
    let i1 = offset - 1,
        j1 = offset + 1;
    let i2 = offset + size - 2,
        j2 = offset + size;
    buffer[i1--] = buffer[j1++];
    buffer[j2++] = buffer[i2--];
    buffer[i1--] = buffer[j1++];
    buffer[j2++] = buffer[i2--];
    buffer[i1--] = buffer[j1++];
    buffer[j2++] = buffer[i2--];
    buffer[i1] = buffer[j1];
    buffer[j2] = buffer[i2];
  }

  filter(x, offset, length) {
    (0, _util.unreachable)("Abstract method `filter` called");
  }

  iterate(ll, hl_lh_hh, u0, v0) {
    const llWidth = ll.width,
          llHeight = ll.height;
    let llItems = ll.items;
    const width = hl_lh_hh.width;
    const height = hl_lh_hh.height;
    const items = hl_lh_hh.items;
    let i, j, k, l, u, v;

    for (k = 0, i = 0; i < llHeight; i++) {
      l = i * 2 * width;

      for (j = 0; j < llWidth; j++, k++, l += 2) {
        items[l] = llItems[k];
      }
    }

    llItems = ll.items = null;
    const bufferPadding = 4;
    const rowBuffer = new Float32Array(width + 2 * bufferPadding);

    if (width === 1) {
      if ((u0 & 1) !== 0) {
        for (v = 0, k = 0; v < height; v++, k += width) {
          items[k] *= 0.5;
        }
      }
    } else {
      for (v = 0, k = 0; v < height; v++, k += width) {
        rowBuffer.set(items.subarray(k, k + width), bufferPadding);
        this.extend(rowBuffer, bufferPadding, width);
        this.filter(rowBuffer, bufferPadding, width);
        items.set(rowBuffer.subarray(bufferPadding, bufferPadding + width), k);
      }
    }

    let numBuffers = 16;
    const colBuffers = [];

    for (i = 0; i < numBuffers; i++) {
      colBuffers.push(new Float32Array(height + 2 * bufferPadding));
    }

    let b,
        currentBuffer = 0;
    ll = bufferPadding + height;

    if (height === 1) {
      if ((v0 & 1) !== 0) {
        for (u = 0; u < width; u++) {
          items[u] *= 0.5;
        }
      }
    } else {
      for (u = 0; u < width; u++) {
        if (currentBuffer === 0) {
          numBuffers = Math.min(width - u, numBuffers);

          for (k = u, l = bufferPadding; l < ll; k += width, l++) {
            for (b = 0; b < numBuffers; b++) {
              colBuffers[b][l] = items[k + b];
            }
          }

          currentBuffer = numBuffers;
        }

        currentBuffer--;
        const buffer = colBuffers[currentBuffer];
        this.extend(buffer, bufferPadding, height);
        this.filter(buffer, bufferPadding, height);

        if (currentBuffer === 0) {
          k = u - numBuffers + 1;

          for (l = bufferPadding; l < ll; k += width, l++) {
            for (b = 0; b < numBuffers; b++) {
              items[k + b] = colBuffers[b][l];
            }
          }
        }
      }
    }

    return {
      width,
      height,
      items
    };
  }

}

class IrreversibleTransform extends Transform {
  filter(x, offset, length) {
    const len = length >> 1;
    offset |= 0;
    let j, n, current, next;
    const alpha = -1.586134342059924;
    const beta = -0.052980118572961;
    const gamma = 0.882911075530934;
    const delta = 0.443506852043971;
    const K = 1.230174104914001;
    const K_ = 1 / K;
    j = offset - 3;

    for (n = len + 4; n--; j += 2) {
      x[j] *= K_;
    }

    j = offset - 2;
    current = delta * x[j - 1];

    for (n = len + 3; n--; j += 2) {
      next = delta * x[j + 1];
      x[j] = K * x[j] - current - next;

      if (n--) {
        j += 2;
        current = delta * x[j + 1];
        x[j] = K * x[j] - current - next;
      } else {
        break;
      }
    }

    j = offset - 1;
    current = gamma * x[j - 1];

    for (n = len + 2; n--; j += 2) {
      next = gamma * x[j + 1];
      x[j] -= current + next;

      if (n--) {
        j += 2;
        current = gamma * x[j + 1];
        x[j] -= current + next;
      } else {
        break;
      }
    }

    j = offset;
    current = beta * x[j - 1];

    for (n = len + 1; n--; j += 2) {
      next = beta * x[j + 1];
      x[j] -= current + next;

      if (n--) {
        j += 2;
        current = beta * x[j + 1];
        x[j] -= current + next;
      } else {
        break;
      }
    }

    if (len !== 0) {
      j = offset + 1;
      current = alpha * x[j - 1];

      for (n = len; n--; j += 2) {
        next = alpha * x[j + 1];
        x[j] -= current + next;

        if (n--) {
          j += 2;
          current = alpha * x[j + 1];
          x[j] -= current + next;
        } else {
          break;
        }
      }
    }
  }

}

class ReversibleTransform extends Transform {
  filter(x, offset, length) {
    const len = length >> 1;
    offset |= 0;
    let j, n;

    for (j = offset, n = len + 1; n--; j += 2) {
      x[j] -= x[j - 1] + x[j + 1] + 2 >> 2;
    }

    for (j = offset + 1, n = len; n--; j += 2) {
      x[j] += x[j - 1] + x[j + 1] >> 1;
    }
  }

}

/***/ }),
/* 41 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LZWStream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

class LZWStream extends _decode_stream.DecodeStream {
  constructor(str, maybeLength, earlyChange) {
    super(maybeLength);
    this.str = str;
    this.dict = str.dict;
    this.cachedData = 0;
    this.bitsCached = 0;
    const maxLzwDictionarySize = 4096;
    const lzwState = {
      earlyChange,
      codeLength: 9,
      nextCode: 258,
      dictionaryValues: new Uint8Array(maxLzwDictionarySize),
      dictionaryLengths: new Uint16Array(maxLzwDictionarySize),
      dictionaryPrevCodes: new Uint16Array(maxLzwDictionarySize),
      currentSequence: new Uint8Array(maxLzwDictionarySize),
      currentSequenceLength: 0
    };

    for (let i = 0; i < 256; ++i) {
      lzwState.dictionaryValues[i] = i;
      lzwState.dictionaryLengths[i] = 1;
    }

    this.lzwState = lzwState;
  }

  readBits(n) {
    let bitsCached = this.bitsCached;
    let cachedData = this.cachedData;

    while (bitsCached < n) {
      const c = this.str.getByte();

      if (c === -1) {
        this.eof = true;
        return null;
      }

      cachedData = cachedData << 8 | c;
      bitsCached += 8;
    }

    this.bitsCached = bitsCached -= n;
    this.cachedData = cachedData;
    this.lastCode = null;
    return cachedData >>> bitsCached & (1 << n) - 1;
  }

  readBlock() {
    const blockSize = 512,
          decodedSizeDelta = blockSize;
    let estimatedDecodedSize = blockSize * 2;
    let i, j, q;
    const lzwState = this.lzwState;

    if (!lzwState) {
      return;
    }

    const earlyChange = lzwState.earlyChange;
    let nextCode = lzwState.nextCode;
    const dictionaryValues = lzwState.dictionaryValues;
    const dictionaryLengths = lzwState.dictionaryLengths;
    const dictionaryPrevCodes = lzwState.dictionaryPrevCodes;
    let codeLength = lzwState.codeLength;
    let prevCode = lzwState.prevCode;
    const currentSequence = lzwState.currentSequence;
    let currentSequenceLength = lzwState.currentSequenceLength;
    let decodedLength = 0;
    let currentBufferLength = this.bufferLength;
    let buffer = this.ensureBuffer(this.bufferLength + estimatedDecodedSize);

    for (i = 0; i < blockSize; i++) {
      const code = this.readBits(codeLength);
      const hasPrev = currentSequenceLength > 0;

      if (code < 256) {
        currentSequence[0] = code;
        currentSequenceLength = 1;
      } else if (code >= 258) {
        if (code < nextCode) {
          currentSequenceLength = dictionaryLengths[code];

          for (j = currentSequenceLength - 1, q = code; j >= 0; j--) {
            currentSequence[j] = dictionaryValues[q];
            q = dictionaryPrevCodes[q];
          }
        } else {
          currentSequence[currentSequenceLength++] = currentSequence[0];
        }
      } else if (code === 256) {
        codeLength = 9;
        nextCode = 258;
        currentSequenceLength = 0;
        continue;
      } else {
        this.eof = true;
        delete this.lzwState;
        break;
      }

      if (hasPrev) {
        dictionaryPrevCodes[nextCode] = prevCode;
        dictionaryLengths[nextCode] = dictionaryLengths[prevCode] + 1;
        dictionaryValues[nextCode] = currentSequence[0];
        nextCode++;
        codeLength = nextCode + earlyChange & nextCode + earlyChange - 1 ? codeLength : Math.min(Math.log(nextCode + earlyChange) / 0.6931471805599453 + 1, 12) | 0;
      }

      prevCode = code;
      decodedLength += currentSequenceLength;

      if (estimatedDecodedSize < decodedLength) {
        do {
          estimatedDecodedSize += decodedSizeDelta;
        } while (estimatedDecodedSize < decodedLength);

        buffer = this.ensureBuffer(this.bufferLength + estimatedDecodedSize);
      }

      for (j = 0; j < currentSequenceLength; j++) {
        buffer[currentBufferLength++] = currentSequence[j];
      }
    }

    lzwState.nextCode = nextCode;
    lzwState.codeLength = codeLength;
    lzwState.prevCode = prevCode;
    lzwState.currentSequenceLength = currentSequenceLength;
    this.bufferLength = currentBufferLength;
  }

}

exports.LZWStream = LZWStream;

/***/ }),
/* 42 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PredictorStream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

var _util = __w_pdfjs_require__(2);

var _primitives = __w_pdfjs_require__(5);

class PredictorStream extends _decode_stream.DecodeStream {
  constructor(str, maybeLength, params) {
    super(maybeLength);

    if (!(0, _primitives.isDict)(params)) {
      return str;
    }

    const predictor = this.predictor = params.get("Predictor") || 1;

    if (predictor <= 1) {
      return str;
    }

    if (predictor !== 2 && (predictor < 10 || predictor > 15)) {
      throw new _util.FormatError(`Unsupported predictor: ${predictor}`);
    }

    if (predictor === 2) {
      this.readBlock = this.readBlockTiff;
    } else {
      this.readBlock = this.readBlockPng;
    }

    this.str = str;
    this.dict = str.dict;
    const colors = this.colors = params.get("Colors") || 1;
    const bits = this.bits = params.get("BPC", "BitsPerComponent") || 8;
    const columns = this.columns = params.get("Columns") || 1;
    this.pixBytes = colors * bits + 7 >> 3;
    this.rowBytes = columns * colors * bits + 7 >> 3;
    return this;
  }

  readBlockTiff() {
    const rowBytes = this.rowBytes;
    const bufferLength = this.bufferLength;
    const buffer = this.ensureBuffer(bufferLength + rowBytes);
    const bits = this.bits;
    const colors = this.colors;
    const rawBytes = this.str.getBytes(rowBytes);
    this.eof = !rawBytes.length;

    if (this.eof) {
      return;
    }

    let inbuf = 0,
        outbuf = 0;
    let inbits = 0,
        outbits = 0;
    let pos = bufferLength;
    let i;

    if (bits === 1 && colors === 1) {
      for (i = 0; i < rowBytes; ++i) {
        let c = rawBytes[i] ^ inbuf;
        c ^= c >> 1;
        c ^= c >> 2;
        c ^= c >> 4;
        inbuf = (c & 1) << 7;
        buffer[pos++] = c;
      }
    } else if (bits === 8) {
      for (i = 0; i < colors; ++i) {
        buffer[pos++] = rawBytes[i];
      }

      for (; i < rowBytes; ++i) {
        buffer[pos] = buffer[pos - colors] + rawBytes[i];
        pos++;
      }
    } else if (bits === 16) {
      const bytesPerPixel = colors * 2;

      for (i = 0; i < bytesPerPixel; ++i) {
        buffer[pos++] = rawBytes[i];
      }

      for (; i < rowBytes; i += 2) {
        const sum = ((rawBytes[i] & 0xff) << 8) + (rawBytes[i + 1] & 0xff) + ((buffer[pos - bytesPerPixel] & 0xff) << 8) + (buffer[pos - bytesPerPixel + 1] & 0xff);
        buffer[pos++] = sum >> 8 & 0xff;
        buffer[pos++] = sum & 0xff;
      }
    } else {
      const compArray = new Uint8Array(colors + 1);
      const bitMask = (1 << bits) - 1;
      let j = 0,
          k = bufferLength;
      const columns = this.columns;

      for (i = 0; i < columns; ++i) {
        for (let kk = 0; kk < colors; ++kk) {
          if (inbits < bits) {
            inbuf = inbuf << 8 | rawBytes[j++] & 0xff;
            inbits += 8;
          }

          compArray[kk] = compArray[kk] + (inbuf >> inbits - bits) & bitMask;
          inbits -= bits;
          outbuf = outbuf << bits | compArray[kk];
          outbits += bits;

          if (outbits >= 8) {
            buffer[k++] = outbuf >> outbits - 8 & 0xff;
            outbits -= 8;
          }
        }
      }

      if (outbits > 0) {
        buffer[k++] = (outbuf << 8 - outbits) + (inbuf & (1 << 8 - outbits) - 1);
      }
    }

    this.bufferLength += rowBytes;
  }

  readBlockPng() {
    const rowBytes = this.rowBytes;
    const pixBytes = this.pixBytes;
    const predictor = this.str.getByte();
    const rawBytes = this.str.getBytes(rowBytes);
    this.eof = !rawBytes.length;

    if (this.eof) {
      return;
    }

    const bufferLength = this.bufferLength;
    const buffer = this.ensureBuffer(bufferLength + rowBytes);
    let prevRow = buffer.subarray(bufferLength - rowBytes, bufferLength);

    if (prevRow.length === 0) {
      prevRow = new Uint8Array(rowBytes);
    }

    let i,
        j = bufferLength,
        up,
        c;

    switch (predictor) {
      case 0:
        for (i = 0; i < rowBytes; ++i) {
          buffer[j++] = rawBytes[i];
        }

        break;

      case 1:
        for (i = 0; i < pixBytes; ++i) {
          buffer[j++] = rawBytes[i];
        }

        for (; i < rowBytes; ++i) {
          buffer[j] = buffer[j - pixBytes] + rawBytes[i] & 0xff;
          j++;
        }

        break;

      case 2:
        for (i = 0; i < rowBytes; ++i) {
          buffer[j++] = prevRow[i] + rawBytes[i] & 0xff;
        }

        break;

      case 3:
        for (i = 0; i < pixBytes; ++i) {
          buffer[j++] = (prevRow[i] >> 1) + rawBytes[i];
        }

        for (; i < rowBytes; ++i) {
          buffer[j] = (prevRow[i] + buffer[j - pixBytes] >> 1) + rawBytes[i] & 0xff;
          j++;
        }

        break;

      case 4:
        for (i = 0; i < pixBytes; ++i) {
          up = prevRow[i];
          c = rawBytes[i];
          buffer[j++] = up + c;
        }

        for (; i < rowBytes; ++i) {
          up = prevRow[i];
          const upLeft = prevRow[i - pixBytes];
          const left = buffer[j - pixBytes];
          const p = left + up - upLeft;
          let pa = p - left;

          if (pa < 0) {
            pa = -pa;
          }

          let pb = p - up;

          if (pb < 0) {
            pb = -pb;
          }

          let pc = p - upLeft;

          if (pc < 0) {
            pc = -pc;
          }

          c = rawBytes[i];

          if (pa <= pb && pa <= pc) {
            buffer[j++] = left + c;
          } else if (pb <= pc) {
            buffer[j++] = up + c;
          } else {
            buffer[j++] = upLeft + c;
          }
        }

        break;

      default:
        throw new _util.FormatError(`Unsupported predictor: ${predictor}`);
    }

    this.bufferLength += rowBytes;
  }

}

exports.PredictorStream = PredictorStream;

/***/ }),
/* 43 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.RunLengthStream = void 0;

var _decode_stream = __w_pdfjs_require__(29);

class RunLengthStream extends _decode_stream.DecodeStream {
  constructor(str, maybeLength) {
    super(maybeLength);
    this.str = str;
    this.dict = str.dict;
  }

  readBlock() {
    const repeatHeader = this.str.getBytes(2);

    if (!repeatHeader || repeatHeader.length < 2 || repeatHeader[0] === 128) {
      this.eof = true;
      return;
    }

    let buffer;
    let bufferLength = this.bufferLength;
    let n = repeatHeader[0];

    if (n < 128) {
      buffer = this.ensureBuffer(bufferLength + n + 1);
      buffer[bufferLength++] = repeatHeader[1];

      if (n > 0) {
        const source = this.str.getBytes(n);
        buffer.set(source, bufferLength);
        bufferLength += n;
      }
    } else {
      n = 257 - n;
      const b = repeatHeader[1];
      buffer = this.ensureBuffer(bufferLength + n + 1);

      for (let i = 0; i < n; i++) {
        buffer[bufferLength++] = b;
      }
    }

    this.bufferLength = bufferLength;
  }

}

exports.RunLengthStream = RunLengthStream;

/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Font = exports.ErrorFont = void 0;

var _util = __w_pdfjs_require__(2);

var _cff_parser = __w_pdfjs_require__(45);

var _fonts_utils = __w_pdfjs_require__(18);

var _glyphlist = __w_pdfjs_require__(20);

var _encodings = __w_pdfjs_require__(19);

var _standard_fonts = __w_pdfjs_require__(47);

var _unicode = __w_pdfjs_require__(21);

var _to_unicode_map = __w_pdfjs_require__(48);

var _cff_font = __w_pdfjs_require__(49);

var _font_renderer = __w_pdfjs_require__(50);

var _glyf = __w_pdfjs_require__(51);

var _cmap = __w_pdfjs_require__(26);

var _opentype_file_builder = __w_pdfjs_require__(52);

var _core_utils = __w_pdfjs_require__(9);

var _stream = __w_pdfjs_require__(10);

var _type1_font = __w_pdfjs_require__(53);

const PRIVATE_USE_AREAS = [[0xe000, 0xf8ff], [0x100000, 0x10fffd]];
const PDF_GLYPH_SPACE_UNITS = 1000;
const EXPORT_DATA_PROPERTIES = ["ascent", "bbox", "black", "bold", "charProcOperatorList", "composite", "cssFontInfo", "data", "defaultVMetrics", "defaultWidth", "descent", "fallbackName", "fontMatrix", "fontType", "isType3Font", "italic", "loadedName", "mimetype", "missingFile", "name", "remeasure", "subtype", "type", "vertical"];
const EXPORT_DATA_EXTRA_PROPERTIES = ["cMap", "defaultEncoding", "differences", "isMonospace", "isSerifFont", "isSymbolicFont", "seacMap", "toFontChar", "toUnicode", "vmetrics", "widths"];

function adjustWidths(properties) {
  if (!properties.fontMatrix) {
    return;
  }

  if (properties.fontMatrix[0] === _util.FONT_IDENTITY_MATRIX[0]) {
    return;
  }

  const scale = 0.001 / properties.fontMatrix[0];
  const glyphsWidths = properties.widths;

  for (const glyph in glyphsWidths) {
    glyphsWidths[glyph] *= scale;
  }

  properties.defaultWidth *= scale;
}

function adjustToUnicode(properties, builtInEncoding) {
  if (properties.isInternalFont) {
    return;
  }

  if (builtInEncoding === properties.defaultEncoding) {
    return;
  }

  if (properties.toUnicode instanceof _to_unicode_map.IdentityToUnicodeMap) {
    return;
  }

  const toUnicode = [],
        glyphsUnicodeMap = (0, _glyphlist.getGlyphsUnicode)();

  for (const charCode in builtInEncoding) {
    if (properties.hasIncludedToUnicodeMap) {
      if (properties.toUnicode.has(charCode)) {
        continue;
      }
    } else if (properties.hasEncoding) {
      if (properties.differences.length === 0 || properties.differences[charCode] !== undefined) {
        continue;
      }
    }

    const glyphName = builtInEncoding[charCode];
    const unicode = (0, _unicode.getUnicodeForGlyph)(glyphName, glyphsUnicodeMap);

    if (unicode !== -1) {
      toUnicode[charCode] = String.fromCharCode(unicode);
    }
  }

  if (toUnicode.length > 0) {
    properties.toUnicode.amend(toUnicode);
  }
}

function amendFallbackToUnicode(properties) {
  if (!properties.fallbackToUnicode) {
    return;
  }

  if (properties.toUnicode instanceof _to_unicode_map.IdentityToUnicodeMap) {
    return;
  }

  const toUnicode = [];

  for (const charCode in properties.fallbackToUnicode) {
    if (properties.toUnicode.has(charCode)) {
      continue;
    }

    toUnicode[charCode] = properties.fallbackToUnicode[charCode];
  }

  if (toUnicode.length > 0) {
    properties.toUnicode.amend(toUnicode);
  }
}

class Glyph {
  constructor(originalCharCode, fontChar, unicode, accent, width, vmetric, operatorListId, isSpace, isInFont) {
    this.originalCharCode = originalCharCode;
    this.fontChar = fontChar;
    this.unicode = unicode;
    this.accent = accent;
    this.width = width;
    this.vmetric = vmetric;
    this.operatorListId = operatorListId;
    this.isSpace = isSpace;
    this.isInFont = isInFont;
  }

  matchesForCache(originalCharCode, fontChar, unicode, accent, width, vmetric, operatorListId, isSpace, isInFont) {
    return this.originalCharCode === originalCharCode && this.fontChar === fontChar && this.unicode === unicode && this.accent === accent && this.width === width && this.vmetric === vmetric && this.operatorListId === operatorListId && this.isSpace === isSpace && this.isInFont === isInFont;
  }

}

function int16(b0, b1) {
  return (b0 << 8) + b1;
}

function writeSignedInt16(bytes, index, value) {
  bytes[index + 1] = value;
  bytes[index] = value >>> 8;
}

function signedInt16(b0, b1) {
  const value = (b0 << 8) + b1;
  return value & 1 << 15 ? value - 0x10000 : value;
}

function int32(b0, b1, b2, b3) {
  return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
}

function string16(value) {
  return String.fromCharCode(value >> 8 & 0xff, value & 0xff);
}

function safeString16(value) {
  if (value > 0x7fff) {
    value = 0x7fff;
  } else if (value < -0x8000) {
    value = -0x8000;
  }

  return String.fromCharCode(value >> 8 & 0xff, value & 0xff);
}

function isTrueTypeFile(file) {
  const header = file.peekBytes(4);
  return (0, _core_utils.readUint32)(header, 0) === 0x00010000 || (0, _util.bytesToString)(header) === "true";
}

function isTrueTypeCollectionFile(file) {
  const header = file.peekBytes(4);
  return (0, _util.bytesToString)(header) === "ttcf";
}

function isOpenTypeFile(file) {
  const header = file.peekBytes(4);
  return (0, _util.bytesToString)(header) === "OTTO";
}

function isType1File(file) {
  const header = file.peekBytes(2);

  if (header[0] === 0x25 && header[1] === 0x21) {
    return true;
  }

  if (header[0] === 0x80 && header[1] === 0x01) {
    return true;
  }

  return false;
}

function isCFFFile(file) {
  const header = file.peekBytes(4);

  if (header[0] >= 1 && header[3] >= 1 && header[3] <= 4) {
    return true;
  }

  return false;
}

function getFontFileType(file, {
  type,
  subtype,
  composite
}) {
  let fileType, fileSubtype;

  if (isTrueTypeFile(file) || isTrueTypeCollectionFile(file)) {
    if (composite) {
      fileType = "CIDFontType2";
    } else {
      fileType = "TrueType";
    }
  } else if (isOpenTypeFile(file)) {
    if (composite) {
      fileType = "CIDFontType2";
    } else {
      fileType = "OpenType";
    }
  } else if (isType1File(file)) {
    if (composite) {
      fileType = "CIDFontType0";
    } else {
      fileType = type === "MMType1" ? "MMType1" : "Type1";
    }
  } else if (isCFFFile(file)) {
    if (composite) {
      fileType = "CIDFontType0";
      fileSubtype = "CIDFontType0C";
    } else {
      fileType = type === "MMType1" ? "MMType1" : "Type1";
      fileSubtype = "Type1C";
    }
  } else {
    (0, _util.warn)("getFontFileType: Unable to detect correct font file Type/Subtype.");
    fileType = type;
    fileSubtype = subtype;
  }

  return [fileType, fileSubtype];
}

function applyStandardFontGlyphMap(map, glyphMap) {
  for (const charCode in glyphMap) {
    map[+charCode] = glyphMap[charCode];
  }
}

function buildToFontChar(encoding, glyphsUnicodeMap, differences) {
  const toFontChar = [];
  let unicode;

  for (let i = 0, ii = encoding.length; i < ii; i++) {
    unicode = (0, _unicode.getUnicodeForGlyph)(encoding[i], glyphsUnicodeMap);

    if (unicode !== -1) {
      toFontChar[i] = unicode;
    }
  }

  for (const charCode in differences) {
    unicode = (0, _unicode.getUnicodeForGlyph)(differences[charCode], glyphsUnicodeMap);

    if (unicode !== -1) {
      toFontChar[+charCode] = unicode;
    }
  }

  return toFontChar;
}

function convertCidString(charCode, cid, shouldThrow = false) {
  switch (cid.length) {
    case 1:
      return cid.charCodeAt(0);

    case 2:
      return cid.charCodeAt(0) << 8 | cid.charCodeAt(1);
  }

  const msg = `Unsupported CID string (charCode ${charCode}): "${cid}".`;

  if (shouldThrow) {
    throw new _util.FormatError(msg);
  }

  (0, _util.warn)(msg);
  return cid;
}

function adjustMapping(charCodeToGlyphId, hasGlyph, newGlyphZeroId) {
  const newMap = Object.create(null);
  const toFontChar = [];
  let privateUseAreaIndex = 0;
  let nextAvailableFontCharCode = PRIVATE_USE_AREAS[privateUseAreaIndex][0];
  let privateUseOffetEnd = PRIVATE_USE_AREAS[privateUseAreaIndex][1];

  for (let originalCharCode in charCodeToGlyphId) {
    originalCharCode |= 0;
    let glyphId = charCodeToGlyphId[originalCharCode];

    if (!hasGlyph(glyphId)) {
      continue;
    }

    if (nextAvailableFontCharCode > privateUseOffetEnd) {
      privateUseAreaIndex++;

      if (privateUseAreaIndex >= PRIVATE_USE_AREAS.length) {
        (0, _util.warn)("Ran out of space in font private use area.");
        break;
      }

      nextAvailableFontCharCode = PRIVATE_USE_AREAS[privateUseAreaIndex][0];
      privateUseOffetEnd = PRIVATE_USE_AREAS[privateUseAreaIndex][1];
    }

    const fontCharCode = nextAvailableFontCharCode++;

    if (glyphId === 0) {
      glyphId = newGlyphZeroId;
    }

    newMap[fontCharCode] = glyphId;
    toFontChar[originalCharCode] = fontCharCode;
  }

  return {
    toFontChar,
    charCodeToGlyphId: newMap,
    nextAvailableFontCharCode
  };
}

function getRanges(glyphs, numGlyphs) {
  const codes = [];

  for (const charCode in glyphs) {
    if (glyphs[charCode] >= numGlyphs) {
      continue;
    }

    codes.push({
      fontCharCode: charCode | 0,
      glyphId: glyphs[charCode]
    });
  }

  if (codes.length === 0) {
    codes.push({
      fontCharCode: 0,
      glyphId: 0
    });
  }

  codes.sort(function fontGetRangesSort(a, b) {
    return a.fontCharCode - b.fontCharCode;
  });
  const ranges = [];
  const length = codes.length;

  for (let n = 0; n < length;) {
    const start = codes[n].fontCharCode;
    const codeIndices = [codes[n].glyphId];
    ++n;
    let end = start;

    while (n < length && end + 1 === codes[n].fontCharCode) {
      codeIndices.push(codes[n].glyphId);
      ++end;
      ++n;

      if (end === 0xffff) {
        break;
      }
    }

    ranges.push([start, end, codeIndices]);
  }

  return ranges;
}

function createCmapTable(glyphs, numGlyphs) {
  const ranges = getRanges(glyphs, numGlyphs);
  const numTables = ranges[ranges.length - 1][1] > 0xffff ? 2 : 1;
  let cmap = "\x00\x00" + string16(numTables) + "\x00\x03" + "\x00\x01" + (0, _util.string32)(4 + numTables * 8);
  let i, ii, j, jj;

  for (i = ranges.length - 1; i >= 0; --i) {
    if (ranges[i][0] <= 0xffff) {
      break;
    }
  }

  const bmpLength = i + 1;

  if (ranges[i][0] < 0xffff && ranges[i][1] === 0xffff) {
    ranges[i][1] = 0xfffe;
  }

  const trailingRangesCount = ranges[i][1] < 0xffff ? 1 : 0;
  const segCount = bmpLength + trailingRangesCount;

  const searchParams = _opentype_file_builder.OpenTypeFileBuilder.getSearchParams(segCount, 2);

  let startCount = "";
  let endCount = "";
  let idDeltas = "";
  let idRangeOffsets = "";
  let glyphsIds = "";
  let bias = 0;
  let range, start, end, codes;

  for (i = 0, ii = bmpLength; i < ii; i++) {
    range = ranges[i];
    start = range[0];
    end = range[1];
    startCount += string16(start);
    endCount += string16(end);
    codes = range[2];
    let contiguous = true;

    for (j = 1, jj = codes.length; j < jj; ++j) {
      if (codes[j] !== codes[j - 1] + 1) {
        contiguous = false;
        break;
      }
    }

    if (!contiguous) {
      const offset = (segCount - i) * 2 + bias * 2;
      bias += end - start + 1;
      idDeltas += string16(0);
      idRangeOffsets += string16(offset);

      for (j = 0, jj = codes.length; j < jj; ++j) {
        glyphsIds += string16(codes[j]);
      }
    } else {
      const startCode = codes[0];
      idDeltas += string16(startCode - start & 0xffff);
      idRangeOffsets += string16(0);
    }
  }

  if (trailingRangesCount > 0) {
    endCount += "\xFF\xFF";
    startCount += "\xFF\xFF";
    idDeltas += "\x00\x01";
    idRangeOffsets += "\x00\x00";
  }

  const format314 = "\x00\x00" + string16(2 * segCount) + string16(searchParams.range) + string16(searchParams.entry) + string16(searchParams.rangeShift) + endCount + "\x00\x00" + startCount + idDeltas + idRangeOffsets + glyphsIds;
  let format31012 = "";
  let header31012 = "";

  if (numTables > 1) {
    cmap += "\x00\x03" + "\x00\x0A" + (0, _util.string32)(4 + numTables * 8 + 4 + format314.length);
    format31012 = "";

    for (i = 0, ii = ranges.length; i < ii; i++) {
      range = ranges[i];
      start = range[0];
      codes = range[2];
      let code = codes[0];

      for (j = 1, jj = codes.length; j < jj; ++j) {
        if (codes[j] !== codes[j - 1] + 1) {
          end = range[0] + j - 1;
          format31012 += (0, _util.string32)(start) + (0, _util.string32)(end) + (0, _util.string32)(code);
          start = end + 1;
          code = codes[j];
        }
      }

      format31012 += (0, _util.string32)(start) + (0, _util.string32)(range[1]) + (0, _util.string32)(code);
    }

    header31012 = "\x00\x0C" + "\x00\x00" + (0, _util.string32)(format31012.length + 16) + "\x00\x00\x00\x00" + (0, _util.string32)(format31012.length / 12);
  }

  return cmap + "\x00\x04" + string16(format314.length + 4) + format314 + header31012 + format31012;
}

function validateOS2Table(os2, file) {
  file.pos = (file.start || 0) + os2.offset;
  const version = file.getUint16();
  file.skip(60);
  const selection = file.getUint16();

  if (version < 4 && selection & 0x0300) {
    return false;
  }

  const firstChar = file.getUint16();
  const lastChar = file.getUint16();

  if (firstChar > lastChar) {
    return false;
  }

  file.skip(6);
  const usWinAscent = file.getUint16();

  if (usWinAscent === 0) {
    return false;
  }

  os2.data[8] = os2.data[9] = 0;
  return true;
}

function createOS2Table(properties, charstrings, override) {
  override = override || {
    unitsPerEm: 0,
    yMax: 0,
    yMin: 0,
    ascent: 0,
    descent: 0
  };
  let ulUnicodeRange1 = 0;
  let ulUnicodeRange2 = 0;
  let ulUnicodeRange3 = 0;
  let ulUnicodeRange4 = 0;
  let firstCharIndex = null;
  let lastCharIndex = 0;

  if (charstrings) {
    for (let code in charstrings) {
      code |= 0;

      if (firstCharIndex > code || !firstCharIndex) {
        firstCharIndex = code;
      }

      if (lastCharIndex < code) {
        lastCharIndex = code;
      }

      const position = (0, _unicode.getUnicodeRangeFor)(code);

      if (position < 32) {
        ulUnicodeRange1 |= 1 << position;
      } else if (position < 64) {
        ulUnicodeRange2 |= 1 << position - 32;
      } else if (position < 96) {
        ulUnicodeRange3 |= 1 << position - 64;
      } else if (position < 123) {
        ulUnicodeRange4 |= 1 << position - 96;
      } else {
        throw new _util.FormatError("Unicode ranges Bits > 123 are reserved for internal usage");
      }
    }

    if (lastCharIndex > 0xffff) {
      lastCharIndex = 0xffff;
    }
  } else {
    firstCharIndex = 0;
    lastCharIndex = 255;
  }

  const bbox = properties.bbox || [0, 0, 0, 0];
  const unitsPerEm = override.unitsPerEm || 1 / (properties.fontMatrix || _util.FONT_IDENTITY_MATRIX)[0];
  const scale = properties.ascentScaled ? 1.0 : unitsPerEm / PDF_GLYPH_SPACE_UNITS;
  const typoAscent = override.ascent || Math.round(scale * (properties.ascent || bbox[3]));
  let typoDescent = override.descent || Math.round(scale * (properties.descent || bbox[1]));

  if (typoDescent > 0 && properties.descent > 0 && bbox[1] < 0) {
    typoDescent = -typoDescent;
  }

  const winAscent = override.yMax || typoAscent;
  const winDescent = -override.yMin || -typoDescent;
  return "\x00\x03" + "\x02\x24" + "\x01\xF4" + "\x00\x05" + "\x00\x00" + "\x02\x8A" + "\x02\xBB" + "\x00\x00" + "\x00\x8C" + "\x02\x8A" + "\x02\xBB" + "\x00\x00" + "\x01\xDF" + "\x00\x31" + "\x01\x02" + "\x00\x00" + "\x00\x00\x06" + String.fromCharCode(properties.fixedPitch ? 0x09 : 0x00) + "\x00\x00\x00\x00\x00\x00" + (0, _util.string32)(ulUnicodeRange1) + (0, _util.string32)(ulUnicodeRange2) + (0, _util.string32)(ulUnicodeRange3) + (0, _util.string32)(ulUnicodeRange4) + "\x2A\x32\x31\x2A" + string16(properties.italicAngle ? 1 : 0) + string16(firstCharIndex || properties.firstChar) + string16(lastCharIndex || properties.lastChar) + string16(typoAscent) + string16(typoDescent) + "\x00\x64" + string16(winAscent) + string16(winDescent) + "\x00\x00\x00\x00" + "\x00\x00\x00\x00" + string16(properties.xHeight) + string16(properties.capHeight) + string16(0) + string16(firstCharIndex || properties.firstChar) + "\x00\x03";
}

function createPostTable(properties) {
  const angle = Math.floor(properties.italicAngle * 2 ** 16);
  return "\x00\x03\x00\x00" + (0, _util.string32)(angle) + "\x00\x00" + "\x00\x00" + (0, _util.string32)(properties.fixedPitch ? 1 : 0) + "\x00\x00\x00\x00" + "\x00\x00\x00\x00" + "\x00\x00\x00\x00" + "\x00\x00\x00\x00";
}

function createPostscriptName(name) {
  return name.replace(/[^\x21-\x7E]|[[\](){}<>/%]/g, "").slice(0, 63);
}

function createNameTable(name, proto) {
  if (!proto) {
    proto = [[], []];
  }

  const strings = [proto[0][0] || "Original licence", proto[0][1] || name, proto[0][2] || "Unknown", proto[0][3] || "uniqueID", proto[0][4] || name, proto[0][5] || "Version 0.11", proto[0][6] || createPostscriptName(name), proto[0][7] || "Unknown", proto[0][8] || "Unknown", proto[0][9] || "Unknown"];
  const stringsUnicode = [];
  let i, ii, j, jj, str;

  for (i = 0, ii = strings.length; i < ii; i++) {
    str = proto[1][i] || strings[i];
    const strBufUnicode = [];

    for (j = 0, jj = str.length; j < jj; j++) {
      strBufUnicode.push(string16(str.charCodeAt(j)));
    }

    stringsUnicode.push(strBufUnicode.join(""));
  }

  const names = [strings, stringsUnicode];
  const platforms = ["\x00\x01", "\x00\x03"];
  const encodings = ["\x00\x00", "\x00\x01"];
  const languages = ["\x00\x00", "\x04\x09"];
  const namesRecordCount = strings.length * platforms.length;
  let nameTable = "\x00\x00" + string16(namesRecordCount) + string16(namesRecordCount * 12 + 6);
  let strOffset = 0;

  for (i = 0, ii = platforms.length; i < ii; i++) {
    const strs = names[i];

    for (j = 0, jj = strs.length; j < jj; j++) {
      str = strs[j];
      const nameRecord = platforms[i] + encodings[i] + languages[i] + string16(j) + string16(str.length) + string16(strOffset);
      nameTable += nameRecord;
      strOffset += str.length;
    }
  }

  nameTable += strings.join("") + stringsUnicode.join("");
  return nameTable;
}

class Font {
  constructor(name, file, properties) {
    this.name = name;
    this.psName = null;
    this.mimetype = null;
    this.disableFontFace = false;
    this.loadedName = properties.loadedName;
    this.isType3Font = properties.isType3Font;
    this.missingFile = false;
    this.cssFontInfo = properties.cssFontInfo;
    this._charsCache = Object.create(null);
    this._glyphCache = Object.create(null);
    let isSerifFont = !!(properties.flags & _fonts_utils.FontFlags.Serif);

    if (!isSerifFont && !properties.isSimulatedFlags) {
      const baseName = name.replace(/[,_]/g, "-").split("-")[0],
            serifFonts = (0, _standard_fonts.getSerifFonts)();

      for (const namePart of baseName.split("+")) {
        if (serifFonts[namePart]) {
          isSerifFont = true;
          break;
        }
      }
    }

    this.isSerifFont = isSerifFont;
    this.isSymbolicFont = !!(properties.flags & _fonts_utils.FontFlags.Symbolic);
    this.isMonospace = !!(properties.flags & _fonts_utils.FontFlags.FixedPitch);
    let type = properties.type;
    let subtype = properties.subtype;
    this.type = type;
    this.subtype = subtype;
    let fallbackName = "sans-serif";

    if (this.isMonospace) {
      fallbackName = "monospace";
    } else if (this.isSerifFont) {
      fallbackName = "serif";
    }

    this.fallbackName = fallbackName;
    this.differences = properties.differences;
    this.widths = properties.widths;
    this.defaultWidth = properties.defaultWidth;
    this.composite = properties.composite;
    this.cMap = properties.cMap;
    this.capHeight = properties.capHeight / PDF_GLYPH_SPACE_UNITS;
    this.ascent = properties.ascent / PDF_GLYPH_SPACE_UNITS;
    this.descent = properties.descent / PDF_GLYPH_SPACE_UNITS;
    this.lineHeight = this.ascent - this.descent;
    this.fontMatrix = properties.fontMatrix;
    this.bbox = properties.bbox;
    this.defaultEncoding = properties.defaultEncoding;
    this.toUnicode = properties.toUnicode;
    this.toFontChar = [];

    if (properties.type === "Type3") {
      for (let charCode = 0; charCode < 256; charCode++) {
        this.toFontChar[charCode] = this.differences[charCode] || properties.defaultEncoding[charCode];
      }

      this.fontType = _util.FontType.TYPE3;
      return;
    }

    this.cidEncoding = properties.cidEncoding || "";
    this.vertical = !!properties.vertical;

    if (this.vertical) {
      this.vmetrics = properties.vmetrics;
      this.defaultVMetrics = properties.defaultVMetrics;
    }

    if (!file || file.isEmpty) {
      if (file) {
        (0, _util.warn)('Font file is empty in "' + name + '" (' + this.loadedName + ")");
      }

      this.fallbackToSystemFont(properties);
      return;
    }

    [type, subtype] = getFontFileType(file, properties);

    if (type !== this.type || subtype !== this.subtype) {
      (0, _util.info)("Inconsistent font file Type/SubType, expected: " + `${this.type}/${this.subtype} but found: ${type}/${subtype}.`);
    }

    let data;

    try {
      switch (type) {
        case "MMType1":
          (0, _util.info)("MMType1 font (" + name + "), falling back to Type1.");

        case "Type1":
        case "CIDFontType0":
          this.mimetype = "font/opentype";
          const cff = subtype === "Type1C" || subtype === "CIDFontType0C" ? new _cff_font.CFFFont(file, properties) : new _type1_font.Type1Font(name, file, properties);
          adjustWidths(properties);
          data = this.convert(name, cff, properties);
          break;

        case "OpenType":
        case "TrueType":
        case "CIDFontType2":
          this.mimetype = "font/opentype";
          data = this.checkAndRepair(name, file, properties);

          if (this.isOpenType) {
            adjustWidths(properties);
            type = "OpenType";
          }

          break;

        default:
          throw new _util.FormatError(`Font ${type} is not supported`);
      }
    } catch (e) {
      (0, _util.warn)(e);
      this.fallbackToSystemFont(properties);
      return;
    }

    amendFallbackToUnicode(properties);
    this.data = data;
    this.fontType = (0, _fonts_utils.getFontType)(type, subtype, properties.isStandardFont);
    this.fontMatrix = properties.fontMatrix;
    this.widths = properties.widths;
    this.defaultWidth = properties.defaultWidth;
    this.toUnicode = properties.toUnicode;
    this.seacMap = properties.seacMap;
  }

  get renderer() {
    const renderer = _font_renderer.FontRendererFactory.create(this, _fonts_utils.SEAC_ANALYSIS_ENABLED);

    return (0, _util.shadow)(this, "renderer", renderer);
  }

  exportData(extraProperties = false) {
    const exportDataProperties = extraProperties ? [...EXPORT_DATA_PROPERTIES, ...EXPORT_DATA_EXTRA_PROPERTIES] : EXPORT_DATA_PROPERTIES;
    const data = Object.create(null);
    let property, value;

    for (property of exportDataProperties) {
      value = this[property];

      if (value !== undefined) {
        data[property] = value;
      }
    }

    return data;
  }

  fallbackToSystemFont(properties) {
    this.missingFile = true;
    const name = this.name;
    const type = this.type;
    const subtype = this.subtype;
    let fontName = (0, _fonts_utils.normalizeFontName)(name);
    const stdFontMap = (0, _standard_fonts.getStdFontMap)(),
          nonStdFontMap = (0, _standard_fonts.getNonStdFontMap)();
    const isStandardFont = !!stdFontMap[fontName];
    const isMappedToStandardFont = !!(nonStdFontMap[fontName] && stdFontMap[nonStdFontMap[fontName]]);
    fontName = stdFontMap[fontName] || nonStdFontMap[fontName] || fontName;
    this.bold = fontName.search(/bold/gi) !== -1;
    this.italic = fontName.search(/oblique/gi) !== -1 || fontName.search(/italic/gi) !== -1;
    this.black = name.search(/Black/g) !== -1;
    const isNarrow = name.search(/Narrow/g) !== -1;
    this.remeasure = (!isStandardFont || isNarrow) && Object.keys(this.widths).length > 0;

    if ((isStandardFont || isMappedToStandardFont) && type === "CIDFontType2" && this.cidEncoding.startsWith("Identity-")) {
      const cidToGidMap = properties.cidToGidMap;
      const map = [];
      applyStandardFontGlyphMap(map, (0, _standard_fonts.getGlyphMapForStandardFonts)());

      if (/Arial-?Black/i.test(name)) {
        applyStandardFontGlyphMap(map, (0, _standard_fonts.getSupplementalGlyphMapForArialBlack)());
      } else if (/Calibri/i.test(name)) {
        applyStandardFontGlyphMap(map, (0, _standard_fonts.getSupplementalGlyphMapForCalibri)());
      }

      if (cidToGidMap) {
        for (const charCode in map) {
          const cid = map[charCode];

          if (cidToGidMap[cid] !== undefined) {
            map[+charCode] = cidToGidMap[cid];
          }
        }

        if (cidToGidMap.length !== this.toUnicode.length && properties.hasIncludedToUnicodeMap && this.toUnicode instanceof _to_unicode_map.IdentityToUnicodeMap) {
          this.toUnicode.forEach(function (charCode, unicodeCharCode) {
            const cid = map[charCode];

            if (cidToGidMap[cid] === undefined) {
              map[+charCode] = unicodeCharCode;
            }
          });
        }
      }

      if (!(this.toUnicode instanceof _to_unicode_map.IdentityToUnicodeMap)) {
        this.toUnicode.forEach(function (charCode, unicodeCharCode) {
          map[+charCode] = unicodeCharCode;
        });
      }

      this.toFontChar = map;
      this.toUnicode = new _to_unicode_map.ToUnicodeMap(map);
    } else if (/Symbol/i.test(fontName)) {
      this.toFontChar = buildToFontChar(_encodings.SymbolSetEncoding, (0, _glyphlist.getGlyphsUnicode)(), this.differences);
    } else if (/Dingbats/i.test(fontName)) {
      if (/Wingdings/i.test(name)) {
        (0, _util.warn)("Non-embedded Wingdings font, falling back to ZapfDingbats.");
      }

      this.toFontChar = buildToFontChar(_encodings.ZapfDingbatsEncoding, (0, _glyphlist.getDingbatsGlyphsUnicode)(), this.differences);
    } else if (isStandardFont) {
      const map = buildToFontChar(this.defaultEncoding, (0, _glyphlist.getGlyphsUnicode)(), this.differences);

      if (type === "CIDFontType2" && !this.cidEncoding.startsWith("Identity-") && !(this.toUnic