(self["webpackChunkenDI"] = self["webpackChunkenDI"] || []).push([["vendor"],{

/***/ "./src/backbone-tools.js":
/*!*******************************!*\
  !*** ./src/backbone-tools.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BootstrapOnInvalidForm: () => (/* binding */ BootstrapOnInvalidForm),
/* harmony export */   BootstrapOnValidForm: () => (/* binding */ BootstrapOnValidForm),
/* harmony export */   applicationStartup: () => (/* binding */ applicationStartup),
/* harmony export */   bindModelValidation: () => (/* binding */ bindModelValidation),
/* harmony export */   displayServerError: () => (/* binding */ displayServerError),
/* harmony export */   displayServerSuccess: () => (/* binding */ displayServerSuccess),
/* harmony export */   hideRegion: () => (/* binding */ hideRegion),
/* harmony export */   setupBbValidationCallbacks: () => (/* binding */ setupBbValidationCallbacks),
/* harmony export */   setupBbValidationPatterns: () => (/* binding */ setupBbValidationPatterns),
/* harmony export */   setupLibraries: () => (/* binding */ setupLibraries),
/* harmony export */   showRegion: () => (/* binding */ showRegion),
/* harmony export */   unbindModelValidation: () => (/* binding */ unbindModelValidation)
/* harmony export */ });
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone-validation */ "./node_modules/backbone-validation/dist/backbone-validation-amd.js");
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_validation__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./tools.js */ "./src/tools.js");
/* harmony import */ var base_components_UserSession_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! base/components/UserSession.js */ "./src/base/components/UserSession.js");
/* harmony import */ var base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! base/components/ConfigBus.js */ "./src/base/components/ConfigBus.js");
/* harmony import */ var base_components_LoginApp_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! base/components/LoginApp.js */ "./src/base/components/LoginApp.js");
/* harmony import */ var bootstrap_js_tab_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! bootstrap/js/tab.js */ "./node_modules/bootstrap/js/tab.js");
/* harmony import */ var bootstrap_js_tab_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(bootstrap_js_tab_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_8__);







var showFieldSetError = function showFieldSetError(control, error) {
  /*
  Show errors at fieldset level (used for error related to specific components)
  */
  var fieldset = control.closest("fieldset");
  fieldset.addClass("error");
  if (fieldset.find(".alert-danger").length === 0) {
    fieldset.find(".title").after('<div class="alert alert-danger"></div>');
  }
  var fieldsetBlock = fieldset.find(".alert-danger");
  return fieldsetBlock.text(error);
};
var showFieldError = function showFieldError(control, error) {
  /*
  Show an error at field level
   control
       The form field jquery object (input, select ...)
      We look for the parent form-group tag
   error
       The message as a string
  */
  var group = control.parents(".form-group");
  group.addClass("has-error");
  if (group.find(".help-block").length === 0) {
    group.append('<span class="help-block error-message"></span>');
  }
  var groupBlock = group.find(".help-block");
  return groupBlock.text(error);
};
var hideFieldSetError = function hideFieldSetError(control) {
  /*
  Hide an error set with showFieldsetError
   */
  var fieldset = control.closest("fieldset");
  fieldset.removeClass("error");
  fieldset.find(".alert-danger").remove();
};
var hideFieldError = function hideFieldError(control) {
  /*
  Hide an error shown at field level
  */
  var group = control.parents(".form-group");
  group.removeClass("has-error");
  group.find(".error-message").remove();
  return control;
};
var BootstrapOnValidForm = function BootstrapOnValidForm(view, attr, selector) {
  console.log("BootstrapOnValidForm");
  var control, group;
  control = view.$("[" + selector + "=" + attr + "]");
  if (control.length === 0) {
    // Fallback looking for an item with attr css class
    control = view.$("." + attr);
    hideFieldSetError(control);
  } else {
    hideFieldError(control);
  }
};
var BootstrapOnInvalidForm = function BootstrapOnInvalidForm(view, attr, error, selector) {
  var control, group, position, target;
  control = view.$("[" + selector + "=" + attr + "]");
  if (control.length === 0) {
    // Fallback looking for an item with attr css class
    control = view.$("." + attr);
    showFieldSetError(control, error);
  } else {
    showFieldError(control, error);
  }
};
var setupBbValidationCallbacks = function setupBbValidationCallbacks(bb_module) {
  underscore__WEBPACK_IMPORTED_MODULE_7___default().extend(bb_module, {
    valid: BootstrapOnValidForm,
    invalid: BootstrapOnInvalidForm
  });
};
var displayServerError = function displayServerError(msg) {
  /*
   *  Show errors in a message box
   */
  var messagebus = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("message");
  messagebus.trigger("error", msg);
};
var displayServerSuccess = function displayServerSuccess(msg) {
  /*
   *  Show errors in a message box
   */
  var messagebus = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("message");
  messagebus.trigger("success", msg);
};
__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");


var setupBbValidationPatterns = function setupBbValidationPatterns(bb_module) {
  underscore__WEBPACK_IMPORTED_MODULE_7___default().extend(bb_module.patterns, {
    amount: /^-?(\d+(?:[\.\,]\d{1,5})?)$/,
    amount2: /^(\d+(?:[\.\,]\d{1,2})?)$/,
    amount3: /^-?(\d+(?:[\.\,]\d{1,2})?)$/
  });
  underscore__WEBPACK_IMPORTED_MODULE_7___default().extend(bb_module.messages, {
    amount: "Doit être un nombre avec au maximum 5 chiffres après la virgule",
    amount2: "Doit être un nombre positif avec au maximum 2 chiffres après la virgule",
    amount3: "Doit être un nombre avec au maximum 2 chiffres après la virgule"
  });
  bb_module.messages["range"] = "{0} doit être compris entre {1} et {2}";
};

/**
 * Setup libraries on page load
 *
 *  - jquery exceptions (see setupDeferredExceptionHandling for details)
 *  - jquery ajax complete hook
 *  - Backbone.validation callbacks
 */
var setupLibraries = function setupLibraries() {
  (0,_tools_js__WEBPACK_IMPORTED_MODULE_2__.setupDeferredExceptionHandling)();
  (0,_tools_js__WEBPACK_IMPORTED_MODULE_2__.setupAjaxCallbacks)();
  setupBbValidationCallbacks((backbone_validation__WEBPACK_IMPORTED_MODULE_1___default().callbacks));
  setupBbValidationPatterns((backbone_validation__WEBPACK_IMPORTED_MODULE_1___default()));
};

/**
 * Backbone marionette application startup process in the new fashion
 *
 * @param {object} options : The AppOption global variable
 * @param {Mn.Application} app : The marionette application to start
 * @param {Object} facade : The facade radio channel used to manage model / collections interactions
 *
 * @param {Mn.App} actionsApp : Optionnal marionette application handling actions
 * @param {Mn.App} statusHistoryApp : Optionnal marionette application handling actions
 * @param {list} customServices: Optionnal radio channel services
 */

var applicationStartup = function applicationStartup(options, app, facade, customOptions) {
  customOptions = customOptions || {};
  var actionsApp = customOptions.actionsApp || null;
  var statusHistoryApp = customOptions.statusHistoryApp || null;
  var customServices = customOptions.customServices || [];
  console.log("# Booting Marionette/Backbone app v2 process");
  (0,_tools_js__WEBPACK_IMPORTED_MODULE_2__.showLoader)();
  setupLibraries();
  (0,_tools_js__WEBPACK_IMPORTED_MODULE_2__.setupAjaxCSRF)(options["csrf_token"]);
  options.config = base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_4__["default"];
  options.login = base_components_LoginApp_js__WEBPACK_IMPORTED_MODULE_5__["default"];
  options.app = app;
  options.facade = facade;
  options.actionsApp = actionsApp;
  options.statusHistoryApp = statusHistoryApp;
  options.$ = (jquery__WEBPACK_IMPORTED_MODULE_8___default());
  options.session = base_components_UserSession_js__WEBPACK_IMPORTED_MODULE_3__["default"];
  base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_4__["default"].setup(options["form_config_url"]);
  customServices.forEach(function (service) {
    return service.setup(options["form_config_url"]);
  });
  facade.setup(options);
  var startApp = function startApp() {
    console.log(" - Starting the Config component");
    var promise1 = base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_4__["default"].start();
    customServices.forEach(function (service) {
      console.log(" - Starting a Custom component");
      promise1 = promise1.then(service.start.bind(service));
    });
    console.log(" - Starting the Facade component");
    var promise2 = promise1.then(facade.start.bind(facade));
    promise2.done(function (result1, result2) {
      console.log("- Components started : Starting the application");
      if (app) {
        app.start();
      }
      // L'application a démarré, désormais en callback de l'auth, on
      // veut synchroniser les modifications en cours
      base_components_LoginApp_js__WEBPACK_IMPORTED_MODULE_5__["default"].setAuthCallbacks([facade.start.bind(facade)]);
      if (actionsApp) {
        actionsApp.start(base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_4__["default"].form_config["actions"]);
      }
      if (statusHistoryApp) {
        statusHistoryApp.start(facade.getCollectionRequest("status_history"));
      }
    });
  };

  // Au cas où on échoue lors du premier chargement, on veut pouvoir re
  // lancer la page après authentification
  base_components_LoginApp_js__WEBPACK_IMPORTED_MODULE_5__["default"].setAuthCallbacks([startApp]);
  base_components_LoginApp_js__WEBPACK_IMPORTED_MODULE_5__["default"].start();
};

/**
 * Utility used to hide a region and its content
 * @param {Mn.Region} region : The Marionettejs Region instance (this.getRegion('regionName') from inside a View)
 *
 */
var hideRegion = function hideRegion(region) {
  // Remove subview if there is one
  if (region.hasView()) {
    region.empty();
  }
  // Hide the region container
  // Afin de s'assurer que nous travaillons bien sur le tag de la Region
  // et pas un autre dans la page, on repart du parent de la Region
  // region.$el pointe parfois au mauvais endroit (pour une raison inconnue)
  var parentEl = underscore__WEBPACK_IMPORTED_MODULE_7___default().result(region, "parentEl");
  var regionTag = jquery__WEBPACK_IMPORTED_MODULE_8___default()(parentEl).find(region.el);
  regionTag.hide();
};

/**
 * Utility used to show a region (if it has been hidden)
 * @param {Mn.Region} region : The Marionettejs Region instance (this.getRegion('regionName') from inside a View)
 *
 */
var showRegion = function showRegion(region) {
  region.$el.show();
};
var bindModelValidation = function bindModelValidation(model) {
  Object.assign(model, (backbone_validation__WEBPACK_IMPORTED_MODULE_1___default().mixin));
};
var unbindModelValidation = function unbindModelValidation(model) {
  delete model.validate;
  delete model.preValidate;
  delete model.isValid;
};

/***/ }),

/***/ "./src/base/behaviors/BaseFormBehavior.js":
/*!************************************************!*\
  !*** ./src/base/behaviors/BaseFormBehavior.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone-validation */ "./node_modules/backbone-validation/dist/backbone-validation-amd.js");
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_validation__WEBPACK_IMPORTED_MODULE_0__);


var BaseFormBehavior = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().Behavior.extend({
  onDataPersist: function onDataPersist(attribute, value) {
    console.log("BaseFormBehavior.onDataPersist");
    backbone_validation__WEBPACK_IMPORTED_MODULE_0___default().unbind(this.view);
    backbone_validation__WEBPACK_IMPORTED_MODULE_0___default().bind(this.view, {
      attributes: function attributes(view) {
        return [attribute];
      }
    });
    var datas = {};
    datas[attribute] = value;
    this.view.model.set(datas);
    this.view.triggerMethod("data:persisted", datas);
  },
  onDataModified: function onDataModified(attribute, value) {
    backbone_validation__WEBPACK_IMPORTED_MODULE_0___default().unbind(this.view);
    backbone_validation__WEBPACK_IMPORTED_MODULE_0___default().bind(this.view, {
      attributes: function attributes(view) {
        return [attribute];
      }
    });
    var datas = {};
    datas[attribute] = value;
    this.view.model.set(datas);
    this.view.model.isValid();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseFormBehavior);

/***/ }),

/***/ "./src/base/behaviors/FormBehavior.js":
/*!********************************************!*\
  !*** ./src/base/behaviors/FormBehavior.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone-validation */ "./node_modules/backbone-validation/dist/backbone-validation-amd.js");
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_validation__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");
/* harmony import */ var _BaseFormBehavior_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BaseFormBehavior.js */ "./src/base/behaviors/BaseFormBehavior.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_3__);
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");





var FormBehavior = backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default().Behavior.extend({
  /*
  Behavior used to manage forms machinery
   Expects the attached View to have :
   a model
  a destCollection
  a form tag
  a type=submit button
  a type=reset button
    * By default models are synced on the server (added/edited) POST/PUT request
   You can affect this behavior :
       bb_sync
           if your view has an attribute bb_sync set to false it will become a simple frontend-only add/edit form
   * This form is an add form if the model has no id.
   * Only datas provided by the current form are validated and synced (not the
  whole model)
   You can affect this behavior by setting your view :
       partial
           If your view wants onlye part of the model to be synced
    View Events
   The following Events are triggered on the view
   cancel:form
  success:sync
   Machinery Event
   The following events can be fired from the view
   reset:model                  : Call the rollback method on the model
   Inherited from BaseFormBehavior
   data:modified  (attr, value) : Synchronize a field's datas with the model
  data:persist   (attr, value) : Synchronize the passed datas
  data:invalid   (model, errors, datas) : Datas are invalid when submitting
    Example :
   Sync the model's datas on field edition
       const MyView = Mn.View.extend({
          behaviors: [FormBehavior],
          bb_sync: false,
          childViewTriggers: {
              'finish': 'data:persist'
          }
      });
   Keep model in sync with the form during edition
       const MyView = Mn.View.extend({
          behaviors: [FormBehavior],
          bb_sync: false,
          childViewTriggers: {
              'finish': 'data:modified'
          }
      });
  */
  behaviors: [_BaseFormBehavior_js__WEBPACK_IMPORTED_MODULE_2__["default"]],
  ui: {
    form: "form",
    reset: "button[type=reset]"
  },
  events: {
    "submit @ui.form": "onSubmitForm",
    "click @ui.reset": "onCancelClick"
  },
  defaults: {
    errorMessage: "Une erreur est survenue"
  },
  // Options retrieval
  getSyncOption: function getSyncOption() {
    var bb_sync = true;
    if (this.view.bb_sync === false) {
      bb_sync = false;
    }
    return bb_sync;
  },
  getPartialOption: function getPartialOption() {
    /* Return true if the model is only partially edited */
    var partial = true;
    if (this.view.partial === false) {
      partial = false;
    }
    return partial;
  },
  serializeForm: function serializeForm() {
    return (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.serializeForm)(this.getUI("form"));
  },
  onSyncError: function onSyncError(datas, status, result) {
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_3___default().channel("message");
    channel.trigger("notify:success", result);
    backbone_validation__WEBPACK_IMPORTED_MODULE_0___default().unbind(this.view);
  },
  onSyncSuccess: function onSyncSuccess(datas, status, result) {
    console.log("FormBehavior.onSuccessSync");
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_3___default().channel("message");
    channel.trigger("notify:success", result);
    backbone_validation__WEBPACK_IMPORTED_MODULE_0___default().unbind(this.view);
    var eventName = "success:sync";
    console.log("Trigger %s from FormBehavior", eventName);
    this.view.triggerMethod(eventName);
  },
  syncServer: function syncServer(datas, bound, source_event_type) {
    console.log("FormBehavior syncServer");
    var bound = bound || false;
    if (this.getPartialOption()) {
      datas = datas || this.view.model.toJSON();
    } else {
      datas = this.view.model.toJSON();
    }
    if (!bound) {
      backbone_validation__WEBPACK_IMPORTED_MODULE_0___default().bind(this.view, {
        attributes: function attributes(view) {
          return _.keys(datas);
        }
      });
    }
    if (this.view.model.isValid(_.keys(datas))) {
      var request;
      var view = this.view;
      view.triggerMethod("before:sync");
      if (!this.view.model.get("id") && !this.view.forceEditForm) {
        request = this.addSubmit(datas);
      } else {
        request = this.editSubmit(datas);
      }
      request.then(function (datas, status, result) {
        view.triggerMethod("form:" + source_event_type);
        return datas, status, result;
      });
      return request.done(this.onSyncSuccess.bind(this)).fail(this.onSyncError.bind(this));
    } else {
      console.log("Datas are invalid");
      var errors = this.view.model.validate(datas);
      console.log(errors);
      this.view.triggerMethod("data:invalid", this.view.model, errors, datas);
      return false;
    }
  },
  addSubmit: function addSubmit(datas) {
    /*
     *
     * Since collection.create doesn't return a jquery promise, we need to
     * re-implement the destcollection create stuff and return the expected
     * promise
     *
     * See sources : (Collection.create)
     * http://backbonejs.org/docs/backbone.html
     *
     */
    console.log("FormBehavior.addSubmit");
    var destCollection = this.view.getOption("destCollection");
    console.log(destCollection);
    var model = destCollection._prepareModel(datas);
    // We replace the current model to get in sync
    this.view.model = model;
    var request;
    if (this.getSyncOption()) {
      request = model.save(null, {
        wait: true,
        sort: true
      });
    } else {
      request = $.Deferred();
      request.resolve(model, null, null);
    }
    request = request.done(function (model, resp, callbackOpts) {
      console.log("Adding to collection");
      destCollection.add(model, callbackOpts);
      destCollection.trigger("saved");
      return model, "success", resp;
    }).fail(this.onSyncError.bind(this));
    return request;
  },
  editSubmit: function editSubmit(datas) {
    console.log("FormBehavior.editSubmit");
    var request;
    if (this.getSyncOption()) {
      request = this.view.model.save(datas, {
        wait: true,
        patch: true
      });
    } else {
      request = $.Deferred();
      request.resolve(this.view.model);
    }
    return request;
  },
  onSubmitForm: function onSubmitForm(event) {
    console.log("FormBehavior.onSubmitForm");
    event.preventDefault();
    var datas = this.syncFormWithModel();
    var request = this.syncServer(datas, false, "submitted");
    if (request) {
      var view = this.view;
      request.then(function () {
        console.log("Trigger 'form:submitted' from FormBehavior");
        view.triggerMethod("form:submitted");
      });
    }
  },
  onDataPersisted: function onDataPersisted(datas) {
    console.log("FormBehavior.onDataPersisted");
    this.syncServer(datas, true, "persisted");
  },
  onCancelClick: function onCancelClick() {
    console.log("FormBehavior.onCancelClick");
    console.log("Trigger reset:model from FormBehavior");
    this.view.triggerMethod("reset:model");
    var eventName = "cancel:form";
    console.log("Trigger %s from FormBehavior", eventName);
    this.view.triggerMethod(eventName);
  },
  onResetModel: function onResetModel() {
    console.log("FormBehavior.onResetModel");
    this.view.model.rollback(this.getSyncOption());
  },
  syncFormWithModel: function syncFormWithModel() {
    /* Set form datas on the model and fires datas validation */
    var datas = this.serializeForm();
    console.log("FormBehavior.syncFormWithModel");
    if (this.view.afterSerializeForm) {
      datas = this.view.afterSerializeForm(datas);
    }
    var model = this.view.model.set(datas, {
      validate: true,
      silent: true
    });
    return datas;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormBehavior);

/***/ }),

/***/ "./src/base/behaviors/ModalBehavior.js":
/*!*********************************************!*\
  !*** ./src/base/behaviors/ModalBehavior.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tools.js */ "./src/tools.js");


var ModalBehavior = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().Behavior.extend({
  /** Modal behaviour for views occuring within a modal
   *
   * Views adopting this behavior MUST
   *  - define an `id` attribute.
   *  - contain a <div class="modal_content_layout"> element (the modal body)
   *
   * fires following events
       modal:beforeClose
      modal:afterNotifySuccess
      destroy:modal
    */
  modalClasses: "modal_view modal_form appear",
  ui: {
    close: ".close",
    modal: ">:first-child",
    modalbody: ">:first-child .modal_content_layout"
  },
  events: {
    "click @ui.close": "onClose"
  },
  onAttach: function onAttach() {
    console.log("ModalBehavior : Showing the modal");
    this.ui.modal.addClass(this.modalClasses);
    this.ui.modal.css("display", "flex");
    document.body.classList.add("modal_open");
    this.ui.close.focus();
  },
  onClose: function onClose() {
    this.view.trigger("modal:canceled");
    console.log("Trigger modal:beforeClose from ModalBehavior");
    this.view.triggerMethod("modal:beforeClose");
    console.log("Trigger modal:close from ModalBehavior");
    this.view.triggerMethod("modal:close");
  },
  onModalClose: function onModalClose() {
    console.log("ModalBehavior.onModalClose");
    (0,tools_js__WEBPACK_IMPORTED_MODULE_0__.closeModal)(this.ui.modal);
    this.triggerFinish();
    document.body.classList.remove("modal_open");
  },
  triggerFinish: function triggerFinish() {
    console.log("Trigger destroy:modal from ModalBehavior");
    this.view.triggerMethod("destroy:modal");
    this.view.destroy();
  },
  onModalNotifySuccess: function onModalNotifySuccess() {
    var modalbody = this.getUI("modalbody");
    var view = this.view;
    if (modalbody.length === 0) {
      console.error("No modalbody found, ModalBehavior is not implemented correctly by view/template.", view, "Consider adding a matching element or overriding ui.modalbody in view.");
    }
    modalbody.effect("highlight", {
      color: "rgba(0,0,0,0)"
    }, 800, view.triggerMethod.bind(view, "modal:after:notifySuccess"));
    modalbody.addClass("action_feedback success");
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModalBehavior);

/***/ }),

/***/ "./src/base/behaviors/ModalFormBehavior.js":
/*!*************************************************!*\
  !*** ./src/base/behaviors/ModalFormBehavior.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ModalBehavior.js */ "./src/base/behaviors/ModalBehavior.js");
/* harmony import */ var _FormBehavior_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FormBehavior.js */ "./src/base/behaviors/FormBehavior.js");



var ModalFormBehavior = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().Behavior.extend({
  /*
      Combine modal and form behavior
       fires the following events on the view
       cancel:form when the modal is closed manually
       modal:close
    */
  behaviors: [_ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__["default"], _FormBehavior_js__WEBPACK_IMPORTED_MODULE_1__["default"]],
  onSuccessSync: function onSuccessSync() {
    console.log("ModalFormBehavior.onSuccessSync");
    console.log("Trigger modal:close from ModalFormBehavior");
    this.view.triggerMethod("modal:close");
  },
  onModalBeforeClose: function onModalBeforeClose() {
    console.log("Trigger reset:model from ModalFormBehavior");
    this.view.triggerMethod("reset:model");
    this.view.triggerMethod("cancel:form");
  },
  onCancelForm: function onCancelForm() {
    console.log("ModalFormBehavior.onCancelForm");
    console.log("Trigger modal:close from ModalFormBehavior");
    this.view.triggerMethod("modal:close");
  },
  onModalClose: function onModalClose() {
    console.log("ModalFormBehavior.onModalClose");
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModalFormBehavior);

/***/ }),

/***/ "./src/base/components/ConfigBus.js":
/*!******************************************!*\
  !*** ./src/base/components/ConfigBus.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }



var ConfigBusClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().Object.extend({
  channelName: "config",
  radioRequests: {
    "get:options": "getFormOptions",
    "has:section": "hasFormSection",
    "get:section": "getFormSection",
    "get:actions": "getFormActions",
    "has:form_section": "hasFormSection",
    "get:form_section": "getFormSection",
    "get:form_actions": "getFormActions",
    reload_config: "start"
  },
  setFormConfig: function setFormConfig(form_config) {
    console.log(" -> ConfigBus.started : form_config loaded");
    console.log(form_config);
    this.form_config = form_config;
  },
  getFormOptions: function getFormOptions(option_name) {
    /*
     * Return a clone of the form options for option_name
     *
     * :param str option_name: The name of the option
     * :returns: A list of dict with options (for building selects)
     */
    var options = this.form_config["options"][option_name];
    if (_.isArray(options)) {
      return _.map(options, _.clone);
    } else {
      return _.clone(options);
    }
  },
  hasFormSection: function hasFormSection(section_name) {
    /*
     *
     * :param str section_name: The name of the section can be a path of attributes separated by ':'
     * :rtype: bool
     */
    var section = this.getFormSection(section_name);
    return section !== null;
  },
  getFormSection: function getFormSection(section_name) {
    /*
     *
     * Return the form section description
     * :param str section_name: The name of the section can be a path of attributes separated by ':'
     * :returns: The section definition
     * :rtype: Object
     */
    var sections = section_name.split(":");
    var result = this.form_config["sections"];
    var _iterator = _createForOfIteratorHelper(sections),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _section_name = _step.value;
        if (_section_name in result) {
          result = result[_section_name];
        } else {
          result = null;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return result;
  },
  getFormActions: function getFormActions() {
    /*
     * Return available form action config
     */
    return this.form_config["actions"];
  },
  _getFieldSettings: function _getFieldSettings(modelName, fieldName) {
    var modelsSettings = this.form_config.models_settings || {};
    var modelSettings = modelsSettings[modelName] || {};
    var fieldSettings = modelSettings[fieldName] || {};
    return fieldSettings;
  },
  isFieldMasked: function isFieldMasked(modelName, fieldName) {
    var fieldSettings = this._getFieldSettings(modelName, fieldName);
    return fieldSettings.masked || false;
  },
  isFieldRequired: function isFieldRequired(modelName, fieldName) {
    var fieldSettings = this._getFieldSettings(modelName, fieldName);
    return fieldSettings.required || false;
  },
  setup: function setup(url) {
    /*
     * Set the configuration url
     */
    this._url = url;
  },
  start: function start() {
    /*
     * Load the page configuration at the given url
     */
    var request = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.ajax_call)(this._url);
    request = request.then(this.setFormConfig.bind(this), function (message) {
      return console.log(message);
    });
    return request;
  }
});
var ConfigBus = new ConfigBusClass();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ConfigBus);

/***/ }),

/***/ "./src/base/components/FacadeModelApiMixin.js":
/*!****************************************************!*\
  !*** ./src/base/components/FacadeModelApiMixin.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../tools */ "./src/tools.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");


var FacadeModelApiMixin = {
  channelName: "facade",
  setModelUrl: function setModelUrl(label, url) {
    this.models[label].url = url;
  },
  setCollectionUrl: function setCollectionUrl(label, url) {
    this.collections[label].url = url;
  },
  loadModel: function loadModel(label) {
    var model = this.models[label];
    var request = model.fetch();
    return request.then(function () {
      return model;
    });
  },
  loadCollection: function loadCollection(label, params) {
    /*
     * Load a collection and returns the collection itself
     */
    var options = {};
    if (params) {
      options["data"] = params;
      options["processData"] = true;
    }
    if (!label in this.collections) {
      console.error("Unknown collection : %s", label);
    }
    var collection = this.collections[label];
    var request = collection.fetch(options);
    return request.then(function () {
      return collection;
    });
  },
  getCollectionRequest: function getCollectionRequest(label) {
    return this.collections[label];
  },
  getModelRequest: function getModelRequest(label) {
    return this.models[label];
  },
  saveModel: function saveModel(modelName) {
    console.log("FacadeModelApiMixin.saveModel", modelName);
    var model = this.models[modelName];
    if (model.isLocalModel) {
      console.log("Skipping ".concat(modelName, " save (local model)"));
      // No-op -> always a success !
      return $.Deferred().resolve();
    } else {
      console.log("Saving ".concat(modelName));
      var pendingChanges = model.changedAttributes();
      var result;
      if (pendingChanges) {
        console.log(" + Running save");
        result = model.save(model.changedAttributes, {
          wait: true,
          sync: true,
          patch: true
        });
      } else {
        console.log(" + No pending changes");
        result = Promise.resolve({});
      }
      return result;
    }
  },
  isDataValid: function isDataValid() {
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("facade");
    channel.trigger("bind:validation");
    var result = {};
    _.each(this.models, function (model) {
      var validate_func = model["validate"];
      if (validate_func) {
        var res = model.validate();
        if (res) {
          _.extend(result, res);
        }
      }
    });
    _.each(this.collections, function (collection, label) {
      var validate_func = collection["validate"];
      if (validate_func) {
        var res = collection.validate();
        if (res) {
          _.extend(result, res);
        }
      }
    });
    channel.trigger("unbind:validation");
    console.log("End of isDataValid");
    console.log(result);
    return result;
  },
  saveAll: function saveAll() {
    var _$;
    // Hack pour checker si les objets gérés par la Facade sont bien éditables
    // Dans le cas contraire, le saveAll doit renvoyer une promise quand même
    // Dans le cas des docs fournisseurs par exemple, on peut rajouter des fichiers après validation
    // Ref : https://framagit.org/endi/endi/-/issues/2712
    var editable = (0,_tools__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "edit", true);
    if (!editable) {
      return new Promise(function (resolve, reject) {
        return {};
      });
    }
    var this_ = this;
    var keys = _.keys(this.models);
    var deferreds = [];
    keys.forEach(function (modelName) {
      deferreds.push(this_.saveModel(modelName));
    });
    return (_$ = $).when.apply(_$, deferreds);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FacadeModelApiMixin);

/***/ }),

/***/ "./src/base/components/LoginApp.js":
/*!*****************************************!*\
  !*** ./src/base/components/LoginApp.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _views_LoginView_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../views/LoginView.js */ "./src/base/views/LoginView.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var marionette_approuter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! marionette.approuter */ "./node_modules/marionette.approuter/lib/marionette.approuter.esm.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");
/* harmony import */ var mathjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! mathjs */ "./node_modules/mathjs/index.js");
/* harmony import */ var mathjs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(mathjs__WEBPACK_IMPORTED_MODULE_4__);
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/*
 * File Name :  LoginApp.js
 */







var Controller = backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default().Object.extend({
  initialize: function initialize(options) {
    this.channel = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("login");
    this.view = options["rootView"];
  },
  login: function login() {
    this.view.showLogin();
  }
});
var Router = marionette_approuter__WEBPACK_IMPORTED_MODULE_2__["default"].extend({
  appRoutes: {
    login: "login"
  }
});
var LoginComponent = backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default().View.extend({
  regions: {
    popin: ".popin-container"
  },
  tagName: "div",
  template: _.template("<div class='popin-container'></div>"),
  showLogin: function showLogin() {
    this.showChildView("popin", new _views_LoginView_js__WEBPACK_IMPORTED_MODULE_0__["default"]({}));
  }
});
var LoginAppClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default().Application.extend({
  channelName: "auth",
  region: "#login_form",
  onStart: function onStart() {
    console.log("Starting the login application");
    var view = new LoginComponent({});
    var controller = new Controller({
      rootView: view
    });
    this.router = new Router({
      controller: controller
    });
    var region = this.getRegion();
    this.showView(view);
    this.checkAuth();
  },
  url: "/api/v1/login",
  radioEvents: {
    login: "onLogin"
  },
  initialize: function initialize() {
    this.ok_callback = null;
    this.error_callback = null;
  },
  checkAuth: function checkAuth() {
    var _this = this;
    // On checke l'authentification, si c'est ok on continue
    // Si ce n'est pas ok, une redirection automatique vers #login est faite dans la partie jquery (cf tools.js)
    (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.ajax_call)(this.url + "?action=check", {}, "GET", {
      success: function success(result) {
        return _this.onAuthSuccess(result);
      }
    });
  },
  setAuthCallbacks: function setAuthCallbacks(callbacks) {
    /*
     * Define authentication callbacks that should be fired
     * on successfull authentication
     */
    this.callbacks = callbacks;
  },
  onLogin: function onLogin(datas, onAuthOk, onAuthFailed) {
    var callbacks = this.callbacks;
    this.ok_callback = onAuthOk;
    this.error_callback = onAuthFailed;
    (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.ajax_call)(this.url, datas, "POST", {
      success: this.onAuthSuccess.bind(this),
      error: this.onAuthError.bind(this)
    });
  },
  onAuthSuccess: function onAuthSuccess(result) {
    if (result["status"] == "success") {
      _.each(this.callbacks, function (callback) {
        if (!_.isUndefined(callback)) {
          callback();
        }
      });
      if (this.ok_callback) {
        this.ok_callback(result);
      }
    } else {
      if (this.error_callback) {
        this.error_callback(result);
      }
    }
  },
  onAuthError: function onAuthError(xhr) {
    if (xhr.status == 400) {
      if (_.has(xhr.responseJSON, "errors")) {
        this.error_callback(xhr.responseJSON.errors);
      } else {
        this.error_callback();
      }
    } else {
      alert("Erreur serveur : contactez votre administrateur");
    }
  }
});
var LoginApp = new LoginAppClass();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoginApp);

/***/ }),

/***/ "./src/base/components/UserSession.js":
/*!********************************************!*\
  !*** ./src/base/components/UserSession.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);


var UserSessionClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().Object.extend({
  channelName: "session",
  radioRequests: {
    get: "getEntry",
    set: "setEntry"
  },
  initialize: function initialize(options) {
    this._datas = {};
  },
  getEntry: function getEntry(key, default_value) {
    return this._datas.hasOwnProperty(key) ? this._datas[key] : default_value;
  },
  setEntry: function setEntry(key, value) {
    console.log("UserSession Storing %s %s", key, value);
    this._datas[key] = value;
  }
});
var UserSession = new UserSessionClass();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserSession);

/***/ }),

/***/ "./src/base/models/BaseCollection.js":
/*!*******************************************!*\
  !*** ./src/base/models/BaseCollection.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);

var BaseCollection = backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.extend({
  constructor: function constructor(models, options) {
    options = options || {};
    if ("url" in options) {
      this.url = options.url;
    }
    backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.apply(this, arguments);
  },
  fetch: function fetch(options) {
    var _this = this;
    var xhr_request = backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.prototype.fetch.call(this, options);
    options = options || {};
    if (xhr_request && !options.silent) {
      xhr_request.done(function () {
        _this.trigger("fetched");
      });
    }
    return xhr_request;
  },
  validate: function validate() {
    var result = {};
    this.each(function (model) {
      var func = model.validateModel;
      if (!func) {
        func = model.validate;
      }
      if (func) {
        Object.assign(result, func.bind(model)());
      } else {
        console.error("Le modèle n'a pas de méthode validate");
      }
    });
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseCollection);

/***/ }),

/***/ "./src/base/models/BaseLineCollection.js":
/*!***********************************************!*\
  !*** ./src/base/models/BaseLineCollection.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../math.js */ "./src/math.js");
/* harmony import */ var _base_models_DuplicableMixin_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../base/models/DuplicableMixin.js */ "./src/base/models/DuplicableMixin.js");
/* global AppOption */




var BaseLineCollection = backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.extend(BaseLineCollection).extend(_base_models_DuplicableMixin_js__WEBPACK_IMPORTED_MODULE_3__["default"]).extend({
  initialize: function initialize() {
    this.on("remove", this.channelCall);
    this.on("sync", this.channelCall);
    this.on("reset", this.channelCall);
    this.on("add", this.channelCall);
  },
  channelCall: function channelCall(model) {
    console.log("Triggering Channel call");
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("facade");
    channel.trigger("changed:line");
  },
  url: function url() {
    return AppOption["context_url"] + "/lines";
  },
  total_ht: function total_ht() {
    var result = 0;
    this.each(function (model) {
      result += (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.round)(model.getHT());
    });
    return result;
  },
  total_tva: function total_tva() {
    var result = 0;
    this.each(function (model) {
      result += (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.round)(model.getTva());
    });
    return result;
  },
  total: function total() {
    var result = 0;
    this.each(function (model) {
      result += (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.round)(model.total());
    });
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseLineCollection);

/***/ }),

/***/ "./src/base/models/BaseLineModel.js":
/*!******************************************!*\
  !*** ./src/base/models/BaseLineModel.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _base_models_BaseModel_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../base/models/BaseModel.js */ "./src/base/models/BaseModel.js");
/* harmony import */ var _base_models_DuplicableMixin_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../base/models/DuplicableMixin.js */ "./src/base/models/DuplicableMixin.js");



var BaseLineModel = _base_models_BaseModel_js__WEBPACK_IMPORTED_MODULE_1__["default"].extend(_base_models_DuplicableMixin_js__WEBPACK_IMPORTED_MODULE_2__["default"]).extend({
  defaults: {
    description: "",
    ht: null,
    tva: null
  },
  initialize: function initialize(options) {
    this.config = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("config");
  },
  // Validation rules for our model's attributes
  validation: {
    ht: {
      required: true,
      pattern: "amount",
      msg: "doit être un nombre"
    },
    tva: {
      required: true,
      pattern: "amount",
      msg: "doit être un nombre"
    },
    type_id: {
      required: true,
      msg: "est requis"
    }
  },
  total: function total() {
    var total = this.getHT() + this.getTva();
    return total;
  },
  getTva: function getTva() {
    var result = parseFloat(this.get("tva"));
    return result;
  },
  getHT: function getHT() {
    var result = parseFloat(this.get("ht"));
    return result;
  },
  getType: function getType() {
    return this.config.request("get:ExpenseType", this.get("type_id"));
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseLineModel);

/***/ }),

/***/ "./src/base/models/BaseModel.js":
/*!**************************************!*\
  !*** ./src/base/models/BaseModel.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");




var BaseModel = backbone__WEBPACK_IMPORTED_MODULE_2___default().Model.extend({
  /*
   * A Base model that add some extras functionnalities to the Base backbone model
   *
   * allow to rollback current model model.rollback()
   * triggers some additionnal events :
   *
   * ('destroyed') when a model has been effectively deleted
   * ('saved', attributes) when the attributes value has been saved server side
   * ('saved:attribute', value) for each attribute
   */
  // Props are used to describe the model and limit the attributes that
  // are set on it and send to the server.
  props: null,
  // itemBaseUrl can be defined to override the url used to fetch/save/delete an existing item
  // EX : /api/v1/files/
  itemBaseUrl: null,
  constructor: function constructor() {
    arguments[0] = this.cleanProps(arguments[0]);
    backbone__WEBPACK_IMPORTED_MODULE_2___default().Model.apply(this, arguments);
    this.save_xhr_request = null;
  },
  toJSON: function toJSON(options) {
    var attributes = underscore__WEBPACK_IMPORTED_MODULE_1___default().clone(this.attributes);
    attributes = this.cleanProps(attributes);
    return attributes;
  },
  set: function set(key, val, options) {
    // Hack Model.set pour filtrer selon les props (si props est spécifié)
    if (this.props) {
      if ((0,_babel_runtime_helpers_esm_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(key) === "object") {
        key = this.cleanProps(key);
      } else {
        if (!this.props.includes(key)) {
          key = null;
        }
      }
    }
    return backbone__WEBPACK_IMPORTED_MODULE_2___default().Model.prototype.set.call(this, key, val, options);
  },
  _runSave: function _runSave(key, val, options) {
    var _this = this;
    var xhr_request = backbone__WEBPACK_IMPORTED_MODULE_2___default().Model.prototype.save.call(this, key, val, options);
    if (xhr_request) {
      xhr_request.done(function () {
        if (underscore__WEBPACK_IMPORTED_MODULE_1___default().isObject(key)) {
          Object.keys(key).map(function (i) {
            console.log("Triggering saved : %s, value %s", i, key[i]);
            _this.trigger("saved:" + i, key[i]);
          });
          console.log("Triggering saved");
          _this.trigger("saved", key);
        } else {
          console.log("Triggering saved : %s, value %s", key, val);
          _this.trigger("saved:" + key, val);
          console.log("Triggering saved");
          _this.trigger("saved");
        }
      });
    }
    return xhr_request;
  },
  save: function save(key, val, options) {
    var _this2 = this;
    if (this.itemBaseUrl !== null) {
      var url = this.itemBaseUrl + this.get("id");
      options = underscore__WEBPACK_IMPORTED_MODULE_1___default().defaults(options || {}, {
        url: url
      });
    }
    if (this.save_xhr_request && this.save_xhr_request.state() == "pending") {
      console.log("A request is pending for this model, we wait it ends");
      this.save_xhr_request = this.save_xhr_request.then(function () {
        return _this2._runSave(key, val, options);
      });
    } else {
      this.save_xhr_request = this._runSave(key, val, options);
    }
    return this.save_xhr_request;
  },
  destroy: function destroy(options) {
    if (this.itemBaseUrl !== null) {
      var url = this.itemBaseUrl + this.get("id");
      options = underscore__WEBPACK_IMPORTED_MODULE_1___default().defaults(options || {}, {
        url: url
      });
    }
    var collection = this.collection;
    var xhr_request = backbone__WEBPACK_IMPORTED_MODULE_2___default().Model.prototype.destroy.call(this, options);
    if (xhr_request) {
      xhr_request.done(function () {
        console.log("Triggering destroyed");
        collection.trigger("destroyed");
      });
    }
    return xhr_request;
  },
  fetch: function fetch(options) {
    if (this.itemBaseUrl !== null) {
      var url = this.itemBaseUrl + this.get("id");
      options = underscore__WEBPACK_IMPORTED_MODULE_1___default().defaults(options || {}, {
        url: url
      });
    }
    return backbone__WEBPACK_IMPORTED_MODULE_2___default().Model.prototype.fetch.call(this, options);
  },
  cleanProps: function cleanProps(attributes) {
    if (!underscore__WEBPACK_IMPORTED_MODULE_1___default().isNull(this.props)) {
      attributes = underscore__WEBPACK_IMPORTED_MODULE_1___default().pick(attributes, this.props);
      attributes = underscore__WEBPACK_IMPORTED_MODULE_1___default().omit(attributes, function (value) {
        return underscore__WEBPACK_IMPORTED_MODULE_1___default().isNull(value) || underscore__WEBPACK_IMPORTED_MODULE_1___default().isUndefined(value);
      });
    }
    return attributes;
  },
  rollback: function rollback(remote) {
    if (this.get("id")) {
      if (remote) {
        this.fetch();
      } else {
        var changed = this.changedAttributes();
        if (!changed) return;
        var keys = underscore__WEBPACK_IMPORTED_MODULE_1___default().keys(changed);
        var prev = underscore__WEBPACK_IMPORTED_MODULE_1___default().pick(this.previousAttributes(), keys);
        this.set(prev);
      }
    }
  },
  findLabelFromId: function findLabelFromId(model_attr, label_key, options) {
    /*
     * Return the label of an option identified by it's id key
     * :param str model_attr: The foreign key key we use to search
     * :param str label_key: The "label" key of the related object
     * :param list options: List of potential related elements
     */
    var value = this.get(model_attr);
    var result = "-";
    if (value) {
      var option = (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.findCurrentSelected)(options, parseInt(value), "id");
      if (option) {
        result = option[label_key];
      }
    }
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseModel);

/***/ }),

/***/ "./src/base/models/ButtonCollection.js":
/*!*********************************************!*\
  !*** ./src/base/models/ButtonCollection.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ButtonModel_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ButtonModel.js */ "./src/base/models/ButtonModel.js");
/*
 * File Name :  ButtonCollection.js
 */


var ButtonCollection = backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.extend({
  model: _ButtonModel_js__WEBPACK_IMPORTED_MODULE_1__["default"]
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ButtonCollection);

/***/ }),

/***/ "./src/base/models/ButtonModel.js":
/*!****************************************!*\
  !*** ./src/base/models/ButtonModel.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/*
 * File Name :  ButtonModel.js
 */

var ButtonModel = backbone__WEBPACK_IMPORTED_MODULE_0___default().Model.extend({
  /*
   * A ButtonModel
   *
   * pass it :
   *
   *  action: The associated action name (used to fire events)
   *  label
   *  icon
   *  showLabel
   *
   */
  defaults: {
    showLabel: true,
    icon: false,
    type: "button"
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ButtonModel);

/***/ }),

/***/ "./src/base/models/DuplicableMixin.js":
/*!********************************************!*\
  !*** ./src/base/models/DuplicableMixin.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");


var DuplicableMixin = {
  /**
   * A mixin for models that implement back-end duplication.
   *
   * REST API side has to offer a ?action=duplicate on resource.
   *
   * duplicate() method to the model.
   *
   *
   * Return a promise providing the duplicated model
   *
   *
   *      var promise = this.model.duplicate();
   *      promise.done(function(model){
   *          // Do something with the new model;
   *      })
   *
   * NB : After the promise is resolved, the collection is also up to date
   */
  onDuplicateError: function onDuplicateError(result) {
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("message");
    channel.trigger("error:ajax", result);
  },
  onDuplicateCallback: function onDuplicateCallback(result) {
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("message");
    channel.trigger("success:ajax", result);
  },
  duplicate: function duplicate(datas) {
    var refresh = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    // duplication du modèle
    var request = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.ajax_call)(this.url() + "?action=duplicate", datas, "POST");
    var result = request;
    if (refresh) {
      // On chaîne un fetch de la collection
      var collection = this.collection;
      var fetch = request.then(function () {
        return collection.fetch();
      });

      // On crée une promise qui sera résolue si les deux requêtes
      // ci-dessus sont terminées ce qui permet d'avoir toutes les
      // informations lors de la fin de la requête
      var promise = $.when(request, fetch);
      result = promise.then(function (a) {
        var model_id = a[0]["id"];
        return collection.get(model_id);
      });
    }
    request.done(this.onDuplicateCallback.bind(this)).fail(this.onDuplicateError.bind(this));
    return result;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DuplicableMixin);

/***/ }),

/***/ "./src/base/models/OrderableCollection.js":
/*!************************************************!*\
  !*** ./src/base/models/OrderableCollection.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _BaseCollection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BaseCollection */ "./src/base/models/BaseCollection.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");


var OrderableCollection = _BaseCollection__WEBPACK_IMPORTED_MODULE_1__["default"].extend({
  comparator: "order",
  initialize: function initialize(options) {
    this.updateModelOrder(false);
  },
  updateModelOrder: function updateModelOrder(sync) {
    var _this = this;
    /*
     * Update the model's order
     *
     * :param bool sync: Should we synchronize the change ?
     */
    if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(sync)) {
      sync = true;
    }
    var requests = [];
    this.each(function (model, index) {
      var order = model.get("order");
      if (order == index) {
        return;
      }
      model.set("order", index);
      if (sync) {
        var request = model.save({
          order: index
        }, {
          patch: true
        });
        requests.push(request);
      }
    });
    return $.when(requests).then(function () {
      return _this.trigger("change:reorder");
    });
  },
  getOrder: function getOrder(comp_func) {
    /*
    :param func comp_func: The function used to compare two items returning one oh them
    */
    if (this.models.length == 0) {
      return 0;
    }
    return this.models.reduce(comp_func).get("order");
  },
  getMinOrder: function getMinOrder() {
    var comp_func = function comp_func(prev, curr) {
      return prev.get("order") < curr.get("order") ? prev : curr;
    };
    return this.getOrder(comp_func);
  },
  getMaxOrder: function getMaxOrder() {
    var comp_func = function comp_func(prev, curr) {
      return prev.get("order") < curr.get("order") ? curr : prev;
    };
    return this.getOrder(comp_func);
  },
  moveUp: function moveUp(model) {
    // I see move up as the -1
    var index = this.indexOf(model);
    if (index > 0) {
      this.models.splice(index - 1, 0, this.models.splice(index, 1)[0]);
    }
    return this.updateModelOrder();
  },
  moveDown: function moveDown(model) {
    // I see move up as the -1
    var index = this.indexOf(model);
    if (index < this.models.length) {
      this.models.splice(index + 1, 0, this.models.splice(index, 1)[0]);
    }
    return this.updateModelOrder();
  },
  /**
   * fetch all models of the collection individually
   *
   * @returns A Promise
   */
  syncAll: function syncAll() {
    var _$;
    var promises = [];
    this.each(function (model) {
      promises.push(model.fetch());
    });
    var resulting_deferred = (_$ = $).when.apply(_$, promises);
    return resulting_deferred;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OrderableCollection);

/***/ }),

/***/ "./src/base/views/ErrorView.js":
/*!*************************************!*\
  !*** ./src/base/views/ErrorView.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_0__);

var ErrorView = backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default().View.extend({
  tagName: "div",
  className: "alert alert-danger",
  template: __webpack_require__(/*! ./templates/ErrorView.mustache */ "./src/base/views/templates/ErrorView.mustache"),
  ui: {
    close: ".close"
  },
  events: {
    "click @ui.close": "onClose"
  },
  onClose: function onClose() {
    this.remove();
  },
  initialize: function initialize() {
    this.errors = this.getOption("errors");
  },
  templateContext: function templateContext() {
    return {
      errors: this.errors
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorView);

/***/ }),

/***/ "./src/base/views/LoginView.js":
/*!*************************************!*\
  !*** ./src/base/views/LoginView.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _behaviors_ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../behaviors/ModalBehavior.js */ "./src/base/behaviors/ModalBehavior.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);



var template = __webpack_require__(/*! ./templates/LoginView.mustache */ "./src/base/views/templates/LoginView.mustache");
var LoginView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  id: "login-modal",
  className: "modal-overlay",
  behaviors: [_behaviors_ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__["default"]],
  template: template,
  url: "/api/login/v1",
  ui: {
    form: "form",
    login: "input[name=login]",
    password: "input[type=password]",
    remember_me: "input[name=remember_me]",
    errors: ".errors"
  },
  events: {
    "submit @ui.form": "onSubmit"
  },
  onSubmit: function onSubmit(event) {
    event.preventDefault();
    this.getUI("errors").hide();
    var datas = {
      login: this.getUI("login").val(),
      password: this.getUI("password").val()
    };
    if (this.getUI("remember_me").is(":checked")) {
      datas["remember_me"] = true;
    }
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("auth");
    channel.trigger("login", datas, this.success.bind(this), this.error.bind(this));
  },
  onModalBeforeClose: function onModalBeforeClose() {
    console.log("Redirecting");
    window.location.replace("#");
  },
  success: function success() {
    this.triggerMethod("close");
  },
  error: function error() {
    this.getUI("errors").html("Erreur d'authentification");
    this.getUI("errors").show();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoginView);

/***/ }),

/***/ "./src/base/views/MessageView.js":
/*!***************************************!*\
  !*** ./src/base/views/MessageView.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");




var MessageView = backbone_marionette__WEBPACK_IMPORTED_MODULE_3___default().View.extend({
  tagName: "div",
  template: __webpack_require__(/*! ./templates/MessageView.mustache */ "./src/base/views/templates/MessageView.mustache"),
  ui: {
    close: "button.close-link",
    alert: ".alert"
  },
  events: {
    "click @ui.close": "onClose"
  },
  modelEvents: {
    "change:notifyClass": "render"
  },
  className: "messages-static-top visuallyhidden",
  onClose: function onClose() {
    this.model.set({
      notifyText: null
    });
    this.$el.hide();
  },
  initialize: function initialize() {
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("message");
    channel.reply({
      "notify:success": this.notifySuccess.bind(this),
      "notify:error": this.notifyError.bind(this)
    });
  },
  notifyError: function notifyError(message) {
    console.log("Notify error");
    this.model.set({
      notifyClass: "error",
      notifyText: message
    });
    this.ui.alert.addClass("alert-danger");
    this.ui.alert.removeClass("alert-success");
    this.$el.removeClass("visuallyhidden");
    this.$el.show();
    (0,_tools_js__WEBPACK_IMPORTED_MODULE_2__.scrollTop)(top);
  },
  notifySuccess: function notifySuccess(message) {
    console.log("Notify success");
    this.model.set({
      notifyClass: "success",
      notifyText: message
    });
    this.ui.alert.removeClass("alert-danger");
    this.$el.removeClass("visuallyhidden");
    this.ui.alert.addClass("alert-success");
    this.$el.show();
  },
  templateContext: function templateContext() {
    var has_message = false;
    if (this.model.get("notifyText")) {
      has_message = true;
    }
    return {
      has_message: has_message,
      error: this.model.get("notifyClass") == "error"
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MessageView);

/***/ }),

/***/ "./src/base/views/TvaProductFormMixin.js":
/*!***********************************************!*\
  !*** ./src/base/views/TvaProductFormMixin.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _widgets_SelectWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../widgets/SelectWidget.js */ "./src/widgets/SelectWidget.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");

var TvaProductFormMixin = {
  /*
   * Mixin handling tva + product synchronization inside a form
   *
   * Expects the View to have :
   *
   * a model with tva_id and product_id attributes
   * an attribute all_product_options
   * an attribute product_options (current options)
   * an attributes tva_options
   *
   * a product_id region
   *
   */
  getDefaultTva: function getDefaultTva() {
    var result = _.findWhere(this.tva_options, {
      "default": true
    });
    if (!result) {
      result = this.tva_options[0];
    }
    return result;
  },
  getCurrentTvaId: function getCurrentTvaId() {
    /*
    Return the tva id of the current model
    Can be overridden if needed
    */
    var tva_id;
    if (this.model.has("tva_id")) {
      tva_id = this.model.get("tva_id");
    } else if (!this.model.props || !("tva_id" in this.model.props)) {
      console.error("This model has no tva_id declared, did you forget to override the getCurrentTvaId method ?");
    }
    return tva_id;
  },
  getProductOptions: function getProductOptions(tva_options, product_options, tva_id) {
    /*
     *  Return an array on filtered products option depending on selected tva
     *  :params list tva_options:
     *  :params list product_options:
     *  :params int tva_id: optionnal tva id
     */
    if (!tva_id) {
      tva_id = this.getCurrentTvaId();
    }
    var options = [];
    if (tva_id) {
      options = _.filter(product_options, function (product) {
        return product.tva_id === parseInt(tva_id);
      });
    }
    return options;
  },
  refreshTvaProductSelect: function refreshTvaProductSelect(event) {
    /**
     * Update and show the TVA products option select
     * :param obj event
     */
    this.product_options = this.getProductOptions(this.tva_options, this.all_product_options);
    this.showChildView("product_id", new _widgets_SelectWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"]({
      options: this.product_options,
      title: "Compte produit",
      value: this.model.get("product_id"),
      field_name: "product_id",
      id_key: "id",
      placeholder: "Choisir un compte produit"
    }));
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TvaProductFormMixin);

/***/ }),

/***/ "./src/common/components/ExpenseTypeService.js":
/*!*****************************************************!*\
  !*** ./src/common/components/ExpenseTypeService.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../base/components/ConfigBus.js */ "./src/base/components/ConfigBus.js");
/* harmony import */ var _models_ExpenseTypeCollection_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/ExpenseTypeCollection.js */ "./src/common/models/ExpenseTypeCollection.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");






/**
 * Specialized config bus responder for Expense Types
 *
 * Answers side-to-side with ConfigBus on same 'config' radio channel.
 */
var ExpenseTypeServiceClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default().Object.extend({
  channelName: "config",
  radioRequests: {
    "get:typeOptions": "getTypeOptions",
    "get:ExpenseType": "get"
  },
  setFormConfig: function setFormConfig(form_config) {
    var allExpenseTypes = underscore__WEBPACK_IMPORTED_MODULE_0___default().flatten([form_config.options.expensekm_types, form_config.options.expense_types, form_config.options.expensetel_types, form_config.options.purchase_types]);
    this.expenseTypes = {
      km: new _models_ExpenseTypeCollection_js__WEBPACK_IMPORTED_MODULE_3__["default"](form_config.options.expensekm_types),
      expense: new _models_ExpenseTypeCollection_js__WEBPACK_IMPORTED_MODULE_3__["default"](form_config.options.expense_types),
      purchase: new _models_ExpenseTypeCollection_js__WEBPACK_IMPORTED_MODULE_3__["default"](form_config.options.purchase_types),
      tel: new _models_ExpenseTypeCollection_js__WEBPACK_IMPORTED_MODULE_3__["default"](form_config.options.expensetel_types),
      all: new _models_ExpenseTypeCollection_js__WEBPACK_IMPORTED_MODULE_3__["default"](allExpenseTypes)
    };
  },
  getTypeOptions: function getTypeOptions(family) {
    /**
     * Provides objects with objects suitable for <option> initialization
     *
     * @param familly: one of 'tel', 'expense', 'purchase', or 'km'.
     * @return list of {id: …, label: …, category: 'all'|'0'|'1'}
     */
    if (!this.expenseTypes[family]) {
      throw new Error("Unknown expense type family: ".concat(family));
    }
    return this.expenseTypes[family].models.map(function (x) {
      return {
        id: x.id,
        label: x.get("label"),
        category: x.get("category")
      };
    });
  },
  get: function get(id) {
    return this.expenseTypes.all.get(id);
  },
  setup: function setup(form_config_url) {
    console.log("ExpenseTypeServiceClass.setup");
  },
  start: function start() {
    console.log("ExpenseTypeServiceClass.start");
    this.setFormConfig(_base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_2__["default"].form_config);
    var result = $.Deferred();
    result.resolve(_base_components_ConfigBus_js__WEBPACK_IMPORTED_MODULE_2__["default"].form_config, null, null);
    return result;
  }
});
var ExpenseTypeService = new ExpenseTypeServiceClass();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExpenseTypeService);

/***/ }),

/***/ "./src/common/components/NodeFileViewerFactory.js":
/*!********************************************************!*\
  !*** ./src/common/components/NodeFileViewerFactory.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);



/** Instantiate the propper viewer view for a NodeFileModel
 *
 * Requires PreviewService to be setup.
 */
var NodeFileViewerFactoryClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().Object.extend({
  /**
   *
   * @param {NodeFileModel} file the file object to be viewed
   * @param {Object} kwargs extra args to be passed as-is to viewer constructor
   * @returns {Mn.View} (or null if no viewer is found)
   */
  getViewer: function getViewer(file, kwargs) {
    var mime = file.get("mimetype");
    var id = file.get("id");
    var klass = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("config").request("get:viewer:class", file);
    if (klass) {
      var args = Object.assign({
        fileUrl: "/files/".concat(id, "?action=download"),
        fileLabel: file.get("label")
      }, kwargs);
      return new klass(args);
    } else {
      console.warn("Trying to render unknown file type: \"".concat(mime, " for file #").concat(id));
      return null;
    }
  }
});
var NodeFileViewerFactory = new NodeFileViewerFactoryClass();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NodeFileViewerFactory);

/***/ }),

/***/ "./src/common/components/PreviewService.js":
/*!*************************************************!*\
  !*** ./src/common/components/PreviewService.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../views/ImageViewerView */ "./src/common/views/ImageViewerView.js");
/* harmony import */ var _views_PDFViewerView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../views/PDFViewerView */ "./src/common/views/PDFViewerView.js");
/* harmony import */ var _base_components_ConfigBus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../base/components/ConfigBus */ "./src/base/components/ConfigBus.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");






/**
 * Specialized config bus responder for Expense Types
 *
 * Answers side-to-side with ConfigBus on same 'config' radio channel.
 */
var PreviewServiceClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default().Object.extend({
  channelName: "config",
  radioRequests: {
    "is:previewable": "isPreviewable",
    "get:viewer:class": "getViewerClass"
  },
  typesMap: {
    "image/jpeg": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/svg+xml": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/gif": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/bitmap": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/png": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/svg": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/webp": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/apng": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "image/tiff": _views_ImageViewerView__WEBPACK_IMPORTED_MODULE_1__["default"],
    "application/pdf": _views_PDFViewerView__WEBPACK_IMPORTED_MODULE_2__["default"]
  },
  setup: function setup(form_config_url) {
    console.log("PreviewService.setup");
  },
  start: function start() {
    console.log("PreviewService.start");
    var result = $.Deferred();
    result.resolve(_base_components_ConfigBus__WEBPACK_IMPORTED_MODULE_3__["default"].form_config, null, null);
    return result;
  },
  /**
   * Tells wether or not the file is previewable in the browser
   *
   * @param {NodeFileModel} nodeFile
   * @return {boolean}
   */
  isPreviewable: function isPreviewable(nodeFile) {
    return this.typesMap.hasOwnProperty(nodeFile.get("mimetype"));
  },
  /**
   * Tells wether or not the file is previewable in the browser
   *
   * @param {NodeFileModel} nodeFile
   * @return {BaseDocumentViewer} (non-instantiated)
   */
  getViewerClass: function getViewerClass(nodeFile) {
    return this.typesMap[nodeFile.get("mimetype")];
  }
});
var PreviewService = new PreviewServiceClass();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewService);

/***/ }),

/***/ "./src/common/components/StatusHistoryApp.js":
/*!***************************************************!*\
  !*** ./src/common/components/StatusHistoryApp.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _views_StatusHistoryView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../views/StatusHistoryView */ "./src/common/views/StatusHistoryView.js");



/** Gère l'historique des statuts/mémos sur un objet
 */
var StatusHistoryAppClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().Application.extend({
  region: {
    el: ".status_history",
    replaceElement: true
  },
  /**
   * @param {Bb.Collection} status_history  the statuses history
   */
  onStart: function onStart(app, status_history) {
    var view = new _views_StatusHistoryView__WEBPACK_IMPORTED_MODULE_0__["default"]({
      collection: status_history
    });
    this.showView(view);
  }
});
var StatusHistoryApp = new StatusHistoryAppClass();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusHistoryApp);

/***/ }),

/***/ "./src/common/components/ToolbarAppClass.js":
/*!**************************************************!*\
  !*** ./src/common/components/ToolbarAppClass.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _views_ActionToolbar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../views/ActionToolbar */ "./src/common/views/ActionToolbar.js");


var ToolbarAppClass = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().Application.extend({
  /*
  Base classe for Toolbar management
  */
  region: "#js_actions",
  getResumeView: function getResumeView(actions) {
    return null; // default
  },
  getMainActions: function getMainActions(actions) {
    return actions["main"];
  },
  getMoreActions: function getMoreActions(actions) {
    return actions["more"];
  },
  renderApp: function renderApp(actions) {
    var main_view = this.getMainActions(actions);
    var more_view = this.getMoreActions(actions);
    var resume_view = this.getResumeView(actions);
    if (main_view != null && main_view.length > 0 || more_view != null && more_view.length > 0 || resume_view != null && resume_view.length > 0) {
      this.view = new _views_ActionToolbar__WEBPACK_IMPORTED_MODULE_0__["default"]({
        main: main_view,
        more: more_view,
        resume: resume_view
      });
      this.showView(this.view);
    }
  },
  onStart: function onStart(app, actions) {
    this.renderApp(actions);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ToolbarAppClass);

/***/ }),

/***/ "./src/common/components/ValidationLimitToolbarAppClass.js":
/*!*****************************************************************!*\
  !*** ./src/common/components/ValidationLimitToolbarAppClass.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ToolbarAppClass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ToolbarAppClass */ "./src/common/components/ToolbarAppClass.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);


var ValidationLimitToolbarAppClass = _ToolbarAppClass__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  initialize: function initialize() {
    this.facade = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("facade");
    this.listenTo(this.facade, "changed:line", this.onLineUpdate);
    this.listenTo(this.facade, "changed:task", this.onLineUpdate);
    this.listenTo(this.facade, "changed:discount", this.onLineUpdate);
    this.listenTo(this.facade, "changed:post_ttc_line", this.onLineUpdate);
  },
  onLineUpdate: function onLineUpdate() {
    var _this = this;
    this.config = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("config");
    this.config.request("reload_config").then(function () {
      var actions = _this.config.request("get:form_actions");
      _this.renderApp(actions);
    });
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ValidationLimitToolbarAppClass);

/***/ }),

/***/ "./src/common/models/ActionCollection.js":
/*!***********************************************!*\
  !*** ./src/common/models/ActionCollection.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ActionModel_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ActionModel.js */ "./src/common/models/ActionModel.js");


var ActionCollection = backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.extend({
  model: _ActionModel_js__WEBPACK_IMPORTED_MODULE_1__["default"]
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ActionCollection);

/***/ }),

/***/ "./src/common/models/ActionModel.js":
/*!******************************************!*\
  !*** ./src/common/models/ActionModel.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);

var ActionModel = backbone__WEBPACK_IMPORTED_MODULE_0___default().Model.extend({});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ActionModel);

/***/ }),

/***/ "./src/common/models/CatalogTreeCollection.js":
/*!****************************************************!*\
  !*** ./src/common/models/CatalogTreeCollection.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CatalogTreeModel_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CatalogTreeModel.js */ "./src/common/models/CatalogTreeModel.js");
/* harmony import */ var math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! math.js */ "./src/math.js");
/*
 * File Name : CatalogTreeCollection.js
 */



var CatalogTreeCollection = backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.extend({
  model: _CatalogTreeModel_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  initialize: function initialize() {
    CatalogTreeCollection.__super__.initialize.apply(this, arguments);
    this.current = this.models.filter(function (model) {
      return model.get("selected");
    });
  },
  getSelected: function getSelected() {
    return this.current;
  },
  allSelected: function allSelected() {
    return this.current.length == this.length;
  },
  setSelected: function setSelected(model, value) {
    var select = !model.get("selected");
    console.log("select", select);
    model.set("selected", select);
    this.current = this.models.filter(function (model) {
      return model.get("selected");
    });
    this.trigger("change:selected");

    // change une quantité nulle lorsque l'item est selectionné
    if (select && (0,math_js__WEBPACK_IMPORTED_MODULE_2__.strToFloat)(model.get("quantity")) == 0) {
      this.setQuantity(model, "1");
    }
  },
  setQuantity: function setQuantity(model, value) {
    model.set("quantity", value);
    this.trigger("change:quantity");
    var selected = (0,math_js__WEBPACK_IMPORTED_MODULE_2__.strToFloat)(value) != 0;

    // change la selection lorsque la quantité est nulle
    if (selected != model.get("selected")) {
      this.setSelected(model, selected);
    }
  },
  setAllSelected: function setAllSelected(models) {
    var _this = this;
    // Set all elements selected : allow to pass a list of
    // models (in case of all selection on filtered list)
    if (models === undefined) {
      models = this.models;
    }
    this.current = models;
    this.current.forEach(function (item) {
      return _this.setSelected(item, true);
    });
  },
  setNoneSelected: function setNoneSelected() {
    var _this2 = this;
    console.log("Set None selected");
    this.current.forEach(function (item) {
      return _this2.setSelected(item, false);
    });
    this.current = [];
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CatalogTreeCollection);

/***/ }),

/***/ "./src/common/models/CatalogTreeModel.js":
/*!***********************************************!*\
  !*** ./src/common/models/CatalogTreeModel.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../math.js */ "./src/math.js");
/*
 * File Name :  CatalogTreeModel
 */


var CatalogTreeModel = backbone__WEBPACK_IMPORTED_MODULE_0___default().Model.extend({
  defaults: {
    selected: false,
    quantity: "0"
  },
  matchPattern: function matchPattern(search) {
    // i for non-case-sensitive
    var regexp = new RegExp(search, "i");
    if (this.get("label").search(regexp) !== -1 || this.get("description").search(regexp) !== -1 || this.get("category_label").search(regexp) !== -1) {
      return true;
    }
    return false;
  },
  ht_label: function ht_label() {
    var precision = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 2;
    console.log(precision);
    return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.formatAmount)(this.get("ht"), true, false, precision);
  },
  ttc_label: function ttc_label() {
    var precision = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 2;
    console.log(precision);
    return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.formatAmount)(this.get("ttc"), true, false, precision);
  },
  supplier_ht_label: function supplier_ht_label() {
    var precision = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 2;
    return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.formatAmount)(this.get("supplier_ht"), true, false, precision);
  },
  is_valid: function is_valid() {
    if (!this.get("selected")) {
      return true;
    }
    var regexp = new RegExp("^\-?[0-9]*([,.][0-9]{0,5})?$");
    if (this.get("quantity").match(regexp)) {
      return true;
    }
    return false;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CatalogTreeModel);

/***/ }),

/***/ "./src/common/models/ExpenseTypeCollection.js":
/*!****************************************************!*\
  !*** ./src/common/models/ExpenseTypeCollection.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ExpenseTypeModel_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ExpenseTypeModel.js */ "./src/common/models/ExpenseTypeModel.js");



var ExpenseTypeCollection = backbone__WEBPACK_IMPORTED_MODULE_1___default().Collection.extend({
  model: _ExpenseTypeModel_js__WEBPACK_IMPORTED_MODULE_2__["default"]
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExpenseTypeCollection);

/***/ }),

/***/ "./src/common/models/ExpenseTypeModel.js":
/*!***********************************************!*\
  !*** ./src/common/models/ExpenseTypeModel.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../math.js */ "./src/math.js");


var ExpenseTypeModel = backbone__WEBPACK_IMPORTED_MODULE_0___default().Model.extend({
  props: ["code", "value", "label", "active",
  // For tel only
  "percentage", "id",
  // For km only
  "amount",
  // Read-only
  "family"],
  defaults: {
    // Generalize special tel computation
    percentage: 100
  },
  computeAmount: function computeAmount(amount) {
    /**
     * Compute the amount of the expense to be handled by CAE.
     */
    var result;
    if (this.has("percentage") && this.get("percentage") != 100) {
      result = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.getPercent)(amount, this.get("percentage"));
    } else {
      // We want to avoid rounding if 100%.
      result = amount;
    }
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExpenseTypeModel);

/***/ }),

/***/ "./src/common/models/NodeFileCollection.js":
/*!*************************************************!*\
  !*** ./src/common/models/NodeFileCollection.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var base_models_BaseCollection_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! base/models/BaseCollection.js */ "./src/base/models/BaseCollection.js");
/* harmony import */ var _NodeFileModel_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./NodeFileModel.js */ "./src/common/models/NodeFileModel.js");



var NodeFileCollection = base_models_BaseCollection_js__WEBPACK_IMPORTED_MODULE_1__["default"].extend({
  model: _NodeFileModel_js__WEBPACK_IMPORTED_MODULE_2__["default"],
  comparator: function comparator(model) {
    return model.get("name").toLowerCase(0);
  },
  asSelectOptions: function asSelectOptions() {
    return this.models.map(function (x) {
      return {
        value: x.get("id"),
        label: x.get("label")
      };
    });
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NodeFileCollection);

/***/ }),

/***/ "./src/common/models/NodeFileModel.js":
/*!********************************************!*\
  !*** ./src/common/models/NodeFileModel.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var base_models_BaseModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! base/models/BaseModel */ "./src/base/models/BaseModel.js");
/*
 * File Name :  NodeFileModel
 */

var NodeFileModel = base_models_BaseModel__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  itemBaseUrl: "/api/v1/files/"
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NodeFileModel);

/***/ }),

/***/ "./src/common/models/StatusLogEntryCollection.js":
/*!*******************************************************!*\
  !*** ./src/common/models/StatusLogEntryCollection.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _StatusLogEntryModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./StatusLogEntryModel */ "./src/common/models/StatusLogEntryModel.js");



/** Collection of status log entries
 *
 * Contains both the status memos triggered by status change and the manual « memos »
 *
 * A sub-route <ressource_url>/statuslogentries is expected.
 */
var StatusLogEntryCollection = backbone__WEBPACK_IMPORTED_MODULE_0___default().Collection.extend({
  model: _StatusLogEntryModel__WEBPACK_IMPORTED_MODULE_1__["default"],
  url: function url() {
    return AppOption["context_url"] + "/statuslogentries";
  },
  /**
   * Sort by -pinned,-datetime
   */
  comparator: function comparator(a, b) {
    if (a.get("pinned") === b.get("pinned")) {
      if (a.get("datetime") < b.get("datetime")) {
        return 1;
      } else {
        return -1;
      }
    } else {
      if (b.get("pinned")) {
        return 1;
      } else {
        return -1;
      }
    }
  },
  getPinnedCount: function getPinnedCount() {
    return this.filter(function (x) {
      return x.get("pinned");
    }).length;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusLogEntryCollection);

/***/ }),

/***/ "./src/common/models/StatusLogEntryModel.js":
/*!**************************************************!*\
  !*** ./src/common/models/StatusLogEntryModel.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var base_models_BaseModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! base/models/BaseModel */ "./src/base/models/BaseModel.js");



var StatusLogEntryModel = base_models_BaseModel__WEBPACK_IMPORTED_MODULE_2__["default"].extend({
  props: ["id", "datetime", "status", "label", "comment", "icon", "css_class", "user", "can_edit", "visibility", "pinned", "notify", "notification_recipients"],
  defaults: function defaults() {
    var config = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("config");
    var recipients = config.request("get:options", "notification_recipients");
    if (!recipients) {
      recipients = [];
    }
    return {
      label: "",
      comment: "",
      pinned: false,
      notify: recipients.length > 0,
      notification_recipients: recipients.map(function (recipient) {
        return recipient.id;
      })
    };
  },
  cleanProps: function cleanProps(attributes) {
    // Turn this method into no-op to avoid discarding null-attrs
    // Discarding null-attrs as cleanProps does prevents null-valued
    // attributed to be synced correctly from server.
    return attributes;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusLogEntryModel);

/***/ }),

/***/ "./src/common/views/ActionListView.js":
/*!********************************************!*\
  !*** ./src/common/views/ActionListView.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _widgets_AnchorWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../widgets/AnchorWidget.js */ "./src/widgets/AnchorWidget.js");
/* harmony import */ var _widgets_ToggleButtonWidget_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../widgets/ToggleButtonWidget.js */ "./src/widgets/ToggleButtonWidget.js");
/* harmony import */ var _widgets_StatusButtonWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../widgets/StatusButtonWidget */ "./src/widgets/StatusButtonWidget.js");
/* harmony import */ var _widgets_POSTButtonWidget_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../widgets/POSTButtonWidget.js */ "./src/widgets/POSTButtonWidget.js");
/* harmony import */ var _models_ActionCollection_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../models/ActionCollection.js */ "./src/common/models/ActionCollection.js");
/* harmony import */ var _widgets_ToolbarButtonWidget_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../widgets/ToolbarButtonWidget.js */ "./src/widgets/ToolbarButtonWidget.js");








var ActionListView = backbone_marionette__WEBPACK_IMPORTED_MODULE_7___default().CollectionView.extend({
  childTemplates: {
    anchor: _widgets_AnchorWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"],
    toggle: _widgets_ToggleButtonWidget_js__WEBPACK_IMPORTED_MODULE_2__["default"],
    POSTButton: _widgets_POSTButtonWidget_js__WEBPACK_IMPORTED_MODULE_4__["default"],
    status: _widgets_StatusButtonWidget__WEBPACK_IMPORTED_MODULE_3__["default"],
    button: _widgets_ToolbarButtonWidget_js__WEBPACK_IMPORTED_MODULE_6__["default"]
  },
  childViewTriggers: {
    "status:change": "status:change"
  },
  tagName: "div",
  attributes: {
    role: "group"
  },
  initialize: function initialize(options) {
    this.collection = options["collection"] = new _models_ActionCollection_js__WEBPACK_IMPORTED_MODULE_5__["default"](options["actions"]);
    console.log(arguments);
    backbone_marionette__WEBPACK_IMPORTED_MODULE_7___default().CollectionView.__super__.initialize.apply(this, arguments);
  },
  childView: function childView(item) {
    var widget = this.childTemplates[item.get("widget")];
    if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(widget)) {
      console.log("Error : invalid widget type %s", item.get("widget"));
    }
    return widget;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ActionListView);

/***/ }),

/***/ "./src/common/views/ActionToolbar.js":
/*!*******************************************!*\
  !*** ./src/common/views/ActionToolbar.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");
/* harmony import */ var _ActionListView_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ActionListView.js */ "./src/common/views/ActionListView.js");



var template = __webpack_require__(/*! ./templates/ActionToolbar.mustache */ "./src/common/views/templates/ActionToolbar.mustache");

/** An horizontal toolbar with three zones
 *
 * - *main* on left for main action buttons
 *    (typically: validation/save buttons)
 * - *more* on right for secondary action buttons
 *    (typically: duplicate/export buttons)
 * - *resume* at center for any other information/controls
 *    (typically: a summary of document)
 *
 * new ActionToolBar(
 * { 'main': [liste de dict décrivant les actions principales]
 * 'more': [liste de dict décrivant les actions secondaires],
 *  'resume': <Instance de View déjà créée>
 )
*/
var ActionToolbar = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  template: template,
  className: "layout flex main_actions",
  regions: {
    main_actions: {
      el: ".main_actions",
      replaceElement: true
    },
    more_actions: {
      el: ".more_actions",
      replaceElement: true
    },
    resume: ".resume"
  },
  childViewTriggers: {
    "status:change": "status:change"
  },
  onRender: function onRender() {
    console.log("RENDERING THE ACTION TOOLBAR");
    var main_actions = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "main", null);
    var more_actions = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "more", null);
    var resume_view = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "resume", null);
    if (main_actions !== null) {
      this.showChildView("main_actions", new _ActionListView_js__WEBPACK_IMPORTED_MODULE_1__["default"]({
        actions: main_actions
      }));
    }
    if (more_actions !== null) {
      this.showChildView("more_actions", new _ActionListView_js__WEBPACK_IMPORTED_MODULE_1__["default"]({
        actions: more_actions
      }));
    }
    if (resume_view != null) {
      this.showChildView("resume", resume_view);
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ActionToolbar);

/***/ }),

/***/ "./src/common/views/BaseDocumentViewerView.js":
/*!****************************************************!*\
  !*** ./src/common/views/BaseDocumentViewerView.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");
/* harmony import */ var _widgets_LoadingWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../widgets/LoadingWidget */ "./src/widgets/LoadingWidget.js");
/* harmony import */ var _DocumentViewerControlsView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DocumentViewerControlsView */ "./src/common/views/DocumentViewerControlsView.js");




var template = __webpack_require__(/*! ./templates/BaseDocumentViewer.mustache */ "./src/common/views/templates/BaseDocumentViewer.mustache");

/** Base for inlined file viewer
 *
 * Offers a document rendering area and a toolbar with zoom/paging options
 *
 * Subclass must implement/override :
 *
 * - zoom() method
 * - onRender() method or template var to customize rendering
 *
 * Subclass may override, if document format supports multipage:
 *
 * - isMultipage() method
 * - onPagePrevious() method
 * - onPageNext() method
 */
var BaseDocumentViewerView = backbone_marionette__WEBPACK_IMPORTED_MODULE_3___default().View.extend({
  attributes: {
    "class": "preview"
  },
  ui: {
    document_container: ".document_container"
  },
  regions: {
    controls: ".controls",
    loader: ".loader"
  },
  template: template,
  childViewEvents: {
    "zoom:in": "onZoomIn",
    "zoom:out": "onZoomOut",
    "page:previous": "onPagePrevious",
    "page:next": "onPageNext",
    open: "onOpen",
    "rotate:right": "onRotateRight",
    "rotate:left": "onRotateLeft",
    "loader:start": "showLoader",
    "loader:stop": "hideLoader"
  },
  initialize: function initialize(options) {
    this.title = this.getOption("title");
    this.footerText = this.getOption("footerText");
    this.fileUrl = this.getOption("fileUrl");
    this.fileLabel = this.getOption("label");
    this.showControls = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "showControls", true);
  },
  /** Helper method to compute x scroll after zoom
   *
   * Goal is to maintain constant viewport center by paning to computed position
   * after zoom. Has to be called *prior* to zooming.
   *
   * @param {Element} container the scrollable container element
   * @param {Number} ratio the zoom ratio we are going to apply
   */
  getXScroll: function getXScroll(container, factor) {
    return (container.scrollLeft + container.clientWidth / 2) * factor - container.clientWidth / 2;
  },
  /** Helper method to compute y scroll after zoom
   *
   * Goal is to maintain constant viewport center by paning to computed position
   * after zoom. Has to be called *prior* to zooming.
   *
   * @param {Element} container the scrollable container element
   * @param {Number} ratio the zoom ratio we are going to apply
   */
  getYScroll: function getYScroll(container, factor) {
    return (container.scrollTop + container.clientHeight / 2) * factor - container.clientHeight / 2;
  },
  onZoomIn: function onZoomIn() {
    this.zoom(1.5);
  },
  onZoomOut: function onZoomOut() {
    this.zoom(0.6666);
  },
  zoom: function zoom(factor) {},
  onOpen: function onOpen() {
    window.open(this.fileUrl);
  },
  onPagePrevious: function onPagePrevious() {},
  onPageNext: function onPageNext() {},
  // To implement if multipage is required
  onRotateRight: function onRotateRight() {},
  // To implement if rotation is required
  onRotateLeft: function onRotateLeft() {},
  // To implement if rotation is required
  isMultipage: function isMultipage() {
    return false;
  },
  // To implement if multipage is required
  onRender: function onRender() {
    this.renderControls(this);
  },
  renderControls: function renderControls(this_) {
    if (this.showControls) {
      var view = new _DocumentViewerControlsView__WEBPACK_IMPORTED_MODULE_2__["default"]({
        multipage: this.isMultipage()
      });
      this_.showChildView("controls", view);
    }
  },
  templateContext: function templateContext() {
    return {
      title: this.title,
      footerText: this.footerText
    };
  },
  showLoader: function showLoader() {
    var view = new _widgets_LoadingWidget__WEBPACK_IMPORTED_MODULE_1__["default"]();
    this.showChildView("loader", view);
  },
  hideLoader: function hideLoader() {
    this.getRegion("loader").empty();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseDocumentViewerView);

/***/ }),

/***/ "./src/common/views/BaseViewerPopupView.js":
/*!*************************************************!*\
  !*** ./src/common/views/BaseViewerPopupView.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _base_behaviors_ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../base/behaviors/ModalBehavior.js */ "./src/base/behaviors/ModalBehavior.js");
/* harmony import */ var _widgets_LoadingWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../widgets/LoadingWidget */ "./src/widgets/LoadingWidget.js");



var template = __webpack_require__(/*! ./templates/BaseViewerPopupView.mustache */ "./src/common/views/templates/BaseViewerPopupView.mustache");

/**
 * Base class for viewer of document
 *
 * Implementors must :
 *  - set this.popupTitle variable
 */
var BaseViewerPopupView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  template: template,
  regions: {
    pdfpreview: ".pdfpreview",
    loader: ".loader"
  },
  behaviors: {
    modal: {
      behaviorClass: _base_behaviors_ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__["default"]
    }
  },
  childViewEvents: {
    "loader:start": "showLoader",
    "loader:stop": "hideLoader"
  },
  templateContext: function templateContext() {
    return {
      popupTitle: this.popupTitle
    };
  },
  onRender: function onRender() {
    this.showPreview();
  },
  showLoader: function showLoader() {
    var view = new _widgets_LoadingWidget__WEBPACK_IMPORTED_MODULE_1__["default"]();
    this.showChildView("loader", view);
  },
  hideLoader: function hideLoader() {
    this.getRegion("loader").empty();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseViewerPopupView);

/***/ }),

/***/ "./src/common/views/BusinessLinkView.js":
/*!**********************************************!*\
  !*** ./src/common/views/BusinessLinkView.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_0__);


/** Display 3 lines with icons, describing linked Business/Project/Customer
 *
 * Linked resource correspond to those listed in the BusinessLinkedModelMixin,
 * they all are optional.
 *
 * For each linked resource, if undefined, nothing is displayed, else, an icon
 * with the resource label is displayed.
 *
 * Required options:
 * - customer_label
 * - project_label
 * - business_label
 */

var BusinessLinkView = backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default().View.extend({
  template: __webpack_require__(/*! ./templates/BusinessLink.mustache */ "./src/common/views/templates/BusinessLink.mustache"),
  templateContext: function templateContext() {
    return {
      customer_label: this.getOption("customer_label"),
      project_label: this.getOption("project_label"),
      business_label: this.getOption("business_label")
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BusinessLinkView);

/***/ }),

/***/ "./src/common/views/CatalogComponent.js":
/*!**********************************************!*\
  !*** ./src/common/views/CatalogComponent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var widgets_LoadingWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! widgets/LoadingWidget.js */ "./src/widgets/LoadingWidget.js");
/* harmony import */ var tools_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tools.js */ "./src/tools.js");
/* harmony import */ var _CatalogTreeView_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CatalogTreeView.js */ "./src/common/views/CatalogTreeView.js");
/* harmony import */ var _models_CatalogTreeCollection_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/CatalogTreeCollection.js */ "./src/common/models/CatalogTreeCollection.js");
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! backbone-validation */ "./node_modules/backbone-validation/dist/backbone-validation-amd.js");
/* harmony import */ var backbone_validation__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(backbone_validation__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var math_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! math.js */ "./src/math.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/*
 * Module name : CatalogComponent
 */








var template = __webpack_require__(/*! ./templates/CatalogComponent.mustache */ "./src/common/views/templates/CatalogComponent.mustache");

/**
    Class displaying the sale_product catalog allowing item selection

    Expects the following options :

        collection_name

            The name of the collection in the associated Facade

        query_params

            The parameters used when querying the server to get the catalog items
        
        multiple 

            Default false : multiple selection allowed ?

    The Following options will be retrieved from the config Radio channel

        decimal_to_display

            Default 2 : How many decimals should we use to display numbers

        mode

            Default "ht": Computation mode

    Emits the following events :

        'catalog:insert' => ({sale_product_id: quantity})

            Emitted when the Insert button is clicked
            Pass the selected models : Object where key is id and the value is quantity

    */
var CatalogComponent = backbone_marionette__WEBPACK_IMPORTED_MODULE_7___default().View.extend({
  className: "modal_content_layout",
  template: template,
  regions: {
    main: ".main"
  },
  ui: {
    insert_btn: "button[value=insert]",
    insert_for_edit_btn: "button[value=insert_for_edit]",
    load_btn: "button[value=load]",
    cancel_btn: "button.reset",
    form: "form"
  },
  // Listen to the current's view events
  events: {
    "click @ui.insert_btn": "onInsertClicked"
  },
  triggers: {
    "click @ui.cancel_btn": "cancel:click"
  },
  initialize: function initialize() {
    this.facade = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("facade");
    // Params to use when querying the collections
    this.query_params = this.getOption("query_params");
    // Allow multiple selections ?
    this.multiple = (0,tools_js__WEBPACK_IMPORTED_MODULE_2__.getOpt)(this, "multiple", false);
    this.collection = new _models_CatalogTreeCollection_js__WEBPACK_IMPORTED_MODULE_4__["default"]();
    this.collection.url = this.getOption("url");
    this.listenTo(this.facade, "bind:validation", this.bindValidation);
    this.listenTo(this.facade, "unbind:validation", this.unbindValidation);
    this.listenTo(this.model, "validated:invalid", this.showErrors);
    this.listenTo(this.model, "validated:valid", this.hideErrors.bind(this));
  },
  showErrors: function showErrors(model, errors) {
    this.$el.addClass("error");
  },
  hideErrors: function hideErrors(model) {
    this.$el.removeClass("error");
  },
  bindValidation: function bindValidation() {
    console.log("bindValidation");
    console.log(this.model);
    backbone_validation__WEBPACK_IMPORTED_MODULE_5___default().bind(this);
  },
  unbindValidation: function unbindValidation() {
    backbone_validation__WEBPACK_IMPORTED_MODULE_5___default().unbind(this);
  },
  showTree: function showTree() {
    this.showChildView("main", new _CatalogTreeView_js__WEBPACK_IMPORTED_MODULE_3__["default"]({
      collection: this.collection,
      multiple: this.multiple
    }));
    this.collection.on("change:selected", this.onItemSelect, this);
    this.onItemSelect();
  },
  loadCatalogTree: function loadCatalogTree() {
    var _this = this;
    console.log(this.collection);
    var serverRequest = this.collection.fetch({
      data: this.getOption("query_params"),
      processData: true
    });
    serverRequest.done(function () {
      return _this.showTree();
    });
  },
  onRender: function onRender() {
    this.myid = _.uniqueId();
    console.log(this.myid);
    this.showChildView("main", new widgets_LoadingWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"]());
    this.loadCatalogTree();
  },
  onItemSelect: function onItemSelect() {
    var models = this.collection.getSelected();
    var btn = this.getUI("insert_btn");
    var value = !(models.length > 0);
    btn.attr("disabled", value);
    btn.attr("aria-disabled", value);
  },
  onDomRemove: function onDomRemove() {
    this.collection.off("change:selected");
    this.collection.setNoneSelected();
  },
  onInsertClicked: function onInsertClicked() {
    var models = this.collection.getSelected();

    // Cancel action if a model is not valid
    for (var idx in models) {
      var model = models[idx];
      if (!model.is_valid()) {
        return;
      }
    }
    var result = models.reduce(function (dict, item) {
      dict[item.get("id")] = (0,math_js__WEBPACK_IMPORTED_MODULE_6__.strToFloat)(item.get("quantity"));
      return dict;
    }, {});
    this.triggerMethod("catalog:insert", result);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CatalogComponent);

/***/ }),

/***/ "./src/common/views/CatalogTreeCollectionView.js":
/*!*******************************************************!*\
  !*** ./src/common/views/CatalogTreeCollectionView.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CatalogTreeItemView_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CatalogTreeItemView.js */ "./src/common/views/CatalogTreeItemView.js");
/*
 * Module name : CatalogTreeCollectionView
 */



var template = __webpack_require__(/*! ./templates/CatalogTreeCollectionView.mustache */ "./src/common/views/templates/CatalogTreeCollectionView.mustache");
var CatalogTreeCollectionView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().CollectionView.extend({
  template: template,
  childView: _CatalogTreeItemView_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  childViewContainer: "tbody"
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CatalogTreeCollectionView);

/***/ }),

/***/ "./src/common/views/CatalogTreeItemView.js":
/*!*************************************************!*\
  !*** ./src/common/views/CatalogTreeItemView.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _widgets_RadioWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../widgets/RadioWidget.js */ "./src/widgets/RadioWidget.js");
/* harmony import */ var _widgets_CheckboxWidget_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../widgets/CheckboxWidget.js */ "./src/widgets/CheckboxWidget.js");
/* harmony import */ var _widgets_InputWidget_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../widgets/InputWidget.js */ "./src/widgets/InputWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");
/*
 * Module name : CatalogTreeItemView
 */






var template = __webpack_require__(/*! ./templates/CatalogTreeItemView.mustache */ "./src/common/views/templates/CatalogTreeItemView.mustache");
var CatalogTreeItemView = backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default().View.extend({
  tagName: "tr",
  template: template,
  regions: {
    td_action: "td.action",
    td_input: "td.input"
  },
  modelEvents: {
    "change:selected": "render",
    "change:quantity": "render"
  },
  // Listen to child view events
  childViewEvents: {
    finish: "onChange"
  },
  // Bubble up child view events
  childViewTriggers: {},
  initialize: function initialize(options) {
    if ((0,_tools_js__WEBPACK_IMPORTED_MODULE_4__.getOpt)(this, "selected", false)) {
      this.model.set("selected");
    }
    this.config = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("config");
    this.compute_mode = this.config.request("get:options", "compute_mode");
    this.decimal_to_display = this.config.request("get:options", "decimal_to_display");
    this.multiple = (0,_tools_js__WEBPACK_IMPORTED_MODULE_4__.getOpt)(this, "multiple", false);
  },
  onRender: function onRender() {
    var widget;
    var options = {
      field_name: "check",
      ariaLabel: "Sélectionner ce produit",
      toggle: false
    };
    if (this.multiple) {
      options = Object.assign(options, {
        value: this.model.get("selected"),
        true_val: true,
        false_val: false
      });
      widget = new _widgets_CheckboxWidget_js__WEBPACK_IMPORTED_MODULE_2__["default"](options);
    } else {
      options["value"] = true;
      widget = new _widgets_RadioWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"](options);
    }
    this.showChildView("td_action", widget);
    this.showChildView("td_input", new _widgets_InputWidget_js__WEBPACK_IMPORTED_MODULE_3__["default"]({
      field_name: "quantity",
      ariaLabel: "qte",
      title: "",
      value: this.model.get("quantity"),
      required: true,
      pattern: "\-?[0-9]*([,.][0-9]{0,5})?"
    }));
  },
  onChange: function onChange(field_name, value) {
    if (field_name == "check") this.model.collection.setSelected(this.model, value);
    if (field_name == "quantity") this.model.collection.setQuantity(this.model, value);
  },
  templateContext: function templateContext() {
    var amount_label;
    if (this.compute_mode == "ht") {
      amount_label = this.model.ht_label(this.decimal_to_display);
    } else {
      amount_label = this.model.ttc_label(this.decimal_to_display);
    }
    var quantity = this.model.get("quantity");
    return {
      amount_label: amount_label,
      quantity: quantity
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CatalogTreeItemView);

/***/ }),

/***/ "./src/common/views/CatalogTreeView.js":
/*!*********************************************!*\
  !*** ./src/common/views/CatalogTreeView.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _widgets_CheckboxWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../widgets/CheckboxWidget.js */ "./src/widgets/CheckboxWidget.js");
/* harmony import */ var _widgets_InputWidget_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../widgets/InputWidget.js */ "./src/widgets/InputWidget.js");
/* harmony import */ var _CatalogTreeCollectionView_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CatalogTreeCollectionView.js */ "./src/common/views/CatalogTreeCollectionView.js");
/*
 * Module name : CatalogTreeView
 */





var template = __webpack_require__(/*! ./templates/CatalogTreeView.mustache */ "./src/common/views/templates/CatalogTreeView.mustache");
var CatalogTreeView = backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default().View.extend({
  template: template,
  regions: {
    selectToggle: ".select-toggle",
    filter: ".field-filter",
    treeContainer: ".tree-container"
  },
  ui: {},
  // Listen to the current's view events
  events: {},
  // Listen to child view events
  childViewEvents: {
    change: "onFilterKeyUp",
    finish: "onToggleChecked"
  },
  // Bubble up child view events
  childViewTriggers: {},
  initialize: function initialize() {
    // store the visible models for the select all functionnality
    this._visibleModels = this.collection.models;
    this.session = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("session");
  },
  onRender: function onRender() {
    var value = this.session.request("get", "catalogFilter", "");
    this.showChildView("filter", new _widgets_InputWidget_js__WEBPACK_IMPORTED_MODULE_2__["default"]({
      field_name: "filter",
      placeholder: "Rechercher par nom / référence / description",
      ariaLabel: "Rechercher par nom / référence / description",
      label: "Rechercher un produit dans le catalogue",
      value: value
    }));
    this.showChildView("treeContainer", new _CatalogTreeCollectionView_js__WEBPACK_IMPORTED_MODULE_3__["default"]({
      collection: this.collection,
      childViewOptions: {
        multiple: this.getOption("multiple")
      }
    }));
    this.showToggleSelect();
  },
  onAttach: function onAttach() {
    // On restaure un filtre existant
    var value = this.session.request("get", "catalogFilter", "");
    if (value.length > 1) {
      this.onFilterKeyUp("filter", value);
    }
  },
  showToggleSelect: function showToggleSelect() {
    if (this.collection.length > 1) {
      this.showChildView("selectToggle", new _widgets_CheckboxWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"]({
        field_name: "toggle",
        title: "",
        inlineLabel: "Sélectionner tous les produits / Aucun produit",
        ariaLabel: "Sélectionner ou déselectionner tous les éléments",
        true_val: true,
        false_val: false,
        toggle: false,
        value: this.collection.allSelected()
      }));
    }
  },
  getFilter: function getFilter(value) {
    var _this = this;
    this._visibleModels = [];
    return function (view, index, children) {
      if (view.model.matchPattern(value) || view.model.get("selected")) {
        _this._visibleModels.push(view.model);
        return true;
      }
    };
  },
  onFilterKeyUp: function onFilterKeyUp(fieldName, value) {
    if (fieldName != "filter") {
      return;
    }
    value = value.toLowerCase().trim();
    this.session.request("set", "catalogFilter", value);
    if (value.length > 1) {
      var filter = this.getFilter(value);
      this.getChildView("treeContainer").setFilter(filter);
    } else {
      this.getChildView("treeContainer").removeFilter();
    }
  },
  onToggleChecked: function onToggleChecked(fieldName, value) {
    if (fieldName == "toggle") {
      if (value) {
        this.collection.setAllSelected(this._visibleModels);
      } else {
        this.collection.setNoneSelected();
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CatalogTreeView);

/***/ }),

/***/ "./src/common/views/DocumentViewerControlsView.js":
/*!********************************************************!*\
  !*** ./src/common/views/DocumentViewerControlsView.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./templates/DocumentViewerControlsView.mustache */ "./src/common/views/templates/DocumentViewerControlsView.mustache");
var DocumentViewerControlsView = backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default().View.extend({
  ui: {
    zoom_in_btn: ".zoom_in",
    zoom_out_btn: ".zoom_out",
    go_previous_btn: ".go_previous",
    go_next_btn: ".go_next",
    open_full_btn: ".open_full",
    rotate_right_btn: ".rotate-right",
    rotate_left_btn: ".rotate-left"
  },
  template: template,
  triggers: {
    "click @ui.zoom_in_btn": "zoom:in",
    "click @ui.zoom_out_btn": "zoom:out",
    "click @ui.go_previous_btn": "page:previous",
    "click @ui.go_next_btn": "page:next",
    "click @ui.open_full_btn": "open",
    "click @ui.rotate_right_btn": "rotate:right",
    "click @ui.rotate_left_btn": "rotate:left"
  },
  templateContext: function templateContext() {
    return {
      multipage: this.getOption("multipage")
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DocumentViewerControlsView);

/***/ }),

/***/ "./src/common/views/ImageViewerView.js":
/*!*********************************************!*\
  !*** ./src/common/views/ImageViewerView.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseDocumentViewerView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseDocumentViewerView */ "./src/common/views/BaseDocumentViewerView.js");

var template = __webpack_require__(/*! ./templates/ImageViewerView.mustache */ "./src/common/views/templates/ImageViewerView.mustache");

/** Image viewer
 *
 * Supports all image formats supported natively by the browser
 */
var ImageViewerView = _BaseDocumentViewerView__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  template: template,
  ui: {
    document_container: ".document_container",
    img: "img"
  },
  initialize: function initialize(options) {
    ImageViewerView.__super__.initialize.apply(this, arguments);
    this.currentScale = 1;
  },
  zoom: function zoom(factor) {
    var container = this.ui.document_container[0];
    var xScroll = this.getXScroll(container, factor);
    var yScroll = this.getYScroll(container, factor);
    this.currentScale = this.currentScale * factor;
    this.ui.img.css("transform", "scale(".concat(this.currentScale, ")"));
    container.scroll(xScroll, yScroll);
  },
  templateContext: function templateContext() {
    return Object.assign(ImageViewerView.__super__.templateContext.apply(this), {
      url: this.fileUrl,
      label: this.fileLabel
    });
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ImageViewerView);

/***/ }),

/***/ "./src/common/views/NodeFileCollectionView.js":
/*!****************************************************!*\
  !*** ./src/common/views/NodeFileCollectionView.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _NodeFileItemView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./NodeFileItemView */ "./src/common/views/NodeFileItemView.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../tools */ "./src/tools.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js");
/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_4__);






var template = __webpack_require__(/*! ./templates/NodeFileCollectionView.mustache */ "./src/common/views/templates/NodeFileCollectionView.mustache");
var Emptyview = backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default().View.extend({
  template: underscore__WEBPACK_IMPORTED_MODULE_0___default().template("<em>Aucun justificatif n’a été déposé pour l’instant"),
  tagName: "li"
});
var NodeFileCollectionView = backbone_marionette__WEBPACK_IMPORTED_MODULE_5___default().CollectionView.extend({
  template: template,
  childView: _NodeFileItemView__WEBPACK_IMPORTED_MODULE_1__["default"],
  emptyView: Emptyview,
  childViewContainer: "ul",
  ui: {
    add_btn: ".add-btn"
  },
  events: {
    "click @ui.add_btn": "onAdd"
  },
  collectionEvents: {
    fetched: "render"
  },
  childViewEvents: {
    "file:updated": "onFileUpdated"
  },
  initialize: function initialize(options) {
    this.facade = backbone_radio__WEBPACK_IMPORTED_MODULE_2___default().channel("facade");
  },
  onFileUpdated: function onFileUpdated() {
    var callback = (0,_tools__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "addCallback", false);
    if (callback) {
      callback();
    }
  },
  onAdd: function onAdd() {
    this.facade.request("save:all");
    var callback = (0,_tools__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "addCallback", false);
    window.openPopup(window.location.pathname + "/addfile", function () {
      if (callback) {
        callback();
      }
    });
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NodeFileCollectionView);

/***/ }),

/***/ "./src/common/views/NodeFileItemView.js":
/*!**********************************************!*\
  !*** ./src/common/views/NodeFileItemView.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _backbone_tools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../backbone-tools */ "./src/backbone-tools.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);



var template = __webpack_require__(/*! ./templates/NodeFileItemView.mustache */ "./src/common/views/templates/NodeFileItemView.mustache");
var NodeFileItemView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  ui: {
    edit_btn: ".edit-btn",
    download_btn: ".download-btn"
  },
  events: {
    "click @ui.edit_btn": "onEdit",
    "click @ui.download_btn": "onDownload"
  },
  tagName: "li",
  template: template,
  initialize: function initialize(options) {
    this.facade = backbone_radio__WEBPACK_IMPORTED_MODULE_1___default().channel("facade");
  },
  onFilePopupCallback: function onFilePopupCallback(options) {
    this.triggerMethod("file:updated");
  },
  onEdit: function onEdit() {
    this.facade.request("save:all");
    window.openPopup("/files/" + this.model.get("id"), this.onFilePopupCallback.bind(this));
  },
  onDownload: function onDownload() {
    this.facade.request("save:all");
    window.openPopup("/files/" + this.model.get("id") + "?action=download");
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NodeFileItemView);

/***/ }),

/***/ "./src/common/views/NodeFileViewerPopupView.js":
/*!*****************************************************!*\
  !*** ./src/common/views/NodeFileViewerPopupView.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _components_NodeFileViewerFactory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../components/NodeFileViewerFactory */ "./src/common/components/NodeFileViewerFactory.js");
/* harmony import */ var _BaseViewerPopupView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BaseViewerPopupView */ "./src/common/views/BaseViewerPopupView.js");
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../tools */ "./src/tools.js");



var NodeFileViewerPopupView = _BaseViewerPopupView__WEBPACK_IMPORTED_MODULE_1__["default"].extend({
  initialize: function initialize(options) {
    this.file = options.file;
    this.popupTitle = (0,_tools__WEBPACK_IMPORTED_MODULE_2__.getOpt)(this, "popupTitle", this.file.get("label"));
  },
  showPreview: function showPreview() {
    var view = _components_NodeFileViewerFactory__WEBPACK_IMPORTED_MODULE_0__["default"].getViewer(this.file, {
      title: this.file.get("name")
    });
    this.showChildView("pdfpreview", view);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NodeFileViewerPopupView);

/***/ }),

/***/ "./src/common/views/PDFViewerView.js":
/*!*******************************************!*\
  !*** ./src/common/views/PDFViewerView.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var pdfjs_dist_legacy_web_pdf_viewer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! pdfjs-dist/legacy/web/pdf_viewer */ "./node_modules/pdfjs-dist/legacy/web/pdf_viewer.js");
/* harmony import */ var pdfjs_dist_legacy_web_pdf_viewer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(pdfjs_dist_legacy_web_pdf_viewer__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _BaseDocumentViewerView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BaseDocumentViewerView */ "./src/common/views/BaseDocumentViewerView.js");
var pdfjsLib = __webpack_require__(/*! pdfjs-dist/legacy/build/pdf.js */ "./node_modules/pdfjs-dist/legacy/build/pdf.js");
var PdfjsWorker = __webpack_require__(/*! worker-loader?esModule=false&filename=[name].js!pdfjs-dist/legacy/build/pdf.worker.min.js */ "./node_modules/worker-loader/dist/cjs.js?esModule=false&filename=[name].js!./node_modules/pdfjs-dist/legacy/build/pdf.worker.min.js");
if (typeof window !== "undefined" && "Worker" in window) {
  pdfjsLib.GlobalWorkerOptions.workerPort = new PdfjsWorker();
}



/** PDF viewer using pdf.js
 *
 * Features :
 *  - zoom/unzoom
 *  - multipage
 *  - text selection (for copy/paste use)
 *
 *  Advanced features are willingly disabled (forms, links, scripting)
 *
 *  Events triggered
 *    - loader:start (start of network load)
 *    - loader:stop (end of network load, whatever the result)
 */
var PDFViewerView = _BaseDocumentViewerView__WEBPACK_IMPORTED_MODULE_1__["default"].extend({
  initialize: function initialize(options) {
    PDFViewerView.__super__.initialize.apply(this, arguments);
    this.pdfDocument = null;
    this.viewer = null;
  },
  onPagePrevious: function onPagePrevious() {
    this.viewer.previousPage();
  },
  onPageNext: function onPageNext() {
    this.viewer.nextPage();
  },
  onRotateRight: function onRotateRight() {
    this.viewer.pagesRotation += 90;
  },
  onRotateLeft: function onRotateLeft() {
    this.viewer.pagesRotation -= 90;
  },
  zoom: function zoom(factor) {
    var container = this.ui.document_container[0];
    var xScroll = this.getXScroll(container, factor);
    var yScroll = this.getYScroll(container, factor);
    this.viewer.currentScale = this.viewer.currentScale * factor;
    container.scroll(xScroll, yScroll);
  },
  onRender: function onRender() {
    var eventBus = new pdfjs_dist_legacy_web_pdf_viewer__WEBPACK_IMPORTED_MODULE_0__.EventBus();
    var pdfViewer = new pdfjs_dist_legacy_web_pdf_viewer__WEBPACK_IMPORTED_MODULE_0__.PDFViewer({
      container: this.ui.document_container[0],
      eventBus: eventBus
    });
    eventBus.on("pagesinit", function () {
      pdfViewer.currentScaleValue = "page-width";
    });
    this.showLoader();
    var this_ = this; // Won't work with a bind() because of workers I guess
    pdfjsLib.getDocument(this.fileUrl).promise.then(function (pdfDocument) {
      this_.hideLoader();
      pdfViewer.setDocument(pdfDocument);
      this_.pdfDocument = pdfDocument;
      this_.renderControls(this_);
    })["catch"](function (reason) {
      this_.hideLoader();
      console.error("Error: " + reason);
      alert("Erreur lors de l'affichage du PDF");
    });
    this.viewer = pdfViewer;
  },
  isMultipage: function isMultipage() {
    return this.pdfDocument.numPages > 1;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PDFViewerView);

/***/ }),

/***/ "./src/common/views/StatusFormPopupView.js":
/*!*************************************************!*\
  !*** ./src/common/views/StatusFormPopupView.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _base_behaviors_ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../base/behaviors/ModalBehavior.js */ "./src/base/behaviors/ModalBehavior.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../tools.js */ "./src/tools.js");



var template = __webpack_require__(/*! ./templates/StatusFormPopupView.mustache */ "./src/common/views/templates/StatusFormPopupView.mustache");

/** The modal to log a message about a new status
 */
var StatusFormPopupView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  id: "status-msg-modal",
  template: template,
  ui: {
    textarea: "textarea",
    btn_cancel: ".cancel",
    submit: "button[type=submit]",
    form: "form"
  },
  behaviors: {
    modal: {
      behaviorClass: _base_behaviors_ModalBehavior_js__WEBPACK_IMPORTED_MODULE_0__["default"]
    }
  },
  events: {
    "click @ui.btn_cancel": "destroy",
    "click @ui.submit": "onSubmit"
  },
  initialize: function initialize(options) {
    this.action = options.action;
  },
  submitCallback: function submitCallback(result) {},
  onSubmit: function onSubmit(event) {
    event.preventDefault();
    var datas = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.serializeForm)(this.getUI("form"));
    datas["submit"] = this.action.get("status");
    var url = this.action.get("url");
    (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.showLoader)();
    this.serverRequest = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.ajax_call)(url, datas, "POST");
    this.serverRequest.then(this.submitCallback.bind(this));
  },
  templateContext: function templateContext() {
    return this.action.attributes;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusFormPopupView);

/***/ }),

/***/ "./src/common/views/StatusHistoryPopupView.js":
/*!****************************************************!*\
  !*** ./src/common/views/StatusHistoryPopupView.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _base_behaviors_ModalBehavior__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../base/behaviors/ModalBehavior */ "./src/base/behaviors/ModalBehavior.js");
/* harmony import */ var _StatusLogEntryCollectionView_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./StatusLogEntryCollectionView.js */ "./src/common/views/StatusLogEntryCollectionView.js");




/** Popup with status history full list
 *
 * Similar StatusHistoryView but w/o "show more" feature, and within a popup.
 */
var StatusHistoryPopupView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  behaviors: [_base_behaviors_ModalBehavior__WEBPACK_IMPORTED_MODULE_0__["default"]],
  template: __webpack_require__(/*! ./templates/StatusHistoryPopupView.mustache */ "./src/common/views/templates/StatusHistoryPopupView.mustache"),
  regions: {
    comments: {
      el: ".comments",
      replaceElement: true
    }
  },
  childViewTriggers: {
    "statuslogentry:edit": "statuslogentry:edit"
  },
  initialize: function initialize(options) {
    this.collection = options.collection;
    this.focusedModel = options.focusedModel;
  },
  onRender: function onRender() {
    this.showChildView("comments", new _StatusLogEntryCollectionView_js__WEBPACK_IMPORTED_MODULE_1__["default"]({
      collection: this.collection,
      focusedModel: this.focusedModel
    }));
  },
  templateContext: function templateContext() {
    return {
      collectionLength: this.collection.length
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusHistoryPopupView);

/***/ }),

/***/ "./src/common/views/StatusHistoryView.js":
/*!***********************************************!*\
  !*** ./src/common/views/StatusHistoryView.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _StatusLogEntryCollectionView_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./StatusLogEntryCollectionView.js */ "./src/common/views/StatusLogEntryCollectionView.js");
/* harmony import */ var _StatusHistoryPopupView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./StatusHistoryPopupView */ "./src/common/views/StatusHistoryPopupView.js");
/* harmony import */ var _StatusLogEntryFormPopupView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./StatusLogEntryFormPopupView */ "./src/common/views/StatusLogEntryFormPopupView.js");
/* harmony import */ var _models_StatusLogEntryModel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/StatusLogEntryModel */ "./src/common/models/StatusLogEntryModel.js");





var StatusHistoryView = backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default().View.extend({
  tagName: "div",
  className: function className() {
    var baseClassNames = "status_history hidden-print";
    if (this.collection && this.collection.length > 0) {
      return baseClassNames + " memos";
    } else {
      return baseClassNames;
    }
  },
  template: __webpack_require__(/*! ./templates/StatusHistoryView.mustache */ "./src/common/views/templates/StatusHistoryView.mustache"),
  regions: {
    comments: {
      el: ".comments",
      replaceElement: true
    },
    modalRegion: ".modalregion"
  },
  ui: {
    show_all_btn: "a.show_all",
    add_new_btn: "button.add_new"
  },
  events: {
    "click @ui.show_all_btn": "onShowAll",
    "click @ui.add_new_btn": "onAddNew"
  },
  childViewEvents: {
    "statuslogentry:edit": "onEdit",
    "statuslogentry:show_full": "onShowAll"
  },
  initialize: function initialize(options) {
    this.limitTo = 3;
    this.collection = options.collection;
    this.listenTo(this.collection, "update", this.render.bind(this));
  },
  /**
   * @param focusedModel optional, the model to scroll to/focus within the collection
   */
  onShowAll: function onShowAll(event, focusedModel) {
    var view = new _StatusHistoryPopupView__WEBPACK_IMPORTED_MODULE_1__["default"]({
      collection: this.collection,
      focusedModel: focusedModel
    });
    this.showChildView("modalRegion", view);
  },
  onAddNew: function onAddNew() {
    this.showChildView("modalRegion", new _StatusLogEntryFormPopupView__WEBPACK_IMPORTED_MODULE_2__["default"]({
      model: new _models_StatusLogEntryModel__WEBPACK_IMPORTED_MODULE_3__["default"](),
      destCollection: this.collection
    }));
  },
  onEdit: function onEdit(model) {
    this.showChildView("modalRegion", new _StatusLogEntryFormPopupView__WEBPACK_IMPORTED_MODULE_2__["default"]({
      model: model,
      destCollection: this.collection,
      edit: true
    }));
  },
  onRender: function onRender() {
    this.showChildView("comments", new _StatusLogEntryCollectionView_js__WEBPACK_IMPORTED_MODULE_0__["default"]({
      collection: this.collection,
      limitTo: this.limitTo
    }));
    // className refresh is not done automatically at render-time by BB
    // force it
    this.$el.attr("class", this.className());
  },
  templateContext: function templateContext() {
    var hiddenItemCount = this.collection.length - this.limitTo;
    return {
      limitTo: this.limitTo,
      hasHiddenItems: hiddenItemCount > 0,
      pluralize: hiddenItemCount > 1 ? "s" : "",
      hiddenItemsCount: hiddenItemCount,
      collectionLength: this.collection.length
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusHistoryView);

/***/ }),

/***/ "./src/common/views/StatusLogEntryCollectionView.js":
/*!**********************************************************!*\
  !*** ./src/common/views/StatusLogEntryCollectionView.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _date_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../date.js */ "./src/date.js");
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../string.js */ "./src/string.js");



var StatusLogEntryItemView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  tagName: "li",
  template: __webpack_require__(/*! ./templates/StatusLogEntryItemView.mustache */ "./src/common/views/templates/StatusLogEntryItemView.mustache"),
  ui: {
    delete_btn: "button.delete",
    edit_btn: "button.edit",
    text_content: "div"
  },
  events: {
    "click @ui.delete_btn": "onDelete",
    "click @ui.edit_btn": "onEdit",
    "click @ui.text_content": "onTextContentClick"
  },
  modelEvents: {
    sync: "render"
  },
  onDelete: function onDelete(event) {
    event.stopPropagation(); // avoid triggering onTextContentClick
    if (window.confirm("Êtes-vous sûr de vouloir supprimer ce mémo ?")) {
      this.model.destroy();
    }
  },
  onEdit: function onEdit(event) {
    event.stopPropagation(); // avoid triggering onTextContentClick
    this.trigger("edit", this.model);
    // console.log('TRIGGER SORT');
    // this.collection.sort();
  },
  onTextContentClick: function onTextContentClick(event) {
    this.trigger("show_full", event, this.model);
  },
  getVisibilityContext: function getVisibilityContext() {
    var visibility = this.model.get("visibility");
    if (visibility === "private") {
      return {
        label: "Perso",
        description: "visible uniquement par vous et les administrateurs de l’application",
        icon: "key"
      };
    } else if (visibility === "management") {
      return {
        label: "Équipe",
        description: "visible uniquement par vous et l'équipe d'appui",
        icon: "users"
      };
    } else {
      // Public visibility is default and not explicitly marked
      return null;
    }
  },
  templateContext: function templateContext() {
    return {
      date: (0,_date_js__WEBPACK_IMPORTED_MODULE_0__.formatDate)(this.model.get("datetime")),
      formatted_comment: (0,_string_js__WEBPACK_IMPORTED_MODULE_1__.addBr)(this.model.get("comment")),
      visibility: this.getVisibilityContext()
    };
  }
});
var StatusHistoryEmptyView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  tagName: "li",
  template: __webpack_require__(/*! ./templates/StatusLogEntryEmptyView.mustache */ "./src/common/views/templates/StatusLogEntryEmptyView.mustache")
});

/**
 * @param {Number} limitTo max elements to display (0 or unset to show all)
 */
var StatusLogEntryCollectionView = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().CollectionView.extend({
  tagName: "ul",
  childView: StatusLogEntryItemView,
  emptyView: StatusHistoryEmptyView,
  childViewTriggers: {
    edit: "statuslogentry:edit",
    show_full: "statuslogentry:show_full"
  },
  collectionEvents: {
    sync: "onChildSync"
  },
  events: {
    render: "onRender"
  },
  onChildSync: function onChildSync() {
    // Pining may re-order childs
    this.collection.sort();
  },
  initialize: function initialize(options) {
    this.limitTo = options.limitTo;
    this.focusedModel = options.focusedModel;
  },
  viewFilter: function viewFilter(child, index, collection) {
    if (this.limitTo) {
      return index < this.limitTo;
    } else {
      return true;
    }
  },
  onAttach: function onAttach() {
    console.log("focusedModel = ", this.focusedModel);
    if (this.focusedModel) {
      var childView = this.children.findByModel(this.focusedModel);
      childView.$el[0].scrollIntoView(false);
      // Do it only once:
      this.focusedModel = undefined;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusLogEntryCollectionView);

/***/ }),

/***/ "./src/common/views/StatusLogEntryFormPopupView.js":
/*!*********************************************************!*\
  !*** ./src/common/views/StatusLogEntryFormPopupView.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _widgets_TextAreaWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../widgets/TextAreaWidget.js */ "./src/widgets/TextAreaWidget.js");
/* harmony import */ var _base_behaviors_ModalFormBehavior_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../base/behaviors/ModalFormBehavior.js */ "./src/base/behaviors/ModalFormBehavior.js");
/* harmony import */ var _widgets_SelectWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../widgets/SelectWidget */ "./src/widgets/SelectWidget.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _widgets_CheckboxWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../widgets/CheckboxWidget */ "./src/widgets/CheckboxWidget.js");
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../string.js */ "./src/string.js");
/* harmony import */ var _backbone_tools_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../backbone-tools.js */ "./src/backbone-tools.js");
/* harmony import */ var _widgets_CheckboxListWidget_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../widgets/CheckboxListWidget.js */ "./src/widgets/CheckboxListWidget.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");









var template = __webpack_require__(/*! ./templates/StatusLogEntryFormPopupView.mustache */ "./src/common/views/templates/StatusLogEntryFormPopupView.mustache");

/** Popup to add freetext memo
 *
 * A single `description` field is split/unsplit from/to two fields on the model:
 * - label (first line)
 * - description (the remainder, if any).
 *
 * See splitDescriptionfield()/mergeDescriptionField()
 *
 * Requirements:
 * - a config channel answering to ('get:options', 'visibilities')
 */
var StatusLogEntryFormPopupView = backbone_marionette__WEBPACK_IMPORTED_MODULE_8___default().View.extend({
  // Send the whole model on submit
  partial: false,
  behaviors: [_base_behaviors_ModalFormBehavior_js__WEBPACK_IMPORTED_MODULE_1__["default"]],
  template: template,
  regions: {
    description: ".field_description",
    visibility: ".field_visibility",
    pinned: ".field_pinned",
    notify: ".field_notify",
    notification_recipients: ".field_notification_recipients"
  },
  ui: {
    form: "form",
    submit: "button[type=submit]"
  },
  // Listen to the current's view events
  events: {
    "click @ui.submit": "onSubmit"
  },
  childViewEvents: {
    "finish:pinned": "onChangePinned",
    "finish:visibility": "onChangeVisibility",
    "finish:notify": "onChangeNotify"
  },
  onChangePinned: function onChangePinned(pinnedValue) {
    var pinnedCount = this.options.destCollection.getPinnedCount();
    if (pinnedValue === true && pinnedCount >= 3) {
      alert("Il y d\xE9j\xE0 ".concat(pinnedCount, " m\xE9mos \xE9pingl\xE9s. ") + "Tous ne pourront pas être affichés à la fois.");
    }
  },
  onChangeVisibility: function onChangeVisibility(visibility) {
    if (visibility != "public") {
      this.hideNotifyField();
      this.hideNotifyRecipientsField();
    } else {
      this.showNotifyField();
      this.showNotifyRecipientsField();
    }
  },
  onChangeNotify: function onChangeNotify(notifyValue) {
    if (notifyValue) {
      this.showNotifyRecipientsField();
    } else {
      this.hideNotifyRecipientsField();
    }
  },
  initialize: function initialize(options) {
    this.model = options.model;
    this.config = backbone_radio__WEBPACK_IMPORTED_MODULE_3___default().channel("config");
    this.notification_recipients = this.config.request("get:options", "notification_recipients");
  },
  onRender: function onRender() {
    this.showTextField();
    this.showVisibilityField();
    this.showPinnedField();
    this.showNotifyField();
    this.showNotifyRecipientsField();
  },
  showTextField: function showTextField() {
    var view = new _widgets_TextAreaWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"]({
      label: "Texte",
      description: "La première ligne sera considérée comme le titre du mémo",
      field_name: "description",
      value: this.mergeDescriptionField(this.model.get("label"), this.model.get("comment")),
      required: true,
      rows: 4
    });
    this.showChildView("description", view);
  },
  showVisibilityField: function showVisibilityField() {
    var docLink = "https://doc.endi.coop/co/MemoNotification.html?ts=l1yxri90#xtlcQNlyvEfgC5vqW3jVOf";
    var docTitle = "Ouvrir la documentation dans une nouvelle fenêtre";
    var view = new _widgets_SelectWidget__WEBPACK_IMPORTED_MODULE_2__["default"]({
      options: this.config.request("get:options", "visibilities"),
      title: "Visibilité",
      field_name: "visibility",
      value: this.model.get("visibility"),
      description: new _string_js__WEBPACK_IMPORTED_MODULE_5__.SafeString("Les m\xE9mos \xAB\xA0Perso\xA0\xBB sont <a target=_blank href=\"".concat(docLink, "\" title=\"").concat(docTitle, "\" aria-label=\"").concat(docTitle, "\">visibles par les administrateurs de l\u2019application</a> mais pas par le reste de l'\xE9quipe d'appui."))
    });
    this.showChildView("visibility", view);
  },
  showPinnedField: function showPinnedField() {
    var view = new _widgets_CheckboxWidget__WEBPACK_IMPORTED_MODULE_4__["default"]({
      inline_label: "Épinglé",
      description: "Ce mémo sera épinglé en début de liste",
      true_val: true,
      false_val: false,
      field_name: "pinned",
      value: this.model.get("pinned")
    });
    this.showChildView("pinned", view);
  },
  showNotifyField: function showNotifyField() {
    if (!this.notification_recipients || this.notification_recipients.length == 0) {
      return;
    }
    var view = new _widgets_CheckboxWidget__WEBPACK_IMPORTED_MODULE_4__["default"]({
      inline_label: "Envoyer une notification",
      true_val: true,
      false_val: false,
      field_name: "notify",
      value: this.model.get("notify"),
      description: " NB : Les notifications ne peuvent être envoyées que pour les mémos Public"
    });
    this.showChildView("notify", view);
    var region = this.getRegion("notify");
    (0,_backbone_tools_js__WEBPACK_IMPORTED_MODULE_6__.showRegion)(region);
  },
  hideNotifyField: function hideNotifyField() {
    var region = this.getRegion("notify");
    (0,_backbone_tools_js__WEBPACK_IMPORTED_MODULE_6__.hideRegion)(region);
  },
  showNotifyRecipientsField: function showNotifyRecipientsField() {
    if (!this.notification_recipients || this.notification_recipients.length == 0) {
      return;
    }
    var view = new _widgets_CheckboxListWidget_js__WEBPACK_IMPORTED_MODULE_7__["default"]({
      options: this.notification_recipients,
      title: "Destinataire(s)",
      value: this.model.get("notification_recipients"),
      field_name: "notification_recipients",
      id_key: "id",
      layout: "two_cols"
    });
    this.showChildView("notification_recipients", view);
    var region = this.getRegion("notification_recipients");
    (0,_backbone_tools_js__WEBPACK_IMPORTED_MODULE_6__.showRegion)(region);
  },
  hideNotifyRecipientsField: function hideNotifyRecipientsField() {
    var region = this.getRegion("notification_recipients");
    (0,_backbone_tools_js__WEBPACK_IMPORTED_MODULE_6__.hideRegion)(region);
  },
  afterSerializeForm: function afterSerializeForm(datas) {
    _.extend(datas, this.splitDescriptionField(datas.description));
    delete datas["description"];
    return datas;
  },
  splitDescriptionField: function splitDescriptionField(text) {
    var separator_position = text.search("\n");
    var label = "";
    var comment = "";
    if (separator_position >= 0) {
      label = text.substring(0, separator_position).trim();
      comment = text.substring(separator_position).trim();
    } else {
      label = text.trim();
      comment = "";
    }
    // Si le label est trop long on place ce qui dépasse en comment
    if (label.length > 255) {
      comment = label.slice(255, label.length) + comment;
      label = label.slice(0, 255);
    }
    return {
      label: label,
      comment: comment
    };
  },
  mergeDescriptionField: function mergeDescriptionField(label, comment) {
    return "".concat(label, "\n\n").concat(comment).trim();
  },
  templateContext: function templateContext() {
    var edit = this.getOption("edit");
    return {
      title: edit ? "Modifier ce mémo" : "Ajouter un mémo"
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusLogEntryFormPopupView);

/***/ }),

/***/ "./src/date.js":
/*!*********************!*\
  !*** ./src/date.js ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dateToIso: () => (/* binding */ dateToIso),
/* harmony export */   dateToLocaleFormat: () => (/* binding */ dateToLocaleFormat),
/* harmony export */   formatDate: () => (/* binding */ formatDate),
/* harmony export */   formatPaymentDate: () => (/* binding */ formatPaymentDate),
/* harmony export */   getDateFromIso: () => (/* binding */ getDateFromIso),
/* harmony export */   getOneMonthAgo: () => (/* binding */ getOneMonthAgo),
/* harmony export */   parseDate: () => (/* binding */ parseDate)
/* harmony export */ });
var getOneMonthAgo = function getOneMonthAgo() {
  var today = new Date();
  var year = today.getUTCFullYear();
  var month = today.getUTCMonth() - 1;
  var day = today.getUTCDate();
  return new Date(year, month, day);
};
var parseDate = function parseDate(isoDate) {
  /*
   * Returns a js Date object from an iso formatted string
   */
  var splitted = isoDate.split("-");
  var year = parseInt(splitted[0], 10);
  var month = parseInt(splitted[1], 10) - 1;
  var day = parseInt(splitted[2], 10);
  return new Date(year, month, day);
};
var getDateFromIso = parseDate;
var formatPaymentDate = function formatPaymentDate(isoDate) {
  /*
   *  format a date from iso to display format
   */
  if (isoDate) {
    // catches null/undefined/""
    var dateObject = parseDate(isoDate);
    return dateToLocaleFormat(dateObject);
  } else {
    return "";
  }
};
var formatDate = formatPaymentDate;
var dateToIso = function dateToIso(dateObject) {
  var year = dateObject.getFullYear();
  var month = dateObject.getMonth() + 1;
  var dt = dateObject.getDate();
  if (dt < 10) {
    dt = "0" + dt;
  }
  if (month < 10) {
    month = "0" + month;
  }
  return year + "-" + month + "-" + dt;
};
var dateToLocaleFormat = function dateToLocaleFormat(dateObject) {
  var year = dateObject.getFullYear();
  var month = dateObject.getMonth() + 1;
  var dt = dateObject.getDate();
  if (dt < 10) {
    dt = "0" + dt;
  }
  if (month < 10) {
    month = "0" + month;
  }
  return dt + "/" + month + "/" + year;
};

/***/ }),

/***/ "./src/math.js":
/*!*********************!*\
  !*** ./src/math.js ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formatAmount: () => (/* binding */ formatAmount),
/* harmony export */   formatPrice: () => (/* binding */ formatPrice),
/* harmony export */   getPercent: () => (/* binding */ getPercent),
/* harmony export */   getTvaPart: () => (/* binding */ getTvaPart),
/* harmony export */   htFromTtc: () => (/* binding */ htFromTtc),
/* harmony export */   isNotFormattable: () => (/* binding */ isNotFormattable),
/* harmony export */   round: () => (/* binding */ round),
/* harmony export */   strToFloat: () => (/* binding */ strToFloat),
/* harmony export */   sumArray: () => (/* binding */ sumArray),
/* harmony export */   trailingZeros: () => (/* binding */ trailingZeros)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var mathjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! mathjs */ "./node_modules/mathjs/index.js");
/* harmony import */ var mathjs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(mathjs__WEBPACK_IMPORTED_MODULE_2__);



function getEpsilon() {
  /*
   * Return the epsilon needed to test if the value is a float error
   * computation result
   */
  if ("EPSILON" in Number) {
    return Number.EPSILON;
  }
  var eps = 1.0;
  do {
    eps /= 2.0;
  } while (1.0 + eps / 2.0 != 1.0);
  return eps;
}
function removeEpsilon(value) {
  /*
   * Remove epsilons (75.599999999 -> 75.6 )from the value if needed
   *
   * :param int value: The value to test if it's a string, we convert it to
   * float before
   */
  if (underscore__WEBPACK_IMPORTED_MODULE_1___default().isUndefined(value.toPrecision)) {
    return value;
  }
  var epsilon = getEpsilon();
  var delta = value.toPrecision(6) - value;
  delta = delta * delta;
  if (delta === 0) {
    return value;
  }
  if (delta < epsilon) {
    return value.toPrecision(6);
  } else {
    return value;
  }
}
var strToFloat = function strToFloat(value) {
  /*
   * Transform the value to a float
   *
   * :param str value: A string value representing a number
   */
  var result;
  if (underscore__WEBPACK_IMPORTED_MODULE_1___default().isNumber(value)) {
    return value;
  }
  if (underscore__WEBPACK_IMPORTED_MODULE_1___default().isUndefined(value) || underscore__WEBPACK_IMPORTED_MODULE_1___default().isNull(value)) {
    value = "0.00";
  }
  value = value.replace(",", ".");
  result = parseFloat(value);
  if (isNaN(result)) {
    return 0.0;
  } else {
    return result;
  }
};
var round = function round(price, precision) {
  /*
   *  Round the price (in our comptability model, round_half_up, 1.5->2)
   *
   *  :param float price: The price to round
   *  :param int precision: The level of precision
   */
  precision = precision || 2;
  return mathjs__WEBPACK_IMPORTED_MODULE_2___default().round(price, precision);
};
var formatPrice = function formatPrice(price, rounded, strip, precision) {
  /*
   * Return a formatted price for display
   * @price : compute-formatted price
   * @rounded : SHould it be rounded to 2 decimals
   * @strip : Should last digits be replaced by dots "..."
   */
  if (strip === undefined) {
    strip = true;
  }
  price = removeEpsilon(price);
  var dots, splitted, integer, cents, ret_string;
  if (rounded) {
    price = round(price, precision);
  }
  splitted = String(price).split(".");
  integer = splitted[0].replace(/(\d)(?=(\d{3})+$)/g, "$1 ");
  if (splitted[1] != undefined) {
    cents = splitted[1];
    if (strip) {
      if (cents.length > 4) {
        dots = true;
      }
      cents = cents.substr(0, 4);
      cents = trailingZeros(cents, rounded);
    }
  } else {
    cents = "00";
  }
  ret_string = integer + "," + cents;
  if (dots) {
    ret_string += "…";
  }
  return ret_string;
};
var isNotFormattable = function isNotFormattable(amount) {
  /*
   * Verify if the amount is already formatted (with the euros sign)
   */
  if (underscore__WEBPACK_IMPORTED_MODULE_1___default().isUndefined(amount) || underscore__WEBPACK_IMPORTED_MODULE_1___default().isNull(amount)) {
    return true;
  }
  var test = " " + amount;
  if (test.indexOf("€") >= 0 || test.indexOf("&nbsp;&euro;") >= 0) {
    return true;
  }
  return false;
};
var formatAmount = function formatAmount(amount, rounded, strip, precision) {
  /*
   * return a formatted user-friendly amount
   */
  if (rounded === undefined) {
    rounded = true;
  }
  if (isNotFormattable(amount)) {
    return amount;
  }
  return formatPrice(amount, rounded, strip, precision) + "&nbsp;&euro;";
};
var trailingZeros = function trailingZeros(cents, rounded) {
  /*
   * Remove trailing zeros in an amount
   *
   * :param str cents: A string value representing cents (14010)
   * :param bool rounded: Should we round the value ?
   */
  if (cents.length === 1) {
    cents += 0;
  }
  var last_value;
  if (!rounded) {
    last_value = cents.substr(cents.length - 1);
    while (cents.length > 2 && last_value == "0") {
      cents = cents.substr(0, cents.length - 1);
      last_value = cents.substr(cents.length - 1);
    }
  }
  return cents;
};
var getTvaPart = function getTvaPart(total, tvaRate) {
  /*
   *  Compute the given tva from total HT
   */
  return total * tvaRate / 100;
};
var htFromTtc = function htFromTtc(ttc, tvaRate) {
  var TVA_ROUNDING_PRECISION = 5;
  var translation_coef = Math.pow(10, TVA_ROUNDING_PRECISION);
  var tva_quotient = mathjs__WEBPACK_IMPORTED_MODULE_2___default().floor(translation_coef / (1 + tvaRate / 100)) / translation_coef;
  console.log(tva_quotient);
  return round(ttc * tva_quotient);
};
var getPercent = function getPercent(amount, percent) {
  /*
   * Compute a percentage
   */
  return round(amount * percent / 100);
};
var sumArray = function sumArray(arrayToSum) {
  if (arrayToSum.length > 1) {
    return mathjs__WEBPACK_IMPORTED_MODULE_2___default().add.apply((mathjs__WEBPACK_IMPORTED_MODULE_2___default()), (0,_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(arrayToSum));
  } else if (arrayToSum.length == 1) {
    return arrayToSum[0];
  } else {
    return 0;
  }
};

/***/ }),

/***/ "./src/string.js":
/*!***********************!*\
  !*** ./src/string.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SafeString: () => (/* binding */ SafeString),
/* harmony export */   addBr: () => (/* binding */ addBr),
/* harmony export */   capitalize: () => (/* binding */ capitalize)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_esm_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");


var capitalize = function capitalize(string) {
  return string.charAt(0).toUpperCase() + string.substring(1).toLowerCase();
};

/** Escape HTML syntax from an HTML string
 *
 * Relies on the browser escaping rather than regex.
 *
 *
 * @param aString string to be escaped
 * @returns {String} escaped string
 */
function escapeHTML(aString) {
  var p = document.createElement("p");
  p.innerText = aString;
  return p.innerHTML;
}

/** Handlebars SafeString
 *
 * A safe string won't be HTML-escaped by handlebars.
 *
 * Equivalent to Handlebars SafeString class.
 *
 * Embeding handelbars for those few lines is an extra 70kio of minified js.
 */
var SafeString = /*#__PURE__*/function () {
  function SafeString(aString) {
    (0,_babel_runtime_helpers_esm_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, SafeString);
    this.string = aString;
  }
  return (0,_babel_runtime_helpers_esm_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(SafeString, [{
    key: "toString",
    value: function toString() {
      return "" + this.string;
    }
  }, {
    key: "toHTML",
    value: function toHTML() {
      return this.toString();
    }
  }]);
}();

/** Replace carriage retuns (\n) by <br />
 *
 * Sanitize input to produce a result safe to code injection.
 */
var addBr = function addBr(aString) {
  // Ref #3875 : On sanitize le Html dans les mémos à la création
  // const escapedString = escapeHTML(aString);
  return new SafeString(aString.replace(/(?:\r\n|\r|\n)/g, "<br />"));
};

/***/ }),

/***/ "./src/tools.js":
/*!**********************!*\
  !*** ./src/tools.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ajax_call: () => (/* binding */ ajax_call),
/* harmony export */   attachTools: () => (/* binding */ attachTools),
/* harmony export */   closeModal: () => (/* binding */ closeModal),
/* harmony export */   findCurrentSelected: () => (/* binding */ findCurrentSelected),
/* harmony export */   getDefaultItem: () => (/* binding */ getDefaultItem),
/* harmony export */   getOpt: () => (/* binding */ getOpt),
/* harmony export */   handle400Errors: () => (/* binding */ handle400Errors),
/* harmony export */   handleJsonRedirect: () => (/* binding */ handleJsonRedirect),
/* harmony export */   hideBtnLoader: () => (/* binding */ hideBtnLoader),
/* harmony export */   hideLoader: () => (/* binding */ hideLoader),
/* harmony export */   openModal: () => (/* binding */ openModal),
/* harmony export */   scrollTop: () => (/* binding */ scrollTop),
/* harmony export */   serializeForm: () => (/* binding */ serializeForm),
/* harmony export */   setupAjaxCSRF: () => (/* binding */ setupAjaxCSRF),
/* harmony export */   setupAjaxCallbacks: () => (/* binding */ setupAjaxCallbacks),
/* harmony export */   setupDeferredExceptionHandling: () => (/* binding */ setupDeferredExceptionHandling),
/* harmony export */   showBtnLoader: () => (/* binding */ showBtnLoader),
/* harmony export */   showLoader: () => (/* binding */ showLoader),
/* harmony export */   sortCollection: () => (/* binding */ sortCollection),
/* harmony export */   toggleModal: () => (/* binding */ toggleModal),
/* harmony export */   updateSelectOptions: () => (/* binding */ updateSelectOptions),
/* harmony export */   viewToString: () => (/* binding */ viewToString)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ "./src/math.js");
/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");



var ajax_call = function ajax_call(url, data, method, extra_options) {
  var data = data || {};
  var method = method || "GET";
  var options = {
    url: url,
    data: data,
    method: method,
    dataType: "json",
    cache: false
  };
  if (["POST", "PUT", "PATCH"].includes(method)) {
    options.contentType = "application/json; charset=UTF-8";
    options.processData = false;
  }
  underscore__WEBPACK_IMPORTED_MODULE_0___default().extend(options, extra_options);
  if (["POST", "PUT", "PATCH"].includes(method) && options.contentType && options.contentType.startsWith("application/json")) {
    options.data = JSON.stringify(data);
  }
  return jquery__WEBPACK_IMPORTED_MODULE_1___default().ajax(options);
};
var updateSelectOptions = function updateSelectOptions(options, val, key) {
  /*
   * Add the selected attr to the option with value 'val'
   *
   * :param list options: list of js objects
   * :param list val: key or keys that will receive selected: true
   * :param str key: the key used to identifiy items ('value' by default)
   * :returns: True if a default or an existing value has been found
   * :rtype: bool
   */
  if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(options)) {
    console.error("updateSelectOptions : options are undefined");
  }
  if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(val)) {
    console.warn("updateSelectOptions : value is undefined");
    return false;
  }
  if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isArray(val)) {
    val = [val];
  }
  if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(key)) {
    key = "value";
  }
  var has_selected = false;
  underscore__WEBPACK_IMPORTED_MODULE_0___default().each(options, function (option) {
    delete option["selected"];
    // On checke si une des valeurs val est égal à option[key] ou à sa
    // représentation en str
    if (underscore__WEBPACK_IMPORTED_MODULE_0___default().contains(val, option[key]) || underscore__WEBPACK_IMPORTED_MODULE_0___default().contains(val, String(option[key]))) {
      option["selected"] = "true";
      has_selected = true;
    }
  });
  if (!has_selected) {
    var option = getDefaultItem(options);
    if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(option)) {
      option["selected"] = true;
      has_selected = true;
    }
  }
  return has_selected;
};
var getDefaultItem = function getDefaultItem(items) {
  /*
   * Get The default item from an array of items looking for a default key
   *
   * :param list items: list of objects
   * :rtype: obj or undefined
   */
  var result = underscore__WEBPACK_IMPORTED_MODULE_0___default().find(items, function (item) {
    return item["default"] == true;
  });
  return result;
};
var findCurrentSelected = function findCurrentSelected(options, current_value, key) {
  /*
   * Return the full object definition from options matching the current value
   *
   * :param list options: List of objects
   * :param str current_value: The current value in int or str
   * :param str key: The key used to identify objects (value by default)
   * :returns: The object matching the current_value
   */
  return underscore__WEBPACK_IMPORTED_MODULE_0___default().find(options, function (item) {
    return item[key] == current_value;
  });
};
var getOpt = function getOpt(obj, key, default_val) {
  /*
   * Helper to get a default option
   *
   * :param obj obj: The object with the getOption func
   * :param str key: The key we're looking for
   * :param default_val: the default value
   *
   * :returns: The value matching key or default
   */
  var val = obj.getOption(key);
  if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(val)) {
    val = default_val;
  }
  return val;
};
var serializeForm = function serializeForm(form_object, options) {
  /*
   * Return the form datas as an object
   * :param obj form_object: A jquery instance wrapping the form
   * :param dict options: One of the available options listed below
   *
   *  clean
   *
   *      Remove null values ('', null ...)
   */
  var null_values = ["", null, "None", "none"];
  options = options || {};
  var result = {};
  var serial = form_object.serializeArray();

  // initialize multi-valued field as arrays
  var multiValued = form_object.find("[multiple]").toArray().map(function (x) {
    return x.name;
  });
  var _iterator = _createForOfIteratorHelper(multiValued),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var fieldName = _step.value;
      result[fieldName] = [];
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  jquery__WEBPACK_IMPORTED_MODULE_1___default().each(serial, function () {
    if (!options["clean"] || underscore__WEBPACK_IMPORTED_MODULE_0___default().indexOf(null_values, this.value) == -1) {
      if (result[this.name]) {
        if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isArray(result[this.name])) {
          result[this.name] = [result[this.name]];
        }
        result[this.name].push(this.value || "");
      } else {
        result[this.name] = this.value || "";
      }
    }
  });
  form_object.find("input[type=checkbox]:not(:checked):not([multiple])").map(function () {
    result[this.name] = "0";
  });
  return result;
};
var handleJsonRedirect = function handleJsonRedirect(xhr) {
  /**
   * Handle json redirect method.
   */
  var json_resp = xhr.responseJSON;
  if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(json_resp) && json_resp.redirect) {
    window.location.href = json_resp.redirect;
  }
  return xhr;
};

/** Show errors returned with a 40* http response */
var handle400Errors = function handle400Errors(xhr) {
  /*
  Minimal user feedback in case something goes wrong and is
  not handled by frontend */
  var message = "Le client a renvoyé une erreur.";
  if (xhr.status >= 400 && xhr.status != 423) {
    if (xhr.status == 415) {
      // Unsupported media type, used for upload of PDF with wrong format
      message = "Le format du fichier n'est pas supporté.";
    } else {
      message = "Votre document n'est pas valide, merci de vérifier votre saisie.";
    }
    if (xhr.responseJSON.errors) {
      message += "\n\n";
      if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isArray(xhr.responseJSON.errors)) {
        xhr.responseJSON.errors.forEach(function (error) {
          message += error + "\n";
        });
      } else if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isObject(xhr.responseJSON.errors)) {
        Object.keys(xhr.responseJSON.errors).forEach(function (key) {
          var error = xhr.responseJSON.errors[key];
          message += key + ":";
          message += error + "\n";
        });
      } else if (underscore__WEBPACK_IMPORTED_MODULE_0___default().isString(xhr.responseJSON.errors)) {
        message += xhr.responseJSON.errors + "\n";
      }
    } else {
      if (xhr.responseJSON.message) {
        message += xhr.responseJSON.message;
      }
    }
  }
  window.alert(message);
  hideLoader();
  return xhr;
};
var setupAjaxCallbacks = function setupAjaxCallbacks() {
  /*
   * Setup ajax calls callbacks
   *
   * if 'redirect' is found in the json resp, we go there
   *
   * if status code is 401 : we redirect to #login
   *
   * alert() user if a 400/500 is returned.
   */
  jquery__WEBPACK_IMPORTED_MODULE_1___default()(document).ajaxComplete(function (event, xhr, settings) {
    if (xhr.status == 401) {
      hideLoader();
      window.location.replace("#login");
    } else if (xhr.status >= 500) {
      hideLoader();
      window.alert("Une erreur bloquante est survenue, veuillez réessayer ultérieurement. Si le problème persiste, veuillez contacter un administrateur.");
    } else if (xhr.status >= 400) {
      handle400Errors(xhr);
    } else if (xhr.status == 0) {
      hideLoader();
      console.error("Unknown error : XHR response with no status (aborted request ?)");
      //window.alert("Une erreur inconnue est survenue, veuillez réessayer ultérieurement. Si le problème persiste, veuillez contacter un administrateur.");
    } else {
      handleJsonRedirect(xhr);
    }
  });
};
var setupAjaxCSRF = function setupAjaxCSRF(csrfToken) {
  jquery__WEBPACK_IMPORTED_MODULE_1___default().ajaxSetup({
    beforeSend: function beforeSend(xhr, settings) {
      if (!(/^http:.*/.test(settings.url) || /^https:.*/.test(settings.url))) {
        // Only send the token to relative URLs i.e. locally.
        xhr.setRequestHeader("X-CSRFToken", csrfToken);
      }
    }
  });
};
var setupDeferredExceptionHandling = function setupDeferredExceptionHandling() {
  /* Override default jQuery exception handling inside Promises
   *
   * jQuery >3.x swalows exception happening inside promises (and issue a console.warn for some of them)
   *
   * Here we let them crash the app with a clear error and stacktrace.
   */
  jQuery.Deferred.exceptionHook = function (error, stack) {
    console.warn("re-throwing a deferred exception, otherwise, it gets (sometimes silently) discarded");
    throw error;
  };
};
var showLoader = function showLoader() {
  /*
   * Show a loading box
   */
  jquery__WEBPACK_IMPORTED_MODULE_1___default()("#loading-box").show();
};
var hideLoader = function hideLoader() {
  /*
   * Show a loading box
   */
  jquery__WEBPACK_IMPORTED_MODULE_1___default()("#loading-box").hide();
};
var showBtnLoader = function showBtnLoader(jquery_object) {
  jquery_object.addClass("loader");
  jquery_object.append("<span class='loading_box'><svg><use href='../static/icons/icones.svg#circle-notch'></use></svg></span>");
};
var hideBtnLoader = function hideBtnLoader(jquery_object) {
  jquery_object.removeClass("loader");
  jquery_object.find(".loading_box").remove();
};
function openPopup(url, callback) {
  var screen_width = screen.width;
  var screen_height = screen.height;
  var width = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.getPercent)(screen_width, 60);
  var height = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.getPercent)(screen_height, 60);
  var uniq_id = underscore__WEBPACK_IMPORTED_MODULE_0___default().uniqueId("popup");
  if (underscore__WEBPACK_IMPORTED_MODULE_0___default().indexOf(url, "?") != -1) {
    url = url + "&popup=" + uniq_id;
  } else {
    url = url + "?popup=" + uniq_id;
  }
  var new_win = window.open(url, uniq_id, "width=" + width + ",height=" + height);
  if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(callback)) {
    window.popupCallbacks[uniq_id] = callback;
  }
}
function dismissPopup(win, options) {
  var callback = window.popupCallbacks[win.name];
  if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(callback)) {
    callback(options);
    delete window.popupCallbacks[win.name];
  } else {
    var default_options = {
      refresh: true
    };
    underscore__WEBPACK_IMPORTED_MODULE_0___default().extend(default_options, options);
    if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(default_options.force_reload)) {
      window.location.reload();
    } else {
      var new_content = "";
      if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(default_options.message)) {
        new_content += "<div class='alert alert-success'><span class='icon'><svg><use href='/static/icons/icones.svg#success'></use></svg></span> ";
        new_content += default_options.message;
      } else if (!underscore__WEBPACK_IMPORTED_MODULE_0___default().isUndefined(default_options.error)) {
        new_content += "<div class='alert alert-danger'><span class='icon'><svg><use href='/static/icons/icones.svg#danger'></use></svg></span> ";
        new_content += default_options.error;
      }
      if (default_options.refresh) {
        new_content += "&nbsp;<a href='#' onclick='window.location.reload();'><span class='icon'><svg><use href='/static/icons/icones.svg#redo-alt'></use></svg></span> Rafraîchir</a>";
      }
      new_content += "</div>";
      var dest_tag = jquery__WEBPACK_IMPORTED_MODULE_1___default()("#popupmessage");
      if (dest_tag.length == 0) {
        dest_tag = jquery__WEBPACK_IMPORTED_MODULE_1___default()(".pagetitle");
      }
      dest_tag.after(new_content);
    }
  }
  win.close();
}
var attachTools = function attachTools() {
  window.dismissPopup = dismissPopup;
  window.openPopup = openPopup;
  window.popupCallbacks = {};
};
var scrollTop = function scrollTop(value) {
  value = value || 0;
  jquery__WEBPACK_IMPORTED_MODULE_1___default()("#target_content").scrollTop(value);
};
var openModal = function openModal(jquery_object) {
  jquery_object.css("display", "flex");
  jquery_object.addClass("appear");
  jquery_object.removeClass("dismiss");
  document.body.classList.add("modal_open");
  var modalCloseButton = jquery_object.querySelector("button.unstyled.close");
  modalCloseButton.focus();
};
var closeModal = function closeModal(jquery_object) {
  jquery_object.css("display", "none");
  jquery_object.removeClass("appear");
  jquery_object.addClass("dismiss");
  document.body.classList.remove("modal_open");
};
var toggleModal = function toggleModal(jquery_object) {
  if (jquery_object.is(":visible")) {
    closeModal(jquery_object);
  } else {
    openModal(jquery_object);
  }
};
var sortCollection = function sortCollection(collection, sortBy, direction) {
  collection.comparator = function (item1, item2) {
    if (direction === "desc") {
      return item1.get(sortBy) > item2.get(sortBy) ? -1 : 1;
    }
    return item1.get(sortBy) > item2.get(sortBy) ? 1 : -1;
  };
  collection.sort();
};
var viewToString = function viewToString(marionetteViewObject) {
  if (!marionetteViewObject.isRendered()) {
    marionetteViewObject.render();
  }
  return marionetteViewObject.$el.html();
};

/***/ }),

/***/ "./src/widgets/AnchorWidget.js":
/*!*************************************!*\
  !*** ./src/widgets/AnchorWidget.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_0__);


/** A Widget for action links
 * Can be initialized in two ways :

    Passing a model with an 'option' attribute describing the Anchor

        new AnchorWidget({model: new Bb.Model({option: {href: 'https://endi.coop', label: 'Link to endi'}})});

    Passing directly the options on widget initialization

        new AnchorWidget({href: 'https://endi.coop', label: 'Link to endi'});
 *
 * It can handle GET actions and popup actions. If you need a POST action (eg:
 * non-idempotent action like deletion), have a look at POSTButtonWidget.
 *
 */
var AnchorWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default().View.extend({
  tagName: "div",
  template: __webpack_require__(/*! ./templates/AnchorWidget.mustache */ "./src/widgets/templates/AnchorWidget.mustache"),
  ui: {
    anchor: "a"
  },
  events: {
    "click @ui.anchor": "onClick"
  },
  findOptions: function findOptions() {
    var options;
    var model = this.getOption("model");
    if (model && model.has("option")) {
      options = model.get("option");
    } else {
      options = this.options;
    }
    return options;
  },
  templateContext: function templateContext() {
    return {
      option: this.findOptions()
    };
  },
  onClick: function onClick() {
    var options = this.findOptions();
    if (options.popup) {
      window.openPopup(options.url);
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnchorWidget);

/***/ }),

/***/ "./src/widgets/BaseFormWidget.js":
/*!***************************************!*\
  !*** ./src/widgets/BaseFormWidget.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/*
 *
 */



/**
 * @param {string} title - The Field UI label
 * @param {string} label - Other way of setting the Field UI label
 * @param {string} changeEventName - The base name of the event triggerd on
 * data change (blur event) (default: 'change')
 * @param {string} finishEventName - The base name of the event triggerd on
 * data finish (leaving the field) (default 'finish')
 * @param {string} field_name - The form field name (attribute name)
 * @param {string} ariaLabel - Custom aria-label (default to title/label)
 * @param {string} description - The field description (under the input/select...)
 * @param {boolean} editable - Is it readonly (defaul true)
 * @param {boolean} required - Is it a mandatory field (will add a star to the UI label)
 * @param {string} value - The value to set (string/date/integer depending on the Child Class)
 *
 * Trigger tools
 *
 * @method triggerChange: Trigger the change and change:field_name events with the value
 * @method triggerFinish: Trigger the finish and finish:field_name events with the value
 */

var BaseFormWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().View.extend({
  initialize: function initialize() {
    this.cid = _.uniqueId();
    this.currentValue = "";
  },
  getTagId: function getTagId() {
    /*
     * Return an id for the current textarea
     */
    var id_ = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "field_id", false);
    if (!id_) {
      var field_name = this.getOption("field_name");
      id_ = field_name + "-" + this.cid;
    }
    return id_;
  },
  getCurrentValue: function getCurrentValue() {
    return this.currentValue;
  },
  triggerChange: function triggerChange(field_value) {
    var event_name = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "changeEventName", "change");
    var field_name = this.getOption("field_name");
    this.triggerMethod(event_name, field_name, field_value);
    this.triggerMethod(event_name + ":" + field_name, field_value);
    this.currentValue = field_value;
  },
  triggerFinish: function triggerFinish(field_value) {
    var event_name = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "finishEventName", "finish");
    console.log("Triggering %s, %s", event_name, field_value);
    var field_name = this.getOption("field_name");
    this.triggerMethod(event_name, field_name, field_value);
    this.triggerMethod(event_name + ":" + field_name, field_value);
    this.currentValue = field_value;
  },
  getCommonContext: function getCommonContext() {
    var label = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "title", "") || (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "label", "");
    var ariaLabel = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "ariaLabel", "") || label;
    var placeholder = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "placeholder", ariaLabel);
    var description = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "description", "");
    var editable = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "editable", true);
    var required = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "required", false);
    if ((0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "value", "")) {
      this.currentValue = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "value", "");
    }
    return {
      ariaLabel: ariaLabel,
      label: label,
      title: label,
      // For retro-compatibility
      description: description,
      placeholder: placeholder,
      field_name: this.getOption("field_name"),
      tagId: this.getTagId(),
      editable: editable,
      required: required
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseFormWidget);

/***/ }),

/***/ "./src/widgets/ButtonCollectionWidget.js":
/*!***********************************************!*\
  !*** ./src/widgets/ButtonCollectionWidget.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ButtonWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ButtonWidget.js */ "./src/widgets/ButtonWidget.js");


var ButtonCollectionWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().CollectionView.extend({
  tagName: "div",
  attributes: {
    role: "group"
  },
  childView: _ButtonWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"],
  childViewOptions: {
    surroundingTagName: "div"
  },
  childViewTriggers: {
    "action:clicked": "action:clicked"
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ButtonCollectionWidget);

/***/ }),

/***/ "./src/widgets/ButtonWidget.js":
/*!*************************************!*\
  !*** ./src/widgets/ButtonWidget.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _IconWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IconWidget.js */ "./src/widgets/IconWidget.js");
/* harmony import */ var _base_models_ButtonModel_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../base/models/ButtonModel.js */ "./src/base/models/ButtonModel.js");




var ButtonWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_3___default().View.extend({
  /*
   * View for a ButtonModel
   *
   * Usage:
   * 1- With a ButtonModel
   *      let model = new ButtonModel({
   *          label: 'click me',
   *          icon: 'plus',
   *          showLabel: false,
   *          action: 'clickme',
   *          css: 'btn-info'
   *      });
   *      widget = new ButtonWidget({model: model});
   *
   * 2- Passing directly the options
   *      widget = new ButtonWidget({
   *          label: 'click me',
   *          icon: 'plus',
   *          showLabel: false,
   *          css: 'btn-info'
   *       })
   *
   *
   * Surrounding Tag (directly to the view)
   * ---------------------------------------
   *
   * You can specify the surrounding tag and its css (mandatory in marionette) by specifying
   *
   * @param {string} surroudingTagName: The tagName of this view (default: span)
   * @param {string} surroudingCss: The css of this view (default: '')
   *
   * Label and icon (on the model or directly to the view)
   * ------------------------------------------------------
   *
   * @param {string} label: label for this button
   * @param {bool} showLabel: Should we show the label (or only the icon)
   * @param {string} icon: Optionnal name of an icon to add to this button
   *
   * Triggers
   * --------
   * There are two way to specify triggers
   *
   * 1- specify an 'action' attribute (on the model or directly)
   *
   * @event action:clicked
   * @property {string} actionName the 'action' string passed as option
   *
   * 2- specify an 'event' attribute (on the model or directly)
   *
   * @event the 'event' string passed as option
   *
   * Full example :
   *
   *      let model = new ButtonModel({label: 'click me', icon: 'plus', showLabel: false});
   *      this.showChildView('button-container', new ButtonWidget({model: model}));
   */
  template: __webpack_require__(/*! ./templates/ButtonWidget.mustache */ "./src/widgets/templates/ButtonWidget.mustache"),
  tagName: function tagName() {
    return (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "surroundingTagName", "span");
  },
  className: function className() {
    return (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "surroundingCss", "");
  },
  regions: {
    icon: {
      el: "icon",
      replaceElement: true
    }
  },
  ui: {
    btn: "button"
  },
  events: {
    "click @ui.btn": "onButtonClicked"
  },
  initialize: function initialize(options) {
    if (!("model" in options)) {
      this.model = new _base_models_ButtonModel_js__WEBPACK_IMPORTED_MODULE_2__["default"]({
        label: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "label", ""),
        icon: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "icon", "question-circle"),
        showLabel: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "showLabel", true),
        title: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "title", "")
      });
      var event = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "event", false);
      if (event) {
        this.model.set("event", event);
      }
      var action = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "action", false);
      if (action) {
        this.model.set("action", action);
      }
    }
  },
  onButtonClicked: function onButtonClicked(event) {
    if (this.model.has("action")) {
      var actionName = this.model.get("action");
      this.triggerMethod("action:clicked", actionName);
    } else if (this.model.has("event")) {
      this.triggerMethod(this.model.get("event"));
    } else {
      console.error("ButtonWidget : il manque un attribut action ou event au modèle");
    }
  },
  onRender: function onRender() {
    var icon = this.model.get("icon");
    if (icon !== false) {
      this.showChildView("icon", new _IconWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"]({
        icon: icon
      }));
    } else {
      this.removeRegion("icon");
    }
  },
  templateContext: function templateContext() {
    var css = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "css", "");
    if (this.model.get("css")) {
      css += " " + this.model.get("css");
    }
    var result = {
      surroundingTagName: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "surroundingTagName", false),
      css: css
    };
    if (!this.model.has("title")) {
      result["title"] = this.model.get("label");
    }
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ButtonWidget);

/***/ }),

/***/ "./src/widgets/CheckboxListWidget.js":
/*!*******************************************!*\
  !*** ./src/widgets/CheckboxListWidget.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");



var template = __webpack_require__(/*! ./templates/CheckboxListWidget.mustache */ "./src/widgets/templates/CheckboxListWidget.mustache");

/*
 * A drop-in replacement for SelectWidget with multiple: true
 *
 *
 * Features :
 *  - single or multiple item selector
 *  - optionaly supports displaying only a subset of the options
 *   (configurable filter function).
 * - optionaly togglable modes (view/edit).
 *
 *  Triggers on value selection (two different events to allow two way of event bindings):
 *  - "finish", field_name, field_value
 *  - "finish:field_name", field_value
 *
 * Support following options
 *
 *   :param str title: The field label
 *   :param str description:
 *   :param str field_name:
 *   :param list options: The options to render list of objects
 *   :param list value: the values to select
 *   :param str id_key: The key of the options used as option's "value", default is "value"
 *   :param bool editable: is this read-only ?
 *   :param bool togglable: (default: false): enable the togglable view/edit mode
 *   :param str removeItemConfirmationMsg: (default: undefined) if set, prompt
 *      for confirmation when unchecking an item.
 *   :param optionFilter: an optional function to filter the <option> to be shown
 *     * Returns true if the option should be offered.
 *     * Takes two params:
 *         * obj option: The option to be evaluated for display
 *   :param layout: which CSS layout to use for checkbox list ? ("two_cols", "three_cols"…),
 *     defaults to nothing special, which means vertical list rendering.
 *   :param noOptionMessage: which message to display when no option is available
 *   :param addBtnIcon: the icon to use for the "add" button
 *   :param addBtnLabel: the label to use for the "add" button
 */
var CheckboxListWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  template: template,
  ui: {
    checkboxes: "input[type=checkbox]",
    toggleEdit: "button.edit"
  },
  events: {
    "click @ui.checkboxes": "onClick",
    "click @ui.toggleEdit": "onToggleEdit"
  },
  getCurrentValues: function getCurrentValues() {
    var checkboxes = this.$el.find("input[type=checkbox]:checked");
    var res = [];
    _.each(checkboxes, function (checkbox) {
      res.push($(checkbox).attr("value"));
    });
    return res;
  },
  onClick: function onClick(event) {
    this.options.value = this.getCurrentValues();
    var continueEvent;
    var removeItemConfirmationMsg = this.getOption("removeItemConfirmationMsg");
    if (!event.target.checked && removeItemConfirmationMsg) {
      continueEvent = window.confirm(removeItemConfirmationMsg);
    } else {
      continueEvent = true;
    }
    if (continueEvent) {
      var values = this.getCurrentValues();
      this.triggerFinish(values);
    } else {
      event.preventDefault();
    }
    this.render();
  },
  onToggleEdit: function onToggleEdit(event) {
    this.editing = !this.editing;
    this.render();
  },
  filterOptions: function filterOptions(options) {
    var currentValues = this.getOption("value");
    var optionFilter = this.getOption("optionFilter");
    var currentOption = undefined;
    if (optionFilter) {
      if (currentValues.length > 0) {
        currentOption = options.find(function (x) {
          return String(x.id) === String(currentValues[0]);
        });
      }
      return options.filter(function (x) {
        return optionFilter(x, currentOption);
      });
    } else {
      return options;
    }
  },
  templateContext: function templateContext() {
    var id_key = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "id_key", "id");
    var options = this.filterOptions(this.getOption("options"));
    var current_values = this.getOption("value");
    var editing;
    (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.updateSelectOptions)(options, current_values, id_key);
    var selectedOptions = options.filter(function (x) {
      return x.selected;
    });
    var togglable = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "togglable", false);
    if (togglable) {
      editing = this.editing == undefined ? false : this.editing;
    } else {
      editing = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "editable", true);
    }
    var result = this.getCommonContext();
    var other = {
      options: options,
      selectedOptions: selectedOptions,
      editing: editing,
      togglable: togglable,
      layout: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "layout", null),
      noOptionMessage: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "noOptionMessage", ""),
      addBtnIcon: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "addBtnIcon", "plus"),
      addBtnLabel: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "addBtnLabel", "Ajouter")
    };
    result = Object.assign(result, other);
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxListWidget);

/***/ }),

/***/ "./src/widgets/CheckboxWidget.js":
/*!***************************************!*\
  !*** ./src/widgets/CheckboxWidget.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");


var template = __webpack_require__(/*! ./templates/CheckboxWidget.mustache */ "./src/widgets/templates/CheckboxWidget.mustache");
/**
 * Build a Checkbox (a toggle by default)
 *
 * See documentation of BaseFormWidget for base options
 *
 *
 * Widget specific field
 *
 *  @param string inline_label: The label shown aside the checbox
 *  @param string true_val: The True value (default '1') used when checked
 *  @param string false_val: The False value (default '0') used when unchecked
 *  @param boolean toggle: Is the checkbox show as a toggle (default true)
 *
 * @fires finishEventName - field_name, value
 * @fires finishEventName:field_name - field_name, value
 *
 */

var CheckboxWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  template: template,
  ui: {
    checkbox: "input[type=checkbox]"
  },
  events: {
    "click @ui.checkbox": "onClick"
  },
  getCurrentValue: function getCurrentValue() {
    var checked = this.getUI("checkbox").prop("checked");
    if (checked) {
      return (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "true_val", "1");
    } else {
      return (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "false_val", "0");
    }
  },
  onClick: function onClick(event) {
    var field_value = this.getCurrentValue();
    this.triggerFinish(field_value);
  },
  templateContext: function templateContext() {
    var result = this.getCommonContext();
    var true_val = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "true_val", "1");
    var checked = this.getOption("value") == true_val;
    var divCss = "checkbox";
    if ((0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "toggle", true)) {
      divCss = "toggle";
    }
    var others = {
      inline_label: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "inline_label", ""),
      checked: checked,
      divCss: divCss
    };
    return Object.assign(result, others);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxWidget);

/***/ }),

/***/ "./src/widgets/DateWidget.js":
/*!***********************************!*\
  !*** ./src/widgets/DateWidget.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var _date_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../date.js */ "./src/date.js");



var template = __webpack_require__(/*! ./templates/DateWidget.mustache */ "./src/widgets/templates/DateWidget.mustache");
var DateWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  /*
  A jquery datepicker widget
  */
  template: template,
  ui: {
    input: "input"
  },
  events: {
    "blur @ui.input": "onBlur",
    "change @ui.input": "onChange",
    "click @ui.input": "onClick",
    "keydown @ui.input": "onKeyDown"
  },
  onBlur: function onBlur() {
    var val = this.ui.input.val();
    this.triggerFinish(val);
  },
  onChange: function onChange(event) {
    var value = this.ui.input.val();
    // Si c'est une action souris, on valide (c'est que l'on a sélectionné la valeur dans le calendrier)

    // NB : un cas reste problématique :
    // Je commence à saisir au clavier et je clique dans le calendrier (l'event ici ne se lancera pas)
    // Le click dans le calendrier ne lance pas d'event onclick
    if (this.isMouseChange) {
      this.triggerFinish(value);
    }
  },
  onClick: function onClick() {
    // Lorsqu'on clique dans l'input on enregistre que c'est une action de la souris
    this.isKeyboardChange = false;
    this.isMouseChange = true;
  },
  onKeyDown: function onKeyDown() {
    // Si on tape au clavier, on enregistre que c'est une action clavier
    this.isKeyboardChange = true;
    this.isMouseChange = false;
  },
  getValue: function getValue() {
    var value = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "date", this.getOption("value")); // FIXME
    return value;
  },
  templateContext: function templateContext() {
    /*
     * Give parameters for the templating context
     */
    // common widget parameters (see BaseFormWidget)
    var ctx = this.getCommonContext();
    var more_ctx = {
      value: this.getValue()
    };
    if (!(0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "editable", true)) {
      more_ctx["date"] = (0,_date_js__WEBPACK_IMPORTED_MODULE_2__.formatDate)(this.getValue());
    }
    more_ctx["erasable"] = false;
    if (!(0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "required", false)) {
      if (this.getValue()) {
        more_ctx["erasable"] = true;
      }
    }
    return Object.assign(ctx, more_ctx);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DateWidget);

/***/ }),

/***/ "./src/widgets/DropDownWidget.js":
/*!***************************************!*\
  !*** ./src/widgets/DropDownWidget.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _ButtonWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ButtonWidget.js */ "./src/widgets/ButtonWidget.js");
/* harmony import */ var _IconWidget_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconWidget.js */ "./src/widgets/IconWidget.js");
/* harmony import */ var _base_models_ButtonCollection_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../base/models/ButtonCollection.js */ "./src/base/models/ButtonCollection.js");
/*
 * File Name :  DropDownWidget.js
 */





var DropDownItemsView = backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default().CollectionView.extend({
  tagName: "ul",
  className: function className() {
    var result = "dropdown-menu";
    var orientation = (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "orientation", "right");
    result += " dropdown-menu-" + orientation;
    return result;
  },
  childView: _ButtonWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  // On forward l'évènement action:clicked
  childViewTriggers: {
    "action:clicked": "action:clicked"
  },
  childViewOptions: {
    surroundingTagName: "li",
    css: "unstyled"
  }
});
var DropDownWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_4___default().View.extend({
  /*
   * A dropdown composite view
   * shows a dropdown with a main button
   *
   * :param str dropDownLabel: The label (used for screen readers in case of showLabel is false)
   * :param str showLabel: default false (should we show the label in any case)
   * :param str icon: The icon
   * :param str css: The css
   * :param obj collection: ButtonCollection
   * :param str orientation: dropdown right/left orientation regarding the need
   *
   * a dropdown button
   * a dropdown populated with the provided collection
   *
   * Triggers action:clicked with param 'action'
   */
  default_icon: "dots",
  tatgName: "div",
  className: "btn-group",
  attributes: {
    style: "display:inline-flex"
  },
  template: __webpack_require__(/*! ./templates/DropDownWidget.mustache */ "./src/widgets/templates/DropDownWidget.mustache"),
  regions: {
    list: {
      el: "ul",
      replaceElement: true
    },
    icon: {
      el: "icon",
      replaceElement: true
    }
  },
  // On forward l'évènement action:clicked
  childViewTriggers: {
    "action:clicked": "action:clicked"
  },
  initialize: function initialize(options) {
    if (!("collection" in options)) {
      this.collection = new _base_models_ButtonCollection_js__WEBPACK_IMPORTED_MODULE_3__["default"](options.buttons);
    }
  },
  onRender: function onRender() {
    this.showChildView("list", new DropDownItemsView({
      collection: this.collection,
      orientation: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "orientation", "right")
    }));
    this.showChildView("icon", new _IconWidget_js__WEBPACK_IMPORTED_MODULE_2__["default"]({
      icon: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "icon", this.default_icon)
    }));
  },
  templateContext: function templateContext() {
    return {
      label: this.getOption("dropdownLabel"),
      showLabel: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "showLabel", false),
      css: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "css", ""),
      orientation: (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.getOpt)(this, "orientation", "left")
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DropDownWidget);

/***/ }),

/***/ "./src/widgets/IconWidget.js":
/*!***********************************!*\
  !*** ./src/widgets/IconWidget.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   iconHtmlString: () => (/* binding */ iconHtmlString)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../tools */ "./src/tools.js");
/*
 * Easily design icons
 *
 * Find list of icons in the icones.svg file
 *
 * this.showChildView('icon-container', new IconWidget({icon: icon}));
 *

*/
/* global ENDI_STATIC_ICON_URL; */


var IconWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().View.extend({
  // NB : we need to use a span since using the tagName : 'svg' doesn't work (icon not loaded)
  tagName: "span",
  template: __webpack_require__(/*! ./templates/IconWidget.mustache */ "./src/widgets/templates/IconWidget.mustache"),
  templateContext: function templateContext() {
    return {
      url: CAERP_STATIC_ICON_URL + "#" + this.getOption("icon")
    };
  }
});
var iconHtmlString = function iconHtmlString(icon) {
  return (0,_tools__WEBPACK_IMPORTED_MODULE_0__.viewToString)(new IconWidget({
    icon: icon
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IconWidget);

/***/ }),

/***/ "./src/widgets/InputWidget.js":
/*!************************************!*\
  !*** ./src/widgets/InputWidget.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");


var InputWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  /*
   * A base input widget
   *
   * Support following options :
   *
   *    * value
   *    * title or label
   *    * field_name
   *    * description
   *    * type (default text)
   *    * addon (bootstrap addon)
   *    * css_class: A custom css class
   *    * editable
   *    * placeholder
   *    * ariaLabel
   *    * dataList
   *    * editable
   *
   *    new InputWidget({'title': 'My label', 'field_name': 'field1});
   *
   *  Trigger 2 types of events :
   *
   *      * change (onKeyUp)
   *      * finish (onBlur)
   *
   *      with parameters :
   *
   *      field_name
   *      value
   *
   */
  tagName: "div",
  className: "form-group",
  template: __webpack_require__(/*! ./templates/InputWidget.mustache */ "./src/widgets/templates/InputWidget.mustache"),
  ui: {
    input: "input"
  },
  events: {
    "keyup @ui.input": "onKeyUp",
    "blur @ui.input": "onBlur"
  },
  onKeyUp: function onKeyUp() {
    this.triggerChange(this.getUI("input").val());
  },
  onBlur: function onBlur() {
    this.triggerFinish(this.getUI("input").val());
  },
  templateContext: function templateContext() {
    var result = this.getCommonContext();
    var type = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "type", "text");
    if (!result.label && !result.ariaLabel && type != "hidden") {
      result.description += "Warning : no ariaLabel provided";
    }
    // update returned dict
    result = Object.assign(result, {
      type: type,
      value: this.getOption("value"),
      css_class: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "css", ""),
      dataList: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "dataList", []),
      uniqueId: _.uniqueId("datalist"),
      pattern: this.getOption("pattern")
    });
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InputWidget);

/***/ }),

/***/ "./src/widgets/LoadingWidget.js":
/*!**************************************!*\
  !*** ./src/widgets/LoadingWidget.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./templates/LoadingWidget.mustache */ "./src/widgets/templates/LoadingWidget.mustache");
var LoadingWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default().View.extend({
  tagName: "div",
  className: "loading_box",
  template: template
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoadingWidget);

/***/ }),

/***/ "./src/widgets/POSTButtonWidget.js":
/*!*****************************************!*\
  !*** ./src/widgets/POSTButtonWidget.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);



/** A <form action=post> with a single action button
 *
 * This is for actions that target POST views. Visually, it looks like the same
 * as AnchorWidget, that handle GET views.
 */
var POSTButtonWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().View.extend({
  tagName: "div",
  template: __webpack_require__(/*! ./templates/POSTButtonWidget.mustache */ "./src/widgets/templates/POSTButtonWidget.mustache"),
  ui: {
    button: "button"
  },
  events: {
    "click @ui.button": "confirm"
  },
  confirm: function confirm() {
    var options = this.model.get("option");
    if (options.confirm_msg) {
      return window.confirm(options.confirm_msg);
    } else {
      return true;
    }
  },
  templateContext: function templateContext() {
    var channel = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("config");
    var csrf_token = channel.request("get:options", "csrf_token");
    return {
      csrf_token: csrf_token
    };
  },
  redirect: function redirect(data, textStatus, jqXHR) {
    window.location = jqXHR.getResponseHeader("Location");
  },
  refresh: function refresh(data, textStatus, jqXHR) {
    console.log("REFRESH", jqXHR, textStatus);
    window.location.reload();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (POSTButtonWidget);

/***/ }),

/***/ "./src/widgets/PercentInputWidget.js":
/*!*******************************************!*\
  !*** ./src/widgets/PercentInputWidget.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var _InputWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InputWidget.js */ "./src/widgets/InputWidget.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_2__);



__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");

var PercentInputWidget = _InputWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"].extend({
  tagName: "div",
  className: "form-group",
  template: __webpack_require__(/*! ./templates/PercentInputWidget.mustache */ "./src/widgets/templates/PercentInputWidget.mustache"),
  ui: {
    input: "input"
  },
  events: {
    "keyup @ui.input": "onKeyUp",
    "input @ui.input": "onKeyUp",
    "blur @ui.input": "onBlur"
  },
  onInput: function onInput() {
    // there is no keyup event for input type=range
    this.triggerChange(this.getUI("input").val());
  },
  onKeyUp: function onKeyUp() {
    this.triggerChange(this.getUI("input").val());
  },
  onBlur: function onBlur() {
    this.triggerFinish(this.getUI("input").val());
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PercentInputWidget);

/***/ }),

/***/ "./src/widgets/RadioChoiceButtonWidget.js":
/*!************************************************!*\
  !*** ./src/widgets/RadioChoiceButtonWidget.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseFormWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseFormWidget */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools */ "./src/tools.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");



/**
 *
 * Voir La documentation de BaseFormWidget pour les options de base
 *
 * @fires finishEventName - field_name, value
 * @fires finishEventName:field_name - field_name, value
 *
 * @param {list} options - List of options each option is a
 * dict {'value': ..., 'label': ...} and can optionnaly have an icon attribute
 */

var RadioChoiceButtonWidget = _BaseFormWidget__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  template: __webpack_require__(/*! ./templates/RadioChoiceButtonWidget.mustache */ "./src/widgets/templates/RadioChoiceButtonWidget.mustache"),
  ui: {
    buttons: "label"
  },
  events: {
    "click @ui.buttons": "onClick"
  },
  /**
   * Lancé l'on clique sur un des labels (un des boutons).
   *
   * NB : La gestion des évènements avec des éléments enfants génère ici des problèmes
   * résolus par les hacks ci-dessous :
   *
   * Si on clique dans un des boutons du widget :
   * - on clique à la fois sur l'input et sur le span
   * - le span (on l'input) génère chacun un event onclick et celui-ci est également exécuté sur chaque parent jusqu'au label
   *
   *
   * @param {Event} event
   * @returns
   */
  onClick: function onClick(event) {
    // On limite la propagation à chaque parent
    event.stopImmediatePropagation();
    // On bloque le traitement du onclick sur l'input (seul celui du span sera traité)
    if (event.target.tagName.toLowerCase() == "input") {
      return;
    }
    // On utilise currentTarget : le label (target est un de ses enfants, ici le <span>)
    var target = $(event.currentTarget);
    var val = $(target).find("input").val();
    this.triggerFinish(val);
  },
  templateContext: function templateContext() {
    var options = this.getOption("options");
    var current_value = this.getOption("value");
    (0,_tools__WEBPACK_IMPORTED_MODULE_1__.updateSelectOptions)(options, current_value);
    var result = this.getCommonContext();
    result["options"] = options;
    return result;
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RadioChoiceButtonWidget);

/***/ }),

/***/ "./src/widgets/RadioWidget.js":
/*!************************************!*\
  !*** ./src/widgets/RadioWidget.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");


var template = __webpack_require__(/*! ./templates/RadioWidget.mustache */ "./src/widgets/templates/RadioWidget.mustache");
var RadioWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  /*
   * Build a Radio
   *
   *  :param str field_name: The form field name
   *  :param str field_value: The value of the radio field
   *  :param str value: The current value
   *
   *  Events :
   *
   *   finish : When selected
   *
   *   onFinish(field_name, field_value)
   *
   */
  template: template,
  ui: {
    radio: "input[type=radio]"
  },
  events: {
    "click @ui.radio": "onClick"
  },
  onClick: function onClick(event) {
    this.triggerFinish(this.getOption("field_value"));
  },
  templateContext: function templateContext() {
    var result = this.getCommonContext();
    var value = this.getOption("field_value");
    var checked = this.getOption("value") == value;
    var others = {
      value: value,
      inline_label: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "inline_label", ""),
      checked: checked
    };
    return Object.assign(result, others);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RadioWidget);

/***/ }),

/***/ "./src/widgets/Select2RemoteWidget.js":
/*!********************************************!*\
  !*** ./src/widgets/Select2RemoteWidget.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var _Select2Widget_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Select2Widget.js */ "./src/widgets/Select2Widget.js");
/* harmony import */ var select2__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! select2 */ "./node_modules/select2/dist/js/select2.js");
/* harmony import */ var select2__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(select2__WEBPACK_IMPORTED_MODULE_3__);



// globally assign select2 fn to $ element


var Select2RemoteWidget = _Select2Widget_js__WEBPACK_IMPORTED_MODULE_2__["default"].extend({
  /*
   * A select2 widget using a remote data source
   *
   * Supports paginated results from an API with backbone-paginated style
   *
   * Share the API of SelectWidget
   *
   * @param url REST API endpoint URL
   * @param pageSize (optional) : how many to fech at once ?
   * @param extraUrlParams (optional) : key/value GET parameters for
   *   HTTP AJAX request.
   * @param value_label : the initial option label, corresponding to `value`arg
   *
   */

  initializePlaceHolder: function initializePlaceHolder(placeholder, options) {
    /* Empty <option> is not required when using ajax datasource
     * we use this function to prefill initial option prior to any ajax
     * list request.
     */
    var initial_value = this.getOption("value");
    var initial_label = this.getOption("value_label");
    if (initial_value) {
      options[0] = (0,_babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, this.id_key, initial_value), this.label_key, initial_label);
    }
  },
  getSelect2Params: function getSelect2Params() {
    var params = _Select2Widget_js__WEBPACK_IMPORTED_MODULE_2__["default"].prototype.getSelect2Params.apply(this);
    var pageSize = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "pageSize", 50);
    var extraUrlParams = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "extraUrlParams", {});
    var this_ = this;
    return Object.assign({}, params, {
      allowClear: true,
      ajax: {
        url: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "url"),
        data: function data(params) {
          var baseURLParams = {
            search: params.term,
            // Respects backbone-paginated style:
            page: params.page || 0,
            items_per_page: pageSize
          };
          return Object.assign({}, baseURLParams, extraUrlParams);
        },
        processResults: function processResults(data, params) {
          // Transforms backbone-paginated pagination style to
          // select2 style
          params.page = params.page || 0;
          var totalCount = data[0].total_entries;
          var thisPageReach = (params.page + 1) * pageSize;
          return {
            results: data[1].map(function (x) {
              return {
                id: x[this_.id_key],
                text: x[this_.label_key]
              };
            }),
            pagination: {
              more: thisPageReach < totalCount
            }
          };
        }
      }
    });
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select2RemoteWidget);

/***/ }),

/***/ "./src/widgets/Select2Widget.js":
/*!**************************************!*\
  !*** ./src/widgets/Select2Widget.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var _SelectWidget_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SelectWidget.js */ "./src/widgets/SelectWidget.js");
/* harmony import */ var select2__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! select2 */ "./node_modules/select2/dist/js/select2.js");
/* harmony import */ var select2__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(select2__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var select2_dist_js_i18n_fr__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! select2/dist/js/i18n/fr */ "./node_modules/select2/dist/js/i18n/fr.js");
/* harmony import */ var select2_dist_js_i18n_fr__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(select2_dist_js_i18n_fr__WEBPACK_IMPORTED_MODULE_4__);
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");



// globally assign select2 fn to $ element



/*
 * Monkeypatch select2 pour éviter un freeze du scroll endi#2342
 *
 * source: https://github.com/select2/select2/issues/3125#issuecomment-337959828
 * On devrait pouvoir retirer ça quand ça sera corrigé upstream…
 */
$.fn.select2.amd.require(["select2/dropdown/attachBody", "select2/utils"], function (AttachBody, Utils) {
  AttachBody.prototype._attachPositioningHandler = function (decorated, container) {
    var self = this;
    var scrollEvent = "scroll.select2." + container.id;
    var resizeEvent = "resize.select2." + container.id;
    var orientationEvent = "orientationchange.select2." + container.id;
    var $watchers = this.$container.parents().filter(Utils.hasScroll);
    $watchers.each(function () {
      $(this).data("select2-scroll-position", {
        x: $(this).scrollLeft(),
        y: $(this).scrollTop()
      });
    });
    $watchers.on(scrollEvent, function (ev) {
      var position = $(this).data("select2-scroll-position");
      $(self).scrollTop(position.y); // patch: this => self
    });
    $(window).on(scrollEvent + " " + resizeEvent + " " + orientationEvent, function (e) {
      self._positionDropdown();
      self._resizeDropdown();
    });
  };
});
var Select2Widget = _SelectWidget_js__WEBPACK_IMPORTED_MODULE_2__["default"].extend({
  /*
   * A select2 widget
   *
   * Share the API of SelectWidget
   */
  getSelect2Params: function getSelect2Params() {
    var params = {
      width: "100%",
      placeholder: (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "placeholder", undefined),
      allowClear: !(0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "required", false),
      language: "fr"
    };
    // For clearable multi-select placeholders, a default placeholder is required.
    if (params.allowClear && params.placeholder === undefined) {
      params.placeholder = "";
    }
    return params;
  },
  onBeforeAttach: function onBeforeAttach() {
    var editable = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "editable", true);
    if (!editable) {
      return;
    }
    if (!(0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "field_id", false)) {
      console.error("Select2 '" + (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "field_name", "inconnu") + "' : aucun field_id n'est fourni pour le widget, la navigation au clavier ne fonctionnera pas");
    }
    var selectUI = this.getUI("select");
    selectUI.select2(this.getSelect2Params());
    selectUI.on("select2:open", function (e) {
      var selectId = e.target.id;
      $(".select2-search__field[aria-controls='select2-" + selectId + "-results']").each(function (key, value) {
        value.focus();
      });
    });
    var this_ = this;
    selectUI.on("select2:close", function (event) {
      var selectId = this_.getTagId();
      $('.select2-selection[aria-labelledby="select2-' + selectId + '-container"]').focus();
    });
  },
  onBeforeDetach: function onBeforeDetach() {
    var editable = (0,_tools_js__WEBPACK_IMPORTED_MODULE_1__.getOpt)(this, "editable", true);
    if (!editable) {
      return;
    }
    this.getUI("select").select2("destroy");
  },
  initializePlaceHolder: function initializePlaceHolder(placeholder, options) {
    /* Empty <option> is required in DOM, see
     * https://select2.org/placeholders#single-select-placeholders
     */
    var emptyOption = (0,_babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, this.id_key, ""), this.label_key, "");
    if (!_.findWhere(options, emptyOption)) {
      options.unshift(emptyOption);
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select2Widget);

/***/ }),

/***/ "./src/widgets/SelectBusinessWidget.js":
/*!*********************************************!*\
  !*** ./src/widgets/SelectBusinessWidget.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var _Select2RemoteWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Select2RemoteWidget */ "./src/widgets/Select2RemoteWidget.js");




var template = __webpack_require__(/*! ./templates/SelectBusinessWidget.mustache */ "./src/widgets/templates/SelectBusinessWidget.mustache");
var SelectBusinessWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_1__["default"].extend({
  /*
   * A widget to select a customer/project/business
   *
   * Cascade-style selection (customer, then project, then business), it is
   * also possible to select only a customer, or only a project…
   *
   * Use ajax requests.
   */
  tagName: "div",
  className: "form-group",
  template: template,
  regions: {
    select_customer: ".select_customer",
    select_project: ".select_project",
    select_business: ".select_business"
  },
  childViewEvents: {
    finish: "onChildChange"
  },
  childViewTriggers: {
    labelChange: "labelChange"
  },
  renderCustomerSelect: function renderCustomerSelect(initialValue, initialLabel) {
    this.showChildView("select_customer", new _Select2RemoteWidget__WEBPACK_IMPORTED_MODULE_3__["default"]({
      field_name: "customer_id",
      field_id: "customer_id",
      value: initialValue,
      url: this.getOption("customers_url"),
      placeholder: "- Choisir un client -",
      title: "Client",
      value_label: initialLabel,
      id_key: "id",
      label_key: "label"
    }));
  },
  renderProjectSelect: function renderProjectSelect(initialValue, initialLabel, urlParams) {
    this.showChildView("select_project", new _Select2RemoteWidget__WEBPACK_IMPORTED_MODULE_3__["default"]({
      field_name: "project_id",
      field_id: "project_id",
      value: initialValue,
      placeholder: "- Choisir un dossier -",
      url: this.getOption("projects_url"),
      title: "Dossier",
      value_label: initialLabel,
      extraUrlParams: urlParams,
      id_key: "id",
      label_key: "name"
    }));
  },
  renderBusinessSelect: function renderBusinessSelect(initialValue, initialLabel, urlParams) {
    this.showChildView("select_business", new _Select2RemoteWidget__WEBPACK_IMPORTED_MODULE_3__["default"]({
      value: initialValue,
      field_name: "business_id",
      field_id: "business_id",
      placeholder: "- Choisir une affaire -",
      url: this.getOption("businesses_url"),
      title: "Affaire",
      value_label: initialLabel,
      extraUrlParams: urlParams,
      id_key: "id",
      label_key: "name"
    }));
  },
  onRender: function onRender() {
    var customerId = this.getOption("customer_value");
    var projectId = this.getOption("project_value");
    var businessId = this.getOption("business_value");
    // record for business select
    this.customer_id = customerId;
    this.renderCustomerSelect(customerId, this.getOption("customer_label"));
    if (customerId) {
      this.renderProjectSelect(projectId, this.getOption("project_label"));
      if (projectId) {
        this.renderBusinessSelect(businessId, this.getOption("business_label"));
      }
    }
  },
  onChildChange: function onChildChange(field_name, value) {
    this.triggerMethod("finish", field_name, value);
    if (field_name === "customer_id") {
      // clear business and project on model
      this.triggerMethod("finish", "project_id", null);
      this.triggerMethod("finish", "business_id", null);

      // Re-render project select, filtering by customer
      this.getRegion("select_project").empty();
      if (value) {
        this.renderProjectSelect(null, "", {
          customer_id: value
        });
        // Record for business select
        this.customer_id = value;
      }

      // Hide business selection (till project is selected)
      this.getRegion("select_business").empty();
    }
    if (field_name === "project_id") {
      // clear business on model
      this.triggerMethod("finish", "business_id", "");

      // Re-render business select, filtering by project_id
      this.getRegion("select_business").empty();
      if (value) {
        this.renderBusinessSelect(null, "", {
          project_id: value,
          customer_id: this.customer_id
        });
      }
    }
  },
  templateContext: function templateContext() {
    return this.getCommonContext();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SelectBusinessWidget);

/***/ }),

/***/ "./src/widgets/SelectWidget.js":
/*!*************************************!*\
  !*** ./src/widgets/SelectWidget.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");
/* harmony import */ var underscore__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(underscore__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");





var template = __webpack_require__(/*! ./templates/SelectWidget.mustache */ "./src/widgets/templates/SelectWidget.mustache");

/**
 * A select widget
 *
 * Features :
 *  - single or multiple item selector
 *  - optionaly supports empty value
 *
 * Triggers :
 *
 * On Value selection
 *
 * @fires finishEventName - named finish by default, current value passed as param
 * @fires finishEventName:field_name - named "finish":field_name by default,
 * current value passed as param
 *
 *
 *
 * See BaseFormWidget for main options
 *
 * SelectWidget specific options :
 *
 *   @param {list} options: The options to render in the form [{id_key: 21, label_key: "Option 21"}]
 *   @param {string} value: The value to select
 *   @param {string} id_key: The key of the options used as option's "value", default is "value"
 *   @param {string} label_key: The key of the options used as label default is label
 *   @param {string} placeholder: placeholder text, will add an <option> with
 *     value="" ; can be set to empty string for empty label <option>
 *     as placeholder.
 *   @param {boolean} multiple: does this widget allow selecting multiple targets
 */
var SelectWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_2__["default"].extend({
  tagName: "div",
  className: "form-group",
  template: template,
  ui: {
    select: "select"
  },
  events: {
    "change @ui.select": "onChange"
  },
  initialize: function initialize() {
    SelectWidget.__super__.initialize.apply(this, arguments);
    this.id_key = (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "id_key", "value");
    this.label_key = (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "label_key", "label");
  },
  onChange: function onChange(event) {
    var select = this.getUI("select");
    var field_values = this.getCurrentValues();
    this.options.value = field_values;

    // Fix #3350 : select pas multiple renvoie une seule valeur
    if ((0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "multiple", false)) {
      this.triggerFinish(field_values);
    } else {
      var value = select.val();
      this.triggerFinish(value);
    }

    // specific to select
    this.triggerMethod("labelChange", this.getOption("field_name"), select.find("option:selected").text());
  },
  /** Return currently selected values
   *
   * this.getOption('value') is not always relevant as it contains only the
   * initial value (from widget initialization).
   */
  getCurrentValues: function getCurrentValues() {
    var optionNodes = $.makeArray(this.$el.find("option:selected"));
    return optionNodes.map(function (x) {
      return x.getAttribute("value");
    });
  },
  initializePlaceHolder: function initializePlaceHolder(placeholder, options) {
    var placeholderOption = (0,_babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, this.id_key, ""), this.label_key, placeholder);
    if (!underscore__WEBPACK_IMPORTED_MODULE_1___default().findWhere(options, placeholderOption)) {
      options.unshift(placeholderOption);
    }
  },
  getReadonly: function getReadonly() {},
  templateContext: function templateContext() {
    var _this = this;
    var ctx = this.getCommonContext();

    // If some ad-hoc filtering of displayed options is required, read
    // CheckBoxListWidget implementation for inspiration.

    // do not use getOption as there is name collision on "options"
    var options = this.options.options || [];
    var initialValue = this.getOption("value");
    var editable = (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "editable", true);
    var more_ctx = {};
    if (!editable) {
      var _options$find;
      var currentValueLabel = (_options$find = options.find(function (item) {
        return item[_this.id_key] == initialValue;
      })) === null || _options$find === void 0 ? void 0 : _options$find[this.label_key];
      more_ctx["currentValueLabel"] = currentValueLabel || "";
    } else {
      var hasInitialValue = !underscore__WEBPACK_IMPORTED_MODULE_1___default().isUndefined(initialValue) && !underscore__WEBPACK_IMPORTED_MODULE_1___default().isNull(initialValue);
      if (hasInitialValue) {
        (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.updateSelectOptions)(options, initialValue, this.id_key);
      }
      var placeholder = (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "placeholder", undefined);
      var hasPlaceHolder = !underscore__WEBPACK_IMPORTED_MODULE_1___default().isUndefined(placeholder);
      if (hasPlaceHolder) {
        this.initializePlaceHolder(placeholder, options);
      }
      var multiple = (0,_tools_js__WEBPACK_IMPORTED_MODULE_3__.getOpt)(this, "multiple", false);
      more_ctx = {
        options: options,
        id_key: this.id_key,
        label_key: this.label_key,
        multiple: multiple
      };
    }
    return Object.assign(ctx, more_ctx);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SelectWidget);

/***/ }),

/***/ "./src/widgets/StatusButtonWidget.js":
/*!*******************************************!*\
  !*** ./src/widgets/StatusButtonWidget.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_0__);



/**
 * A button sending status modifications to the facade radio channel
 */
var StatusButtonWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_1___default().View.extend({
  tagName: "div",
  template: __webpack_require__(/*! ./templates/StatusButtonWidget.mustache */ "./src/widgets/templates/StatusButtonWidget.mustache"),
  ui: {
    button: "button"
  },
  events: {
    "click @ui.button": "onClick"
  },
  onClick: function onClick(event) {
    this.triggerMethod("status:change", this.model);
    var facade = backbone_radio__WEBPACK_IMPORTED_MODULE_0___default().channel("facade");
    facade.trigger("status:change", this.model);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusButtonWidget);

/***/ }),

/***/ "./src/widgets/TextAreaWidget.js":
/*!***************************************!*\
  !*** ./src/widgets/TextAreaWidget.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tinymce_tinymce__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tinymce/tinymce */ "./node_modules/tinymce/tinymce.js");
/* harmony import */ var tinymce_tinymce__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(tinymce_tinymce__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var tinymce_themes_silver__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tinymce/themes/silver */ "./node_modules/tinymce/themes/silver/index.js");
/* harmony import */ var tinymce_themes_silver__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(tinymce_themes_silver__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var tinymce_icons_default__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tinymce/icons/default */ "./node_modules/tinymce/icons/default/index.js");
/* harmony import */ var tinymce_icons_default__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(tinymce_icons_default__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var tinymce_plugins_lists__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tinymce/plugins/lists */ "./node_modules/tinymce/plugins/lists/index.js");
/* harmony import */ var tinymce_plugins_lists__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(tinymce_plugins_lists__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var tinymce_plugins_advlist__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tinymce/plugins/advlist */ "./node_modules/tinymce/plugins/advlist/index.js");
/* harmony import */ var tinymce_plugins_advlist__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(tinymce_plugins_advlist__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var tinymce_plugins_paste__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tinymce/plugins/paste */ "./node_modules/tinymce/plugins/paste/index.js");
/* harmony import */ var tinymce_plugins_paste__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(tinymce_plugins_paste__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var tinymce_plugins_searchreplace__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tinymce/plugins/searchreplace */ "./node_modules/tinymce/plugins/searchreplace/index.js");
/* harmony import */ var tinymce_plugins_searchreplace__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(tinymce_plugins_searchreplace__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var tinymce_plugins_visualblocks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tinymce/plugins/visualblocks */ "./node_modules/tinymce/plugins/visualblocks/index.js");
/* harmony import */ var tinymce_plugins_visualblocks__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(tinymce_plugins_visualblocks__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var tinymce_plugins_fullscreen__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tinymce/plugins/fullscreen */ "./node_modules/tinymce/plugins/fullscreen/index.js");
/* harmony import */ var tinymce_plugins_fullscreen__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(tinymce_plugins_fullscreen__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./BaseFormWidget.js */ "./src/widgets/BaseFormWidget.js");
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");


/* Default icons are required for TinyMCE 5.3 or above */

// Any plugins you want to use has to be imported








var template = __webpack_require__(/*! ./templates/TextAreaWidget.mustache */ "./src/widgets/templates/TextAreaWidget.mustache");
var setupTinyMce = function setupTinyMce(kwargs) {
  /*
   * Setup a tinymce editor
   * kwargs are tinymce init options to be added to the default ones
   *
   * Should at least provide the selector key
   *
   * https://www.tinymce.com/docs/
   */
  // Following block is kept in sync manually with vue_sources/src/components/forms/RichTextArea.vue
  var skin = "oxide";
  if (window.matchMedia("(prefers-color-scheme: dark)").matches) {
    skin = "oxide-dark";
  }
  var options = {
    body_class: "form-control",
    theme_advanced_toolbar_location: "top",
    theme_advanced_toolbar_align: "left",
    width: "100%",
    //height: "auto",
    language: "fr_FR",
    skin_url: "/fanstatic/fanstatic/js/build/tinymce-assets/skins/ui/" + skin,
    language_url: "/fanstatic/fanstatic/js/build/tinymce-assets/langs/fr_FR.js",
    content_css: "/fanstatic/fanstatic/js/build/tinymce-assets/skins/ui/" + skin + "/content.css",
    plugins: "lists advlist searchreplace visualblocks fullscreen paste",
    theme_advanced_resizing: true,
    theme: "silver",
    skin: skin,
    strict_loading_mode: true,
    mode: "none",
    convert_fonts_to_spans: true,
    paste_as_text: true,
    toolbar: "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | " + "bullist numlist outdent indent | link image | print preview media fullpage | " + "forecolor backcolor emoticons",
    menubar: "edit view insert format tools table",
    browser_spellcheck: true
  };
  _.extend(options, kwargs);
  tinymce_tinymce__WEBPACK_IMPORTED_MODULE_0___default().init(options);
};
var TextAreaWidget = _BaseFormWidget_js__WEBPACK_IMPORTED_MODULE_9__["default"].extend({
  /*
   * A textarea widget
   *
   * Support following options :
   *
   *   :param str title:
   *   :param str description:
   *   :param str field_name:
   *   :param str value:
   *   :param int rows:
   *   :param bool editable:
   *   :param str placeholder:
   *   :param bool tinymce: Richtext widget ?
   *
   * Triggers two type of events
   *
   *   change : on KeyUp
   *   finish : when leaving the field
   */
  tagName: "div",
  className: "form-group",
  template: template,
  ui: {
    textarea: "textarea"
  },
  events: {
    "keyup @ui.textarea": "onKeyUp",
    "blur @ui.textarea": "onBlur"
  },
  onKeyUp: function onKeyUp() {
    this.triggerChange(this.getUI("textarea").val());
  },
  onBlur: function onBlur() {
    this.triggerFinish(this.getUI("textarea").val());
  },
  templateContext: function templateContext() {
    var ctx = this.getCommonContext();
    var more_ctx = {
      value: (0,_tools_js__WEBPACK_IMPORTED_MODULE_10__.getOpt)(this, "value", ""),
      rows: (0,_tools_js__WEBPACK_IMPORTED_MODULE_10__.getOpt)(this, "rows", 2)
    };
    return Object.assign(ctx, more_ctx);
  },
  onAttach: function onAttach() {
    var tiny = (0,_tools_js__WEBPACK_IMPORTED_MODULE_10__.getOpt)(this, "tinymce", false);
    if (tiny) {
      var onblur = this.onBlur.bind(this);
      var onkeyup = this.onKeyUp.bind(this);
      setupTinyMce({
        selector: "#" + this.getTagId(),
        init_instance_callback: function init_instance_callback(editor) {
          editor.on("blur", onblur);
          editor.on("keyup", onkeyup);
          editor.on("change", function () {
            tinymce_tinymce__WEBPACK_IMPORTED_MODULE_0___default().triggerSave();
          });
        }
      });
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextAreaWidget);

/***/ }),

/***/ "./src/widgets/ToggleButtonWidget.js":
/*!*******************************************!*\
  !*** ./src/widgets/ToggleButtonWidget.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _tools_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../tools.js */ "./src/tools.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js");
/* harmony import */ var backbone_radio__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(backbone_radio__WEBPACK_IMPORTED_MODULE_1__);
/* provided dependency */ var _ = __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js");



var template = __webpack_require__(/*! ./templates/ToggleButtonWidget.mustache */ "./src/widgets/templates/ToggleButtonWidget.mustache");
var ToggleButtonWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_2___default().View.extend({
  template: template,
  ui: {
    radios: "input[type=radio]"
  },
  events: {
    "change @ui.radios": "onChange"
  },
  initialize: function initialize() {
    this.updateSelectOptions();
  },
  updateSelectOptions: function updateSelectOptions() {
    var options = this.model.get("options");
    (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.updateSelectOptions)(options.buttons, options.current_value, "value");
  },
  onChange: function onChange(event) {
    var stringValue = event.target.value;
    var opts = this.model.get("options");
    // Allows to have non-string value in current_value
    var selectedButton = _.find(opts.buttons, function (button) {
      return button.value.toString() === stringValue;
    });
    var typedValue = selectedButton.value;
    opts.current_value = typedValue;
    this.model.set("options", opts);
    this.updateSelectOptions();
    this.render();
    this.trigger("status:change", typedValue);
    (0,_tools_js__WEBPACK_IMPORTED_MODULE_0__.ajax_call)(this.model.get("options").url, {
      submit: typedValue
    }, "POST", {
      success: this.onSuccess.bind(this)
    });
  },
  onSuccess: function onSuccess() {
    this.trigger("status:changed", this.model);
  },
  templateContext: function templateContext() {
    var options = this.model.get("options");
    return {
      name: options.name,
      toggle_label: options.toggle_label || "Changer le statut en",
      buttons: options.buttons
    };
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ToggleButtonWidget);

/***/ }),

/***/ "./src/widgets/ToolbarButtonWidget.js":
/*!********************************************!*\
  !*** ./src/widgets/ToolbarButtonWidget.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! backbone.marionette */ "./node_modules/backbone.marionette/lib/backbone.marionette.js");
/* harmony import */ var backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone_marionette__WEBPACK_IMPORTED_MODULE_0__);


/** A Widget for action links
 * Can be initialized in two ways :

    Passing a model with an 'option' attribute describing the Anchor

        new ToolbarButtonWidget({model: new Bb.Model({option: {href: 'https://endi.coop', label: 'Link to endi'}})});

    Passing directly the options on widget initialization

        new ToolbarButtonWidget({href: 'https://endi.coop', label: 'Link to endi'});
 *
 * It can handle GET actions and popup actions. If you need a POST action (eg:
 * non-idempotent action like deletion), have a look at POSTButtonWidget.
 *
 */
var ToolbarButtonWidget = backbone_marionette__WEBPACK_IMPORTED_MODULE_0___default().View.extend({
  tagName: "div",
  template: __webpack_require__(/*! ./templates/ToolbarButtonWidget.mustache */ "./src/widgets/templates/ToolbarButtonWidget.mustache"),
  ui: {
    button: "button"
  },
  events: {
    "click @ui.button": "onClick"
  },
  findOptions: function findOptions() {
    var options;
    var model = this.getOption("model");
    if (model && model.has("option")) {
      options = model.get("option");
    } else {
      options = this.options;
    }
    return options;
  },
  templateContext: function templateContext() {
    var options = this.findOptions();
    var onclick;
    if (!(options.onclick instanceof Function)) {
      onclick = options.onclick;
    }
    return {
      option: this.findOptions(),
      onclick: onclick
    };
  },
  onClick: function onClick(event) {
    var options = this.findOptions();
    if (options.popup) {
      window.openPopup(options.url);
    } else if (options.onclick instanceof Function) {
      options.onclick(event);
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ToolbarButtonWidget);

/***/ }),

/***/ "./node_modules/backbone-validation/dist/backbone-validation-amd.js":
/*!**************************************************************************!*\
  !*** ./node_modules/backbone-validation/dist/backbone-validation-amd.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Backbone.Validation v0.11.5
//
// Copyright (c) 2011-2015 Thomas Pedersen
// Distributed under MIT License
//
// Documentation and full license available at:
// http://thedersen.com/projects/backbone-validation
(function (factory) {
  if (true) {
    module.exports = factory(__webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js"), __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js"));
  } else {}
}(function (Backbone, _) {
  Backbone.Validation = (function(_){
    'use strict';
  
    // Default options
    // ---------------
  
    var defaultOptions = {
      forceUpdate: false,
      selector: 'name',
      labelFormatter: 'sentenceCase',
      valid: Function.prototype,
      invalid: Function.prototype
    };
  
  
    // Helper functions
    // ----------------
  
    // Formatting functions used for formatting error messages
    var formatFunctions = {
      // Uses the configured label formatter to format the attribute name
      // to make it more readable for the user
      formatLabel: function(attrName, model) {
        return defaultLabelFormatters[defaultOptions.labelFormatter](attrName, model);
      },
  
      // Replaces nummeric placeholders like {0} in a string with arguments
      // passed to the function
      format: function() {
        var args = Array.prototype.slice.call(arguments),
            text = args.shift();
        return text.replace(/\{(\d+)\}/g, function(match, number) {
          return typeof args[number] !== 'undefined' ? args[number] : match;
        });
      }
    };
  
    // Flattens an object
    // eg:
    //
    //     var o = {
    //       owner: {
    //         name: 'Backbone',
    //         address: {
    //           street: 'Street',
    //           zip: 1234
    //         }
    //       }
    //     };
    //
    // becomes:
    //
    //     var o = {
    //       'owner': {
    //         name: 'Backbone',
    //         address: {
    //           street: 'Street',
    //           zip: 1234
    //         }
    //       },
    //       'owner.name': 'Backbone',
    //       'owner.address': {
    //         street: 'Street',
    //         zip: 1234
    //       },
    //       'owner.address.street': 'Street',
    //       'owner.address.zip': 1234
    //     };
    // This may seem redundant, but it allows for maximum flexibility
    // in validation rules.
    var flatten = function (obj, into, prefix) {
      into = into || {};
      prefix = prefix || '';
  
      _.each(obj, function(val, key) {
        if(obj.hasOwnProperty(key)) {
          if (!!val && _.isArray(val)) {
            _.forEach(val, function(v, k) {
              flatten(v, into, prefix + key + '.' + k + '.');
              into[prefix + key + '.' + k] = v;
            });
          } else if (!!val && typeof val === 'object' && val.constructor === Object) {
            flatten(val, into, prefix + key + '.');
          }
  
          // Register the current level object as well
          into[prefix + key] = val;
        }
      });
  
      return into;
    };
  
    // Validation
    // ----------
  
    var Validation = (function(){
  
      // Returns an object with undefined properties for all
      // attributes on the model that has defined one or more
      // validation rules.
      var getValidatedAttrs = function(model, attrs) {
        attrs = attrs || _.keys(_.result(model, 'validation') || {});
        return _.reduce(attrs, function(memo, key) {
          memo[key] = void 0;
          return memo;
        }, {});
      };
  
      // Returns an array with attributes passed through options
      var getOptionsAttrs = function(options, view) {
        var attrs = options.attributes;
        if (_.isFunction(attrs)) {
          attrs = attrs(view);
        } else if (_.isString(attrs) && (_.isFunction(defaultAttributeLoaders[attrs]))) {
          attrs = defaultAttributeLoaders[attrs](view);
        }
        if (_.isArray(attrs)) {
          return attrs;
        }
      };
  
  
      // Looks on the model for validations for a specified
      // attribute. Returns an array of any validators defined,
      // or an empty array if none is defined.
      var getValidators = function(model, attr) {
        var attrValidationSet = model.validation ? _.result(model, 'validation')[attr] || {} : {};
  
        // If the validator is a function or a string, wrap it in a function validator
        if (_.isFunction(attrValidationSet) || _.isString(attrValidationSet)) {
          attrValidationSet = {
            fn: attrValidationSet
          };
        }
  
        // Stick the validator object into an array
        if(!_.isArray(attrValidationSet)) {
          attrValidationSet = [attrValidationSet];
        }
  
        // Reduces the array of validators into a new array with objects
        // with a validation method to call, the value to validate against
        // and the specified error message, if any
        return _.reduce(attrValidationSet, function(memo, attrValidation) {
          _.each(_.without(_.keys(attrValidation), 'msg'), function(validator) {
            memo.push({
              fn: defaultValidators[validator],
              val: attrValidation[validator],
              msg: attrValidation.msg
            });
          });
          return memo;
        }, []);
      };
  
      // Validates an attribute against all validators defined
      // for that attribute. If one or more errors are found,
      // the first error message is returned.
      // If the attribute is valid, an empty string is returned.
      var validateAttr = function(model, attr, value, computed) {
        // Reduces the array of validators to an error message by
        // applying all the validators and returning the first error
        // message, if any.
        return _.reduce(getValidators(model, attr), function(memo, validator){
          // Pass the format functions plus the default
          // validators as the context to the validator
          var ctx = _.extend({}, formatFunctions, defaultValidators),
              result = validator.fn.call(ctx, value, attr, validator.val, model, computed);
  
          if(result === false || memo === false) {
            return false;
          }
          if (result && !memo) {
            return _.result(validator, 'msg') || result;
          }
          return memo;
        }, '');
      };
  
      // Loops through the model's attributes and validates the specified attrs.
      // Returns and object containing names of invalid attributes
      // as well as error messages.
      var validateModel = function(model, attrs, validatedAttrs) {
        var error,
            invalidAttrs = {},
            isValid = true,
            computed = _.clone(attrs);
  
        _.each(validatedAttrs, function(val, attr) {
          error = validateAttr(model, attr, val, computed);
          if (error) {
            invalidAttrs[attr] = error;
            isValid = false;
          }
        });
  
        return {
          invalidAttrs: invalidAttrs,
          isValid: isValid
        };
      };
  
      // Contains the methods that are mixed in on the model when binding
      var mixin = function(view, options) {
        return {
  
          // Check whether or not a value, or a hash of values
          // passes validation without updating the model
          preValidate: function(attr, value) {
            var self = this,
                result = {},
                error;
  
            if(_.isObject(attr)){
              _.each(attr, function(value, key) {
                error = self.preValidate(key, value);
                if(error){
                  result[key] = error;
                }
              });
  
              return _.isEmpty(result) ? undefined : result;
            }
            else {
              return validateAttr(this, attr, value, _.extend({}, this.attributes));
            }
          },
  
          // Check to see if an attribute, an array of attributes or the
          // entire model is valid. Passing true will force a validation
          // of the model.
          isValid: function(option) {
            var flattened, attrs, error, invalidAttrs;
  
            option = option || getOptionsAttrs(options, view);
  
            if(_.isString(option)){
              attrs = [option];
            } else if(_.isArray(option)) {
              attrs = option;
            }
            if (attrs) {
              flattened = flatten(this.attributes);
              //Loop through all associated views
              _.each(this.associatedViews, function(view) {
                _.each(attrs, function (attr) {
                  error = validateAttr(this, attr, flattened[attr], _.extend({}, this.attributes));
                  if (error) {
                    options.invalid(view, attr, error, options.selector);
                    invalidAttrs = invalidAttrs || {};
                    invalidAttrs[attr] = error;
                  } else {
                    options.valid(view, attr, options.selector);
                  }
                }, this);
              }, this);
            }
  
            if(option === true) {
              invalidAttrs = this.validate();
            }
            if (invalidAttrs) {
              this.trigger('invalid', this, invalidAttrs, {validationError: invalidAttrs});
            }
            return attrs ? !invalidAttrs : this.validation ? this._isValid : true;
          },
  
          // This is called by Backbone when it needs to perform validation.
          // You can call it manually without any parameters to validate the
          // entire model.
          validate: function(attrs, setOptions){
            var model = this,
                validateAll = !attrs,
                opt = _.extend({}, options, setOptions),
                validatedAttrs = getValidatedAttrs(model, getOptionsAttrs(options, view)),
                allAttrs = _.extend({}, validatedAttrs, model.attributes, attrs),
                flattened = flatten(allAttrs),
                changedAttrs = attrs ? flatten(attrs) : flattened,
                result = validateModel(model, allAttrs, _.pick(flattened, _.keys(validatedAttrs)));
  
            model._isValid = result.isValid;
  
            //After validation is performed, loop through all associated views
            _.each(model.associatedViews, function(view){
  
              // After validation is performed, loop through all validated and changed attributes
              // and call the valid and invalid callbacks so the view is updated.
              _.each(validatedAttrs, function(val, attr){
                  var invalid = result.invalidAttrs.hasOwnProperty(attr),
                    changed = changedAttrs.hasOwnProperty(attr);
  
                  if(!invalid){
                    opt.valid(view, attr, opt.selector);
                  }
                  if(invalid && (changed || validateAll)){
                    opt.invalid(view, attr, result.invalidAttrs[attr], opt.selector);
                  }
              });
            });
  
            // Trigger validated events.
            // Need to defer this so the model is actually updated before
            // the event is triggered.
            _.defer(function() {
              model.trigger('validated', model._isValid, model, result.invalidAttrs);
              model.trigger('validated:' + (model._isValid ? 'valid' : 'invalid'), model, result.invalidAttrs);
            });
  
            // Return any error messages to Backbone, unless the forceUpdate flag is set.
            // Then we do not return anything and fools Backbone to believe the validation was
            // a success. That way Backbone will update the model regardless.
            if (!opt.forceUpdate && _.intersection(_.keys(result.invalidAttrs), _.keys(changedAttrs)).length > 0) {
              return result.invalidAttrs;
            }
          }
        };
      };
  
      // Helper to mix in validation on a model. Stores the view in the associated views array.
      var bindModel = function(view, model, options) {
        if (model.associatedViews) {
          model.associatedViews.push(view);
        } else {
          model.associatedViews = [view];
        }
        _.extend(model, mixin(view, options));
      };
  
      // Removes view from associated views of the model or the methods
      // added to a model if no view or single view provided
      var unbindModel = function(model, view) {
        if (view && model.associatedViews && model.associatedViews.length > 1){
          model.associatedViews = _.without(model.associatedViews, view);
        } else {
          delete model.validate;
          delete model.preValidate;
          delete model.isValid;
          delete model.associatedViews;
        }
      };
  
      // Mix in validation on a model whenever a model is
      // added to a collection
      var collectionAdd = function(model) {
        bindModel(this.view, model, this.options);
      };
  
      // Remove validation from a model whenever a model is
      // removed from a collection
      var collectionRemove = function(model) {
        unbindModel(model);
      };
  
      // Returns the public methods on Backbone.Validation
      return {
  
        // Current version of the library
        version: '0.11.3',
  
        // Called to configure the default options
        configure: function(options) {
          _.extend(defaultOptions, options);
        },
  
        // Hooks up validation on a view with a model
        // or collection
        bind: function(view, options) {
          options = _.extend({}, defaultOptions, defaultCallbacks, options);
  
          var model = options.model || view.model,
              collection = options.collection || view.collection;
  
          if(typeof model === 'undefined' && typeof collection === 'undefined'){
            throw 'Before you execute the binding your view must have a model or a collection.\n' +
                  'See http://thedersen.com/projects/backbone-validation/#using-form-model-validation for more information.';
          }
  
          if(model) {
            bindModel(view, model, options);
          }
          else if(collection) {
            collection.each(function(model){
              bindModel(view, model, options);
            });
            collection.bind('add', collectionAdd, {view: view, options: options});
            collection.bind('remove', collectionRemove);
          }
        },
  
        // Removes validation from a view with a model
        // or collection
        unbind: function(view, options) {
          options = _.extend({}, options);
          var model = options.model || view.model,
              collection = options.collection || view.collection;
  
          if(model) {
            unbindModel(model, view);
          }
          else if(collection) {
            collection.each(function(model){
              unbindModel(model, view);
            });
            collection.unbind('add', collectionAdd);
            collection.unbind('remove', collectionRemove);
          }
        },
  
        // Used to extend the Backbone.Model.prototype
        // with validation
        mixin: mixin(null, defaultOptions)
      };
    }());
  
  
    // Callbacks
    // ---------
  
    var defaultCallbacks = Validation.callbacks = {
  
      // Gets called when a previously invalid field in the
      // view becomes valid. Removes any error message.
      // Should be overridden with custom functionality.
      valid: function(view, attr, selector) {
        view.$('[' + selector + '~="' + attr + '"]')
            .removeClass('invalid')
            .removeAttr('data-error');
      },
  
      // Gets called when a field in the view becomes invalid.
      // Adds a error message.
      // Should be overridden with custom functionality.
      invalid: function(view, attr, error, selector) {
        view.$('[' + selector + '~="' + attr + '"]')
            .addClass('invalid')
            .attr('data-error', error);
      }
    };
  
  
    // Patterns
    // --------
  
    var defaultPatterns = Validation.patterns = {
      // Matches any digit(s) (i.e. 0-9)
      digits: /^\d+$/,
  
      // Matches any number (e.g. 100.000)
      number: /^-?(?:\d+|\d{1,3}(?:,\d{3})+)(?:\.\d+)?$/,
  
      // Matches a valid email address (e.g. mail@example.com)
      email: /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i,
  
      // Mathes any valid url (e.g. http://www.xample.com)
      url: /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i
    };
  
  
    // Error messages
    // --------------
  
    // Error message for the build in validators.
    // {x} gets swapped out with arguments form the validator.
    var defaultMessages = Validation.messages = {
      required: '{0} is required',
      acceptance: '{0} must be accepted',
      min: '{0} must be greater than or equal to {1}',
      max: '{0} must be less than or equal to {1}',
      range: '{0} must be between {1} and {2}',
      length: '{0} must be {1} characters',
      minLength: '{0} must be at least {1} characters',
      maxLength: '{0} must be at most {1} characters',
      rangeLength: '{0} must be between {1} and {2} characters',
      oneOf: '{0} must be one of: {1}',
      equalTo: '{0} must be the same as {1}',
      digits: '{0} must only contain digits',
      number: '{0} must be a number',
      email: '{0} must be a valid email',
      url: '{0} must be a valid url',
      inlinePattern: '{0} is invalid'
    };
  
    // Label formatters
    // ----------------
  
    // Label formatters are used to convert the attribute name
    // to a more human friendly label when using the built in
    // error messages.
    // Configure which one to use with a call to
    //
    //     Backbone.Validation.configure({
    //       labelFormatter: 'label'
    //     });
    var defaultLabelFormatters = Validation.labelFormatters = {
  
      // Returns the attribute name with applying any formatting
      none: function(attrName) {
        return attrName;
      },
  
      // Converts attributeName or attribute_name to Attribute name
      sentenceCase: function(attrName) {
        return attrName.replace(/(?:^\w|[A-Z]|\b\w)/g, function(match, index) {
          return index === 0 ? match.toUpperCase() : ' ' + match.toLowerCase();
        }).replace(/_/g, ' ');
      },
  
      // Looks for a label configured on the model and returns it
      //
      //      var Model = Backbone.Model.extend({
      //        validation: {
      //          someAttribute: {
      //            required: true
      //          }
      //        },
      //
      //        labels: {
      //          someAttribute: 'Custom label'
      //        }
      //      });
      label: function(attrName, model) {
        return (model.labels && model.labels[attrName]) || defaultLabelFormatters.sentenceCase(attrName, model);
      }
    };
  
    // AttributeLoaders
  
    var defaultAttributeLoaders = Validation.attributeLoaders = {
      inputNames: function (view) {
        var attrs = [];
        if (view) {
          view.$('form [name]').each(function () {
            if (/^(?:input|select|textarea)$/i.test(this.nodeName) && this.name &&
              this.type !== 'submit' && attrs.indexOf(this.name) === -1) {
              attrs.push(this.name);
            }
          });
        }
        return attrs;
      }
    };
  
  
    // Built in validators
    // -------------------
  
    var defaultValidators = Validation.validators = (function(){
      // Use native trim when defined
      var trim = String.prototype.trim ?
        function(text) {
          return text === null ? '' : String.prototype.trim.call(text);
        } :
        function(text) {
          var trimLeft = /^\s+/,
              trimRight = /\s+$/;
  
          return text === null ? '' : text.toString().replace(trimLeft, '').replace(trimRight, '');
        };
  
      // Determines whether or not a value is a number
      var isNumber = function(value){
        return _.isNumber(value) || (_.isString(value) && value.match(defaultPatterns.number));
      };
  
      // Determines whether or not a value is empty
      var hasValue = function(value) {
        return !(_.isNull(value) || _.isUndefined(value) || (_.isString(value) && trim(value) === '') || (_.isArray(value) && _.isEmpty(value)));
      };
  
      return {
        // Function validator
        // Lets you implement a custom function used for validation
        fn: function(value, attr, fn, model, computed) {
          if(_.isString(fn)){
            fn = model[fn];
          }
          return fn.call(model, value, attr, computed);
        },
  
        // Required validator
        // Validates if the attribute is required or not
        // This can be specified as either a boolean value or a function that returns a boolean value
        required: function(value, attr, required, model, computed) {
          var isRequired = _.isFunction(required) ? required.call(model, value, attr, computed) : required;
          if(!isRequired && !hasValue(value)) {
            return false; // overrides all other validators
          }
          if (isRequired && !hasValue(value)) {
            return this.format(defaultMessages.required, this.formatLabel(attr, model));
          }
        },
  
        // Acceptance validator
        // Validates that something has to be accepted, e.g. terms of use
        // `true` or 'true' are valid
        acceptance: function(value, attr, accept, model) {
          if(value !== 'true' && (!_.isBoolean(value) || value === false)) {
            return this.format(defaultMessages.acceptance, this.formatLabel(attr, model));
          }
        },
  
        // Min validator
        // Validates that the value has to be a number and equal to or greater than
        // the min value specified
        min: function(value, attr, minValue, model) {
          if (!isNumber(value) || value < minValue) {
            return this.format(defaultMessages.min, this.formatLabel(attr, model), minValue);
          }
        },
  
        // Max validator
        // Validates that the value has to be a number and equal to or less than
        // the max value specified
        max: function(value, attr, maxValue, model) {
          if (!isNumber(value) || value > maxValue) {
            return this.format(defaultMessages.max, this.formatLabel(attr, model), maxValue);
          }
        },
  
        // Range validator
        // Validates that the value has to be a number and equal to or between
        // the two numbers specified
        range: function(value, attr, range, model) {
          if(!isNumber(value) || value < range[0] || value > range[1]) {
            return this.format(defaultMessages.range, this.formatLabel(attr, model), range[0], range[1]);
          }
        },
  
        // Length validator
        // Validates that the value has to be a string with length equal to
        // the length value specified
        length: function(value, attr, length, model) {
          if (!_.isString(value) || value.length !== length) {
            return this.format(defaultMessages.length, this.formatLabel(attr, model), length);
          }
        },
  
        // Min length validator
        // Validates that the value has to be a string with length equal to or greater than
        // the min length value specified
        minLength: function(value, attr, minLength, model) {
          if (!_.isString(value) || value.length < minLength) {
            return this.format(defaultMessages.minLength, this.formatLabel(attr, model), minLength);
          }
        },
  
        // Max length validator
        // Validates that the value has to be a string with length equal to or less than
        // the max length value specified
        maxLength: function(value, attr, maxLength, model) {
          if (!_.isString(value) || value.length > maxLength) {
            return this.format(defaultMessages.maxLength, this.formatLabel(attr, model), maxLength);
          }
        },
  
        // Range length validator
        // Validates that the value has to be a string and equal to or between
        // the two numbers specified
        rangeLength: function(value, attr, range, model) {
          if (!_.isString(value) || value.length < range[0] || value.length > range[1]) {
            return this.format(defaultMessages.rangeLength, this.formatLabel(attr, model), range[0], range[1]);
          }
        },
  
        // One of validator
        // Validates that the value has to be equal to one of the elements in
        // the specified array. Case sensitive matching
        oneOf: function(value, attr, values, model) {
          if(!_.include(values, value)){
            return this.format(defaultMessages.oneOf, this.formatLabel(attr, model), values.join(', '));
          }
        },
  
        // Equal to validator
        // Validates that the value has to be equal to the value of the attribute
        // with the name specified
        equalTo: function(value, attr, equalTo, model, computed) {
          if(value !== computed[equalTo]) {
            return this.format(defaultMessages.equalTo, this.formatLabel(attr, model), this.formatLabel(equalTo, model));
          }
        },
  
        // Pattern validator
        // Validates that the value has to match the pattern specified.
        // Can be a regular expression or the name of one of the built in patterns
        pattern: function(value, attr, pattern, model) {
          if (!hasValue(value) || !value.toString().match(defaultPatterns[pattern] || pattern)) {
            return this.format(defaultMessages[pattern] || defaultMessages.inlinePattern, this.formatLabel(attr, model), pattern);
          }
        }
      };
    }());
  
    // Set the correct context for all validators
    // when used from within a method validator
    _.each(defaultValidators, function(validator, key){
      defaultValidators[key] = _.bind(defaultValidators[key], _.extend({}, formatFunctions, defaultValidators));
    });
  
    return Validation;
  }(_));
  return Backbone.Validation;
}));

/***/ }),

/***/ "./node_modules/backbone.marionette/lib/backbone.marionette.js":
/*!*********************************************************************!*\
  !*** ./node_modules/backbone.marionette/lib/backbone.marionette.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/**
* @license
* MarionetteJS (Backbone.Marionette)
* ----------------------------------
* v4.1.2
*
* Copyright (c)2019 Derick Bailey, Muted Solutions, LLC.
* Distributed under MIT license
*
* http://marionettejs.com
*/


(function (global, factory) {
   true ? factory(exports, __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js"), __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js"), __webpack_require__(/*! backbone.radio */ "./node_modules/backbone.radio/build/backbone.radio.js")) :
  0;
}(this, function (exports, Backbone, _, Radio) { 'use strict';

  Backbone = Backbone && Backbone.hasOwnProperty('default') ? Backbone['default'] : Backbone;
  _ = _ && _.hasOwnProperty('default') ? _['default'] : _;
  Radio = Radio && Radio.hasOwnProperty('default') ? Radio['default'] : Radio;

  var version = "4.1.2";

  //Internal utility for creating context style global utils
  var proxy = function proxy(method) {
    return function (context) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return method.apply(context, args);
    };
  };

  // Marionette.extend

  var extend = Backbone.Model.extend;

  // ----------------------
  // Pass in a mapping of events => functions or function names
  // and return a mapping of events => functions

  var normalizeMethods = function normalizeMethods(hash) {
    var _this = this;

    if (!hash) {
      return;
    }

    return _.reduce(hash, function (normalizedHash, method, name) {
      if (!_.isFunction(method)) {
        method = _this[method];
      }

      if (method) {
        normalizedHash[name] = method;
      }

      return normalizedHash;
    }, {});
  };

  // Error
  var errorProps = ['description', 'fileName', 'lineNumber', 'name', 'message', 'number', 'url'];
  var MarionetteError = extend.call(Error, {
    urlRoot: "http://marionettejs.com/docs/v".concat(version, "/"),
    url: '',
    constructor: function constructor(options) {
      var error = Error.call(this, options.message);

      _.extend(this, _.pick(error, errorProps), _.pick(options, errorProps));

      if (Error.captureStackTrace) {
        this.captureStackTrace();
      }

      this.url = this.urlRoot + this.url;
    },
    captureStackTrace: function captureStackTrace() {
      Error.captureStackTrace(this, MarionetteError);
    },
    toString: function toString() {
      return "".concat(this.name, ": ").concat(this.message, " See: ").concat(this.url);
    }
  });

  // Bind Entity Events & Unbind Entity Events

  function normalizeBindings(context, bindings) {
    if (!_.isObject(bindings)) {
      throw new MarionetteError({
        message: 'Bindings must be an object.',
        url: 'common.html#bindevents'
      });
    }

    return normalizeMethods.call(context, bindings);
  }

  function bindEvents(entity, bindings) {
    if (!entity || !bindings) {
      return this;
    }

    this.listenTo(entity, normalizeBindings(this, bindings));
    return this;
  }

  function unbindEvents(entity, bindings) {
    if (!entity) {
      return this;
    }

    if (!bindings) {
      this.stopListening(entity);
      return this;
    }

    this.stopListening(entity, normalizeBindings(this, bindings));
    return this;
  } // Export Public API

  // Bind/Unbind Radio Requests

  function normalizeBindings$1(context, bindings) {
    if (!_.isObject(bindings)) {
      throw new MarionetteError({
        message: 'Bindings must be an object.',
        url: 'common.html#bindrequests'
      });
    }

    return normalizeMethods.call(context, bindings);
  }

  function bindRequests(channel, bindings) {
    if (!channel || !bindings) {
      return this;
    }

    channel.reply(normalizeBindings$1(this, bindings), this);
    return this;
  }

  function unbindRequests(channel, bindings) {
    if (!channel) {
      return this;
    }

    if (!bindings) {
      channel.stopReplying(null, null, this);
      return this;
    }

    channel.stopReplying(normalizeBindings$1(this, bindings));
    return this;
  }

  // Marionette.getOption
  // --------------------
  // Retrieve an object, function or other value from the
  // object or its `options`, with `options` taking precedence.
  var getOption = function getOption(optionName) {
    if (!optionName) {
      return;
    }

    if (this.options && this.options[optionName] !== undefined) {
      return this.options[optionName];
    } else {
      return this[optionName];
    }
  };

  var mergeOptions = function mergeOptions(options, keys) {
    var _this = this;

    if (!options) {
      return;
    }

    _.each(keys, function (key) {
      var option = options[key];

      if (option !== undefined) {
        _this[key] = option;
      }
    });
  };

  // DOM Refresh

  function triggerMethodChildren(view, event, shouldTrigger) {
    if (!view._getImmediateChildren) {
      return;
    }

    _.each(view._getImmediateChildren(), function (child) {
      if (!shouldTrigger(child)) {
        return;
      }

      child.triggerMethod(event, child);
    });
  }

  function shouldTriggerAttach(view) {
    return !view._isAttached;
  }

  function shouldAttach(view) {
    if (!shouldTriggerAttach(view)) {
      return false;
    }

    view._isAttached = true;
    return true;
  }

  function shouldTriggerDetach(view) {
    return view._isAttached;
  }

  function shouldDetach(view) {
    view._isAttached = false;
    return true;
  }

  function triggerDOMRefresh(view) {
    if (view._isAttached && view._isRendered) {
      view.triggerMethod('dom:refresh', view);
    }
  }

  function triggerDOMRemove(view) {
    if (view._isAttached && view._isRendered) {
      view.triggerMethod('dom:remove', view);
    }
  }

  function handleBeforeAttach() {
    triggerMethodChildren(this, 'before:attach', shouldTriggerAttach);
  }

  function handleAttach() {
    triggerMethodChildren(this, 'attach', shouldAttach);
    triggerDOMRefresh(this);
  }

  function handleBeforeDetach() {
    triggerMethodChildren(this, 'before:detach', shouldTriggerDetach);
    triggerDOMRemove(this);
  }

  function handleDetach() {
    triggerMethodChildren(this, 'detach', shouldDetach);
  }

  function handleBeforeRender() {
    triggerDOMRemove(this);
  }

  function handleRender() {
    triggerDOMRefresh(this);
  } // Monitor a view's state, propagating attach/detach events to children and firing dom:refresh
  // whenever a rendered view is attached or an attached view is rendered.


  function monitorViewEvents(view) {
    if (view._areViewEventsMonitored || view.monitorViewEvents === false) {
      return;
    }

    view._areViewEventsMonitored = true;
    view.on({
      'before:attach': handleBeforeAttach,
      'attach': handleAttach,
      'before:detach': handleBeforeDetach,
      'detach': handleDetach,
      'before:render': handleBeforeRender,
      'render': handleRender
    });
  }

  // Trigger Method

  var splitter = /(^|:)(\w)/gi; // Only calc getOnMethodName once

  var methodCache = {}; // take the event section ("section1:section2:section3")
  // and turn it in to uppercase name onSection1Section2Section3

  function getEventName(match, prefix, eventName) {
    return eventName.toUpperCase();
  }

  var getOnMethodName = function getOnMethodName(event) {
    if (!methodCache[event]) {
      methodCache[event] = 'on' + event.replace(splitter, getEventName);
    }

    return methodCache[event];
  }; // Trigger an event and/or a corresponding method name. Examples:
  //
  // `this.triggerMethod("foo")` will trigger the "foo" event and
  // call the "onFoo" method.
  //
  // `this.triggerMethod("foo:bar")` will trigger the "foo:bar" event and
  // call the "onFooBar" method.


  function triggerMethod(event) {
    // get the method name from the event name
    var methodName = getOnMethodName(event);
    var method = getOption.call(this, methodName);
    var result; // call the onMethodName if it exists

    if (_.isFunction(method)) {
      // pass all args, except the event name
      result = method.apply(this, _.drop(arguments));
    } // trigger the event


    this.trigger.apply(this, arguments);
    return result;
  }

  var Events = {
    triggerMethod: triggerMethod
  };

  var CommonMixin = {
    // Imports the "normalizeMethods" to transform hashes of
    // events=>function references/names to a hash of events=>function references
    normalizeMethods: normalizeMethods,
    _setOptions: function _setOptions(options, classOptions) {
      this.options = _.extend({}, _.result(this, 'options'), options);
      this.mergeOptions(options, classOptions);
    },
    // A handy way to merge passed-in options onto the instance
    mergeOptions: mergeOptions,
    // Enable getting options from this or this.options by name.
    getOption: getOption,
    // Enable binding view's events from another entity.
    bindEvents: bindEvents,
    // Enable unbinding view's events from another entity.
    unbindEvents: unbindEvents,
    // Enable binding view's requests.
    bindRequests: bindRequests,
    // Enable unbinding view's requests.
    unbindRequests: unbindRequests,
    triggerMethod: triggerMethod
  };

  _.extend(CommonMixin, Backbone.Events);

  var DestroyMixin = {
    _isDestroyed: false,
    isDestroyed: function isDestroyed() {
      return this._isDestroyed;
    },
    destroy: function destroy(options) {
      if (this._isDestroyed) {
        return this;
      }

      this.triggerMethod('before:destroy', this, options);
      this._isDestroyed = true;
      this.triggerMethod('destroy', this, options);
      this.stopListening();
      return this;
    }
  };

  // - channelName
  // - radioEvents
  // - radioRequests

  var RadioMixin = {
    _initRadio: function _initRadio() {
      var channelName = _.result(this, 'channelName');

      if (!channelName) {
        return;
      }
      /* istanbul ignore next */


      if (!Radio) {
        throw new MarionetteError({
          message: 'The dependency "backbone.radio" is missing.',
          url: 'backbone.radio.html#marionette-integration'
        });
      }

      var channel = this._channel = Radio.channel(channelName);

      var radioEvents = _.result(this, 'radioEvents');

      this.bindEvents(channel, radioEvents);

      var radioRequests = _.result(this, 'radioRequests');

      this.bindRequests(channel, radioRequests);
      this.on('destroy', this._destroyRadio);
    },
    _destroyRadio: function _destroyRadio() {
      this._channel.stopReplying(null, null, this);
    },
    getChannel: function getChannel() {
      return this._channel;
    }
  };

  // Object
  var ClassOptions = ['channelName', 'radioEvents', 'radioRequests']; // Object borrows many conventions and utilities from Backbone.

  var MarionetteObject = function MarionetteObject(options) {
    this._setOptions(options, ClassOptions);

    this.cid = _.uniqueId(this.cidPrefix);

    this._initRadio();

    this.initialize.apply(this, arguments);
  };

  MarionetteObject.extend = extend; // Object Methods
  // --------------

  _.extend(MarionetteObject.prototype, CommonMixin, DestroyMixin, RadioMixin, {
    cidPrefix: 'mno',
    // This is a noop method intended to be overridden
    initialize: function initialize() {}
  });

  // Implementation of the invoke method (http://underscorejs.org/#invoke) with support for
  var _invoke = _.invokeMap || _.invoke;

  // - behaviors
  // Takes care of getting the behavior class
  // given options and a key.
  // If a user passes in options.behaviorClass
  // default to using that.
  // If a user passes in a Behavior Class directly, use that
  // Otherwise an error is thrown

  function getBehaviorClass(options) {
    if (options.behaviorClass) {
      return {
        BehaviorClass: options.behaviorClass,
        options: options
      };
    } //treat functions as a Behavior constructor


    if (_.isFunction(options)) {
      return {
        BehaviorClass: options,
        options: {}
      };
    }

    throw new MarionetteError({
      message: 'Unable to get behavior class. A Behavior constructor should be passed directly or as behaviorClass property of options',
      url: 'marionette.behavior.html#defining-and-attaching-behaviors'
    });
  } // Iterate over the behaviors object, for each behavior
  // instantiate it and get its grouped behaviors.
  // This accepts a list of behaviors in either an object or array form


  function parseBehaviors(view, behaviors, allBehaviors) {
    return _.reduce(behaviors, function (reducedBehaviors, behaviorDefiniton) {
      var _getBehaviorClass = getBehaviorClass(behaviorDefiniton),
          BehaviorClass = _getBehaviorClass.BehaviorClass,
          options = _getBehaviorClass.options;

      var behavior = new BehaviorClass(options, view);
      reducedBehaviors.push(behavior);
      return parseBehaviors(view, _.result(behavior, 'behaviors'), reducedBehaviors);
    }, allBehaviors);
  }

  var BehaviorsMixin = {
    _initBehaviors: function _initBehaviors() {
      this._behaviors = parseBehaviors(this, _.result(this, 'behaviors'), []);
    },
    _getBehaviorTriggers: function _getBehaviorTriggers() {
      var triggers = _invoke(this._behaviors, '_getTriggers');

      return _.reduce(triggers, function (memo, _triggers) {
        return _.extend(memo, _triggers);
      }, {});
    },
    _getBehaviorEvents: function _getBehaviorEvents() {
      var events = _invoke(this._behaviors, '_getEvents');

      return _.reduce(events, function (memo, _events) {
        return _.extend(memo, _events);
      }, {});
    },
    // proxy behavior $el to the view's $el.
    _proxyBehaviorViewProperties: function _proxyBehaviorViewProperties() {
      _invoke(this._behaviors, 'proxyViewProperties');
    },
    // delegate modelEvents and collectionEvents
    _delegateBehaviorEntityEvents: function _delegateBehaviorEntityEvents() {
      _invoke(this._behaviors, 'delegateEntityEvents');
    },
    // undelegate modelEvents and collectionEvents
    _undelegateBehaviorEntityEvents: function _undelegateBehaviorEntityEvents() {
      _invoke(this._behaviors, 'undelegateEntityEvents');
    },
    _destroyBehaviors: function _destroyBehaviors(options) {
      // Call destroy on each behavior after
      // destroying the view.
      // This unbinds event listeners
      // that behaviors have registered for.
      _invoke(this._behaviors, 'destroy', options);
    },
    // Remove a behavior
    _removeBehavior: function _removeBehavior(behavior) {
      // Don't worry about the clean up if the view is destroyed
      if (this._isDestroyed) {
        return;
      } // Remove behavior-only triggers and events


      this.undelegate(".trig".concat(behavior.cid, " .").concat(behavior.cid));
      this._behaviors = _.without(this._behaviors, behavior);
    },
    _bindBehaviorUIElements: function _bindBehaviorUIElements() {
      _invoke(this._behaviors, 'bindUIElements');
    },
    _unbindBehaviorUIElements: function _unbindBehaviorUIElements() {
      _invoke(this._behaviors, 'unbindUIElements');
    },
    _triggerEventOnBehaviors: function _triggerEventOnBehaviors(eventName, view, options) {
      _invoke(this._behaviors, 'triggerMethod', eventName, view, options);
    }
  };

  // - collectionEvents
  // - modelEvents

  var DelegateEntityEventsMixin = {
    // Handle `modelEvents`, and `collectionEvents` configuration
    _delegateEntityEvents: function _delegateEntityEvents(model, collection) {
      if (model) {
        this._modelEvents = _.result(this, 'modelEvents');
        this.bindEvents(model, this._modelEvents);
      }

      if (collection) {
        this._collectionEvents = _.result(this, 'collectionEvents');
        this.bindEvents(collection, this._collectionEvents);
      }
    },
    // Remove any previously delegate entity events
    _undelegateEntityEvents: function _undelegateEntityEvents(model, collection) {
      if (this._modelEvents) {
        this.unbindEvents(model, this._modelEvents);
        delete this._modelEvents;
      }

      if (this._collectionEvents) {
        this.unbindEvents(collection, this._collectionEvents);
        delete this._collectionEvents;
      }
    },
    // Remove cached event handlers
    _deleteEntityEventHandlers: function _deleteEntityEventHandlers() {
      delete this._modelEvents;
      delete this._collectionEvents;
    }
  };

  // - template
  // - templateContext

  var TemplateRenderMixin = {
    // Internal method to render the template with the serialized data
    // and template context
    _renderTemplate: function _renderTemplate(template) {
      // Add in entity data and template context
      var data = this.mixinTemplateContext(this.serializeData()) || {}; // Render and add to el

      var html = this._renderHtml(template, data);

      if (typeof html !== 'undefined') {
        this.attachElContent(html);
      }
    },
    // Get the template for this view instance.
    // You can set a `template` attribute in the view definition
    // or pass a `template: TemplateFunction` parameter in
    // to the constructor options.
    getTemplate: function getTemplate() {
      return this.template;
    },
    // Mix in template context methods. Looks for a
    // `templateContext` attribute, which can either be an
    // object literal, or a function that returns an object
    // literal. All methods and attributes from this object
    // are copies to the object passed in.
    mixinTemplateContext: function mixinTemplateContext(serializedData) {
      var templateContext = _.result(this, 'templateContext');

      if (!templateContext) {
        return serializedData;
      }

      if (!serializedData) {
        return templateContext;
      }

      return _.extend({}, serializedData, templateContext);
    },
    // Serialize the view's model *or* collection, if
    // it exists, for the template
    serializeData: function serializeData() {
      // If we have a model, we serialize that
      if (this.model) {
        return this.serializeModel();
      } // Otherwise, we serialize the collection,
      // making it available under the `items` property


      if (this.collection) {
        return {
          items: this.serializeCollection()
        };
      }
    },
    // Prepares the special `model` property of a view
    // for being displayed in the template. Override this if
    // you need a custom transformation for your view's model
    serializeModel: function serializeModel() {
      return this.model.attributes;
    },
    // Serialize a collection
    serializeCollection: function serializeCollection() {
      return _.map(this.collection.models, function (model) {
        return model.attributes;
      });
    },
    // Renders the data into the template
    _renderHtml: function _renderHtml(template, data) {
      return template(data);
    },
    // Attaches the content of a given view.
    // This method can be overridden to optimize rendering,
    // or to render in a non standard way.
    //
    // For example, using `innerHTML` instead of `$el.html`
    //
    // ```js
    // attachElContent(html) {
    //   this.el.innerHTML = html;
    // }
    // ```
    attachElContent: function attachElContent(html) {
      this.Dom.setContents(this.el, html, this.$el);
    }
  };

  // Borrow event splitter from Backbone
  var delegateEventSplitter = /^(\S+)\s*(.*)$/; // Set event name to be namespaced using a unique index
  // to generate a non colliding event namespace
  // http://api.jquery.com/event.namespace/

  var getNamespacedEventName = function getNamespacedEventName(eventName, namespace) {
    var match = eventName.match(delegateEventSplitter);
    return "".concat(match[1], ".").concat(namespace, " ").concat(match[2]);
  };

  // Add Feature flags here
  // e.g. 'class' => false
  var FEATURES = {
    childViewEventPrefix: false,
    triggersStopPropagation: true,
    triggersPreventDefault: true,
    DEV_MODE: false
  };

  function isEnabled(name) {
    return !!FEATURES[name];
  }

  function setEnabled(name, state) {
    return FEATURES[name] = state;
  }

  // 'click:foo'

  function buildViewTrigger(view, triggerDef) {
    if (_.isString(triggerDef)) {
      triggerDef = {
        event: triggerDef
      };
    }

    var eventName = triggerDef.event;
    var shouldPreventDefault = !!triggerDef.preventDefault;

    if (isEnabled('triggersPreventDefault')) {
      shouldPreventDefault = triggerDef.preventDefault !== false;
    }

    var shouldStopPropagation = !!triggerDef.stopPropagation;

    if (isEnabled('triggersStopPropagation')) {
      shouldStopPropagation = triggerDef.stopPropagation !== false;
    }

    return function (event) {
      if (shouldPreventDefault) {
        event.preventDefault();
      }

      if (shouldStopPropagation) {
        event.stopPropagation();
      }

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      view.triggerMethod.apply(view, [eventName, view, event].concat(args));
    };
  }

  var TriggersMixin = {
    // Configure `triggers` to forward DOM events to view
    // events. `triggers: {"click .foo": "do:foo"}`
    _getViewTriggers: function _getViewTriggers(view, triggers) {
      var _this = this;

      // Configure the triggers, prevent default
      // action and stop propagation of DOM events
      return _.reduce(triggers, function (events, value, key) {
        key = getNamespacedEventName(key, "trig".concat(_this.cid));
        events[key] = buildViewTrigger(view, value);
        return events;
      }, {});
    }
  };

  // a given key for triggers and events
  // swaps the @ui with the associated selector.
  // Returns a new, non-mutated, parsed events hash.

  var _normalizeUIKeys = function normalizeUIKeys(hash, ui) {
    return _.reduce(hash, function (memo, val, key) {
      var normalizedKey = _normalizeUIString(key, ui);

      memo[normalizedKey] = val;
      return memo;
    }, {});
  };

  var uiRegEx = /@ui\.[a-zA-Z-_$0-9]*/g; // utility method for parsing @ui. syntax strings
  // into associated selector

  var _normalizeUIString = function normalizeUIString(uiString, ui) {
    return uiString.replace(uiRegEx, function (r) {
      return ui[r.slice(4)];
    });
  }; // allows for the use of the @ui. syntax within
  // a given value for regions
  // swaps the @ui with the associated selector


  var _normalizeUIValues = function normalizeUIValues(hash, ui, property) {
    _.each(hash, function (val, key) {
      if (_.isString(val)) {
        hash[key] = _normalizeUIString(val, ui);
      } else if (val) {
        var propertyVal = val[property];

        if (_.isString(propertyVal)) {
          val[property] = _normalizeUIString(propertyVal, ui);
        }
      }
    });

    return hash;
  };

  var UIMixin = {
    // normalize the keys of passed hash with the views `ui` selectors.
    // `{"@ui.foo": "bar"}`
    normalizeUIKeys: function normalizeUIKeys(hash) {
      var uiBindings = this._getUIBindings();

      return _normalizeUIKeys(hash, uiBindings);
    },
    // normalize the passed string with the views `ui` selectors.
    // `"@ui.bar"`
    normalizeUIString: function normalizeUIString(uiString) {
      var uiBindings = this._getUIBindings();

      return _normalizeUIString(uiString, uiBindings);
    },
    // normalize the values of passed hash with the views `ui` selectors.
    // `{foo: "@ui.bar"}`
    normalizeUIValues: function normalizeUIValues(hash, property) {
      var uiBindings = this._getUIBindings();

      return _normalizeUIValues(hash, uiBindings, property);
    },
    _getUIBindings: function _getUIBindings() {
      var uiBindings = _.result(this, '_uiBindings');

      return uiBindings || _.result(this, 'ui');
    },
    // This method binds the elements specified in the "ui" hash inside the view's code with
    // the associated jQuery selectors.
    _bindUIElements: function _bindUIElements() {
      var _this = this;

      if (!this.ui) {
        return;
      } // store the ui hash in _uiBindings so they can be reset later
      // and so re-rendering the view will be able to find the bindings


      if (!this._uiBindings) {
        this._uiBindings = this.ui;
      } // get the bindings result, as a function or otherwise


      var bindings = _.result(this, '_uiBindings'); // empty the ui so we don't have anything to start with


      this._ui = {}; // bind each of the selectors

      _.each(bindings, function (selector, key) {
        _this._ui[key] = _this.$(selector);
      });

      this.ui = this._ui;
    },
    _unbindUIElements: function _unbindUIElements() {
      var _this2 = this;

      if (!this.ui || !this._uiBindings) {
        return;
      } // delete all of the existing ui bindings


      _.each(this.ui, function ($el, name) {
        delete _this2.ui[name];
      }); // reset the ui element to the original bindings configuration


      this.ui = this._uiBindings;
      delete this._uiBindings;
      delete this._ui;
    },
    _getUI: function _getUI(name) {
      return this._ui[name];
    }
  };

  // DomApi

  function _getEl(el) {
    return el instanceof Backbone.$ ? el : Backbone.$(el);
  } // Static setter


  function setDomApi(mixin) {
    this.prototype.Dom = _.extend({}, this.prototype.Dom, mixin);
    return this;
  }
  var DomApi = {
    // Returns a new HTML DOM node instance
    createBuffer: function createBuffer() {
      return document.createDocumentFragment();
    },
    // Returns the document element for a given DOM element
    getDocumentEl: function getDocumentEl(el) {
      return el.ownerDocument.documentElement;
    },
    // Lookup the `selector` string
    // Selector may also be a DOM element
    // Returns an array-like object of nodes
    getEl: function getEl(selector) {
      return _getEl(selector);
    },
    // Finds the `selector` string with the el
    // Returns an array-like object of nodes
    findEl: function findEl(el, selector) {
      return _getEl(el).find(selector);
    },
    // Returns true if the el contains the node childEl
    hasEl: function hasEl(el, childEl) {
      return el.contains(childEl && childEl.parentNode);
    },
    // Detach `el` from the DOM without removing listeners
    detachEl: function detachEl(el) {
      var _$el = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _getEl(el);

      _$el.detach();
    },
    // Remove `oldEl` from the DOM and put `newEl` in its place
    replaceEl: function replaceEl(newEl, oldEl) {
      if (newEl === oldEl) {
        return;
      }

      var parent = oldEl.parentNode;

      if (!parent) {
        return;
      }

      parent.replaceChild(newEl, oldEl);
    },
    // Swaps the location of `el1` and `el2` in the DOM
    swapEl: function swapEl(el1, el2) {
      if (el1 === el2) {
        return;
      }

      var parent1 = el1.parentNode;
      var parent2 = el2.parentNode;

      if (!parent1 || !parent2) {
        return;
      }

      var next1 = el1.nextSibling;
      var next2 = el2.nextSibling;
      parent1.insertBefore(el2, next1);
      parent2.insertBefore(el1, next2);
    },
    // Replace the contents of `el` with the HTML string of `html`
    setContents: function setContents(el, html) {
      var _$el = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _getEl(el);

      _$el.html(html);
    },
    // Takes the DOM node `el` and appends the DOM node `contents`
    // to the end of the element's contents.
    appendContents: function appendContents(el, contents) {
      var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
          _ref$_$el = _ref._$el,
          _$el = _ref$_$el === void 0 ? _getEl(el) : _ref$_$el,
          _ref$_$contents = _ref._$contents,
          _$contents = _ref$_$contents === void 0 ? _getEl(contents) : _ref$_$contents;

      _$el.append(_$contents);
    },
    // Does the el have child nodes
    hasContents: function hasContents(el) {
      return !!el && el.hasChildNodes();
    },
    // Remove the inner contents of `el` from the DOM while leaving
    // `el` itself in the DOM.
    detachContents: function detachContents(el) {
      var _$el = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _getEl(el);

      _$el.contents().detach();
    }
  };

  // ViewMixin
  // - behaviors
  // - childViewEventPrefix
  // - childViewEvents
  // - childViewTriggers
  // - collectionEvents
  // - modelEvents
  // - triggers
  // - ui

  var ViewMixin = {
    Dom: DomApi,
    _isElAttached: function _isElAttached() {
      return !!this.el && this.Dom.hasEl(this.Dom.getDocumentEl(this.el), this.el);
    },
    supportsRenderLifecycle: true,
    supportsDestroyLifecycle: true,
    _isDestroyed: false,
    isDestroyed: function isDestroyed() {
      return !!this._isDestroyed;
    },
    _isRendered: false,
    isRendered: function isRendered() {
      return !!this._isRendered;
    },
    _isAttached: false,
    isAttached: function isAttached() {
      return !!this._isAttached;
    },
    // Overriding Backbone.View's `delegateEvents` to handle
    // `events` and `triggers`
    delegateEvents: function delegateEvents(events) {
      this._proxyBehaviorViewProperties();

      this._buildEventProxies();

      var combinedEvents = _.extend({}, this._getBehaviorEvents(), this._getEvents(events), this._getBehaviorTriggers(), this._getTriggers());

      Backbone.View.prototype.delegateEvents.call(this, combinedEvents);
      return this;
    },
    // Allows Backbone.View events to utilize `@ui.` selectors
    _getEvents: function _getEvents(events) {
      if (events) {
        return this.normalizeUIKeys(events);
      }

      if (!this.events) {
        return;
      }

      return this.normalizeUIKeys(_.result(this, 'events'));
    },
    // Configure `triggers` to forward DOM events to view
    // events. `triggers: {"click .foo": "do:foo"}`
    _getTriggers: function _getTriggers() {
      if (!this.triggers) {
        return;
      } // Allow `triggers` to be configured as a function


      var triggers = this.normalizeUIKeys(_.result(this, 'triggers')); // Configure the triggers, prevent default
      // action and stop propagation of DOM events

      return this._getViewTriggers(this, triggers);
    },
    // Handle `modelEvents`, and `collectionEvents` configuration
    delegateEntityEvents: function delegateEntityEvents() {
      this._delegateEntityEvents(this.model, this.collection); // bind each behaviors model and collection events


      this._delegateBehaviorEntityEvents();

      return this;
    },
    // Handle unbinding `modelEvents`, and `collectionEvents` configuration
    undelegateEntityEvents: function undelegateEntityEvents() {
      this._undelegateEntityEvents(this.model, this.collection); // unbind each behaviors model and collection events


      this._undelegateBehaviorEntityEvents();

      return this;
    },
    // Handle destroying the view and its children.
    destroy: function destroy(options) {
      if (this._isDestroyed || this._isDestroying) {
        return this;
      }

      this._isDestroying = true;
      var shouldTriggerDetach = this._isAttached && !this._disableDetachEvents;
      this.triggerMethod('before:destroy', this, options);

      if (shouldTriggerDetach) {
        this.triggerMethod('before:detach', this);
      } // unbind UI elements


      this.unbindUIElements(); // remove the view from the DOM

      this._removeElement();

      if (shouldTriggerDetach) {
        this._isAttached = false;
        this.triggerMethod('detach', this);
      } // remove children after the remove to prevent extra paints


      this._removeChildren();

      this._isDestroyed = true;
      this._isRendered = false; // Destroy behaviors after _isDestroyed flag

      this._destroyBehaviors(options);

      this._deleteEntityEventHandlers();

      this.triggerMethod('destroy', this, options);

      this._triggerEventOnBehaviors('destroy', this, options);

      this.stopListening();
      return this;
    },
    // Equates to this.$el.remove
    _removeElement: function _removeElement() {
      this.$el.off().removeData();
      this.Dom.detachEl(this.el, this.$el);
    },
    // This method binds the elements specified in the "ui" hash
    bindUIElements: function bindUIElements() {
      this._bindUIElements();

      this._bindBehaviorUIElements();

      return this;
    },
    // This method unbinds the elements specified in the "ui" hash
    unbindUIElements: function unbindUIElements() {
      this._unbindUIElements();

      this._unbindBehaviorUIElements();

      return this;
    },
    getUI: function getUI(name) {
      return this._getUI(name);
    },
    // Cache `childViewEvents` and `childViewTriggers`
    _buildEventProxies: function _buildEventProxies() {
      this._childViewEvents = this.normalizeMethods(_.result(this, 'childViewEvents'));
      this._childViewTriggers = _.result(this, 'childViewTriggers');
      this._eventPrefix = this._getEventPrefix();
    },
    _getEventPrefix: function _getEventPrefix() {
      var defaultPrefix = isEnabled('childViewEventPrefix') ? 'childview' : false;

      var prefix = _.result(this, 'childViewEventPrefix', defaultPrefix);

      return prefix === false ? prefix : prefix + ':';
    },
    _proxyChildViewEvents: function _proxyChildViewEvents(view) {
      if (this._childViewEvents || this._childViewTriggers || this._eventPrefix) {
        this.listenTo(view, 'all', this._childViewEventHandler);
      }
    },
    _childViewEventHandler: function _childViewEventHandler(eventName) {
      var childViewEvents = this._childViewEvents; // call collectionView childViewEvent if defined

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      if (childViewEvents && childViewEvents[eventName]) {
        childViewEvents[eventName].apply(this, args);
      } // use the parent view's proxyEvent handlers


      var childViewTriggers = this._childViewTriggers; // Call the event with the proxy name on the parent layout

      if (childViewTriggers && childViewTriggers[eventName]) {
        this.triggerMethod.apply(this, [childViewTriggers[eventName]].concat(args));
      }

      if (this._eventPrefix) {
        this.triggerMethod.apply(this, [this._eventPrefix + eventName].concat(args));
      }
    }
  };

  _.extend(ViewMixin, BehaviorsMixin, CommonMixin, DelegateEntityEventsMixin, TemplateRenderMixin, TriggersMixin, UIMixin);

  function renderView(view) {
    if (view._isRendered) {
      return;
    }

    if (!view.supportsRenderLifecycle) {
      view.triggerMethod('before:render', view);
    }

    view.render();
    view._isRendered = true;

    if (!view.supportsRenderLifecycle) {
      view.triggerMethod('render', view);
    }
  }
  function destroyView(view, disableDetachEvents) {
    if (view.destroy) {
      // Attach flag for public destroy function internal check
      view._disableDetachEvents = disableDetachEvents;
      view.destroy();
      return;
    } // Destroy for non-Marionette Views


    if (!view.supportsDestroyLifecycle) {
      view.triggerMethod('before:destroy', view);
    }

    var shouldTriggerDetach = view._isAttached && !disableDetachEvents;

    if (shouldTriggerDetach) {
      view.triggerMethod('before:detach', view);
    }

    view.remove();

    if (shouldTriggerDetach) {
      view._isAttached = false;
      view.triggerMethod('detach', view);
    }

    view._isDestroyed = true;

    if (!view.supportsDestroyLifecycle) {
      view.triggerMethod('destroy', view);
    }
  }

  // Region
  var classErrorName = 'RegionError';
  var ClassOptions$1 = ['allowMissingEl', 'parentEl', 'replaceElement'];

  var Region = function Region(options) {
    this._setOptions(options, ClassOptions$1);

    this.cid = _.uniqueId(this.cidPrefix); // getOption necessary because options.el may be passed as undefined

    this._initEl = this.el = this.getOption('el'); // Handle when this.el is passed in as a $ wrapped element.

    this.el = this.el instanceof Backbone.$ ? this.el[0] : this.el;
    this.$el = this._getEl(this.el);
    this.initialize.apply(this, arguments);
  };

  Region.extend = extend;
  Region.setDomApi = setDomApi; // Region Methods
  // --------------

  _.extend(Region.prototype, CommonMixin, {
    Dom: DomApi,
    cidPrefix: 'mnr',
    replaceElement: false,
    _isReplaced: false,
    _isSwappingView: false,
    // This is a noop method intended to be overridden
    initialize: function initialize() {},
    // Displays a view instance inside of the region. If necessary handles calling the `render`
    // method for you. Reads content directly from the `el` attribute.
    show: function show(view, options) {
      if (!this._ensureElement(options)) {
        return;
      }

      view = this._getView(view, options);

      if (view === this.currentView) {
        return this;
      }

      if (view._isShown) {
        throw new MarionetteError({
          name: classErrorName,
          message: 'View is already shown in a Region or CollectionView',
          url: 'marionette.region.html#showing-a-view'
        });
      }

      this._isSwappingView = !!this.currentView;
      this.triggerMethod('before:show', this, view, options); // Assume an attached view is already in the region for pre-existing DOM

      if (this.currentView || !view._isAttached) {
        this.empty(options);
      }

      this._setupChildView(view);

      this.currentView = view;
      renderView(view);

      this._attachView(view, options);

      this.triggerMethod('show', this, view, options);
      this._isSwappingView = false;
      return this;
    },
    _getEl: function _getEl(el) {
      if (!el) {
        throw new MarionetteError({
          name: classErrorName,
          message: 'An "el" must be specified for a region.',
          url: 'marionette.region.html#additional-options'
        });
      }

      return this.getEl(el);
    },
    _setEl: function _setEl() {
      this.$el = this._getEl(this.el);

      if (this.$el.length) {
        this.el = this.$el[0];
      } // Make sure the $el contains only the el


      if (this.$el.length > 1) {
        this.$el = this.Dom.getEl(this.el);
      }
    },
    // Set the `el` of the region and move any current view to the new `el`.
    _setElement: function _setElement(el) {
      if (el === this.el) {
        return this;
      }

      var shouldReplace = this._isReplaced;

      this._restoreEl();

      this.el = el;

      this._setEl();

      if (this.currentView) {
        var view = this.currentView;

        if (shouldReplace) {
          this._replaceEl(view);
        } else {
          this.attachHtml(view);
        }
      }

      return this;
    },
    _setupChildView: function _setupChildView(view) {
      monitorViewEvents(view);

      this._proxyChildViewEvents(view); // We need to listen for if a view is destroyed in a way other than through the region.
      // If this happens we need to remove the reference to the currentView since once a view
      // has been destroyed we can not reuse it.


      view.on('destroy', this._empty, this);
    },
    _proxyChildViewEvents: function _proxyChildViewEvents(view) {
      var parentView = this._parentView;

      if (!parentView) {
        return;
      }

      parentView._proxyChildViewEvents(view);
    },
    // If the regions parent view is not monitoring its attach/detach events
    _shouldDisableMonitoring: function _shouldDisableMonitoring() {
      return this._parentView && this._parentView.monitorViewEvents === false;
    },
    _isElAttached: function _isElAttached() {
      return this.Dom.hasEl(this.Dom.getDocumentEl(this.el), this.el);
    },
    _attachView: function _attachView(view) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          replaceElement = _ref.replaceElement;

      var shouldTriggerAttach = !view._isAttached && this._isElAttached() && !this._shouldDisableMonitoring();
      var shouldReplaceEl = typeof replaceElement === 'undefined' ? !!_.result(this, 'replaceElement') : !!replaceElement;

      if (shouldTriggerAttach) {
        view.triggerMethod('before:attach', view);
      }

      if (shouldReplaceEl) {
        this._replaceEl(view);
      } else {
        this.attachHtml(view);
      }

      if (shouldTriggerAttach) {
        view._isAttached = true;
        view.triggerMethod('attach', view);
      } // Corresponds that view is shown in a marionette Region or CollectionView


      view._isShown = true;
    },
    _ensureElement: function _ensureElement() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (!_.isObject(this.el)) {
        this._setEl();
      }

      if (!this.$el || this.$el.length === 0) {
        var allowMissingEl = typeof options.allowMissingEl === 'undefined' ? !!_.result(this, 'allowMissingEl') : !!options.allowMissingEl;

        if (allowMissingEl) {
          return false;
        } else {
          throw new MarionetteError({
            name: classErrorName,
            message: "An \"el\" must exist in DOM for this region ".concat(this.cid),
            url: 'marionette.region.html#additional-options'
          });
        }
      }

      return true;
    },
    _getView: function _getView(view) {
      if (!view) {
        throw new MarionetteError({
          name: classErrorName,
          message: 'The view passed is undefined and therefore invalid. You must pass a view instance to show.',
          url: 'marionette.region.html#showing-a-view'
        });
      }

      if (view._isDestroyed) {
        throw new MarionetteError({
          name: classErrorName,
          message: "View (cid: \"".concat(view.cid, "\") has already been destroyed and cannot be used."),
          url: 'marionette.region.html#showing-a-view'
        });
      }

      if (view instanceof Backbone.View) {
        return view;
      }

      var viewOptions = this._getViewOptions(view);

      return new View(viewOptions);
    },
    // This allows for a template or a static string to be
    // used as a template
    _getViewOptions: function _getViewOptions(viewOptions) {
      if (_.isFunction(viewOptions)) {
        return {
          template: viewOptions
        };
      }

      if (_.isObject(viewOptions)) {
        return viewOptions;
      }

      var template = function template() {
        return viewOptions;
      };

      return {
        template: template
      };
    },
    // Override this method to change how the region finds the DOM element that it manages. Return
    // a jQuery selector object scoped to a provided parent el or the document if none exists.
    getEl: function getEl(el) {
      var context = _.result(this, 'parentEl');

      if (context && _.isString(el)) {
        return this.Dom.findEl(context, el);
      }

      return this.Dom.getEl(el);
    },
    _replaceEl: function _replaceEl(view) {
      // Always restore the el to ensure the regions el is present before replacing
      this._restoreEl();

      view.on('before:destroy', this._restoreEl, this);
      this.Dom.replaceEl(view.el, this.el);
      this._isReplaced = true;
    },
    // Restore the region's element in the DOM.
    _restoreEl: function _restoreEl() {
      // There is nothing to replace
      if (!this._isReplaced) {
        return;
      }

      var view = this.currentView;

      if (!view) {
        return;
      }

      this._detachView(view);

      this._isReplaced = false;
    },
    // Check to see if the region's el was replaced.
    isReplaced: function isReplaced() {
      return !!this._isReplaced;
    },
    // Check to see if a view is being swapped by another
    isSwappingView: function isSwappingView() {
      return !!this._isSwappingView;
    },
    // Override this method to change how the new view is appended to the `$el` that the
    // region is managing
    attachHtml: function attachHtml(view) {
      this.Dom.appendContents(this.el, view.el, {
        _$el: this.$el,
        _$contents: view.$el
      });
    },
    // Destroy the current view, if there is one. If there is no current view,
    // it will detach any html inside the region's `el`.
    empty: function empty() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        allowMissingEl: true
      };
      var view = this.currentView; // If there is no view in the region we should only detach current html

      if (!view) {
        if (this._ensureElement(options)) {
          this.detachHtml();
        }

        return this;
      }

      this._empty(view, true);

      return this;
    },
    _empty: function _empty(view, shouldDestroy) {
      view.off('destroy', this._empty, this);
      this.triggerMethod('before:empty', this, view);

      this._restoreEl();

      delete this.currentView;

      if (!view._isDestroyed) {
        if (shouldDestroy) {
          this.removeView(view);
        } else {
          this._detachView(view);
        }

        view._isShown = false;

        this._stopChildViewEvents(view);
      }

      this.triggerMethod('empty', this, view);
    },
    _stopChildViewEvents: function _stopChildViewEvents(view) {
      var parentView = this._parentView;

      if (!parentView) {
        return;
      }

      this._parentView.stopListening(view);
    },
    // Non-Marionette safe view.destroy
    destroyView: function destroyView$1(view) {
      if (view._isDestroyed) {
        return view;
      }

      destroyView(view, this._shouldDisableMonitoring());

      return view;
    },
    // Override this method to determine what happens when the view
    // is removed from the region when the view is not being detached
    removeView: function removeView(view) {
      this.destroyView(view);
    },
    // Empties the Region without destroying the view
    // Returns the detached view
    detachView: function detachView() {
      var view = this.currentView;

      if (!view) {
        return;
      }

      this._empty(view);

      return view;
    },
    _detachView: function _detachView(view) {
      var shouldTriggerDetach = view._isAttached && !this._shouldDisableMonitoring();
      var shouldRestoreEl = this._isReplaced;

      if (shouldTriggerDetach) {
        view.triggerMethod('before:detach', view);
      }

      if (shouldRestoreEl) {
        this.Dom.replaceEl(this.el, view.el);
      } else {
        this.detachHtml();
      }

      if (shouldTriggerDetach) {
        view._isAttached = false;
        view.triggerMethod('detach', view);
      }
    },
    // Override this method to change how the region detaches current content
    detachHtml: function detachHtml() {
      this.Dom.detachContents(this.el, this.$el);
    },
    // Checks whether a view is currently present within the region. Returns `true` if there is
    // and `false` if no view is present.
    hasView: function hasView() {
      return !!this.currentView;
    },
    // Reset the region by destroying any existing view and clearing out the cached `$el`.
    // The next time a view is shown via this region, the region will re-query the DOM for
    // the region's `el`.
    reset: function reset(options) {
      this.empty(options);
      this.el = this._initEl;
      delete this.$el;
      return this;
    },
    _isDestroyed: false,
    isDestroyed: function isDestroyed() {
      return this._isDestroyed;
    },
    // Destroy the region, remove any child view
    // and remove the region from any associated view
    destroy: function destroy(options) {
      if (this._isDestroyed) {
        return this;
      }

      this.triggerMethod('before:destroy', this, options);
      this._isDestroyed = true;
      this.reset(options);

      if (this._name) {
        this._parentView._removeReferences(this._name);
      }

      delete this._parentView;
      delete this._name;
      this.triggerMethod('destroy', this, options);
      this.stopListening();
      return this;
    }
  });

  function buildRegion (definition, defaults) {
    if (definition instanceof Region) {
      return definition;
    }

    if (_.isString(definition)) {
      return buildRegionFromObject(defaults, {
        el: definition
      });
    }

    if (_.isFunction(definition)) {
      return buildRegionFromObject(defaults, {
        regionClass: definition
      });
    }

    if (_.isObject(definition)) {
      return buildRegionFromObject(defaults, definition);
    }

    throw new MarionetteError({
      message: 'Improper region configuration type.',
      url: 'marionette.region.html#defining-regions'
    });
  }

  function buildRegionFromObject(defaults, definition) {
    var options = _.extend({}, defaults, definition);

    var RegionClass = options.regionClass;
    delete options.regionClass;
    return new RegionClass(options);
  }

  // - regions
  // - regionClass

  var RegionsMixin = {
    regionClass: Region,
    // Internal method to initialize the regions that have been defined in a
    // `regions` attribute on this View.
    _initRegions: function _initRegions() {
      // init regions hash
      this.regions = this.regions || {};
      this._regions = {};
      this.addRegions(_.result(this, 'regions'));
    },
    // Internal method to re-initialize all of the regions by updating
    // the `el` that they point to
    _reInitRegions: function _reInitRegions() {
      _invoke(this._regions, 'reset');
    },
    // Add a single region, by name, to the View
    addRegion: function addRegion(name, definition) {
      var regions = {};
      regions[name] = definition;
      return this.addRegions(regions)[name];
    },
    // Add multiple regions as a {name: definition, name2: def2} object literal
    addRegions: function addRegions(regions) {
      // If there's nothing to add, stop here.
      if (_.isEmpty(regions)) {
        return;
      } // Normalize region selectors hash to allow
      // a user to use the @ui. syntax.


      regions = this.normalizeUIValues(regions, 'el'); // Add the regions definitions to the regions property

      this.regions = _.extend({}, this.regions, regions);
      return this._addRegions(regions);
    },
    // internal method to build and add regions
    _addRegions: function _addRegions(regionDefinitions) {
      var _this = this;

      var defaults = {
        regionClass: this.regionClass,
        parentEl: _.partial(_.result, this, 'el')
      };
      return _.reduce(regionDefinitions, function (regions, definition, name) {
        regions[name] = buildRegion(definition, defaults);

        _this._addRegion(regions[name], name);

        return regions;
      }, {});
    },
    _addRegion: function _addRegion(region, name) {
      this.triggerMethod('before:add:region', this, name, region);
      region._parentView = this;
      region._name = name;
      this._regions[name] = region;
      this.triggerMethod('add:region', this, name, region);
    },
    // Remove a single region from the View, by name
    removeRegion: function removeRegion(name) {
      var region = this._regions[name];

      this._removeRegion(region, name);

      return region;
    },
    // Remove all regions from the View
    removeRegions: function removeRegions() {
      var regions = this._getRegions();

      _.each(this._regions, this._removeRegion.bind(this));

      return regions;
    },
    _removeRegion: function _removeRegion(region, name) {
      this.triggerMethod('before:remove:region', this, name, region);
      region.destroy();
      this.triggerMethod('remove:region', this, name, region);
    },
    // Called in a region's destroy
    _removeReferences: function _removeReferences(name) {
      delete this.regions[name];
      delete this._regions[name];
    },
    // Empty all regions in the region manager, but
    // leave them attached
    emptyRegions: function emptyRegions() {
      var regions = this.getRegions();

      _invoke(regions, 'empty');

      return regions;
    },
    // Checks to see if view contains region
    // Accepts the region name
    // hasRegion('main')
    hasRegion: function hasRegion(name) {
      return !!this.getRegion(name);
    },
    // Provides access to regions
    // Accepts the region name
    // getRegion('main')
    getRegion: function getRegion(name) {
      if (!this._isRendered) {
        this.render();
      }

      return this._regions[name];
    },
    _getRegions: function _getRegions() {
      return _.clone(this._regions);
    },
    // Get all regions
    getRegions: function getRegions() {
      if (!this._isRendered) {
        this.render();
      }

      return this._getRegions();
    },
    showChildView: function showChildView(name, view, options) {
      var region = this.getRegion(name);
      region.show(view, options);
      return view;
    },
    detachChildView: function detachChildView(name) {
      return this.getRegion(name).detachView();
    },
    getChildView: function getChildView(name) {
      return this.getRegion(name).currentView;
    }
  };

  // Static setter for the renderer
  function setRenderer(renderer) {
    this.prototype._renderHtml = renderer;
    return this;
  }

  // View
  var ClassOptions$2 = ['behaviors', 'childViewEventPrefix', 'childViewEvents', 'childViewTriggers', 'collectionEvents', 'events', 'modelEvents', 'regionClass', 'regions', 'template', 'templateContext', 'triggers', 'ui']; // Used by _getImmediateChildren

  function childReducer(children, region) {
    if (region.currentView) {
      children.push(region.currentView);
    }

    return children;
  } // The standard view. Includes view events, automatic rendering
  // templates, nested views, and more.


  var View = Backbone.View.extend({
    constructor: function constructor(options) {
      this._setOptions(options, ClassOptions$2);

      monitorViewEvents(this);

      this._initBehaviors();

      this._initRegions();

      Backbone.View.prototype.constructor.apply(this, arguments);
      this.delegateEntityEvents();

      this._triggerEventOnBehaviors('initialize', this, options);
    },
    // Overriding Backbone.View's `setElement` to handle
    // if an el was previously defined. If so, the view might be
    // rendered or attached on setElement.
    setElement: function setElement() {
      Backbone.View.prototype.setElement.apply(this, arguments);
      this._isRendered = this.Dom.hasContents(this.el);
      this._isAttached = this._isElAttached();

      if (this._isRendered) {
        this.bindUIElements();
      }

      return this;
    },
    // If a template is available, renders it into the view's `el`
    // Re-inits regions and binds UI.
    render: function render() {
      var template = this.getTemplate();

      if (template === false || this._isDestroyed) {
        return this;
      }

      this.triggerMethod('before:render', this); // If this is not the first render call, then we need to
      // re-initialize the `el` for each region

      if (this._isRendered) {
        this._reInitRegions();
      }

      this._renderTemplate(template);

      this.bindUIElements();
      this._isRendered = true;
      this.triggerMethod('render', this);
      return this;
    },
    // called by ViewMixin destroy
    _removeChildren: function _removeChildren() {
      this.removeRegions();
    },
    _getImmediateChildren: function _getImmediateChildren() {
      return _.reduce(this._regions, childReducer, []);
    }
  }, {
    setRenderer: setRenderer,
    setDomApi: setDomApi
  });

  _.extend(View.prototype, ViewMixin, RegionsMixin);

  // shut down child views.

  var Container = function Container() {
    this._init();
  }; // Mix in methods from Underscore, for iteration, and other
  // collection related features.
  // Borrowing this code from Backbone.Collection:
  // https://github.com/jashkenas/backbone/blob/1.1.2/backbone.js#L962


  var methods = ['forEach', 'each', 'map', 'find', 'detect', 'filter', 'select', 'reject', 'every', 'all', 'some', 'any', 'include', 'contains', 'invoke', 'toArray', 'first', 'initial', 'rest', 'last', 'without', 'isEmpty', 'pluck', 'reduce', 'partition'];

  _.each(methods, function (method) {
    Container.prototype[method] = function () {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _[method].apply(_, [this._views].concat(args));
    };
  });

  function stringComparator(comparator, view) {
    return view.model && view.model.get(comparator);
  } // Container Methods
  // -----------------


  _.extend(Container.prototype, {
    // Initializes an empty container
    _init: function _init() {
      this._views = [];
      this._viewsByCid = {};
      this._indexByModel = {};

      this._updateLength();
    },
    // Add a view to this container. Stores the view
    // by `cid` and makes it searchable by the model
    // cid (and model itself). Additionally it stores
    // the view by index in the _views array
    _add: function _add(view) {
      var index = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._views.length;

      this._addViewIndexes(view); // add to end by default


      this._views.splice(index, 0, view);

      this._updateLength();
    },
    _addViewIndexes: function _addViewIndexes(view) {
      // store the view
      this._viewsByCid[view.cid] = view; // index it by model

      if (view.model) {
        this._indexByModel[view.model.cid] = view;
      }
    },
    // Sort (mutate) and return the array of the child views.
    _sort: function _sort(comparator, context) {
      if (typeof comparator === 'string') {
        comparator = _.partial(stringComparator, comparator);
        return this._sortBy(comparator);
      }

      if (comparator.length === 1) {
        return this._sortBy(comparator.bind(context));
      }

      return this._views.sort(comparator.bind(context));
    },
    // Makes `_.sortBy` mutate the array to match `this._views.sort`
    _sortBy: function _sortBy(comparator) {
      var sortedViews = _.sortBy(this._views, comparator);

      this._set(sortedViews);

      return sortedViews;
    },
    // Replace array contents without overwriting the reference.
    // Should not add/remove views
    _set: function _set(views, shouldReset) {
      this._views.length = 0;

      this._views.push.apply(this._views, views.slice(0));

      if (shouldReset) {
        this._viewsByCid = {};
        this._indexByModel = {};

        _.each(views, this._addViewIndexes.bind(this));

        this._updateLength();
      }
    },
    // Swap views by index
    _swap: function _swap(view1, view2) {
      var view1Index = this.findIndexByView(view1);
      var view2Index = this.findIndexByView(view2);

      if (view1Index === -1 || view2Index === -1) {
        return;
      }

      var swapView = this._views[view1Index];
      this._views[view1Index] = this._views[view2Index];
      this._views[view2Index] = swapView;
    },
    // Find a view by the model that was attached to it.
    // Uses the model's `cid` to find it.
    findByModel: function findByModel(model) {
      return this.findByModelCid(model.cid);
    },
    // Find a view by the `cid` of the model that was attached to it.
    findByModelCid: function findByModelCid(modelCid) {
      return this._indexByModel[modelCid];
    },
    // Find a view by index.
    findByIndex: function findByIndex(index) {
      return this._views[index];
    },
    // Find the index of a view instance
    findIndexByView: function findIndexByView(view) {
      return this._views.indexOf(view);
    },
    // Retrieve a view by its `cid` directly
    findByCid: function findByCid(cid) {
      return this._viewsByCid[cid];
    },
    hasView: function hasView(view) {
      return !!this.findByCid(view.cid);
    },
    // Remove a view and clean up index references.
    _remove: function _remove(view) {
      if (!this._viewsByCid[view.cid]) {
        return;
      } // delete model index


      if (view.model) {
        delete this._indexByModel[view.model.cid];
      } // remove the view from the container


      delete this._viewsByCid[view.cid];
      var index = this.findIndexByView(view);

      this._views.splice(index, 1);

      this._updateLength();
    },
    // Update the `.length` attribute on this container
    _updateLength: function _updateLength() {
      this.length = this._views.length;
    }
  });

  // Collection View
  var classErrorName$1 = 'CollectionViewError';
  var ClassOptions$3 = ['behaviors', 'childView', 'childViewContainer', 'childViewEventPrefix', 'childViewEvents', 'childViewOptions', 'childViewTriggers', 'collectionEvents', 'emptyView', 'emptyViewOptions', 'events', 'modelEvents', 'sortWithCollection', 'template', 'templateContext', 'triggers', 'ui', 'viewComparator', 'viewFilter']; // A view that iterates over a Backbone.Collection
  // and renders an individual child view for each model.

  var CollectionView = Backbone.View.extend({
    // flag for maintaining the sorted order of the collection
    sortWithCollection: true,
    // constructor
    constructor: function constructor(options) {
      this._setOptions(options, ClassOptions$3);

      monitorViewEvents(this);

      this._initChildViewStorage();

      this._initBehaviors();

      Backbone.View.prototype.constructor.apply(this, arguments); // Init empty region

      this.getEmptyRegion();
      this.delegateEntityEvents();

      this._triggerEventOnBehaviors('initialize', this, options);
    },
    // Internal method to set up the `children` object for storing all of the child views
    // `_children` represents all child views
    // `children` represents only views filtered to be shown
    _initChildViewStorage: function _initChildViewStorage() {
      this._children = new Container();
      this.children = new Container();
    },
    // Create an region to show the emptyView
    getEmptyRegion: function getEmptyRegion() {
      var $emptyEl = this.$container || this.$el;

      if (this._emptyRegion && !this._emptyRegion.isDestroyed()) {
        this._emptyRegion._setElement($emptyEl[0]);

        return this._emptyRegion;
      }

      this._emptyRegion = new Region({
        el: $emptyEl[0],
        replaceElement: false
      });
      this._emptyRegion._parentView = this;
      return this._emptyRegion;
    },
    // Configured the initial events that the collection view binds to.
    _initialEvents: function _initialEvents() {
      if (this._isRendered) {
        return;
      }

      this.listenTo(this.collection, {
        'sort': this._onCollectionSort,
        'reset': this._onCollectionReset,
        'update': this._onCollectionUpdate
      });
    },
    // Internal method. This checks for any changes in the order of the collection.
    // If the index of any view doesn't match, it will re-sort.
    _onCollectionSort: function _onCollectionSort(collection, _ref) {
      var add = _ref.add,
          merge = _ref.merge,
          remove = _ref.remove;

      if (!this.sortWithCollection || this.viewComparator === false) {
        return;
      } // If the data is changing we will handle the sort later in `_onCollectionUpdate`


      if (add || remove || merge) {
        return;
      } // If the only thing happening here is sorting, sort.


      this.sort();
    },
    _onCollectionReset: function _onCollectionReset() {
      this._destroyChildren();

      this._addChildModels(this.collection.models);

      this.sort();
    },
    // Handle collection update model additions and  removals
    _onCollectionUpdate: function _onCollectionUpdate(collection, options) {
      var changes = options.changes; // Remove first since it'll be a shorter array lookup.

      var removedViews = changes.removed.length && this._removeChildModels(changes.removed);

      this._addedViews = changes.added.length && this._addChildModels(changes.added);

      this._detachChildren(removedViews);

      this.sort(); // Destroy removed child views after all of the render is complete

      this._removeChildViews(removedViews);
    },
    _removeChildModels: function _removeChildModels(models) {
      var _this = this;

      return _.reduce(models, function (views, model) {
        var removeView = _this._removeChildModel(model);

        if (removeView) {
          views.push(removeView);
        }

        return views;
      }, []);
    },
    _removeChildModel: function _removeChildModel(model) {
      var view = this._children.findByModel(model);

      if (view) {
        this._removeChild(view);
      }

      return view;
    },
    _removeChild: function _removeChild(view) {
      this.triggerMethod('before:remove:child', this, view);

      this.children._remove(view);

      this._children._remove(view);

      this.triggerMethod('remove:child', this, view);
    },
    // Added views are returned for consistency with _removeChildModels
    _addChildModels: function _addChildModels(models) {
      return _.map(models, this._addChildModel.bind(this));
    },
    _addChildModel: function _addChildModel(model) {
      var view = this._createChildView(model);

      this._addChild(view);

      return view;
    },
    _createChildView: function _createChildView(model) {
      var ChildView = this._getChildView(model);

      var childViewOptions = this._getChildViewOptions(model);

      var view = this.buildChildView(model, ChildView, childViewOptions);
      return view;
    },
    _addChild: function _addChild(view, index) {
      this.triggerMethod('before:add:child', this, view);

      this._setupChildView(view);

      this._children._add(view, index);

      this.children._add(view, index);

      this.triggerMethod('add:child', this, view);
    },
    // Retrieve the `childView` class
    // The `childView` property can be either a view class or a function that
    // returns a view class. If it is a function, it will receive the model that
    // will be passed to the view instance (created from the returned view class)
    _getChildView: function _getChildView(child) {
      var childView = this.childView;

      if (!childView) {
        throw new MarionetteError({
          name: classErrorName$1,
          message: 'A "childView" must be specified',
          url: 'marionette.collectionview.html#collectionviews-childview'
        });
      }

      childView = this._getView(childView, child);

      if (!childView) {
        throw new MarionetteError({
          name: classErrorName$1,
          message: '"childView" must be a view class or a function that returns a view class',
          url: 'marionette.collectionview.html#collectionviews-childview'
        });
      }

      return childView;
    },
    // First check if the `view` is a view class (the common case)
    // Then check if it's a function (which we assume that returns a view class)
    _getView: function _getView(view, child) {
      if (view.prototype instanceof Backbone.View || view === Backbone.View) {
        return view;
      } else if (_.isFunction(view)) {
        return view.call(this, child);
      }
    },
    _getChildViewOptions: function _getChildViewOptions(child) {
      if (_.isFunction(this.childViewOptions)) {
        return this.childViewOptions(child);
      }

      return this.childViewOptions;
    },
    // Build a `childView` for a model in the collection.
    // Override to customize the build
    buildChildView: function buildChildView(child, ChildViewClass, childViewOptions) {
      var options = _.extend({
        model: child
      }, childViewOptions);

      return new ChildViewClass(options);
    },
    _setupChildView: function _setupChildView(view) {
      monitorViewEvents(view); // We need to listen for if a view is destroyed in a way other
      // than through the CollectionView.
      // If this happens we need to remove the reference to the view
      // since once a view has been destroyed we can not reuse it.

      view.on('destroy', this.removeChildView, this); // set up the child view event forwarding

      this._proxyChildViewEvents(view);
    },
    // used by ViewMixin's `_childViewEventHandler`
    _getImmediateChildren: function _getImmediateChildren() {
      return this.children._views;
    },
    // Overriding Backbone.View's `setElement` to handle
    // if an el was previously defined. If so, the view might be
    // attached on setElement.
    setElement: function setElement() {
      Backbone.View.prototype.setElement.apply(this, arguments);
      this._isAttached = this._isElAttached();
      return this;
    },
    // Render children views.
    render: function render() {
      if (this._isDestroyed) {
        return this;
      }

      this.triggerMethod('before:render', this);

      this._destroyChildren();

      if (this.collection) {
        this._addChildModels(this.collection.models);

        this._initialEvents();
      }

      var template = this.getTemplate();

      if (template) {
        this._renderTemplate(template);

        this.bindUIElements();
      }

      this._getChildViewContainer();

      this.sort();
      this._isRendered = true;
      this.triggerMethod('render', this);
      return this;
    },
    // Get a container within the template to add the children within
    _getChildViewContainer: function _getChildViewContainer() {
      var childViewContainer = _.result(this, 'childViewContainer');

      this.$container = childViewContainer ? this.$(childViewContainer) : this.$el;

      if (!this.$container.length) {
        throw new MarionetteError({
          name: classErrorName$1,
          message: "The specified \"childViewContainer\" was not found: ".concat(childViewContainer),
          url: 'marionette.collectionview.html#defining-the-childviewcontainer'
        });
      }
    },
    // Sorts the children then filters and renders the results.
    sort: function sort() {
      this._sortChildren();

      this.filter();
      return this;
    },
    // Sorts views by viewComparator and sets the children to the new order
    _sortChildren: function _sortChildren() {
      if (!this._children.length) {
        return;
      }

      var viewComparator = this.getComparator();

      if (!viewComparator) {
        return;
      } // If children are sorted prevent added to end perf


      delete this._addedViews;
      this.triggerMethod('before:sort', this);

      this._children._sort(viewComparator, this);

      this.triggerMethod('sort', this);
    },
    // Sets the view's `viewComparator` and applies the sort if the view is ready.
    // To prevent the render pass `{ preventRender: true }` as the 2nd argument.
    setComparator: function setComparator(comparator) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          preventRender = _ref2.preventRender;

      var comparatorChanged = this.viewComparator !== comparator;
      var shouldSort = comparatorChanged && !preventRender;
      this.viewComparator = comparator;

      if (shouldSort) {
        this.sort();
      }

      return this;
    },
    // Clears the `viewComparator` and follows the same rules for rendering as `setComparator`.
    removeComparator: function removeComparator(options) {
      return this.setComparator(null, options);
    },
    // If viewComparator is overriden it will be returned here.
    // Additionally override this function to provide custom
    // viewComparator logic
    getComparator: function getComparator() {
      if (this.viewComparator) {
        return this.viewComparator;
      }

      if (!this.sortWithCollection || this.viewComparator === false || !this.collection) {
        return false;
      }

      return this._viewComparator;
    },
    // Default internal view comparator that order the views by
    // the order of the collection
    _viewComparator: function _viewComparator(view) {
      return this.collection.indexOf(view.model);
    },
    // This method filters the children views and renders the results
    filter: function filter() {
      if (this._isDestroyed) {
        return this;
      }

      this._filterChildren();

      this._renderChildren();

      return this;
    },
    _filterChildren: function _filterChildren() {
      var _this2 = this;

      if (!this._children.length) {
        return;
      }

      var viewFilter = this._getFilter();

      if (!viewFilter) {
        var shouldReset = this.children.length !== this._children.length;

        this.children._set(this._children._views, shouldReset);

        return;
      } // If children are filtered prevent added to end perf


      delete this._addedViews;
      this.triggerMethod('before:filter', this);
      var attachViews = [];
      var detachViews = [];

      _.each(this._children._views, function (view, key, children) {
        (viewFilter.call(_this2, view, key, children) ? attachViews : detachViews).push(view);
      });

      this._detachChildren(detachViews); // reset children


      this.children._set(attachViews, true);

      this.triggerMethod('filter', this, attachViews, detachViews);
    },
    // This method returns a function for the viewFilter
    _getFilter: function _getFilter() {
      var viewFilter = this.getFilter();

      if (!viewFilter) {
        return false;
      }

      if (_.isFunction(viewFilter)) {
        return viewFilter;
      } // Support filter predicates `{ fooFlag: true }`


      if (_.isObject(viewFilter)) {
        var matcher = _.matches(viewFilter);

        return function (view) {
          return matcher(view.model && view.model.attributes);
        };
      } // Filter by model attribute


      if (_.isString(viewFilter)) {
        return function (view) {
          return view.model && view.model.get(viewFilter);
        };
      }

      throw new MarionetteError({
        name: classErrorName$1,
        message: '"viewFilter" must be a function, predicate object literal, a string indicating a model attribute, or falsy',
        url: 'marionette.collectionview.html#defining-the-viewfilter'
      });
    },
    // Override this function to provide custom
    // viewFilter logic
    getFilter: function getFilter() {
      return this.viewFilter;
    },
    // Sets the view's `viewFilter` and applies the filter if the view is ready.
    // To prevent the render pass `{ preventRender: true }` as the 2nd argument.
    setFilter: function setFilter(filter) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          preventRender = _ref3.preventRender;

      var filterChanged = this.viewFilter !== filter;
      var shouldRender = filterChanged && !preventRender;
      this.viewFilter = filter;

      if (shouldRender) {
        this.filter();
      }

      return this;
    },
    // Clears the `viewFilter` and follows the same rules for rendering as `setFilter`.
    removeFilter: function removeFilter(options) {
      return this.setFilter(null, options);
    },
    _detachChildren: function _detachChildren(detachingViews) {
      _.each(detachingViews, this._detachChildView.bind(this));
    },
    _detachChildView: function _detachChildView(view) {
      var shouldTriggerDetach = view._isAttached && this.monitorViewEvents !== false;

      if (shouldTriggerDetach) {
        view.triggerMethod('before:detach', view);
      }

      this.detachHtml(view);

      if (shouldTriggerDetach) {
        view._isAttached = false;
        view.triggerMethod('detach', view);
      }

      view._isShown = false;
    },
    // Override this method to change how the collectionView detaches a child view
    detachHtml: function detachHtml(view) {
      this.Dom.detachEl(view.el, view.$el);
    },
    _renderChildren: function _renderChildren() {
      // If there are unrendered views prevent add to end perf
      if (this._hasUnrenderedViews) {
        delete this._addedViews;
        delete this._hasUnrenderedViews;
      }

      var views = this._addedViews || this.children._views;
      this.triggerMethod('before:render:children', this, views);

      if (this.isEmpty()) {
        this._showEmptyView();
      } else {
        this._destroyEmptyView();

        var els = this._getBuffer(views);

        this._attachChildren(els, views);
      }

      delete this._addedViews;
      this.triggerMethod('render:children', this, views);
    },
    // Renders each view and creates a fragment buffer from them
    _getBuffer: function _getBuffer(views) {
      var _this3 = this;

      var elBuffer = this.Dom.createBuffer();

      _.each(views, function (view) {
        renderView(view); // corresponds that view is shown in a Region or CollectionView

        view._isShown = true;

        _this3.Dom.appendContents(elBuffer, view.el, {
          _$contents: view.$el
        });
      });

      return elBuffer;
    },
    _attachChildren: function _attachChildren(els, views) {
      var shouldTriggerAttach = this._isAttached && this.monitorViewEvents !== false;
      views = shouldTriggerAttach ? views : [];

      _.each(views, function (view) {
        if (view._isAttached) {
          return;
        }

        view.triggerMethod('before:attach', view);
      });

      this.attachHtml(els, this.$container);

      _.each(views, function (view) {
        if (view._isAttached) {
          return;
        }

        view._isAttached = true;
        view.triggerMethod('attach', view);
      });
    },
    // Override this method to do something other than `.append`.
    // You can attach any HTML at this point including the els.
    attachHtml: function attachHtml(els, $container) {
      this.Dom.appendContents($container[0], els, {
        _$el: $container
      });
    },
    isEmpty: function isEmpty() {
      return !this.children.length;
    },
    _showEmptyView: function _showEmptyView() {
      var EmptyView = this._getEmptyView();

      if (!EmptyView) {
        return;
      }

      var options = this._getEmptyViewOptions();

      var emptyRegion = this.getEmptyRegion();
      emptyRegion.show(new EmptyView(options));
    },
    // Retrieve the empty view class
    _getEmptyView: function _getEmptyView() {
      var emptyView = this.emptyView;

      if (!emptyView) {
        return;
      }

      return this._getView(emptyView);
    },
    // Remove the emptyView
    _destroyEmptyView: function _destroyEmptyView() {
      var emptyRegion = this.getEmptyRegion(); // Only empty if a view is show so the region
      // doesn't detach any other unrelated HTML

      if (emptyRegion.hasView()) {
        emptyRegion.empty();
      }
    },
    //
    _getEmptyViewOptions: function _getEmptyViewOptions() {
      var emptyViewOptions = this.emptyViewOptions || this.childViewOptions;

      if (_.isFunction(emptyViewOptions)) {
        return emptyViewOptions.call(this);
      }

      return emptyViewOptions;
    },
    swapChildViews: function swapChildViews(view1, view2) {
      if (!this._children.hasView(view1) || !this._children.hasView(view2)) {
        throw new MarionetteError({
          name: classErrorName$1,
          message: 'Both views must be children of the collection view to swap.',
          url: 'marionette.collectionview.html#swapping-child-views'
        });
      }

      this._children._swap(view1, view2);

      this.Dom.swapEl(view1.el, view2.el); // If the views are not filtered the same, refilter

      if (this.children.hasView(view1) !== this.children.hasView(view2)) {
        this.filter();
      } else {
        this.children._swap(view1, view2);
      }

      return this;
    },
    // Render the child's view and add it to the HTML for the collection view at a given index, based on the current sort
    addChildView: function addChildView(view, index) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      if (!view || view._isDestroyed) {
        return view;
      }

      if (view._isShown) {
        throw new MarionetteError({
          name: classErrorName$1,
          message: 'View is already shown in a Region or CollectionView',
          url: 'marionette.region.html#showing-a-view'
        });
      }

      if (_.isObject(index)) {
        options = index;
      } // If options has defined index we should use it


      if (options.index != null) {
        index = options.index;
      }

      if (!this._isRendered) {
        this.render();
      }

      this._addChild(view, index);

      if (options.preventRender) {
        this._hasUnrenderedViews = true;
        return view;
      }

      var hasIndex = typeof index !== 'undefined';
      var isAddedToEnd = !hasIndex || index >= this._children.length; // Only cache views if added to the end and there is no unrendered views

      if (isAddedToEnd && !this._hasUnrenderedViews) {
        this._addedViews = [view];
      }

      if (hasIndex) {
        this._renderChildren();
      } else {
        this.sort();
      }

      return view;
    },
    // Detach a view from the children.  Best used when adding a
    // childView from `addChildView`
    detachChildView: function detachChildView(view) {
      this.removeChildView(view, {
        shouldDetach: true
      });
      return view;
    },
    // Remove the child view and destroy it.  Best used when adding a
    // childView from `addChildView`
    // The options argument is for internal use only
    removeChildView: function removeChildView(view, options) {
      if (!view) {
        return view;
      }

      this._removeChildView(view, options);

      this._removeChild(view);

      if (this.isEmpty()) {
        this._showEmptyView();
      }

      return view;
    },
    _removeChildViews: function _removeChildViews(views) {
      _.each(views, this._removeChildView.bind(this));
    },
    _removeChildView: function _removeChildView(view) {
      var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          shouldDetach = _ref4.shouldDetach;

      view.off('destroy', this.removeChildView, this);

      if (shouldDetach) {
        this._detachChildView(view);
      } else {
        this._destroyChildView(view);
      }

      this.stopListening(view);
    },
    _destroyChildView: function _destroyChildView(view) {
      if (view._isDestroyed) {
        return;
      }

      var shouldDisableEvents = this.monitorViewEvents === false;
      destroyView(view, shouldDisableEvents);
    },
    // called by ViewMixin destroy
    _removeChildren: function _removeChildren() {
      this._destroyChildren();

      var emptyRegion = this.getEmptyRegion();
      emptyRegion.destroy();
      delete this._addedViews;
    },
    // Destroy the child views that this collection view is holding on to, if any
    _destroyChildren: function _destroyChildren() {
      if (!this._children.length) {
        return;
      }

      this.triggerMethod('before:destroy:children', this);

      if (this.monitorViewEvents === false) {
        this.Dom.detachContents(this.el, this.$el);
      }

      this._removeChildViews(this._children._views); // After all children have been destroyed re-init the container


      this._children._init();

      this.children._init();

      this.triggerMethod('destroy:children', this);
    }
  }, {
    setDomApi: setDomApi,
    setRenderer: setRenderer
  });

  _.extend(CollectionView.prototype, ViewMixin);

  // Behavior
  var ClassOptions$4 = ['collectionEvents', 'events', 'modelEvents', 'triggers', 'ui'];

  var Behavior = function Behavior(options, view) {
    // Setup reference to the view.
    // this comes in handle when a behavior
    // wants to directly talk up the chain
    // to the view.
    this.view = view;

    this._setOptions(options, ClassOptions$4);

    this.cid = _.uniqueId(this.cidPrefix); // Construct an internal UI hash using the behaviors UI
    // hash combined and overridden by the view UI hash.
    // This allows the user to use UI hash elements defined
    // in the parent view as well as those defined in the behavior.
    // This order will help the reuse and share of a behavior
    // between multiple views, while letting a view override
    // a selector under an UI key.

    this.ui = _.extend({}, _.result(this, 'ui'), _.result(view, 'ui')); // Proxy view triggers

    this.listenTo(view, 'all', this.triggerMethod);
    this.initialize.apply(this, arguments);
  };

  Behavior.extend = extend; // Behavior Methods
  // --------------

  _.extend(Behavior.prototype, CommonMixin, DelegateEntityEventsMixin, TriggersMixin, UIMixin, {
    cidPrefix: 'mnb',
    // This is a noop method intended to be overridden
    initialize: function initialize() {},
    // proxy behavior $ method to the view
    // this is useful for doing jquery DOM lookups
    // scoped to behaviors view.
    $: function $() {
      return this.view.$.apply(this.view, arguments);
    },
    // Stops the behavior from listening to events.
    destroy: function destroy() {
      this.stopListening();

      this.view._removeBehavior(this);

      this._deleteEntityEventHandlers();

      return this;
    },
    proxyViewProperties: function proxyViewProperties() {
      this.$el = this.view.$el;
      this.el = this.view.el;
      return this;
    },
    bindUIElements: function bindUIElements() {
      this._bindUIElements();

      return this;
    },
    unbindUIElements: function unbindUIElements() {
      this._unbindUIElements();

      return this;
    },
    getUI: function getUI(name) {
      return this._getUI(name);
    },
    // Handle `modelEvents`, and `collectionEvents` configuration
    delegateEntityEvents: function delegateEntityEvents() {
      this._delegateEntityEvents(this.view.model, this.view.collection);

      return this;
    },
    undelegateEntityEvents: function undelegateEntityEvents() {
      this._undelegateEntityEvents(this.view.model, this.view.collection);

      return this;
    },
    _getEvents: function _getEvents() {
      var _this = this;

      if (!this.events) {
        return;
      } // Normalize behavior events hash to allow
      // a user to use the @ui. syntax.


      var behaviorEvents = this.normalizeUIKeys(_.result(this, 'events')); // binds the handler to the behavior and builds a unique eventName

      return _.reduce(behaviorEvents, function (events, behaviorHandler, key) {
        if (!_.isFunction(behaviorHandler)) {
          behaviorHandler = _this[behaviorHandler];
        }

        if (!behaviorHandler) {
          return events;
        }

        key = getNamespacedEventName(key, _this.cid);
        events[key] = behaviorHandler.bind(_this);
        return events;
      }, {});
    },
    // Internal method to build all trigger handlers for a given behavior
    _getTriggers: function _getTriggers() {
      if (!this.triggers) {
        return;
      } // Normalize behavior triggers hash to allow
      // a user to use the @ui. syntax.


      var behaviorTriggers = this.normalizeUIKeys(_.result(this, 'triggers'));
      return this._getViewTriggers(this.view, behaviorTriggers);
    }
  });

  // Application
  var ClassOptions$5 = ['channelName', 'radioEvents', 'radioRequests', 'region', 'regionClass'];

  var Application = function Application(options) {
    this._setOptions(options, ClassOptions$5);

    this.cid = _.uniqueId(this.cidPrefix);

    this._initRegion();

    this._initRadio();

    this.initialize.apply(this, arguments);
  };

  Application.extend = extend; // Application Methods
  // --------------

  _.extend(Application.prototype, CommonMixin, DestroyMixin, RadioMixin, {
    cidPrefix: 'mna',
    // This is a noop method intended to be overridden
    initialize: function initialize() {},
    // Kick off all of the application's processes.
    start: function start(options) {
      this.triggerMethod('before:start', this, options);
      this.triggerMethod('start', this, options);
      return this;
    },
    regionClass: Region,
    _initRegion: function _initRegion() {
      var region = this.region;

      if (!region) {
        return;
      }

      var defaults = {
        regionClass: this.regionClass
      };
      this._region = buildRegion(region, defaults);
    },
    getRegion: function getRegion() {
      return this._region;
    },
    showView: function showView(view) {
      var region = this.getRegion();

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      region.show.apply(region, [view].concat(args));
      return view;
    },
    getView: function getView() {
      return this.getRegion().currentView;
    }
  });

  var bindEvents$1 = proxy(bindEvents);
  var unbindEvents$1 = proxy(unbindEvents);
  var bindRequests$1 = proxy(bindRequests);
  var unbindRequests$1 = proxy(unbindRequests);
  var mergeOptions$1 = proxy(mergeOptions);
  var getOption$1 = proxy(getOption);
  var normalizeMethods$1 = proxy(normalizeMethods);
  var triggerMethod$1 = proxy(triggerMethod); // Configuration

  var setDomApi$1 = function setDomApi(mixin) {
    CollectionView.setDomApi(mixin);
    Region.setDomApi(mixin);
    View.setDomApi(mixin);
  };
  var setRenderer$1 = function setRenderer(renderer) {
    CollectionView.setRenderer(renderer);
    View.setRenderer(renderer);
  };
  var backbone_marionette = {
    View: View,
    CollectionView: CollectionView,
    MnObject: MarionetteObject,
    Object: MarionetteObject,
    Region: Region,
    Behavior: Behavior,
    Application: Application,
    isEnabled: isEnabled,
    setEnabled: setEnabled,
    monitorViewEvents: monitorViewEvents,
    Events: Events,
    extend: extend,
    DomApi: DomApi,
    VERSION: version
  };

  exports.Application = Application;
  exports.Behavior = Behavior;
  exports.CollectionView = CollectionView;
  exports.DomApi = DomApi;
  exports.Events = Events;
  exports.MnObject = MarionetteObject;
  exports.Region = Region;
  exports.VERSION = version;
  exports.View = View;
  exports.bindEvents = bindEvents$1;
  exports.bindRequests = bindRequests$1;
  exports.default = backbone_marionette;
  exports.extend = extend;
  exports.getOption = getOption$1;
  exports.isEnabled = isEnabled;
  exports.mergeOptions = mergeOptions$1;
  exports.monitorViewEvents = monitorViewEvents;
  exports.normalizeMethods = normalizeMethods$1;
  exports.setDomApi = setDomApi$1;
  exports.setEnabled = setEnabled;
  exports.setRenderer = setRenderer$1;
  exports.triggerMethod = triggerMethod$1;
  exports.unbindEvents = unbindEvents$1;
  exports.unbindRequests = unbindRequests$1;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
this && this.Marionette && (this.Mn = this.Marionette);
//# sourceMappingURL=backbone.marionette.js.map


/***/ }),

/***/ "./node_modules/backbone.paginator/lib/backbone.paginator.js":
/*!*******************************************************************!*\
  !*** ./node_modules/backbone.paginator/lib/backbone.paginator.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/*
  backbone.paginator
  http://github.com/backbone-paginator/backbone.paginator

  Copyright (c) 2016 Jimmy Yuen Ho Wong and contributors

  @module
  @license MIT
*/

(function (factory) {

  // CommonJS
  if (true) {
    module.exports = factory(__webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js"), __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js"));
  }
  // AMD
  else { var PageableCollection, oldPageableCollection; }

}(function (_, Backbone) {

  "use strict";

  var _extend = _.extend;
  var _omit = _.omit;
  var _clone = _.clone;
  var _each = _.each;
  var _pick = _.pick;
  var _contains = _.includes;
  var _isEmpty = _.isEmpty;
  var _pairs = _.pairs || _.toPairs;
  var _invert = _.invert;
  var _isArray = _.isArray;
  var _isFunction = _.isFunction;
  var _isObject = _.isObject;
  var _keys = _.keys;
  var _isUndefined = _.isUndefined;
  var ceil = Math.ceil;
  var floor = Math.floor;
  var max = Math.max;

  var BBColProto = Backbone.Collection.prototype;

  function finiteInt (val, name) {
    if (!_.isNumber(val) || _.isNaN(val) || !_.isFinite(val) || ~~val !== val) {
      throw new TypeError("`" + name + "` must be a finite integer");
    }
    return val;
  }

  function queryStringToParams (qs) {
    var kvp, k, v, ls, params = {}, decode = decodeURIComponent;
    var kvps = qs.split("&");
    for (var i = 0, l = kvps.length; i < l; i++) {
      var param = kvps[i];
      kvp = param.split("="), k = kvp[0], v = kvp[1];
      if (v == null) v = true;
      k = decode(k), v = decode(v), ls = params[k];
      if (_isArray(ls)) ls.push(v);
      else if (ls) params[k] = [ls, v];
      else params[k] = v;
    }
    return params;
  }

  // hack to make sure the whatever event handlers for this event is run
  // before func is, and the event handlers that func will trigger.
  function runOnceAtLastHandler (col, event, func) {
    var eventHandlers = col._events[event];
    if (eventHandlers && eventHandlers.length) {
      var lastHandler = eventHandlers[eventHandlers.length - 1];
      var oldCallback = lastHandler.callback;
      lastHandler.callback = function () {
        try {
          oldCallback.apply(this, arguments);
          func();
        }
        catch (e) {
          throw e;
        }
        finally {
          lastHandler.callback = oldCallback;
        }
      };
    }
    else func();
  }

  var PARAM_TRIM_RE = /[\s'"]/g;
  var URL_TRIM_RE = /[<>\s'"]/g;


  /**
   * State change event. Fired when PageableCollection#state gets updated
   *
   * @event pageable:state:change
   * @type {object} The PageableCollection#state object of this
   * PageableCollection instance
   */


  /**
     Drop-in replacement for Backbone.Collection. Supports server-side and
     client-side pagination and sorting. Client-side mode also support fully
     multi-directional synchronization of changes between pages.

     @class PageableCollection
     @extends Backbone.Collection
  */
  var PageableCollection = Backbone.PageableCollection = Backbone.Collection.extend({

    /**
       The container object to store all pagination states.

       You can override the default state by extending this class or specifying
       them in an `options` hash to the constructor.

       @property {number} firstPage = 1 - The first page index. Set to 0 if
       your server API uses 0-based indices. You should only override this value
       during extension, initialization or reset by the server after
       fetching. This value should be read only at other times.

       @property {number} lastPage = null - The last page index. This value
       is __read only__ and it's calculated based on whether `firstPage` is 0 or
       1, during bootstrapping, fetching and resetting. Please don't change this
       value under any circumstances.

       @property {number} currentPage = null - The current page index. You
       should only override this value during extension, initialization or reset
       by the server after fetching. This value should be read only at other
       times. Can be a 0-based or 1-based index, depending on whether
       `firstPage` is 0 or 1. If left as default, it will be set to `firstPage`
       on initialization.

       @property {number} pageSize = 25 - How many records to show per
       page. This value is __read only__ after initialization, if you want to
       change the page size after initialization, you must call
       PageableCollection#setPageSize.

       @property {number} totalPages = null - How many pages there are. This
       value is __read only__ and it is calculated from `totalRecords`.

       @property {number} totalRecords = null - How many records there
       are. This value is __required__ under server mode. This value is optional
       for client mode as the number will be the same as the number of models
       during bootstrapping and during fetching, either supplied by the server
       in the metadata, or calculated from the size of the response.

       @property {string} sortKey = null - The model attribute to use for
       sorting.

       @property {number} order = -1 - The order to use for sorting. Specify
       -1 for ascending order or 1 for descending order. If 0, no client side
       sorting will be done and the order query parameter will not be sent to
       the server during a fetch.
    */
    state: {
      firstPage: 1,
      lastPage: null,
      currentPage: null,
      pageSize: 25,
      totalPages: null,
      totalRecords: null,
      sortKey: null,
      order: -1
    },

    /**
       @property {string} mode = "server" The mode of operations for this
       collection. `"server"` paginates on the server-side, `"client"` paginates
       on the client-side and `"infinite"` paginates on the server-side for APIs
       that do not support `totalRecords`.
    */
    mode: "server",

    /**
       A translation map to convert PageableCollection state attributes
       to the query parameters accepted by your server API.

       You can override the default state by extending this class or specifying
       them in `options.queryParams` object hash to the constructor.

       @property {string|function():string} currentPage = "page"
       @property {string|function():string} pageSize = "per_page"
       @property {string|function():string} totalPages = "total_pages"
       @property {string|function():string} totalRecords = "total_entries"
       @property {string|function():string} sortKey = "sort_by"
       @property {string|function():string} order = "order"
       @property {Object} directions = {"-1": "asc", "1": "desc"} - A map for
       translating a PageableCollection#state.order constant to the ones your
       server API accepts.
    */
    queryParams: {
      currentPage: "page",
      pageSize: "per_page",
      totalPages: "total_pages",
      totalRecords: "total_entries",
      sortKey: "sort_by",
      order: "order",
      directions: {
        "-1": "asc",
        "1": "desc"
      }
    },

    /**
       Given a list of models or model attributues, bootstraps the full
       collection in client mode or infinite mode, or just the page you want in
       server mode.

       If you want to initialize a collection to a different state than the
       default, you can specify them in `options.state`. Any state parameters
       supplied will be merged with the default. If you want to change the
       default mapping from PageableCollection#state keys to your server API's
       query parameter names, you can specifiy an object hash in
       `option.queryParams`. Likewise, any mapping provided will be merged with
       the default. Lastly, all Backbone.Collection constructor options are also
       accepted.

       See:

       - PageableCollection#state
       - PageableCollection#queryParams
       - [Backbone.Collection#initialize](http://backbonejs.org/#Collection-constructor)

       @constructor

       @property {Backbone.Collection} fullCollection - __CLIENT MODE ONLY__
       This collection is the internal storage for the bootstrapped or fetched
       models. You can use this if you want to operate on all the pages.

       @param {Array.<Object>} models

       @param {Object} options

       @param {function(*, *): number} options.comparator - If specified, this
       comparator is set to the current page under server mode, or the
       PageableCollection#fullCollection otherwise.

       @param {boolean} options.full 0 If `false` and either a
       `options.comparator` or `sortKey` is defined, the comparator is attached
       to the current page. Default is `true` under client or infinite mode and
       the comparator will be attached to the PageableCollection#fullCollection.

       @param {Object} options.state - The state attributes overriding the defaults.

       @param {string} options.state.sortKey - The model attribute to use for
       sorting. If specified instead of `options.comparator`, a comparator will
       be automatically created using this value, and optionally a sorting order
       specified in `options.state.order`. The comparator is then attached to
       the new collection instance.

       @param {number} options.state.order - The order to use for sorting. Specify
       -1 for ascending order and 1 for descending order.

       @param {Object} options.queryParam
    */
    constructor: function (models, options) {

      BBColProto.constructor.apply(this, arguments);

      options = options || {};

      var mode = this.mode = options.mode || this.mode || PageableProto.mode;

      var queryParams = _extend({}, PageableProto.queryParams, this.queryParams,
                                options.queryParams || {});

      queryParams.directions = _extend({},
                                       PageableProto.queryParams.directions,
                                       this.queryParams.directions,
                                       queryParams.directions);

      this.queryParams = queryParams;

      var state = this.state = _extend({}, PageableProto.state, this.state,
                                       options.state);

      state.currentPage = state.currentPage == null ?
        state.firstPage :
        state.currentPage;

      if (!_isArray(models)) models = models ? [models] : [];
      models = models.slice();

      if (mode != "server" && state.totalRecords == null && !_isEmpty(models)) {
        // Can't use models.length naively here because Backbone.Collection will
        // dedupe by `idAttribute`
        state.totalRecords = this.length;
      }

      this.switchMode(mode, _extend({fetch: false,
                                     resetState: false,
                                     models: models}, options));

      var comparator = options.comparator;

      if (state.sortKey && !comparator) {
        this.setSorting(state.sortKey, state.order, options);
      }

      if (mode != "server") {
        var fullCollection = this.fullCollection;

        if (comparator && options.full) {
          this.comparator = null;
          fullCollection.comparator = comparator;
        }

        if (options.full) fullCollection.sort();

        // make sure the models in the current page and full collection have the
        // same references
        if (!_isEmpty(models)) {
          this.getPage(state.currentPage);
        }
      }

      this._initState = _clone(this.state);
    },

    /**
       Makes a Backbone.Collection that contains all the pages.

       @private
       @param {Array.<Object|Backbone.Model>} models
       @param {Object} options Options for Backbone.Collection constructor.
       @return {Backbone.Collection}
    */
    _makeFullCollection: function (models, options) {

      var properties = ["url", "model", "sync", "comparator"];
      var thisProto = this.constructor.prototype;
      var i, length, prop;

      var proto = {};
      for (i = 0, length = properties.length; i < length; i++) {
        prop = properties[i];
        if (!_isUndefined(thisProto[prop])) {
          proto[prop] = thisProto[prop];
        }
      }

      var fullCollection = new (Backbone.Collection.extend(proto))(models, options);

      for (i = 0, length = properties.length; i < length; i++) {
        prop = properties[i];
        if (this[prop] !== thisProto[prop]) {
          fullCollection[prop] = this[prop];
        }
      }

      return fullCollection;
    },

    /**
       Factory method that returns a Backbone event handler that responses to
       the `add`, `remove`, `reset`, and the `sort` events. The returned event
       handler will synchronize the current page collection and the full
       collection's models.

       @private

       @fires PageableCollection#pageable:state:change when handling an
       `add`, `remove`, or `reset` event

       @param {PageableCollection} pageCol
       @param {Backbone.Collection} fullCol

       @return {function(string, Backbone.Model, Backbone.Collection, Object)}
       Collection event handler
    */
    _makeCollectionEventHandler: function (pageCol, fullCol) {

      return function collectionEventHandler (event, model, collection, options) {

        var handlers = pageCol._handlers;
        _each(_keys(handlers), function (event) {
          var handler = handlers[event];
          pageCol.off(event, handler);
          fullCol.off(event, handler);
        });

        var state = _clone(pageCol.state);
        var firstPage = state.firstPage;
        var currentPage = firstPage === 0 ?
          state.currentPage :
          state.currentPage - 1;
        var pageSize = state.pageSize;
        var pageStart = currentPage * pageSize, pageEnd = pageStart + pageSize;

        if (event == "add") {
          var pageIndex, fullIndex, addAt, colToAdd, options = options || {};
          if (collection == fullCol) {
            fullIndex = fullCol.indexOf(model);
            if (fullIndex >= pageStart && fullIndex < pageEnd) {
              colToAdd = pageCol;
              pageIndex = addAt = fullIndex - pageStart;
            }
          }
          else {
            pageIndex = pageCol.indexOf(model);
            fullIndex = pageStart + pageIndex;
            colToAdd = fullCol;
            var addAt = !_isUndefined(options.at) ?
              options.at + pageStart :
              fullIndex;
          }

          if (!options.onRemove) {
            ++state.totalRecords;
            delete options.onRemove;
          }

          pageCol.state = pageCol._checkState(state);

          if (colToAdd) {
            colToAdd.add(model, _extend({}, options, {at: addAt}));
            var modelToRemove = pageIndex >= pageSize ?
              model :
              !_isUndefined(options.at) && addAt < pageEnd && pageCol.length > pageSize ?
              pageCol.at(pageSize) :
              null;
            if (modelToRemove) {
              runOnceAtLastHandler(collection, event, function () {
                pageCol.remove(modelToRemove, {onAdd: true});
              });
            }
          }

          if (!options.silent) pageCol.trigger("pageable:state:change", pageCol.state);
        }

        // remove the model from the other collection as well
        if (event == "remove") {
          if (!options.onAdd) {
            // decrement totalRecords and update totalPages and lastPage
            if (!--state.totalRecords) {
              state.totalRecords = null;
              state.totalPages = null;
            }
            else {
              var totalPages = state.totalPages = ceil(state.totalRecords / pageSize);
              state.lastPage = firstPage === 0 ? totalPages - 1 : totalPages || firstPage;
              if (state.currentPage > totalPages) state.currentPage = state.lastPage;
            }
            pageCol.state = pageCol._checkState(state);

            var nextModel, removedIndex = options.index;
            if (collection == pageCol) {
              if (nextModel = fullCol.at(pageEnd)) {
                runOnceAtLastHandler(pageCol, event, function () {
                  pageCol.push(nextModel, {onRemove: true});
                });
              }
              else if (!pageCol.length && state.totalRecords) {
                pageCol.reset(fullCol.models.slice(pageStart - pageSize, pageEnd - pageSize),
                              _extend({}, options, {parse: false}));
              }
              fullCol.remove(model);
            }
            else if (removedIndex >= pageStart && removedIndex < pageEnd) {
              if (nextModel = fullCol.at(pageEnd - 1)) {
                runOnceAtLastHandler(pageCol, event, function () {
                  pageCol.push(nextModel, {onRemove: true});
                });
              }
              pageCol.remove(model);
              if (!pageCol.length && state.totalRecords) {
                pageCol.reset(fullCol.models.slice(pageStart - pageSize, pageEnd - pageSize),
                              _extend({}, options, {parse: false}));
              }
            }
          }
          else delete options.onAdd;

          if (!options.silent) pageCol.trigger("pageable:state:change", pageCol.state);
        }

        if (event == "reset") {
          options = collection;
          collection = model;

          // Reset that's not a result of getPage
          if (collection == pageCol && options.from == null &&
              options.to == null) {
            var head = fullCol.models.slice(0, pageStart);
            var tail = fullCol.models.slice(pageStart + pageCol.models.length);
            fullCol.reset(head.concat(pageCol.models).concat(tail), options);
          }
          else if (collection == fullCol) {
            if (!(state.totalRecords = fullCol.models.length)) {
              state.totalRecords = null;
              state.totalPages = null;
            }
            if (pageCol.mode == "client") {
              firstPage = state.lastPage = state.currentPage = state.firstPage;
              currentPage = firstPage === 0 ? state.currentPage : state.currentPage - 1;
              pageStart = currentPage * pageSize;
              pageEnd = pageStart + pageSize;
            }
            pageCol.state = pageCol._checkState(state);
            pageCol.reset(fullCol.models.slice(pageStart, pageEnd),
                          _extend({}, options, {parse: false}));
          }

          if (!options.silent) pageCol.trigger("pageable:state:change", pageCol.state);
        }

        if (event == "sort") {
          options = collection;
          collection = model;
          if (collection === fullCol) {
            pageCol.reset(fullCol.models.slice(pageStart, pageEnd),
                          _extend({}, options, {parse: false}));
          }
        }

        _each(_keys(handlers), function (event) {
          var handler = handlers[event];
          _each([pageCol, fullCol], function (col) {
            col.on(event, handler);
            var callbacks = col._events[event] || [];
            callbacks.unshift(callbacks.pop());
          });
        });
      };
    },

    /**
       Sanity check this collection's pagination states. Only perform checks
       when all the required pagination state values are defined and not null.
       If `totalPages` is undefined or null, it is set to `totalRecords` /
       `pageSize`. `lastPage` is set according to whether `firstPage` is 0 or 1
       when no error occurs.

       @private

       @param {Object} state

       @throws {TypeError} If `totalRecords`, `pageSize`, `currentPage` or
       `firstPage` is not a finite integer.

       @throws {RangeError} If `pageSize`, `currentPage` or `firstPage` is out
       of bounds.

       @return {Object} Returns the `state` object if no error was found.
    */
    _checkState: function (state) {
      var mode = this.mode;
      var links = this.links;
      var totalRecords = state.totalRecords;
      var pageSize = state.pageSize;
      var currentPage = state.currentPage;
      var firstPage = state.firstPage;
      var totalPages = state.totalPages;

      if (totalRecords != null && pageSize != null && currentPage != null &&
          firstPage != null && (mode == "infinite" ? links : true)) {

        totalRecords = finiteInt(totalRecords, "totalRecords");
        pageSize = finiteInt(pageSize, "pageSize");
        currentPage = finiteInt(currentPage, "currentPage");
        firstPage = finiteInt(firstPage, "firstPage");

        if (pageSize < 1) {
          throw new RangeError("`pageSize` must be >= 1");
        }

        totalPages = state.totalPages = ceil(totalRecords / pageSize);

        if (firstPage < 0 || firstPage > 1) {
          throw new RangeError("`firstPage must be 0 or 1`");
        }

        state.lastPage = firstPage === 0 ? max(0, totalPages - 1) : totalPages || firstPage;

        if (mode == "infinite") {
          if (!links[currentPage]) {
            throw new RangeError("No link found for page " + currentPage);
          }
        }
        else if (currentPage < firstPage ||
                 (totalPages > 0 &&
                  (firstPage ? currentPage > totalPages : currentPage >= totalPages))) {
          throw new RangeError("`currentPage` must be firstPage <= currentPage " +
                               (firstPage ? "<" : "<=") +
                               " totalPages if " + firstPage + "-based. Got " +
                               currentPage + ".");
        }
      }

      return state;
    },

    /**
       Change the page size of this collection.

       Under most if not all circumstances, you should call this method to
       change the page size of a pageable collection because it will keep the
       pagination state sane. By default, the method will recalculate the
       current page number to one that will retain the current page's models
       when increasing the page size. When decreasing the page size, this method
       will retain the last models to the current page that will fit into the
       smaller page size.

       If `options.first` is true, changing the page size will also reset the
       current page back to the first page instead of trying to be smart.

       For server mode operations, changing the page size will trigger a
       PageableCollection#fetch and subsequently a `reset` event.

       For client mode operations, changing the page size will `reset` the
       current page by recalculating the current page boundary on the client
       side.

       If `options.fetch` is true, a fetch can be forced if the collection is in
       client mode.

       @param {number} pageSize - The new page size to set to PageableCollection#state.
       @param {Object} options - {@link PageableCollection#fetch} options.
       @param {boolean} options.first = false 0 Reset the current page number to
       the first page if `true`.
       @param {boolean} options.fetch - If `true`, force a fetch in client mode.

       @throws {TypeError} If `pageSize` is not a finite integer.
       @throws {RangeError} If `pageSize` is less than 1.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this.
    */
    setPageSize: function (pageSize, options) {
      pageSize = finiteInt(pageSize, "pageSize");

      options = options || {first: false};

      var state = this.state;
      var totalPages = ceil(state.totalRecords / pageSize);
      var currentPage = totalPages ?
          max(state.firstPage, floor(totalPages * state.currentPage / state.totalPages)) :
        state.firstPage;

      state = this.state = this._checkState(_extend({}, state, {
        pageSize: pageSize,
        currentPage: options.first ? state.firstPage : currentPage,
        totalPages: totalPages
      }));

      return this.getPage(state.currentPage, _omit(options, ["first"]));
    },

    /**
       Switching between client, server and infinite mode.

       If switching from client to server mode, the #fullCollection is emptied
       first and then deleted and a fetch is immediately issued for the current
       page from the server. Pass `false` to `options.fetch` to skip fetching.

       If switching to infinite mode, and if `options.models` is given for an
       array of models,PageableCollection#links will be populated with a URL per
       page, using the default URL for this collection.

       If switching from server to client mode, all of the pages are immediately
       refetched. If you have too many pages, you can pass `false` to
       `options.fetch` to skip fetching.

       If switching to any mode from infinite mode, thePageableCollection#links
       will be deleted.

       @fires PageableCollection#pageable:state:change

       @param {"server"|"client"|"infinite"} mode - The mode to switch to.

       @param {Object} options

       @param {boolean} options.fetch = true - If `false`, no fetching is done.

       @param {boolean} options.resetState = true - If 'false', the state is not
       reset, but checked for sanity instead.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this if `options.fetch` is `false`.
    */
    switchMode: function (mode, options) {

      if (!_contains(["server", "client", "infinite"], mode)) {
        throw new TypeError('`mode` must be one of "server", "client" or "infinite"');
      }

      options = options || {fetch: true, resetState: true};

      var state = this.state = options.resetState ?
        _clone(this._initState) :
        this._checkState(_extend({}, this.state));

      this.mode = mode;

      var self = this;
      var fullCollection = this.fullCollection;
      var handlers = this._handlers = this._handlers || {}, handler;
      if (mode != "server" && !fullCollection) {
        fullCollection = this._makeFullCollection(options.models || [], options);
        fullCollection.pageableCollection = this;
        this.fullCollection = fullCollection;
        var allHandler = this._makeCollectionEventHandler(this, fullCollection);
        _each(["add", "remove", "reset", "sort"], function (event) {
          handlers[event] = handler = _.bind(allHandler, {}, event);
          self.on(event, handler);
          fullCollection.on(event, handler);
        });
        fullCollection.comparator = this._fullComparator;
      }
      else if (mode == "server" && fullCollection) {
        _each(_keys(handlers), function (event) {
          handler = handlers[event];
          self.off(event, handler);
          fullCollection.off(event, handler);
        });
        delete this._handlers;
        this._fullComparator = fullCollection.comparator;
        delete this.fullCollection;
      }

      if (mode == "infinite") {
        var links = this.links = {};
        var firstPage = state.firstPage;
        var totalPages = ceil(state.totalRecords / state.pageSize);
        var lastPage = firstPage === 0 ? max(0, totalPages - 1) : totalPages || firstPage;
        for (var i = state.firstPage; i <= lastPage; i++) {
          links[i] = this.url;
        }
      }
      else if (this.links) delete this.links;

      if (!options.silent) this.trigger("pageable:state:change", state);

      return options.fetch ?
        this.fetch(_omit(options, "fetch", "resetState")) :
        this;
    },

    /**
       @return {boolean} `true` if this collection can page backward, `false`
       otherwise.
    */
    hasPreviousPage: function () {
      var state = this.state;
      var currentPage = state.currentPage;
      if (this.mode != "infinite") return currentPage > state.firstPage;
      return !!this.links[currentPage - 1];
    },

    /**
       @return {boolean} `true` if this collection can page forward, `false`
       otherwise.
    */
    hasNextPage: function () {
      var state = this.state;
      var currentPage = this.state.currentPage;
      if (this.mode != "infinite") return currentPage < state.lastPage;
      return !!this.links[currentPage + 1];
    },

    /**
       Fetch the first page in server mode, or reset the current page of this
       collection to the first page in client or infinite mode.

       @param {Object} options {@linkPageableCollection#getPage} options.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this.
    */
    getFirstPage: function (options) {
      return this.getPage("first", options);
    },

    /**
       Fetch the previous page in server mode, or reset the current page of this
       collection to the previous page in client or infinite mode.

       @param {Object} options {@linkPageableCollection#getPage} options.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this.
    */
    getPreviousPage: function (options) {
      return this.getPage("prev", options);
    },

    /**
       Fetch the next page in server mode, or reset the current page of this
       collection to the next page in client mode.

       @param {Object} options {@linkPageableCollection#getPage} options.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this.
    */
    getNextPage: function (options) {
      return this.getPage("next", options);
    },

    /**
       Fetch the last page in server mode, or reset the current page of this
       collection to the last page in client mode.

       @param {Object} options {@linkPageableCollection#getPage} options.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this.
    */
    getLastPage: function (options) {
      return this.getPage("last", options);
    },

    /**
       Given a page index, set PageableCollection#state.currentPage to that
       index. If this collection is in server mode, fetch the page using the
       updated state, otherwise, reset the current page of this collection to
       the page specified by `index` in client mode. If `options.fetch` is true,
       a fetch can be forced in client mode before resetting the current
       page. Under infinite mode, if the index is less than the current page, a
       reset is done as in client mode. If the index is greater than the current
       page number, a fetch is made with the results **appended**
       toPageableCollection#fullCollection.  The current page will then be reset
       after fetching.

       @fires PageableCollection#pageable:state:change

       @param {number|string} index - The page index to go to, or the page name to
       look up fromPageableCollection#links in infinite mode.
       @param {Object} options - {@linkPageableCollection#fetch} options or
       [reset](http://backbonejs.org/#Collection-reset) options for client mode
       when `options.fetch` is `false`.
       @param {boolean} options.fetch = false - If true, force a
       {@linkPageableCollection#fetch} in client mode.

       @throws {TypeError} If `index` is not a finite integer under server or
       client mode, or does not yield a URL fromPageableCollection#links under
       infinite mode.

       @throws {RangeError} If `index` is out of bounds.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this.
    */
    getPage: function (index, options) {

      var mode = this.mode, fullCollection = this.fullCollection;

      options = options || {fetch: false};

      var state = this.state,
      firstPage = state.firstPage,
      currentPage = state.currentPage,
      lastPage = state.lastPage,
      pageSize = state.pageSize;

      var pageNum = index;
      switch (index) {
        case "first": pageNum = firstPage; break;
        case "prev": pageNum = currentPage - 1; break;
        case "next": pageNum = currentPage + 1; break;
        case "last": pageNum = lastPage; break;
        default: pageNum = finiteInt(index, "index");
      }

      this.state = this._checkState(_extend({}, state, {currentPage: pageNum}));
      if (!options.silent) this.trigger("pageable:state:change", this.state);

      options.from = currentPage, options.to = pageNum;

      var pageStart = (firstPage === 0 ? pageNum : pageNum - 1) * pageSize;
      var pageModels = fullCollection && fullCollection.length ?
        fullCollection.models.slice(pageStart, pageStart + pageSize) :
        [];
      if ((mode == "client" || (mode == "infinite" && !_isEmpty(pageModels))) &&
          !options.fetch) {
        this.reset(pageModels, _omit(options, "fetch"));
        return this;
      }

      if (mode == "infinite") options.url = this.links[pageNum];

      return this.fetch(_omit(options, "fetch"));
    },

    /**
       Fetch the page for the provided item offset in server mode, or reset the
       current page of this collection to the page for the provided item offset
       in client mode.

       @param {number} offset
       @param {Object} options {@linkPageableCollection#getPage} options.

       @chainable
       @return {XMLHttpRequest|PageableCollection} The XMLHttpRequest
       from fetch or this.
    */
    getPageByOffset: function (offset, options) {
      if (offset < 0) {
        throw new RangeError("`offset must be > 0`");
      }
      offset = finiteInt(offset, "offset");

      var page = floor(offset / this.state.pageSize);
      if (this.state.firstPage !== 0) page++;
      if (page > this.state.lastPage) page = this.state.lastPage;
      return this.getPage(page, options);
    },

    /**
       Overidden to make `getPage` compatible with Zepto.

       @param {string} method
       @param {Backbone.Model|Backbone.Collection} model
       @param {Object} options

       @return {XMLHttpRequest}
    */
    sync: function (method, model, options) {
      var self = this;
      if (self.mode == "infinite") {
        var success = options.success;
        var currentPage = self.state.currentPage;
        options.success = function (resp, status, xhr) {
          var links = self.links;
          var newLinks = self.parseLinks(resp, _extend({xhr: xhr}, options));
          if (newLinks.first) links[self.state.firstPage] = newLinks.first;
          if (newLinks.prev) links[currentPage - 1] = newLinks.prev;
          if (newLinks.next) links[currentPage + 1] = newLinks.next;
          if (success) success(resp, status, xhr);
        };
      }

      return (BBColProto.sync || Backbone.sync).call(self, method, model, options);
    },

    /**
       Parse pagination links from the server response. Only valid under
       infinite mode.

       Given a response body and a XMLHttpRequest object, extract pagination
       links from them for infinite paging.

       This default implementation parses the RFC 5988 `Link` header and extract
       3 links from it - `first`, `prev`, `next`. Any subclasses overriding this
       method __must__ return an object hash having only the keys
       above. However, simply returning a `next` link or an empty hash if there
       are no more links should be enough for most implementations.

       @param {*} resp The deserialized response body.
       @param {Object} options
       @param {XMLHttpRequest} options.xhr - The XMLHttpRequest object for this
       response.
       @return {Object}
    */
    parseLinks: function (resp, options) {
      var links = {};
      var linkHeader = options.xhr.getResponseHeader("Link");
      if (linkHeader) {
        var relations = ["first", "prev", "next"];
        _each(linkHeader.split(","), function (linkValue) {
          var linkParts = linkValue.split(";");
          var url = linkParts[0].replace(URL_TRIM_RE, "");
          var params = linkParts.slice(1);
          _each(params, function (param) {
            var paramParts = param.split("=");
            var key = paramParts[0].replace(PARAM_TRIM_RE, "");
            var value = paramParts[1].replace(PARAM_TRIM_RE, "");
            if (key == "rel" && _contains(relations, value)) links[value] = url;
          });
        });
      }

      return links;
    },

    /**
       Parse server response data.

       This default implementation assumes the response data is in one of two
       structures:

           [
             {}, // Your new pagination state
             [{}, ...] // An array of JSON objects
           ]

       Or,

           [{}] // An array of JSON objects

       The first structure is the preferred form because the pagination states
       may have been updated on the server side, sending them down again allows
       this collection to update its states. If the response has a pagination
       state object, it is checked for errors.

       The second structure is the
       [Backbone.Collection#parse](http://backbonejs.org/#Collection-parse)
       default.

       **Note:** this method has been further simplified since 1.1.7. While
       existingPageableCollection#parse implementations will continue to work,
       new code is encouraged to overridePageableCollection#parseState
       andPageableCollection#parseRecords instead.

       @fires PageableCollection#pageable:state:change

       @param {Object} resp The deserialized response data from the server.
       @param {Object} options The options for the ajax request

       @return {Array.<Object>} An array of model objects
    */
    parse: function (resp, options) {
      var newState = this.parseState(resp, _clone(this.queryParams), _clone(this.state), options);
      if (newState) {
        this.state = this._checkState(_extend({}, this.state, newState));
        if (!(options || {}).silent) this.trigger("pageable:state:change", this.state);
      }
      return this.parseRecords(resp, options);
    },

    /**
       Parse server response for server pagination state updates. Not applicable
       under infinite mode.

       This default implementation first checks whether the response has any
       state object as documented inPageableCollection#parse. If it exists, a
       state object is returned by mapping the server state keys to this
       pageable collection instance's query parameter keys using `queryParams`.

       It is __NOT__ neccessary to return a full state object complete with all
       the mappings defined inPageableCollection#queryParams. Any state object
       resulted is merged with a copy of the current pageable collection state
       and checked for sanity before actually updating. Most of the time, simply
       providing a new `totalRecords` value is enough to trigger a full
       pagination state recalculation.

           parseState: function (resp, queryParams, state, options) {
             return {totalRecords: resp.total_entries};
           }

       If you want to use header fields use:

           parseState: function (resp, queryParams, state, options) {
               return {totalRecords: options.xhr.getResponseHeader("X-total")};
           }

       This method __MUST__ return a new state object instead of directly
       modifying the PageableCollection#state object. The behavior of directly
       modifying PageableCollection#state is undefined.

       @param {Object} resp - The deserialized response data from the server.
       @param {Object} queryParams - A copy of PageableCollection#queryParams.
       @param {Object} state - A copy of PageableCollection#state.
       @param {Object} options - The options passed through from
       `parse`. (backbone >= 0.9.10 only)

       @return {Object} A new (partial) state object.
     */
    parseState: function (resp, queryParams, state, options) {
      if (resp && resp.length === 2 && _isObject(resp[0]) && _isArray(resp[1])) {

        var newState = _clone(state);
        var serverState = resp[0];

        _each(_pairs(_omit(queryParams, "directions")), function (kvp) {
          var k = kvp[0], v = kvp[1];
          var serverVal = serverState[v];
          if (!_isUndefined(serverVal) && !_.isNull(serverVal)) newState[k] = serverState[v];
        });

        if (serverState.order) {
          newState.order = _invert(queryParams.directions)[serverState.order] * 1;
        }

        return newState;
      }
    },

    /**
       Parse server response for an array of model objects.

       This default implementation first checks whether the response has any
       state object as documented inPageableCollection#parse. If it exists, the
       array of model objects is assumed to be the second element, otherwise the
       entire response is returned directly.

       @param {Object} resp - The deserialized response data from the server.
       @param {Object} options - The options passed through from the
       `parse`. (backbone >= 0.9.10 only)

       @return {Array.<Object>} An array of model objects
     */
    parseRecords: function (resp, options) {
      if (resp && resp.length === 2 && _isObject(resp[0]) && _isArray(resp[1])) {
        return resp[1];
      }

      return resp;
    },

    /**
       Fetch a page from the server in server mode, or all the pages in client
       mode. Under infinite mode, the current page is refetched by default and
       then reset.

       The query string is constructed by translating the current pagination
       state to your server API query parameter
       usingPageableCollection#queryParams. The current page will reset after
       fetch.

       @param {Object} options - Accepts all
       [Backbone.Collection#fetch](http://backbonejs.org/#Collection-fetch)
       options.

       @return {XMLHttpRequest}
    */
    fetch: function (options) {

      options = options || {};

      var state = this._checkState(this.state);

      var mode = this.mode;

      if (mode == "infinite" && !options.url) {
        options.url = this.links[state.currentPage];
      }

      var data = options.data || {};

      // dedup query params
      var url = options.url || this.url || "";
      if (_isFunction(url)) url = url.call(this);
      var qsi = url.indexOf("?");
      if (qsi != -1) {
        _extend(data, queryStringToParams(url.slice(qsi + 1)));
        url = url.slice(0, qsi);
      }

      options.url = url;
      options.data = data;

      // pick the appropriate query param keys to map according to the mode
      var queryParams = this.mode == "client" ?
          _pick(this.queryParams, "sortKey") :
          _omit(_pick(this.queryParams, _keys(PageableProto.queryParams)),
                "order", "directions", "totalPages", "totalRecords");

      // map the query params to the data object used by the underlying ajax lib
      // to construct the query string
      _each(queryParams, function (v, k) {
        v = _isFunction(v) ? v.call(this) : v;
        if (state[k] != null && v != null && _.isUndefined(data[v])) {
          data[v] = state[k];
        }
      }, this);

      var sortKey = _isFunction(this.queryParams.sortKey) ?
          this.queryParams.sortKey.call(this) :
          this.queryParams.sortKey;

      var order = _isFunction(this.queryParams.order) ?
          this.queryParams.order.call(this) :
          this.queryParams.order;

      if (sortKey != null && state.sortKey != null &&
          order != null && state.order != null) {
        if (_isArray(state.order)) {
          data[order] = [];
          for (var i = 0; i < state.order.length; i++) {
            data[order].push(this.queryParams.directions[state.order[i]]);
          }
        }
        else {
          data[order] = this.queryParams.directions[state.order + ""];
        }
      }

      // map extra query parameters
      var extraKvps = _pairs(_omit(this.queryParams,
                                   _keys(PageableProto.queryParams)));
      for (var i = 0; i < extraKvps.length; i++) {
        var kvp = extraKvps[i];
        var v = kvp[1];
        v = _isFunction(v) ? v.call(this) : v;
        if (v != null) data[kvp[0]] = v;
      }

      if (mode != "server") {
        var self = this, fullCol = this.fullCollection;
        var success = options.success;
        options.success = function (col, resp, opts) {

          // make sure the caller's intent is obeyed
          opts = opts || {};
          if (_isUndefined(options.silent)) delete opts.silent;
          else opts.silent = options.silent;

          var models = col.models;
          if (mode == "client") fullCol.reset(models, opts);
          else {
            fullCol.add(models, _extend({at: fullCol.length},
                                        _extend(opts, {parse: false})));
            self.trigger("reset", self, opts);
          }

          if (success) success(col, resp, opts);
        };

        // silent the first reset from backbone
        return BBColProto.fetch.call(this, _extend({}, options, {silent: true}));
      }

      return BBColProto.fetch.call(this, options);
    },

    /**
       Convenient method for making a `comparator` sorted by a model attribute
       identified by `sortKey` and ordered by `order`.

       Like a Backbone.Collection, a PageableCollection will maintain the
       __current page__ in sorted order on the client side if a `comparator` is
       attached to it. If the collection is in client mode, you can attach a
       comparator toPageableCollection#fullCollection to have all the pages
       reflect the global sorting order by specifying an option `full` to
       `true`. You __must__ call `sort` manually
       orPageableCollection#fullCollection.sort after calling this method to
       force a resort.

       While you can use this method to sort the current page in server mode,
       the sorting order may not reflect the global sorting order due to the
       additions or removals of the records on the server since the last
       fetch. If you want the most updated page in a global sorting order, it is
       recommended that you set PageableCollection#state.sortKey and optionally
       PageableCollection#state.order, and then callPageableCollection#fetch.

       @protected

       @param {string} sortKey = this.state.sortKey - See `state.sortKey`.
       @param {number} order = this.state.order - See `state.order`.
       @param {(function(Backbone.Model, string): Object) | string} sortValue -
       See PageableCollection#setSorting.

       @return {function(Backbone.Model, string): number}

       See [Backbone.Collection.comparator](http://backbonejs.org/#Collection-comparator).
    */
    _makeComparator: function (sortKey, order, sortValue) {
      var state = this.state;

      sortKey = sortKey || state.sortKey;
      order = order || state.order;

      if (!sortKey || !order) return;

      if (!sortValue) {
        sortValue = function (model, attr) {
          return model.get(attr);
        };
      }

      return function (left, right) {
        var l = sortValue(left, sortKey), r = sortValue(right, sortKey), t;
        if (order === 1) t = l, l = r, r = t;
        if (l === r) return 0;
        else if (l < r) return -1;
        return 1;
      };
    },

    /**
       Adjusts the sorting for this pageable collection.

       Given a `sortKey` and an `order`, sets `state.sortKey` and
       `state.order`. A comparator can be applied on the client side to sort in
       the order defined if `options.side` is `"client"`. By default the
       comparator is applied to thePageableCollection#fullCollection. Set
       `options.full` to `false` to apply a comparator to the current page under
       any mode. Setting `sortKey` to `null` removes the comparator from both
       the current page and the full collection.

       If a `sortValue` function is given, it will be passed the `(model,
       sortKey)` arguments and is used to extract a value from the model during
       comparison sorts. If `sortValue` is not given, `model.get(sortKey)` is
       used for sorting.

       @chainable

       @param {string} sortKey - See `state.sortKey`.
       @param {number} order=this.state.order - See `state.order`.
       @param {Object} options
       @param {string} options.side - By default, `"client"` if `mode` is
       `"client"`, `"server"` otherwise.
       @param {boolean} options.full = true
       @param {(function(Backbone.Model, string): Object) | string} options.sortValue

       @return {PageableCollection} this
    */
    setSorting: function (sortKey, order, options) {

      var state = this.state;

      state.sortKey = sortKey;
      state.order = order = order || state.order;

      var fullCollection = this.fullCollection;

      var delComp = false, delFullComp = false;

      if (!sortKey) delComp = delFullComp = true;

      var mode = this.mode;
      options = _extend({side: mode == "client" ? mode : "server", full: true},
                        options);

      var comparator = this._makeComparator(sortKey, order, options.sortValue);

      var full = options.full, side = options.side;

      if (side == "client") {
        if (full) {
          if (fullCollection) fullCollection.comparator = comparator;
          delComp = true;
        }
        else {
          this.comparator = comparator;
          delFullComp = true;
        }
      }
      else if (side == "server" && !full) {
        this.comparator = comparator;
      }

      if (delComp) this.comparator = null;
      if (delFullComp && fullCollection) fullCollection.comparator = null;

      return this;
    }

  });

  var PageableProto = PageableCollection.prototype;

  return PageableCollection;

}));


/***/ }),

/***/ "./node_modules/backbone.radio/build/backbone.radio.js":
/*!*************************************************************!*\
  !*** ./node_modules/backbone.radio/build/backbone.radio.js ***!
  \*************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

// Backbone.Radio v2.0.0

(function (global, factory) {
   true ? module.exports = factory(__webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js"), __webpack_require__(/*! backbone */ "./node_modules/backbone/backbone.js")) :
  0;
}(this, function (_,Backbone) { 'use strict';

  _ = 'default' in _ ? _['default'] : _;
  Backbone = 'default' in Backbone ? Backbone['default'] : Backbone;

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj;
  };

  var previousRadio = Backbone.Radio;

  var Radio = Backbone.Radio = {};

  Radio.VERSION = '2.0.0';

  // This allows you to run multiple instances of Radio on the same
  // webapp. After loading the new version, call `noConflict()` to
  // get a reference to it. At the same time the old version will be
  // returned to Backbone.Radio.
  Radio.noConflict = function () {
    Backbone.Radio = previousRadio;
    return this;
  };

  // Whether or not we're in DEBUG mode or not. DEBUG mode helps you
  // get around the issues of lack of warnings when events are mis-typed.
  Radio.DEBUG = false;

  // Format debug text.
  Radio._debugText = function (warning, eventName, channelName) {
    return warning + (channelName ? ' on the ' + channelName + ' channel' : '') + ': "' + eventName + '"';
  };

  // This is the method that's called when an unregistered event was called.
  // By default, it logs warning to the console. By overriding this you could
  // make it throw an Error, for instance. This would make firing a nonexistent event
  // have the same consequence as firing a nonexistent method on an Object.
  Radio.debugLog = function (warning, eventName, channelName) {
    if (Radio.DEBUG && console && console.warn) {
      console.warn(Radio._debugText(warning, eventName, channelName));
    }
  };

  var eventSplitter = /\s+/;

  // An internal method used to handle Radio's method overloading for Requests.
  // It's borrowed from Backbone.Events. It differs from Backbone's overload
  // API (which is used in Backbone.Events) in that it doesn't support space-separated
  // event names.
  Radio._eventsApi = function (obj, action, name, rest) {
    if (!name) {
      return false;
    }

    var results = {};

    // Handle event maps.
    if ((typeof name === 'undefined' ? 'undefined' : _typeof(name)) === 'object') {
      for (var key in name) {
        var result = obj[action].apply(obj, [key, name[key]].concat(rest));
        eventSplitter.test(key) ? _.extend(results, result) : results[key] = result;
      }
      return results;
    }

    // Handle space separated event names.
    if (eventSplitter.test(name)) {
      var names = name.split(eventSplitter);
      for (var i = 0, l = names.length; i < l; i++) {
        results[names[i]] = obj[action].apply(obj, [names[i]].concat(rest));
      }
      return results;
    }

    return false;
  };

  // An optimized way to execute callbacks.
  Radio._callHandler = function (callback, context, args) {
    var a1 = args[0],
        a2 = args[1],
        a3 = args[2];
    switch (args.length) {
      case 0:
        return callback.call(context);
      case 1:
        return callback.call(context, a1);
      case 2:
        return callback.call(context, a1, a2);
      case 3:
        return callback.call(context, a1, a2, a3);
      default:
        return callback.apply(context, args);
    }
  };

  // A helper used by `off` methods to the handler from the store
  function removeHandler(store, name, callback, context) {
    var event = store[name];
    if ((!callback || callback === event.callback || callback === event.callback._callback) && (!context || context === event.context)) {
      delete store[name];
      return true;
    }
  }

  function removeHandlers(store, name, callback, context) {
    store || (store = {});
    var names = name ? [name] : _.keys(store);
    var matched = false;

    for (var i = 0, length = names.length; i < length; i++) {
      name = names[i];

      // If there's no event by this name, log it and continue
      // with the loop
      if (!store[name]) {
        continue;
      }

      if (removeHandler(store, name, callback, context)) {
        matched = true;
      }
    }

    return matched;
  }

  /*
   * tune-in
   * -------
   * Get console logs of a channel's activity
   *
   */

  var _logs = {};

  // This is to produce an identical function in both tuneIn and tuneOut,
  // so that Backbone.Events unregisters it.
  function _partial(channelName) {
    return _logs[channelName] || (_logs[channelName] = _.bind(Radio.log, Radio, channelName));
  }

  _.extend(Radio, {

    // Log information about the channel and event
    log: function log(channelName, eventName) {
      if (typeof console === 'undefined') {
        return;
      }
      var args = _.toArray(arguments).slice(2);
      console.log('[' + channelName + '] "' + eventName + '"', args);
    },

    // Logs all events on this channel to the console. It sets an
    // internal value on the channel telling it we're listening,
    // then sets a listener on the Backbone.Events
    tuneIn: function tuneIn(channelName) {
      var channel = Radio.channel(channelName);
      channel._tunedIn = true;
      channel.on('all', _partial(channelName));
      return this;
    },

    // Stop logging all of the activities on this channel to the console
    tuneOut: function tuneOut(channelName) {
      var channel = Radio.channel(channelName);
      channel._tunedIn = false;
      channel.off('all', _partial(channelName));
      delete _logs[channelName];
      return this;
    }
  });

  /*
   * Backbone.Radio.Requests
   * -----------------------
   * A messaging system for requesting data.
   *
   */

  function makeCallback(callback) {
    return _.isFunction(callback) ? callback : function () {
      return callback;
    };
  }

  Radio.Requests = {

    // Make a request
    request: function request(name) {
      var args = _.toArray(arguments).slice(1);
      var results = Radio._eventsApi(this, 'request', name, args);
      if (results) {
        return results;
      }
      var channelName = this.channelName;
      var requests = this._requests;

      // Check if we should log the request, and if so, do it
      if (channelName && this._tunedIn) {
        Radio.log.apply(this, [channelName, name].concat(args));
      }

      // If the request isn't handled, log it in DEBUG mode and exit
      if (requests && (requests[name] || requests['default'])) {
        var handler = requests[name] || requests['default'];
        args = requests[name] ? args : arguments;
        return Radio._callHandler(handler.callback, handler.context, args);
      } else {
        Radio.debugLog('An unhandled request was fired', name, channelName);
      }
    },

    // Set up a handler for a request
    reply: function reply(name, callback, context) {
      if (Radio._eventsApi(this, 'reply', name, [callback, context])) {
        return this;
      }

      this._requests || (this._requests = {});

      if (this._requests[name]) {
        Radio.debugLog('A request was overwritten', name, this.channelName);
      }

      this._requests[name] = {
        callback: makeCallback(callback),
        context: context || this
      };

      return this;
    },

    // Set up a handler that can only be requested once
    replyOnce: function replyOnce(name, callback, context) {
      if (Radio._eventsApi(this, 'replyOnce', name, [callback, context])) {
        return this;
      }

      var self = this;

      var once = _.once(function () {
        self.stopReplying(name);
        return makeCallback(callback).apply(this, arguments);
      });

      return this.reply(name, once, context);
    },

    // Remove handler(s)
    stopReplying: function stopReplying(name, callback, context) {
      if (Radio._eventsApi(this, 'stopReplying', name)) {
        return this;
      }

      // Remove everything if there are no arguments passed
      if (!name && !callback && !context) {
        delete this._requests;
      } else if (!removeHandlers(this._requests, name, callback, context)) {
        Radio.debugLog('Attempted to remove the unregistered request', name, this.channelName);
      }

      return this;
    }
  };

  /*
   * Backbone.Radio.channel
   * ----------------------
   * Get a reference to a channel by name.
   *
   */

  Radio._channels = {};

  Radio.channel = function (channelName) {
    if (!channelName) {
      throw new Error('You must provide a name for the channel.');
    }

    if (Radio._channels[channelName]) {
      return Radio._channels[channelName];
    } else {
      return Radio._channels[channelName] = new Radio.Channel(channelName);
    }
  };

  /*
   * Backbone.Radio.Channel
   * ----------------------
   * A Channel is an object that extends from Backbone.Events,
   * and Radio.Requests.
   *
   */

  Radio.Channel = function (channelName) {
    this.channelName = channelName;
  };

  _.extend(Radio.Channel.prototype, Backbone.Events, Radio.Requests, {

    // Remove all handlers from the messaging systems of this channel
    reset: function reset() {
      this.off();
      this.stopListening();
      this.stopReplying();
      return this;
    }
  });

  /*
   * Top-level API
   * -------------
   * Supplies the 'top-level API' for working with Channels directly
   * from Backbone.Radio.
   *
   */

  var channel;
  var args;
  var systems = [Backbone.Events, Radio.Requests];
  _.each(systems, function (system) {
    _.each(system, function (method, methodName) {
      Radio[methodName] = function (channelName) {
        args = _.toArray(arguments).slice(1);
        channel = this.channel(channelName);
        return channel[methodName].apply(channel, args);
      };
    });
  });

  Radio.reset = function (channelName) {
    var channels = !channelName ? this._channels : [this._channels[channelName]];
    _.each(channels, function (channel) {
      channel.reset();
    });
  };

  return Radio;

}));
//# sourceMappingURL=./backbone.radio.js.map

/***/ }),

/***/ "./node_modules/backbone/backbone.js":
/*!*******************************************!*\
  !*** ./node_modules/backbone/backbone.js ***!
  \*******************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;//     Backbone.js 1.4.0

//     (c) 2010-2019 Jeremy Ashkenas and DocumentCloud
//     Backbone may be freely distributed under the MIT license.
//     For all details and documentation:
//     http://backbonejs.org

(function(factory) {

  // Establish the root object, `window` (`self`) in the browser, or `global` on the server.
  // We use `self` instead of `window` for `WebWorker` support.
  var root = typeof self == 'object' && self.self === self && self ||
            typeof __webpack_require__.g == 'object' && __webpack_require__.g.global === __webpack_require__.g && __webpack_require__.g;

  // Set up Backbone appropriately for the environment. Start with AMD.
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js"), __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js"), exports], __WEBPACK_AMD_DEFINE_RESULT__ = (function(_, $, exports) {
      // Export global even in AMD case in case this script is loaded with
      // others that may still expect a global Backbone.
      root.Backbone = factory(root, exports, _, $);
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

  // Next for Node.js or CommonJS. jQuery may not be needed as a module.
  } else { var _, $; }

})(function(root, Backbone, _, $) {

  // Initial Setup
  // -------------

  // Save the previous value of the `Backbone` variable, so that it can be
  // restored later on, if `noConflict` is used.
  var previousBackbone = root.Backbone;

  // Create a local reference to a common array method we'll want to use later.
  var slice = Array.prototype.slice;

  // Current version of the library. Keep in sync with `package.json`.
  Backbone.VERSION = '1.4.0';

  // For Backbone's purposes, jQuery, Zepto, Ender, or My Library (kidding) owns
  // the `$` variable.
  Backbone.$ = $;

  // Runs Backbone.js in *noConflict* mode, returning the `Backbone` variable
  // to its previous owner. Returns a reference to this Backbone object.
  Backbone.noConflict = function() {
    root.Backbone = previousBackbone;
    return this;
  };

  // Turn on `emulateHTTP` to support legacy HTTP servers. Setting this option
  // will fake `"PATCH"`, `"PUT"` and `"DELETE"` requests via the `_method` parameter and
  // set a `X-Http-Method-Override` header.
  Backbone.emulateHTTP = false;

  // Turn on `emulateJSON` to support legacy servers that can't deal with direct
  // `application/json` requests ... this will encode the body as
  // `application/x-www-form-urlencoded` instead and will send the model in a
  // form param named `model`.
  Backbone.emulateJSON = false;

  // Backbone.Events
  // ---------------

  // A module that can be mixed in to *any object* in order to provide it with
  // a custom event channel. You may bind a callback to an event with `on` or
  // remove with `off`; `trigger`-ing an event fires all callbacks in
  // succession.
  //
  //     var object = {};
  //     _.extend(object, Backbone.Events);
  //     object.on('expand', function(){ alert('expanded'); });
  //     object.trigger('expand');
  //
  var Events = Backbone.Events = {};

  // Regular expression used to split event strings.
  var eventSplitter = /\s+/;

  // A private global variable to share between listeners and listenees.
  var _listening;

  // Iterates over the standard `event, callback` (as well as the fancy multiple
  // space-separated events `"change blur", callback` and jQuery-style event
  // maps `{event: callback}`).
  var eventsApi = function(iteratee, events, name, callback, opts) {
    var i = 0, names;
    if (name && typeof name === 'object') {
      // Handle event maps.
      if (callback !== void 0 && 'context' in opts && opts.context === void 0) opts.context = callback;
      for (names = _.keys(name); i < names.length ; i++) {
        events = eventsApi(iteratee, events, names[i], name[names[i]], opts);
      }
    } else if (name && eventSplitter.test(name)) {
      // Handle space-separated event names by delegating them individually.
      for (names = name.split(eventSplitter); i < names.length; i++) {
        events = iteratee(events, names[i], callback, opts);
      }
    } else {
      // Finally, standard events.
      events = iteratee(events, name, callback, opts);
    }
    return events;
  };

  // Bind an event to a `callback` function. Passing `"all"` will bind
  // the callback to all events fired.
  Events.on = function(name, callback, context) {
    this._events = eventsApi(onApi, this._events || {}, name, callback, {
      context: context,
      ctx: this,
      listening: _listening
    });

    if (_listening) {
      var listeners = this._listeners || (this._listeners = {});
      listeners[_listening.id] = _listening;
      // Allow the listening to use a counter, instead of tracking
      // callbacks for library interop
      _listening.interop = false;
    }

    return this;
  };

  // Inversion-of-control versions of `on`. Tell *this* object to listen to
  // an event in another object... keeping track of what it's listening to
  // for easier unbinding later.
  Events.listenTo = function(obj, name, callback) {
    if (!obj) return this;
    var id = obj._listenId || (obj._listenId = _.uniqueId('l'));
    var listeningTo = this._listeningTo || (this._listeningTo = {});
    var listening = _listening = listeningTo[id];

    // This object is not listening to any other events on `obj` yet.
    // Setup the necessary references to track the listening callbacks.
    if (!listening) {
      this._listenId || (this._listenId = _.uniqueId('l'));
      listening = _listening = listeningTo[id] = new Listening(this, obj);
    }

    // Bind callbacks on obj.
    var error = tryCatchOn(obj, name, callback, this);
    _listening = void 0;

    if (error) throw error;
    // If the target obj is not Backbone.Events, track events manually.
    if (listening.interop) listening.on(name, callback);

    return this;
  };

  // The reducing API that adds a callback to the `events` object.
  var onApi = function(events, name, callback, options) {
    if (callback) {
      var handlers = events[name] || (events[name] = []);
      var context = options.context, ctx = options.ctx, listening = options.listening;
      if (listening) listening.count++;

      handlers.push({callback: callback, context: context, ctx: context || ctx, listening: listening});
    }
    return events;
  };

  // An try-catch guarded #on function, to prevent poisoning the global
  // `_listening` variable.
  var tryCatchOn = function(obj, name, callback, context) {
    try {
      obj.on(name, callback, context);
    } catch (e) {
      return e;
    }
  };

  // Remove one or many callbacks. If `context` is null, removes all
  // callbacks with that function. If `callback` is null, removes all
  // callbacks for the event. If `name` is null, removes all bound
  // callbacks for all events.
  Events.off = function(name, callback, context) {
    if (!this._events) return this;
    this._events = eventsApi(offApi, this._events, name, callback, {
      context: context,
      listeners: this._listeners
    });

    return this;
  };

  // Tell this object to stop listening to either specific events ... or
  // to every object it's currently listening to.
  Events.stopListening = function(obj, name, callback) {
    var listeningTo = this._listeningTo;
    if (!listeningTo) return this;

    var ids = obj ? [obj._listenId] : _.keys(listeningTo);
    for (var i = 0; i < ids.length; i++) {
      var listening = listeningTo[ids[i]];

      // If listening doesn't exist, this object is not currently
      // listening to obj. Break out early.
      if (!listening) break;

      listening.obj.off(name, callback, this);
      if (listening.interop) listening.off(name, callback);
    }
    if (_.isEmpty(listeningTo)) this._listeningTo = void 0;

    return this;
  };

  // The reducing API that removes a callback from the `events` object.
  var offApi = function(events, name, callback, options) {
    if (!events) return;

    var context = options.context, listeners = options.listeners;
    var i = 0, names;

    // Delete all event listeners and "drop" events.
    if (!name && !context && !callback) {
      for (names = _.keys(listeners); i < names.length; i++) {
        listeners[names[i]].cleanup();
      }
      return;
    }

    names = name ? [name] : _.keys(events);
    for (; i < names.length; i++) {
      name = names[i];
      var handlers = events[name];

      // Bail out if there are no events stored.
      if (!handlers) break;

      // Find any remaining events.
      var remaining = [];
      for (var j = 0; j < handlers.length; j++) {
        var handler = handlers[j];
        if (
          callback && callback !== handler.callback &&
            callback !== handler.callback._callback ||
              context && context !== handler.context
        ) {
          remaining.push(handler);
        } else {
          var listening = handler.listening;
          if (listening) listening.off(name, callback);
        }
      }

      // Replace events if there are any remaining.  Otherwise, clean up.
      if (remaining.length) {
        events[name] = remaining;
      } else {
        delete events[name];
      }
    }

    return events;
  };

  // Bind an event to only be triggered a single time. After the first time
  // the callback is invoked, its listener will be removed. If multiple events
  // are passed in using the space-separated syntax, the handler will fire
  // once for each event, not once for a combination of all events.
  Events.once = function(name, callback, context) {
    // Map the event into a `{event: once}` object.
    var events = eventsApi(onceMap, {}, name, callback, this.off.bind(this));
    if (typeof name === 'string' && context == null) callback = void 0;
    return this.on(events, callback, context);
  };

  // Inversion-of-control versions of `once`.
  Events.listenToOnce = function(obj, name, callback) {
    // Map the event into a `{event: once}` object.
    var events = eventsApi(onceMap, {}, name, callback, this.stopListening.bind(this, obj));
    return this.listenTo(obj, events);
  };

  // Reduces the event callbacks into a map of `{event: onceWrapper}`.
  // `offer` unbinds the `onceWrapper` after it has been called.
  var onceMap = function(map, name, callback, offer) {
    if (callback) {
      var once = map[name] = _.once(function() {
        offer(name, once);
        callback.apply(this, arguments);
      });
      once._callback = callback;
    }
    return map;
  };

  // Trigger one or many events, firing all bound callbacks. Callbacks are
  // passed the same arguments as `trigger` is, apart from the event name
  // (unless you're listening on `"all"`, which will cause your callback to
  // receive the true name of the event as the first argument).
  Events.trigger = function(name) {
    if (!this._events) return this;

    var length = Math.max(0, arguments.length - 1);
    var args = Array(length);
    for (var i = 0; i < length; i++) args[i] = arguments[i + 1];

    eventsApi(triggerApi, this._events, name, void 0, args);
    return this;
  };

  // Handles triggering the appropriate event callbacks.
  var triggerApi = function(objEvents, name, callback, args) {
    if (objEvents) {
      var events = objEvents[name];
      var allEvents = objEvents.all;
      if (events && allEvents) allEvents = allEvents.slice();
      if (events) triggerEvents(events, args);
      if (allEvents) triggerEvents(allEvents, [name].concat(args));
    }
    return objEvents;
  };

  // A difficult-to-believe, but optimized internal dispatch function for
  // triggering events. Tries to keep the usual cases speedy (most internal
  // Backbone events have 3 arguments).
  var triggerEvents = function(events, args) {
    var ev, i = -1, l = events.length, a1 = args[0], a2 = args[1], a3 = args[2];
    switch (args.length) {
      case 0: while (++i < l) (ev = events[i]).callback.call(ev.ctx); return;
      case 1: while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1); return;
      case 2: while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1, a2); return;
      case 3: while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1, a2, a3); return;
      default: while (++i < l) (ev = events[i]).callback.apply(ev.ctx, args); return;
    }
  };

  // A listening class that tracks and cleans up memory bindings
  // when all callbacks have been offed.
  var Listening = function(listener, obj) {
    this.id = listener._listenId;
    this.listener = listener;
    this.obj = obj;
    this.interop = true;
    this.count = 0;
    this._events = void 0;
  };

  Listening.prototype.on = Events.on;

  // Offs a callback (or several).
  // Uses an optimized counter if the listenee uses Backbone.Events.
  // Otherwise, falls back to manual tracking to support events
  // library interop.
  Listening.prototype.off = function(name, callback) {
    var cleanup;
    if (this.interop) {
      this._events = eventsApi(offApi, this._events, name, callback, {
        context: void 0,
        listeners: void 0
      });
      cleanup = !this._events;
    } else {
      this.count--;
      cleanup = this.count === 0;
    }
    if (cleanup) this.cleanup();
  };

  // Cleans up memory bindings between the listener and the listenee.
  Listening.prototype.cleanup = function() {
    delete this.listener._listeningTo[this.obj._listenId];
    if (!this.interop) delete this.obj._listeners[this.id];
  };

  // Aliases for backwards compatibility.
  Events.bind   = Events.on;
  Events.unbind = Events.off;

  // Allow the `Backbone` object to serve as a global event bus, for folks who
  // want global "pubsub" in a convenient place.
  _.extend(Backbone, Events);

  // Backbone.Model
  // --------------

  // Backbone **Models** are the basic data object in the framework --
  // frequently representing a row in a table in a database on your server.
  // A discrete chunk of data and a bunch of useful, related methods for
  // performing computations and transformations on that data.

  // Create a new model with the specified attributes. A client id (`cid`)
  // is automatically generated and assigned for you.
  var Model = Backbone.Model = function(attributes, options) {
    var attrs = attributes || {};
    options || (options = {});
    this.preinitialize.apply(this, arguments);
    this.cid = _.uniqueId(this.cidPrefix);
    this.attributes = {};
    if (options.collection) this.collection = options.collection;
    if (options.parse) attrs = this.parse(attrs, options) || {};
    var defaults = _.result(this, 'defaults');
    attrs = _.defaults(_.extend({}, defaults, attrs), defaults);
    this.set(attrs, options);
    this.changed = {};
    this.initialize.apply(this, arguments);
  };

  // Attach all inheritable methods to the Model prototype.
  _.extend(Model.prototype, Events, {

    // A hash of attributes whose current and previous value differ.
    changed: null,

    // The value returned during the last failed validation.
    validationError: null,

    // The default name for the JSON `id` attribute is `"id"`. MongoDB and
    // CouchDB users may want to set this to `"_id"`.
    idAttribute: 'id',

    // The prefix is used to create the client id which is used to identify models locally.
    // You may want to override this if you're experiencing name clashes with model ids.
    cidPrefix: 'c',

    // preinitialize is an empty function by default. You can override it with a function
    // or object.  preinitialize will run before any instantiation logic is run in the Model.
    preinitialize: function(){},

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // Return a copy of the model's `attributes` object.
    toJSON: function(options) {
      return _.clone(this.attributes);
    },

    // Proxy `Backbone.sync` by default -- but override this if you need
    // custom syncing semantics for *this* particular model.
    sync: function() {
      return Backbone.sync.apply(this, arguments);
    },

    // Get the value of an attribute.
    get: function(attr) {
      return this.attributes[attr];
    },

    // Get the HTML-escaped value of an attribute.
    escape: function(attr) {
      return _.escape(this.get(attr));
    },

    // Returns `true` if the attribute contains a value that is not null
    // or undefined.
    has: function(attr) {
      return this.get(attr) != null;
    },

    // Special-cased proxy to underscore's `_.matches` method.
    matches: function(attrs) {
      return !!_.iteratee(attrs, this)(this.attributes);
    },

    // Set a hash of model attributes on the object, firing `"change"`. This is
    // the core primitive operation of a model, updating the data and notifying
    // anyone who needs to know about the change in state. The heart of the beast.
    set: function(key, val, options) {
      if (key == null) return this;

      // Handle both `"key", value` and `{key: value}` -style arguments.
      var attrs;
      if (typeof key === 'object') {
        attrs = key;
        options = val;
      } else {
        (attrs = {})[key] = val;
      }

      options || (options = {});

      // Run validation.
      if (!this._validate(attrs, options)) return false;

      // Extract attributes and options.
      var unset      = options.unset;
      var silent     = options.silent;
      var changes    = [];
      var changing   = this._changing;
      this._changing = true;

      if (!changing) {
        this._previousAttributes = _.clone(this.attributes);
        this.changed = {};
      }

      var current = this.attributes;
      var changed = this.changed;
      var prev    = this._previousAttributes;

      // For each `set` attribute, update or delete the current value.
      for (var attr in attrs) {
        val = attrs[attr];
        if (!_.isEqual(current[attr], val)) changes.push(attr);
        if (!_.isEqual(prev[attr], val)) {
          changed[attr] = val;
        } else {
          delete changed[attr];
        }
        unset ? delete current[attr] : current[attr] = val;
      }

      // Update the `id`.
      if (this.idAttribute in attrs) this.id = this.get(this.idAttribute);

      // Trigger all relevant attribute changes.
      if (!silent) {
        if (changes.length) this._pending = options;
        for (var i = 0; i < changes.length; i++) {
          this.trigger('change:' + changes[i], this, current[changes[i]], options);
        }
      }

      // You might be wondering why there's a `while` loop here. Changes can
      // be recursively nested within `"change"` events.
      if (changing) return this;
      if (!silent) {
        while (this._pending) {
          options = this._pending;
          this._pending = false;
          this.trigger('change', this, options);
        }
      }
      this._pending = false;
      this._changing = false;
      return this;
    },

    // Remove an attribute from the model, firing `"change"`. `unset` is a noop
    // if the attribute doesn't exist.
    unset: function(attr, options) {
      return this.set(attr, void 0, _.extend({}, options, {unset: true}));
    },

    // Clear all attributes on the model, firing `"change"`.
    clear: function(options) {
      var attrs = {};
      for (var key in this.attributes) attrs[key] = void 0;
      return this.set(attrs, _.extend({}, options, {unset: true}));
    },

    // Determine if the model has changed since the last `"change"` event.
    // If you specify an attribute name, determine if that attribute has changed.
    hasChanged: function(attr) {
      if (attr == null) return !_.isEmpty(this.changed);
      return _.has(this.changed, attr);
    },

    // Return an object containing all the attributes that have changed, or
    // false if there are no changed attributes. Useful for determining what
    // parts of a view need to be updated and/or what attributes need to be
    // persisted to the server. Unset attributes will be set to undefined.
    // You can also pass an attributes object to diff against the model,
    // determining if there *would be* a change.
    changedAttributes: function(diff) {
      if (!diff) return this.hasChanged() ? _.clone(this.changed) : false;
      var old = this._changing ? this._previousAttributes : this.attributes;
      var changed = {};
      var hasChanged;
      for (var attr in diff) {
        var val = diff[attr];
        if (_.isEqual(old[attr], val)) continue;
        changed[attr] = val;
        hasChanged = true;
      }
      return hasChanged ? changed : false;
    },

    // Get the previous value of an attribute, recorded at the time the last
    // `"change"` event was fired.
    previous: function(attr) {
      if (attr == null || !this._previousAttributes) return null;
      return this._previousAttributes[attr];
    },

    // Get all of the attributes of the model at the time of the previous
    // `"change"` event.
    previousAttributes: function() {
      return _.clone(this._previousAttributes);
    },

    // Fetch the model from the server, merging the response with the model's
    // local attributes. Any changed attributes will trigger a "change" event.
    fetch: function(options) {
      options = _.extend({parse: true}, options);
      var model = this;
      var success = options.success;
      options.success = function(resp) {
        var serverAttrs = options.parse ? model.parse(resp, options) : resp;
        if (!model.set(serverAttrs, options)) return false;
        if (success) success.call(options.context, model, resp, options);
        model.trigger('sync', model, resp, options);
      };
      wrapError(this, options);
      return this.sync('read', this, options);
    },

    // Set a hash of model attributes, and sync the model to the server.
    // If the server returns an attributes hash that differs, the model's
    // state will be `set` again.
    save: function(key, val, options) {
      // Handle both `"key", value` and `{key: value}` -style arguments.
      var attrs;
      if (key == null || typeof key === 'object') {
        attrs = key;
        options = val;
      } else {
        (attrs = {})[key] = val;
      }

      options = _.extend({validate: true, parse: true}, options);
      var wait = options.wait;

      // If we're not waiting and attributes exist, save acts as
      // `set(attr).save(null, opts)` with validation. Otherwise, check if
      // the model will be valid when the attributes, if any, are set.
      if (attrs && !wait) {
        if (!this.set(attrs, options)) return false;
      } else if (!this._validate(attrs, options)) {
        return false;
      }

      // After a successful server-side save, the client is (optionally)
      // updated with the server-side state.
      var model = this;
      var success = options.success;
      var attributes = this.attributes;
      options.success = function(resp) {
        // Ensure attributes are restored during synchronous saves.
        model.attributes = attributes;
        var serverAttrs = options.parse ? model.parse(resp, options) : resp;
        if (wait) serverAttrs = _.extend({}, attrs, serverAttrs);
        if (serverAttrs && !model.set(serverAttrs, options)) return false;
        if (success) success.call(options.context, model, resp, options);
        model.trigger('sync', model, resp, options);
      };
      wrapError(this, options);

      // Set temporary attributes if `{wait: true}` to properly find new ids.
      if (attrs && wait) this.attributes = _.extend({}, attributes, attrs);

      var method = this.isNew() ? 'create' : options.patch ? 'patch' : 'update';
      if (method === 'patch' && !options.attrs) options.attrs = attrs;
      var xhr = this.sync(method, this, options);

      // Restore attributes.
      this.attributes = attributes;

      return xhr;
    },

    // Destroy this model on the server if it was already persisted.
    // Optimistically removes the model from its collection, if it has one.
    // If `wait: true` is passed, waits for the server to respond before removal.
    destroy: function(options) {
      options = options ? _.clone(options) : {};
      var model = this;
      var success = options.success;
      var wait = options.wait;

      var destroy = function() {
        model.stopListening();
        model.trigger('destroy', model, model.collection, options);
      };

      options.success = function(resp) {
        if (wait) destroy();
        if (success) success.call(options.context, model, resp, options);
        if (!model.isNew()) model.trigger('sync', model, resp, options);
      };

      var xhr = false;
      if (this.isNew()) {
        _.defer(options.success);
      } else {
        wrapError(this, options);
        xhr = this.sync('delete', this, options);
      }
      if (!wait) destroy();
      return xhr;
    },

    // Default URL for the model's representation on the server -- if you're
    // using Backbone's restful methods, override this to change the endpoint
    // that will be called.
    url: function() {
      var base =
        _.result(this, 'urlRoot') ||
        _.result(this.collection, 'url') ||
        urlError();
      if (this.isNew()) return base;
      var id = this.get(this.idAttribute);
      return base.replace(/[^\/]$/, '$&/') + encodeURIComponent(id);
    },

    // **parse** converts a response into the hash of attributes to be `set` on
    // the model. The default implementation is just to pass the response along.
    parse: function(resp, options) {
      return resp;
    },

    // Create a new model with identical attributes to this one.
    clone: function() {
      return new this.constructor(this.attributes);
    },

    // A model is new if it has never been saved to the server, and lacks an id.
    isNew: function() {
      return !this.has(this.idAttribute);
    },

    // Check if the model is currently in a valid state.
    isValid: function(options) {
      return this._validate({}, _.extend({}, options, {validate: true}));
    },

    // Run validation against the next complete set of model attributes,
    // returning `true` if all is well. Otherwise, fire an `"invalid"` event.
    _validate: function(attrs, options) {
      if (!options.validate || !this.validate) return true;
      attrs = _.extend({}, this.attributes, attrs);
      var error = this.validationError = this.validate(attrs, options) || null;
      if (!error) return true;
      this.trigger('invalid', this, error, _.extend(options, {validationError: error}));
      return false;
    }

  });

  // Backbone.Collection
  // -------------------

  // If models tend to represent a single row of data, a Backbone Collection is
  // more analogous to a table full of data ... or a small slice or page of that
  // table, or a collection of rows that belong together for a particular reason
  // -- all of the messages in this particular folder, all of the documents
  // belonging to this particular author, and so on. Collections maintain
  // indexes of their models, both in order, and for lookup by `id`.

  // Create a new **Collection**, perhaps to contain a specific type of `model`.
  // If a `comparator` is specified, the Collection will maintain
  // its models in sort order, as they're added and removed.
  var Collection = Backbone.Collection = function(models, options) {
    options || (options = {});
    this.preinitialize.apply(this, arguments);
    if (options.model) this.model = options.model;
    if (options.comparator !== void 0) this.comparator = options.comparator;
    this._reset();
    this.initialize.apply(this, arguments);
    if (models) this.reset(models, _.extend({silent: true}, options));
  };

  // Default options for `Collection#set`.
  var setOptions = {add: true, remove: true, merge: true};
  var addOptions = {add: true, remove: false};

  // Splices `insert` into `array` at index `at`.
  var splice = function(array, insert, at) {
    at = Math.min(Math.max(at, 0), array.length);
    var tail = Array(array.length - at);
    var length = insert.length;
    var i;
    for (i = 0; i < tail.length; i++) tail[i] = array[i + at];
    for (i = 0; i < length; i++) array[i + at] = insert[i];
    for (i = 0; i < tail.length; i++) array[i + length + at] = tail[i];
  };

  // Define the Collection's inheritable methods.
  _.extend(Collection.prototype, Events, {

    // The default model for a collection is just a **Backbone.Model**.
    // This should be overridden in most cases.
    model: Model,


    // preinitialize is an empty function by default. You can override it with a function
    // or object.  preinitialize will run before any instantiation logic is run in the Collection.
    preinitialize: function(){},

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // The JSON representation of a Collection is an array of the
    // models' attributes.
    toJSON: function(options) {
      return this.map(function(model) { return model.toJSON(options); });
    },

    // Proxy `Backbone.sync` by default.
    sync: function() {
      return Backbone.sync.apply(this, arguments);
    },

    // Add a model, or list of models to the set. `models` may be Backbone
    // Models or raw JavaScript objects to be converted to Models, or any
    // combination of the two.
    add: function(models, options) {
      return this.set(models, _.extend({merge: false}, options, addOptions));
    },

    // Remove a model, or a list of models from the set.
    remove: function(models, options) {
      options = _.extend({}, options);
      var singular = !_.isArray(models);
      models = singular ? [models] : models.slice();
      var removed = this._removeModels(models, options);
      if (!options.silent && removed.length) {
        options.changes = {added: [], merged: [], removed: removed};
        this.trigger('update', this, options);
      }
      return singular ? removed[0] : removed;
    },

    // Update a collection by `set`-ing a new list of models, adding new ones,
    // removing models that are no longer present, and merging models that
    // already exist in the collection, as necessary. Similar to **Model#set**,
    // the core operation for updating the data contained by the collection.
    set: function(models, options) {
      if (models == null) return;

      options = _.extend({}, setOptions, options);
      if (options.parse && !this._isModel(models)) {
        models = this.parse(models, options) || [];
      }

      var singular = !_.isArray(models);
      models = singular ? [models] : models.slice();

      var at = options.at;
      if (at != null) at = +at;
      if (at > this.length) at = this.length;
      if (at < 0) at += this.length + 1;

      var set = [];
      var toAdd = [];
      var toMerge = [];
      var toRemove = [];
      var modelMap = {};

      var add = options.add;
      var merge = options.merge;
      var remove = options.remove;

      var sort = false;
      var sortable = this.comparator && at == null && options.sort !== false;
      var sortAttr = _.isString(this.comparator) ? this.comparator : null;

      // Turn bare objects into model references, and prevent invalid models
      // from being added.
      var model, i;
      for (i = 0; i < models.length; i++) {
        model = models[i];

        // If a duplicate is found, prevent it from being added and
        // optionally merge it into the existing model.
        var existing = this.get(model);
        if (existing) {
          if (merge && model !== existing) {
            var attrs = this._isModel(model) ? model.attributes : model;
            if (options.parse) attrs = existing.parse(attrs, options);
            existing.set(attrs, options);
            toMerge.push(existing);
            if (sortable && !sort) sort = existing.hasChanged(sortAttr);
          }
          if (!modelMap[existing.cid]) {
            modelMap[existing.cid] = true;
            set.push(existing);
          }
          models[i] = existing;

        // If this is a new, valid model, push it to the `toAdd` list.
        } else if (add) {
          model = models[i] = this._prepareModel(model, options);
          if (model) {
            toAdd.push(model);
            this._addReference(model, options);
            modelMap[model.cid] = true;
            set.push(model);
          }
        }
      }

      // Remove stale models.
      if (remove) {
        for (i = 0; i < this.length; i++) {
          model = this.models[i];
          if (!modelMap[model.cid]) toRemove.push(model);
        }
        if (toRemove.length) this._removeModels(toRemove, options);
      }

      // See if sorting is needed, update `length` and splice in new models.
      var orderChanged = false;
      var replace = !sortable && add && remove;
      if (set.length && replace) {
        orderChanged = this.length !== set.length || _.some(this.models, function(m, index) {
          return m !== set[index];
        });
        this.models.length = 0;
        splice(this.models, set, 0);
        this.length = this.models.length;
      } else if (toAdd.length) {
        if (sortable) sort = true;
        splice(this.models, toAdd, at == null ? this.length : at);
        this.length = this.models.length;
      }

      // Silently sort the collection if appropriate.
      if (sort) this.sort({silent: true});

      // Unless silenced, it's time to fire all appropriate add/sort/update events.
      if (!options.silent) {
        for (i = 0; i < toAdd.length; i++) {
          if (at != null) options.index = at + i;
          model = toAdd[i];
          model.trigger('add', model, this, options);
        }
        if (sort || orderChanged) this.trigger('sort', this, options);
        if (toAdd.length || toRemove.length || toMerge.length) {
          options.changes = {
            added: toAdd,
            removed: toRemove,
            merged: toMerge
          };
          this.trigger('update', this, options);
        }
      }

      // Return the added (or merged) model (or models).
      return singular ? models[0] : models;
    },

    // When you have more items than you want to add or remove individually,
    // you can reset the entire set with a new list of models, without firing
    // any granular `add` or `remove` events. Fires `reset` when finished.
    // Useful for bulk operations and optimizations.
    reset: function(models, options) {
      options = options ? _.clone(options) : {};
      for (var i = 0; i < this.models.length; i++) {
        this._removeReference(this.models[i], options);
      }
      options.previousModels = this.models;
      this._reset();
      models = this.add(models, _.extend({silent: true}, options));
      if (!options.silent) this.trigger('reset', this, options);
      return models;
    },

    // Add a model to the end of the collection.
    push: function(model, options) {
      return this.add(model, _.extend({at: this.length}, options));
    },

    // Remove a model from the end of the collection.
    pop: function(options) {
      var model = this.at(this.length - 1);
      return this.remove(model, options);
    },

    // Add a model to the beginning of the collection.
    unshift: function(model, options) {
      return this.add(model, _.extend({at: 0}, options));
    },

    // Remove a model from the beginning of the collection.
    shift: function(options) {
      var model = this.at(0);
      return this.remove(model, options);
    },

    // Slice out a sub-array of models from the collection.
    slice: function() {
      return slice.apply(this.models, arguments);
    },

    // Get a model from the set by id, cid, model object with id or cid
    // properties, or an attributes object that is transformed through modelId.
    get: function(obj) {
      if (obj == null) return void 0;
      return this._byId[obj] ||
        this._byId[this.modelId(this._isModel(obj) ? obj.attributes : obj)] ||
        obj.cid && this._byId[obj.cid];
    },

    // Returns `true` if the model is in the collection.
    has: function(obj) {
      return this.get(obj) != null;
    },

    // Get the model at the given index.
    at: function(index) {
      if (index < 0) index += this.length;
      return this.models[index];
    },

    // Return models with matching attributes. Useful for simple cases of
    // `filter`.
    where: function(attrs, first) {
      return this[first ? 'find' : 'filter'](attrs);
    },

    // Return the first model with matching attributes. Useful for simple cases
    // of `find`.
    findWhere: function(attrs) {
      return this.where(attrs, true);
    },

    // Force the collection to re-sort itself. You don't need to call this under
    // normal circumstances, as the set will maintain sort order as each item
    // is added.
    sort: function(options) {
      var comparator = this.comparator;
      if (!comparator) throw new Error('Cannot sort a set without a comparator');
      options || (options = {});

      var length = comparator.length;
      if (_.isFunction(comparator)) comparator = comparator.bind(this);

      // Run sort based on type of `comparator`.
      if (length === 1 || _.isString(comparator)) {
        this.models = this.sortBy(comparator);
      } else {
        this.models.sort(comparator);
      }
      if (!options.silent) this.trigger('sort', this, options);
      return this;
    },

    // Pluck an attribute from each model in the collection.
    pluck: function(attr) {
      return this.map(attr + '');
    },

    // Fetch the default set of models for this collection, resetting the
    // collection when they arrive. If `reset: true` is passed, the response
    // data will be passed through the `reset` method instead of `set`.
    fetch: function(options) {
      options = _.extend({parse: true}, options);
      var success = options.success;
      var collection = this;
      options.success = function(resp) {
        var method = options.reset ? 'reset' : 'set';
        collection[method](resp, options);
        if (success) success.call(options.context, collection, resp, options);
        collection.trigger('sync', collection, resp, options);
      };
      wrapError(this, options);
      return this.sync('read', this, options);
    },

    // Create a new instance of a model in this collection. Add the model to the
    // collection immediately, unless `wait: true` is passed, in which case we
    // wait for the server to agree.
    create: function(model, options) {
      options = options ? _.clone(options) : {};
      var wait = options.wait;
      model = this._prepareModel(model, options);
      if (!model) return false;
      if (!wait) this.add(model, options);
      var collection = this;
      var success = options.success;
      options.success = function(m, resp, callbackOpts) {
        if (wait) collection.add(m, callbackOpts);
        if (success) success.call(callbackOpts.context, m, resp, callbackOpts);
      };
      model.save(null, options);
      return model;
    },

    // **parse** converts a response into a list of models to be added to the
    // collection. The default implementation is just to pass it through.
    parse: function(resp, options) {
      return resp;
    },

    // Create a new collection with an identical list of models as this one.
    clone: function() {
      return new this.constructor(this.models, {
        model: this.model,
        comparator: this.comparator
      });
    },

    // Define how to uniquely identify models in the collection.
    modelId: function(attrs) {
      return attrs[this.model.prototype.idAttribute || 'id'];
    },

    // Get an iterator of all models in this collection.
    values: function() {
      return new CollectionIterator(this, ITERATOR_VALUES);
    },

    // Get an iterator of all model IDs in this collection.
    keys: function() {
      return new CollectionIterator(this, ITERATOR_KEYS);
    },

    // Get an iterator of all [ID, model] tuples in this collection.
    entries: function() {
      return new CollectionIterator(this, ITERATOR_KEYSVALUES);
    },

    // Private method to reset all internal state. Called when the collection
    // is first initialized or reset.
    _reset: function() {
      this.length = 0;
      this.models = [];
      this._byId  = {};
    },

    // Prepare a hash of attributes (or other model) to be added to this
    // collection.
    _prepareModel: function(attrs, options) {
      if (this._isModel(attrs)) {
        if (!attrs.collection) attrs.collection = this;
        return attrs;
      }
      options = options ? _.clone(options) : {};
      options.collection = this;
      var model = new this.model(attrs, options);
      if (!model.validationError) return model;
      this.trigger('invalid', this, model.validationError, options);
      return false;
    },

    // Internal method called by both remove and set.
    _removeModels: function(models, options) {
      var removed = [];
      for (var i = 0; i < models.length; i++) {
        var model = this.get(models[i]);
        if (!model) continue;

        var index = this.indexOf(model);
        this.models.splice(index, 1);
        this.length--;

        // Remove references before triggering 'remove' event to prevent an
        // infinite loop. #3693
        delete this._byId[model.cid];
        var id = this.modelId(model.attributes);
        if (id != null) delete this._byId[id];

        if (!options.silent) {
          options.index = index;
          model.trigger('remove', model, this, options);
        }

        removed.push(model);
        this._removeReference(model, options);
      }
      return removed;
    },

    // Method for checking whether an object should be considered a model for
    // the purposes of adding to the collection.
    _isModel: function(model) {
      return model instanceof Model;
    },

    // Internal method to create a model's ties to a collection.
    _addReference: function(model, options) {
      this._byId[model.cid] = model;
      var id = this.modelId(model.attributes);
      if (id != null) this._byId[id] = model;
      model.on('all', this._onModelEvent, this);
    },

    // Internal method to sever a model's ties to a collection.
    _removeReference: function(model, options) {
      delete this._byId[model.cid];
      var id = this.modelId(model.attributes);
      if (id != null) delete this._byId[id];
      if (this === model.collection) delete model.collection;
      model.off('all', this._onModelEvent, this);
    },

    // Internal method called every time a model in the set fires an event.
    // Sets need to update their indexes when models change ids. All other
    // events simply proxy through. "add" and "remove" events that originate
    // in other collections are ignored.
    _onModelEvent: function(event, model, collection, options) {
      if (model) {
        if ((event === 'add' || event === 'remove') && collection !== this) return;
        if (event === 'destroy') this.remove(model, options);
        if (event === 'change') {
          var prevId = this.modelId(model.previousAttributes());
          var id = this.modelId(model.attributes);
          if (prevId !== id) {
            if (prevId != null) delete this._byId[prevId];
            if (id != null) this._byId[id] = model;
          }
        }
      }
      this.trigger.apply(this, arguments);
    }

  });

  // Defining an @@iterator method implements JavaScript's Iterable protocol.
  // In modern ES2015 browsers, this value is found at Symbol.iterator.
  /* global Symbol */
  var $$iterator = typeof Symbol === 'function' && Symbol.iterator;
  if ($$iterator) {
    Collection.prototype[$$iterator] = Collection.prototype.values;
  }

  // CollectionIterator
  // ------------------

  // A CollectionIterator implements JavaScript's Iterator protocol, allowing the
  // use of `for of` loops in modern browsers and interoperation between
  // Backbone.Collection and other JavaScript functions and third-party libraries
  // which can operate on Iterables.
  var CollectionIterator = function(collection, kind) {
    this._collection = collection;
    this._kind = kind;
    this._index = 0;
  };

  // This "enum" defines the three possible kinds of values which can be emitted
  // by a CollectionIterator that correspond to the values(), keys() and entries()
  // methods on Collection, respectively.
  var ITERATOR_VALUES = 1;
  var ITERATOR_KEYS = 2;
  var ITERATOR_KEYSVALUES = 3;

  // All Iterators should themselves be Iterable.
  if ($$iterator) {
    CollectionIterator.prototype[$$iterator] = function() {
      return this;
    };
  }

  CollectionIterator.prototype.next = function() {
    if (this._collection) {

      // Only continue iterating if the iterated collection is long enough.
      if (this._index < this._collection.length) {
        var model = this._collection.at(this._index);
        this._index++;

        // Construct a value depending on what kind of values should be iterated.
        var value;
        if (this._kind === ITERATOR_VALUES) {
          value = model;
        } else {
          var id = this._collection.modelId(model.attributes);
          if (this._kind === ITERATOR_KEYS) {
            value = id;
          } else { // ITERATOR_KEYSVALUES
            value = [id, model];
          }
        }
        return {value: value, done: false};
      }

      // Once exhausted, remove the reference to the collection so future
      // calls to the next method always return done.
      this._collection = void 0;
    }

    return {value: void 0, done: true};
  };

  // Backbone.View
  // -------------

  // Backbone Views are almost more convention than they are actual code. A View
  // is simply a JavaScript object that represents a logical chunk of UI in the
  // DOM. This might be a single item, an entire list, a sidebar or panel, or
  // even the surrounding frame which wraps your whole app. Defining a chunk of
  // UI as a **View** allows you to define your DOM events declaratively, without
  // having to worry about render order ... and makes it easy for the view to
  // react to specific changes in the state of your models.

  // Creating a Backbone.View creates its initial element outside of the DOM,
  // if an existing element is not provided...
  var View = Backbone.View = function(options) {
    this.cid = _.uniqueId('view');
    this.preinitialize.apply(this, arguments);
    _.extend(this, _.pick(options, viewOptions));
    this._ensureElement();
    this.initialize.apply(this, arguments);
  };

  // Cached regex to split keys for `delegate`.
  var delegateEventSplitter = /^(\S+)\s*(.*)$/;

  // List of view options to be set as properties.
  var viewOptions = ['model', 'collection', 'el', 'id', 'attributes', 'className', 'tagName', 'events'];

  // Set up all inheritable **Backbone.View** properties and methods.
  _.extend(View.prototype, Events, {

    // The default `tagName` of a View's element is `"div"`.
    tagName: 'div',

    // jQuery delegate for element lookup, scoped to DOM elements within the
    // current view. This should be preferred to global lookups where possible.
    $: function(selector) {
      return this.$el.find(selector);
    },

    // preinitialize is an empty function by default. You can override it with a function
    // or object.  preinitialize will run before any instantiation logic is run in the View
    preinitialize: function(){},

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // **render** is the core function that your view should override, in order
    // to populate its element (`this.el`), with the appropriate HTML. The
    // convention is for **render** to always return `this`.
    render: function() {
      return this;
    },

    // Remove this view by taking the element out of the DOM, and removing any
    // applicable Backbone.Events listeners.
    remove: function() {
      this._removeElement();
      this.stopListening();
      return this;
    },

    // Remove this view's element from the document and all event listeners
    // attached to it. Exposed for subclasses using an alternative DOM
    // manipulation API.
    _removeElement: function() {
      this.$el.remove();
    },

    // Change the view's element (`this.el` property) and re-delegate the
    // view's events on the new element.
    setElement: function(element) {
      this.undelegateEvents();
      this._setElement(element);
      this.delegateEvents();
      return this;
    },

    // Creates the `this.el` and `this.$el` references for this view using the
    // given `el`. `el` can be a CSS selector or an HTML string, a jQuery
    // context or an element. Subclasses can override this to utilize an
    // alternative DOM manipulation API and are only required to set the
    // `this.el` property.
    _setElement: function(el) {
      this.$el = el instanceof Backbone.$ ? el : Backbone.$(el);
      this.el = this.$el[0];
    },

    // Set callbacks, where `this.events` is a hash of
    //
    // *{"event selector": "callback"}*
    //
    //     {
    //       'mousedown .title':  'edit',
    //       'click .button':     'save',
    //       'click .open':       function(e) { ... }
    //     }
    //
    // pairs. Callbacks will be bound to the view, with `this` set properly.
    // Uses event delegation for efficiency.
    // Omitting the selector binds the event to `this.el`.
    delegateEvents: function(events) {
      events || (events = _.result(this, 'events'));
      if (!events) return this;
      this.undelegateEvents();
      for (var key in events) {
        var method = events[key];
        if (!_.isFunction(method)) method = this[method];
        if (!method) continue;
        var match = key.match(delegateEventSplitter);
        this.delegate(match[1], match[2], method.bind(this));
      }
      return this;
    },

    // Add a single event listener to the view's element (or a child element
    // using `selector`). This only works for delegate-able events: not `focus`,
    // `blur`, and not `change`, `submit`, and `reset` in Internet Explorer.
    delegate: function(eventName, selector, listener) {
      this.$el.on(eventName + '.delegateEvents' + this.cid, selector, listener);
      return this;
    },

    // Clears all callbacks previously bound to the view by `delegateEvents`.
    // You usually don't need to use this, but may wish to if you have multiple
    // Backbone views attached to the same DOM element.
    undelegateEvents: function() {
      if (this.$el) this.$el.off('.delegateEvents' + this.cid);
      return this;
    },

    // A finer-grained `undelegateEvents` for removing a single delegated event.
    // `selector` and `listener` are both optional.
    undelegate: function(eventName, selector, listener) {
      this.$el.off(eventName + '.delegateEvents' + this.cid, selector, listener);
      return this;
    },

    // Produces a DOM element to be assigned to your view. Exposed for
    // subclasses using an alternative DOM manipulation API.
    _createElement: function(tagName) {
      return document.createElement(tagName);
    },

    // Ensure that the View has a DOM element to render into.
    // If `this.el` is a string, pass it through `$()`, take the first
    // matching element, and re-assign it to `el`. Otherwise, create
    // an element from the `id`, `className` and `tagName` properties.
    _ensureElement: function() {
      if (!this.el) {
        var attrs = _.extend({}, _.result(this, 'attributes'));
        if (this.id) attrs.id = _.result(this, 'id');
        if (this.className) attrs['class'] = _.result(this, 'className');
        this.setElement(this._createElement(_.result(this, 'tagName')));
        this._setAttributes(attrs);
      } else {
        this.setElement(_.result(this, 'el'));
      }
    },

    // Set attributes from a hash on this view's element.  Exposed for
    // subclasses using an alternative DOM manipulation API.
    _setAttributes: function(attributes) {
      this.$el.attr(attributes);
    }

  });

  // Proxy Backbone class methods to Underscore functions, wrapping the model's
  // `attributes` object or collection's `models` array behind the scenes.
  //
  // collection.filter(function(model) { return model.get('age') > 10 });
  // collection.each(this.addView);
  //
  // `Function#apply` can be slow so we use the method's arg count, if we know it.
  var addMethod = function(base, length, method, attribute) {
    switch (length) {
      case 1: return function() {
        return base[method](this[attribute]);
      };
      case 2: return function(value) {
        return base[method](this[attribute], value);
      };
      case 3: return function(iteratee, context) {
        return base[method](this[attribute], cb(iteratee, this), context);
      };
      case 4: return function(iteratee, defaultVal, context) {
        return base[method](this[attribute], cb(iteratee, this), defaultVal, context);
      };
      default: return function() {
        var args = slice.call(arguments);
        args.unshift(this[attribute]);
        return base[method].apply(base, args);
      };
    }
  };

  var addUnderscoreMethods = function(Class, base, methods, attribute) {
    _.each(methods, function(length, method) {
      if (base[method]) Class.prototype[method] = addMethod(base, length, method, attribute);
    });
  };

  // Support `collection.sortBy('attr')` and `collection.findWhere({id: 1})`.
  var cb = function(iteratee, instance) {
    if (_.isFunction(iteratee)) return iteratee;
    if (_.isObject(iteratee) && !instance._isModel(iteratee)) return modelMatcher(iteratee);
    if (_.isString(iteratee)) return function(model) { return model.get(iteratee); };
    return iteratee;
  };
  var modelMatcher = function(attrs) {
    var matcher = _.matches(attrs);
    return function(model) {
      return matcher(model.attributes);
    };
  };

  // Underscore methods that we want to implement on the Collection.
  // 90% of the core usefulness of Backbone Collections is actually implemented
  // right here:
  var collectionMethods = {forEach: 3, each: 3, map: 3, collect: 3, reduce: 0,
    foldl: 0, inject: 0, reduceRight: 0, foldr: 0, find: 3, detect: 3, filter: 3,
    select: 3, reject: 3, every: 3, all: 3, some: 3, any: 3, include: 3, includes: 3,
    contains: 3, invoke: 0, max: 3, min: 3, toArray: 1, size: 1, first: 3,
    head: 3, take: 3, initial: 3, rest: 3, tail: 3, drop: 3, last: 3,
    without: 0, difference: 0, indexOf: 3, shuffle: 1, lastIndexOf: 3,
    isEmpty: 1, chain: 1, sample: 3, partition: 3, groupBy: 3, countBy: 3,
    sortBy: 3, indexBy: 3, findIndex: 3, findLastIndex: 3};


  // Underscore methods that we want to implement on the Model, mapped to the
  // number of arguments they take.
  var modelMethods = {keys: 1, values: 1, pairs: 1, invert: 1, pick: 0,
    omit: 0, chain: 1, isEmpty: 1};

  // Mix in each Underscore method as a proxy to `Collection#models`.

  _.each([
    [Collection, collectionMethods, 'models'],
    [Model, modelMethods, 'attributes']
  ], function(config) {
    var Base = config[0],
        methods = config[1],
        attribute = config[2];

    Base.mixin = function(obj) {
      var mappings = _.reduce(_.functions(obj), function(memo, name) {
        memo[name] = 0;
        return memo;
      }, {});
      addUnderscoreMethods(Base, obj, mappings, attribute);
    };

    addUnderscoreMethods(Base, _, methods, attribute);
  });

  // Backbone.sync
  // -------------

  // Override this function to change the manner in which Backbone persists
  // models to the server. You will be passed the type of request, and the
  // model in question. By default, makes a RESTful Ajax request
  // to the model's `url()`. Some possible customizations could be:
  //
  // * Use `setTimeout` to batch rapid-fire updates into a single request.
  // * Send up the models as XML instead of JSON.
  // * Persist models via WebSockets instead of Ajax.
  //
  // Turn on `Backbone.emulateHTTP` in order to send `PUT` and `DELETE` requests
  // as `POST`, with a `_method` parameter containing the true HTTP method,
  // as well as all requests with the body as `application/x-www-form-urlencoded`
  // instead of `application/json` with the model in a param named `model`.
  // Useful when interfacing with server-side languages like **PHP** that make
  // it difficult to read the body of `PUT` requests.
  Backbone.sync = function(method, model, options) {
    var type = methodMap[method];

    // Default options, unless specified.
    _.defaults(options || (options = {}), {
      emulateHTTP: Backbone.emulateHTTP,
      emulateJSON: Backbone.emulateJSON
    });

    // Default JSON-request options.
    var params = {type: type, dataType: 'json'};

    // Ensure that we have a URL.
    if (!options.url) {
      params.url = _.result(model, 'url') || urlError();
    }

    // Ensure that we have the appropriate request data.
    if (options.data == null && model && (method === 'create' || method === 'update' || method === 'patch')) {
      params.contentType = 'application/json';
      params.data = JSON.stringify(options.attrs || model.toJSON(options));
    }

    // For older servers, emulate JSON by encoding the request into an HTML-form.
    if (options.emulateJSON) {
      params.contentType = 'application/x-www-form-urlencoded';
      params.data = params.data ? {model: params.data} : {};
    }

    // For older servers, emulate HTTP by mimicking the HTTP method with `_method`
    // And an `X-HTTP-Method-Override` header.
    if (options.emulateHTTP && (type === 'PUT' || type === 'DELETE' || type === 'PATCH')) {
      params.type = 'POST';
      if (options.emulateJSON) params.data._method = type;
      var beforeSend = options.beforeSend;
      options.beforeSend = function(xhr) {
        xhr.setRequestHeader('X-HTTP-Method-Override', type);
        if (beforeSend) return beforeSend.apply(this, arguments);
      };
    }

    // Don't process data on a non-GET request.
    if (params.type !== 'GET' && !options.emulateJSON) {
      params.processData = false;
    }

    // Pass along `textStatus` and `errorThrown` from jQuery.
    var error = options.error;
    options.error = function(xhr, textStatus, errorThrown) {
      options.textStatus = textStatus;
      options.errorThrown = errorThrown;
      if (error) error.call(options.context, xhr, textStatus, errorThrown);
    };

    // Make the request, allowing the user to override any Ajax options.
    var xhr = options.xhr = Backbone.ajax(_.extend(params, options));
    model.trigger('request', model, xhr, options);
    return xhr;
  };

  // Map from CRUD to HTTP for our default `Backbone.sync` implementation.
  var methodMap = {
    create: 'POST',
    update: 'PUT',
    patch: 'PATCH',
    delete: 'DELETE',
    read: 'GET'
  };

  // Set the default implementation of `Backbone.ajax` to proxy through to `$`.
  // Override this if you'd like to use a different library.
  Backbone.ajax = function() {
    return Backbone.$.ajax.apply(Backbone.$, arguments);
  };

  // Backbone.Router
  // ---------------

  // Routers map faux-URLs to actions, and fire events when routes are
  // matched. Creating a new one sets its `routes` hash, if not set statically.
  var Router = Backbone.Router = function(options) {
    options || (options = {});
    this.preinitialize.apply(this, arguments);
    if (options.routes) this.routes = options.routes;
    this._bindRoutes();
    this.initialize.apply(this, arguments);
  };

  // Cached regular expressions for matching named param parts and splatted
  // parts of route strings.
  var optionalParam = /\((.*?)\)/g;
  var namedParam    = /(\(\?)?:\w+/g;
  var splatParam    = /\*\w+/g;
  var escapeRegExp  = /[\-{}\[\]+?.,\\\^$|#\s]/g;

  // Set up all inheritable **Backbone.Router** properties and methods.
  _.extend(Router.prototype, Events, {

    // preinitialize is an empty function by default. You can override it with a function
    // or object.  preinitialize will run before any instantiation logic is run in the Router.
    preinitialize: function(){},

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // Manually bind a single named route to a callback. For example:
    //
    //     this.route('search/:query/p:num', 'search', function(query, num) {
    //       ...
    //     });
    //
    route: function(route, name, callback) {
      if (!_.isRegExp(route)) route = this._routeToRegExp(route);
      if (_.isFunction(name)) {
        callback = name;
        name = '';
      }
      if (!callback) callback = this[name];
      var router = this;
      Backbone.history.route(route, function(fragment) {
        var args = router._extractParameters(route, fragment);
        if (router.execute(callback, args, name) !== false) {
          router.trigger.apply(router, ['route:' + name].concat(args));
          router.trigger('route', name, args);
          Backbone.history.trigger('route', router, name, args);
        }
      });
      return this;
    },

    // Execute a route handler with the provided parameters.  This is an
    // excellent place to do pre-route setup or post-route cleanup.
    execute: function(callback, args, name) {
      if (callback) callback.apply(this, args);
    },

    // Simple proxy to `Backbone.history` to save a fragment into the history.
    navigate: function(fragment, options) {
      Backbone.history.navigate(fragment, options);
      return this;
    },

    // Bind all defined routes to `Backbone.history`. We have to reverse the
    // order of the routes here to support behavior where the most general
    // routes can be defined at the bottom of the route map.
    _bindRoutes: function() {
      if (!this.routes) return;
      this.routes = _.result(this, 'routes');
      var route, routes = _.keys(this.routes);
      while ((route = routes.pop()) != null) {
        this.route(route, this.routes[route]);
      }
    },

    // Convert a route string into a regular expression, suitable for matching
    // against the current location hash.
    _routeToRegExp: function(route) {
      route = route.replace(escapeRegExp, '\\$&')
        .replace(optionalParam, '(?:$1)?')
        .replace(namedParam, function(match, optional) {
          return optional ? match : '([^/?]+)';
        })
        .replace(splatParam, '([^?]*?)');
      return new RegExp('^' + route + '(?:\\?([\\s\\S]*))?$');
    },

    // Given a route, and a URL fragment that it matches, return the array of
    // extracted decoded parameters. Empty or unmatched parameters will be
    // treated as `null` to normalize cross-browser behavior.
    _extractParameters: function(route, fragment) {
      var params = route.exec(fragment).slice(1);
      return _.map(params, function(param, i) {
        // Don't decode the search params.
        if (i === params.length - 1) return param || null;
        return param ? decodeURIComponent(param) : null;
      });
    }

  });

  // Backbone.History
  // ----------------

  // Handles cross-browser history management, based on either
  // [pushState](http://diveintohtml5.info/history.html) and real URLs, or
  // [onhashchange](https://developer.mozilla.org/en-US/docs/DOM/window.onhashchange)
  // and URL fragments. If the browser supports neither (old IE, natch),
  // falls back to polling.
  var History = Backbone.History = function() {
    this.handlers = [];
    this.checkUrl = this.checkUrl.bind(this);

    // Ensure that `History` can be used outside of the browser.
    if (typeof window !== 'undefined') {
      this.location = window.location;
      this.history = window.history;
    }
  };

  // Cached regex for stripping a leading hash/slash and trailing space.
  var routeStripper = /^[#\/]|\s+$/g;

  // Cached regex for stripping leading and trailing slashes.
  var rootStripper = /^\/+|\/+$/g;

  // Cached regex for stripping urls of hash.
  var pathStripper = /#.*$/;

  // Has the history handling already been started?
  History.started = false;

  // Set up all inheritable **Backbone.History** properties and methods.
  _.extend(History.prototype, Events, {

    // The default interval to poll for hash changes, if necessary, is
    // twenty times a second.
    interval: 50,

    // Are we at the app root?
    atRoot: function() {
      var path = this.location.pathname.replace(/[^\/]$/, '$&/');
      return path === this.root && !this.getSearch();
    },

    // Does the pathname match the root?
    matchRoot: function() {
      var path = this.decodeFragment(this.location.pathname);
      var rootPath = path.slice(0, this.root.length - 1) + '/';
      return rootPath === this.root;
    },

    // Unicode characters in `location.pathname` are percent encoded so they're
    // decoded for comparison. `%25` should not be decoded since it may be part
    // of an encoded parameter.
    decodeFragment: function(fragment) {
      return decodeURI(fragment.replace(/%25/g, '%2525'));
    },

    // In IE6, the hash fragment and search params are incorrect if the
    // fragment contains `?`.
    getSearch: function() {
      var match = this.location.href.replace(/#.*/, '').match(/\?.+/);
      return match ? match[0] : '';
    },

    // Gets the true hash value. Cannot use location.hash directly due to bug
    // in Firefox where location.hash will always be decoded.
    getHash: function(window) {
      var match = (window || this).location.href.match(/#(.*)$/);
      return match ? match[1] : '';
    },

    // Get the pathname and search params, without the root.
    getPath: function() {
      var path = this.decodeFragment(
        this.location.pathname + this.getSearch()
      ).slice(this.root.length - 1);
      return path.charAt(0) === '/' ? path.slice(1) : path;
    },

    // Get the cross-browser normalized URL fragment from the path or hash.
    getFragment: function(fragment) {
      if (fragment == null) {
        if (this._usePushState || !this._wantsHashChange) {
          fragment = this.getPath();
        } else {
          fragment = this.getHash();
        }
      }
      return fragment.replace(routeStripper, '');
    },

    // Start the hash change handling, returning `true` if the current URL matches
    // an existing route, and `false` otherwise.
    start: function(options) {
      if (History.started) throw new Error('Backbone.history has already been started');
      History.started = true;

      // Figure out the initial configuration. Do we need an iframe?
      // Is pushState desired ... is it available?
      this.options          = _.extend({root: '/'}, this.options, options);
      this.root             = this.options.root;
      this._wantsHashChange = this.options.hashChange !== false;
      this._hasHashChange   = 'onhashchange' in window && (document.documentMode === void 0 || document.documentMode > 7);
      this._useHashChange   = this._wantsHashChange && this._hasHashChange;
      this._wantsPushState  = !!this.options.pushState;
      this._hasPushState    = !!(this.history && this.history.pushState);
      this._usePushState    = this._wantsPushState && this._hasPushState;
      this.fragment         = this.getFragment();

      // Normalize root to always include a leading and trailing slash.
      this.root = ('/' + this.root + '/').replace(rootStripper, '/');

      // Transition from hashChange to pushState or vice versa if both are
      // requested.
      if (this._wantsHashChange && this._wantsPushState) {

        // If we've started off with a route from a `pushState`-enabled
        // browser, but we're currently in a browser that doesn't support it...
        if (!this._hasPushState && !this.atRoot()) {
          var rootPath = this.root.slice(0, -1) || '/';
          this.location.replace(rootPath + '#' + this.getPath());
          // Return immediately as browser will do redirect to new url
          return true;

        // Or if we've started out with a hash-based route, but we're currently
        // in a browser where it could be `pushState`-based instead...
        } else if (this._hasPushState && this.atRoot()) {
          this.navigate(this.getHash(), {replace: true});
        }

      }

      // Proxy an iframe to handle location events if the browser doesn't
      // support the `hashchange` event, HTML5 history, or the user wants
      // `hashChange` but not `pushState`.
      if (!this._hasHashChange && this._wantsHashChange && !this._usePushState) {
        this.iframe = document.createElement('iframe');
        this.iframe.src = 'javascript:0';
        this.iframe.style.display = 'none';
        this.iframe.tabIndex = -1;
        var body = document.body;
        // Using `appendChild` will throw on IE < 9 if the document is not ready.
        var iWindow = body.insertBefore(this.iframe, body.firstChild).contentWindow;
        iWindow.document.open();
        iWindow.document.close();
        iWindow.location.hash = '#' + this.fragment;
      }

      // Add a cross-platform `addEventListener` shim for older browsers.
      var addEventListener = window.addEventListener || function(eventName, listener) {
        return attachEvent('on' + eventName, listener);
      };

      // Depending on whether we're using pushState or hashes, and whether
      // 'onhashchange' is supported, determine how we check the URL state.
      if (this._usePushState) {
        addEventListener('popstate', this.checkUrl, false);
      } else if (this._useHashChange && !this.iframe) {
        addEventListener('hashchange', this.checkUrl, false);
      } else if (this._wantsHashChange) {
        this._checkUrlInterval = setInterval(this.checkUrl, this.interval);
      }

      if (!this.options.silent) return this.loadUrl();
    },

    // Disable Backbone.history, perhaps temporarily. Not useful in a real app,
    // but possibly useful for unit testing Routers.
    stop: function() {
      // Add a cross-platform `removeEventListener` shim for older browsers.
      var removeEventListener = window.removeEventListener || function(eventName, listener) {
        return detachEvent('on' + eventName, listener);
      };

      // Remove window listeners.
      if (this._usePushState) {
        removeEventListener('popstate', this.checkUrl, false);
      } else if (this._useHashChange && !this.iframe) {
        removeEventListener('hashchange', this.checkUrl, false);
      }

      // Clean up the iframe if necessary.
      if (this.iframe) {
        document.body.removeChild(this.iframe);
        this.iframe = null;
      }

      // Some environments will throw when clearing an undefined interval.
      if (this._checkUrlInterval) clearInterval(this._checkUrlInterval);
      History.started = false;
    },

    // Add a route to be tested when the fragment changes. Routes added later
    // may override previous routes.
    route: function(route, callback) {
      this.handlers.unshift({route: route, callback: callback});
    },

    // Checks the current URL to see if it has changed, and if it has,
    // calls `loadUrl`, normalizing across the hidden iframe.
    checkUrl: function(e) {
      var current = this.getFragment();

      // If the user pressed the back button, the iframe's hash will have
      // changed and we should use that for comparison.
      if (current === this.fragment && this.iframe) {
        current = this.getHash(this.iframe.contentWindow);
      }

      if (current === this.fragment) return false;
      if (this.iframe) this.navigate(current);
      this.loadUrl();
    },

    // Attempt to load the current URL fragment. If a route succeeds with a
    // match, returns `true`. If no defined routes matches the fragment,
    // returns `false`.
    loadUrl: function(fragment) {
      // If the root doesn't match, no routes can match either.
      if (!this.matchRoot()) return false;
      fragment = this.fragment = this.getFragment(fragment);
      return _.some(this.handlers, function(handler) {
        if (handler.route.test(fragment)) {
          handler.callback(fragment);
          return true;
        }
      });
    },

    // Save a fragment into the hash history, or replace the URL state if the
    // 'replace' option is passed. You are responsible for properly URL-encoding
    // the fragment in advance.
    //
    // The options object can contain `trigger: true` if you wish to have the
    // route callback be fired (not usually desirable), or `replace: true`, if
    // you wish to modify the current URL without adding an entry to the history.
    navigate: function(fragment, options) {
      if (!History.started) return false;
      if (!options || options === true) options = {trigger: !!options};

      // Normalize the fragment.
      fragment = this.getFragment(fragment || '');

      // Don't include a trailing slash on the root.
      var rootPath = this.root;
      if (fragment === '' || fragment.charAt(0) === '?') {
        rootPath = rootPath.slice(0, -1) || '/';
      }
      var url = rootPath + fragment;

      // Strip the fragment of the query and hash for matching.
      fragment = fragment.replace(pathStripper, '');

      // Decode for matching.
      var decodedFragment = this.decodeFragment(fragment);

      if (this.fragment === decodedFragment) return;
      this.fragment = decodedFragment;

      // If pushState is available, we use it to set the fragment as a real URL.
      if (this._usePushState) {
        this.history[options.replace ? 'replaceState' : 'pushState']({}, document.title, url);

      // If hash changes haven't been explicitly disabled, update the hash
      // fragment to store history.
      } else if (this._wantsHashChange) {
        this._updateHash(this.location, fragment, options.replace);
        if (this.iframe && fragment !== this.getHash(this.iframe.contentWindow)) {
          var iWindow = this.iframe.contentWindow;

          // Opening and closing the iframe tricks IE7 and earlier to push a
          // history entry on hash-tag change.  When replace is true, we don't
          // want this.
          if (!options.replace) {
            iWindow.document.open();
            iWindow.document.close();
          }

          this._updateHash(iWindow.location, fragment, options.replace);
        }

      // If you've told us that you explicitly don't want fallback hashchange-
      // based history, then `navigate` becomes a page refresh.
      } else {
        return this.location.assign(url);
      }
      if (options.trigger) return this.loadUrl(fragment);
    },

    // Update the hash location, either replacing the current entry, or adding
    // a new one to the browser history.
    _updateHash: function(location, fragment, replace) {
      if (replace) {
        var href = location.href.replace(/(javascript:|#).*$/, '');
        location.replace(href + '#' + fragment);
      } else {
        // Some browsers require that `hash` contains a leading #.
        location.hash = '#' + fragment;
      }
    }

  });

  // Create the default Backbone.history.
  Backbone.history = new History;

  // Helpers
  // -------

  // Helper function to correctly set up the prototype chain for subclasses.
  // Similar to `goog.inherits`, but uses a hash of prototype properties and
  // class properties to be extended.
  var extend = function(protoProps, staticProps) {
    var parent = this;
    var child;

    // The constructor function for the new subclass is either defined by you
    // (the "constructor" property in your `extend` definition), or defaulted
    // by us to simply call the parent constructor.
    if (protoProps && _.has(protoProps, 'constructor')) {
      child = protoProps.constructor;
    } else {
      child = function(){ return parent.apply(this, arguments); };
    }

    // Add static properties to the constructor function, if supplied.
    _.extend(child, parent, staticProps);

    // Set the prototype chain to inherit from `parent`, without calling
    // `parent`'s constructor function and add the prototype properties.
    child.prototype = _.create(parent.prototype, protoProps);
    child.prototype.constructor = child;

    // Set a convenience property in case the parent's prototype is needed
    // later.
    child.__super__ = parent.prototype;

    return child;
  };

  // Set up inheritance for the model, collection, router, view and history.
  Model.extend = Collection.extend = Router.extend = View.extend = History.extend = extend;

  // Throw an error when a URL is needed, and none is supplied.
  var urlError = function() {
    throw new Error('A "url" property or function must be specified');
  };

  // Wrap an optional error callback with a fallback error event.
  var wrapError = function(model, options) {
    var error = options.error;
    options.error = function(resp) {
      if (error) error.call(options.context, model, resp, options);
      model.trigger('error', model, resp, options);
    };
  };

  return Backbone;
});


/***/ }),

/***/ "./node_modules/bootstrap/dist/js/npm.js":
/*!***********************************************!*\
  !*** ./node_modules/bootstrap/dist/js/npm.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// This file is autogenerated via the `commonjs` Grunt task. You can require() this file in a CommonJS environment.
__webpack_require__(/*! ../../js/transition.js */ "./node_modules/bootstrap/js/transition.js")
__webpack_require__(/*! ../../js/alert.js */ "./node_modules/bootstrap/js/alert.js")
__webpack_require__(/*! ../../js/button.js */ "./node_modules/bootstrap/js/button.js")
__webpack_require__(/*! ../../js/carousel.js */ "./node_modules/bootstrap/js/carousel.js")
__webpack_require__(/*! ../../js/collapse.js */ "./node_modules/bootstrap/js/collapse.js")
__webpack_require__(/*! ../../js/dropdown.js */ "./node_modules/bootstrap/js/dropdown.js")
__webpack_require__(/*! ../../js/modal.js */ "./node_modules/bootstrap/js/modal.js")
__webpack_require__(/*! ../../js/tooltip.js */ "./node_modules/bootstrap/js/tooltip.js")
__webpack_require__(/*! ../../js/popover.js */ "./node_modules/bootstrap/js/popover.js")
__webpack_require__(/*! ../../js/scrollspy.js */ "./node_modules/bootstrap/js/scrollspy.js")
__webpack_require__(/*! ../../js/tab.js */ "./node_modules/bootstrap/js/tab.js")
__webpack_require__(/*! ../../js/affix.js */ "./node_modules/bootstrap/js/affix.js")

/***/ }),

/***/ "./node_modules/bootstrap/js/affix.js":
/*!********************************************!*\
  !*** ./node_modules/bootstrap/js/affix.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: affix.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#affix
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // AFFIX CLASS DEFINITION
  // ======================

  var Affix = function (element, options) {
    this.options = $.extend({}, Affix.DEFAULTS, options)

    var target = this.options.target === Affix.DEFAULTS.target ? $(this.options.target) : $(document).find(this.options.target)

    this.$target = target
      .on('scroll.bs.affix.data-api', $.proxy(this.checkPosition, this))
      .on('click.bs.affix.data-api',  $.proxy(this.checkPositionWithEventLoop, this))

    this.$element     = $(element)
    this.affixed      = null
    this.unpin        = null
    this.pinnedOffset = null

    this.checkPosition()
  }

  Affix.VERSION  = '3.4.1'

  Affix.RESET    = 'affix affix-top affix-bottom'

  Affix.DEFAULTS = {
    offset: 0,
    target: window
  }

  Affix.prototype.getState = function (scrollHeight, height, offsetTop, offsetBottom) {
    var scrollTop    = this.$target.scrollTop()
    var position     = this.$element.offset()
    var targetHeight = this.$target.height()

    if (offsetTop != null && this.affixed == 'top') return scrollTop < offsetTop ? 'top' : false

    if (this.affixed == 'bottom') {
      if (offsetTop != null) return (scrollTop + this.unpin <= position.top) ? false : 'bottom'
      return (scrollTop + targetHeight <= scrollHeight - offsetBottom) ? false : 'bottom'
    }

    var initializing   = this.affixed == null
    var colliderTop    = initializing ? scrollTop : position.top
    var colliderHeight = initializing ? targetHeight : height

    if (offsetTop != null && scrollTop <= offsetTop) return 'top'
    if (offsetBottom != null && (colliderTop + colliderHeight >= scrollHeight - offsetBottom)) return 'bottom'

    return false
  }

  Affix.prototype.getPinnedOffset = function () {
    if (this.pinnedOffset) return this.pinnedOffset
    this.$element.removeClass(Affix.RESET).addClass('affix')
    var scrollTop = this.$target.scrollTop()
    var position  = this.$element.offset()
    return (this.pinnedOffset = position.top - scrollTop)
  }

  Affix.prototype.checkPositionWithEventLoop = function () {
    setTimeout($.proxy(this.checkPosition, this), 1)
  }

  Affix.prototype.checkPosition = function () {
    if (!this.$element.is(':visible')) return

    var height       = this.$element.height()
    var offset       = this.options.offset
    var offsetTop    = offset.top
    var offsetBottom = offset.bottom
    var scrollHeight = Math.max($(document).height(), $(document.body).height())

    if (typeof offset != 'object')         offsetBottom = offsetTop = offset
    if (typeof offsetTop == 'function')    offsetTop    = offset.top(this.$element)
    if (typeof offsetBottom == 'function') offsetBottom = offset.bottom(this.$element)

    var affix = this.getState(scrollHeight, height, offsetTop, offsetBottom)

    if (this.affixed != affix) {
      if (this.unpin != null) this.$element.css('top', '')

      var affixType = 'affix' + (affix ? '-' + affix : '')
      var e         = $.Event(affixType + '.bs.affix')

      this.$element.trigger(e)

      if (e.isDefaultPrevented()) return

      this.affixed = affix
      this.unpin = affix == 'bottom' ? this.getPinnedOffset() : null

      this.$element
        .removeClass(Affix.RESET)
        .addClass(affixType)
        .trigger(affixType.replace('affix', 'affixed') + '.bs.affix')
    }

    if (affix == 'bottom') {
      this.$element.offset({
        top: scrollHeight - height - offsetBottom
      })
    }
  }


  // AFFIX PLUGIN DEFINITION
  // =======================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.affix')
      var options = typeof option == 'object' && option

      if (!data) $this.data('bs.affix', (data = new Affix(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.affix

  $.fn.affix             = Plugin
  $.fn.affix.Constructor = Affix


  // AFFIX NO CONFLICT
  // =================

  $.fn.affix.noConflict = function () {
    $.fn.affix = old
    return this
  }


  // AFFIX DATA-API
  // ==============

  $(window).on('load', function () {
    $('[data-spy="affix"]').each(function () {
      var $spy = $(this)
      var data = $spy.data()

      data.offset = data.offset || {}

      if (data.offsetBottom != null) data.offset.bottom = data.offsetBottom
      if (data.offsetTop    != null) data.offset.top    = data.offsetTop

      Plugin.call($spy, data)
    })
  })

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/alert.js":
/*!********************************************!*\
  !*** ./node_modules/bootstrap/js/alert.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: alert.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#alerts
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // ALERT CLASS DEFINITION
  // ======================

  var dismiss = '[data-dismiss="alert"]'
  var Alert   = function (el) {
    $(el).on('click', dismiss, this.close)
  }

  Alert.VERSION = '3.4.1'

  Alert.TRANSITION_DURATION = 150

  Alert.prototype.close = function (e) {
    var $this    = $(this)
    var selector = $this.attr('data-target')

    if (!selector) {
      selector = $this.attr('href')
      selector = selector && selector.replace(/.*(?=#[^\s]*$)/, '') // strip for ie7
    }

    selector    = selector === '#' ? [] : selector
    var $parent = $(document).find(selector)

    if (e) e.preventDefault()

    if (!$parent.length) {
      $parent = $this.closest('.alert')
    }

    $parent.trigger(e = $.Event('close.bs.alert'))

    if (e.isDefaultPrevented()) return

    $parent.removeClass('in')

    function removeElement() {
      // detach from parent, fire event then clean up data
      $parent.detach().trigger('closed.bs.alert').remove()
    }

    $.support.transition && $parent.hasClass('fade') ?
      $parent
        .one('bsTransitionEnd', removeElement)
        .emulateTransitionEnd(Alert.TRANSITION_DURATION) :
      removeElement()
  }


  // ALERT PLUGIN DEFINITION
  // =======================

  function Plugin(option) {
    return this.each(function () {
      var $this = $(this)
      var data  = $this.data('bs.alert')

      if (!data) $this.data('bs.alert', (data = new Alert(this)))
      if (typeof option == 'string') data[option].call($this)
    })
  }

  var old = $.fn.alert

  $.fn.alert             = Plugin
  $.fn.alert.Constructor = Alert


  // ALERT NO CONFLICT
  // =================

  $.fn.alert.noConflict = function () {
    $.fn.alert = old
    return this
  }


  // ALERT DATA-API
  // ==============

  $(document).on('click.bs.alert.data-api', dismiss, Alert.prototype.close)

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/button.js":
/*!*********************************************!*\
  !*** ./node_modules/bootstrap/js/button.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: button.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#buttons
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // BUTTON PUBLIC CLASS DEFINITION
  // ==============================

  var Button = function (element, options) {
    this.$element  = $(element)
    this.options   = $.extend({}, Button.DEFAULTS, options)
    this.isLoading = false
  }

  Button.VERSION  = '3.4.1'

  Button.DEFAULTS = {
    loadingText: 'loading...'
  }

  Button.prototype.setState = function (state) {
    var d    = 'disabled'
    var $el  = this.$element
    var val  = $el.is('input') ? 'val' : 'html'
    var data = $el.data()

    state += 'Text'

    if (data.resetText == null) $el.data('resetText', $el[val]())

    // push to event loop to allow forms to submit
    setTimeout($.proxy(function () {
      $el[val](data[state] == null ? this.options[state] : data[state])

      if (state == 'loadingText') {
        this.isLoading = true
        $el.addClass(d).attr(d, d).prop(d, true)
      } else if (this.isLoading) {
        this.isLoading = false
        $el.removeClass(d).removeAttr(d).prop(d, false)
      }
    }, this), 0)
  }

  Button.prototype.toggle = function () {
    var changed = true
    var $parent = this.$element.closest('[data-toggle="buttons"]')

    if ($parent.length) {
      var $input = this.$element.find('input')
      if ($input.prop('type') == 'radio') {
        if ($input.prop('checked')) changed = false
        $parent.find('.active').removeClass('active')
        this.$element.addClass('active')
      } else if ($input.prop('type') == 'checkbox') {
        if (($input.prop('checked')) !== this.$element.hasClass('active')) changed = false
        this.$element.toggleClass('active')
      }
      $input.prop('checked', this.$element.hasClass('active'))
      if (changed) $input.trigger('change')
    } else {
      this.$element.attr('aria-pressed', !this.$element.hasClass('active'))
      this.$element.toggleClass('active')
    }
  }


  // BUTTON PLUGIN DEFINITION
  // ========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.button')
      var options = typeof option == 'object' && option

      if (!data) $this.data('bs.button', (data = new Button(this, options)))

      if (option == 'toggle') data.toggle()
      else if (option) data.setState(option)
    })
  }

  var old = $.fn.button

  $.fn.button             = Plugin
  $.fn.button.Constructor = Button


  // BUTTON NO CONFLICT
  // ==================

  $.fn.button.noConflict = function () {
    $.fn.button = old
    return this
  }


  // BUTTON DATA-API
  // ===============

  $(document)
    .on('click.bs.button.data-api', '[data-toggle^="button"]', function (e) {
      var $btn = $(e.target).closest('.btn')
      Plugin.call($btn, 'toggle')
      if (!($(e.target).is('input[type="radio"], input[type="checkbox"]'))) {
        // Prevent double click on radios, and the double selections (so cancellation) on checkboxes
        e.preventDefault()
        // The target component still receive the focus
        if ($btn.is('input,button')) $btn.trigger('focus')
        else $btn.find('input:visible,button:visible').first().trigger('focus')
      }
    })
    .on('focus.bs.button.data-api blur.bs.button.data-api', '[data-toggle^="button"]', function (e) {
      $(e.target).closest('.btn').toggleClass('focus', /^focus(in)?$/.test(e.type))
    })

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/carousel.js":
/*!***********************************************!*\
  !*** ./node_modules/bootstrap/js/carousel.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: carousel.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#carousel
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // CAROUSEL CLASS DEFINITION
  // =========================

  var Carousel = function (element, options) {
    this.$element    = $(element)
    this.$indicators = this.$element.find('.carousel-indicators')
    this.options     = options
    this.paused      = null
    this.sliding     = null
    this.interval    = null
    this.$active     = null
    this.$items      = null

    this.options.keyboard && this.$element.on('keydown.bs.carousel', $.proxy(this.keydown, this))

    this.options.pause == 'hover' && !('ontouchstart' in document.documentElement) && this.$element
      .on('mouseenter.bs.carousel', $.proxy(this.pause, this))
      .on('mouseleave.bs.carousel', $.proxy(this.cycle, this))
  }

  Carousel.VERSION  = '3.4.1'

  Carousel.TRANSITION_DURATION = 600

  Carousel.DEFAULTS = {
    interval: 5000,
    pause: 'hover',
    wrap: true,
    keyboard: true
  }

  Carousel.prototype.keydown = function (e) {
    if (/input|textarea/i.test(e.target.tagName)) return
    switch (e.which) {
      case 37: this.prev(); break
      case 39: this.next(); break
      default: return
    }

    e.preventDefault()
  }

  Carousel.prototype.cycle = function (e) {
    e || (this.paused = false)

    this.interval && clearInterval(this.interval)

    this.options.interval
      && !this.paused
      && (this.interval = setInterval($.proxy(this.next, this), this.options.interval))

    return this
  }

  Carousel.prototype.getItemIndex = function (item) {
    this.$items = item.parent().children('.item')
    return this.$items.index(item || this.$active)
  }

  Carousel.prototype.getItemForDirection = function (direction, active) {
    var activeIndex = this.getItemIndex(active)
    var willWrap = (direction == 'prev' && activeIndex === 0)
                || (direction == 'next' && activeIndex == (this.$items.length - 1))
    if (willWrap && !this.options.wrap) return active
    var delta = direction == 'prev' ? -1 : 1
    var itemIndex = (activeIndex + delta) % this.$items.length
    return this.$items.eq(itemIndex)
  }

  Carousel.prototype.to = function (pos) {
    var that        = this
    var activeIndex = this.getItemIndex(this.$active = this.$element.find('.item.active'))

    if (pos > (this.$items.length - 1) || pos < 0) return

    if (this.sliding)       return this.$element.one('slid.bs.carousel', function () { that.to(pos) }) // yes, "slid"
    if (activeIndex == pos) return this.pause().cycle()

    return this.slide(pos > activeIndex ? 'next' : 'prev', this.$items.eq(pos))
  }

  Carousel.prototype.pause = function (e) {
    e || (this.paused = true)

    if (this.$element.find('.next, .prev').length && $.support.transition) {
      this.$element.trigger($.support.transition.end)
      this.cycle(true)
    }

    this.interval = clearInterval(this.interval)

    return this
  }

  Carousel.prototype.next = function () {
    if (this.sliding) return
    return this.slide('next')
  }

  Carousel.prototype.prev = function () {
    if (this.sliding) return
    return this.slide('prev')
  }

  Carousel.prototype.slide = function (type, next) {
    var $active   = this.$element.find('.item.active')
    var $next     = next || this.getItemForDirection(type, $active)
    var isCycling = this.interval
    var direction = type == 'next' ? 'left' : 'right'
    var that      = this

    if ($next.hasClass('active')) return (this.sliding = false)

    var relatedTarget = $next[0]
    var slideEvent = $.Event('slide.bs.carousel', {
      relatedTarget: relatedTarget,
      direction: direction
    })
    this.$element.trigger(slideEvent)
    if (slideEvent.isDefaultPrevented()) return

    this.sliding = true

    isCycling && this.pause()

    if (this.$indicators.length) {
      this.$indicators.find('.active').removeClass('active')
      var $nextIndicator = $(this.$indicators.children()[this.getItemIndex($next)])
      $nextIndicator && $nextIndicator.addClass('active')
    }

    var slidEvent = $.Event('slid.bs.carousel', { relatedTarget: relatedTarget, direction: direction }) // yes, "slid"
    if ($.support.transition && this.$element.hasClass('slide')) {
      $next.addClass(type)
      if (typeof $next === 'object' && $next.length) {
        $next[0].offsetWidth // force reflow
      }
      $active.addClass(direction)
      $next.addClass(direction)
      $active
        .one('bsTransitionEnd', function () {
          $next.removeClass([type, direction].join(' ')).addClass('active')
          $active.removeClass(['active', direction].join(' '))
          that.sliding = false
          setTimeout(function () {
            that.$element.trigger(slidEvent)
          }, 0)
        })
        .emulateTransitionEnd(Carousel.TRANSITION_DURATION)
    } else {
      $active.removeClass('active')
      $next.addClass('active')
      this.sliding = false
      this.$element.trigger(slidEvent)
    }

    isCycling && this.cycle()

    return this
  }


  // CAROUSEL PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.carousel')
      var options = $.extend({}, Carousel.DEFAULTS, $this.data(), typeof option == 'object' && option)
      var action  = typeof option == 'string' ? option : options.slide

      if (!data) $this.data('bs.carousel', (data = new Carousel(this, options)))
      if (typeof option == 'number') data.to(option)
      else if (action) data[action]()
      else if (options.interval) data.pause().cycle()
    })
  }

  var old = $.fn.carousel

  $.fn.carousel             = Plugin
  $.fn.carousel.Constructor = Carousel


  // CAROUSEL NO CONFLICT
  // ====================

  $.fn.carousel.noConflict = function () {
    $.fn.carousel = old
    return this
  }


  // CAROUSEL DATA-API
  // =================

  var clickHandler = function (e) {
    var $this   = $(this)
    var href    = $this.attr('href')
    if (href) {
      href = href.replace(/.*(?=#[^\s]+$)/, '') // strip for ie7
    }

    var target  = $this.attr('data-target') || href
    var $target = $(document).find(target)

    if (!$target.hasClass('carousel')) return

    var options = $.extend({}, $target.data(), $this.data())
    var slideIndex = $this.attr('data-slide-to')
    if (slideIndex) options.interval = false

    Plugin.call($target, options)

    if (slideIndex) {
      $target.data('bs.carousel').to(slideIndex)
    }

    e.preventDefault()
  }

  $(document)
    .on('click.bs.carousel.data-api', '[data-slide]', clickHandler)
    .on('click.bs.carousel.data-api', '[data-slide-to]', clickHandler)

  $(window).on('load', function () {
    $('[data-ride="carousel"]').each(function () {
      var $carousel = $(this)
      Plugin.call($carousel, $carousel.data())
    })
  })

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/collapse.js":
/*!***********************************************!*\
  !*** ./node_modules/bootstrap/js/collapse.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: collapse.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#collapse
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

/* jshint latedef: false */

+function ($) {
  'use strict';

  // COLLAPSE PUBLIC CLASS DEFINITION
  // ================================

  var Collapse = function (element, options) {
    this.$element      = $(element)
    this.options       = $.extend({}, Collapse.DEFAULTS, options)
    this.$trigger      = $('[data-toggle="collapse"][href="#' + element.id + '"],' +
                           '[data-toggle="collapse"][data-target="#' + element.id + '"]')
    this.transitioning = null

    if (this.options.parent) {
      this.$parent = this.getParent()
    } else {
      this.addAriaAndCollapsedClass(this.$element, this.$trigger)
    }

    if (this.options.toggle) this.toggle()
  }

  Collapse.VERSION  = '3.4.1'

  Collapse.TRANSITION_DURATION = 350

  Collapse.DEFAULTS = {
    toggle: true
  }

  Collapse.prototype.dimension = function () {
    var hasWidth = this.$element.hasClass('width')
    return hasWidth ? 'width' : 'height'
  }

  Collapse.prototype.show = function () {
    if (this.transitioning || this.$element.hasClass('in')) return

    var activesData
    var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing')

    if (actives && actives.length) {
      activesData = actives.data('bs.collapse')
      if (activesData && activesData.transitioning) return
    }

    var startEvent = $.Event('show.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    if (actives && actives.length) {
      Plugin.call(actives, 'hide')
      activesData || actives.data('bs.collapse', null)
    }

    var dimension = this.dimension()

    this.$element
      .removeClass('collapse')
      .addClass('collapsing')[dimension](0)
      .attr('aria-expanded', true)

    this.$trigger
      .removeClass('collapsed')
      .attr('aria-expanded', true)

    this.transitioning = 1

    var complete = function () {
      this.$element
        .removeClass('collapsing')
        .addClass('collapse in')[dimension]('')
      this.transitioning = 0
      this.$element
        .trigger('shown.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    var scrollSize = $.camelCase(['scroll', dimension].join('-'))

    this.$element
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])
  }

  Collapse.prototype.hide = function () {
    if (this.transitioning || !this.$element.hasClass('in')) return

    var startEvent = $.Event('hide.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    var dimension = this.dimension()

    this.$element[dimension](this.$element[dimension]())[0].offsetHeight

    this.$element
      .addClass('collapsing')
      .removeClass('collapse in')
      .attr('aria-expanded', false)

    this.$trigger
      .addClass('collapsed')
      .attr('aria-expanded', false)

    this.transitioning = 1

    var complete = function () {
      this.transitioning = 0
      this.$element
        .removeClass('collapsing')
        .addClass('collapse')
        .trigger('hidden.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    this.$element
      [dimension](0)
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)
  }

  Collapse.prototype.toggle = function () {
    this[this.$element.hasClass('in') ? 'hide' : 'show']()
  }

  Collapse.prototype.getParent = function () {
    return $(document).find(this.options.parent)
      .find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]')
      .each($.proxy(function (i, element) {
        var $element = $(element)
        this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element)
      }, this))
      .end()
  }

  Collapse.prototype.addAriaAndCollapsedClass = function ($element, $trigger) {
    var isOpen = $element.hasClass('in')

    $element.attr('aria-expanded', isOpen)
    $trigger
      .toggleClass('collapsed', !isOpen)
      .attr('aria-expanded', isOpen)
  }

  function getTargetFromTrigger($trigger) {
    var href
    var target = $trigger.attr('data-target')
      || (href = $trigger.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, '') // strip for ie7

    return $(document).find(target)
  }


  // COLLAPSE PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.collapse')
      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)

      if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false
      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.collapse

  $.fn.collapse             = Plugin
  $.fn.collapse.Constructor = Collapse


  // COLLAPSE NO CONFLICT
  // ====================

  $.fn.collapse.noConflict = function () {
    $.fn.collapse = old
    return this
  }


  // COLLAPSE DATA-API
  // =================

  $(document).on('click.bs.collapse.data-api', '[data-toggle="collapse"]', function (e) {
    var $this   = $(this)

    if (!$this.attr('data-target')) e.preventDefault()

    var $target = getTargetFromTrigger($this)
    var data    = $target.data('bs.collapse')
    var option  = data ? 'toggle' : $this.data()

    Plugin.call($target, option)
  })

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/dropdown.js":
/*!***********************************************!*\
  !*** ./node_modules/bootstrap/js/dropdown.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: dropdown.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#dropdowns
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // DROPDOWN CLASS DEFINITION
  // =========================

  var backdrop = '.dropdown-backdrop'
  var toggle   = '[data-toggle="dropdown"]'
  var Dropdown = function (element) {
    $(element).on('click.bs.dropdown', this.toggle)
  }

  Dropdown.VERSION = '3.4.1'

  function getParent($this) {
    var selector = $this.attr('data-target')

    if (!selector) {
      selector = $this.attr('href')
      selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\s]*$)/, '') // strip for ie7
    }

    var $parent = selector !== '#' ? $(document).find(selector) : null

    return $parent && $parent.length ? $parent : $this.parent()
  }

  function clearMenus(e) {
    if (e && e.which === 3) return
    $(backdrop).remove()
    $(toggle).each(function () {
      var $this         = $(this)
      var $parent       = getParent($this)
      var relatedTarget = { relatedTarget: this }

      if (!$parent.hasClass('open')) return

      if (e && e.type == 'click' && /input|textarea/i.test(e.target.tagName) && $.contains($parent[0], e.target)) return

      $parent.trigger(e = $.Event('hide.bs.dropdown', relatedTarget))

      if (e.isDefaultPrevented()) return

      $this.attr('aria-expanded', 'false')
      $parent.removeClass('open').trigger($.Event('hidden.bs.dropdown', relatedTarget))
    })
  }

  Dropdown.prototype.toggle = function (e) {
    var $this = $(this)

    if ($this.is('.disabled, :disabled')) return

    var $parent  = getParent($this)
    var isActive = $parent.hasClass('open')

    clearMenus()

    if (!isActive) {
      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {
        // if mobile we use a backdrop because click events don't delegate
        $(document.createElement('div'))
          .addClass('dropdown-backdrop')
          .insertAfter($(this))
          .on('click', clearMenus)
      }

      var relatedTarget = { relatedTarget: this }
      $parent.trigger(e = $.Event('show.bs.dropdown', relatedTarget))

      if (e.isDefaultPrevented()) return

      $this
        .trigger('focus')
        .attr('aria-expanded', 'true')

      $parent
        .toggleClass('open')
        .trigger($.Event('shown.bs.dropdown', relatedTarget))
    }

    return false
  }

  Dropdown.prototype.keydown = function (e) {
    if (!/(38|40|27|32)/.test(e.which) || /input|textarea/i.test(e.target.tagName)) return

    var $this = $(this)

    e.preventDefault()
    e.stopPropagation()

    if ($this.is('.disabled, :disabled')) return

    var $parent  = getParent($this)
    var isActive = $parent.hasClass('open')

    if (!isActive && e.which != 27 || isActive && e.which == 27) {
      if (e.which == 27) $parent.find(toggle).trigger('focus')
      return $this.trigger('click')
    }

    var desc = ' li:not(.disabled):visible a'
    var $items = $parent.find('.dropdown-menu' + desc)

    if (!$items.length) return

    var index = $items.index(e.target)

    if (e.which == 38 && index > 0)                 index--         // up
    if (e.which == 40 && index < $items.length - 1) index++         // down
    if (!~index)                                    index = 0

    $items.eq(index).trigger('focus')
  }


  // DROPDOWN PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this = $(this)
      var data  = $this.data('bs.dropdown')

      if (!data) $this.data('bs.dropdown', (data = new Dropdown(this)))
      if (typeof option == 'string') data[option].call($this)
    })
  }

  var old = $.fn.dropdown

  $.fn.dropdown             = Plugin
  $.fn.dropdown.Constructor = Dropdown


  // DROPDOWN NO CONFLICT
  // ====================

  $.fn.dropdown.noConflict = function () {
    $.fn.dropdown = old
    return this
  }


  // APPLY TO STANDARD DROPDOWN ELEMENTS
  // ===================================

  $(document)
    .on('click.bs.dropdown.data-api', clearMenus)
    .on('click.bs.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })
    .on('click.bs.dropdown.data-api', toggle, Dropdown.prototype.toggle)
    .on('keydown.bs.dropdown.data-api', toggle, Dropdown.prototype.keydown)
    .on('keydown.bs.dropdown.data-api', '.dropdown-menu', Dropdown.prototype.keydown)

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/modal.js":
/*!********************************************!*\
  !*** ./node_modules/bootstrap/js/modal.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: modal.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#modals
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // MODAL CLASS DEFINITION
  // ======================

  var Modal = function (element, options) {
    this.options = options
    this.$body = $(document.body)
    this.$element = $(element)
    this.$dialog = this.$element.find('.modal-dialog')
    this.$backdrop = null
    this.isShown = null
    this.originalBodyPad = null
    this.scrollbarWidth = 0
    this.ignoreBackdropClick = false
    this.fixedContent = '.navbar-fixed-top, .navbar-fixed-bottom'

    if (this.options.remote) {
      this.$element
        .find('.modal-content')
        .load(this.options.remote, $.proxy(function () {
          this.$element.trigger('loaded.bs.modal')
        }, this))
    }
  }

  Modal.VERSION = '3.4.1'

  Modal.TRANSITION_DURATION = 300
  Modal.BACKDROP_TRANSITION_DURATION = 150

  Modal.DEFAULTS = {
    backdrop: true,
    keyboard: true,
    show: true
  }

  Modal.prototype.toggle = function (_relatedTarget) {
    return this.isShown ? this.hide() : this.show(_relatedTarget)
  }

  Modal.prototype.show = function (_relatedTarget) {
    var that = this
    var e = $.Event('show.bs.modal', { relatedTarget: _relatedTarget })

    this.$element.trigger(e)

    if (this.isShown || e.isDefaultPrevented()) return

    this.isShown = true

    this.checkScrollbar()
    this.setScrollbar()
    this.$body.addClass('modal-open')

    this.escape()
    this.resize()

    this.$element.on('click.dismiss.bs.modal', '[data-dismiss="modal"]', $.proxy(this.hide, this))

    this.$dialog.on('mousedown.dismiss.bs.modal', function () {
      that.$element.one('mouseup.dismiss.bs.modal', function (e) {
        if ($(e.target).is(that.$element)) that.ignoreBackdropClick = true
      })
    })

    this.backdrop(function () {
      var transition = $.support.transition && that.$element.hasClass('fade')

      if (!that.$element.parent().length) {
        that.$element.appendTo(that.$body) // don't move modals dom position
      }

      that.$element
        .show()
        .scrollTop(0)

      that.adjustDialog()

      if (transition) {
        that.$element[0].offsetWidth // force reflow
      }

      that.$element.addClass('in')

      that.enforceFocus()

      var e = $.Event('shown.bs.modal', { relatedTarget: _relatedTarget })

      transition ?
        that.$dialog // wait for modal to slide in
          .one('bsTransitionEnd', function () {
            that.$element.trigger('focus').trigger(e)
          })
          .emulateTransitionEnd(Modal.TRANSITION_DURATION) :
        that.$element.trigger('focus').trigger(e)
    })
  }

  Modal.prototype.hide = function (e) {
    if (e) e.preventDefault()

    e = $.Event('hide.bs.modal')

    this.$element.trigger(e)

    if (!this.isShown || e.isDefaultPrevented()) return

    this.isShown = false

    this.escape()
    this.resize()

    $(document).off('focusin.bs.modal')

    this.$element
      .removeClass('in')
      .off('click.dismiss.bs.modal')
      .off('mouseup.dismiss.bs.modal')

    this.$dialog.off('mousedown.dismiss.bs.modal')

    $.support.transition && this.$element.hasClass('fade') ?
      this.$element
        .one('bsTransitionEnd', $.proxy(this.hideModal, this))
        .emulateTransitionEnd(Modal.TRANSITION_DURATION) :
      this.hideModal()
  }

  Modal.prototype.enforceFocus = function () {
    $(document)
      .off('focusin.bs.modal') // guard against infinite focus loop
      .on('focusin.bs.modal', $.proxy(function (e) {
        if (document !== e.target &&
          this.$element[0] !== e.target &&
          !this.$element.has(e.target).length) {
          this.$element.trigger('focus')
        }
      }, this))
  }

  Modal.prototype.escape = function () {
    if (this.isShown && this.options.keyboard) {
      this.$element.on('keydown.dismiss.bs.modal', $.proxy(function (e) {
        e.which == 27 && this.hide()
      }, this))
    } else if (!this.isShown) {
      this.$element.off('keydown.dismiss.bs.modal')
    }
  }

  Modal.prototype.resize = function () {
    if (this.isShown) {
      $(window).on('resize.bs.modal', $.proxy(this.handleUpdate, this))
    } else {
      $(window).off('resize.bs.modal')
    }
  }

  Modal.prototype.hideModal = function () {
    var that = this
    this.$element.hide()
    this.backdrop(function () {
      that.$body.removeClass('modal-open')
      that.resetAdjustments()
      that.resetScrollbar()
      that.$element.trigger('hidden.bs.modal')
    })
  }

  Modal.prototype.removeBackdrop = function () {
    this.$backdrop && this.$backdrop.remove()
    this.$backdrop = null
  }

  Modal.prototype.backdrop = function (callback) {
    var that = this
    var animate = this.$element.hasClass('fade') ? 'fade' : ''

    if (this.isShown && this.options.backdrop) {
      var doAnimate = $.support.transition && animate

      this.$backdrop = $(document.createElement('div'))
        .addClass('modal-backdrop ' + animate)
        .appendTo(this.$body)

      this.$element.on('click.dismiss.bs.modal', $.proxy(function (e) {
        if (this.ignoreBackdropClick) {
          this.ignoreBackdropClick = false
          return
        }
        if (e.target !== e.currentTarget) return
        this.options.backdrop == 'static'
          ? this.$element[0].focus()
          : this.hide()
      }, this))

      if (doAnimate) this.$backdrop[0].offsetWidth // force reflow

      this.$backdrop.addClass('in')

      if (!callback) return

      doAnimate ?
        this.$backdrop
          .one('bsTransitionEnd', callback)
          .emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :
        callback()

    } else if (!this.isShown && this.$backdrop) {
      this.$backdrop.removeClass('in')

      var callbackRemove = function () {
        that.removeBackdrop()
        callback && callback()
      }
      $.support.transition && this.$element.hasClass('fade') ?
        this.$backdrop
          .one('bsTransitionEnd', callbackRemove)
          .emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :
        callbackRemove()

    } else if (callback) {
      callback()
    }
  }

  // these following methods are used to handle overflowing modals

  Modal.prototype.handleUpdate = function () {
    this.adjustDialog()
  }

  Modal.prototype.adjustDialog = function () {
    var modalIsOverflowing = this.$element[0].scrollHeight > document.documentElement.clientHeight

    this.$element.css({
      paddingLeft: !this.bodyIsOverflowing && modalIsOverflowing ? this.scrollbarWidth : '',
      paddingRight: this.bodyIsOverflowing && !modalIsOverflowing ? this.scrollbarWidth : ''
    })
  }

  Modal.prototype.resetAdjustments = function () {
    this.$element.css({
      paddingLeft: '',
      paddingRight: ''
    })
  }

  Modal.prototype.checkScrollbar = function () {
    var fullWindowWidth = window.innerWidth
    if (!fullWindowWidth) { // workaround for missing window.innerWidth in IE8
      var documentElementRect = document.documentElement.getBoundingClientRect()
      fullWindowWidth = documentElementRect.right - Math.abs(documentElementRect.left)
    }
    this.bodyIsOverflowing = document.body.clientWidth < fullWindowWidth
    this.scrollbarWidth = this.measureScrollbar()
  }

  Modal.prototype.setScrollbar = function () {
    var bodyPad = parseInt((this.$body.css('padding-right') || 0), 10)
    this.originalBodyPad = document.body.style.paddingRight || ''
    var scrollbarWidth = this.scrollbarWidth
    if (this.bodyIsOverflowing) {
      this.$body.css('padding-right', bodyPad + scrollbarWidth)
      $(this.fixedContent).each(function (index, element) {
        var actualPadding = element.style.paddingRight
        var calculatedPadding = $(element).css('padding-right')
        $(element)
          .data('padding-right', actualPadding)
          .css('padding-right', parseFloat(calculatedPadding) + scrollbarWidth + 'px')
      })
    }
  }

  Modal.prototype.resetScrollbar = function () {
    this.$body.css('padding-right', this.originalBodyPad)
    $(this.fixedContent).each(function (index, element) {
      var padding = $(element).data('padding-right')
      $(element).removeData('padding-right')
      element.style.paddingRight = padding ? padding : ''
    })
  }

  Modal.prototype.measureScrollbar = function () { // thx walsh
    var scrollDiv = document.createElement('div')
    scrollDiv.className = 'modal-scrollbar-measure'
    this.$body.append(scrollDiv)
    var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth
    this.$body[0].removeChild(scrollDiv)
    return scrollbarWidth
  }


  // MODAL PLUGIN DEFINITION
  // =======================

  function Plugin(option, _relatedTarget) {
    return this.each(function () {
      var $this = $(this)
      var data = $this.data('bs.modal')
      var options = $.extend({}, Modal.DEFAULTS, $this.data(), typeof option == 'object' && option)

      if (!data) $this.data('bs.modal', (data = new Modal(this, options)))
      if (typeof option == 'string') data[option](_relatedTarget)
      else if (options.show) data.show(_relatedTarget)
    })
  }

  var old = $.fn.modal

  $.fn.modal = Plugin
  $.fn.modal.Constructor = Modal


  // MODAL NO CONFLICT
  // =================

  $.fn.modal.noConflict = function () {
    $.fn.modal = old
    return this
  }


  // MODAL DATA-API
  // ==============

  $(document).on('click.bs.modal.data-api', '[data-toggle="modal"]', function (e) {
    var $this = $(this)
    var href = $this.attr('href')
    var target = $this.attr('data-target') ||
      (href && href.replace(/.*(?=#[^\s]+$)/, '')) // strip for ie7

    var $target = $(document).find(target)
    var option = $target.data('bs.modal') ? 'toggle' : $.extend({ remote: !/#/.test(href) && href }, $target.data(), $this.data())

    if ($this.is('a')) e.preventDefault()

    $target.one('show.bs.modal', function (showEvent) {
      if (showEvent.isDefaultPrevented()) return // only register focus restorer if modal will actually get shown
      $target.one('hidden.bs.modal', function () {
        $this.is(':visible') && $this.trigger('focus')
      })
    })
    Plugin.call($target, option, this)
  })

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/popover.js":
/*!**********************************************!*\
  !*** ./node_modules/bootstrap/js/popover.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: popover.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#popovers
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // POPOVER PUBLIC CLASS DEFINITION
  // ===============================

  var Popover = function (element, options) {
    this.init('popover', element, options)
  }

  if (!$.fn.tooltip) throw new Error('Popover requires tooltip.js')

  Popover.VERSION  = '3.4.1'

  Popover.DEFAULTS = $.extend({}, $.fn.tooltip.Constructor.DEFAULTS, {
    placement: 'right',
    trigger: 'click',
    content: '',
    template: '<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'
  })


  // NOTE: POPOVER EXTENDS tooltip.js
  // ================================

  Popover.prototype = $.extend({}, $.fn.tooltip.Constructor.prototype)

  Popover.prototype.constructor = Popover

  Popover.prototype.getDefaults = function () {
    return Popover.DEFAULTS
  }

  Popover.prototype.setContent = function () {
    var $tip    = this.tip()
    var title   = this.getTitle()
    var content = this.getContent()

    if (this.options.html) {
      var typeContent = typeof content

      if (this.options.sanitize) {
        title = this.sanitizeHtml(title)

        if (typeContent === 'string') {
          content = this.sanitizeHtml(content)
        }
      }

      $tip.find('.popover-title').html(title)
      $tip.find('.popover-content').children().detach().end()[
        typeContent === 'string' ? 'html' : 'append'
      ](content)
    } else {
      $tip.find('.popover-title').text(title)
      $tip.find('.popover-content').children().detach().end().text(content)
    }

    $tip.removeClass('fade top bottom left right in')

    // IE8 doesn't accept hiding via the `:empty` pseudo selector, we have to do
    // this manually by checking the contents.
    if (!$tip.find('.popover-title').html()) $tip.find('.popover-title').hide()
  }

  Popover.prototype.hasContent = function () {
    return this.getTitle() || this.getContent()
  }

  Popover.prototype.getContent = function () {
    var $e = this.$element
    var o  = this.options

    return $e.attr('data-content')
      || (typeof o.content == 'function' ?
        o.content.call($e[0]) :
        o.content)
  }

  Popover.prototype.arrow = function () {
    return (this.$arrow = this.$arrow || this.tip().find('.arrow'))
  }


  // POPOVER PLUGIN DEFINITION
  // =========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.popover')
      var options = typeof option == 'object' && option

      if (!data && /destroy|hide/.test(option)) return
      if (!data) $this.data('bs.popover', (data = new Popover(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.popover

  $.fn.popover             = Plugin
  $.fn.popover.Constructor = Popover


  // POPOVER NO CONFLICT
  // ===================

  $.fn.popover.noConflict = function () {
    $.fn.popover = old
    return this
  }

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/scrollspy.js":
/*!************************************************!*\
  !*** ./node_modules/bootstrap/js/scrollspy.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: scrollspy.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#scrollspy
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // SCROLLSPY CLASS DEFINITION
  // ==========================

  function ScrollSpy(element, options) {
    this.$body          = $(document.body)
    this.$scrollElement = $(element).is(document.body) ? $(window) : $(element)
    this.options        = $.extend({}, ScrollSpy.DEFAULTS, options)
    this.selector       = (this.options.target || '') + ' .nav li > a'
    this.offsets        = []
    this.targets        = []
    this.activeTarget   = null
    this.scrollHeight   = 0

    this.$scrollElement.on('scroll.bs.scrollspy', $.proxy(this.process, this))
    this.refresh()
    this.process()
  }

  ScrollSpy.VERSION  = '3.4.1'

  ScrollSpy.DEFAULTS = {
    offset: 10
  }

  ScrollSpy.prototype.getScrollHeight = function () {
    return this.$scrollElement[0].scrollHeight || Math.max(this.$body[0].scrollHeight, document.documentElement.scrollHeight)
  }

  ScrollSpy.prototype.refresh = function () {
    var that          = this
    var offsetMethod  = 'offset'
    var offsetBase    = 0

    this.offsets      = []
    this.targets      = []
    this.scrollHeight = this.getScrollHeight()

    if (!$.isWindow(this.$scrollElement[0])) {
      offsetMethod = 'position'
      offsetBase   = this.$scrollElement.scrollTop()
    }

    this.$body
      .find(this.selector)
      .map(function () {
        var $el   = $(this)
        var href  = $el.data('target') || $el.attr('href')
        var $href = /^#./.test(href) && $(href)

        return ($href
          && $href.length
          && $href.is(':visible')
          && [[$href[offsetMethod]().top + offsetBase, href]]) || null
      })
      .sort(function (a, b) { return a[0] - b[0] })
      .each(function () {
        that.offsets.push(this[0])
        that.targets.push(this[1])
      })
  }

  ScrollSpy.prototype.process = function () {
    var scrollTop    = this.$scrollElement.scrollTop() + this.options.offset
    var scrollHeight = this.getScrollHeight()
    var maxScroll    = this.options.offset + scrollHeight - this.$scrollElement.height()
    var offsets      = this.offsets
    var targets      = this.targets
    var activeTarget = this.activeTarget
    var i

    if (this.scrollHeight != scrollHeight) {
      this.refresh()
    }

    if (scrollTop >= maxScroll) {
      return activeTarget != (i = targets[targets.length - 1]) && this.activate(i)
    }

    if (activeTarget && scrollTop < offsets[0]) {
      this.activeTarget = null
      return this.clear()
    }

    for (i = offsets.length; i--;) {
      activeTarget != targets[i]
        && scrollTop >= offsets[i]
        && (offsets[i + 1] === undefined || scrollTop < offsets[i + 1])
        && this.activate(targets[i])
    }
  }

  ScrollSpy.prototype.activate = function (target) {
    this.activeTarget = target

    this.clear()

    var selector = this.selector +
      '[data-target="' + target + '"],' +
      this.selector + '[href="' + target + '"]'

    var active = $(selector)
      .parents('li')
      .addClass('active')

    if (active.parent('.dropdown-menu').length) {
      active = active
        .closest('li.dropdown')
        .addClass('active')
    }

    active.trigger('activate.bs.scrollspy')
  }

  ScrollSpy.prototype.clear = function () {
    $(this.selector)
      .parentsUntil(this.options.target, '.active')
      .removeClass('active')
  }


  // SCROLLSPY PLUGIN DEFINITION
  // ===========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.scrollspy')
      var options = typeof option == 'object' && option

      if (!data) $this.data('bs.scrollspy', (data = new ScrollSpy(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.scrollspy

  $.fn.scrollspy             = Plugin
  $.fn.scrollspy.Constructor = ScrollSpy


  // SCROLLSPY NO CONFLICT
  // =====================

  $.fn.scrollspy.noConflict = function () {
    $.fn.scrollspy = old
    return this
  }


  // SCROLLSPY DATA-API
  // ==================

  $(window).on('load.bs.scrollspy.data-api', function () {
    $('[data-spy="scroll"]').each(function () {
      var $spy = $(this)
      Plugin.call($spy, $spy.data())
    })
  })

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/tab.js":
/*!******************************************!*\
  !*** ./node_modules/bootstrap/js/tab.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: tab.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#tabs
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // TAB CLASS DEFINITION
  // ====================

  var Tab = function (element) {
    // jscs:disable requireDollarBeforejQueryAssignment
    this.element = $(element)
    // jscs:enable requireDollarBeforejQueryAssignment
  }

  Tab.VERSION = '3.4.1'

  Tab.TRANSITION_DURATION = 150

  Tab.prototype.show = function () {
    var $this    = this.element
    var $ul      = $this.closest('ul:not(.dropdown-menu)')
    var selector = $this.data('target')

    if (!selector) {
      selector = $this.attr('href')
      selector = selector && selector.replace(/.*(?=#[^\s]*$)/, '') // strip for ie7
    }

    if ($this.parent('li').hasClass('active')) return

    var $previous = $ul.find('.active:last a')
    var hideEvent = $.Event('hide.bs.tab', {
      relatedTarget: $this[0]
    })
    var showEvent = $.Event('show.bs.tab', {
      relatedTarget: $previous[0]
    })

    $previous.trigger(hideEvent)
    $this.trigger(showEvent)

    if (showEvent.isDefaultPrevented() || hideEvent.isDefaultPrevented()) return

    var $target = $(document).find(selector)

    this.activate($this.closest('li'), $ul)
    this.activate($target, $target.parent(), function () {
      $previous.trigger({
        type: 'hidden.bs.tab',
        relatedTarget: $this[0]
      })
      $this.trigger({
        type: 'shown.bs.tab',
        relatedTarget: $previous[0]
      })
    })
  }

  Tab.prototype.activate = function (element, container, callback) {
    var $active    = container.find('> .active')
    var transition = callback
      && $.support.transition
      && ($active.length && $active.hasClass('fade') || !!container.find('> .fade').length)

    function next() {
      $active
        .removeClass('active')
        .find('> .dropdown-menu > .active')
        .removeClass('active')
        .end()
        .find('[data-toggle="tab"]')
        .attr('aria-expanded', false)

      element
        .addClass('active')
        .find('[data-toggle="tab"]')
        .attr('aria-expanded', true)

      if (transition) {
        element[0].offsetWidth // reflow for transition
        element.addClass('in')
      } else {
        element.removeClass('fade')
      }

      if (element.parent('.dropdown-menu').length) {
        element
          .closest('li.dropdown')
          .addClass('active')
          .end()
          .find('[data-toggle="tab"]')
          .attr('aria-expanded', true)
      }

      callback && callback()
    }

    $active.length && transition ?
      $active
        .one('bsTransitionEnd', next)
        .emulateTransitionEnd(Tab.TRANSITION_DURATION) :
      next()

    $active.removeClass('in')
  }


  // TAB PLUGIN DEFINITION
  // =====================

  function Plugin(option) {
    return this.each(function () {
      var $this = $(this)
      var data  = $this.data('bs.tab')

      if (!data) $this.data('bs.tab', (data = new Tab(this)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.tab

  $.fn.tab             = Plugin
  $.fn.tab.Constructor = Tab


  // TAB NO CONFLICT
  // ===============

  $.fn.tab.noConflict = function () {
    $.fn.tab = old
    return this
  }


  // TAB DATA-API
  // ============

  var clickHandler = function (e) {
    e.preventDefault()
    Plugin.call($(this), 'show')
  }

  $(document)
    .on('click.bs.tab.data-api', '[data-toggle="tab"]', clickHandler)
    .on('click.bs.tab.data-api', '[data-toggle="pill"]', clickHandler)

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/tooltip.js":
/*!**********************************************!*\
  !*** ./node_modules/bootstrap/js/tooltip.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: tooltip.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#tooltip
 * Inspired by the original jQuery.tipsy by Jason Frame
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

+function ($) {
  'use strict';

  var DISALLOWED_ATTRIBUTES = ['sanitize', 'whiteList', 'sanitizeFn']

  var uriAttrs = [
    'background',
    'cite',
    'href',
    'itemtype',
    'longdesc',
    'poster',
    'src',
    'xlink:href'
  ]

  var ARIA_ATTRIBUTE_PATTERN = /^aria-[\w-]*$/i

  var DefaultWhitelist = {
    // Global attributes allowed on any supplied element below.
    '*': ['class', 'dir', 'id', 'lang', 'role', ARIA_ATTRIBUTE_PATTERN],
    a: ['target', 'href', 'title', 'rel'],
    area: [],
    b: [],
    br: [],
    col: [],
    code: [],
    div: [],
    em: [],
    hr: [],
    h1: [],
    h2: [],
    h3: [],
    h4: [],
    h5: [],
    h6: [],
    i: [],
    img: ['src', 'alt', 'title', 'width', 'height'],
    li: [],
    ol: [],
    p: [],
    pre: [],
    s: [],
    small: [],
    span: [],
    sub: [],
    sup: [],
    strong: [],
    u: [],
    ul: []
  }

  /**
   * A pattern that recognizes a commonly useful subset of URLs that are safe.
   *
   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts
   */
  var SAFE_URL_PATTERN = /^(?:(?:https?|mailto|ftp|tel|file):|[^&:/?#]*(?:[/?#]|$))/gi

  /**
   * A pattern that matches safe data URLs. Only matches image, video and audio types.
   *
   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts
   */
  var DATA_URL_PATTERN = /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[a-z0-9+/]+=*$/i

  function allowedAttribute(attr, allowedAttributeList) {
    var attrName = attr.nodeName.toLowerCase()

    if ($.inArray(attrName, allowedAttributeList) !== -1) {
      if ($.inArray(attrName, uriAttrs) !== -1) {
        return Boolean(attr.nodeValue.match(SAFE_URL_PATTERN) || attr.nodeValue.match(DATA_URL_PATTERN))
      }

      return true
    }

    var regExp = $(allowedAttributeList).filter(function (index, value) {
      return value instanceof RegExp
    })

    // Check if a regular expression validates the attribute.
    for (var i = 0, l = regExp.length; i < l; i++) {
      if (attrName.match(regExp[i])) {
        return true
      }
    }

    return false
  }

  function sanitizeHtml(unsafeHtml, whiteList, sanitizeFn) {
    if (unsafeHtml.length === 0) {
      return unsafeHtml
    }

    if (sanitizeFn && typeof sanitizeFn === 'function') {
      return sanitizeFn(unsafeHtml)
    }

    // IE 8 and below don't support createHTMLDocument
    if (!document.implementation || !document.implementation.createHTMLDocument) {
      return unsafeHtml
    }

    var createdDocument = document.implementation.createHTMLDocument('sanitization')
    createdDocument.body.innerHTML = unsafeHtml

    var whitelistKeys = $.map(whiteList, function (el, i) { return i })
    var elements = $(createdDocument.body).find('*')

    for (var i = 0, len = elements.length; i < len; i++) {
      var el = elements[i]
      var elName = el.nodeName.toLowerCase()

      if ($.inArray(elName, whitelistKeys) === -1) {
        el.parentNode.removeChild(el)

        continue
      }

      var attributeList = $.map(el.attributes, function (el) { return el })
      var whitelistedAttributes = [].concat(whiteList['*'] || [], whiteList[elName] || [])

      for (var j = 0, len2 = attributeList.length; j < len2; j++) {
        if (!allowedAttribute(attributeList[j], whitelistedAttributes)) {
          el.removeAttribute(attributeList[j].nodeName)
        }
      }
    }

    return createdDocument.body.innerHTML
  }

  // TOOLTIP PUBLIC CLASS DEFINITION
  // ===============================

  var Tooltip = function (element, options) {
    this.type       = null
    this.options    = null
    this.enabled    = null
    this.timeout    = null
    this.hoverState = null
    this.$element   = null
    this.inState    = null

    this.init('tooltip', element, options)
  }

  Tooltip.VERSION  = '3.4.1'

  Tooltip.TRANSITION_DURATION = 150

  Tooltip.DEFAULTS = {
    animation: true,
    placement: 'top',
    selector: false,
    template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',
    trigger: 'hover focus',
    title: '',
    delay: 0,
    html: false,
    container: false,
    viewport: {
      selector: 'body',
      padding: 0
    },
    sanitize : true,
    sanitizeFn : null,
    whiteList : DefaultWhitelist
  }

  Tooltip.prototype.init = function (type, element, options) {
    this.enabled   = true
    this.type      = type
    this.$element  = $(element)
    this.options   = this.getOptions(options)
    this.$viewport = this.options.viewport && $(document).find($.isFunction(this.options.viewport) ? this.options.viewport.call(this, this.$element) : (this.options.viewport.selector || this.options.viewport))
    this.inState   = { click: false, hover: false, focus: false }

    if (this.$element[0] instanceof document.constructor && !this.options.selector) {
      throw new Error('`selector` option must be specified when initializing ' + this.type + ' on the window.document object!')
    }

    var triggers = this.options.trigger.split(' ')

    for (var i = triggers.length; i--;) {
      var trigger = triggers[i]

      if (trigger == 'click') {
        this.$element.on('click.' + this.type, this.options.selector, $.proxy(this.toggle, this))
      } else if (trigger != 'manual') {
        var eventIn  = trigger == 'hover' ? 'mouseenter' : 'focusin'
        var eventOut = trigger == 'hover' ? 'mouseleave' : 'focusout'

        this.$element.on(eventIn  + '.' + this.type, this.options.selector, $.proxy(this.enter, this))
        this.$element.on(eventOut + '.' + this.type, this.options.selector, $.proxy(this.leave, this))
      }
    }

    this.options.selector ?
      (this._options = $.extend({}, this.options, { trigger: 'manual', selector: '' })) :
      this.fixTitle()
  }

  Tooltip.prototype.getDefaults = function () {
    return Tooltip.DEFAULTS
  }

  Tooltip.prototype.getOptions = function (options) {
    var dataAttributes = this.$element.data()

    for (var dataAttr in dataAttributes) {
      if (dataAttributes.hasOwnProperty(dataAttr) && $.inArray(dataAttr, DISALLOWED_ATTRIBUTES) !== -1) {
        delete dataAttributes[dataAttr]
      }
    }

    options = $.extend({}, this.getDefaults(), dataAttributes, options)

    if (options.delay && typeof options.delay == 'number') {
      options.delay = {
        show: options.delay,
        hide: options.delay
      }
    }

    if (options.sanitize) {
      options.template = sanitizeHtml(options.template, options.whiteList, options.sanitizeFn)
    }

    return options
  }

  Tooltip.prototype.getDelegateOptions = function () {
    var options  = {}
    var defaults = this.getDefaults()

    this._options && $.each(this._options, function (key, value) {
      if (defaults[key] != value) options[key] = value
    })

    return options
  }

  Tooltip.prototype.enter = function (obj) {
    var self = obj instanceof this.constructor ?
      obj : $(obj.currentTarget).data('bs.' + this.type)

    if (!self) {
      self = new this.constructor(obj.currentTarget, this.getDelegateOptions())
      $(obj.currentTarget).data('bs.' + this.type, self)
    }

    if (obj instanceof $.Event) {
      self.inState[obj.type == 'focusin' ? 'focus' : 'hover'] = true
    }

    if (self.tip().hasClass('in') || self.hoverState == 'in') {
      self.hoverState = 'in'
      return
    }

    clearTimeout(self.timeout)

    self.hoverState = 'in'

    if (!self.options.delay || !self.options.delay.show) return self.show()

    self.timeout = setTimeout(function () {
      if (self.hoverState == 'in') self.show()
    }, self.options.delay.show)
  }

  Tooltip.prototype.isInStateTrue = function () {
    for (var key in this.inState) {
      if (this.inState[key]) return true
    }

    return false
  }

  Tooltip.prototype.leave = function (obj) {
    var self = obj instanceof this.constructor ?
      obj : $(obj.currentTarget).data('bs.' + this.type)

    if (!self) {
      self = new this.constructor(obj.currentTarget, this.getDelegateOptions())
      $(obj.currentTarget).data('bs.' + this.type, self)
    }

    if (obj instanceof $.Event) {
      self.inState[obj.type == 'focusout' ? 'focus' : 'hover'] = false
    }

    if (self.isInStateTrue()) return

    clearTimeout(self.timeout)

    self.hoverState = 'out'

    if (!self.options.delay || !self.options.delay.hide) return self.hide()

    self.timeout = setTimeout(function () {
      if (self.hoverState == 'out') self.hide()
    }, self.options.delay.hide)
  }

  Tooltip.prototype.show = function () {
    var e = $.Event('show.bs.' + this.type)

    if (this.hasContent() && this.enabled) {
      this.$element.trigger(e)

      var inDom = $.contains(this.$element[0].ownerDocument.documentElement, this.$element[0])
      if (e.isDefaultPrevented() || !inDom) return
      var that = this

      var $tip = this.tip()

      var tipId = this.getUID(this.type)

      this.setContent()
      $tip.attr('id', tipId)
      this.$element.attr('aria-describedby', tipId)

      if (this.options.animation) $tip.addClass('fade')

      var placement = typeof this.options.placement == 'function' ?
        this.options.placement.call(this, $tip[0], this.$element[0]) :
        this.options.placement

      var autoToken = /\s?auto?\s?/i
      var autoPlace = autoToken.test(placement)
      if (autoPlace) placement = placement.replace(autoToken, '') || 'top'

      $tip
        .detach()
        .css({ top: 0, left: 0, display: 'block' })
        .addClass(placement)
        .data('bs.' + this.type, this)

      this.options.container ? $tip.appendTo($(document).find(this.options.container)) : $tip.insertAfter(this.$element)
      this.$element.trigger('inserted.bs.' + this.type)

      var pos          = this.getPosition()
      var actualWidth  = $tip[0].offsetWidth
      var actualHeight = $tip[0].offsetHeight

      if (autoPlace) {
        var orgPlacement = placement
        var viewportDim = this.getPosition(this.$viewport)

        placement = placement == 'bottom' && pos.bottom + actualHeight > viewportDim.bottom ? 'top'    :
                    placement == 'top'    && pos.top    - actualHeight < viewportDim.top    ? 'bottom' :
                    placement == 'right'  && pos.right  + actualWidth  > viewportDim.width  ? 'left'   :
                    placement == 'left'   && pos.left   - actualWidth  < viewportDim.left   ? 'right'  :
                    placement

        $tip
          .removeClass(orgPlacement)
          .addClass(placement)
      }

      var calculatedOffset = this.getCalculatedOffset(placement, pos, actualWidth, actualHeight)

      this.applyPlacement(calculatedOffset, placement)

      var complete = function () {
        var prevHoverState = that.hoverState
        that.$element.trigger('shown.bs.' + that.type)
        that.hoverState = null

        if (prevHoverState == 'out') that.leave(that)
      }

      $.support.transition && this.$tip.hasClass('fade') ?
        $tip
          .one('bsTransitionEnd', complete)
          .emulateTransitionEnd(Tooltip.TRANSITION_DURATION) :
        complete()
    }
  }

  Tooltip.prototype.applyPlacement = function (offset, placement) {
    var $tip   = this.tip()
    var width  = $tip[0].offsetWidth
    var height = $tip[0].offsetHeight

    // manually read margins because getBoundingClientRect includes difference
    var marginTop = parseInt($tip.css('margin-top'), 10)
    var marginLeft = parseInt($tip.css('margin-left'), 10)

    // we must check for NaN for ie 8/9
    if (isNaN(marginTop))  marginTop  = 0
    if (isNaN(marginLeft)) marginLeft = 0

    offset.top  += marginTop
    offset.left += marginLeft

    // $.fn.offset doesn't round pixel values
    // so we use setOffset directly with our own function B-0
    $.offset.setOffset($tip[0], $.extend({
      using: function (props) {
        $tip.css({
          top: Math.round(props.top),
          left: Math.round(props.left)
        })
      }
    }, offset), 0)

    $tip.addClass('in')

    // check to see if placing tip in new offset caused the tip to resize itself
    var actualWidth  = $tip[0].offsetWidth
    var actualHeight = $tip[0].offsetHeight

    if (placement == 'top' && actualHeight != height) {
      offset.top = offset.top + height - actualHeight
    }

    var delta = this.getViewportAdjustedDelta(placement, offset, actualWidth, actualHeight)

    if (delta.left) offset.left += delta.left
    else offset.top += delta.top

    var isVertical          = /top|bottom/.test(placement)
    var arrowDelta          = isVertical ? delta.left * 2 - width + actualWidth : delta.top * 2 - height + actualHeight
    var arrowOffsetPosition = isVertical ? 'offsetWidth' : 'offsetHeight'

    $tip.offset(offset)
    this.replaceArrow(arrowDelta, $tip[0][arrowOffsetPosition], isVertical)
  }

  Tooltip.prototype.replaceArrow = function (delta, dimension, isVertical) {
    this.arrow()
      .css(isVertical ? 'left' : 'top', 50 * (1 - delta / dimension) + '%')
      .css(isVertical ? 'top' : 'left', '')
  }

  Tooltip.prototype.setContent = function () {
    var $tip  = this.tip()
    var title = this.getTitle()

    if (this.options.html) {
      if (this.options.sanitize) {
        title = sanitizeHtml(title, this.options.whiteList, this.options.sanitizeFn)
      }

      $tip.find('.tooltip-inner').html(title)
    } else {
      $tip.find('.tooltip-inner').text(title)
    }

    $tip.removeClass('fade in top bottom left right')
  }

  Tooltip.prototype.hide = function (callback) {
    var that = this
    var $tip = $(this.$tip)
    var e    = $.Event('hide.bs.' + this.type)

    function complete() {
      if (that.hoverState != 'in') $tip.detach()
      if (that.$element) { // TODO: Check whether guarding this code with this `if` is really necessary.
        that.$element
          .removeAttr('aria-describedby')
          .trigger('hidden.bs.' + that.type)
      }
      callback && callback()
    }

    this.$element.trigger(e)

    if (e.isDefaultPrevented()) return

    $tip.removeClass('in')

    $.support.transition && $tip.hasClass('fade') ?
      $tip
        .one('bsTransitionEnd', complete)
        .emulateTransitionEnd(Tooltip.TRANSITION_DURATION) :
      complete()

    this.hoverState = null

    return this
  }

  Tooltip.prototype.fixTitle = function () {
    var $e = this.$element
    if ($e.attr('title') || typeof $e.attr('data-original-title') != 'string') {
      $e.attr('data-original-title', $e.attr('title') || '').attr('title', '')
    }
  }

  Tooltip.prototype.hasContent = function () {
    return this.getTitle()
  }

  Tooltip.prototype.getPosition = function ($element) {
    $element   = $element || this.$element

    var el     = $element[0]
    var isBody = el.tagName == 'BODY'

    var elRect    = el.getBoundingClientRect()
    if (elRect.width == null) {
      // width and height are missing in IE8, so compute them manually; see https://github.com/twbs/bootstrap/issues/14093
      elRect = $.extend({}, elRect, { width: elRect.right - elRect.left, height: elRect.bottom - elRect.top })
    }
    var isSvg = window.SVGElement && el instanceof window.SVGElement
    // Avoid using $.offset() on SVGs since it gives incorrect results in jQuery 3.
    // See https://github.com/twbs/bootstrap/issues/20280
    var elOffset  = isBody ? { top: 0, left: 0 } : (isSvg ? null : $element.offset())
    var scroll    = { scroll: isBody ? document.documentElement.scrollTop || document.body.scrollTop : $element.scrollTop() }
    var outerDims = isBody ? { width: $(window).width(), height: $(window).height() } : null

    return $.extend({}, elRect, scroll, outerDims, elOffset)
  }

  Tooltip.prototype.getCalculatedOffset = function (placement, pos, actualWidth, actualHeight) {
    return placement == 'bottom' ? { top: pos.top + pos.height,   left: pos.left + pos.width / 2 - actualWidth / 2 } :
           placement == 'top'    ? { top: pos.top - actualHeight, left: pos.left + pos.width / 2 - actualWidth / 2 } :
           placement == 'left'   ? { top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left - actualWidth } :
        /* placement == 'right' */ { top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left + pos.width }

  }

  Tooltip.prototype.getViewportAdjustedDelta = function (placement, pos, actualWidth, actualHeight) {
    var delta = { top: 0, left: 0 }
    if (!this.$viewport) return delta

    var viewportPadding = this.options.viewport && this.options.viewport.padding || 0
    var viewportDimensions = this.getPosition(this.$viewport)

    if (/right|left/.test(placement)) {
      var topEdgeOffset    = pos.top - viewportPadding - viewportDimensions.scroll
      var bottomEdgeOffset = pos.top + viewportPadding - viewportDimensions.scroll + actualHeight
      if (topEdgeOffset < viewportDimensions.top) { // top overflow
        delta.top = viewportDimensions.top - topEdgeOffset
      } else if (bottomEdgeOffset > viewportDimensions.top + viewportDimensions.height) { // bottom overflow
        delta.top = viewportDimensions.top + viewportDimensions.height - bottomEdgeOffset
      }
    } else {
      var leftEdgeOffset  = pos.left - viewportPadding
      var rightEdgeOffset = pos.left + viewportPadding + actualWidth
      if (leftEdgeOffset < viewportDimensions.left) { // left overflow
        delta.left = viewportDimensions.left - leftEdgeOffset
      } else if (rightEdgeOffset > viewportDimensions.right) { // right overflow
        delta.left = viewportDimensions.left + viewportDimensions.width - rightEdgeOffset
      }
    }

    return delta
  }

  Tooltip.prototype.getTitle = function () {
    var title
    var $e = this.$element
    var o  = this.options

    title = $e.attr('data-original-title')
      || (typeof o.title == 'function' ? o.title.call($e[0]) :  o.title)

    return title
  }

  Tooltip.prototype.getUID = function (prefix) {
    do prefix += ~~(Math.random() * 1000000)
    while (document.getElementById(prefix))
    return prefix
  }

  Tooltip.prototype.tip = function () {
    if (!this.$tip) {
      this.$tip = $(this.options.template)
      if (this.$tip.length != 1) {
        throw new Error(this.type + ' `template` option must consist of exactly 1 top-level element!')
      }
    }
    return this.$tip
  }

  Tooltip.prototype.arrow = function () {
    return (this.$arrow = this.$arrow || this.tip().find('.tooltip-arrow'))
  }

  Tooltip.prototype.enable = function () {
    this.enabled = true
  }

  Tooltip.prototype.disable = function () {
    this.enabled = false
  }

  Tooltip.prototype.toggleEnabled = function () {
    this.enabled = !this.enabled
  }

  Tooltip.prototype.toggle = function (e) {
    var self = this
    if (e) {
      self = $(e.currentTarget).data('bs.' + this.type)
      if (!self) {
        self = new this.constructor(e.currentTarget, this.getDelegateOptions())
        $(e.currentTarget).data('bs.' + this.type, self)
      }
    }

    if (e) {
      self.inState.click = !self.inState.click
      if (self.isInStateTrue()) self.enter(self)
      else self.leave(self)
    } else {
      self.tip().hasClass('in') ? self.leave(self) : self.enter(self)
    }
  }

  Tooltip.prototype.destroy = function () {
    var that = this
    clearTimeout(this.timeout)
    this.hide(function () {
      that.$element.off('.' + that.type).removeData('bs.' + that.type)
      if (that.$tip) {
        that.$tip.detach()
      }
      that.$tip = null
      that.$arrow = null
      that.$viewport = null
      that.$element = null
    })
  }

  Tooltip.prototype.sanitizeHtml = function (unsafeHtml) {
    return sanitizeHtml(unsafeHtml, this.options.whiteList, this.options.sanitizeFn)
  }

  // TOOLTIP PLUGIN DEFINITION
  // =========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.tooltip')
      var options = typeof option == 'object' && option

      if (!data && /destroy|hide/.test(option)) return
      if (!data) $this.data('bs.tooltip', (data = new Tooltip(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.tooltip

  $.fn.tooltip             = Plugin
  $.fn.tooltip.Constructor = Tooltip


  // TOOLTIP NO CONFLICT
  // ===================

  $.fn.tooltip.noConflict = function () {
    $.fn.tooltip = old
    return this
  }

}(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/js/transition.js":
/*!*************************************************!*\
  !*** ./node_modules/bootstrap/js/transition.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* ========================================================================
 * Bootstrap: transition.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#transitions
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // CSS TRANSITION SUPPORT (Shoutout: https://modernizr.com/)
  // ============================================================

  function transitionEnd() {
    var el = document.createElement('bootstrap')

    var transEndEventNames = {
      WebkitTransition : 'webkitTransitionEnd',
      MozTransition    : 'transitionend',
      OTransition      : 'oTransitionEnd otransitionend',
      transition       : 'transitionend'
    }

    for (var name in transEndEventNames) {
      if (el.style[name] !== undefined) {
        return { end: transEndEventNames[name] }
      }
    }

    return false // explicit for ie8 (  ._.)
  }

  // https://blog.alexmaccaw.com/css-transitions
  $.fn.emulateTransitionEnd = function (duration) {
    var called = false
    var $el = this
    $(this).one('bsTransitionEnd', function () { called = true })
    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }
    setTimeout(callback, duration)
    return this
  }

  $(function () {
    $.support.transition = transitionEnd()

    if (!$.support.transition) return

    $.event.special.bsTransitionEnd = {
      bindType: $.support.transition.end,
      delegateType: $.support.transition.end,
      handle: function (e) {
        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments)
      }
    }
  })

}(jQuery);


/***/ }),

/***/ "./node_modules/complex.js/complex.js":
/*!********************************************!*\
  !*** ./node_modules/complex.js/complex.js ***!
  \********************************************/
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
 * @license Complex.js v2.0.11 11/02/2016
 *
 * Copyright (c) 2016, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/

/**
 *
 * This class allows the manipulation of complex numbers.
 * You can pass a complex number in different formats. Either as object, double, string or two integer parameters.
 *
 * Object form
 * { re: <real>, im: <imaginary> }
 * { arg: <angle>, abs: <radius> }
 * { phi: <angle>, r: <radius> }
 *
 * Array / Vector form
 * [ real, imaginary ]
 *
 * Double form
 * 99.3 - Single double value
 *
 * String form
 * '23.1337' - Simple real number
 * '15+3i' - a simple complex number
 * '3-i' - a simple complex number
 *
 * Example:
 *
 * var c = new Complex('99.3+8i');
 * c.mul({r: 3, i: 9}).div(4.9).sub(3, 2);
 *
 */

(function(root) {

  'use strict';

  var cosh = function(x) {
    return (Math.exp(x) + Math.exp(-x)) * 0.5;
  };

  var sinh = function(x) {
    return (Math.exp(x) - Math.exp(-x)) * 0.5;
  };

  /**
   * Calculates cos(x) - 1 using Taylor series if x is small.
   *
   * @param {number} x
   * @returns {number} cos(x) - 1
   */

  var cosm1 = function(x) {
    var limit = Math.PI/4;
    if (x < -limit || x > limit) {
      return (Math.cos(x) - 1.0);
    }

    var xx = x * x;
    return xx *
      (-0.5 + xx *
        (1/24 + xx *
          (-1/720 + xx *
            (1/40320 + xx *
              (-1/3628800 + xx *
                (1/4790014600 + xx *
                  (-1/87178291200 + xx *
                    (1/20922789888000)
                  )
                )
              )
            )
          )
        )
      )
  };

  var hypot = function(x, y) {

    var a = Math.abs(x);
    var b = Math.abs(y);

    if (a < 3000 && b < 3000) {
      return Math.sqrt(a * a + b * b);
    }

    if (a < b) {
      a = b;
      b = x / y;
    } else {
      b = y / x;
    }
    return a * Math.sqrt(1 + b * b);
  };

  var parser_exit = function() {
    throw SyntaxError('Invalid Param');
  };

  /**
   * Calculates log(sqrt(a^2+b^2)) in a way to avoid overflows
   *
   * @param {number} a
   * @param {number} b
   * @returns {number}
   */
  function logHypot(a, b) {

    var _a = Math.abs(a);
    var _b = Math.abs(b);

    if (a === 0) {
      return Math.log(_b);
    }

    if (b === 0) {
      return Math.log(_a);
    }

    if (_a < 3000 && _b < 3000) {
      return Math.log(a * a + b * b) * 0.5;
    }

    /* I got 4 ideas to compute this property without overflow:
     *
     * Testing 1000000 times with random samples for a,b ∈ [1, 1000000000] against a big decimal library to get an error estimate
     *
     * 1. Only eliminate the square root: (OVERALL ERROR: 3.9122483030951116e-11)

     Math.log(a * a + b * b) / 2

     *
     *
     * 2. Try to use the non-overflowing pythagoras: (OVERALL ERROR: 8.889760039210159e-10)

     var fn = function(a, b) {
     a = Math.abs(a);
     b = Math.abs(b);
     var t = Math.min(a, b);
     a = Math.max(a, b);
     t = t / a;

     return Math.log(a) + Math.log(1 + t * t) / 2;
     };

     * 3. Abuse the identity cos(atan(y/x) = x / sqrt(x^2+y^2): (OVERALL ERROR: 3.4780178737037204e-10)

     Math.log(a / Math.cos(Math.atan2(b, a)))

     * 4. Use 3. and apply log rules: (OVERALL ERROR: 1.2014087502620896e-9)

     Math.log(a) - Math.log(Math.cos(Math.atan2(b, a)))

     */

    return Math.log(a / Math.cos(Math.atan2(b, a)));
  }

  var parse = function(a, b) {

    var z = {'re': 0, 'im': 0};

    if (a === undefined || a === null) {
      z['re'] =
              z['im'] = 0;
    } else if (b !== undefined) {
      z['re'] = a;
      z['im'] = b;
    } else
      switch (typeof a) {

        case 'object':

          if ('im' in a && 're' in a) {
            z['re'] = a['re'];
            z['im'] = a['im'];
          } else if ('abs' in a && 'arg' in a) {
            if (!Number.isFinite(a['abs']) && Number.isFinite(a['arg'])) {
              return Complex['INFINITY'];
            }
            z['re'] = a['abs'] * Math.cos(a['arg']);
            z['im'] = a['abs'] * Math.sin(a['arg']);
          } else if ('r' in a && 'phi' in a) {
            if (!Number.isFinite(a['r']) && Number.isFinite(a['phi'])) {
              return Complex['INFINITY'];
            }
            z['re'] = a['r'] * Math.cos(a['phi']);
            z['im'] = a['r'] * Math.sin(a['phi']);
          } else if (a.length === 2) { // Quick array check
            z['re'] = a[0];
            z['im'] = a[1];
          } else {
            parser_exit();
          }
          break;

        case 'string':

          z['im'] = /* void */
                  z['re'] = 0;

          var tokens = a.match(/\d+\.?\d*e[+-]?\d+|\d+\.?\d*|\.\d+|./g);
          var plus = 1;
          var minus = 0;

          if (tokens === null) {
            parser_exit();
          }

          for (var i = 0; i < tokens.length; i++) {

            var c = tokens[i];

            if (c === ' ' || c === '\t' || c === '\n') {
              /* void */
            } else if (c === '+') {
              plus++;
            } else if (c === '-') {
              minus++;
            } else if (c === 'i' || c === 'I') {

              if (plus + minus === 0) {
                parser_exit();
              }

              if (tokens[i + 1] !== ' ' && !isNaN(tokens[i + 1])) {
                z['im'] += parseFloat((minus % 2 ? '-' : '') + tokens[i + 1]);
                i++;
              } else {
                z['im'] += parseFloat((minus % 2 ? '-' : '') + '1');
              }
              plus = minus = 0;

            } else {

              if (plus + minus === 0 || isNaN(c)) {
                parser_exit();
              }

              if (tokens[i + 1] === 'i' || tokens[i + 1] === 'I') {
                z['im'] += parseFloat((minus % 2 ? '-' : '') + c);
                i++;
              } else {
                z['re'] += parseFloat((minus % 2 ? '-' : '') + c);
              }
              plus = minus = 0;
            }
          }

          // Still something on the stack
          if (plus + minus > 0) {
            parser_exit();
          }
          break;

        case 'number':
          z['im'] = 0;
          z['re'] = a;
          break;

        default:
          parser_exit();
      }

    if (isNaN(z['re']) || isNaN(z['im'])) {
      // If a calculation is NaN, we treat it as NaN and don't throw
      //parser_exit();
    }

    return z;
  };

  /**
   * @constructor
   * @returns {Complex}
   */
  function Complex(a, b) {

    if (!(this instanceof Complex)) {
      return new Complex(a, b);
    }

    var z = parse(a, b);

    this['re'] = z['re'];
    this['im'] = z['im'];
  }

  Complex.prototype = {

    're': 0,
    'im': 0,

    /**
     * Calculates the sign of a complex number, which is a normalized complex
     *
     * @returns {Complex}
     */
    'sign': function() {

      var abs = this['abs']();

      return new Complex(
              this['re'] / abs,
              this['im'] / abs);
    },

    /**
     * Adds two complex numbers
     *
     * @returns {Complex}
     */
    'add': function(a, b) {

      var z = new Complex(a, b);

      // Infinity + Infinity = NaN
      if (this['isInfinite']() && z['isInfinite']()) {
        return Complex['NAN'];
      }

      // Infinity + z = Infinity { where z != Infinity }
      if (this['isInfinite']() || z['isInfinite']()) {
        return Complex['INFINITY'];
      }

      return new Complex(
              this['re'] + z['re'],
              this['im'] + z['im']);
    },

    /**
     * Subtracts two complex numbers
     *
     * @returns {Complex}
     */
    'sub': function(a, b) {

      var z = new Complex(a, b);

      // Infinity - Infinity = NaN
      if (this['isInfinite']() && z['isInfinite']()) {
        return Complex['NAN'];
      }

      // Infinity - z = Infinity { where z != Infinity }
      if (this['isInfinite']() || z['isInfinite']()) {
        return Complex['INFINITY'];
      }

      return new Complex(
              this['re'] - z['re'],
              this['im'] - z['im']);
    },

    /**
     * Multiplies two complex numbers
     *
     * @returns {Complex}
     */
    'mul': function(a, b) {

      var z = new Complex(a, b);

      // Infinity * 0 = NaN
      if ((this['isInfinite']() && z['isZero']()) || (this['isZero']() && z['isInfinite']())) {
        return Complex['NAN'];
      }

      // Infinity * z = Infinity { where z != 0 }
      if (this['isInfinite']() || z['isInfinite']()) {
        return Complex['INFINITY'];
      }

      // Short circuit for real values
      if (z['im'] === 0 && this['im'] === 0) {
        return new Complex(this['re'] * z['re'], 0);
      }

      return new Complex(
              this['re'] * z['re'] - this['im'] * z['im'],
              this['re'] * z['im'] + this['im'] * z['re']);
    },

    /**
     * Divides two complex numbers
     *
     * @returns {Complex}
     */
    'div': function(a, b) {

      var z = new Complex(a, b);

      // 0 / 0 = NaN and Infinity / Infinity = NaN
      if ((this['isZero']() && z['isZero']()) || (this['isInfinite']() && z['isInfinite']())) {
        return Complex['NAN'];
      }

      // Infinity / 0 = Infinity
      if (this['isInfinite']() || z['isZero']()) {
        return Complex['INFINITY'];
      }

      // 0 / Infinity = 0
      if (this['isZero']() || z['isInfinite']()) {
        return Complex['ZERO'];
      }

      a = this['re'];
      b = this['im'];

      var c = z['re'];
      var d = z['im'];
      var t, x;

      if (0 === d) {
        // Divisor is real
        return new Complex(a / c, b / c);
      }

      if (Math.abs(c) < Math.abs(d)) {

        x = c / d;
        t = c * x + d;

        return new Complex(
                (a * x + b) / t,
                (b * x - a) / t);

      } else {

        x = d / c;
        t = d * x + c;

        return new Complex(
                (a + b * x) / t,
                (b - a * x) / t);
      }
    },

    /**
     * Calculate the power of two complex numbers
     *
     * @returns {Complex}
     */
    'pow': function(a, b) {

      var z = new Complex(a, b);

      a = this['re'];
      b = this['im'];

      if (z['isZero']()) {
        return Complex['ONE'];
      }

      // If the exponent is real
      if (z['im'] === 0) {

        if (b === 0 && a >= 0) {

          return new Complex(Math.pow(a, z['re']), 0);

        } else if (a === 0) { // If base is fully imaginary

          switch ((z['re'] % 4 + 4) % 4) {
            case 0:
              return new Complex(Math.pow(b, z['re']), 0);
            case 1:
              return new Complex(0, Math.pow(b, z['re']));
            case 2:
              return new Complex(-Math.pow(b, z['re']), 0);
            case 3:
              return new Complex(0, -Math.pow(b, z['re']));
          }
        }
      }

      /* I couldn't find a good formula, so here is a derivation and optimization
       *
       * z_1^z_2 = (a + bi)^(c + di)
       *         = exp((c + di) * log(a + bi)
       *         = pow(a^2 + b^2, (c + di) / 2) * exp(i(c + di)atan2(b, a))
       * =>...
       * Re = (pow(a^2 + b^2, c / 2) * exp(-d * atan2(b, a))) * cos(d * log(a^2 + b^2) / 2 + c * atan2(b, a))
       * Im = (pow(a^2 + b^2, c / 2) * exp(-d * atan2(b, a))) * sin(d * log(a^2 + b^2) / 2 + c * atan2(b, a))
       *
       * =>...
       * Re = exp(c * log(sqrt(a^2 + b^2)) - d * atan2(b, a)) * cos(d * log(sqrt(a^2 + b^2)) + c * atan2(b, a))
       * Im = exp(c * log(sqrt(a^2 + b^2)) - d * atan2(b, a)) * sin(d * log(sqrt(a^2 + b^2)) + c * atan2(b, a))
       *
       * =>
       * Re = exp(c * logsq2 - d * arg(z_1)) * cos(d * logsq2 + c * arg(z_1))
       * Im = exp(c * logsq2 - d * arg(z_1)) * sin(d * logsq2 + c * arg(z_1))
       *
       */

      if (a === 0 && b === 0 && z['re'] > 0 && z['im'] >= 0) {
        return Complex['ZERO'];
      }

      var arg = Math.atan2(b, a);
      var loh = logHypot(a, b);

      a = Math.exp(z['re'] * loh - z['im'] * arg);
      b = z['im'] * loh + z['re'] * arg;
      return new Complex(
              a * Math.cos(b),
              a * Math.sin(b));
    },

    /**
     * Calculate the complex square root
     *
     * @returns {Complex}
     */
    'sqrt': function() {

      var a = this['re'];
      var b = this['im'];
      var r = this['abs']();

      var re, im;

      if (a >= 0) {

        if (b === 0) {
          return new Complex(Math.sqrt(a), 0);
        }

        re = 0.5 * Math.sqrt(2.0 * (r + a));
      } else {
        re = Math.abs(b) / Math.sqrt(2 * (r - a));
      }

      if (a <= 0) {
        im = 0.5 * Math.sqrt(2.0 * (r - a));
      } else {
        im = Math.abs(b) / Math.sqrt(2 * (r + a));
      }

      return new Complex(re, b < 0 ? -im : im);
    },

    /**
     * Calculate the complex exponent
     *
     * @returns {Complex}
     */
    'exp': function() {

      var tmp = Math.exp(this['re']);

      if (this['im'] === 0) {
        //return new Complex(tmp, 0);
      }
      return new Complex(
              tmp * Math.cos(this['im']),
              tmp * Math.sin(this['im']));
    },

    /**
     * Calculate the complex exponent and subtracts one.
     *
     * This may be more accurate than `Complex(x).exp().sub(1)` if
     * `x` is small.
     *
     * @returns {Complex}
     */
    'expm1': function() {

      /**
       * exp(a + i*b) - 1
       = exp(a) * (cos(b) + j*sin(b)) - 1
       = expm1(a)*cos(b) + cosm1(b) + j*exp(a)*sin(b)
       */

      var a = this['re'];
      var b = this['im'];

      return new Complex(
              Math.expm1(a) * Math.cos(b) + cosm1(b),
              Math.exp(a) * Math.sin(b));
    },

    /**
     * Calculate the natural log
     *
     * @returns {Complex}
     */
    'log': function() {

      var a = this['re'];
      var b = this['im'];

      if (b === 0 && a > 0) {
        //return new Complex(Math.log(a), 0);
      }

      return new Complex(
              logHypot(a, b),
              Math.atan2(b, a));
    },

    /**
     * Calculate the magnitude of the complex number
     *
     * @returns {number}
     */
    'abs': function() {

      return hypot(this['re'], this['im']);
    },

    /**
     * Calculate the angle of the complex number
     *
     * @returns {number}
     */
    'arg': function() {

      return Math.atan2(this['im'], this['re']);
    },

    /**
     * Calculate the sine of the complex number
     *
     * @returns {Complex}
     */
    'sin': function() {

      // sin(c) = (e^b - e^(-b)) / (2i)

      var a = this['re'];
      var b = this['im'];

      return new Complex(
              Math.sin(a) * cosh(b),
              Math.cos(a) * sinh(b));
    },

    /**
     * Calculate the cosine
     *
     * @returns {Complex}
     */
    'cos': function() {

      // cos(z) = (e^b + e^(-b)) / 2

      var a = this['re'];
      var b = this['im'];

      return new Complex(
              Math.cos(a) * cosh(b),
              -Math.sin(a) * sinh(b));
    },

    /**
     * Calculate the tangent
     *
     * @returns {Complex}
     */
    'tan': function() {

      // tan(c) = (e^(ci) - e^(-ci)) / (i(e^(ci) + e^(-ci)))

      var a = 2 * this['re'];
      var b = 2 * this['im'];
      var d = Math.cos(a) + cosh(b);

      return new Complex(
              Math.sin(a) / d,
              sinh(b) / d);
    },

    /**
     * Calculate the cotangent
     *
     * @returns {Complex}
     */
    'cot': function() {

      // cot(c) = i(e^(ci) + e^(-ci)) / (e^(ci) - e^(-ci))

      var a = 2 * this['re'];
      var b = 2 * this['im'];
      var d = Math.cos(a) - cosh(b);

      return new Complex(
              -Math.sin(a) / d,
              sinh(b) / d);
    },

    /**
     * Calculate the secant
     *
     * @returns {Complex}
     */
    'sec': function() {

      // sec(c) = 2 / (e^(ci) + e^(-ci))

      var a = this['re'];
      var b = this['im'];
      var d = 0.5 * cosh(2 * b) + 0.5 * Math.cos(2 * a);

      return new Complex(
              Math.cos(a) * cosh(b) / d,
              Math.sin(a) * sinh(b) / d);
    },

    /**
     * Calculate the cosecans
     *
     * @returns {Complex}
     */
    'csc': function() {

      // csc(c) = 2i / (e^(ci) - e^(-ci))

      var a = this['re'];
      var b = this['im'];
      var d = 0.5 * cosh(2 * b) - 0.5 * Math.cos(2 * a);

      return new Complex(
              Math.sin(a) * cosh(b) / d,
              -Math.cos(a) * sinh(b) / d);
    },

    /**
     * Calculate the complex arcus sinus
     *
     * @returns {Complex}
     */
    'asin': function() {

      // asin(c) = -i * log(ci + sqrt(1 - c^2))

      var a = this['re'];
      var b = this['im'];

      var t1 = new Complex(
              b * b - a * a + 1,
              -2 * a * b)['sqrt']();

      var t2 = new Complex(
              t1['re'] - b,
              t1['im'] + a)['log']();

      return new Complex(t2['im'], -t2['re']);
    },

    /**
     * Calculate the complex arcus cosinus
     *
     * @returns {Complex}
     */
    'acos': function() {

      // acos(c) = i * log(c - i * sqrt(1 - c^2))

      var a = this['re'];
      var b = this['im'];

      var t1 = new Complex(
              b * b - a * a + 1,
              -2 * a * b)['sqrt']();

      var t2 = new Complex(
              t1['re'] - b,
              t1['im'] + a)['log']();

      return new Complex(Math.PI / 2 - t2['im'], t2['re']);
    },

    /**
     * Calculate the complex arcus tangent
     *
     * @returns {Complex}
     */
    'atan': function() {

      // atan(c) = i / 2 log((i + x) / (i - x))

      var a = this['re'];
      var b = this['im'];

      if (a === 0) {

        if (b === 1) {
          return new Complex(0, Infinity);
        }

        if (b === -1) {
          return new Complex(0, -Infinity);
        }
      }

      var d = a * a + (1.0 - b) * (1.0 - b);

      var t1 = new Complex(
              (1 - b * b - a * a) / d,
              -2 * a / d).log();

      return new Complex(-0.5 * t1['im'], 0.5 * t1['re']);
    },

    /**
     * Calculate the complex arcus cotangent
     *
     * @returns {Complex}
     */
    'acot': function() {

      // acot(c) = i / 2 log((c - i) / (c + i))

      var a = this['re'];
      var b = this['im'];

      if (b === 0) {
        return new Complex(Math.atan2(1, a), 0);
      }

      var d = a * a + b * b;
      return (d !== 0)
              ? new Complex(
                      a / d,
                      -b / d).atan()
              : new Complex(
                      (a !== 0) ? a / 0 : 0,
                      (b !== 0) ? -b / 0 : 0).atan();
    },

    /**
     * Calculate the complex arcus secant
     *
     * @returns {Complex}
     */
    'asec': function() {

      // asec(c) = -i * log(1 / c + sqrt(1 - i / c^2))

      var a = this['re'];
      var b = this['im'];

      if (a === 0 && b === 0) {
        return new Complex(0, Infinity);
      }

      var d = a * a + b * b;
      return (d !== 0)
              ? new Complex(
                      a / d,
                      -b / d).acos()
              : new Complex(
                      (a !== 0) ? a / 0 : 0,
                      (b !== 0) ? -b / 0 : 0).acos();
    },

    /**
     * Calculate the complex arcus cosecans
     *
     * @returns {Complex}
     */
    'acsc': function() {

      // acsc(c) = -i * log(i / c + sqrt(1 - 1 / c^2))

      var a = this['re'];
      var b = this['im'];

      if (a === 0 && b === 0) {
        return new Complex(Math.PI / 2, Infinity);
      }

      var d = a * a + b * b;
      return (d !== 0)
              ? new Complex(
                      a / d,
                      -b / d).asin()
              : new Complex(
                      (a !== 0) ? a / 0 : 0,
                      (b !== 0) ? -b / 0 : 0).asin();
    },

    /**
     * Calculate the complex sinh
     *
     * @returns {Complex}
     */
    'sinh': function() {

      // sinh(c) = (e^c - e^-c) / 2

      var a = this['re'];
      var b = this['im'];

      return new Complex(
              sinh(a) * Math.cos(b),
              cosh(a) * Math.sin(b));
    },

    /**
     * Calculate the complex cosh
     *
     * @returns {Complex}
     */
    'cosh': function() {

      // cosh(c) = (e^c + e^-c) / 2

      var a = this['re'];
      var b = this['im'];

      return new Complex(
              cosh(a) * Math.cos(b),
              sinh(a) * Math.sin(b));
    },

    /**
     * Calculate the complex tanh
     *
     * @returns {Complex}
     */
    'tanh': function() {

      // tanh(c) = (e^c - e^-c) / (e^c + e^-c)

      var a = 2 * this['re'];
      var b = 2 * this['im'];
      var d = cosh(a) + Math.cos(b);

      return new Complex(
              sinh(a) / d,
              Math.sin(b) / d);
    },

    /**
     * Calculate the complex coth
     *
     * @returns {Complex}
     */
    'coth': function() {

      // coth(c) = (e^c + e^-c) / (e^c - e^-c)

      var a = 2 * this['re'];
      var b = 2 * this['im'];
      var d = cosh(a) - Math.cos(b);

      return new Complex(
              sinh(a) / d,
              -Math.sin(b) / d);
    },

    /**
     * Calculate the complex coth
     *
     * @returns {Complex}
     */
    'csch': function() {

      // csch(c) = 2 / (e^c - e^-c)

      var a = this['re'];
      var b = this['im'];
      var d = Math.cos(2 * b) - cosh(2 * a);

      return new Complex(
              -2 * sinh(a) * Math.cos(b) / d,
              2 * cosh(a) * Math.sin(b) / d);
    },

    /**
     * Calculate the complex sech
     *
     * @returns {Complex}
     */
    'sech': function() {

      // sech(c) = 2 / (e^c + e^-c)

      var a = this['re'];
      var b = this['im'];
      var d = Math.cos(2 * b) + cosh(2 * a);

      return new Complex(
              2 * cosh(a) * Math.cos(b) / d,
              -2 * sinh(a) * Math.sin(b) / d);
    },

    /**
     * Calculate the complex asinh
     *
     * @returns {Complex}
     */
    'asinh': function() {

      // asinh(c) = log(c + sqrt(c^2 + 1))

      var tmp = this['im'];
      this['im'] = -this['re'];
      this['re'] = tmp;
      var res = this['asin']();

      this['re'] = -this['im'];
      this['im'] = tmp;
      tmp = res['re'];

      res['re'] = -res['im'];
      res['im'] = tmp;
      return res;
    },

    /**
     * Calculate the complex asinh
     *
     * @returns {Complex}
     */
    'acosh': function() {

      // acosh(c) = log(c + sqrt(c^2 - 1))

      var res = this['acos']();
      if (res['im'] <= 0) {
        var tmp = res['re'];
        res['re'] = -res['im'];
        res['im'] = tmp;
      } else {
        var tmp = res['im'];
        res['im'] = -res['re'];
        res['re'] = tmp;
      }
      return res;
    },

    /**
     * Calculate the complex atanh
     *
     * @returns {Complex}
     */
    'atanh': function() {

      // atanh(c) = log((1+c) / (1-c)) / 2

      var a = this['re'];
      var b = this['im'];

      var noIM = a > 1 && b === 0;
      var oneMinus = 1 - a;
      var onePlus = 1 + a;
      var d = oneMinus * oneMinus + b * b;

      var x = (d !== 0)
              ? new Complex(
                      (onePlus * oneMinus - b * b) / d,
                      (b * oneMinus + onePlus * b) / d)
              : new Complex(
                      (a !== -1) ? (a / 0) : 0,
                      (b !== 0) ? (b / 0) : 0);

      var temp = x['re'];
      x['re'] = logHypot(x['re'], x['im']) / 2;
      x['im'] = Math.atan2(x['im'], temp) / 2;
      if (noIM) {
        x['im'] = -x['im'];
      }
      return x;
    },

    /**
     * Calculate the complex acoth
     *
     * @returns {Complex}
     */
    'acoth': function() {

      // acoth(c) = log((c+1) / (c-1)) / 2

      var a = this['re'];
      var b = this['im'];

      if (a === 0 && b === 0) {
        return new Complex(0, Math.PI / 2);
      }

      var d = a * a + b * b;
      return (d !== 0)
              ? new Complex(
                      a / d,
                      -b / d).atanh()
              : new Complex(
                      (a !== 0) ? a / 0 : 0,
                      (b !== 0) ? -b / 0 : 0).atanh();
    },

    /**
     * Calculate the complex acsch
     *
     * @returns {Complex}
     */
    'acsch': function() {

      // acsch(c) = log((1+sqrt(1+c^2))/c)

      var a = this['re'];
      var b = this['im'];

      if (b === 0) {

        return new Complex(
                (a !== 0)
                ? Math.log(a + Math.sqrt(a * a + 1))
                : Infinity, 0);
      }

      var d = a * a + b * b;
      return (d !== 0)
              ? new Complex(
                      a / d,
                      -b / d).asinh()
              : new Complex(
                      (a !== 0) ? a / 0 : 0,
                      (b !== 0) ? -b / 0 : 0).asinh();
    },

    /**
     * Calculate the complex asech
     *
     * @returns {Complex}
     */
    'asech': function() {

      // asech(c) = log((1+sqrt(1-c^2))/c)

      var a = this['re'];
      var b = this['im'];

      if (this['isZero']()) {
        return Complex['INFINITY'];
      }

      var d = a * a + b * b;
      return (d !== 0)
              ? new Complex(
                      a / d,
                      -b / d).acosh()
              : new Complex(
                      (a !== 0) ? a / 0 : 0,
                      (b !== 0) ? -b / 0 : 0).acosh();
    },

    /**
     * Calculate the complex inverse 1/z
     *
     * @returns {Complex}
     */
    'inverse': function() {

      // 1 / 0 = Infinity and 1 / Infinity = 0
      if (this['isZero']()) {
        return Complex['INFINITY'];
      }

      if (this['isInfinite']()) {
        return Complex['ZERO'];
      }

      var a = this['re'];
      var b = this['im'];

      var d = a * a + b * b;

      return new Complex(a / d, -b / d);
    },

    /**
     * Returns the complex conjugate
     *
     * @returns {Complex}
     */
    'conjugate': function() {

      return new Complex(this['re'], -this['im']);
    },

    /**
     * Gets the negated complex number
     *
     * @returns {Complex}
     */
    'neg': function() {

      return new Complex(-this['re'], -this['im']);
    },

    /**
     * Ceils the actual complex number
     *
     * @returns {Complex}
     */
    'ceil': function(places) {

      places = Math.pow(10, places || 0);

      return new Complex(
              Math.ceil(this['re'] * places) / places,
              Math.ceil(this['im'] * places) / places);
    },

    /**
     * Floors the actual complex number
     *
     * @returns {Complex}
     */
    'floor': function(places) {

      places = Math.pow(10, places || 0);

      return new Complex(
              Math.floor(this['re'] * places) / places,
              Math.floor(this['im'] * places) / places);
    },

    /**
     * Ceils the actual complex number
     *
     * @returns {Complex}
     */
    'round': function(places) {

      places = Math.pow(10, places || 0);

      return new Complex(
              Math.round(this['re'] * places) / places,
              Math.round(this['im'] * places) / places);
    },

    /**
     * Compares two complex numbers
     *
     * **Note:** new Complex(Infinity).equals(Infinity) === false
     *
     * @returns {boolean}
     */
    'equals': function(a, b) {

      var z = new Complex(a, b);

      return Math.abs(z['re'] - this['re']) <= Complex['EPSILON'] &&
              Math.abs(z['im'] - this['im']) <= Complex['EPSILON'];
    },

    /**
     * Clones the actual object
     *
     * @returns {Complex}
     */
    'clone': function() {

      return new Complex(this['re'], this['im']);
    },

    /**
     * Gets a string of the actual complex number
     *
     * @returns {string}
     */
    'toString': function() {

      var a = this['re'];
      var b = this['im'];
      var ret = '';

      if (this['isNaN']()) {
        return 'NaN';
      }

      if (this['isZero']()) {
        return '0';
      }

      if (this['isInfinite']()) {
        return 'Infinity';
      }

      if (a !== 0) {
        ret += a;
      }

      if (b !== 0) {

        if (a !== 0) {
          ret += b < 0 ? ' - ' : ' + ';
        } else if (b < 0) {
          ret += '-';
        }

        b = Math.abs(b);

        if (1 !== b) {
          ret += b;
        }
        ret += 'i';
      }

      if (!ret)
        return '0';

      return ret;
    },

    /**
     * Returns the actual number as a vector
     *
     * @returns {Array}
     */
    'toVector': function() {

      return [this['re'], this['im']];
    },

    /**
     * Returns the actual real value of the current object
     *
     * @returns {number|null}
     */
    'valueOf': function() {

      if (this['im'] === 0) {
        return this['re'];
      }
      return null;
    },

    /**
     * Determines whether a complex number is not on the Riemann sphere.
     *
     * @returns {boolean}
     */
    'isNaN': function() {
      return isNaN(this['re']) || isNaN(this['im']);
    },

    /**
     * Determines whether or not a complex number is at the zero pole of the
     * Riemann sphere.
     *
     * @returns {boolean}
     */
    'isZero': function() {
      return (
              (this['re'] === 0 || this['re'] === -0) &&
              (this['im'] === 0 || this['im'] === -0)
              );
    },

    /**
     * Determines whether a complex number is not at the infinity pole of the
     * Riemann sphere.
     *
     * @returns {boolean}
     */
    'isFinite': function() {
      return isFinite(this['re']) && isFinite(this['im']);
    },

    /**
     * Determines whether or not a complex number is at the infinity pole of the
     * Riemann sphere.
     *
     * @returns {boolean}
     */
    'isInfinite': function() {
      return !(this['isNaN']() || this['isFinite']());
    }
  };

  Complex['ZERO'] = new Complex(0, 0);
  Complex['ONE'] = new Complex(1, 0);
  Complex['I'] = new Complex(0, 1);
  Complex['PI'] = new Complex(Math.PI, 0);
  Complex['E'] = new Complex(Math.E, 0);
  Complex['INFINITY'] = new Complex(Infinity, Infinity);
  Complex['NAN'] = new Complex(NaN, NaN);
  Complex['EPSILON'] = 1e-16;

  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return Complex;
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}

})(this);


/***/ }),

/***/ "./node_modules/decimal.js/decimal.js":
/*!********************************************!*\
  !*** ./node_modules/decimal.js/decimal.js ***!
  \********************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;;(function (globalScope) {
  'use strict';


  /*
   *  decimal.js v10.2.0
   *  An arbitrary-precision Decimal type for JavaScript.
   *  https://github.com/MikeMcl/decimal.js
   *  Copyright (c) 2019 Michael Mclaughlin <M8ch88l@gmail.com>
   *  MIT Licence
   */


  // -----------------------------------  EDITABLE DEFAULTS  ------------------------------------ //


    // The maximum exponent magnitude.
    // The limit on the value of `toExpNeg`, `toExpPos`, `minE` and `maxE`.
  var EXP_LIMIT = 9e15,                      // 0 to 9e15

    // The limit on the value of `precision`, and on the value of the first argument to
    // `toDecimalPlaces`, `toExponential`, `toFixed`, `toPrecision` and `toSignificantDigits`.
    MAX_DIGITS = 1e9,                        // 0 to 1e9

    // Base conversion alphabet.
    NUMERALS = '0123456789abcdef',

    // The natural logarithm of 10 (1025 digits).
    LN10 = '2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058',

    // Pi (1025 digits).
    PI = '3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789',


    // The initial configuration properties of the Decimal constructor.
    DEFAULTS = {

      // These values must be integers within the stated ranges (inclusive).
      // Most of these values can be changed at run-time using the `Decimal.config` method.

      // The maximum number of significant digits of the result of a calculation or base conversion.
      // E.g. `Decimal.config({ precision: 20 });`
      precision: 20,                         // 1 to MAX_DIGITS

      // The rounding mode used when rounding to `precision`.
      //
      // ROUND_UP         0 Away from zero.
      // ROUND_DOWN       1 Towards zero.
      // ROUND_CEIL       2 Towards +Infinity.
      // ROUND_FLOOR      3 Towards -Infinity.
      // ROUND_HALF_UP    4 Towards nearest neighbour. If equidistant, up.
      // ROUND_HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
      // ROUND_HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
      // ROUND_HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
      // ROUND_HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
      //
      // E.g.
      // `Decimal.rounding = 4;`
      // `Decimal.rounding = Decimal.ROUND_HALF_UP;`
      rounding: 4,                           // 0 to 8

      // The modulo mode used when calculating the modulus: a mod n.
      // The quotient (q = a / n) is calculated according to the corresponding rounding mode.
      // The remainder (r) is calculated as: r = a - n * q.
      //
      // UP         0 The remainder is positive if the dividend is negative, else is negative.
      // DOWN       1 The remainder has the same sign as the dividend (JavaScript %).
      // FLOOR      3 The remainder has the same sign as the divisor (Python %).
      // HALF_EVEN  6 The IEEE 754 remainder function.
      // EUCLID     9 Euclidian division. q = sign(n) * floor(a / abs(n)). Always positive.
      //
      // Truncated division (1), floored division (3), the IEEE 754 remainder (6), and Euclidian
      // division (9) are commonly used for the modulus operation. The other rounding modes can also
      // be used, but they may not give useful results.
      modulo: 1,                             // 0 to 9

      // The exponent value at and beneath which `toString` returns exponential notation.
      // JavaScript numbers: -7
      toExpNeg: -7,                          // 0 to -EXP_LIMIT

      // The exponent value at and above which `toString` returns exponential notation.
      // JavaScript numbers: 21
      toExpPos:  21,                         // 0 to EXP_LIMIT

      // The minimum exponent value, beneath which underflow to zero occurs.
      // JavaScript numbers: -324  (5e-324)
      minE: -EXP_LIMIT,                      // -1 to -EXP_LIMIT

      // The maximum exponent value, above which overflow to Infinity occurs.
      // JavaScript numbers: 308  (1.7976931348623157e+308)
      maxE: EXP_LIMIT,                       // 1 to EXP_LIMIT

      // Whether to use cryptographically-secure random number generation, if available.
      crypto: false                          // true/false
    },


  // ----------------------------------- END OF EDITABLE DEFAULTS ------------------------------- //


    Decimal, inexact, noConflict, quadrant,
    external = true,

    decimalError = '[DecimalError] ',
    invalidArgument = decimalError + 'Invalid argument: ',
    precisionLimitExceeded = decimalError + 'Precision limit exceeded',
    cryptoUnavailable = decimalError + 'crypto unavailable',

    mathfloor = Math.floor,
    mathpow = Math.pow,

    isBinary = /^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i,
    isHex = /^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i,
    isOctal = /^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i,
    isDecimal = /^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,

    BASE = 1e7,
    LOG_BASE = 7,
    MAX_SAFE_INTEGER = 9007199254740991,

    LN10_PRECISION = LN10.length - 1,
    PI_PRECISION = PI.length - 1,

    // Decimal.prototype object
    P = { name: '[object Decimal]' };


  // Decimal prototype methods


  /*
   *  absoluteValue             abs
   *  ceil
   *  comparedTo                cmp
   *  cosine                    cos
   *  cubeRoot                  cbrt
   *  decimalPlaces             dp
   *  dividedBy                 div
   *  dividedToIntegerBy        divToInt
   *  equals                    eq
   *  floor
   *  greaterThan               gt
   *  greaterThanOrEqualTo      gte
   *  hyperbolicCosine          cosh
   *  hyperbolicSine            sinh
   *  hyperbolicTangent         tanh
   *  inverseCosine             acos
   *  inverseHyperbolicCosine   acosh
   *  inverseHyperbolicSine     asinh
   *  inverseHyperbolicTangent  atanh
   *  inverseSine               asin
   *  inverseTangent            atan
   *  isFinite
   *  isInteger                 isInt
   *  isNaN
   *  isNegative                isNeg
   *  isPositive                isPos
   *  isZero
   *  lessThan                  lt
   *  lessThanOrEqualTo         lte
   *  logarithm                 log
   *  [maximum]                 [max]
   *  [minimum]                 [min]
   *  minus                     sub
   *  modulo                    mod
   *  naturalExponential        exp
   *  naturalLogarithm          ln
   *  negated                   neg
   *  plus                      add
   *  precision                 sd
   *  round
   *  sine                      sin
   *  squareRoot                sqrt
   *  tangent                   tan
   *  times                     mul
   *  toBinary
   *  toDecimalPlaces           toDP
   *  toExponential
   *  toFixed
   *  toFraction
   *  toHexadecimal             toHex
   *  toNearest
   *  toNumber
   *  toOctal
   *  toPower                   pow
   *  toPrecision
   *  toSignificantDigits       toSD
   *  toString
   *  truncated                 trunc
   *  valueOf                   toJSON
   */


  /*
   * Return a new Decimal whose value is the absolute value of this Decimal.
   *
   */
  P.absoluteValue = P.abs = function () {
    var x = new this.constructor(this);
    if (x.s < 0) x.s = 1;
    return finalise(x);
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a whole number in the
   * direction of positive Infinity.
   *
   */
  P.ceil = function () {
    return finalise(new this.constructor(this), this.e + 1, 2);
  };


  /*
   * Return
   *   1    if the value of this Decimal is greater than the value of `y`,
   *  -1    if the value of this Decimal is less than the value of `y`,
   *   0    if they have the same value,
   *   NaN  if the value of either Decimal is NaN.
   *
   */
  P.comparedTo = P.cmp = function (y) {
    var i, j, xdL, ydL,
      x = this,
      xd = x.d,
      yd = (y = new x.constructor(y)).d,
      xs = x.s,
      ys = y.s;

    // Either NaN or ±Infinity?
    if (!xd || !yd) {
      return !xs || !ys ? NaN : xs !== ys ? xs : xd === yd ? 0 : !xd ^ xs < 0 ? 1 : -1;
    }

    // Either zero?
    if (!xd[0] || !yd[0]) return xd[0] ? xs : yd[0] ? -ys : 0;

    // Signs differ?
    if (xs !== ys) return xs;

    // Compare exponents.
    if (x.e !== y.e) return x.e > y.e ^ xs < 0 ? 1 : -1;

    xdL = xd.length;
    ydL = yd.length;

    // Compare digit by digit.
    for (i = 0, j = xdL < ydL ? xdL : ydL; i < j; ++i) {
      if (xd[i] !== yd[i]) return xd[i] > yd[i] ^ xs < 0 ? 1 : -1;
    }

    // Compare lengths.
    return xdL === ydL ? 0 : xdL > ydL ^ xs < 0 ? 1 : -1;
  };


  /*
   * Return a new Decimal whose value is the cosine of the value in radians of this Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-1, 1]
   *
   * cos(0)         = 1
   * cos(-0)        = 1
   * cos(Infinity)  = NaN
   * cos(-Infinity) = NaN
   * cos(NaN)       = NaN
   *
   */
  P.cosine = P.cos = function () {
    var pr, rm,
      x = this,
      Ctor = x.constructor;

    if (!x.d) return new Ctor(NaN);

    // cos(0) = cos(-0) = 1
    if (!x.d[0]) return new Ctor(1);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
    Ctor.rounding = 1;

    x = cosine(Ctor, toLessThanHalfPi(Ctor, x));

    Ctor.precision = pr;
    Ctor.rounding = rm;

    return finalise(quadrant == 2 || quadrant == 3 ? x.neg() : x, pr, rm, true);
  };


  /*
   *
   * Return a new Decimal whose value is the cube root of the value of this Decimal, rounded to
   * `precision` significant digits using rounding mode `rounding`.
   *
   *  cbrt(0)  =  0
   *  cbrt(-0) = -0
   *  cbrt(1)  =  1
   *  cbrt(-1) = -1
   *  cbrt(N)  =  N
   *  cbrt(-I) = -I
   *  cbrt(I)  =  I
   *
   * Math.cbrt(x) = (x < 0 ? -Math.pow(-x, 1/3) : Math.pow(x, 1/3))
   *
   */
  P.cubeRoot = P.cbrt = function () {
    var e, m, n, r, rep, s, sd, t, t3, t3plusx,
      x = this,
      Ctor = x.constructor;

    if (!x.isFinite() || x.isZero()) return new Ctor(x);
    external = false;

    // Initial estimate.
    s = x.s * mathpow(x.s * x, 1 / 3);

     // Math.cbrt underflow/overflow?
     // Pass x to Math.pow as integer, then adjust the exponent of the result.
    if (!s || Math.abs(s) == 1 / 0) {
      n = digitsToString(x.d);
      e = x.e;

      // Adjust n exponent so it is a multiple of 3 away from x exponent.
      if (s = (e - n.length + 1) % 3) n += (s == 1 || s == -2 ? '0' : '00');
      s = mathpow(n, 1 / 3);

      // Rarely, e may be one less than the result exponent value.
      e = mathfloor((e + 1) / 3) - (e % 3 == (e < 0 ? -1 : 2));

      if (s == 1 / 0) {
        n = '5e' + e;
      } else {
        n = s.toExponential();
        n = n.slice(0, n.indexOf('e') + 1) + e;
      }

      r = new Ctor(n);
      r.s = x.s;
    } else {
      r = new Ctor(s.toString());
    }

    sd = (e = Ctor.precision) + 3;

    // Halley's method.
    // TODO? Compare Newton's method.
    for (;;) {
      t = r;
      t3 = t.times(t).times(t);
      t3plusx = t3.plus(x);
      r = divide(t3plusx.plus(x).times(t), t3plusx.plus(t3), sd + 2, 1);

      // TODO? Replace with for-loop and checkRoundingDigits.
      if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
        n = n.slice(sd - 3, sd + 1);

        // The 4th rounding digit may be in error by -1 so if the 4 rounding digits are 9999 or 4999
        // , i.e. approaching a rounding boundary, continue the iteration.
        if (n == '9999' || !rep && n == '4999') {

          // On the first iteration only, check to see if rounding up gives the exact result as the
          // nines may infinitely repeat.
          if (!rep) {
            finalise(t, e + 1, 0);

            if (t.times(t).times(t).eq(x)) {
              r = t;
              break;
            }
          }

          sd += 4;
          rep = 1;
        } else {

          // If the rounding digits are null, 0{0,4} or 50{0,3}, check for an exact result.
          // If not, then there are further digits and m will be truthy.
          if (!+n || !+n.slice(1) && n.charAt(0) == '5') {

            // Truncate to the first rounding digit.
            finalise(r, e + 1, 1);
            m = !r.times(r).times(r).eq(x);
          }

          break;
        }
      }
    }

    external = true;

    return finalise(r, e, Ctor.rounding, m);
  };


  /*
   * Return the number of decimal places of the value of this Decimal.
   *
   */
  P.decimalPlaces = P.dp = function () {
    var w,
      d = this.d,
      n = NaN;

    if (d) {
      w = d.length - 1;
      n = (w - mathfloor(this.e / LOG_BASE)) * LOG_BASE;

      // Subtract the number of trailing zeros of the last word.
      w = d[w];
      if (w) for (; w % 10 == 0; w /= 10) n--;
      if (n < 0) n = 0;
    }

    return n;
  };


  /*
   *  n / 0 = I
   *  n / N = N
   *  n / I = 0
   *  0 / n = 0
   *  0 / 0 = N
   *  0 / N = N
   *  0 / I = 0
   *  N / n = N
   *  N / 0 = N
   *  N / N = N
   *  N / I = N
   *  I / n = I
   *  I / 0 = I
   *  I / N = N
   *  I / I = N
   *
   * Return a new Decimal whose value is the value of this Decimal divided by `y`, rounded to
   * `precision` significant digits using rounding mode `rounding`.
   *
   */
  P.dividedBy = P.div = function (y) {
    return divide(this, new this.constructor(y));
  };


  /*
   * Return a new Decimal whose value is the integer part of dividing the value of this Decimal
   * by the value of `y`, rounded to `precision` significant digits using rounding mode `rounding`.
   *
   */
  P.dividedToIntegerBy = P.divToInt = function (y) {
    var x = this,
      Ctor = x.constructor;
    return finalise(divide(x, new Ctor(y), 0, 1, 1), Ctor.precision, Ctor.rounding);
  };


  /*
   * Return true if the value of this Decimal is equal to the value of `y`, otherwise return false.
   *
   */
  P.equals = P.eq = function (y) {
    return this.cmp(y) === 0;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a whole number in the
   * direction of negative Infinity.
   *
   */
  P.floor = function () {
    return finalise(new this.constructor(this), this.e + 1, 3);
  };


  /*
   * Return true if the value of this Decimal is greater than the value of `y`, otherwise return
   * false.
   *
   */
  P.greaterThan = P.gt = function (y) {
    return this.cmp(y) > 0;
  };


  /*
   * Return true if the value of this Decimal is greater than or equal to the value of `y`,
   * otherwise return false.
   *
   */
  P.greaterThanOrEqualTo = P.gte = function (y) {
    var k = this.cmp(y);
    return k == 1 || k === 0;
  };


  /*
   * Return a new Decimal whose value is the hyperbolic cosine of the value in radians of this
   * Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [1, Infinity]
   *
   * cosh(x) = 1 + x^2/2! + x^4/4! + x^6/6! + ...
   *
   * cosh(0)         = 1
   * cosh(-0)        = 1
   * cosh(Infinity)  = Infinity
   * cosh(-Infinity) = Infinity
   * cosh(NaN)       = NaN
   *
   *  x        time taken (ms)   result
   * 1000      9                 9.8503555700852349694e+433
   * 10000     25                4.4034091128314607936e+4342
   * 100000    171               1.4033316802130615897e+43429
   * 1000000   3817              1.5166076984010437725e+434294
   * 10000000  abandoned after 2 minute wait
   *
   * TODO? Compare performance of cosh(x) = 0.5 * (exp(x) + exp(-x))
   *
   */
  P.hyperbolicCosine = P.cosh = function () {
    var k, n, pr, rm, len,
      x = this,
      Ctor = x.constructor,
      one = new Ctor(1);

    if (!x.isFinite()) return new Ctor(x.s ? 1 / 0 : NaN);
    if (x.isZero()) return one;

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
    Ctor.rounding = 1;
    len = x.d.length;

    // Argument reduction: cos(4x) = 1 - 8cos^2(x) + 8cos^4(x) + 1
    // i.e. cos(x) = 1 - cos^2(x/4)(8 - 8cos^2(x/4))

    // Estimate the optimum number of times to use the argument reduction.
    // TODO? Estimation reused from cosine() and may not be optimal here.
    if (len < 32) {
      k = Math.ceil(len / 3);
      n = (1 / tinyPow(4, k)).toString();
    } else {
      k = 16;
      n = '2.3283064365386962890625e-10';
    }

    x = taylorSeries(Ctor, 1, x.times(n), new Ctor(1), true);

    // Reverse argument reduction
    var cosh2_x,
      i = k,
      d8 = new Ctor(8);
    for (; i--;) {
      cosh2_x = x.times(x);
      x = one.minus(cosh2_x.times(d8.minus(cosh2_x.times(d8))));
    }

    return finalise(x, Ctor.precision = pr, Ctor.rounding = rm, true);
  };


  /*
   * Return a new Decimal whose value is the hyperbolic sine of the value in radians of this
   * Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-Infinity, Infinity]
   *
   * sinh(x) = x + x^3/3! + x^5/5! + x^7/7! + ...
   *
   * sinh(0)         = 0
   * sinh(-0)        = -0
   * sinh(Infinity)  = Infinity
   * sinh(-Infinity) = -Infinity
   * sinh(NaN)       = NaN
   *
   * x        time taken (ms)
   * 10       2 ms
   * 100      5 ms
   * 1000     14 ms
   * 10000    82 ms
   * 100000   886 ms            1.4033316802130615897e+43429
   * 200000   2613 ms
   * 300000   5407 ms
   * 400000   8824 ms
   * 500000   13026 ms          8.7080643612718084129e+217146
   * 1000000  48543 ms
   *
   * TODO? Compare performance of sinh(x) = 0.5 * (exp(x) - exp(-x))
   *
   */
  P.hyperbolicSine = P.sinh = function () {
    var k, pr, rm, len,
      x = this,
      Ctor = x.constructor;

    if (!x.isFinite() || x.isZero()) return new Ctor(x);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
    Ctor.rounding = 1;
    len = x.d.length;

    if (len < 3) {
      x = taylorSeries(Ctor, 2, x, x, true);
    } else {

      // Alternative argument reduction: sinh(3x) = sinh(x)(3 + 4sinh^2(x))
      // i.e. sinh(x) = sinh(x/3)(3 + 4sinh^2(x/3))
      // 3 multiplications and 1 addition

      // Argument reduction: sinh(5x) = sinh(x)(5 + sinh^2(x)(20 + 16sinh^2(x)))
      // i.e. sinh(x) = sinh(x/5)(5 + sinh^2(x/5)(20 + 16sinh^2(x/5)))
      // 4 multiplications and 2 additions

      // Estimate the optimum number of times to use the argument reduction.
      k = 1.4 * Math.sqrt(len);
      k = k > 16 ? 16 : k | 0;

      x = x.times(1 / tinyPow(5, k));
      x = taylorSeries(Ctor, 2, x, x, true);

      // Reverse argument reduction
      var sinh2_x,
        d5 = new Ctor(5),
        d16 = new Ctor(16),
        d20 = new Ctor(20);
      for (; k--;) {
        sinh2_x = x.times(x);
        x = x.times(d5.plus(sinh2_x.times(d16.times(sinh2_x).plus(d20))));
      }
    }

    Ctor.precision = pr;
    Ctor.rounding = rm;

    return finalise(x, pr, rm, true);
  };


  /*
   * Return a new Decimal whose value is the hyperbolic tangent of the value in radians of this
   * Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-1, 1]
   *
   * tanh(x) = sinh(x) / cosh(x)
   *
   * tanh(0)         = 0
   * tanh(-0)        = -0
   * tanh(Infinity)  = 1
   * tanh(-Infinity) = -1
   * tanh(NaN)       = NaN
   *
   */
  P.hyperbolicTangent = P.tanh = function () {
    var pr, rm,
      x = this,
      Ctor = x.constructor;

    if (!x.isFinite()) return new Ctor(x.s);
    if (x.isZero()) return new Ctor(x);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + 7;
    Ctor.rounding = 1;

    return divide(x.sinh(), x.cosh(), Ctor.precision = pr, Ctor.rounding = rm);
  };


  /*
   * Return a new Decimal whose value is the arccosine (inverse cosine) in radians of the value of
   * this Decimal.
   *
   * Domain: [-1, 1]
   * Range: [0, pi]
   *
   * acos(x) = pi/2 - asin(x)
   *
   * acos(0)       = pi/2
   * acos(-0)      = pi/2
   * acos(1)       = 0
   * acos(-1)      = pi
   * acos(1/2)     = pi/3
   * acos(-1/2)    = 2*pi/3
   * acos(|x| > 1) = NaN
   * acos(NaN)     = NaN
   *
   */
  P.inverseCosine = P.acos = function () {
    var halfPi,
      x = this,
      Ctor = x.constructor,
      k = x.abs().cmp(1),
      pr = Ctor.precision,
      rm = Ctor.rounding;

    if (k !== -1) {
      return k === 0
        // |x| is 1
        ? x.isNeg() ? getPi(Ctor, pr, rm) : new Ctor(0)
        // |x| > 1 or x is NaN
        : new Ctor(NaN);
    }

    if (x.isZero()) return getPi(Ctor, pr + 4, rm).times(0.5);

    // TODO? Special case acos(0.5) = pi/3 and acos(-0.5) = 2*pi/3

    Ctor.precision = pr + 6;
    Ctor.rounding = 1;

    x = x.asin();
    halfPi = getPi(Ctor, pr + 4, rm).times(0.5);

    Ctor.precision = pr;
    Ctor.rounding = rm;

    return halfPi.minus(x);
  };


  /*
   * Return a new Decimal whose value is the inverse of the hyperbolic cosine in radians of the
   * value of this Decimal.
   *
   * Domain: [1, Infinity]
   * Range: [0, Infinity]
   *
   * acosh(x) = ln(x + sqrt(x^2 - 1))
   *
   * acosh(x < 1)     = NaN
   * acosh(NaN)       = NaN
   * acosh(Infinity)  = Infinity
   * acosh(-Infinity) = NaN
   * acosh(0)         = NaN
   * acosh(-0)        = NaN
   * acosh(1)         = 0
   * acosh(-1)        = NaN
   *
   */
  P.inverseHyperbolicCosine = P.acosh = function () {
    var pr, rm,
      x = this,
      Ctor = x.constructor;

    if (x.lte(1)) return new Ctor(x.eq(1) ? 0 : NaN);
    if (!x.isFinite()) return new Ctor(x);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(Math.abs(x.e), x.sd()) + 4;
    Ctor.rounding = 1;
    external = false;

    x = x.times(x).minus(1).sqrt().plus(x);

    external = true;
    Ctor.precision = pr;
    Ctor.rounding = rm;

    return x.ln();
  };


  /*
   * Return a new Decimal whose value is the inverse of the hyperbolic sine in radians of the value
   * of this Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-Infinity, Infinity]
   *
   * asinh(x) = ln(x + sqrt(x^2 + 1))
   *
   * asinh(NaN)       = NaN
   * asinh(Infinity)  = Infinity
   * asinh(-Infinity) = -Infinity
   * asinh(0)         = 0
   * asinh(-0)        = -0
   *
   */
  P.inverseHyperbolicSine = P.asinh = function () {
    var pr, rm,
      x = this,
      Ctor = x.constructor;

    if (!x.isFinite() || x.isZero()) return new Ctor(x);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + 2 * Math.max(Math.abs(x.e), x.sd()) + 6;
    Ctor.rounding = 1;
    external = false;

    x = x.times(x).plus(1).sqrt().plus(x);

    external = true;
    Ctor.precision = pr;
    Ctor.rounding = rm;

    return x.ln();
  };


  /*
   * Return a new Decimal whose value is the inverse of the hyperbolic tangent in radians of the
   * value of this Decimal.
   *
   * Domain: [-1, 1]
   * Range: [-Infinity, Infinity]
   *
   * atanh(x) = 0.5 * ln((1 + x) / (1 - x))
   *
   * atanh(|x| > 1)   = NaN
   * atanh(NaN)       = NaN
   * atanh(Infinity)  = NaN
   * atanh(-Infinity) = NaN
   * atanh(0)         = 0
   * atanh(-0)        = -0
   * atanh(1)         = Infinity
   * atanh(-1)        = -Infinity
   *
   */
  P.inverseHyperbolicTangent = P.atanh = function () {
    var pr, rm, wpr, xsd,
      x = this,
      Ctor = x.constructor;

    if (!x.isFinite()) return new Ctor(NaN);
    if (x.e >= 0) return new Ctor(x.abs().eq(1) ? x.s / 0 : x.isZero() ? x : NaN);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    xsd = x.sd();

    if (Math.max(xsd, pr) < 2 * -x.e - 1) return finalise(new Ctor(x), pr, rm, true);

    Ctor.precision = wpr = xsd - x.e;

    x = divide(x.plus(1), new Ctor(1).minus(x), wpr + pr, 1);

    Ctor.precision = pr + 4;
    Ctor.rounding = 1;

    x = x.ln();

    Ctor.precision = pr;
    Ctor.rounding = rm;

    return x.times(0.5);
  };


  /*
   * Return a new Decimal whose value is the arcsine (inverse sine) in radians of the value of this
   * Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-pi/2, pi/2]
   *
   * asin(x) = 2*atan(x/(1 + sqrt(1 - x^2)))
   *
   * asin(0)       = 0
   * asin(-0)      = -0
   * asin(1/2)     = pi/6
   * asin(-1/2)    = -pi/6
   * asin(1)       = pi/2
   * asin(-1)      = -pi/2
   * asin(|x| > 1) = NaN
   * asin(NaN)     = NaN
   *
   * TODO? Compare performance of Taylor series.
   *
   */
  P.inverseSine = P.asin = function () {
    var halfPi, k,
      pr, rm,
      x = this,
      Ctor = x.constructor;

    if (x.isZero()) return new Ctor(x);

    k = x.abs().cmp(1);
    pr = Ctor.precision;
    rm = Ctor.rounding;

    if (k !== -1) {

      // |x| is 1
      if (k === 0) {
        halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
        halfPi.s = x.s;
        return halfPi;
      }

      // |x| > 1 or x is NaN
      return new Ctor(NaN);
    }

    // TODO? Special case asin(1/2) = pi/6 and asin(-1/2) = -pi/6

    Ctor.precision = pr + 6;
    Ctor.rounding = 1;

    x = x.div(new Ctor(1).minus(x.times(x)).sqrt().plus(1)).atan();

    Ctor.precision = pr;
    Ctor.rounding = rm;

    return x.times(2);
  };


  /*
   * Return a new Decimal whose value is the arctangent (inverse tangent) in radians of the value
   * of this Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-pi/2, pi/2]
   *
   * atan(x) = x - x^3/3 + x^5/5 - x^7/7 + ...
   *
   * atan(0)         = 0
   * atan(-0)        = -0
   * atan(1)         = pi/4
   * atan(-1)        = -pi/4
   * atan(Infinity)  = pi/2
   * atan(-Infinity) = -pi/2
   * atan(NaN)       = NaN
   *
   */
  P.inverseTangent = P.atan = function () {
    var i, j, k, n, px, t, r, wpr, x2,
      x = this,
      Ctor = x.constructor,
      pr = Ctor.precision,
      rm = Ctor.rounding;

    if (!x.isFinite()) {
      if (!x.s) return new Ctor(NaN);
      if (pr + 4 <= PI_PRECISION) {
        r = getPi(Ctor, pr + 4, rm).times(0.5);
        r.s = x.s;
        return r;
      }
    } else if (x.isZero()) {
      return new Ctor(x);
    } else if (x.abs().eq(1) && pr + 4 <= PI_PRECISION) {
      r = getPi(Ctor, pr + 4, rm).times(0.25);
      r.s = x.s;
      return r;
    }

    Ctor.precision = wpr = pr + 10;
    Ctor.rounding = 1;

    // TODO? if (x >= 1 && pr <= PI_PRECISION) atan(x) = halfPi * x.s - atan(1 / x);

    // Argument reduction
    // Ensure |x| < 0.42
    // atan(x) = 2 * atan(x / (1 + sqrt(1 + x^2)))

    k = Math.min(28, wpr / LOG_BASE + 2 | 0);

    for (i = k; i; --i) x = x.div(x.times(x).plus(1).sqrt().plus(1));

    external = false;

    j = Math.ceil(wpr / LOG_BASE);
    n = 1;
    x2 = x.times(x);
    r = new Ctor(x);
    px = x;

    // atan(x) = x - x^3/3 + x^5/5 - x^7/7 + ...
    for (; i !== -1;) {
      px = px.times(x2);
      t = r.minus(px.div(n += 2));

      px = px.times(x2);
      r = t.plus(px.div(n += 2));

      if (r.d[j] !== void 0) for (i = j; r.d[i] === t.d[i] && i--;);
    }

    if (k) r = r.times(2 << (k - 1));

    external = true;

    return finalise(r, Ctor.precision = pr, Ctor.rounding = rm, true);
  };


  /*
   * Return true if the value of this Decimal is a finite number, otherwise return false.
   *
   */
  P.isFinite = function () {
    return !!this.d;
  };


  /*
   * Return true if the value of this Decimal is an integer, otherwise return false.
   *
   */
  P.isInteger = P.isInt = function () {
    return !!this.d && mathfloor(this.e / LOG_BASE) > this.d.length - 2;
  };


  /*
   * Return true if the value of this Decimal is NaN, otherwise return false.
   *
   */
  P.isNaN = function () {
    return !this.s;
  };


  /*
   * Return true if the value of this Decimal is negative, otherwise return false.
   *
   */
  P.isNegative = P.isNeg = function () {
    return this.s < 0;
  };


  /*
   * Return true if the value of this Decimal is positive, otherwise return false.
   *
   */
  P.isPositive = P.isPos = function () {
    return this.s > 0;
  };


  /*
   * Return true if the value of this Decimal is 0 or -0, otherwise return false.
   *
   */
  P.isZero = function () {
    return !!this.d && this.d[0] === 0;
  };


  /*
   * Return true if the value of this Decimal is less than `y`, otherwise return false.
   *
   */
  P.lessThan = P.lt = function (y) {
    return this.cmp(y) < 0;
  };


  /*
   * Return true if the value of this Decimal is less than or equal to `y`, otherwise return false.
   *
   */
  P.lessThanOrEqualTo = P.lte = function (y) {
    return this.cmp(y) < 1;
  };


  /*
   * Return the logarithm of the value of this Decimal to the specified base, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * If no base is specified, return log[10](arg).
   *
   * log[base](arg) = ln(arg) / ln(base)
   *
   * The result will always be correctly rounded if the base of the log is 10, and 'almost always'
   * otherwise:
   *
   * Depending on the rounding mode, the result may be incorrectly rounded if the first fifteen
   * rounding digits are [49]99999999999999 or [50]00000000000000. In that case, the maximum error
   * between the result and the correctly rounded result will be one ulp (unit in the last place).
   *
   * log[-b](a)       = NaN
   * log[0](a)        = NaN
   * log[1](a)        = NaN
   * log[NaN](a)      = NaN
   * log[Infinity](a) = NaN
   * log[b](0)        = -Infinity
   * log[b](-0)       = -Infinity
   * log[b](-a)       = NaN
   * log[b](1)        = 0
   * log[b](Infinity) = Infinity
   * log[b](NaN)      = NaN
   *
   * [base] {number|string|Decimal} The base of the logarithm.
   *
   */
  P.logarithm = P.log = function (base) {
    var isBase10, d, denominator, k, inf, num, sd, r,
      arg = this,
      Ctor = arg.constructor,
      pr = Ctor.precision,
      rm = Ctor.rounding,
      guard = 5;

    // Default base is 10.
    if (base == null) {
      base = new Ctor(10);
      isBase10 = true;
    } else {
      base = new Ctor(base);
      d = base.d;

      // Return NaN if base is negative, or non-finite, or is 0 or 1.
      if (base.s < 0 || !d || !d[0] || base.eq(1)) return new Ctor(NaN);

      isBase10 = base.eq(10);
    }

    d = arg.d;

    // Is arg negative, non-finite, 0 or 1?
    if (arg.s < 0 || !d || !d[0] || arg.eq(1)) {
      return new Ctor(d && !d[0] ? -1 / 0 : arg.s != 1 ? NaN : d ? 0 : 1 / 0);
    }

    // The result will have a non-terminating decimal expansion if base is 10 and arg is not an
    // integer power of 10.
    if (isBase10) {
      if (d.length > 1) {
        inf = true;
      } else {
        for (k = d[0]; k % 10 === 0;) k /= 10;
        inf = k !== 1;
      }
    }

    external = false;
    sd = pr + guard;
    num = naturalLogarithm(arg, sd);
    denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);

    // The result will have 5 rounding digits.
    r = divide(num, denominator, sd, 1);

    // If at a rounding boundary, i.e. the result's rounding digits are [49]9999 or [50]0000,
    // calculate 10 further digits.
    //
    // If the result is known to have an infinite decimal expansion, repeat this until it is clear
    // that the result is above or below the boundary. Otherwise, if after calculating the 10
    // further digits, the last 14 are nines, round up and assume the result is exact.
    // Also assume the result is exact if the last 14 are zero.
    //
    // Example of a result that will be incorrectly rounded:
    // log[1048576](4503599627370502) = 2.60000000000000009610279511444746...
    // The above result correctly rounded using ROUND_CEIL to 1 decimal place should be 2.7, but it
    // will be given as 2.6 as there are 15 zeros immediately after the requested decimal place, so
    // the exact result would be assumed to be 2.6, which rounded using ROUND_CEIL to 1 decimal
    // place is still 2.6.
    if (checkRoundingDigits(r.d, k = pr, rm)) {

      do {
        sd += 10;
        num = naturalLogarithm(arg, sd);
        denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
        r = divide(num, denominator, sd, 1);

        if (!inf) {

          // Check for 14 nines from the 2nd rounding digit, as the first may be 4.
          if (+digitsToString(r.d).slice(k + 1, k + 15) + 1 == 1e14) {
            r = finalise(r, pr + 1, 0);
          }

          break;
        }
      } while (checkRoundingDigits(r.d, k += 10, rm));
    }

    external = true;

    return finalise(r, pr, rm);
  };


  /*
   * Return a new Decimal whose value is the maximum of the arguments and the value of this Decimal.
   *
   * arguments {number|string|Decimal}
   *
  P.max = function () {
    Array.prototype.push.call(arguments, this);
    return maxOrMin(this.constructor, arguments, 'lt');
  };
   */


  /*
   * Return a new Decimal whose value is the minimum of the arguments and the value of this Decimal.
   *
   * arguments {number|string|Decimal}
   *
  P.min = function () {
    Array.prototype.push.call(arguments, this);
    return maxOrMin(this.constructor, arguments, 'gt');
  };
   */


  /*
   *  n - 0 = n
   *  n - N = N
   *  n - I = -I
   *  0 - n = -n
   *  0 - 0 = 0
   *  0 - N = N
   *  0 - I = -I
   *  N - n = N
   *  N - 0 = N
   *  N - N = N
   *  N - I = N
   *  I - n = I
   *  I - 0 = I
   *  I - N = N
   *  I - I = N
   *
   * Return a new Decimal whose value is the value of this Decimal minus `y`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   */
  P.minus = P.sub = function (y) {
    var d, e, i, j, k, len, pr, rm, xd, xe, xLTy, yd,
      x = this,
      Ctor = x.constructor;

    y = new Ctor(y);

    // If either is not finite...
    if (!x.d || !y.d) {

      // Return NaN if either is NaN.
      if (!x.s || !y.s) y = new Ctor(NaN);

      // Return y negated if x is finite and y is ±Infinity.
      else if (x.d) y.s = -y.s;

      // Return x if y is finite and x is ±Infinity.
      // Return x if both are ±Infinity with different signs.
      // Return NaN if both are ±Infinity with the same sign.
      else y = new Ctor(y.d || x.s !== y.s ? x : NaN);

      return y;
    }

    // If signs differ...
    if (x.s != y.s) {
      y.s = -y.s;
      return x.plus(y);
    }

    xd = x.d;
    yd = y.d;
    pr = Ctor.precision;
    rm = Ctor.rounding;

    // If either is zero...
    if (!xd[0] || !yd[0]) {

      // Return y negated if x is zero and y is non-zero.
      if (yd[0]) y.s = -y.s;

      // Return x if y is zero and x is non-zero.
      else if (xd[0]) y = new Ctor(x);

      // Return zero if both are zero.
      // From IEEE 754 (2008) 6.3: 0 - 0 = -0 - -0 = -0 when rounding to -Infinity.
      else return new Ctor(rm === 3 ? -0 : 0);

      return external ? finalise(y, pr, rm) : y;
    }

    // x and y are finite, non-zero numbers with the same sign.

    // Calculate base 1e7 exponents.
    e = mathfloor(y.e / LOG_BASE);
    xe = mathfloor(x.e / LOG_BASE);

    xd = xd.slice();
    k = xe - e;

    // If base 1e7 exponents differ...
    if (k) {
      xLTy = k < 0;

      if (xLTy) {
        d = xd;
        k = -k;
        len = yd.length;
      } else {
        d = yd;
        e = xe;
        len = xd.length;
      }

      // Numbers with massively different exponents would result in a very high number of
      // zeros needing to be prepended, but this can be avoided while still ensuring correct
      // rounding by limiting the number of zeros to `Math.ceil(pr / LOG_BASE) + 2`.
      i = Math.max(Math.ceil(pr / LOG_BASE), len) + 2;

      if (k > i) {
        k = i;
        d.length = 1;
      }

      // Prepend zeros to equalise exponents.
      d.reverse();
      for (i = k; i--;) d.push(0);
      d.reverse();

    // Base 1e7 exponents equal.
    } else {

      // Check digits to determine which is the bigger number.

      i = xd.length;
      len = yd.length;
      xLTy = i < len;
      if (xLTy) len = i;

      for (i = 0; i < len; i++) {
        if (xd[i] != yd[i]) {
          xLTy = xd[i] < yd[i];
          break;
        }
      }

      k = 0;
    }

    if (xLTy) {
      d = xd;
      xd = yd;
      yd = d;
      y.s = -y.s;
    }

    len = xd.length;

    // Append zeros to `xd` if shorter.
    // Don't add zeros to `yd` if shorter as subtraction only needs to start at `yd` length.
    for (i = yd.length - len; i > 0; --i) xd[len++] = 0;

    // Subtract yd from xd.
    for (i = yd.length; i > k;) {

      if (xd[--i] < yd[i]) {
        for (j = i; j && xd[--j] === 0;) xd[j] = BASE - 1;
        --xd[j];
        xd[i] += BASE;
      }

      xd[i] -= yd[i];
    }

    // Remove trailing zeros.
    for (; xd[--len] === 0;) xd.pop();

    // Remove leading zeros and adjust exponent accordingly.
    for (; xd[0] === 0; xd.shift()) --e;

    // Zero?
    if (!xd[0]) return new Ctor(rm === 3 ? -0 : 0);

    y.d = xd;
    y.e = getBase10Exponent(xd, e);

    return external ? finalise(y, pr, rm) : y;
  };


  /*
   *   n % 0 =  N
   *   n % N =  N
   *   n % I =  n
   *   0 % n =  0
   *  -0 % n = -0
   *   0 % 0 =  N
   *   0 % N =  N
   *   0 % I =  0
   *   N % n =  N
   *   N % 0 =  N
   *   N % N =  N
   *   N % I =  N
   *   I % n =  N
   *   I % 0 =  N
   *   I % N =  N
   *   I % I =  N
   *
   * Return a new Decimal whose value is the value of this Decimal modulo `y`, rounded to
   * `precision` significant digits using rounding mode `rounding`.
   *
   * The result depends on the modulo mode.
   *
   */
  P.modulo = P.mod = function (y) {
    var q,
      x = this,
      Ctor = x.constructor;

    y = new Ctor(y);

    // Return NaN if x is ±Infinity or NaN, or y is NaN or ±0.
    if (!x.d || !y.s || y.d && !y.d[0]) return new Ctor(NaN);

    // Return x if y is ±Infinity or x is ±0.
    if (!y.d || x.d && !x.d[0]) {
      return finalise(new Ctor(x), Ctor.precision, Ctor.rounding);
    }

    // Prevent rounding of intermediate calculations.
    external = false;

    if (Ctor.modulo == 9) {

      // Euclidian division: q = sign(y) * floor(x / abs(y))
      // result = x - q * y    where  0 <= result < abs(y)
      q = divide(x, y.abs(), 0, 3, 1);
      q.s *= y.s;
    } else {
      q = divide(x, y, 0, Ctor.modulo, 1);
    }

    q = q.times(y);

    external = true;

    return x.minus(q);
  };


  /*
   * Return a new Decimal whose value is the natural exponential of the value of this Decimal,
   * i.e. the base e raised to the power the value of this Decimal, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   */
  P.naturalExponential = P.exp = function () {
    return naturalExponential(this);
  };


  /*
   * Return a new Decimal whose value is the natural logarithm of the value of this Decimal,
   * rounded to `precision` significant digits using rounding mode `rounding`.
   *
   */
  P.naturalLogarithm = P.ln = function () {
    return naturalLogarithm(this);
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal negated, i.e. as if multiplied by
   * -1.
   *
   */
  P.negated = P.neg = function () {
    var x = new this.constructor(this);
    x.s = -x.s;
    return finalise(x);
  };


  /*
   *  n + 0 = n
   *  n + N = N
   *  n + I = I
   *  0 + n = n
   *  0 + 0 = 0
   *  0 + N = N
   *  0 + I = I
   *  N + n = N
   *  N + 0 = N
   *  N + N = N
   *  N + I = N
   *  I + n = I
   *  I + 0 = I
   *  I + N = N
   *  I + I = I
   *
   * Return a new Decimal whose value is the value of this Decimal plus `y`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   */
  P.plus = P.add = function (y) {
    var carry, d, e, i, k, len, pr, rm, xd, yd,
      x = this,
      Ctor = x.constructor;

    y = new Ctor(y);

    // If either is not finite...
    if (!x.d || !y.d) {

      // Return NaN if either is NaN.
      if (!x.s || !y.s) y = new Ctor(NaN);

      // Return x if y is finite and x is ±Infinity.
      // Return x if both are ±Infinity with the same sign.
      // Return NaN if both are ±Infinity with different signs.
      // Return y if x is finite and y is ±Infinity.
      else if (!x.d) y = new Ctor(y.d || x.s === y.s ? x : NaN);

      return y;
    }

     // If signs differ...
    if (x.s != y.s) {
      y.s = -y.s;
      return x.minus(y);
    }

    xd = x.d;
    yd = y.d;
    pr = Ctor.precision;
    rm = Ctor.rounding;

    // If either is zero...
    if (!xd[0] || !yd[0]) {

      // Return x if y is zero.
      // Return y if y is non-zero.
      if (!yd[0]) y = new Ctor(x);

      return external ? finalise(y, pr, rm) : y;
    }

    // x and y are finite, non-zero numbers with the same sign.

    // Calculate base 1e7 exponents.
    k = mathfloor(x.e / LOG_BASE);
    e = mathfloor(y.e / LOG_BASE);

    xd = xd.slice();
    i = k - e;

    // If base 1e7 exponents differ...
    if (i) {

      if (i < 0) {
        d = xd;
        i = -i;
        len = yd.length;
      } else {
        d = yd;
        e = k;
        len = xd.length;
      }

      // Limit number of zeros prepended to max(ceil(pr / LOG_BASE), len) + 1.
      k = Math.ceil(pr / LOG_BASE);
      len = k > len ? k + 1 : len + 1;

      if (i > len) {
        i = len;
        d.length = 1;
      }

      // Prepend zeros to equalise exponents. Note: Faster to use reverse then do unshifts.
      d.reverse();
      for (; i--;) d.push(0);
      d.reverse();
    }

    len = xd.length;
    i = yd.length;

    // If yd is longer than xd, swap xd and yd so xd points to the longer array.
    if (len - i < 0) {
      i = len;
      d = yd;
      yd = xd;
      xd = d;
    }

    // Only start adding at yd.length - 1 as the further digits of xd can be left as they are.
    for (carry = 0; i;) {
      carry = (xd[--i] = xd[i] + yd[i] + carry) / BASE | 0;
      xd[i] %= BASE;
    }

    if (carry) {
      xd.unshift(carry);
      ++e;
    }

    // Remove trailing zeros.
    // No need to check for zero, as +x + +y != 0 && -x + -y != 0
    for (len = xd.length; xd[--len] == 0;) xd.pop();

    y.d = xd;
    y.e = getBase10Exponent(xd, e);

    return external ? finalise(y, pr, rm) : y;
  };


  /*
   * Return the number of significant digits of the value of this Decimal.
   *
   * [z] {boolean|number} Whether to count integer-part trailing zeros: true, false, 1 or 0.
   *
   */
  P.precision = P.sd = function (z) {
    var k,
      x = this;

    if (z !== void 0 && z !== !!z && z !== 1 && z !== 0) throw Error(invalidArgument + z);

    if (x.d) {
      k = getPrecision(x.d);
      if (z && x.e + 1 > k) k = x.e + 1;
    } else {
      k = NaN;
    }

    return k;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a whole number using
   * rounding mode `rounding`.
   *
   */
  P.round = function () {
    var x = this,
      Ctor = x.constructor;

    return finalise(new Ctor(x), x.e + 1, Ctor.rounding);
  };


  /*
   * Return a new Decimal whose value is the sine of the value in radians of this Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-1, 1]
   *
   * sin(x) = x - x^3/3! + x^5/5! - ...
   *
   * sin(0)         = 0
   * sin(-0)        = -0
   * sin(Infinity)  = NaN
   * sin(-Infinity) = NaN
   * sin(NaN)       = NaN
   *
   */
  P.sine = P.sin = function () {
    var pr, rm,
      x = this,
      Ctor = x.constructor;

    if (!x.isFinite()) return new Ctor(NaN);
    if (x.isZero()) return new Ctor(x);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
    Ctor.rounding = 1;

    x = sine(Ctor, toLessThanHalfPi(Ctor, x));

    Ctor.precision = pr;
    Ctor.rounding = rm;

    return finalise(quadrant > 2 ? x.neg() : x, pr, rm, true);
  };


  /*
   * Return a new Decimal whose value is the square root of this Decimal, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   *  sqrt(-n) =  N
   *  sqrt(N)  =  N
   *  sqrt(-I) =  N
   *  sqrt(I)  =  I
   *  sqrt(0)  =  0
   *  sqrt(-0) = -0
   *
   */
  P.squareRoot = P.sqrt = function () {
    var m, n, sd, r, rep, t,
      x = this,
      d = x.d,
      e = x.e,
      s = x.s,
      Ctor = x.constructor;

    // Negative/NaN/Infinity/zero?
    if (s !== 1 || !d || !d[0]) {
      return new Ctor(!s || s < 0 && (!d || d[0]) ? NaN : d ? x : 1 / 0);
    }

    external = false;

    // Initial estimate.
    s = Math.sqrt(+x);

    // Math.sqrt underflow/overflow?
    // Pass x to Math.sqrt as integer, then adjust the exponent of the result.
    if (s == 0 || s == 1 / 0) {
      n = digitsToString(d);

      if ((n.length + e) % 2 == 0) n += '0';
      s = Math.sqrt(n);
      e = mathfloor((e + 1) / 2) - (e < 0 || e % 2);

      if (s == 1 / 0) {
        n = '1e' + e;
      } else {
        n = s.toExponential();
        n = n.slice(0, n.indexOf('e') + 1) + e;
      }

      r = new Ctor(n);
    } else {
      r = new Ctor(s.toString());
    }

    sd = (e = Ctor.precision) + 3;

    // Newton-Raphson iteration.
    for (;;) {
      t = r;
      r = t.plus(divide(x, t, sd + 2, 1)).times(0.5);

      // TODO? Replace with for-loop and checkRoundingDigits.
      if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
        n = n.slice(sd - 3, sd + 1);

        // The 4th rounding digit may be in error by -1 so if the 4 rounding digits are 9999 or
        // 4999, i.e. approaching a rounding boundary, continue the iteration.
        if (n == '9999' || !rep && n == '4999') {

          // On the first iteration only, check to see if rounding up gives the exact result as the
          // nines may infinitely repeat.
          if (!rep) {
            finalise(t, e + 1, 0);

            if (t.times(t).eq(x)) {
              r = t;
              break;
            }
          }

          sd += 4;
          rep = 1;
        } else {

          // If the rounding digits are null, 0{0,4} or 50{0,3}, check for an exact result.
          // If not, then there are further digits and m will be truthy.
          if (!+n || !+n.slice(1) && n.charAt(0) == '5') {

            // Truncate to the first rounding digit.
            finalise(r, e + 1, 1);
            m = !r.times(r).eq(x);
          }

          break;
        }
      }
    }

    external = true;

    return finalise(r, e, Ctor.rounding, m);
  };


  /*
   * Return a new Decimal whose value is the tangent of the value in radians of this Decimal.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-Infinity, Infinity]
   *
   * tan(0)         = 0
   * tan(-0)        = -0
   * tan(Infinity)  = NaN
   * tan(-Infinity) = NaN
   * tan(NaN)       = NaN
   *
   */
  P.tangent = P.tan = function () {
    var pr, rm,
      x = this,
      Ctor = x.constructor;

    if (!x.isFinite()) return new Ctor(NaN);
    if (x.isZero()) return new Ctor(x);

    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + 10;
    Ctor.rounding = 1;

    x = x.sin();
    x.s = 1;
    x = divide(x, new Ctor(1).minus(x.times(x)).sqrt(), pr + 10, 0);

    Ctor.precision = pr;
    Ctor.rounding = rm;

    return finalise(quadrant == 2 || quadrant == 4 ? x.neg() : x, pr, rm, true);
  };


  /*
   *  n * 0 = 0
   *  n * N = N
   *  n * I = I
   *  0 * n = 0
   *  0 * 0 = 0
   *  0 * N = N
   *  0 * I = N
   *  N * n = N
   *  N * 0 = N
   *  N * N = N
   *  N * I = N
   *  I * n = I
   *  I * 0 = N
   *  I * N = N
   *  I * I = I
   *
   * Return a new Decimal whose value is this Decimal times `y`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   */
  P.times = P.mul = function (y) {
    var carry, e, i, k, r, rL, t, xdL, ydL,
      x = this,
      Ctor = x.constructor,
      xd = x.d,
      yd = (y = new Ctor(y)).d;

    y.s *= x.s;

     // If either is NaN, ±Infinity or ±0...
    if (!xd || !xd[0] || !yd || !yd[0]) {

      return new Ctor(!y.s || xd && !xd[0] && !yd || yd && !yd[0] && !xd

        // Return NaN if either is NaN.
        // Return NaN if x is ±0 and y is ±Infinity, or y is ±0 and x is ±Infinity.
        ? NaN

        // Return ±Infinity if either is ±Infinity.
        // Return ±0 if either is ±0.
        : !xd || !yd ? y.s / 0 : y.s * 0);
    }

    e = mathfloor(x.e / LOG_BASE) + mathfloor(y.e / LOG_BASE);
    xdL = xd.length;
    ydL = yd.length;

    // Ensure xd points to the longer array.
    if (xdL < ydL) {
      r = xd;
      xd = yd;
      yd = r;
      rL = xdL;
      xdL = ydL;
      ydL = rL;
    }

    // Initialise the result array with zeros.
    r = [];
    rL = xdL + ydL;
    for (i = rL; i--;) r.push(0);

    // Multiply!
    for (i = ydL; --i >= 0;) {
      carry = 0;
      for (k = xdL + i; k > i;) {
        t = r[k] + yd[i] * xd[k - i - 1] + carry;
        r[k--] = t % BASE | 0;
        carry = t / BASE | 0;
      }

      r[k] = (r[k] + carry) % BASE | 0;
    }

    // Remove trailing zeros.
    for (; !r[--rL];) r.pop();

    if (carry) ++e;
    else r.shift();

    y.d = r;
    y.e = getBase10Exponent(r, e);

    return external ? finalise(y, Ctor.precision, Ctor.rounding) : y;
  };


  /*
   * Return a string representing the value of this Decimal in base 2, round to `sd` significant
   * digits using rounding mode `rm`.
   *
   * If the optional `sd` argument is present then return binary exponential notation.
   *
   * [sd] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toBinary = function (sd, rm) {
    return toStringBinary(this, 2, sd, rm);
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a maximum of `dp`
   * decimal places using rounding mode `rm` or `rounding` if `rm` is omitted.
   *
   * If `dp` is omitted, return a new Decimal whose value is the value of this Decimal.
   *
   * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toDecimalPlaces = P.toDP = function (dp, rm) {
    var x = this,
      Ctor = x.constructor;

    x = new Ctor(x);
    if (dp === void 0) return x;

    checkInt32(dp, 0, MAX_DIGITS);

    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);

    return finalise(x, dp + x.e + 1, rm);
  };


  /*
   * Return a string representing the value of this Decimal in exponential notation rounded to
   * `dp` fixed decimal places using rounding mode `rounding`.
   *
   * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toExponential = function (dp, rm) {
    var str,
      x = this,
      Ctor = x.constructor;

    if (dp === void 0) {
      str = finiteToString(x, true);
    } else {
      checkInt32(dp, 0, MAX_DIGITS);

      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);

      x = finalise(new Ctor(x), dp + 1, rm);
      str = finiteToString(x, true, dp + 1);
    }

    return x.isNeg() && !x.isZero() ? '-' + str : str;
  };


  /*
   * Return a string representing the value of this Decimal in normal (fixed-point) notation to
   * `dp` fixed decimal places and rounded using rounding mode `rm` or `rounding` if `rm` is
   * omitted.
   *
   * As with JavaScript numbers, (-0).toFixed(0) is '0', but e.g. (-0.00001).toFixed(0) is '-0'.
   *
   * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   * (-0).toFixed(0) is '0', but (-0.1).toFixed(0) is '-0'.
   * (-0).toFixed(1) is '0.0', but (-0.01).toFixed(1) is '-0.0'.
   * (-0).toFixed(3) is '0.000'.
   * (-0.5).toFixed(0) is '-0'.
   *
   */
  P.toFixed = function (dp, rm) {
    var str, y,
      x = this,
      Ctor = x.constructor;

    if (dp === void 0) {
      str = finiteToString(x);
    } else {
      checkInt32(dp, 0, MAX_DIGITS);

      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);

      y = finalise(new Ctor(x), dp + x.e + 1, rm);
      str = finiteToString(y, false, dp + y.e + 1);
    }

    // To determine whether to add the minus sign look at the value before it was rounded,
    // i.e. look at `x` rather than `y`.
    return x.isNeg() && !x.isZero() ? '-' + str : str;
  };


  /*
   * Return an array representing the value of this Decimal as a simple fraction with an integer
   * numerator and an integer denominator.
   *
   * The denominator will be a positive non-zero value less than or equal to the specified maximum
   * denominator. If a maximum denominator is not specified, the denominator will be the lowest
   * value necessary to represent the number exactly.
   *
   * [maxD] {number|string|Decimal} Maximum denominator. Integer >= 1 and < Infinity.
   *
   */
  P.toFraction = function (maxD) {
    var d, d0, d1, d2, e, k, n, n0, n1, pr, q, r,
      x = this,
      xd = x.d,
      Ctor = x.constructor;

    if (!xd) return new Ctor(x);

    n1 = d0 = new Ctor(1);
    d1 = n0 = new Ctor(0);

    d = new Ctor(d1);
    e = d.e = getPrecision(xd) - x.e - 1;
    k = e % LOG_BASE;
    d.d[0] = mathpow(10, k < 0 ? LOG_BASE + k : k);

    if (maxD == null) {

      // d is 10**e, the minimum max-denominator needed.
      maxD = e > 0 ? d : n1;
    } else {
      n = new Ctor(maxD);
      if (!n.isInt() || n.lt(n1)) throw Error(invalidArgument + n);
      maxD = n.gt(d) ? (e > 0 ? d : n1) : n;
    }

    external = false;
    n = new Ctor(digitsToString(xd));
    pr = Ctor.precision;
    Ctor.precision = e = xd.length * LOG_BASE * 2;

    for (;;)  {
      q = divide(n, d, 0, 1, 1);
      d2 = d0.plus(q.times(d1));
      if (d2.cmp(maxD) == 1) break;
      d0 = d1;
      d1 = d2;
      d2 = n1;
      n1 = n0.plus(q.times(d2));
      n0 = d2;
      d2 = d;
      d = n.minus(q.times(d2));
      n = d2;
    }

    d2 = divide(maxD.minus(d0), d1, 0, 1, 1);
    n0 = n0.plus(d2.times(n1));
    d0 = d0.plus(d2.times(d1));
    n0.s = n1.s = x.s;

    // Determine which fraction is closer to x, n0/d0 or n1/d1?
    r = divide(n1, d1, e, 1).minus(x).abs().cmp(divide(n0, d0, e, 1).minus(x).abs()) < 1
        ? [n1, d1] : [n0, d0];

    Ctor.precision = pr;
    external = true;

    return r;
  };


  /*
   * Return a string representing the value of this Decimal in base 16, round to `sd` significant
   * digits using rounding mode `rm`.
   *
   * If the optional `sd` argument is present then return binary exponential notation.
   *
   * [sd] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toHexadecimal = P.toHex = function (sd, rm) {
    return toStringBinary(this, 16, sd, rm);
  };


  /*
   * Returns a new Decimal whose value is the nearest multiple of `y` in the direction of rounding
   * mode `rm`, or `Decimal.rounding` if `rm` is omitted, to the value of this Decimal.
   *
   * The return value will always have the same sign as this Decimal, unless either this Decimal
   * or `y` is NaN, in which case the return value will be also be NaN.
   *
   * The return value is not affected by the value of `precision`.
   *
   * y {number|string|Decimal} The magnitude to round to a multiple of.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   * 'toNearest() rounding mode not an integer: {rm}'
   * 'toNearest() rounding mode out of range: {rm}'
   *
   */
  P.toNearest = function (y, rm) {
    var x = this,
      Ctor = x.constructor;

    x = new Ctor(x);

    if (y == null) {

      // If x is not finite, return x.
      if (!x.d) return x;

      y = new Ctor(1);
      rm = Ctor.rounding;
    } else {
      y = new Ctor(y);
      if (rm === void 0) {
        rm = Ctor.rounding;
      } else {
        checkInt32(rm, 0, 8);
      }

      // If x is not finite, return x if y is not NaN, else NaN.
      if (!x.d) return y.s ? x : y;

      // If y is not finite, return Infinity with the sign of x if y is Infinity, else NaN.
      if (!y.d) {
        if (y.s) y.s = x.s;
        return y;
      }
    }

    // If y is not zero, calculate the nearest multiple of y to x.
    if (y.d[0]) {
      external = false;
      x = divide(x, y, 0, rm, 1).times(y);
      external = true;
      finalise(x);

    // If y is zero, return zero with the sign of x.
    } else {
      y.s = x.s;
      x = y;
    }

    return x;
  };


  /*
   * Return the value of this Decimal converted to a number primitive.
   * Zero keeps its sign.
   *
   */
  P.toNumber = function () {
    return +this;
  };


  /*
   * Return a string representing the value of this Decimal in base 8, round to `sd` significant
   * digits using rounding mode `rm`.
   *
   * If the optional `sd` argument is present then return binary exponential notation.
   *
   * [sd] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toOctal = function (sd, rm) {
    return toStringBinary(this, 8, sd, rm);
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal raised to the power `y`, rounded
   * to `precision` significant digits using rounding mode `rounding`.
   *
   * ECMAScript compliant.
   *
   *   pow(x, NaN)                           = NaN
   *   pow(x, ±0)                            = 1

   *   pow(NaN, non-zero)                    = NaN
   *   pow(abs(x) > 1, +Infinity)            = +Infinity
   *   pow(abs(x) > 1, -Infinity)            = +0
   *   pow(abs(x) == 1, ±Infinity)           = NaN
   *   pow(abs(x) < 1, +Infinity)            = +0
   *   pow(abs(x) < 1, -Infinity)            = +Infinity
   *   pow(+Infinity, y > 0)                 = +Infinity
   *   pow(+Infinity, y < 0)                 = +0
   *   pow(-Infinity, odd integer > 0)       = -Infinity
   *   pow(-Infinity, even integer > 0)      = +Infinity
   *   pow(-Infinity, odd integer < 0)       = -0
   *   pow(-Infinity, even integer < 0)      = +0
   *   pow(+0, y > 0)                        = +0
   *   pow(+0, y < 0)                        = +Infinity
   *   pow(-0, odd integer > 0)              = -0
   *   pow(-0, even integer > 0)             = +0
   *   pow(-0, odd integer < 0)              = -Infinity
   *   pow(-0, even integer < 0)             = +Infinity
   *   pow(finite x < 0, finite non-integer) = NaN
   *
   * For non-integer or very large exponents pow(x, y) is calculated using
   *
   *   x^y = exp(y*ln(x))
   *
   * Assuming the first 15 rounding digits are each equally likely to be any digit 0-9, the
   * probability of an incorrectly rounded result
   * P([49]9{14} | [50]0{14}) = 2 * 0.2 * 10^-14 = 4e-15 = 1/2.5e+14
   * i.e. 1 in 250,000,000,000,000
   *
   * If a result is incorrectly rounded the maximum error will be 1 ulp (unit in last place).
   *
   * y {number|string|Decimal} The power to which to raise this Decimal.
   *
   */
  P.toPower = P.pow = function (y) {
    var e, k, pr, r, rm, s,
      x = this,
      Ctor = x.constructor,
      yn = +(y = new Ctor(y));

    // Either ±Infinity, NaN or ±0?
    if (!x.d || !y.d || !x.d[0] || !y.d[0]) return new Ctor(mathpow(+x, yn));

    x = new Ctor(x);

    if (x.eq(1)) return x;

    pr = Ctor.precision;
    rm = Ctor.rounding;

    if (y.eq(1)) return finalise(x, pr, rm);

    // y exponent
    e = mathfloor(y.e / LOG_BASE);

    // If y is a small integer use the 'exponentiation by squaring' algorithm.
    if (e >= y.d.length - 1 && (k = yn < 0 ? -yn : yn) <= MAX_SAFE_INTEGER) {
      r = intPow(Ctor, x, k, pr);
      return y.s < 0 ? new Ctor(1).div(r) : finalise(r, pr, rm);
    }

    s = x.s;

    // if x is negative
    if (s < 0) {

      // if y is not an integer
      if (e < y.d.length - 1) return new Ctor(NaN);

      // Result is positive if x is negative and the last digit of integer y is even.
      if ((y.d[e] & 1) == 0) s = 1;

      // if x.eq(-1)
      if (x.e == 0 && x.d[0] == 1 && x.d.length == 1) {
        x.s = s;
        return x;
      }
    }

    // Estimate result exponent.
    // x^y = 10^e,  where e = y * log10(x)
    // log10(x) = log10(x_significand) + x_exponent
    // log10(x_significand) = ln(x_significand) / ln(10)
    k = mathpow(+x, yn);
    e = k == 0 || !isFinite(k)
      ? mathfloor(yn * (Math.log('0.' + digitsToString(x.d)) / Math.LN10 + x.e + 1))
      : new Ctor(k + '').e;

    // Exponent estimate may be incorrect e.g. x: 0.999999999999999999, y: 2.29, e: 0, r.e: -1.

    // Overflow/underflow?
    if (e > Ctor.maxE + 1 || e < Ctor.minE - 1) return new Ctor(e > 0 ? s / 0 : 0);

    external = false;
    Ctor.rounding = x.s = 1;

    // Estimate the extra guard digits needed to ensure five correct rounding digits from
    // naturalLogarithm(x). Example of failure without these extra digits (precision: 10):
    // new Decimal(2.32456).pow('2087987436534566.46411')
    // should be 1.162377823e+764914905173815, but is 1.162355823e+764914905173815
    k = Math.min(12, (e + '').length);

    // r = x^y = exp(y*ln(x))
    r = naturalExponential(y.times(naturalLogarithm(x, pr + k)), pr);

    // r may be Infinity, e.g. (0.9999999999999999).pow(-1e+40)
    if (r.d) {

      // Truncate to the required precision plus five rounding digits.
      r = finalise(r, pr + 5, 1);

      // If the rounding digits are [49]9999 or [50]0000 increase the precision by 10 and recalculate
      // the result.
      if (checkRoundingDigits(r.d, pr, rm)) {
        e = pr + 10;

        // Truncate to the increased precision plus five rounding digits.
        r = finalise(naturalExponential(y.times(naturalLogarithm(x, e + k)), e), e + 5, 1);

        // Check for 14 nines from the 2nd rounding digit (the first rounding digit may be 4 or 9).
        if (+digitsToString(r.d).slice(pr + 1, pr + 15) + 1 == 1e14) {
          r = finalise(r, pr + 1, 0);
        }
      }
    }

    r.s = s;
    external = true;
    Ctor.rounding = rm;

    return finalise(r, pr, rm);
  };


  /*
   * Return a string representing the value of this Decimal rounded to `sd` significant digits
   * using rounding mode `rounding`.
   *
   * Return exponential notation if `sd` is less than the number of digits necessary to represent
   * the integer part of the value in normal notation.
   *
   * [sd] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toPrecision = function (sd, rm) {
    var str,
      x = this,
      Ctor = x.constructor;

    if (sd === void 0) {
      str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
    } else {
      checkInt32(sd, 1, MAX_DIGITS);

      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);

      x = finalise(new Ctor(x), sd, rm);
      str = finiteToString(x, sd <= x.e || x.e <= Ctor.toExpNeg, sd);
    }

    return x.isNeg() && !x.isZero() ? '-' + str : str;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a maximum of `sd`
   * significant digits using rounding mode `rm`, or to `precision` and `rounding` respectively if
   * omitted.
   *
   * [sd] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   * 'toSD() digits out of range: {sd}'
   * 'toSD() digits not an integer: {sd}'
   * 'toSD() rounding mode not an integer: {rm}'
   * 'toSD() rounding mode out of range: {rm}'
   *
   */
  P.toSignificantDigits = P.toSD = function (sd, rm) {
    var x = this,
      Ctor = x.constructor;

    if (sd === void 0) {
      sd = Ctor.precision;
      rm = Ctor.rounding;
    } else {
      checkInt32(sd, 1, MAX_DIGITS);

      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
    }

    return finalise(new Ctor(x), sd, rm);
  };


  /*
   * Return a string representing the value of this Decimal.
   *
   * Return exponential notation if this Decimal has a positive exponent equal to or greater than
   * `toExpPos`, or a negative exponent equal to or less than `toExpNeg`.
   *
   */
  P.toString = function () {
    var x = this,
      Ctor = x.constructor,
      str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);

    return x.isNeg() && !x.isZero() ? '-' + str : str;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal truncated to a whole number.
   *
   */
  P.truncated = P.trunc = function () {
    return finalise(new this.constructor(this), this.e + 1, 1);
  };


  /*
   * Return a string representing the value of this Decimal.
   * Unlike `toString`, negative zero will include the minus sign.
   *
   */
  P.valueOf = P.toJSON = function () {
    var x = this,
      Ctor = x.constructor,
      str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);

    return x.isNeg() ? '-' + str : str;
  };


  /*
  // Add aliases to match BigDecimal method names.
  // P.add = P.plus;
  P.subtract = P.minus;
  P.multiply = P.times;
  P.divide = P.div;
  P.remainder = P.mod;
  P.compareTo = P.cmp;
  P.negate = P.neg;
   */


  // Helper functions for Decimal.prototype (P) and/or Decimal methods, and their callers.


  /*
   *  digitsToString           P.cubeRoot, P.logarithm, P.squareRoot, P.toFraction, P.toPower,
   *                           finiteToString, naturalExponential, naturalLogarithm
   *  checkInt32               P.toDecimalPlaces, P.toExponential, P.toFixed, P.toNearest,
   *                           P.toPrecision, P.toSignificantDigits, toStringBinary, random
   *  checkRoundingDigits      P.logarithm, P.toPower, naturalExponential, naturalLogarithm
   *  convertBase              toStringBinary, parseOther
   *  cos                      P.cos
   *  divide                   P.atanh, P.cubeRoot, P.dividedBy, P.dividedToIntegerBy,
   *                           P.logarithm, P.modulo, P.squareRoot, P.tan, P.tanh, P.toFraction,
   *                           P.toNearest, toStringBinary, naturalExponential, naturalLogarithm,
   *                           taylorSeries, atan2, parseOther
   *  finalise                 P.absoluteValue, P.atan, P.atanh, P.ceil, P.cos, P.cosh,
   *                           P.cubeRoot, P.dividedToIntegerBy, P.floor, P.logarithm, P.minus,
   *                           P.modulo, P.negated, P.plus, P.round, P.sin, P.sinh, P.squareRoot,
   *                           P.tan, P.times, P.toDecimalPlaces, P.toExponential, P.toFixed,
   *                           P.toNearest, P.toPower, P.toPrecision, P.toSignificantDigits,
   *                           P.truncated, divide, getLn10, getPi, naturalExponential,
   *                           naturalLogarithm, ceil, floor, round, trunc
   *  finiteToString           P.toExponential, P.toFixed, P.toPrecision, P.toString, P.valueOf,
   *                           toStringBinary
   *  getBase10Exponent        P.minus, P.plus, P.times, parseOther
   *  getLn10                  P.logarithm, naturalLogarithm
   *  getPi                    P.acos, P.asin, P.atan, toLessThanHalfPi, atan2
   *  getPrecision             P.precision, P.toFraction
   *  getZeroString            digitsToString, finiteToString
   *  intPow                   P.toPower, parseOther
   *  isOdd                    toLessThanHalfPi
   *  maxOrMin                 max, min
   *  naturalExponential       P.naturalExponential, P.toPower
   *  naturalLogarithm         P.acosh, P.asinh, P.atanh, P.logarithm, P.naturalLogarithm,
   *                           P.toPower, naturalExponential
   *  nonFiniteToString        finiteToString, toStringBinary
   *  parseDecimal             Decimal
   *  parseOther               Decimal
   *  sin                      P.sin
   *  taylorSeries             P.cosh, P.sinh, cos, sin
   *  toLessThanHalfPi         P.cos, P.sin
   *  toStringBinary           P.toBinary, P.toHexadecimal, P.toOctal
   *  truncate                 intPow
   *
   *  Throws:                  P.logarithm, P.precision, P.toFraction, checkInt32, getLn10, getPi,
   *                           naturalLogarithm, config, parseOther, random, Decimal
   */


  function digitsToString(d) {
    var i, k, ws,
      indexOfLastWord = d.length - 1,
      str = '',
      w = d[0];

    if (indexOfLastWord > 0) {
      str += w;
      for (i = 1; i < indexOfLastWord; i++) {
        ws = d[i] + '';
        k = LOG_BASE - ws.length;
        if (k) str += getZeroString(k);
        str += ws;
      }

      w = d[i];
      ws = w + '';
      k = LOG_BASE - ws.length;
      if (k) str += getZeroString(k);
    } else if (w === 0) {
      return '0';
    }

    // Remove trailing zeros of last w.
    for (; w % 10 === 0;) w /= 10;

    return str + w;
  }


  function checkInt32(i, min, max) {
    if (i !== ~~i || i < min || i > max) {
      throw Error(invalidArgument + i);
    }
  }


  /*
   * Check 5 rounding digits if `repeating` is null, 4 otherwise.
   * `repeating == null` if caller is `log` or `pow`,
   * `repeating != null` if caller is `naturalLogarithm` or `naturalExponential`.
   */
  function checkRoundingDigits(d, i, rm, repeating) {
    var di, k, r, rd;

    // Get the length of the first word of the array d.
    for (k = d[0]; k >= 10; k /= 10) --i;

    // Is the rounding digit in the first word of d?
    if (--i < 0) {
      i += LOG_BASE;
      di = 0;
    } else {
      di = Math.ceil((i + 1) / LOG_BASE);
      i %= LOG_BASE;
    }

    // i is the index (0 - 6) of the rounding digit.
    // E.g. if within the word 3487563 the first rounding digit is 5,
    // then i = 4, k = 1000, rd = 3487563 % 1000 = 563
    k = mathpow(10, LOG_BASE - i);
    rd = d[di] % k | 0;

    if (repeating == null) {
      if (i < 3) {
        if (i == 0) rd = rd / 100 | 0;
        else if (i == 1) rd = rd / 10 | 0;
        r = rm < 4 && rd == 99999 || rm > 3 && rd == 49999 || rd == 50000 || rd == 0;
      } else {
        r = (rm < 4 && rd + 1 == k || rm > 3 && rd + 1 == k / 2) &&
          (d[di + 1] / k / 100 | 0) == mathpow(10, i - 2) - 1 ||
            (rd == k / 2 || rd == 0) && (d[di + 1] / k / 100 | 0) == 0;
      }
    } else {
      if (i < 4) {
        if (i == 0) rd = rd / 1000 | 0;
        else if (i == 1) rd = rd / 100 | 0;
        else if (i == 2) rd = rd / 10 | 0;
        r = (repeating || rm < 4) && rd == 9999 || !repeating && rm > 3 && rd == 4999;
      } else {
        r = ((repeating || rm < 4) && rd + 1 == k ||
        (!repeating && rm > 3) && rd + 1 == k / 2) &&
          (d[di + 1] / k / 1000 | 0) == mathpow(10, i - 3) - 1;
      }
    }

    return r;
  }


  // Convert string of `baseIn` to an array of numbers of `baseOut`.
  // Eg. convertBase('255', 10, 16) returns [15, 15].
  // Eg. convertBase('ff', 16, 10) returns [2, 5, 5].
  function convertBase(str, baseIn, baseOut) {
    var j,
      arr = [0],
      arrL,
      i = 0,
      strL = str.length;

    for (; i < strL;) {
      for (arrL = arr.length; arrL--;) arr[arrL] *= baseIn;
      arr[0] += NUMERALS.indexOf(str.charAt(i++));
      for (j = 0; j < arr.length; j++) {
        if (arr[j] > baseOut - 1) {
          if (arr[j + 1] === void 0) arr[j + 1] = 0;
          arr[j + 1] += arr[j] / baseOut | 0;
          arr[j] %= baseOut;
        }
      }
    }

    return arr.reverse();
  }


  /*
   * cos(x) = 1 - x^2/2! + x^4/4! - ...
   * |x| < pi/2
   *
   */
  function cosine(Ctor, x) {
    var k, y,
      len = x.d.length;

    // Argument reduction: cos(4x) = 8*(cos^4(x) - cos^2(x)) + 1
    // i.e. cos(x) = 8*(cos^4(x/4) - cos^2(x/4)) + 1

    // Estimate the optimum number of times to use the argument reduction.
    if (len < 32) {
      k = Math.ceil(len / 3);
      y = (1 / tinyPow(4, k)).toString();
    } else {
      k = 16;
      y = '2.3283064365386962890625e-10';
    }

    Ctor.precision += k;

    x = taylorSeries(Ctor, 1, x.times(y), new Ctor(1));

    // Reverse argument reduction
    for (var i = k; i--;) {
      var cos2x = x.times(x);
      x = cos2x.times(cos2x).minus(cos2x).times(8).plus(1);
    }

    Ctor.precision -= k;

    return x;
  }


  /*
   * Perform division in the specified base.
   */
  var divide = (function () {

    // Assumes non-zero x and k, and hence non-zero result.
    function multiplyInteger(x, k, base) {
      var temp,
        carry = 0,
        i = x.length;

      for (x = x.slice(); i--;) {
        temp = x[i] * k + carry;
        x[i] = temp % base | 0;
        carry = temp / base | 0;
      }

      if (carry) x.unshift(carry);

      return x;
    }

    function compare(a, b, aL, bL) {
      var i, r;

      if (aL != bL) {
        r = aL > bL ? 1 : -1;
      } else {
        for (i = r = 0; i < aL; i++) {
          if (a[i] != b[i]) {
            r = a[i] > b[i] ? 1 : -1;
            break;
          }
        }
      }

      return r;
    }

    function subtract(a, b, aL, base) {
      var i = 0;

      // Subtract b from a.
      for (; aL--;) {
        a[aL] -= i;
        i = a[aL] < b[aL] ? 1 : 0;
        a[aL] = i * base + a[aL] - b[aL];
      }

      // Remove leading zeros.
      for (; !a[0] && a.length > 1;) a.shift();
    }

    return function (x, y, pr, rm, dp, base) {
      var cmp, e, i, k, logBase, more, prod, prodL, q, qd, rem, remL, rem0, sd, t, xi, xL, yd0,
        yL, yz,
        Ctor = x.constructor,
        sign = x.s == y.s ? 1 : -1,
        xd = x.d,
        yd = y.d;

      // Either NaN, Infinity or 0?
      if (!xd || !xd[0] || !yd || !yd[0]) {

        return new Ctor(// Return NaN if either NaN, or both Infinity or 0.
          !x.s || !y.s || (xd ? yd && xd[0] == yd[0] : !yd) ? NaN :

          // Return ±0 if x is 0 or y is ±Infinity, or return ±Infinity as y is 0.
          xd && xd[0] == 0 || !yd ? sign * 0 : sign / 0);
      }

      if (base) {
        logBase = 1;
        e = x.e - y.e;
      } else {
        base = BASE;
        logBase = LOG_BASE;
        e = mathfloor(x.e / logBase) - mathfloor(y.e / logBase);
      }

      yL = yd.length;
      xL = xd.length;
      q = new Ctor(sign);
      qd = q.d = [];

      // Result exponent may be one less than e.
      // The digit array of a Decimal from toStringBinary may have trailing zeros.
      for (i = 0; yd[i] == (xd[i] || 0); i++);

      if (yd[i] > (xd[i] || 0)) e--;

      if (pr == null) {
        sd = pr = Ctor.precision;
        rm = Ctor.rounding;
      } else if (dp) {
        sd = pr + (x.e - y.e) + 1;
      } else {
        sd = pr;
      }

      if (sd < 0) {
        qd.push(1);
        more = true;
      } else {

        // Convert precision in number of base 10 digits to base 1e7 digits.
        sd = sd / logBase + 2 | 0;
        i = 0;

        // divisor < 1e7
        if (yL == 1) {
          k = 0;
          yd = yd[0];
          sd++;

          // k is the carry.
          for (; (i < xL || k) && sd--; i++) {
            t = k * base + (xd[i] || 0);
            qd[i] = t / yd | 0;
            k = t % yd | 0;
          }

          more = k || i < xL;

        // divisor >= 1e7
        } else {

          // Normalise xd and yd so highest order digit of yd is >= base/2
          k = base / (yd[0] + 1) | 0;

          if (k > 1) {
            yd = multiplyInteger(yd, k, base);
            xd = multiplyInteger(xd, k, base);
            yL = yd.length;
            xL = xd.length;
          }

          xi = yL;
          rem = xd.slice(0, yL);
          remL = rem.length;

          // Add zeros to make remainder as long as divisor.
          for (; remL < yL;) rem[remL++] = 0;

          yz = yd.slice();
          yz.unshift(0);
          yd0 = yd[0];

          if (yd[1] >= base / 2) ++yd0;

          do {
            k = 0;

            // Compare divisor and remainder.
            cmp = compare(yd, rem, yL, remL);

            // If divisor < remainder.
            if (cmp < 0) {

              // Calculate trial digit, k.
              rem0 = rem[0];
              if (yL != remL) rem0 = rem0 * base + (rem[1] || 0);

              // k will be how many times the divisor goes into the current remainder.
              k = rem0 / yd0 | 0;

              //  Algorithm:
              //  1. product = divisor * trial digit (k)
              //  2. if product > remainder: product -= divisor, k--
              //  3. remainder -= product
              //  4. if product was < remainder at 2:
              //    5. compare new remainder and divisor
              //    6. If remainder > divisor: remainder -= divisor, k++

              if (k > 1) {
                if (k >= base) k = base - 1;

                // product = divisor * trial digit.
                prod = multiplyInteger(yd, k, base);
                prodL = prod.length;
                remL = rem.length;

                // Compare product and remainder.
                cmp = compare(prod, rem, prodL, remL);

                // product > remainder.
                if (cmp == 1) {
                  k--;

                  // Subtract divisor from product.
                  subtract(prod, yL < prodL ? yz : yd, prodL, base);
                }
              } else {

                // cmp is -1.
                // If k is 0, there is no need to compare yd and rem again below, so change cmp to 1
                // to avoid it. If k is 1 there is a need to compare yd and rem again below.
                if (k == 0) cmp = k = 1;
                prod = yd.slice();
              }

              prodL = prod.length;
              if (prodL < remL) prod.unshift(0);

              // Subtract product from remainder.
              subtract(rem, prod, remL, base);

              // If product was < previous remainder.
              if (cmp == -1) {
                remL = rem.length;

                // Compare divisor and new remainder.
                cmp = compare(yd, rem, yL, remL);

                // If divisor < new remainder, subtract divisor from remainder.
                if (cmp < 1) {
                  k++;

                  // Subtract divisor from remainder.
                  subtract(rem, yL < remL ? yz : yd, remL, base);
                }
              }

              remL = rem.length;
            } else if (cmp === 0) {
              k++;
              rem = [0];
            }    // if cmp === 1, k will be 0

            // Add the next digit, k, to the result array.
            qd[i++] = k;

            // Update the remainder.
            if (cmp && rem[0]) {
              rem[remL++] = xd[xi] || 0;
            } else {
              rem = [xd[xi]];
              remL = 1;
            }

          } while ((xi++ < xL || rem[0] !== void 0) && sd--);

          more = rem[0] !== void 0;
        }

        // Leading zero?
        if (!qd[0]) qd.shift();
      }

      // logBase is 1 when divide is being used for base conversion.
      if (logBase == 1) {
        q.e = e;
        inexact = more;
      } else {

        // To calculate q.e, first get the number of digits of qd[0].
        for (i = 1, k = qd[0]; k >= 10; k /= 10) i++;
        q.e = i + e * logBase - 1;

        finalise(q, dp ? pr + q.e + 1 : pr, rm, more);
      }

      return q;
    };
  })();


  /*
   * Round `x` to `sd` significant digits using rounding mode `rm`.
   * Check for over/under-flow.
   */
   function finalise(x, sd, rm, isTruncated) {
    var digits, i, j, k, rd, roundUp, w, xd, xdi,
      Ctor = x.constructor;

    // Don't round if sd is null or undefined.
    out: if (sd != null) {
      xd = x.d;

      // Infinity/NaN.
      if (!xd) return x;

      // rd: the rounding digit, i.e. the digit after the digit that may be rounded up.
      // w: the word of xd containing rd, a base 1e7 number.
      // xdi: the index of w within xd.
      // digits: the number of digits of w.
      // i: what would be the index of rd within w if all the numbers were 7 digits long (i.e. if
      // they had leading zeros)
      // j: if > 0, the actual index of rd within w (if < 0, rd is a leading zero).

      // Get the length of the first word of the digits array xd.
      for (digits = 1, k = xd[0]; k >= 10; k /= 10) digits++;
      i = sd - digits;

      // Is the rounding digit in the first word of xd?
      if (i < 0) {
        i += LOG_BASE;
        j = sd;
        w = xd[xdi = 0];

        // Get the rounding digit at index j of w.
        rd = w / mathpow(10, digits - j - 1) % 10 | 0;
      } else {
        xdi = Math.ceil((i + 1) / LOG_BASE);
        k = xd.length;
        if (xdi >= k) {
          if (isTruncated) {

            // Needed by `naturalExponential`, `naturalLogarithm` and `squareRoot`.
            for (; k++ <= xdi;) xd.push(0);
            w = rd = 0;
            digits = 1;
            i %= LOG_BASE;
            j = i - LOG_BASE + 1;
          } else {
            break out;
          }
        } else {
          w = k = xd[xdi];

          // Get the number of digits of w.
          for (digits = 1; k >= 10; k /= 10) digits++;

          // Get the index of rd within w.
          i %= LOG_BASE;

          // Get the index of rd within w, adjusted for leading zeros.
          // The number of leading zeros of w is given by LOG_BASE - digits.
          j = i - LOG_BASE + digits;

          // Get the rounding digit at index j of w.
          rd = j < 0 ? 0 : w / mathpow(10, digits - j - 1) % 10 | 0;
        }
      }

      // Are there any non-zero digits after the rounding digit?
      isTruncated = isTruncated || sd < 0 ||
        xd[xdi + 1] !== void 0 || (j < 0 ? w : w % mathpow(10, digits - j - 1));

      // The expression `w % mathpow(10, digits - j - 1)` returns all the digits of w to the right
      // of the digit at (left-to-right) index j, e.g. if w is 908714 and j is 2, the expression
      // will give 714.

      roundUp = rm < 4
        ? (rd || isTruncated) && (rm == 0 || rm == (x.s < 0 ? 3 : 2))
        : rd > 5 || rd == 5 && (rm == 4 || isTruncated || rm == 6 &&

          // Check whether the digit to the left of the rounding digit is odd.
          ((i > 0 ? j > 0 ? w / mathpow(10, digits - j) : 0 : xd[xdi - 1]) % 10) & 1 ||
            rm == (x.s < 0 ? 8 : 7));

      if (sd < 1 || !xd[0]) {
        xd.length = 0;
        if (roundUp) {

          // Convert sd to decimal places.
          sd -= x.e + 1;

          // 1, 0.1, 0.01, 0.001, 0.0001 etc.
          xd[0] = mathpow(10, (LOG_BASE - sd % LOG_BASE) % LOG_BASE);
          x.e = -sd || 0;
        } else {

          // Zero.
          xd[0] = x.e = 0;
        }

        return x;
      }

      // Remove excess digits.
      if (i == 0) {
        xd.length = xdi;
        k = 1;
        xdi--;
      } else {
        xd.length = xdi + 1;
        k = mathpow(10, LOG_BASE - i);

        // E.g. 56700 becomes 56000 if 7 is the rounding digit.
        // j > 0 means i > number of leading zeros of w.
        xd[xdi] = j > 0 ? (w / mathpow(10, digits - j) % mathpow(10, j) | 0) * k : 0;
      }

      if (roundUp) {
        for (;;) {

          // Is the digit to be rounded up in the first word of xd?
          if (xdi == 0) {

            // i will be the length of xd[0] before k is added.
            for (i = 1, j = xd[0]; j >= 10; j /= 10) i++;
            j = xd[0] += k;
            for (k = 1; j >= 10; j /= 10) k++;

            // if i != k the length has increased.
            if (i != k) {
              x.e++;
              if (xd[0] == BASE) xd[0] = 1;
            }

            break;
          } else {
            xd[xdi] += k;
            if (xd[xdi] != BASE) break;
            xd[xdi--] = 0;
            k = 1;
          }
        }
      }

      // Remove trailing zeros.
      for (i = xd.length; xd[--i] === 0;) xd.pop();
    }

    if (external) {

      // Overflow?
      if (x.e > Ctor.maxE) {

        // Infinity.
        x.d = null;
        x.e = NaN;

      // Underflow?
      } else if (x.e < Ctor.minE) {

        // Zero.
        x.e = 0;
        x.d = [0];
        // Ctor.underflow = true;
      } // else Ctor.underflow = false;
    }

    return x;
  }


  function finiteToString(x, isExp, sd) {
    if (!x.isFinite()) return nonFiniteToString(x);
    var k,
      e = x.e,
      str = digitsToString(x.d),
      len = str.length;

    if (isExp) {
      if (sd && (k = sd - len) > 0) {
        str = str.charAt(0) + '.' + str.slice(1) + getZeroString(k);
      } else if (len > 1) {
        str = str.charAt(0) + '.' + str.slice(1);
      }

      str = str + (x.e < 0 ? 'e' : 'e+') + x.e;
    } else if (e < 0) {
      str = '0.' + getZeroString(-e - 1) + str;
      if (sd && (k = sd - len) > 0) str += getZeroString(k);
    } else if (e >= len) {
      str += getZeroString(e + 1 - len);
      if (sd && (k = sd - e - 1) > 0) str = str + '.' + getZeroString(k);
    } else {
      if ((k = e + 1) < len) str = str.slice(0, k) + '.' + str.slice(k);
      if (sd && (k = sd - len) > 0) {
        if (e + 1 === len) str += '.';
        str += getZeroString(k);
      }
    }

    return str;
  }


  // Calculate the base 10 exponent from the base 1e7 exponent.
  function getBase10Exponent(digits, e) {
    var w = digits[0];

    // Add the number of digits of the first word of the digits array.
    for ( e *= LOG_BASE; w >= 10; w /= 10) e++;
    return e;
  }


  function getLn10(Ctor, sd, pr) {
    if (sd > LN10_PRECISION) {

      // Reset global state in case the exception is caught.
      external = true;
      if (pr) Ctor.precision = pr;
      throw Error(precisionLimitExceeded);
    }
    return finalise(new Ctor(LN10), sd, 1, true);
  }


  function getPi(Ctor, sd, rm) {
    if (sd > PI_PRECISION) throw Error(precisionLimitExceeded);
    return finalise(new Ctor(PI), sd, rm, true);
  }


  function getPrecision(digits) {
    var w = digits.length - 1,
      len = w * LOG_BASE + 1;

    w = digits[w];

    // If non-zero...
    if (w) {

      // Subtract the number of trailing zeros of the last word.
      for (; w % 10 == 0; w /= 10) len--;

      // Add the number of digits of the first word.
      for (w = digits[0]; w >= 10; w /= 10) len++;
    }

    return len;
  }


  function getZeroString(k) {
    var zs = '';
    for (; k--;) zs += '0';
    return zs;
  }


  /*
   * Return a new Decimal whose value is the value of Decimal `x` to the power `n`, where `n` is an
   * integer of type number.
   *
   * Implements 'exponentiation by squaring'. Called by `pow` and `parseOther`.
   *
   */
  function intPow(Ctor, x, n, pr) {
    var isTruncated,
      r = new Ctor(1),

      // Max n of 9007199254740991 takes 53 loop iterations.
      // Maximum digits array length; leaves [28, 34] guard digits.
      k = Math.ceil(pr / LOG_BASE + 4);

    external = false;

    for (;;) {
      if (n % 2) {
        r = r.times(x);
        if (truncate(r.d, k)) isTruncated = true;
      }

      n = mathfloor(n / 2);
      if (n === 0) {

        // To ensure correct rounding when r.d is truncated, increment the last word if it is zero.
        n = r.d.length - 1;
        if (isTruncated && r.d[n] === 0) ++r.d[n];
        break;
      }

      x = x.times(x);
      truncate(x.d, k);
    }

    external = true;

    return r;
  }


  function isOdd(n) {
    return n.d[n.d.length - 1] & 1;
  }


  /*
   * Handle `max` and `min`. `ltgt` is 'lt' or 'gt'.
   */
  function maxOrMin(Ctor, args, ltgt) {
    var y,
      x = new Ctor(args[0]),
      i = 0;

    for (; ++i < args.length;) {
      y = new Ctor(args[i]);
      if (!y.s) {
        x = y;
        break;
      } else if (x[ltgt](y)) {
        x = y;
      }
    }

    return x;
  }


  /*
   * Return a new Decimal whose value is the natural exponential of `x` rounded to `sd` significant
   * digits.
   *
   * Taylor/Maclaurin series.
   *
   * exp(x) = x^0/0! + x^1/1! + x^2/2! + x^3/3! + ...
   *
   * Argument reduction:
   *   Repeat x = x / 32, k += 5, until |x| < 0.1
   *   exp(x) = exp(x / 2^k)^(2^k)
   *
   * Previously, the argument was initially reduced by
   * exp(x) = exp(r) * 10^k  where r = x - k * ln10, k = floor(x / ln10)
   * to first put r in the range [0, ln10], before dividing by 32 until |x| < 0.1, but this was
   * found to be slower than just dividing repeatedly by 32 as above.
   *
   * Max integer argument: exp('20723265836946413') = 6.3e+9000000000000000
   * Min integer argument: exp('-20723265836946411') = 1.2e-9000000000000000
   * (Math object integer min/max: Math.exp(709) = 8.2e+307, Math.exp(-745) = 5e-324)
   *
   *  exp(Infinity)  = Infinity
   *  exp(-Infinity) = 0
   *  exp(NaN)       = NaN
   *  exp(±0)        = 1
   *
   *  exp(x) is non-terminating for any finite, non-zero x.
   *
   *  The result will always be correctly rounded.
   *
   */
  function naturalExponential(x, sd) {
    var denominator, guard, j, pow, sum, t, wpr,
      rep = 0,
      i = 0,
      k = 0,
      Ctor = x.constructor,
      rm = Ctor.rounding,
      pr = Ctor.precision;

    // 0/NaN/Infinity?
    if (!x.d || !x.d[0] || x.e > 17) {

      return new Ctor(x.d
        ? !x.d[0] ? 1 : x.s < 0 ? 0 : 1 / 0
        : x.s ? x.s < 0 ? 0 : x : 0 / 0);
    }

    if (sd == null) {
      external = false;
      wpr = pr;
    } else {
      wpr = sd;
    }

    t = new Ctor(0.03125);

    // while abs(x) >= 0.1
    while (x.e > -2) {

      // x = x / 2^5
      x = x.times(t);
      k += 5;
    }

    // Use 2 * log10(2^k) + 5 (empirically derived) to estimate the increase in precision
    // necessary to ensure the first 4 rounding digits are correct.
    guard = Math.log(mathpow(2, k)) / Math.LN10 * 2 + 5 | 0;
    wpr += guard;
    denominator = pow = sum = new Ctor(1);
    Ctor.precision = wpr;

    for (;;) {
      pow = finalise(pow.times(x), wpr, 1);
      denominator = denominator.times(++i);
      t = sum.plus(divide(pow, denominator, wpr, 1));

      if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum.d).slice(0, wpr)) {
        j = k;
        while (j--) sum = finalise(sum.times(sum), wpr, 1);

        // Check to see if the first 4 rounding digits are [49]999.
        // If so, repeat the summation with a higher precision, otherwise
        // e.g. with precision: 18, rounding: 1
        // exp(18.404272462595034083567793919843761) = 98372560.1229999999 (should be 98372560.123)
        // `wpr - guard` is the index of first rounding digit.
        if (sd == null) {

          if (rep < 3 && checkRoundingDigits(sum.d, wpr - guard, rm, rep)) {
            Ctor.precision = wpr += 10;
            denominator = pow = t = new Ctor(1);
            i = 0;
            rep++;
          } else {
            return finalise(sum, Ctor.precision = pr, rm, external = true);
          }
        } else {
          Ctor.precision = pr;
          return sum;
        }
      }

      sum = t;
    }
  }


  /*
   * Return a new Decimal whose value is the natural logarithm of `x` rounded to `sd` significant
   * digits.
   *
   *  ln(-n)        = NaN
   *  ln(0)         = -Infinity
   *  ln(-0)        = -Infinity
   *  ln(1)         = 0
   *  ln(Infinity)  = Infinity
   *  ln(-Infinity) = NaN
   *  ln(NaN)       = NaN
   *
   *  ln(n) (n != 1) is non-terminating.
   *
   */
  function naturalLogarithm(y, sd) {
    var c, c0, denominator, e, numerator, rep, sum, t, wpr, x1, x2,
      n = 1,
      guard = 10,
      x = y,
      xd = x.d,
      Ctor = x.constructor,
      rm = Ctor.rounding,
      pr = Ctor.precision;

    // Is x negative or Infinity, NaN, 0 or 1?
    if (x.s < 0 || !xd || !xd[0] || !x.e && xd[0] == 1 && xd.length == 1) {
      return new Ctor(xd && !xd[0] ? -1 / 0 : x.s != 1 ? NaN : xd ? 0 : x);
    }

    if (sd == null) {
      external = false;
      wpr = pr;
    } else {
      wpr = sd;
    }

    Ctor.precision = wpr += guard;
    c = digitsToString(xd);
    c0 = c.charAt(0);

    if (Math.abs(e = x.e) < 1.5e15) {

      // Argument reduction.
      // The series converges faster the closer the argument is to 1, so using
      // ln(a^b) = b * ln(a),   ln(a) = ln(a^b) / b
      // multiply the argument by itself until the leading digits of the significand are 7, 8, 9,
      // 10, 11, 12 or 13, recording the number of multiplications so the sum of the series can
      // later be divided by this number, then separate out the power of 10 using
      // ln(a*10^b) = ln(a) + b*ln(10).

      // max n is 21 (gives 0.9, 1.0 or 1.1) (9e15 / 21 = 4.2e14).
      //while (c0 < 9 && c0 != 1 || c0 == 1 && c.charAt(1) > 1) {
      // max n is 6 (gives 0.7 - 1.3)
      while (c0 < 7 && c0 != 1 || c0 == 1 && c.charAt(1) > 3) {
        x = x.times(y);
        c = digitsToString(x.d);
        c0 = c.charAt(0);
        n++;
      }

      e = x.e;

      if (c0 > 1) {
        x = new Ctor('0.' + c);
        e++;
      } else {
        x = new Ctor(c0 + '.' + c.slice(1));
      }
    } else {

      // The argument reduction method above may result in overflow if the argument y is a massive
      // number with exponent >= 1500000000000000 (9e15 / 6 = 1.5e15), so instead recall this
      // function using ln(x*10^e) = ln(x) + e*ln(10).
      t = getLn10(Ctor, wpr + 2, pr).times(e + '');
      x = naturalLogarithm(new Ctor(c0 + '.' + c.slice(1)), wpr - guard).plus(t);
      Ctor.precision = pr;

      return sd == null ? finalise(x, pr, rm, external = true) : x;
    }

    // x1 is x reduced to a value near 1.
    x1 = x;

    // Taylor series.
    // ln(y) = ln((1 + x)/(1 - x)) = 2(x + x^3/3 + x^5/5 + x^7/7 + ...)
    // where x = (y - 1)/(y + 1)    (|x| < 1)
    sum = numerator = x = divide(x.minus(1), x.plus(1), wpr, 1);
    x2 = finalise(x.times(x), wpr, 1);
    denominator = 3;

    for (;;) {
      numerator = finalise(numerator.times(x2), wpr, 1);
      t = sum.plus(divide(numerator, new Ctor(denominator), wpr, 1));

      if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum.d).slice(0, wpr)) {
        sum = sum.times(2);

        // Reverse the argument reduction. Check that e is not 0 because, besides preventing an
        // unnecessary calculation, -0 + 0 = +0 and to ensure correct rounding -0 needs to stay -0.
        if (e !== 0) sum = sum.plus(getLn10(Ctor, wpr + 2, pr).times(e + ''));
        sum = divide(sum, new Ctor(n), wpr, 1);

        // Is rm > 3 and the first 4 rounding digits 4999, or rm < 4 (or the summation has
        // been repeated previously) and the first 4 rounding digits 9999?
        // If so, restart the summation with a higher precision, otherwise
        // e.g. with precision: 12, rounding: 1
        // ln(135520028.6126091714265381533) = 18.7246299999 when it should be 18.72463.
        // `wpr - guard` is the index of first rounding digit.
        if (sd == null) {
          if (checkRoundingDigits(sum.d, wpr - guard, rm, rep)) {
            Ctor.precision = wpr += guard;
            t = numerator = x = divide(x1.minus(1), x1.plus(1), wpr, 1);
            x2 = finalise(x.times(x), wpr, 1);
            denominator = rep = 1;
          } else {
            return finalise(sum, Ctor.precision = pr, rm, external = true);
          }
        } else {
          Ctor.precision = pr;
          return sum;
        }
      }

      sum = t;
      denominator += 2;
    }
  }


  // ±Infinity, NaN.
  function nonFiniteToString(x) {
    // Unsigned.
    return String(x.s * x.s / 0);
  }


  /*
   * Parse the value of a new Decimal `x` from string `str`.
   */
  function parseDecimal(x, str) {
    var e, i, len;

    // Decimal point?
    if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');

    // Exponential form?
    if ((i = str.search(/e/i)) > 0) {

      // Determine exponent.
      if (e < 0) e = i;
      e += +str.slice(i + 1);
      str = str.substring(0, i);
    } else if (e < 0) {

      // Integer.
      e = str.length;
    }

    // Determine leading zeros.
    for (i = 0; str.charCodeAt(i) === 48; i++);

    // Determine trailing zeros.
    for (len = str.length; str.charCodeAt(len - 1) === 48; --len);
    str = str.slice(i, len);

    if (str) {
      len -= i;
      x.e = e = e - i - 1;
      x.d = [];

      // Transform base

      // e is the base 10 exponent.
      // i is where to slice str to get the first word of the digits array.
      i = (e + 1) % LOG_BASE;
      if (e < 0) i += LOG_BASE;

      if (i < len) {
        if (i) x.d.push(+str.slice(0, i));
        for (len -= LOG_BASE; i < len;) x.d.push(+str.slice(i, i += LOG_BASE));
        str = str.slice(i);
        i = LOG_BASE - str.length;
      } else {
        i -= len;
      }

      for (; i--;) str += '0';
      x.d.push(+str);

      if (external) {

        // Overflow?
        if (x.e > x.constructor.maxE) {

          // Infinity.
          x.d = null;
          x.e = NaN;

        // Underflow?
        } else if (x.e < x.constructor.minE) {

          // Zero.
          x.e = 0;
          x.d = [0];
          // x.constructor.underflow = true;
        } // else x.constructor.underflow = false;
      }
    } else {

      // Zero.
      x.e = 0;
      x.d = [0];
    }

    return x;
  }


  /*
   * Parse the value of a new Decimal `x` from a string `str`, which is not a decimal value.
   */
  function parseOther(x, str) {
    var base, Ctor, divisor, i, isFloat, len, p, xd, xe;

    if (str === 'Infinity' || str === 'NaN') {
      if (!+str) x.s = NaN;
      x.e = NaN;
      x.d = null;
      return x;
    }

    if (isHex.test(str))  {
      base = 16;
      str = str.toLowerCase();
    } else if (isBinary.test(str))  {
      base = 2;
    } else if (isOctal.test(str))  {
      base = 8;
    } else {
      throw Error(invalidArgument + str);
    }

    // Is there a binary exponent part?
    i = str.search(/p/i);

    if (i > 0) {
      p = +str.slice(i + 1);
      str = str.substring(2, i);
    } else {
      str = str.slice(2);
    }

    // Convert `str` as an integer then divide the result by `base` raised to a power such that the
    // fraction part will be restored.
    i = str.indexOf('.');
    isFloat = i >= 0;
    Ctor = x.constructor;

    if (isFloat) {
      str = str.replace('.', '');
      len = str.length;
      i = len - i;

      // log[10](16) = 1.2041... , log[10](88) = 1.9444....
      divisor = intPow(Ctor, new Ctor(base), i, i * 2);
    }

    xd = convertBase(str, base, BASE);
    xe = xd.length - 1;

    // Remove trailing zeros.
    for (i = xe; xd[i] === 0; --i) xd.pop();
    if (i < 0) return new Ctor(x.s * 0);
    x.e = getBase10Exponent(xd, xe);
    x.d = xd;
    external = false;

    // At what precision to perform the division to ensure exact conversion?
    // maxDecimalIntegerPartDigitCount = ceil(log[10](b) * otherBaseIntegerPartDigitCount)
    // log[10](2) = 0.30103, log[10](8) = 0.90309, log[10](16) = 1.20412
    // E.g. ceil(1.2 * 3) = 4, so up to 4 decimal digits are needed to represent 3 hex int digits.
    // maxDecimalFractionPartDigitCount = {Hex:4|Oct:3|Bin:1} * otherBaseFractionPartDigitCount
    // Therefore using 4 * the number of digits of str will always be enough.
    if (isFloat) x = divide(x, divisor, len * 4);

    // Multiply by the binary exponent part if present.
    if (p) x = x.times(Math.abs(p) < 54 ? mathpow(2, p) : Decimal.pow(2, p));
    external = true;

    return x;
  }


  /*
   * sin(x) = x - x^3/3! + x^5/5! - ...
   * |x| < pi/2
   *
   */
  function sine(Ctor, x) {
    var k,
      len = x.d.length;

    if (len < 3) return taylorSeries(Ctor, 2, x, x);

    // Argument reduction: sin(5x) = 16*sin^5(x) - 20*sin^3(x) + 5*sin(x)
    // i.e. sin(x) = 16*sin^5(x/5) - 20*sin^3(x/5) + 5*sin(x/5)
    // and  sin(x) = sin(x/5)(5 + sin^2(x/5)(16sin^2(x/5) - 20))

    // Estimate the optimum number of times to use the argument reduction.
    k = 1.4 * Math.sqrt(len);
    k = k > 16 ? 16 : k | 0;

    x = x.times(1 / tinyPow(5, k));
    x = taylorSeries(Ctor, 2, x, x);

    // Reverse argument reduction
    var sin2_x,
      d5 = new Ctor(5),
      d16 = new Ctor(16),
      d20 = new Ctor(20);
    for (; k--;) {
      sin2_x = x.times(x);
      x = x.times(d5.plus(sin2_x.times(d16.times(sin2_x).minus(d20))));
    }

    return x;
  }


  // Calculate Taylor series for `cos`, `cosh`, `sin` and `sinh`.
  function taylorSeries(Ctor, n, x, y, isHyperbolic) {
    var j, t, u, x2,
      i = 1,
      pr = Ctor.precision,
      k = Math.ceil(pr / LOG_BASE);

    external = false;
    x2 = x.times(x);
    u = new Ctor(y);

    for (;;) {
      t = divide(u.times(x2), new Ctor(n++ * n++), pr, 1);
      u = isHyperbolic ? y.plus(t) : y.minus(t);
      y = divide(t.times(x2), new Ctor(n++ * n++), pr, 1);
      t = u.plus(y);

      if (t.d[k] !== void 0) {
        for (j = k; t.d[j] === u.d[j] && j--;);
        if (j == -1) break;
      }

      j = u;
      u = y;
      y = t;
      t = j;
      i++;
    }

    external = true;
    t.d.length = k + 1;

    return t;
  }


  // Exponent e must be positive and non-zero.
  function tinyPow(b, e) {
    var n = b;
    while (--e) n *= b;
    return n;
  }


  // Return the absolute value of `x` reduced to less than or equal to half pi.
  function toLessThanHalfPi(Ctor, x) {
    var t,
      isNeg = x.s < 0,
      pi = getPi(Ctor, Ctor.precision, 1),
      halfPi = pi.times(0.5);

    x = x.abs();

    if (x.lte(halfPi)) {
      quadrant = isNeg ? 4 : 1;
      return x;
    }

    t = x.divToInt(pi);

    if (t.isZero()) {
      quadrant = isNeg ? 3 : 2;
    } else {
      x = x.minus(t.times(pi));

      // 0 <= x < pi
      if (x.lte(halfPi)) {
        quadrant = isOdd(t) ? (isNeg ? 2 : 3) : (isNeg ? 4 : 1);
        return x;
      }

      quadrant = isOdd(t) ? (isNeg ? 1 : 4) : (isNeg ? 3 : 2);
    }

    return x.minus(pi).abs();
  }


  /*
   * Return the value of Decimal `x` as a string in base `baseOut`.
   *
   * If the optional `sd` argument is present include a binary exponent suffix.
   */
  function toStringBinary(x, baseOut, sd, rm) {
    var base, e, i, k, len, roundUp, str, xd, y,
      Ctor = x.constructor,
      isExp = sd !== void 0;

    if (isExp) {
      checkInt32(sd, 1, MAX_DIGITS);
      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
    } else {
      sd = Ctor.precision;
      rm = Ctor.rounding;
    }

    if (!x.isFinite()) {
      str = nonFiniteToString(x);
    } else {
      str = finiteToString(x);
      i = str.indexOf('.');

      // Use exponential notation according to `toExpPos` and `toExpNeg`? No, but if required:
      // maxBinaryExponent = floor((decimalExponent + 1) * log[2](10))
      // minBinaryExponent = floor(decimalExponent * log[2](10))
      // log[2](10) = 3.321928094887362347870319429489390175864

      if (isExp) {
        base = 2;
        if (baseOut == 16) {
          sd = sd * 4 - 3;
        } else if (baseOut == 8) {
          sd = sd * 3 - 2;
        }
      } else {
        base = baseOut;
      }

      // Convert the number as an integer then divide the result by its base raised to a power such
      // that the fraction part will be restored.

      // Non-integer.
      if (i >= 0) {
        str = str.replace('.', '');
        y = new Ctor(1);
        y.e = str.length - i;
        y.d = convertBase(finiteToString(y), 10, base);
        y.e = y.d.length;
      }

      xd = convertBase(str, 10, base);
      e = len = xd.length;

      // Remove trailing zeros.
      for (; xd[--len] == 0;) xd.pop();

      if (!xd[0]) {
        str = isExp ? '0p+0' : '0';
      } else {
        if (i < 0) {
          e--;
        } else {
          x = new Ctor(x);
          x.d = xd;
          x.e = e;
          x = divide(x, y, sd, rm, 0, base);
          xd = x.d;
          e = x.e;
          roundUp = inexact;
        }

        // The rounding digit, i.e. the digit after the digit that may be rounded up.
        i = xd[sd];
        k = base / 2;
        roundUp = roundUp || xd[sd + 1] !== void 0;

        roundUp = rm < 4
          ? (i !== void 0 || roundUp) && (rm === 0 || rm === (x.s < 0 ? 3 : 2))
          : i > k || i === k && (rm === 4 || roundUp || rm === 6 && xd[sd - 1] & 1 ||
            rm === (x.s < 0 ? 8 : 7));

        xd.length = sd;

        if (roundUp) {

          // Rounding up may mean the previous digit has to be rounded up and so on.
          for (; ++xd[--sd] > base - 1;) {
            xd[sd] = 0;
            if (!sd) {
              ++e;
              xd.unshift(1);
            }
          }
        }

        // Determine trailing zeros.
        for (len = xd.length; !xd[len - 1]; --len);

        // E.g. [4, 11, 15] becomes 4bf.
        for (i = 0, str = ''; i < len; i++) str += NUMERALS.charAt(xd[i]);

        // Add binary exponent suffix?
        if (isExp) {
          if (len > 1) {
            if (baseOut == 16 || baseOut == 8) {
              i = baseOut == 16 ? 4 : 3;
              for (--len; len % i; len++) str += '0';
              xd = convertBase(str, base, baseOut);
              for (len = xd.length; !xd[len - 1]; --len);

              // xd[0] will always be be 1
              for (i = 1, str = '1.'; i < len; i++) str += NUMERALS.charAt(xd[i]);
            } else {
              str = str.charAt(0) + '.' + str.slice(1);
            }
          }

          str =  str + (e < 0 ? 'p' : 'p+') + e;
        } else if (e < 0) {
          for (; ++e;) str = '0' + str;
          str = '0.' + str;
        } else {
          if (++e > len) for (e -= len; e-- ;) str += '0';
          else if (e < len) str = str.slice(0, e) + '.' + str.slice(e);
        }
      }

      str = (baseOut == 16 ? '0x' : baseOut == 2 ? '0b' : baseOut == 8 ? '0o' : '') + str;
    }

    return x.s < 0 ? '-' + str : str;
  }


  // Does not strip trailing zeros.
  function truncate(arr, len) {
    if (arr.length > len) {
      arr.length = len;
      return true;
    }
  }


  // Decimal methods


  /*
   *  abs
   *  acos
   *  acosh
   *  add
   *  asin
   *  asinh
   *  atan
   *  atanh
   *  atan2
   *  cbrt
   *  ceil
   *  clone
   *  config
   *  cos
   *  cosh
   *  div
   *  exp
   *  floor
   *  hypot
   *  ln
   *  log
   *  log2
   *  log10
   *  max
   *  min
   *  mod
   *  mul
   *  pow
   *  random
   *  round
   *  set
   *  sign
   *  sin
   *  sinh
   *  sqrt
   *  sub
   *  tan
   *  tanh
   *  trunc
   */


  /*
   * Return a new Decimal whose value is the absolute value of `x`.
   *
   * x {number|string|Decimal}
   *
   */
  function abs(x) {
    return new this(x).abs();
  }


  /*
   * Return a new Decimal whose value is the arccosine in radians of `x`.
   *
   * x {number|string|Decimal}
   *
   */
  function acos(x) {
    return new this(x).acos();
  }


  /*
   * Return a new Decimal whose value is the inverse of the hyperbolic cosine of `x`, rounded to
   * `precision` significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function acosh(x) {
    return new this(x).acosh();
  }


  /*
   * Return a new Decimal whose value is the sum of `x` and `y`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   * y {number|string|Decimal}
   *
   */
  function add(x, y) {
    return new this(x).plus(y);
  }


  /*
   * Return a new Decimal whose value is the arcsine in radians of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   *
   */
  function asin(x) {
    return new this(x).asin();
  }


  /*
   * Return a new Decimal whose value is the inverse of the hyperbolic sine of `x`, rounded to
   * `precision` significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function asinh(x) {
    return new this(x).asinh();
  }


  /*
   * Return a new Decimal whose value is the arctangent in radians of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   *
   */
  function atan(x) {
    return new this(x).atan();
  }


  /*
   * Return a new Decimal whose value is the inverse of the hyperbolic tangent of `x`, rounded to
   * `precision` significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function atanh(x) {
    return new this(x).atanh();
  }


  /*
   * Return a new Decimal whose value is the arctangent in radians of `y/x` in the range -pi to pi
   * (inclusive), rounded to `precision` significant digits using rounding mode `rounding`.
   *
   * Domain: [-Infinity, Infinity]
   * Range: [-pi, pi]
   *
   * y {number|string|Decimal} The y-coordinate.
   * x {number|string|Decimal} The x-coordinate.
   *
   * atan2(±0, -0)               = ±pi
   * atan2(±0, +0)               = ±0
   * atan2(±0, -x)               = ±pi for x > 0
   * atan2(±0, x)                = ±0 for x > 0
   * atan2(-y, ±0)               = -pi/2 for y > 0
   * atan2(y, ±0)                = pi/2 for y > 0
   * atan2(±y, -Infinity)        = ±pi for finite y > 0
   * atan2(±y, +Infinity)        = ±0 for finite y > 0
   * atan2(±Infinity, x)         = ±pi/2 for finite x
   * atan2(±Infinity, -Infinity) = ±3*pi/4
   * atan2(±Infinity, +Infinity) = ±pi/4
   * atan2(NaN, x) = NaN
   * atan2(y, NaN) = NaN
   *
   */
  function atan2(y, x) {
    y = new this(y);
    x = new this(x);
    var r,
      pr = this.precision,
      rm = this.rounding,
      wpr = pr + 4;

    // Either NaN
    if (!y.s || !x.s) {
      r = new this(NaN);

    // Both ±Infinity
    } else if (!y.d && !x.d) {
      r = getPi(this, wpr, 1).times(x.s > 0 ? 0.25 : 0.75);
      r.s = y.s;

    // x is ±Infinity or y is ±0
    } else if (!x.d || y.isZero()) {
      r = x.s < 0 ? getPi(this, pr, rm) : new this(0);
      r.s = y.s;

    // y is ±Infinity or x is ±0
    } else if (!y.d || x.isZero()) {
      r = getPi(this, wpr, 1).times(0.5);
      r.s = y.s;

    // Both non-zero and finite
    } else if (x.s < 0) {
      this.precision = wpr;
      this.rounding = 1;
      r = this.atan(divide(y, x, wpr, 1));
      x = getPi(this, wpr, 1);
      this.precision = pr;
      this.rounding = rm;
      r = y.s < 0 ? r.minus(x) : r.plus(x);
    } else {
      r = this.atan(divide(y, x, wpr, 1));
    }

    return r;
  }


  /*
   * Return a new Decimal whose value is the cube root of `x`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   *
   */
  function cbrt(x) {
    return new this(x).cbrt();
  }


  /*
   * Return a new Decimal whose value is `x` rounded to an integer using `ROUND_CEIL`.
   *
   * x {number|string|Decimal}
   *
   */
  function ceil(x) {
    return finalise(x = new this(x), x.e + 1, 2);
  }


  /*
   * Configure global settings for a Decimal constructor.
   *
   * `obj` is an object with one or more of the following properties,
   *
   *   precision  {number}
   *   rounding   {number}
   *   toExpNeg   {number}
   *   toExpPos   {number}
   *   maxE       {number}
   *   minE       {number}
   *   modulo     {number}
   *   crypto     {boolean|number}
   *   defaults   {true}
   *
   * E.g. Decimal.config({ precision: 20, rounding: 4 })
   *
   */
  function config(obj) {
    if (!obj || typeof obj !== 'object') throw Error(decimalError + 'Object expected');
    var i, p, v,
      useDefaults = obj.defaults === true,
      ps = [
        'precision', 1, MAX_DIGITS,
        'rounding', 0, 8,
        'toExpNeg', -EXP_LIMIT, 0,
        'toExpPos', 0, EXP_LIMIT,
        'maxE', 0, EXP_LIMIT,
        'minE', -EXP_LIMIT, 0,
        'modulo', 0, 9
      ];

    for (i = 0; i < ps.length; i += 3) {
      if (p = ps[i], useDefaults) this[p] = DEFAULTS[p];
      if ((v = obj[p]) !== void 0) {
        if (mathfloor(v) === v && v >= ps[i + 1] && v <= ps[i + 2]) this[p] = v;
        else throw Error(invalidArgument + p + ': ' + v);
      }
    }

    if (p = 'crypto', useDefaults) this[p] = DEFAULTS[p];
    if ((v = obj[p]) !== void 0) {
      if (v === true || v === false || v === 0 || v === 1) {
        if (v) {
          if (typeof crypto != 'undefined' && crypto &&
            (crypto.getRandomValues || crypto.randomBytes)) {
            this[p] = true;
          } else {
            throw Error(cryptoUnavailable);
          }
        } else {
          this[p] = false;
        }
      } else {
        throw Error(invalidArgument + p + ': ' + v);
      }
    }

    return this;
  }


  /*
   * Return a new Decimal whose value is the cosine of `x`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function cos(x) {
    return new this(x).cos();
  }


  /*
   * Return a new Decimal whose value is the hyperbolic cosine of `x`, rounded to precision
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function cosh(x) {
    return new this(x).cosh();
  }


  /*
   * Create and return a Decimal constructor with the same configuration properties as this Decimal
   * constructor.
   *
   */
  function clone(obj) {
    var i, p, ps;

    /*
     * The Decimal constructor and exported function.
     * Return a new Decimal instance.
     *
     * v {number|string|Decimal} A numeric value.
     *
     */
    function Decimal(v) {
      var e, i, t,
        x = this;

      // Decimal called without new.
      if (!(x instanceof Decimal)) return new Decimal(v);

      // Retain a reference to this Decimal constructor, and shadow Decimal.prototype.constructor
      // which points to Object.
      x.constructor = Decimal;

      // Duplicate.
      if (v instanceof Decimal) {
        x.s = v.s;

        if (external) {
          if (!v.d || v.e > Decimal.maxE) {

            // Infinity.
            x.e = NaN;
            x.d = null;
          } else if (v.e < Decimal.minE) {

            // Zero.
            x.e = 0;
            x.d = [0];
          } else {
            x.e = v.e;
            x.d = v.d.slice();
          }
        } else {
          x.e = v.e;
          x.d = v.d ? v.d.slice() : v.d;
        }

        return;
      }

      t = typeof v;

      if (t === 'number') {
        if (v === 0) {
          x.s = 1 / v < 0 ? -1 : 1;
          x.e = 0;
          x.d = [0];
          return;
        }

        if (v < 0) {
          v = -v;
          x.s = -1;
        } else {
          x.s = 1;
        }

        // Fast path for small integers.
        if (v === ~~v && v < 1e7) {
          for (e = 0, i = v; i >= 10; i /= 10) e++;

          if (external) {
            if (e > Decimal.maxE) {
              x.e = NaN;
              x.d = null;
            } else if (e < Decimal.minE) {
              x.e = 0;
              x.d = [0];
            } else {
              x.e = e;
              x.d = [v];
            }
          } else {
            x.e = e;
            x.d = [v];
          }

          return;

        // Infinity, NaN.
        } else if (v * 0 !== 0) {
          if (!v) x.s = NaN;
          x.e = NaN;
          x.d = null;
          return;
        }

        return parseDecimal(x, v.toString());

      } else if (t !== 'string') {
        throw Error(invalidArgument + v);
      }

      // Minus sign?
      if ((i = v.charCodeAt(0)) === 45) {
        v = v.slice(1);
        x.s = -1;
      } else {
        // Plus sign?
        if (i === 43) v = v.slice(1);
        x.s = 1;
      }

      return isDecimal.test(v) ? parseDecimal(x, v) : parseOther(x, v);
    }

    Decimal.prototype = P;

    Decimal.ROUND_UP = 0;
    Decimal.ROUND_DOWN = 1;
    Decimal.ROUND_CEIL = 2;
    Decimal.ROUND_FLOOR = 3;
    Decimal.ROUND_HALF_UP = 4;
    Decimal.ROUND_HALF_DOWN = 5;
    Decimal.ROUND_HALF_EVEN = 6;
    Decimal.ROUND_HALF_CEIL = 7;
    Decimal.ROUND_HALF_FLOOR = 8;
    Decimal.EUCLID = 9;

    Decimal.config = Decimal.set = config;
    Decimal.clone = clone;
    Decimal.isDecimal = isDecimalInstance;

    Decimal.abs = abs;
    Decimal.acos = acos;
    Decimal.acosh = acosh;        // ES6
    Decimal.add = add;
    Decimal.asin = asin;
    Decimal.asinh = asinh;        // ES6
    Decimal.atan = atan;
    Decimal.atanh = atanh;        // ES6
    Decimal.atan2 = atan2;
    Decimal.cbrt = cbrt;          // ES6
    Decimal.ceil = ceil;
    Decimal.cos = cos;
    Decimal.cosh = cosh;          // ES6
    Decimal.div = div;
    Decimal.exp = exp;
    Decimal.floor = floor;
    Decimal.hypot = hypot;        // ES6
    Decimal.ln = ln;
    Decimal.log = log;
    Decimal.log10 = log10;        // ES6
    Decimal.log2 = log2;          // ES6
    Decimal.max = max;
    Decimal.min = min;
    Decimal.mod = mod;
    Decimal.mul = mul;
    Decimal.pow = pow;
    Decimal.random = random;
    Decimal.round = round;
    Decimal.sign = sign;          // ES6
    Decimal.sin = sin;
    Decimal.sinh = sinh;          // ES6
    Decimal.sqrt = sqrt;
    Decimal.sub = sub;
    Decimal.tan = tan;
    Decimal.tanh = tanh;          // ES6
    Decimal.trunc = trunc;        // ES6

    if (obj === void 0) obj = {};
    if (obj) {
      if (obj.defaults !== true) {
        ps = ['precision', 'rounding', 'toExpNeg', 'toExpPos', 'maxE', 'minE', 'modulo', 'crypto'];
        for (i = 0; i < ps.length;) if (!obj.hasOwnProperty(p = ps[i++])) obj[p] = this[p];
      }
    }

    Decimal.config(obj);

    return Decimal;
  }


  /*
   * Return a new Decimal whose value is `x` divided by `y`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   * y {number|string|Decimal}
   *
   */
  function div(x, y) {
    return new this(x).div(y);
  }


  /*
   * Return a new Decimal whose value is the natural exponential of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} The power to which to raise the base of the natural log.
   *
   */
  function exp(x) {
    return new this(x).exp();
  }


  /*
   * Return a new Decimal whose value is `x` round to an integer using `ROUND_FLOOR`.
   *
   * x {number|string|Decimal}
   *
   */
  function floor(x) {
    return finalise(x = new this(x), x.e + 1, 3);
  }


  /*
   * Return a new Decimal whose value is the square root of the sum of the squares of the arguments,
   * rounded to `precision` significant digits using rounding mode `rounding`.
   *
   * hypot(a, b, ...) = sqrt(a^2 + b^2 + ...)
   *
   * arguments {number|string|Decimal}
   *
   */
  function hypot() {
    var i, n,
      t = new this(0);

    external = false;

    for (i = 0; i < arguments.length;) {
      n = new this(arguments[i++]);
      if (!n.d) {
        if (n.s) {
          external = true;
          return new this(1 / 0);
        }
        t = n;
      } else if (t.d) {
        t = t.plus(n.times(n));
      }
    }

    external = true;

    return t.sqrt();
  }


  /*
   * Return true if object is a Decimal instance (where Decimal is any Decimal constructor),
   * otherwise return false.
   *
   */
  function isDecimalInstance(obj) {
    return obj instanceof Decimal || obj && obj.name === '[object Decimal]' || false;
  }


  /*
   * Return a new Decimal whose value is the natural logarithm of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   *
   */
  function ln(x) {
    return new this(x).ln();
  }


  /*
   * Return a new Decimal whose value is the log of `x` to the base `y`, or to base 10 if no base
   * is specified, rounded to `precision` significant digits using rounding mode `rounding`.
   *
   * log[y](x)
   *
   * x {number|string|Decimal} The argument of the logarithm.
   * y {number|string|Decimal} The base of the logarithm.
   *
   */
  function log(x, y) {
    return new this(x).log(y);
  }


  /*
   * Return a new Decimal whose value is the base 2 logarithm of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   *
   */
  function log2(x) {
    return new this(x).log(2);
  }


  /*
   * Return a new Decimal whose value is the base 10 logarithm of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   *
   */
  function log10(x) {
    return new this(x).log(10);
  }


  /*
   * Return a new Decimal whose value is the maximum of the arguments.
   *
   * arguments {number|string|Decimal}
   *
   */
  function max() {
    return maxOrMin(this, arguments, 'lt');
  }


  /*
   * Return a new Decimal whose value is the minimum of the arguments.
   *
   * arguments {number|string|Decimal}
   *
   */
  function min() {
    return maxOrMin(this, arguments, 'gt');
  }


  /*
   * Return a new Decimal whose value is `x` modulo `y`, rounded to `precision` significant digits
   * using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   * y {number|string|Decimal}
   *
   */
  function mod(x, y) {
    return new this(x).mod(y);
  }


  /*
   * Return a new Decimal whose value is `x` multiplied by `y`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   * y {number|string|Decimal}
   *
   */
  function mul(x, y) {
    return new this(x).mul(y);
  }


  /*
   * Return a new Decimal whose value is `x` raised to the power `y`, rounded to precision
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} The base.
   * y {number|string|Decimal} The exponent.
   *
   */
  function pow(x, y) {
    return new this(x).pow(y);
  }


  /*
   * Returns a new Decimal with a random value equal to or greater than 0 and less than 1, and with
   * `sd`, or `Decimal.precision` if `sd` is omitted, significant digits (or less if trailing zeros
   * are produced).
   *
   * [sd] {number} Significant digits. Integer, 0 to MAX_DIGITS inclusive.
   *
   */
  function random(sd) {
    var d, e, k, n,
      i = 0,
      r = new this(1),
      rd = [];

    if (sd === void 0) sd = this.precision;
    else checkInt32(sd, 1, MAX_DIGITS);

    k = Math.ceil(sd / LOG_BASE);

    if (!this.crypto) {
      for (; i < k;) rd[i++] = Math.random() * 1e7 | 0;

    // Browsers supporting crypto.getRandomValues.
    } else if (crypto.getRandomValues) {
      d = crypto.getRandomValues(new Uint32Array(k));

      for (; i < k;) {
        n = d[i];

        // 0 <= n < 4294967296
        // Probability n >= 4.29e9, is 4967296 / 4294967296 = 0.00116 (1 in 865).
        if (n >= 4.29e9) {
          d[i] = crypto.getRandomValues(new Uint32Array(1))[0];
        } else {

          // 0 <= n <= 4289999999
          // 0 <= (n % 1e7) <= 9999999
          rd[i++] = n % 1e7;
        }
      }

    // Node.js supporting crypto.randomBytes.
    } else if (crypto.randomBytes) {

      // buffer
      d = crypto.randomBytes(k *= 4);

      for (; i < k;) {

        // 0 <= n < 2147483648
        n = d[i] + (d[i + 1] << 8) + (d[i + 2] << 16) + ((d[i + 3] & 0x7f) << 24);

        // Probability n >= 2.14e9, is 7483648 / 2147483648 = 0.0035 (1 in 286).
        if (n >= 2.14e9) {
          crypto.randomBytes(4).copy(d, i);
        } else {

          // 0 <= n <= 2139999999
          // 0 <= (n % 1e7) <= 9999999
          rd.push(n % 1e7);
          i += 4;
        }
      }

      i = k / 4;
    } else {
      throw Error(cryptoUnavailable);
    }

    k = rd[--i];
    sd %= LOG_BASE;

    // Convert trailing digits to zeros according to sd.
    if (k && sd) {
      n = mathpow(10, LOG_BASE - sd);
      rd[i] = (k / n | 0) * n;
    }

    // Remove trailing words which are zero.
    for (; rd[i] === 0; i--) rd.pop();

    // Zero?
    if (i < 0) {
      e = 0;
      rd = [0];
    } else {
      e = -1;

      // Remove leading words which are zero and adjust exponent accordingly.
      for (; rd[0] === 0; e -= LOG_BASE) rd.shift();

      // Count the digits of the first word of rd to determine leading zeros.
      for (k = 1, n = rd[0]; n >= 10; n /= 10) k++;

      // Adjust the exponent for leading zeros of the first word of rd.
      if (k < LOG_BASE) e -= LOG_BASE - k;
    }

    r.e = e;
    r.d = rd;

    return r;
  }


  /*
   * Return a new Decimal whose value is `x` rounded to an integer using rounding mode `rounding`.
   *
   * To emulate `Math.round`, set rounding to 7 (ROUND_HALF_CEIL).
   *
   * x {number|string|Decimal}
   *
   */
  function round(x) {
    return finalise(x = new this(x), x.e + 1, this.rounding);
  }


  /*
   * Return
   *   1    if x > 0,
   *  -1    if x < 0,
   *   0    if x is 0,
   *  -0    if x is -0,
   *   NaN  otherwise
   *
   * x {number|string|Decimal}
   *
   */
  function sign(x) {
    x = new this(x);
    return x.d ? (x.d[0] ? x.s : 0 * x.s) : x.s || NaN;
  }


  /*
   * Return a new Decimal whose value is the sine of `x`, rounded to `precision` significant digits
   * using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function sin(x) {
    return new this(x).sin();
  }


  /*
   * Return a new Decimal whose value is the hyperbolic sine of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function sinh(x) {
    return new this(x).sinh();
  }


  /*
   * Return a new Decimal whose value is the square root of `x`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   *
   */
  function sqrt(x) {
    return new this(x).sqrt();
  }


  /*
   * Return a new Decimal whose value is `x` minus `y`, rounded to `precision` significant digits
   * using rounding mode `rounding`.
   *
   * x {number|string|Decimal}
   * y {number|string|Decimal}
   *
   */
  function sub(x, y) {
    return new this(x).sub(y);
  }


  /*
   * Return a new Decimal whose value is the tangent of `x`, rounded to `precision` significant
   * digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function tan(x) {
    return new this(x).tan();
  }


  /*
   * Return a new Decimal whose value is the hyperbolic tangent of `x`, rounded to `precision`
   * significant digits using rounding mode `rounding`.
   *
   * x {number|string|Decimal} A value in radians.
   *
   */
  function tanh(x) {
    return new this(x).tanh();
  }


  /*
   * Return a new Decimal whose value is `x` truncated to an integer.
   *
   * x {number|string|Decimal}
   *
   */
  function trunc(x) {
    return finalise(x = new this(x), x.e + 1, 1);
  }


  // Create and configure initial Decimal constructor.
  Decimal = clone(DEFAULTS);

  Decimal['default'] = Decimal.Decimal = Decimal;

  // Create the internal constants from their string values.
  LN10 = new Decimal(LN10);
  PI = new Decimal(PI);


  // Export.


  // AMD.
  if (true) {
    !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
      return Decimal;
    }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

  // Node and other environments that support module.exports.
  } else {}
})(this);


/***/ }),

/***/ "./node_modules/dommatrix/dist/dommatrix.js":
/*!**************************************************!*\
  !*** ./node_modules/dommatrix/dist/dommatrix.js ***!
  \**************************************************/
/***/ (function(module) {

/*!
* DOMMatrix v1.0.3 (https://thednp.github.io/dommatrix/)
* Copyright 2022 © thednp
* Licensed under MIT (https://github.com/thednp/DOMMatrix/blob/master/LICENSE)
*/
(function (global, factory) {
   true ? module.exports = factory() :
  0;
})(this, (function () { 'use strict';

  // DOMMatrix Static methods
  // * `fromArray` is a more simple implementation, should also accept Float[32/64]Array;
  // * `fromMatrix` load values from another CSSMatrix/DOMMatrix instance or JSON object;
  // * `fromString` parses and loads values from any valid CSS transform string (TransformList).

  /**
   * Creates a new mutable `CSSMatrix` instance given an array of 16/6 floating point values.
   * This static method invalidates arrays that contain non-number elements.
   *
   * If the array has six values, the result is a 2D matrix; if the array has 16 values,
   * the result is a 3D matrix. Otherwise, a TypeError exception is thrown.
   *
   * @param {CSSM.matrix | CSSM.matrix3d} array an `Array` to feed values from.
   * @return {CSSMatrix} the resulted matrix.
   */
  function fromArray(array) {
    var m = new CSSMatrix();
    var a = Array.from(array);

    if (!a.every(function (n) { return !Number.isNaN(n); })) {
      throw TypeError(("CSSMatrix: \"" + array + "\" must only have numbers."));
    }
    if (a.length === 16) {
      var m11 = a[0];
      var m12 = a[1];
      var m13 = a[2];
      var m14 = a[3];
      var m21 = a[4];
      var m22 = a[5];
      var m23 = a[6];
      var m24 = a[7];
      var m31 = a[8];
      var m32 = a[9];
      var m33 = a[10];
      var m34 = a[11];
      var m41 = a[12];
      var m42 = a[13];
      var m43 = a[14];
      var m44 = a[15];

      m.m11 = m11;
      m.a = m11;

      m.m21 = m21;
      m.c = m21;

      m.m31 = m31;

      m.m41 = m41;
      m.e = m41;

      m.m12 = m12;
      m.b = m12;

      m.m22 = m22;
      m.d = m22;

      m.m32 = m32;

      m.m42 = m42;
      m.f = m42;

      m.m13 = m13;
      m.m23 = m23;
      m.m33 = m33;
      m.m43 = m43;
      m.m14 = m14;
      m.m24 = m24;
      m.m34 = m34;
      m.m44 = m44;
    } else if (a.length === 6) {
      var M11 = a[0];
      var M12 = a[1];
      var M21 = a[2];
      var M22 = a[3];
      var M41 = a[4];
      var M42 = a[5];

      m.m11 = M11;
      m.a = M11;

      m.m12 = M12;
      m.b = M12;

      m.m21 = M21;
      m.c = M21;

      m.m22 = M22;
      m.d = M22;

      m.m41 = M41;
      m.e = M41;

      m.m42 = M42;
      m.f = M42;
    } else {
      throw new TypeError('CSSMatrix: expecting an Array of 6/16 values.');
    }
    return m;
  }

  /**
   * Creates a new mutable `CSSMatrix` instance given an existing matrix or a
   * `DOMMatrix` instance which provides the values for its properties.
   *
   * @param {CSSMatrix | DOMMatrix | CSSM.JSONMatrix} m the source matrix to feed values from.
   * @return {CSSMatrix} the resulted matrix.
   */
  function fromMatrix(m) {
    var keys = Object.keys(new CSSMatrix());
    if (typeof m === 'object' && keys.every(function (k) { return k in m; })) {
      return fromArray(
        [m.m11, m.m12, m.m13, m.m14,
          m.m21, m.m22, m.m23, m.m24,
          m.m31, m.m32, m.m33, m.m34,
          m.m41, m.m42, m.m43, m.m44]
      );
    }
    throw TypeError(("CSSMatrix: \"" + (JSON.stringify(m)) + "\" is not a DOMMatrix / CSSMatrix / JSON compatible object."));
  }

  /**
   * Creates a new mutable `CSSMatrix` given any valid CSS transform string,
   * or what we call `TransformList`:
   *
   * * `matrix(a, b, c, d, e, f)` - valid matrix() transform function
   * * `matrix3d(m11, m12, m13, ...m44)` - valid matrix3d() transform function
   * * `translate(tx, ty) rotateX(alpha)` - any valid transform function(s)
   *
   * @copyright thednp © 2021
   *
   * @param {string} source valid CSS transform string syntax.
   * @return {CSSMatrix} the resulted matrix.
   */
  function fromString(source) {
    if (typeof source !== 'string') {
      throw TypeError(("CSSMatrix: \"" + source + "\" is not a string."));
    }
    var str = String(source).replace(/\s/g, '');
    var m = new CSSMatrix();
    var invalidStringError = "CSSMatrix: invalid transform string \"" + source + "\"";

    // const px = ['perspective'];
    // const length = ['translate', 'translate3d', 'translateX', 'translateY', 'translateZ'];
    // const deg = ['rotate', 'rotate3d', 'rotateX', 'rotateY', 'rotateZ', 'skew', 'skewX', 'skewY'];
    // const abs = ['scale', 'scale3d', 'matrix', 'matrix3d'];
    // const transformFunctions = px.concat(length, deg, abs);

    str.split(')').filter(function (f) { return f; }).forEach(function (tf) {
      var ref = tf.split('(');
      var prop = ref[0];
      var value = ref[1];

      // invalidate empty string
      if (!value) { throw TypeError(invalidStringError); }

      var components = value.split(',')
        .map(function (n) { return (n.includes('rad') ? parseFloat(n) * (180 / Math.PI) : parseFloat(n)); });

      var x = components[0];
      var y = components[1];
      var z = components[2];
      var a = components[3];
      var xyz = [x, y, z];
      var xyza = [x, y, z, a];

      // single number value expected
      if (prop === 'perspective' && x && [y, z].every(function (n) { return n === undefined; })) {
        m.m34 = -1 / x;
      // 6/16 number values expected
      } else if (prop.includes('matrix') && [6, 16].includes(components.length)
        && components.every(function (n) { return !Number.isNaN(+n); })) {
        var values = components.map(function (n) { return (Math.abs(n) < 1e-6 ? 0 : n); });
        // @ts-ignore -- conditions should suffice
        m = m.multiply(fromArray(values));
      // 3 values expected
      } else if (prop === 'translate3d' && xyz.every(function (n) { return !Number.isNaN(+n); })) {
        m = m.translate(x, y, z);
      // single/double number value(s) expected
      } else if (prop === 'translate' && x && z === undefined) {
        m = m.translate(x, y || 0, 0);
      // all 4 values expected
      } else if (prop === 'rotate3d' && xyza.every(function (n) { return !Number.isNaN(+n); }) && a) {
        m = m.rotateAxisAngle(x, y, z, a);
      // single value expected
      } else if (prop === 'rotate' && x && [y, z].every(function (n) { return n === undefined; })) {
        m = m.rotate(0, 0, x);
      // 3 values expected
      } else if (prop === 'scale3d' && xyz.every(function (n) { return !Number.isNaN(+n); }) && xyz.some(function (n) { return n !== 1; })) {
        m = m.scale(x, y, z);
      // single value expected
      } else if (prop === 'scale' && !Number.isNaN(x) && x !== 1 && z === undefined) {
        var nosy = Number.isNaN(+y);
        var sy = nosy ? x : y;
        m = m.scale(x, sy, 1);
      // single/double value expected
      } else if (prop === 'skew' && (x || (!Number.isNaN(x) && y)) && z === undefined) {
        m = m.skew(x, y || 0);
      } else if (/[XYZ]/.test(prop) && x && [y, z].every(function (n) { return n === undefined; }) // a single value expected
        && ['translate', 'rotate', 'scale', 'skew'].some(function (p) { return prop.includes(p); })) {
        if (['skewX', 'skewY'].includes(prop)) {
          // @ts-ignore unfortunately
          m = m[prop](x);
        } else {
          var fn = prop.replace(/[XYZ]/, '');
          var axis = prop.replace(fn, '');
          var idx = ['X', 'Y', 'Z'].indexOf(axis);
          var def = fn === 'scale' ? 1 : 0;
          var axeValues = [
            idx === 0 ? x : def,
            idx === 1 ? x : def,
            idx === 2 ? x : def];
          // @ts-ignore unfortunately
          m = m[fn].apply(m, axeValues);
        }
      } else {
        throw TypeError(invalidStringError);
      }
    });

    return m;
  }

  /**
   * Returns an *Array* containing elements which comprise the matrix.
   * The method can return either the 16 elements or the 6 elements
   * depending on the value of the `is2D` parameter.
   *
   * @param {CSSMatrix | DOMMatrix | CSSM.JSONMatrix} m the source matrix to feed values from.
   * @param {boolean=} is2D *Array* representation of the matrix
   * @return {CSSM.matrix | CSSM.matrix3d} an *Array* representation of the matrix
   */
  function toArray(m, is2D) {
    if (is2D) {
      return [m.a, m.b, m.c, m.d, m.e, m.f];
    }
    return [m.m11, m.m12, m.m13, m.m14,
      m.m21, m.m22, m.m23, m.m24,
      m.m31, m.m32, m.m33, m.m34,
      m.m41, m.m42, m.m43, m.m44];
  }

  // Transform Functions
  // https://www.w3.org/TR/css-transforms-1/#transform-functions

  /**
   * Creates a new `CSSMatrix` for the translation matrix and returns it.
   * This method is equivalent to the CSS `translate3d()` function.
   *
   * https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/translate3d
   *
   * @param {number} x the `x-axis` position.
   * @param {number} y the `y-axis` position.
   * @param {number} z the `z-axis` position.
   * @return {CSSMatrix} the resulted matrix.
   */
  function Translate(x, y, z) {
    var m = new CSSMatrix();
    m.m41 = x;
    m.e = x;
    m.m42 = y;
    m.f = y;
    m.m43 = z;
    return m;
  }

  /**
   * Creates a new `CSSMatrix` for the rotation matrix and returns it.
   *
   * http://en.wikipedia.org/wiki/Rotation_matrix
   *
   * @param {number} rx the `x-axis` rotation.
   * @param {number} ry the `y-axis` rotation.
   * @param {number} rz the `z-axis` rotation.
   * @return {CSSMatrix} the resulted matrix.
   */
  function Rotate(rx, ry, rz) {
    var m = new CSSMatrix();
    var degToRad = Math.PI / 180;
    var radX = rx * degToRad;
    var radY = ry * degToRad;
    var radZ = rz * degToRad;

    // minus sin() because of right-handed system
    var cosx = Math.cos(radX);
    var sinx = -Math.sin(radX);
    var cosy = Math.cos(radY);
    var siny = -Math.sin(radY);
    var cosz = Math.cos(radZ);
    var sinz = -Math.sin(radZ);

    var m11 = cosy * cosz;
    var m12 = -cosy * sinz;

    m.m11 = m11;
    m.a = m11;

    m.m12 = m12;
    m.b = m12;

    m.m13 = siny;

    var m21 = sinx * siny * cosz + cosx * sinz;
    m.m21 = m21;
    m.c = m21;

    var m22 = cosx * cosz - sinx * siny * sinz;
    m.m22 = m22;
    m.d = m22;

    m.m23 = -sinx * cosy;

    m.m31 = sinx * sinz - cosx * siny * cosz;
    m.m32 = sinx * cosz + cosx * siny * sinz;
    m.m33 = cosx * cosy;

    return m;
  }

  /**
   * Creates a new `CSSMatrix` for the rotation matrix and returns it.
   * This method is equivalent to the CSS `rotate3d()` function.
   *
   * https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/rotate3d
   *
   * @param {number} x the `x-axis` vector length.
   * @param {number} y the `y-axis` vector length.
   * @param {number} z the `z-axis` vector length.
   * @param {number} alpha the value in degrees of the rotation.
   * @return {CSSMatrix} the resulted matrix.
   */
  function RotateAxisAngle(x, y, z, alpha) {
    var m = new CSSMatrix();
    var length = Math.sqrt(x * x + y * y + z * z);

    if (length === 0) {
      // bad vector length, return identity
      return m;
    }

    var X = x / length;
    var Y = y / length;
    var Z = z / length;

    var angle = alpha * (Math.PI / 360);
    var sinA = Math.sin(angle);
    var cosA = Math.cos(angle);
    var sinA2 = sinA * sinA;
    var x2 = X * X;
    var y2 = Y * Y;
    var z2 = Z * Z;

    var m11 = 1 - 2 * (y2 + z2) * sinA2;
    m.m11 = m11;
    m.a = m11;

    var m12 = 2 * (X * Y * sinA2 + Z * sinA * cosA);
    m.m12 = m12;
    m.b = m12;

    m.m13 = 2 * (X * Z * sinA2 - Y * sinA * cosA);

    var m21 = 2 * (Y * X * sinA2 - Z * sinA * cosA);
    m.m21 = m21;
    m.c = m21;

    var m22 = 1 - 2 * (z2 + x2) * sinA2;
    m.m22 = m22;
    m.d = m22;

    m.m23 = 2 * (Y * Z * sinA2 + X * sinA * cosA);
    m.m31 = 2 * (Z * X * sinA2 + Y * sinA * cosA);
    m.m32 = 2 * (Z * Y * sinA2 - X * sinA * cosA);
    m.m33 = 1 - 2 * (x2 + y2) * sinA2;

    return m;
  }

  /**
   * Creates a new `CSSMatrix` for the scale matrix and returns it.
   * This method is equivalent to the CSS `scale3d()` function, except it doesn't
   * accept {x, y, z} transform origin parameters.
   *
   * https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/scale3d
   *
   * @param {number} x the `x-axis` scale.
   * @param {number} y the `y-axis` scale.
   * @param {number} z the `z-axis` scale.
   * @return {CSSMatrix} the resulted matrix.
   */
  function Scale(x, y, z) {
    var m = new CSSMatrix();
    m.m11 = x;
    m.a = x;

    m.m22 = y;
    m.d = y;

    m.m33 = z;
    return m;
  }

  /**
   * Creates a new `CSSMatrix` for the shear of both the `x-axis` and`y-axis`
   * matrix and returns it. This method is equivalent to the CSS `skew()` function.
   *
   * https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/skew
   *
   * @param {number} angleX the X-angle in degrees.
   * @param {number} angleY the Y-angle in degrees.
   * @return {CSSMatrix} the resulted matrix.
   */
  function Skew(angleX, angleY) {
    var m = new CSSMatrix();
    if (angleX) {
      var radX = (angleX * Math.PI) / 180;
      var tX = Math.tan(radX);
      m.m21 = tX;
      m.c = tX;
    }
    if (angleY) {
      var radY = (angleY * Math.PI) / 180;
      var tY = Math.tan(radY);
      m.m12 = tY;
      m.b = tY;
    }
    return m;
  }

  /**
   * Creates a new `CSSMatrix` for the shear of the `x-axis` rotation matrix and
   * returns it. This method is equivalent to the CSS `skewX()` function.
   *
   * https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/skewX
   *
   * @param {number} angle the angle in degrees.
   * @return {CSSMatrix} the resulted matrix.
   */
  function SkewX(angle) {
    return Skew(angle, 0);
  }

  /**
   * Creates a new `CSSMatrix` for the shear of the `y-axis` rotation matrix and
   * returns it. This method is equivalent to the CSS `skewY()` function.
   *
   * https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function/skewY
   *
   * @param {number} angle the angle in degrees.
   * @return {CSSMatrix} the resulted matrix.
   */
  function SkewY(angle) {
    return Skew(0, angle);
  }

  /**
   * Creates a new `CSSMatrix` resulted from the multiplication of two matrixes
   * and returns it. Both matrixes are not changed.
   *
   * @param {CSSMatrix | DOMMatrix | CSSM.JSONMatrix} m1 the first matrix.
   * @param {CSSMatrix | DOMMatrix | CSSM.JSONMatrix} m2 the second matrix.
   * @return {CSSMatrix} the resulted matrix.
   */
  function Multiply(m1, m2) {
    var m11 = m2.m11 * m1.m11 + m2.m12 * m1.m21 + m2.m13 * m1.m31 + m2.m14 * m1.m41;
    var m12 = m2.m11 * m1.m12 + m2.m12 * m1.m22 + m2.m13 * m1.m32 + m2.m14 * m1.m42;
    var m13 = m2.m11 * m1.m13 + m2.m12 * m1.m23 + m2.m13 * m1.m33 + m2.m14 * m1.m43;
    var m14 = m2.m11 * m1.m14 + m2.m12 * m1.m24 + m2.m13 * m1.m34 + m2.m14 * m1.m44;

    var m21 = m2.m21 * m1.m11 + m2.m22 * m1.m21 + m2.m23 * m1.m31 + m2.m24 * m1.m41;
    var m22 = m2.m21 * m1.m12 + m2.m22 * m1.m22 + m2.m23 * m1.m32 + m2.m24 * m1.m42;
    var m23 = m2.m21 * m1.m13 + m2.m22 * m1.m23 + m2.m23 * m1.m33 + m2.m24 * m1.m43;
    var m24 = m2.m21 * m1.m14 + m2.m22 * m1.m24 + m2.m23 * m1.m34 + m2.m24 * m1.m44;

    var m31 = m2.m31 * m1.m11 + m2.m32 * m1.m21 + m2.m33 * m1.m31 + m2.m34 * m1.m41;
    var m32 = m2.m31 * m1.m12 + m2.m32 * m1.m22 + m2.m33 * m1.m32 + m2.m34 * m1.m42;
    var m33 = m2.m31 * m1.m13 + m2.m32 * m1.m23 + m2.m33 * m1.m33 + m2.m34 * m1.m43;
    var m34 = m2.m31 * m1.m14 + m2.m32 * m1.m24 + m2.m33 * m1.m34 + m2.m34 * m1.m44;

    var m41 = m2.m41 * m1.m11 + m2.m42 * m1.m21 + m2.m43 * m1.m31 + m2.m44 * m1.m41;
    var m42 = m2.m41 * m1.m12 + m2.m42 * m1.m22 + m2.m43 * m1.m32 + m2.m44 * m1.m42;
    var m43 = m2.m41 * m1.m13 + m2.m42 * m1.m23 + m2.m43 * m1.m33 + m2.m44 * m1.m43;
    var m44 = m2.m41 * m1.m14 + m2.m42 * m1.m24 + m2.m43 * m1.m34 + m2.m44 * m1.m44;

    return fromArray(
      [m11, m12, m13, m14,
        m21, m22, m23, m24,
        m31, m32, m33, m34,
        m41, m42, m43, m44]
    );
  }

  /**
   * Creates and returns a new `DOMMatrix` compatible instance
   * with equivalent instance.
   * @class CSSMatrix
   *
   * @author thednp <https://github.com/thednp/DOMMatrix/>
   * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMMatrix
   */

  var CSSMatrix = function CSSMatrix() {
    var args = [], len = arguments.length;
    while ( len-- ) args[ len ] = arguments[ len ];

    var m = this;
    // array 6
    m.a = 1; m.b = 0;
    m.c = 0; m.d = 1;
    m.e = 0; m.f = 0;
    // array 16
    m.m11 = 1; m.m12 = 0; m.m13 = 0; m.m14 = 0;
    m.m21 = 0; m.m22 = 1; m.m23 = 0; m.m24 = 0;
    m.m31 = 0; m.m32 = 0; m.m33 = 1; m.m34 = 0;
    m.m41 = 0; m.m42 = 0; m.m43 = 0; m.m44 = 1;

    if (args.length) {
      var ARGS = [16, 6].some(function (l) { return l === args.length; }) ? args : args[0];

      return m.setMatrixValue(ARGS);
    }
    return m;
  };

  var prototypeAccessors = { isIdentity: { configurable: true },is2D: { configurable: true } };

  /**
   * A `Boolean` whose value is `true` if the matrix is the identity matrix. The identity
   * matrix is one in which every value is 0 except those on the main diagonal from top-left
   * to bottom-right corner (in other words, where the offsets in each direction are equal).
   *
   * @return {boolean} the current property value
   */
  prototypeAccessors.isIdentity.get = function () {
    var m = this;
    return (m.m11 === 1 && m.m12 === 0 && m.m13 === 0 && m.m14 === 0
            && m.m21 === 0 && m.m22 === 1 && m.m23 === 0 && m.m24 === 0
            && m.m31 === 0 && m.m32 === 0 && m.m33 === 1 && m.m34 === 0
            && m.m41 === 0 && m.m42 === 0 && m.m43 === 0 && m.m44 === 1);
  };

  /**
   * A `Boolean` flag whose value is `true` if the matrix was initialized as a 2D matrix
   * and `false` if the matrix is 3D.
   *
   * @return {boolean} the current property value
   */
  prototypeAccessors.is2D.get = function () {
    var m = this;
    return (m.m31 === 0 && m.m32 === 0 && m.m33 === 1 && m.m34 === 0 && m.m43 === 0 && m.m44 === 1);
  };

  /**
   * The `setMatrixValue` method replaces the existing matrix with one computed
   * in the browser. EG: `matrix(1,0.25,-0.25,1,0,0)`
   *
   * The method accepts any *Array* values, the result of
   * `DOMMatrix` instance method `toFloat64Array()` / `toFloat32Array()` calls
   *or `CSSMatrix` instance method `toArray()`.
   *
   * This method expects valid *matrix()* / *matrix3d()* string values, as well
   * as other transform functions like *translateX(10px)*.
   *
   * @param {string | CSSM.matrix | CSSM.matrix3d | CSSMatrix | DOMMatrix | CSSM.JSONMatrix} source
   * @return {CSSMatrix} the matrix instance
   */
  CSSMatrix.prototype.setMatrixValue = function setMatrixValue (source) {
    var m = this;

    // CSS transform string source - TransformList first
    if (typeof source === 'string' && source.length && source !== 'none') {
      return fromString(source);
    }
    // [Arguments list | Array] come second
    if ([Array, Float64Array, Float32Array].some(function (a) { return source instanceof a; })) {
      // @ts-ignore
      return fromArray(source);
    }
    // new CSSMatrix(CSSMatrix | DOMMatrix | JSON) last
    if ([CSSMatrix, DOMMatrix, Object].some(function (a) { return source instanceof a; })) {
      // @ts-ignore
      return fromMatrix(source);
    }

    return m;
  };

  /**
   * Returns a *Float32Array* containing elements which comprise the matrix.
   * The method can return either the 16 elements or the 6 elements
   * depending on the value of the `is2D` parameter.
   *
   * @param {boolean=} is2D *Array* representation of the matrix
   * @return {Float32Array} an *Array* representation of the matrix
   */
  CSSMatrix.prototype.toFloat32Array = function toFloat32Array (is2D) {
    return Float32Array.from(toArray(this, is2D));
  };

  /**
   * Returns a *Float64Array* containing elements which comprise the matrix.
   * The method can return either the 16 elements or the 6 elements
   * depending on the value of the `is2D` parameter.
   *
   * @param {boolean=} is2D *Array* representation of the matrix
   * @return {Float64Array} an *Array* representation of the matrix
   */
  CSSMatrix.prototype.toFloat64Array = function toFloat64Array (is2D) {
    return Float64Array.from(toArray(this, is2D));
  };

  /**
   * Creates and returns a string representation of the matrix in `CSS` matrix syntax,
   * using the appropriate `CSS` matrix notation.
   *
   * matrix3d *matrix3d(m11, m12, m13, m14, m21, ...)*
   * matrix *matrix(a, b, c, d, e, f)*
   *
   * @return {string} a string representation of the matrix
   */
  CSSMatrix.prototype.toString = function toString () {
    var m = this;
    var is2D = m.is2D;
    var values = m.toFloat64Array(is2D).join(', ');
    var type = is2D ? 'matrix' : 'matrix3d';
    return (type + "(" + values + ")");
  };

  /**
   * Returns a JSON representation of the `CSSMatrix` instance, a standard *Object*
   * that includes `{a,b,c,d,e,f}` and `{m11,m12,m13,..m44}` properties as well
   * as the `is2D` & `isIdentity` properties.
   *
   * The result can also be used as a second parameter for the `fromMatrix` static method
   * to load values into another matrix instance.
   *
   * @return {CSSM.JSONMatrix} an *Object* with all matrix values.
   */
  CSSMatrix.prototype.toJSON = function toJSON () {
    var m = this;
    var is2D = m.is2D;
      var isIdentity = m.isIdentity;
    return Object.assign({}, m, {is2D: is2D, isIdentity: isIdentity});
  };

  /**
   * The Multiply method returns a new CSSMatrix which is the result of this
   * matrix multiplied by the passed matrix, with the passed matrix to the right.
   * This matrix is not modified.
   *
   * @param {CSSMatrix | DOMMatrix | CSSM.JSONMatrix} m2 CSSMatrix
   * @return {CSSMatrix} The resulted matrix.
   */
  CSSMatrix.prototype.multiply = function multiply (m2) {
    return Multiply(this, m2);
  };

  /**
   * The translate method returns a new matrix which is this matrix post
   * multiplied by a translation matrix containing the passed values. If the z
   * component is undefined, a 0 value is used in its place. This matrix is not
   * modified.
   *
   * @param {number} x X component of the translation value.
   * @param {number=} y Y component of the translation value.
   * @param {number=} z Z component of the translation value.
   * @return {CSSMatrix} The resulted matrix
   */
  CSSMatrix.prototype.translate = function translate (x, y, z) {
    var X = x;
    var Y = y;
    var Z = z;
    if (Y === undefined) { Y = 0; }
    if (Z === undefined) { Z = 0; }
    return Multiply(this, Translate(X, Y, Z));
  };

  /**
   * The scale method returns a new matrix which is this matrix post multiplied by
   * a scale matrix containing the passed values. If the z component is undefined,
   * a 1 value is used in its place. If the y component is undefined, the x
   * component value is used in its place. This matrix is not modified.
   *
   * @param {number} x The X component of the scale value.
   * @param {number=} y The Y component of the scale value.
   * @param {number=} z The Z component of the scale value.
   * @return {CSSMatrix} The resulted matrix
   */
  CSSMatrix.prototype.scale = function scale (x, y, z) {
    var X = x;
    var Y = y;
    var Z = z;
    if (Y === undefined) { Y = x; }
    if (Z === undefined) { Z = 1; } // Z must be 1 if undefined

    return Multiply(this, Scale(X, Y, Z));
  };

  /**
   * The rotate method returns a new matrix which is this matrix post multiplied
   * by each of 3 rotation matrices about the major axes, first X, then Y, then Z.
   * If the y and z components are undefined, the x value is used to rotate the
   * object about the z axis, as though the vector (0,0,x) were passed. All
   * rotation values are in degrees. This matrix is not modified.
   *
   * @param {number} rx The X component of the rotation, or Z if Y and Z are null.
   * @param {number=} ry The (optional) Y component of the rotation value.
   * @param {number=} rz The (optional) Z component of the rotation value.
   * @return {CSSMatrix} The resulted matrix
   */
  CSSMatrix.prototype.rotate = function rotate (rx, ry, rz) {
    var RX = rx;
    var RY = ry || 0;
    var RZ = rz || 0;

    if (typeof rx === 'number' && ry === undefined && rz === undefined) {
      RZ = RX; RX = 0; RY = 0;
    }

    return Multiply(this, Rotate(RX, RY, RZ));
  };

  /**
   * The rotateAxisAngle method returns a new matrix which is this matrix post
   * multiplied by a rotation matrix with the given axis and `angle`. The right-hand
   * rule is used to determine the direction of rotation. All rotation values are
   * in degrees. This matrix is not modified.
   *
   * @param {number} x The X component of the axis vector.
   * @param {number} y The Y component of the axis vector.
   * @param {number} z The Z component of the axis vector.
   * @param {number} angle The angle of rotation about the axis vector, in degrees.
   * @return {CSSMatrix} The resulted matrix
   */
  CSSMatrix.prototype.rotateAxisAngle = function rotateAxisAngle (x, y, z, angle) {
    if ([x, y, z, angle].some(function (n) { return Number.isNaN(+n); })) {
      throw new TypeError('CSSMatrix: expecting 4 values');
    }
    return Multiply(this, RotateAxisAngle(x, y, z, angle));
  };

  /**
   * Specifies a skew transformation along the `x-axis` by the given angle.
   * This matrix is not modified.
   *
   * @param {number} angle The angle amount in degrees to skew.
   * @return {CSSMatrix} The resulted matrix
   */
  CSSMatrix.prototype.skewX = function skewX (angle) {
    return Multiply(this, SkewX(angle));
  };

  /**
   * Specifies a skew transformation along the `y-axis` by the given angle.
   * This matrix is not modified.
   *
   * @param {number} angle The angle amount in degrees to skew.
   * @return {CSSMatrix} The resulted matrix
   */
  CSSMatrix.prototype.skewY = function skewY (angle) {
    return Multiply(this, SkewY(angle));
  };

  /**
   * Specifies a skew transformation along both the `x-axis` and `y-axis`.
   * This matrix is not modified.
   *
   * @param {number} angleX The X-angle amount in degrees to skew.
   * @param {number} angleY The angle amount in degrees to skew.
   * @return {CSSMatrix} The resulted matrix
   */
  CSSMatrix.prototype.skew = function skew (angleX, angleY) {
    return Multiply(this, Skew(angleX, angleY));
  };

  /**
   * Transforms a specified vector using the matrix, returning a new
   * {x,y,z,w} Tuple *Object* comprising the transformed vector.
   * Neither the matrix nor the original vector are altered.
   *
   * The method is equivalent with `transformPoint()` method
   * of the `DOMMatrix` constructor.
   *
   * @param {CSSM.PointTuple | DOMPoint} t Tuple with `{x,y,z,w}` components
   * @return {CSSM.PointTuple | DOMPoint} the resulting Tuple
   */
  CSSMatrix.prototype.transformPoint = function transformPoint (t) {
    var m = this;

    var x = m.m11 * t.x + m.m21 * t.y + m.m31 * t.z + m.m41 * t.w;
    var y = m.m12 * t.x + m.m22 * t.y + m.m32 * t.z + m.m42 * t.w;
    var z = m.m13 * t.x + m.m23 * t.y + m.m33 * t.z + m.m43 * t.w;
    var w = m.m14 * t.x + m.m24 * t.y + m.m34 * t.z + m.m44 * t.w;

    return t instanceof DOMPoint
      ? new DOMPoint(x, y, z, w)
      : {
        x: x, y: y, z: z, w: w,
      };
  };

  Object.defineProperties( CSSMatrix.prototype, prototypeAccessors );

  // Add Transform Functions to CSSMatrix object
  // without creating a TypeScript namespace.
  Object.assign(CSSMatrix, {
    Translate: Translate,
    Rotate: Rotate,
    RotateAxisAngle: RotateAxisAngle,
    Scale: Scale,
    SkewX: SkewX,
    SkewY: SkewY,
    Skew: Skew,
    Multiply: Multiply,
    fromArray: fromArray,
    fromMatrix: fromMatrix,
    fromString: fromString,
    toArray: toArray,
  });

  var version = "1.0.3";

  /**
   * A global namespace for library version.
   * @type {string}
   */
  var Version = version;

  /** @typedef {import('../types/index')} */

  Object.assign(CSSMatrix, { Version: Version });

  return CSSMatrix;

}));


/***/ }),

/***/ "./node_modules/escape-latex/dist/index.js":
/*!*************************************************!*\
  !*** ./node_modules/escape-latex/dist/index.js ***!
  \*************************************************/
/***/ ((module) => {

"use strict";


// Map the characters to escape to their escaped values. The list is derived
// from http://www.cespedes.org/blog/85/how-to-escape-latex-special-characters

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var defaultEscapes = {
  "{": "\\{",
  "}": "\\}",
  "\\": "\\textbackslash{}",
  "#": "\\#",
  $: "\\$",
  "%": "\\%",
  "&": "\\&",
  "^": "\\textasciicircum{}",
  _: "\\_",
  "~": "\\textasciitilde{}"
};
var formatEscapes = {
  "\u2013": "\\--",
  "\u2014": "\\---",
  " ": "~",
  "\t": "\\qquad{}",
  "\r\n": "\\newline{}",
  "\n": "\\newline{}"
};

var defaultEscapeMapFn = function defaultEscapeMapFn(defaultEscapes, formatEscapes) {
  return _extends({}, defaultEscapes, formatEscapes);
};

/**
 * Escape a string to be used in LaTeX documents.
 * @param {string} str the string to be escaped.
 * @param {boolean} params.preserveFormatting whether formatting escapes should
 *  be performed (default: false).
 * @param {function} params.escapeMapFn the function to modify the escape maps.
 * @return {string} the escaped string, ready to be used in LaTeX.
 */
module.exports = function (str) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$preserveFormatti = _ref.preserveFormatting,
      preserveFormatting = _ref$preserveFormatti === undefined ? false : _ref$preserveFormatti,
      _ref$escapeMapFn = _ref.escapeMapFn,
      escapeMapFn = _ref$escapeMapFn === undefined ? defaultEscapeMapFn : _ref$escapeMapFn;

  var runningStr = String(str);
  var result = "";

  var escapes = escapeMapFn(_extends({}, defaultEscapes), preserveFormatting ? _extends({}, formatEscapes) : {});
  var escapeKeys = Object.keys(escapes); // as it is reused later on

  // Algorithm: Go through the string character by character, if it matches
  // with one of the special characters then we'll replace it with the escaped
  // version.

  var _loop = function _loop() {
    var specialCharFound = false;
    escapeKeys.forEach(function (key, index) {
      if (specialCharFound) {
        return;
      }
      if (runningStr.length >= key.length && runningStr.slice(0, key.length) === key) {
        result += escapes[escapeKeys[index]];
        runningStr = runningStr.slice(key.length, runningStr.length);
        specialCharFound = true;
      }
    });
    if (!specialCharFound) {
      result += runningStr.slice(0, 1);
      runningStr = runningStr.slice(1, runningStr.length);
    }
  };

  while (runningStr) {
    _loop();
  }
  return result;
};

/***/ }),

/***/ "./node_modules/fraction.js/fraction.js":
/*!**********************************************!*\
  !*** ./node_modules/fraction.js/fraction.js ***!
  \**********************************************/
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
 * @license Fraction.js v4.0.12 09/09/2015
 * http://www.xarg.org/2014/03/rational-numbers-in-javascript/
 *
 * Copyright (c) 2015, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/


/**
 *
 * This class offers the possibility to calculate fractions.
 * You can pass a fraction in different formats. Either as array, as double, as string or as an integer.
 *
 * Array/Object form
 * [ 0 => <nominator>, 1 => <denominator> ]
 * [ n => <nominator>, d => <denominator> ]
 *
 * Integer form
 * - Single integer value
 *
 * Double form
 * - Single double value
 *
 * String form
 * 123.456 - a simple double
 * 123/456 - a string fraction
 * 123.'456' - a double with repeating decimal places
 * 123.(456) - synonym
 * 123.45'6' - a double with repeating last place
 * 123.45(6) - synonym
 *
 * Example:
 *
 * var f = new Fraction("9.4'31'");
 * f.mul([-4, 3]).div(4.9);
 *
 */

(function(root) {

  "use strict";

  // Maximum search depth for cyclic rational numbers. 2000 should be more than enough.
  // Example: 1/7 = 0.(142857) has 6 repeating decimal places.
  // If MAX_CYCLE_LEN gets reduced, long cycles will not be detected and toString() only gets the first 10 digits
  var MAX_CYCLE_LEN = 2000;

  // Parsed data to avoid calling "new" all the time
  var P = {
    "s": 1,
    "n": 0,
    "d": 1
  };

  function createError(name) {

    function errorConstructor() {
      var temp = Error.apply(this, arguments);
      temp['name'] = this['name'] = name;
      this['stack'] = temp['stack'];
      this['message'] = temp['message'];
    }

    /**
     * Error constructor
     *
     * @constructor
     */
    function IntermediateInheritor() {}
    IntermediateInheritor.prototype = Error.prototype;
    errorConstructor.prototype = new IntermediateInheritor();

    return errorConstructor;
  }

  var DivisionByZero = Fraction['DivisionByZero'] = createError('DivisionByZero');
  var InvalidParameter = Fraction['InvalidParameter'] = createError('InvalidParameter');

  function assign(n, s) {

    if (isNaN(n = parseInt(n, 10))) {
      throwInvalidParam();
    }
    return n * s;
  }

  function throwInvalidParam() {
    throw new InvalidParameter();
  }

  var parse = function(p1, p2) {

    var n = 0, d = 1, s = 1;
    var v = 0, w = 0, x = 0, y = 1, z = 1;

    var A = 0, B = 1;
    var C = 1, D = 1;

    var N = 10000000;
    var M;

    if (p1 === undefined || p1 === null) {
      /* void */
    } else if (p2 !== undefined) {
      n = p1;
      d = p2;
      s = n * d;
    } else
      switch (typeof p1) {

        case "object":
        {
          if ("d" in p1 && "n" in p1) {
            n = p1["n"];
            d = p1["d"];
            if ("s" in p1)
              n *= p1["s"];
          } else if (0 in p1) {
            n = p1[0];
            if (1 in p1)
              d = p1[1];
          } else {
            throwInvalidParam();
          }
          s = n * d;
          break;
        }
        case "number":
        {
          if (p1 < 0) {
            s = p1;
            p1 = -p1;
          }

          if (p1 % 1 === 0) {
            n = p1;
          } else if (p1 > 0) { // check for != 0, scale would become NaN (log(0)), which converges really slow

            if (p1 >= 1) {
              z = Math.pow(10, Math.floor(1 + Math.log(p1) / Math.LN10));
              p1 /= z;
            }

            // Using Farey Sequences
            // http://www.johndcook.com/blog/2010/10/20/best-rational-approximation/

            while (B <= N && D <= N) {
              M = (A + C) / (B + D);

              if (p1 === M) {
                if (B + D <= N) {
                  n = A + C;
                  d = B + D;
                } else if (D > B) {
                  n = C;
                  d = D;
                } else {
                  n = A;
                  d = B;
                }
                break;

              } else {

                if (p1 > M) {
                  A += C;
                  B += D;
                } else {
                  C += A;
                  D += B;
                }

                if (B > N) {
                  n = C;
                  d = D;
                } else {
                  n = A;
                  d = B;
                }
              }
            }
            n *= z;
          } else if (isNaN(p1) || isNaN(p2)) {
            d = n = NaN;
          }
          break;
        }
        case "string":
        {
          B = p1.match(/\d+|./g);

          if (B === null)
            throwInvalidParam();

          if (B[A] === '-') {// Check for minus sign at the beginning
            s = -1;
            A++;
          } else if (B[A] === '+') {// Check for plus sign at the beginning
            A++;
          }

          if (B.length === A + 1) { // Check if it's just a simple number "1234"
            w = assign(B[A++], s);
          } else if (B[A + 1] === '.' || B[A] === '.') { // Check if it's a decimal number

            if (B[A] !== '.') { // Handle 0.5 and .5
              v = assign(B[A++], s);
            }
            A++;

            // Check for decimal places
            if (A + 1 === B.length || B[A + 1] === '(' && B[A + 3] === ')' || B[A + 1] === "'" && B[A + 3] === "'") {
              w = assign(B[A], s);
              y = Math.pow(10, B[A].length);
              A++;
            }

            // Check for repeating places
            if (B[A] === '(' && B[A + 2] === ')' || B[A] === "'" && B[A + 2] === "'") {
              x = assign(B[A + 1], s);
              z = Math.pow(10, B[A + 1].length) - 1;
              A += 3;
            }

          } else if (B[A + 1] === '/' || B[A + 1] === ':') { // Check for a simple fraction "123/456" or "123:456"
            w = assign(B[A], s);
            y = assign(B[A + 2], 1);
            A += 3;
          } else if (B[A + 3] === '/' && B[A + 1] === ' ') { // Check for a complex fraction "123 1/2"
            v = assign(B[A], s);
            w = assign(B[A + 2], s);
            y = assign(B[A + 4], 1);
            A += 5;
          }

          if (B.length <= A) { // Check for more tokens on the stack
            d = y * z;
            s = /* void */
                    n = x + d * v + z * w;
            break;
          }

          /* Fall through on error */
        }
        default:
          throwInvalidParam();
      }

    if (d === 0) {
      throw new DivisionByZero();
    }

    P["s"] = s < 0 ? -1 : 1;
    P["n"] = Math.abs(n);
    P["d"] = Math.abs(d);
  };

  function modpow(b, e, m) {

    var r = 1;
    for (; e > 0; b = (b * b) % m, e >>= 1) {

      if (e & 1) {
        r = (r * b) % m;
      }
    }
    return r;
  }


  function cycleLen(n, d) {

    for (; d % 2 === 0;
            d /= 2) {
    }

    for (; d % 5 === 0;
            d /= 5) {
    }

    if (d === 1) // Catch non-cyclic numbers
      return 0;

    // If we would like to compute really large numbers quicker, we could make use of Fermat's little theorem:
    // 10^(d-1) % d == 1
    // However, we don't need such large numbers and MAX_CYCLE_LEN should be the capstone,
    // as we want to translate the numbers to strings.

    var rem = 10 % d;
    var t = 1;

    for (; rem !== 1; t++) {
      rem = rem * 10 % d;

      if (t > MAX_CYCLE_LEN)
        return 0; // Returning 0 here means that we don't print it as a cyclic number. It's likely that the answer is `d-1`
    }
    return t;
  }


     function cycleStart(n, d, len) {

    var rem1 = 1;
    var rem2 = modpow(10, len, d);

    for (var t = 0; t < 300; t++) { // s < ~log10(Number.MAX_VALUE)
      // Solve 10^s == 10^(s+t) (mod d)

      if (rem1 === rem2)
        return t;

      rem1 = rem1 * 10 % d;
      rem2 = rem2 * 10 % d;
    }
    return 0;
  }

  function gcd(a, b) {

    if (!a)
      return b;
    if (!b)
      return a;

    while (1) {
      a %= b;
      if (!a)
        return b;
      b %= a;
      if (!b)
        return a;
    }
  };

  /**
   * Module constructor
   *
   * @constructor
   * @param {number|Fraction=} a
   * @param {number=} b
   */
  function Fraction(a, b) {

    if (!(this instanceof Fraction)) {
      return new Fraction(a, b);
    }

    parse(a, b);

    if (Fraction['REDUCE']) {
      a = gcd(P["d"], P["n"]); // Abuse a
    } else {
      a = 1;
    }

    this["s"] = P["s"];
    this["n"] = P["n"] / a;
    this["d"] = P["d"] / a;
  }

  /**
   * Boolean global variable to be able to disable automatic reduction of the fraction
   *
   */
  Fraction['REDUCE'] = 1;

  Fraction.prototype = {

    "s": 1,
    "n": 0,
    "d": 1,

    /**
     * Calculates the absolute value
     *
     * Ex: new Fraction(-4).abs() => 4
     **/
    "abs": function() {

      return new Fraction(this["n"], this["d"]);
    },

    /**
     * Inverts the sign of the current fraction
     *
     * Ex: new Fraction(-4).neg() => 4
     **/
    "neg": function() {

      return new Fraction(-this["s"] * this["n"], this["d"]);
    },

    /**
     * Adds two rational numbers
     *
     * Ex: new Fraction({n: 2, d: 3}).add("14.9") => 467 / 30
     **/
    "add": function(a, b) {

      parse(a, b);
      return new Fraction(
              this["s"] * this["n"] * P["d"] + P["s"] * this["d"] * P["n"],
              this["d"] * P["d"]
              );
    },

    /**
     * Subtracts two rational numbers
     *
     * Ex: new Fraction({n: 2, d: 3}).add("14.9") => -427 / 30
     **/
    "sub": function(a, b) {

      parse(a, b);
      return new Fraction(
              this["s"] * this["n"] * P["d"] - P["s"] * this["d"] * P["n"],
              this["d"] * P["d"]
              );
    },

    /**
     * Multiplies two rational numbers
     *
     * Ex: new Fraction("-17.(345)").mul(3) => 5776 / 111
     **/
    "mul": function(a, b) {

      parse(a, b);
      return new Fraction(
              this["s"] * P["s"] * this["n"] * P["n"],
              this["d"] * P["d"]
              );
    },

    /**
     * Divides two rational numbers
     *
     * Ex: new Fraction("-17.(345)").inverse().div(3)
     **/
    "div": function(a, b) {

      parse(a, b);
      return new Fraction(
              this["s"] * P["s"] * this["n"] * P["d"],
              this["d"] * P["n"]
              );
    },

    /**
     * Clones the actual object
     *
     * Ex: new Fraction("-17.(345)").clone()
     **/
    "clone": function() {
      return new Fraction(this);
    },

    /**
     * Calculates the modulo of two rational numbers - a more precise fmod
     *
     * Ex: new Fraction('4.(3)').mod([7, 8]) => (13/3) % (7/8) = (5/6)
     **/
    "mod": function(a, b) {

      if (isNaN(this['n']) || isNaN(this['d'])) {
        return new Fraction(NaN);
      }

      if (a === undefined) {
        return new Fraction(this["s"] * this["n"] % this["d"], 1);
      }

      parse(a, b);
      if (0 === P["n"] && 0 === this["d"]) {
        Fraction(0, 0); // Throw DivisionByZero
      }

      /*
       * First silly attempt, kinda slow
       *
       return that["sub"]({
       "n": num["n"] * Math.floor((this.n / this.d) / (num.n / num.d)),
       "d": num["d"],
       "s": this["s"]
       });*/

      /*
       * New attempt: a1 / b1 = a2 / b2 * q + r
       * => b2 * a1 = a2 * b1 * q + b1 * b2 * r
       * => (b2 * a1 % a2 * b1) / (b1 * b2)
       */
      return new Fraction(
              this["s"] * (P["d"] * this["n"]) % (P["n"] * this["d"]),
              P["d"] * this["d"]
              );
    },

    /**
     * Calculates the fractional gcd of two rational numbers
     *
     * Ex: new Fraction(5,8).gcd(3,7) => 1/56
     */
    "gcd": function(a, b) {

      parse(a, b);

      // gcd(a / b, c / d) = gcd(a, c) / lcm(b, d)

      return new Fraction(gcd(P["n"], this["n"]) * gcd(P["d"], this["d"]), P["d"] * this["d"]);
    },

    /**
     * Calculates the fractional lcm of two rational numbers
     *
     * Ex: new Fraction(5,8).lcm(3,7) => 15
     */
    "lcm": function(a, b) {

      parse(a, b);

      // lcm(a / b, c / d) = lcm(a, c) / gcd(b, d)

      if (P["n"] === 0 && this["n"] === 0) {
        return new Fraction;
      }
      return new Fraction(P["n"] * this["n"], gcd(P["n"], this["n"]) * gcd(P["d"], this["d"]));
    },

    /**
     * Calculates the ceil of a rational number
     *
     * Ex: new Fraction('4.(3)').ceil() => (5 / 1)
     **/
    "ceil": function(places) {

      places = Math.pow(10, places || 0);

      if (isNaN(this["n"]) || isNaN(this["d"])) {
        return new Fraction(NaN);
      }
      return new Fraction(Math.ceil(places * this["s"] * this["n"] / this["d"]), places);
    },

    /**
     * Calculates the floor of a rational number
     *
     * Ex: new Fraction('4.(3)').floor() => (4 / 1)
     **/
    "floor": function(places) {

      places = Math.pow(10, places || 0);

      if (isNaN(this["n"]) || isNaN(this["d"])) {
        return new Fraction(NaN);
      }
      return new Fraction(Math.floor(places * this["s"] * this["n"] / this["d"]), places);
    },

    /**
     * Rounds a rational numbers
     *
     * Ex: new Fraction('4.(3)').round() => (4 / 1)
     **/
    "round": function(places) {

      places = Math.pow(10, places || 0);

      if (isNaN(this["n"]) || isNaN(this["d"])) {
        return new Fraction(NaN);
      }
      return new Fraction(Math.round(places * this["s"] * this["n"] / this["d"]), places);
    },

    /**
     * Gets the inverse of the fraction, means numerator and denumerator are exchanged
     *
     * Ex: new Fraction([-3, 4]).inverse() => -4 / 3
     **/
    "inverse": function() {

      return new Fraction(this["s"] * this["d"], this["n"]);
    },

    /**
     * Calculates the fraction to some integer exponent
     *
     * Ex: new Fraction(-1,2).pow(-3) => -8
     */
    "pow": function(m) {

      if (m < 0) {
        return new Fraction(Math.pow(this['s'] * this["d"], -m), Math.pow(this["n"], -m));
      } else {
        return new Fraction(Math.pow(this['s'] * this["n"], m), Math.pow(this["d"], m));
      }
    },

    /**
     * Check if two rational numbers are the same
     *
     * Ex: new Fraction(19.6).equals([98, 5]);
     **/
    "equals": function(a, b) {

      parse(a, b);
      return this["s"] * this["n"] * P["d"] === P["s"] * P["n"] * this["d"]; // Same as compare() === 0
    },

    /**
     * Check if two rational numbers are the same
     *
     * Ex: new Fraction(19.6).equals([98, 5]);
     **/
    "compare": function(a, b) {

      parse(a, b);
      var t = (this["s"] * this["n"] * P["d"] - P["s"] * P["n"] * this["d"]);
      return (0 < t) - (t < 0);
    },

    "simplify": function(eps) {

      // First naive implementation, needs improvement

      if (isNaN(this['n']) || isNaN(this['d'])) {
        return this;
      }

      var cont = this['abs']()['toContinued']();

      eps = eps || 0.001;

      function rec(a) {
        if (a.length === 1)
          return new Fraction(a[0]);
        return rec(a.slice(1))['inverse']()['add'](a[0]);
      }

      for (var i = 0; i < cont.length; i++) {
        var tmp = rec(cont.slice(0, i + 1));
        if (tmp['sub'](this['abs']())['abs']().valueOf() < eps) {
          return tmp['mul'](this['s']);
        }
      }
      return this;
    },

    /**
     * Check if two rational numbers are divisible
     *
     * Ex: new Fraction(19.6).divisible(1.5);
     */
    "divisible": function(a, b) {

      parse(a, b);
      return !(!(P["n"] * this["d"]) || ((this["n"] * P["d"]) % (P["n"] * this["d"])));
    },

    /**
     * Returns a decimal representation of the fraction
     *
     * Ex: new Fraction("100.'91823'").valueOf() => 100.91823918239183
     **/
    'valueOf': function() {

      return this["s"] * this["n"] / this["d"];
    },

    /**
     * Returns a string-fraction representation of a Fraction object
     *
     * Ex: new Fraction("1.'3'").toFraction() => "4 1/3"
     **/
    'toFraction': function(excludeWhole) {

      var whole, str = "";
      var n = this["n"];
      var d = this["d"];
      if (this["s"] < 0) {
        str += '-';
      }

      if (d === 1) {
        str += n;
      } else {

        if (excludeWhole && (whole = Math.floor(n / d)) > 0) {
          str += whole;
          str += " ";
          n %= d;
        }

        str += n;
        str += '/';
        str += d;
      }
      return str;
    },

    /**
     * Returns a latex representation of a Fraction object
     *
     * Ex: new Fraction("1.'3'").toLatex() => "\frac{4}{3}"
     **/
    'toLatex': function(excludeWhole) {

      var whole, str = "";
      var n = this["n"];
      var d = this["d"];
      if (this["s"] < 0) {
        str += '-';
      }

      if (d === 1) {
        str += n;
      } else {

        if (excludeWhole && (whole = Math.floor(n / d)) > 0) {
          str += whole;
          n %= d;
        }

        str += "\\frac{";
        str += n;
        str += '}{';
        str += d;
        str += '}';
      }
      return str;
    },

    /**
     * Returns an array of continued fraction elements
     *
     * Ex: new Fraction("7/8").toContinued() => [0,1,7]
     */
    'toContinued': function() {

      var t;
      var a = this['n'];
      var b = this['d'];
      var res = [];

      if (isNaN(this['n']) || isNaN(this['d'])) {
        return res;
      }

      do {
        res.push(Math.floor(a / b));
        t = a % b;
        a = b;
        b = t;
      } while (a !== 1);

      return res;
    },

    /**
     * Creates a string representation of a fraction with all digits
     *
     * Ex: new Fraction("100.'91823'").toString() => "100.(91823)"
     **/
    'toString': function(dec) {

      var g;
      var N = this["n"];
      var D = this["d"];

      if (isNaN(N) || isNaN(D)) {
        return "NaN";
      }

      if (!Fraction['REDUCE']) {
        g = gcd(N, D);
        N /= g;
        D /= g;
      }

      dec = dec || 15; // 15 = decimal places when no repitation

      var cycLen = cycleLen(N, D); // Cycle length
      var cycOff = cycleStart(N, D, cycLen); // Cycle start

      var str = this['s'] === -1 ? "-" : "";

      str += N / D | 0;

      N %= D;
      N *= 10;

      if (N)
        str += ".";

      if (cycLen) {

        for (var i = cycOff; i--; ) {
          str += N / D | 0;
          N %= D;
          N *= 10;
        }
        str += "(";
        for (var i = cycLen; i--; ) {
          str += N / D | 0;
          N %= D;
          N *= 10;
        }
        str += ")";
      } else {
        for (var i = dec; N && i--; ) {
          str += N / D | 0;
          N %= D;
          N *= 10;
        }
      }
      return str;
    }
  };

  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return Fraction;
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}

})(this);


/***/ }),

/***/ "./src/base/views/templates/ErrorView.mustache":
/*!*****************************************************!*\
  !*** ./src/base/views/templates/ErrorView.mustache ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    return "        <li>"
    + container.escapeExpression(container.lambda(depth0, depth0))
    + "</li>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<ul>\n"
    + ((stack1 = lookupProperty(helpers,"each").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"errors") : depth0),{"name":"each","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":2,"column":4},"end":{"line":4,"column":13}}})) != null ? stack1 : "")
    + "</ul>\n<button class=\"icon only unstyled close\" title=\"Masquer ce message\" aria-label=\"Masquer ce message\" data-dismiss=\"alert\" type=\"button\">\n    <svg><use href=\"/static/icons/icones.svg#times\"></use></svg>\n</button>";
},"useData":true});

/***/ }),

/***/ "./src/base/views/templates/LoginView.mustache":
/*!*****************************************************!*\
  !*** ./src/base/views/templates/LoginView.mustache ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<section id=\"user_login_form\" class=\"modal_view size_small\">\n    <div role=\"dialog\" id=\"user_login-forms\" aria-modal=\"true\" aria-labelledby=\"user_login-forms_title\">\n        <form>\n	        <div class=\"modal_layout\">\n                <header>\n                    <button class=\"icon only unstyled close\" title=\"Fermer cette fenêtre\" aria-label=\"Fermer cette fenêtre\" onclick=\"toggleModal('user_login_form'); return false;\">\n                        <svg><use href=\"/static/icons/icones.svg#times\"></use></svg>\n                    </button>\n                    <h2 id=\"user_login-forms_title\">\n                        <span class=\"user_avatar\">\n                            <svg><use href=\"/static/icons/icones.svg#user\"></use></svg>\n                        </span> \n                        Authentification\n                    </h2>\n                </header>\n                <div class=\"modal_content_layout\">\n                    <div class=\"modal_content\">\n                        <div class=\"errors alert alert-danger\" style=\"display:none;\"></div>\n                        <fieldset>\n    						<div class=\"form-group item-login item-login\" id=\"item-deformField1\">\n    							<label for=\"deformField1\" class=\"control-label required\" id=\"req-deformField1\" title=\"Identifiant - Champ obligatoire\">\n    								<svg class=\"error\"><use href=\"/static/icons/icones.svg#exclamation-triangle\"></use></svg>\n    								Identifiant\n    								<span class=\"icon required\">\n                                        <svg><use href=\"/static/icons/icones.svg#required\"></use></svg> \n                                        <span><span class=\"screen-reader-text\">Champ</span> Obligatoire</span>\n                                    </span>\n    							</label>\n    							<input name=\"login\" value=\"\" id=\"deformField1\" class=\" form-control \" type=\"text\">\n    						</div>\n    						<div class=\"form-group item-password\" id=\"item-deformField2\">\n    							<label for=\"deformField2\" class=\"control-label required\" id=\"req-deformField2\" title=\"Mot de passe - Champ obligatoire\">\n    								<svg class=\"error\"><use href=\"/static/icons/icones.svg#exclamation-triangle\"></use></svg>\n    								Mot de passe\n    								<span class=\"icon required\" aria-label=\"Champ obligatoire\"><svg><use href=\"/static/icons/icones.svg#required\"></use></svg> Obligatoire</span>\n    							</label>\n    							<input name=\"password\" value=\"\" id=\"deformField2\" class=\" form-control \" type=\"password\">\n    						</div>\n    						<div class=\"form-group item-remember_me\" title=\"\" id=\"item-deformField4\">\n    							<div class=\"toggle\">\n    								<label for=\"deformField4\">\n    									<input name=\"remember_me\" value=\"true\" id=\"deformField4\" type=\"checkbox\">\n    									<span>Rester connecté</span>\n    								</label>\n    							</div>\n    						</div>\n                        </fieldset>\n                    </div>\n                    <footer>\n                        <button class='btn btn-primary' type='submit'>Connexion</button>\n                    </footer>\n                </div>\n	        </div>\n        </form>\n    </div>\n</section>\n";
},"useData":true});

/***/ }),

/***/ "./src/base/views/templates/MessageView.mustache":
/*!*******************************************************!*\
  !*** ./src/base/views/templates/MessageView.mustache ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<div class='alert text-center'>\n"
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"notifyText") || (depth0 != null ? lookupProperty(depth0,"notifyText") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"notifyText","hash":{},"data":data,"loc":{"start":{"line":3,"column":0},"end":{"line":3,"column":16}}}) : helper))) != null ? stack1 : "")
    + "\n<button class='close-link unstyled close'><svg><use href=\"/static/icons/icones.svg#times\"></use></svg></button>\n</div>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"has_message") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":1,"column":0},"end":{"line":6,"column":7}}})) != null ? stack1 : "");
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/ActionToolbar.mustache":
/*!***********************************************************!*\
  !*** ./src/common/views/templates/ActionToolbar.mustache ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<div class='main_actions'>\n</div>\n<div class='resume'>\n</div>\n<div class='more_actions'>\n</div>";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/BaseDocumentViewer.mustache":
/*!****************************************************************!*\
  !*** ./src/common/views/templates/BaseDocumentViewer.mustache ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "	    <h4>"
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"title","hash":{},"data":data,"loc":{"start":{"line":3,"column":9},"end":{"line":3,"column":20}}}) : helper))) != null ? stack1 : "")
    + "</h4>\n";
},"3":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <p class=\"help_text\">\n        <span class=\"icon\">\n            <svg><use href=\"/static/icons/icones.svg#info-circle\"></use></svg>\n        </span>\n        <small>\n            <em>"
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"footerText") || (depth0 != null ? lookupProperty(depth0,"footerText") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"footerText","hash":{},"data":data,"loc":{"start":{"line":17,"column":16},"end":{"line":17,"column":32}}}) : helper))) != null ? stack1 : "")
    + "</em>\n        </small>\n    </p>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<div class=\"layout flex two_cols document_header\">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"title") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":2,"column":4},"end":{"line":4,"column":11}}})) != null ? stack1 : "")
    + "	<div class=\"controls align_right\"></div>\n</div>\n<div class=\"document_container\">\n    <div id=\"viewer\" class=\"pdfViewer\"></div>\n    <div class=\"loader\"></div>\n</div>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"footerText") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":11,"column":0},"end":{"line":20,"column":8}}})) != null ? stack1 : "");
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/BaseViewerPopupView.mustache":
/*!*****************************************************************!*\
  !*** ./src/common/views/templates/BaseViewerPopupView.mustache ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<section id=\"status_form\" class=\"modal_view size_large\">\n		<div role=\"dialog\" aria-modal=\"true\" aria-labelledby=\"pdf-preview_title\">\n			<div class=\"modal_layout\">\n				<header>\n					<button type='button' class=\"icon only unstyled close\" title=\"Fermer cette fenêtre\" aria-label=\"Fermer cette fenêtre\" onclick=\"toggleModal('status_form'); return false;\">\n						<svg><use href=\"/static/icons/icones.svg#times\"></use></svg>\n					</button>\n					<h2 id=\"status-forms_title\">"
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"popupTitle") || (depth0 != null ? lookupProperty(depth0,"popupTitle") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"popupTitle","hash":{},"data":data,"loc":{"start":{"line":8,"column":33},"end":{"line":8,"column":49}}}) : helper))) != null ? stack1 : "")
    + "</h2>\n				</header>\n				<div class=\"modal_content_layout\">\n					<div class=\"modal_content \">\n						<div class=\"layout flex content_vertical_padding pdf_viewer\">\n							<div class=\"preview\">\n                                <div class=\"pdfpreview\"></div>\n							</div>\n                        </div>\n					</div>\n				</div>\n                <div class=\"loader\"></div>\n			</div>\n		</div>\n</section>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/BusinessLink.mustache":
/*!**********************************************************!*\
  !*** ./src/common/views/templates/BusinessLink.mustache ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <span class=\"icon\" title=\"Client\">\n            <svg alt=\"Client \"><use href=\"/static/icons/icones.svg#user\"></use></svg>\n        </span>\n        "
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"customer_label") || (depth0 != null ? lookupProperty(depth0,"customer_label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"customer_label","hash":{},"data":data,"loc":{"start":{"line":6,"column":8},"end":{"line":6,"column":30}}}) : helper))) != null ? stack1 : "")
    + "\n";
},"3":function(container,depth0,helpers,partials,data) {
    return "        rien\n";
},"5":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <br />\n        <span class=\"icon\" title=\"Dossier\"\n        >\n            <svg alt=\"Dossier \"><use href=\"/static/icons/icones.svg#folder\"></use></svg>\n        </span>\n        "
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"project_label") || (depth0 != null ? lookupProperty(depth0,"project_label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"project_label","hash":{},"data":data,"loc":{"start":{"line":16,"column":8},"end":{"line":16,"column":29}}}) : helper))) != null ? stack1 : "")
    + "\n";
},"7":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <br />\n        <span class=\"icon\" title=\"Affaire\">\n            <svg alt=\"Affaire \"><use href=\"/static/icons/icones.svg#list-alt\"></use></svg>\n        </span>\n        "
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"business_label") || (depth0 != null ? lookupProperty(depth0,"business_label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"business_label","hash":{},"data":data,"loc":{"start":{"line":23,"column":8},"end":{"line":23,"column":30}}}) : helper))) != null ? stack1 : "")
    + "\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<span class=\"icon_label\">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"customer_label") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.program(3, data, 0),"data":data,"loc":{"start":{"line":2,"column":4},"end":{"line":9,"column":11}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"project_label") : depth0),{"name":"if","hash":{},"fn":container.program(5, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":10,"column":4},"end":{"line":17,"column":11}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"business_label") : depth0),{"name":"if","hash":{},"fn":container.program(7, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":18,"column":4},"end":{"line":24,"column":11}}})) != null ? stack1 : "")
    + "</span>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/CatalogComponent.mustache":
/*!**************************************************************!*\
  !*** ./src/common/views/templates/CatalogComponent.mustache ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<form class=\"deform\" autocomplete=\"off\">\n    <fieldset class=\"deformFormFieldset\">\n        <div class='main'></div>\n        <div class='form-actions form-group'>\n            <button class='btn btn-primary icon' type='submit' value='insert' disabled='true' aria-disabled='true' title=\"Ajouter le ou les produits sélectionnés\" aria-label=\"Ajouter le ou les produits sélectionnés\">\n                <svg><use href=\"/static/icons/icones.svg#check\"></use></svg>Ajouter\n            </button>\n            <button class='btn' type='reset' value='cancel'>\n                Annuler\n            </button>\n        </div>\n    </fieldset>\n</form>";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/CatalogTreeCollectionView.mustache":
/*!***********************************************************************!*\
  !*** ./src/common/views/templates/CatalogTreeCollectionView.mustache ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<table class=\"hover_table top_align_table\">\n  <thead>\n    <th scope=\"col\" class=\"col_select\">\n	  <div class=\"select-toggle\"></div>\n	</th>\n	<th scope=\"col\" class=\"col_number quantity\" title=\"Quantité\">Q<span class=\"screen-reader-text\">uanti</span>té</th>\n    <th scope=\"col\" class=\"col_text unity\">Unité</th>\n    <th scope=\"col\" class=\"col_text\">Nom interne</th>\n	<th scope=\"col\" class=\"col_text\">Description</th>\n	<th scope=\"col\" class=\"col_number\" title=\"Prix Unitaire Hors Taxes\">Prix U<span aria-hidden=\"true\">.</span><span class=\"screen-reader-text\">nitaire</span> H<span class=\"screen-reader-text\">ors </span>T<span class=\"screen-reader-text\">axes</span></th>\n  </thead>\n  <tbody></tbody>\n</table>\n\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/CatalogTreeItemView.mustache":
/*!*****************************************************************!*\
  !*** ./src/common/views/templates/CatalogTreeItemView.mustache ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "("
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"ref") || (depth0 != null ? lookupProperty(depth0,"ref") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"ref","hash":{},"data":data,"loc":{"start":{"line":7,"column":26},"end":{"line":7,"column":33}}}) : helper)))
    + ")";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<td class='col_select action'></td>\n<td class='col_number input'></td>\n<td class='col_text unity'>\n    "
    + alias4(((helper = (helper = lookupProperty(helpers,"unity") || (depth0 != null ? lookupProperty(depth0,"unity") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"unity","hash":{},"data":data,"loc":{"start":{"line":4,"column":4},"end":{"line":4,"column":13}}}) : helper)))
    + "\n</td>\n<td class='col_text'>\n    "
    + alias4(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":7,"column":4},"end":{"line":7,"column":13}}}) : helper)))
    + " "
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"ref") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":7,"column":14},"end":{"line":7,"column":41}}})) != null ? stack1 : "")
    + "\n</td>\n<td class='col_text'>\n    <small>"
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"description") || (depth0 != null ? lookupProperty(depth0,"description") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"description","hash":{},"data":data,"loc":{"start":{"line":10,"column":11},"end":{"line":10,"column":28}}}) : helper))) != null ? stack1 : "")
    + "</small>\n</td>\n<td class='col_number'>\n    "
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"amount_label") || (depth0 != null ? lookupProperty(depth0,"amount_label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"amount_label","hash":{},"data":data,"loc":{"start":{"line":13,"column":4},"end":{"line":13,"column":22}}}) : helper))) != null ? stack1 : "")
    + "\n</td>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/CatalogTreeView.mustache":
/*!*************************************************************!*\
  !*** ./src/common/views/templates/CatalogTreeView.mustache ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<div class=\"layout flex product-filter\">\n	<span class=\"icon\">\n		<svg><use href=\"/static/icons/icones.svg#search\"></use></svg>\n	</span>\n	<div class='field-filter'></div>\n</div>\n<div class='tree-container table_container'></div>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/DocumentViewerControlsView.mustache":
/*!************************************************************************!*\
  !*** ./src/common/views/templates/DocumentViewerControlsView.mustache ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    return "        <button class=\"go_previous btn icon only\" title=\"Page précédente\" aria-label=\"Aller à la page précédente du document\">\n                <svg>\n                        <use href=\"/static/icons/icones.svg#chevron-left\"></use>\n                </svg>\n        </button>\n        <button class=\"go_next btn icon only\" title=\"Page suivante\" aria-label=\"Aller à la page suivante du document\">\n                <svg>\n                        <use href=\"/static/icons/icones.svg#chevron-right\"></use>\n                </svg>\n        </button>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"multipage") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":1,"column":0},"end":{"line":12,"column":7}}})) != null ? stack1 : "")
    + "\n<button class=\"rotate-left btn icon only\" title=\"Tourner à gauche\" aria-label=\"Tourner le document vers la gauche\">\n        <svg>\n                <use href=\"/static/icons/icones.svg#rotate-left\"></use>\n        </svg>\n</button>\n<button class=\"rotate-right btn icon only\" title=\"Tourner à droite\" aria-label=\"Tourner le document vers la droite\">\n        <svg>\n                <use href=\"/static/icons/icones.svg#rotate-right\"></use>\n        </svg>\n</button>\n\n<button class=\"zoom_in btn icon only\" title=\"Zoomer\" aria-label=\"Zoomer le document\">\n        <svg>\n                <use href=\"/static/icons/icones.svg#search-plus\"></use>\n        </svg>\n</button>\n<button class=\"zoom_out btn icon only\" title=\"Dézoomer\" aria-label=\"Dézoomer le document\">\n        <svg>\n                <use href=\"/static/icons/icones.svg#search-minus\"></use>\n        </svg>\n</button>\n\n<button class=\"open_full btn icon only\" title=\"Télécharger\" aria-label=\"Télécharger le fichier\">\n        <svg>\n                <use href=\"/static/icons/icones.svg#download\"></use>\n        </svg>\n</button>";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/ImageViewerView.mustache":
/*!*************************************************************!*\
  !*** ./src/common/views/templates/ImageViewerView.mustache ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var stack1, helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "	    <h4>"
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"title","hash":{},"data":data,"loc":{"start":{"line":3,"column":9},"end":{"line":3,"column":20}}}) : helper))) != null ? stack1 : "")
    + "</h4>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<div class=\"layout flex two_cols document_header\">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"title") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":2,"column":4},"end":{"line":4,"column":11}}})) != null ? stack1 : "")
    + "	<div class=\"controls align_right\"></div>\n</div>\n<div class=\"document_container\" style=\"\">\n    <img src=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"url") || (depth0 != null ? lookupProperty(depth0,"url") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"url","hash":{},"data":data,"loc":{"start":{"line":8,"column":14},"end":{"line":8,"column":21}}}) : helper)))
    + "\" alt=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":8,"column":28},"end":{"line":8,"column":37}}}) : helper)))
    + "\" />\n</div>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/NodeFileCollectionView.mustache":
/*!********************************************************************!*\
  !*** ./src/common/views/templates/NodeFileCollectionView.mustache ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<h3>Justificatifs</h3>\n<div class=\"content_vertical_padding\">\n<ul></ul>\n</div>\n<a href=\"#\" class=\"add-btn btn btn-primary\">\n    <svg><use href=\"/static/icons/icones.svg#paperclip\"></use></svg>\n    Ajouter un fichier\n</a>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/NodeFileItemView.mustache":
/*!**************************************************************!*\
  !*** ./src/common/views/templates/NodeFileItemView.mustache ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    return "    <span class=\"icon only tag positive\" title=\"Fichier signé numériquement\">\n        <svg role=\"presentation\"><use href=\"/static/icons/icones.svg#lock\"></use></svg>\n        <span class=\"screen-reader-text\">Fichier signé numériquement</span>\n    </span>\n";
},"3":function(container,depth0,helpers,partials,data) {
    return "    <span class=\"icon only tag caution\" title=\"Fichier non signé numériquement\">\n        <svg role=\"presentation\"><use href=\"/static/icons/icones.svg#lock-open\"></use></svg>\n        <span class=\"screen-reader-text\">Fichier non signé numériquement</span>\n    </span>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"is_signed") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.program(3, data, 0),"data":data,"loc":{"start":{"line":1,"column":0},"end":{"line":11,"column":7}}})) != null ? stack1 : "")
    + ((stack1 = ((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":12,"column":0},"end":{"line":12,"column":11}}}) : helper))) != null ? stack1 : "")
    + "\n<a href=\"#\" class=\"edit-btn btn icon only unstyled\" title=\"Éditer ce fichier\" aria-label=\"Éditer ce fichier\">\n    <svg><use href=\"/static/icons/icones.svg#pen\"></use></svg>\n</a>\n<a href=\"#\" class=\"download-btn btn icon only unstyled\" title=\"Télécharger ce fichier\" aria-label=\"Télécharger ce fichier\">\n    <svg><use href=\"/static/icons/icones.svg#download\"></use></svg>\n</a>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/StatusFormPopupView.mustache":
/*!*****************************************************************!*\
  !*** ./src/common/views/templates/StatusFormPopupView.mustache ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "                    <div class='alert alert-info'>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"help_text") || (depth0 != null ? lookupProperty(depth0,"help_text") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"help_text","hash":{},"data":data,"loc":{"start":{"line":16,"column":50},"end":{"line":16,"column":63}}}) : helper)))
    + "</div>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "\n<div role=\"dialog\" id=\"expense_status_change_form\" aria-modal=\"true\" aria-labelledby=\"expense_status_change_form_title\">\n    <form class='form' data-url='"
    + alias4(((helper = (helper = lookupProperty(helpers,"url") || (depth0 != null ? lookupProperty(depth0,"url") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"url","hash":{},"data":data,"loc":{"start":{"line":3,"column":33},"end":{"line":3,"column":42}}}) : helper)))
    + "' method='POST'>\n    	<div class=\"modal_layout\">\n            <header>\n                <button class=\"icon only unstyled close\" title=\"Fermer cette fenêtre\" type='button'>\n                    <svg><use href=\"/static/icons/icones.svg#times\"></use></svg>\n                </button>\n                <h2 id=\"expense_status_change_form_title\">\n                    "
    + alias4(((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"title","hash":{},"data":data,"loc":{"start":{"line":10,"column":20},"end":{"line":10,"column":31}}}) : helper)))
    + "\n                </h2>\n            </header>\n            <div class=\"modal_content_layout\">\n                <div class=\"modal_content\">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"help_text") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":15,"column":20},"end":{"line":17,"column":27}}})) != null ? stack1 : "")
    + "                    <div class='form-group'>\n                        <label for='comment'>Mémo</label>\n                        <textarea class='form-control' name='comment' id='comment' rows=4></textarea>\n                        <span class=\"help-block\">Ajouter un commentaire au mémo de demande de validation</span>\n                    </div>\n                </div>\n                <footer>\n                    <button class='btn btn-primary icon' type='submit' value='"
    + alias4(((helper = (helper = lookupProperty(helpers,"status") || (depth0 != null ? lookupProperty(depth0,"status") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"status","hash":{},"data":data,"loc":{"start":{"line":25,"column":78},"end":{"line":25,"column":88}}}) : helper)))
    + "'><svg><use href=\"/static/icons/icones.svg#save\"></use></svg> "
    + alias4(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":25,"column":150},"end":{"line":25,"column":159}}}) : helper)))
    + "</button>\n                    <button class='btn icon cancel' type='button'><svg><use href=\"/static/icons/icones.svg#times\"></use></svg> Annuler</button>\n                </footer>\n            </div>\n    	</div>\n    </form>\n</div>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/StatusHistoryPopupView.mustache":
/*!********************************************************************!*\
  !*** ./src/common/views/templates/StatusHistoryPopupView.mustache ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "                        <span class=\"bubble\">"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"collectionLength") || (depth0 != null ? lookupProperty(depth0,"collectionLength") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"collectionLength","hash":{},"data":data,"loc":{"start":{"line":17,"column":45},"end":{"line":17,"column":67}}}) : helper)))
    + "</span>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<section id=\"status_history_modal\" class=\"modal_view size_small\">\n    <div role=\"dialog\" id=\"postit_history\" aria-modal=\"true\"\n         aria-labelledby=\"postit_history_title\"\n         aria-describedby=\"postit_history_text\" class=\"appear\">\n        <div class=\"modal_layout\">\n            <header>\n                <button class=\"icon only unstyled close\"\n                        title=\"Masquer ce message\"\n                        type='button'>\n                    <svg>\n                        <use href=\"/static/icons/icones.svg#times\"></use>\n                    </svg>\n                </button>\n                <h2 id=\"postit_history_title\">\n                    Mémos\n"
    + ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"collectionLength") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":16,"column":20},"end":{"line":18,"column":27}}})) != null ? stack1 : "")
    + "                </h2>\n            </header>\n            <div class=\"modal_content_layout\">\n                <div class=\"modal_content memos\">\n                    <ul class=\"comments\"></ul>\n                </div>\n                <footer>\n                    <button type=\"reset\"\n                        class=\"btn btn-primary\"\n                        onclick=\"toggleModal('status_history_modal'); return false;\"\n                        title=\"Fermer cette fenêtre\"\n                        aria-label=\"Fermer cette fenêtre\">\n                        Fermer\n                    </button>\n                </footer>\n            </div>\n        </div>\n    </div>\n</section>\n";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/StatusHistoryView.mustache":
/*!***************************************************************!*\
  !*** ./src/common/views/templates/StatusHistoryView.mustache ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <span class=\"bubble\">"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"collectionLength") || (depth0 != null ? lookupProperty(depth0,"collectionLength") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"collectionLength","hash":{},"data":data,"loc":{"start":{"line":4,"column":29},"end":{"line":4,"column":51}}}) : helper)))
    + "</span>\n";
},"3":function(container,depth0,helpers,partials,data) {
    var helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <small>… et "
    + alias4(((helper = (helper = lookupProperty(helpers,"hiddenItemsCount") || (depth0 != null ? lookupProperty(depth0,"hiddenItemsCount") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"hiddenItemsCount","hash":{},"data":data,"loc":{"start":{"line":15,"column":16},"end":{"line":15,"column":38}}}) : helper)))
    + " mémo"
    + alias4(((helper = (helper = lookupProperty(helpers,"pluralize") || (depth0 != null ? lookupProperty(depth0,"pluralize") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"pluralize","hash":{},"data":data,"loc":{"start":{"line":15,"column":43},"end":{"line":15,"column":58}}}) : helper)))
    + " plus\n        ancien"
    + alias4(((helper = (helper = lookupProperty(helpers,"pluralize") || (depth0 != null ? lookupProperty(depth0,"pluralize") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"pluralize","hash":{},"data":data,"loc":{"start":{"line":16,"column":14},"end":{"line":16,"column":29}}}) : helper)))
    + "&nbsp;:</small>\n    <a class=\"show_all\" href=\"#\">Voir tous les mémos</a>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<h4>\n    Mémos\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"collectionLength") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":3,"column":4},"end":{"line":5,"column":11}}})) != null ? stack1 : "")
    + "    <button class=\"btn icon only unstyled add_new\" title=\"Ajouter un mémo\"\n            aria-label=\"Ajouter un mémo\"\n    >\n        <svg><use href=\"/static/icons/icones.svg#plus\"></use></svg>\n    </button>\n</h4>\n<div class='modalregion'></div>\n<ul class=\"comments\"></ul>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"hasHiddenItems") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":14,"column":0},"end":{"line":18,"column":7}}})) != null ? stack1 : "");
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/StatusLogEntryEmptyView.mustache":
/*!*********************************************************************!*\
  !*** ./src/common/views/templates/StatusLogEntryEmptyView.mustache ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<blockquote>\n<p class=\"status\"></p>\n<p>Aucun mémo pour l'instant.</p>\n</blockquote>";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/StatusLogEntryFormPopupView.mustache":
/*!*************************************************************************!*\
  !*** ./src/common/views/templates/StatusLogEntryFormPopupView.mustache ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<section class=\"modal_view size_middle\">\n	<div role=\"dialog\" id=\"add_memo\" aria-modal=\"true\" aria-labelledby=\"add_memo_title\" class=\"appear\">\n		<form class=\"form\">\n			<div class=\"modal_layout\">\n				<header>\n					<button class=\"icon only unstyled close\" title=\"Masquer cette fenêtre\" aria-label=\"Masquer cette fenêtre\" type='button'>\n						<svg>\n							<use href=\"../static/icons/icones.svg#times\"></use>\n						</svg>\n					</button>\n					<h2 id=\"add_memo_title\">\n						"
    + alias4(((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"title","hash":{},"data":data,"loc":{"start":{"line":12,"column":6},"end":{"line":12,"column":17}}}) : helper)))
    + "\n					</h2>\n				</header>\n				<div class=\"modal_content_layout\">\n					<div class=\"modal_content\">\n						<div class=\"content_vertical_padding separate_bottom_dashed\">\n							<div class=\"row form-row\">\n								<div class=\"col-md-12\">\n									<div class=\"field_description\"></div>\n								</div>\n							</div>\n							<div class=\"row form-row\">\n								<div class=\"col-md-6\">\n									<div class=\"field_visibility\"></div>\n								</div>\n								<div class=\"col-md-6\">\n									<div class=\"field_pinned\"></div>\n								</div>\n							</div>\n						</div>\n						<div class=\"row form-row\">\n							<div class=\"col-md-12\">\n								<div class=\"field_notify\"></div>\n							</div>\n						</div>\n						<div class=\"row form-row\">\n							<div class=\"col-md-12\">\n								<div class=\"field_notification_recipients\"></div>\n							</div>\n\n						</div>\n					</div>\n					<footer>\n						<button class=\"btn btn-primary\" type=\"submit\" value=\"submit\">\n							"
    + alias4(((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"title","hash":{},"data":data,"loc":{"start":{"line":46,"column":7},"end":{"line":46,"column":18}}}) : helper)))
    + "\n						</button>\n						<button class=\"btn\" type=\"reset\" title=\"Fermer cette fenêtre\" aria-label=\"Fermer cette fenêtre\">\n							Fermer\n						</button>\n					</footer>\n				</div>\n			</div>\n		</form>\n	</div>\n</section>";
},"useData":true});

/***/ }),

/***/ "./src/common/views/templates/StatusLogEntryItemView.mustache":
/*!********************************************************************!*\
  !*** ./src/common/views/templates/StatusLogEntryItemView.mustache ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "class=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"status") || (depth0 != null ? lookupProperty(depth0,"status") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"status","hash":{},"data":data,"loc":{"start":{"line":1,"column":33},"end":{"line":1,"column":43}}}) : helper)))
    + "\"";
},"3":function(container,depth0,helpers,partials,data) {
    var helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <span class=\"icon status "
    + alias4(((helper = (helper = lookupProperty(helpers,"css_class") || (depth0 != null ? lookupProperty(depth0,"css_class") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"css_class","hash":{},"data":data,"loc":{"start":{"line":3,"column":29},"end":{"line":3,"column":42}}}) : helper)))
    + "\" role=\"presentation\">\n        <svg><use href=\"/static/icons/icones.svg#"
    + alias4(((helper = (helper = lookupProperty(helpers,"icon") || (depth0 != null ? lookupProperty(depth0,"icon") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"icon","hash":{},"data":data,"loc":{"start":{"line":4,"column":49},"end":{"line":4,"column":57}}}) : helper)))
    + "\"></use></svg>\n    </span>\n";
},"5":function(container,depth0,helpers,partials,data) {
    return "        <button class=\"icon only unstyled delete\" title=\"Supprimer ce mémo\"\n                aria-label=\"Supprimer ce mémo\">\n            <svg>\n                <use href=\"/static/icons/icones.svg#trash-alt\"></use>\n            </svg>\n        </button>\n        <button class=\"icon only unstyled edit\" title=\"Modifier ce mémo\"\n                aria-label=\"Modifier ce mémo\">\n            <svg>\n                <use href=\"/static/icons/icones.svg#pen\"></use>\n            </svg>\n        </button>\n";
},"7":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <h5>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"label","hash":{},"data":data,"loc":{"start":{"line":23,"column":8},"end":{"line":23,"column":17}}}) : helper)))
    + "</h5>\n";
},"9":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <p>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"formatted_comment") || (depth0 != null ? lookupProperty(depth0,"formatted_comment") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"formatted_comment","hash":{},"data":data,"loc":{"start":{"line":26,"column":7},"end":{"line":26,"column":28}}}) : helper)))
    + "</p>\n";
},"11":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "title=\"Mémo "
    + container.escapeExpression(container.lambda(((stack1 = (depth0 != null ? lookupProperty(depth0,"visibility") : depth0)) != null ? lookupProperty(stack1,"description") : stack1), depth0))
    + "\"";
},"13":function(container,depth0,helpers,partials,data) {
    var stack1, alias1=container.lambda, alias2=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <span class=\"icon\" role=\"presentation\">\n            <svg><use href=\"/static/icons/icones.svg#"
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"visibility") : depth0)) != null ? lookupProperty(stack1,"icon") : stack1), depth0))
    + "\"></use></svg>\n            "
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"visibility") : depth0)) != null ? lookupProperty(stack1,"label") : stack1), depth0))
    + "\n            <span class=\"screen-reader-text\">("
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"visibility") : depth0)) != null ? lookupProperty(stack1,"description") : stack1), depth0))
    + ")</span>\n            —\n        </span>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<blockquote "
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"status") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":1,"column":12},"end":{"line":1,"column":51}}})) != null ? stack1 : "")
    + ">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"icon") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":2,"column":0},"end":{"line":6,"column":7}}})) != null ? stack1 : "")
    + "<div>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"can_edit") : depth0),{"name":"if","hash":{},"fn":container.program(5, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":8,"column":4},"end":{"line":21,"column":11}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"label") : depth0),{"name":"if","hash":{},"fn":container.program(7, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":22,"column":0},"end":{"line":24,"column":7}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"comment") : depth0),{"name":"if","hash":{},"fn":container.program(9, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":25,"column":0},"end":{"line":27,"column":7}}})) != null ? stack1 : "")
    + "</div>\n<footer "
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"visibility") : depth0),{"name":"if","hash":{},"fn":container.program(11, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":29,"column":8},"end":{"line":29,"column":72}}})) != null ? stack1 : "")
    + ">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"visibility") : depth0),{"name":"if","hash":{},"fn":container.program(13, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":30,"column":4},"end":{"line":37,"column":11}}})) != null ? stack1 : "")
    + "    "
    + alias4(((helper = (helper = lookupProperty(helpers,"user") || (depth0 != null ? lookupProperty(depth0,"user") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"user","hash":{},"data":data,"loc":{"start":{"line":38,"column":4},"end":{"line":38,"column":12}}}) : helper)))
    + " le "
    + alias4(((helper = (helper = lookupProperty(helpers,"date") || (depth0 != null ? lookupProperty(depth0,"date") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"date","hash":{},"data":data,"loc":{"start":{"line":38,"column":16},"end":{"line":38,"column":24}}}) : helper)))
    + "\n</footer>\n</blockquote>\n";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/AnchorWidget.mustache":
/*!*****************************************************!*\
  !*** ./src/widgets/templates/AnchorWidget.mustache ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    return "javascript:void(0);";
},"3":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return container.escapeExpression(container.lambda(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"url") : stack1), depth0));
},"5":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "onclick=\"return window.confirm('"
    + container.escapeExpression(container.lambda(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"confirm_msg") : stack1), depth0))
    + "')\"";
},"7":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return " "
    + container.escapeExpression(container.lambda(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"attrs") : stack1), depth0));
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, alias1=container.lambda, alias2=container.escapeExpression, alias3=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<a\n    class='"
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"css") : stack1), depth0))
    + "'\n    href='"
    + ((stack1 = lookupProperty(helpers,"if").call(alias3,((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"popup") : stack1),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.program(3, data, 0),"data":data,"loc":{"start":{"line":3,"column":10},"end":{"line":3,"column":80}}})) != null ? stack1 : "")
    + "'\n    title=\""
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"title") : stack1), depth0))
    + "\"\n    "
    + ((stack1 = lookupProperty(helpers,"if").call(alias3,((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"confirm_msg") : stack1),{"name":"if","hash":{},"fn":container.program(5, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":5,"column":4},"end":{"line":5,"column":96}}})) != null ? stack1 : "")
    + "\n    "
    + ((stack1 = lookupProperty(helpers,"if").call(alias3,((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"attrs") : stack1),{"name":"if","hash":{},"fn":container.program(7, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":6,"column":4},"end":{"line":6,"column":50}}})) != null ? stack1 : "")
    + ">\n    <svg><use href=\"/static/icons/icones.svg#"
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"icon") : stack1), depth0))
    + "\"></use></svg>\n    "
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"label") : stack1), depth0))
    + "\n</a>\n";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/ButtonWidget.mustache":
/*!*****************************************************!*\
  !*** ./src/widgets/templates/ButtonWidget.mustache ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    return " only";
},"3":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    "
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"label","hash":{},"data":data,"loc":{"start":{"line":5,"column":4},"end":{"line":5,"column":15}}}) : helper)))
    + "\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<button class='btn icon"
    + ((stack1 = lookupProperty(helpers,"unless").call(alias1,(depth0 != null ? lookupProperty(depth0,"showLabel") : depth0),{"name":"unless","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":1,"column":23},"end":{"line":1,"column":60}}})) != null ? stack1 : "")
    + " "
    + alias4(((helper = (helper = lookupProperty(helpers,"css") || (depth0 != null ? lookupProperty(depth0,"css") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"css","hash":{},"data":data,"loc":{"start":{"line":1,"column":61},"end":{"line":1,"column":68}}}) : helper)))
    + "' data-action='"
    + alias4(((helper = (helper = lookupProperty(helpers,"action") || (depth0 != null ? lookupProperty(depth0,"action") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"action","hash":{},"data":data,"loc":{"start":{"line":1,"column":83},"end":{"line":1,"column":95}}}) : helper)))
    + "' title='"
    + alias4(((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"title","hash":{},"data":data,"loc":{"start":{"line":1,"column":104},"end":{"line":1,"column":113}}}) : helper)))
    + "'\n        type='"
    + alias4(((helper = (helper = lookupProperty(helpers,"type") || (depth0 != null ? lookupProperty(depth0,"type") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"type","hash":{},"data":data,"loc":{"start":{"line":2,"column":14},"end":{"line":2,"column":22}}}) : helper)))
    + "'>\n	<icon></icon>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"showLabel") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":4,"column":4},"end":{"line":6,"column":11}}})) != null ? stack1 : "")
    + "</button>\n";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/CheckboxListWidget.mustache":
/*!***********************************************************!*\
  !*** ./src/widgets/templates/CheckboxListWidget.mustache ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <label for=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":4,"column":20},"end":{"line":4,"column":29}}}) : helper)))
    + "\">\n            "
    + alias4(((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"title","hash":{},"data":data,"loc":{"start":{"line":5,"column":12},"end":{"line":5,"column":21}}}) : helper)))
    + "\n        </label>\n";
},"3":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"editable") : depth0),{"name":"if","hash":{},"fn":container.program(4, data, 0),"inverse":container.program(6, data, 0),"data":data,"loc":{"start":{"line":12,"column":3},"end":{"line":16,"column":10}}})) != null ? stack1 : "");
},"4":function(container,depth0,helpers,partials,data) {
    return "				<div class=\"layout flex editable\">\n";
},"6":function(container,depth0,helpers,partials,data) {
    return "				<div>\n";
},"8":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "layout flex "
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"layout") || (depth0 != null ? lookupProperty(depth0,"layout") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"layout","hash":{},"data":data,"loc":{"start":{"line":19,"column":49},"end":{"line":19,"column":59}}}) : helper)));
},"10":function(container,depth0,helpers,partials,data,blockParams,depths) {
    var stack1, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"unless").call(alias1,(depth0 != null ? lookupProperty(depth0,"options") : depth0),{"name":"unless","hash":{},"fn":container.program(11, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":21,"column":5},"end":{"line":23,"column":17}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"each").call(alias1,(depth0 != null ? lookupProperty(depth0,"options") : depth0),{"name":"each","hash":{},"fn":container.program(13, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":24,"column":5},"end":{"line":46,"column":15}}})) != null ? stack1 : "");
},"11":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "						<em>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"noOptionMessage") || (depth0 != null ? lookupProperty(depth0,"noOptionMessage") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"noOptionMessage","hash":{},"data":data,"loc":{"start":{"line":22,"column":10},"end":{"line":22,"column":29}}}) : helper)))
    + "</em>\n";
},"13":function(container,depth0,helpers,partials,data,blockParams,depths) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.escapeExpression, alias3=container.lambda, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "						<div>\n							<div class=\"checkbox\">\n								<label>\n									<input \n										id=\""
    + alias2(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":29,"column":14},"end":{"line":29,"column":23}}}) : helper)))
    + "\" \n										type='checkbox'\n										multiple=\"multiple\"\n										name='"
    + alias2(alias3((depths[1] != null ? lookupProperty(depths[1],"field_name") : depths[1]), depth0))
    + "'\n										value='"
    + alias2(alias3((depth0 != null ? lookupProperty(depth0,"id") : depth0), depth0))
    + "'\n										aria-label=\""
    + alias2(alias3((depth0 != null ? lookupProperty(depth0,"label") : depth0), depth0))
    + "\"\n										"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"selected") : depth0),{"name":"if","hash":{},"fn":container.program(14, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":35,"column":10},"end":{"line":35,"column":45}}})) != null ? stack1 : "")
    + " />\n									<span>"
    + alias2(alias3((depth0 != null ? lookupProperty(depth0,"label") : depth0), depth0))
    + "</span>\n								</label>\n							</div>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depths[1] != null ? lookupProperty(depths[1],"description") : depths[1]),{"name":"if","hash":{},"fn":container.program(16, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":39,"column":7},"end":{"line":41,"column":14}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"help_text") : depth0),{"name":"if","hash":{},"fn":container.program(18, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":42,"column":7},"end":{"line":44,"column":14}}})) != null ? stack1 : "")
    + "						</div>\n";
},"14":function(container,depth0,helpers,partials,data) {
    return "checked";
},"16":function(container,depth0,helpers,partials,data,blockParams,depths) {
    var lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "								<span class='help-block'>"
    + container.escapeExpression(container.lambda((depths[1] != null ? lookupProperty(depths[1],"description") : depths[1]), depth0))
    + "</span>\n";
},"18":function(container,depth0,helpers,partials,data) {
    var lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "								<span class='help-block'>"
    + container.escapeExpression(container.lambda((depth0 != null ? lookupProperty(depth0,"help_text") : depth0), depth0))
    + "</span>\n";
},"20":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),((stack1 = (depth0 != null ? lookupProperty(depth0,"selectedOptions") : depth0)) != null ? lookupProperty(stack1,"length") : stack1),{"name":"if","hash":{},"fn":container.program(21, data, 0),"inverse":container.program(11, data, 0),"data":data,"loc":{"start":{"line":48,"column":5},"end":{"line":56,"column":12}}})) != null ? stack1 : "");
},"21":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "						<ul>\n"
    + ((stack1 = lookupProperty(helpers,"each").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"selectedOptions") : depth0),{"name":"each","hash":{},"fn":container.program(22, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":50,"column":7},"end":{"line":52,"column":17}}})) != null ? stack1 : "")
    + "						</ul>\n";
},"22":function(container,depth0,helpers,partials,data) {
    var lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "								<li>"
    + container.escapeExpression(container.lambda((depth0 != null ? lookupProperty(depth0,"label") : depth0), depth0))
    + "</li>\n";
},"24":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"editable") : depth0),{"name":"if","hash":{},"fn":container.program(25, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":61,"column":4},"end":{"line":77,"column":11}}})) != null ? stack1 : "");
},"25":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"editing") : depth0),{"name":"if","hash":{},"fn":container.program(26, data, 0),"inverse":container.program(28, data, 0),"data":data,"loc":{"start":{"line":62,"column":5},"end":{"line":76,"column":12}}})) != null ? stack1 : "");
},"26":function(container,depth0,helpers,partials,data) {
    return "						<button class='btn icon only unstyled edit' title='Annuler' aria-label='Annuler'>\n							<svg><use href=\"/static/icons/icones.svg#times\"></use></svg>\n						</button>\n";
},"28":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),((stack1 = (depth0 != null ? lookupProperty(depth0,"selectedOptions") : depth0)) != null ? lookupProperty(stack1,"length") : stack1),{"name":"if","hash":{},"fn":container.program(29, data, 0),"inverse":container.program(31, data, 0),"data":data,"loc":{"start":{"line":67,"column":6},"end":{"line":75,"column":13}}})) != null ? stack1 : "");
},"29":function(container,depth0,helpers,partials,data) {
    return "							<button class='btn icon only edit' title='Modifier' aria-label='Modifier'>\n								<svg><use href=\"/static/icons/icones.svg#pen\"></use></svg>\n							</button>\n";
},"31":function(container,depth0,helpers,partials,data) {
    var helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "							<button class='btn btn-primary icon edit'>\n								<svg><use href=\"/static/icons/icones.svg#"
    + alias4(((helper = (helper = lookupProperty(helpers,"addBtnIcon") || (depth0 != null ? lookupProperty(depth0,"addBtnIcon") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"addBtnIcon","hash":{},"data":data,"loc":{"start":{"line":73,"column":49},"end":{"line":73,"column":63}}}) : helper)))
    + "\"></use></svg> "
    + alias4(((helper = (helper = lookupProperty(helpers,"addBtnLabel") || (depth0 != null ? lookupProperty(depth0,"addBtnLabel") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"addBtnLabel","hash":{},"data":data,"loc":{"start":{"line":73,"column":78},"end":{"line":73,"column":93}}}) : helper)))
    + "\n							</button>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data,blockParams,depths) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<div class='form-group'>\n\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"title") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":3,"column":4},"end":{"line":7,"column":11}}})) != null ? stack1 : "")
    + "   \n	<fieldset id=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":9,"column":15},"end":{"line":9,"column":24}}}) : helper)))
    + "\">\n\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"togglable") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":11,"column":2},"end":{"line":17,"column":9}}})) != null ? stack1 : "")
    + "		\n			<div class=\"content "
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"layout") : depth0),{"name":"if","hash":{},"fn":container.program(8, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":19,"column":23},"end":{"line":19,"column":66}}})) != null ? stack1 : "")
    + "\">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"editing") : depth0),{"name":"if","hash":{},"fn":container.program(10, data, 0, blockParams, depths),"inverse":container.program(20, data, 0, blockParams, depths),"data":data,"loc":{"start":{"line":20,"column":4},"end":{"line":57,"column":11}}})) != null ? stack1 : "")
    + "			</div>\n\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"togglable") : depth0),{"name":"if","hash":{},"fn":container.program(24, data, 0, blockParams, depths),"inverse":container.noop,"data":data,"loc":{"start":{"line":60,"column":3},"end":{"line":78,"column":10}}})) != null ? stack1 : "")
    + "\n		</div>\n\n    </fieldset>\n</div>\n";
},"useData":true,"useDepths":true});

/***/ }),

/***/ "./src/widgets/templates/CheckboxWidget.mustache":
/*!*******************************************************!*\
  !*** ./src/widgets/templates/CheckboxWidget.mustache ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <label>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"title") || (depth0 != null ? lookupProperty(depth0,"title") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"title","hash":{},"data":data,"loc":{"start":{"line":3,"column":11},"end":{"line":3,"column":20}}}) : helper)))
    + "</label>\n";
},"3":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <div class=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"divCss") || (depth0 != null ? lookupProperty(depth0,"divCss") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"divCss","hash":{},"data":data,"loc":{"start":{"line":6,"column":20},"end":{"line":6,"column":30}}}) : helper)))
    + "\">\n            <label for=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":7,"column":24},"end":{"line":7,"column":33}}}) : helper)))
    + "\">\n				<input \n					id=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":9,"column":9},"end":{"line":9,"column":18}}}) : helper)))
    + "\"\n					type='checkbox'\n					name='"
    + alias4(((helper = (helper = lookupProperty(helpers,"field_name") || (depth0 != null ? lookupProperty(depth0,"field_name") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"field_name","hash":{},"data":data,"loc":{"start":{"line":11,"column":11},"end":{"line":11,"column":27}}}) : helper)))
    + "'\n					value='true'\n					"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"checked") : depth0),{"name":"if","hash":{},"fn":container.program(4, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":13,"column":5},"end":{"line":13,"column":34}}})) != null ? stack1 : "")
    + " \n				/> \n				<span>"
    + alias4(((helper = (helper = lookupProperty(helpers,"inline_label") || (depth0 != null ? lookupProperty(depth0,"inline_label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"inline_label","hash":{},"data":data,"loc":{"start":{"line":15,"column":10},"end":{"line":15,"column":26}}}) : helper)))
    + "</span>\n                <span class=\"screen-reader-text\">"
    + alias4(((helper = (helper = lookupProperty(helpers,"ariaLabel") || (depth0 != null ? lookupProperty(depth0,"ariaLabel") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"ariaLabel","hash":{},"data":data,"loc":{"start":{"line":16,"column":49},"end":{"line":16,"column":62}}}) : helper)))
    + "</span>\n            </label>\n        </div>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"description") : depth0),{"name":"if","hash":{},"fn":container.program(6, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":19,"column":8},"end":{"line":21,"column":15}}})) != null ? stack1 : "");
},"4":function(container,depth0,helpers,partials,data) {
    return "checked";
},"6":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <span class='help-block'>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"description") || (depth0 != null ? lookupProperty(depth0,"description") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"description","hash":{},"data":data,"loc":{"start":{"line":20,"column":33},"end":{"line":20,"column":50}}}) : helper)))
    + "</span>\n";
},"8":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <div>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"label","hash":{},"data":data,"loc":{"start":{"line":23,"column":13},"end":{"line":23,"column":22}}}) : helper)))
    + "</div>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<div class='form-group'>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"title") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":2,"column":4},"end":{"line":4,"column":11}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"editable") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0),"inverse":container.program(8, data, 0),"data":data,"loc":{"start":{"line":5,"column":4},"end":{"line":24,"column":11}}})) != null ? stack1 : "")
    + "</div>\n";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/DateWidget.mustache":
/*!***************************************************!*\
  !*** ./src/widgets/templates/DateWidget.mustache ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <div class='form-group date'>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"label") : depth0),{"name":"if","hash":{},"fn":container.program(2, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":3,"column":4},"end":{"line":18,"column":7}}})) != null ? stack1 : "")
    + "        <input\n            class=\"form-control\"\n                id='"
    + alias4(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":21,"column":20},"end":{"line":21,"column":29}}}) : helper)))
    + "'\n                    name=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"field_name") || (depth0 != null ? lookupProperty(depth0,"field_name") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"field_name","hash":{},"data":data,"loc":{"start":{"line":22,"column":26},"end":{"line":22,"column":42}}}) : helper)))
    + "\"\n                        type=\"date\" "
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"required") : depth0),{"name":"if","hash":{},"fn":container.program(9, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":23,"column":36},"end":{"line":23,"column":67}}})) != null ? stack1 : "")
    + "\n                        value=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"value") || (depth0 != null ? lookupProperty(depth0,"value") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"value","hash":{},"data":data,"loc":{"start":{"line":24,"column":31},"end":{"line":24,"column":40}}}) : helper)))
    + "\" />\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"description") : depth0),{"name":"if","hash":{},"fn":container.program(11, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":25,"column":8},"end":{"line":27,"column":15}}})) != null ? stack1 : "")
    + "    </div>\n";
},"2":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"required") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0),"inverse":container.program(5, data, 0),"data":data,"loc":{"start":{"line":4,"column":1},"end":{"line":8,"column":11}}})) != null ? stack1 : "")
    + "    <svg class=\"error\"><use href=\"/static/icons/icones.svg#exclamation-triangle\"></use></svg>\n    "
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":10,"column":4},"end":{"line":10,"column":13}}}) : helper)))
    + "\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"required") : depth0),{"name":"if","hash":{},"fn":container.program(7, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":11,"column":4},"end":{"line":16,"column":11}}})) != null ? stack1 : "")
    + "</label>\n";
},"3":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<label for=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":5,"column":12},"end":{"line":5,"column":21}}}) : helper)))
    + "\" class=\"required\" title=\"Champ obligatoire\">\n";
},"5":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<label for=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":7,"column":12},"end":{"line":7,"column":21}}}) : helper)))
    + "\">\n";
},"7":function(container,depth0,helpers,partials,data) {
    return "    <span class=\"icon required\">\n        <svg><use href=\"/static/icons/icones.svg#required\"></use></svg>\n        <span><span class=\"screen-reader-text\">Champ</span> Obligatoire</span>\n    </span>\n";
},"9":function(container,depth0,helpers,partials,data) {
    return "required";
},"11":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "        <span class='help-block'>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"description") || (depth0 != null ? lookupProperty(depth0,"description") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"description","hash":{},"data":data,"loc":{"start":{"line":26,"column":33},"end":{"line":26,"column":50}}}) : helper)))
    + "</span>\n";
},"13":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <div class='form-group date'>\n        <span class=\"label\">"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":31,"column":28},"end":{"line":31,"column":37}}}) : helper)))
    + "</span>\n        <span class='form-control data'>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"date") : depth0),{"name":"if","hash":{},"fn":container.program(14, data, 0),"inverse":container.program(16, data, 0),"data":data,"loc":{"start":{"line":33,"column":12},"end":{"line":37,"column":19}}})) != null ? stack1 : "")
    + "        </span>\n    </div>\n";
},"14":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "                "
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"date") || (depth0 != null ? lookupProperty(depth0,"date") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"date","hash":{},"data":data,"loc":{"start":{"line":34,"column":16},"end":{"line":34,"column":26}}}) : helper)))
    + "\n";
},"16":function(container,depth0,helpers,partials,data) {
    return "                <em>Non définie</em>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"editable") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.program(13, data, 0),"data":data,"loc":{"start":{"line":1,"column":0},"end":{"line":40,"column":7}}})) != null ? stack1 : "");
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/DropDownWidget.mustache":
/*!*******************************************************!*\
  !*** ./src/widgets/templates/DropDownWidget.mustache ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    return " only";
},"3":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "&nbsp;"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"label","hash":{},"data":data,"loc":{"start":{"line":9,"column":41},"end":{"line":9,"column":50}}}) : helper)));
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<button \ntype=\"button\"\nclass='btn dropdown-toggle "
    + alias4(((helper = (helper = lookupProperty(helpers,"css") || (depth0 != null ? lookupProperty(depth0,"css") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"css","hash":{},"data":data,"loc":{"start":{"line":3,"column":27},"end":{"line":3,"column":35}}}) : helper)))
    + " icon"
    + ((stack1 = lookupProperty(helpers,"unless").call(alias1,(depth0 != null ? lookupProperty(depth0,"showLabel") : depth0),{"name":"unless","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":3,"column":40},"end":{"line":3,"column":77}}})) != null ? stack1 : "")
    + "' \ntitle='"
    + alias4(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":4,"column":7},"end":{"line":4,"column":18}}}) : helper)))
    + "'\ndata-toggle=\"dropdown\"                                                    \n      aria-haspopup=\"true\"                                                      \n      aria-expanded=\"false\" \n>\n    <icon></icon>"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"showLabel") : depth0),{"name":"if","hash":{},"fn":container.program(3, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":9,"column":17},"end":{"line":9,"column":57}}})) != null ? stack1 : "")
    + "\n    <span class=\"screen-reader-text\">"
    + alias4(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":10,"column":37},"end":{"line":10,"column":48}}}) : helper)))
    + "</span>\n</button>\n<ul></ul>";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/IconWidget.mustache":
/*!***************************************************!*\
  !*** ./src/widgets/templates/IconWidget.mustache ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<svg><use href=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"url") || (depth0 != null ? lookupProperty(depth0,"url") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"url","hash":{},"data":data,"loc":{"start":{"line":1,"column":16},"end":{"line":1,"column":23}}}) : helper)))
    + "\"></use></svg>";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/InputWidget.mustache":
/*!****************************************************!*\
  !*** ./src/widgets/templates/InputWidget.mustache ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"required") : depth0),{"name":"if","hash":{},"fn":container.program(2, data, 0),"inverse":container.program(4, data, 0),"data":data,"loc":{"start":{"line":2,"column":1},"end":{"line":6,"column":11}}})) != null ? stack1 : "")
    + "    <svg class=\"error\"><use href=\"/static/icons/icones.svg#exclamation-triangle\"></use></svg>\n    "
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":8,"column":4},"end":{"line":8,"column":13}}}) : helper)))
    + "\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"required") : depth0),{"name":"if","hash":{},"fn":container.program(6, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":9,"column":4},"end":{"line":14,"column":11}}})) != null ? stack1 : "")
    + "</label>\n";
},"2":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<label for=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":3,"column":12},"end":{"line":3,"column":21}}}) : helper)))
    + "\" class=\"required\" title=\"Champ obligatoire\">\n";
},"4":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<label for=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":5,"column":12},"end":{"line":5,"column":21}}}) : helper)))
    + "\">\n";
},"6":function(container,depth0,helpers,partials,data) {
    return "    <span class=\"icon required\">\n        <svg><use href=\"/static/icons/icones.svg#required\"></use></svg>\n        <span><span class=\"screen-reader-text\">Champ</span> Obligatoire</span>\n    </span> \n";
},"8":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "pattern=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"pattern") || (depth0 != null ? lookupProperty(depth0,"pattern") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"pattern","hash":{},"data":data,"loc":{"start":{"line":25,"column":31},"end":{"line":25,"column":42}}}) : helper)))
    + "\"";
},"10":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "list=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"uniqueId") || (depth0 != null ? lookupProperty(depth0,"uniqueId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"uniqueId","hash":{},"data":data,"loc":{"start":{"line":26,"column":29},"end":{"line":26,"column":41}}}) : helper)))
    + "\"";
},"12":function(container,depth0,helpers,partials,data) {
    return "readonly";
},"14":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<span class='help-block'>"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"description") || (depth0 != null ? lookupProperty(depth0,"description") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"description","hash":{},"data":data,"loc":{"start":{"line":31,"column":25},"end":{"line":31,"column":40}}}) : helper)))
    + "</span>\n";
},"16":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(depth0 != null ? depth0 : (container.nullContext || {}),(depth0 != null ? lookupProperty(depth0,"dataList") : depth0),{"name":"if","hash":{},"fn":container.program(17, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":34,"column":0},"end":{"line":40,"column":7}}})) != null ? stack1 : "");
},"17":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<datalist id=\""
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"uniqueId") || (depth0 != null ? lookupProperty(depth0,"uniqueId") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias1,{"name":"uniqueId","hash":{},"data":data,"loc":{"start":{"line":35,"column":14},"end":{"line":35,"column":28}}}) : helper)))
    + "\">\n"
    + ((stack1 = lookupProperty(helpers,"each").call(alias1,(depth0 != null ? lookupProperty(depth0,"dataList") : depth0),{"name":"each","hash":{},"fn":container.program(18, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":36,"column":4},"end":{"line":38,"column":17}}})) != null ? stack1 : "")
    + "</datalist>\n";
},"18":function(container,depth0,helpers,partials,data) {
    return "    <option value=\""
    + container.escapeExpression(container.lambda(depth0, depth0))
    + "\">\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"label") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":1,"column":0},"end":{"line":16,"column":7}}})) != null ? stack1 : "")
    + "<input\n       id=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":18,"column":11},"end":{"line":18,"column":20}}}) : helper)))
    + "\"\n       class='form-control "
    + alias4(((helper = (helper = lookupProperty(helpers,"css_class") || (depth0 != null ? lookupProperty(depth0,"css_class") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"css_class","hash":{},"data":data,"loc":{"start":{"line":19,"column":27},"end":{"line":19,"column":40}}}) : helper)))
    + "'\n       type='"
    + alias4(((helper = (helper = lookupProperty(helpers,"type") || (depth0 != null ? lookupProperty(depth0,"type") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"type","hash":{},"data":data,"loc":{"start":{"line":20,"column":13},"end":{"line":20,"column":21}}}) : helper)))
    + "'\n       value='"
    + alias4(((helper = (helper = lookupProperty(helpers,"value") || (depth0 != null ? lookupProperty(depth0,"value") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"value","hash":{},"data":data,"loc":{"start":{"line":21,"column":14},"end":{"line":21,"column":23}}}) : helper)))
    + "'\n       name=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"field_name") || (depth0 != null ? lookupProperty(depth0,"field_name") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"field_name","hash":{},"data":data,"loc":{"start":{"line":22,"column":13},"end":{"line":22,"column":27}}}) : helper)))
    + "\"\n       aria-label='"
    + alias4(((helper = (helper = lookupProperty(helpers,"ariaLabel") || (depth0 != null ? lookupProperty(depth0,"ariaLabel") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"ariaLabel","hash":{},"data":data,"loc":{"start":{"line":23,"column":19},"end":{"line":23,"column":32}}}) : helper)))
    + "'\n       placeholder=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"placeholder") || (depth0 != null ? lookupProperty(depth0,"placeholder") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"placeholder","hash":{},"data":data,"loc":{"start":{"line":24,"column":20},"end":{"line":24,"column":35}}}) : helper)))
    + "\"\n       "
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"pattern") : depth0),{"name":"if","hash":{},"fn":container.program(8, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":25,"column":7},"end":{"line":25,"column":50}}})) != null ? stack1 : "")
    + "\n       "
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"dataList") : depth0),{"name":"if","hash":{},"fn":container.program(10, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":26,"column":7},"end":{"line":26,"column":49}}})) != null ? stack1 : "")
    + "\n       "
    + ((stack1 = lookupProperty(helpers,"unless").call(alias1,(depth0 != null ? lookupProperty(depth0,"editable") : depth0),{"name":"unless","hash":{},"fn":container.program(12, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":27,"column":7},"end":{"line":27,"column":46}}})) != null ? stack1 : "")
    + "\n       ></input>\n\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"description") : depth0),{"name":"if","hash":{},"fn":container.program(14, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":30,"column":0},"end":{"line":32,"column":7}}})) != null ? stack1 : "")
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"editable") : depth0),{"name":"if","hash":{},"fn":container.program(16, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":33,"column":0},"end":{"line":41,"column":7}}})) != null ? stack1 : "")
    + "\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"dataList") : depth0),{"name":"if","hash":{},"fn":container.program(17, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":43,"column":0},"end":{"line":49,"column":7}}})) != null ? stack1 : "");
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/LoadingWidget.mustache":
/*!******************************************************!*\
  !*** ./src/widgets/templates/LoadingWidget.mustache ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    return "<svg><use href=\"/static/icons/icones.svg#circle-notch\"></use></svg>";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/POSTButtonWidget.mustache":
/*!*********************************************************!*\
  !*** ./src/widgets/templates/POSTButtonWidget.mustache ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var stack1, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "            <svg><use href=\"/static/icons/icones.svg#"
    + container.escapeExpression(container.lambda(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"icon") : stack1), depth0))
    + "\"></use></svg>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=container.lambda, alias2=container.escapeExpression, alias3=depth0 != null ? depth0 : (container.nullContext || {}), lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<form action=\""
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"url") : stack1), depth0))
    + "\"  method=\"post\" class=\"btn-container\">\n    <input type=\"hidden\" name=\"csrf_token\" value=\""
    + alias2(((helper = (helper = lookupProperty(helpers,"csrf_token") || (depth0 != null ? lookupProperty(depth0,"csrf_token") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(alias3,{"name":"csrf_token","hash":{},"data":data,"loc":{"start":{"line":2,"column":50},"end":{"line":2,"column":66}}}) : helper)))
    + "\" />\n    <button\n        type=\"submit\"\n        class='btn "
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"css") : stack1), depth0))
    + "'\n        title=\""
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"title") : stack1), depth0))
    + "\">\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias3,((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"icon") : stack1),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":7,"column":8},"end":{"line":9,"column":15}}})) != null ? stack1 : "")
    + "        "
    + alias2(alias1(((stack1 = (depth0 != null ? lookupProperty(depth0,"option") : depth0)) != null ? lookupProperty(stack1,"label") : stack1), depth0))
    + "\n    </button>\n</form>\n";
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/PercentInputWidget.mustache":
/*!***********************************************************!*\
  !*** ./src/widgets/templates/PercentInputWidget.mustache ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data) {
    var helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "<label for=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":1,"column":25},"end":{"line":1,"column":34}}}) : helper)))
    + "\">"
    + alias4(((helper = (helper = lookupProperty(helpers,"label") || (depth0 != null ? lookupProperty(depth0,"label") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"label","hash":{},"data":data,"loc":{"start":{"line":1,"column":36},"end":{"line":1,"column":45}}}) : helper)))
    + "</label>";
},"3":function(container,depth0,helpers,partials,data) {
    return "disabled";
},"5":function(container,depth0,helpers,partials,data) {
    var helper, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "    <span class=\"help-block\">"
    + container.escapeExpression(((helper = (helper = lookupProperty(helpers,"description") || (depth0 != null ? lookupProperty(depth0,"description") : depth0)) != null ? helper : container.hooks.helperMissing),(typeof helper === "function" ? helper.call(depth0 != null ? depth0 : (container.nullContext || {}),{"name":"description","hash":{},"data":data,"loc":{"start":{"line":32,"column":29},"end":{"line":32,"column":44}}}) : helper)))
    + "</span>\n";
},"compiler":[8,">= 4.3.0"],"main":function(container,depth0,helpers,partials,data) {
    var stack1, helper, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.hooks.helperMissing, alias3="function", alias4=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"label") : depth0),{"name":"if","hash":{},"fn":container.program(1, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":1,"column":0},"end":{"line":1,"column":60}}})) != null ? stack1 : "")
    + "\n<div class=\"input_range_wrapper\">\n	<input\n		class=\"form-control "
    + alias4(((helper = (helper = lookupProperty(helpers,"css_class") || (depth0 != null ? lookupProperty(depth0,"css_class") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"css_class","hash":{},"data":data,"loc":{"start":{"line":4,"column":22},"end":{"line":4,"column":35}}}) : helper)))
    + "\"\n		type=\"range\"\n		style=\"padding: 0\"\n		value=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"value") || (depth0 != null ? lookupProperty(depth0,"value") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"value","hash":{},"data":data,"loc":{"start":{"line":7,"column":9},"end":{"line":7,"column":18}}}) : helper)))
    + "\"\n		name=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"field_name") || (depth0 != null ? lookupProperty(depth0,"field_name") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"field_name","hash":{},"data":data,"loc":{"start":{"line":8,"column":8},"end":{"line":8,"column":22}}}) : helper)))
    + "\"\n		id=\""
    + alias4(((helper = (helper = lookupProperty(helpers,"tagId") || (depth0 != null ? lookupProperty(depth0,"tagId") : depth0)) != null ? helper : alias2),(typeof helper === alias3 ? helper.call(alias1,{"name":"tagId","hash":{},"data":data,"loc":{"start":{"line":9,"column":6},"end":{"line":9,"column":15}}}) : helper)))
    + "\"\n		min=\"0\" max=\"100\" step=\"10\"\n        "
    + ((stack1 = lookupProperty(helpers,"unless").call(alias1,(depth0 != null ? lookupProperty(depth0,"editable") : depth0),{"name":"unless","hash":{},"fn":container.program(3, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":11,"column":8},"end":{"line":11,"column":47}}})) != null ? stack1 : "")
    + "\n	></input>\n	<div class=\"input_range_ticks\">\n		<span></span>\n		<span></span>\n		<span></span>\n		<span></span>\n		<span></span>\n		<span></span>\n		<span></span>\n		<span></span>\n		<span></span>\n		<span></span>\n	</div>\n	<div class=\"input_range_hint\">\n		<span>0 %</span>\n		<span>50 %</span>\n		<span>100 %</span>\n	</div>\n</div>\n"
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"description") : depth0),{"name":"if","hash":{},"fn":container.program(5, data, 0),"inverse":container.noop,"data":data,"loc":{"start":{"line":31,"column":0},"end":{"line":33,"column":7}}})) != null ? stack1 : "");
},"useData":true});

/***/ }),

/***/ "./src/widgets/templates/RadioChoiceButtonWidget.mustache":
/*!****************************************************************!*\
  !*** ./src/widgets/templates/RadioChoiceButtonWidget.mustache ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Handlebars = __webpack_require__(/*! ../../../node_modules/handlebars/runtime.js */ "./node_modules/handlebars/runtime.js");
function __default(obj) { return obj && (obj.__esModule ? obj["default"] : obj); }
module.exports = (Handlebars["default"] || Handlebars).template({"1":function(container,depth0,helpers,partials,data,blockParams,depths) {
    var stack1, alias1=depth0 != null ? depth0 : (container.nullContext || {}), alias2=container.lambda, alias3=container.escapeExpression, lookupProperty = container.lookupProperty || function(parent, propertyName) {
        if (Object.prototype.hasOwnProperty.call(parent, propertyName)) {
          return parent[propertyName];
        }
        return undefined
    };

  return "		<label \n			title=\""
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 != null ? lookupProperty(depth0,"selected") : depth0),{"name":"if","hash":{},"fn":container.program(2, data, 0, blockParams, depths),"inverse":container.program(4, data, 0, blockParams, depths),"data":data,"loc":{"start":{"line":6,"column":10},"end":{"line":6,"column":91}}})) != null ? stack1 : "")
    + "\" \n			class=\""
    + ((stack1 = lookupProperty(helpers,"if").call(alias1,(depth0 !=