'''
# Amazon SageMaker Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_sagemaker as sagemaker
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for SageMaker construct libraries](https://constructs.dev/search?q=sagemaker)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::SageMaker resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SageMaker.html) directly.

> An experimental construct library for this service is available in preview. Since it is not stable yet, it is distributed
> as a separate package so that you can pin its version independently of the rest of the CDK. See the package:
>
> <span class="package-reference">@aws-cdk/aws-sagemaker-alpha</span>

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::SageMaker](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SageMaker.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/main/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import constructs as _constructs_77d1e7e8
from .. import (
    CfnResource as _CfnResource_9df397a6,
    CfnTag as _CfnTag_f6864754,
    IInspectable as _IInspectable_c2943556,
    IResolvable as _IResolvable_da3f097b,
    TagManager as _TagManager_0a598cb3,
    TreeInspector as _TreeInspector_488e0dd5,
)


@jsii.implements(_IInspectable_c2943556)
class CfnApp(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnApp",
):
    '''A CloudFormation ``AWS::SageMaker::App``.

    Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.

    :cloudformationResource: AWS::SageMaker::App
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_app = sagemaker.CfnApp(self, "MyCfnApp",
            app_name="appName",
            app_type="appType",
            domain_id="domainId",
            user_profile_name="userProfileName",
        
            # the properties below are optional
            resource_spec=sagemaker.CfnApp.ResourceSpecProperty(
                instance_type="instanceType",
                sage_maker_image_arn="sageMakerImageArn",
                sage_maker_image_version_arn="sageMakerImageVersionArn"
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_name: builtins.str,
        app_type: builtins.str,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnApp.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::App``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param app_name: The name of the app.
        :param app_type: The type of app. *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``
        :param domain_id: The domain ID.
        :param user_profile_name: The user profile name.
        :param resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da207547ea530dc451bd8f33c6174b52ddcb5c9c348d4df84894bf6a2e2ada4a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnAppProps(
            app_name=app_name,
            app_type=app_type,
            domain_id=domain_id,
            user_profile_name=user_profile_name,
            resource_spec=resource_spec,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76b99b25d5846497c07368fb764a277782458a65eed58ef9398494227f100421)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed187eab5bee18dd53b1c928d2ccb0e90ab23f4cc25f17ae924a522946f79c87)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrAppArn")
    def attr_app_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the app, such as ``arn:aws:sagemaker:us-west-2:account-id:app/my-app-name`` .

        :cloudformationAttribute: AppArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrAppArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="appName")
    def app_name(self) -> builtins.str:
        '''The name of the app.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-appname
        '''
        return typing.cast(builtins.str, jsii.get(self, "appName"))

    @app_name.setter
    def app_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60338cb684c35adee2166006d8a5799b8774a901f8ecf9c2ac63ee250f468884)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appName", value)

    @builtins.property
    @jsii.member(jsii_name="appType")
    def app_type(self) -> builtins.str:
        '''The type of app.

        *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-apptype
        '''
        return typing.cast(builtins.str, jsii.get(self, "appType"))

    @app_type.setter
    def app_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8050a2337833fa41f2f81b9f4cdfdb20ac505027fde6b3acfde898ba8800a4a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appType", value)

    @builtins.property
    @jsii.member(jsii_name="domainId")
    def domain_id(self) -> builtins.str:
        '''The domain ID.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-domainid
        '''
        return typing.cast(builtins.str, jsii.get(self, "domainId"))

    @domain_id.setter
    def domain_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__563ef9985abcabcd774803749869a87550a085a0ba09908e86c235da523c4d6c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainId", value)

    @builtins.property
    @jsii.member(jsii_name="userProfileName")
    def user_profile_name(self) -> builtins.str:
        '''The user profile name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-userprofilename
        '''
        return typing.cast(builtins.str, jsii.get(self, "userProfileName"))

    @user_profile_name.setter
    def user_profile_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9231045eaa19a04e645ac4427861d86fb43ed510b73c35bda73d525ca58769ab)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "userProfileName", value)

    @builtins.property
    @jsii.member(jsii_name="resourceSpec")
    def resource_spec(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnApp.ResourceSpecProperty"]]:
        '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-resourcespec
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnApp.ResourceSpecProperty"]], jsii.get(self, "resourceSpec"))

    @resource_spec.setter
    def resource_spec(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnApp.ResourceSpecProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41e96c1fc82b070303e88c71e535d7b01017c13f06d3c4baf96523a46c257f09)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceSpec", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnApp.ResourceSpecProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_type": "instanceType",
            "sage_maker_image_arn": "sageMakerImageArn",
            "sage_maker_image_version_arn": "sageMakerImageVersionArn",
        },
    )
    class ResourceSpecProperty:
        def __init__(
            self,
            *,
            instance_type: typing.Optional[builtins.str] = None,
            sage_maker_image_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_version_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :param instance_type: The instance type that the image version runs on. .. epigraph:: *JupyterServer apps* only support the ``system`` value. For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.
            :param sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
            :param sage_maker_image_version_arn: The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                resource_spec_property = sagemaker.CfnApp.ResourceSpecProperty(
                    instance_type="instanceType",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__59e5b32b2186d51d00289fe7e4950d7333bbf83c68ebe92d0bdb2eceb03ed406)
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument sage_maker_image_arn", value=sage_maker_image_arn, expected_type=type_hints["sage_maker_image_arn"])
                check_type(argname="argument sage_maker_image_version_arn", value=sage_maker_image_version_arn, expected_type=type_hints["sage_maker_image_version_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if sage_maker_image_arn is not None:
                self._values["sage_maker_image_arn"] = sage_maker_image_arn
            if sage_maker_image_version_arn is not None:
                self._values["sage_maker_image_version_arn"] = sage_maker_image_version_arn

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The instance type that the image version runs on.

            .. epigraph::

               *JupyterServer apps* only support the ``system`` value.

               For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the SageMaker image that the image version belongs to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimagearn
            '''
            result = self._values.get("sage_maker_image_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_version_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimageversionarn
            '''
            result = self._values.get("sage_maker_image_version_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResourceSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_c2943556)
class CfnAppImageConfig(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig",
):
    '''A CloudFormation ``AWS::SageMaker::AppImageConfig``.

    Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.

    :cloudformationResource: AWS::SageMaker::AppImageConfig
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_app_image_config = sagemaker.CfnAppImageConfig(self, "MyCfnAppImageConfig",
            app_image_config_name="appImageConfigName",
        
            # the properties below are optional
            kernel_gateway_image_config=sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                    name="name",
        
                    # the properties below are optional
                    display_name="displayName"
                )],
        
                # the properties below are optional
                file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                    default_gid=123,
                    default_uid=123,
                    mount_path="mountPath"
                )
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_image_config_name: builtins.str,
        kernel_gateway_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.KernelGatewayImageConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::AppImageConfig``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param app_image_config_name: The name of the AppImageConfig. Must be unique to your account.
        :param kernel_gateway_image_config: The configuration for the file system and kernels in the SageMaker image.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a5bddad57cf4d60d052f199fa18e6d92660d1097d0ea8d783dbde99f9c0a028d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnAppImageConfigProps(
            app_image_config_name=app_image_config_name,
            kernel_gateway_image_config=kernel_gateway_image_config,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bb94facbcc3b4d7b1de5aa9b83ce79e3da77d42eacbb7c16e3363a42398869b)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e215d4a475fe72e90d5dd156e3b19de51b712660dded95424cb42e06752b5395)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrAppImageConfigArn")
    def attr_app_image_config_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the AppImageConfig, such as ``arn:aws:sagemaker:us-west-2:account-id:app-image-config/my-app-image-config-name`` .

        :cloudformationAttribute: AppImageConfigArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrAppImageConfigArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="appImageConfigName")
    def app_image_config_name(self) -> builtins.str:
        '''The name of the AppImageConfig.

        Must be unique to your account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname
        '''
        return typing.cast(builtins.str, jsii.get(self, "appImageConfigName"))

    @app_image_config_name.setter
    def app_image_config_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01fc550542699aeed5dd2d9ae695d23b69d475612dabef44e560292d011f07e0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appImageConfigName", value)

    @builtins.property
    @jsii.member(jsii_name="kernelGatewayImageConfig")
    def kernel_gateway_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelGatewayImageConfigProperty"]]:
        '''The configuration for the file system and kernels in the SageMaker image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelGatewayImageConfigProperty"]], jsii.get(self, "kernelGatewayImageConfig"))

    @kernel_gateway_image_config.setter
    def kernel_gateway_image_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelGatewayImageConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5129d030fcca687bbeeb2006415186516bbfe40d0eb84e4e1b19bda9233d80f0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kernelGatewayImageConfig", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.FileSystemConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "default_gid": "defaultGid",
            "default_uid": "defaultUid",
            "mount_path": "mountPath",
        },
    )
    class FileSystemConfigProperty:
        def __init__(
            self,
            *,
            default_gid: typing.Optional[jsii.Number] = None,
            default_uid: typing.Optional[jsii.Number] = None,
            mount_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.

            :param default_gid: The default POSIX group ID (GID). If not specified, defaults to ``100`` .
            :param default_uid: The default POSIX user ID (UID). If not specified, defaults to ``1000`` .
            :param mount_path: The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                file_system_config_property = sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                    default_gid=123,
                    default_uid=123,
                    mount_path="mountPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1bf5a54cea483597930e2acc9a52917d8d76e77acdbacf9c4d89c223259b37b0)
                check_type(argname="argument default_gid", value=default_gid, expected_type=type_hints["default_gid"])
                check_type(argname="argument default_uid", value=default_uid, expected_type=type_hints["default_uid"])
                check_type(argname="argument mount_path", value=mount_path, expected_type=type_hints["mount_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_gid is not None:
                self._values["default_gid"] = default_gid
            if default_uid is not None:
                self._values["default_uid"] = default_uid
            if mount_path is not None:
                self._values["mount_path"] = mount_path

        @builtins.property
        def default_gid(self) -> typing.Optional[jsii.Number]:
            '''The default POSIX group ID (GID).

            If not specified, defaults to ``100`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultgid
            '''
            result = self._values.get("default_gid")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def default_uid(self) -> typing.Optional[jsii.Number]:
            '''The default POSIX user ID (UID).

            If not specified, defaults to ``1000`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultuid
            '''
            result = self._values.get("default_uid")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def mount_path(self) -> typing.Optional[builtins.str]:
            '''The path within the image to mount the user's EFS home directory.

            The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-mountpath
            '''
            result = self._values.get("mount_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FileSystemConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "kernel_specs": "kernelSpecs",
            "file_system_config": "fileSystemConfig",
        },
    )
    class KernelGatewayImageConfigProperty:
        def __init__(
            self,
            *,
            kernel_specs: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.KernelSpecProperty", typing.Dict[builtins.str, typing.Any]]]]],
            file_system_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnAppImageConfig.FileSystemConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.

            :param kernel_specs: The specification of the Jupyter kernels in the image.
            :param file_system_config: The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                kernel_gateway_image_config_property = sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                    kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                        name="name",
                
                        # the properties below are optional
                        display_name="displayName"
                    )],
                
                    # the properties below are optional
                    file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                        default_gid=123,
                        default_uid=123,
                        mount_path="mountPath"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c86ddd58dc2d271d40ac6b9fe05c0ef722eda13bfa91f644e01a4fc42586ef1e)
                check_type(argname="argument kernel_specs", value=kernel_specs, expected_type=type_hints["kernel_specs"])
                check_type(argname="argument file_system_config", value=file_system_config, expected_type=type_hints["file_system_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "kernel_specs": kernel_specs,
            }
            if file_system_config is not None:
                self._values["file_system_config"] = file_system_config

        @builtins.property
        def kernel_specs(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelSpecProperty"]]]:
            '''The specification of the Jupyter kernels in the image.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-kernelspecs
            '''
            result = self._values.get("kernel_specs")
            assert result is not None, "Required property 'kernel_specs' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.KernelSpecProperty"]]], result)

        @builtins.property
        def file_system_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.FileSystemConfigProperty"]]:
            '''The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-filesystemconfig
            '''
            result = self._values.get("file_system_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnAppImageConfig.FileSystemConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelGatewayImageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelSpecProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "display_name": "displayName"},
    )
    class KernelSpecProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            display_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The specification of a Jupyter kernel.

            :param name: The name of the Jupyter kernel in the image. This value is case sensitive.
            :param display_name: The display name of the kernel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                kernel_spec_property = sagemaker.CfnAppImageConfig.KernelSpecProperty(
                    name="name",
                
                    # the properties below are optional
                    display_name="displayName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ca51ca3546507d1ce51158d74b8fb17c6958c2747cd16f3b75aceb61d2159329)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument display_name", value=display_name, expected_type=type_hints["display_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }
            if display_name is not None:
                self._values["display_name"] = display_name

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the Jupyter kernel in the image.

            This value is case sensitive.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def display_name(self) -> typing.Optional[builtins.str]:
            '''The display name of the kernel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-displayname
            '''
            result = self._values.get("display_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppImageConfigProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_image_config_name": "appImageConfigName",
        "kernel_gateway_image_config": "kernelGatewayImageConfig",
        "tags": "tags",
    },
)
class CfnAppImageConfigProps:
    def __init__(
        self,
        *,
        app_image_config_name: builtins.str,
        kernel_gateway_image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnAppImageConfig.KernelGatewayImageConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnAppImageConfig``.

        :param app_image_config_name: The name of the AppImageConfig. Must be unique to your account.
        :param kernel_gateway_image_config: The configuration for the file system and kernels in the SageMaker image.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_app_image_config_props = sagemaker.CfnAppImageConfigProps(
                app_image_config_name="appImageConfigName",
            
                # the properties below are optional
                kernel_gateway_image_config=sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                    kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                        name="name",
            
                        # the properties below are optional
                        display_name="displayName"
                    )],
            
                    # the properties below are optional
                    file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                        default_gid=123,
                        default_uid=123,
                        mount_path="mountPath"
                    )
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff2672f4d222b0d6bb376871aa42ac2f1c78c70d0a1aa2fd3f19e08fcbb07857)
            check_type(argname="argument app_image_config_name", value=app_image_config_name, expected_type=type_hints["app_image_config_name"])
            check_type(argname="argument kernel_gateway_image_config", value=kernel_gateway_image_config, expected_type=type_hints["kernel_gateway_image_config"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_image_config_name": app_image_config_name,
        }
        if kernel_gateway_image_config is not None:
            self._values["kernel_gateway_image_config"] = kernel_gateway_image_config
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_image_config_name(self) -> builtins.str:
        '''The name of the AppImageConfig.

        Must be unique to your account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname
        '''
        result = self._values.get("app_image_config_name")
        assert result is not None, "Required property 'app_image_config_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def kernel_gateway_image_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.KernelGatewayImageConfigProperty]]:
        '''The configuration for the file system and kernels in the SageMaker image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig
        '''
        result = self._values.get("kernel_gateway_image_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnAppImageConfig.KernelGatewayImageConfigProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAppImageConfigProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnAppProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_name": "appName",
        "app_type": "appType",
        "domain_id": "domainId",
        "user_profile_name": "userProfileName",
        "resource_spec": "resourceSpec",
        "tags": "tags",
    },
)
class CfnAppProps:
    def __init__(
        self,
        *,
        app_name: builtins.str,
        app_type: builtins.str,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnApp.ResourceSpecProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnApp``.

        :param app_name: The name of the app.
        :param app_type: The type of app. *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``
        :param domain_id: The domain ID.
        :param user_profile_name: The user profile name.
        :param resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_app_props = sagemaker.CfnAppProps(
                app_name="appName",
                app_type="appType",
                domain_id="domainId",
                user_profile_name="userProfileName",
            
                # the properties below are optional
                resource_spec=sagemaker.CfnApp.ResourceSpecProperty(
                    instance_type="instanceType",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f03f5ccb1b2c4633c9ef3bee30e7429d047ef909520efe2cbcf88d12287682b)
            check_type(argname="argument app_name", value=app_name, expected_type=type_hints["app_name"])
            check_type(argname="argument app_type", value=app_type, expected_type=type_hints["app_type"])
            check_type(argname="argument domain_id", value=domain_id, expected_type=type_hints["domain_id"])
            check_type(argname="argument user_profile_name", value=user_profile_name, expected_type=type_hints["user_profile_name"])
            check_type(argname="argument resource_spec", value=resource_spec, expected_type=type_hints["resource_spec"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_name": app_name,
            "app_type": app_type,
            "domain_id": domain_id,
            "user_profile_name": user_profile_name,
        }
        if resource_spec is not None:
            self._values["resource_spec"] = resource_spec
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_name(self) -> builtins.str:
        '''The name of the app.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-appname
        '''
        result = self._values.get("app_name")
        assert result is not None, "Required property 'app_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_type(self) -> builtins.str:
        '''The type of app.

        *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-apptype
        '''
        result = self._values.get("app_type")
        assert result is not None, "Required property 'app_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def domain_id(self) -> builtins.str:
        '''The domain ID.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-domainid
        '''
        result = self._values.get("domain_id")
        assert result is not None, "Required property 'domain_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def user_profile_name(self) -> builtins.str:
        '''The user profile name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-userprofilename
        '''
        result = self._values.get("user_profile_name")
        assert result is not None, "Required property 'user_profile_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_spec(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnApp.ResourceSpecProperty]]:
        '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-resourcespec
        '''
        result = self._values.get("resource_spec")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnApp.ResourceSpecProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAppProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnCodeRepository(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnCodeRepository",
):
    '''A CloudFormation ``AWS::SageMaker::CodeRepository``.

    Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.

    The repository can be hosted either in `AWS CodeCommit <https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html>`_ or in any other Git repository.

    :cloudformationResource: AWS::SageMaker::CodeRepository
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_code_repository = sagemaker.CfnCodeRepository(self, "MyCfnCodeRepository",
            git_config=sagemaker.CfnCodeRepository.GitConfigProperty(
                repository_url="repositoryUrl",
        
                # the properties below are optional
                branch="branch",
                secret_arn="secretArn"
            ),
        
            # the properties below are optional
            code_repository_name="codeRepositoryName",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        git_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnCodeRepository.GitConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        code_repository_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::CodeRepository``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param git_config: Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.
        :param code_repository_name: The name of the Git repository.
        :param tags: List of tags for Code Repository.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d17e8e1fa9515a89c3b89e14e1cbaa1aa86352b6f00eb195b7e040e28d143bb)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnCodeRepositoryProps(
            git_config=git_config, code_repository_name=code_repository_name, tags=tags
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bff270252b12354536e07e0adbb6a99f9803ad93f114f8583a39db978a69fa3f)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53e09fd075ed3c77659648b585bc9171f99083a9e3158fb4475a8f9ca5cf3e0a)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCodeRepositoryName")
    def attr_code_repository_name(self) -> builtins.str:
        '''The name of the code repository, such as ``myCodeRepo`` .

        :cloudformationAttribute: CodeRepositoryName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCodeRepositoryName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''List of tags for Code Repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="gitConfig")
    def git_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnCodeRepository.GitConfigProperty"]:
        '''Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnCodeRepository.GitConfigProperty"], jsii.get(self, "gitConfig"))

    @git_config.setter
    def git_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnCodeRepository.GitConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c94bc452a10c6b523d42959d6fd417ef8250361ea0998ca3fe23777c0086fc7d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "gitConfig", value)

    @builtins.property
    @jsii.member(jsii_name="codeRepositoryName")
    def code_repository_name(self) -> typing.Optional[builtins.str]:
        '''The name of the Git repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "codeRepositoryName"))

    @code_repository_name.setter
    def code_repository_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a0e39e1c2d26d01398986983ecd1ad412f11a1b0fcc8519842102d63b6f8dff)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "codeRepositoryName", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnCodeRepository.GitConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "repository_url": "repositoryUrl",
            "branch": "branch",
            "secret_arn": "secretArn",
        },
    )
    class GitConfigProperty:
        def __init__(
            self,
            *,
            repository_url: builtins.str,
            branch: typing.Optional[builtins.str] = None,
            secret_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies configuration details for a Git repository in your AWS account.

            :param repository_url: The URL where the Git repository is located.
            :param branch: The default branch for the Git repository.
            :param secret_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of ``AWSCURRENT`` and must be in the following format: ``{"username": *UserName* , "password": *Password* }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                git_config_property = sagemaker.CfnCodeRepository.GitConfigProperty(
                    repository_url="repositoryUrl",
                
                    # the properties below are optional
                    branch="branch",
                    secret_arn="secretArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7219bf58b36a2496c01c604d8614f6ea1469c9ff3b2619516c61e8e994b4dbe1)
                check_type(argname="argument repository_url", value=repository_url, expected_type=type_hints["repository_url"])
                check_type(argname="argument branch", value=branch, expected_type=type_hints["branch"])
                check_type(argname="argument secret_arn", value=secret_arn, expected_type=type_hints["secret_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_url": repository_url,
            }
            if branch is not None:
                self._values["branch"] = branch
            if secret_arn is not None:
                self._values["secret_arn"] = secret_arn

        @builtins.property
        def repository_url(self) -> builtins.str:
            '''The URL where the Git repository is located.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
            '''
            result = self._values.get("repository_url")
            assert result is not None, "Required property 'repository_url' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def branch(self) -> typing.Optional[builtins.str]:
            '''The default branch for the Git repository.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
            '''
            result = self._values.get("branch")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def secret_arn(self) -> typing.Optional[builtins.str]:
            '''The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository.

            The secret must have a staging label of ``AWSCURRENT`` and must be in the following format:

            ``{"username": *UserName* , "password": *Password* }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
            '''
            result = self._values.get("secret_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GitConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnCodeRepositoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "git_config": "gitConfig",
        "code_repository_name": "codeRepositoryName",
        "tags": "tags",
    },
)
class CfnCodeRepositoryProps:
    def __init__(
        self,
        *,
        git_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnCodeRepository.GitConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        code_repository_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnCodeRepository``.

        :param git_config: Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.
        :param code_repository_name: The name of the Git repository.
        :param tags: List of tags for Code Repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_code_repository_props = sagemaker.CfnCodeRepositoryProps(
                git_config=sagemaker.CfnCodeRepository.GitConfigProperty(
                    repository_url="repositoryUrl",
            
                    # the properties below are optional
                    branch="branch",
                    secret_arn="secretArn"
                ),
            
                # the properties below are optional
                code_repository_name="codeRepositoryName",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c42ae1f0efe0811d1d204114356c2e0129a8f96e7aa17a0078217570e2903e4a)
            check_type(argname="argument git_config", value=git_config, expected_type=type_hints["git_config"])
            check_type(argname="argument code_repository_name", value=code_repository_name, expected_type=type_hints["code_repository_name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "git_config": git_config,
        }
        if code_repository_name is not None:
            self._values["code_repository_name"] = code_repository_name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def git_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnCodeRepository.GitConfigProperty]:
        '''Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
        '''
        result = self._values.get("git_config")
        assert result is not None, "Required property 'git_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnCodeRepository.GitConfigProperty], result)

    @builtins.property
    def code_repository_name(self) -> typing.Optional[builtins.str]:
        '''The name of the Git repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
        '''
        result = self._values.get("code_repository_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''List of tags for Code Repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnCodeRepositoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnDataQualityJobDefinition(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition",
):
    '''A CloudFormation ``AWS::SageMaker::DataQualityJobDefinition``.

    Creates a definition for a job that monitors data quality and drift. For information about model monitor, see `Amazon SageMaker Model Monitor <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html>`_ .

    :cloudformationResource: AWS::SageMaker::DataQualityJobDefinition
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_data_quality_job_definition = sagemaker.CfnDataQualityJobDefinition(self, "MyCfnDataQualityJobDefinition",
            data_quality_app_specification=sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                image_uri="imageUri",
        
                # the properties below are optional
                container_arguments=["containerArguments"],
                container_entrypoint=["containerEntrypoint"],
                environment={
                    "environment_key": "environment"
                },
                post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                record_preprocessor_source_uri="recordPreprocessorSourceUri"
            ),
            data_quality_job_input=sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                            line=False
                        ),
                        parquet=False
                    ),
                    local_path="localPath",
        
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                ),
                endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
        
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            ),
            data_quality_job_output_config=sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )],
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            job_resources=sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
        
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            data_quality_baseline_config=sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                baselining_job_name="baseliningJobName",
                constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                ),
                statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                    s3_uri="s3Uri"
                )
            ),
            endpoint_name="endpointName",
            job_definition_name="jobDefinitionName",
            network_config=sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                enable_inter_container_traffic_encryption=False,
                enable_network_isolation=False,
                vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            ),
            stopping_condition=sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                max_runtime_in_seconds=123
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        data_quality_app_specification: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty", typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_input: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DataQualityJobInputProperty", typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_output_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.MonitoringOutputConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        job_resources: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.MonitoringResourcesProperty", typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        data_quality_baseline_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        network_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.NetworkConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        stopping_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.StoppingConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::DataQualityJobDefinition``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param data_quality_app_specification: Specifies the container that runs the monitoring job.
        :param data_quality_job_input: A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
        :param data_quality_job_output_config: The output configuration for monitoring jobs.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param data_quality_baseline_config: Configures the constraints and baselines for the monitoring job.
        :param endpoint_name: ``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.
        :param job_definition_name: The name for the monitoring job definition.
        :param network_config: Specifies networking configuration for the monitoring job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__738872af4917cc4a9c82bf05685c5bae3f1ac28542f97be97fe1f36cb1ba9f22)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDataQualityJobDefinitionProps(
            data_quality_app_specification=data_quality_app_specification,
            data_quality_job_input=data_quality_job_input,
            data_quality_job_output_config=data_quality_job_output_config,
            job_resources=job_resources,
            role_arn=role_arn,
            data_quality_baseline_config=data_quality_baseline_config,
            endpoint_name=endpoint_name,
            job_definition_name=job_definition_name,
            network_config=network_config,
            stopping_condition=stopping_condition,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f462bdc067fd44e78f92476e1454a553345a32c03985c226bd6553e4c637284a)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f21a6d8efc59d5475d29ea3eb6cb20caf535aef455944b20e340244406959398)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the job definition was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrJobDefinitionArn")
    def attr_job_definition_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the job definition.

        :cloudformationAttribute: JobDefinitionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrJobDefinitionArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="dataQualityAppSpecification")
    def data_quality_app_specification(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty"]:
        '''Specifies the container that runs the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty"], jsii.get(self, "dataQualityAppSpecification"))

    @data_quality_app_specification.setter
    def data_quality_app_specification(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d33a45fcf08092c0e108f025d8d4a4fc5872cb335e89ddc1f1c94f4d59bb502)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityAppSpecification", value)

    @builtins.property
    @jsii.member(jsii_name="dataQualityJobInput")
    def data_quality_job_input(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityJobInputProperty"]:
        '''A list of inputs for the monitoring job.

        Currently endpoints are supported as monitoring inputs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityJobInputProperty"], jsii.get(self, "dataQualityJobInput"))

    @data_quality_job_input.setter
    def data_quality_job_input(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityJobInputProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22c7862ad92959194cfe02be5360375cb1cd67676ced8e0d0b87e7822af6ebde)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityJobInput", value)

    @builtins.property
    @jsii.member(jsii_name="dataQualityJobOutputConfig")
    def data_quality_job_output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputConfigProperty"]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputConfigProperty"], jsii.get(self, "dataQualityJobOutputConfig"))

    @data_quality_job_output_config.setter
    def data_quality_job_output_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d029ecdfc6dcdfc0f1c62dff2897f3cb8d337d35dfcd0f36aa375a458bfcae9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityJobOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="jobResources")
    def job_resources(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringResourcesProperty"]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringResourcesProperty"], jsii.get(self, "jobResources"))

    @job_resources.setter
    def job_resources(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringResourcesProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29ff9c2764c492630d1c5cc10ba5a43a5f0e949dfc7672232a6858b4fc679c55)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobResources", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9f4267c53b0d493df8356e7f07d5aa41c917ddcfb48583b5137a53da86f4c13)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="dataQualityBaselineConfig")
    def data_quality_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty"]]:
        '''Configures the constraints and baselines for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty"]], jsii.get(self, "dataQualityBaselineConfig"))

    @data_quality_baseline_config.setter
    def data_quality_baseline_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc8e3f65489594e046239891fcc106cf785fdad2448a7b413159063d4ec2baad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityBaselineConfig", value)

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-endpointname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2370e87925965d970102cac6226c13f49a0241b622030c01b2780bcb34a8ec19)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="jobDefinitionName")
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name for the monitoring job definition.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "jobDefinitionName"))

    @job_definition_name.setter
    def job_definition_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e482152aafd0979a35f29bc7cd47814ad3977ddb15a34b7c02c4b274ed8aea23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobDefinitionName", value)

    @builtins.property
    @jsii.member(jsii_name="networkConfig")
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.NetworkConfigProperty"]]:
        '''Specifies networking configuration for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.NetworkConfigProperty"]], jsii.get(self, "networkConfig"))

    @network_config.setter
    def network_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.NetworkConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5982fc49bfb59c2f83b476c77c84ae4a4e929f10dd2181018054a285dee2e87d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "networkConfig", value)

    @builtins.property
    @jsii.member(jsii_name="stoppingCondition")
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StoppingConditionProperty"]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StoppingConditionProperty"]], jsii.get(self, "stoppingCondition"))

    @stopping_condition.setter
    def stopping_condition(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StoppingConditionProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf7fbe101220056322d4ff1986d7e71874aee8887d658ccaa569c5000edefac0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stoppingCondition", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_captured_destination_s3_uri": "dataCapturedDestinationS3Uri",
            "dataset_format": "datasetFormat",
            "local_path": "localPath",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class BatchTransformInputProperty:
        def __init__(
            self,
            *,
            data_captured_destination_s3_uri: builtins.str,
            dataset_format: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.DatasetFormatProperty", typing.Dict[builtins.str, typing.Any]]],
            local_path: builtins.str,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param data_captured_destination_s3_uri: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.
            :param dataset_format: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.DatasetFormat``.
            :param local_path: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.LocalPath``.
            :param s3_data_distribution_type: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.
            :param s3_input_mode: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                batch_transform_input_property = sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                            line=False
                        ),
                        parquet=False
                    ),
                    local_path="localPath",
                
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1b75b7b728f069893458a7695ee7ac0853bd8e23efc061ecf9829ddbd3a6dbdd)
                check_type(argname="argument data_captured_destination_s3_uri", value=data_captured_destination_s3_uri, expected_type=type_hints["data_captured_destination_s3_uri"])
                check_type(argname="argument dataset_format", value=dataset_format, expected_type=type_hints["dataset_format"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_captured_destination_s3_uri": data_captured_destination_s3_uri,
                "dataset_format": dataset_format,
                "local_path": local_path,
            }
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def data_captured_destination_s3_uri(self) -> builtins.str:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-datacaptureddestinations3uri
            '''
            result = self._values.get("data_captured_destination_s3_uri")
            assert result is not None, "Required property 'data_captured_destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def dataset_format(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DatasetFormatProperty"]:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.DatasetFormat``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-datasetformat
            '''
            result = self._values.get("dataset_format")
            assert result is not None, "Required property 'dataset_format' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.DatasetFormatProperty"], result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.LocalPath``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BatchTransformInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_count": "instanceCount",
            "instance_type": "instanceType",
            "volume_size_in_gb": "volumeSizeInGb",
            "volume_kms_key_id": "volumeKmsKeyId",
        },
    )
    class ClusterConfigProperty:
        def __init__(
            self,
            *,
            instance_count: jsii.Number,
            instance_type: builtins.str,
            volume_size_in_gb: jsii.Number,
            volume_kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for the cluster of resources used to run the processing job.

            :param instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
            :param instance_type: The ML compute instance type for the processing job.
            :param volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
            :param volume_kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_config_property = sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
                
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__441576a0f27acb41558fd46f071ce526510ec72480da00f75773b2a12013485c)
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
                check_type(argname="argument volume_kms_key_id", value=volume_kms_key_id, expected_type=type_hints["volume_kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "instance_count": instance_count,
                "instance_type": instance_type,
                "volume_size_in_gb": volume_size_in_gb,
            }
            if volume_kms_key_id is not None:
                self._values["volume_kms_key_id"] = volume_kms_key_id

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of ML compute instances to use in the model monitoring job.

            For distributed processing jobs, specify a value greater than 1. The default value is 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The ML compute instance type for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def volume_size_in_gb(self) -> jsii.Number:
            '''The size of the ML storage volume, in gigabytes, that you want to provision.

            You must specify sufficient ML storage for your scenario.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            assert result is not None, "Required property 'volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def volume_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumekmskeyid
            '''
            result = self._values.get("volume_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class ConstraintsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The constraints resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                constraints_resource_property = sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8248581daf5496221148b44514fed0064c1ab304d2086bed4146fdcb2aad1058)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html#cfn-sagemaker-dataqualityjobdefinition-constraintsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConstraintsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.CsvProperty",
        jsii_struct_bases=[],
        name_mapping={"header": "header"},
    )
    class CsvProperty:
        def __init__(
            self,
            *,
            header: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param header: ``CfnDataQualityJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-csv.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                csv_property = sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                    header=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6ee6b0eb617419663b4b8b32dff8e00b1f826734909bcd7b71edd3ae47218cec)
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if header is not None:
                self._values["header"] = header

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnDataQualityJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-csv.html#cfn-sagemaker-dataqualityjobdefinition-csv-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CsvProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "image_uri": "imageUri",
            "container_arguments": "containerArguments",
            "container_entrypoint": "containerEntrypoint",
            "environment": "environment",
            "post_analytics_processor_source_uri": "postAnalyticsProcessorSourceUri",
            "record_preprocessor_source_uri": "recordPreprocessorSourceUri",
        },
    )
    class DataQualityAppSpecificationProperty:
        def __init__(
            self,
            *,
            image_uri: builtins.str,
            container_arguments: typing.Optional[typing.Sequence[builtins.str]] = None,
            container_entrypoint: typing.Optional[typing.Sequence[builtins.str]] = None,
            environment: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]] = None,
            post_analytics_processor_source_uri: typing.Optional[builtins.str] = None,
            record_preprocessor_source_uri: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information about the container that a data quality monitoring job runs.

            :param image_uri: The container image that the data quality monitoring job runs.
            :param container_arguments: The arguments to send to the container that the monitoring job runs.
            :param container_entrypoint: The entrypoint for a container used to run a monitoring job.
            :param environment: Sets the environment variables in the container that the monitoring job runs.
            :param post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
            :param record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_quality_app_specification_property = sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                    image_uri="imageUri",
                
                    # the properties below are optional
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    environment={
                        "environment_key": "environment"
                    },
                    post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                    record_preprocessor_source_uri="recordPreprocessorSourceUri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__11ad7b07799b19e9d0c959ac5d51f2235fe7a36d54964df0e345ae8688d19922)
                check_type(argname="argument image_uri", value=image_uri, expected_type=type_hints["image_uri"])
                check_type(argname="argument container_arguments", value=container_arguments, expected_type=type_hints["container_arguments"])
                check_type(argname="argument container_entrypoint", value=container_entrypoint, expected_type=type_hints["container_entrypoint"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
                check_type(argname="argument post_analytics_processor_source_uri", value=post_analytics_processor_source_uri, expected_type=type_hints["post_analytics_processor_source_uri"])
                check_type(argname="argument record_preprocessor_source_uri", value=record_preprocessor_source_uri, expected_type=type_hints["record_preprocessor_source_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "image_uri": image_uri,
            }
            if container_arguments is not None:
                self._values["container_arguments"] = container_arguments
            if container_entrypoint is not None:
                self._values["container_entrypoint"] = container_entrypoint
            if environment is not None:
                self._values["environment"] = environment
            if post_analytics_processor_source_uri is not None:
                self._values["post_analytics_processor_source_uri"] = post_analytics_processor_source_uri
            if record_preprocessor_source_uri is not None:
                self._values["record_preprocessor_source_uri"] = record_preprocessor_source_uri

        @builtins.property
        def image_uri(self) -> builtins.str:
            '''The container image that the data quality monitoring job runs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-imageuri
            '''
            result = self._values.get("image_uri")
            assert result is not None, "Required property 'image_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def container_arguments(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The arguments to send to the container that the monitoring job runs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerarguments
            '''
            result = self._values.get("container_arguments")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def container_entrypoint(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The entrypoint for a container used to run a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerentrypoint
            '''
            result = self._values.get("container_entrypoint")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def environment(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]]:
            '''Sets the environment variables in the container that the monitoring job runs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]], result)

        @builtins.property
        def post_analytics_processor_source_uri(self) -> typing.Optional[builtins.str]:
            '''An Amazon S3 URI to a script that is called after analysis has been performed.

            Applicable only for the built-in (first party) containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-postanalyticsprocessorsourceuri
            '''
            result = self._values.get("post_analytics_processor_source_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def record_preprocessor_source_uri(self) -> typing.Optional[builtins.str]:
            '''An Amazon S3 URI to a script that is called per row prior to running analysis.

            It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-recordpreprocessorsourceuri
            '''
            result = self._values.get("record_preprocessor_source_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityAppSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "baselining_job_name": "baseliningJobName",
            "constraints_resource": "constraintsResource",
            "statistics_resource": "statisticsResource",
        },
    )
    class DataQualityBaselineConfigProperty:
        def __init__(
            self,
            *,
            baselining_job_name: typing.Optional[builtins.str] = None,
            constraints_resource: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.ConstraintsResourceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            statistics_resource: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.StatisticsResourceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Configuration for monitoring constraints and monitoring statistics.

            These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :param baselining_job_name: The name of the job that performs baselining for the data quality monitoring job.
            :param constraints_resource: The constraints resource for a monitoring job.
            :param statistics_resource: Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_quality_baseline_config_property = sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    ),
                    statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                        s3_uri="s3Uri"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b3e1d4034764e8a8282c558559d3c93f2a5f23a1c1e5af323dec1e81a3e53562)
                check_type(argname="argument baselining_job_name", value=baselining_job_name, expected_type=type_hints["baselining_job_name"])
                check_type(argname="argument constraints_resource", value=constraints_resource, expected_type=type_hints["constraints_resource"])
                check_type(argname="argument statistics_resource", value=statistics_resource, expected_type=type_hints["statistics_resource"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if baselining_job_name is not None:
                self._values["baselining_job_name"] = baselining_job_name
            if constraints_resource is not None:
                self._values["constraints_resource"] = constraints_resource
            if statistics_resource is not None:
                self._values["statistics_resource"] = statistics_resource

        @builtins.property
        def baselining_job_name(self) -> typing.Optional[builtins.str]:
            '''The name of the job that performs baselining for the data quality monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-baseliningjobname
            '''
            result = self._values.get("baselining_job_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def constraints_resource(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ConstraintsResourceProperty"]]:
            '''The constraints resource for a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-constraintsresource
            '''
            result = self._values.get("constraints_resource")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ConstraintsResourceProperty"]], result)

        @builtins.property
        def statistics_resource(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StatisticsResourceProperty"]]:
            '''Configuration for monitoring constraints and monitoring statistics.

            These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-statisticsresource
            '''
            result = self._values.get("statistics_resource")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.StatisticsResourceProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "batch_transform_input": "batchTransformInput",
            "endpoint_input": "endpointInput",
        },
    )
    class DataQualityJobInputProperty:
        def __init__(
            self,
            *,
            batch_transform_input: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.BatchTransformInputProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            endpoint_input: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.EndpointInputProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The input for the data quality monitoring job.

            Currently endpoints are supported for input.

            :param batch_transform_input: ``CfnDataQualityJobDefinition.DataQualityJobInputProperty.BatchTransformInput``.
            :param endpoint_input: Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_quality_job_input_property = sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                    batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                                line=False
                            ),
                            parquet=False
                        ),
                        local_path="localPath",
                
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
                
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__544455777165b176b920249188ba86b340ed4f77e4675683ab1522af2f4badf1)
                check_type(argname="argument batch_transform_input", value=batch_transform_input, expected_type=type_hints["batch_transform_input"])
                check_type(argname="argument endpoint_input", value=endpoint_input, expected_type=type_hints["endpoint_input"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if batch_transform_input is not None:
                self._values["batch_transform_input"] = batch_transform_input
            if endpoint_input is not None:
                self._values["endpoint_input"] = endpoint_input

        @builtins.property
        def batch_transform_input(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.BatchTransformInputProperty"]]:
            '''``CfnDataQualityJobDefinition.DataQualityJobInputProperty.BatchTransformInput``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-batchtransforminput
            '''
            result = self._values.get("batch_transform_input")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.BatchTransformInputProperty"]], result)

        @builtins.property
        def endpoint_input(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.EndpointInputProperty"]]:
            '''Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-endpointinput
            '''
            result = self._values.get("endpoint_input")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.EndpointInputProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityJobInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty",
        jsii_struct_bases=[],
        name_mapping={"csv": "csv", "json": "json", "parquet": "parquet"},
    )
    class DatasetFormatProperty:
        def __init__(
            self,
            *,
            csv: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.CsvProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.JsonProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            parquet: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param csv: ``CfnDataQualityJobDefinition.DatasetFormatProperty.Csv``.
            :param json: ``CfnDataQualityJobDefinition.DatasetFormatProperty.Json``.
            :param parquet: ``CfnDataQualityJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                dataset_format_property = sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                    csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                        header=False
                    ),
                    json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                        line=False
                    ),
                    parquet=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__72b55db1656fb2bcc5633e486da62737a3f6d508f0d82b1ddd27a348b79b925b)
                check_type(argname="argument csv", value=csv, expected_type=type_hints["csv"])
                check_type(argname="argument json", value=json, expected_type=type_hints["json"])
                check_type(argname="argument parquet", value=parquet, expected_type=type_hints["parquet"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv is not None:
                self._values["csv"] = csv
            if json is not None:
                self._values["json"] = json
            if parquet is not None:
                self._values["parquet"] = parquet

        @builtins.property
        def csv(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.CsvProperty"]]:
            '''``CfnDataQualityJobDefinition.DatasetFormatProperty.Csv``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-csv
            '''
            result = self._values.get("csv")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.CsvProperty"]], result)

        @builtins.property
        def json(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.JsonProperty"]]:
            '''``CfnDataQualityJobDefinition.DatasetFormatProperty.Json``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-json
            '''
            result = self._values.get("json")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.JsonProperty"]], result)

        @builtins.property
        def parquet(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnDataQualityJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-parquet
            '''
            result = self._values.get("parquet")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DatasetFormatProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "endpoint_name": "endpointName",
            "local_path": "localPath",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class EndpointInputProperty:
        def __init__(
            self,
            *,
            endpoint_name: builtins.str,
            local_path: builtins.str,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Input object for the endpoint.

            :param endpoint_name: An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.
            :param local_path: Path to the filesystem where the endpoint data is available to the container.
            :param s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to ``FullyReplicated``
            :param s3_input_mode: Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job. ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                endpoint_input_property = sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
                
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__601305c78964ecde31263e255b74c778af52df31d8ef7cb4dd0eb2d3a6c28583)
                check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "endpoint_name": endpoint_name,
                "local_path": local_path,
            }
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def endpoint_name(self) -> builtins.str:
            '''An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-endpointname
            '''
            result = self._values.get("endpoint_name")
            assert result is not None, "Required property 'endpoint_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''Path to the filesystem where the endpoint data is available to the container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.

            Defaults to ``FullyReplicated``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job.

            ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.JsonProperty",
        jsii_struct_bases=[],
        name_mapping={"line": "line"},
    )
    class JsonProperty:
        def __init__(
            self,
            *,
            line: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param line: ``CfnDataQualityJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-json.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                json_property = sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                    line=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bbb228f2cc450802d77014c5761cf088476cfb96cca3c0ba2a6970015dab083b)
                check_type(argname="argument line", value=line, expected_type=type_hints["line"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if line is not None:
                self._values["line"] = line

        @builtins.property
        def line(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnDataQualityJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-json.html#cfn-sagemaker-dataqualityjobdefinition-json-line
            '''
            result = self._values.get("line")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "monitoring_outputs": "monitoringOutputs",
            "kms_key_id": "kmsKeyId",
        },
    )
    class MonitoringOutputConfigProperty:
        def __init__(
            self,
            *,
            monitoring_outputs: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.MonitoringOutputProperty", typing.Dict[builtins.str, typing.Any]]]]],
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for monitoring jobs.

            :param monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_output_config_property = sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
                
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__27ce8c4b0ff4f56b1642e027e445fa857c7e78618882f3465132c214aa3cefcd)
                check_type(argname="argument monitoring_outputs", value=monitoring_outputs, expected_type=type_hints["monitoring_outputs"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "monitoring_outputs": monitoring_outputs,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def monitoring_outputs(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputProperty"]]]:
            '''Monitoring outputs for monitoring jobs.

            This is where the output of the periodic monitoring jobs is uploaded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-monitoringoutputs
            '''
            result = self._values.get("monitoring_outputs")
            assert result is not None, "Required property 'monitoring_outputs' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.MonitoringOutputProperty"]]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_output": "s3Output"},
    )
    class MonitoringOutputProperty:
        def __init__(
            self,
            *,
            s3_output: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.S3OutputProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The output object for a monitoring job.

            :param s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_output_property = sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__69c3b9716a30dd2e2aa8080d1792409d731b5674fbcbefd12fc5bc52de21eb03)
                check_type(argname="argument s3_output", value=s3_output, expected_type=type_hints["s3_output"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output": s3_output,
            }

        @builtins.property
        def s3_output(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.S3OutputProperty"]:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutput-s3output
            '''
            result = self._values.get("s3_output")
            assert result is not None, "Required property 's3_output' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.S3OutputProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_config": "clusterConfig"},
    )
    class MonitoringResourcesProperty:
        def __init__(
            self,
            *,
            cluster_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.ClusterConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''Identifies the resources to deploy for a monitoring job.

            :param cluster_config: The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_resources_property = sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
                
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__11b009463e27499e4088d4a4ff3eb32ac79a74cb796077eccef622663c7e78e1)
                check_type(argname="argument cluster_config", value=cluster_config, expected_type=type_hints["cluster_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cluster_config": cluster_config,
            }

        @builtins.property
        def cluster_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ClusterConfigProperty"]:
            '''The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html#cfn-sagemaker-dataqualityjobdefinition-monitoringresources-clusterconfig
            '''
            result = self._values.get("cluster_config")
            assert result is not None, "Required property 'cluster_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.ClusterConfigProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringResourcesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_inter_container_traffic_encryption": "enableInterContainerTrafficEncryption",
            "enable_network_isolation": "enableNetworkIsolation",
            "vpc_config": "vpcConfig",
        },
    )
    class NetworkConfigProperty:
        def __init__(
            self,
            *,
            enable_inter_container_traffic_encryption: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDataQualityJobDefinition.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.

            :param enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
            :param enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
            :param vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                network_config_property = sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__80502177a4e5c8957484568926e21dfce6f3cab0e6313a34ee6bafac1ac94de4)
                check_type(argname="argument enable_inter_container_traffic_encryption", value=enable_inter_container_traffic_encryption, expected_type=type_hints["enable_inter_container_traffic_encryption"])
                check_type(argname="argument enable_network_isolation", value=enable_network_isolation, expected_type=type_hints["enable_network_isolation"])
                check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_inter_container_traffic_encryption is not None:
                self._values["enable_inter_container_traffic_encryption"] = enable_inter_container_traffic_encryption
            if enable_network_isolation is not None:
                self._values["enable_network_isolation"] = enable_network_isolation
            if vpc_config is not None:
                self._values["vpc_config"] = vpc_config

        @builtins.property
        def enable_inter_container_traffic_encryption(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Whether to encrypt all communications between distributed processing jobs.

            Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enableintercontainertrafficencryption
            '''
            result = self._values.get("enable_inter_container_traffic_encryption")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def enable_network_isolation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Whether to allow inbound and outbound network calls to and from the containers used for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enablenetworkisolation
            '''
            result = self._values.get("enable_network_isolation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def vpc_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.VpcConfigProperty"]]:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-vpcconfig
            '''
            result = self._values.get("vpc_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDataQualityJobDefinition.VpcConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.S3OutputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "local_path": "localPath",
            "s3_uri": "s3Uri",
            "s3_upload_mode": "s3UploadMode",
        },
    )
    class S3OutputProperty:
        def __init__(
            self,
            *,
            local_path: builtins.str,
            s3_uri: builtins.str,
            s3_upload_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :param local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
            :param s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
            :param s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                s3_output_property = sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                    local_path="localPath",
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    s3_upload_mode="s3UploadMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c76b13f2c22215a02261c3002c67bac19ddd708df4133a02db04cf014d82159e)
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument s3_upload_mode", value=s3_upload_mode, expected_type=type_hints["s3_upload_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "local_path": local_path,
                "s3_uri": s3_uri,
            }
            if s3_upload_mode is not None:
                self._values["s3_upload_mode"] = s3_upload_mode

        @builtins.property
        def local_path(self) -> builtins.str:
            '''The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            LocalPath is an absolute path for the output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_upload_mode(self) -> typing.Optional[builtins.str]:
            '''Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uploadmode
            '''
            result = self._values.get("s3_upload_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3OutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class StatisticsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The statistics resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the statistics resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                statistics_resource_property = sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e66a7ef5687cec2b47261b154bc007b591d204014d7afbc2b5d0700f91efa565)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the statistics resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html#cfn-sagemaker-dataqualityjobdefinition-statisticsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StatisticsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"max_runtime_in_seconds": "maxRuntimeInSeconds"},
    )
    class StoppingConditionProperty:
        def __init__(self, *, max_runtime_in_seconds: jsii.Number) -> None:
            '''Specifies a limit to how long a model training job or model compilation job can run.

            It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.

            To stop a training job, SageMaker sends the algorithm the ``SIGTERM`` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.

            The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with ``CreateModel`` .
            .. epigraph::

               The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.

            :param max_runtime_in_seconds: The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model. For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days. The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                stopping_condition_property = sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__080294505eaa0cfd3e651708dd9939428c82dd4a6df3e6ba24e70b042595bfc5)
                check_type(argname="argument max_runtime_in_seconds", value=max_runtime_in_seconds, expected_type=type_hints["max_runtime_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_runtime_in_seconds": max_runtime_in_seconds,
            }

        @builtins.property
        def max_runtime_in_seconds(self) -> jsii.Number:
            '''The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.

            For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.

            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.

            The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition-maxruntimeinseconds
            '''
            result = self._values.get("max_runtime_in_seconds")
            assert result is not None, "Required property 'max_runtime_in_seconds' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StoppingConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Training Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9271b40223b97a4908066b16c9660259e46e7b1d4d693d3a2df71e4d8c31a21f)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form sg-xxxxxxxx.

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDataQualityJobDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={
        "data_quality_app_specification": "dataQualityAppSpecification",
        "data_quality_job_input": "dataQualityJobInput",
        "data_quality_job_output_config": "dataQualityJobOutputConfig",
        "job_resources": "jobResources",
        "role_arn": "roleArn",
        "data_quality_baseline_config": "dataQualityBaselineConfig",
        "endpoint_name": "endpointName",
        "job_definition_name": "jobDefinitionName",
        "network_config": "networkConfig",
        "stopping_condition": "stoppingCondition",
        "tags": "tags",
    },
)
class CfnDataQualityJobDefinitionProps:
    def __init__(
        self,
        *,
        data_quality_app_specification: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty, typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_input: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.DataQualityJobInputProperty, typing.Dict[builtins.str, typing.Any]]],
        data_quality_job_output_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.MonitoringOutputConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        job_resources: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.MonitoringResourcesProperty, typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        data_quality_baseline_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        network_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.NetworkConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        stopping_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDataQualityJobDefinition.StoppingConditionProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDataQualityJobDefinition``.

        :param data_quality_app_specification: Specifies the container that runs the monitoring job.
        :param data_quality_job_input: A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
        :param data_quality_job_output_config: The output configuration for monitoring jobs.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param data_quality_baseline_config: Configures the constraints and baselines for the monitoring job.
        :param endpoint_name: ``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.
        :param job_definition_name: The name for the monitoring job definition.
        :param network_config: Specifies networking configuration for the monitoring job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_data_quality_job_definition_props = sagemaker.CfnDataQualityJobDefinitionProps(
                data_quality_app_specification=sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                    image_uri="imageUri",
            
                    # the properties below are optional
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    environment={
                        "environment_key": "environment"
                    },
                    post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                    record_preprocessor_source_uri="recordPreprocessorSourceUri"
                ),
                data_quality_job_input=sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                    batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                                line=False
                            ),
                            parquet=False
                        ),
                        local_path="localPath",
            
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
            
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                ),
                data_quality_job_output_config=sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
            
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                job_resources=sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
            
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                data_quality_baseline_config=sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    ),
                    statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                        s3_uri="s3Uri"
                    )
                ),
                endpoint_name="endpointName",
                job_definition_name="jobDefinitionName",
                network_config=sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                ),
                stopping_condition=sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c5a27da69d6cdc76cfa83b348321ea97cb5023c0191ac16e8ba03f2ab76dac6)
            check_type(argname="argument data_quality_app_specification", value=data_quality_app_specification, expected_type=type_hints["data_quality_app_specification"])
            check_type(argname="argument data_quality_job_input", value=data_quality_job_input, expected_type=type_hints["data_quality_job_input"])
            check_type(argname="argument data_quality_job_output_config", value=data_quality_job_output_config, expected_type=type_hints["data_quality_job_output_config"])
            check_type(argname="argument job_resources", value=job_resources, expected_type=type_hints["job_resources"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument data_quality_baseline_config", value=data_quality_baseline_config, expected_type=type_hints["data_quality_baseline_config"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument job_definition_name", value=job_definition_name, expected_type=type_hints["job_definition_name"])
            check_type(argname="argument network_config", value=network_config, expected_type=type_hints["network_config"])
            check_type(argname="argument stopping_condition", value=stopping_condition, expected_type=type_hints["stopping_condition"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data_quality_app_specification": data_quality_app_specification,
            "data_quality_job_input": data_quality_job_input,
            "data_quality_job_output_config": data_quality_job_output_config,
            "job_resources": job_resources,
            "role_arn": role_arn,
        }
        if data_quality_baseline_config is not None:
            self._values["data_quality_baseline_config"] = data_quality_baseline_config
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if job_definition_name is not None:
            self._values["job_definition_name"] = job_definition_name
        if network_config is not None:
            self._values["network_config"] = network_config
        if stopping_condition is not None:
            self._values["stopping_condition"] = stopping_condition
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def data_quality_app_specification(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty]:
        '''Specifies the container that runs the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
        '''
        result = self._values.get("data_quality_app_specification")
        assert result is not None, "Required property 'data_quality_app_specification' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty], result)

    @builtins.property
    def data_quality_job_input(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityJobInputProperty]:
        '''A list of inputs for the monitoring job.

        Currently endpoints are supported as monitoring inputs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
        '''
        result = self._values.get("data_quality_job_input")
        assert result is not None, "Required property 'data_quality_job_input' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityJobInputProperty], result)

    @builtins.property
    def data_quality_job_output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringOutputConfigProperty]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
        '''
        result = self._values.get("data_quality_job_output_config")
        assert result is not None, "Required property 'data_quality_job_output_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringOutputConfigProperty], result)

    @builtins.property
    def job_resources(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringResourcesProperty]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
        '''
        result = self._values.get("job_resources")
        assert result is not None, "Required property 'job_resources' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.MonitoringResourcesProperty], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def data_quality_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty]]:
        '''Configures the constraints and baselines for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
        '''
        result = self._values.get("data_quality_baseline_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty]], result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name for the monitoring job definition.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
        '''
        result = self._values.get("job_definition_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.NetworkConfigProperty]]:
        '''Specifies networking configuration for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
        '''
        result = self._values.get("network_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.NetworkConfigProperty]], result)

    @builtins.property
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.StoppingConditionProperty]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
        '''
        result = self._values.get("stopping_condition")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDataQualityJobDefinition.StoppingConditionProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDataQualityJobDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnDevice(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDevice",
):
    '''A CloudFormation ``AWS::SageMaker::Device``.

    The ``AWS::SageMaker::Device`` resource is an Amazon SageMaker resource type that allows you to register your Devices against an existing SageMaker Edge Manager DeviceFleet. Each device must be listed individually in the CFN specification.

    :cloudformationResource: AWS::SageMaker::Device
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_device = sagemaker.CfnDevice(self, "MyCfnDevice",
            device_fleet_name="deviceFleetName",
        
            # the properties below are optional
            device=sagemaker.CfnDevice.DeviceProperty(
                device_name="deviceName",
        
                # the properties below are optional
                description="description",
                iot_thing_name="iotThingName"
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        device_fleet_name: builtins.str,
        device: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDevice.DeviceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Device``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param device_fleet_name: The name of the fleet the device belongs to.
        :param device: Edge device you want to create.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your devices. Each tag consists of a key and a value, both of which you define.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3abcdef1d2ea64456171c0cbf08b0c16eae8b8d28f4815c6515aabe2e523270)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDeviceProps(
            device_fleet_name=device_fleet_name, device=device, tags=tags
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a8d3dc37aebc873d0aeea906ad87c927cdf82cf7e9a80e28d7b2195c636a2b4)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0506dad1f49196fefcbd13d570aff49c31dda0672510b37b43320d943cf268b7)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your devices.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="deviceFleetName")
    def device_fleet_name(self) -> builtins.str:
        '''The name of the fleet the device belongs to.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-devicefleetname
        '''
        return typing.cast(builtins.str, jsii.get(self, "deviceFleetName"))

    @device_fleet_name.setter
    def device_fleet_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__946425d0a7da6f130191f8a0815402b1bda48bcc0627c7ed770b3d4f07198f79)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deviceFleetName", value)

    @builtins.property
    @jsii.member(jsii_name="device")
    def device(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDevice.DeviceProperty"]]:
        '''Edge device you want to create.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDevice.DeviceProperty"]], jsii.get(self, "device"))

    @device.setter
    def device(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDevice.DeviceProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76314385f9853a3bfe385c949d5b6a43dee2c54b479381ea9765bd304cba6476)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "device", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDevice.DeviceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "device_name": "deviceName",
            "description": "description",
            "iot_thing_name": "iotThingName",
        },
    )
    class DeviceProperty:
        def __init__(
            self,
            *,
            device_name: builtins.str,
            description: typing.Optional[builtins.str] = None,
            iot_thing_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information of a particular device.

            :param device_name: The name of the device.
            :param description: Description of the device.
            :param iot_thing_name: AWS Internet of Things (IoT) object name.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                device_property = sagemaker.CfnDevice.DeviceProperty(
                    device_name="deviceName",
                
                    # the properties below are optional
                    description="description",
                    iot_thing_name="iotThingName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__43b40b55245978699774f9b5e56191c22e81a73552561f7190f32a80a2311431)
                check_type(argname="argument device_name", value=device_name, expected_type=type_hints["device_name"])
                check_type(argname="argument description", value=description, expected_type=type_hints["description"])
                check_type(argname="argument iot_thing_name", value=iot_thing_name, expected_type=type_hints["iot_thing_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "device_name": device_name,
            }
            if description is not None:
                self._values["description"] = description
            if iot_thing_name is not None:
                self._values["iot_thing_name"] = iot_thing_name

        @builtins.property
        def device_name(self) -> builtins.str:
            '''The name of the device.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-devicename
            '''
            result = self._values.get("device_name")
            assert result is not None, "Required property 'device_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            '''Description of the device.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-description
            '''
            result = self._values.get("description")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def iot_thing_name(self) -> typing.Optional[builtins.str]:
            '''AWS Internet of Things (IoT) object name.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-iotthingname
            '''
            result = self._values.get("iot_thing_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeviceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_c2943556)
class CfnDeviceFleet(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceFleet",
):
    '''A CloudFormation ``AWS::SageMaker::DeviceFleet``.

    The ``AWS::SageMaker::DeviceFleet`` resource is an Amazon SageMaker resource type that allows you to create a DeviceFleet that manages your SageMaker Edge Manager Devices. You must register your devices against the ``DeviceFleet`` separately.

    :cloudformationResource: AWS::SageMaker::DeviceFleet
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_device_fleet = sagemaker.CfnDeviceFleet(self, "MyCfnDeviceFleet",
            device_fleet_name="deviceFleetName",
            output_config=sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                s3_output_location="s3OutputLocation",
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            description="description",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        device_fleet_name: builtins.str,
        output_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDeviceFleet.EdgeOutputConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::DeviceFleet``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param device_fleet_name: Name of the device fleet.
        :param output_config: The output configuration for storing sample data collected by the fleet.
        :param role_arn: The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
        :param description: A description of the fleet.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your device fleets. Each tag consists of a key and a value, both of which you define.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e5c11192822cf6a7274bcacd8c8147149a9111d09d2701f9547a16c89d2d2c06)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDeviceFleetProps(
            device_fleet_name=device_fleet_name,
            output_config=output_config,
            role_arn=role_arn,
            description=description,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3cb330fe6c6b70769b12318fb10174ed458f16ae84753429881454642514e4e9)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d262d2dfa0a766b9ef88b7d0180a9a007a4589ca64179969667e5c835a27524)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="deviceFleetName")
    def device_fleet_name(self) -> builtins.str:
        '''Name of the device fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-devicefleetname
        '''
        return typing.cast(builtins.str, jsii.get(self, "deviceFleetName"))

    @device_fleet_name.setter
    def device_fleet_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc1ebf19bb8d12d33f46194921833987903a772f1f8219286b1e902fb541b0a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deviceFleetName", value)

    @builtins.property
    @jsii.member(jsii_name="outputConfig")
    def output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDeviceFleet.EdgeOutputConfigProperty"]:
        '''The output configuration for storing sample data collected by the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDeviceFleet.EdgeOutputConfigProperty"], jsii.get(self, "outputConfig"))

    @output_config.setter
    def output_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDeviceFleet.EdgeOutputConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7fc98ed95422b4cc9f6b42674ea7654ba952161c116c8516d593f0414b33cb81)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "outputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2032a1e19b80658a94b8bed07221ad9072ce3559dc064b8ec7b727b4080ed28a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eeedc707895aa3002c706479748ee7820bd530fd99db1b35f3953bbe5c0681d5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "s3_output_location": "s3OutputLocation",
            "kms_key_id": "kmsKeyId",
        },
    )
    class EdgeOutputConfigProperty:
        def __init__(
            self,
            *,
            s3_output_location: builtins.str,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for storing sample data collected by the fleet.

            :param s3_output_location: The Amazon Simple Storage (S3) bucket URI.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                edge_output_config_property = sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                    s3_output_location="s3OutputLocation",
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1eb8f35c611515659c53b813c3fef2016ed31d467e5dfe3e9720e7ec96acc382)
                check_type(argname="argument s3_output_location", value=s3_output_location, expected_type=type_hints["s3_output_location"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output_location": s3_output_location,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def s3_output_location(self) -> builtins.str:
            '''The Amazon Simple Storage (S3) bucket URI.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-s3outputlocation
            '''
            result = self._values.get("s3_output_location")
            assert result is not None, "Required property 's3_output_location' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.

            If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EdgeOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceFleetProps",
    jsii_struct_bases=[],
    name_mapping={
        "device_fleet_name": "deviceFleetName",
        "output_config": "outputConfig",
        "role_arn": "roleArn",
        "description": "description",
        "tags": "tags",
    },
)
class CfnDeviceFleetProps:
    def __init__(
        self,
        *,
        device_fleet_name: builtins.str,
        output_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDeviceFleet.EdgeOutputConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDeviceFleet``.

        :param device_fleet_name: Name of the device fleet.
        :param output_config: The output configuration for storing sample data collected by the fleet.
        :param role_arn: The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
        :param description: A description of the fleet.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your device fleets. Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_device_fleet_props = sagemaker.CfnDeviceFleetProps(
                device_fleet_name="deviceFleetName",
                output_config=sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                    s3_output_location="s3OutputLocation",
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                description="description",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2dc3d0951ad79f71353b3ad32783516a322539ca7717d79ffa74bab3f2b0300)
            check_type(argname="argument device_fleet_name", value=device_fleet_name, expected_type=type_hints["device_fleet_name"])
            check_type(argname="argument output_config", value=output_config, expected_type=type_hints["output_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "device_fleet_name": device_fleet_name,
            "output_config": output_config,
            "role_arn": role_arn,
        }
        if description is not None:
            self._values["description"] = description
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def device_fleet_name(self) -> builtins.str:
        '''Name of the device fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-devicefleetname
        '''
        result = self._values.get("device_fleet_name")
        assert result is not None, "Required property 'device_fleet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDeviceFleet.EdgeOutputConfigProperty]:
        '''The output configuration for storing sample data collected by the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
        '''
        result = self._values.get("output_config")
        assert result is not None, "Required property 'output_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDeviceFleet.EdgeOutputConfigProperty], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeviceFleetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDeviceProps",
    jsii_struct_bases=[],
    name_mapping={
        "device_fleet_name": "deviceFleetName",
        "device": "device",
        "tags": "tags",
    },
)
class CfnDeviceProps:
    def __init__(
        self,
        *,
        device_fleet_name: builtins.str,
        device: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDevice.DeviceProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDevice``.

        :param device_fleet_name: The name of the fleet the device belongs to.
        :param device: Edge device you want to create.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your devices. Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_device_props = sagemaker.CfnDeviceProps(
                device_fleet_name="deviceFleetName",
            
                # the properties below are optional
                device=sagemaker.CfnDevice.DeviceProperty(
                    device_name="deviceName",
            
                    # the properties below are optional
                    description="description",
                    iot_thing_name="iotThingName"
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73e7f76537702c6066451ab74616be8106d0374344002438b8bafb5d35f7440e)
            check_type(argname="argument device_fleet_name", value=device_fleet_name, expected_type=type_hints["device_fleet_name"])
            check_type(argname="argument device", value=device, expected_type=type_hints["device"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "device_fleet_name": device_fleet_name,
        }
        if device is not None:
            self._values["device"] = device
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def device_fleet_name(self) -> builtins.str:
        '''The name of the fleet the device belongs to.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-devicefleetname
        '''
        result = self._values.get("device_fleet_name")
        assert result is not None, "Required property 'device_fleet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def device(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDevice.DeviceProperty]]:
        '''Edge device you want to create.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
        '''
        result = self._values.get("device")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDevice.DeviceProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your devices.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeviceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnDomain(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain",
):
    '''A CloudFormation ``AWS::SageMaker::Domain``.

    Creates a ``Domain`` used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. Users within a domain can share notebook files and other artifacts with each other.

    *EFS storage*

    When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.

    SageMaker uses the AWS Key Management Service ( AWS KMS) to encrypt the EFS volume attached to the domain with an AWS managed key by default. For more control, you can specify a customer managed key. For more information, see `Protect Data at Rest Using Encryption <https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html>`_ .

    *VPC configuration*

    All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the ``AppNetworkAccessType`` parameter. ``AppNetworkAccessType`` corresponds to the network access type that you choose when you onboard to Studio. The following options are available:

    - ``PublicInternetOnly`` - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.
    - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.

    When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.
    .. epigraph::

       NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.

    For more information, see `Connect SageMaker Studio Notebooks to Resources in a VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html>`_ .

    :cloudformationResource: AWS::SageMaker::Domain
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_domain = sagemaker.CfnDomain(self, "MyCfnDomain",
            auth_mode="authMode",
            default_user_settings=sagemaker.CfnDomain.UserSettingsProperty(
                execution_role="executionRole",
        
                # the properties below are optional
                jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                    access_status="accessStatus",
                    user_group="userGroup"
                ),
                security_groups=["securityGroups"],
                sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                    notebook_output_option="notebookOutputOption",
                    s3_kms_key_id="s3KmsKeyId",
                    s3_output_path="s3OutputPath"
                )
            ),
            domain_name="domainName",
            subnet_ids=["subnetIds"],
            vpc_id="vpcId",
        
            # the properties below are optional
            app_network_access_type="appNetworkAccessType",
            app_security_group_management="appSecurityGroupManagement",
            default_space_settings=sagemaker.CfnDomain.DefaultSpaceSettingsProperty(
                execution_role="executionRole",
        
                # the properties below are optional
                jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                security_groups=["securityGroups"]
            ),
            domain_settings=sagemaker.CfnDomain.DomainSettingsProperty(
                r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                    domain_execution_role_arn="domainExecutionRoleArn",
        
                    # the properties below are optional
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    r_studio_connect_url="rStudioConnectUrl",
                    r_studio_package_manager_url="rStudioPackageManagerUrl"
                ),
                security_group_ids=["securityGroupIds"]
            ),
            kms_key_id="kmsKeyId",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        auth_mode: builtins.str,
        default_user_settings: typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.UserSettingsProperty", typing.Dict[builtins.str, typing.Any]]],
        domain_name: builtins.str,
        subnet_ids: typing.Sequence[builtins.str],
        vpc_id: builtins.str,
        app_network_access_type: typing.Optional[builtins.str] = None,
        app_security_group_management: typing.Optional[builtins.str] = None,
        default_space_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DefaultSpaceSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        domain_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.DomainSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Domain``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param auth_mode: The mode of authentication that members use to access the Domain. *Valid Values* : ``SSO | IAM``
        :param default_user_settings: The default user settings.
        :param domain_name: The domain name.
        :param subnet_ids: The VPC subnets that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Array members* : Minimum number of 1 item. Maximum number of 16 items. *Pattern* : ``[-0-9a-zA-Z]+``
        :param vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Pattern* : ``[-0-9a-zA-Z]+``
        :param app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` . - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets *Valid Values* : ``PublicInternetOnly | VpcOnly``
        :param app_security_group_management: The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode. Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided. If setting up the domain for use with RStudio, this value must be set to ``Service`` . *Allowed Values* : ``Service`` | ``Customer``
        :param default_space_settings: ``AWS::SageMaker::Domain.DefaultSpaceSettings``.
        :param domain_settings: A collection of settings that apply to the ``SageMaker Domain`` . These settings are specified through the ``CreateDomain`` API call.
        :param kms_key_id: SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default. For more control, specify a customer managed CMK. *Length Constraints* : Maximum length of 2048. *Pattern* : ``.*``
        :param tags: Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. Tags that you specify for the Domain are also added to all apps that are launched in the Domain. *Array members* : Minimum number of 0 items. Maximum number of 50 items.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a98e719c58aab3299db52c4086bfb65ee6438882423af805478e9ea3fda998f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDomainProps(
            auth_mode=auth_mode,
            default_user_settings=default_user_settings,
            domain_name=domain_name,
            subnet_ids=subnet_ids,
            vpc_id=vpc_id,
            app_network_access_type=app_network_access_type,
            app_security_group_management=app_security_group_management,
            default_space_settings=default_space_settings,
            domain_settings=domain_settings,
            kms_key_id=kms_key_id,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__054b92073504f806c8065046fb755c4424b063db14ea01d662bf1a3799b913a9)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27b8551bfeb2abb4c1faf2dad1939e476fbe0902c5876e849b3a2a2526fef410)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrDomainArn")
    def attr_domain_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the Domain, such as ``arn:aws:sagemaker:us-west-2:account-id:domain/my-domain-name`` .

        :cloudformationAttribute: DomainArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrDomainArn"))

    @builtins.property
    @jsii.member(jsii_name="attrDomainId")
    def attr_domain_id(self) -> builtins.str:
        '''The Domain ID.

        :cloudformationAttribute: DomainId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrDomainId"))

    @builtins.property
    @jsii.member(jsii_name="attrHomeEfsFileSystemId")
    def attr_home_efs_file_system_id(self) -> builtins.str:
        '''The ID of the Amazon Elastic File System (EFS) managed by this Domain.

        :cloudformationAttribute: HomeEfsFileSystemId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrHomeEfsFileSystemId"))

    @builtins.property
    @jsii.member(jsii_name="attrSecurityGroupIdForDomainBoundary")
    def attr_security_group_id_for_domain_boundary(self) -> builtins.str:
        '''The ID of the security group that authorizes traffic between the ``RSessionGateway`` apps and the ``RStudioServerPro`` app.

        :cloudformationAttribute: SecurityGroupIdForDomainBoundary
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrSecurityGroupIdForDomainBoundary"))

    @builtins.property
    @jsii.member(jsii_name="attrSingleSignOnManagedApplicationInstanceId")
    def attr_single_sign_on_managed_application_instance_id(self) -> builtins.str:
        '''The IAM Identity Center managed application instance ID.

        :cloudformationAttribute: SingleSignOnManagedApplicationInstanceId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrSingleSignOnManagedApplicationInstanceId"))

    @builtins.property
    @jsii.member(jsii_name="attrUrl")
    def attr_url(self) -> builtins.str:
        '''The URL for the Domain.

        :cloudformationAttribute: Url
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrUrl"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tags to associated with the Domain.

        Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.

        Tags that you specify for the Domain are also added to all apps that are launched in the Domain.

        *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="authMode")
    def auth_mode(self) -> builtins.str:
        '''The mode of authentication that members use to access the Domain.

        *Valid Values* : ``SSO | IAM``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode
        '''
        return typing.cast(builtins.str, jsii.get(self, "authMode"))

    @auth_mode.setter
    def auth_mode(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a67fdecfd1f892afa5b5efc44318f01b5d8286aec268d01fb468966f5a4710fb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "authMode", value)

    @builtins.property
    @jsii.member(jsii_name="defaultUserSettings")
    def default_user_settings(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnDomain.UserSettingsProperty"]:
        '''The default user settings.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnDomain.UserSettingsProperty"], jsii.get(self, "defaultUserSettings"))

    @default_user_settings.setter
    def default_user_settings(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnDomain.UserSettingsProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__14263bf0f3dae6b010cee5a9a7de240a41a79f8f655ed36f1444e579a936fc5d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultUserSettings", value)

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        '''The domain name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
        '''
        return typing.cast(builtins.str, jsii.get(self, "domainName"))

    @domain_name.setter
    def domain_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76d0ed31020f4eadd792cd5d7897939d99ef06ed557509d040b88b5f6e9cca9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="subnetIds")
    def subnet_ids(self) -> typing.List[builtins.str]:
        '''The VPC subnets that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Array members* : Minimum number of 1 item. Maximum number of 16 items.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "subnetIds"))

    @subnet_ids.setter
    def subnet_ids(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6556642f81d027deb80da8cf42e945b715e6966790a8ab41e68da4acaaf3a9eb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "subnetIds", value)

    @builtins.property
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        '''The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid
        '''
        return typing.cast(builtins.str, jsii.get(self, "vpcId"))

    @vpc_id.setter
    def vpc_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0aca1d756799cd6468a535127ee441605b164991ff11c6effe6c40c519ff5c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vpcId", value)

    @builtins.property
    @jsii.member(jsii_name="appNetworkAccessType")
    def app_network_access_type(self) -> typing.Optional[builtins.str]:
        '''Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` .

        - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access
        - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets

        *Valid Values* : ``PublicInternetOnly | VpcOnly``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "appNetworkAccessType"))

    @app_network_access_type.setter
    def app_network_access_type(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66770e15c78955514aa53519369aa0389610ff7cbd94793f5ee385fb2c96a0cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appNetworkAccessType", value)

    @builtins.property
    @jsii.member(jsii_name="appSecurityGroupManagement")
    def app_security_group_management(self) -> typing.Optional[builtins.str]:
        '''The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode.

        Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided. If setting up the domain for use with RStudio, this value must be set to ``Service`` .

        *Allowed Values* : ``Service`` | ``Customer``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "appSecurityGroupManagement"))

    @app_security_group_management.setter
    def app_security_group_management(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dfaaa586058b1b8f2197fde6ee73bb9b0d7df2f79e82996c1d47c48d7c51b1c5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appSecurityGroupManagement", value)

    @builtins.property
    @jsii.member(jsii_name="defaultSpaceSettings")
    def default_space_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceSettingsProperty"]]:
        '''``AWS::SageMaker::Domain.DefaultSpaceSettings``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceSettingsProperty"]], jsii.get(self, "defaultSpaceSettings"))

    @default_space_settings.setter
    def default_space_settings(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DefaultSpaceSettingsProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5d0e056a481e730ebed277f032ef13b3337668137169bd966cc3fc66b40464e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultSpaceSettings", value)

    @builtins.property
    @jsii.member(jsii_name="domainSettings")
    def domain_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DomainSettingsProperty"]]:
        '''A collection of settings that apply to the ``SageMaker Domain`` .

        These settings are specified through the ``CreateDomain`` API call.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DomainSettingsProperty"]], jsii.get(self, "domainSettings"))

    @domain_settings.setter
    def domain_settings(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.DomainSettingsProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a80dc18546bde6c82a5e78a8e60c044ce75c01a498f10fd5d6422d2fecfbbd61)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainSettings", value)

    @builtins.property
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.

        For more control, specify a customer managed CMK.

        *Length Constraints* : Maximum length of 2048.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "kmsKeyId"))

    @kms_key_id.setter
    def kms_key_id(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__705995dde312c66454de0b9e9f6a8d7e895beb5c34f61395d1dab1369dd40850)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kmsKeyId", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.CustomImageProperty",
        jsii_struct_bases=[],
        name_mapping={
            "app_image_config_name": "appImageConfigName",
            "image_name": "imageName",
            "image_version_number": "imageVersionNumber",
        },
    )
    class CustomImageProperty:
        def __init__(
            self,
            *,
            app_image_config_name: builtins.str,
            image_name: builtins.str,
            image_version_number: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''A custom SageMaker image.

            For more information, see `Bring your own SageMaker image <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html>`_ .

            :param app_image_config_name: The name of the AppImageConfig.
            :param image_name: The name of the CustomImage. Must be unique to your account.
            :param image_version_number: The version number of the CustomImage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                custom_image_property = sagemaker.CfnDomain.CustomImageProperty(
                    app_image_config_name="appImageConfigName",
                    image_name="imageName",
                
                    # the properties below are optional
                    image_version_number=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2406a28ab5a6558d6675669b44f0ae0fc98be5d4a9d0f1426d9e8ba1b3a2b623)
                check_type(argname="argument app_image_config_name", value=app_image_config_name, expected_type=type_hints["app_image_config_name"])
                check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
                check_type(argname="argument image_version_number", value=image_version_number, expected_type=type_hints["image_version_number"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "app_image_config_name": app_image_config_name,
                "image_name": image_name,
            }
            if image_version_number is not None:
                self._values["image_version_number"] = image_version_number

        @builtins.property
        def app_image_config_name(self) -> builtins.str:
            '''The name of the AppImageConfig.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-appimageconfigname
            '''
            result = self._values.get("app_image_config_name")
            assert result is not None, "Required property 'app_image_config_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_name(self) -> builtins.str:
            '''The name of the CustomImage.

            Must be unique to your account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imagename
            '''
            result = self._values.get("image_name")
            assert result is not None, "Required property 'image_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_version_number(self) -> typing.Optional[jsii.Number]:
            '''The version number of the CustomImage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imageversionnumber
            '''
            result = self._values.get("image_version_number")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomImageProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "execution_role": "executionRole",
            "jupyter_server_app_settings": "jupyterServerAppSettings",
            "kernel_gateway_app_settings": "kernelGatewayAppSettings",
            "security_groups": "securityGroups",
        },
    )
    class DefaultSpaceSettingsProperty:
        def __init__(
            self,
            *,
            execution_role: builtins.str,
            jupyter_server_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.JupyterServerAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            kernel_gateway_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.KernelGatewayAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            security_groups: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''A collection of settings that apply to spaces created in the Domain.

            :param execution_role: The ARN of the execution role for the space.
            :param jupyter_server_app_settings: The JupyterServer app settings.
            :param kernel_gateway_app_settings: The KernelGateway app settings.
            :param security_groups: The security group IDs for the Amazon Virtual Private Cloud that the space uses for communication.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                default_space_settings_property = sagemaker.CfnDomain.DefaultSpaceSettingsProperty(
                    execution_role="executionRole",
                
                    # the properties below are optional
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    security_groups=["securityGroups"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6f9de66f7050e50e98d4b4c96b379ab71681a650698564e825f452052572214f)
                check_type(argname="argument execution_role", value=execution_role, expected_type=type_hints["execution_role"])
                check_type(argname="argument jupyter_server_app_settings", value=jupyter_server_app_settings, expected_type=type_hints["jupyter_server_app_settings"])
                check_type(argname="argument kernel_gateway_app_settings", value=kernel_gateway_app_settings, expected_type=type_hints["kernel_gateway_app_settings"])
                check_type(argname="argument security_groups", value=security_groups, expected_type=type_hints["security_groups"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "execution_role": execution_role,
            }
            if jupyter_server_app_settings is not None:
                self._values["jupyter_server_app_settings"] = jupyter_server_app_settings
            if kernel_gateway_app_settings is not None:
                self._values["kernel_gateway_app_settings"] = kernel_gateway_app_settings
            if security_groups is not None:
                self._values["security_groups"] = security_groups

        @builtins.property
        def execution_role(self) -> builtins.str:
            '''The ARN of the execution role for the space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-executionrole
            '''
            result = self._values.get("execution_role")
            assert result is not None, "Required property 'execution_role' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def jupyter_server_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]]:
            '''The JupyterServer app settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-jupyterserverappsettings
            '''
            result = self._values.get("jupyter_server_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]], result)

        @builtins.property
        def kernel_gateway_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]]:
            '''The KernelGateway app settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-kernelgatewayappsettings
            '''
            result = self._values.get("kernel_gateway_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]], result)

        @builtins.property
        def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security group IDs for the Amazon Virtual Private Cloud that the space uses for communication.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-securitygroups
            '''
            result = self._values.get("security_groups")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultSpaceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.DomainSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "r_studio_server_pro_domain_settings": "rStudioServerProDomainSettings",
            "security_group_ids": "securityGroupIds",
        },
    )
    class DomainSettingsProperty:
        def __init__(
            self,
            *,
            r_studio_server_pro_domain_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.RStudioServerProDomainSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            security_group_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''A collection of settings that apply to the ``SageMaker Domain`` .

            These settings are specified through the ``CreateDomain`` API call.

            :param r_studio_server_pro_domain_settings: A collection of settings that configure the ``RStudioServerPro`` Domain-level app.
            :param security_group_ids: The security groups for the Amazon Virtual Private Cloud that the ``Domain`` uses for communication between Domain-level apps and user apps.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                domain_settings_property = sagemaker.CfnDomain.DomainSettingsProperty(
                    r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                        domain_execution_role_arn="domainExecutionRoleArn",
                
                        # the properties below are optional
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        r_studio_connect_url="rStudioConnectUrl",
                        r_studio_package_manager_url="rStudioPackageManagerUrl"
                    ),
                    security_group_ids=["securityGroupIds"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b23323cc301476d59d77a279da88bfc3d14a3c21fb8709a0ecc6db6074a56cf9)
                check_type(argname="argument r_studio_server_pro_domain_settings", value=r_studio_server_pro_domain_settings, expected_type=type_hints["r_studio_server_pro_domain_settings"])
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if r_studio_server_pro_domain_settings is not None:
                self._values["r_studio_server_pro_domain_settings"] = r_studio_server_pro_domain_settings
            if security_group_ids is not None:
                self._values["security_group_ids"] = security_group_ids

        @builtins.property
        def r_studio_server_pro_domain_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProDomainSettingsProperty"]]:
            '''A collection of settings that configure the ``RStudioServerPro`` Domain-level app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-rstudioserverprodomainsettings
            '''
            result = self._values.get("r_studio_server_pro_domain_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProDomainSettingsProperty"]], result)

        @builtins.property
        def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security groups for the Amazon Virtual Private Cloud that the ``Domain`` uses for communication between Domain-level apps and user apps.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DomainSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterServerAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"default_resource_spec": "defaultResourceSpec"},
    )
    class JupyterServerAppSettingsProperty:
        def __init__(
            self,
            *,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The JupyterServer app settings.

            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                jupyter_server_app_settings_property = sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__942897b920fdd808a5ea532138ac1b0df0fb1c9ddd37871604e65d095f882b59)
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html#cfn-sagemaker-domain-jupyterserverappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JupyterServerAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.KernelGatewayAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
        },
    )
    class KernelGatewayAppSettingsProperty:
        def __init__(
            self,
            *,
            custom_images: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The KernelGateway app settings.

            :param custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app. .. epigraph:: The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS Command Line Interface or AWS CloudFormation and the instance type parameter value is not passed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                kernel_gateway_app_settings_property = sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__976135962fc7c07e542fc30bab2304803e495b79c9c357ea5114ddc4b0dbb7ed)
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]]:
            '''A list of custom SageMaker images that are configured to run as a KernelGateway app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.

            .. epigraph::

               The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS Command Line Interface or AWS CloudFormation and the instance type parameter value is not passed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelGatewayAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.RSessionAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
        },
    )
    class RSessionAppSettingsProperty:
        def __init__(
            self,
            *,
            custom_images: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A collection of settings that apply to an ``RSessionGateway`` app.

            :param custom_images: A list of custom SageMaker images that are configured to run as a RSession app.
            :param default_resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                r_session_app_settings_property = sagemaker.CfnDomain.RSessionAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ed9236f4ca80bc2b976cbd6c7f549652ec32a05dfb3665bd8630243e309c6276)
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]]:
            '''A list of custom SageMaker images that are configured to run as a RSession app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnDomain.CustomImageProperty"]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RSessionAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"access_status": "accessStatus", "user_group": "userGroup"},
    )
    class RStudioServerProAppSettingsProperty:
        def __init__(
            self,
            *,
            access_status: typing.Optional[builtins.str] = None,
            user_group: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A collection of settings that configure user interaction with the ``RStudioServerPro`` app.

            :param access_status: Indicates whether the current user has access to the ``RStudioServerPro`` app.
            :param user_group: The level of permissions that the user has within the ``RStudioServerPro`` app. This value defaults to ``User``. The ``Admin`` value allows the user access to the RStudio Administrative Dashboard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                r_studio_server_pro_app_settings_property = sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                    access_status="accessStatus",
                    user_group="userGroup"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5bdad69d0d7dd9f412f84d21f9ef9cb6bb758f797a769d60e05dab58f67a85af)
                check_type(argname="argument access_status", value=access_status, expected_type=type_hints["access_status"])
                check_type(argname="argument user_group", value=user_group, expected_type=type_hints["user_group"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if access_status is not None:
                self._values["access_status"] = access_status
            if user_group is not None:
                self._values["user_group"] = user_group

        @builtins.property
        def access_status(self) -> typing.Optional[builtins.str]:
            '''Indicates whether the current user has access to the ``RStudioServerPro`` app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-accessstatus
            '''
            result = self._values.get("access_status")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def user_group(self) -> typing.Optional[builtins.str]:
            '''The level of permissions that the user has within the ``RStudioServerPro`` app.

            This value defaults to ``User``. The ``Admin`` value allows the user access to the RStudio Administrative Dashboard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-usergroup
            '''
            result = self._values.get("user_group")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RStudioServerProAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "domain_execution_role_arn": "domainExecutionRoleArn",
            "default_resource_spec": "defaultResourceSpec",
            "r_studio_connect_url": "rStudioConnectUrl",
            "r_studio_package_manager_url": "rStudioPackageManagerUrl",
        },
    )
    class RStudioServerProDomainSettingsProperty:
        def __init__(
            self,
            *,
            domain_execution_role_arn: builtins.str,
            default_resource_spec: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            r_studio_connect_url: typing.Optional[builtins.str] = None,
            r_studio_package_manager_url: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A collection of settings that configure the ``RStudioServerPro`` Domain-level app.

            :param domain_execution_role_arn: The ARN of the execution role for the ``RStudioServerPro`` Domain-level app.
            :param default_resource_spec: A collection that defines the default ``InstanceType`` , ``SageMakerImageArn`` , and ``SageMakerImageVersionArn`` for the Domain.
            :param r_studio_connect_url: A URL pointing to an RStudio Connect server.
            :param r_studio_package_manager_url: A URL pointing to an RStudio Package Manager server.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                r_studio_server_pro_domain_settings_property = sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                    domain_execution_role_arn="domainExecutionRoleArn",
                
                    # the properties below are optional
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    r_studio_connect_url="rStudioConnectUrl",
                    r_studio_package_manager_url="rStudioPackageManagerUrl"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a53076bef887f5d807ddb5491cbeabe991590efba7801d2aa8d981d6913eb70c)
                check_type(argname="argument domain_execution_role_arn", value=domain_execution_role_arn, expected_type=type_hints["domain_execution_role_arn"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
                check_type(argname="argument r_studio_connect_url", value=r_studio_connect_url, expected_type=type_hints["r_studio_connect_url"])
                check_type(argname="argument r_studio_package_manager_url", value=r_studio_package_manager_url, expected_type=type_hints["r_studio_package_manager_url"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "domain_execution_role_arn": domain_execution_role_arn,
            }
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec
            if r_studio_connect_url is not None:
                self._values["r_studio_connect_url"] = r_studio_connect_url
            if r_studio_package_manager_url is not None:
                self._values["r_studio_package_manager_url"] = r_studio_package_manager_url

        @builtins.property
        def domain_execution_role_arn(self) -> builtins.str:
            '''The ARN of the execution role for the ``RStudioServerPro`` Domain-level app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-domainexecutionrolearn
            '''
            result = self._values.get("domain_execution_role_arn")
            assert result is not None, "Required property 'domain_execution_role_arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]]:
            '''A collection that defines the default ``InstanceType`` , ``SageMakerImageArn`` , and ``SageMakerImageVersionArn`` for the Domain.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.ResourceSpecProperty"]], result)

        @builtins.property
        def r_studio_connect_url(self) -> typing.Optional[builtins.str]:
            '''A URL pointing to an RStudio Connect server.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudioconnecturl
            '''
            result = self._values.get("r_studio_connect_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def r_studio_package_manager_url(self) -> typing.Optional[builtins.str]:
            '''A URL pointing to an RStudio Package Manager server.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudiopackagemanagerurl
            '''
            result = self._values.get("r_studio_package_manager_url")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RStudioServerProDomainSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.ResourceSpecProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_type": "instanceType",
            "lifecycle_config_arn": "lifecycleConfigArn",
            "sage_maker_image_arn": "sageMakerImageArn",
            "sage_maker_image_version_arn": "sageMakerImageVersionArn",
        },
    )
    class ResourceSpecProperty:
        def __init__(
            self,
            *,
            instance_type: typing.Optional[builtins.str] = None,
            lifecycle_config_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_version_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :param instance_type: The instance type that the image version runs on. .. epigraph:: *JupyterServer apps* only support the ``system`` value. For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.
            :param lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
            :param sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
            :param sage_maker_image_version_arn: The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                resource_spec_property = sagemaker.CfnDomain.ResourceSpecProperty(
                    instance_type="instanceType",
                    lifecycle_config_arn="lifecycleConfigArn",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a15c1a8a4f296645dbaf164af882f41bb1cf89c7585a52dc9b76a9ade4b3f49a)
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument lifecycle_config_arn", value=lifecycle_config_arn, expected_type=type_hints["lifecycle_config_arn"])
                check_type(argname="argument sage_maker_image_arn", value=sage_maker_image_arn, expected_type=type_hints["sage_maker_image_arn"])
                check_type(argname="argument sage_maker_image_version_arn", value=sage_maker_image_version_arn, expected_type=type_hints["sage_maker_image_version_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if lifecycle_config_arn is not None:
                self._values["lifecycle_config_arn"] = lifecycle_config_arn
            if sage_maker_image_arn is not None:
                self._values["sage_maker_image_arn"] = sage_maker_image_arn
            if sage_maker_image_version_arn is not None:
                self._values["sage_maker_image_version_arn"] = sage_maker_image_version_arn

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The instance type that the image version runs on.

            .. epigraph::

               *JupyterServer apps* only support the ``system`` value.

               For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lifecycle_config_arn(self) -> typing.Optional[builtins.str]:
            '''The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-lifecycleconfigarn
            '''
            result = self._values.get("lifecycle_config_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the SageMaker image that the image version belongs to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimagearn
            '''
            result = self._values.get("sage_maker_image_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_version_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimageversionarn
            '''
            result = self._values.get("sage_maker_image_version_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResourceSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.SharingSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "notebook_output_option": "notebookOutputOption",
            "s3_kms_key_id": "s3KmsKeyId",
            "s3_output_path": "s3OutputPath",
        },
    )
    class SharingSettingsProperty:
        def __init__(
            self,
            *,
            notebook_output_option: typing.Optional[builtins.str] = None,
            s3_kms_key_id: typing.Optional[builtins.str] = None,
            s3_output_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies options when sharing an Amazon SageMaker Studio notebook.

            These settings are specified as part of ``DefaultUserSettings`` when the `CreateDomain <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html>`_ API is called, and as part of ``UserSettings`` when the `CreateUserProfile <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html>`_ API is called.

            :param notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is ``Disabled`` .
            :param s3_kms_key_id: When ``NotebookOutputOption`` is ``Allowed`` , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
            :param s3_output_path: When ``NotebookOutputOption`` is ``Allowed`` , the Amazon S3 bucket used to store the shared notebook snapshots.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                sharing_settings_property = sagemaker.CfnDomain.SharingSettingsProperty(
                    notebook_output_option="notebookOutputOption",
                    s3_kms_key_id="s3KmsKeyId",
                    s3_output_path="s3OutputPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__548dd396dfd935cd647f2a1297e1f20836fc0ddc163c1659d63bbf9e9cf88849)
                check_type(argname="argument notebook_output_option", value=notebook_output_option, expected_type=type_hints["notebook_output_option"])
                check_type(argname="argument s3_kms_key_id", value=s3_kms_key_id, expected_type=type_hints["s3_kms_key_id"])
                check_type(argname="argument s3_output_path", value=s3_output_path, expected_type=type_hints["s3_output_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if notebook_output_option is not None:
                self._values["notebook_output_option"] = notebook_output_option
            if s3_kms_key_id is not None:
                self._values["s3_kms_key_id"] = s3_kms_key_id
            if s3_output_path is not None:
                self._values["s3_output_path"] = s3_output_path

        @builtins.property
        def notebook_output_option(self) -> typing.Optional[builtins.str]:
            '''Whether to include the notebook cell output when sharing the notebook.

            The default is ``Disabled`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-notebookoutputoption
            '''
            result = self._values.get("notebook_output_option")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''When ``NotebookOutputOption`` is ``Allowed`` , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3kmskeyid
            '''
            result = self._values.get("s3_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_output_path(self) -> typing.Optional[builtins.str]:
            '''When ``NotebookOutputOption`` is ``Allowed`` , the Amazon S3 bucket used to store the shared notebook snapshots.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3outputpath
            '''
            result = self._values.get("s3_output_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SharingSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomain.UserSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "execution_role": "executionRole",
            "jupyter_server_app_settings": "jupyterServerAppSettings",
            "kernel_gateway_app_settings": "kernelGatewayAppSettings",
            "r_session_app_settings": "rSessionAppSettings",
            "r_studio_server_pro_app_settings": "rStudioServerProAppSettings",
            "security_groups": "securityGroups",
            "sharing_settings": "sharingSettings",
        },
    )
    class UserSettingsProperty:
        def __init__(
            self,
            *,
            execution_role: builtins.str,
            jupyter_server_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.JupyterServerAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            kernel_gateway_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.KernelGatewayAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            r_session_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.RSessionAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            r_studio_server_pro_app_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.RStudioServerProAppSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            security_groups: typing.Optional[typing.Sequence[builtins.str]] = None,
            sharing_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnDomain.SharingSettingsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A collection of settings that apply to users of Amazon SageMaker Studio.

            These settings are specified when the `CreateUserProfile <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html>`_ API is called, and as ``DefaultUserSettings`` when the `CreateDomain <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html>`_ API is called.

            ``SecurityGroups`` is aggregated when specified in both calls. For all other settings in ``UserSettings`` , the values specified in ``CreateUserProfile`` take precedence over those specified in ``CreateDomain`` .

            :param execution_role: The execution role for the user.
            :param jupyter_server_app_settings: The Jupyter server's app settings.
            :param kernel_gateway_app_settings: The kernel gateway app settings.
            :param r_session_app_settings: A collection of settings that configure the ``RSessionGateway`` app.
            :param r_studio_server_pro_app_settings: A collection of settings that configure user interaction with the ``RStudioServerPro`` app.
            :param security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication. Optional when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``PublicInternetOnly`` . Required when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``VpcOnly`` , unless specified as part of the ``DefaultUserSettings`` for the domain. Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
            :param sharing_settings: Specifies options for sharing SageMaker Studio notebooks.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                user_settings_property = sagemaker.CfnDomain.UserSettingsProperty(
                    execution_role="executionRole",
                
                    # the properties below are optional
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                        access_status="accessStatus",
                        user_group="userGroup"
                    ),
                    security_groups=["securityGroups"],
                    sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                        notebook_output_option="notebookOutputOption",
                        s3_kms_key_id="s3KmsKeyId",
                        s3_output_path="s3OutputPath"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__88423e90a647fb1fb625855a5ca5160b5e8125e664363a24f90939664cc2d507)
                check_type(argname="argument execution_role", value=execution_role, expected_type=type_hints["execution_role"])
                check_type(argname="argument jupyter_server_app_settings", value=jupyter_server_app_settings, expected_type=type_hints["jupyter_server_app_settings"])
                check_type(argname="argument kernel_gateway_app_settings", value=kernel_gateway_app_settings, expected_type=type_hints["kernel_gateway_app_settings"])
                check_type(argname="argument r_session_app_settings", value=r_session_app_settings, expected_type=type_hints["r_session_app_settings"])
                check_type(argname="argument r_studio_server_pro_app_settings", value=r_studio_server_pro_app_settings, expected_type=type_hints["r_studio_server_pro_app_settings"])
                check_type(argname="argument security_groups", value=security_groups, expected_type=type_hints["security_groups"])
                check_type(argname="argument sharing_settings", value=sharing_settings, expected_type=type_hints["sharing_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "execution_role": execution_role,
            }
            if jupyter_server_app_settings is not None:
                self._values["jupyter_server_app_settings"] = jupyter_server_app_settings
            if kernel_gateway_app_settings is not None:
                self._values["kernel_gateway_app_settings"] = kernel_gateway_app_settings
            if r_session_app_settings is not None:
                self._values["r_session_app_settings"] = r_session_app_settings
            if r_studio_server_pro_app_settings is not None:
                self._values["r_studio_server_pro_app_settings"] = r_studio_server_pro_app_settings
            if security_groups is not None:
                self._values["security_groups"] = security_groups
            if sharing_settings is not None:
                self._values["sharing_settings"] = sharing_settings

        @builtins.property
        def execution_role(self) -> builtins.str:
            '''The execution role for the user.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-executionrole
            '''
            result = self._values.get("execution_role")
            assert result is not None, "Required property 'execution_role' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def jupyter_server_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]]:
            '''The Jupyter server's app settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterserverappsettings
            '''
            result = self._values.get("jupyter_server_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.JupyterServerAppSettingsProperty"]], result)

        @builtins.property
        def kernel_gateway_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]]:
            '''The kernel gateway app settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-kernelgatewayappsettings
            '''
            result = self._values.get("kernel_gateway_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.KernelGatewayAppSettingsProperty"]], result)

        @builtins.property
        def r_session_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RSessionAppSettingsProperty"]]:
            '''A collection of settings that configure the ``RSessionGateway`` app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rsessionappsettings
            '''
            result = self._values.get("r_session_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RSessionAppSettingsProperty"]], result)

        @builtins.property
        def r_studio_server_pro_app_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProAppSettingsProperty"]]:
            '''A collection of settings that configure user interaction with the ``RStudioServerPro`` app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rstudioserverproappsettings
            '''
            result = self._values.get("r_studio_server_pro_app_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.RStudioServerProAppSettingsProperty"]], result)

        @builtins.property
        def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.

            Optional when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``PublicInternetOnly`` .

            Required when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``VpcOnly`` , unless specified as part of the ``DefaultUserSettings`` for the domain.

            Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-securitygroups
            '''
            result = self._values.get("security_groups")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def sharing_settings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.SharingSettingsProperty"]]:
            '''Specifies options for sharing SageMaker Studio notebooks.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-sharingsettings
            '''
            result = self._values.get("sharing_settings")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnDomain.SharingSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "UserSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnDomainProps",
    jsii_struct_bases=[],
    name_mapping={
        "auth_mode": "authMode",
        "default_user_settings": "defaultUserSettings",
        "domain_name": "domainName",
        "subnet_ids": "subnetIds",
        "vpc_id": "vpcId",
        "app_network_access_type": "appNetworkAccessType",
        "app_security_group_management": "appSecurityGroupManagement",
        "default_space_settings": "defaultSpaceSettings",
        "domain_settings": "domainSettings",
        "kms_key_id": "kmsKeyId",
        "tags": "tags",
    },
)
class CfnDomainProps:
    def __init__(
        self,
        *,
        auth_mode: builtins.str,
        default_user_settings: typing.Union[_IResolvable_da3f097b, typing.Union[CfnDomain.UserSettingsProperty, typing.Dict[builtins.str, typing.Any]]],
        domain_name: builtins.str,
        subnet_ids: typing.Sequence[builtins.str],
        vpc_id: builtins.str,
        app_network_access_type: typing.Optional[builtins.str] = None,
        app_security_group_management: typing.Optional[builtins.str] = None,
        default_space_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDomain.DefaultSpaceSettingsProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        domain_settings: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnDomain.DomainSettingsProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDomain``.

        :param auth_mode: The mode of authentication that members use to access the Domain. *Valid Values* : ``SSO | IAM``
        :param default_user_settings: The default user settings.
        :param domain_name: The domain name.
        :param subnet_ids: The VPC subnets that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Array members* : Minimum number of 1 item. Maximum number of 16 items. *Pattern* : ``[-0-9a-zA-Z]+``
        :param vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Pattern* : ``[-0-9a-zA-Z]+``
        :param app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` . - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets *Valid Values* : ``PublicInternetOnly | VpcOnly``
        :param app_security_group_management: The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode. Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided. If setting up the domain for use with RStudio, this value must be set to ``Service`` . *Allowed Values* : ``Service`` | ``Customer``
        :param default_space_settings: ``AWS::SageMaker::Domain.DefaultSpaceSettings``.
        :param domain_settings: A collection of settings that apply to the ``SageMaker Domain`` . These settings are specified through the ``CreateDomain`` API call.
        :param kms_key_id: SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default. For more control, specify a customer managed CMK. *Length Constraints* : Maximum length of 2048. *Pattern* : ``.*``
        :param tags: Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. Tags that you specify for the Domain are also added to all apps that are launched in the Domain. *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_domain_props = sagemaker.CfnDomainProps(
                auth_mode="authMode",
                default_user_settings=sagemaker.CfnDomain.UserSettingsProperty(
                    execution_role="executionRole",
            
                    # the properties below are optional
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                        access_status="accessStatus",
                        user_group="userGroup"
                    ),
                    security_groups=["securityGroups"],
                    sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                        notebook_output_option="notebookOutputOption",
                        s3_kms_key_id="s3KmsKeyId",
                        s3_output_path="s3OutputPath"
                    )
                ),
                domain_name="domainName",
                subnet_ids=["subnetIds"],
                vpc_id="vpcId",
            
                # the properties below are optional
                app_network_access_type="appNetworkAccessType",
                app_security_group_management="appSecurityGroupManagement",
                default_space_settings=sagemaker.CfnDomain.DefaultSpaceSettingsProperty(
                    execution_role="executionRole",
            
                    # the properties below are optional
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    security_groups=["securityGroups"]
                ),
                domain_settings=sagemaker.CfnDomain.DomainSettingsProperty(
                    r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                        domain_execution_role_arn="domainExecutionRoleArn",
            
                        # the properties below are optional
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        r_studio_connect_url="rStudioConnectUrl",
                        r_studio_package_manager_url="rStudioPackageManagerUrl"
                    ),
                    security_group_ids=["securityGroupIds"]
                ),
                kms_key_id="kmsKeyId",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d70b90cbf9af0f3b53a18e5f11f7de868ef5fe3e6110bb229fd1350019f730e5)
            check_type(argname="argument auth_mode", value=auth_mode, expected_type=type_hints["auth_mode"])
            check_type(argname="argument default_user_settings", value=default_user_settings, expected_type=type_hints["default_user_settings"])
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument subnet_ids", value=subnet_ids, expected_type=type_hints["subnet_ids"])
            check_type(argname="argument vpc_id", value=vpc_id, expected_type=type_hints["vpc_id"])
            check_type(argname="argument app_network_access_type", value=app_network_access_type, expected_type=type_hints["app_network_access_type"])
            check_type(argname="argument app_security_group_management", value=app_security_group_management, expected_type=type_hints["app_security_group_management"])
            check_type(argname="argument default_space_settings", value=default_space_settings, expected_type=type_hints["default_space_settings"])
            check_type(argname="argument domain_settings", value=domain_settings, expected_type=type_hints["domain_settings"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "auth_mode": auth_mode,
            "default_user_settings": default_user_settings,
            "domain_name": domain_name,
            "subnet_ids": subnet_ids,
            "vpc_id": vpc_id,
        }
        if app_network_access_type is not None:
            self._values["app_network_access_type"] = app_network_access_type
        if app_security_group_management is not None:
            self._values["app_security_group_management"] = app_security_group_management
        if default_space_settings is not None:
            self._values["default_space_settings"] = default_space_settings
        if domain_settings is not None:
            self._values["domain_settings"] = domain_settings
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def auth_mode(self) -> builtins.str:
        '''The mode of authentication that members use to access the Domain.

        *Valid Values* : ``SSO | IAM``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode
        '''
        result = self._values.get("auth_mode")
        assert result is not None, "Required property 'auth_mode' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def default_user_settings(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnDomain.UserSettingsProperty]:
        '''The default user settings.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings
        '''
        result = self._values.get("default_user_settings")
        assert result is not None, "Required property 'default_user_settings' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnDomain.UserSettingsProperty], result)

    @builtins.property
    def domain_name(self) -> builtins.str:
        '''The domain name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
        '''
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def subnet_ids(self) -> typing.List[builtins.str]:
        '''The VPC subnets that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Array members* : Minimum number of 1 item. Maximum number of 16 items.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids
        '''
        result = self._values.get("subnet_ids")
        assert result is not None, "Required property 'subnet_ids' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def vpc_id(self) -> builtins.str:
        '''The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid
        '''
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_network_access_type(self) -> typing.Optional[builtins.str]:
        '''Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` .

        - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access
        - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets

        *Valid Values* : ``PublicInternetOnly | VpcOnly``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype
        '''
        result = self._values.get("app_network_access_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def app_security_group_management(self) -> typing.Optional[builtins.str]:
        '''The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode.

        Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided. If setting up the domain for use with RStudio, this value must be set to ``Service`` .

        *Allowed Values* : ``Service`` | ``Customer``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement
        '''
        result = self._values.get("app_security_group_management")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def default_space_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DefaultSpaceSettingsProperty]]:
        '''``AWS::SageMaker::Domain.DefaultSpaceSettings``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings
        '''
        result = self._values.get("default_space_settings")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DefaultSpaceSettingsProperty]], result)

    @builtins.property
    def domain_settings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DomainSettingsProperty]]:
        '''A collection of settings that apply to the ``SageMaker Domain`` .

        These settings are specified through the ``CreateDomain`` API call.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings
        '''
        result = self._values.get("domain_settings")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnDomain.DomainSettingsProperty]], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.

        For more control, specify a customer managed CMK.

        *Length Constraints* : Maximum length of 2048.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Tags to associated with the Domain.

        Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.

        Tags that you specify for the Domain are also added to all apps that are launched in the Domain.

        *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDomainProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnEndpoint(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint",
):
    '''A CloudFormation ``AWS::SageMaker::Endpoint``.

    Use the ``AWS::SageMaker::Endpoint`` resource to create an endpoint using the specified configuration in the request. Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource. For more information, see `Deploy a Model on Amazon SageMaker Hosting Services <https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html>`_ in the *Amazon SageMaker Developer Guide* .

    :cloudformationResource: AWS::SageMaker::Endpoint
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_endpoint = sagemaker.CfnEndpoint(self, "MyCfnEndpoint",
            endpoint_config_name="endpointConfigName",
        
            # the properties below are optional
            deployment_config=sagemaker.CfnEndpoint.DeploymentConfigProperty(
                blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                    traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                        type="type",
        
                        # the properties below are optional
                        canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123
                    ),
        
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    termination_wait_in_seconds=123
                ),
        
                # the properties below are optional
                auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                    alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                )
            ),
            endpoint_name="endpointName",
            exclude_retained_variant_properties=[sagemaker.CfnEndpoint.VariantPropertyProperty(
                variant_property_type="variantPropertyType"
            )],
            retain_all_variant_properties=False,
            retain_deployment_config=False,
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        endpoint_config_name: builtins.str,
        deployment_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.DeploymentConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        exclude_retained_variant_properties: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.VariantPropertyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        retain_all_variant_properties: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        retain_deployment_config: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Endpoint``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param endpoint_config_name: The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .
        :param deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param endpoint_name: The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .
        :param exclude_retained_variant_properties: When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .
        :param retain_all_variant_properties: When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.
        :param retain_deployment_config: Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__25a1b782521c912d49f8881f9136b81a31874db7423cbc69dd4d592308ab1637)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnEndpointProps(
            endpoint_config_name=endpoint_config_name,
            deployment_config=deployment_config,
            endpoint_name=endpoint_name,
            exclude_retained_variant_properties=exclude_retained_variant_properties,
            retain_all_variant_properties=retain_all_variant_properties,
            retain_deployment_config=retain_deployment_config,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30e2eaf7ae1d65739ce7b332f2d2eaa983053d55ecf4081e243a2ac5f47961eb)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f47dbdb18a90354facd890ea710422eaf2acd63bfcef2ca594f9c45be4c0741)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointName")
    def attr_endpoint_name(self) -> builtins.str:
        '''The name of the endpoint, such as ``MyEndpoint`` .

        :cloudformationAttribute: EndpointName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="endpointConfigName")
    def endpoint_config_name(self) -> builtins.str:
        '''The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
        '''
        return typing.cast(builtins.str, jsii.get(self, "endpointConfigName"))

    @endpoint_config_name.setter
    def endpoint_config_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8fc46b5a4608391c5b023fa1800209955387c9abc04000465c1497a02ffcc73b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointConfigName", value)

    @builtins.property
    @jsii.member(jsii_name="deploymentConfig")
    def deployment_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.DeploymentConfigProperty"]]:
        '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.DeploymentConfigProperty"]], jsii.get(self, "deploymentConfig"))

    @deployment_config.setter
    def deployment_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.DeploymentConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__282ad840d284416c74cb1dec9d8585464ab2fdabef85c02a2157137e553d929d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deploymentConfig", value)

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed57f464bb55b112eacf852ffafe64ee93beb0dd0f9a9c81cfed938f546e9413)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="excludeRetainedVariantProperties")
    def exclude_retained_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.VariantPropertyProperty"]]]]:
        '''When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.VariantPropertyProperty"]]]], jsii.get(self, "excludeRetainedVariantProperties"))

    @exclude_retained_variant_properties.setter
    def exclude_retained_variant_properties(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.VariantPropertyProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ee6a8f5fa98cdfc488825acbd1978c8669d4e6de4cdb626a755c8b4462edb18)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "excludeRetainedVariantProperties", value)

    @builtins.property
    @jsii.member(jsii_name="retainAllVariantProperties")
    def retain_all_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.

        To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], jsii.get(self, "retainAllVariantProperties"))

    @retain_all_variant_properties.setter
    def retain_all_variant_properties(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a449b8aec7663417625aba5613780daefbd54794f3fc085c8275ee15b03e0ddd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "retainAllVariantProperties", value)

    @builtins.property
    @jsii.member(jsii_name="retainDeploymentConfig")
    def retain_deployment_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''Specifies whether to reuse the last deployment configuration.

        The default value is false (the configuration is not reused).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], jsii.get(self, "retainDeploymentConfig"))

    @retain_deployment_config.setter
    def retain_deployment_config(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edaf654b3efad8522601d55dc70b1fbe91565b325788322fd32078ba331c7236)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "retainDeploymentConfig", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.AlarmProperty",
        jsii_struct_bases=[],
        name_mapping={"alarm_name": "alarmName"},
    )
    class AlarmProperty:
        def __init__(self, *, alarm_name: builtins.str) -> None:
            '''An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.

            :param alarm_name: The name of a CloudWatch alarm in your account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                alarm_property = sagemaker.CfnEndpoint.AlarmProperty(
                    alarm_name="alarmName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__545f901797973de76167553f39b693c4f1564abc9dfaeb5563cb8afd7917adb1)
                check_type(argname="argument alarm_name", value=alarm_name, expected_type=type_hints["alarm_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarm_name": alarm_name,
            }

        @builtins.property
        def alarm_name(self) -> builtins.str:
            '''The name of a CloudWatch alarm in your account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html#cfn-sagemaker-endpoint-alarm-alarmname
            '''
            result = self._values.get("alarm_name")
            assert result is not None, "Required property 'alarm_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AlarmProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.AutoRollbackConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"alarms": "alarms"},
    )
    class AutoRollbackConfigProperty:
        def __init__(
            self,
            *,
            alarms: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.AlarmProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :param alarms: List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                auto_rollback_config_property = sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                    alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d86e3846eb32ca90c0c7fbf8652bbfcc5f60c6360575c7f19bc7e9da7d2fe467)
                check_type(argname="argument alarms", value=alarms, expected_type=type_hints["alarms"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarms": alarms,
            }

        @builtins.property
        def alarms(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AlarmProperty"]]]:
            '''List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.

            If any alarms are tripped during a deployment, SageMaker rolls back the deployment.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html#cfn-sagemaker-endpoint-autorollbackconfig-alarms
            '''
            result = self._values.get("alarms")
            assert result is not None, "Required property 'alarms' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AlarmProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AutoRollbackConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "traffic_routing_configuration": "trafficRoutingConfiguration",
            "maximum_execution_timeout_in_seconds": "maximumExecutionTimeoutInSeconds",
            "termination_wait_in_seconds": "terminationWaitInSeconds",
        },
    )
    class BlueGreenUpdatePolicyProperty:
        def __init__(
            self,
            *,
            traffic_routing_configuration: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.TrafficRoutingConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            maximum_execution_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            termination_wait_in_seconds: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Update policy for a blue/green deployment.

            If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.

            :param traffic_routing_configuration: Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.
            :param maximum_execution_timeout_in_seconds: Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in ``TerminationWaitInSeconds`` and ``WaitIntervalInSeconds`` .
            :param termination_wait_in_seconds: Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is 0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                blue_green_update_policy_property = sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                    traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                        type="type",
                
                        # the properties below are optional
                        canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123
                    ),
                
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    termination_wait_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d28be213bc658ab75fb13a94b106b4201e989c105915c39fb50705be12d37728)
                check_type(argname="argument traffic_routing_configuration", value=traffic_routing_configuration, expected_type=type_hints["traffic_routing_configuration"])
                check_type(argname="argument maximum_execution_timeout_in_seconds", value=maximum_execution_timeout_in_seconds, expected_type=type_hints["maximum_execution_timeout_in_seconds"])
                check_type(argname="argument termination_wait_in_seconds", value=termination_wait_in_seconds, expected_type=type_hints["termination_wait_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "traffic_routing_configuration": traffic_routing_configuration,
            }
            if maximum_execution_timeout_in_seconds is not None:
                self._values["maximum_execution_timeout_in_seconds"] = maximum_execution_timeout_in_seconds
            if termination_wait_in_seconds is not None:
                self._values["termination_wait_in_seconds"] = termination_wait_in_seconds

        @builtins.property
        def traffic_routing_configuration(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpoint.TrafficRoutingConfigProperty"]:
            '''Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-trafficroutingconfiguration
            '''
            result = self._values.get("traffic_routing_configuration")
            assert result is not None, "Required property 'traffic_routing_configuration' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpoint.TrafficRoutingConfigProperty"], result)

        @builtins.property
        def maximum_execution_timeout_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''Maximum execution timeout for the deployment.

            Note that the timeout value should be larger than the total waiting time specified in ``TerminationWaitInSeconds`` and ``WaitIntervalInSeconds`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-maximumexecutiontimeoutinseconds
            '''
            result = self._values.get("maximum_execution_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def termination_wait_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet.

            Default is 0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-terminationwaitinseconds
            '''
            result = self._values.get("termination_wait_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlueGreenUpdatePolicyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.CapacitySizeProperty",
        jsii_struct_bases=[],
        name_mapping={"type": "type", "value": "value"},
    )
    class CapacitySizeProperty:
        def __init__(self, *, type: builtins.str, value: jsii.Number) -> None:
            '''Specifies the type and size of the endpoint capacity to activate for a blue/green deployment, a rolling deployment, or a rollback strategy.

            You can specify your batches as either instance count or the overall percentage or your fleet.

            For a rollback strategy, if you don't specify the fields in this object, or if you set the ``Value`` to 100%, then SageMaker uses a blue/green rollback strategy and rolls all traffic back to the blue fleet.

            :param type: Specifies the endpoint capacity type. - ``INSTANCE_COUNT`` : The endpoint activates based on the number of instances. - ``CAPACITY_PERCENT`` : The endpoint activates based on the specified percentage of capacity.
            :param value: Defines the capacity size, either as a number of instances or a capacity percentage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                capacity_size_property = sagemaker.CfnEndpoint.CapacitySizeProperty(
                    type="type",
                    value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__620e1fd2701901a3771895d025a10da547bd6349c473e05ba7dd2b7c1ee9235b)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
                "value": value,
            }

        @builtins.property
        def type(self) -> builtins.str:
            '''Specifies the endpoint capacity type.

            - ``INSTANCE_COUNT`` : The endpoint activates based on the number of instances.
            - ``CAPACITY_PERCENT`` : The endpoint activates based on the specified percentage of capacity.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> jsii.Number:
            '''Defines the capacity size, either as a number of instances or a capacity percentage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CapacitySizeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.DeploymentConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "blue_green_update_policy": "blueGreenUpdatePolicy",
            "auto_rollback_configuration": "autoRollbackConfiguration",
        },
    )
    class DeploymentConfigProperty:
        def __init__(
            self,
            *,
            blue_green_update_policy: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.BlueGreenUpdatePolicyProperty", typing.Dict[builtins.str, typing.Any]]],
            auto_rollback_configuration: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.AutoRollbackConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

            :param blue_green_update_policy: Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
            :param auto_rollback_configuration: Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                deployment_config_property = sagemaker.CfnEndpoint.DeploymentConfigProperty(
                    blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                        traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                            type="type",
                
                            # the properties below are optional
                            canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            wait_interval_in_seconds=123
                        ),
                
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        termination_wait_in_seconds=123
                    ),
                
                    # the properties below are optional
                    auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                        alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                            alarm_name="alarmName"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ef4fd0099485ae9d7fd2d7347509c94feea591075e4c9b0ec8f5dd9747851049)
                check_type(argname="argument blue_green_update_policy", value=blue_green_update_policy, expected_type=type_hints["blue_green_update_policy"])
                check_type(argname="argument auto_rollback_configuration", value=auto_rollback_configuration, expected_type=type_hints["auto_rollback_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "blue_green_update_policy": blue_green_update_policy,
            }
            if auto_rollback_configuration is not None:
                self._values["auto_rollback_configuration"] = auto_rollback_configuration

        @builtins.property
        def blue_green_update_policy(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpoint.BlueGreenUpdatePolicyProperty"]:
            '''Update policy for a blue/green deployment.

            If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-bluegreenupdatepolicy
            '''
            result = self._values.get("blue_green_update_policy")
            assert result is not None, "Required property 'blue_green_update_policy' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpoint.BlueGreenUpdatePolicyProperty"], result)

        @builtins.property
        def auto_rollback_configuration(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AutoRollbackConfigProperty"]]:
            '''Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-autorollbackconfiguration
            '''
            result = self._values.get("auto_rollback_configuration")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.AutoRollbackConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeploymentConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.TrafficRoutingConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "type": "type",
            "canary_size": "canarySize",
            "linear_step_size": "linearStepSize",
            "wait_interval_in_seconds": "waitIntervalInSeconds",
        },
    )
    class TrafficRoutingConfigProperty:
        def __init__(
            self,
            *,
            type: builtins.str,
            canary_size: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            linear_step_size: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            wait_interval_in_seconds: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Defines the traffic routing strategy during an endpoint deployment to shift traffic from the old fleet to the new fleet.

            :param type: Traffic routing strategy type. - ``ALL_AT_ONCE`` : Endpoint traffic shifts to the new fleet in a single step. - ``CANARY`` : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic. - ``LINEAR`` : Endpoint traffic shifts to the new fleet in n steps of a configurable size.
            :param canary_size: Batch size for the first step to turn on traffic on the new endpoint fleet. ``Value`` must be less than or equal to 50% of the variant's total instance count.
            :param linear_step_size: Batch size for each step to turn on traffic on the new endpoint fleet. ``Value`` must be 10-50% of the variant's total instance count.
            :param wait_interval_in_seconds: The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                traffic_routing_config_property = sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                    type="type",
                
                    # the properties below are optional
                    canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    wait_interval_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ed93bec369cf789d2763e6fe66be5df767a5c5c4c898134732efbeb60fd121ee)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument canary_size", value=canary_size, expected_type=type_hints["canary_size"])
                check_type(argname="argument linear_step_size", value=linear_step_size, expected_type=type_hints["linear_step_size"])
                check_type(argname="argument wait_interval_in_seconds", value=wait_interval_in_seconds, expected_type=type_hints["wait_interval_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
            }
            if canary_size is not None:
                self._values["canary_size"] = canary_size
            if linear_step_size is not None:
                self._values["linear_step_size"] = linear_step_size
            if wait_interval_in_seconds is not None:
                self._values["wait_interval_in_seconds"] = wait_interval_in_seconds

        @builtins.property
        def type(self) -> builtins.str:
            '''Traffic routing strategy type.

            - ``ALL_AT_ONCE`` : Endpoint traffic shifts to the new fleet in a single step.
            - ``CANARY`` : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic.
            - ``LINEAR`` : Endpoint traffic shifts to the new fleet in n steps of a configurable size.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def canary_size(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]]:
            '''Batch size for the first step to turn on traffic on the new endpoint fleet.

            ``Value`` must be less than or equal to 50% of the variant's total instance count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-canarysize
            '''
            result = self._values.get("canary_size")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]], result)

        @builtins.property
        def linear_step_size(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]]:
            '''Batch size for each step to turn on traffic on the new endpoint fleet.

            ``Value`` must be 10-50% of the variant's total instance count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-linearstepsize
            '''
            result = self._values.get("linear_step_size")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpoint.CapacitySizeProperty"]], result)

        @builtins.property
        def wait_interval_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-waitintervalinseconds
            '''
            result = self._values.get("wait_interval_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TrafficRoutingConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpoint.VariantPropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"variant_property_type": "variantPropertyType"},
    )
    class VariantPropertyProperty:
        def __init__(
            self,
            *,
            variant_property_type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies a production variant property type for an Endpoint.

            If you are updating an Endpoint with the `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ option set to ``true`` , the ``VarientProperty`` objects listed in `ExcludeRetainedVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-ExcludeRetainedVariantProperties>`_ override the existing variant properties of the Endpoint.

            :param variant_property_type: The type of variant property. The supported values are:. - ``DesiredInstanceCount`` : Overrides the existing variant instance counts using the `InitialInstanceCount <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ . - ``DesiredWeight`` : Overrides the existing variant weights using the `InitialVariantWeight <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ . - ``DataCaptureConfig`` : (Not currently supported.)

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                variant_property_property = sagemaker.CfnEndpoint.VariantPropertyProperty(
                    variant_property_type="variantPropertyType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a64f8f48a2b5af883cfc2cd98614bb5fc82a1ad9e9bad182f015286151da4d68)
                check_type(argname="argument variant_property_type", value=variant_property_type, expected_type=type_hints["variant_property_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if variant_property_type is not None:
                self._values["variant_property_type"] = variant_property_type

        @builtins.property
        def variant_property_type(self) -> typing.Optional[builtins.str]:
            '''The type of variant property. The supported values are:.

            - ``DesiredInstanceCount`` : Overrides the existing variant instance counts using the `InitialInstanceCount <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ .
            - ``DesiredWeight`` : Overrides the existing variant weights using the `InitialVariantWeight <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ .
            - ``DataCaptureConfig`` : (Not currently supported.)

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
            '''
            result = self._values.get("variant_property_type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VariantPropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_c2943556)
class CfnEndpointConfig(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig",
):
    '''A CloudFormation ``AWS::SageMaker::EndpointConfig``.

    The ``AWS::SageMaker::EndpointConfig`` resource creates a configuration for an Amazon SageMaker endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ in the *SageMaker Developer Guide* .

    :cloudformationResource: AWS::SageMaker::EndpointConfig
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_endpoint_config = sagemaker.CfnEndpointConfig(self, "MyCfnEndpointConfig",
            production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                initial_variant_weight=123,
                model_name="modelName",
                variant_name="variantName",
        
                # the properties below are optional
                accelerator_type="acceleratorType",
                container_startup_health_check_timeout_in_seconds=123,
                enable_ssm_access=False,
                initial_instance_count=123,
                instance_type="instanceType",
                model_data_download_timeout_in_seconds=123,
                serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123,
        
                    # the properties below are optional
                    provisioned_concurrency=123
                ),
                volume_size_in_gb=123
            )],
        
            # the properties below are optional
            async_inference_config=sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                    kms_key_id="kmsKeyId",
                    notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                        error_topic="errorTopic",
                        include_inference_response_in=["includeInferenceResponseIn"],
                        success_topic="successTopic"
                    ),
                    s3_failure_path="s3FailurePath",
                    s3_output_path="s3OutputPath"
                ),
        
                # the properties below are optional
                client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                    max_concurrent_invocations_per_instance=123
                )
            ),
            data_capture_config=sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                    capture_mode="captureMode"
                )],
                destination_s3_uri="destinationS3Uri",
                initial_sampling_percentage=123,
        
                # the properties below are optional
                capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                ),
                enable_capture=False,
                kms_key_id="kmsKeyId"
            ),
            endpoint_config_name="endpointConfigName",
            explainer_config=sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                    shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                        shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                            mime_type="mimeType",
                            shap_baseline="shapBaseline",
                            shap_baseline_uri="shapBaselineUri"
                        ),
        
                        # the properties below are optional
                        number_of_samples=123,
                        seed=123,
                        text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                            granularity="granularity",
                            language="language"
                        ),
                        use_logit=False
                    ),
        
                    # the properties below are optional
                    enable_explanations="enableExplanations",
                    inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                        content_template="contentTemplate",
                        feature_headers=["featureHeaders"],
                        features_attribute="featuresAttribute",
                        feature_types=["featureTypes"],
                        label_attribute="labelAttribute",
                        label_headers=["labelHeaders"],
                        label_index=123,
                        max_payload_in_mb=123,
                        max_record_count=123,
                        probability_attribute="probabilityAttribute",
                        probability_index=123
                    )
                )
            ),
            kms_key_id="kmsKeyId",
            shadow_production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                initial_variant_weight=123,
                model_name="modelName",
                variant_name="variantName",
        
                # the properties below are optional
                accelerator_type="acceleratorType",
                container_startup_health_check_timeout_in_seconds=123,
                enable_ssm_access=False,
                initial_instance_count=123,
                instance_type="instanceType",
                model_data_download_timeout_in_seconds=123,
                serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123,
        
                    # the properties below are optional
                    provisioned_concurrency=123
                ),
                volume_size_in_gb=123
            )],
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        production_variants: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ProductionVariantProperty", typing.Dict[builtins.str, typing.Any]]]]],
        async_inference_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        data_capture_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.DataCaptureConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_config_name: typing.Optional[builtins.str] = None,
        explainer_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ExplainerConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        shadow_production_variants: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ProductionVariantProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::EndpointConfig``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param production_variants: A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.
        :param async_inference_config: Specifies configuration for how an endpoint performs asynchronous inference.
        :param data_capture_config: Specifies how to capture endpoint data for model monitor. The data capture configuration applies to all production variants hosted at the endpoint.
        :param endpoint_config_name: The name of the endpoint configuration.
        :param explainer_config: ``AWS::SageMaker::EndpointConfig.ExplainerConfig``.
        :param kms_key_id: The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` - Alias name: ``alias/ExampleAlias`` - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`` The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_ .. epigraph:: Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails. For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ . For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .
        :param shadow_production_variants: Array of ``ProductionVariant`` objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5ec3761393d0c2344de58784b3017f7e1498d65c80ca0e29094c617103903e4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnEndpointConfigProps(
            production_variants=production_variants,
            async_inference_config=async_inference_config,
            data_capture_config=data_capture_config,
            endpoint_config_name=endpoint_config_name,
            explainer_config=explainer_config,
            kms_key_id=kms_key_id,
            shadow_production_variants=shadow_production_variants,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b2d94310d95f958331f33f530628190b1b0cb9f396a80c916a18ff5d4f37f1b4)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d017ceb78f627a4d082938a9d00f60606064212462ecc172f2732ca4cfecf4e)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointConfigName")
    def attr_endpoint_config_name(self) -> builtins.str:
        '''The name of the endpoint configuration, such as ``MyEndpointConfiguration`` .

        :cloudformationAttribute: EndpointConfigName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointConfigName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="productionVariants")
    def production_variants(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]:
        '''A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]], jsii.get(self, "productionVariants"))

    @production_variants.setter
    def production_variants(
        self,
        value: typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bfd9dbaba28aed3cd83027875322f2cbb70f3fea264bd0ad0c78e962c341e3e9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "productionVariants", value)

    @builtins.property
    @jsii.member(jsii_name="asyncInferenceConfig")
    def async_inference_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceConfigProperty"]]:
        '''Specifies configuration for how an endpoint performs asynchronous inference.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceConfigProperty"]], jsii.get(self, "asyncInferenceConfig"))

    @async_inference_config.setter
    def async_inference_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d66437c5253334608419691e2755c084d9f098a57fe7460e997e14374a4394b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "asyncInferenceConfig", value)

    @builtins.property
    @jsii.member(jsii_name="dataCaptureConfig")
    def data_capture_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.DataCaptureConfigProperty"]]:
        '''Specifies how to capture endpoint data for model monitor.

        The data capture configuration applies to all production variants hosted at the endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.DataCaptureConfigProperty"]], jsii.get(self, "dataCaptureConfig"))

    @data_capture_config.setter
    def data_capture_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.DataCaptureConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13ddfd0a291efa4705835c0f8adb807852e0c61e1bcff1144556e06335ac7f46)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataCaptureConfig", value)

    @builtins.property
    @jsii.member(jsii_name="endpointConfigName")
    def endpoint_config_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint configuration.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointConfigName"))

    @endpoint_config_name.setter
    def endpoint_config_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c1e35e22547536b5f3a9420b1327dcc09512d00f5a6fcb7050fb847aef3cc7e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointConfigName", value)

    @builtins.property
    @jsii.member(jsii_name="explainerConfig")
    def explainer_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ExplainerConfigProperty"]]:
        '''``AWS::SageMaker::EndpointConfig.ExplainerConfig``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ExplainerConfigProperty"]], jsii.get(self, "explainerConfig"))

    @explainer_config.setter
    def explainer_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ExplainerConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f3348af00a67f21513de8698151acf7998ee647db8a9740c9d0d51eb170a4fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "explainerConfig", value)

    @builtins.property
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.

        - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab``
        - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab``
        - Alias name: ``alias/ExampleAlias``
        - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias``

        The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_
        .. epigraph::

           Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails.

           For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ .

           For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "kmsKeyId"))

    @kms_key_id.setter
    def kms_key_id(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1feedfcd01ce7ecf1fca052ce76bf378f4ce268fabd561d3ec301f697053426d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kmsKeyId", value)

    @builtins.property
    @jsii.member(jsii_name="shadowProductionVariants")
    def shadow_production_variants(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]]:
        '''Array of ``ProductionVariant`` objects.

        There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]], jsii.get(self, "shadowProductionVariants"))

    @shadow_production_variants.setter
    def shadow_production_variants(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ProductionVariantProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__364e8e55ae8c7122cb952ab736c20798058ad6defc1088f9d91757193a806d68)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "shadowProductionVariants", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_concurrent_invocations_per_instance": "maxConcurrentInvocationsPerInstance",
        },
    )
    class AsyncInferenceClientConfigProperty:
        def __init__(
            self,
            *,
            max_concurrent_invocations_per_instance: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :param max_concurrent_invocations_per_instance: The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, SageMaker will choose an optimal value for you.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_client_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                    max_concurrent_invocations_per_instance=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3dee0d44cdca5f0d19568fbd2782436822015939f8aeb568463590b55f41cfe6)
                check_type(argname="argument max_concurrent_invocations_per_instance", value=max_concurrent_invocations_per_instance, expected_type=type_hints["max_concurrent_invocations_per_instance"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if max_concurrent_invocations_per_instance is not None:
                self._values["max_concurrent_invocations_per_instance"] = max_concurrent_invocations_per_instance

        @builtins.property
        def max_concurrent_invocations_per_instance(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''The maximum number of concurrent requests sent by the SageMaker client to the model container.

            If no value is provided, SageMaker will choose an optimal value for you.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceclientconfig-maxconcurrentinvocationsperinstance
            '''
            result = self._values.get("max_concurrent_invocations_per_instance")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceClientConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "output_config": "outputConfig",
            "client_config": "clientConfig",
        },
    )
    class AsyncInferenceConfigProperty:
        def __init__(
            self,
            *,
            output_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceOutputConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            client_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceClientConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies configuration for how an endpoint performs asynchronous inference.

            :param output_config: Specifies the configuration for asynchronous inference invocation outputs.
            :param client_config: Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                    output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                        kms_key_id="kmsKeyId",
                        notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                            error_topic="errorTopic",
                            include_inference_response_in=["includeInferenceResponseIn"],
                            success_topic="successTopic"
                        ),
                        s3_failure_path="s3FailurePath",
                        s3_output_path="s3OutputPath"
                    ),
                
                    # the properties below are optional
                    client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                        max_concurrent_invocations_per_instance=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9d6279f6f1637a7f063e020863fb6143db719f071239eaff4a14abcffa4e236c)
                check_type(argname="argument output_config", value=output_config, expected_type=type_hints["output_config"])
                check_type(argname="argument client_config", value=client_config, expected_type=type_hints["client_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "output_config": output_config,
            }
            if client_config is not None:
                self._values["client_config"] = client_config

        @builtins.property
        def output_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceOutputConfigProperty"]:
            '''Specifies the configuration for asynchronous inference invocation outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-outputconfig
            '''
            result = self._values.get("output_config")
            assert result is not None, "Required property 'output_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceOutputConfigProperty"], result)

        @builtins.property
        def client_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceClientConfigProperty"]]:
            '''Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-clientconfig
            '''
            result = self._values.get("client_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceClientConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "error_topic": "errorTopic",
            "include_inference_response_in": "includeInferenceResponseIn",
            "success_topic": "successTopic",
        },
    )
    class AsyncInferenceNotificationConfigProperty:
        def __init__(
            self,
            *,
            error_topic: typing.Optional[builtins.str] = None,
            include_inference_response_in: typing.Optional[typing.Sequence[builtins.str]] = None,
            success_topic: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration for notifications of inference results for asynchronous inference.

            :param error_topic: Amazon SNS topic to post a notification to when an inference fails. If no topic is provided, no notification is sent on failure.
            :param include_inference_response_in: ``CfnEndpointConfig.AsyncInferenceNotificationConfigProperty.IncludeInferenceResponseIn``.
            :param success_topic: Amazon SNS topic to post a notification to when an inference completes successfully. If no topic is provided, no notification is sent on success.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_notification_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                    error_topic="errorTopic",
                    include_inference_response_in=["includeInferenceResponseIn"],
                    success_topic="successTopic"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__78f6f560c2b90941cc4af6490a3ab4a8382e19112589f81c2bff6e63dfa574bb)
                check_type(argname="argument error_topic", value=error_topic, expected_type=type_hints["error_topic"])
                check_type(argname="argument include_inference_response_in", value=include_inference_response_in, expected_type=type_hints["include_inference_response_in"])
                check_type(argname="argument success_topic", value=success_topic, expected_type=type_hints["success_topic"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if error_topic is not None:
                self._values["error_topic"] = error_topic
            if include_inference_response_in is not None:
                self._values["include_inference_response_in"] = include_inference_response_in
            if success_topic is not None:
                self._values["success_topic"] = success_topic

        @builtins.property
        def error_topic(self) -> typing.Optional[builtins.str]:
            '''Amazon SNS topic to post a notification to when an inference fails.

            If no topic is provided, no notification is sent on failure.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-errortopic
            '''
            result = self._values.get("error_topic")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def include_inference_response_in(
            self,
        ) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnEndpointConfig.AsyncInferenceNotificationConfigProperty.IncludeInferenceResponseIn``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-includeinferenceresponsein
            '''
            result = self._values.get("include_inference_response_in")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def success_topic(self) -> typing.Optional[builtins.str]:
            '''Amazon SNS topic to post a notification to when an inference completes successfully.

            If no topic is provided, no notification is sent on success.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-successtopic
            '''
            result = self._values.get("success_topic")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceNotificationConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "kms_key_id": "kmsKeyId",
            "notification_config": "notificationConfig",
            "s3_failure_path": "s3FailurePath",
            "s3_output_path": "s3OutputPath",
        },
    )
    class AsyncInferenceOutputConfigProperty:
        def __init__(
            self,
            *,
            kms_key_id: typing.Optional[builtins.str] = None,
            notification_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.AsyncInferenceNotificationConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            s3_failure_path: typing.Optional[builtins.str] = None,
            s3_output_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration for asynchronous inference invocation outputs.

            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
            :param notification_config: Specifies the configuration for notifications of inference results for asynchronous inference.
            :param s3_failure_path: ``CfnEndpointConfig.AsyncInferenceOutputConfigProperty.S3FailurePath``.
            :param s3_output_path: The Amazon S3 location to upload inference responses to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                async_inference_output_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                    kms_key_id="kmsKeyId",
                    notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                        error_topic="errorTopic",
                        include_inference_response_in=["includeInferenceResponseIn"],
                        success_topic="successTopic"
                    ),
                    s3_failure_path="s3FailurePath",
                    s3_output_path="s3OutputPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c3ae80c64de4a57385622840864bf472efd012f72363c8a905b70c436e071533)
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
                check_type(argname="argument notification_config", value=notification_config, expected_type=type_hints["notification_config"])
                check_type(argname="argument s3_failure_path", value=s3_failure_path, expected_type=type_hints["s3_failure_path"])
                check_type(argname="argument s3_output_path", value=s3_output_path, expected_type=type_hints["s3_output_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id
            if notification_config is not None:
                self._values["notification_config"] = notification_config
            if s3_failure_path is not None:
                self._values["s3_failure_path"] = s3_failure_path
            if s3_output_path is not None:
                self._values["s3_output_path"] = s3_output_path

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def notification_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceNotificationConfigProperty"]]:
            '''Specifies the configuration for notifications of inference results for asynchronous inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-notificationconfig
            '''
            result = self._values.get("notification_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.AsyncInferenceNotificationConfigProperty"]], result)

        @builtins.property
        def s3_failure_path(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.AsyncInferenceOutputConfigProperty.S3FailurePath``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3failurepath
            '''
            result = self._values.get("s3_failure_path")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_output_path(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 location to upload inference responses to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3outputpath
            '''
            result = self._values.get("s3_output_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={
            "csv_content_types": "csvContentTypes",
            "json_content_types": "jsonContentTypes",
        },
    )
    class CaptureContentTypeHeaderProperty:
        def __init__(
            self,
            *,
            csv_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            json_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''Specifies the JSON and CSV content types of the data that the endpoint captures.

            :param csv_content_types: A list of the CSV content types of the data that the endpoint captures. For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
            :param json_content_types: A list of the JSON content types of the data that the endpoint captures. For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                capture_content_type_header_property = sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8f365f85e452b00846d8dd4987370795343fee0c95178a92e6cb69c5d32bba4e)
                check_type(argname="argument csv_content_types", value=csv_content_types, expected_type=type_hints["csv_content_types"])
                check_type(argname="argument json_content_types", value=json_content_types, expected_type=type_hints["json_content_types"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv_content_types is not None:
                self._values["csv_content_types"] = csv_content_types
            if json_content_types is not None:
                self._values["json_content_types"] = json_content_types

        @builtins.property
        def csv_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of the CSV content types of the data that the endpoint captures.

            For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-csvcontenttypes
            '''
            result = self._values.get("csv_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def json_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of the JSON content types of the data that the endpoint captures.

            For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-jsoncontenttypes
            '''
            result = self._values.get("json_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptureContentTypeHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureOptionProperty",
        jsii_struct_bases=[],
        name_mapping={"capture_mode": "captureMode"},
    )
    class CaptureOptionProperty:
        def __init__(self, *, capture_mode: builtins.str) -> None:
            '''Specifies whether the endpoint captures input data or output data.

            :param capture_mode: Specifies whether the endpoint captures input data or output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                capture_option_property = sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                    capture_mode="captureMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__025dde0eee27b1ccd2ed0364dddac7611f70b70c09602593590e4a1cc7047b37)
                check_type(argname="argument capture_mode", value=capture_mode, expected_type=type_hints["capture_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "capture_mode": capture_mode,
            }

        @builtins.property
        def capture_mode(self) -> builtins.str:
            '''Specifies whether the endpoint captures input data or output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
            '''
            result = self._values.get("capture_mode")
            assert result is not None, "Required property 'capture_mode' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptureOptionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "shap_config": "shapConfig",
            "enable_explanations": "enableExplanations",
            "inference_config": "inferenceConfig",
        },
    )
    class ClarifyExplainerConfigProperty:
        def __init__(
            self,
            *,
            shap_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyShapConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            enable_explanations: typing.Optional[builtins.str] = None,
            inference_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyInferenceConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''
            :param shap_config: ``CfnEndpointConfig.ClarifyExplainerConfigProperty.ShapConfig``.
            :param enable_explanations: ``CfnEndpointConfig.ClarifyExplainerConfigProperty.EnableExplanations``.
            :param inference_config: ``CfnEndpointConfig.ClarifyExplainerConfigProperty.InferenceConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_explainer_config_property = sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                    shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                        shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                            mime_type="mimeType",
                            shap_baseline="shapBaseline",
                            shap_baseline_uri="shapBaselineUri"
                        ),
                
                        # the properties below are optional
                        number_of_samples=123,
                        seed=123,
                        text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                            granularity="granularity",
                            language="language"
                        ),
                        use_logit=False
                    ),
                
                    # the properties below are optional
                    enable_explanations="enableExplanations",
                    inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                        content_template="contentTemplate",
                        feature_headers=["featureHeaders"],
                        features_attribute="featuresAttribute",
                        feature_types=["featureTypes"],
                        label_attribute="labelAttribute",
                        label_headers=["labelHeaders"],
                        label_index=123,
                        max_payload_in_mb=123,
                        max_record_count=123,
                        probability_attribute="probabilityAttribute",
                        probability_index=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__558fc059462816c0491f464603da3fabbd56effd8ec81519187f942727b6f280)
                check_type(argname="argument shap_config", value=shap_config, expected_type=type_hints["shap_config"])
                check_type(argname="argument enable_explanations", value=enable_explanations, expected_type=type_hints["enable_explanations"])
                check_type(argname="argument inference_config", value=inference_config, expected_type=type_hints["inference_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "shap_config": shap_config,
            }
            if enable_explanations is not None:
                self._values["enable_explanations"] = enable_explanations
            if inference_config is not None:
                self._values["inference_config"] = inference_config

        @builtins.property
        def shap_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapConfigProperty"]:
            '''``CfnEndpointConfig.ClarifyExplainerConfigProperty.ShapConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-shapconfig
            '''
            result = self._values.get("shap_config")
            assert result is not None, "Required property 'shap_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapConfigProperty"], result)

        @builtins.property
        def enable_explanations(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyExplainerConfigProperty.EnableExplanations``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-enableexplanations
            '''
            result = self._values.get("enable_explanations")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyInferenceConfigProperty"]]:
            '''``CfnEndpointConfig.ClarifyExplainerConfigProperty.InferenceConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-inferenceconfig
            '''
            result = self._values.get("inference_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyInferenceConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyExplainerConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "content_template": "contentTemplate",
            "feature_headers": "featureHeaders",
            "features_attribute": "featuresAttribute",
            "feature_types": "featureTypes",
            "label_attribute": "labelAttribute",
            "label_headers": "labelHeaders",
            "label_index": "labelIndex",
            "max_payload_in_mb": "maxPayloadInMb",
            "max_record_count": "maxRecordCount",
            "probability_attribute": "probabilityAttribute",
            "probability_index": "probabilityIndex",
        },
    )
    class ClarifyInferenceConfigProperty:
        def __init__(
            self,
            *,
            content_template: typing.Optional[builtins.str] = None,
            feature_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            features_attribute: typing.Optional[builtins.str] = None,
            feature_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            label_attribute: typing.Optional[builtins.str] = None,
            label_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            label_index: typing.Optional[jsii.Number] = None,
            max_payload_in_mb: typing.Optional[jsii.Number] = None,
            max_record_count: typing.Optional[jsii.Number] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            probability_index: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''
            :param content_template: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.ContentTemplate``.
            :param feature_headers: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureHeaders``.
            :param features_attribute: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeaturesAttribute``.
            :param feature_types: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureTypes``.
            :param label_attribute: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelAttribute``.
            :param label_headers: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelHeaders``.
            :param label_index: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelIndex``.
            :param max_payload_in_mb: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxPayloadInMB``.
            :param max_record_count: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxRecordCount``.
            :param probability_attribute: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityAttribute``.
            :param probability_index: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityIndex``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_inference_config_property = sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                    content_template="contentTemplate",
                    feature_headers=["featureHeaders"],
                    features_attribute="featuresAttribute",
                    feature_types=["featureTypes"],
                    label_attribute="labelAttribute",
                    label_headers=["labelHeaders"],
                    label_index=123,
                    max_payload_in_mb=123,
                    max_record_count=123,
                    probability_attribute="probabilityAttribute",
                    probability_index=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__219c4bc4be82ae8b985455b761775c8949e24bde8f8339359c77ac29849deaa3)
                check_type(argname="argument content_template", value=content_template, expected_type=type_hints["content_template"])
                check_type(argname="argument feature_headers", value=feature_headers, expected_type=type_hints["feature_headers"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument feature_types", value=feature_types, expected_type=type_hints["feature_types"])
                check_type(argname="argument label_attribute", value=label_attribute, expected_type=type_hints["label_attribute"])
                check_type(argname="argument label_headers", value=label_headers, expected_type=type_hints["label_headers"])
                check_type(argname="argument label_index", value=label_index, expected_type=type_hints["label_index"])
                check_type(argname="argument max_payload_in_mb", value=max_payload_in_mb, expected_type=type_hints["max_payload_in_mb"])
                check_type(argname="argument max_record_count", value=max_record_count, expected_type=type_hints["max_record_count"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument probability_index", value=probability_index, expected_type=type_hints["probability_index"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if content_template is not None:
                self._values["content_template"] = content_template
            if feature_headers is not None:
                self._values["feature_headers"] = feature_headers
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if feature_types is not None:
                self._values["feature_types"] = feature_types
            if label_attribute is not None:
                self._values["label_attribute"] = label_attribute
            if label_headers is not None:
                self._values["label_headers"] = label_headers
            if label_index is not None:
                self._values["label_index"] = label_index
            if max_payload_in_mb is not None:
                self._values["max_payload_in_mb"] = max_payload_in_mb
            if max_record_count is not None:
                self._values["max_record_count"] = max_record_count
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if probability_index is not None:
                self._values["probability_index"] = probability_index

        @builtins.property
        def content_template(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.ContentTemplate``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-contenttemplate
            '''
            result = self._values.get("content_template")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def feature_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureHeaders``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featureheaders
            '''
            result = self._values.get("feature_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeaturesAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def feature_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureTypes``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuretypes
            '''
            result = self._values.get("feature_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def label_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelattribute
            '''
            result = self._values.get("label_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def label_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelHeaders``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelheaders
            '''
            result = self._values.get("label_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def label_index(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelIndex``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelindex
            '''
            result = self._values.get("label_index")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def max_payload_in_mb(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxPayloadInMB``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxpayloadinmb
            '''
            result = self._values.get("max_payload_in_mb")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def max_record_count(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxRecordCount``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxrecordcount
            '''
            result = self._values.get("max_record_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_index(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityIndex``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityindex
            '''
            result = self._values.get("probability_index")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyInferenceConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "mime_type": "mimeType",
            "shap_baseline": "shapBaseline",
            "shap_baseline_uri": "shapBaselineUri",
        },
    )
    class ClarifyShapBaselineConfigProperty:
        def __init__(
            self,
            *,
            mime_type: typing.Optional[builtins.str] = None,
            shap_baseline: typing.Optional[builtins.str] = None,
            shap_baseline_uri: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param mime_type: ``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.MimeType``.
            :param shap_baseline: ``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaseline``.
            :param shap_baseline_uri: ``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaselineUri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_shap_baseline_config_property = sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                    mime_type="mimeType",
                    shap_baseline="shapBaseline",
                    shap_baseline_uri="shapBaselineUri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cdc07b2ae81ca067b669ad8eee10c233a84cec6816b6e1eaeb4a3c9022fb49f4)
                check_type(argname="argument mime_type", value=mime_type, expected_type=type_hints["mime_type"])
                check_type(argname="argument shap_baseline", value=shap_baseline, expected_type=type_hints["shap_baseline"])
                check_type(argname="argument shap_baseline_uri", value=shap_baseline_uri, expected_type=type_hints["shap_baseline_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if mime_type is not None:
                self._values["mime_type"] = mime_type
            if shap_baseline is not None:
                self._values["shap_baseline"] = shap_baseline
            if shap_baseline_uri is not None:
                self._values["shap_baseline_uri"] = shap_baseline_uri

        @builtins.property
        def mime_type(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.MimeType``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-mimetype
            '''
            result = self._values.get("mime_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shap_baseline(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaseline``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaseline
            '''
            result = self._values.get("shap_baseline")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shap_baseline_uri(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaselineUri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaselineuri
            '''
            result = self._values.get("shap_baseline_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyShapBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "shap_baseline_config": "shapBaselineConfig",
            "number_of_samples": "numberOfSamples",
            "seed": "seed",
            "text_config": "textConfig",
            "use_logit": "useLogit",
        },
    )
    class ClarifyShapConfigProperty:
        def __init__(
            self,
            *,
            shap_baseline_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyShapBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            number_of_samples: typing.Optional[jsii.Number] = None,
            seed: typing.Optional[jsii.Number] = None,
            text_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyTextConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            use_logit: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param shap_baseline_config: ``CfnEndpointConfig.ClarifyShapConfigProperty.ShapBaselineConfig``.
            :param number_of_samples: ``CfnEndpointConfig.ClarifyShapConfigProperty.NumberOfSamples``.
            :param seed: ``CfnEndpointConfig.ClarifyShapConfigProperty.Seed``.
            :param text_config: ``CfnEndpointConfig.ClarifyShapConfigProperty.TextConfig``.
            :param use_logit: ``CfnEndpointConfig.ClarifyShapConfigProperty.UseLogit``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_shap_config_property = sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                    shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                        mime_type="mimeType",
                        shap_baseline="shapBaseline",
                        shap_baseline_uri="shapBaselineUri"
                    ),
                
                    # the properties below are optional
                    number_of_samples=123,
                    seed=123,
                    text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                        granularity="granularity",
                        language="language"
                    ),
                    use_logit=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d13ff204bac34e66abda71c300286f5367bc3e95b80ce1f5be250f0fd508e677)
                check_type(argname="argument shap_baseline_config", value=shap_baseline_config, expected_type=type_hints["shap_baseline_config"])
                check_type(argname="argument number_of_samples", value=number_of_samples, expected_type=type_hints["number_of_samples"])
                check_type(argname="argument seed", value=seed, expected_type=type_hints["seed"])
                check_type(argname="argument text_config", value=text_config, expected_type=type_hints["text_config"])
                check_type(argname="argument use_logit", value=use_logit, expected_type=type_hints["use_logit"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "shap_baseline_config": shap_baseline_config,
            }
            if number_of_samples is not None:
                self._values["number_of_samples"] = number_of_samples
            if seed is not None:
                self._values["seed"] = seed
            if text_config is not None:
                self._values["text_config"] = text_config
            if use_logit is not None:
                self._values["use_logit"] = use_logit

        @builtins.property
        def shap_baseline_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapBaselineConfigProperty"]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.ShapBaselineConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-shapbaselineconfig
            '''
            result = self._values.get("shap_baseline_config")
            assert result is not None, "Required property 'shap_baseline_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyShapBaselineConfigProperty"], result)

        @builtins.property
        def number_of_samples(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.NumberOfSamples``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-numberofsamples
            '''
            result = self._values.get("number_of_samples")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def seed(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.Seed``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-seed
            '''
            result = self._values.get("seed")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def text_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyTextConfigProperty"]]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.TextConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-textconfig
            '''
            result = self._values.get("text_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyTextConfigProperty"]], result)

        @builtins.property
        def use_logit(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.UseLogit``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-uselogit
            '''
            result = self._values.get("use_logit")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyShapConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"granularity": "granularity", "language": "language"},
    )
    class ClarifyTextConfigProperty:
        def __init__(
            self,
            *,
            granularity: builtins.str,
            language: builtins.str,
        ) -> None:
            '''
            :param granularity: ``CfnEndpointConfig.ClarifyTextConfigProperty.Granularity``.
            :param language: ``CfnEndpointConfig.ClarifyTextConfigProperty.Language``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                clarify_text_config_property = sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                    granularity="granularity",
                    language="language"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bb02c2885c5605c12d9e5b35849a33c20ae5db4791746707dc4165477061ed2d)
                check_type(argname="argument granularity", value=granularity, expected_type=type_hints["granularity"])
                check_type(argname="argument language", value=language, expected_type=type_hints["language"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "granularity": granularity,
                "language": language,
            }

        @builtins.property
        def granularity(self) -> builtins.str:
            '''``CfnEndpointConfig.ClarifyTextConfigProperty.Granularity``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-granularity
            '''
            result = self._values.get("granularity")
            assert result is not None, "Required property 'granularity' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def language(self) -> builtins.str:
            '''``CfnEndpointConfig.ClarifyTextConfigProperty.Language``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-language
            '''
            result = self._values.get("language")
            assert result is not None, "Required property 'language' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyTextConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.DataCaptureConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "capture_options": "captureOptions",
            "destination_s3_uri": "destinationS3Uri",
            "initial_sampling_percentage": "initialSamplingPercentage",
            "capture_content_type_header": "captureContentTypeHeader",
            "enable_capture": "enableCapture",
            "kms_key_id": "kmsKeyId",
        },
    )
    class DataCaptureConfigProperty:
        def __init__(
            self,
            *,
            capture_options: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.CaptureOptionProperty", typing.Dict[builtins.str, typing.Any]]]]],
            destination_s3_uri: builtins.str,
            initial_sampling_percentage: jsii.Number,
            capture_content_type_header: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.CaptureContentTypeHeaderProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            enable_capture: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration of your endpoint for model monitor data capture.

            :param capture_options: Specifies whether the endpoint captures input data to your model, output data from your model, or both.
            :param destination_s3_uri: The S3 bucket where model monitor stores captured data.
            :param initial_sampling_percentage: The percentage of data to capture.
            :param capture_content_type_header: A list of the JSON and CSV content type that the endpoint captures.
            :param enable_capture: Set to ``True`` to enable data capture.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption. The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_capture_config_property = sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                    capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                        capture_mode="captureMode"
                    )],
                    destination_s3_uri="destinationS3Uri",
                    initial_sampling_percentage=123,
                
                    # the properties below are optional
                    capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    enable_capture=False,
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5f66371a559ba65ff125b2321cd8b6a93386ca97a2bbac0b89139668121914bb)
                check_type(argname="argument capture_options", value=capture_options, expected_type=type_hints["capture_options"])
                check_type(argname="argument destination_s3_uri", value=destination_s3_uri, expected_type=type_hints["destination_s3_uri"])
                check_type(argname="argument initial_sampling_percentage", value=initial_sampling_percentage, expected_type=type_hints["initial_sampling_percentage"])
                check_type(argname="argument capture_content_type_header", value=capture_content_type_header, expected_type=type_hints["capture_content_type_header"])
                check_type(argname="argument enable_capture", value=enable_capture, expected_type=type_hints["enable_capture"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "capture_options": capture_options,
                "destination_s3_uri": destination_s3_uri,
                "initial_sampling_percentage": initial_sampling_percentage,
            }
            if capture_content_type_header is not None:
                self._values["capture_content_type_header"] = capture_content_type_header
            if enable_capture is not None:
                self._values["enable_capture"] = enable_capture
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def capture_options(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureOptionProperty"]]]:
            '''Specifies whether the endpoint captures input data to your model, output data from your model, or both.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
            '''
            result = self._values.get("capture_options")
            assert result is not None, "Required property 'capture_options' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureOptionProperty"]]], result)

        @builtins.property
        def destination_s3_uri(self) -> builtins.str:
            '''The S3 bucket where model monitor stores captured data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
            '''
            result = self._values.get("destination_s3_uri")
            assert result is not None, "Required property 'destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def initial_sampling_percentage(self) -> jsii.Number:
            '''The percentage of data to capture.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
            '''
            result = self._values.get("initial_sampling_percentage")
            assert result is not None, "Required property 'initial_sampling_percentage' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def capture_content_type_header(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureContentTypeHeaderProperty"]]:
            '''A list of the JSON and CSV content type that the endpoint captures.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
            '''
            result = self._values.get("capture_content_type_header")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.CaptureContentTypeHeaderProperty"]], result)

        @builtins.property
        def enable_capture(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Set to ``True`` to enable data capture.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
            '''
            result = self._values.get("enable_capture")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.

            The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataCaptureConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ExplainerConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"clarify_explainer_config": "clarifyExplainerConfig"},
    )
    class ExplainerConfigProperty:
        def __init__(
            self,
            *,
            clarify_explainer_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ClarifyExplainerConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''
            :param clarify_explainer_config: ``CfnEndpointConfig.ExplainerConfigProperty.ClarifyExplainerConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                explainer_config_property = sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                    clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                        shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                            shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                                mime_type="mimeType",
                                shap_baseline="shapBaseline",
                                shap_baseline_uri="shapBaselineUri"
                            ),
                
                            # the properties below are optional
                            number_of_samples=123,
                            seed=123,
                            text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                                granularity="granularity",
                                language="language"
                            ),
                            use_logit=False
                        ),
                
                        # the properties below are optional
                        enable_explanations="enableExplanations",
                        inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                            content_template="contentTemplate",
                            feature_headers=["featureHeaders"],
                            features_attribute="featuresAttribute",
                            feature_types=["featureTypes"],
                            label_attribute="labelAttribute",
                            label_headers=["labelHeaders"],
                            label_index=123,
                            max_payload_in_mb=123,
                            max_record_count=123,
                            probability_attribute="probabilityAttribute",
                            probability_index=123
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bca400d67b7e0b7493acf5a52ff4165f4d522d876c087e0e3b8c804a10c9e4e5)
                check_type(argname="argument clarify_explainer_config", value=clarify_explainer_config, expected_type=type_hints["clarify_explainer_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if clarify_explainer_config is not None:
                self._values["clarify_explainer_config"] = clarify_explainer_config

        @builtins.property
        def clarify_explainer_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyExplainerConfigProperty"]]:
            '''``CfnEndpointConfig.ExplainerConfigProperty.ClarifyExplainerConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html#cfn-sagemaker-endpointconfig-explainerconfig-clarifyexplainerconfig
            '''
            result = self._values.get("clarify_explainer_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ClarifyExplainerConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ExplainerConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ProductionVariantProperty",
        jsii_struct_bases=[],
        name_mapping={
            "initial_variant_weight": "initialVariantWeight",
            "model_name": "modelName",
            "variant_name": "variantName",
            "accelerator_type": "acceleratorType",
            "container_startup_health_check_timeout_in_seconds": "containerStartupHealthCheckTimeoutInSeconds",
            "enable_ssm_access": "enableSsmAccess",
            "initial_instance_count": "initialInstanceCount",
            "instance_type": "instanceType",
            "model_data_download_timeout_in_seconds": "modelDataDownloadTimeoutInSeconds",
            "serverless_config": "serverlessConfig",
            "volume_size_in_gb": "volumeSizeInGb",
        },
    )
    class ProductionVariantProperty:
        def __init__(
            self,
            *,
            initial_variant_weight: jsii.Number,
            model_name: builtins.str,
            variant_name: builtins.str,
            accelerator_type: typing.Optional[builtins.str] = None,
            container_startup_health_check_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            enable_ssm_access: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            initial_instance_count: typing.Optional[jsii.Number] = None,
            instance_type: typing.Optional[builtins.str] = None,
            model_data_download_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            serverless_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnEndpointConfig.ServerlessConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            volume_size_in_gb: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Specifies a model that you want to host and the resources to deploy for hosting it.

            If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying the ``InitialVariantWeight`` objects.

            :param initial_variant_weight: Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the ``VariantWeight`` to the sum of all ``VariantWeight`` values across all ProductionVariants. If unspecified, it defaults to 1.0.
            :param model_name: The name of the model that you want to host. This is the name that you specified when creating the model.
            :param variant_name: The name of the production variant.
            :param accelerator_type: The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ . For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ .
            :param container_startup_health_check_timeout_in_seconds: ``CfnEndpointConfig.ProductionVariantProperty.ContainerStartupHealthCheckTimeoutInSeconds``.
            :param enable_ssm_access: ``CfnEndpointConfig.ProductionVariantProperty.EnableSSMAccess``.
            :param initial_instance_count: Number of instances to launch initially.
            :param instance_type: The ML compute instance type.
            :param model_data_download_timeout_in_seconds: ``CfnEndpointConfig.ProductionVariantProperty.ModelDataDownloadTimeoutInSeconds``.
            :param serverless_config: The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
            :param volume_size_in_gb: ``CfnEndpointConfig.ProductionVariantProperty.VolumeSizeInGB``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                production_variant_property = sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    initial_variant_weight=123,
                    model_name="modelName",
                    variant_name="variantName",
                
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    enable_ssm_access=False,
                    initial_instance_count=123,
                    instance_type="instanceType",
                    model_data_download_timeout_in_seconds=123,
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123,
                
                        # the properties below are optional
                        provisioned_concurrency=123
                    ),
                    volume_size_in_gb=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__685c22aefe4bd12e237f4e6f239c6de7809e228c81d2604127d6824fa36dee01)
                check_type(argname="argument initial_variant_weight", value=initial_variant_weight, expected_type=type_hints["initial_variant_weight"])
                check_type(argname="argument model_name", value=model_name, expected_type=type_hints["model_name"])
                check_type(argname="argument variant_name", value=variant_name, expected_type=type_hints["variant_name"])
                check_type(argname="argument accelerator_type", value=accelerator_type, expected_type=type_hints["accelerator_type"])
                check_type(argname="argument container_startup_health_check_timeout_in_seconds", value=container_startup_health_check_timeout_in_seconds, expected_type=type_hints["container_startup_health_check_timeout_in_seconds"])
                check_type(argname="argument enable_ssm_access", value=enable_ssm_access, expected_type=type_hints["enable_ssm_access"])
                check_type(argname="argument initial_instance_count", value=initial_instance_count, expected_type=type_hints["initial_instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument model_data_download_timeout_in_seconds", value=model_data_download_timeout_in_seconds, expected_type=type_hints["model_data_download_timeout_in_seconds"])
                check_type(argname="argument serverless_config", value=serverless_config, expected_type=type_hints["serverless_config"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "initial_variant_weight": initial_variant_weight,
                "model_name": model_name,
                "variant_name": variant_name,
            }
            if accelerator_type is not None:
                self._values["accelerator_type"] = accelerator_type
            if container_startup_health_check_timeout_in_seconds is not None:
                self._values["container_startup_health_check_timeout_in_seconds"] = container_startup_health_check_timeout_in_seconds
            if enable_ssm_access is not None:
                self._values["enable_ssm_access"] = enable_ssm_access
            if initial_instance_count is not None:
                self._values["initial_instance_count"] = initial_instance_count
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if model_data_download_timeout_in_seconds is not None:
                self._values["model_data_download_timeout_in_seconds"] = model_data_download_timeout_in_seconds
            if serverless_config is not None:
                self._values["serverless_config"] = serverless_config
            if volume_size_in_gb is not None:
                self._values["volume_size_in_gb"] = volume_size_in_gb

        @builtins.property
        def initial_variant_weight(self) -> jsii.Number:
            '''Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.

            The traffic to a production variant is determined by the ratio of the ``VariantWeight`` to the sum of all ``VariantWeight`` values across all ProductionVariants. If unspecified, it defaults to 1.0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
            '''
            result = self._values.get("initial_variant_weight")
            assert result is not None, "Required property 'initial_variant_weight' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def model_name(self) -> builtins.str:
            '''The name of the model that you want to host.

            This is the name that you specified when creating the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
            '''
            result = self._values.get("model_name")
            assert result is not None, "Required property 'model_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def variant_name(self) -> builtins.str:
            '''The name of the production variant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
            '''
            result = self._values.get("variant_name")
            assert result is not None, "Required property 'variant_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def accelerator_type(self) -> typing.Optional[builtins.str]:
            '''The size of the Elastic Inference (EI) instance to use for the production variant.

            EI instances provide on-demand GPU computing for inference. For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ . For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
            '''
            result = self._values.get("accelerator_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def container_startup_health_check_timeout_in_seconds(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ProductionVariantProperty.ContainerStartupHealthCheckTimeoutInSeconds``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-containerstartuphealthchecktimeoutinseconds
            '''
            result = self._values.get("container_startup_health_check_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def enable_ssm_access(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnEndpointConfig.ProductionVariantProperty.EnableSSMAccess``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-enablessmaccess
            '''
            result = self._values.get("enable_ssm_access")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def initial_instance_count(self) -> typing.Optional[jsii.Number]:
            '''Number of instances to launch initially.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
            '''
            result = self._values.get("initial_instance_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The ML compute instance type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def model_data_download_timeout_in_seconds(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ProductionVariantProperty.ModelDataDownloadTimeoutInSeconds``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modeldatadownloadtimeoutinseconds
            '''
            result = self._values.get("model_data_download_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def serverless_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ServerlessConfigProperty"]]:
            '''The serverless configuration for an endpoint.

            Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig
            '''
            result = self._values.get("serverless_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnEndpointConfig.ServerlessConfigProperty"]], result)

        @builtins.property
        def volume_size_in_gb(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ProductionVariantProperty.VolumeSizeInGB``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ProductionVariantProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ServerlessConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_concurrency": "maxConcurrency",
            "memory_size_in_mb": "memorySizeInMb",
            "provisioned_concurrency": "provisionedConcurrency",
        },
    )
    class ServerlessConfigProperty:
        def __init__(
            self,
            *,
            max_concurrency: jsii.Number,
            memory_size_in_mb: jsii.Number,
            provisioned_concurrency: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Specifies the serverless configuration for an endpoint variant.

            :param max_concurrency: The maximum number of concurrent invocations your serverless endpoint can process.
            :param memory_size_in_mb: The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
            :param provisioned_concurrency: ``CfnEndpointConfig.ServerlessConfigProperty.ProvisionedConcurrency``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant-serverlessconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                serverless_config_property = sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123,
                
                    # the properties below are optional
                    provisioned_concurrency=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__106fe363b377b1cd93971d0e7e50c104cd6274d6f8c54c71faa17da1c784753b)
                check_type(argname="argument max_concurrency", value=max_concurrency, expected_type=type_hints["max_concurrency"])
                check_type(argname="argument memory_size_in_mb", value=memory_size_in_mb, expected_type=type_hints["memory_size_in_mb"])
                check_type(argname="argument provisioned_concurrency", value=provisioned_concurrency, expected_type=type_hints["provisioned_concurrency"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_concurrency": max_concurrency,
                "memory_size_in_mb": memory_size_in_mb,
            }
            if provisioned_concurrency is not None:
                self._values["provisioned_concurrency"] = provisioned_concurrency

        @builtins.property
        def max_concurrency(self) -> jsii.Number:
            '''The maximum number of concurrent invocations your serverless endpoint can process.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant-serverlessconfig.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig-maxconcurrency
            '''
            result = self._values.get("max_concurrency")
            assert result is not None, "Required property 'max_concurrency' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def memory_size_in_mb(self) -> jsii.Number:
            '''The memory size of your serverless endpoint.

            Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant-serverlessconfig.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig-memorysizeinmb
            '''
            result = self._values.get("memory_size_in_mb")
            assert result is not None, "Required property 'memory_size_in_mb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def provisioned_concurrency(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ServerlessConfigProperty.ProvisionedConcurrency``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant-serverlessconfig.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig-provisionedconcurrency
            '''
            result = self._values.get("provisioned_concurrency")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ServerlessConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointConfigProps",
    jsii_struct_bases=[],
    name_mapping={
        "production_variants": "productionVariants",
        "async_inference_config": "asyncInferenceConfig",
        "data_capture_config": "dataCaptureConfig",
        "endpoint_config_name": "endpointConfigName",
        "explainer_config": "explainerConfig",
        "kms_key_id": "kmsKeyId",
        "shadow_production_variants": "shadowProductionVariants",
        "tags": "tags",
    },
)
class CfnEndpointConfigProps:
    def __init__(
        self,
        *,
        production_variants: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.ProductionVariantProperty, typing.Dict[builtins.str, typing.Any]]]]],
        async_inference_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.AsyncInferenceConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        data_capture_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.DataCaptureConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_config_name: typing.Optional[builtins.str] = None,
        explainer_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.ExplainerConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        shadow_production_variants: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpointConfig.ProductionVariantProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnEndpointConfig``.

        :param production_variants: A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.
        :param async_inference_config: Specifies configuration for how an endpoint performs asynchronous inference.
        :param data_capture_config: Specifies how to capture endpoint data for model monitor. The data capture configuration applies to all production variants hosted at the endpoint.
        :param endpoint_config_name: The name of the endpoint configuration.
        :param explainer_config: ``AWS::SageMaker::EndpointConfig.ExplainerConfig``.
        :param kms_key_id: The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` - Alias name: ``alias/ExampleAlias`` - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`` The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_ .. epigraph:: Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails. For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ . For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .
        :param shadow_production_variants: Array of ``ProductionVariant`` objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_endpoint_config_props = sagemaker.CfnEndpointConfigProps(
                production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    initial_variant_weight=123,
                    model_name="modelName",
                    variant_name="variantName",
            
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    enable_ssm_access=False,
                    initial_instance_count=123,
                    instance_type="instanceType",
                    model_data_download_timeout_in_seconds=123,
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123,
            
                        # the properties below are optional
                        provisioned_concurrency=123
                    ),
                    volume_size_in_gb=123
                )],
            
                # the properties below are optional
                async_inference_config=sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                    output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                        kms_key_id="kmsKeyId",
                        notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                            error_topic="errorTopic",
                            include_inference_response_in=["includeInferenceResponseIn"],
                            success_topic="successTopic"
                        ),
                        s3_failure_path="s3FailurePath",
                        s3_output_path="s3OutputPath"
                    ),
            
                    # the properties below are optional
                    client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                        max_concurrent_invocations_per_instance=123
                    )
                ),
                data_capture_config=sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                    capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                        capture_mode="captureMode"
                    )],
                    destination_s3_uri="destinationS3Uri",
                    initial_sampling_percentage=123,
            
                    # the properties below are optional
                    capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    enable_capture=False,
                    kms_key_id="kmsKeyId"
                ),
                endpoint_config_name="endpointConfigName",
                explainer_config=sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                    clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                        shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                            shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                                mime_type="mimeType",
                                shap_baseline="shapBaseline",
                                shap_baseline_uri="shapBaselineUri"
                            ),
            
                            # the properties below are optional
                            number_of_samples=123,
                            seed=123,
                            text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                                granularity="granularity",
                                language="language"
                            ),
                            use_logit=False
                        ),
            
                        # the properties below are optional
                        enable_explanations="enableExplanations",
                        inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                            content_template="contentTemplate",
                            feature_headers=["featureHeaders"],
                            features_attribute="featuresAttribute",
                            feature_types=["featureTypes"],
                            label_attribute="labelAttribute",
                            label_headers=["labelHeaders"],
                            label_index=123,
                            max_payload_in_mb=123,
                            max_record_count=123,
                            probability_attribute="probabilityAttribute",
                            probability_index=123
                        )
                    )
                ),
                kms_key_id="kmsKeyId",
                shadow_production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    initial_variant_weight=123,
                    model_name="modelName",
                    variant_name="variantName",
            
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    enable_ssm_access=False,
                    initial_instance_count=123,
                    instance_type="instanceType",
                    model_data_download_timeout_in_seconds=123,
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123,
            
                        # the properties below are optional
                        provisioned_concurrency=123
                    ),
                    volume_size_in_gb=123
                )],
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78ef2b9ddede793caaf7b19d01bb59252a5dbfeb2526319f7e6ad617b37c5814)
            check_type(argname="argument production_variants", value=production_variants, expected_type=type_hints["production_variants"])
            check_type(argname="argument async_inference_config", value=async_inference_config, expected_type=type_hints["async_inference_config"])
            check_type(argname="argument data_capture_config", value=data_capture_config, expected_type=type_hints["data_capture_config"])
            check_type(argname="argument endpoint_config_name", value=endpoint_config_name, expected_type=type_hints["endpoint_config_name"])
            check_type(argname="argument explainer_config", value=explainer_config, expected_type=type_hints["explainer_config"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument shadow_production_variants", value=shadow_production_variants, expected_type=type_hints["shadow_production_variants"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "production_variants": production_variants,
        }
        if async_inference_config is not None:
            self._values["async_inference_config"] = async_inference_config
        if data_capture_config is not None:
            self._values["data_capture_config"] = data_capture_config
        if endpoint_config_name is not None:
            self._values["endpoint_config_name"] = endpoint_config_name
        if explainer_config is not None:
            self._values["explainer_config"] = explainer_config
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if shadow_production_variants is not None:
            self._values["shadow_production_variants"] = shadow_production_variants
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def production_variants(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]]:
        '''A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
        '''
        result = self._values.get("production_variants")
        assert result is not None, "Required property 'production_variants' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]], result)

    @builtins.property
    def async_inference_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.AsyncInferenceConfigProperty]]:
        '''Specifies configuration for how an endpoint performs asynchronous inference.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig
        '''
        result = self._values.get("async_inference_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.AsyncInferenceConfigProperty]], result)

    @builtins.property
    def data_capture_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.DataCaptureConfigProperty]]:
        '''Specifies how to capture endpoint data for model monitor.

        The data capture configuration applies to all production variants hosted at the endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
        '''
        result = self._values.get("data_capture_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.DataCaptureConfigProperty]], result)

    @builtins.property
    def endpoint_config_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint configuration.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
        '''
        result = self._values.get("endpoint_config_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def explainer_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ExplainerConfigProperty]]:
        '''``AWS::SageMaker::EndpointConfig.ExplainerConfig``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig
        '''
        result = self._values.get("explainer_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ExplainerConfigProperty]], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.

        - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab``
        - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab``
        - Alias name: ``alias/ExampleAlias``
        - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias``

        The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_
        .. epigraph::

           Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails.

           For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ .

           For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shadow_production_variants(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]]]:
        '''Array of ``ProductionVariant`` objects.

        There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants
        '''
        result = self._values.get("shadow_production_variants")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpointConfig.ProductionVariantProperty]]]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEndpointConfigProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnEndpointProps",
    jsii_struct_bases=[],
    name_mapping={
        "endpoint_config_name": "endpointConfigName",
        "deployment_config": "deploymentConfig",
        "endpoint_name": "endpointName",
        "exclude_retained_variant_properties": "excludeRetainedVariantProperties",
        "retain_all_variant_properties": "retainAllVariantProperties",
        "retain_deployment_config": "retainDeploymentConfig",
        "tags": "tags",
    },
)
class CfnEndpointProps:
    def __init__(
        self,
        *,
        endpoint_config_name: builtins.str,
        deployment_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpoint.DeploymentConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        exclude_retained_variant_properties: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnEndpoint.VariantPropertyProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        retain_all_variant_properties: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        retain_deployment_config: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnEndpoint``.

        :param endpoint_config_name: The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .
        :param deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param endpoint_name: The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .
        :param exclude_retained_variant_properties: When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .
        :param retain_all_variant_properties: When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.
        :param retain_deployment_config: Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_endpoint_props = sagemaker.CfnEndpointProps(
                endpoint_config_name="endpointConfigName",
            
                # the properties below are optional
                deployment_config=sagemaker.CfnEndpoint.DeploymentConfigProperty(
                    blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                        traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                            type="type",
            
                            # the properties below are optional
                            canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            wait_interval_in_seconds=123
                        ),
            
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        termination_wait_in_seconds=123
                    ),
            
                    # the properties below are optional
                    auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                        alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                            alarm_name="alarmName"
                        )]
                    )
                ),
                endpoint_name="endpointName",
                exclude_retained_variant_properties=[sagemaker.CfnEndpoint.VariantPropertyProperty(
                    variant_property_type="variantPropertyType"
                )],
                retain_all_variant_properties=False,
                retain_deployment_config=False,
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52a2e56834295c61b7da5a9bf2f08a781f50e70d1e6a1452ded8f8b0cc1245c1)
            check_type(argname="argument endpoint_config_name", value=endpoint_config_name, expected_type=type_hints["endpoint_config_name"])
            check_type(argname="argument deployment_config", value=deployment_config, expected_type=type_hints["deployment_config"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument exclude_retained_variant_properties", value=exclude_retained_variant_properties, expected_type=type_hints["exclude_retained_variant_properties"])
            check_type(argname="argument retain_all_variant_properties", value=retain_all_variant_properties, expected_type=type_hints["retain_all_variant_properties"])
            check_type(argname="argument retain_deployment_config", value=retain_deployment_config, expected_type=type_hints["retain_deployment_config"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoint_config_name": endpoint_config_name,
        }
        if deployment_config is not None:
            self._values["deployment_config"] = deployment_config
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if exclude_retained_variant_properties is not None:
            self._values["exclude_retained_variant_properties"] = exclude_retained_variant_properties
        if retain_all_variant_properties is not None:
            self._values["retain_all_variant_properties"] = retain_all_variant_properties
        if retain_deployment_config is not None:
            self._values["retain_deployment_config"] = retain_deployment_config
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def endpoint_config_name(self) -> builtins.str:
        '''The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
        '''
        result = self._values.get("endpoint_config_name")
        assert result is not None, "Required property 'endpoint_config_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def deployment_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpoint.DeploymentConfigProperty]]:
        '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
        '''
        result = self._values.get("deployment_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnEndpoint.DeploymentConfigProperty]], result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def exclude_retained_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpoint.VariantPropertyProperty]]]]:
        '''When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
        '''
        result = self._values.get("exclude_retained_variant_properties")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnEndpoint.VariantPropertyProperty]]]], result)

    @builtins.property
    def retain_all_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.

        To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
        '''
        result = self._values.get("retain_all_variant_properties")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

    @builtins.property
    def retain_deployment_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''Specifies whether to reuse the last deployment configuration.

        The default value is false (the configuration is not reused).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig
        '''
        result = self._values.get("retain_deployment_config")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEndpointProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnFeatureGroup(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup",
):
    '''A CloudFormation ``AWS::SageMaker::FeatureGroup``.

    Create a new ``FeatureGroup`` . A ``FeatureGroup`` is a group of ``Features`` defined in the ``FeatureStore`` to describe a ``Record`` .

    The ``FeatureGroup`` defines the schema and features contained in the FeatureGroup. A ``FeatureGroup`` definition is composed of a list of ``Features`` , a ``RecordIdentifierFeatureName`` , an ``EventTimeFeatureName`` and configurations for its ``OnlineStore`` and ``OfflineStore`` . Check `AWS service quotas <https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html>`_ to see the ``FeatureGroup`` s quota for your AWS account.
    .. epigraph::

       You must include at least one of ``OnlineStoreConfig`` and ``OfflineStoreConfig`` to create a ``FeatureGroup`` .

    :cloudformationResource: AWS::SageMaker::FeatureGroup
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        # offline_store_config: Any
        # online_store_config: Any
        
        cfn_feature_group = sagemaker.CfnFeatureGroup(self, "MyCfnFeatureGroup",
            event_time_feature_name="eventTimeFeatureName",
            feature_definitions=[sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                feature_name="featureName",
                feature_type="featureType"
            )],
            feature_group_name="featureGroupName",
            record_identifier_feature_name="recordIdentifierFeatureName",
        
            # the properties below are optional
            description="description",
            offline_store_config=offline_store_config,
            online_store_config=online_store_config,
            role_arn="roleArn",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        event_time_feature_name: builtins.str,
        feature_definitions: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.FeatureDefinitionProperty", typing.Dict[builtins.str, typing.Any]]]]],
        feature_group_name: builtins.str,
        record_identifier_feature_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        offline_store_config: typing.Any = None,
        online_store_config: typing.Any = None,
        role_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::FeatureGroup``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param event_time_feature_name: The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` . A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .
        :param feature_definitions: A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` . Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` . ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` . You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .
        :param feature_group_name: The name of the ``FeatureGroup`` .
        :param record_identifier_feature_name: The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .
        :param description: A free form description of a ``FeatureGroup`` .
        :param offline_store_config: The configuration of an ``OfflineStore`` .
        :param online_store_config: The configuration of an ``OnlineStore`` .
        :param role_arn: The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
        :param tags: Tags used to define a ``FeatureGroup`` .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4102c01580236aeaa8183dc09f0ab2d908ee3b4650df43ce2419ef038f864258)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnFeatureGroupProps(
            event_time_feature_name=event_time_feature_name,
            feature_definitions=feature_definitions,
            feature_group_name=feature_group_name,
            record_identifier_feature_name=record_identifier_feature_name,
            description=description,
            offline_store_config=offline_store_config,
            online_store_config=online_store_config,
            role_arn=role_arn,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cd6259820b736e87a6da7d27e2e1e1a14b614640e31da0fcb54668a45db785f)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4377922dbd7c3d2d8d521bce16c0e6ef23d2e76a3cd1823cfe6bb698934e9794)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Tags used to define a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="eventTimeFeatureName")
    def event_time_feature_name(self) -> builtins.str:
        '''The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` .

        A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename
        '''
        return typing.cast(builtins.str, jsii.get(self, "eventTimeFeatureName"))

    @event_time_feature_name.setter
    def event_time_feature_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8adfc53ff0bc63839afe55973c1f5c8873bebb52fb98328b9839255298b674b9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "eventTimeFeatureName", value)

    @builtins.property
    @jsii.member(jsii_name="featureDefinitions")
    def feature_definitions(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.FeatureDefinitionProperty"]]]:
        '''A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` .

        Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

        ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

        You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.FeatureDefinitionProperty"]]], jsii.get(self, "featureDefinitions"))

    @feature_definitions.setter
    def feature_definitions(
        self,
        value: typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.FeatureDefinitionProperty"]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__554ed28625ccedc71ce244f01f302b22d68e2b9ad204918f91e7f3fd85527e61)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "featureDefinitions", value)

    @builtins.property
    @jsii.member(jsii_name="featureGroupName")
    def feature_group_name(self) -> builtins.str:
        '''The name of the ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname
        '''
        return typing.cast(builtins.str, jsii.get(self, "featureGroupName"))

    @feature_group_name.setter
    def feature_group_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6f4169fe264f570e3e6859737b587e566b9716d614cf3a24902f6b04cde8b93)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "featureGroupName", value)

    @builtins.property
    @jsii.member(jsii_name="offlineStoreConfig")
    def offline_store_config(self) -> typing.Any:
        '''The configuration of an ``OfflineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig
        '''
        return typing.cast(typing.Any, jsii.get(self, "offlineStoreConfig"))

    @offline_store_config.setter
    def offline_store_config(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35a3cd1a7f2eeb38ecbdecb8d787b667dd2fb89f595b3887438fb9c49ebe2125)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "offlineStoreConfig", value)

    @builtins.property
    @jsii.member(jsii_name="onlineStoreConfig")
    def online_store_config(self) -> typing.Any:
        '''The configuration of an ``OnlineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig
        '''
        return typing.cast(typing.Any, jsii.get(self, "onlineStoreConfig"))

    @online_store_config.setter
    def online_store_config(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36874ea58589f290874ec1f6e4483a6eaf3b42f76d17dd0b2c0aa81106ea1710)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "onlineStoreConfig", value)

    @builtins.property
    @jsii.member(jsii_name="recordIdentifierFeatureName")
    def record_identifier_feature_name(self) -> builtins.str:
        '''The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename
        '''
        return typing.cast(builtins.str, jsii.get(self, "recordIdentifierFeatureName"))

    @record_identifier_feature_name.setter
    def record_identifier_feature_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b78873bd7aeb067f399e0d34bbfcead148ee8cd93f599510cd64c6e738908832)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "recordIdentifierFeatureName", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A free form description of a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b3eb81281cd3d68bb6a0b5a3ea79863153df71f1420743d27c3d773a2fd6c98)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dd4c4dc86f0dd4d52ceac67d70b2ea2229a255079338500d2261a011ff1b32ee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.DataCatalogConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "catalog": "catalog",
            "database": "database",
            "table_name": "tableName",
        },
    )
    class DataCatalogConfigProperty:
        def __init__(
            self,
            *,
            catalog: builtins.str,
            database: builtins.str,
            table_name: builtins.str,
        ) -> None:
            '''The meta data of the Glue table which serves as data catalog for the ``OfflineStore`` .

            :param catalog: The name of the Glue table catalog.
            :param database: The name of the Glue table database.
            :param table_name: The name of the Glue table.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_catalog_config_property = sagemaker.CfnFeatureGroup.DataCatalogConfigProperty(
                    catalog="catalog",
                    database="database",
                    table_name="tableName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4caa5f76e9359d50b237d02f2288070020184465e320800c861a60749c9be45b)
                check_type(argname="argument catalog", value=catalog, expected_type=type_hints["catalog"])
                check_type(argname="argument database", value=database, expected_type=type_hints["database"])
                check_type(argname="argument table_name", value=table_name, expected_type=type_hints["table_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "catalog": catalog,
                "database": database,
                "table_name": table_name,
            }

        @builtins.property
        def catalog(self) -> builtins.str:
            '''The name of the Glue table catalog.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-catalog
            '''
            result = self._values.get("catalog")
            assert result is not None, "Required property 'catalog' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def database(self) -> builtins.str:
            '''The name of the Glue table database.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-database
            '''
            result = self._values.get("database")
            assert result is not None, "Required property 'database' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def table_name(self) -> builtins.str:
            '''The name of the Glue table.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-tablename
            '''
            result = self._values.get("table_name")
            assert result is not None, "Required property 'table_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataCatalogConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.FeatureDefinitionProperty",
        jsii_struct_bases=[],
        name_mapping={"feature_name": "featureName", "feature_type": "featureType"},
    )
    class FeatureDefinitionProperty:
        def __init__(
            self,
            *,
            feature_name: builtins.str,
            feature_type: builtins.str,
        ) -> None:
            '''A list of features.

            You must include ``FeatureName`` and ``FeatureType`` . Valid feature ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

            :param feature_name: The name of a feature. The type must be a string. ``FeatureName`` cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .
            :param feature_type: The value type of a feature. Valid values are Integral, Fractional, or String.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                feature_definition_property = sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                    feature_name="featureName",
                    feature_type="featureType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__04848822e3ad8782bf48bda17c952f5ed10b1558aac29dcca56aa3c21c34f2a1)
                check_type(argname="argument feature_name", value=feature_name, expected_type=type_hints["feature_name"])
                check_type(argname="argument feature_type", value=feature_type, expected_type=type_hints["feature_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "feature_name": feature_name,
                "feature_type": feature_type,
            }

        @builtins.property
        def feature_name(self) -> builtins.str:
            '''The name of a feature.

            The type must be a string. ``FeatureName`` cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featurename
            '''
            result = self._values.get("feature_name")
            assert result is not None, "Required property 'feature_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def feature_type(self) -> builtins.str:
            '''The value type of a feature.

            Valid values are Integral, Fractional, or String.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featuretype
            '''
            result = self._values.get("feature_type")
            assert result is not None, "Required property 'feature_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FeatureDefinitionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "s3_storage_config": "s3StorageConfig",
            "data_catalog_config": "dataCatalogConfig",
            "disable_glue_table_creation": "disableGlueTableCreation",
            "table_format": "tableFormat",
        },
    )
    class OfflineStoreConfigProperty:
        def __init__(
            self,
            *,
            s3_storage_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.S3StorageConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            data_catalog_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.DataCatalogConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            disable_glue_table_creation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            table_format: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration of an ``OfflineStore`` .

            Provide an ``OfflineStoreConfig`` in a request to ``CreateFeatureGroup`` to create an ``OfflineStore`` .

            To encrypt an ``OfflineStore`` using at rest data encryption, specify AWS Key Management Service (KMS) key ID, or ``KMSKeyId`` , in ``S3StorageConfig`` .

            :param s3_storage_config: The Amazon Simple Storage (Amazon S3) location of ``OfflineStore`` .
            :param data_catalog_config: The meta data of the Glue table that is autogenerated when an ``OfflineStore`` is created.
            :param disable_glue_table_creation: Set to ``True`` to disable the automatic creation of an AWS Glue table when configuring an ``OfflineStore`` . If set to ``False`` , Feature Store will name the ``OfflineStore`` Glue table following `Athena's naming recommendations <https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html>`_ . The default value is ``False`` .
            :param table_format: ``CfnFeatureGroup.OfflineStoreConfigProperty.TableFormat``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                offline_store_config_property = sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty(
                    s3_storage_config=sagemaker.CfnFeatureGroup.S3StorageConfigProperty(
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        kms_key_id="kmsKeyId"
                    ),
                
                    # the properties below are optional
                    data_catalog_config=sagemaker.CfnFeatureGroup.DataCatalogConfigProperty(
                        catalog="catalog",
                        database="database",
                        table_name="tableName"
                    ),
                    disable_glue_table_creation=False,
                    table_format="tableFormat"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2f29e7edde4b24306bda02357db072f0b29e6110817a4c588bd3c02734019d42)
                check_type(argname="argument s3_storage_config", value=s3_storage_config, expected_type=type_hints["s3_storage_config"])
                check_type(argname="argument data_catalog_config", value=data_catalog_config, expected_type=type_hints["data_catalog_config"])
                check_type(argname="argument disable_glue_table_creation", value=disable_glue_table_creation, expected_type=type_hints["disable_glue_table_creation"])
                check_type(argname="argument table_format", value=table_format, expected_type=type_hints["table_format"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_storage_config": s3_storage_config,
            }
            if data_catalog_config is not None:
                self._values["data_catalog_config"] = data_catalog_config
            if disable_glue_table_creation is not None:
                self._values["disable_glue_table_creation"] = disable_glue_table_creation
            if table_format is not None:
                self._values["table_format"] = table_format

        @builtins.property
        def s3_storage_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.S3StorageConfigProperty"]:
            '''The Amazon Simple Storage (Amazon S3) location of ``OfflineStore`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-s3storageconfig
            '''
            result = self._values.get("s3_storage_config")
            assert result is not None, "Required property 's3_storage_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.S3StorageConfigProperty"], result)

        @builtins.property
        def data_catalog_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.DataCatalogConfigProperty"]]:
            '''The meta data of the Glue table that is autogenerated when an ``OfflineStore`` is created.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-datacatalogconfig
            '''
            result = self._values.get("data_catalog_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.DataCatalogConfigProperty"]], result)

        @builtins.property
        def disable_glue_table_creation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Set to ``True`` to disable the automatic creation of an AWS Glue table when configuring an ``OfflineStore`` .

            If set to ``False`` , Feature Store will name the ``OfflineStore`` Glue table following `Athena's naming recommendations <https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html>`_ .

            The default value is ``False`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-disablegluetablecreation
            '''
            result = self._values.get("disable_glue_table_creation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def table_format(self) -> typing.Optional[builtins.str]:
            '''``CfnFeatureGroup.OfflineStoreConfigProperty.TableFormat``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-tableformat
            '''
            result = self._values.get("table_format")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OfflineStoreConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_online_store": "enableOnlineStore",
            "security_config": "securityConfig",
        },
    )
    class OnlineStoreConfigProperty:
        def __init__(
            self,
            *,
            enable_online_store: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            security_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnFeatureGroup.OnlineStoreSecurityConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Use this to specify the AWS Key Management Service (KMS) Key ID, or ``KMSKeyId`` , for at rest data encryption.

            You can turn ``OnlineStore`` on or off by specifying the ``EnableOnlineStore`` flag at General Assembly.

            The default value is ``False`` .

            :param enable_online_store: Turn ``OnlineStore`` off by specifying ``False`` for the ``EnableOnlineStore`` flag. Turn ``OnlineStore`` on by specifying ``True`` for the ``EnableOnlineStore`` flag. The default value is ``False`` .
            :param security_config: Use to specify KMS Key ID ( ``KMSKeyId`` ) for at-rest encryption of your ``OnlineStore`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                online_store_config_property = sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty(
                    enable_online_store=False,
                    security_config=sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty(
                        kms_key_id="kmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4068ec17c64be821371cb37a174b97e325a38220882aa92f5b086d22af6c9c9b)
                check_type(argname="argument enable_online_store", value=enable_online_store, expected_type=type_hints["enable_online_store"])
                check_type(argname="argument security_config", value=security_config, expected_type=type_hints["security_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_online_store is not None:
                self._values["enable_online_store"] = enable_online_store
            if security_config is not None:
                self._values["security_config"] = security_config

        @builtins.property
        def enable_online_store(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Turn ``OnlineStore`` off by specifying ``False`` for the ``EnableOnlineStore`` flag.

            Turn ``OnlineStore`` on by specifying ``True`` for the ``EnableOnlineStore`` flag.

            The default value is ``False`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-enableonlinestore
            '''
            result = self._values.get("enable_online_store")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def security_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.OnlineStoreSecurityConfigProperty"]]:
            '''Use to specify KMS Key ID ( ``KMSKeyId`` ) for at-rest encryption of your ``OnlineStore`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-securityconfig
            '''
            result = self._values.get("security_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnFeatureGroup.OnlineStoreSecurityConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OnlineStoreConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"kms_key_id": "kmsKeyId"},
    )
    class OnlineStoreSecurityConfigProperty:
        def __init__(self, *, kms_key_id: typing.Optional[builtins.str] = None) -> None:
            '''The security configuration for ``OnlineStore`` .

            :param kms_key_id: The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption. The caller (either user or IAM role) of ``CreateFeatureGroup`` must have below permissions to the ``OnlineStore`` ``KmsKeyId`` : - ``"kms:Encrypt"`` - ``"kms:Decrypt"`` - ``"kms:DescribeKey"`` - ``"kms:CreateGrant"`` - ``"kms:RetireGrant"`` - ``"kms:ReEncryptFrom"`` - ``"kms:ReEncryptTo"`` - ``"kms:GenerateDataKey"`` - ``"kms:ListAliases"`` - ``"kms:ListGrants"`` - ``"kms:RevokeGrant"`` The caller (either user or IAM role) to all DataPlane operations ( ``PutRecord`` , ``GetRecord`` , ``DeleteRecord`` ) must have the following permissions to the ``KmsKeyId`` : - ``"kms:Decrypt"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                online_store_security_config_property = sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty(
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9ba97e020f46b5d443fb0f7a2b65107dfb083e44bf5c9573eb5b040837128996)
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.

            The caller (either user or IAM role) of ``CreateFeatureGroup`` must have below permissions to the ``OnlineStore`` ``KmsKeyId`` :

            - ``"kms:Encrypt"``
            - ``"kms:Decrypt"``
            - ``"kms:DescribeKey"``
            - ``"kms:CreateGrant"``
            - ``"kms:RetireGrant"``
            - ``"kms:ReEncryptFrom"``
            - ``"kms:ReEncryptTo"``
            - ``"kms:GenerateDataKey"``
            - ``"kms:ListAliases"``
            - ``"kms:ListGrants"``
            - ``"kms:RevokeGrant"``

            The caller (either user or IAM role) to all DataPlane operations ( ``PutRecord`` , ``GetRecord`` , ``DeleteRecord`` ) must have the following permissions to the ``KmsKeyId`` :

            - ``"kms:Decrypt"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html#cfn-sagemaker-featuregroup-onlinestoresecurityconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OnlineStoreSecurityConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.S3StorageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri", "kms_key_id": "kmsKeyId"},
    )
    class S3StorageConfigProperty:
        def __init__(
            self,
            *,
            s3_uri: builtins.str,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon Simple Storage (Amazon S3) location and and security configuration for ``OfflineStore`` .

            :param s3_uri: The S3 URI, or location in Amazon S3, of ``OfflineStore`` . S3 URIs have a format similar to the following: ``s3://example-bucket/prefix/`` .
            :param kms_key_id: The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the ``OfflineStore`` S3 location. The IAM ``roleARN`` that is passed as a parameter to ``CreateFeatureGroup`` must have below permissions to the ``KmsKeyId`` : - ``"kms:GenerateDataKey"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                s3_storage_config_property = sagemaker.CfnFeatureGroup.S3StorageConfigProperty(
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4deea26cb2dc59d1dedd4813cf07b36e4bf8da5eff8446a0b746de73938917fc)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_uri": s3_uri,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''The S3 URI, or location in Amazon S3, of ``OfflineStore`` .

            S3 URIs have a format similar to the following: ``s3://example-bucket/prefix/`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the ``OfflineStore`` S3 location.

            The IAM ``roleARN`` that is passed as a parameter to ``CreateFeatureGroup`` must have below permissions to the ``KmsKeyId`` :

            - ``"kms:GenerateDataKey"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3StorageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnFeatureGroupProps",
    jsii_struct_bases=[],
    name_mapping={
        "event_time_feature_name": "eventTimeFeatureName",
        "feature_definitions": "featureDefinitions",
        "feature_group_name": "featureGroupName",
        "record_identifier_feature_name": "recordIdentifierFeatureName",
        "description": "description",
        "offline_store_config": "offlineStoreConfig",
        "online_store_config": "onlineStoreConfig",
        "role_arn": "roleArn",
        "tags": "tags",
    },
)
class CfnFeatureGroupProps:
    def __init__(
        self,
        *,
        event_time_feature_name: builtins.str,
        feature_definitions: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnFeatureGroup.FeatureDefinitionProperty, typing.Dict[builtins.str, typing.Any]]]]],
        feature_group_name: builtins.str,
        record_identifier_feature_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        offline_store_config: typing.Any = None,
        online_store_config: typing.Any = None,
        role_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnFeatureGroup``.

        :param event_time_feature_name: The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` . A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .
        :param feature_definitions: A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` . Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` . ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` . You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .
        :param feature_group_name: The name of the ``FeatureGroup`` .
        :param record_identifier_feature_name: The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .
        :param description: A free form description of a ``FeatureGroup`` .
        :param offline_store_config: The configuration of an ``OfflineStore`` .
        :param online_store_config: The configuration of an ``OnlineStore`` .
        :param role_arn: The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
        :param tags: Tags used to define a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            # offline_store_config: Any
            # online_store_config: Any
            
            cfn_feature_group_props = sagemaker.CfnFeatureGroupProps(
                event_time_feature_name="eventTimeFeatureName",
                feature_definitions=[sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                    feature_name="featureName",
                    feature_type="featureType"
                )],
                feature_group_name="featureGroupName",
                record_identifier_feature_name="recordIdentifierFeatureName",
            
                # the properties below are optional
                description="description",
                offline_store_config=offline_store_config,
                online_store_config=online_store_config,
                role_arn="roleArn",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb1e9da53f754dd8978f06cdc95c9101b0ef89f3b1a689ab0a1e92eacd0a0951)
            check_type(argname="argument event_time_feature_name", value=event_time_feature_name, expected_type=type_hints["event_time_feature_name"])
            check_type(argname="argument feature_definitions", value=feature_definitions, expected_type=type_hints["feature_definitions"])
            check_type(argname="argument feature_group_name", value=feature_group_name, expected_type=type_hints["feature_group_name"])
            check_type(argname="argument record_identifier_feature_name", value=record_identifier_feature_name, expected_type=type_hints["record_identifier_feature_name"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument offline_store_config", value=offline_store_config, expected_type=type_hints["offline_store_config"])
            check_type(argname="argument online_store_config", value=online_store_config, expected_type=type_hints["online_store_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "event_time_feature_name": event_time_feature_name,
            "feature_definitions": feature_definitions,
            "feature_group_name": feature_group_name,
            "record_identifier_feature_name": record_identifier_feature_name,
        }
        if description is not None:
            self._values["description"] = description
        if offline_store_config is not None:
            self._values["offline_store_config"] = offline_store_config
        if online_store_config is not None:
            self._values["online_store_config"] = online_store_config
        if role_arn is not None:
            self._values["role_arn"] = role_arn
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def event_time_feature_name(self) -> builtins.str:
        '''The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` .

        A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename
        '''
        result = self._values.get("event_time_feature_name")
        assert result is not None, "Required property 'event_time_feature_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def feature_definitions(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnFeatureGroup.FeatureDefinitionProperty]]]:
        '''A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` .

        Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

        ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

        You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions
        '''
        result = self._values.get("feature_definitions")
        assert result is not None, "Required property 'feature_definitions' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnFeatureGroup.FeatureDefinitionProperty]]], result)

    @builtins.property
    def feature_group_name(self) -> builtins.str:
        '''The name of the ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname
        '''
        result = self._values.get("feature_group_name")
        assert result is not None, "Required property 'feature_group_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def record_identifier_feature_name(self) -> builtins.str:
        '''The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename
        '''
        result = self._values.get("record_identifier_feature_name")
        assert result is not None, "Required property 'record_identifier_feature_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A free form description of a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def offline_store_config(self) -> typing.Any:
        '''The configuration of an ``OfflineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig
        '''
        result = self._values.get("offline_store_config")
        return typing.cast(typing.Any, result)

    @builtins.property
    def online_store_config(self) -> typing.Any:
        '''The configuration of an ``OnlineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig
        '''
        result = self._values.get("online_store_config")
        return typing.cast(typing.Any, result)

    @builtins.property
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn
        '''
        result = self._values.get("role_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Tags used to define a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnFeatureGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnImage(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImage",
):
    '''A CloudFormation ``AWS::SageMaker::Image``.

    Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Elastic Container Registry (ECR). For more information, see `Bring your own SageMaker image <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html>`_ .

    :cloudformationResource: AWS::SageMaker::Image
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_image = sagemaker.CfnImage(self, "MyCfnImage",
            image_name="imageName",
            image_role_arn="imageRoleArn",
        
            # the properties below are optional
            image_description="imageDescription",
            image_display_name="imageDisplayName",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        image_name: builtins.str,
        image_role_arn: builtins.str,
        image_description: typing.Optional[builtins.str] = None,
        image_display_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Image``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param image_name: The name of the Image. Must be unique by region in your account. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. *Length Constraints* : Minimum length of 20. Maximum length of 2048. *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``
        :param image_description: The description of the image. *Length Constraints* : Minimum length of 1. Maximum length of 512. *Pattern* : ``.*``
        :param image_display_name: The display name of the image. *Length Constraints* : Minimum length of 1. Maximum length of 128. *Pattern* : ``^\\S(.*\\S)?$``
        :param tags: A list of key-value pairs to apply to this resource. *Array Members* : Minimum number of 0 items. Maximum number of 50 items.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dde982bdab4dea21946725303bd84c1eb61267733b6351eb23c00f7d036f6966)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnImageProps(
            image_name=image_name,
            image_role_arn=image_role_arn,
            image_description=image_description,
            image_display_name=image_display_name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3683228322bbbd09cb4aac0a4469f1685a49afb4d71c553abbab272eaef100dc)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4230003faeb71eb706948f19ec046a12d72b36d81d5e22c11bcc3b1ebe02c2c0)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrImageArn")
    def attr_image_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the image.

        *Type* : String

        *Length Constraints* : Maximum length of 256.

        *Pattern* : ``^arn:aws(-[\\w]+)*:sagemaker:.+:[0-9]{12}:image/[a-z0-9]([-.]?[a-z0-9])*$``

        :cloudformationAttribute: ImageArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''A list of key-value pairs to apply to this resource.

        *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="imageName")
    def image_name(self) -> builtins.str:
        '''The name of the Image. Must be unique by region in your account.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagename
        '''
        return typing.cast(builtins.str, jsii.get(self, "imageName"))

    @image_name.setter
    def image_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c83dda1eec4dea7e586e14528740a9a908c8dc9cfdfaa25322bcb6254256fe95)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageName", value)

    @builtins.property
    @jsii.member(jsii_name="imageRoleArn")
    def image_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.

        *Length Constraints* : Minimum length of 20. Maximum length of 2048.

        *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagerolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "imageRoleArn"))

    @image_role_arn.setter
    def image_role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4cb3cf1a068192a3c85d41bfd4e7865613f5eaad72e81e906ea09806af1a6a2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageRoleArn", value)

    @builtins.property
    @jsii.member(jsii_name="imageDescription")
    def image_description(self) -> typing.Optional[builtins.str]:
        '''The description of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 512.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedescription
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageDescription"))

    @image_description.setter
    def image_description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d98fb90f3bdd23e0a7e2f8f7f3b5da1a34a2efdfb7989565b70a598777d1d2e9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageDescription", value)

    @builtins.property
    @jsii.member(jsii_name="imageDisplayName")
    def image_display_name(self) -> typing.Optional[builtins.str]:
        '''The display name of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 128.

        *Pattern* : ``^\\S(.*\\S)?$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedisplayname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageDisplayName"))

    @image_display_name.setter
    def image_display_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9507742917d9e396f824e9318497084f8ae68b4ebb9daa0f6845e96629a78a4d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageDisplayName", value)


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImageProps",
    jsii_struct_bases=[],
    name_mapping={
        "image_name": "imageName",
        "image_role_arn": "imageRoleArn",
        "image_description": "imageDescription",
        "image_display_name": "imageDisplayName",
        "tags": "tags",
    },
)
class CfnImageProps:
    def __init__(
        self,
        *,
        image_name: builtins.str,
        image_role_arn: builtins.str,
        image_description: typing.Optional[builtins.str] = None,
        image_display_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnImage``.

        :param image_name: The name of the Image. Must be unique by region in your account. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. *Length Constraints* : Minimum length of 20. Maximum length of 2048. *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``
        :param image_description: The description of the image. *Length Constraints* : Minimum length of 1. Maximum length of 512. *Pattern* : ``.*``
        :param image_display_name: The display name of the image. *Length Constraints* : Minimum length of 1. Maximum length of 128. *Pattern* : ``^\\S(.*\\S)?$``
        :param tags: A list of key-value pairs to apply to this resource. *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_image_props = sagemaker.CfnImageProps(
                image_name="imageName",
                image_role_arn="imageRoleArn",
            
                # the properties below are optional
                image_description="imageDescription",
                image_display_name="imageDisplayName",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc32c041f4bbebc30466bd7f70f1571b2e2a1def5e8e2166caa2d830a35fe8e8)
            check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
            check_type(argname="argument image_role_arn", value=image_role_arn, expected_type=type_hints["image_role_arn"])
            check_type(argname="argument image_description", value=image_description, expected_type=type_hints["image_description"])
            check_type(argname="argument image_display_name", value=image_display_name, expected_type=type_hints["image_display_name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "image_name": image_name,
            "image_role_arn": image_role_arn,
        }
        if image_description is not None:
            self._values["image_description"] = image_description
        if image_display_name is not None:
            self._values["image_display_name"] = image_display_name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def image_name(self) -> builtins.str:
        '''The name of the Image. Must be unique by region in your account.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagename
        '''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.

        *Length Constraints* : Minimum length of 20. Maximum length of 2048.

        *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagerolearn
        '''
        result = self._values.get("image_role_arn")
        assert result is not None, "Required property 'image_role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_description(self) -> typing.Optional[builtins.str]:
        '''The description of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 512.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedescription
        '''
        result = self._values.get("image_description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_display_name(self) -> typing.Optional[builtins.str]:
        '''The display name of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 128.

        *Pattern* : ``^\\S(.*\\S)?$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedisplayname
        '''
        result = self._values.get("image_display_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''A list of key-value pairs to apply to this resource.

        *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnImageProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnImageVersion(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImageVersion",
):
    '''A CloudFormation ``AWS::SageMaker::ImageVersion``.

    Creates a version of the SageMaker image specified by ``ImageName`` . The version represents the Amazon Container Registry (ECR) container image specified by ``BaseImage`` .
    .. epigraph::

       You can use the ``DependsOn`` attribute to specify that the creation of a specific resource follows another. You can use it for the following use cases. For more information, see ```DependsOn`` attribute <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html>`_ .

       1. ``DependsOn`` can be used to establish a parent/child relationship between ``ImageVersion`` and ``Image`` where the ``ImageVersion`` ``DependsOn`` the ``Image`` .
       2. ``DependsOn`` can be used to establish order among ``ImageVersion`` s within the same ``Image`` namespace. For example, if ImageVersionB ``DependsOn`` ImageVersionA and both share the same parent ``Image`` , then ImageVersionA is version N and ImageVersionB is N+1.

    :cloudformationResource: AWS::SageMaker::ImageVersion
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_image_version = sagemaker.CfnImageVersion(self, "MyCfnImageVersion",
            base_image="baseImage",
            image_name="imageName"
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        base_image: builtins.str,
        image_name: builtins.str,
    ) -> None:
        '''Create a new ``AWS::SageMaker::ImageVersion``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param base_image: The container image that the SageMaker image version is based on. *Length Constraints* : Minimum length of 1. Maximum length of 255. *Pattern* : ``.*``
        :param image_name: The name of the parent image. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ad8c361f2876657ea1cf0f0f9f7356de06575f95ad80d7a587da19094ecd39f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnImageVersionProps(base_image=base_image, image_name=image_name)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5617eaff0fc7e0099928623a36e2b9f1458a37ad9fe1fa24bd54f054ebffae4)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c4bc42175535dc7e1f18100775e38634217828944c7afb9a921d5d4ded34609)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrContainerImage")
    def attr_container_image(self) -> builtins.str:
        '''The URI of the container image version referenced by ImageVersion.

        :cloudformationAttribute: ContainerImage
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrContainerImage"))

    @builtins.property
    @jsii.member(jsii_name="attrImageArn")
    def attr_image_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the parent Image.

        :cloudformationAttribute: ImageArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageArn"))

    @builtins.property
    @jsii.member(jsii_name="attrImageVersionArn")
    def attr_image_version_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the image version.

        *Type* : String

        *Length Constraints* : Maximum length of 256.

        *Pattern* : ``^arn:aws(-[\\w]+)*:sagemaker:.+:[0-9]{12}:image-version/[a-z0-9]([-.]?[a-z0-9])* /[0-9]+$``

        :cloudformationAttribute: ImageVersionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageVersionArn"))

    @builtins.property
    @jsii.member(jsii_name="attrVersion")
    def attr_version(self) -> jsii.Number:
        '''The version of the image.

        :cloudformationAttribute: Version
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrVersion"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="baseImage")
    def base_image(self) -> builtins.str:
        '''The container image that the SageMaker image version is based on.

        *Length Constraints* : Minimum length of 1. Maximum length of 255.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage
        '''
        return typing.cast(builtins.str, jsii.get(self, "baseImage"))

    @base_image.setter
    def base_image(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cd7f0125c670f13843a82d4765f1707e53ed79633a107bc8f478ee89f7c4447)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "baseImage", value)

    @builtins.property
    @jsii.member(jsii_name="imageName")
    def image_name(self) -> builtins.str:
        '''The name of the parent image.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename
        '''
        return typing.cast(builtins.str, jsii.get(self, "imageName"))

    @image_name.setter
    def image_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__32397b68bd7477c88dd5aca2fab6262902fec8c5be04520516af969354dc3411)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageName", value)


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnImageVersionProps",
    jsii_struct_bases=[],
    name_mapping={"base_image": "baseImage", "image_name": "imageName"},
)
class CfnImageVersionProps:
    def __init__(self, *, base_image: builtins.str, image_name: builtins.str) -> None:
        '''Properties for defining a ``CfnImageVersion``.

        :param base_image: The container image that the SageMaker image version is based on. *Length Constraints* : Minimum length of 1. Maximum length of 255. *Pattern* : ``.*``
        :param image_name: The name of the parent image. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_image_version_props = sagemaker.CfnImageVersionProps(
                base_image="baseImage",
                image_name="imageName"
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb1cf2f49fa3a5bb0e6e9fdd2097a7a9401edb65fabfda045235c1b04b02fbf1)
            check_type(argname="argument base_image", value=base_image, expected_type=type_hints["base_image"])
            check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "base_image": base_image,
            "image_name": image_name,
        }

    @builtins.property
    def base_image(self) -> builtins.str:
        '''The container image that the SageMaker image version is based on.

        *Length Constraints* : Minimum length of 1. Maximum length of 255.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage
        '''
        result = self._values.get("base_image")
        assert result is not None, "Required property 'base_image' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_name(self) -> builtins.str:
        '''The name of the parent image.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename
        '''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnImageVersionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnInferenceExperiment(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment",
):
    '''A CloudFormation ``AWS::SageMaker::InferenceExperiment``.

    Creates an inference experiment using the configurations specified in the request.

    Use this API to setup and schedule an experiment to compare model variants on a Amazon SageMaker inference endpoint. For more information about inference experiments, see `Shadow tests <https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html>`_ .

    Amazon SageMaker begins your experiment at the scheduled time and routes traffic to your endpoint's model variants based on your specified configuration.

    While the experiment is in progress or after it has concluded, you can view metrics that compare your model variants. For more information, see `View, monitor, and edit shadow tests <https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests-view-monitor-edit.html>`_ .

    :cloudformationResource: AWS::SageMaker::InferenceExperiment
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_inference_experiment = sagemaker.CfnInferenceExperiment(self, "MyCfnInferenceExperiment",
            endpoint_name="endpointName",
            model_variants=[sagemaker.CfnInferenceExperiment.ModelVariantConfigProperty(
                infrastructure_config=sagemaker.CfnInferenceExperiment.ModelInfrastructureConfigProperty(
                    infrastructure_type="infrastructureType",
                    real_time_inference_config=sagemaker.CfnInferenceExperiment.RealTimeInferenceConfigProperty(
                        instance_count=123,
                        instance_type="instanceType"
                    )
                ),
                model_name="modelName",
                variant_name="variantName"
            )],
            name="name",
            role_arn="roleArn",
            type="type",
        
            # the properties below are optional
            data_storage_config=sagemaker.CfnInferenceExperiment.DataStorageConfigProperty(
                destination="destination",
        
                # the properties below are optional
                content_type=sagemaker.CfnInferenceExperiment.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                ),
                kms_key="kmsKey"
            ),
            description="description",
            desired_state="desiredState",
            kms_key="kmsKey",
            schedule=sagemaker.CfnInferenceExperiment.InferenceExperimentScheduleProperty(
                end_time="endTime",
                start_time="startTime"
            ),
            shadow_mode_config=sagemaker.CfnInferenceExperiment.ShadowModeConfigProperty(
                shadow_model_variants=[sagemaker.CfnInferenceExperiment.ShadowModelVariantConfigProperty(
                    sampling_percentage=123,
                    shadow_model_variant_name="shadowModelVariantName"
                )],
                source_model_variant_name="sourceModelVariantName"
            ),
            status_reason="statusReason",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        endpoint_name: builtins.str,
        model_variants: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.ModelVariantConfigProperty", typing.Dict[builtins.str, typing.Any]]]]],
        name: builtins.str,
        role_arn: builtins.str,
        type: builtins.str,
        data_storage_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.DataStorageConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        description: typing.Optional[builtins.str] = None,
        desired_state: typing.Optional[builtins.str] = None,
        kms_key: typing.Optional[builtins.str] = None,
        schedule: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.InferenceExperimentScheduleProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        shadow_mode_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.ShadowModeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        status_reason: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::InferenceExperiment``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param endpoint_name: The name of the endpoint.
        :param model_variants: An array of ``ModelVariantConfigSummary`` objects. There is one for each variant in the inference experiment. Each ``ModelVariantConfigSummary`` object in the array describes the infrastructure configuration for deploying the corresponding variant.
        :param name: The name of the inference experiment.
        :param role_arn: The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
        :param type: The type of the inference experiment.
        :param data_storage_config: The Amazon S3 location and configuration for storing inference request and response data.
        :param description: The description of the inference experiment.
        :param desired_state: The desired state of the experiment after stopping. The possible states are the following:. - ``Completed`` : The experiment completed successfully - ``Cancelled`` : The experiment was canceled
        :param kms_key: The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
        :param schedule: The duration for which the inference experiment ran or will run. The maximum duration that you can set for an inference experiment is 30 days.
        :param shadow_mode_config: The configuration of ``ShadowMode`` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
        :param status_reason: The error message for the inference experiment status result.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__43a6aafd6835d00baa8d211b8e504c33f5e79820719546466a90ba8ccba23e8b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnInferenceExperimentProps(
            endpoint_name=endpoint_name,
            model_variants=model_variants,
            name=name,
            role_arn=role_arn,
            type=type,
            data_storage_config=data_storage_config,
            description=description,
            desired_state=desired_state,
            kms_key=kms_key,
            schedule=schedule,
            shadow_mode_config=shadow_mode_config,
            status_reason=status_reason,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0429293b59a464f1c87e050fd5de3a0f1283acf5234761acc40dd9a0c1529ec6)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d5462c366a245602783769db7714995b6576c73554805c7d6edbb2f89fa9c82)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''
        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''
        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointMetadataEndpointConfigName")
    def attr_endpoint_metadata_endpoint_config_name(self) -> builtins.str:
        '''
        :cloudformationAttribute: EndpointMetadata.EndpointConfigName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointMetadataEndpointConfigName"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointMetadataEndpointName")
    def attr_endpoint_metadata_endpoint_name(self) -> builtins.str:
        '''
        :cloudformationAttribute: EndpointMetadata.EndpointName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointMetadataEndpointName"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointMetadataEndpointStatus")
    def attr_endpoint_metadata_endpoint_status(self) -> builtins.str:
        '''
        :cloudformationAttribute: EndpointMetadata.EndpointStatus
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointMetadataEndpointStatus"))

    @builtins.property
    @jsii.member(jsii_name="attrLastModifiedTime")
    def attr_last_modified_time(self) -> builtins.str:
        '''
        :cloudformationAttribute: LastModifiedTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLastModifiedTime"))

    @builtins.property
    @jsii.member(jsii_name="attrStatus")
    def attr_status(self) -> builtins.str:
        '''
        :cloudformationAttribute: Status
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrStatus"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> builtins.str:
        '''The name of the endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-endpointname
        '''
        return typing.cast(builtins.str, jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c4337f067fc258ce16c34b1da89725682a5cf8ff9f6a2ddd422b9f89840ee1a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="modelVariants")
    def model_variants(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ModelVariantConfigProperty"]]]:
        '''An array of ``ModelVariantConfigSummary`` objects.

        There is one for each variant in the inference experiment. Each ``ModelVariantConfigSummary`` object in the array describes the infrastructure configuration for deploying the corresponding variant.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-modelvariants
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ModelVariantConfigProperty"]]], jsii.get(self, "modelVariants"))

    @model_variants.setter
    def model_variants(
        self,
        value: typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ModelVariantConfigProperty"]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d41f9ab792b0ee24b059dd0c689f265f2cc5451883b9558031beef50d938eb62)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelVariants", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of the inference experiment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-name
        '''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__043744ee899f8ec5bbdbd1fbc6d8774cadd21db45111864f5c8ead306bb7b595)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d34c11a8c1a2565fd1bd312899edca7a17ece1ab4a263f6b77d6495463d16160)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        '''The type of the inference experiment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-type
        '''
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85a5c60f39e6ced69371734777bf1a7f5120ae90108f9878242836df2968b2cf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="dataStorageConfig")
    def data_storage_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.DataStorageConfigProperty"]]:
        '''The Amazon S3 location and configuration for storing inference request and response data.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-datastorageconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.DataStorageConfigProperty"]], jsii.get(self, "dataStorageConfig"))

    @data_storage_config.setter
    def data_storage_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.DataStorageConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ca53dbe0cab6482d1059c1abb3716bae126aa7390eed3feb2786f3f26ec1f3a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataStorageConfig", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''The description of the inference experiment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9675a0ad932dd544645220c342877b3a50604bc4af74f4945f49c0c1fa4bf9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="desiredState")
    def desired_state(self) -> typing.Optional[builtins.str]:
        '''The desired state of the experiment after stopping. The possible states are the following:.

        - ``Completed`` : The experiment completed successfully
        - ``Cancelled`` : The experiment was canceled

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-desiredstate
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "desiredState"))

    @desired_state.setter
    def desired_state(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__560c4e84471ced1b1564fbafbcde81a7c5199b6ab923155b20dfb4ffa055319a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "desiredState", value)

    @builtins.property
    @jsii.member(jsii_name="kmsKey")
    def kms_key(self) -> typing.Optional[builtins.str]:
        '''The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-kmskey
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "kmsKey"))

    @kms_key.setter
    def kms_key(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73ae7d64f9f9a718610ce8ac197a5da229e70b8d0dc49ef88b25fe0fd5c376d4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kmsKey", value)

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.InferenceExperimentScheduleProperty"]]:
        '''The duration for which the inference experiment ran or will run.

        The maximum duration that you can set for an inference experiment is 30 days.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-schedule
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.InferenceExperimentScheduleProperty"]], jsii.get(self, "schedule"))

    @schedule.setter
    def schedule(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.InferenceExperimentScheduleProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed6b54d3ee809b6078311472039cded4bd4bb4c3baf96c59e62c310c5ff476ab)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "schedule", value)

    @builtins.property
    @jsii.member(jsii_name="shadowModeConfig")
    def shadow_mode_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ShadowModeConfigProperty"]]:
        '''The configuration of ``ShadowMode`` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests.

        For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-shadowmodeconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ShadowModeConfigProperty"]], jsii.get(self, "shadowModeConfig"))

    @shadow_mode_config.setter
    def shadow_mode_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ShadowModeConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67f5007da506049c6e4d9db3b50bf4f19e91b2ec2cdc034cd3d9bf82d7c9d8f4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "shadowModeConfig", value)

    @builtins.property
    @jsii.member(jsii_name="statusReason")
    def status_reason(self) -> typing.Optional[builtins.str]:
        '''The error message for the inference experiment status result.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-statusreason
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "statusReason"))

    @status_reason.setter
    def status_reason(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dfebdc6aced204f5eadb3a382298b795ce8fc92befce5a9dcf2c97d6291e404e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "statusReason", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.CaptureContentTypeHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={
            "csv_content_types": "csvContentTypes",
            "json_content_types": "jsonContentTypes",
        },
    )
    class CaptureContentTypeHeaderProperty:
        def __init__(
            self,
            *,
            csv_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            json_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''Configuration specifying how to treat different headers.

            If no headers are specified SageMaker will by default base64 encode when capturing the data.

            :param csv_content_types: The list of all content type headers that SageMaker will treat as CSV and capture accordingly.
            :param json_content_types: The list of all content type headers that SageMaker will treat as JSON and capture accordingly.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-capturecontenttypeheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                capture_content_type_header_property = sagemaker.CfnInferenceExperiment.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7c0b271d1582078e305c84d489e11f37be3e2b7ef6c6198b16bdde2fd43eb6f4)
                check_type(argname="argument csv_content_types", value=csv_content_types, expected_type=type_hints["csv_content_types"])
                check_type(argname="argument json_content_types", value=json_content_types, expected_type=type_hints["json_content_types"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv_content_types is not None:
                self._values["csv_content_types"] = csv_content_types
            if json_content_types is not None:
                self._values["json_content_types"] = json_content_types

        @builtins.property
        def csv_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The list of all content type headers that SageMaker will treat as CSV and capture accordingly.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-capturecontenttypeheader.html#cfn-sagemaker-inferenceexperiment-capturecontenttypeheader-csvcontenttypes
            '''
            result = self._values.get("csv_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def json_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The list of all content type headers that SageMaker will treat as JSON and capture accordingly.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-capturecontenttypeheader.html#cfn-sagemaker-inferenceexperiment-capturecontenttypeheader-jsoncontenttypes
            '''
            result = self._values.get("json_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptureContentTypeHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.DataStorageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "destination": "destination",
            "content_type": "contentType",
            "kms_key": "kmsKey",
        },
    )
    class DataStorageConfigProperty:
        def __init__(
            self,
            *,
            destination: builtins.str,
            content_type: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.CaptureContentTypeHeaderProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            kms_key: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon S3 location and configuration for storing inference request and response data.

            This is an optional parameter that you can use for data capture. For more information, see `Capture data <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html>`_ .

            :param destination: The Amazon S3 bucket where the inference request and response data is stored.
            :param content_type: Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.
            :param kms_key: The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-datastorageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                data_storage_config_property = sagemaker.CfnInferenceExperiment.DataStorageConfigProperty(
                    destination="destination",
                
                    # the properties below are optional
                    content_type=sagemaker.CfnInferenceExperiment.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    kms_key="kmsKey"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4bb25738a9eaaf2cf105bc471ef7ba191fa9e7b1befb0d87ec8f0b7c0bbf555b)
                check_type(argname="argument destination", value=destination, expected_type=type_hints["destination"])
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
                check_type(argname="argument kms_key", value=kms_key, expected_type=type_hints["kms_key"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "destination": destination,
            }
            if content_type is not None:
                self._values["content_type"] = content_type
            if kms_key is not None:
                self._values["kms_key"] = kms_key

        @builtins.property
        def destination(self) -> builtins.str:
            '''The Amazon S3 bucket where the inference request and response data is stored.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-datastorageconfig.html#cfn-sagemaker-inferenceexperiment-datastorageconfig-destination
            '''
            result = self._values.get("destination")
            assert result is not None, "Required property 'destination' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def content_type(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.CaptureContentTypeHeaderProperty"]]:
            '''Configuration specifying how to treat different headers.

            If no headers are specified SageMaker will by default base64 encode when capturing the data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-datastorageconfig.html#cfn-sagemaker-inferenceexperiment-datastorageconfig-contenttype
            '''
            result = self._values.get("content_type")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.CaptureContentTypeHeaderProperty"]], result)

        @builtins.property
        def kms_key(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-datastorageconfig.html#cfn-sagemaker-inferenceexperiment-datastorageconfig-kmskey
            '''
            result = self._values.get("kms_key")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataStorageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.EndpointMetadataProperty",
        jsii_struct_bases=[],
        name_mapping={
            "endpoint_name": "endpointName",
            "endpoint_config_name": "endpointConfigName",
            "endpoint_status": "endpointStatus",
        },
    )
    class EndpointMetadataProperty:
        def __init__(
            self,
            *,
            endpoint_name: builtins.str,
            endpoint_config_name: typing.Optional[builtins.str] = None,
            endpoint_status: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The metadata of the endpoint.

            :param endpoint_name: The name of the endpoint.
            :param endpoint_config_name: The name of the endpoint configuration.
            :param endpoint_status: The status of the endpoint. For possible values of the status of an endpoint, see ` <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-endpointmetadata.html#cfn-sagemaker-inferenceexperiment-endpointmetadata-endpointstatus>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-endpointmetadata.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                endpoint_metadata_property = sagemaker.CfnInferenceExperiment.EndpointMetadataProperty(
                    endpoint_name="endpointName",
                
                    # the properties below are optional
                    endpoint_config_name="endpointConfigName",
                    endpoint_status="endpointStatus"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__584b8c3e18059227ecc04adc07f8c677504691a10ba94105216fb343fc851d8c)
                check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
                check_type(argname="argument endpoint_config_name", value=endpoint_config_name, expected_type=type_hints["endpoint_config_name"])
                check_type(argname="argument endpoint_status", value=endpoint_status, expected_type=type_hints["endpoint_status"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "endpoint_name": endpoint_name,
            }
            if endpoint_config_name is not None:
                self._values["endpoint_config_name"] = endpoint_config_name
            if endpoint_status is not None:
                self._values["endpoint_status"] = endpoint_status

        @builtins.property
        def endpoint_name(self) -> builtins.str:
            '''The name of the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-endpointmetadata.html#cfn-sagemaker-inferenceexperiment-endpointmetadata-endpointname
            '''
            result = self._values.get("endpoint_name")
            assert result is not None, "Required property 'endpoint_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def endpoint_config_name(self) -> typing.Optional[builtins.str]:
            '''The name of the endpoint configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-endpointmetadata.html#cfn-sagemaker-inferenceexperiment-endpointmetadata-endpointconfigname
            '''
            result = self._values.get("endpoint_config_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def endpoint_status(self) -> typing.Optional[builtins.str]:
            '''The status of the endpoint.

            For possible values of the status of an endpoint, see ` <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-endpointmetadata.html#cfn-sagemaker-inferenceexperiment-endpointmetadata-endpointstatus>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-endpointmetadata.html#cfn-sagemaker-inferenceexperiment-endpointmetadata-endpointstatus
            '''
            result = self._values.get("endpoint_status")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointMetadataProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.InferenceExperimentScheduleProperty",
        jsii_struct_bases=[],
        name_mapping={"end_time": "endTime", "start_time": "startTime"},
    )
    class InferenceExperimentScheduleProperty:
        def __init__(
            self,
            *,
            end_time: typing.Optional[builtins.str] = None,
            start_time: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The start and end times of an inference experiment.

            The maximum duration that you can set for an inference experiment is 30 days.

            :param end_time: The timestamp at which the inference experiment ended or will end.
            :param start_time: The timestamp at which the inference experiment started or will start.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-inferenceexperimentschedule.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                inference_experiment_schedule_property = sagemaker.CfnInferenceExperiment.InferenceExperimentScheduleProperty(
                    end_time="endTime",
                    start_time="startTime"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__acbe5d91e9d98b2305f92faad4290867d7222976052ee9514438e22424c987af)
                check_type(argname="argument end_time", value=end_time, expected_type=type_hints["end_time"])
                check_type(argname="argument start_time", value=start_time, expected_type=type_hints["start_time"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if end_time is not None:
                self._values["end_time"] = end_time
            if start_time is not None:
                self._values["start_time"] = start_time

        @builtins.property
        def end_time(self) -> typing.Optional[builtins.str]:
            '''The timestamp at which the inference experiment ended or will end.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-inferenceexperimentschedule.html#cfn-sagemaker-inferenceexperiment-inferenceexperimentschedule-endtime
            '''
            result = self._values.get("end_time")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def start_time(self) -> typing.Optional[builtins.str]:
            '''The timestamp at which the inference experiment started or will start.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-inferenceexperimentschedule.html#cfn-sagemaker-inferenceexperiment-inferenceexperimentschedule-starttime
            '''
            result = self._values.get("start_time")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InferenceExperimentScheduleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.ModelInfrastructureConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "infrastructure_type": "infrastructureType",
            "real_time_inference_config": "realTimeInferenceConfig",
        },
    )
    class ModelInfrastructureConfigProperty:
        def __init__(
            self,
            *,
            infrastructure_type: builtins.str,
            real_time_inference_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.RealTimeInferenceConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The configuration for the infrastructure that the model will be deployed to.

            :param infrastructure_type: The inference option to which to deploy your model. Possible values are the following:. - ``RealTime`` : Deploy to real-time inference.
            :param real_time_inference_config: The infrastructure configuration for deploying the model to real-time inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-modelinfrastructureconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                model_infrastructure_config_property = sagemaker.CfnInferenceExperiment.ModelInfrastructureConfigProperty(
                    infrastructure_type="infrastructureType",
                    real_time_inference_config=sagemaker.CfnInferenceExperiment.RealTimeInferenceConfigProperty(
                        instance_count=123,
                        instance_type="instanceType"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4b18fe8646349bdc2b21a39c725771f5758341e2b9462bbc2fa2551d36678833)
                check_type(argname="argument infrastructure_type", value=infrastructure_type, expected_type=type_hints["infrastructure_type"])
                check_type(argname="argument real_time_inference_config", value=real_time_inference_config, expected_type=type_hints["real_time_inference_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "infrastructure_type": infrastructure_type,
                "real_time_inference_config": real_time_inference_config,
            }

        @builtins.property
        def infrastructure_type(self) -> builtins.str:
            '''The inference option to which to deploy your model. Possible values are the following:.

            - ``RealTime`` : Deploy to real-time inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-modelinfrastructureconfig.html#cfn-sagemaker-inferenceexperiment-modelinfrastructureconfig-infrastructuretype
            '''
            result = self._values.get("infrastructure_type")
            assert result is not None, "Required property 'infrastructure_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def real_time_inference_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.RealTimeInferenceConfigProperty"]:
            '''The infrastructure configuration for deploying the model to real-time inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-modelinfrastructureconfig.html#cfn-sagemaker-inferenceexperiment-modelinfrastructureconfig-realtimeinferenceconfig
            '''
            result = self._values.get("real_time_inference_config")
            assert result is not None, "Required property 'real_time_inference_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.RealTimeInferenceConfigProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelInfrastructureConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.ModelVariantConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "infrastructure_config": "infrastructureConfig",
            "model_name": "modelName",
            "variant_name": "variantName",
        },
    )
    class ModelVariantConfigProperty:
        def __init__(
            self,
            *,
            infrastructure_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.ModelInfrastructureConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            model_name: builtins.str,
            variant_name: builtins.str,
        ) -> None:
            '''Contains information about the deployment options of a model.

            :param infrastructure_config: The configuration for the infrastructure that the model will be deployed to.
            :param model_name: The name of the Amazon SageMaker Model entity.
            :param variant_name: The name of the variant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-modelvariantconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                model_variant_config_property = sagemaker.CfnInferenceExperiment.ModelVariantConfigProperty(
                    infrastructure_config=sagemaker.CfnInferenceExperiment.ModelInfrastructureConfigProperty(
                        infrastructure_type="infrastructureType",
                        real_time_inference_config=sagemaker.CfnInferenceExperiment.RealTimeInferenceConfigProperty(
                            instance_count=123,
                            instance_type="instanceType"
                        )
                    ),
                    model_name="modelName",
                    variant_name="variantName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d3c170d8faf15db2d5807c2ae41d4a468de1df8e8a19c9c6caabe6d26f370a21)
                check_type(argname="argument infrastructure_config", value=infrastructure_config, expected_type=type_hints["infrastructure_config"])
                check_type(argname="argument model_name", value=model_name, expected_type=type_hints["model_name"])
                check_type(argname="argument variant_name", value=variant_name, expected_type=type_hints["variant_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "infrastructure_config": infrastructure_config,
                "model_name": model_name,
                "variant_name": variant_name,
            }

        @builtins.property
        def infrastructure_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ModelInfrastructureConfigProperty"]:
            '''The configuration for the infrastructure that the model will be deployed to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-modelvariantconfig.html#cfn-sagemaker-inferenceexperiment-modelvariantconfig-infrastructureconfig
            '''
            result = self._values.get("infrastructure_config")
            assert result is not None, "Required property 'infrastructure_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ModelInfrastructureConfigProperty"], result)

        @builtins.property
        def model_name(self) -> builtins.str:
            '''The name of the Amazon SageMaker Model entity.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-modelvariantconfig.html#cfn-sagemaker-inferenceexperiment-modelvariantconfig-modelname
            '''
            result = self._values.get("model_name")
            assert result is not None, "Required property 'model_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def variant_name(self) -> builtins.str:
            '''The name of the variant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-modelvariantconfig.html#cfn-sagemaker-inferenceexperiment-modelvariantconfig-variantname
            '''
            result = self._values.get("variant_name")
            assert result is not None, "Required property 'variant_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelVariantConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.RealTimeInferenceConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_count": "instanceCount",
            "instance_type": "instanceType",
        },
    )
    class RealTimeInferenceConfigProperty:
        def __init__(
            self,
            *,
            instance_count: jsii.Number,
            instance_type: builtins.str,
        ) -> None:
            '''The infrastructure configuration for deploying the model to a real-time inference endpoint.

            :param instance_count: The number of instances of the type specified by ``InstanceType`` .
            :param instance_type: The instance type the model is deployed to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-realtimeinferenceconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                real_time_inference_config_property = sagemaker.CfnInferenceExperiment.RealTimeInferenceConfigProperty(
                    instance_count=123,
                    instance_type="instanceType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ee618762d941d57c3de8cc9c6f383b82dea89ef9cf39ca6466ee5a46c80b81a0)
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "instance_count": instance_count,
                "instance_type": instance_type,
            }

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of instances of the type specified by ``InstanceType`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-realtimeinferenceconfig.html#cfn-sagemaker-inferenceexperiment-realtimeinferenceconfig-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The instance type the model is deployed to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-realtimeinferenceconfig.html#cfn-sagemaker-inferenceexperiment-realtimeinferenceconfig-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RealTimeInferenceConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.ShadowModeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "shadow_model_variants": "shadowModelVariants",
            "source_model_variant_name": "sourceModelVariantName",
        },
    )
    class ShadowModeConfigProperty:
        def __init__(
            self,
            *,
            shadow_model_variants: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnInferenceExperiment.ShadowModelVariantConfigProperty", typing.Dict[builtins.str, typing.Any]]]]],
            source_model_variant_name: builtins.str,
        ) -> None:
            '''The configuration of ``ShadowMode`` inference experiment type, which specifies a production variant to take all the inference requests, and a shadow variant to which Amazon SageMaker replicates a percentage of the inference requests.

            For the shadow variant it also specifies the percentage of requests that Amazon SageMaker replicates.

            :param shadow_model_variants: List of shadow variant configurations.
            :param source_model_variant_name: The name of the production variant, which takes all the inference requests.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-shadowmodeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                shadow_mode_config_property = sagemaker.CfnInferenceExperiment.ShadowModeConfigProperty(
                    shadow_model_variants=[sagemaker.CfnInferenceExperiment.ShadowModelVariantConfigProperty(
                        sampling_percentage=123,
                        shadow_model_variant_name="shadowModelVariantName"
                    )],
                    source_model_variant_name="sourceModelVariantName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3f291b4e09d5ffc820332818871f4802d2b8177cb6cb21d9e46fa42b37419994)
                check_type(argname="argument shadow_model_variants", value=shadow_model_variants, expected_type=type_hints["shadow_model_variants"])
                check_type(argname="argument source_model_variant_name", value=source_model_variant_name, expected_type=type_hints["source_model_variant_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "shadow_model_variants": shadow_model_variants,
                "source_model_variant_name": source_model_variant_name,
            }

        @builtins.property
        def shadow_model_variants(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ShadowModelVariantConfigProperty"]]]:
            '''List of shadow variant configurations.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-shadowmodeconfig.html#cfn-sagemaker-inferenceexperiment-shadowmodeconfig-shadowmodelvariants
            '''
            result = self._values.get("shadow_model_variants")
            assert result is not None, "Required property 'shadow_model_variants' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnInferenceExperiment.ShadowModelVariantConfigProperty"]]], result)

        @builtins.property
        def source_model_variant_name(self) -> builtins.str:
            '''The name of the production variant, which takes all the inference requests.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-shadowmodeconfig.html#cfn-sagemaker-inferenceexperiment-shadowmodeconfig-sourcemodelvariantname
            '''
            result = self._values.get("source_model_variant_name")
            assert result is not None, "Required property 'source_model_variant_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ShadowModeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperiment.ShadowModelVariantConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "sampling_percentage": "samplingPercentage",
            "shadow_model_variant_name": "shadowModelVariantName",
        },
    )
    class ShadowModelVariantConfigProperty:
        def __init__(
            self,
            *,
            sampling_percentage: jsii.Number,
            shadow_model_variant_name: builtins.str,
        ) -> None:
            '''The name and sampling percentage of a shadow variant.

            :param sampling_percentage: The percentage of inference requests that Amazon SageMaker replicates from the production variant to the shadow variant.
            :param shadow_model_variant_name: The name of the shadow variant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-shadowmodelvariantconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                shadow_model_variant_config_property = sagemaker.CfnInferenceExperiment.ShadowModelVariantConfigProperty(
                    sampling_percentage=123,
                    shadow_model_variant_name="shadowModelVariantName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b71dfceba1d10e6ee264fc7af67e8ae144ee546f86d6a0ff6ceaacdfde0a8cc8)
                check_type(argname="argument sampling_percentage", value=sampling_percentage, expected_type=type_hints["sampling_percentage"])
                check_type(argname="argument shadow_model_variant_name", value=shadow_model_variant_name, expected_type=type_hints["shadow_model_variant_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "sampling_percentage": sampling_percentage,
                "shadow_model_variant_name": shadow_model_variant_name,
            }

        @builtins.property
        def sampling_percentage(self) -> jsii.Number:
            '''The percentage of inference requests that Amazon SageMaker replicates from the production variant to the shadow variant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-shadowmodelvariantconfig.html#cfn-sagemaker-inferenceexperiment-shadowmodelvariantconfig-samplingpercentage
            '''
            result = self._values.get("sampling_percentage")
            assert result is not None, "Required property 'sampling_percentage' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def shadow_model_variant_name(self) -> builtins.str:
            '''The name of the shadow variant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferenceexperiment-shadowmodelvariantconfig.html#cfn-sagemaker-inferenceexperiment-shadowmodelvariantconfig-shadowmodelvariantname
            '''
            result = self._values.get("shadow_model_variant_name")
            assert result is not None, "Required property 'shadow_model_variant_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ShadowModelVariantConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnInferenceExperimentProps",
    jsii_struct_bases=[],
    name_mapping={
        "endpoint_name": "endpointName",
        "model_variants": "modelVariants",
        "name": "name",
        "role_arn": "roleArn",
        "type": "type",
        "data_storage_config": "dataStorageConfig",
        "description": "description",
        "desired_state": "desiredState",
        "kms_key": "kmsKey",
        "schedule": "schedule",
        "shadow_mode_config": "shadowModeConfig",
        "status_reason": "statusReason",
        "tags": "tags",
    },
)
class CfnInferenceExperimentProps:
    def __init__(
        self,
        *,
        endpoint_name: builtins.str,
        model_variants: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnInferenceExperiment.ModelVariantConfigProperty, typing.Dict[builtins.str, typing.Any]]]]],
        name: builtins.str,
        role_arn: builtins.str,
        type: builtins.str,
        data_storage_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnInferenceExperiment.DataStorageConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        description: typing.Optional[builtins.str] = None,
        desired_state: typing.Optional[builtins.str] = None,
        kms_key: typing.Optional[builtins.str] = None,
        schedule: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnInferenceExperiment.InferenceExperimentScheduleProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        shadow_mode_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnInferenceExperiment.ShadowModeConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        status_reason: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnInferenceExperiment``.

        :param endpoint_name: The name of the endpoint.
        :param model_variants: An array of ``ModelVariantConfigSummary`` objects. There is one for each variant in the inference experiment. Each ``ModelVariantConfigSummary`` object in the array describes the infrastructure configuration for deploying the corresponding variant.
        :param name: The name of the inference experiment.
        :param role_arn: The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
        :param type: The type of the inference experiment.
        :param data_storage_config: The Amazon S3 location and configuration for storing inference request and response data.
        :param description: The description of the inference experiment.
        :param desired_state: The desired state of the experiment after stopping. The possible states are the following:. - ``Completed`` : The experiment completed successfully - ``Cancelled`` : The experiment was canceled
        :param kms_key: The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
        :param schedule: The duration for which the inference experiment ran or will run. The maximum duration that you can set for an inference experiment is 30 days.
        :param shadow_mode_config: The configuration of ``ShadowMode`` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
        :param status_reason: The error message for the inference experiment status result.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_inference_experiment_props = sagemaker.CfnInferenceExperimentProps(
                endpoint_name="endpointName",
                model_variants=[sagemaker.CfnInferenceExperiment.ModelVariantConfigProperty(
                    infrastructure_config=sagemaker.CfnInferenceExperiment.ModelInfrastructureConfigProperty(
                        infrastructure_type="infrastructureType",
                        real_time_inference_config=sagemaker.CfnInferenceExperiment.RealTimeInferenceConfigProperty(
                            instance_count=123,
                            instance_type="instanceType"
                        )
                    ),
                    model_name="modelName",
                    variant_name="variantName"
                )],
                name="name",
                role_arn="roleArn",
                type="type",
            
                # the properties below are optional
                data_storage_config=sagemaker.CfnInferenceExperiment.DataStorageConfigProperty(
                    destination="destination",
            
                    # the properties below are optional
                    content_type=sagemaker.CfnInferenceExperiment.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    kms_key="kmsKey"
                ),
                description="description",
                desired_state="desiredState",
                kms_key="kmsKey",
                schedule=sagemaker.CfnInferenceExperiment.InferenceExperimentScheduleProperty(
                    end_time="endTime",
                    start_time="startTime"
                ),
                shadow_mode_config=sagemaker.CfnInferenceExperiment.ShadowModeConfigProperty(
                    shadow_model_variants=[sagemaker.CfnInferenceExperiment.ShadowModelVariantConfigProperty(
                        sampling_percentage=123,
                        shadow_model_variant_name="shadowModelVariantName"
                    )],
                    source_model_variant_name="sourceModelVariantName"
                ),
                status_reason="statusReason",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__92df73cfaf86dc9fd85986305f2cf4611dafd4cb962187062714c75ad4d36821)
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument model_variants", value=model_variants, expected_type=type_hints["model_variants"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument data_storage_config", value=data_storage_config, expected_type=type_hints["data_storage_config"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument desired_state", value=desired_state, expected_type=type_hints["desired_state"])
            check_type(argname="argument kms_key", value=kms_key, expected_type=type_hints["kms_key"])
            check_type(argname="argument schedule", value=schedule, expected_type=type_hints["schedule"])
            check_type(argname="argument shadow_mode_config", value=shadow_mode_config, expected_type=type_hints["shadow_mode_config"])
            check_type(argname="argument status_reason", value=status_reason, expected_type=type_hints["status_reason"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoint_name": endpoint_name,
            "model_variants": model_variants,
            "name": name,
            "role_arn": role_arn,
            "type": type,
        }
        if data_storage_config is not None:
            self._values["data_storage_config"] = data_storage_config
        if description is not None:
            self._values["description"] = description
        if desired_state is not None:
            self._values["desired_state"] = desired_state
        if kms_key is not None:
            self._values["kms_key"] = kms_key
        if schedule is not None:
            self._values["schedule"] = schedule
        if shadow_mode_config is not None:
            self._values["shadow_mode_config"] = shadow_mode_config
        if status_reason is not None:
            self._values["status_reason"] = status_reason
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def endpoint_name(self) -> builtins.str:
        '''The name of the endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-endpointname
        '''
        result = self._values.get("endpoint_name")
        assert result is not None, "Required property 'endpoint_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def model_variants(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.ModelVariantConfigProperty]]]:
        '''An array of ``ModelVariantConfigSummary`` objects.

        There is one for each variant in the inference experiment. Each ``ModelVariantConfigSummary`` object in the array describes the infrastructure configuration for deploying the corresponding variant.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-modelvariants
        '''
        result = self._values.get("model_variants")
        assert result is not None, "Required property 'model_variants' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.ModelVariantConfigProperty]]], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the inference experiment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''The type of the inference experiment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def data_storage_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.DataStorageConfigProperty]]:
        '''The Amazon S3 location and configuration for storing inference request and response data.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-datastorageconfig
        '''
        result = self._values.get("data_storage_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.DataStorageConfigProperty]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''The description of the inference experiment.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def desired_state(self) -> typing.Optional[builtins.str]:
        '''The desired state of the experiment after stopping. The possible states are the following:.

        - ``Completed`` : The experiment completed successfully
        - ``Cancelled`` : The experiment was canceled

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-desiredstate
        '''
        result = self._values.get("desired_state")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kms_key(self) -> typing.Optional[builtins.str]:
        '''The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-kmskey
        '''
        result = self._values.get("kms_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def schedule(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.InferenceExperimentScheduleProperty]]:
        '''The duration for which the inference experiment ran or will run.

        The maximum duration that you can set for an inference experiment is 30 days.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-schedule
        '''
        result = self._values.get("schedule")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.InferenceExperimentScheduleProperty]], result)

    @builtins.property
    def shadow_mode_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.ShadowModeConfigProperty]]:
        '''The configuration of ``ShadowMode`` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests.

        For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-shadowmodeconfig
        '''
        result = self._values.get("shadow_mode_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnInferenceExperiment.ShadowModeConfigProperty]], result)

    @builtins.property
    def status_reason(self) -> typing.Optional[builtins.str]:
        '''The error message for the inference experiment status result.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-statusreason
        '''
        result = self._values.get("status_reason")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnInferenceExperimentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnModel(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnModel",
):
    '''A CloudFormation ``AWS::SageMaker::Model``.

    The ``AWS::SageMaker::Model`` resource to create a model to host at an Amazon SageMaker endpoint. For more information, see `Deploying a Model on Amazon SageMaker Hosting Services <https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html>`_ in the *Amazon SageMaker Developer Guide* .

    :cloudformationResource: AWS::SageMaker::Model
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        # environment: Any
        
        cfn_model = sagemaker.CfnModel(self, "MyCfnModel",
            execution_role_arn="executionRoleArn",
        
            # the properties below are optional
            containers=[sagemaker.CfnModel.ContainerDefinitionProperty(
                container_hostname="containerHostname",
                environment=environment,
                image="image",
                image_config=sagemaker.CfnModel.ImageConfigProperty(
                    repository_access_mode="repositoryAccessMode",
        
                    # the properties below are optional
                    repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                        repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                    )
                ),
                inference_specification_name="inferenceSpecificationName",
                mode="mode",
                model_data_url="modelDataUrl",
                model_package_name="modelPackageName",
                multi_model_config=sagemaker.CfnModel.MultiModelConfigProperty(
                    model_cache_setting="modelCacheSetting"
                )
            )],
            enable_network_isolation=False,
            inference_execution_config=sagemaker.CfnModel.InferenceExecutionConfigProperty(
                mode="mode"
            ),
            model_name="modelName",
            primary_container=sagemaker.CfnModel.ContainerDefinitionProperty(
                container_hostname="containerHostname",
                environment=environment,
                image="image",
                image_config=sagemaker.CfnModel.ImageConfigProperty(
                    repository_access_mode="repositoryAccessMode",
        
                    # the properties below are optional
                    repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                        repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                    )
                ),
                inference_specification_name="inferenceSpecificationName",
                mode="mode",
                model_data_url="modelDataUrl",
                model_package_name="modelPackageName",
                multi_model_config=sagemaker.CfnModel.MultiModelConfigProperty(
                    model_cache_setting="modelCacheSetting"
                )
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            vpc_config=sagemaker.CfnModel.VpcConfigProperty(
                security_group_ids=["securityGroupIds"],
                subnets=["subnets"]
            )
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        execution_role_arn: builtins.str,
        containers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModel.ContainerDefinitionProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        inference_execution_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModel.InferenceExecutionConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        model_name: typing.Optional[builtins.str] = None,
        primary_container: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModel.ContainerDefinitionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModel.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Model``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param execution_role_arn: The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see `SageMaker Roles <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html>`_ . .. epigraph:: To be able to pass this role to SageMaker, the caller of this API must have the ``iam:PassRole`` permission.
        :param containers: Specifies the containers in the inference pipeline.
        :param enable_network_isolation: Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
        :param inference_execution_config: Specifies details of how containers in a multi-container endpoint are called.
        :param model_name: The name of the new model.
        :param primary_container: The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .
        :param vpc_config: A `VpcConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html>`_ object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. ``VpcConfig`` is used in hosting services and in batch transform. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7038463d0628899b9eb5e6fe2ba453464478eaae99d07015ffbcc79b06d20df5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnModelProps(
            execution_role_arn=execution_role_arn,
            containers=containers,
            enable_network_isolation=enable_network_isolation,
            inference_execution_config=inference_execution_config,
            model_name=model_name,
            primary_container=primary_container,
            tags=tags,
            vpc_config=vpc_config,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b84351be1922488ac80002fe5ddee12b876da8414660edea4a2934f89467ec19)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__913c78dc3229ce748ffe616b0a4e27dde623fb940a9aba6e71ddfad962b6cf1a)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrModelName")
    def attr_model_name(self) -> builtins.str:
        '''The name of the model, such as ``MyModel`` .

        :cloudformationAttribute: ModelName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrModelName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="executionRoleArn")
    def execution_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs.

        Deploying on ML compute instances is part of model hosting. For more information, see `SageMaker Roles <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html>`_ .
        .. epigraph::

           To be able to pass this role to SageMaker, the caller of this API must have the ``iam:PassRole`` permission.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "executionRoleArn"))

    @execution_role_arn.setter
    def execution_role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9245e519b65722c82aa989675ac43fc87cf93b2550317f4eaf7e13a9664cc7f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "executionRoleArn", value)

    @builtins.property
    @jsii.member(jsii_name="containers")
    def containers(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnModel.ContainerDefinitionProperty"]]]]:
        '''Specifies the containers in the inference pipeline.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnModel.ContainerDefinitionProperty"]]]], jsii.get(self, "containers"))

    @containers.setter
    def containers(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnModel.ContainerDefinitionProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b01e1f19c42cd636e28c12960d0033c49437123645a888dfe9632b05f82d3e13)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "containers", value)

    @builtins.property
    @jsii.member(jsii_name="enableNetworkIsolation")
    def enable_network_isolation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
        '''Isolates the model container.

        No inbound or outbound network calls can be made to or from the model container.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], jsii.get(self, "enableNetworkIsolation"))

    @enable_network_isolation.setter
    def enable_network_isolation(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53bc631344d4b4e3c59054cff75e57ec89c85f75caf719e0dab16fcd8afd0466)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enableNetworkIsolation", value)

    @builtins.property
    @jsii.member(jsii_name="inferenceExecutionConfig")
    def inference_execution_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.InferenceExecutionConfigProperty"]]:
        '''Specifies details of how containers in a multi-container endpoint are called.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-inferenceexecutionconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.InferenceExecutionConfigProperty"]], jsii.get(self, "inferenceExecutionConfig"))

    @inference_execution_config.setter
    def inference_execution_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.InferenceExecutionConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2442385f951a1cbcea2aa75bc2ac67e569b8dacf083ebcdbaaf36da6d71e1c9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "inferenceExecutionConfig", value)

    @builtins.property
    @jsii.member(jsii_name="modelName")
    def model_name(self) -> typing.Optional[builtins.str]:
        '''The name of the new model.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "modelName"))

    @model_name.setter
    def model_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e4e3295bb42e97b1b076108d30037b03bceb1ed3a175c334b83e248865661f3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelName", value)

    @builtins.property
    @jsii.member(jsii_name="primaryContainer")
    def primary_container(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.ContainerDefinitionProperty"]]:
        '''The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.ContainerDefinitionProperty"]], jsii.get(self, "primaryContainer"))

    @primary_container.setter
    def primary_container(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.ContainerDefinitionProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7dd8585adfcdbc3db9b90e6fbfbd279c2c8f241c64f52a3aadf8294bb116c781)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "primaryContainer", value)

    @builtins.property
    @jsii.member(jsii_name="vpcConfig")
    def vpc_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.VpcConfigProperty"]]:
        '''A `VpcConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html>`_ object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. ``VpcConfig`` is used in hosting services and in batch transform. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.VpcConfigProperty"]], jsii.get(self, "vpcConfig"))

    @vpc_config.setter
    def vpc_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.VpcConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9cfac637d2a98c4124bfa455969a4e620103bd5e25811264e2ba7b637cc9bf8e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vpcConfig", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModel.ContainerDefinitionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "container_hostname": "containerHostname",
            "environment": "environment",
            "image": "image",
            "image_config": "imageConfig",
            "inference_specification_name": "inferenceSpecificationName",
            "mode": "mode",
            "model_data_url": "modelDataUrl",
            "model_package_name": "modelPackageName",
            "multi_model_config": "multiModelConfig",
        },
    )
    class ContainerDefinitionProperty:
        def __init__(
            self,
            *,
            container_hostname: typing.Optional[builtins.str] = None,
            environment: typing.Any = None,
            image: typing.Optional[builtins.str] = None,
            image_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModel.ImageConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            inference_specification_name: typing.Optional[builtins.str] = None,
            mode: typing.Optional[builtins.str] = None,
            model_data_url: typing.Optional[builtins.str] = None,
            model_package_name: typing.Optional[builtins.str] = None,
            multi_model_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModel.MultiModelConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Describes the container, as part of model definition.

            :param container_hostname: This parameter is ignored for models that contain only a ``PrimaryContainer`` . When a ``ContainerDefinition`` is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see `Use Logs and Metrics to Monitor an Inference Pipeline <https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html>`_ . If you don't specify a value for this parameter for a ``ContainerDefinition`` that is part of an inference pipeline, a unique name is automatically assigned based on the position of the ``ContainerDefinition`` in the pipeline. If you specify a value for the ``ContainerHostName`` for any ``ContainerDefinition`` that is part of an inference pipeline, you must specify a value for the ``ContainerHostName`` parameter of every ``ContainerDefinition`` in that pipeline.
            :param environment: The environment variables to set in the Docker container. Each key and value in the ``Environment`` string to string map can have length of up to 1024. We support up to 16 entries in the map.
            :param image: The path where inference code is stored. This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both ``registry/repository[:tag]`` and ``registry/repository[@digest]`` image path formats. For more information, see `Using Your Own Algorithms with Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html>`_ . .. epigraph:: The model artifacts in an Amazon S3 bucket and the Docker image for inference container in Amazon EC2 Container Registry must be in the same region as the model or endpoint you are creating.
            :param image_config: Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For information about storing containers in a private Docker registry, see `Use a Private Docker Registry for Real-Time Inference Containers <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html>`_ . .. epigraph:: The model artifacts in an Amazon S3 bucket and the Docker image for inference container in Amazon EC2 Container Registry must be in the same region as the model or endpoint you are creating.
            :param inference_specification_name: The inference specification name in the model package version.
            :param mode: Whether the container hosts a single model or multiple models.
            :param model_data_url: The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see `Common Parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html>`_ . .. epigraph:: The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating. If you provide a value for this parameter, SageMaker uses AWS Security Token Service to download model artifacts from the S3 path you provide. AWS STS is activated in your AWS account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more information, see `Activating and Deactivating AWS STS in an AWS Region <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html>`_ in the *AWS Identity and Access Management User Guide* . .. epigraph:: If you use a built-in algorithm to create a model, SageMaker requires that you provide a S3 path to the model artifacts in ``ModelDataUrl`` .
            :param model_package_name: The name or Amazon Resource Name (ARN) of the model package to use to create the model.
            :param multi_model_config: Specifies additional configuration for multi-model endpoints.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                # environment: Any
                
                container_definition_property = sagemaker.CfnModel.ContainerDefinitionProperty(
                    container_hostname="containerHostname",
                    environment=environment,
                    image="image",
                    image_config=sagemaker.CfnModel.ImageConfigProperty(
                        repository_access_mode="repositoryAccessMode",
                
                        # the properties below are optional
                        repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                            repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                        )
                    ),
                    inference_specification_name="inferenceSpecificationName",
                    mode="mode",
                    model_data_url="modelDataUrl",
                    model_package_name="modelPackageName",
                    multi_model_config=sagemaker.CfnModel.MultiModelConfigProperty(
                        model_cache_setting="modelCacheSetting"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__996935212d254956134eaeb4bf5a82a497d061b5ef4b632b3d9d05c75d492918)
                check_type(argname="argument container_hostname", value=container_hostname, expected_type=type_hints["container_hostname"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
                check_type(argname="argument image", value=image, expected_type=type_hints["image"])
                check_type(argname="argument image_config", value=image_config, expected_type=type_hints["image_config"])
                check_type(argname="argument inference_specification_name", value=inference_specification_name, expected_type=type_hints["inference_specification_name"])
                check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
                check_type(argname="argument model_data_url", value=model_data_url, expected_type=type_hints["model_data_url"])
                check_type(argname="argument model_package_name", value=model_package_name, expected_type=type_hints["model_package_name"])
                check_type(argname="argument multi_model_config", value=multi_model_config, expected_type=type_hints["multi_model_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if container_hostname is not None:
                self._values["container_hostname"] = container_hostname
            if environment is not None:
                self._values["environment"] = environment
            if image is not None:
                self._values["image"] = image
            if image_config is not None:
                self._values["image_config"] = image_config
            if inference_specification_name is not None:
                self._values["inference_specification_name"] = inference_specification_name
            if mode is not None:
                self._values["mode"] = mode
            if model_data_url is not None:
                self._values["model_data_url"] = model_data_url
            if model_package_name is not None:
                self._values["model_package_name"] = model_package_name
            if multi_model_config is not None:
                self._values["multi_model_config"] = multi_model_config

        @builtins.property
        def container_hostname(self) -> typing.Optional[builtins.str]:
            '''This parameter is ignored for models that contain only a ``PrimaryContainer`` .

            When a ``ContainerDefinition`` is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see `Use Logs and Metrics to Monitor an Inference Pipeline <https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html>`_ . If you don't specify a value for this parameter for a ``ContainerDefinition`` that is part of an inference pipeline, a unique name is automatically assigned based on the position of the ``ContainerDefinition`` in the pipeline. If you specify a value for the ``ContainerHostName`` for any ``ContainerDefinition`` that is part of an inference pipeline, you must specify a value for the ``ContainerHostName`` parameter of every ``ContainerDefinition`` in that pipeline.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
            '''
            result = self._values.get("container_hostname")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def environment(self) -> typing.Any:
            '''The environment variables to set in the Docker container.

            Each key and value in the ``Environment`` string to string map can have length of up to 1024. We support up to 16 entries in the map.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Any, result)

        @builtins.property
        def image(self) -> typing.Optional[builtins.str]:
            '''The path where inference code is stored.

            This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both ``registry/repository[:tag]`` and ``registry/repository[@digest]`` image path formats. For more information, see `Using Your Own Algorithms with Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html>`_ .
            .. epigraph::

               The model artifacts in an Amazon S3 bucket and the Docker image for inference container in Amazon EC2 Container Registry must be in the same region as the model or endpoint you are creating.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
            '''
            result = self._values.get("image")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def image_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.ImageConfigProperty"]]:
            '''Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).

            For information about storing containers in a private Docker registry, see `Use a Private Docker Registry for Real-Time Inference Containers <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html>`_ .
            .. epigraph::

               The model artifacts in an Amazon S3 bucket and the Docker image for inference container in Amazon EC2 Container Registry must be in the same region as the model or endpoint you are creating.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-imageconfig
            '''
            result = self._values.get("image_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.ImageConfigProperty"]], result)

        @builtins.property
        def inference_specification_name(self) -> typing.Optional[builtins.str]:
            '''The inference specification name in the model package version.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-inferencespecificationname
            '''
            result = self._values.get("inference_specification_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def mode(self) -> typing.Optional[builtins.str]:
            '''Whether the container hosts a single model or multiple models.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-mode
            '''
            result = self._values.get("mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def model_data_url(self) -> typing.Optional[builtins.str]:
            '''The S3 path where the model artifacts, which result from model training, are stored.

            This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see `Common Parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html>`_ .
            .. epigraph::

               The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating.

            If you provide a value for this parameter, SageMaker uses AWS Security Token Service to download model artifacts from the S3 path you provide. AWS STS is activated in your AWS account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more information, see `Activating and Deactivating AWS STS in an AWS Region <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html>`_ in the *AWS Identity and Access Management User Guide* .
            .. epigraph::

               If you use a built-in algorithm to create a model, SageMaker requires that you provide a S3 path to the model artifacts in ``ModelDataUrl`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
            '''
            result = self._values.get("model_data_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def model_package_name(self) -> typing.Optional[builtins.str]:
            '''The name or Amazon Resource Name (ARN) of the model package to use to create the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modelpackagename
            '''
            result = self._values.get("model_package_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def multi_model_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.MultiModelConfigProperty"]]:
            '''Specifies additional configuration for multi-model endpoints.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-multimodelconfig
            '''
            result = self._values.get("multi_model_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.MultiModelConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ContainerDefinitionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModel.ImageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "repository_access_mode": "repositoryAccessMode",
            "repository_auth_config": "repositoryAuthConfig",
        },
    )
    class ImageConfigProperty:
        def __init__(
            self,
            *,
            repository_access_mode: builtins.str,
            repository_auth_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModel.RepositoryAuthConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).

            :param repository_access_mode: Set this to one of the following values:. - ``Platform`` - The model image is hosted in Amazon ECR. - ``Vpc`` - The model image is hosted in a private Docker registry in your VPC.
            :param repository_auth_config: (Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified ``Vpc`` as the value for the ``RepositoryAccessMode`` field, and the private Docker registry where the model image is hosted requires authentication.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                image_config_property = sagemaker.CfnModel.ImageConfigProperty(
                    repository_access_mode="repositoryAccessMode",
                
                    # the properties below are optional
                    repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                        repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__180270b1ba7df71db873af487e12d74fe699c3086d4da3480de69fa5d9547097)
                check_type(argname="argument repository_access_mode", value=repository_access_mode, expected_type=type_hints["repository_access_mode"])
                check_type(argname="argument repository_auth_config", value=repository_auth_config, expected_type=type_hints["repository_auth_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_access_mode": repository_access_mode,
            }
            if repository_auth_config is not None:
                self._values["repository_auth_config"] = repository_auth_config

        @builtins.property
        def repository_access_mode(self) -> builtins.str:
            '''Set this to one of the following values:.

            - ``Platform`` - The model image is hosted in Amazon ECR.
            - ``Vpc`` - The model image is hosted in a private Docker registry in your VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryaccessmode
            '''
            result = self._values.get("repository_access_mode")
            assert result is not None, "Required property 'repository_access_mode' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def repository_auth_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.RepositoryAuthConfigProperty"]]:
            '''(Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted.

            Specify a value for this property only if you specified ``Vpc`` as the value for the ``RepositoryAccessMode`` field, and the private Docker registry where the model image is hosted requires authentication.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig
            '''
            result = self._values.get("repository_auth_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModel.RepositoryAuthConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModel.InferenceExecutionConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"mode": "mode"},
    )
    class InferenceExecutionConfigProperty:
        def __init__(self, *, mode: builtins.str) -> None:
            '''Specifies details about how containers in a multi-container endpoint are run.

            :param mode: How containers in a multi-container are run. The following values are valid. - ``Serial`` - Containers run as a serial pipeline. - ``Direct`` - Only the individual container that you specify is run.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-inferenceexecutionconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                inference_execution_config_property = sagemaker.CfnModel.InferenceExecutionConfigProperty(
                    mode="mode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__de83cd55ed4b1fc85f299ed9d65fccedbf91ee1227e57cfa7bf733eec8cc7555)
                check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "mode": mode,
            }

        @builtins.property
        def mode(self) -> builtins.str:
            '''How containers in a multi-container are run. The following values are valid.

            - ``Serial`` - Containers run as a serial pipeline.
            - ``Direct`` - Only the individual container that you specify is run.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-inferenceexecutionconfig.html#cfn-sagemaker-model-inferenceexecutionconfig-mode
            '''
            result = self._values.get("mode")
            assert result is not None, "Required property 'mode' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InferenceExecutionConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModel.MultiModelConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"model_cache_setting": "modelCacheSetting"},
    )
    class MultiModelConfigProperty:
        def __init__(
            self,
            *,
            model_cache_setting: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies additional configuration for hosting multi-model endpoints.

            :param model_cache_setting: Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the endpoint might perform better if you disable model caching. To disable model caching, set the value of this parameter to Disabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                multi_model_config_property = sagemaker.CfnModel.MultiModelConfigProperty(
                    model_cache_setting="modelCacheSetting"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__eec04cb7e26e6c993c6789df684dc23c1794f95642a9b7de5423825e8f44827c)
                check_type(argname="argument model_cache_setting", value=model_cache_setting, expected_type=type_hints["model_cache_setting"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if model_cache_setting is not None:
                self._values["model_cache_setting"] = model_cache_setting

        @builtins.property
        def model_cache_setting(self) -> typing.Optional[builtins.str]:
            '''Whether to cache models for a multi-model endpoint.

            By default, multi-model endpoints cache models so that a model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the endpoint might perform better if you disable model caching. To disable model caching, set the value of this parameter to Disabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html#cfn-sagemaker-model-containerdefinition-multimodelconfig-modelcachesetting
            '''
            result = self._values.get("model_cache_setting")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MultiModelConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModel.RepositoryAuthConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "repository_credentials_provider_arn": "repositoryCredentialsProviderArn",
        },
    )
    class RepositoryAuthConfigProperty:
        def __init__(
            self,
            *,
            repository_credentials_provider_arn: builtins.str,
        ) -> None:
            '''Specifies an authentication configuration for the private docker registry where your model image is hosted.

            Specify a value for this property only if you specified ``Vpc`` as the value for the ``RepositoryAccessMode`` field of the ``ImageConfig`` object that you passed to a call to ``CreateModel`` and the private Docker registry where the model image is hosted requires authentication.

            :param repository_credentials_provider_arn: The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an AWS Lambda function, see `Create a Lambda function with the console <https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html>`_ in the *AWS Lambda Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                repository_auth_config_property = sagemaker.CfnModel.RepositoryAuthConfigProperty(
                    repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__055d3a2d4cf2da6731af22ce760741f05ab6fab49696f9fc65c093a2dfc0571c)
                check_type(argname="argument repository_credentials_provider_arn", value=repository_credentials_provider_arn, expected_type=type_hints["repository_credentials_provider_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_credentials_provider_arn": repository_credentials_provider_arn,
            }

        @builtins.property
        def repository_credentials_provider_arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted.

            For information about how to create an AWS Lambda function, see `Create a Lambda function with the console <https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html>`_ in the *AWS Lambda Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig-repositorycredentialsproviderarn
            '''
            result = self._values.get("repository_credentials_provider_arn")
            assert result is not None, "Required property 'repository_credentials_provider_arn' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RepositoryAuthConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModel.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Training Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnModel.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__55eaa95aa90ad4b6999e4006738b0d40057c7530e2df3a661a4d6d9ea9b26c3f)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form sg-xxxxxxxx.

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_c2943556)
class CfnModelBiasJobDefinition(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition",
):
    '''A CloudFormation ``AWS::SageMaker::ModelBiasJobDefinition``.

    Creates the definition for a model bias job.

    :cloudformationResource: AWS::SageMaker::ModelBiasJobDefinition
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        cfn_model_bias_job_definition = sagemaker.CfnModelBiasJobDefinition(self, "MyCfnModelBiasJobDefinition",
            job_resources=sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty(
                cluster_config=sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
        
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            ),
            model_bias_app_specification=sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty(
                config_uri="configUri",
                image_uri="imageUri",
        
                # the properties below are optional
                environment={
                    "environment_key": "environment"
                }
            ),
            model_bias_job_input=sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty(
                ground_truth_s3_input=sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                    s3_uri="s3Uri"
                ),
        
                # the properties below are optional
                batch_transform_input=sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=sagemaker.CfnModelBiasJobDefinition.JsonProperty(
                            line=False
                        ),
                        parquet=False
                    ),
                    local_path="localPath",
        
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                ),
                endpoint_input=sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
        
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                )
            ),
            model_bias_job_output_config=sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty(
                monitoring_outputs=[sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )],
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            endpoint_name="endpointName",
            job_definition_name="jobDefinitionName",
            model_bias_baseline_config=sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty(
                baselining_job_name="baseliningJobName",
                constraints_resource=sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            ),
            network_config=sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty(
                enable_inter_container_traffic_encryption=False,
                enable_network_isolation=False,
                vpc_config=sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            ),
            stopping_condition=sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty(
                max_runtime_in_seconds=123
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        job_resources: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.MonitoringResourcesProperty", typing.Dict[builtins.str, typing.Any]]],
        model_bias_app_specification: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty", typing.Dict[builtins.str, typing.Any]]],
        model_bias_job_input: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.ModelBiasJobInputProperty", typing.Dict[builtins.str, typing.Any]]],
        model_bias_job_output_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.MonitoringOutputConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        model_bias_baseline_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        network_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.NetworkConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        stopping_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.StoppingConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::ModelBiasJobDefinition``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param model_bias_app_specification: Configures the model bias job to run a specified Docker container image.
        :param model_bias_job_input: Inputs for the model bias job.
        :param model_bias_job_output_config: The output configuration for monitoring jobs.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param endpoint_name: ``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.
        :param job_definition_name: The name of the bias job definition. The name must be unique within an AWS Region in the AWS account.
        :param model_bias_baseline_config: The baseline configuration for a model bias job.
        :param network_config: Networking options for a model bias job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5872e9629433c78a4806d9db53eb11d5daed20c7d3e8e4499c965f5459e8a0da)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnModelBiasJobDefinitionProps(
            job_resources=job_resources,
            model_bias_app_specification=model_bias_app_specification,
            model_bias_job_input=model_bias_job_input,
            model_bias_job_output_config=model_bias_job_output_config,
            role_arn=role_arn,
            endpoint_name=endpoint_name,
            job_definition_name=job_definition_name,
            model_bias_baseline_config=model_bias_baseline_config,
            network_config=network_config,
            stopping_condition=stopping_condition,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30a2c6f0c977388e724ac91b9243f8c00987aa5ad7e25fb19c61839812145ebc)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61b39aa70eee6ad364d2a9532cb7f6e9f3c54be8261f5f3b42ea9eb4c31abce4)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the job definition was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrJobDefinitionArn")
    def attr_job_definition_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the job definition.

        :cloudformationAttribute: JobDefinitionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrJobDefinitionArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="jobResources")
    def job_resources(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringResourcesProperty"]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringResourcesProperty"], jsii.get(self, "jobResources"))

    @job_resources.setter
    def job_resources(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringResourcesProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4d25577671ac14fc2077caea7b095d699090f94839ed53d13e4875c34c6ba13)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobResources", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasAppSpecification")
    def model_bias_app_specification(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty"]:
        '''Configures the model bias job to run a specified Docker container image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty"], jsii.get(self, "modelBiasAppSpecification"))

    @model_bias_app_specification.setter
    def model_bias_app_specification(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4a90b0ccee1791598d39d418f1a3314cd5d1b8bea523ee7a5f1ba04e697d49f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasAppSpecification", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasJobInput")
    def model_bias_job_input(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasJobInputProperty"]:
        '''Inputs for the model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasJobInputProperty"], jsii.get(self, "modelBiasJobInput"))

    @model_bias_job_input.setter
    def model_bias_job_input(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasJobInputProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f7d7745ade63f1d91e760582259714ed75129cdf07dc3a2aef1c8453e1c31be2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasJobInput", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasJobOutputConfig")
    def model_bias_job_output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringOutputConfigProperty"]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringOutputConfigProperty"], jsii.get(self, "modelBiasJobOutputConfig"))

    @model_bias_job_output_config.setter
    def model_bias_job_output_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringOutputConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ca83e265312887bf91d708a9c2063355e1f575cfe903547ec38487020a048b89)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasJobOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fff9bf6880fe445d4f4aee27a35e15071953a8ce117ebd3abf182497a61a9967)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-endpointname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9e49ca89381d4cd706696ca645f36f1e966bbee42f50fa589af0f2bcd121f117)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="jobDefinitionName")
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name of the bias job definition.

        The name must be unique within an AWS Region in the AWS account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "jobDefinitionName"))

    @job_definition_name.setter
    def job_definition_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__50c53d48b8ba4b9bb17a0c41365c39ed717b163631f50f1837e6abba7069e579)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobDefinitionName", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasBaselineConfig")
    def model_bias_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty"]]:
        '''The baseline configuration for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty"]], jsii.get(self, "modelBiasBaselineConfig"))

    @model_bias_baseline_config.setter
    def model_bias_baseline_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__564f3203a07a362273c689d273521691f57b7fe7e19b5cdfac97df3e45677ba7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasBaselineConfig", value)

    @builtins.property
    @jsii.member(jsii_name="networkConfig")
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.NetworkConfigProperty"]]:
        '''Networking options for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.NetworkConfigProperty"]], jsii.get(self, "networkConfig"))

    @network_config.setter
    def network_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.NetworkConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e0f168d3853b9bdc566efd8f97da806d03d1518937caf92cd43447ff5e2e6ae)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "networkConfig", value)

    @builtins.property
    @jsii.member(jsii_name="stoppingCondition")
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.StoppingConditionProperty"]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.StoppingConditionProperty"]], jsii.get(self, "stoppingCondition"))

    @stopping_condition.setter
    def stopping_condition(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.StoppingConditionProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8b9812c4f147c20439686b5bacf9867f679c51edd630c77d87d65d5ab33b4d7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stoppingCondition", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_captured_destination_s3_uri": "dataCapturedDestinationS3Uri",
            "dataset_format": "datasetFormat",
            "local_path": "localPath",
            "end_time_offset": "endTimeOffset",
            "features_attribute": "featuresAttribute",
            "inference_attribute": "inferenceAttribute",
            "probability_attribute": "probabilityAttribute",
            "probability_threshold_attribute": "probabilityThresholdAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
            "start_time_offset": "startTimeOffset",
        },
    )
    class BatchTransformInputProperty:
        def __init__(
            self,
            *,
            data_captured_destination_s3_uri: builtins.str,
            dataset_format: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.DatasetFormatProperty", typing.Dict[builtins.str, typing.Any]]],
            local_path: builtins.str,
            end_time_offset: typing.Optional[builtins.str] = None,
            features_attribute: typing.Optional[builtins.str] = None,
            inference_attribute: typing.Optional[builtins.str] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            probability_threshold_attribute: typing.Optional[jsii.Number] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
            start_time_offset: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param data_captured_destination_s3_uri: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.
            :param dataset_format: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.DatasetFormat``.
            :param local_path: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.LocalPath``.
            :param end_time_offset: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.EndTimeOffset``.
            :param features_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.FeaturesAttribute``.
            :param inference_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.InferenceAttribute``.
            :param probability_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityAttribute``.
            :param probability_threshold_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityThresholdAttribute``.
            :param s3_data_distribution_type: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.
            :param s3_input_mode: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3InputMode``.
            :param start_time_offset: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.StartTimeOffset``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                batch_transform_input_property = sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=sagemaker.CfnModelBiasJobDefinition.JsonProperty(
                            line=False
                        ),
                        parquet=False
                    ),
                    local_path="localPath",
                
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__095e1c4ad30edfe45e06a2be3f2d81470123016adae4473fa83adb32923cd5b6)
                check_type(argname="argument data_captured_destination_s3_uri", value=data_captured_destination_s3_uri, expected_type=type_hints["data_captured_destination_s3_uri"])
                check_type(argname="argument dataset_format", value=dataset_format, expected_type=type_hints["dataset_format"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument end_time_offset", value=end_time_offset, expected_type=type_hints["end_time_offset"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument inference_attribute", value=inference_attribute, expected_type=type_hints["inference_attribute"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument probability_threshold_attribute", value=probability_threshold_attribute, expected_type=type_hints["probability_threshold_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
                check_type(argname="argument start_time_offset", value=start_time_offset, expected_type=type_hints["start_time_offset"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_captured_destination_s3_uri": data_captured_destination_s3_uri,
                "dataset_format": dataset_format,
                "local_path": local_path,
            }
            if end_time_offset is not None:
                self._values["end_time_offset"] = end_time_offset
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if inference_attribute is not None:
                self._values["inference_attribute"] = inference_attribute
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if probability_threshold_attribute is not None:
                self._values["probability_threshold_attribute"] = probability_threshold_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode
            if start_time_offset is not None:
                self._values["start_time_offset"] = start_time_offset

        @builtins.property
        def data_captured_destination_s3_uri(self) -> builtins.str:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-datacaptureddestinations3uri
            '''
            result = self._values.get("data_captured_destination_s3_uri")
            assert result is not None, "Required property 'data_captured_destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def dataset_format(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.DatasetFormatProperty"]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.DatasetFormat``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-datasetformat
            '''
            result = self._values.get("dataset_format")
            assert result is not None, "Required property 'dataset_format' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.DatasetFormatProperty"], result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.LocalPath``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def end_time_offset(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.EndTimeOffset``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-endtimeoffset
            '''
            result = self._values.get("end_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.FeaturesAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.InferenceAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-inferenceattribute
            '''
            result = self._values.get("inference_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_threshold_attribute(self) -> typing.Optional[jsii.Number]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityThresholdAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-probabilitythresholdattribute
            '''
            result = self._values.get("probability_threshold_attribute")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def start_time_offset(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.StartTimeOffset``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-starttimeoffset
            '''
            result = self._values.get("start_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BatchTransformInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_count": "instanceCount",
            "instance_type": "instanceType",
            "volume_size_in_gb": "volumeSizeInGb",
            "volume_kms_key_id": "volumeKmsKeyId",
        },
    )
    class ClusterConfigProperty:
        def __init__(
            self,
            *,
            instance_count: jsii.Number,
            instance_type: builtins.str,
            volume_size_in_gb: jsii.Number,
            volume_kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for the cluster resources used to run the processing job.

            :param instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
            :param instance_type: The ML compute instance type for the processing job.
            :param volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
            :param volume_kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                cluster_config_property = sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
                
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7b8869dfe33d807dbf7cfd7e3dc13f6b26b3f5e0e5682b9dc2811f4ede94462a)
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
                check_type(argname="argument volume_kms_key_id", value=volume_kms_key_id, expected_type=type_hints["volume_kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "instance_count": instance_count,
                "instance_type": instance_type,
                "volume_size_in_gb": volume_size_in_gb,
            }
            if volume_kms_key_id is not None:
                self._values["volume_kms_key_id"] = volume_kms_key_id

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of ML compute instances to use in the model monitoring job.

            For distributed processing jobs, specify a value greater than 1. The default value is 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The ML compute instance type for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def volume_size_in_gb(self) -> jsii.Number:
            '''The size of the ML storage volume, in gigabytes, that you want to provision.

            You must specify sufficient ML storage for your scenario.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            assert result is not None, "Required property 'volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def volume_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumekmskeyid
            '''
            result = self._values.get("volume_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class ConstraintsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The constraints resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                constraints_resource_property = sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__943ebfed01717dd008a0d1e2960fc1ce2d35b1748556502d98427a764b53750f)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html#cfn-sagemaker-modelbiasjobdefinition-constraintsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConstraintsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.CsvProperty",
        jsii_struct_bases=[],
        name_mapping={"header": "header"},
    )
    class CsvProperty:
        def __init__(
            self,
            *,
            header: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param header: ``CfnModelBiasJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-csv.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                csv_property = sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                    header=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ad7b9ec14afd894dc6cae82e572b09369f7dbf4f6dcc8847e5dea58a0bd8340c)
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if header is not None:
                self._values["header"] = header

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnModelBiasJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-csv.html#cfn-sagemaker-modelbiasjobdefinition-csv-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CsvProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty",
        jsii_struct_bases=[],
        name_mapping={"csv": "csv", "json": "json", "parquet": "parquet"},
    )
    class DatasetFormatProperty:
        def __init__(
            self,
            *,
            csv: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.CsvProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.JsonProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            parquet: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param csv: ``CfnModelBiasJobDefinition.DatasetFormatProperty.Csv``.
            :param json: ``CfnModelBiasJobDefinition.DatasetFormatProperty.Json``.
            :param parquet: ``CfnModelBiasJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                dataset_format_property = sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                    csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                        header=False
                    ),
                    json=sagemaker.CfnModelBiasJobDefinition.JsonProperty(
                        line=False
                    ),
                    parquet=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__36892a7975b64582ee5f88a49643cfe6219c5efea35fb7613c7dd08e9b2eaad0)
                check_type(argname="argument csv", value=csv, expected_type=type_hints["csv"])
                check_type(argname="argument json", value=json, expected_type=type_hints["json"])
                check_type(argname="argument parquet", value=parquet, expected_type=type_hints["parquet"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv is not None:
                self._values["csv"] = csv
            if json is not None:
                self._values["json"] = json
            if parquet is not None:
                self._values["parquet"] = parquet

        @builtins.property
        def csv(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.CsvProperty"]]:
            '''``CfnModelBiasJobDefinition.DatasetFormatProperty.Csv``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html#cfn-sagemaker-modelbiasjobdefinition-datasetformat-csv
            '''
            result = self._values.get("csv")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.CsvProperty"]], result)

        @builtins.property
        def json(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.JsonProperty"]]:
            '''``CfnModelBiasJobDefinition.DatasetFormatProperty.Json``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html#cfn-sagemaker-modelbiasjobdefinition-datasetformat-json
            '''
            result = self._values.get("json")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.JsonProperty"]], result)

        @builtins.property
        def parquet(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnModelBiasJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html#cfn-sagemaker-modelbiasjobdefinition-datasetformat-parquet
            '''
            result = self._values.get("parquet")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DatasetFormatProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "endpoint_name": "endpointName",
            "local_path": "localPath",
            "end_time_offset": "endTimeOffset",
            "features_attribute": "featuresAttribute",
            "inference_attribute": "inferenceAttribute",
            "probability_attribute": "probabilityAttribute",
            "probability_threshold_attribute": "probabilityThresholdAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
            "start_time_offset": "startTimeOffset",
        },
    )
    class EndpointInputProperty:
        def __init__(
            self,
            *,
            endpoint_name: builtins.str,
            local_path: builtins.str,
            end_time_offset: typing.Optional[builtins.str] = None,
            features_attribute: typing.Optional[builtins.str] = None,
            inference_attribute: typing.Optional[builtins.str] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            probability_threshold_attribute: typing.Optional[jsii.Number] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
            start_time_offset: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Input object for the endpoint.

            :param endpoint_name: An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.
            :param local_path: Path to the filesystem where the endpoint data is available to the container.
            :param end_time_offset: If specified, monitoring jobs substract this time from the end time. For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .
            :param features_attribute: The attributes of the input data that are the input features.
            :param inference_attribute: The attribute of the input data that represents the ground truth label.
            :param probability_attribute: In a classification problem, the attribute that represents the class probability.
            :param probability_threshold_attribute: The threshold for the class probability to be evaluated as a positive result.
            :param s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to ``FullyReplicated``
            :param s3_input_mode: Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job. ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .
            :param start_time_offset: If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                endpoint_input_property = sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
                
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f1f8abf8437ab2ecf1d7e91d0e0eef66b0b92d6eb75e4e47d89f5119da394e82)
                check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument end_time_offset", value=end_time_offset, expected_type=type_hints["end_time_offset"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument inference_attribute", value=inference_attribute, expected_type=type_hints["inference_attribute"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument probability_threshold_attribute", value=probability_threshold_attribute, expected_type=type_hints["probability_threshold_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
                check_type(argname="argument start_time_offset", value=start_time_offset, expected_type=type_hints["start_time_offset"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "endpoint_name": endpoint_name,
                "local_path": local_path,
            }
            if end_time_offset is not None:
                self._values["end_time_offset"] = end_time_offset
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if inference_attribute is not None:
                self._values["inference_attribute"] = inference_attribute
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if probability_threshold_attribute is not None:
                self._values["probability_threshold_attribute"] = probability_threshold_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode
            if start_time_offset is not None:
                self._values["start_time_offset"] = start_time_offset

        @builtins.property
        def endpoint_name(self) -> builtins.str:
            '''An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endpointname
            '''
            result = self._values.get("endpoint_name")
            assert result is not None, "Required property 'endpoint_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''Path to the filesystem where the endpoint data is available to the container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def end_time_offset(self) -> typing.Optional[builtins.str]:
            '''If specified, monitoring jobs substract this time from the end time.

            For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endtimeoffset
            '''
            result = self._values.get("end_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''The attributes of the input data that are the input features.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_attribute(self) -> typing.Optional[builtins.str]:
            '''The attribute of the input data that represents the ground truth label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-inferenceattribute
            '''
            result = self._values.get("inference_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''In a classification problem, the attribute that represents the class probability.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_threshold_attribute(self) -> typing.Optional[jsii.Number]:
            '''The threshold for the class probability to be evaluated as a positive result.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilitythresholdattribute
            '''
            result = self._values.get("probability_threshold_attribute")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.

            Defaults to ``FullyReplicated``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job.

            ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def start_time_offset(self) -> typing.Optional[builtins.str]:
            '''If specified, monitoring jobs substract this time from the start time.

            For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-starttimeoffset
            '''
            result = self._values.get("start_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.JsonProperty",
        jsii_struct_bases=[],
        name_mapping={"line": "line"},
    )
    class JsonProperty:
        def __init__(
            self,
            *,
            line: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
        ) -> None:
            '''
            :param line: ``CfnModelBiasJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-json.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                json_property = sagemaker.CfnModelBiasJobDefinition.JsonProperty(
                    line=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__108ddba994e973d46709c36ee036ed088e10ebd2bafb950e49da9971b9bd4478)
                check_type(argname="argument line", value=line, expected_type=type_hints["line"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if line is not None:
                self._values["line"] = line

        @builtins.property
        def line(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''``CfnModelBiasJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-json.html#cfn-sagemaker-modelbiasjobdefinition-json-line
            '''
            result = self._values.get("line")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "config_uri": "configUri",
            "image_uri": "imageUri",
            "environment": "environment",
        },
    )
    class ModelBiasAppSpecificationProperty:
        def __init__(
            self,
            *,
            config_uri: builtins.str,
            image_uri: builtins.str,
            environment: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]] = None,
        ) -> None:
            '''Docker container image configuration object for the model bias job.

            :param config_uri: JSON formatted S3 file that defines bias parameters. For more information on this JSON configuration file, see `Configure bias parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html>`_ .
            :param image_uri: The container image to be run by the model bias job.
            :param environment: Sets the environment variables in the Docker container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                model_bias_app_specification_property = sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty(
                    config_uri="configUri",
                    image_uri="imageUri",
                
                    # the properties below are optional
                    environment={
                        "environment_key": "environment"
                    }
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1f01cf0d16de54b691554f90fc0164a32bb034cb11f48e1da830de2f9a3cf5a6)
                check_type(argname="argument config_uri", value=config_uri, expected_type=type_hints["config_uri"])
                check_type(argname="argument image_uri", value=image_uri, expected_type=type_hints["image_uri"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "config_uri": config_uri,
                "image_uri": image_uri,
            }
            if environment is not None:
                self._values["environment"] = environment

        @builtins.property
        def config_uri(self) -> builtins.str:
            '''JSON formatted S3 file that defines bias parameters.

            For more information on this JSON configuration file, see `Configure bias parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-configuri
            '''
            result = self._values.get("config_uri")
            assert result is not None, "Required property 'config_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_uri(self) -> builtins.str:
            '''The container image to be run by the model bias job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-imageuri
            '''
            result = self._values.get("image_uri")
            assert result is not None, "Required property 'image_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def environment(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]]:
            '''Sets the environment variables in the Docker container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelBiasAppSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "baselining_job_name": "baseliningJobName",
            "constraints_resource": "constraintsResource",
        },
    )
    class ModelBiasBaselineConfigProperty:
        def __init__(
            self,
            *,
            baselining_job_name: typing.Optional[builtins.str] = None,
            constraints_resource: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.ConstraintsResourceProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The configuration for a baseline model bias job.

            :param baselining_job_name: The name of the baseline model bias job.
            :param constraints_resource: The constraints resource for a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                model_bias_baseline_config_property = sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__823e6e415f7639c7c7afbfb8814917a4e2e40c50c66bdfe3ac97ca0bc30cc5d3)
                check_type(argname="argument baselining_job_name", value=baselining_job_name, expected_type=type_hints["baselining_job_name"])
                check_type(argname="argument constraints_resource", value=constraints_resource, expected_type=type_hints["constraints_resource"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if baselining_job_name is not None:
                self._values["baselining_job_name"] = baselining_job_name
            if constraints_resource is not None:
                self._values["constraints_resource"] = constraints_resource

        @builtins.property
        def baselining_job_name(self) -> typing.Optional[builtins.str]:
            '''The name of the baseline model bias job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-baseliningjobname
            '''
            result = self._values.get("baselining_job_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def constraints_resource(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ConstraintsResourceProperty"]]:
            '''The constraints resource for a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-constraintsresource
            '''
            result = self._values.get("constraints_resource")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ConstraintsResourceProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelBiasBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "ground_truth_s3_input": "groundTruthS3Input",
            "batch_transform_input": "batchTransformInput",
            "endpoint_input": "endpointInput",
        },
    )
    class ModelBiasJobInputProperty:
        def __init__(
            self,
            *,
            ground_truth_s3_input: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty", typing.Dict[builtins.str, typing.Any]]],
            batch_transform_input: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.BatchTransformInputProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            endpoint_input: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.EndpointInputProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Inputs for the model bias job.

            :param ground_truth_s3_input: Location of ground truth labels to use in model bias job.
            :param batch_transform_input: ``CfnModelBiasJobDefinition.ModelBiasJobInputProperty.BatchTransformInput``.
            :param endpoint_input: Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                model_bias_job_input_property = sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty(
                    ground_truth_s3_input=sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                        s3_uri="s3Uri"
                    ),
                
                    # the properties below are optional
                    batch_transform_input=sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=sagemaker.CfnModelBiasJobDefinition.JsonProperty(
                                line=False
                            ),
                            parquet=False
                        ),
                        local_path="localPath",
                
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    ),
                    endpoint_input=sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
                
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2ffcf5c6155bcd42245ba3b4be18afbff8648089a8d444f8113b04cbaae873b1)
                check_type(argname="argument ground_truth_s3_input", value=ground_truth_s3_input, expected_type=type_hints["ground_truth_s3_input"])
                check_type(argname="argument batch_transform_input", value=batch_transform_input, expected_type=type_hints["batch_transform_input"])
                check_type(argname="argument endpoint_input", value=endpoint_input, expected_type=type_hints["endpoint_input"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "ground_truth_s3_input": ground_truth_s3_input,
            }
            if batch_transform_input is not None:
                self._values["batch_transform_input"] = batch_transform_input
            if endpoint_input is not None:
                self._values["endpoint_input"] = endpoint_input

        @builtins.property
        def ground_truth_s3_input(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty"]:
            '''Location of ground truth labels to use in model bias job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-groundtruths3input
            '''
            result = self._values.get("ground_truth_s3_input")
            assert result is not None, "Required property 'ground_truth_s3_input' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty"], result)

        @builtins.property
        def batch_transform_input(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.BatchTransformInputProperty"]]:
            '''``CfnModelBiasJobDefinition.ModelBiasJobInputProperty.BatchTransformInput``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-batchtransforminput
            '''
            result = self._values.get("batch_transform_input")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.BatchTransformInputProperty"]], result)

        @builtins.property
        def endpoint_input(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.EndpointInputProperty"]]:
            '''Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-endpointinput
            '''
            result = self._values.get("endpoint_input")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.EndpointInputProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelBiasJobInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class MonitoringGroundTruthS3InputProperty:
        def __init__(self, *, s3_uri: builtins.str) -> None:
            '''The ground truth labels for the dataset used for the monitoring job.

            :param s3_uri: The address of the Amazon S3 location of the ground truth labels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_ground_truth_s3_input_property = sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__157af7a127a3b0073068813c099aca200305bbf786f887277a81dd44b8ccb7be)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_uri": s3_uri,
            }

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''The address of the Amazon S3 location of the ground truth labels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringGroundTruthS3InputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "monitoring_outputs": "monitoringOutputs",
            "kms_key_id": "kmsKeyId",
        },
    )
    class MonitoringOutputConfigProperty:
        def __init__(
            self,
            *,
            monitoring_outputs: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.MonitoringOutputProperty", typing.Dict[builtins.str, typing.Any]]]]],
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for monitoring jobs.

            :param monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_output_config_property = sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
                
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__66d2a40f96e7c82ca2e00fe803e1af79eb9f014c8e2eaaf048e5f919855e60b8)
                check_type(argname="argument monitoring_outputs", value=monitoring_outputs, expected_type=type_hints["monitoring_outputs"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "monitoring_outputs": monitoring_outputs,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def monitoring_outputs(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringOutputProperty"]]]:
            '''Monitoring outputs for monitoring jobs.

            This is where the output of the periodic monitoring jobs is uploaded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-monitoringoutputs
            '''
            result = self._values.get("monitoring_outputs")
            assert result is not None, "Required property 'monitoring_outputs' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.MonitoringOutputProperty"]]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_output": "s3Output"},
    )
    class MonitoringOutputProperty:
        def __init__(
            self,
            *,
            s3_output: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.S3OutputProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The output object for a monitoring job.

            :param s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_output_property = sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__26779aa7e6b94222b25d88996befe67774fd9e96c31cf9ab4b970012ad11c0bd)
                check_type(argname="argument s3_output", value=s3_output, expected_type=type_hints["s3_output"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output": s3_output,
            }

        @builtins.property
        def s3_output(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.S3OutputProperty"]:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutput-s3output
            '''
            result = self._values.get("s3_output")
            assert result is not None, "Required property 's3_output' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.S3OutputProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_config": "clusterConfig"},
    )
    class MonitoringResourcesProperty:
        def __init__(
            self,
            *,
            cluster_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.ClusterConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''Identifies the resources to deploy for a monitoring job.

            :param cluster_config: The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                monitoring_resources_property = sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
                
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d366eab1f33057db8e52fa7f9a947a4c33d5d1a88ebc1f70e0b42ddf22fdd665)
                check_type(argname="argument cluster_config", value=cluster_config, expected_type=type_hints["cluster_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cluster_config": cluster_config,
            }

        @builtins.property
        def cluster_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ClusterConfigProperty"]:
            '''The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html#cfn-sagemaker-modelbiasjobdefinition-monitoringresources-clusterconfig
            '''
            result = self._values.get("cluster_config")
            assert result is not None, "Required property 'cluster_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.ClusterConfigProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringResourcesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_inter_container_traffic_encryption": "enableInterContainerTrafficEncryption",
            "enable_network_isolation": "enableNetworkIsolation",
            "vpc_config": "vpcConfig",
        },
    )
    class NetworkConfigProperty:
        def __init__(
            self,
            *,
            enable_inter_container_traffic_encryption: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]] = None,
            vpc_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelBiasJobDefinition.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.

            :param enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
            :param enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
            :param vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                network_config_property = sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__387cd4dbb8879c27437d3607adf4bc4d6cb6faeb7264e9eb78f046cd461f5447)
                check_type(argname="argument enable_inter_container_traffic_encryption", value=enable_inter_container_traffic_encryption, expected_type=type_hints["enable_inter_container_traffic_encryption"])
                check_type(argname="argument enable_network_isolation", value=enable_network_isolation, expected_type=type_hints["enable_network_isolation"])
                check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_inter_container_traffic_encryption is not None:
                self._values["enable_inter_container_traffic_encryption"] = enable_inter_container_traffic_encryption
            if enable_network_isolation is not None:
                self._values["enable_network_isolation"] = enable_network_isolation
            if vpc_config is not None:
                self._values["vpc_config"] = vpc_config

        @builtins.property
        def enable_inter_container_traffic_encryption(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Whether to encrypt all communications between distributed processing jobs.

            Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enableintercontainertrafficencryption
            '''
            result = self._values.get("enable_inter_container_traffic_encryption")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def enable_network_isolation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]]:
            '''Whether to allow inbound and outbound network calls to and from the containers used for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enablenetworkisolation
            '''
            result = self._values.get("enable_network_isolation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_da3f097b]], result)

        @builtins.property
        def vpc_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.VpcConfigProperty"]]:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-vpcconfig
            '''
            result = self._values.get("vpc_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelBiasJobDefinition.VpcConfigProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.S3OutputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "local_path": "localPath",
            "s3_uri": "s3Uri",
            "s3_upload_mode": "s3UploadMode",
        },
    )
    class S3OutputProperty:
        def __init__(
            self,
            *,
            local_path: builtins.str,
            s3_uri: builtins.str,
            s3_upload_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :param local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. ``LocalPath`` is an absolute path for the output data.
            :param s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
            :param s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                s3_output_property = sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                    local_path="localPath",
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    s3_upload_mode="s3UploadMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__50955362eff017f76ac61a86f28afca2e07257ac507029f9cf344292c30cc690)
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument s3_upload_mode", value=s3_upload_mode, expected_type=type_hints["s3_upload_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "local_path": local_path,
                "s3_uri": s3_uri,
            }
            if s3_upload_mode is not None:
                self._values["s3_upload_mode"] = s3_upload_mode

        @builtins.property
        def local_path(self) -> builtins.str:
            '''The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            ``LocalPath`` is an absolute path for the output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_upload_mode(self) -> typing.Optional[builtins.str]:
            '''Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uploadmode
            '''
            result = self._values.get("s3_upload_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3OutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"max_runtime_in_seconds": "maxRuntimeInSeconds"},
    )
    class StoppingConditionProperty:
        def __init__(self, *, max_runtime_in_seconds: jsii.Number) -> None:
            '''Specifies a limit to how long a model training job or model compilation job can run.

            It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.

            To stop a training job, SageMaker sends the algorithm the ``SIGTERM`` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.

            The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with ``CreateModel`` .
            .. epigraph::

               The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.

            :param max_runtime_in_seconds: The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model. For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days. The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                stopping_condition_property = sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2ab64963f895d7d98e730686e981f063bb28b958ec4593026768864d8df0709b)
                check_type(argname="argument max_runtime_in_seconds", value=max_runtime_in_seconds, expected_type=type_hints["max_runtime_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_runtime_in_seconds": max_runtime_in_seconds,
            }

        @builtins.property
        def max_runtime_in_seconds(self) -> jsii.Number:
            '''The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.

            For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.

            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.

            The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition-maxruntimeinseconds
            '''
            result = self._values.get("max_runtime_in_seconds")
            assert result is not None, "Required property 'max_runtime_in_seconds' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StoppingConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Training Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__041672cbe0536137cc10cb4921c5ada479006d91889f53efb9ed3bc4d57f8ca2)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form sg-xxxxxxxx.

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelBiasJobDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={
        "job_resources": "jobResources",
        "model_bias_app_specification": "modelBiasAppSpecification",
        "model_bias_job_input": "modelBiasJobInput",
        "model_bias_job_output_config": "modelBiasJobOutputConfig",
        "role_arn": "roleArn",
        "endpoint_name": "endpointName",
        "job_definition_name": "jobDefinitionName",
        "model_bias_baseline_config": "modelBiasBaselineConfig",
        "network_config": "networkConfig",
        "stopping_condition": "stoppingCondition",
        "tags": "tags",
    },
)
class CfnModelBiasJobDefinitionProps:
    def __init__(
        self,
        *,
        job_resources: typing.Union[_IResolvable_da3f097b, typing.Union[CfnModelBiasJobDefinition.MonitoringResourcesProperty, typing.Dict[builtins.str, typing.Any]]],
        model_bias_app_specification: typing.Union[_IResolvable_da3f097b, typing.Union[CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty, typing.Dict[builtins.str, typing.Any]]],
        model_bias_job_input: typing.Union[_IResolvable_da3f097b, typing.Union[CfnModelBiasJobDefinition.ModelBiasJobInputProperty, typing.Dict[builtins.str, typing.Any]]],
        model_bias_job_output_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnModelBiasJobDefinition.MonitoringOutputConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        role_arn: builtins.str,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        model_bias_baseline_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        network_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnModelBiasJobDefinition.NetworkConfigProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        stopping_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union[CfnModelBiasJobDefinition.StoppingConditionProperty, typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnModelBiasJobDefinition``.

        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param model_bias_app_specification: Configures the model bias job to run a specified Docker container image.
        :param model_bias_job_input: Inputs for the model bias job.
        :param model_bias_job_output_config: The output configuration for monitoring jobs.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param endpoint_name: ``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.
        :param job_definition_name: The name of the bias job definition. The name must be unique within an AWS Region in the AWS account.
        :param model_bias_baseline_config: The baseline configuration for a model bias job.
        :param network_config: Networking options for a model bias job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_sagemaker as sagemaker
            
            cfn_model_bias_job_definition_props = sagemaker.CfnModelBiasJobDefinitionProps(
                job_resources=sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
            
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                ),
                model_bias_app_specification=sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty(
                    config_uri="configUri",
                    image_uri="imageUri",
            
                    # the properties below are optional
                    environment={
                        "environment_key": "environment"
                    }
                ),
                model_bias_job_input=sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty(
                    ground_truth_s3_input=sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                        s3_uri="s3Uri"
                    ),
            
                    # the properties below are optional
                    batch_transform_input=sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=sagemaker.CfnModelBiasJobDefinition.JsonProperty(
                                line=False
                            ),
                            parquet=False
                        ),
                        local_path="localPath",
            
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    ),
                    endpoint_input=sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
            
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    )
                ),
                model_bias_job_output_config=sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
            
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                endpoint_name="endpointName",
                job_definition_name="jobDefinitionName",
                model_bias_baseline_config=sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    )
                ),
                network_config=sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                ),
                stopping_condition=sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3161ba72dcb53b69d61217bc71ca77ee8b6119cd05c9055b38545e88d3f6f6b6)
            check_type(argname="argument job_resources", value=job_resources, expected_type=type_hints["job_resources"])
            check_type(argname="argument model_bias_app_specification", value=model_bias_app_specification, expected_type=type_hints["model_bias_app_specification"])
            check_type(argname="argument model_bias_job_input", value=model_bias_job_input, expected_type=type_hints["model_bias_job_input"])
            check_type(argname="argument model_bias_job_output_config", value=model_bias_job_output_config, expected_type=type_hints["model_bias_job_output_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument job_definition_name", value=job_definition_name, expected_type=type_hints["job_definition_name"])
            check_type(argname="argument model_bias_baseline_config", value=model_bias_baseline_config, expected_type=type_hints["model_bias_baseline_config"])
            check_type(argname="argument network_config", value=network_config, expected_type=type_hints["network_config"])
            check_type(argname="argument stopping_condition", value=stopping_condition, expected_type=type_hints["stopping_condition"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "job_resources": job_resources,
            "model_bias_app_specification": model_bias_app_specification,
            "model_bias_job_input": model_bias_job_input,
            "model_bias_job_output_config": model_bias_job_output_config,
            "role_arn": role_arn,
        }
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if job_definition_name is not None:
            self._values["job_definition_name"] = job_definition_name
        if model_bias_baseline_config is not None:
            self._values["model_bias_baseline_config"] = model_bias_baseline_config
        if network_config is not None:
            self._values["network_config"] = network_config
        if stopping_condition is not None:
            self._values["stopping_condition"] = stopping_condition
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def job_resources(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.MonitoringResourcesProperty]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
        '''
        result = self._values.get("job_resources")
        assert result is not None, "Required property 'job_resources' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.MonitoringResourcesProperty], result)

    @builtins.property
    def model_bias_app_specification(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty]:
        '''Configures the model bias job to run a specified Docker container image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
        '''
        result = self._values.get("model_bias_app_specification")
        assert result is not None, "Required property 'model_bias_app_specification' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty], result)

    @builtins.property
    def model_bias_job_input(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.ModelBiasJobInputProperty]:
        '''Inputs for the model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
        '''
        result = self._values.get("model_bias_job_input")
        assert result is not None, "Required property 'model_bias_job_input' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.ModelBiasJobInputProperty], result)

    @builtins.property
    def model_bias_job_output_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.MonitoringOutputConfigProperty]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
        '''
        result = self._values.get("model_bias_job_output_config")
        assert result is not None, "Required property 'model_bias_job_output_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.MonitoringOutputConfigProperty], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name of the bias job definition.

        The name must be unique within an AWS Region in the AWS account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
        '''
        result = self._values.get("job_definition_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def model_bias_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty]]:
        '''The baseline configuration for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
        '''
        result = self._values.get("model_bias_baseline_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty]], result)

    @builtins.property
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.NetworkConfigProperty]]:
        '''Networking options for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
        '''
        result = self._values.get("network_config")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.NetworkConfigProperty]], result)

    @builtins.property
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.StoppingConditionProperty]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
        '''
        result = self._values.get("stopping_condition")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, CfnModelBiasJobDefinition.StoppingConditionProperty]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnModelBiasJobDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnModelCard(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelCard",
):
    '''A CloudFormation ``AWS::SageMaker::ModelCard``.

    Creates an Amazon SageMaker Model Card.

    For information about how to use model cards, see `Amazon SageMaker Model Card <https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html>`_ .

    :cloudformationResource: AWS::SageMaker::ModelCard
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_sagemaker as sagemaker
        
        # value: Any
        
        cfn_model_card = sagemaker.CfnModelCard(self, "MyCfnModelCard",
            content=sagemaker.CfnModelCard.ContentProperty(
                additional_information=sagemaker.CfnModelCard.AdditionalInformationProperty(
                    caveats_and_recommendations="caveatsAndRecommendations",
                    custom_details={
                        "custom_details_key": "customDetails"
                    },
                    ethical_considerations="ethicalConsiderations"
                ),
                business_details=sagemaker.CfnModelCard.BusinessDetailsProperty(
                    business_problem="businessProblem",
                    business_stakeholders="businessStakeholders",
                    line_of_business="lineOfBusiness"
                ),
                evaluation_details=[sagemaker.CfnModelCard.EvaluationDetailProperty(
                    name="name",
        
                    # the properties below are optional
                    datasets=["datasets"],
                    evaluation_job_arn="evaluationJobArn",
                    evaluation_observation="evaluationObservation",
                    metadata={
                        "metadata_key": "metadata"
                    },
                    metric_groups=[sagemaker.CfnModelCard.MetricGroupProperty(
                        metric_data=[sagemaker.CfnModelCard.MetricDataItemsProperty(
                            name="name",
                            type="type",
                            value=value,
        
                            # the properties below are optional
                            notes="notes",
                            x_axis_name=["xAxisName"],
                            y_axis_name=["yAxisName"]
                        )],
                        name="name"
                    )]
                )],
                intended_uses=sagemaker.CfnModelCard.IntendedUsesProperty(
                    explanations_for_risk_rating="explanationsForRiskRating",
                    factors_affecting_model_efficiency="factorsAffectingModelEfficiency",
                    intended_uses="intendedUses",
                    purpose_of_model="purposeOfModel",
                    risk_rating="riskRating"
                ),
                model_overview=sagemaker.CfnModelCard.ModelOverviewProperty(
                    algorithm_type="algorithmType",
                    inference_environment=sagemaker.CfnModelCard.InferenceEnvironmentProperty(
                        container_image=["containerImage"]
                    ),
                    model_artifact=["modelArtifact"],
                    model_creator="modelCreator",
                    model_description="modelDescription",
                    model_id="modelId",
                    model_name="modelName",
                    model_owner="modelOwner",
                    model_version=123,
                    problem_type="problemType"
                ),
                model_package_details=sagemaker.CfnModelCard.ModelPackageDetailsProperty(
                    approval_description="approvalDescription",
                    created_by=sagemaker.CfnModelCard.ModelPackageCreatorProperty(
                        user_profile_name="userProfileName"
                    ),
                    domain="domain",
                    inference_specification=sagemaker.CfnModelCard.InferenceSpecificationProperty(
                        containers=[sagemaker.CfnModelCard.ContainerProperty(
                            image="image",
        
                            # the properties below are optional
                            model_data_url="modelDataUrl",
                            nearest_model_name="nearestModelName"
                        )]
                    ),
                    model_approval_status="modelApprovalStatus",
                    model_package_arn="modelPackageArn",
                    model_package_description="modelPackageDescription",
                    model_package_group_name="modelPackageGroupName",
                    model_package_name="modelPackageName",
                    model_package_status="modelPackageStatus",
                    model_package_version=123,
                    source_algorithms=[sagemaker.CfnModelCard.SourceAlgorithmProperty(
                        algorithm_name="algorithmName",
        
                        # the properties below are optional
                        model_data_url="modelDataUrl"
                    )],
                    task="task"
                ),
                training_details=sagemaker.CfnModelCard.TrainingDetailsProperty(
                    objective_function=sagemaker.CfnModelCard.ObjectiveFunctionProperty(
                        function=sagemaker.CfnModelCard.FunctionProperty(
                            condition="condition",
                            facet="facet",
                            function="function"
                        ),
                        notes="notes"
                    ),
                    training_job_details=sagemaker.CfnModelCard.TrainingJobDetailsProperty(
                        hyper_parameters=[sagemaker.CfnModelCard.TrainingHyperParameterProperty(
                            name="name",
                            value="value"
                        )],
                        training_arn="trainingArn",
                        training_datasets=["trainingDatasets"],
                        training_environment=sagemaker.CfnModelCard.TrainingEnvironmentProperty(
                            container_image=["containerImage"]
                        ),
                        training_metrics=[sagemaker.CfnModelCard.TrainingMetricProperty(
                            name="name",
                            value=123,
        
                            # the properties below are optional
                            notes="notes"
                        )],
                        user_provided_hyper_parameters=[sagemaker.CfnModelCard.TrainingHyperParameterProperty(
                            name="name",
                            value="value"
                        )],
                        user_provided_training_metrics=[sagemaker.CfnModelCard.TrainingMetricProperty(
                            name="name",
                            value=123,
        
                            # the properties below are optional
                            notes="notes"
                        )]
                    ),
                    training_observations="trainingObservations"
                )
            ),
            model_card_name="modelCardName",
            model_card_status="modelCardStatus",
        
            # the properties below are optional
            created_by=sagemaker.CfnModelCard.UserContextProperty(
                domain_id="domainId",
                user_profile_arn="userProfileArn",
                user_profile_name="userProfileName"
            ),
            last_modified_by=sagemaker.CfnModelCard.UserContextProperty(
                domain_id="domainId",
                user_profile_arn="userProfileArn",
                user_profile_name="userProfileName"
            ),
            security_config=sagemaker.CfnModelCard.SecurityConfigProperty(
                kms_key_id="kmsKeyId"
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        content: typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.ContentProperty", typing.Dict[builtins.str, typing.Any]]],
        model_card_name: builtins.str,
        model_card_status: builtins.str,
        created_by: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.UserContextProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        last_modified_by: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.UserContextProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        security_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.SecurityConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::ModelCard``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param content: The content of the model card. Content uses the `model card JSON schema <https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema>`_ .
        :param model_card_name: The unique name of the model card.
        :param model_card_status: The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval. - ``Draft`` : The model card is a work in progress. - ``PendingReview`` : The model card is pending review. - ``Approved`` : The model card is approved. - ``Archived`` : The model card is archived. No more updates should be made to the model card, but it can still be exported.
        :param created_by: Information about the user who created or modified one or more of the following:. - Experiment - Trial - Trial component - Lineage group - Project - Model Card
        :param last_modified_by: ``AWS::SageMaker::ModelCard.LastModifiedBy``.
        :param security_config: The security configuration used to protect model card data.
        :param tags: Key-value pairs used to manage metadata for the model card.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a592fe664bd5fc9b01b1e64fc0f6cea3e28e6bcee51c6b1db5790b4854661b17)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnModelCardProps(
            content=content,
            model_card_name=model_card_name,
            model_card_status=model_card_status,
            created_by=created_by,
            last_modified_by=last_modified_by,
            security_config=security_config,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3a1a3799b007a1226f7f69a3ae5033dd02cabd7734d75bf1f0b2f0945e26ad6e)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f553be99ffe4257f9cb4a7f1b60bc1b90090306760fcbca6966d067686781764)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreatedByDomainId")
    def attr_created_by_domain_id(self) -> builtins.str:
        '''
        :cloudformationAttribute: CreatedBy.DomainId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreatedByDomainId"))

    @builtins.property
    @jsii.member(jsii_name="attrCreatedByUserProfileArn")
    def attr_created_by_user_profile_arn(self) -> builtins.str:
        '''
        :cloudformationAttribute: CreatedBy.UserProfileArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreatedByUserProfileArn"))

    @builtins.property
    @jsii.member(jsii_name="attrCreatedByUserProfileName")
    def attr_created_by_user_profile_name(self) -> builtins.str:
        '''
        :cloudformationAttribute: CreatedBy.UserProfileName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreatedByUserProfileName"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''
        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrLastModifiedByDomainId")
    def attr_last_modified_by_domain_id(self) -> builtins.str:
        '''
        :cloudformationAttribute: LastModifiedBy.DomainId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLastModifiedByDomainId"))

    @builtins.property
    @jsii.member(jsii_name="attrLastModifiedByUserProfileArn")
    def attr_last_modified_by_user_profile_arn(self) -> builtins.str:
        '''
        :cloudformationAttribute: LastModifiedBy.UserProfileArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLastModifiedByUserProfileArn"))

    @builtins.property
    @jsii.member(jsii_name="attrLastModifiedByUserProfileName")
    def attr_last_modified_by_user_profile_name(self) -> builtins.str:
        '''
        :cloudformationAttribute: LastModifiedBy.UserProfileName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLastModifiedByUserProfileName"))

    @builtins.property
    @jsii.member(jsii_name="attrLastModifiedTime")
    def attr_last_modified_time(self) -> builtins.str:
        '''
        :cloudformationAttribute: LastModifiedTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLastModifiedTime"))

    @builtins.property
    @jsii.member(jsii_name="attrModelCardArn")
    def attr_model_card_arn(self) -> builtins.str:
        '''The Amazon Resource Number (ARN) of the model card.

        For example, ``arn:aws:sagemaker:us-west-2:012345678901:modelcard/examplemodelcard`` .

        :cloudformationAttribute: ModelCardArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrModelCardArn"))

    @builtins.property
    @jsii.member(jsii_name="attrModelCardProcessingStatus")
    def attr_model_card_processing_status(self) -> builtins.str:
        '''
        :cloudformationAttribute: ModelCardProcessingStatus
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrModelCardProcessingStatus"))

    @builtins.property
    @jsii.member(jsii_name="attrModelCardVersion")
    def attr_model_card_version(self) -> jsii.Number:
        '''
        :cloudformationAttribute: ModelCardVersion
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrModelCardVersion"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Key-value pairs used to manage metadata for the model card.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="content")
    def content(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnModelCard.ContentProperty"]:
        '''The content of the model card.

        Content uses the `model card JSON schema <https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-content
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnModelCard.ContentProperty"], jsii.get(self, "content"))

    @content.setter
    def content(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnModelCard.ContentProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6312b1e45b9cd115d8d68dc4f0a7a5ba993555ace7bf2658c7bdb9d31af3b066)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "content", value)

    @builtins.property
    @jsii.member(jsii_name="modelCardName")
    def model_card_name(self) -> builtins.str:
        '''The unique name of the model card.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-modelcardname
        '''
        return typing.cast(builtins.str, jsii.get(self, "modelCardName"))

    @model_card_name.setter
    def model_card_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35b92fd0a88edd62589b1ac3231631690a1025b09fa71eda09f8fb912e29bbb8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelCardName", value)

    @builtins.property
    @jsii.member(jsii_name="modelCardStatus")
    def model_card_status(self) -> builtins.str:
        '''The approval status of the model card within your organization.

        Different organizations might have different criteria for model card review and approval.

        - ``Draft`` : The model card is a work in progress.
        - ``PendingReview`` : The model card is pending review.
        - ``Approved`` : The model card is approved.
        - ``Archived`` : The model card is archived. No more updates should be made to the model card, but it can still be exported.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-modelcardstatus
        '''
        return typing.cast(builtins.str, jsii.get(self, "modelCardStatus"))

    @model_card_status.setter
    def model_card_status(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ccc5c6c973f86f30180b2e7f8af4bb35118c6878fb5ee58dd4ce7f30713c6fd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelCardStatus", value)

    @builtins.property
    @jsii.member(jsii_name="createdBy")
    def created_by(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.UserContextProperty"]]:
        '''Information about the user who created or modified one or more of the following:.

        - Experiment
        - Trial
        - Trial component
        - Lineage group
        - Project
        - Model Card

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-createdby
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.UserContextProperty"]], jsii.get(self, "createdBy"))

    @created_by.setter
    def created_by(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.UserContextProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3200edebb36cb29038567788eb869413a6087864c22db112f4e396c0347e23d5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "createdBy", value)

    @builtins.property
    @jsii.member(jsii_name="lastModifiedBy")
    def last_modified_by(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.UserContextProperty"]]:
        '''``AWS::SageMaker::ModelCard.LastModifiedBy``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-lastmodifiedby
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.UserContextProperty"]], jsii.get(self, "lastModifiedBy"))

    @last_modified_by.setter
    def last_modified_by(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.UserContextProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__980c80444f032b41b916e012ba6410d56d5b5f6ffbae3ba3ac29416576d8c48b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "lastModifiedBy", value)

    @builtins.property
    @jsii.member(jsii_name="securityConfig")
    def security_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.SecurityConfigProperty"]]:
        '''The security configuration used to protect model card data.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-securityconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.SecurityConfigProperty"]], jsii.get(self, "securityConfig"))

    @security_config.setter
    def security_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.SecurityConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd3e6b98665d602c4bc065357e599386796abc8ca8388dee986b130a4e6537c3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "securityConfig", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelCard.AdditionalInformationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "caveats_and_recommendations": "caveatsAndRecommendations",
            "custom_details": "customDetails",
            "ethical_considerations": "ethicalConsiderations",
        },
    )
    class AdditionalInformationProperty:
        def __init__(
            self,
            *,
            caveats_and_recommendations: typing.Optional[builtins.str] = None,
            custom_details: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]] = None,
            ethical_considerations: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Additional information about the model.

            :param caveats_and_recommendations: Caveats and recommendations for those who might use this model in their applications.
            :param custom_details: Any additional information to document about the model.
            :param ethical_considerations: Any ethical considerations documented by the model card author.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-additionalinformation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                additional_information_property = sagemaker.CfnModelCard.AdditionalInformationProperty(
                    caveats_and_recommendations="caveatsAndRecommendations",
                    custom_details={
                        "custom_details_key": "customDetails"
                    },
                    ethical_considerations="ethicalConsiderations"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bdc804b35b707b6b83db59dd5856c727f91c3eaf822ead69849965c8d835fb16)
                check_type(argname="argument caveats_and_recommendations", value=caveats_and_recommendations, expected_type=type_hints["caveats_and_recommendations"])
                check_type(argname="argument custom_details", value=custom_details, expected_type=type_hints["custom_details"])
                check_type(argname="argument ethical_considerations", value=ethical_considerations, expected_type=type_hints["ethical_considerations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if caveats_and_recommendations is not None:
                self._values["caveats_and_recommendations"] = caveats_and_recommendations
            if custom_details is not None:
                self._values["custom_details"] = custom_details
            if ethical_considerations is not None:
                self._values["ethical_considerations"] = ethical_considerations

        @builtins.property
        def caveats_and_recommendations(self) -> typing.Optional[builtins.str]:
            '''Caveats and recommendations for those who might use this model in their applications.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-additionalinformation.html#cfn-sagemaker-modelcard-additionalinformation-caveatsandrecommendations
            '''
            result = self._values.get("caveats_and_recommendations")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def custom_details(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]]:
            '''Any additional information to document about the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-additionalinformation.html#cfn-sagemaker-modelcard-additionalinformation-customdetails
            '''
            result = self._values.get("custom_details")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, builtins.str]]], result)

        @builtins.property
        def ethical_considerations(self) -> typing.Optional[builtins.str]:
            '''Any ethical considerations documented by the model card author.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-additionalinformation.html#cfn-sagemaker-modelcard-additionalinformation-ethicalconsiderations
            '''
            result = self._values.get("ethical_considerations")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AdditionalInformationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelCard.BusinessDetailsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "business_problem": "businessProblem",
            "business_stakeholders": "businessStakeholders",
            "line_of_business": "lineOfBusiness",
        },
    )
    class BusinessDetailsProperty:
        def __init__(
            self,
            *,
            business_problem: typing.Optional[builtins.str] = None,
            business_stakeholders: typing.Optional[builtins.str] = None,
            line_of_business: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information about how the model supports business goals.

            :param business_problem: The specific business problem that the model is trying to solve.
            :param business_stakeholders: The relevant stakeholders for the model.
            :param line_of_business: The broader business need that the model is serving.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-businessdetails.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                business_details_property = sagemaker.CfnModelCard.BusinessDetailsProperty(
                    business_problem="businessProblem",
                    business_stakeholders="businessStakeholders",
                    line_of_business="lineOfBusiness"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c9648d55d580d4da7524caf1b1d303ad1894db6b202cb07f245c4a41363fae4b)
                check_type(argname="argument business_problem", value=business_problem, expected_type=type_hints["business_problem"])
                check_type(argname="argument business_stakeholders", value=business_stakeholders, expected_type=type_hints["business_stakeholders"])
                check_type(argname="argument line_of_business", value=line_of_business, expected_type=type_hints["line_of_business"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if business_problem is not None:
                self._values["business_problem"] = business_problem
            if business_stakeholders is not None:
                self._values["business_stakeholders"] = business_stakeholders
            if line_of_business is not None:
                self._values["line_of_business"] = line_of_business

        @builtins.property
        def business_problem(self) -> typing.Optional[builtins.str]:
            '''The specific business problem that the model is trying to solve.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-businessdetails.html#cfn-sagemaker-modelcard-businessdetails-businessproblem
            '''
            result = self._values.get("business_problem")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def business_stakeholders(self) -> typing.Optional[builtins.str]:
            '''The relevant stakeholders for the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-businessdetails.html#cfn-sagemaker-modelcard-businessdetails-businessstakeholders
            '''
            result = self._values.get("business_stakeholders")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def line_of_business(self) -> typing.Optional[builtins.str]:
            '''The broader business need that the model is serving.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-businessdetails.html#cfn-sagemaker-modelcard-businessdetails-lineofbusiness
            '''
            result = self._values.get("line_of_business")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BusinessDetailsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelCard.ContainerProperty",
        jsii_struct_bases=[],
        name_mapping={
            "image": "image",
            "model_data_url": "modelDataUrl",
            "nearest_model_name": "nearestModelName",
        },
    )
    class ContainerProperty:
        def __init__(
            self,
            *,
            image: builtins.str,
            model_data_url: typing.Optional[builtins.str] = None,
            nearest_model_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param image: ``CfnModelCard.ContainerProperty.Image``.
            :param model_data_url: ``CfnModelCard.ContainerProperty.ModelDataUrl``.
            :param nearest_model_name: ``CfnModelCard.ContainerProperty.NearestModelName``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-container.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                container_property = sagemaker.CfnModelCard.ContainerProperty(
                    image="image",
                
                    # the properties below are optional
                    model_data_url="modelDataUrl",
                    nearest_model_name="nearestModelName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__33e54e364df9af6954c3dcbfdce9460667559b7475acfc5fd430e99e93216bb9)
                check_type(argname="argument image", value=image, expected_type=type_hints["image"])
                check_type(argname="argument model_data_url", value=model_data_url, expected_type=type_hints["model_data_url"])
                check_type(argname="argument nearest_model_name", value=nearest_model_name, expected_type=type_hints["nearest_model_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "image": image,
            }
            if model_data_url is not None:
                self._values["model_data_url"] = model_data_url
            if nearest_model_name is not None:
                self._values["nearest_model_name"] = nearest_model_name

        @builtins.property
        def image(self) -> builtins.str:
            '''``CfnModelCard.ContainerProperty.Image``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-container.html#cfn-sagemaker-modelcard-container-image
            '''
            result = self._values.get("image")
            assert result is not None, "Required property 'image' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def model_data_url(self) -> typing.Optional[builtins.str]:
            '''``CfnModelCard.ContainerProperty.ModelDataUrl``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-container.html#cfn-sagemaker-modelcard-container-modeldataurl
            '''
            result = self._values.get("model_data_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def nearest_model_name(self) -> typing.Optional[builtins.str]:
            '''``CfnModelCard.ContainerProperty.NearestModelName``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-container.html#cfn-sagemaker-modelcard-container-nearestmodelname
            '''
            result = self._values.get("nearest_model_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ContainerProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_sagemaker.CfnModelCard.ContentProperty",
        jsii_struct_bases=[],
        name_mapping={
            "additional_information": "additionalInformation",
            "business_details": "businessDetails",
            "evaluation_details": "evaluationDetails",
            "intended_uses": "intendedUses",
            "model_overview": "modelOverview",
            "model_package_details": "modelPackageDetails",
            "training_details": "trainingDetails",
        },
    )
    class ContentProperty:
        def __init__(
            self,
            *,
            additional_information: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.AdditionalInformationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            business_details: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.BusinessDetailsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            evaluation_details: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.EvaluationDetailProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            intended_uses: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.IntendedUsesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            model_overview: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.ModelOverviewProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            model_package_details: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.ModelPackageDetailsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            training_details: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnModelCard.TrainingDetailsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The content of the model card.

            It follows the `model card json schema <https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema>`_ .

            :param additional_information: Additional information about the model.
            :param business_details: Information about how the model supports business goals.
            :param evaluation_details: An overview about the model's evaluation.
            :param intended_uses: The intended usage of the model.
            :param model_overview: An overview about the model.
            :param model_package_details: ``CfnModelCard.ContentProperty.ModelPackageDetails``.
            :param training_details: An overview about model training.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-content.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_sagemaker as sagemaker
                
                # value: Any
                
                content_property = sagemaker.CfnModelCard.ContentProperty(
                    additional_information=sagemaker.CfnModelCard.AdditionalInformationProperty(
                        caveats_and_recommendations="caveatsAndRecommendations",
                        custom_details={
                            "custom_details_key": "customDetails"
                        },
                        ethical_considerations="ethicalConsiderations"
                    ),
                    business_details=sagemaker.CfnModelCard.BusinessDetailsProperty(
                        business_problem="businessProblem",
                        business_stakeholders="businessStakeholders",
                        line_of_business="lineOfBusiness"
                    ),
                    evaluation_details=[sagemaker.CfnModelCard.EvaluationDetailProperty(
                        name="name",
                
                        # the properties below are optional
                        datasets=["datasets"],
                        evaluation_job_arn="evaluationJobArn",
                        evaluation_observation="evaluationObservation",
                        metadata={
                            "metadata_key": "metadata"
                        },
                        metric_groups=[sagemaker.CfnModelCard.MetricGroupProperty(
                            metric_data=[sagemaker.CfnModelCard.MetricDataItemsProperty(
                                name="name",
                                type="type",
                                value=value,
                
                                # the properties below are optional
                                notes="notes",
                                x_axis_name=["xAxisName"],
                                y_axis_name=["yAxisName"]
                            )],
                            name="name"
                        )]
                    )],
                    intended_uses=sagemaker.CfnModelCard.IntendedUsesProperty(
                        explanations_for_risk_rating="explanationsForRiskRating",
                        factors_affecting_model_efficiency="factorsAffectingModelEfficiency",
                        intended_uses="intendedUses",
                        purpose_of_model="purposeOfModel",
                        risk_rating="riskRating"
                    ),
                    model_overview=sagemaker.CfnModelCard.ModelOverviewProperty(
                        algorithm_type="algorithmType",
                        inference_environment=sagemaker.CfnModelCard.InferenceEnvironmentProperty(
                            container_image=["containerImage"]
                        ),
                        model_artifact=["modelArtifact"],
                        model_creator="modelCreator",
                        model_description="modelDescription",
                        model_id="modelId",
                        model_name="modelName",
                        model_owner="modelOwner",
                        model_version=123,
                        problem_type="problemType"
                    ),
                    model_package_details=sagemaker.CfnModelCard.ModelPackageDetailsProperty(
                        approval_description="approvalDescription",
                        created_by=sagemaker.CfnModelCard.ModelPackageCreatorProperty(
                            user_profile_name="userProfileName"
                        ),
                        domain="domain",
                        inference_specification=sagemaker.CfnModelCard.InferenceSpecificationProperty(
                            containers=[sagemaker.CfnModelCard.ContainerProperty(
                                image="image",
                
                                # the properties below are optional
                                model_data_url="modelDataUrl",
                                nearest_model_name="nearestModelName"
                            )]
                        ),
                        model_approval_status="modelApprovalStatus",
                        model_package_arn="modelPackageArn",
                        model_package_description="modelPackageDescription",
                        model_package_group_name="modelPackageGroupName",
                        model_package_name="modelPackageName",
                        model_package_status="modelPackageStatus",
                        model_package_version=123,
                        source_algorithms=[sagemaker.CfnModelCard.SourceAlgorithmProperty(
                            algorithm_name="algorithmName",
                
                            # the properties below are optional
                            model_data_url="modelDataUrl"
                        )],
                        task="task"
                    ),
                    training_details=sagemaker.CfnModelCard.TrainingDetailsProperty(
                        objective_function=sagemaker.CfnModelCard.ObjectiveFunctionProperty(
                            function=sagemaker.CfnModelCard.FunctionProperty(
                                condition="condition",
                                facet="facet",
                                function="function"
                            ),
                            notes="notes"
                        ),
                        training_job_details=sagemaker.CfnModelCard.TrainingJobDetailsProperty(
                            hyper_parameters=[sagemaker.CfnModelCard.TrainingHyperParameterProperty(
                                name="name",
                                value="value"
                            )],
                            training_arn="trainingArn",
                            training_datasets=["trainingDatasets"],
                            training_environment=sagemaker.CfnModelCard.TrainingEnvironmentProperty(
                                container_image=["containerImage"]
                            ),
                            training_metrics=[sagemaker.CfnModelCard.TrainingMetricProperty(
                                name="name",
                                value=123,
                
                                # the properties below are optional
                                notes="notes"
                            )],
                            user_provided_hyper_parameters=[sagemaker.CfnModelCard.TrainingHyperParameterProperty(
                                name="name",
                                value="value"
                            )],
                            user_provided_training_metrics=[sagemaker.CfnModelCard.TrainingMetricProperty(
                                name="name",
                                value=123,
                
                                # the properties below are optional
                                notes="notes"
                            )]
                        ),
                        training_observations="trainingObservations"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2bdf1111a719ae9856d556b646aa8ed25948001df09f5d13ffdfa66d2c045e8a)
                check_type(argname="argument additional_information", value=additional_information, expected_type=type_hints["additional_information"])
                check_type(argname="argument business_details", value=business_details, expected_type=type_hints["business_details"])
                check_type(argname="argument evaluation_details", value=evaluation_details, expected_type=type_hints["evaluation_details"])
                check_type(argname="argument intended_uses", value=intended_uses, expected_type=type_hints["intended_uses"])
                check_type(argname="argument model_overview", value=model_overview, expected_type=type_hints["model_overview"])
                check_type(argname="argument model_package_details", value=model_package_details, expected_type=type_hints["model_package_details"])
                check_type(argname="argument training_details", value=training_details, expected_type=type_hints["training_details"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if additional_information is not None:
                self._values["additional_information"] = additional_information
            if business_details is not None:
                self._values["business_details"] = business_details
            if evaluation_details is not None:
                self._values["evaluation_details"] = evaluation_details
            if intended_uses is not None:
                self._values["intended_uses"] = intended_uses
            if model_overview is not None:
                self._values["model_overview"] = model_overview
            if model_package_details is not None:
                self._values["model_package_details"] = model_package_details
            if training_details is not None:
                self._values["training_details"] = training_details

        @builtins.property
        def additional_information(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.AdditionalInformationProperty"]]:
            '''Additional information about the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-content.html#cfn-sagemaker-modelcard-content-additionalinformation
            '''
            result = self._values.get("additional_information")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.AdditionalInformationProperty"]], result)

        @builtins.property
        def business_details(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.BusinessDetailsProperty"]]:
            '''Information about how the model supports business goals.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-content.html#cfn-sagemaker-modelcard-content-businessdetails
            '''
            result = self._values.get("business_details")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.BusinessDetailsProperty"]], result)

        @builtins.property
        def evaluation_details(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnModelCard.EvaluationDetailProperty"]]]]:
            '''An overview about the model's evaluation.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-content.html#cfn-sagemaker-modelcard-content-evaluationdetails
            '''
            result = self._values.get("evaluation_details")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnModelCard.EvaluationDetailProperty"]]]], result)

        @builtins.property
        def intended_uses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.IntendedUsesProperty"]]:
            '''The intended usage of the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-content.html#cfn-sagemaker-modelcard-content-intendeduses
            '''
            result = self._values.get("intended_uses")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.IntendedUsesProperty"]], result)

        @builtins.property
        def model_overview(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnModelCard.ModelOverviewProperty"]]:
            '''An overview about the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelcard-content.html#cfn-sagemaker-modelcard-content-modeloverview
            '''
            result = self._values.get("model_overview")
            return typing.cast