'''
# AWS::WAFv2 Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_wafv2 as wafv2
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for WAFv2 construct libraries](https://constructs.dev/search?q=wafv2)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::WAFv2 resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_WAFv2.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::WAFv2](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_WAFv2.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/main/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import constructs as _constructs_77d1e7e8
from .. import (
    CfnResource as _CfnResource_9df397a6,
    CfnTag as _CfnTag_f6864754,
    IInspectable as _IInspectable_c2943556,
    IResolvable as _IResolvable_da3f097b,
    TagManager as _TagManager_0a598cb3,
    TreeInspector as _TreeInspector_488e0dd5,
)


@jsii.implements(_IInspectable_c2943556)
class CfnIPSet(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnIPSet",
):
    '''A CloudFormation ``AWS::WAFv2::IPSet``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``IPSet`` to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure AWS WAF to block them using an IP set that lists those IP addresses.

    You use an IP set by providing its Amazon Resource Name (ARN) to the rule statement ``IPSetReferenceStatement`` , when you add a rule to a rule group or web ACL.

    :cloudformationResource: AWS::WAFv2::IPSet
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_wafv2 as wafv2
        
        cfn_iPSet = wafv2.CfnIPSet(self, "MyCfnIPSet",
            addresses=["addresses"],
            ip_address_version="ipAddressVersion",
            scope="scope",
        
            # the properties below are optional
            description="description",
            name="name",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        addresses: typing.Sequence[builtins.str],
        ip_address_version: builtins.str,
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::IPSet``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param addresses: Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` . Example address strings: - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` . - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` . For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ . Example JSON ``Addresses`` specifications: - Empty array: ``"Addresses": []`` - Array with one address: ``"Addresses": ["192.0.2.44/32"]`` - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`` - INVALID specification: ``"Addresses": [""]`` INVALID
        :param ip_address_version: The version of the IP addresses, either ``IPV4`` or ``IPV6`` .
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the IP set that helps with identification.
        :param name: The name of the IP set. You cannot change the name of an ``IPSet`` after you create it.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__039afc69c65e0dd02b0d7963f7fa0f2983949d351922a3fbe8afc7cd0aa22eab)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnIPSetProps(
            addresses=addresses,
            ip_address_version=ip_address_version,
            scope=scope,
            description=description,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0600a367beb5e92220f305b2a290f7e6c367a23cdd9bdc5ba244ae1705a05b3a)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__179e205b0ee0cdd8de882b8a3fba1a899c4ff7e936aa2de1283121509e783188)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the IP set.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the IP set.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="addresses")
    def addresses(self) -> typing.List[builtins.str]:
        '''Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses.

        All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` .

        Example address strings:

        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` .
        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` .

        For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ .

        Example JSON ``Addresses`` specifications:

        - Empty array: ``"Addresses": []``
        - Array with one address: ``"Addresses": ["192.0.2.44/32"]``
        - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]``
        - INVALID specification: ``"Addresses": [""]`` INVALID

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-addresses
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "addresses"))

    @addresses.setter
    def addresses(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f10a155b121165e58778a83d62545cfbfc395feeb362e4b1d092ad6be31ca8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "addresses", value)

    @builtins.property
    @jsii.member(jsii_name="ipAddressVersion")
    def ip_address_version(self) -> builtins.str:
        '''The version of the IP addresses, either ``IPV4`` or ``IPV6`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-ipaddressversion
        '''
        return typing.cast(builtins.str, jsii.get(self, "ipAddressVersion"))

    @ip_address_version.setter
    def ip_address_version(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a699244d4dfb348990708737607c0caf993fb45f4f6ad29f480c33b8209331d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "ipAddressVersion", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__feee99d99d65eba762ddaa0e8744a3087cf92dbcdebb488d058953dbb010e8f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the IP set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__68a24131e312bc846012992c64cf5b9592365c9af854d2d4c50e4921aa058bb0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the IP set.

        You cannot change the name of an ``IPSet`` after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c0c9ed63000c100a64f48977af0d5bcd4c1fdd0ec76ceef0e3e0d45fbe40fbe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnIPSetProps",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "ip_address_version": "ipAddressVersion",
        "scope": "scope",
        "description": "description",
        "name": "name",
        "tags": "tags",
    },
)
class CfnIPSetProps:
    def __init__(
        self,
        *,
        addresses: typing.Sequence[builtins.str],
        ip_address_version: builtins.str,
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnIPSet``.

        :param addresses: Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` . Example address strings: - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` . - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` . For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ . Example JSON ``Addresses`` specifications: - Empty array: ``"Addresses": []`` - Array with one address: ``"Addresses": ["192.0.2.44/32"]`` - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`` - INVALID specification: ``"Addresses": [""]`` INVALID
        :param ip_address_version: The version of the IP addresses, either ``IPV4`` or ``IPV6`` .
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the IP set that helps with identification.
        :param name: The name of the IP set. You cannot change the name of an ``IPSet`` after you create it.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_wafv2 as wafv2
            
            cfn_iPSet_props = wafv2.CfnIPSetProps(
                addresses=["addresses"],
                ip_address_version="ipAddressVersion",
                scope="scope",
            
                # the properties below are optional
                description="description",
                name="name",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96b0ead7c11c27cbe1678aa0bf080746e410b94c991c94a4b26268579d9f4d17)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument ip_address_version", value=ip_address_version, expected_type=type_hints["ip_address_version"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "addresses": addresses,
            "ip_address_version": ip_address_version,
            "scope": scope,
        }
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def addresses(self) -> typing.List[builtins.str]:
        '''Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses.

        All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` .

        Example address strings:

        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` .
        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` .

        For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ .

        Example JSON ``Addresses`` specifications:

        - Empty array: ``"Addresses": []``
        - Array with one address: ``"Addresses": ["192.0.2.44/32"]``
        - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]``
        - INVALID specification: ``"Addresses": [""]`` INVALID

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-addresses
        '''
        result = self._values.get("addresses")
        assert result is not None, "Required property 'addresses' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def ip_address_version(self) -> builtins.str:
        '''The version of the IP addresses, either ``IPV4`` or ``IPV6`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-ipaddressversion
        '''
        result = self._values.get("ip_address_version")
        assert result is not None, "Required property 'ip_address_version' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the IP set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the IP set.

        You cannot change the name of an ``IPSet`` after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnIPSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnLoggingConfiguration(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration",
):
    '''A CloudFormation ``AWS::WAFv2::LoggingConfiguration``.

    Defines an association between logging destinations and a web ACL resource, for logging from AWS WAF . As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records.
    .. epigraph::

       You can define one logging destination per web ACL.

    You can access information about the traffic that AWS WAF inspects using the following steps:

    - Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose.

    The name that you give the destination must start with ``aws-waf-logs-`` . Depending on the type of destination, you might need to configure additional settings or permissions.

    For configuration requirements and pricing information for each destination type, see `Logging web ACL traffic <https://docs.aws.amazon.com/waf/latest/developerguide/logging.html>`_ in the *AWS WAF Developer Guide* .

    - Associate your logging destination to your web ACL using a ``PutLoggingConfiguration`` request.

    When you successfully enable logging using a ``PutLoggingConfiguration`` request, AWS WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, AWS WAF creates a resource policy on the log group. For an Amazon S3 bucket, AWS WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, AWS WAF creates a service-linked role.

    For additional information about web ACL logging, see `Logging web ACL traffic information <https://docs.aws.amazon.com/waf/latest/developerguide/logging.html>`_ in the *AWS WAF Developer Guide* .

    :cloudformationResource: AWS::WAFv2::LoggingConfiguration
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_wafv2 as wafv2
        
        # json_body: Any
        # logging_filter: Any
        # method: Any
        # query_string: Any
        # single_header: Any
        # uri_path: Any
        
        cfn_logging_configuration = wafv2.CfnLoggingConfiguration(self, "MyCfnLoggingConfiguration",
            log_destination_configs=["logDestinationConfigs"],
            resource_arn="resourceArn",
        
            # the properties below are optional
            logging_filter=logging_filter,
            redacted_fields=[wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                json_body=json_body,
                method=method,
                query_string=query_string,
                single_header=single_header,
                uri_path=uri_path
            )]
        )
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        log_destination_configs: typing.Sequence[builtins.str],
        resource_arn: builtins.str,
        logging_filter: typing.Any = None,
        redacted_fields: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::LoggingConfiguration``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param log_destination_configs: The logging destination configuration that you want to associate with the web ACL. .. epigraph:: You can associate one logging destination to a web ACL.
        :param resource_arn: The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .
        :param logging_filter: Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
        :param redacted_fields: The parts of the request that you want to keep out of the logs. For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``REDACTED`` for all rules that use the ``SingleHeader`` ``FieldToMatch`` setting. Redaction applies only to the component that's specified in the rule's ``FieldToMatch`` setting, so the ``SingleHeader`` redaction doesn't apply to rules that use the ``Headers`` ``FieldToMatch`` . .. epigraph:: You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a8c4ba5ee1b98a4ed1dd5001182ec8712406026687793bcb17c7a78771fa41c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnLoggingConfigurationProps(
            log_destination_configs=log_destination_configs,
            resource_arn=resource_arn,
            logging_filter=logging_filter,
            redacted_fields=redacted_fields,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__09d6ff21499349760b4e1833c701bb35da7d5f623b987204d2cba29df24d4dd5)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce45f42f3fc8a3306e3cf191c01b8b74f6f778f934881efc098c67eae0ab574f)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrManagedByFirewallManager")
    def attr_managed_by_firewall_manager(self) -> _IResolvable_da3f097b:
        '''Indicates whether the logging configuration was created by AWS Firewall Manager , as part of an AWS WAF policy configuration.

        If true, only Firewall Manager can modify or delete the configuration.

        :cloudformationAttribute: ManagedByFirewallManager
        '''
        return typing.cast(_IResolvable_da3f097b, jsii.get(self, "attrManagedByFirewallManager"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="logDestinationConfigs")
    def log_destination_configs(self) -> typing.List[builtins.str]:
        '''The logging destination configuration that you want to associate with the web ACL.

        .. epigraph::

           You can associate one logging destination to a web ACL.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "logDestinationConfigs"))

    @log_destination_configs.setter
    def log_destination_configs(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cea30baad623cdba4cda27c8a05e17294c73ce64e3c9306b0448944f2d2e7603)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "logDestinationConfigs", value)

    @builtins.property
    @jsii.member(jsii_name="loggingFilter")
    def logging_filter(self) -> typing.Any:
        '''Filtering that specifies which web requests are kept in the logs and which are dropped.

        You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter
        '''
        return typing.cast(typing.Any, jsii.get(self, "loggingFilter"))

    @logging_filter.setter
    def logging_filter(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e432d8d1e0fc298c7c4d7f42acca7ba0c8edc61ee2795cd2454d866a80034faa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "loggingFilter", value)

    @builtins.property
    @jsii.member(jsii_name="resourceArn")
    def resource_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceArn"))

    @resource_arn.setter
    def resource_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__131460b145114748342bba71adbba5e0de220ac6ea445093e05959407b65bd2e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceArn", value)

    @builtins.property
    @jsii.member(jsii_name="redactedFields")
    def redacted_fields(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FieldToMatchProperty"]]]]:
        '''The parts of the request that you want to keep out of the logs.

        For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``REDACTED`` for all rules that use the ``SingleHeader`` ``FieldToMatch`` setting.

        Redaction applies only to the component that's specified in the rule's ``FieldToMatch`` setting, so the ``SingleHeader`` redaction doesn't apply to rules that use the ``Headers`` ``FieldToMatch`` .
        .. epigraph::

           You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FieldToMatchProperty"]]]], jsii.get(self, "redactedFields"))

    @redacted_fields.setter
    def redacted_fields(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FieldToMatchProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77098387595faa6bc77b294170e26602e484493e0515112c5936ba88ceb70e6c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "redactedFields", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ActionConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"action": "action"},
    )
    class ActionConditionProperty:
        def __init__(self, *, action: builtins.str) -> None:
            '''A single action condition for a condition in a logging filter.

            :param action: The action setting that a log record must contain in order to meet the condition. This is the action that AWS WAF applied to the web request. For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value ``EXCLUDED_AS_COUNT`` matches on excluded rules and also on rules that have a rule action override of Count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                action_condition_property = wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                    action="action"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b50ba1c68e04e01fa933a06e4c55e88e55cd8c0103f546e3e3df1cc633cebd96)
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "action": action,
            }

        @builtins.property
        def action(self) -> builtins.str:
            '''The action setting that a log record must contain in order to meet the condition.

            This is the action that AWS WAF applied to the web request.

            For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value ``EXCLUDED_AS_COUNT`` matches on excluded rules and also on rules that have a rule action override of Count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html#cfn-wafv2-loggingconfiguration-actioncondition-action
            '''
            result = self._values.get("action")
            assert result is not None, "Required property 'action' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ActionConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.ConditionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "action_condition": "actionCondition",
            "label_name_condition": "labelNameCondition",
        },
    )
    class ConditionProperty:
        def __init__(
            self,
            *,
            action_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.ActionConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            label_name_condition: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.LabelNameConditionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A single match condition for a log filter.

            :param action_condition: A single action condition. This is the action setting that a log record must contain in order to meet the condition.
            :param label_name_condition: A single label name condition. This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                condition_property = wafv2.CfnLoggingConfiguration.ConditionProperty(
                    action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                        action="action"
                    ),
                    label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                        label_name="labelName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__656ff215ddddac51d5278c1b95b125cba525825694103354c56a1d5a69bccafa)
                check_type(argname="argument action_condition", value=action_condition, expected_type=type_hints["action_condition"])
                check_type(argname="argument label_name_condition", value=label_name_condition, expected_type=type_hints["label_name_condition"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if action_condition is not None:
                self._values["action_condition"] = action_condition
            if label_name_condition is not None:
                self._values["label_name_condition"] = label_name_condition

        @builtins.property
        def action_condition(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ActionConditionProperty"]]:
            '''A single action condition.

            This is the action setting that a log record must contain in order to meet the condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-actioncondition
            '''
            result = self._values.get("action_condition")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ActionConditionProperty"]], result)

        @builtins.property
        def label_name_condition(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.LabelNameConditionProperty"]]:
            '''A single label name condition.

            This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-labelnamecondition
            '''
            result = self._values.get("label_name_condition")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.LabelNameConditionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            json_body: typing.Any = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''The parts of the request that you want to keep out of the logs.

            This is used in the logging configuration ``RedactedFields`` specification.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            :param json_body: Redact the request body JSON.
            :param method: Redact the indicated HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Redact the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Redact a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }``
            :param uri_path: Redact the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # json_body: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                    json_body=json_body,
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a114319b47aa4cd2b95781f4821770182938be36290f92e23536d594e9de8d12)
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def json_body(self) -> typing.Any:
            '''Redact the request body JSON.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Any, result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Redact the indicated HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Redact the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Redact a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Redact the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FilterProperty",
        jsii_struct_bases=[],
        name_mapping={
            "behavior": "behavior",
            "conditions": "conditions",
            "requirement": "requirement",
        },
    )
    class FilterProperty:
        def __init__(
            self,
            *,
            behavior: builtins.str,
            conditions: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.ConditionProperty", typing.Dict[builtins.str, typing.Any]]]]],
            requirement: builtins.str,
        ) -> None:
            '''A single logging filter, used in ``LoggingFilter`` .

            :param behavior: How to handle logs that satisfy the filter's conditions and requirement.
            :param conditions: Match conditions for the filter.
            :param requirement: Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                filter_property = wafv2.CfnLoggingConfiguration.FilterProperty(
                    behavior="behavior",
                    conditions=[wafv2.CfnLoggingConfiguration.ConditionProperty(
                        action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                            action="action"
                        ),
                        label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                            label_name="labelName"
                        )
                    )],
                    requirement="requirement"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b78b0441cbfd332efa20e314d1f8d29adb0ea98f8aee71719041ba64fe798c15)
                check_type(argname="argument behavior", value=behavior, expected_type=type_hints["behavior"])
                check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
                check_type(argname="argument requirement", value=requirement, expected_type=type_hints["requirement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "behavior": behavior,
                "conditions": conditions,
                "requirement": requirement,
            }

        @builtins.property
        def behavior(self) -> builtins.str:
            '''How to handle logs that satisfy the filter's conditions and requirement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-behavior
            '''
            result = self._values.get("behavior")
            assert result is not None, "Required property 'behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def conditions(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ConditionProperty"]]]:
            '''Match conditions for the filter.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-conditions
            '''
            result = self._values.get("conditions")
            assert result is not None, "Required property 'conditions' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.ConditionProperty"]]], result)

        @builtins.property
        def requirement(self) -> builtins.str:
            '''Logic to apply to the filtering conditions.

            You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-requirement
            '''
            result = self._values.get("requirement")
            assert result is not None, "Required property 'requirement' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.MatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``All`` , AWS WAF matches against keys and values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array. AWS WAF parses the JSON in the following examples as two valid key, value pairs: - Missing comma: ``{"key1":"value1""key2":"value2"}`` - Missing colon: ``{"key1":"value1","key2""value2"}`` - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnLoggingConfiguration.JsonBodyProperty(
                    match_pattern=wafv2.CfnLoggingConfiguration.MatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__eecc91912e5b445e79d0bc6e4a9855bb182f496c1cd38ebc4465393f47e06750)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.MatchPatternProperty"]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.MatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``All`` , AWS WAF matches against keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

            AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.

            AWS WAF parses the JSON in the following examples as two valid key, value pairs:

            - Missing comma: ``{"key1":"value1""key2":"value2"}``
            - Missing colon: ``{"key1":"value1","key2""value2"}``
            - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LabelNameConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"label_name": "labelName"},
    )
    class LabelNameConditionProperty:
        def __init__(self, *, label_name: builtins.str) -> None:
            '''A single label name condition for a condition in a logging filter.

            :param label_name: The label name that a log record must contain in order to meet the condition. This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_name_condition_property = wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                    label_name="labelName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ce4928adbdaf21f843c60f7ff46db78d9f71cd9a544213de312c7a389034c4c2)
                check_type(argname="argument label_name", value=label_name, expected_type=type_hints["label_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "label_name": label_name,
            }

        @builtins.property
        def label_name(self) -> builtins.str:
            '''The label name that a log record must contain in order to meet the condition.

            This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html#cfn-wafv2-loggingconfiguration-labelnamecondition-labelname
            '''
            result = self._values.get("label_name")
            assert result is not None, "Required property 'label_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelNameConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.LoggingFilterProperty",
        jsii_struct_bases=[],
        name_mapping={"default_behavior": "defaultBehavior", "filters": "filters"},
    )
    class LoggingFilterProperty:
        def __init__(
            self,
            *,
            default_behavior: builtins.str,
            filters: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnLoggingConfiguration.FilterProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Filtering that specifies which web requests are kept in the logs and which are dropped, defined for a web ACL's ``LoggingConfiguration`` .

            You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

            :param default_behavior: Default handling for logs that don't match any of the specified filtering conditions.
            :param filters: The filters that you want to apply to the logs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                logging_filter_property = wafv2.CfnLoggingConfiguration.LoggingFilterProperty(
                    default_behavior="defaultBehavior",
                    filters=[wafv2.CfnLoggingConfiguration.FilterProperty(
                        behavior="behavior",
                        conditions=[wafv2.CfnLoggingConfiguration.ConditionProperty(
                            action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                                action="action"
                            ),
                            label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                                label_name="labelName"
                            )
                        )],
                        requirement="requirement"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bfe62ade2e509570c793f0eb85aa51c6ec6f9070c34bb75ad87d9c454a31de06)
                check_type(argname="argument default_behavior", value=default_behavior, expected_type=type_hints["default_behavior"])
                check_type(argname="argument filters", value=filters, expected_type=type_hints["filters"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "default_behavior": default_behavior,
                "filters": filters,
            }

        @builtins.property
        def default_behavior(self) -> builtins.str:
            '''Default handling for logs that don't match any of the specified filtering conditions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-defaultbehavior
            '''
            result = self._values.get("default_behavior")
            assert result is not None, "Required property 'default_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def filters(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FilterProperty"]]]:
            '''The filters that you want to apply to the logs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-filters
            '''
            result = self._values.get("filters")
            assert result is not None, "Required property 'filters' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnLoggingConfiguration.FilterProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LoggingFilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.MatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class MatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :param all: Match all of the elements. You must specify either this setting or the ``IncludedPaths`` setting, but not both.
            :param included_paths: Match only the specified include paths. Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . You must specify either this setting or the ``All`` setting, but not both. .. epigraph:: Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                match_pattern_property = wafv2.CfnLoggingConfiguration.MatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7f5363956da4183fbbc9d58305c49d115c7f21916e1661cc8e8b3e772aeac3c5)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''Match all of the elements.

            You must specify either this setting or the ``IncludedPaths`` setting, but not both.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Match only the specified include paths.

            Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            You must specify either this setting or the ``All`` setting, but not both.
            .. epigraph::

               Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.SingleHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleHeaderProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one of the headers in the web request, identified by name, for example, ``User-Agent`` or ``Referer`` .

            The name isn't case sensitive.

            You can filter and inspect all headers with the ``FieldToMatch`` setting ``Headers`` .

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :param name: The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_header_property = wafv2.CfnLoggingConfiguration.SingleHeaderProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fcdbe2344105f56809989a50b71b674a0abcb188986d4b216ba3fc5f416632c2)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html#cfn-wafv2-loggingconfiguration-singleheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnLoggingConfigurationProps",
    jsii_struct_bases=[],
    name_mapping={
        "log_destination_configs": "logDestinationConfigs",
        "resource_arn": "resourceArn",
        "logging_filter": "loggingFilter",
        "redacted_fields": "redactedFields",
    },
)
class CfnLoggingConfigurationProps:
    def __init__(
        self,
        *,
        log_destination_configs: typing.Sequence[builtins.str],
        resource_arn: builtins.str,
        logging_filter: typing.Any = None,
        redacted_fields: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnLoggingConfiguration.FieldToMatchProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnLoggingConfiguration``.

        :param log_destination_configs: The logging destination configuration that you want to associate with the web ACL. .. epigraph:: You can associate one logging destination to a web ACL.
        :param resource_arn: The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .
        :param logging_filter: Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
        :param redacted_fields: The parts of the request that you want to keep out of the logs. For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``REDACTED`` for all rules that use the ``SingleHeader`` ``FieldToMatch`` setting. Redaction applies only to the component that's specified in the rule's ``FieldToMatch`` setting, so the ``SingleHeader`` redaction doesn't apply to rules that use the ``Headers`` ``FieldToMatch`` . .. epigraph:: You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_wafv2 as wafv2
            
            # json_body: Any
            # logging_filter: Any
            # method: Any
            # query_string: Any
            # single_header: Any
            # uri_path: Any
            
            cfn_logging_configuration_props = wafv2.CfnLoggingConfigurationProps(
                log_destination_configs=["logDestinationConfigs"],
                resource_arn="resourceArn",
            
                # the properties below are optional
                logging_filter=logging_filter,
                redacted_fields=[wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                    json_body=json_body,
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    uri_path=uri_path
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__713893ab58a2ac0a37391a960bcaeb40dad62a9addec656d6016e0911ff1d752)
            check_type(argname="argument log_destination_configs", value=log_destination_configs, expected_type=type_hints["log_destination_configs"])
            check_type(argname="argument resource_arn", value=resource_arn, expected_type=type_hints["resource_arn"])
            check_type(argname="argument logging_filter", value=logging_filter, expected_type=type_hints["logging_filter"])
            check_type(argname="argument redacted_fields", value=redacted_fields, expected_type=type_hints["redacted_fields"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "log_destination_configs": log_destination_configs,
            "resource_arn": resource_arn,
        }
        if logging_filter is not None:
            self._values["logging_filter"] = logging_filter
        if redacted_fields is not None:
            self._values["redacted_fields"] = redacted_fields

    @builtins.property
    def log_destination_configs(self) -> typing.List[builtins.str]:
        '''The logging destination configuration that you want to associate with the web ACL.

        .. epigraph::

           You can associate one logging destination to a web ACL.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs
        '''
        result = self._values.get("log_destination_configs")
        assert result is not None, "Required property 'log_destination_configs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def resource_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn
        '''
        result = self._values.get("resource_arn")
        assert result is not None, "Required property 'resource_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def logging_filter(self) -> typing.Any:
        '''Filtering that specifies which web requests are kept in the logs and which are dropped.

        You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter
        '''
        result = self._values.get("logging_filter")
        return typing.cast(typing.Any, result)

    @builtins.property
    def redacted_fields(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnLoggingConfiguration.FieldToMatchProperty]]]]:
        '''The parts of the request that you want to keep out of the logs.

        For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``REDACTED`` for all rules that use the ``SingleHeader`` ``FieldToMatch`` setting.

        Redaction applies only to the component that's specified in the rule's ``FieldToMatch`` setting, so the ``SingleHeader`` redaction doesn't apply to rules that use the ``Headers`` ``FieldToMatch`` .
        .. epigraph::

           You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , and ``Method`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields
        '''
        result = self._values.get("redacted_fields")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnLoggingConfiguration.FieldToMatchProperty]]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnLoggingConfigurationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnRegexPatternSet(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRegexPatternSet",
):
    '''A CloudFormation ``AWS::WAFv2::RegexPatternSet``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``RegexPatternSet`` to have AWS WAF inspect a web request component for a specific set of regular expression patterns.

    You use a regex pattern set by providing its Amazon Resource Name (ARN) to the rule statement ``RegexPatternSetReferenceStatement`` , when you add a rule to a rule group or web ACL.

    :cloudformationResource: AWS::WAFv2::RegexPatternSet
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_wafv2 as wafv2
        
        cfn_regex_pattern_set = wafv2.CfnRegexPatternSet(self, "MyCfnRegexPatternSet",
            regular_expression_list=["regularExpressionList"],
            scope="scope",
        
            # the properties below are optional
            description="description",
            name="name",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        regular_expression_list: typing.Sequence[builtins.str],
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::RegexPatternSet``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param regular_expression_list: The regular expression patterns in the set.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the set that helps with identification.
        :param name: The name of the set. You cannot change the name after you create the set.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9cac4ad6f53737b9539cafcf1c5335cc1730b94e91e16609b8484eeb02a972c)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnRegexPatternSetProps(
            regular_expression_list=regular_expression_list,
            scope=scope,
            description=description,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bb67597e6b986a810872fc80d040910cf0c649df66f8a90887b49bb15b1d104)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__131971a5443887615a0e02b763d8b00cc2eb6e5c404f9fa6d94b78266aefdffb)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the regex pattern set.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the regex pattern set.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="regularExpressionList")
    def regular_expression_list(self) -> typing.List[builtins.str]:
        '''The regular expression patterns in the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-regularexpressionlist
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "regularExpressionList"))

    @regular_expression_list.setter
    def regular_expression_list(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4ca0288728c67165a7c1ac018aedf56cbbc29ab8b7d65a41aa53725cabca8c2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "regularExpressionList", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f64738019eff796073258de928c3af2e479868f96c5ac05ec7a01d8f1e6953ad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e92feb6e48a6da68fe36d1bef73657aa406f74df78d1b77d7d494a4b92949a9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the set.

        You cannot change the name after you create the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b2d8f91c1720f07bbe37765c9c4ba11a88810bbc881356de626a279e0b29542)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRegexPatternSetProps",
    jsii_struct_bases=[],
    name_mapping={
        "regular_expression_list": "regularExpressionList",
        "scope": "scope",
        "description": "description",
        "name": "name",
        "tags": "tags",
    },
)
class CfnRegexPatternSetProps:
    def __init__(
        self,
        *,
        regular_expression_list: typing.Sequence[builtins.str],
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnRegexPatternSet``.

        :param regular_expression_list: The regular expression patterns in the set.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the set that helps with identification.
        :param name: The name of the set. You cannot change the name after you create the set.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_wafv2 as wafv2
            
            cfn_regex_pattern_set_props = wafv2.CfnRegexPatternSetProps(
                regular_expression_list=["regularExpressionList"],
                scope="scope",
            
                # the properties below are optional
                description="description",
                name="name",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4655926f3e763ad1701fea25b17a982c17326f38b7601267b5b7b6462571865e)
            check_type(argname="argument regular_expression_list", value=regular_expression_list, expected_type=type_hints["regular_expression_list"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "regular_expression_list": regular_expression_list,
            "scope": scope,
        }
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def regular_expression_list(self) -> typing.List[builtins.str]:
        '''The regular expression patterns in the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-regularexpressionlist
        '''
        result = self._values.get("regular_expression_list")
        assert result is not None, "Required property 'regular_expression_list' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the set.

        You cannot change the name after you create the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRegexPatternSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnRuleGroup(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup",
):
    '''A CloudFormation ``AWS::WAFv2::RuleGroup``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``RuleGroup`` to define a collection of rules for inspecting and controlling web requests. You use a rule group in an ``WebACL`` by providing its Amazon Resource Name (ARN) to the rule statement ``RuleGroupReferenceStatement`` , when you add rules to the web ACL.

    When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.

    :cloudformationResource: AWS::WAFv2::RuleGroup
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_wafv2 as wafv2
        
        # all: Any
        # allow: Any
        # all_query_arguments: Any
        # block: Any
        # captcha: Any
        # challenge: Any
        # count: Any
        # method: Any
        # query_string: Any
        # single_header: Any
        # single_query_argument: Any
        # statement_property_: wafv2.CfnRuleGroup.StatementProperty
        # uri_path: Any
        
        cfn_rule_group = wafv2.CfnRuleGroup(self, "MyCfnRuleGroup",
            capacity=123,
            scope="scope",
            visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                cloud_watch_metrics_enabled=False,
                metric_name="metricName",
                sampled_requests_enabled=False
            ),
        
            # the properties below are optional
            available_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                name="name"
            )],
            consumed_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                name="name"
            )],
            custom_response_bodies={
                "custom_response_bodies_key": wafv2.CfnRuleGroup.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            },
            description="description",
            name="name",
            rules=[wafv2.CfnRuleGroup.RuleProperty(
                name="name",
                priority=123,
                statement=wafv2.CfnRuleGroup.StatementProperty(
                    and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                        statements=[statement_property_]
                    ),
                    byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        positional_constraint="positionalConstraint",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
        
                        # the properties below are optional
                        search_string="searchString",
                        search_string_base64="searchStringBase64"
                    ),
                    geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                        country_codes=["countryCodes"],
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        )
                    ),
                    ip_set_reference_statement={
                        "arn": "arn",
        
                        # the properties below are optional
                        "ip_set_forwarded_ip_config": {
                            "fallback_behavior": "fallbackBehavior",
                            "header_name": "headerName",
                            "position": "position"
                        }
                    },
                    label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                        key="key",
                        scope="scope"
                    ),
                    not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                        statement=statement_property_
                    ),
                    or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                        statements=[statement_property_]
                    ),
                    rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                        aggregate_key_type="aggregateKeyType",
                        limit=123,
        
                        # the properties below are optional
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        ),
                        scope_down_statement=statement_property_
                    ),
                    regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        regex_string="regexString",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                        arn="arn",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                        comparison_operator="comparisonOperator",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        size=123,
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
        
                        # the properties below are optional
                        sensitivity_level="sensitivityLevel"
                    ),
                    xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    )
                ),
                visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                ),
        
                # the properties below are optional
                action=wafv2.CfnRuleGroup.RuleActionProperty(
                    allow=allow,
                    block=block,
                    captcha=captcha,
                    challenge=challenge,
                    count=count
                ),
                captcha_config=wafv2.CfnRuleGroup.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                ),
                challenge_config=wafv2.CfnRuleGroup.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                ),
                rule_labels=[wafv2.CfnRuleGroup.LabelProperty(
                    name="name"
                )]
            )],
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        capacity: jsii.Number,
        scope: builtins.str,
        visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        available_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelSummaryProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        consumed_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelSummaryProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomResponseBodyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RuleProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::RuleGroup``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param capacity: The web ACL capacity units (WCUs) required for this rule group. When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit. AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param available_labels: The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the ``RuleLabels`` for a ``Rule`` .
        :param consumed_labels: The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
        :param description: A description of the rule group that helps with identification.
        :param name: The name of the rule group. You cannot change the name of a rule group after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__39414085bb3516b24d65751cc1c079ecf5858068f282c2e495c8018706735edc)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnRuleGroupProps(
            capacity=capacity,
            scope=scope,
            visibility_config=visibility_config,
            available_labels=available_labels,
            consumed_labels=consumed_labels,
            custom_response_bodies=custom_response_bodies,
            description=description,
            name=name,
            rules=rules,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__876762f27eecc699ae54746548a47c32e6e3addbc69b2ea95646b69ad890682c)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e035e41ba622b9f85376fe682de1ee8f6e8c3e3b255d40dc70db5eb415158e8)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the rule group.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the rule group.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="attrLabelNamespace")
    def attr_label_namespace(self) -> builtins.str:
        '''The label namespace prefix for this rule group.

        All labels added by rules in this rule group have this prefix.

        The syntax for the label namespace prefix for a rule group is the following: ``awswaf:<account ID>:rule group:<rule group name>:``

        When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.

        :cloudformationAttribute: LabelNamespace
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLabelNamespace"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="capacity")
    def capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) required for this rule group.

        When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity
        '''
        return typing.cast(jsii.Number, jsii.get(self, "capacity"))

    @capacity.setter
    def capacity(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a56c37c7bc29f2831ea729412a7f600abdd6f1d91a82d7a5effddbb927d0dfa1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "capacity", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae8ffe104c6f6915775b7c5e65eddfe2215df681e4310f44b338e7e68c3b4873)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="visibilityConfig")
    def visibility_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"], jsii.get(self, "visibilityConfig"))

    @visibility_config.setter
    def visibility_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59c44d25e9138a6e2331abe9c20e650b2a9a6f305b0d924cd2ec4eb2a2b53c82)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "visibilityConfig", value)

    @builtins.property
    @jsii.member(jsii_name="availableLabels")
    def available_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]]:
        '''The labels that one or more rules in this rule group add to matching web requests.

        These labels are defined in the ``RuleLabels`` for a ``Rule`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-availablelabels
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]], jsii.get(self, "availableLabels"))

    @available_labels.setter
    def available_labels(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__87efb1e72c16cf174a66f5de7e3a1acb593ad15b2a49891fedc3a05d24744ab7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "availableLabels", value)

    @builtins.property
    @jsii.member(jsii_name="consumedLabels")
    def consumed_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]]:
        '''The labels that one or more rules in this rule group match against in label match statements.

        These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-consumedlabels
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]], jsii.get(self, "consumedLabels"))

    @consumed_labels.setter
    def consumed_labels(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelSummaryProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__151ac040118628222af413c1e8037639c78074fcbf0820eca1183493bbc6a276)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "consumedLabels", value)

    @builtins.property
    @jsii.member(jsii_name="customResponseBodies")
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseBodyProperty"]]]]:
        '''A map of custom response keys and content bodies.

        When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.

        For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

        For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-customresponsebodies
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseBodyProperty"]]]], jsii.get(self, "customResponseBodies"))

    @custom_response_bodies.setter
    def custom_response_bodies(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseBodyProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c6734af8825be0006d3866bbb0cbe92224af63291661891e57e0c75552c6b52)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customResponseBodies", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the rule group that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a74ba4694f9055d7fa9dea9d8533dae3a9863fe2c52936a40f56b5ee621a7bd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the rule group.

        You cannot change the name of a rule group after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__318f59356ef5efba50745f0edba0c5a641ba203e36f7ea75fa71db32f96cdffe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleProperty"]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.

        Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleProperty"]]]], jsii.get(self, "rules"))

    @rules.setter
    def rules(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c59df75c410f1ef0e87781b4669ef58e1c494a030dbd329d9d3b33e5e5689c36)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "rules", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.AllowProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class AllowProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.AllowProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-allowaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                allow_property = wafv2.CfnRuleGroup.AllowProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0cd21728bae207efe1b926b2fbc1d23015b74ee0d958e5665ab40b1f44536fb5)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''``CfnRuleGroup.AllowProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-allowaction.html#cfn-wafv2-rulegroup-allowaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AllowProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.AndStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class AndStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :param statements: The statements to combine with AND logic. You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                and_statement_property = wafv2.CfnRuleGroup.AndStatementProperty(
                    statements=[wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__563d7c7c3c7b0cea107ea61895bf83f08deacaa77dd306915bce9745256ed662)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]]:
            '''The statements to combine with AND logic.

            You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatement.html#cfn-wafv2-rulegroup-andstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AndStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.BlockProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_response": "customResponse"},
    )
    class BlockProperty:
        def __init__(
            self,
            *,
            custom_response: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomResponseProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''
            :param custom_response: ``CfnRuleGroup.BlockProperty.CustomResponse``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-blockaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                block_property = wafv2.CfnRuleGroup.BlockProperty(
                    custom_response=wafv2.CfnRuleGroup.CustomResponseProperty(
                        response_code=123,
                
                        # the properties below are optional
                        custom_response_body_key="customResponseBodyKey",
                        response_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__48d37744c2bde6e8969fbbe9f60128093f4d69360ff6c086fcb635ca42f3ae63)
                check_type(argname="argument custom_response", value=custom_response, expected_type=type_hints["custom_response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_response is not None:
                self._values["custom_response"] = custom_response

        @builtins.property
        def custom_response(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseProperty"]]:
            '''``CfnRuleGroup.BlockProperty.CustomResponse``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-blockaction.html#cfn-wafv2-rulegroup-blockaction-customresponse
            '''
            result = self._values.get("custom_response")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomResponseProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.BodyProperty",
        jsii_struct_bases=[],
        name_mapping={"oversize_handling": "oversizeHandling"},
    )
    class BodyProperty:
        def __init__(
            self,
            *,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection. The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-body.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                body_property = wafv2.CfnRuleGroup.BodyProperty(
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__506ec9a30f623a62378d6a06c17d4d19e8ba6fd573f92a7b1c1c0344e158f1c1)
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection.

            The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-body.html#cfn-wafv2-rulegroup-body-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ByteMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "positional_constraint": "positionalConstraint",
            "text_transformations": "textTransformations",
            "search_string": "searchString",
            "search_string_base64": "searchStringBase64",
        },
    )
    class ByteMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            positional_constraint: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            search_string: typing.Optional[builtins.str] = None,
            search_string_base64: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param positional_constraint: The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` . Valid values include the following: *CONTAINS* The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter. *CONTAINS_WORD* The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true: - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` . - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` . *EXACTLY* The value of the specified part of the web request must exactly match the value of ``SearchString`` . *STARTS_WITH* The value of ``SearchString`` must appear at the beginning of the specified part of the web request. *ENDS_WITH* The value of ``SearchString`` must appear at the end of the specified part of the web request.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive. Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you. For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` . You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .
            :param search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead. You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                byte_match_statement_property = wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    positional_constraint="positionalConstraint",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    search_string="searchString",
                    search_string_base64="searchStringBase64"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e374dcbd15c82dd0423abc3fb66bf99c31bc4d6a714fc65deb3dbdbc83866d7a)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument positional_constraint", value=positional_constraint, expected_type=type_hints["positional_constraint"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument search_string", value=search_string, expected_type=type_hints["search_string"])
                check_type(argname="argument search_string_base64", value=search_string_base64, expected_type=type_hints["search_string_base64"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "positional_constraint": positional_constraint,
                "text_transformations": text_transformations,
            }
            if search_string is not None:
                self._values["search_string"] = search_string
            if search_string_base64 is not None:
                self._values["search_string_base64"] = search_string_base64

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def positional_constraint(self) -> builtins.str:
            '''The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` .

            Valid values include the following:

            *CONTAINS*

            The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter.

            *CONTAINS_WORD*

            The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true:

            - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` .
            - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` .

            *EXACTLY*

            The value of the specified part of the web request must exactly match the value of ``SearchString`` .

            *STARTS_WITH*

            The value of ``SearchString`` must appear at the beginning of the specified part of the web request.

            *ENDS_WITH*

            The value of ``SearchString`` must appear at the end of the specified part of the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-positionalconstraint
            '''
            result = self._values.get("positional_constraint")
            assert result is not None, "Required property 'positional_constraint' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        @builtins.property
        def search_string(self) -> typing.Optional[builtins.str]:
            '''A string value that you want AWS WAF to search for.

            AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

            Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

            For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` .

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstring
            '''
            result = self._values.get("search_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def search_string_base64(self) -> typing.Optional[builtins.str]:
            '''String to search for in a web request component, base64-encoded.

            If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead.

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstringbase64
            '''
            result = self._values.get("search_string_base64")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ByteMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class CaptchaConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_config_property = wafv2.CfnRuleGroup.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ebafa919d6724cdf183a20541551119bce7173107fdd048a66c88459d0941bc1)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]]:
            '''Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaconfig.html#cfn-wafv2-rulegroup-captchaconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CaptchaProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.CaptchaProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_property = wafv2.CfnRuleGroup.CaptchaProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__af6223a5f7ab5465cccb92f4c58392286f808a004540f62c1e1e9129cd070b73)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''``CfnRuleGroup.CaptchaProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaaction.html#cfn-wafv2-rulegroup-captchaaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ChallengeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class ChallengeConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_config_property = wafv2.CfnRuleGroup.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__62c099b656c2f0c706d5eb59ef0ae29419c316ced387e2eadf3d991364f580a9)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]]:
            '''Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeconfig.html#cfn-wafv2-rulegroup-challengeconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ChallengeProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class ChallengeProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.ChallengeProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_property = wafv2.CfnRuleGroup.ChallengeProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d906d833235c5ff91003135445d7c19e5b8c861e7c39ccfa0ef7dcfd1be6ef5f)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''``CfnRuleGroup.ChallengeProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeaction.html#cfn-wafv2-rulegroup-challengeaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookieMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_cookies": "excludedCookies",
            "included_cookies": "includedCookies",
        },
    )
    class CookieMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :param all: Inspect all cookies.
            :param excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
            :param included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookie_match_pattern_property = wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                    all=all,
                    excluded_cookies=["excludedCookies"],
                    included_cookies=["includedCookies"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ba3427cb356d43e73608b1ba33a4b697440f7941676945db2ccd811c8adec13b)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_cookies", value=excluded_cookies, expected_type=type_hints["excluded_cookies"])
                check_type(argname="argument included_cookies", value=included_cookies, expected_type=type_hints["included_cookies"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_cookies is not None:
                self._values["excluded_cookies"] = excluded_cookies
            if included_cookies is not None:
                self._values["included_cookies"] = included_cookies

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all cookies.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-excludedcookies
            '''
            result = self._values.get("excluded_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-includedcookies
            '''
            result = self._values.get("included_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookieMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookiesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class CookiesProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CookieMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect the cookies in the web request.

            You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` . Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``
            :param match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookies_property = wafv2.CfnRuleGroup.CookiesProperty(
                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                        all=all,
                        excluded_cookies=["excludedCookies"],
                        included_cookies=["includedCookies"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__687d06c7916771b985b2d22b396936b0c009299c093162a7c6c07603792055aa)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookieMatchPatternProperty"]:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookieMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the cookies to inspect with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookiesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CountProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CountProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.CountProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-countaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                count_property = wafv2.CfnRuleGroup.CountProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__71e61a42e92f193c85d1fcfd81493f8469fc462d68588518298fa55ac4d312ce)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]]:
            '''``CfnRuleGroup.CountProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-countaction.html#cfn-wafv2-rulegroup-countaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CountProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomHTTPHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "value": "value"},
    )
    class CustomHTTPHeaderProperty:
        def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
            '''A custom header for custom request and response handling.

            This is used in ``CustomResponse`` and ``CustomRequestHandling``

            :param name: The name of the custom header. For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .
            :param value: The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_hTTPHeader_property = wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                    name="name",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3d76773fc27e7f41d84dbd4e3336cc6488a3528c4316f455a7a0ae4a9a53cbdd)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "value": value,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the custom header.

            For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html#cfn-wafv2-rulegroup-customhttpheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html#cfn-wafv2-rulegroup-customhttpheader-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomHTTPHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomRequestHandlingProperty",
        jsii_struct_bases=[],
        name_mapping={"insert_headers": "insertHeaders"},
    )
    class CustomRequestHandlingProperty:
        def __init__(
            self,
            *,
            insert_headers: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Custom request handling behavior that inserts custom headers into a web request.

            You can add custom request handling for AWS WAF to use when the rule action doesn't block the request. For example, ``CaptchaAction`` for requests with valid t okens, and ``AllowAction`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :param insert_headers: The HTTP headers to insert into the request. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customrequesthandling.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_request_handling_property = wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                    insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__732e127a19f06b44c67d7c677da73501e7c1d2652c4330adfb7b2c8f89bd232f)
                check_type(argname="argument insert_headers", value=insert_headers, expected_type=type_hints["insert_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "insert_headers": insert_headers,
            }

        @builtins.property
        def insert_headers(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]]:
            '''The HTTP headers to insert into the request. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customrequesthandling.html#cfn-wafv2-rulegroup-customrequesthandling-insertheaders
            '''
            result = self._values.get("insert_headers")
            assert result is not None, "Required property 'insert_headers' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomRequestHandlingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseBodyProperty",
        jsii_struct_bases=[],
        name_mapping={"content": "content", "content_type": "contentType"},
    )
    class CustomResponseBodyProperty:
        def __init__(
            self,
            *,
            content: builtins.str,
            content_type: builtins.str,
        ) -> None:
            '''The response body to use in a custom response to a web request.

            This is referenced by key from ``CustomResponse`` ``CustomResponseBodyKey`` .

            :param content: The payload of the custom response. You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
            :param content_type: The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_body_property = wafv2.CfnRuleGroup.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__95738aad7b36944436b448ead8858c2960f4aa04ae3ab6cdecc68eb1431cec78)
                check_type(argname="argument content", value=content, expected_type=type_hints["content"])
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "content": content,
                "content_type": content_type,
            }

        @builtins.property
        def content(self) -> builtins.str:
            '''The payload of the custom response.

            You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html#cfn-wafv2-rulegroup-customresponsebody-content
            '''
            result = self._values.get("content")
            assert result is not None, "Required property 'content' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def content_type(self) -> builtins.str:
            '''The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html#cfn-wafv2-rulegroup-customresponsebody-contenttype
            '''
            result = self._values.get("content_type")
            assert result is not None, "Required property 'content_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "response_code": "responseCode",
            "custom_response_body_key": "customResponseBodyKey",
            "response_headers": "responseHeaders",
        },
    )
    class CustomResponseProperty:
        def __init__(
            self,
            *,
            response_code: jsii.Number,
            custom_response_body_key: typing.Optional[builtins.str] = None,
            response_headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A custom response to send to the client.

            You can define a custom response for rule actions and default web ACL actions that are set to ``Block`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param response_code: The HTTP status code to return to the client. For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .
            :param custom_response_body_key: References the response body that you want AWS WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.
            :param response_headers: The HTTP headers to use in the response. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_property = wafv2.CfnRuleGroup.CustomResponseProperty(
                    response_code=123,
                
                    # the properties below are optional
                    custom_response_body_key="customResponseBodyKey",
                    response_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a656c09c13fc139cde331d7b8cda07db864bbfa6a8458d1482a84a0c4366634e)
                check_type(argname="argument response_code", value=response_code, expected_type=type_hints["response_code"])
                check_type(argname="argument custom_response_body_key", value=custom_response_body_key, expected_type=type_hints["custom_response_body_key"])
                check_type(argname="argument response_headers", value=response_headers, expected_type=type_hints["response_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "response_code": response_code,
            }
            if custom_response_body_key is not None:
                self._values["custom_response_body_key"] = custom_response_body_key
            if response_headers is not None:
                self._values["response_headers"] = response_headers

        @builtins.property
        def response_code(self) -> jsii.Number:
            '''The HTTP status code to return to the client.

            For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-responsecode
            '''
            result = self._values.get("response_code")
            assert result is not None, "Required property 'response_code' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_response_body_key(self) -> typing.Optional[builtins.str]:
            '''References the response body that you want AWS WAF to return to the web request client.

            You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-customresponsebodykey
            '''
            result = self._values.get("custom_response_body_key")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def response_headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]]]:
            '''The HTTP headers to use in the response. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-responseheaders
            '''
            result = self._values.get("response_headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CustomHTTPHeaderProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all_query_arguments": "allQueryArguments",
            "body": "body",
            "cookies": "cookies",
            "headers": "headers",
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "single_query_argument": "singleQueryArgument",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            all_query_arguments: typing.Any = None,
            body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.BodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            cookies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CookiesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.HeadersProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json_body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.JsonBodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            single_query_argument: typing.Any = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''The part of the web request that you want AWS WAF to inspect.

            Include the single ``FieldToMatch`` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in ``FieldToMatch`` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            :param all_query_arguments: Inspect all query arguments.
            :param body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees. For information about how to handle oversized request bodies, see the ``Body`` object configuration.
            :param cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param headers: Inspect the request headers. You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
            :param json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.
            :param method: Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Inspect the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Inspect a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }`` Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.
            :param single_query_argument: Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive. Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``
            :param uri_path: Inspect the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnRuleGroup.FieldToMatchProperty(
                    all_query_arguments=all_query_arguments,
                    body=wafv2.CfnRuleGroup.BodyProperty(
                        oversize_handling="oversizeHandling"
                    ),
                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                            all=all,
                            excluded_cookies=["excludedCookies"],
                            included_cookies=["includedCookies"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                            all=all,
                            excluded_headers=["excludedHeaders"],
                            included_headers=["includedHeaders"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                            all=all,
                            included_paths=["includedPaths"]
                        ),
                        match_scope="matchScope",
                
                        # the properties below are optional
                        invalid_fallback_behavior="invalidFallbackBehavior",
                        oversize_handling="oversizeHandling"
                    ),
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    single_query_argument=single_query_argument,
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__dcb790c3130e52c64e6b7cf00db86b37d1b54427689c46b6c9e6a712278d0a22)
                check_type(argname="argument all_query_arguments", value=all_query_arguments, expected_type=type_hints["all_query_arguments"])
                check_type(argname="argument body", value=body, expected_type=type_hints["body"])
                check_type(argname="argument cookies", value=cookies, expected_type=type_hints["cookies"])
                check_type(argname="argument headers", value=headers, expected_type=type_hints["headers"])
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument single_query_argument", value=single_query_argument, expected_type=type_hints["single_query_argument"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all_query_arguments is not None:
                self._values["all_query_arguments"] = all_query_arguments
            if body is not None:
                self._values["body"] = body
            if cookies is not None:
                self._values["cookies"] = cookies
            if headers is not None:
                self._values["headers"] = headers
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if single_query_argument is not None:
                self._values["single_query_argument"] = single_query_argument
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def all_query_arguments(self) -> typing.Any:
            '''Inspect all query arguments.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-allqueryarguments
            '''
            result = self._values.get("all_query_arguments")
            return typing.cast(typing.Any, result)

        @builtins.property
        def body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.BodyProperty"]]:
            '''Inspect the request body as plain text.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees.

            For information about how to handle oversized request bodies, see the ``Body`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-body
            '''
            result = self._values.get("body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.BodyProperty"]], result)

        @builtins.property
        def cookies(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookiesProperty"]]:
            '''Inspect the request cookies.

            You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-cookies
            '''
            result = self._values.get("cookies")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CookiesProperty"]], result)

        @builtins.property
        def headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeadersProperty"]]:
            '''Inspect the request headers.

            You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-headers
            '''
            result = self._values.get("headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeadersProperty"]], result)

        @builtins.property
        def json_body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonBodyProperty"]]:
            '''Inspect the request body as JSON.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees.

            For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonBodyProperty"]], result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Inspect the HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Inspect the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Inspect a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_query_argument(self) -> typing.Any:
            '''Inspect a single query argument.

            Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singlequeryargument
            '''
            result = self._values.get("single_query_argument")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Inspect the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
        },
    )
    class ForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used for ``GeoMatchStatement`` and ``RateBasedStatement`` . For ``IPSetReferenceStatement`` , use ``IPSetForwardedIPConfig`` instead.

            AWS WAF only evaluates the first IP address found in the specified HTTP header.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                forwarded_iPConfiguration_property = wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                    fallback_behavior="fallbackBehavior",
                    header_name="headerName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5f2c77ca83e05726f506d897c08097d3d52f7d5b27d7ff87dc1e895b0430f3fd)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html#cfn-wafv2-rulegroup-forwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html#cfn-wafv2-rulegroup-forwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.GeoMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "country_codes": "countryCodes",
            "forwarded_ip_config": "forwardedIpConfig",
        },
    )
    class GeoMatchStatementProperty:
        def __init__(
            self,
            *,
            country_codes: typing.Optional[typing.Sequence[builtins.str]] = None,
            forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param country_codes: An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard. When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                geo_match_statement_property = wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                    country_codes=["countryCodes"],
                    forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b307fe9ca02b540fc5c0f014f6b5a63a10a4add91a9ce999d840cbd0593ce99f)
                check_type(argname="argument country_codes", value=country_codes, expected_type=type_hints["country_codes"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if country_codes is not None:
                self._values["country_codes"] = country_codes
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config

        @builtins.property
        def country_codes(self) -> typing.Optional[typing.List[builtins.str]]:
            '''An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

            When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html#cfn-wafv2-rulegroup-geomatchstatement-countrycodes
            '''
            result = self._values.get("country_codes")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html#cfn-wafv2-rulegroup-geomatchstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GeoMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeaderMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_headers": "excludedHeaders",
            "included_headers": "includedHeaders",
        },
    )
    class HeaderMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :param all: Inspect all headers.
            :param excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
            :param included_headers: Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                header_match_pattern_property = wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                    all=all,
                    excluded_headers=["excludedHeaders"],
                    included_headers=["includedHeaders"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bf53983f4986a7d25fa1269a0ff0b5cd93f641c4e17e3e63be425cfea9d5fa60)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_headers", value=excluded_headers, expected_type=type_hints["excluded_headers"])
                check_type(argname="argument included_headers", value=included_headers, expected_type=type_hints["included_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_headers is not None:
                self._values["excluded_headers"] = excluded_headers
            if included_headers is not None:
                self._values["included_headers"] = included_headers

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all headers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-excludedheaders
            '''
            result = self._values.get("excluded_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-includedheaders
            '''
            result = self._values.get("included_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeaderMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeadersProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class HeadersProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.HeaderMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect all headers in the web request.

            You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            If you want to inspect just the value of a single header, use the ``SingleHeader`` ``FieldToMatch`` setting instead.

            Example JSON: ``"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of headers to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` . Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``
            :param match_scope: The parts of the headers to match with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                headers_property = wafv2.CfnRuleGroup.HeadersProperty(
                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                        all=all,
                        excluded_headers=["excludedHeaders"],
                        included_headers=["includedHeaders"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__68939559f5ddc50a99055ff471636da558cafd33ea1a0679c73384843b36a382)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeaderMatchPatternProperty"]:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.HeaderMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the headers to match with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeadersProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
            "position": "position",
        },
    )
    class IPSetForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
            position: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used only for ``IPSetReferenceStatement`` . For ``GeoMatchStatement`` and ``RateBasedStatement`` , use ``ForwardedIPConfig`` instead.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
            :param position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through. The options for this setting are the following: - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP. - LAST - Inspect the last IP address in the list of IP addresses in the header. - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_forwarded_iPConfiguration_property = {
                    "fallback_behavior": "fallbackBehavior",
                    "header_name": "headerName",
                    "position": "position"
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fafdfae16db1aec677d9eb805b9fce3561f7cbd357f87afbf97e39466e915dd1)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
                check_type(argname="argument position", value=position, expected_type=type_hints["position"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
                "position": position,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def position(self) -> builtins.str:
            '''The position in the header to search for the IP address.

            The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through.

            The options for this setting are the following:

            - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
            - LAST - Inspect the last IP address in the list of IP addresses in the header.
            - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-position
            '''
            result = self._values.get("position")
            assert result is not None, "Required property 'position' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "ip_set_forwarded_ip_config": "ipSetForwardedIpConfig",
        },
    )
    class IPSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            ip_set_forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.IPSetForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.
            :param ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_reference_statement_property = {
                    "arn": "arn",
                
                    # the properties below are optional
                    "ip_set_forwarded_ip_config": {
                        "fallback_behavior": "fallbackBehavior",
                        "header_name": "headerName",
                        "position": "position"
                    }
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__aa7f79ff40e6abfc4bf693b928feb685105969a0b0d18737637b0770de375f24)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument ip_set_forwarded_ip_config", value=ip_set_forwarded_ip_config, expected_type=type_hints["ip_set_forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
            }
            if ip_set_forwarded_ip_config is not None:
                self._values["ip_set_forwarded_ip_config"] = ip_set_forwarded_ip_config

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html#cfn-wafv2-rulegroup-ipsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def ip_set_forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html#cfn-wafv2-rulegroup-ipsetreferencestatement-ipsetforwardedipconfig
            '''
            result = self._values.get("ip_set_forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ImmunityTimePropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time": "immunityTime"},
    )
    class ImmunityTimePropertyProperty:
        def __init__(self, *, immunity_time: jsii.Number) -> None:
            '''Used for CAPTCHA and challenge token settings.

            Determines how long a ``CAPTCHA`` or challenge timestamp remains valid after AWS WAF updates it for a successful ``CAPTCHA`` or challenge response.

            :param immunity_time: The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF . The default setting is 300. For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-immunitytimeproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                immunity_time_property_property = wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f31a0b3f57889411d82cd445b651ca6964104416a165d4f1341a7386ece7f8a2)
                check_type(argname="argument immunity_time", value=immunity_time, expected_type=type_hints["immunity_time"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "immunity_time": immunity_time,
            }

        @builtins.property
        def immunity_time(self) -> jsii.Number:
            '''The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF .

            The default setting is 300.

            For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-immunitytimeproperty.html#cfn-wafv2-rulegroup-immunitytimeproperty-immunitytime
            '''
            result = self._values.get("immunity_time")
            assert result is not None, "Required property 'immunity_time' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImmunityTimePropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
            "oversize_handling": "oversizeHandling",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.JsonMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``All`` , AWS WAF matches against keys and values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array. AWS WAF parses the JSON in the following examples as two valid key, value pairs: - Missing comma: ``{"key1":"value1""key2":"value2"}`` - Missing colon: ``{"key1":"value1","key2""value2"}`` - Extra colons: ``{"key1"::"value1","key2""value2"}``
            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection. The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnRuleGroup.JsonBodyProperty(
                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__602ab3bf019e524b1f85e0a2cdb3225626316719b294dfa66fcfd8b7fc9e7a09)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonMatchPatternProperty"]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.JsonMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``All`` , AWS WAF matches against keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

            AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.

            AWS WAF parses the JSON in the following examples as two valid key, value pairs:

            - Missing comma: ``{"key1":"value1""key2":"value2"}``
            - Missing colon: ``{"key1":"value1","key2""value2"}``
            - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection.

            The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class JsonMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the ``FieldToMatch`` option ``JsonBody`` .

            :param all: Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. You must specify either this setting or the ``IncludedPaths`` setting, but not both.
            :param included_paths: Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . You must specify either this setting or the ``All`` setting, but not both. .. epigraph:: Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_match_pattern_property = wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__dab2a32ecd37609031b6a2466d7e688b30c96fc1ad44abc1ef8772113d9cb2f0)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            You must specify either this setting or the ``IncludedPaths`` setting, but not both.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html#cfn-wafv2-rulegroup-jsonmatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            You must specify either this setting or the ``All`` setting, but not both.
            .. epigraph::

               Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html#cfn-wafv2-rulegroup-jsonmatchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "scope": "scope"},
    )
    class LabelMatchStatementProperty:
        def __init__(self, *, key: builtins.str, scope: builtins.str) -> None:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :param key: The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:. - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates. Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .
            :param scope: Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_match_statement_property = wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                    key="key",
                    scope="scope"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8534d6484d98965904a22ba8bb87bf13a7731fb62ca8c77473924f20bf4ef2c5)
                check_type(argname="argument key", value=key, expected_type=type_hints["key"])
                check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "key": key,
                "scope": scope,
            }

        @builtins.property
        def key(self) -> builtins.str:
            '''The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:.

            - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
            - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

            Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html#cfn-wafv2-rulegroup-labelmatchstatement-key
            '''
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def scope(self) -> builtins.str:
            '''Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html#cfn-wafv2-rulegroup-labelmatchstatement-scope
            '''
            result = self._values.get("scope")
            assert result is not None, "Required property 'scope' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''A single label container.

            This is used as an element of a label array in ``RuleLabels`` inside a rule.

            :param name: The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-label.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_property = wafv2.CfnRuleGroup.LabelProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__192de58f3deffa379dc85491b2590e2e3f6fc48000776732b0c87dc6f1301799)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-label.html#cfn-wafv2-rulegroup-label-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelSummaryProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelSummaryProperty:
        def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
            '''List of labels used by one or more of the rules of a ``RuleGroup`` .

            This summary object is used for the following rule group lists:

            - ``AvailableLabels`` - Labels that rules add to matching requests. These labels are defined in the ``RuleLabels`` for a rule.
            - ``ConsumedLabels`` - Labels that rules match against. These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.

            :param name: An individual label specification.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelsummary.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_summary_property = wafv2.CfnRuleGroup.LabelSummaryProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4c5532fc362b33574821b7df757d816e9a7fbb8ef8a968abb72e759637b21f08)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if name is not None:
                self._values["name"] = name

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''An individual label specification.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelsummary.html#cfn-wafv2-rulegroup-labelsummary-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelSummaryProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.NotStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statement": "statement"},
    )
    class NotStatementProperty:
        def __init__(
            self,
            *,
            statement: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''A logical rule statement used to negate the results of another rule statement.

            You provide one ``Statement`` within the ``NotStatement`` .

            :param statement: The statement to negate. You can use any statement that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                not_statement_property = wafv2.CfnRuleGroup.NotStatementProperty(
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5739539e5cf7f8d7c902a07e2068450067fcde040af783d61ea32e816467f4b0)
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statement": statement,
            }

        @builtins.property
        def statement(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]:
            '''The statement to negate.

            You can use any statement that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatement.html#cfn-wafv2-rulegroup-notstatement-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NotStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.OrStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class OrStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with OR logic.

            You provide more than one ``Statement`` within the ``OrStatement`` .

            :param statements: The statements to combine with OR logic. You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                or_statement_property = wafv2.CfnRuleGroup.OrStatementProperty(
                    statements=[wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ac0f7a31c2c062eaaca70b7d43c11c1e6b78ce7502ec2206e832cabc7d2428c0)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]]:
            '''The statements to combine with OR logic.

            You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatement.html#cfn-wafv2-rulegroup-orstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OrStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateBasedStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aggregate_key_type": "aggregateKeyType",
            "limit": "limit",
            "forwarded_ip_config": "forwardedIpConfig",
            "scope_down_statement": "scopeDownStatement",
        },
    )
    class RateBasedStatementProperty:
        def __init__(
            self,
            *,
            aggregate_key_type: builtins.str,
            limit: jsii.Number,
            forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            scope_down_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.

            You can use this to put a temporary block on requests from an IP address that is sending excessive requests.

            AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .

            When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.

            You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:

            - An IP match statement with an IP set that specifies the address 192.0.2.44.
            - A string match statement that searches in the User-Agent header for the string BadBot.

            In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.

            You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.

            :param aggregate_key_type: Setting that indicates how to aggregate the request counts. The options are the following:. - ``IP`` - Aggregate the request counts on the IP address from the web request origin. - ``FORWARDED_IP`` - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the ``ForwardedIPConfig`` , to specify the header to use. .. epigraph:: You can only use the ``IP`` and ``FORWARDED_IP`` key types.
            :param limit: The limit on requests per 5-minute period for a single originating IP address. If the statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. This is required if you specify a forwarded IP in the rule's aggregate key settings.
            :param scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement. Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable statement in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                rate_based_statement_property = wafv2.CfnRuleGroup.RateBasedStatementProperty(
                    aggregate_key_type="aggregateKeyType",
                    limit=123,
                
                    # the properties below are optional
                    forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    ),
                    scope_down_statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__39e60064f8f4286866d2fa7f3c5494f2a2f33a4179f5370836b825ab35a02e19)
                check_type(argname="argument aggregate_key_type", value=aggregate_key_type, expected_type=type_hints["aggregate_key_type"])
                check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
                check_type(argname="argument scope_down_statement", value=scope_down_statement, expected_type=type_hints["scope_down_statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "aggregate_key_type": aggregate_key_type,
                "limit": limit,
            }
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config
            if scope_down_statement is not None:
                self._values["scope_down_statement"] = scope_down_statement

        @builtins.property
        def aggregate_key_type(self) -> builtins.str:
            '''Setting that indicates how to aggregate the request counts. The options are the following:.

            - ``IP`` - Aggregate the request counts on the IP address from the web request origin.
            - ``FORWARDED_IP`` - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the ``ForwardedIPConfig`` , to specify the header to use.

            .. epigraph::

               You can only use the ``IP`` and ``FORWARDED_IP`` key types.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-aggregatekeytype
            '''
            result = self._values.get("aggregate_key_type")
            assert result is not None, "Required property 'aggregate_key_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def limit(self) -> jsii.Number:
            '''The limit on requests per 5-minute period for a single originating IP address.

            If the statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-limit
            '''
            result = self._values.get("limit")
            assert result is not None, "Required property 'limit' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This is required if you specify a forwarded IP in the rule's aggregate key settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ForwardedIPConfigurationProperty"]], result)

        @builtins.property
        def scope_down_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]]:
            '''An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement.

            Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable statement in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-scopedownstatement
            '''
            result = self._values.get("scope_down_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateBasedStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "regex_string": "regexString",
            "text_transformations": "textTransformations",
        },
    )
    class RegexMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            regex_string: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement used to search web request components for a match against a single regular expression.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param regex_string: The string representing the regular expression.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_match_statement_property = wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    regex_string="regexString",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__19f93168f4e99e1fefe30605a0c36c70d5669dc501d923863dc01b02ed09edc1)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument regex_string", value=regex_string, expected_type=type_hints["regex_string"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "regex_string": regex_string,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def regex_string(self) -> builtins.str:
            '''The string representing the regular expression.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-regexstring
            '''
            result = self._values.get("regex_string")
            assert result is not None, "Required property 'regex_string' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
        },
    )
    class RegexPatternSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement used to search web request components for matches with regular expressions.

            To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

            Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_pattern_set_reference_statement_property = wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                    arn="arn",
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6910c2b882b693ee6a9ebfe30a376f3d75e7230122900daff24df6b399d3ba4e)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexPatternSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleActionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allow": "allow",
            "block": "block",
            "captcha": "captcha",
            "challenge": "challenge",
            "count": "count",
        },
    )
    class RuleActionProperty:
        def __init__(
            self,
            *,
            allow: typing.Any = None,
            block: typing.Any = None,
            captcha: typing.Any = None,
            challenge: typing.Any = None,
            count: typing.Any = None,
        ) -> None:
            '''The action that AWS WAF should take on a web request when it matches a rule's statement.

            Settings at the web ACL level can override the rule action setting.

            :param allow: Instructs AWS WAF to allow the web request.
            :param block: Instructs AWS WAF to block the web request.
            :param captcha: Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:. - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` . - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination. AWS WAF generates a response that it sends back to the client, which includes the following: - The header ``x-amzn-waf-action`` with a value of ``captcha`` . - The HTTP status code ``405 Method Not Allowed`` . - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge. You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting. This action option is available for rules. It isn't available for web ACL default actions.
            :param challenge: Instructs AWS WAF to run a ``Challenge`` check against the web request.
            :param count: Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # allow: Any
                # block: Any
                # captcha: Any
                # challenge: Any
                # count: Any
                
                rule_action_property = wafv2.CfnRuleGroup.RuleActionProperty(
                    allow=allow,
                    block=block,
                    captcha=captcha,
                    challenge=challenge,
                    count=count
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__39522e2876cae159806be752e9ce4c0e4fb8f4dd0ef92591b3957abd0202b035)
                check_type(argname="argument allow", value=allow, expected_type=type_hints["allow"])
                check_type(argname="argument block", value=block, expected_type=type_hints["block"])
                check_type(argname="argument captcha", value=captcha, expected_type=type_hints["captcha"])
                check_type(argname="argument challenge", value=challenge, expected_type=type_hints["challenge"])
                check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if allow is not None:
                self._values["allow"] = allow
            if block is not None:
                self._values["block"] = block
            if captcha is not None:
                self._values["captcha"] = captcha
            if challenge is not None:
                self._values["challenge"] = challenge
            if count is not None:
                self._values["count"] = count

        @builtins.property
        def allow(self) -> typing.Any:
            '''Instructs AWS WAF to allow the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-allow
            '''
            result = self._values.get("allow")
            return typing.cast(typing.Any, result)

        @builtins.property
        def block(self) -> typing.Any:
            '''Instructs AWS WAF to block the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-block
            '''
            result = self._values.get("block")
            return typing.cast(typing.Any, result)

        @builtins.property
        def captcha(self) -> typing.Any:
            '''Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:.

            - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .
            - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF generates a response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``captcha`` .
            - The HTTP status code ``405 Method Not Allowed`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge.

            You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-captcha
            '''
            result = self._values.get("captcha")
            return typing.cast(typing.Any, result)

        @builtins.property
        def challenge(self) -> typing.Any:
            '''Instructs AWS WAF to run a ``Challenge`` check against the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-challenge
            '''
            result = self._values.get("challenge")
            return typing.cast(typing.Any, result)

        @builtins.property
        def count(self) -> typing.Any:
            '''Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-count
            '''
            result = self._values.get("count")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "priority": "priority",
            "statement": "statement",
            "visibility_config": "visibilityConfig",
            "action": "action",
            "captcha_config": "captchaConfig",
            "challenge_config": "challengeConfig",
            "rule_labels": "ruleLabels",
        },
    )
    class RuleProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            priority: jsii.Number,
            statement: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]]],
            visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            action: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RuleActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            captcha_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.CaptchaConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            challenge_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ChallengeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rule_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A single rule, which you can use in a ``WebACL`` or ``RuleGroup`` to identify web requests that you want to allow, block, or count.

            Each rule includes one top-level ``Statement`` that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

            :param name: The name of the rule. You can't change the name of a ``Rule`` after you create it.
            :param priority: If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
            :param statement: The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .
            :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
            :param action: The action that AWS WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
            :param captcha_config: Specifies how AWS WAF should handle ``CAPTCHA`` evaluations. If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.
            :param challenge_config: Specifies how AWS WAF should handle ``Challenge`` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
            :param rule_labels: Labels to apply to web requests that match the rule match statement. AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace. Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` . For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines: - Separate each component of the label with a colon. - Each namespace or name can have up to 128 characters. - You can specify up to 5 namespaces in a label. - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` . For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # allow: Any
                # all_query_arguments: Any
                # block: Any
                # captcha: Any
                # challenge: Any
                # count: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                rule_property = wafv2.CfnRuleGroup.RuleProperty(
                    name="name",
                    priority=123,
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    ),
                    visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                        cloud_watch_metrics_enabled=False,
                        metric_name="metricName",
                        sampled_requests_enabled=False
                    ),
                
                    # the properties below are optional
                    action=wafv2.CfnRuleGroup.RuleActionProperty(
                        allow=allow,
                        block=block,
                        captcha=captcha,
                        challenge=challenge,
                        count=count
                    ),
                    captcha_config=wafv2.CfnRuleGroup.CaptchaConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    challenge_config=wafv2.CfnRuleGroup.ChallengeConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    rule_labels=[wafv2.CfnRuleGroup.LabelProperty(
                        name="name"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__015056668c1a8717f25fff39a27fc12627cce51740c1528d560a3e6eb644647e)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
                check_type(argname="argument visibility_config", value=visibility_config, expected_type=type_hints["visibility_config"])
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
                check_type(argname="argument captcha_config", value=captcha_config, expected_type=type_hints["captcha_config"])
                check_type(argname="argument challenge_config", value=challenge_config, expected_type=type_hints["challenge_config"])
                check_type(argname="argument rule_labels", value=rule_labels, expected_type=type_hints["rule_labels"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "priority": priority,
                "statement": statement,
                "visibility_config": visibility_config,
            }
            if action is not None:
                self._values["action"] = action
            if captcha_config is not None:
                self._values["captcha_config"] = captcha_config
            if challenge_config is not None:
                self._values["challenge_config"] = challenge_config
            if rule_labels is not None:
                self._values["rule_labels"] = rule_labels

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule.

            You can't change the name of a ``Rule`` after you create it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def priority(self) -> jsii.Number:
            '''If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` .

            AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-priority
            '''
            result = self._values.get("priority")
            assert result is not None, "Required property 'priority' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def statement(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"]:
            '''The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.StatementProperty"], result)

        @builtins.property
        def visibility_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"]:
            '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-visibilityconfig
            '''
            result = self._values.get("visibility_config")
            assert result is not None, "Required property 'visibility_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.VisibilityConfigProperty"], result)

        @builtins.property
        def action(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleActionProperty"]]:
            '''The action that AWS WAF should take on a web request when it matches the rule statement.

            Settings at the web ACL level can override the rule action setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-action
            '''
            result = self._values.get("action")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RuleActionProperty"]], result)

        @builtins.property
        def captcha_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CaptchaConfigProperty"]]:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations.

            If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-captchaconfig
            '''
            result = self._values.get("captcha_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.CaptchaConfigProperty"]], result)

        @builtins.property
        def challenge_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ChallengeConfigProperty"]]:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-challengeconfig
            '''
            result = self._values.get("challenge_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ChallengeConfigProperty"]], result)

        @builtins.property
        def rule_labels(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelProperty"]]]]:
            '''Labels to apply to web requests that match the rule match statement.

            AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.

            Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` .

            For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:

            - Separate each component of the label with a colon.
            - Each namespace or name can have up to 128 characters.
            - You can specify up to 5 namespaces in a label.
            - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` .

            For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-rulelabels
            '''
            result = self._values.get("rule_labels")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SingleHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleHeaderProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one of the headers in the web request, identified by name, for example, ``User-Agent`` or ``Referer`` .

            The name isn't case sensitive.

            You can filter and inspect all headers with the ``FieldToMatch`` setting ``Headers`` .

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :param name: The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singleheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_header_property = wafv2.CfnRuleGroup.SingleHeaderProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5cf567bf196203e16e1454b52367471780e0889d630c732027d4071cd2ab8640)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singleheader.html#cfn-wafv2-rulegroup-singleheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SingleQueryArgumentProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleQueryArgumentProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one query argument in the web request, identified by name, for example *UserName* or *SalesRegion* .

            The name isn't case sensitive.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :param name: The name of the query argument to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singlequeryargument.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_query_argument_property = wafv2.CfnRuleGroup.SingleQueryArgumentProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5f1ca125c090766441fe7b0776cf806a069b05f4a71f38f8657e8d10c4988ede)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query argument to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singlequeryargument.html#cfn-wafv2-rulegroup-singlequeryargument-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleQueryArgumentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SizeConstraintStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "comparison_operator": "comparisonOperator",
            "field_to_match": "fieldToMatch",
            "size": "size",
            "text_transformations": "textTransformations",
        },
    )
    class SizeConstraintStatementProperty:
        def __init__(
            self,
            *,
            comparison_operator: builtins.str,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            size: jsii.Number,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).

            For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

            If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes of the body up to the limit for the web ACL. By default, for regional web ACLs, this limit is 8 KB (8,192 kilobytes) and for CloudFront web ACLs, this limit is 16 KB (16,384 kilobytes). For CloudFront web ACLs, you can increase the limit in the web ACL ``AssociationConfig`` , for additional fees. If you know that the request body for your web requests should never exceed the inspection limit, you could use a size constraint statement to block requests that have a larger request body size.

            If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.

            :param comparison_operator: The operator to use to compare the request part to the size setting.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param size: The size, in byte, to compare to the request part, after any transformations.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                size_constraint_statement_property = wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                    comparison_operator="comparisonOperator",
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    size=123,
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b4e71477ea891ae9537f70f2a7ad51756ce844f8e608371a6a7e0b43d47bcf37)
                check_type(argname="argument comparison_operator", value=comparison_operator, expected_type=type_hints["comparison_operator"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument size", value=size, expected_type=type_hints["size"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "comparison_operator": comparison_operator,
                "field_to_match": field_to_match,
                "size": size,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def comparison_operator(self) -> builtins.str:
            '''The operator to use to compare the request part to the size setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-comparisonoperator
            '''
            result = self._values.get("comparison_operator")
            assert result is not None, "Required property 'comparison_operator' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def size(self) -> jsii.Number:
            '''The size, in byte, to compare to the request part, after any transformations.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-size
            '''
            result = self._values.get("size")
            assert result is not None, "Required property 'size' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SizeConstraintStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SqliMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
            "sensitivity_level": "sensitivityLevel",
        },
    )
    class SqliMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            sensitivity_level: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that inspects for malicious SQL code.

            Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param sensitivity_level: The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. ``HIGH`` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see `Testing and tuning <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html>`_ in the *AWS WAF Developer Guide* . ``LOW`` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives. Default: ``LOW``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                sqli_match_statement_property = wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    sensitivity_level="sensitivityLevel"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b9ae549bd77f9cf10d97954d1e78a797db181843dcc5510b91fc32672eee8542)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument sensitivity_level", value=sensitivity_level, expected_type=type_hints["sensitivity_level"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }
            if sensitivity_level is not None:
                self._values["sensitivity_level"] = sensitivity_level

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        @builtins.property
        def sensitivity_level(self) -> typing.Optional[builtins.str]:
            '''The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks.

            ``HIGH`` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see `Testing and tuning <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html>`_ in the *AWS WAF Developer Guide* .

            ``LOW`` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.

            Default: ``LOW``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-sensitivitylevel
            '''
            result = self._values.get("sensitivity_level")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SqliMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.StatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "and_statement": "andStatement",
            "byte_match_statement": "byteMatchStatement",
            "geo_match_statement": "geoMatchStatement",
            "ip_set_reference_statement": "ipSetReferenceStatement",
            "label_match_statement": "labelMatchStatement",
            "not_statement": "notStatement",
            "or_statement": "orStatement",
            "rate_based_statement": "rateBasedStatement",
            "regex_match_statement": "regexMatchStatement",
            "regex_pattern_set_reference_statement": "regexPatternSetReferenceStatement",
            "size_constraint_statement": "sizeConstraintStatement",
            "sqli_match_statement": "sqliMatchStatement",
            "xss_match_statement": "xssMatchStatement",
        },
    )
    class StatementProperty:
        def __init__(
            self,
            *,
            and_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.AndStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            byte_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.ByteMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            geo_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.GeoMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            ip_set_reference_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.IPSetReferenceStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            label_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.LabelMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            not_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.NotStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            or_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.OrStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rate_based_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RateBasedStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            regex_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RegexMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            regex_pattern_set_reference_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.RegexPatternSetReferenceStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            size_constraint_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.SizeConstraintStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            sqli_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.SqliMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            xss_match_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.XssMatchStatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The processing guidance for a rule, used by AWS WAF to determine whether a web request matches the rule.

            :param and_statement: A logical rule statement used to combine other rule statements with AND logic. You provide more than one ``Statement`` within the ``AndStatement`` .
            :param byte_match_statement: A rule statement that defines a string match search for AWS WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
            :param geo_match_statement: A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match. - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array. - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed. AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` . If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` . If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` . For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
            :param ip_set_reference_statement: A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement. Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
            :param label_match_statement: A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL. The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
            :param not_statement: A logical rule statement used to negate the results of another rule statement. You provide one ``Statement`` within the ``NotStatement`` .
            :param or_statement: A logical rule statement used to combine other rule statements with OR logic. You provide more than one ``Statement`` within the ``OrStatement`` .
            :param rate_based_statement: A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this to put a temporary block on requests from an IP address that is sending excessive requests. AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF . When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit. You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements: - An IP match statement with an IP set that specifies the address 192.0.2.44. - A string match statement that searches in the User-Agent header for the string BadBot. In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule. You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.
            :param regex_match_statement: A rule statement used to search web request components for a match against a single regular expression.
            :param regex_pattern_set_reference_statement: A rule statement used to search web request components for matches with regular expressions. To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
            :param size_constraint_statement: A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes. If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes of the body up to the limit for the web ACL. By default, for regional web ACLs, this limit is 8 KB (8,192 kilobytes) and for CloudFront web ACLs, this limit is 16 KB (16,384 kilobytes). For CloudFront web ACLs, you can increase the limit in the web ACL ``AssociationConfig`` , for additional fees. If you know that the request body for your web requests should never exceed the inspection limit, you could use a size constraint statement to block requests that have a larger request body size. If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.
            :param sqli_match_statement: A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
            :param xss_match_statement: A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c10bc3e3f69d89ad06f25a44daee62e7de586ae4280e39230f29c24092fe4a4f)
                check_type(argname="argument and_statement", value=and_statement, expected_type=type_hints["and_statement"])
                check_type(argname="argument byte_match_statement", value=byte_match_statement, expected_type=type_hints["byte_match_statement"])
                check_type(argname="argument geo_match_statement", value=geo_match_statement, expected_type=type_hints["geo_match_statement"])
                check_type(argname="argument ip_set_reference_statement", value=ip_set_reference_statement, expected_type=type_hints["ip_set_reference_statement"])
                check_type(argname="argument label_match_statement", value=label_match_statement, expected_type=type_hints["label_match_statement"])
                check_type(argname="argument not_statement", value=not_statement, expected_type=type_hints["not_statement"])
                check_type(argname="argument or_statement", value=or_statement, expected_type=type_hints["or_statement"])
                check_type(argname="argument rate_based_statement", value=rate_based_statement, expected_type=type_hints["rate_based_statement"])
                check_type(argname="argument regex_match_statement", value=regex_match_statement, expected_type=type_hints["regex_match_statement"])
                check_type(argname="argument regex_pattern_set_reference_statement", value=regex_pattern_set_reference_statement, expected_type=type_hints["regex_pattern_set_reference_statement"])
                check_type(argname="argument size_constraint_statement", value=size_constraint_statement, expected_type=type_hints["size_constraint_statement"])
                check_type(argname="argument sqli_match_statement", value=sqli_match_statement, expected_type=type_hints["sqli_match_statement"])
                check_type(argname="argument xss_match_statement", value=xss_match_statement, expected_type=type_hints["xss_match_statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if and_statement is not None:
                self._values["and_statement"] = and_statement
            if byte_match_statement is not None:
                self._values["byte_match_statement"] = byte_match_statement
            if geo_match_statement is not None:
                self._values["geo_match_statement"] = geo_match_statement
            if ip_set_reference_statement is not None:
                self._values["ip_set_reference_statement"] = ip_set_reference_statement
            if label_match_statement is not None:
                self._values["label_match_statement"] = label_match_statement
            if not_statement is not None:
                self._values["not_statement"] = not_statement
            if or_statement is not None:
                self._values["or_statement"] = or_statement
            if rate_based_statement is not None:
                self._values["rate_based_statement"] = rate_based_statement
            if regex_match_statement is not None:
                self._values["regex_match_statement"] = regex_match_statement
            if regex_pattern_set_reference_statement is not None:
                self._values["regex_pattern_set_reference_statement"] = regex_pattern_set_reference_statement
            if size_constraint_statement is not None:
                self._values["size_constraint_statement"] = size_constraint_statement
            if sqli_match_statement is not None:
                self._values["sqli_match_statement"] = sqli_match_statement
            if xss_match_statement is not None:
                self._values["xss_match_statement"] = xss_match_statement

        @builtins.property
        def and_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.AndStatementProperty"]]:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-andstatement
            '''
            result = self._values.get("and_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.AndStatementProperty"]], result)

        @builtins.property
        def byte_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ByteMatchStatementProperty"]]:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-bytematchstatement
            '''
            result = self._values.get("byte_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.ByteMatchStatementProperty"]], result)

        @builtins.property
        def geo_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.GeoMatchStatementProperty"]]:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-geomatchstatement
            '''
            result = self._values.get("geo_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.GeoMatchStatementProperty"]], result)

        @builtins.property
        def ip_set_reference_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetReferenceStatementProperty"]]:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-ipsetreferencestatement
            '''
            result = self._values.get("ip_set_reference_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.IPSetReferenceStatementProperty"]], result)

        @builtins.property
        def label_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelMatchStatementProperty"]]:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-labelmatchstatement
            '''
            result = self._values.get("label_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.LabelMatchStatementProperty"]], result)

        @builtins.property
        def not_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.NotStatementProperty"]]:
            '''A logical rule statement used to negate the results of another rule statement.

            You provide one ``Statement`` within the ``NotStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-notstatement
            '''
            result = self._values.get("not_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.NotStatementProperty"]], result)

        @builtins.property
        def or_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.OrStatementProperty"]]:
            '''A logical rule statement used to combine other rule statements with OR logic.

            You provide more than one ``Statement`` within the ``OrStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-orstatement
            '''
            result = self._values.get("or_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.OrStatementProperty"]], result)

        @builtins.property
        def rate_based_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateBasedStatementProperty"]]:
            '''A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.

            You can use this to put a temporary block on requests from an IP address that is sending excessive requests.

            AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .

            When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.

            You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:

            - An IP match statement with an IP set that specifies the address 192.0.2.44.
            - A string match statement that searches in the User-Agent header for the string BadBot.

            In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.

            You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-ratebasedstatement
            '''
            result = self._values.get("rate_based_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RateBasedStatementProperty"]], result)

        @builtins.property
        def regex_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexMatchStatementProperty"]]:
            '''A rule statement used to search web request components for a match against a single regular expression.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-regexmatchstatement
            '''
            result = self._values.get("regex_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexMatchStatementProperty"]], result)

        @builtins.property
        def regex_pattern_set_reference_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexPatternSetReferenceStatementProperty"]]:
            '''A rule statement used to search web request components for matches with regular expressions.

            To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

            Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-regexpatternsetreferencestatement
            '''
            result = self._values.get("regex_pattern_set_reference_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.RegexPatternSetReferenceStatementProperty"]], result)

        @builtins.property
        def size_constraint_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SizeConstraintStatementProperty"]]:
            '''A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).

            For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

            If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes of the body up to the limit for the web ACL. By default, for regional web ACLs, this limit is 8 KB (8,192 kilobytes) and for CloudFront web ACLs, this limit is 16 KB (16,384 kilobytes). For CloudFront web ACLs, you can increase the limit in the web ACL ``AssociationConfig`` , for additional fees. If you know that the request body for your web requests should never exceed the inspection limit, you could use a size constraint statement to block requests that have a larger request body size.

            If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-sizeconstraintstatement
            '''
            result = self._values.get("size_constraint_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SizeConstraintStatementProperty"]], result)

        @builtins.property
        def sqli_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SqliMatchStatementProperty"]]:
            '''A rule statement that inspects for malicious SQL code.

            Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-sqlimatchstatement
            '''
            result = self._values.get("sqli_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.SqliMatchStatementProperty"]], result)

        @builtins.property
        def xss_match_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.XssMatchStatementProperty"]]:
            '''A rule statement that inspects for cross-site scripting (XSS) attacks.

            In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-xssmatchstatement
            '''
            result = self._values.get("xss_match_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.XssMatchStatementProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.TextTransformationProperty",
        jsii_struct_bases=[],
        name_mapping={"priority": "priority", "type": "type"},
    )
    class TextTransformationProperty:
        def __init__(self, *, priority: jsii.Number, type: builtins.str) -> None:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            :param priority: Sets the relative processing order for multiple transformations. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
            :param type: You can specify the following transformation types:. *BASE64_DECODE* - Decode a ``Base64`` -encoded string. *BASE64_DECODE_EXT* - Decode a ``Base64`` -encoded string, but use a forgiving implementation that ignores characters that aren't valid. *CMD_LINE* - Command-line transformations. These are helpful in reducing effectiveness of attackers who inject an operating system command-line command and use unusual formatting to disguise some or all of the command. - Delete the following characters: ``\\ " ' ^`` - Delete spaces before the following characters: ``/ (`` - Replace the following characters with a space: ``, ;`` - Replace multiple spaces with one space - Convert uppercase letters (A-Z) to lowercase (a-z) *COMPRESS_WHITE_SPACE* - Replace these characters with a space character (decimal 32): - ``\\f`` , formfeed, decimal 12 - ``\\t`` , tab, decimal 9 - ``\\n`` , newline, decimal 10 - ``\\r`` , carriage return, decimal 13 - ``\\v`` , vertical tab, decimal 11 - Non-breaking space, decimal 160 ``COMPRESS_WHITE_SPACE`` also replaces multiple spaces with one space. *CSS_DECODE* - Decode characters that were encoded using CSS 2.x escape rules ``syndata.html#characters`` . This function uses up to two bytes in the decoding process, so it can help to uncover ASCII characters that were encoded using CSS encoding that wouldn’t typically be encoded. It's also useful in countering evasion, which is a combination of a backslash and non-hexadecimal characters. For example, ``ja\\vascript`` for javascript. *ESCAPE_SEQ_DECODE* - Decode the following ANSI C escape sequences: ``\\a`` , ``\\b`` , ``\\f`` , ``\\n`` , ``\\r`` , ``\\t`` , ``\\v`` , ``\\\\`` , ``\\?`` , ``\\'`` , ``\\"`` , ``\\xHH`` (hexadecimal), ``\\0OOO`` (octal). Encodings that aren't valid remain in the output. *HEX_DECODE* - Decode a string of hexadecimal characters into a binary. *HTML_ENTITY_DECODE* - Replace HTML-encoded characters with unencoded characters. ``HTML_ENTITY_DECODE`` performs these operations: - Replaces ``(ampersand)quot;`` with ``"`` - Replaces ``(ampersand)nbsp;`` with a non-breaking space, decimal 160 - Replaces ``(ampersand)lt;`` with a "less than" symbol - Replaces ``(ampersand)gt;`` with ``>`` - Replaces characters that are represented in hexadecimal format, ``(ampersand)#xhhhh;`` , with the corresponding characters - Replaces characters that are represented in decimal format, ``(ampersand)#nnnn;`` , with the corresponding characters *JS_DECODE* - Decode JavaScript escape sequences. If a ``\\`` ``u`` ``HHHH`` code is in the full-width ASCII code range of ``FF01-FF5E`` , then the higher byte is used to detect and adjust the lower byte. If not, only the lower byte is used and the higher byte is zeroed, causing a possible loss of information. *LOWERCASE* - Convert uppercase letters (A-Z) to lowercase (a-z). *MD5* - Calculate an MD5 hash from the data in the input. The computed hash is in a raw binary form. *NONE* - Specify ``NONE`` if you don't want any text transformations. *NORMALIZE_PATH* - Remove multiple slashes, directory self-references, and directory back-references that are not at the beginning of the input from an input string. *NORMALIZE_PATH_WIN* - This is the same as ``NORMALIZE_PATH`` , but first converts backslash characters to forward slashes. *REMOVE_NULLS* - Remove all ``NULL`` bytes from the input. *REPLACE_COMMENTS* - Replace each occurrence of a C-style comment ( ``/* ... * /`` ) with a single space. Multiple consecutive occurrences are not compressed. Unterminated comments are also replaced with a space (ASCII 0x20). However, a standalone termination of a comment ( ``* /`` ) is not acted upon. *REPLACE_NULLS* - Replace NULL bytes in the input with space characters (ASCII ``0x20`` ). *SQL_HEX_DECODE* - Decode SQL hex data. Example ( ``0x414243`` ) will be decoded to ( ``ABC`` ). *URL_DECODE* - Decode a URL-encoded value. *URL_DECODE_UNI* - Like ``URL_DECODE`` , but with support for Microsoft-specific ``%u`` encoding. If the code is in the full-width ASCII code range of ``FF01-FF5E`` , the higher byte is used to detect and adjust the lower byte. Otherwise, only the lower byte is used and the higher byte is zeroed. *UTF8_TO_UNICODE* - Convert all UTF-8 character sequences to Unicode. This helps input normalization, and minimizing false-positives and false-negatives for non-English languages.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                text_transformation_property = wafv2.CfnRuleGroup.TextTransformationProperty(
                    priority=123,
                    type="type"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cbdf04ef9e923368f792f61fdb73e804a219fcd9c66ffb20e85214a5a0861eae)
                check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "priority": priority,
                "type": type,
            }

        @builtins.property
        def priority(self) -> jsii.Number:
            '''Sets the relative processing order for multiple transformations.

            AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-priority
            '''
            result = self._values.get("priority")
            assert result is not None, "Required property 'priority' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def type(self) -> builtins.str:
            '''You can specify the following transformation types:.

            *BASE64_DECODE* - Decode a ``Base64`` -encoded string.

            *BASE64_DECODE_EXT* - Decode a ``Base64`` -encoded string, but use a forgiving implementation that ignores characters that aren't valid.

            *CMD_LINE* - Command-line transformations. These are helpful in reducing effectiveness of attackers who inject an operating system command-line command and use unusual formatting to disguise some or all of the command.

            - Delete the following characters: ``\\ " ' ^``
            - Delete spaces before the following characters: ``/ (``
            - Replace the following characters with a space: ``, ;``
            - Replace multiple spaces with one space
            - Convert uppercase letters (A-Z) to lowercase (a-z)

            *COMPRESS_WHITE_SPACE* - Replace these characters with a space character (decimal 32):

            - ``\\f`` , formfeed, decimal 12
            - ``\\t`` , tab, decimal 9
            - ``\\n`` , newline, decimal 10
            - ``\\r`` , carriage return, decimal 13
            - ``\\v`` , vertical tab, decimal 11
            - Non-breaking space, decimal 160

            ``COMPRESS_WHITE_SPACE`` also replaces multiple spaces with one space.

            *CSS_DECODE* - Decode characters that were encoded using CSS 2.x escape rules ``syndata.html#characters`` . This function uses up to two bytes in the decoding process, so it can help to uncover ASCII characters that were encoded using CSS encoding that wouldn’t typically be encoded. It's also useful in countering evasion, which is a combination of a backslash and non-hexadecimal characters. For example, ``ja\\vascript`` for javascript.

            *ESCAPE_SEQ_DECODE* - Decode the following ANSI C escape sequences: ``\\a`` , ``\\b`` , ``\\f`` , ``\\n`` , ``\\r`` , ``\\t`` , ``\\v`` , ``\\\\`` , ``\\?`` , ``\\'`` , ``\\"`` , ``\\xHH`` (hexadecimal), ``\\0OOO`` (octal). Encodings that aren't valid remain in the output.

            *HEX_DECODE* - Decode a string of hexadecimal characters into a binary.

            *HTML_ENTITY_DECODE* - Replace HTML-encoded characters with unencoded characters. ``HTML_ENTITY_DECODE`` performs these operations:

            - Replaces ``(ampersand)quot;`` with ``"``
            - Replaces ``(ampersand)nbsp;`` with a non-breaking space, decimal 160
            - Replaces ``(ampersand)lt;`` with a "less than" symbol
            - Replaces ``(ampersand)gt;`` with ``>``
            - Replaces characters that are represented in hexadecimal format, ``(ampersand)#xhhhh;`` , with the corresponding characters
            - Replaces characters that are represented in decimal format, ``(ampersand)#nnnn;`` , with the corresponding characters

            *JS_DECODE* - Decode JavaScript escape sequences. If a ``\\`` ``u`` ``HHHH`` code is in the full-width ASCII code range of ``FF01-FF5E`` , then the higher byte is used to detect and adjust the lower byte. If not, only the lower byte is used and the higher byte is zeroed, causing a possible loss of information.

            *LOWERCASE* - Convert uppercase letters (A-Z) to lowercase (a-z).

            *MD5* - Calculate an MD5 hash from the data in the input. The computed hash is in a raw binary form.

            *NONE* - Specify ``NONE`` if you don't want any text transformations.

            *NORMALIZE_PATH* - Remove multiple slashes, directory self-references, and directory back-references that are not at the beginning of the input from an input string.

            *NORMALIZE_PATH_WIN* - This is the same as ``NORMALIZE_PATH`` , but first converts backslash characters to forward slashes.

            *REMOVE_NULLS* - Remove all ``NULL`` bytes from the input.

            *REPLACE_COMMENTS* - Replace each occurrence of a C-style comment ( ``/* ... * /`` ) with a single space. Multiple consecutive occurrences are not compressed. Unterminated comments are also replaced with a space (ASCII 0x20). However, a standalone termination of a comment ( ``* /`` ) is not acted upon.

            *REPLACE_NULLS* - Replace NULL bytes in the input with space characters (ASCII ``0x20`` ).

            *SQL_HEX_DECODE* - Decode SQL hex data. Example ( ``0x414243`` ) will be decoded to ( ``ABC`` ).

            *URL_DECODE* - Decode a URL-encoded value.

            *URL_DECODE_UNI* - Like ``URL_DECODE`` , but with support for Microsoft-specific ``%u`` encoding. If the code is in the full-width ASCII code range of ``FF01-FF5E`` , the higher byte is used to detect and adjust the lower byte. Otherwise, only the lower byte is used and the higher byte is zeroed.

            *UTF8_TO_UNICODE* - Convert all UTF-8 character sequences to Unicode. This helps input normalization, and minimizing false-positives and false-negatives for non-English languages.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TextTransformationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.VisibilityConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cloud_watch_metrics_enabled": "cloudWatchMetricsEnabled",
            "metric_name": "metricName",
            "sampled_requests_enabled": "sampledRequestsEnabled",
        },
    )
    class VisibilityConfigProperty:
        def __init__(
            self,
            *,
            cloud_watch_metrics_enabled: typing.Union[builtins.bool, _IResolvable_da3f097b],
            metric_name: builtins.str,
            sampled_requests_enabled: typing.Union[builtins.bool, _IResolvable_da3f097b],
        ) -> None:
            '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

            :param cloud_watch_metrics_enabled: Indicates whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see `AWS WAF Metrics <https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics>`_ in the *AWS WAF Developer Guide* . For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information, see `The web ACL default action <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html>`_ in the *AWS WAF Developer Guide* .
            :param metric_name: A name of the Amazon CloudWatch metric dimension. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example ``All`` and ``Default_Action`` .
            :param sampled_requests_enabled: Indicates whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                visibility_config_property = wafv2.CfnRuleGroup.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ffc3de9fa9cd77d11c4487ad80fc48948664b917c8642b35ca709762ce71fddf)
                check_type(argname="argument cloud_watch_metrics_enabled", value=cloud_watch_metrics_enabled, expected_type=type_hints["cloud_watch_metrics_enabled"])
                check_type(argname="argument metric_name", value=metric_name, expected_type=type_hints["metric_name"])
                check_type(argname="argument sampled_requests_enabled", value=sampled_requests_enabled, expected_type=type_hints["sampled_requests_enabled"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cloud_watch_metrics_enabled": cloud_watch_metrics_enabled,
                "metric_name": metric_name,
                "sampled_requests_enabled": sampled_requests_enabled,
            }

        @builtins.property
        def cloud_watch_metrics_enabled(
            self,
        ) -> typing.Union[builtins.bool, _IResolvable_da3f097b]:
            '''Indicates whether the associated resource sends metrics to Amazon CloudWatch.

            For the list of available metrics, see `AWS WAF Metrics <https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics>`_ in the *AWS WAF Developer Guide* .

            For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information,
            see `The web ACL default action <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-cloudwatchmetricsenabled
            '''
            result = self._values.get("cloud_watch_metrics_enabled")
            assert result is not None, "Required property 'cloud_watch_metrics_enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _IResolvable_da3f097b], result)

        @builtins.property
        def metric_name(self) -> builtins.str:
            '''A name of the Amazon CloudWatch metric dimension.

            The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example ``All`` and ``Default_Action`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-metricname
            '''
            result = self._values.get("metric_name")
            assert result is not None, "Required property 'metric_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def sampled_requests_enabled(
            self,
        ) -> typing.Union[builtins.bool, _IResolvable_da3f097b]:
            '''Indicates whether AWS WAF should store a sampling of the web requests that match the rules.

            You can view the sampled requests through the AWS WAF console.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-sampledrequestsenabled
            '''
            result = self._values.get("sampled_requests_enabled")
            assert result is not None, "Required property 'sampled_requests_enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _IResolvable_da3f097b], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VisibilityConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroup.XssMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
        },
    )
    class XssMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement that inspects for cross-site scripting (XSS) attacks.

            In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                xss_match_statement_property = wafv2.CfnRuleGroup.XssMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e502ec1c8bc4096eb797b55f6c0a1f9c506e23db360770a855cc273d36ce4b4a)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.FieldToMatchProperty"], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnRuleGroup.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "XssMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="aws-cdk-lib.aws_wafv2.CfnRuleGroupProps",
    jsii_struct_bases=[],
    name_mapping={
        "capacity": "capacity",
        "scope": "scope",
        "visibility_config": "visibilityConfig",
        "available_labels": "availableLabels",
        "consumed_labels": "consumedLabels",
        "custom_response_bodies": "customResponseBodies",
        "description": "description",
        "name": "name",
        "rules": "rules",
        "tags": "tags",
    },
)
class CfnRuleGroupProps:
    def __init__(
        self,
        *,
        capacity: jsii.Number,
        scope: builtins.str,
        visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.VisibilityConfigProperty, typing.Dict[builtins.str, typing.Any]]],
        available_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.LabelSummaryProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        consumed_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.LabelSummaryProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.CustomResponseBodyProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union[CfnRuleGroup.RuleProperty, typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnRuleGroup``.

        :param capacity: The web ACL capacity units (WCUs) required for this rule group. When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit. AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param available_labels: The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the ``RuleLabels`` for a ``Rule`` .
        :param consumed_labels: The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
        :param description: A description of the rule group that helps with identification.
        :param name: The name of the rule group. You cannot change the name of a rule group after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from aws_cdk import aws_wafv2 as wafv2
            
            # all: Any
            # allow: Any
            # all_query_arguments: Any
            # block: Any
            # captcha: Any
            # challenge: Any
            # count: Any
            # method: Any
            # query_string: Any
            # single_header: Any
            # single_query_argument: Any
            # statement_property_: wafv2.CfnRuleGroup.StatementProperty
            # uri_path: Any
            
            cfn_rule_group_props = wafv2.CfnRuleGroupProps(
                capacity=123,
                scope="scope",
                visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                ),
            
                # the properties below are optional
                available_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                    name="name"
                )],
                consumed_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                    name="name"
                )],
                custom_response_bodies={
                    "custom_response_bodies_key": wafv2.CfnRuleGroup.CustomResponseBodyProperty(
                        content="content",
                        content_type="contentType"
                    )
                },
                description="description",
                name="name",
                rules=[wafv2.CfnRuleGroup.RuleProperty(
                    name="name",
                    priority=123,
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
            
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
            
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
            
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
            
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    ),
                    visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                        cloud_watch_metrics_enabled=False,
                        metric_name="metricName",
                        sampled_requests_enabled=False
                    ),
            
                    # the properties below are optional
                    action=wafv2.CfnRuleGroup.RuleActionProperty(
                        allow=allow,
                        block=block,
                        captcha=captcha,
                        challenge=challenge,
                        count=count
                    ),
                    captcha_config=wafv2.CfnRuleGroup.CaptchaConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    challenge_config=wafv2.CfnRuleGroup.ChallengeConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    rule_labels=[wafv2.CfnRuleGroup.LabelProperty(
                        name="name"
                    )]
                )],
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8dfa44d9c30297c12ad00bd34bbd4b85ea5438f4127e7e97226c16565c6ef5b)
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument visibility_config", value=visibility_config, expected_type=type_hints["visibility_config"])
            check_type(argname="argument available_labels", value=available_labels, expected_type=type_hints["available_labels"])
            check_type(argname="argument consumed_labels", value=consumed_labels, expected_type=type_hints["consumed_labels"])
            check_type(argname="argument custom_response_bodies", value=custom_response_bodies, expected_type=type_hints["custom_response_bodies"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "capacity": capacity,
            "scope": scope,
            "visibility_config": visibility_config,
        }
        if available_labels is not None:
            self._values["available_labels"] = available_labels
        if consumed_labels is not None:
            self._values["consumed_labels"] = consumed_labels
        if custom_response_bodies is not None:
            self._values["custom_response_bodies"] = custom_response_bodies
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if rules is not None:
            self._values["rules"] = rules
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) required for this rule group.

        When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity
        '''
        result = self._values.get("capacity")
        assert result is not None, "Required property 'capacity' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def visibility_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, CfnRuleGroup.VisibilityConfigProperty]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig
        '''
        result = self._values.get("visibility_config")
        assert result is not None, "Required property 'visibility_config' is missing"
        return typing.cast(typing.Union[_IResolvable_da3f097b, CfnRuleGroup.VisibilityConfigProperty], result)

    @builtins.property
    def available_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]]:
        '''The labels that one or more rules in this rule group add to matching web requests.

        These labels are defined in the ``RuleLabels`` for a ``Rule`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-availablelabels
        '''
        result = self._values.get("available_labels")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]], result)

    @builtins.property
    def consumed_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]]:
        '''The labels that one or more rules in this rule group match against in label match statements.

        These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-consumedlabels
        '''
        result = self._values.get("consumed_labels")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.LabelSummaryProperty]]]], result)

    @builtins.property
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, CfnRuleGroup.CustomResponseBodyProperty]]]]:
        '''A map of custom response keys and content bodies.

        When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.

        For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

        For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-customresponsebodies
        '''
        result = self._values.get("custom_response_bodies")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, CfnRuleGroup.CustomResponseBodyProperty]]]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the rule group that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the rule group.

        You cannot change the name of a rule group after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.RuleProperty]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.

        Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, CfnRuleGroup.RuleProperty]]]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_f6864754]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_f6864754]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRuleGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_c2943556)
class CfnWebACL(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL",
):
    '''A CloudFormation ``AWS::WAFv2::WebACL``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``WebACL`` to define a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you specify a default action to take (allow, block) for any request that doesn't match any of the rules. The rules in a web ACL can contain rule statements that you define explicitly and rule statements that reference rule groups and managed rule groups. You can associate a web ACL with one or more AWS resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer , an AWS AppSync GraphQL API , an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance.

    :cloudformationResource: AWS::WAFv2::WebACL
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html
    :exampleMetadata: fixture=_generated

    Example::

        
    '''

    def __init__(
        self,
        scope_: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        default_action: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.DefaultActionProperty", typing.Dict[builtins.str, typing.Any]]],
        scope: builtins.str,
        visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]]],
        association_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AssociationConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        captcha_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CaptchaConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        challenge_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ChallengeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomResponseBodyProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RuleProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_f6864754, typing.Dict[builtins.str, typing.Any]]]] = None,
        token_domains: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::WebACL``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param default_action: The action to perform if none of the ``Rules`` contained in the ``WebACL`` match.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` . For information about how to define the association of the web ACL with your resource, see ``WebACLAssociation`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param association_config: Specifies custom configurations for the associations between the web ACL and protected resources. Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to AWS WAF for inspection. The default is 16 KB (16,384 kilobytes). .. epigraph:: You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .
        :param captcha_config: Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings. If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .
        :param challenge_config: Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own ``ChallengeConfig`` settings. If you don't specify this, AWS WAF uses its default settings for ``ChallengeConfig`` .
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
        :param description: A description of the web ACL that helps with identification.
        :param name: The name of the web ACL. You cannot change the name of a web ACL after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        :param token_domains: Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03030a65c492e95a1d1ae5ddafd6acbb9efdfa7e18b6367ac7e03eb8fe504525)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnWebACLProps(
            default_action=default_action,
            scope=scope,
            visibility_config=visibility_config,
            association_config=association_config,
            captcha_config=captcha_config,
            challenge_config=challenge_config,
            custom_response_bodies=custom_response_bodies,
            description=description,
            name=name,
            rules=rules,
            tags=tags,
            token_domains=token_domains,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_488e0dd5) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__376231183b8e6168d309715ff2ec1f7a5bf235473ef67e8b905ee5400deee7e0)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__10d5331eeda0a793d74c086edb4a25c85042aefaf4f3ed126aac4e1d2f840d07)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrCapacity")
    def attr_capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) currently being used by this web ACL.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :cloudformationAttribute: Capacity
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrCapacity"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the web ACL.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="attrLabelNamespace")
    def attr_label_namespace(self) -> builtins.str:
        '''The label namespace prefix for this web ACL.

        All labels added by rules in this web ACL have this prefix.

        The syntax for the label namespace prefix for a web ACL is the following: ``awswaf:<account ID>:webacl:<web ACL name>:``

        When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.

        :cloudformationAttribute: LabelNamespace
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLabelNamespace"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0a598cb3:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tags
        '''
        return typing.cast(_TagManager_0a598cb3, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="defaultAction")
    def default_action(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.DefaultActionProperty"]:
        '''The action to perform if none of the ``Rules`` contained in the ``WebACL`` match.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-defaultaction
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.DefaultActionProperty"], jsii.get(self, "defaultAction"))

    @default_action.setter
    def default_action(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnWebACL.DefaultActionProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2278a10121edfa33bcba416640471cade86cfa4cd26e23a8e52483acce0b053c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultAction", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        For information about how to define the association of the web ACL with your resource, see ``WebACLAssociation`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a713a6057870757511e9190984a673024b8e428fbfb62430ddca1be52f22a466)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="visibilityConfig")
    def visibility_config(
        self,
    ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-visibilityconfig
        '''
        return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"], jsii.get(self, "visibilityConfig"))

    @visibility_config.setter
    def visibility_config(
        self,
        value: typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c31cd418fc7ecfcb56c27ca59f7e1a72ad63669e0587305727953071e54beba5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "visibilityConfig", value)

    @builtins.property
    @jsii.member(jsii_name="associationConfig")
    def association_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AssociationConfigProperty"]]:
        '''Specifies custom configurations for the associations between the web ACL and protected resources.

        Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to AWS WAF for inspection. The default is 16 KB (16,384 kilobytes).
        .. epigraph::

           You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-associationconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AssociationConfigProperty"]], jsii.get(self, "associationConfig"))

    @association_config.setter
    def association_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AssociationConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd4131e7b800e93fe8dbfa57a0b3448dcc676e6dccccd567162368dbc7b9aa88)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "associationConfig", value)

    @builtins.property
    @jsii.member(jsii_name="captchaConfig")
    def captcha_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]]:
        '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings.

        If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-captchaconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]], jsii.get(self, "captchaConfig"))

    @captcha_config.setter
    def captcha_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bec4912672ad4c39c01367d956dcf8b3173f9726891f89f7bcb98f5d113a5b96)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "captchaConfig", value)

    @builtins.property
    @jsii.member(jsii_name="challengeConfig")
    def challenge_config(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]]:
        '''Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own ``ChallengeConfig`` settings.

        If you don't specify this, AWS WAF uses its default settings for ``ChallengeConfig`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-challengeconfig
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]], jsii.get(self, "challengeConfig"))

    @challenge_config.setter
    def challenge_config(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e91b2b602941cac006704e7fffe237dd7367bae62a80676a727ef6f2d0ff5748)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "challengeConfig", value)

    @builtins.property
    @jsii.member(jsii_name="customResponseBodies")
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseBodyProperty"]]]]:
        '''A map of custom response keys and content bodies.

        When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.

        For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

        For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-customresponsebodies
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseBodyProperty"]]]], jsii.get(self, "customResponseBodies"))

    @custom_response_bodies.setter
    def custom_response_bodies(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseBodyProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5782b9cc65df721fabb81b38101a49b0dce480579e9b262edcfe915ec2bb91ee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customResponseBodies", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the web ACL that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b7cfda3db6502d36377ec778a8c90e7487c0f54a00cb343261a4d256ace27df9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the web ACL.

        You cannot change the name of a web ACL after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__191460374393c7b9829682ab4faa571596cd3c2090e46352a427930a25736975)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleProperty"]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.

        Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-rules
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleProperty"]]]], jsii.get(self, "rules"))

    @rules.setter
    def rules(
        self,
        value: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleProperty"]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e3abb4095a53abe30bca846b48411ffb15b0267398c52a824a8ffba45db4f4c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "rules", value)

    @builtins.property
    @jsii.member(jsii_name="tokenDomains")
    def token_domains(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Specifies the domains that AWS WAF should accept in a web request token.

        This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tokendomains
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tokenDomains"))

    @token_domains.setter
    def token_domains(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99fc4e17b77f4f0f511e3dfadd416c0aa9910c2cf60e12f343bccd8e81d4c228)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tokenDomains", value)

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty",
        jsii_struct_bases=[],
        name_mapping={
            "login_path": "loginPath",
            "request_inspection": "requestInspection",
            "response_inspection": "responseInspection",
        },
    )
    class AWSManagedRulesATPRuleSetProperty:
        def __init__(
            self,
            *,
            login_path: builtins.str,
            request_inspection: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RequestInspectionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            response_inspection: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ResponseInspectionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Details for your use of the account takeover prevention managed rule group, ``AWSManagedRulesATPRuleSet`` .

            This configuration is used in ``ManagedRuleGroupConfig`` .

            :param login_path: The path of the login endpoint for your application. For example, for the URL ``https://example.com/web/login`` , you would provide the path ``/web/login`` . The rule group inspects only HTTP ``POST`` requests to your specified login endpoint.
            :param request_inspection: The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
            :param response_inspection: The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that submit too many failed login attempts in a short amount of time. .. epigraph:: Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                a_wSManaged_rules_aTPRule_set_property = wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty(
                    login_path="loginPath",
                
                    # the properties below are optional
                    request_inspection=wafv2.CfnWebACL.RequestInspectionProperty(
                        password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        ),
                        payload_type="payloadType",
                        username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        )
                    ),
                    response_inspection=wafv2.CfnWebACL.ResponseInspectionProperty(
                        body_contains=wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                            failure_strings=["failureStrings"],
                            success_strings=["successStrings"]
                        ),
                        header=wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                            failure_values=["failureValues"],
                            name="name",
                            success_values=["successValues"]
                        ),
                        json=wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                            failure_values=["failureValues"],
                            identifier="identifier",
                            success_values=["successValues"]
                        ),
                        status_code=wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                            failure_codes=[123],
                            success_codes=[123]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f9aee7f94c21473b0495313f92d8a99724499d3f5a99e7229679efb1e73516ad)
                check_type(argname="argument login_path", value=login_path, expected_type=type_hints["login_path"])
                check_type(argname="argument request_inspection", value=request_inspection, expected_type=type_hints["request_inspection"])
                check_type(argname="argument response_inspection", value=response_inspection, expected_type=type_hints["response_inspection"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "login_path": login_path,
            }
            if request_inspection is not None:
                self._values["request_inspection"] = request_inspection
            if response_inspection is not None:
                self._values["response_inspection"] = response_inspection

        @builtins.property
        def login_path(self) -> builtins.str:
            '''The path of the login endpoint for your application.

            For example, for the URL ``https://example.com/web/login`` , you would provide the path ``/web/login`` .

            The rule group inspects only HTTP ``POST`` requests to your specified login endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-loginpath
            '''
            result = self._values.get("login_path")
            assert result is not None, "Required property 'login_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def request_inspection(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestInspectionProperty"]]:
            '''The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-requestinspection
            '''
            result = self._values.get("request_inspection")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestInspectionProperty"]], result)

        @builtins.property
        def response_inspection(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionProperty"]]:
            '''The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.

            The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that submit too many failed login attempts in a short amount of time.
            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-responseinspection
            '''
            result = self._values.get("response_inspection")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AWSManagedRulesATPRuleSetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty",
        jsii_struct_bases=[],
        name_mapping={"inspection_level": "inspectionLevel"},
    )
    class AWSManagedRulesBotControlRuleSetProperty:
        def __init__(self, *, inspection_level: builtins.str) -> None:
            '''Details for your use of the Bot Control managed rule group, used in ``ManagedRuleGroupConfig`` .

            :param inspection_level: The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                a_wSManaged_rules_bot_control_rule_set_property = wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                    inspection_level="inspectionLevel"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__23917b7bd12237aafb58493973b8f61366778e01800aad21ea2f95a01294dc76)
                check_type(argname="argument inspection_level", value=inspection_level, expected_type=type_hints["inspection_level"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "inspection_level": inspection_level,
            }

        @builtins.property
        def inspection_level(self) -> builtins.str:
            '''The inspection level to use for the Bot Control rule group.

            The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-inspectionlevel
            '''
            result = self._values.get("inspection_level")
            assert result is not None, "Required property 'inspection_level' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AWSManagedRulesBotControlRuleSetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AllowActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class AllowActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should allow the request and optionally defines additional custom handling for the request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_request_handling: Defines custom handling for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                allow_action_property = wafv2.CfnWebACL.AllowActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__69dee3824024f4ebf455961564f0743db7a203a492aae72706c2b03ec8de3725)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html#cfn-wafv2-webacl-allowaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AllowActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AndStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class AndStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :param statements: The statements to combine with AND logic. You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e3977b616ebe935b8882258fb7fe1261468bceabf99977afc1c05b1df5a70def)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]]:
            '''The statements to combine with AND logic.

            You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html#cfn-wafv2-webacl-andstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AndStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.AssociationConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"request_body": "requestBody"},
    )
    class AssociationConfigProperty:
        def __init__(
            self,
            *,
            request_body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''Specifies custom configurations for the associations between the web ACL and protected resources.

            Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to AWS WAF for inspection. The default is 16 KB (16,384 kilobytes).
            .. epigraph::

               You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .

            :param request_body: Customizes the maximum size of the request body that your protected CloudFront distributions forward to AWS WAF for inspection. The default size is 16 KB (16,384 kilobytes). .. epigraph:: You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                association_config_property = wafv2.CfnWebACL.AssociationConfigProperty(
                    request_body={
                        "request_body_key": wafv2.CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty(
                            default_size_inspection_limit="defaultSizeInspectionLimit"
                        )
                    }
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__889bff55ba91160187275a11669025b829161457b27db183745c6a70c6fb0947)
                check_type(argname="argument request_body", value=request_body, expected_type=type_hints["request_body"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if request_body is not None:
                self._values["request_body"] = request_body

        @builtins.property
        def request_body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty"]]]]:
            '''Customizes the maximum size of the request body that your protected CloudFront distributions forward to AWS WAF for inspection.

            The default size is 16 KB (16,384 kilobytes).
            .. epigraph::

               You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html#cfn-wafv2-webacl-associationconfig-requestbody
            '''
            result = self._values.get("request_body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Mapping[builtins.str, typing.Union[_IResolvable_da3f097b, "CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AssociationConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.BlockActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_response": "customResponse"},
    )
    class BlockActionProperty:
        def __init__(
            self,
            *,
            custom_response: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomResponseProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should block the request and optionally defines additional custom handling for the response to the web request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_response: Defines a custom response for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                block_action_property = wafv2.CfnWebACL.BlockActionProperty(
                    custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                        response_code=123,
                
                        # the properties below are optional
                        custom_response_body_key="customResponseBodyKey",
                        response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2cd0779b093422bd5fd6a55e35abfcd7322ddfbd2b9d953493ef043b3fbf4cf8)
                check_type(argname="argument custom_response", value=custom_response, expected_type=type_hints["custom_response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_response is not None:
                self._values["custom_response"] = custom_response

        @builtins.property
        def custom_response(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseProperty"]]:
            '''Defines a custom response for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html#cfn-wafv2-webacl-blockaction-customresponse
            '''
            result = self._values.get("custom_response")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomResponseProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.BodyProperty",
        jsii_struct_bases=[],
        name_mapping={"oversize_handling": "oversizeHandling"},
    )
    class BodyProperty:
        def __init__(
            self,
            *,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection. The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                body_property = wafv2.CfnWebACL.BodyProperty(
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__931342fa1a6c3c85b33cb0561c01b7d14274ade272ed3521abe036b843fa8f3e)
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection.

            The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html#cfn-wafv2-webacl-body-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ByteMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "positional_constraint": "positionalConstraint",
            "text_transformations": "textTransformations",
            "search_string": "searchString",
            "search_string_base64": "searchStringBase64",
        },
    )
    class ByteMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            positional_constraint: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            search_string: typing.Optional[builtins.str] = None,
            search_string_base64: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param positional_constraint: The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` . Valid values include the following: *CONTAINS* The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter. *CONTAINS_WORD* The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true: - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` . - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` . *EXACTLY* The value of the specified part of the web request must exactly match the value of ``SearchString`` . *STARTS_WITH* The value of ``SearchString`` must appear at the beginning of the specified part of the web request. *ENDS_WITH* The value of ``SearchString`` must appear at the end of the specified part of the web request.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive. Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you. For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` . You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .
            :param search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead. You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                byte_match_statement_property = wafv2.CfnWebACL.ByteMatchStatementProperty(
                    field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnWebACL.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnWebACL.CookiesProperty(
                            match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnWebACL.HeadersProperty(
                            match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnWebACL.JsonBodyProperty(
                            match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    positional_constraint="positionalConstraint",
                    text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    search_string="searchString",
                    search_string_base64="searchStringBase64"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__aa15ef2b16644ae01b4e67c309786112c6345b088bd7dc3abcd5ef657c4d06f9)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument positional_constraint", value=positional_constraint, expected_type=type_hints["positional_constraint"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument search_string", value=search_string, expected_type=type_hints["search_string"])
                check_type(argname="argument search_string_base64", value=search_string_base64, expected_type=type_hints["search_string_base64"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "positional_constraint": positional_constraint,
                "text_transformations": text_transformations,
            }
            if search_string is not None:
                self._values["search_string"] = search_string
            if search_string_base64 is not None:
                self._values["search_string_base64"] = search_string_base64

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"], result)

        @builtins.property
        def positional_constraint(self) -> builtins.str:
            '''The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` .

            Valid values include the following:

            *CONTAINS*

            The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter.

            *CONTAINS_WORD*

            The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true:

            - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` .
            - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` .

            *EXACTLY*

            The value of the specified part of the web request must exactly match the value of ``SearchString`` .

            *STARTS_WITH*

            The value of ``SearchString`` must appear at the beginning of the specified part of the web request.

            *ENDS_WITH*

            The value of ``SearchString`` must appear at the end of the specified part of the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-positionalconstraint
            '''
            result = self._values.get("positional_constraint")
            assert result is not None, "Required property 'positional_constraint' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]], result)

        @builtins.property
        def search_string(self) -> typing.Optional[builtins.str]:
            '''A string value that you want AWS WAF to search for.

            AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

            Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

            For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` .

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstring
            '''
            result = self._values.get("search_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def search_string_base64(self) -> typing.Optional[builtins.str]:
            '''String to search for in a web request component, base64-encoded.

            If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead.

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstringbase64
            '''
            result = self._values.get("search_string_base64")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ByteMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CaptchaActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:.

            - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .
            - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF generates a response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``captcha`` .
            - The HTTP status code ``405 Method Not Allowed`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge.

            You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :param custom_request_handling: Defines custom handling for the web request, used when the ``CAPTCHA`` inspection determines that the request's token is valid and unexpired. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_action_property = wafv2.CfnWebACL.CaptchaActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c28ed2f577156216a396d23cdf94c64fd6f221d82920aea9a64f1c77e4acbd35)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request, used when the ``CAPTCHA`` inspection determines that the request's token is valid and unexpired.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html#cfn-wafv2-webacl-captchaaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class CaptchaConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings.

            If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .

            :param immunity_time_property: Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                captcha_config_property = wafv2.CfnWebACL.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b45a1ab97900eb88b801a9d476ef90fffa338929bfd860fb5818734249ab355d)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]]:
            '''Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html#cfn-wafv2-webacl-captchaconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class ChallengeActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should run a ``Challenge`` check against the request to verify that the request is coming from a legitimate client session:  - If the request includes a valid, unexpired challenge token, AWS WAF applies any custom request handling and labels that you've configured and then allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .

            - If the request doesn't include a valid, unexpired challenge token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF then generates a challenge response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``challenge`` .
            - The HTTP status code ``202 Request Accepted`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a JavaScript page interstitial with a challenge script.

            Challenges run silent browser interrogations in the background, and don't generally affect the end user experience.

            A challenge enforces token acquisition using an interstitial JavaScript challenge that inspects the client session for legitimate behavior. The challenge blocks bots or at least increases the cost of operating sophisticated bots.

            After the client session successfully responds to the challenge, it receives a new token from AWS WAF , which the challenge script uses to resubmit the original request.

            You can configure the expiration time in the ``ChallengeConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :param custom_request_handling: Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_action_property = wafv2.CfnWebACL.ChallengeActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3e00e6c1f2ede04c7bc1e9b6ad5856518734b5452ceecd17f5010c5456ddf203)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html#cfn-wafv2-webacl-challengeaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class ChallengeConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                challenge_config_property = wafv2.CfnWebACL.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e59d4e09b55c6fb1e18f3dbf3d0659f147db2659c300a744e836928d4b000e7b)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]]:
            '''Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html#cfn-wafv2-webacl-challengeconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ImmunityTimePropertyProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CookieMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_cookies": "excludedCookies",
            "included_cookies": "includedCookies",
        },
    )
    class CookieMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :param all: Inspect all cookies.
            :param excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
            :param included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookie_match_pattern_property = wafv2.CfnWebACL.CookieMatchPatternProperty(
                    all=all,
                    excluded_cookies=["excludedCookies"],
                    included_cookies=["includedCookies"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__11e565e9aad1b474694cbb7c884715be324a3c5b38238a45e13e0d2ed78d816d)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_cookies", value=excluded_cookies, expected_type=type_hints["excluded_cookies"])
                check_type(argname="argument included_cookies", value=included_cookies, expected_type=type_hints["included_cookies"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_cookies is not None:
                self._values["excluded_cookies"] = excluded_cookies
            if included_cookies is not None:
                self._values["included_cookies"] = included_cookies

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all cookies.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-excludedcookies
            '''
            result = self._values.get("excluded_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-includedcookies
            '''
            result = self._values.get("included_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookieMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CookiesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class CookiesProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CookieMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect the cookies in the web request.

            You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` . Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``
            :param match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookies_property = wafv2.CfnWebACL.CookiesProperty(
                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                        all=all,
                        excluded_cookies=["excludedCookies"],
                        included_cookies=["includedCookies"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5ad212e56575cb6c1346d11d3fd80ae8eba42e3155418b11a1bec538355e2656)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookieMatchPatternProperty"]:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookieMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the cookies to inspect with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available cookies normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookiesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CountActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CountActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Specifies that AWS WAF should count the request. Optionally defines additional custom handling for the request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_request_handling: Defines custom handling for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                count_action_property = wafv2.CfnWebACL.CountActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ad85beaba3815f0aba760c694686ca93d6643507bcf4f500bf71e7da4c260e18)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]]:
            '''Defines custom handling for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html#cfn-wafv2-webacl-countaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomRequestHandlingProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CountActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomHTTPHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "value": "value"},
    )
    class CustomHTTPHeaderProperty:
        def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
            '''A custom header for custom request and response handling.

            This is used in ``CustomResponse`` and ``CustomRequestHandling`` .

            :param name: The name of the custom header. For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .
            :param value: The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_hTTPHeader_property = wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                    name="name",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__32cba5cbfe0dd140f4c32592f1dc09f6de35627e0538709e1c9a3dd17aaa3aef)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "value": value,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the custom header.

            For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomHTTPHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomRequestHandlingProperty",
        jsii_struct_bases=[],
        name_mapping={"insert_headers": "insertHeaders"},
    )
    class CustomRequestHandlingProperty:
        def __init__(
            self,
            *,
            insert_headers: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''Custom request handling behavior that inserts custom headers into a web request.

            You can add custom request handling for AWS WAF to use when the rule action doesn't block the request. For example, ``CaptchaAction`` for requests with valid t okens, and ``AllowAction`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the *AWS WAF Developer Guide* .

            :param insert_headers: The HTTP headers to insert into the request. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_request_handling_property = wafv2.CfnWebACL.CustomRequestHandlingProperty(
                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ba933811044d610695911a26490bdd0e276008bbe930839f73ea645c8f2b7316)
                check_type(argname="argument insert_headers", value=insert_headers, expected_type=type_hints["insert_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "insert_headers": insert_headers,
            }

        @builtins.property
        def insert_headers(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]]:
            '''The HTTP headers to insert into the request. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html#cfn-wafv2-webacl-customrequesthandling-insertheaders
            '''
            result = self._values.get("insert_headers")
            assert result is not None, "Required property 'insert_headers' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomRequestHandlingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseBodyProperty",
        jsii_struct_bases=[],
        name_mapping={"content": "content", "content_type": "contentType"},
    )
    class CustomResponseBodyProperty:
        def __init__(
            self,
            *,
            content: builtins.str,
            content_type: builtins.str,
        ) -> None:
            '''The response body to use in a custom response to a web request.

            This is referenced by key from ``CustomResponse`` ``CustomResponseBodyKey`` .

            :param content: The payload of the custom response. You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .
            :param content_type: The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_body_property = wafv2.CfnWebACL.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__281879092afa665915e6fd969d0e9a5b5b4898fe8ef498c2dea6a4bf1109aafa)
                check_type(argname="argument content", value=content, expected_type=type_hints["content"])
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "content": content,
                "content_type": content_type,
            }

        @builtins.property
        def content(self) -> builtins.str:
            '''The payload of the custom response.

            You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-content
            '''
            result = self._values.get("content")
            assert result is not None, "Required property 'content' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def content_type(self) -> builtins.str:
            '''The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-contenttype
            '''
            result = self._values.get("content_type")
            assert result is not None, "Required property 'content_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "response_code": "responseCode",
            "custom_response_body_key": "customResponseBodyKey",
            "response_headers": "responseHeaders",
        },
    )
    class CustomResponseProperty:
        def __init__(
            self,
            *,
            response_code: jsii.Number,
            custom_response_body_key: typing.Optional[builtins.str] = None,
            response_headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A custom response to send to the client.

            You can define a custom response for rule actions and default web ACL actions that are set to the block action.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param response_code: The HTTP status code to return to the client. For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .
            :param custom_response_body_key: References the response body that you want AWS WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.
            :param response_headers: The HTTP headers to use in the response. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                custom_response_property = wafv2.CfnWebACL.CustomResponseProperty(
                    response_code=123,
                
                    # the properties below are optional
                    custom_response_body_key="customResponseBodyKey",
                    response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6dbc9439dfbaeae9e0932894939e1048a58a2d028d4ee3fbdcead25e1600ad91)
                check_type(argname="argument response_code", value=response_code, expected_type=type_hints["response_code"])
                check_type(argname="argument custom_response_body_key", value=custom_response_body_key, expected_type=type_hints["custom_response_body_key"])
                check_type(argname="argument response_headers", value=response_headers, expected_type=type_hints["response_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "response_code": response_code,
            }
            if custom_response_body_key is not None:
                self._values["custom_response_body_key"] = custom_response_body_key
            if response_headers is not None:
                self._values["response_headers"] = response_headers

        @builtins.property
        def response_code(self) -> jsii.Number:
            '''The HTTP status code to return to the client.

            For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responsecode
            '''
            result = self._values.get("response_code")
            assert result is not None, "Required property 'response_code' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_response_body_key(self) -> typing.Optional[builtins.str]:
            '''References the response body that you want AWS WAF to return to the web request client.

            You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-customresponsebodykey
            '''
            result = self._values.get("custom_response_body_key")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def response_headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]]]:
            '''The HTTP headers to use in the response. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responseheaders
            '''
            result = self._values.get("response_headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CustomHTTPHeaderProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.DefaultActionProperty",
        jsii_struct_bases=[],
        name_mapping={"allow": "allow", "block": "block"},
    )
    class DefaultActionProperty:
        def __init__(
            self,
            *,
            allow: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AllowActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            block: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.BlockActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''In a ``WebACL`` , this is the action that you want AWS WAF to perform when a web request doesn't match any of the rules in the ``WebACL`` .

            The default action must be a terminating action.

            :param allow: Specifies that AWS WAF should allow requests by default.
            :param block: Specifies that AWS WAF should block requests by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                default_action_property = wafv2.CfnWebACL.DefaultActionProperty(
                    allow=wafv2.CfnWebACL.AllowActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    block=wafv2.CfnWebACL.BlockActionProperty(
                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                            response_code=123,
                
                            # the properties below are optional
                            custom_response_body_key="customResponseBodyKey",
                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4f9b2681c5a7f99be956a44a9c1d132bd2244e6fdc65ac82690f66a9402698b5)
                check_type(argname="argument allow", value=allow, expected_type=type_hints["allow"])
                check_type(argname="argument block", value=block, expected_type=type_hints["block"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if allow is not None:
                self._values["allow"] = allow
            if block is not None:
                self._values["block"] = block

        @builtins.property
        def allow(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AllowActionProperty"]]:
            '''Specifies that AWS WAF should allow requests by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-allow
            '''
            result = self._values.get("allow")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AllowActionProperty"]], result)

        @builtins.property
        def block(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BlockActionProperty"]]:
            '''Specifies that AWS WAF should block requests by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-block
            '''
            result = self._values.get("block")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BlockActionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ExcludedRuleProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class ExcludedRuleProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Specifies a single rule in a rule group whose action you want to override to ``Count`` .

            .. epigraph::

               Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .

            :param name: The name of the rule whose action you want to override to ``Count`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                excluded_rule_property = wafv2.CfnWebACL.ExcludedRuleProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a96bf0217136d589753b415a4d08032d4bb70e9d17edcf46dbc160ad99e5935a)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule whose action you want to override to ``Count`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html#cfn-wafv2-webacl-excludedrule-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ExcludedRuleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.FieldIdentifierProperty",
        jsii_struct_bases=[],
        name_mapping={"identifier": "identifier"},
    )
    class FieldIdentifierProperty:
        def __init__(self, *, identifier: builtins.str) -> None:
            '''The identifier of the username or password field, used in the ``ManagedRuleGroupConfig`` settings.

            :param identifier: The name of the username or password field, used in the ``ManagedRuleGroupConfig`` settings. When the ``PayloadType`` is ``JSON`` , the identifier must be in JSON pointer syntax. For example ``/form/username`` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . When the ``PayloadType`` is ``FORM_ENCODED`` , use the HTML form names. For example, ``username`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                field_identifier_property = wafv2.CfnWebACL.FieldIdentifierProperty(
                    identifier="identifier"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cb389deae2afd887b8a26e90f20af6819bccf430ed2ee28f87cc538c2e16bce6)
                check_type(argname="argument identifier", value=identifier, expected_type=type_hints["identifier"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "identifier": identifier,
            }

        @builtins.property
        def identifier(self) -> builtins.str:
            '''The name of the username or password field, used in the ``ManagedRuleGroupConfig`` settings.

            When the ``PayloadType`` is ``JSON`` , the identifier must be in JSON pointer syntax. For example ``/form/username`` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            When the ``PayloadType`` is ``FORM_ENCODED`` , use the HTML form names. For example, ``username`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html#cfn-wafv2-webacl-fieldidentifier-identifier
            '''
            result = self._values.get("identifier")
            assert result is not None, "Required property 'identifier' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldIdentifierProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all_query_arguments": "allQueryArguments",
            "body": "body",
            "cookies": "cookies",
            "headers": "headers",
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "single_query_argument": "singleQueryArgument",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            all_query_arguments: typing.Any = None,
            body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.BodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            cookies: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CookiesProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            headers: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.HeadersProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json_body: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.JsonBodyProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            single_query_argument: typing.Any = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''The part of the web request that you want AWS WAF to inspect.

            Include the single ``FieldToMatch`` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in ``FieldToMatch`` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            :param all_query_arguments: Inspect all query arguments.
            :param body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees. For information about how to handle oversized request bodies, see the ``Body`` object configuration.
            :param cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param headers: Inspect the request headers. You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
            :param json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.
            :param method: Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Inspect the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Inspect a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }`` Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.
            :param single_query_argument: Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive. Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``
            :param uri_path: Inspect the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnWebACL.FieldToMatchProperty(
                    all_query_arguments=all_query_arguments,
                    body=wafv2.CfnWebACL.BodyProperty(
                        oversize_handling="oversizeHandling"
                    ),
                    cookies=wafv2.CfnWebACL.CookiesProperty(
                        match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                            all=all,
                            excluded_cookies=["excludedCookies"],
                            included_cookies=["includedCookies"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    headers=wafv2.CfnWebACL.HeadersProperty(
                        match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                            all=all,
                            excluded_headers=["excludedHeaders"],
                            included_headers=["includedHeaders"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    json_body=wafv2.CfnWebACL.JsonBodyProperty(
                        match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                            all=all,
                            included_paths=["includedPaths"]
                        ),
                        match_scope="matchScope",
                
                        # the properties below are optional
                        invalid_fallback_behavior="invalidFallbackBehavior",
                        oversize_handling="oversizeHandling"
                    ),
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    single_query_argument=single_query_argument,
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__25d147c856e9a8fd64f4cc05856e4813e584f37ef787792ad3c4e07907417207)
                check_type(argname="argument all_query_arguments", value=all_query_arguments, expected_type=type_hints["all_query_arguments"])
                check_type(argname="argument body", value=body, expected_type=type_hints["body"])
                check_type(argname="argument cookies", value=cookies, expected_type=type_hints["cookies"])
                check_type(argname="argument headers", value=headers, expected_type=type_hints["headers"])
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument single_query_argument", value=single_query_argument, expected_type=type_hints["single_query_argument"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all_query_arguments is not None:
                self._values["all_query_arguments"] = all_query_arguments
            if body is not None:
                self._values["body"] = body
            if cookies is not None:
                self._values["cookies"] = cookies
            if headers is not None:
                self._values["headers"] = headers
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if single_query_argument is not None:
                self._values["single_query_argument"] = single_query_argument
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def all_query_arguments(self) -> typing.Any:
            '''Inspect all query arguments.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-allqueryarguments
            '''
            result = self._values.get("all_query_arguments")
            return typing.cast(typing.Any, result)

        @builtins.property
        def body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BodyProperty"]]:
            '''Inspect the request body as plain text.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees.

            For information about how to handle oversized request bodies, see the ``Body`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-body
            '''
            result = self._values.get("body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BodyProperty"]], result)

        @builtins.property
        def cookies(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookiesProperty"]]:
            '''Inspect the request cookies.

            You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-cookies
            '''
            result = self._values.get("cookies")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CookiesProperty"]], result)

        @builtins.property
        def headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeadersProperty"]]:
            '''Inspect the request headers.

            You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-headers
            '''
            result = self._values.get("headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeadersProperty"]], result)

        @builtins.property
        def json_body(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonBodyProperty"]]:
            '''Inspect the request body as JSON.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            A limited amount of the request body is forwarded to AWS WAF for inspection by the underlying host service. For regional resources, the limit is 8 KB (8,192 kilobytes) and for CloudFront distributions, the limit is 16 KB (16,384 kilobytes). For CloudFront distributions, you can increase the limit in the web ACL's ``AssociationConfig`` , for additional processing fees.

            For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonBodyProperty"]], result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Inspect the HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Inspect the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Inspect a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_query_argument(self) -> typing.Any:
            '''Inspect a single query argument.

            Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singlequeryargument
            '''
            result = self._values.get("single_query_argument")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Inspect the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
        },
    )
    class ForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used for ``GeoMatchStatement`` and ``RateBasedStatement`` . For ``IPSetReferenceStatement`` , use ``IPSetForwardedIPConfig`` instead.

            AWS WAF only evaluates the first IP address found in the specified HTTP header.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                forwarded_iPConfiguration_property = wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                    fallback_behavior="fallbackBehavior",
                    header_name="headerName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__db1f5e352c4a5fdd9a13196892955f19f25065d63109402ea882298152866a75)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.GeoMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "country_codes": "countryCodes",
            "forwarded_ip_config": "forwardedIpConfig",
        },
    )
    class GeoMatchStatementProperty:
        def __init__(
            self,
            *,
            country_codes: typing.Optional[typing.Sequence[builtins.str]] = None,
            forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param country_codes: An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard. When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                geo_match_statement_property = wafv2.CfnWebACL.GeoMatchStatementProperty(
                    country_codes=["countryCodes"],
                    forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__befc77fe4c1d7ff11b5fe89a367afb00688b31f469f3561e1dc2fc7c6cf1aea5)
                check_type(argname="argument country_codes", value=country_codes, expected_type=type_hints["country_codes"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if country_codes is not None:
                self._values["country_codes"] = country_codes
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config

        @builtins.property
        def country_codes(self) -> typing.Optional[typing.List[builtins.str]]:
            '''An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

            When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-countrycodes
            '''
            result = self._values.get("country_codes")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GeoMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.HeaderMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_headers": "excludedHeaders",
            "included_headers": "includedHeaders",
        },
    )
    class HeaderMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :param all: Inspect all headers.
            :param excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
            :param included_headers: Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                header_match_pattern_property = wafv2.CfnWebACL.HeaderMatchPatternProperty(
                    all=all,
                    excluded_headers=["excludedHeaders"],
                    included_headers=["includedHeaders"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__74f4bafb0ceef9ccf5758d2d07f34c359f06d8608d8db4d517f5a02bf945ad72)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_headers", value=excluded_headers, expected_type=type_hints["excluded_headers"])
                check_type(argname="argument included_headers", value=included_headers, expected_type=type_hints["included_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_headers is not None:
                self._values["excluded_headers"] = excluded_headers
            if included_headers is not None:
                self._values["included_headers"] = included_headers

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all headers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-excludedheaders
            '''
            result = self._values.get("excluded_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-includedheaders
            '''
            result = self._values.get("included_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeaderMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.HeadersProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class HeadersProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.HeaderMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect all headers in the web request.

            You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            If you want to inspect just the value of a single header, use the ``SingleHeader`` ``FieldToMatch`` setting instead.

            Example JSON: ``"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of headers to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` . Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``
            :param match_scope: The parts of the headers to match with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                headers_property = wafv2.CfnWebACL.HeadersProperty(
                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                        all=all,
                        excluded_headers=["excludedHeaders"],
                        included_headers=["includedHeaders"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fb8a12a400cdb513abdda33ba661401606db55c8dc78fefe32c1a27bf31ea2c4)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeaderMatchPatternProperty"]:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.HeaderMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the headers to match with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the headers of the request are more numerous or larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available headers normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeadersProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
            "position": "position",
        },
    )
    class IPSetForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
            position: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used only for ``IPSetReferenceStatement`` . For ``GeoMatchStatement`` and ``RateBasedStatement`` , use ``ForwardedIPConfig`` instead.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
            :param position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through. The options for this setting are the following: - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP. - LAST - Inspect the last IP address in the list of IP addresses in the header. - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_forwarded_iPConfiguration_property = {
                    "fallback_behavior": "fallbackBehavior",
                    "header_name": "headerName",
                    "position": "position"
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c84737e60b069b2a78f599f428b4ef9e093de8316e5c8534f5c2154d424da173)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
                check_type(argname="argument position", value=position, expected_type=type_hints["position"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
                "position": position,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def position(self) -> builtins.str:
            '''The position in the header to search for the IP address.

            The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through.

            The options for this setting are the following:

            - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
            - LAST - Inspect the last IP address in the list of IP addresses in the header.
            - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-position
            '''
            result = self._values.get("position")
            assert result is not None, "Required property 'position' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "ip_set_forwarded_ip_config": "ipSetForwardedIpConfig",
        },
    )
    class IPSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            ip_set_forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.IPSetForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.
            :param ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                i_pSet_reference_statement_property = {
                    "arn": "arn",
                
                    # the properties below are optional
                    "ip_set_forwarded_ip_config": {
                        "fallback_behavior": "fallbackBehavior",
                        "header_name": "headerName",
                        "position": "position"
                    }
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__344492cd77103ff2a78ddd489f925b8d499c81f54082b275e70c59266867f37d)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument ip_set_forwarded_ip_config", value=ip_set_forwarded_ip_config, expected_type=type_hints["ip_set_forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
            }
            if ip_set_forwarded_ip_config is not None:
                self._values["ip_set_forwarded_ip_config"] = ip_set_forwarded_ip_config

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def ip_set_forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.IPSetForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-ipsetforwardedipconfig
            '''
            result = self._values.get("ip_set_forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.IPSetForwardedIPConfigurationProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ImmunityTimePropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time": "immunityTime"},
    )
    class ImmunityTimePropertyProperty:
        def __init__(self, *, immunity_time: jsii.Number) -> None:
            '''Used for CAPTCHA and challenge token settings.

            Determines how long a ``CAPTCHA`` or challenge timestamp remains valid after AWS WAF updates it for a successful ``CAPTCHA`` or challenge response.

            :param immunity_time: The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF . The default setting is 300. For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                immunity_time_property_property = wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4ebec44af1e8d72b72f8c361dc8efc545a044cf914ee07c895cf4c1d1acefad2)
                check_type(argname="argument immunity_time", value=immunity_time, expected_type=type_hints["immunity_time"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "immunity_time": immunity_time,
            }

        @builtins.property
        def immunity_time(self) -> jsii.Number:
            '''The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF .

            The default setting is 300.

            For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html#cfn-wafv2-webacl-immunitytimeproperty-immunitytime
            '''
            result = self._values.get("immunity_time")
            assert result is not None, "Required property 'immunity_time' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImmunityTimePropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
            "oversize_handling": "oversizeHandling",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.JsonMatchPatternProperty", typing.Dict[builtins.str, typing.Any]]],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``All`` , AWS WAF matches against keys and values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array. AWS WAF parses the JSON in the following examples as two valid key, value pairs: - Missing comma: ``{"key1":"value1""key2":"value2"}`` - Missing colon: ``{"key1":"value1","key2""value2"}`` - Extra colons: ``{"key1"::"value1","key2""value2"}``
            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection. The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnWebACL.JsonBodyProperty(
                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b371d01e6e192e377c25d061f5a40b73b3aca7d15781a83f612151eddebe6fa2)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonMatchPatternProperty"]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.JsonMatchPatternProperty"], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``All`` , AWS WAF matches against keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

            AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.

            AWS WAF parses the JSON in the following examples as two valid key, value pairs:

            - Missing comma: ``{"key1":"value1""key2":"value2"}``
            - Missing colon: ``{"key1":"value1","key2""value2"}``
            - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. If the body is larger than the limit, the underlying host service only forwards the contents that are below the limit to AWS WAF for inspection.

            The default limit is 8 KB (8,192 kilobytes) for regional resources and 16 KB (16,384 kilobytes) for CloudFront distributions. For CloudFront distributions, you can increase the limit in the web ACL ``AssociationConfig`` , for additional processing fees.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the available body contents normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.JsonMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class JsonMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the ``FieldToMatch`` option ``JsonBody`` .

            :param all: Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. You must specify either this setting or the ``IncludedPaths`` setting, but not both.
            :param included_paths: Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . You must specify either this setting or the ``All`` setting, but not both. .. epigraph:: Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_match_pattern_property = wafv2.CfnWebACL.JsonMatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0da90eac09d57420ee040ab315fb49e6de7faca7697217290633a02356c64b8c)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            You must specify either this setting or the ``IncludedPaths`` setting, but not both.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            You must specify either this setting or the ``All`` setting, but not both.
            .. epigraph::

               Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.LabelMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "scope": "scope"},
    )
    class LabelMatchStatementProperty:
        def __init__(self, *, key: builtins.str, scope: builtins.str) -> None:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :param key: The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:. - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates. Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .
            :param scope: Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_match_statement_property = wafv2.CfnWebACL.LabelMatchStatementProperty(
                    key="key",
                    scope="scope"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7fbc144fb2899e7e14bfe8ef6fcbc18ee5df1b532334669d611524d95ba13a79)
                check_type(argname="argument key", value=key, expected_type=type_hints["key"])
                check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "key": key,
                "scope": scope,
            }

        @builtins.property
        def key(self) -> builtins.str:
            '''The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:.

            - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
            - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

            Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-key
            '''
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def scope(self) -> builtins.str:
            '''Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-scope
            '''
            result = self._values.get("scope")
            assert result is not None, "Required property 'scope' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.LabelProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''A single label container.

            This is used as an element of a label array in ``RuleLabels`` inside a rule.

            :param name: The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                label_property = wafv2.CfnWebACL.LabelProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bf81be90baf4410ecf4fe3290d007b8b6c18da545bbac600a4ec86a29a24621d)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html#cfn-wafv2-webacl-label-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ManagedRuleGroupConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aws_managed_rules_atp_rule_set": "awsManagedRulesAtpRuleSet",
            "aws_managed_rules_bot_control_rule_set": "awsManagedRulesBotControlRuleSet",
            "login_path": "loginPath",
            "password_field": "passwordField",
            "payload_type": "payloadType",
            "username_field": "usernameField",
        },
    )
    class ManagedRuleGroupConfigProperty:
        def __init__(
            self,
            *,
            aws_managed_rules_atp_rule_set: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AWSManagedRulesATPRuleSetProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            aws_managed_rules_bot_control_rule_set: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AWSManagedRulesBotControlRuleSetProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            login_path: typing.Optional[builtins.str] = None,
            password_field: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            payload_type: typing.Optional[builtins.str] = None,
            username_field: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''Additional information that's used by a managed rule group. Many managed rule groups don't require this.

            Use the ``AWSManagedRulesBotControlRuleSet`` configuration object to configure the protection level that you want the Bot Control rule group to use.

            :param aws_managed_rules_atp_rule_set: Additional configuration for using the account takeover prevention (ATP) managed rule group, ``AWSManagedRulesATPRuleSet`` . Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests. This configuration replaces the individual configuration fields in ``ManagedRuleGroupConfig`` and provides additional feature configuration. For information about using the ATP managed rule group, see `AWS WAF Fraud Control account takeover prevention (ATP) rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html>`_ and `AWS WAF Fraud Control account takeover prevention (ATP) <https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html>`_ in the *AWS WAF Developer Guide* .
            :param aws_managed_rules_bot_control_rule_set: Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ and `AWS WAF Bot Control <https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html>`_ in the *AWS WAF Developer Guide* .
            :param login_path: .. epigraph:: Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` .
            :param password_field: .. epigraph:: Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` ``RequestInspection`` .
            :param payload_type: .. epigraph:: Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` ``RequestInspection`` .
            :param username_field: .. epigraph:: Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` ``RequestInspection`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                managed_rule_group_config_property = wafv2.CfnWebACL.ManagedRuleGroupConfigProperty(
                    aws_managed_rules_atp_rule_set=wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty(
                        login_path="loginPath",
                
                        # the properties below are optional
                        request_inspection=wafv2.CfnWebACL.RequestInspectionProperty(
                            password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            ),
                            payload_type="payloadType",
                            username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            )
                        ),
                        response_inspection=wafv2.CfnWebACL.ResponseInspectionProperty(
                            body_contains=wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                                failure_strings=["failureStrings"],
                                success_strings=["successStrings"]
                            ),
                            header=wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                                failure_values=["failureValues"],
                                name="name",
                                success_values=["successValues"]
                            ),
                            json=wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                                failure_values=["failureValues"],
                                identifier="identifier",
                                success_values=["successValues"]
                            ),
                            status_code=wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                                failure_codes=[123],
                                success_codes=[123]
                            )
                        )
                    ),
                    aws_managed_rules_bot_control_rule_set=wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                        inspection_level="inspectionLevel"
                    ),
                    login_path="loginPath",
                    password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    ),
                    payload_type="payloadType",
                    username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__517661cb97cc58c609587fc6ca9907b2e23d8f3cd6e1e4034f3f6d82b85d2d77)
                check_type(argname="argument aws_managed_rules_atp_rule_set", value=aws_managed_rules_atp_rule_set, expected_type=type_hints["aws_managed_rules_atp_rule_set"])
                check_type(argname="argument aws_managed_rules_bot_control_rule_set", value=aws_managed_rules_bot_control_rule_set, expected_type=type_hints["aws_managed_rules_bot_control_rule_set"])
                check_type(argname="argument login_path", value=login_path, expected_type=type_hints["login_path"])
                check_type(argname="argument password_field", value=password_field, expected_type=type_hints["password_field"])
                check_type(argname="argument payload_type", value=payload_type, expected_type=type_hints["payload_type"])
                check_type(argname="argument username_field", value=username_field, expected_type=type_hints["username_field"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if aws_managed_rules_atp_rule_set is not None:
                self._values["aws_managed_rules_atp_rule_set"] = aws_managed_rules_atp_rule_set
            if aws_managed_rules_bot_control_rule_set is not None:
                self._values["aws_managed_rules_bot_control_rule_set"] = aws_managed_rules_bot_control_rule_set
            if login_path is not None:
                self._values["login_path"] = login_path
            if password_field is not None:
                self._values["password_field"] = password_field
            if payload_type is not None:
                self._values["payload_type"] = payload_type
            if username_field is not None:
                self._values["username_field"] = username_field

        @builtins.property
        def aws_managed_rules_atp_rule_set(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesATPRuleSetProperty"]]:
            '''Additional configuration for using the account takeover prevention (ATP) managed rule group, ``AWSManagedRulesATPRuleSet`` .

            Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.

            This configuration replaces the individual configuration fields in ``ManagedRuleGroupConfig`` and provides additional feature configuration.

            For information about using the ATP managed rule group, see `AWS WAF Fraud Control account takeover prevention (ATP) rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html>`_ and `AWS WAF Fraud Control account takeover prevention (ATP) <https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesatpruleset
            '''
            result = self._values.get("aws_managed_rules_atp_rule_set")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesATPRuleSetProperty"]], result)

        @builtins.property
        def aws_managed_rules_bot_control_rule_set(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesBotControlRuleSetProperty"]]:
            '''Additional configuration for using the Bot Control managed rule group.

            Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ and `AWS WAF Bot Control <https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesbotcontrolruleset
            '''
            result = self._values.get("aws_managed_rules_bot_control_rule_set")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AWSManagedRulesBotControlRuleSetProperty"]], result)

        @builtins.property
        def login_path(self) -> typing.Optional[builtins.str]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-loginpath
            '''
            result = self._values.get("login_path")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def password_field(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` ``RequestInspection`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-passwordfield
            '''
            result = self._values.get("password_field")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]], result)

        @builtins.property
        def payload_type(self) -> typing.Optional[builtins.str]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` ``RequestInspection`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-payloadtype
            '''
            result = self._values.get("payload_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def username_field(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]]:
            '''.. epigraph::

   Instead of this setting, provide your configuration under ``AWSManagedRulesATPRuleSet`` ``RequestInspection`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-usernamefield
            '''
            result = self._values.get("username_field")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ManagedRuleGroupConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ManagedRuleGroupStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "vendor_name": "vendorName",
            "excluded_rules": "excludedRules",
            "managed_rule_group_configs": "managedRuleGroupConfigs",
            "rule_action_overrides": "ruleActionOverrides",
            "scope_down_statement": "scopeDownStatement",
            "version": "version",
        },
    )
    class ManagedRuleGroupStatementProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            vendor_name: builtins.str,
            excluded_rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ExcludedRuleProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            managed_rule_group_configs: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ManagedRuleGroupConfigProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            rule_action_overrides: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RuleActionOverrideProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            scope_down_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            version: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement used to run the rules that are defined in a managed rule group.

            To use this, provide the vendor name and the name of the rule group in this statement.

            You cannot nest a ``ManagedRuleGroupStatement`` , for example for use inside a ``NotStatement`` or ``OrStatement`` . It can only be referenced as a top-level statement within a rule.

            :param name: The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
            :param vendor_name: The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
            :param excluded_rules: Rules in the referenced rule group whose actions are set to ``Count`` . .. epigraph:: Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .
            :param managed_rule_group_configs: Additional information that's used by a managed rule group. Many managed rule groups don't require this. Use the ``AWSManagedRulesATPRuleSet`` configuration object for the account takeover prevention managed rule group, to provide information such as the sign-in page of your application and the type of content to accept or reject from the client. Use the ``AWSManagedRulesBotControlRuleSet`` configuration object to configure the protection level that you want the Bot Control rule group to use.
            :param rule_action_overrides: Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. You can use overrides for testing, for example you can override all of rule actions to ``Count`` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
            :param scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
            :param version: The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f4f6c9025d3a7ae0d9ee82e8e6b386992bc78314180fcac33b95584e813a6205)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument vendor_name", value=vendor_name, expected_type=type_hints["vendor_name"])
                check_type(argname="argument excluded_rules", value=excluded_rules, expected_type=type_hints["excluded_rules"])
                check_type(argname="argument managed_rule_group_configs", value=managed_rule_group_configs, expected_type=type_hints["managed_rule_group_configs"])
                check_type(argname="argument rule_action_overrides", value=rule_action_overrides, expected_type=type_hints["rule_action_overrides"])
                check_type(argname="argument scope_down_statement", value=scope_down_statement, expected_type=type_hints["scope_down_statement"])
                check_type(argname="argument version", value=version, expected_type=type_hints["version"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "vendor_name": vendor_name,
            }
            if excluded_rules is not None:
                self._values["excluded_rules"] = excluded_rules
            if managed_rule_group_configs is not None:
                self._values["managed_rule_group_configs"] = managed_rule_group_configs
            if rule_action_overrides is not None:
                self._values["rule_action_overrides"] = rule_action_overrides
            if scope_down_statement is not None:
                self._values["scope_down_statement"] = scope_down_statement
            if version is not None:
                self._values["version"] = version

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the managed rule group.

            You use this, along with the vendor name, to identify the rule group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def vendor_name(self) -> builtins.str:
            '''The name of the managed rule group vendor.

            You use this, along with the rule group name, to identify a rule group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-vendorname
            '''
            result = self._values.get("vendor_name")
            assert result is not None, "Required property 'vendor_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def excluded_rules(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ExcludedRuleProperty"]]]]:
            '''Rules in the referenced rule group whose actions are set to ``Count`` .

            .. epigraph::

               Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-excludedrules
            '''
            result = self._values.get("excluded_rules")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ExcludedRuleProperty"]]]], result)

        @builtins.property
        def managed_rule_group_configs(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ManagedRuleGroupConfigProperty"]]]]:
            '''Additional information that's used by a managed rule group. Many managed rule groups don't require this.

            Use the ``AWSManagedRulesATPRuleSet`` configuration object for the account takeover prevention managed rule group, to provide information such as the sign-in page of your application and the type of content to accept or reject from the client.

            Use the ``AWSManagedRulesBotControlRuleSet`` configuration object to configure the protection level that you want the Bot Control rule group to use.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-managedrulegroupconfigs
            '''
            result = self._values.get("managed_rule_group_configs")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ManagedRuleGroupConfigProperty"]]]], result)

        @builtins.property
        def rule_action_overrides(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionOverrideProperty"]]]]:
            '''Action settings to use in the place of the rule actions that are configured inside the rule group.

            You specify one override for each rule whose action you want to change.

            You can use overrides for testing, for example you can override all of rule actions to ``Count`` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-ruleactionoverrides
            '''
            result = self._values.get("rule_action_overrides")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionOverrideProperty"]]]], result)

        @builtins.property
        def scope_down_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]:
            '''An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group.

            Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-scopedownstatement
            '''
            result = self._values.get("scope_down_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]], result)

        @builtins.property
        def version(self) -> typing.Optional[builtins.str]:
            '''The version of the managed rule group to use.

            If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-version
            '''
            result = self._values.get("version")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ManagedRuleGroupStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.NotStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statement": "statement"},
    )
    class NotStatementProperty:
        def __init__(
            self,
            *,
            statement: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''A logical rule statement used to negate the results of another rule statement.

            You provide one ``Statement`` within the ``NotStatement`` .

            :param statement: The statement to negate. You can use any statement that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6323d964e28230f9d2649acc0c25b70ee57b1f6721b37df85848f3c969c544ff)
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statement": statement,
            }

        @builtins.property
        def statement(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]:
            '''The statement to negate.

            You can use any statement that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatement.html#cfn-wafv2-webacl-notstatement-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NotStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.OrStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class OrStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with OR logic.

            You provide more than one ``Statement`` within the ``OrStatement`` .

            :param statements: The statements to combine with OR logic. You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__857a9b37018dee0d151e0a05984b557cea8bf5f8e57f6957cacb75335b7f4985)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]]:
            '''The statements to combine with OR logic.

            You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatement.html#cfn-wafv2-webacl-orstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OrStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.OverrideActionProperty",
        jsii_struct_bases=[],
        name_mapping={"count": "count", "none": "none"},
    )
    class OverrideActionProperty:
        def __init__(
            self,
            *,
            count: typing.Any = None,
            none: typing.Any = None,
        ) -> None:
            '''The action to use in the place of the action that results from the rule group evaluation.

            Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only.

            You can only use this for rule statements that reference a rule group, like ``RuleGroupReferenceStatement`` and ``ManagedRuleGroupStatement`` .
            .. epigraph::

               This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with ``Count`` action, in your rule group reference statement settings.

            :param count: Override the rule group evaluation result to count only. .. epigraph:: This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with ``Count`` action, in your rule group reference statement settings.
            :param none: Don't override the rule group evaluation result. This is the most common setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # count: Any
                # none: Any
                
                override_action_property = wafv2.CfnWebACL.OverrideActionProperty(
                    count=count,
                    none=none
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__799e1b838f491914647df091fcbac72eb8119756fda0c013be732c4617a3fc77)
                check_type(argname="argument count", value=count, expected_type=type_hints["count"])
                check_type(argname="argument none", value=none, expected_type=type_hints["none"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if count is not None:
                self._values["count"] = count
            if none is not None:
                self._values["none"] = none

        @builtins.property
        def count(self) -> typing.Any:
            '''Override the rule group evaluation result to count only.

            .. epigraph::

               This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with ``Count`` action, in your rule group reference statement settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-count
            '''
            result = self._values.get("count")
            return typing.cast(typing.Any, result)

        @builtins.property
        def none(self) -> typing.Any:
            '''Don't override the rule group evaluation result.

            This is the most common setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-none
            '''
            result = self._values.get("none")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OverrideActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RateBasedStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aggregate_key_type": "aggregateKeyType",
            "limit": "limit",
            "forwarded_ip_config": "forwardedIpConfig",
            "scope_down_statement": "scopeDownStatement",
        },
    )
    class RateBasedStatementProperty:
        def __init__(
            self,
            *,
            aggregate_key_type: builtins.str,
            limit: jsii.Number,
            forwarded_ip_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            scope_down_statement: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.

            You can use this to put a temporary block on requests from an IP address that is sending excessive requests.

            AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .

            When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.

            You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:

            - An IP match statement with an IP set that specifies the address 192.0.2.44.
            - A string match statement that searches in the User-Agent header for the string BadBot.

            In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.

            You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.

            :param aggregate_key_type: Setting that indicates how to aggregate the request counts. The options are the following:. - ``IP`` - Aggregate the request counts on the IP address from the web request origin. - ``FORWARDED_IP`` - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the ``ForwardedIPConfig`` , to specify the header to use. .. epigraph:: You can only use the ``IP`` and ``FORWARDED_IP`` key types.
            :param limit: The limit on requests per 5-minute period for a single originating IP address. If the statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. This is required if you specify a forwarded IP in the rule's aggregate key settings.
            :param scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement. Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d49b8cc0c82261f5510afab04b955c5ca035f3eea109c82126189a502f868259)
                check_type(argname="argument aggregate_key_type", value=aggregate_key_type, expected_type=type_hints["aggregate_key_type"])
                check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
                check_type(argname="argument scope_down_statement", value=scope_down_statement, expected_type=type_hints["scope_down_statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "aggregate_key_type": aggregate_key_type,
                "limit": limit,
            }
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config
            if scope_down_statement is not None:
                self._values["scope_down_statement"] = scope_down_statement

        @builtins.property
        def aggregate_key_type(self) -> builtins.str:
            '''Setting that indicates how to aggregate the request counts. The options are the following:.

            - ``IP`` - Aggregate the request counts on the IP address from the web request origin.
            - ``FORWARDED_IP`` - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the ``ForwardedIPConfig`` , to specify the header to use.

            .. epigraph::

               You can only use the ``IP`` and ``FORWARDED_IP`` key types.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-aggregatekeytype
            '''
            result = self._values.get("aggregate_key_type")
            assert result is not None, "Required property 'aggregate_key_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def limit(self) -> jsii.Number:
            '''The limit on requests per 5-minute period for a single originating IP address.

            If the statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-limit
            '''
            result = self._values.get("limit")
            assert result is not None, "Required property 'limit' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ForwardedIPConfigurationProperty"]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This is required if you specify a forwarded IP in the rule's aggregate key settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ForwardedIPConfigurationProperty"]], result)

        @builtins.property
        def scope_down_statement(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]]:
            '''An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement.

            Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-scopedownstatement
            '''
            result = self._values.get("scope_down_statement")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateBasedStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RegexMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "regex_string": "regexString",
            "text_transformations": "textTransformations",
        },
    )
    class RegexMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            regex_string: builtins.str,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement used to search web request components for a match against a single regular expression.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param regex_string: The string representing the regular expression.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_match_statement_property = wafv2.CfnWebACL.RegexMatchStatementProperty(
                    field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnWebACL.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnWebACL.CookiesProperty(
                            match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnWebACL.HeadersProperty(
                            match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnWebACL.JsonBodyProperty(
                            match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    regex_string="regexString",
                    text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f56d815e9b33978239f84bdcfda0c264d936fd60828961424551075611c4a321)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument regex_string", value=regex_string, expected_type=type_hints["regex_string"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "regex_string": regex_string,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"], result)

        @builtins.property
        def regex_string(self) -> builtins.str:
            '''The string representing the regular expression.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-regexstring
            '''
            result = self._values.get("regex_string")
            assert result is not None, "Required property 'regex_string' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RegexPatternSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
        },
    )
    class RegexPatternSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement used to search web request components for matches with regular expressions.

            To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

            Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_pattern_set_reference_statement_property = wafv2.CfnWebACL.RegexPatternSetReferenceStatementProperty(
                    arn="arn",
                    field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnWebACL.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnWebACL.CookiesProperty(
                            match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnWebACL.HeadersProperty(
                            match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnWebACL.JsonBodyProperty(
                            match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__02b7d36560bfd4ed2bd6508818cf89b216972c719200032cdc4b3a04ea677b6c)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexPatternSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"default_size_inspection_limit": "defaultSizeInspectionLimit"},
    )
    class RequestBodyAssociatedResourceTypeConfigProperty:
        def __init__(self, *, default_size_inspection_limit: builtins.str) -> None:
            '''Customizes the maximum size of the request body that your protected CloudFront distributions forward to AWS WAF for inspection.

            The default size is 16 KB (16,384 kilobytes).
            .. epigraph::

               You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see `AWS WAF Pricing <https://docs.aws.amazon.com/waf/pricing/>`_ .

            This is used in the ``AssociationConfig`` of the web ACL.

            :param default_size_inspection_limit: Specifies the maximum size of the web request body component that an associated CloudFront distribution should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Default: ``16 KB (16,384 kilobytes)``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestbodyassociatedresourcetypeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                request_body_associated_resource_type_config_property = wafv2.CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty(
                    default_size_inspection_limit="defaultSizeInspectionLimit"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__22d5e10d054b4857a7983cdc47094a04c46a1c4d98b791e6c9aa5b16fe172d31)
                check_type(argname="argument default_size_inspection_limit", value=default_size_inspection_limit, expected_type=type_hints["default_size_inspection_limit"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "default_size_inspection_limit": default_size_inspection_limit,
            }

        @builtins.property
        def default_size_inspection_limit(self) -> builtins.str:
            '''Specifies the maximum size of the web request body component that an associated CloudFront distribution should send to AWS WAF for inspection.

            This applies to statements in the web ACL that inspect the body or JSON body.

            Default: ``16 KB (16,384 kilobytes)``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestbodyassociatedresourcetypeconfig.html#cfn-wafv2-webacl-requestbodyassociatedresourcetypeconfig-defaultsizeinspectionlimit
            '''
            result = self._values.get("default_size_inspection_limit")
            assert result is not None, "Required property 'default_size_inspection_limit' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RequestBodyAssociatedResourceTypeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RequestInspectionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "password_field": "passwordField",
            "payload_type": "payloadType",
            "username_field": "usernameField",
        },
    )
    class RequestInspectionProperty:
        def __init__(
            self,
            *,
            password_field: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
            payload_type: builtins.str,
            username_field: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]]],
        ) -> None:
            '''The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.

            This is part of the ``AWSManagedRulesATPRuleSet`` configuration in ``ManagedRuleGroupConfig`` .

            In these settings, you specify how your application accepts login attempts by providing the request payload type and the names of the fields within the request body where the username and password are provided.

            :param password_field: The name of the field in the request payload that contains your customer's password. How you specify this depends on the request inspection payload type. - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . For example, for the JSON payload ``{ "form": { "password": "THE_PASSWORD" } }`` , the password field specification is ``/form/password`` . - For form encoded payload types, use the HTML form names. For example, for an HTML form with the input element named ``password1`` , the password field specification is ``password1`` .
            :param payload_type: The payload type for your login endpoint, either JSON or form encoded.
            :param username_field: The name of the field in the request payload that contains your customer's username. How you specify this depends on the request inspection payload type. - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . For example, for the JSON payload ``{ "form": { "username": "THE_USERNAME" } }`` , the username field specification is ``/form/username`` . - For form encoded payload types, use the HTML form names. For example, for an HTML form with the input element named ``username1`` , the username field specification is ``username1``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                request_inspection_property = wafv2.CfnWebACL.RequestInspectionProperty(
                    password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    ),
                    payload_type="payloadType",
                    username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__631f6ce9c66767cd3623179821149ad0c9ae909f0dec5461d8df0ab22d67933e)
                check_type(argname="argument password_field", value=password_field, expected_type=type_hints["password_field"])
                check_type(argname="argument payload_type", value=payload_type, expected_type=type_hints["payload_type"])
                check_type(argname="argument username_field", value=username_field, expected_type=type_hints["username_field"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "password_field": password_field,
                "payload_type": payload_type,
                "username_field": username_field,
            }

        @builtins.property
        def password_field(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]:
            '''The name of the field in the request payload that contains your customer's password.

            How you specify this depends on the request inspection payload type.

            - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            For example, for the JSON payload ``{ "form": { "password": "THE_PASSWORD" } }`` , the password field specification is ``/form/password`` .

            - For form encoded payload types, use the HTML form names.

            For example, for an HTML form with the input element named ``password1`` , the password field specification is ``password1`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-passwordfield
            '''
            result = self._values.get("password_field")
            assert result is not None, "Required property 'password_field' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"], result)

        @builtins.property
        def payload_type(self) -> builtins.str:
            '''The payload type for your login endpoint, either JSON or form encoded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-payloadtype
            '''
            result = self._values.get("payload_type")
            assert result is not None, "Required property 'payload_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def username_field(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"]:
            '''The name of the field in the request payload that contains your customer's username.

            How you specify this depends on the request inspection payload type.

            - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            For example, for the JSON payload ``{ "form": { "username": "THE_USERNAME" } }`` , the username field specification is ``/form/username`` .

            - For form encoded payload types, use the HTML form names.

            For example, for an HTML form with the input element named ``username1`` , the username field specification is ``username1``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-usernamefield
            '''
            result = self._values.get("username_field")
            assert result is not None, "Required property 'username_field' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldIdentifierProperty"], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RequestInspectionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "failure_strings": "failureStrings",
            "success_strings": "successStrings",
        },
    )
    class ResponseInspectionBodyContainsProperty:
        def __init__(
            self,
            *,
            failure_strings: typing.Sequence[builtins.str],
            success_strings: typing.Sequence[builtins.str],
        ) -> None:
            '''Configures inspection of the response body.

            AWS WAF can inspect the first 65,536 bytes (64 KB) of the response body. This is part of the ``ResponseInspection`` configuration for ``AWSManagedRulesATPRuleSet`` .
            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            :param failure_strings: Strings in the body of the response that indicate a failed login attempt. To be counted as a failed login, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings. JSON example: ``"FailureStrings": [ "Login failed" ]``
            :param success_strings: Strings in the body of the response that indicate a successful login attempt. To be counted as a successful login, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings. JSON example: ``"SuccessStrings": [ "Login successful", "Welcome to our site!" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                response_inspection_body_contains_property = wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                    failure_strings=["failureStrings"],
                    success_strings=["successStrings"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__001cc1bea45335a1839e2b65a4dc717def05ad661440732523e578cc547c9cf6)
                check_type(argname="argument failure_strings", value=failure_strings, expected_type=type_hints["failure_strings"])
                check_type(argname="argument success_strings", value=success_strings, expected_type=type_hints["success_strings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "failure_strings": failure_strings,
                "success_strings": success_strings,
            }

        @builtins.property
        def failure_strings(self) -> typing.List[builtins.str]:
            '''Strings in the body of the response that indicate a failed login attempt.

            To be counted as a failed login, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.

            JSON example: ``"FailureStrings": [ "Login failed" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html#cfn-wafv2-webacl-responseinspectionbodycontains-failurestrings
            '''
            result = self._values.get("failure_strings")
            assert result is not None, "Required property 'failure_strings' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def success_strings(self) -> typing.List[builtins.str]:
            '''Strings in the body of the response that indicate a successful login attempt.

            To be counted as a successful login, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.

            JSON example: ``"SuccessStrings": [ "Login successful", "Welcome to our site!" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html#cfn-wafv2-webacl-responseinspectionbodycontains-successstrings
            '''
            result = self._values.get("success_strings")
            assert result is not None, "Required property 'success_strings' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResponseInspectionBodyContainsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={
            "failure_values": "failureValues",
            "name": "name",
            "success_values": "successValues",
        },
    )
    class ResponseInspectionHeaderProperty:
        def __init__(
            self,
            *,
            failure_values: typing.Sequence[builtins.str],
            name: builtins.str,
            success_values: typing.Sequence[builtins.str],
        ) -> None:
            '''Configures inspection of the response header. This is part of the ``ResponseInspection`` configuration for ``AWSManagedRulesATPRuleSet`` .

            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            :param failure_values: Values in the response header with the specified name that indicate a failed login attempt. To be counted as a failed login, the value must be an exact match, including case. Each value must be unique among the success and failure values. JSON example: ``"FailureValues": [ "LoginFailed", "Failed login" ]``
            :param name: The name of the header to match against. The name must be an exact match, including case. JSON example: ``"Name": [ "LoginResult" ]``
            :param success_values: Values in the response header with the specified name that indicate a successful login attempt. To be counted as a successful login, the value must be an exact match, including case. Each value must be unique among the success and failure values. JSON example: ``"SuccessValues": [ "LoginPassed", "Successful login" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                response_inspection_header_property = wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                    failure_values=["failureValues"],
                    name="name",
                    success_values=["successValues"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8d54bd2e1e87345845c47e4bcb710221a7b6cbb187011e8c4784202555b3ac63)
                check_type(argname="argument failure_values", value=failure_values, expected_type=type_hints["failure_values"])
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument success_values", value=success_values, expected_type=type_hints["success_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "failure_values": failure_values,
                "name": name,
                "success_values": success_values,
            }

        @builtins.property
        def failure_values(self) -> typing.List[builtins.str]:
            '''Values in the response header with the specified name that indicate a failed login attempt.

            To be counted as a failed login, the value must be an exact match, including case. Each value must be unique among the success and failure values.

            JSON example: ``"FailureValues": [ "LoginFailed", "Failed login" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-failurevalues
            '''
            result = self._values.get("failure_values")
            assert result is not None, "Required property 'failure_values' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the header to match against. The name must be an exact match, including case.

            JSON example: ``"Name": [ "LoginResult" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def success_values(self) -> typing.List[builtins.str]:
            '''Values in the response header with the specified name that indicate a successful login attempt.

            To be counted as a successful login, the value must be an exact match, including case. Each value must be unique among the success and failure values.

            JSON example: ``"SuccessValues": [ "LoginPassed", "Successful login" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-successvalues
            '''
            result = self._values.get("success_values")
            assert result is not None, "Required property 'success_values' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResponseInspectionHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionJsonProperty",
        jsii_struct_bases=[],
        name_mapping={
            "failure_values": "failureValues",
            "identifier": "identifier",
            "success_values": "successValues",
        },
    )
    class ResponseInspectionJsonProperty:
        def __init__(
            self,
            *,
            failure_values: typing.Sequence[builtins.str],
            identifier: builtins.str,
            success_values: typing.Sequence[builtins.str],
        ) -> None:
            '''Configures inspection of the response JSON.

            AWS WAF can inspect the first 65,536 bytes (64 KB) of the response JSON. This is part of the ``ResponseInspection`` configuration for ``AWSManagedRulesATPRuleSet`` .
            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            :param failure_values: Values for the specified identifier in the response JSON that indicate a failed login attempt. To be counted as a failed login, the value must be an exact match, including case. Each value must be unique among the success and failure values. JSON example: ``"FailureValues": [ "False", "Failed" ]``
            :param identifier: The identifier for the value to match against in the JSON. The identifier must be an exact match, including case. JSON example: ``"Identifier": [ "/login/success" ]``
            :param success_values: Values for the specified identifier in the response JSON that indicate a successful login attempt. To be counted as a successful login, the value must be an exact match, including case. Each value must be unique among the success and failure values. JSON example: ``"SuccessValues": [ "True", "Succeeded" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionjson.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                response_inspection_json_property = wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                    failure_values=["failureValues"],
                    identifier="identifier",
                    success_values=["successValues"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4c8f4d0b86cce16d0934a1e63472a5a0e9dc97d26d5dfdfd5fa65ff1a78d89ca)
                check_type(argname="argument failure_values", value=failure_values, expected_type=type_hints["failure_values"])
                check_type(argname="argument identifier", value=identifier, expected_type=type_hints["identifier"])
                check_type(argname="argument success_values", value=success_values, expected_type=type_hints["success_values"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "failure_values": failure_values,
                "identifier": identifier,
                "success_values": success_values,
            }

        @builtins.property
        def failure_values(self) -> typing.List[builtins.str]:
            '''Values for the specified identifier in the response JSON that indicate a failed login attempt.

            To be counted as a failed login, the value must be an exact match, including case. Each value must be unique among the success and failure values.

            JSON example: ``"FailureValues": [ "False", "Failed" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionjson.html#cfn-wafv2-webacl-responseinspectionjson-failurevalues
            '''
            result = self._values.get("failure_values")
            assert result is not None, "Required property 'failure_values' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def identifier(self) -> builtins.str:
            '''The identifier for the value to match against in the JSON.

            The identifier must be an exact match, including case.

            JSON example: ``"Identifier": [ "/login/success" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionjson.html#cfn-wafv2-webacl-responseinspectionjson-identifier
            '''
            result = self._values.get("identifier")
            assert result is not None, "Required property 'identifier' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def success_values(self) -> typing.List[builtins.str]:
            '''Values for the specified identifier in the response JSON that indicate a successful login attempt.

            To be counted as a successful login, the value must be an exact match, including case. Each value must be unique among the success and failure values.

            JSON example: ``"SuccessValues": [ "True", "Succeeded" ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionjson.html#cfn-wafv2-webacl-responseinspectionjson-successvalues
            '''
            result = self._values.get("success_values")
            assert result is not None, "Required property 'success_values' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResponseInspectionJsonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "body_contains": "bodyContains",
            "header": "header",
            "json": "json",
            "status_code": "statusCode",
        },
    )
    class ResponseInspectionProperty:
        def __init__(
            self,
            *,
            body_contains: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ResponseInspectionBodyContainsProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            header: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ResponseInspectionHeaderProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            json: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ResponseInspectionJsonProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            status_code: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ResponseInspectionStatusCodeProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.

            The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that submit too many failed login attempts in a short amount of time.
            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            This is part of the ``AWSManagedRulesATPRuleSet`` configuration in ``ManagedRuleGroupConfig`` .

            Enable login response inspection by configuring exactly one component of the response to inspect. You can't configure more than one. If you don't configure any of the response inspection options, response inspection is disabled.

            :param body_contains: Configures inspection of the response body. AWS WAF can inspect the first 65,536 bytes (64 KB) of the response body.
            :param header: Configures inspection of the response header.
            :param json: Configures inspection of the response JSON. AWS WAF can inspect the first 65,536 bytes (64 KB) of the response JSON.
            :param status_code: Configures inspection of the response status code.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspection.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                response_inspection_property = wafv2.CfnWebACL.ResponseInspectionProperty(
                    body_contains=wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty(
                        failure_strings=["failureStrings"],
                        success_strings=["successStrings"]
                    ),
                    header=wafv2.CfnWebACL.ResponseInspectionHeaderProperty(
                        failure_values=["failureValues"],
                        name="name",
                        success_values=["successValues"]
                    ),
                    json=wafv2.CfnWebACL.ResponseInspectionJsonProperty(
                        failure_values=["failureValues"],
                        identifier="identifier",
                        success_values=["successValues"]
                    ),
                    status_code=wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                        failure_codes=[123],
                        success_codes=[123]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4ddbef3844830b496ad1d72cde0d99675c920f03c7933a56098772df1999c3d7)
                check_type(argname="argument body_contains", value=body_contains, expected_type=type_hints["body_contains"])
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
                check_type(argname="argument json", value=json, expected_type=type_hints["json"])
                check_type(argname="argument status_code", value=status_code, expected_type=type_hints["status_code"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if body_contains is not None:
                self._values["body_contains"] = body_contains
            if header is not None:
                self._values["header"] = header
            if json is not None:
                self._values["json"] = json
            if status_code is not None:
                self._values["status_code"] = status_code

        @builtins.property
        def body_contains(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionBodyContainsProperty"]]:
            '''Configures inspection of the response body.

            AWS WAF can inspect the first 65,536 bytes (64 KB) of the response body.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspection.html#cfn-wafv2-webacl-responseinspection-bodycontains
            '''
            result = self._values.get("body_contains")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionBodyContainsProperty"]], result)

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionHeaderProperty"]]:
            '''Configures inspection of the response header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspection.html#cfn-wafv2-webacl-responseinspection-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionHeaderProperty"]], result)

        @builtins.property
        def json(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionJsonProperty"]]:
            '''Configures inspection of the response JSON.

            AWS WAF can inspect the first 65,536 bytes (64 KB) of the response JSON.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspection.html#cfn-wafv2-webacl-responseinspection-json
            '''
            result = self._values.get("json")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionJsonProperty"]], result)

        @builtins.property
        def status_code(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionStatusCodeProperty"]]:
            '''Configures inspection of the response status code.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspection.html#cfn-wafv2-webacl-responseinspection-statuscode
            '''
            result = self._values.get("status_code")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ResponseInspectionStatusCodeProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResponseInspectionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty",
        jsii_struct_bases=[],
        name_mapping={
            "failure_codes": "failureCodes",
            "success_codes": "successCodes",
        },
    )
    class ResponseInspectionStatusCodeProperty:
        def __init__(
            self,
            *,
            failure_codes: typing.Union[typing.Sequence[jsii.Number], _IResolvable_da3f097b],
            success_codes: typing.Union[typing.Sequence[jsii.Number], _IResolvable_da3f097b],
        ) -> None:
            '''Configures inspection of the response status code. This is part of the ``ResponseInspection`` configuration for ``AWSManagedRulesATPRuleSet`` .

            .. epigraph::

               Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.

            :param failure_codes: Status codes in the response that indicate a failed login attempt. To be counted as a failed login, the response status code must match one of these. Each code must be unique among the success and failure status codes. JSON example: ``"FailureCodes": [ 400, 404 ]``
            :param success_codes: Status codes in the response that indicate a successful login attempt. To be counted as a successful login, the response status code must match one of these. Each code must be unique among the success and failure status codes. JSON example: ``"SuccessCodes": [ 200, 201 ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionstatuscode.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                response_inspection_status_code_property = wafv2.CfnWebACL.ResponseInspectionStatusCodeProperty(
                    failure_codes=[123],
                    success_codes=[123]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__70e5eb2335449e4aaf1d16dd8f72fb62a6461b897d7c2ffdd01ebbb739e22822)
                check_type(argname="argument failure_codes", value=failure_codes, expected_type=type_hints["failure_codes"])
                check_type(argname="argument success_codes", value=success_codes, expected_type=type_hints["success_codes"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "failure_codes": failure_codes,
                "success_codes": success_codes,
            }

        @builtins.property
        def failure_codes(
            self,
        ) -> typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]:
            '''Status codes in the response that indicate a failed login attempt.

            To be counted as a failed login, the response status code must match one of these. Each code must be unique among the success and failure status codes.

            JSON example: ``"FailureCodes": [ 400, 404 ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionstatuscode.html#cfn-wafv2-webacl-responseinspectionstatuscode-failurecodes
            '''
            result = self._values.get("failure_codes")
            assert result is not None, "Required property 'failure_codes' is missing"
            return typing.cast(typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b], result)

        @builtins.property
        def success_codes(
            self,
        ) -> typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b]:
            '''Status codes in the response that indicate a successful login attempt.

            To be counted as a successful login, the response status code must match one of these. Each code must be unique among the success and failure status codes.

            JSON example: ``"SuccessCodes": [ 200, 201 ]``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionstatuscode.html#cfn-wafv2-webacl-responseinspectionstatuscode-successcodes
            '''
            result = self._values.get("success_codes")
            assert result is not None, "Required property 'success_codes' is missing"
            return typing.cast(typing.Union[typing.List[jsii.Number], _IResolvable_da3f097b], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResponseInspectionStatusCodeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RuleActionOverrideProperty",
        jsii_struct_bases=[],
        name_mapping={"action_to_use": "actionToUse", "name": "name"},
    )
    class RuleActionOverrideProperty:
        def __init__(
            self,
            *,
            action_to_use: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RuleActionProperty", typing.Dict[builtins.str, typing.Any]]],
            name: builtins.str,
        ) -> None:
            '''Action setting to use in the place of a rule action that is configured inside the rule group.

            You specify one override for each rule whose action you want to change.

            You can use overrides for testing, for example you can override all of rule actions to ``Count`` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.

            :param action_to_use: The override action to use, in place of the configured action of the rule in the rule group.
            :param name: The name of the rule to override.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleactionoverride.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rule_action_override_property = wafv2.CfnWebACL.RuleActionOverrideProperty(
                    action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                        allow=wafv2.CfnWebACL.AllowActionProperty(
                            custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                    name="name",
                                    value="value"
                                )]
                            )
                        ),
                        block=wafv2.CfnWebACL.BlockActionProperty(
                            custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                response_code=123,
                
                                # the properties below are optional
                                custom_response_body_key="customResponseBodyKey",
                                response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                    name="name",
                                    value="value"
                                )]
                            )
                        ),
                        captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                            custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                    name="name",
                                    value="value"
                                )]
                            )
                        ),
                        challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                            custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                    name="name",
                                    value="value"
                                )]
                            )
                        ),
                        count=wafv2.CfnWebACL.CountActionProperty(
                            custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                    name="name",
                                    value="value"
                                )]
                            )
                        )
                    ),
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__182c43a8a56146dc87ca7f6b548113467168c3a59b5063a4ea96c90cdce24dd5)
                check_type(argname="argument action_to_use", value=action_to_use, expected_type=type_hints["action_to_use"])
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "action_to_use": action_to_use,
                "name": name,
            }

        @builtins.property
        def action_to_use(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionProperty"]:
            '''The override action to use, in place of the configured action of the rule in the rule group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleactionoverride.html#cfn-wafv2-webacl-ruleactionoverride-actiontouse
            '''
            result = self._values.get("action_to_use")
            assert result is not None, "Required property 'action_to_use' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionProperty"], result)

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule to override.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleactionoverride.html#cfn-wafv2-webacl-ruleactionoverride-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleActionOverrideProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RuleActionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allow": "allow",
            "block": "block",
            "captcha": "captcha",
            "challenge": "challenge",
            "count": "count",
        },
    )
    class RuleActionProperty:
        def __init__(
            self,
            *,
            allow: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.AllowActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            block: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.BlockActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            captcha: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CaptchaActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            challenge: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ChallengeActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            count: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CountActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
        ) -> None:
            '''The action that AWS WAF should take on a web request when it matches a rule's statement.

            Settings at the web ACL level can override the rule action setting.

            :param allow: Instructs AWS WAF to allow the web request.
            :param block: Instructs AWS WAF to block the web request.
            :param captcha: Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:. - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` . - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination. AWS WAF generates a response that it sends back to the client, which includes the following: - The header ``x-amzn-waf-action`` with a value of ``captcha`` . - The HTTP status code ``405 Method Not Allowed`` . - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge. You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting. This action option is available for rules. It isn't available for web ACL default actions.
            :param challenge: Instructs AWS WAF to run a ``Challenge`` check against the web request.
            :param count: Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rule_action_property = wafv2.CfnWebACL.RuleActionProperty(
                    allow=wafv2.CfnWebACL.AllowActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    block=wafv2.CfnWebACL.BlockActionProperty(
                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                            response_code=123,
                
                            # the properties below are optional
                            custom_response_body_key="customResponseBodyKey",
                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    count=wafv2.CfnWebACL.CountActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__baf6edb4c818930b2402022177da307d779bfdc03cd1e96dc76af277a102677e)
                check_type(argname="argument allow", value=allow, expected_type=type_hints["allow"])
                check_type(argname="argument block", value=block, expected_type=type_hints["block"])
                check_type(argname="argument captcha", value=captcha, expected_type=type_hints["captcha"])
                check_type(argname="argument challenge", value=challenge, expected_type=type_hints["challenge"])
                check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if allow is not None:
                self._values["allow"] = allow
            if block is not None:
                self._values["block"] = block
            if captcha is not None:
                self._values["captcha"] = captcha
            if challenge is not None:
                self._values["challenge"] = challenge
            if count is not None:
                self._values["count"] = count

        @builtins.property
        def allow(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AllowActionProperty"]]:
            '''Instructs AWS WAF to allow the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-allow
            '''
            result = self._values.get("allow")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.AllowActionProperty"]], result)

        @builtins.property
        def block(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BlockActionProperty"]]:
            '''Instructs AWS WAF to block the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-block
            '''
            result = self._values.get("block")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.BlockActionProperty"]], result)

        @builtins.property
        def captcha(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaActionProperty"]]:
            '''Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:.

            - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .
            - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF generates a response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``captcha`` .
            - The HTTP status code ``405 Method Not Allowed`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge.

            You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-captcha
            '''
            result = self._values.get("captcha")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaActionProperty"]], result)

        @builtins.property
        def challenge(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeActionProperty"]]:
            '''Instructs AWS WAF to run a ``Challenge`` check against the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-challenge
            '''
            result = self._values.get("challenge")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeActionProperty"]], result)

        @builtins.property
        def count(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CountActionProperty"]]:
            '''Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-count
            '''
            result = self._values.get("count")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CountActionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RuleGroupReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "excluded_rules": "excludedRules",
            "rule_action_overrides": "ruleActionOverrides",
        },
    )
    class RuleGroupReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            excluded_rules: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ExcludedRuleProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
            rule_action_overrides: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RuleActionOverrideProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A rule statement used to run the rules that are defined in a ``RuleGroup`` .

            To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.

            You cannot nest a ``RuleGroupReferenceStatement`` , for example for use inside a ``NotStatement`` or ``OrStatement`` . You can only use a rule group reference statement at the top level inside a web ACL.

            :param arn: The Amazon Resource Name (ARN) of the entity.
            :param excluded_rules: Rules in the referenced rule group whose actions are set to ``Count`` . .. epigraph:: Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .
            :param rule_action_overrides: Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. You can use overrides for testing, for example you can override all of rule actions to ``Count`` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rulegroupreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                rule_group_reference_statement_property = wafv2.CfnWebACL.RuleGroupReferenceStatementProperty(
                    arn="arn",
                
                    # the properties below are optional
                    excluded_rules=[wafv2.CfnWebACL.ExcludedRuleProperty(
                        name="name"
                    )],
                    rule_action_overrides=[wafv2.CfnWebACL.RuleActionOverrideProperty(
                        action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                            allow=wafv2.CfnWebACL.AllowActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            block=wafv2.CfnWebACL.BlockActionProperty(
                                custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                    response_code=123,
                
                                    # the properties below are optional
                                    custom_response_body_key="customResponseBodyKey",
                                    response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            count=wafv2.CfnWebACL.CountActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            )
                        ),
                        name="name"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__33b5d438698608680e25769b62d185cf716504c9a2cc9d46167b82f1a0d3cc10)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument excluded_rules", value=excluded_rules, expected_type=type_hints["excluded_rules"])
                check_type(argname="argument rule_action_overrides", value=rule_action_overrides, expected_type=type_hints["rule_action_overrides"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
            }
            if excluded_rules is not None:
                self._values["excluded_rules"] = excluded_rules
            if rule_action_overrides is not None:
                self._values["rule_action_overrides"] = rule_action_overrides

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the entity.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rulegroupreferencestatement.html#cfn-wafv2-webacl-rulegroupreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def excluded_rules(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ExcludedRuleProperty"]]]]:
            '''Rules in the referenced rule group whose actions are set to ``Count`` .

            .. epigraph::

               Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rulegroupreferencestatement.html#cfn-wafv2-webacl-rulegroupreferencestatement-excludedrules
            '''
            result = self._values.get("excluded_rules")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ExcludedRuleProperty"]]]], result)

        @builtins.property
        def rule_action_overrides(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionOverrideProperty"]]]]:
            '''Action settings to use in the place of the rule actions that are configured inside the rule group.

            You specify one override for each rule whose action you want to change.

            You can use overrides for testing, for example you can override all of rule actions to ``Count`` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rulegroupreferencestatement.html#cfn-wafv2-webacl-rulegroupreferencestatement-ruleactionoverrides
            '''
            result = self._values.get("rule_action_overrides")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionOverrideProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleGroupReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.RuleProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "priority": "priority",
            "statement": "statement",
            "visibility_config": "visibilityConfig",
            "action": "action",
            "captcha_config": "captchaConfig",
            "challenge_config": "challengeConfig",
            "override_action": "overrideAction",
            "rule_labels": "ruleLabels",
        },
    )
    class RuleProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            priority: jsii.Number,
            statement: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]]],
            visibility_config: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]]],
            action: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.RuleActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            captcha_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.CaptchaConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            challenge_config: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.ChallengeConfigProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            override_action: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.OverrideActionProperty", typing.Dict[builtins.str, typing.Any]]]] = None,
            rule_labels: typing.Optional[typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.LabelProperty", typing.Dict[builtins.str, typing.Any]]]]]] = None,
        ) -> None:
            '''A single rule, which you can use in a ``WebACL`` or ``RuleGroup`` to identify web requests that you want to allow, block, or count.

            Each rule includes one top-level ``Statement`` that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

            :param name: The name of the rule. You can't change the name of a ``Rule`` after you create it.
            :param priority: If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
            :param statement: The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .
            :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
            :param action: The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the web ACL level can override the rule action setting. This is used only for rules whose statements don't reference a rule group. Rule statements that reference a rule group are ``RuleGroupReferenceStatement`` and ``ManagedRuleGroupStatement`` . You must set either this ``Action`` setting or the rule's ``OverrideAction`` , but not both: - If the rule statement doesn't reference a rule group, you must set this rule action setting and you must not set the rule's override action setting. - If the rule statement references a rule group, you must not set this action setting, because the actions are already set on the rules inside the rule group. You must set the rule's override action setting to indicate specifically whether to override the actions that are set on the rules in the rule group.
            :param captcha_config: Specifies how AWS WAF should handle ``CAPTCHA`` evaluations. If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.
            :param challenge_config: Specifies how AWS WAF should handle ``Challenge`` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
            :param override_action: The override action to apply to the rules in a rule group, instead of the individual rule action settings. This is used only for rules whose statements reference a rule group. Rule statements that reference a rule group are ``RuleGroupReferenceStatement`` and ``ManagedRuleGroupStatement`` . Set the override action to none to leave the rule group rule actions in effect. Set it to count to only count matches, regardless of the rule action settings. You must set either this ``OverrideAction`` setting or the ``Action`` setting, but not both: - If the rule statement references a rule group, you must set this override action setting and you must not set the rule's action setting. - If the rule statement doesn't reference a rule group, you must set the rule action setting and you must not set the rule's override action setting.
            :param rule_labels: Labels to apply to web requests that match the rule match statement. AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace. Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` . For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines: - Separate each component of the label with a colon. - Each namespace or name can have up to 128 characters. - You can specify up to 5 namespaces in a label. - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` . For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html
            :exampleMetadata: fixture=_generated

            Example::

                
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__adb0f551b9c5ed78bb47ec68c5dbb11522502d873137543511b73ff137005571)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
                check_type(argname="argument visibility_config", value=visibility_config, expected_type=type_hints["visibility_config"])
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
                check_type(argname="argument captcha_config", value=captcha_config, expected_type=type_hints["captcha_config"])
                check_type(argname="argument challenge_config", value=challenge_config, expected_type=type_hints["challenge_config"])
                check_type(argname="argument override_action", value=override_action, expected_type=type_hints["override_action"])
                check_type(argname="argument rule_labels", value=rule_labels, expected_type=type_hints["rule_labels"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "priority": priority,
                "statement": statement,
                "visibility_config": visibility_config,
            }
            if action is not None:
                self._values["action"] = action
            if captcha_config is not None:
                self._values["captcha_config"] = captcha_config
            if challenge_config is not None:
                self._values["challenge_config"] = challenge_config
            if override_action is not None:
                self._values["override_action"] = override_action
            if rule_labels is not None:
                self._values["rule_labels"] = rule_labels

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule.

            You can't change the name of a ``Rule`` after you create it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def priority(self) -> jsii.Number:
            '''If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` .

            AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-priority
            '''
            result = self._values.get("priority")
            assert result is not None, "Required property 'priority' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def statement(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"]:
            '''The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.StatementProperty"], result)

        @builtins.property
        def visibility_config(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"]:
            '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-visibilityconfig
            '''
            result = self._values.get("visibility_config")
            assert result is not None, "Required property 'visibility_config' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.VisibilityConfigProperty"], result)

        @builtins.property
        def action(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionProperty"]]:
            '''The action that AWS WAF should take on a web request when it matches the rule's statement.

            Settings at the web ACL level can override the rule action setting.

            This is used only for rules whose statements don't reference a rule group. Rule statements that reference a rule group are ``RuleGroupReferenceStatement`` and ``ManagedRuleGroupStatement`` .

            You must set either this ``Action`` setting or the rule's ``OverrideAction`` , but not both:

            - If the rule statement doesn't reference a rule group, you must set this rule action setting and you must not set the rule's override action setting.
            - If the rule statement references a rule group, you must not set this action setting, because the actions are already set on the rules inside the rule group. You must set the rule's override action setting to indicate specifically whether to override the actions that are set on the rules in the rule group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-action
            '''
            result = self._values.get("action")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.RuleActionProperty"]], result)

        @builtins.property
        def captcha_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]]:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations.

            If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-captchaconfig
            '''
            result = self._values.get("captcha_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.CaptchaConfigProperty"]], result)

        @builtins.property
        def challenge_config(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]]:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-challengeconfig
            '''
            result = self._values.get("challenge_config")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.ChallengeConfigProperty"]], result)

        @builtins.property
        def override_action(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.OverrideActionProperty"]]:
            '''The override action to apply to the rules in a rule group, instead of the individual rule action settings.

            This is used only for rules whose statements reference a rule group. Rule statements that reference a rule group are ``RuleGroupReferenceStatement`` and ``ManagedRuleGroupStatement`` .

            Set the override action to none to leave the rule group rule actions in effect. Set it to count to only count matches, regardless of the rule action settings.

            You must set either this ``OverrideAction`` setting or the ``Action`` setting, but not both:

            - If the rule statement references a rule group, you must set this override action setting and you must not set the rule's action setting.
            - If the rule statement doesn't reference a rule group, you must set the rule action setting and you must not set the rule's override action setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-overrideaction
            '''
            result = self._values.get("override_action")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, "CfnWebACL.OverrideActionProperty"]], result)

        @builtins.property
        def rule_labels(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.LabelProperty"]]]]:
            '''Labels to apply to web requests that match the rule match statement.

            AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.

            Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` .

            For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:

            - Separate each component of the label with a colon.
            - Each namespace or name can have up to 128 characters.
            - You can specify up to 5 namespaces in a label.
            - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` .

            For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-rulelabels
            '''
            result = self._values.get("rule_labels")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.LabelProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.SingleHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleHeaderProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one of the headers in the web request, identified by name, for example, ``User-Agent`` or ``Referer`` .

            The name isn't case sensitive.

            You can filter and inspect all headers with the ``FieldToMatch`` setting ``Headers`` .

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :param name: The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-singleheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_header_property = wafv2.CfnWebACL.SingleHeaderProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__59f1942433fae4b7a98a44e7ab49d20f04fe64f17348211bc3aa8962e367a7f3)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-singleheader.html#cfn-wafv2-webacl-singleheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.SingleQueryArgumentProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleQueryArgumentProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one query argument in the web request, identified by name, for example *UserName* or *SalesRegion* .

            The name isn't case sensitive.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :param name: The name of the query argument to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-singlequeryargument.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                single_query_argument_property = wafv2.CfnWebACL.SingleQueryArgumentProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__04843ba647f7cf72b2882159194765344c68c485434432f8b9cd43b2c26d2bed)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query argument to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-singlequeryargument.html#cfn-wafv2-webacl-singlequeryargument-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleQueryArgumentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.SizeConstraintStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "comparison_operator": "comparisonOperator",
            "field_to_match": "fieldToMatch",
            "size": "size",
            "text_transformations": "textTransformations",
        },
    )
    class SizeConstraintStatementProperty:
        def __init__(
            self,
            *,
            comparison_operator: builtins.str,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            size: jsii.Number,
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
        ) -> None:
            '''A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).

            For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

            If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes of the body up to the limit for the web ACL. By default, for regional web ACLs, this limit is 8 KB (8,192 kilobytes) and for CloudFront web ACLs, this limit is 16 KB (16,384 kilobytes). For CloudFront web ACLs, you can increase the limit in the web ACL ``AssociationConfig`` , for additional fees. If you know that the request body for your web requests should never exceed the inspection limit, you could use a size constraint statement to block requests that have a larger request body size.

            If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.

            :param comparison_operator: The operator to use to compare the request part to the size setting.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param size: The size, in byte, to compare to the request part, after any transformations.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                size_constraint_statement_property = wafv2.CfnWebACL.SizeConstraintStatementProperty(
                    comparison_operator="comparisonOperator",
                    field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnWebACL.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnWebACL.CookiesProperty(
                            match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnWebACL.HeadersProperty(
                            match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnWebACL.JsonBodyProperty(
                            match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    size=123,
                    text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__865b49e379fa7b3164d1c8e64243430f9e779fe36a4a5e82ae22f64065827d86)
                check_type(argname="argument comparison_operator", value=comparison_operator, expected_type=type_hints["comparison_operator"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument size", value=size, expected_type=type_hints["size"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "comparison_operator": comparison_operator,
                "field_to_match": field_to_match,
                "size": size,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def comparison_operator(self) -> builtins.str:
            '''The operator to use to compare the request part to the size setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-comparisonoperator
            '''
            result = self._values.get("comparison_operator")
            assert result is not None, "Required property 'comparison_operator' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, "CfnWebACL.FieldToMatchProperty"], result)

        @builtins.property
        def size(self) -> jsii.Number:
            '''The size, in byte, to compare to the request part, after any transformations.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-size
            '''
            result = self._values.get("size")
            assert result is not None, "Required property 'size' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_da3f097b, typing.List[typing.Union[_IResolvable_da3f097b, "CfnWebACL.TextTransformationProperty"]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SizeConstraintStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="aws-cdk-lib.aws_wafv2.CfnWebACL.SqliMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
            "sensitivity_level": "sensitivityLevel",
        },
    )
    class SqliMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]]],
            text_transformations: typing.Union[_IResolvable_da3f097b, typing.Sequence[typing.Union[_IResolvable_da3f097b, typing.Union["CfnWebACL.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]]]]],
            sensitivity_level: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that inspects for malicious SQL code.

            Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param sensitivity_level: The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. ``HIGH`` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see `Testing and tuning <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html>`_ in the *AWS WAF Developer Guide* . ``LOW`` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives. Default: ``LOW``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sqlimatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from aws_cdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                sqli_match_statement_property = wafv2.CfnWebACL.SqliMatchStatementProperty(
                    field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnWebACL.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnWebACL.CookiesProperty(
                            match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnWebACL.HeadersProperty(
                            match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body