"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CognitoUserPoolsAuthorizer=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),core_1=require("../../../core"),cx_api_1=require("../../../cx-api"),apigateway_generated_1=require("../apigateway.generated"),authorizer_1=require("../authorizer"),method_1=require("../method");class CognitoUserPoolsAuthorizer extends authorizer_1.Authorizer{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_CognitoUserPoolsAuthorizerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CognitoUserPoolsAuthorizer),error}const restApiId=this.lazyRestApiId(),authorizerProps={name:props.authorizerName??core_1.Names.uniqueId(this),restApiId,type:"COGNITO_USER_POOLS",providerArns:props.cognitoUserPools.map(userPool=>userPool.userPoolArn),authorizerResultTtlInSeconds:props.resultsCacheTtl?.toSeconds(),identitySource:props.identitySource||"method.request.header.Authorization"};this.authorizerProps=authorizerProps;const resource=new apigateway_generated_1.CfnAuthorizer(this,"Resource",authorizerProps);this.authorizerId=resource.ref,this.authorizerArn=core_1.Stack.of(this).formatArn({service:"execute-api",resource:restApiId,resourceName:`authorizers/${this.authorizerId}`}),this.authorizationType=method_1.AuthorizationType.COGNITO}_attachToApi(restApi){if(this.restApiId&&this.restApiId!==restApi.restApiId)throw new Error("Cannot attach authorizer to two different rest APIs");this.restApiId=restApi.restApiId;const addToLogicalId=core_1.FeatureFlags.of(this).isEnabled(cx_api_1.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID),deployment=restApi.latestDeployment;deployment&&addToLogicalId&&(deployment.node.addDependency(this),deployment.addToLogicalId({authorizer:this.authorizerProps}))}lazyRestApiId(){return core_1.Lazy.string({produce:()=>{if(!this.restApiId)throw new Error(`Authorizer (${this.node.path}) must be attached to a RestApi`);return this.restApiId}})}}_a=JSII_RTTI_SYMBOL_1,CognitoUserPoolsAuthorizer[_a]={fqn:"aws-cdk-lib.aws_apigateway.CognitoUserPoolsAuthorizer",version:"2.87.0"},exports.CognitoUserPoolsAuthorizer=CognitoUserPoolsAuthorizer;
