"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.AuthorizationType=exports.Method=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),constructs_1=require("constructs"),apigateway_canned_metrics_generated_1=require("./apigateway-canned-metrics.generated"),apigateway_generated_1=require("./apigateway.generated"),authorizer_1=require("./authorizer"),mock_1=require("./integrations/mock"),restapi_1=require("./restapi"),util_1=require("./util"),cloudwatch=require("../../aws-cloudwatch"),iam=require("../../aws-iam"),core_1=require("../../core"),cx_api_1=require("../../cx-api");class Method extends core_1.Resource{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_MethodProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Method),error}this.resource=props.resource,this.api=props.resource.api,this.httpMethod=props.httpMethod.toUpperCase(),(0,util_1.validateHttpMethod)(this.httpMethod);const options=props.options||{},defaultMethodOptions=props.resource.defaultMethodOptions||{},authorizer=options.authorizer||defaultMethodOptions.authorizer,authorizerId=authorizer?.authorizerId?authorizer.authorizerId:void 0,authorizationTypeOption=options.authorizationType||defaultMethodOptions.authorizationType,authorizationType=authorizer?.authorizationType||authorizationTypeOption||AuthorizationType.NONE;if(authorizer?.authorizationType&&authorizationTypeOption&&authorizer?.authorizationType!==authorizationTypeOption)throw new Error(`${this.resource}/${this.httpMethod} - Authorization type is set to ${authorizationTypeOption} which is different from what is required by the authorizer [${authorizer.authorizationType}]`);authorizer_1.Authorizer.isAuthorizer(authorizer)&&authorizer._attachToApi(this.api),this.methodResponses=options.methodResponses??[];const bindResult=(props.integration??this.resource.defaultIntegration??new mock_1.MockIntegration).bind(this),methodProps={resourceId:props.resource.resourceId,restApiId:this.api.restApiId,httpMethod:this.httpMethod,operationName:options.operationName||defaultMethodOptions.operationName,apiKeyRequired:options.apiKeyRequired??defaultMethodOptions.apiKeyRequired,authorizationType,authorizerId,requestParameters:options.requestParameters||defaultMethodOptions.requestParameters,integration:this.renderIntegration(bindResult),methodResponses:core_1.Lazy.any({produce:()=>this.renderMethodResponses(this.methodResponses)},{omitEmptyArray:!0}),requestModels:this.renderRequestModels(options.requestModels),requestValidatorId:this.requestValidatorId(options),authorizationScopes:options.authorizationScopes??defaultMethodOptions.authorizationScopes},resource=new apigateway_generated_1.CfnMethod(this,"Resource",methodProps);this.methodId=resource.ref,restapi_1.RestApiBase._isRestApiBase(props.resource.api)&&props.resource.api._attachMethod(this);const deployment=props.resource.api.latestDeployment;deployment&&(deployment.node.addDependency(resource),deployment.addToLogicalId({method:{...methodProps,integrationToken:bindResult?.deploymentToken}}))}get restApi(){return this.resource.restApi}get methodArn(){const stage=this.api.deploymentStage?.stageName;return this.api.arnForExecuteApi(this.httpMethod,pathForArn(this.resource.path),stage)}get testMethodArn(){return this.api.arnForExecuteApi(this.httpMethod,pathForArn(this.resource.path),"test-invoke-stage")}addMethodResponse(methodResponse){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_MethodResponse(methodResponse)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addMethodResponse),error}this.methodResponses.push(methodResponse)}renderIntegration(bindResult){const options=bindResult.options??{};let credentials;return options.credentialsRole?credentials=options.credentialsRole.roleArn:options.credentialsPassthrough&&(credentials=core_1.Stack.of(this).formatArn({service:"iam",region:"",account:"*",resource:"user",arnFormat:core_1.ArnFormat.SLASH_RESOURCE_NAME,resourceName:"*"})),{type:bindResult.type,uri:bindResult.uri,cacheKeyParameters:options.cacheKeyParameters,cacheNamespace:options.cacheNamespace,contentHandling:options.contentHandling,integrationHttpMethod:bindResult.integrationHttpMethod,requestParameters:options.requestParameters,requestTemplates:options.requestTemplates,passthroughBehavior:options.passthroughBehavior,integrationResponses:options.integrationResponses,connectionType:options.connectionType,connectionId:options.vpcLink?options.vpcLink.vpcLinkId:void 0,credentials,timeoutInMillis:options.timeout?.toMilliseconds()}}renderMethodResponses(methodResponses){if(methodResponses)return methodResponses.map(mr=>{let responseModels;if(mr.responseModels){responseModels={};for(const contentType in mr.responseModels)mr.responseModels.hasOwnProperty(contentType)&&(responseModels[contentType]=mr.responseModels[contentType].modelId)}return{statusCode:mr.statusCode,responseParameters:mr.responseParameters,responseModels}})}renderRequestModels(requestModels){if(!requestModels)return;const models={};for(const contentType in requestModels)requestModels.hasOwnProperty(contentType)&&(models[contentType]=requestModels[contentType].modelId);return models}requestValidatorId(options){if(options.requestValidator&&options.requestValidatorOptions)throw new Error("Only one of 'requestValidator' or 'requestValidatorOptions' must be specified.");if(options.requestValidatorOptions){const id=core_1.FeatureFlags.of(this).isEnabled(cx_api_1.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID)?`${core_1.Names.uniqueResourceName(new constructs_1.Construct(this,"Validator"),{})}`:"validator";return this.api.addRequestValidator(id,options.requestValidatorOptions).requestValidatorId}return options.requestValidator?.requestValidatorId}metric(metricName,stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new cloudwatch.Metric({namespace:"AWS/ApiGateway",metricName,dimensionsMap:{ApiName:this.api.restApiName,Method:this.httpMethod,Resource:this.resource.path,Stage:stage.stageName},...props}).attachTo(this)}metricClientError(stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricClientError),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics._4XxErrorSum,stage,props)}metricServerError(stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricServerError),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics._5XxErrorSum,stage,props)}metricCacheHitCount(stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCacheHitCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.cacheHitCountSum,stage,props)}metricCacheMissCount(stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCacheMissCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.cacheMissCountSum,stage,props)}metricCount(stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.countSum,stage,{statistic:"SampleCount",...props})}metricIntegrationLatency(stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricIntegrationLatency),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.integrationLatencyAverage,stage,props)}metricLatency(stage,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricLatency),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.latencyAverage,stage,props)}grantExecute(grantee){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantExecute),error}return iam.Grant.addToPrincipal({grantee,actions:["execute-api:Invoke"],resourceArns:[this.methodArn]})}cannedMetric(fn,stage,props){return new cloudwatch.Metric({...fn({ApiName:this.api.restApiName,Method:this.httpMethod,Resource:this.resource.path,Stage:stage.stageName}),...props}).attachTo(this)}}_a=JSII_RTTI_SYMBOL_1,Method[_a]={fqn:"aws-cdk-lib.aws_apigateway.Method",version:"2.87.0"},exports.Method=Method;var AuthorizationType;(function(AuthorizationType2){AuthorizationType2.NONE="NONE",AuthorizationType2.IAM="AWS_IAM",AuthorizationType2.CUSTOM="CUSTOM",AuthorizationType2.COGNITO="COGNITO_USER_POOLS"})(AuthorizationType=exports.AuthorizationType||(exports.AuthorizationType={}));function pathForArn(path){return path.replace(/\{[^\}]*\}/g,"*")}
