"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.EndpointType=exports.ApiKeySourceType=exports.RestApi=exports.SpecRestApi=exports.RestApiBase=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),api_key_1=require("./api-key"),apigateway_canned_metrics_generated_1=require("./apigateway-canned-metrics.generated"),apigateway_generated_1=require("./apigateway.generated"),deployment_1=require("./deployment"),domain_name_1=require("./domain-name"),gateway_response_1=require("./gateway-response"),model_1=require("./model"),requestvalidator_1=require("./requestvalidator"),resource_1=require("./resource"),stage_1=require("./stage"),usage_plan_1=require("./usage-plan"),cloudwatch=require("../../aws-cloudwatch"),iam=require("../../aws-iam"),core_1=require("../../core"),cx_api_1=require("../../cx-api"),RESTAPI_SYMBOL=Symbol.for("@aws-cdk/aws-apigateway.RestApiBase");class RestApiBase extends core_1.Resource{static _isRestApiBase(x){return x!==null&&typeof x=="object"&&RESTAPI_SYMBOL in x}get latestDeployment(){return this._latestDeployment}get domainName(){return this._domainName}constructor(scope,id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_RestApiBaseProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,RestApiBase),error}const restApiName=props.restApiName??id;super(scope,id,{physicalName:restApiName}),this.restApiName=restApiName,Object.defineProperty(this,RESTAPI_SYMBOL,{value:!0})}urlForPath(path="/"){if(!this.deploymentStage)throw new Error('Cannot determine deployment stage for API from "deploymentStage". Use "deploy" or explicitly set "deploymentStage"');return this.deploymentStage.urlForPath(path)}addDomainName(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_DomainNameOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDomainName),error}const domainName=new domain_name_1.DomainName(this,id,{...options,mapping:this});return this._domainName||(this._domainName=domainName),domainName}addUsagePlan(id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_UsagePlanProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addUsagePlan),error}return new usage_plan_1.UsagePlan(this,id,props)}arnForExecuteApi(method="*",path="/*",stage="*"){if(!core_1.Token.isUnresolved(path)&&!path.startsWith("/"))throw new Error(`"path" must begin with a "/": '${path}'`);return method.toUpperCase()==="ANY"&&(method="*"),core_1.Stack.of(this).formatArn({service:"execute-api",resource:this.restApiId,arnFormat:core_1.ArnFormat.SLASH_RESOURCE_NAME,resourceName:`${stage}/${method}${path}`})}addGatewayResponse(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_GatewayResponseOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addGatewayResponse),error}return new gateway_response_1.GatewayResponse(this,id,{restApi:this,...options})}addApiKey(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ApiKeyOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addApiKey),error}return new api_key_1.ApiKey(this,id,{stages:[this.deploymentStage],...options})}metric(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new cloudwatch.Metric({namespace:"AWS/ApiGateway",metricName,dimensionsMap:{ApiName:this.restApiName},...props}).attachTo(this)}metricClientError(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricClientError),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics._4XxErrorSum,props)}metricServerError(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricServerError),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics._5XxErrorSum,props)}metricCacheHitCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCacheHitCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.cacheHitCountSum,props)}metricCacheMissCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCacheMissCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.cacheMissCountSum,props)}metricCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.countSum,{statistic:"SampleCount",...props})}metricIntegrationLatency(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricIntegrationLatency),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.integrationLatencyAverage,props)}metricLatency(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricLatency),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.latencyAverage,props)}_attachMethod(method){}_attachDeployment(deployment){}_attachStage(stage){this.cloudWatchAccount&&stage.node.addDependency(this.cloudWatchAccount)}_configureCloudWatchRole(apiResource){const role=new iam.Role(this,"CloudWatchRole",{assumedBy:new iam.ServicePrincipal("apigateway.amazonaws.com"),managedPolicies:[iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AmazonAPIGatewayPushToCloudWatchLogs")]});role.applyRemovalPolicy(core_1.RemovalPolicy.RETAIN),this.cloudWatchAccount=new apigateway_generated_1.CfnAccount(this,"Account",{cloudWatchRoleArn:role.roleArn}),this.cloudWatchAccount.applyRemovalPolicy(core_1.RemovalPolicy.RETAIN),this.cloudWatchAccount.node.addDependency(apiResource)}configureCloudWatchRole(apiResource){this._configureCloudWatchRole(apiResource)}configureDeployment(props){this._configureDeployment(props)}_configureDeployment(props){if(props.deploy??!0){this._latestDeployment=new deployment_1.Deployment(this,"Deployment",{description:props.description?props.description:"Automatically created by the RestApi construct",api:this,retainDeployments:props.retainDeployments});const stageName=props.deployOptions&&props.deployOptions.stageName||"prod";this.deploymentStage=new stage_1.Stage(this,`DeploymentStage.${stageName}`,{deployment:this._latestDeployment,...props.deployOptions}),new core_1.CfnOutput(this,"Endpoint",{exportName:props.endpointExportName,value:this.urlForPath()})}else if(props.deployOptions)throw new Error("Cannot set 'deployOptions' if 'deploy' is disabled")}_configureEndpoints(props){if(props.endpointTypes&&props.endpointConfiguration)throw new Error("Only one of the RestApi props, endpointTypes or endpointConfiguration, is allowed");if(props.endpointConfiguration)return{types:props.endpointConfiguration.types,vpcEndpointIds:props.endpointConfiguration?.vpcEndpoints?.map(vpcEndpoint=>vpcEndpoint.vpcEndpointId)};if(props.endpointTypes)return{types:props.endpointTypes}}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({ApiName:this.restApiName}),...props}).attachTo(this)}}_a=JSII_RTTI_SYMBOL_1,RestApiBase[_a]={fqn:"aws-cdk-lib.aws_apigateway.RestApiBase",version:"2.87.0"},exports.RestApiBase=RestApiBase;class SpecRestApi extends RestApiBase{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_SpecRestApiProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SpecRestApi),error}const apiDefConfig=props.apiDefinition.bind(this),resource=new apigateway_generated_1.CfnRestApi(this,"Resource",{name:this.restApiName,policy:props.policy,failOnWarnings:props.failOnWarnings,minimumCompressionSize:props.minCompressionSize?.toBytes(),body:apiDefConfig.inlineDefinition??void 0,bodyS3Location:apiDefConfig.inlineDefinition?void 0:apiDefConfig.s3Location,endpointConfiguration:this._configureEndpoints(props),parameters:props.parameters,disableExecuteApiEndpoint:props.disableExecuteApiEndpoint});props.apiDefinition.bindAfterCreate(this,this),this.node.defaultChild=resource,this.restApiId=resource.ref,this.restApiRootResourceId=resource.attrRootResourceId,this.root=new RootResource(this,{},this.restApiRootResourceId);const cloudWatchRoleDefault=!core_1.FeatureFlags.of(this).isEnabled(cx_api_1.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE);(props.cloudWatchRole??cloudWatchRoleDefault)&&this._configureCloudWatchRole(resource),this._configureDeployment(props),props.domainName&&this.addDomainName("CustomDomain",props.domainName)}}_b=JSII_RTTI_SYMBOL_1,SpecRestApi[_b]={fqn:"aws-cdk-lib.aws_apigateway.SpecRestApi",version:"2.87.0"},exports.SpecRestApi=SpecRestApi;class RestApi extends RestApiBase{static fromRestApiId(scope,id,restApiId){class Import extends RestApiBase{constructor(){super(...arguments),this.restApiId=restApiId}get root(){throw new Error("root is not configured when imported using `fromRestApiId()`. Use `fromRestApiAttributes()` API instead.")}get restApiRootResourceId(){throw new Error("restApiRootResourceId is not configured when imported using `fromRestApiId()`. Use `fromRestApiAttributes()` API instead.")}}return new Import(scope,id)}static fromRestApiAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_RestApiAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromRestApiAttributes),error}class Import extends RestApiBase{constructor(){super(...arguments),this.restApiId=attrs.restApiId,this.restApiName=attrs.restApiName??id,this.restApiRootResourceId=attrs.rootResourceId,this.root=new RootResource(this,{},this.restApiRootResourceId)}}return new Import(scope,id)}constructor(scope,id,props={}){super(scope,id,props),this.methods=new Array,this.deployments=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_RestApiProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,RestApi),error}if(props.minCompressionSize!==void 0&&props.minimumCompressionSize!==void 0)throw new Error("both properties minCompressionSize and minimumCompressionSize cannot be set at once.");const resource=new apigateway_generated_1.CfnRestApi(this,"Resource",{name:this.physicalName,description:props.description,policy:props.policy,failOnWarnings:props.failOnWarnings,minimumCompressionSize:props.minCompressionSize?.toBytes()??props.minimumCompressionSize,binaryMediaTypes:props.binaryMediaTypes,endpointConfiguration:this._configureEndpoints(props),apiKeySourceType:props.apiKeySourceType,cloneFrom:props.cloneFrom?.restApiId,parameters:props.parameters,disableExecuteApiEndpoint:props.disableExecuteApiEndpoint});this.node.defaultChild=resource,this.restApiId=resource.ref;const cloudWatchRoleDefault=!core_1.FeatureFlags.of(this).isEnabled(cx_api_1.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE);(props.cloudWatchRole??cloudWatchRoleDefault)&&this._configureCloudWatchRole(resource),this._configureDeployment(props),props.domainName&&this.addDomainName("CustomDomain",props.domainName),this.root=new RootResource(this,props,resource.attrRootResourceId),this.restApiRootResourceId=resource.attrRootResourceId,this.node.addValidation({validate:()=>this.validateRestApi()})}get url(){return this.urlForPath()}addModel(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ModelOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addModel),error}return new model_1.Model(this,id,{...props,restApi:this})}addRequestValidator(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_RequestValidatorOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addRequestValidator),error}return new requestvalidator_1.RequestValidator(this,id,{...props,restApi:this})}_attachMethod(method){this.methods.push(method);for(const dep of this.deployments)dep._addMethodDependency(method)}_attachDeployment(deployment){this.deployments.push(deployment);for(const method of this.methods)deployment._addMethodDependency(method)}validateRestApi(){return this.methods.length===0?["The REST API doesn't contain any methods"]:[]}}_c=JSII_RTTI_SYMBOL_1,RestApi[_c]={fqn:"aws-cdk-lib.aws_apigateway.RestApi",version:"2.87.0"},exports.RestApi=RestApi;var ApiKeySourceType;(function(ApiKeySourceType2){ApiKeySourceType2.HEADER="HEADER",ApiKeySourceType2.AUTHORIZER="AUTHORIZER"})(ApiKeySourceType=exports.ApiKeySourceType||(exports.ApiKeySourceType={}));var EndpointType;(function(EndpointType2){EndpointType2.EDGE="EDGE",EndpointType2.REGIONAL="REGIONAL",EndpointType2.PRIVATE="PRIVATE"})(EndpointType=exports.EndpointType||(exports.EndpointType={}));class RootResource extends resource_1.ResourceBase{constructor(api,props,resourceId){super(api,"Default"),this.parentResource=void 0,this.defaultIntegration=props.defaultIntegration,this.defaultMethodOptions=props.defaultMethodOptions,this.defaultCorsPreflightOptions=props.defaultCorsPreflightOptions,this.api=api,this.resourceId=resourceId,this.path="/",api instanceof RestApi&&(this._restApi=api),this.defaultCorsPreflightOptions&&this.addCorsPreflight(this.defaultCorsPreflightOptions)}get restApi(){if(!this._restApi)throw new Error("RestApi is not available on Resource not connected to an instance of RestApi. Use `api` instead");return this._restApi}}function ignore(_x){}
