"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Stage=exports.StageBase=exports.MethodLoggingLevel=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),access_log_1=require("./access-log"),api_key_1=require("./api-key"),apigateway_canned_metrics_generated_1=require("./apigateway-canned-metrics.generated"),apigateway_generated_1=require("./apigateway.generated"),restapi_1=require("./restapi"),util_1=require("./util"),cloudwatch=require("../../aws-cloudwatch"),core_1=require("../../core");var MethodLoggingLevel;(function(MethodLoggingLevel2){MethodLoggingLevel2.OFF="OFF",MethodLoggingLevel2.ERROR="ERROR",MethodLoggingLevel2.INFO="INFO"})(MethodLoggingLevel=exports.MethodLoggingLevel||(exports.MethodLoggingLevel={}));class StageBase extends core_1.Resource{addApiKey(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_ApiKeyOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addApiKey),error}return new api_key_1.ApiKey(this,id,{stages:[this],...options})}urlForPath(path="/"){if(!path.startsWith("/"))throw new Error(`Path must begin with "/": ${path}`);return`https://${this.restApi.restApiId}.execute-api.${core_1.Stack.of(this).region}.${core_1.Stack.of(this).urlSuffix}/${this.stageName}${path}`}get stageArn(){return core_1.Stack.of(this).formatArn({arnFormat:core_1.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME,service:"apigateway",account:"",resource:"restapis",resourceName:`${this.restApi.restApiId}/stages/${this.stageName}`})}metric(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new cloudwatch.Metric({namespace:"AWS/ApiGateway",metricName,dimensionsMap:{ApiName:this.restApi.restApiName,Stage:this.stageName},...props}).attachTo(this)}metricClientError(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricClientError),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics._4XxErrorSum,props)}metricServerError(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricServerError),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics._5XxErrorSum,props)}metricCacheHitCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCacheHitCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.cacheHitCountSum,props)}metricCacheMissCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCacheMissCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.cacheMissCountSum,props)}metricCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCount),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.countSum,{statistic:"SampleCount",...props})}metricIntegrationLatency(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricIntegrationLatency),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.integrationLatencyAverage,props)}metricLatency(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricLatency),error}return this.cannedMetric(apigateway_canned_metrics_generated_1.ApiGatewayMetrics.latencyAverage,props)}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({ApiName:this.restApi.restApiName,Stage:this.stageName}),...props}).attachTo(this)}}_a=JSII_RTTI_SYMBOL_1,StageBase[_a]={fqn:"aws-cdk-lib.aws_apigateway.StageBase",version:"2.87.0"},exports.StageBase=StageBase;class Stage extends StageBase{static fromStageAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_StageAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromStageAttributes),error}class Import extends StageBase{constructor(){super(...arguments),this.stageName=attrs.stageName,this.restApi=attrs.restApi}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_StageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Stage),error}this.enableCacheCluster=props.cacheClusterEnabled;const methodSettings=this.renderMethodSettings(props);let accessLogSetting;const accessLogDestination=props.accessLogDestination,accessLogFormat=props.accessLogFormat;if(!accessLogDestination&&!accessLogFormat)accessLogSetting=void 0;else{if(accessLogFormat!==void 0&&!core_1.Token.isUnresolved(accessLogFormat.toString())&&!/.*\$context.(requestId|extendedRequestId)\b.*/.test(accessLogFormat.toString()))throw new Error("Access log must include either `AccessLogFormat.contextRequestId()` or `AccessLogFormat.contextExtendedRequestId()`");if(accessLogFormat!==void 0&&accessLogDestination===void 0)throw new Error("Access log format is specified without a destination");accessLogSetting={destinationArn:accessLogDestination?.bind(this).destinationArn,format:accessLogFormat?.toString()?accessLogFormat?.toString():access_log_1.AccessLogFormat.clf().toString()}}if(props.cacheClusterSize!==void 0){if(this.enableCacheCluster===void 0)this.enableCacheCluster=!0;else if(this.enableCacheCluster===!1)throw new Error(`Cannot set "cacheClusterSize" to ${props.cacheClusterSize} and "cacheClusterEnabled" to "false"`)}const cacheClusterSize=this.enableCacheCluster?props.cacheClusterSize||"0.5":void 0,resource=new apigateway_generated_1.CfnStage(this,"Resource",{stageName:props.stageName||"prod",accessLogSetting,cacheClusterEnabled:this.enableCacheCluster,cacheClusterSize,clientCertificateId:props.clientCertificateId,deploymentId:props.deployment.deploymentId,restApiId:props.deployment.api.restApiId,description:props.description,documentationVersion:props.documentationVersion,variables:props.variables,tracingEnabled:props.tracingEnabled,methodSettings});this.stageName=resource.ref,this.restApi=props.deployment.api,restapi_1.RestApiBase._isRestApiBase(this.restApi)&&this.restApi._attachStage(this)}renderMethodSettings(props){const settings=new Array,self=this,commonMethodOptions={metricsEnabled:props.metricsEnabled,loggingLevel:props.loggingLevel,dataTraceEnabled:props.dataTraceEnabled,throttlingBurstLimit:props.throttlingBurstLimit,throttlingRateLimit:props.throttlingRateLimit,cachingEnabled:props.cachingEnabled,cacheTtl:props.cacheTtl,cacheDataEncrypted:props.cacheDataEncrypted};if(Object.keys(commonMethodOptions).map(v=>commonMethodOptions[v]).filter(x=>x!==void 0).length>0&&settings.push(renderEntry("/*/*",commonMethodOptions)),props.methodOptions)for(const path of Object.keys(props.methodOptions))settings.push(renderEntry(path,props.methodOptions[path]));return settings.length===0?void 0:settings;function renderEntry(path,options){if(options.cachingEnabled){if(self.enableCacheCluster===void 0)self.enableCacheCluster=!0;else if(self.enableCacheCluster===!1)throw new Error(`Cannot enable caching for method ${path} since cache cluster is disabled on stage`)}const{httpMethod,resourcePath}=(0,util_1.parseMethodOptionsPath)(path);return{httpMethod,resourcePath,cacheDataEncrypted:options.cacheDataEncrypted,cacheTtlInSeconds:options.cacheTtl&&options.cacheTtl.toSeconds(),cachingEnabled:options.cachingEnabled,dataTraceEnabled:options.dataTraceEnabled??!1,loggingLevel:options.loggingLevel,metricsEnabled:options.metricsEnabled,throttlingBurstLimit:options.throttlingBurstLimit,throttlingRateLimit:options.throttlingRateLimit}}}}_b=JSII_RTTI_SYMBOL_1,Stage[_b]={fqn:"aws-cdk-lib.aws_apigateway.Stage",version:"2.87.0"},exports.Stage=Stage;
