import * as constructs from 'constructs';
import * as cdk from '../../core';
import * as cfn_parse from '../../core/lib/helpers-internal';
/**
 * Properties for defining a `CfnCollaboration`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html
 */
export interface CfnCollaborationProps {
    /**
     * A display name of the collaboration creator.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname
     */
    readonly creatorDisplayName: string;
    /**
     * The abilities granted to the collaboration creator.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities
     */
    readonly creatorMemberAbilities: string[];
    /**
     * A description of the collaboration provided by the collaboration owner.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description
     */
    readonly description: string;
    /**
     * A list of initial members, not including the creator. This list is immutable.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members
     */
    readonly members: Array<CfnCollaboration.MemberSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * A human-readable identifier provided by the collaboration owner. Display names are not unique.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name
     */
    readonly name: string;
    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus
     */
    readonly queryLogStatus: string;
    /**
     * The settings for client-side encryption for cryptographic computing.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata
     */
    readonly dataEncryptionMetadata?: CfnCollaboration.DataEncryptionMetadataProperty | cdk.IResolvable;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CleanRooms::Collaboration`
 *
 * Creates a new collaboration.
 *
 * @cloudformationResource AWS::CleanRooms::Collaboration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html
 */
export declare class CfnCollaboration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CleanRooms::Collaboration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCollaboration;
    /**
     * Returns the Amazon Resource Name (ARN) of the specified collaboration.
     *
     * Example: `arn:aws:cleanrooms:us-east-1:111122223333:collaboration/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * Returns the unique identifier of the specified collaboration.
     *
     * Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
     * @cloudformationAttribute CollaborationIdentifier
     */
    readonly attrCollaborationIdentifier: string;
    /**
     * A display name of the collaboration creator.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname
     */
    creatorDisplayName: string;
    /**
     * The abilities granted to the collaboration creator.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities
     */
    creatorMemberAbilities: string[];
    /**
     * A description of the collaboration provided by the collaboration owner.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description
     */
    description: string;
    /**
     * A list of initial members, not including the creator. This list is immutable.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members
     */
    members: Array<CfnCollaboration.MemberSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * A human-readable identifier provided by the collaboration owner. Display names are not unique.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name
     */
    name: string;
    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus
     */
    queryLogStatus: string;
    /**
     * The settings for client-side encryption for cryptographic computing.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata
     */
    dataEncryptionMetadata: CfnCollaboration.DataEncryptionMetadataProperty | cdk.IResolvable | undefined;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CleanRooms::Collaboration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCollaborationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCollaboration {
    /**
     * The settings for client-side encryption for cryptographic computing.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html
     */
    interface DataEncryptionMetadataProperty {
        /**
         * Indicates whether encrypted tables can contain cleartext data (true) or are to cryptographically process every column (false).
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowcleartext
         */
        readonly allowCleartext: boolean | cdk.IResolvable;
        /**
         * Indicates whether Fingerprint columns can contain duplicate entries (true) or are to contain only non-repeated values (false).
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowduplicates
         */
        readonly allowDuplicates: boolean | cdk.IResolvable;
        /**
         * Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name (true) or can only be joined on Fingerprint columns of the same name (false).
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowjoinsoncolumnswithdifferentnames
         */
        readonly allowJoinsOnColumnsWithDifferentNames: boolean | cdk.IResolvable;
        /**
         * Indicates whether NULL values are to be copied as NULL to encrypted tables (true) or cryptographically processed (false).
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-preservenulls
         */
        readonly preserveNulls: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnCollaboration {
    /**
     * Basic metadata used to construct a new member.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html
     */
    interface MemberSpecificationProperty {
        /**
         * The identifier used to reference members of the collaboration. Currently only supports AWS account ID.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-accountid
         */
        readonly accountId: string;
        /**
         * The member's display name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-displayname
         */
        readonly displayName: string;
        /**
         * The abilities granted to the collaboration member.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-memberabilities
         */
        readonly memberAbilities: string[];
    }
}
/**
 * Properties for defining a `CfnConfiguredTable`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html
 */
export interface CfnConfiguredTableProps {
    /**
     * The columns within the underlying AWS Glue table that can be utilized within collaborations.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-allowedcolumns
     */
    readonly allowedColumns: string[];
    /**
     * The analysis method for the configured table. The only valid value is currently `DIRECT_QUERY`.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysismethod
     */
    readonly analysisMethod: string;
    /**
     * A name for the configured table.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-name
     */
    readonly name: string;
    /**
     * The AWS Glue table that this configured table represents.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference
     */
    readonly tableReference: CfnConfiguredTable.TableReferenceProperty | cdk.IResolvable;
    /**
     * The entire created analysis rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules
     */
    readonly analysisRules?: Array<CfnConfiguredTable.AnalysisRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * A description for the configured table.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-description
     */
    readonly description?: string;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CleanRooms::ConfiguredTable`
 *
 * Creates a new configured table resource.
 *
 * @cloudformationResource AWS::CleanRooms::ConfiguredTable
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html
 */
export declare class CfnConfiguredTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CleanRooms::ConfiguredTable";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfiguredTable;
    /**
     * Returns the Amazon Resource Name (ARN) of the specified configured table.
     *
     * Example: `arn:aws:cleanrooms:us-east-1:111122223333:configuredtable/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * Returns the unique identifier of the specified configured table.
     *
     * Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
     * @cloudformationAttribute ConfiguredTableIdentifier
     */
    readonly attrConfiguredTableIdentifier: string;
    /**
     * The columns within the underlying AWS Glue table that can be utilized within collaborations.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-allowedcolumns
     */
    allowedColumns: string[];
    /**
     * The analysis method for the configured table. The only valid value is currently `DIRECT_QUERY`.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysismethod
     */
    analysisMethod: string;
    /**
     * A name for the configured table.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-name
     */
    name: string;
    /**
     * The AWS Glue table that this configured table represents.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference
     */
    tableReference: CfnConfiguredTable.TableReferenceProperty | cdk.IResolvable;
    /**
     * The entire created analysis rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules
     */
    analysisRules: Array<CfnConfiguredTable.AnalysisRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * A description for the configured table.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-description
     */
    description: string | undefined;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CleanRooms::ConfiguredTable`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnConfiguredTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnConfiguredTable {
    /**
     * Column in configured table that can be used in aggregate function in query.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html
     */
    interface AggregateColumnProperty {
        /**
         * Column names in configured table of aggregate columns.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html#cfn-cleanrooms-configuredtable-aggregatecolumn-columnnames
         */
        readonly columnNames: string[];
        /**
         * Aggregation function that can be applied to aggregate column in query.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html#cfn-cleanrooms-configuredtable-aggregatecolumn-function
         */
        readonly function: string;
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * Constraint on query output removing output rows that do not meet a minimum number of distinct values of a specified column.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html
     */
    interface AggregationConstraintProperty {
        /**
         * Column in aggregation constraint for which there must be a minimum number of distinct values in an output row for it to be in the query output.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-columnname
         */
        readonly columnName: string;
        /**
         * The minimum number of distinct values that an output row must be an aggregation of. Minimum threshold of distinct values for a specified column that must exist in an output row for it to be in the query output.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-minimum
         */
        readonly minimum: number;
        /**
         * The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-type
         */
        readonly type: string;
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * A specification about how data from the configured table can be used in a query.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html
     */
    interface AnalysisRuleProperty {
        /**
         * A policy that describes the associated data usage limitations.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html#cfn-cleanrooms-configuredtable-analysisrule-policy
         */
        readonly policy: CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyProperty | cdk.IResolvable;
        /**
         * The type of analysis rule. Valid values are `AGGREGATION` and `LIST`.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html#cfn-cleanrooms-configuredtable-analysisrule-type
         */
        readonly type: string;
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * Enables query structure and specified queries that produce aggregate statistics.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html
     */
    interface AnalysisRuleAggregationProperty {
        /**
         * The columns that query runners are allowed to use in aggregation queries.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-aggregatecolumns
         */
        readonly aggregateColumns: Array<CfnConfiguredTable.AggregateColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The columns that query runners are allowed to select, group by, or filter by.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-dimensioncolumns
         */
        readonly dimensionColumns: string[];
        /**
         * Columns in configured table that can be used in join statements and/or as aggregate columns. They can never be outputted directly.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-joincolumns
         */
        readonly joinColumns: string[];
        /**
         * Control that requires member who runs query to do a join with their configured table and/or other configured table in query.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-joinrequired
         */
        readonly joinRequired?: string;
        /**
         * Columns that must meet a specific threshold value (after an aggregation function is applied to it) for each output row to be returned.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-outputconstraints
         */
        readonly outputConstraints: Array<CfnConfiguredTable.AggregationConstraintProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Set of scalar functions that are allowed to be used on dimension columns and the output of aggregation of metrics.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-scalarfunctions
         */
        readonly scalarFunctions: string[];
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * A type of analysis rule that enables row-level analysis.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html
     */
    interface AnalysisRuleListProperty {
        /**
         * Columns that can be used to join a configured table with the table of the member who can query and other members' configured tables.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-joincolumns
         */
        readonly joinColumns: string[];
        /**
         * Columns that can be listed in the output.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-listcolumns
         */
        readonly listColumns: string[];
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * Controls on the query specifications that can be run on a configured table.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicy.html
     */
    interface ConfiguredTableAnalysisRulePolicyProperty {
        /**
         * Controls on the query specifications that can be run on a configured table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicy.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicy-v1
         */
        readonly v1: CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyV1Property | cdk.IResolvable;
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * Controls on the query specifications that can be run on a configured table.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html
     */
    interface ConfiguredTableAnalysisRulePolicyV1Property {
        /**
         * Analysis rule type that enables only aggregation queries on a configured table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-aggregation
         */
        readonly aggregation?: CfnConfiguredTable.AnalysisRuleAggregationProperty | cdk.IResolvable;
        /**
         * Analysis rule type that enables only list queries on a configured table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-list
         */
        readonly list?: CfnConfiguredTable.AnalysisRuleListProperty | cdk.IResolvable;
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * A reference to a table within an AWS Glue data catalog.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html
     */
    interface GlueTableReferenceProperty {
        /**
         * The name of the database the AWS Glue table belongs to.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html#cfn-cleanrooms-configuredtable-gluetablereference-databasename
         */
        readonly databaseName: string;
        /**
         * The name of the AWS Glue table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html#cfn-cleanrooms-configuredtable-gluetablereference-tablename
         */
        readonly tableName: string;
    }
}
export declare namespace CfnConfiguredTable {
    /**
     * A pointer to the dataset that underlies this table. Currently, this can only be an AWS Glue table.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-tablereference.html
     */
    interface TableReferenceProperty {
        /**
         * If present, a reference to the AWS Glue table referred to by this table reference.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-tablereference.html#cfn-cleanrooms-configuredtable-tablereference-glue
         */
        readonly glue: CfnConfiguredTable.GlueTableReferenceProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `CfnConfiguredTableAssociation`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html
 */
export interface CfnConfiguredTableAssociationProps {
    /**
     * A unique identifier for the configured table to be associated to. Currently accepts a configured table ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableidentifier
     */
    readonly configuredTableIdentifier: string;
    /**
     * The unique ID for the membership this configured table association belongs to.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-membershipidentifier
     */
    readonly membershipIdentifier: string;
    /**
     * The name of the configured table association, in lowercase. The table is identified by this name when running protected queries against the underlying data.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-name
     */
    readonly name: string;
    /**
     * The service will assume this role to access catalog metadata and query the table.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-rolearn
     */
    readonly roleArn: string;
    /**
     * A description of the configured table association.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-description
     */
    readonly description?: string;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CleanRooms::ConfiguredTableAssociation`
 *
 * Creates a configured table association. A configured table association links a configured table with a collaboration.
 *
 * @cloudformationResource AWS::CleanRooms::ConfiguredTableAssociation
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html
 */
export declare class CfnConfiguredTableAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CleanRooms::ConfiguredTableAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfiguredTableAssociation;
    /**
     * Returns the Amazon Resource Name (ARN) of the specified configured table association.
     *
     * Example: `arn:aws:cleanrooms:us-east-1:111122223333:configuredtable/a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * Returns the unique identifier of the specified configured table association.
     *
     * Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE33333`
     * @cloudformationAttribute ConfiguredTableAssociationIdentifier
     */
    readonly attrConfiguredTableAssociationIdentifier: string;
    /**
     * A unique identifier for the configured table to be associated to. Currently accepts a configured table ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-configuredtableidentifier
     */
    configuredTableIdentifier: string;
    /**
     * The unique ID for the membership this configured table association belongs to.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-membershipidentifier
     */
    membershipIdentifier: string;
    /**
     * The name of the configured table association, in lowercase. The table is identified by this name when running protected queries against the underlying data.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-name
     */
    name: string;
    /**
     * The service will assume this role to access catalog metadata and query the table.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-rolearn
     */
    roleArn: string;
    /**
     * A description of the configured table association.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-description
     */
    description: string | undefined;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtableassociation.html#cfn-cleanrooms-configuredtableassociation-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CleanRooms::ConfiguredTableAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnConfiguredTableAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnMembership`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html
 */
export interface CfnMembershipProps {
    /**
     * The unique ID for the associated collaboration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-collaborationidentifier
     */
    readonly collaborationIdentifier: string;
    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-querylogstatus
     */
    readonly queryLogStatus: string;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CleanRooms::Membership`
 *
 * Creates a membership for a specific collaboration identifier and joins the collaboration.
 *
 * @cloudformationResource AWS::CleanRooms::Membership
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html
 */
export declare class CfnMembership extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CleanRooms::Membership";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMembership;
    /**
     * Returns the Amazon Resource Name (ARN) of the specified membership.
     *
     * Example: `arn:aws:cleanrooms:us-east-1:111122223333:membership/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * Returns the Amazon Resource Name (ARN) of the specified collaboration.
     *
     * Example: `arn:aws:cleanrooms:us-east-1:111122223333:collaboration/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
     * @cloudformationAttribute CollaborationArn
     */
    readonly attrCollaborationArn: string;
    /**
     * Returns the unique identifier of the specified collaboration creator account.
     *
     * Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
     * @cloudformationAttribute CollaborationCreatorAccountId
     */
    readonly attrCollaborationCreatorAccountId: string;
    /**
     * Returns the unique identifier of the specified membership.
     *
     * Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE22222`
     * @cloudformationAttribute MembershipIdentifier
     */
    readonly attrMembershipIdentifier: string;
    /**
     * The unique ID for the associated collaboration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-collaborationidentifier
     */
    collaborationIdentifier: string;
    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-querylogstatus
     */
    queryLogStatus: string;
    /**
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CleanRooms::Membership`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnMembershipProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
