"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.HeadersReferrerPolicy=exports.HeadersFrameOption=exports.ResponseHeadersPolicy=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudfront_generated_1=require("./cloudfront.generated"),core_1=require("../../core");class ResponseHeadersPolicy extends core_1.Resource{static fromResponseHeadersPolicyId(scope,id,responseHeadersPolicyId){class Import extends core_1.Resource{constructor(){super(...arguments),this.responseHeadersPolicyId=responseHeadersPolicyId}}return new Import(scope,id)}static fromManagedResponseHeadersPolicy(managedResponseHeadersPolicyId){return new class{constructor(){this.responseHeadersPolicyId=managedResponseHeadersPolicyId}}}constructor(scope,id,props={}){super(scope,id,{physicalName:props.responseHeadersPolicyName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_ResponseHeadersPolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ResponseHeadersPolicy),error}const responseHeadersPolicyName=props.responseHeadersPolicyName??core_1.Names.uniqueResourceName(this,{maxLength:128}),resource=new cloudfront_generated_1.CfnResponseHeadersPolicy(this,"Resource",{responseHeadersPolicyConfig:{name:responseHeadersPolicyName,comment:props.comment,corsConfig:props.corsBehavior?this._renderCorsConfig(props.corsBehavior):void 0,customHeadersConfig:props.customHeadersBehavior?this._renderCustomHeadersConfig(props.customHeadersBehavior):void 0,securityHeadersConfig:props.securityHeadersBehavior?this._renderSecurityHeadersConfig(props.securityHeadersBehavior):void 0,removeHeadersConfig:props.removeHeaders?this._renderRemoveHeadersConfig(props.removeHeaders):void 0,serverTimingHeadersConfig:props.serverTimingSamplingRate?this._renderServerTimingHeadersConfig(props.serverTimingSamplingRate):void 0}});this.responseHeadersPolicyId=resource.ref}_renderCorsConfig(behavior){return{accessControlAllowCredentials:behavior.accessControlAllowCredentials,accessControlAllowHeaders:{items:behavior.accessControlAllowHeaders},accessControlAllowMethods:{items:behavior.accessControlAllowMethods},accessControlAllowOrigins:{items:behavior.accessControlAllowOrigins},accessControlExposeHeaders:behavior.accessControlExposeHeaders?{items:behavior.accessControlExposeHeaders}:void 0,accessControlMaxAgeSec:behavior.accessControlMaxAge?behavior.accessControlMaxAge.toSeconds():void 0,originOverride:behavior.originOverride}}_renderCustomHeadersConfig(behavior){return{items:behavior.customHeaders}}_renderSecurityHeadersConfig(behavior){return{contentSecurityPolicy:behavior.contentSecurityPolicy,contentTypeOptions:behavior.contentTypeOptions,frameOptions:behavior.frameOptions,referrerPolicy:behavior.referrerPolicy,strictTransportSecurity:behavior.strictTransportSecurity?{...behavior.strictTransportSecurity,accessControlMaxAgeSec:behavior.strictTransportSecurity.accessControlMaxAge.toSeconds()}:void 0,xssProtection:behavior.xssProtection}}_renderRemoveHeadersConfig(headers){const readonlyHeaders=["content-encoding","content-length","transfer-encoding","warning","via"];return{items:headers.map(header=>{if(!core_1.Token.isUnresolved(header)&&readonlyHeaders.includes(header.toLowerCase()))throw new Error(`Cannot remove read-only header ${header}`);return{header}})}}_renderServerTimingHeadersConfig(samplingRate){if(!core_1.Token.isUnresolved(samplingRate)){if(samplingRate<0||samplingRate>100)throw new Error(`Sampling rate must be between 0 and 100 (inclusive), received ${samplingRate}`);if(!hasMaxDecimalPlaces(samplingRate,4))throw new Error(`Sampling rate can have up to four decimal places, received ${samplingRate}`)}return{enabled:!0,samplingRate}}}_a=JSII_RTTI_SYMBOL_1,ResponseHeadersPolicy[_a]={fqn:"aws-cdk-lib.aws_cloudfront.ResponseHeadersPolicy",version:"2.87.0"},ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS=ResponseHeadersPolicy.fromManagedResponseHeadersPolicy("60669652-455b-4ae9-85a4-c4c02393f86c"),ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT=ResponseHeadersPolicy.fromManagedResponseHeadersPolicy("5cc3b908-e619-4b99-88e5-2cf7f45965bd"),ResponseHeadersPolicy.SECURITY_HEADERS=ResponseHeadersPolicy.fromManagedResponseHeadersPolicy("67f7725c-6f97-4210-82d7-5512b31e9d03"),ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_AND_SECURITY_HEADERS=ResponseHeadersPolicy.fromManagedResponseHeadersPolicy("e61eb60c-9c35-4d20-a928-2b84e02af89c"),ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT_AND_SECURITY_HEADERS=ResponseHeadersPolicy.fromManagedResponseHeadersPolicy("eaab4381-ed33-4a86-88ca-d9558dc6cd63"),exports.ResponseHeadersPolicy=ResponseHeadersPolicy;var HeadersFrameOption;(function(HeadersFrameOption2){HeadersFrameOption2.DENY="DENY",HeadersFrameOption2.SAMEORIGIN="SAMEORIGIN"})(HeadersFrameOption=exports.HeadersFrameOption||(exports.HeadersFrameOption={}));var HeadersReferrerPolicy;(function(HeadersReferrerPolicy2){HeadersReferrerPolicy2.NO_REFERRER="no-referrer",HeadersReferrerPolicy2.NO_REFERRER_WHEN_DOWNGRADE="no-referrer-when-downgrade",HeadersReferrerPolicy2.ORIGIN="origin",HeadersReferrerPolicy2.ORIGIN_WHEN_CROSS_ORIGIN="origin-when-cross-origin",HeadersReferrerPolicy2.SAME_ORIGIN="same-origin",HeadersReferrerPolicy2.STRICT_ORIGIN="strict-origin",HeadersReferrerPolicy2.STRICT_ORIGIN_WHEN_CROSS_ORIGIN="strict-origin-when-cross-origin",HeadersReferrerPolicy2.UNSAFE_URL="unsafe-url"})(HeadersReferrerPolicy=exports.HeadersReferrerPolicy||(exports.HeadersReferrerPolicy={}));function hasMaxDecimalPlaces(num,decimals){const parts=num.toString().split(".");return parts.length===1||parts[1].length<=decimals}
