"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CloudFrontWebDistribution=exports.ViewerCertificate=exports.CloudFrontAllowedCachedMethods=exports.CloudFrontAllowedMethods=exports.OriginSslPolicy=exports.FailoverStatusCode=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudfront_generated_1=require("./cloudfront.generated"),distribution_1=require("./distribution"),utils_1=require("./private/utils"),certificatemanager=require("../../aws-certificatemanager"),iam=require("../../aws-iam"),s3=require("../../aws-s3"),cdk=require("../../core");var FailoverStatusCode;(function(FailoverStatusCode2){FailoverStatusCode2[FailoverStatusCode2.FORBIDDEN=403]="FORBIDDEN",FailoverStatusCode2[FailoverStatusCode2.NOT_FOUND=404]="NOT_FOUND",FailoverStatusCode2[FailoverStatusCode2.INTERNAL_SERVER_ERROR=500]="INTERNAL_SERVER_ERROR",FailoverStatusCode2[FailoverStatusCode2.BAD_GATEWAY=502]="BAD_GATEWAY",FailoverStatusCode2[FailoverStatusCode2.SERVICE_UNAVAILABLE=503]="SERVICE_UNAVAILABLE",FailoverStatusCode2[FailoverStatusCode2.GATEWAY_TIMEOUT=504]="GATEWAY_TIMEOUT"})(FailoverStatusCode=exports.FailoverStatusCode||(exports.FailoverStatusCode={}));var OriginSslPolicy;(function(OriginSslPolicy2){OriginSslPolicy2.SSL_V3="SSLv3",OriginSslPolicy2.TLS_V1="TLSv1",OriginSslPolicy2.TLS_V1_1="TLSv1.1",OriginSslPolicy2.TLS_V1_2="TLSv1.2"})(OriginSslPolicy=exports.OriginSslPolicy||(exports.OriginSslPolicy={}));var CloudFrontAllowedMethods;(function(CloudFrontAllowedMethods2){CloudFrontAllowedMethods2.GET_HEAD="GH",CloudFrontAllowedMethods2.GET_HEAD_OPTIONS="GHO",CloudFrontAllowedMethods2.ALL="ALL"})(CloudFrontAllowedMethods=exports.CloudFrontAllowedMethods||(exports.CloudFrontAllowedMethods={}));var CloudFrontAllowedCachedMethods;(function(CloudFrontAllowedCachedMethods2){CloudFrontAllowedCachedMethods2.GET_HEAD="GH",CloudFrontAllowedCachedMethods2.GET_HEAD_OPTIONS="GHO"})(CloudFrontAllowedCachedMethods=exports.CloudFrontAllowedCachedMethods||(exports.CloudFrontAllowedCachedMethods={}));class ViewerCertificate{static fromAcmCertificate(certificate,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_certificatemanager_ICertificate(certificate),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_ViewerCertificateOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAcmCertificate),error}const{sslMethod:sslSupportMethod=distribution_1.SSLMethod.SNI,securityPolicy:minimumProtocolVersion,aliases}=options;return new ViewerCertificate({acmCertificateArn:certificate.certificateArn,sslSupportMethod,minimumProtocolVersion},aliases)}static fromIamCertificate(iamCertificateId,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_ViewerCertificateOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromIamCertificate),error}const{sslMethod:sslSupportMethod=distribution_1.SSLMethod.SNI,securityPolicy:minimumProtocolVersion,aliases}=options;return new ViewerCertificate({iamCertificateId,sslSupportMethod,minimumProtocolVersion},aliases)}static fromCloudFrontDefaultCertificate(...aliases){return new ViewerCertificate({cloudFrontDefaultCertificate:!0},aliases)}constructor(props,aliases=[]){this.props=props,this.aliases=aliases}}_a=JSII_RTTI_SYMBOL_1,ViewerCertificate[_a]={fqn:"aws-cdk-lib.aws_cloudfront.ViewerCertificate",version:"2.87.0"},exports.ViewerCertificate=ViewerCertificate;class CloudFrontWebDistribution extends cdk.Resource{static fromDistributionAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_CloudFrontWebDistributionAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDistributionAttributes),error}return new class extends cdk.Resource{constructor(){super(scope,id),this.domainName=attrs.domainName,this.distributionDomainName=attrs.domainName,this.distributionId=attrs.distributionId}grant(grantee,...actions){return iam.Grant.addToPrincipal({grantee,actions,resourceArns:[(0,utils_1.formatDistributionArn)(this)]})}grantCreateInvalidation(identity){return this.grant(identity,"cloudfront:CreateInvalidation")}}}constructor(scope,id,props){super(scope,id),this.METHOD_LOOKUP_MAP={GH:["GET","HEAD"],GHO:["GET","HEAD","OPTIONS"],ALL:["DELETE","GET","HEAD","OPTIONS","PATCH","POST","PUT"]},this.VALID_SSL_PROTOCOLS={[distribution_1.SSLMethod.SNI]:[distribution_1.SecurityPolicyProtocol.TLS_V1,distribution_1.SecurityPolicyProtocol.TLS_V1_1_2016,distribution_1.SecurityPolicyProtocol.TLS_V1_2016,distribution_1.SecurityPolicyProtocol.TLS_V1_2_2018,distribution_1.SecurityPolicyProtocol.TLS_V1_2_2019,distribution_1.SecurityPolicyProtocol.TLS_V1_2_2021],[distribution_1.SSLMethod.VIP]:[distribution_1.SecurityPolicyProtocol.SSL_V3,distribution_1.SecurityPolicyProtocol.TLS_V1]};try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_CloudFrontWebDistributionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CloudFrontWebDistribution),error}const trimmedComment=props.comment&&props.comment.length>128?`${props.comment.slice(0,128-3)}...`:props.comment,behaviors=[],origins=[],originGroups=[];let originIndex=1;for(const originConfig of props.originConfigs){let originId=`origin${originIndex}`;const originProperty=this.toOriginProperty(originConfig,originId);if(originConfig.failoverCustomOriginSource||originConfig.failoverS3OriginSource){const originSecondaryId=`originSecondary${originIndex}`,originSecondaryProperty=this.toOriginProperty({s3OriginSource:originConfig.failoverS3OriginSource,customOriginSource:originConfig.failoverCustomOriginSource,originPath:originConfig.originPath,originHeaders:originConfig.originHeaders,originShieldRegion:originConfig.originShieldRegion},originSecondaryId),originGroupsId=`OriginGroup${originIndex}`,failoverCodes=originConfig.failoverCriteriaStatusCodes??[500,502,503,504];originGroups.push({id:originGroupsId,members:{items:[{originId},{originId:originSecondaryId}],quantity:2},failoverCriteria:{statusCodes:{items:failoverCodes,quantity:failoverCodes.length}}}),originId=originGroupsId,origins.push(originSecondaryProperty)}for(const behavior of originConfig.behaviors)behaviors.push({...behavior,targetOriginId:originId});origins.push(originProperty),originIndex++}origins.forEach(origin=>{if(!origin.s3OriginConfig&&!origin.customOriginConfig)throw new Error(`Origin ${origin.domainName} is missing either S3OriginConfig or CustomOriginConfig. At least 1 must be specified.`)});const originGroupsDistConfig=originGroups.length>0?{items:originGroups,quantity:originGroups.length}:void 0,defaultBehaviors=behaviors.filter(behavior=>behavior.isDefaultBehavior);if(defaultBehaviors.length!==1)throw new Error("There can only be one default behavior across all sources. [ One default behavior per distribution ].");const otherBehaviors=[];for(const behavior of behaviors.filter(b=>!b.isDefaultBehavior)){if(!behavior.pathPattern)throw new Error("pathPattern is required for all non-default behaviors");otherBehaviors.push(this.toBehavior(behavior,props.viewerProtocolPolicy))}let distributionConfig={comment:trimmedComment,enabled:props.enabled??!0,defaultRootObject:props.defaultRootObject??"index.html",httpVersion:props.httpVersion||distribution_1.HttpVersion.HTTP2,priceClass:props.priceClass||distribution_1.PriceClass.PRICE_CLASS_100,ipv6Enabled:props.enableIpV6??!0,customErrorResponses:props.errorConfigurations,webAclId:props.webACLId,origins,originGroups:originGroupsDistConfig,defaultCacheBehavior:this.toBehavior(defaultBehaviors[0],props.viewerProtocolPolicy),cacheBehaviors:otherBehaviors.length>0?otherBehaviors:void 0};if(props.aliasConfiguration&&props.viewerCertificate)throw new Error(["You cannot set both aliasConfiguration and viewerCertificate properties.","Please only use viewerCertificate, as aliasConfiguration is deprecated."].join(" "));let _viewerCertificate=props.viewerCertificate;if(props.aliasConfiguration){const{acmCertRef,securityPolicy,sslMethod,names:aliases}=props.aliasConfiguration;_viewerCertificate=ViewerCertificate.fromAcmCertificate(certificatemanager.Certificate.fromCertificateArn(this,"AliasConfigurationCert",acmCertRef),{securityPolicy,sslMethod,aliases})}if(_viewerCertificate){const{props:viewerCertificate,aliases}=_viewerCertificate;Object.assign(distributionConfig,{aliases,viewerCertificate});const{minimumProtocolVersion,sslSupportMethod}=viewerCertificate;if(minimumProtocolVersion!=null&&sslSupportMethod!=null){const validProtocols=this.VALID_SSL_PROTOCOLS[sslSupportMethod];if(validProtocols.indexOf(minimumProtocolVersion.toString())===-1)throw new Error(`${minimumProtocolVersion} is not compabtible with sslMethod ${sslSupportMethod}.
	Valid Protocols are: ${validProtocols.join(", ")}`)}}else distributionConfig={...distributionConfig,viewerCertificate:{cloudFrontDefaultCertificate:!0}};props.loggingConfig&&(this.loggingBucket=props.loggingConfig.bucket||new s3.Bucket(this,"LoggingBucket",{encryption:s3.BucketEncryption.S3_MANAGED}),distributionConfig={...distributionConfig,logging:{bucket:this.loggingBucket.bucketRegionalDomainName,includeCookies:props.loggingConfig.includeCookies||!1,prefix:props.loggingConfig.prefix}}),props.geoRestriction&&(distributionConfig={...distributionConfig,restrictions:{geoRestriction:{restrictionType:props.geoRestriction.restrictionType,locations:props.geoRestriction.locations}}});const distribution=new cloudfront_generated_1.CfnDistribution(this,"CFDistribution",{distributionConfig});this.node.defaultChild=distribution,this.domainName=distribution.attrDomainName,this.distributionDomainName=distribution.attrDomainName,this.distributionId=distribution.ref}grant(identity,...actions){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(identity)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grant),error}return iam.Grant.addToPrincipal({grantee:identity,actions,resourceArns:[(0,utils_1.formatDistributionArn)(this)]})}grantCreateInvalidation(identity){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(identity)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantCreateInvalidation),error}return this.grant(identity,"cloudfront:CreateInvalidation")}toBehavior(input,protoPolicy){let toReturn={allowedMethods:this.METHOD_LOOKUP_MAP[input.allowedMethods||CloudFrontAllowedMethods.GET_HEAD],cachedMethods:this.METHOD_LOOKUP_MAP[input.cachedMethods||CloudFrontAllowedCachedMethods.GET_HEAD],compress:input.compress!==!1,defaultTtl:input.defaultTtl&&input.defaultTtl.toSeconds(),forwardedValues:input.forwardedValues||{queryString:!1,cookies:{forward:"none"}},maxTtl:input.maxTtl&&input.maxTtl.toSeconds(),minTtl:input.minTtl&&input.minTtl.toSeconds(),trustedKeyGroups:input.trustedKeyGroups?.map(key=>key.keyGroupId),trustedSigners:input.trustedSigners,targetOriginId:input.targetOriginId,viewerProtocolPolicy:input.viewerProtocolPolicy||protoPolicy||distribution_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS};if(input.isDefaultBehavior||(toReturn=Object.assign(toReturn,{pathPattern:input.pathPattern})),input.functionAssociations&&(toReturn=Object.assign(toReturn,{functionAssociations:input.functionAssociations.map(association=>({functionArn:association.function.functionArn,eventType:association.eventType.toString()}))})),input.lambdaFunctionAssociations){const includeBodyEventTypes=[distribution_1.LambdaEdgeEventType.ORIGIN_REQUEST,distribution_1.LambdaEdgeEventType.VIEWER_REQUEST];if(input.lambdaFunctionAssociations.some(fna=>fna.includeBody&&!includeBodyEventTypes.includes(fna.eventType)))throw new Error("'includeBody' can only be true for ORIGIN_REQUEST or VIEWER_REQUEST event types.");toReturn=Object.assign(toReturn,{lambdaFunctionAssociations:input.lambdaFunctionAssociations.map(fna=>({eventType:fna.eventType,lambdaFunctionArn:fna.lambdaFunction&&fna.lambdaFunction.edgeArn,includeBody:fna.includeBody}))});for(const a of input.lambdaFunctionAssociations)a.lambdaFunction.role&&iam.Role.isRole(a.lambdaFunction.role)&&a.lambdaFunction.role.assumeRolePolicy&&a.lambdaFunction.role.assumeRolePolicy.addStatements(new iam.PolicyStatement({actions:["sts:AssumeRole"],principals:[new iam.ServicePrincipal("edgelambda.amazonaws.com")]}))}return toReturn}toOriginProperty(originConfig,originId){if(!originConfig.s3OriginSource&&!originConfig.customOriginSource)throw new Error("There must be at least one origin source - either an s3OriginSource, a customOriginSource");if(originConfig.customOriginSource&&originConfig.s3OriginSource)throw new Error("There cannot be both an s3OriginSource and a customOriginSource in the same SourceConfiguration.");if([originConfig.originHeaders,originConfig.s3OriginSource?.originHeaders,originConfig.customOriginSource?.originHeaders].filter(x=>x).length>1)throw new Error("Only one originHeaders field allowed across origin and failover origins");if([originConfig.originPath,originConfig.s3OriginSource?.originPath,originConfig.customOriginSource?.originPath].filter(x=>x).length>1)throw new Error("Only one originPath field allowed across origin and failover origins");if([originConfig.originShieldRegion,originConfig.s3OriginSource?.originShieldRegion,originConfig.customOriginSource?.originShieldRegion].filter(x=>x).length>1)throw new Error("Only one originShieldRegion field allowed across origin and failover origins");const headers=originConfig.originHeaders??originConfig.s3OriginSource?.originHeaders??originConfig.customOriginSource?.originHeaders,originHeaders=[];headers&&Object.keys(headers).forEach(key=>{const oHeader={headerName:key,headerValue:headers[key]};originHeaders.push(oHeader)});let s3OriginConfig;originConfig.s3OriginSource&&(originConfig.s3OriginSource.originAccessIdentity?(originConfig.s3OriginSource.s3BucketSource.addToResourcePolicy(new iam.PolicyStatement({resources:[originConfig.s3OriginSource.s3BucketSource.arnForObjects("*")],actions:["s3:GetObject"],principals:[originConfig.s3OriginSource.originAccessIdentity.grantPrincipal]})),s3OriginConfig={originAccessIdentity:`origin-access-identity/cloudfront/${originConfig.s3OriginSource.originAccessIdentity.originAccessIdentityId}`}):s3OriginConfig={});const connectionAttempts=originConfig.connectionAttempts??3;if(connectionAttempts<1||3<connectionAttempts||!Number.isInteger(connectionAttempts))throw new Error("connectionAttempts: You can specify 1, 2, or 3 as the number of attempts.");const connectionTimeout=(originConfig.connectionTimeout||cdk.Duration.seconds(10)).toSeconds();if(connectionTimeout<1||10<connectionTimeout||!Number.isInteger(connectionTimeout))throw new Error("connectionTimeout: You can specify a number of seconds between 1 and 10 (inclusive).");return{id:originId,domainName:originConfig.s3OriginSource?originConfig.s3OriginSource.s3BucketSource.bucketRegionalDomainName:originConfig.customOriginSource.domainName,originPath:originConfig.originPath??originConfig.customOriginSource?.originPath??originConfig.s3OriginSource?.originPath,originCustomHeaders:originHeaders.length>0?originHeaders:void 0,s3OriginConfig,originShield:this.toOriginShieldProperty(originConfig),customOriginConfig:originConfig.customOriginSource?{httpPort:originConfig.customOriginSource.httpPort||80,httpsPort:originConfig.customOriginSource.httpsPort||443,originKeepaliveTimeout:originConfig.customOriginSource.originKeepaliveTimeout&&originConfig.customOriginSource.originKeepaliveTimeout.toSeconds()||5,originReadTimeout:originConfig.customOriginSource.originReadTimeout&&originConfig.customOriginSource.originReadTimeout.toSeconds()||30,originProtocolPolicy:originConfig.customOriginSource.originProtocolPolicy||distribution_1.OriginProtocolPolicy.HTTPS_ONLY,originSslProtocols:originConfig.customOriginSource.allowedOriginSSLVersions||[OriginSslPolicy.TLS_V1_2]}:void 0,connectionAttempts,connectionTimeout}}toOriginShieldProperty(originConfig){const originShieldRegion=originConfig.originShieldRegion??originConfig.customOriginSource?.originShieldRegion??originConfig.s3OriginSource?.originShieldRegion;return originShieldRegion?{enabled:!0,originShieldRegion}:void 0}}_b=JSII_RTTI_SYMBOL_1,CloudFrontWebDistribution[_b]={fqn:"aws-cdk-lib.aws_cloudfront.CloudFrontWebDistribution",version:"2.87.0"},exports.CloudFrontWebDistribution=CloudFrontWebDistribution;
