"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.normalizeRawStringStatistic=exports.normalizeStatistic=exports.parseStatistic=exports.pairStatisticToString=exports.singleStatisticToString=void 0;const stats_1=require("../stats");function parseSingleStatistic(statistic,prefix){const prefixLower=prefix.toLowerCase();if(statistic=statistic.toLowerCase(),!statistic.startsWith(prefixLower))return;const reDecimal="\\d+(?:\\.\\d+)?",r=new RegExp(`^${prefixLower}(${reDecimal})$`).exec(statistic);if(!r)return;const value=parseFloat(r[1]);if(!(value<0||value>100))return{type:"single",rawStatistic:statistic,statPrefix:prefixLower,value}}function parsePairStatistic(statistic,prefix){const r=new RegExp(`^${prefix}\\(([^)]+)\\)$`,"i").exec(statistic);if(!r)return;const common={type:"pair",canBeSingleStat:!1,rawStatistic:statistic,statPrefix:prefix.toUpperCase()},[lhs,rhs]=r[1].split(":");if(rhs===void 0)return;const parseNumberAndPercent=x=>{if(x=x.trim(),!x)return[void 0,!1];const value=parseFloat(x.replace(/%$/,"")),percent=x.endsWith("%");return isNaN(value)||value<0||percent&&value>100?["fail",!1]:[value,percent]},[lower,lhsPercent]=parseNumberAndPercent(lhs),[upper,rhsPercent]=parseNumberAndPercent(rhs);if(lower==="fail"||upper==="fail"||lower===void 0&&upper===void 0||lower!==void 0&&upper!==void 0&&lhsPercent!==rhsPercent)return;const isPercent=lhsPercent||rhsPercent,canBeSingleStat=lower===void 0&&isPercent,asSingleStatStr=canBeSingleStat?`${prefix.toLowerCase()}${upper}`:void 0;return{...common,lower,upper,isPercent,canBeSingleStat,asSingleStatStr}}function singleStatisticToString(parsed){return`${parsed.statPrefix}${parsed.value}`}exports.singleStatisticToString=singleStatisticToString;function pairStatisticToString(parsed){const percent=parsed.isPercent?"%":"",lower=parsed.lower?`${parsed.lower}${percent}`:"",upper=parsed.upper?`${parsed.upper}${percent}`:"";return`${parsed.statPrefix}(${lower}:${upper})`}exports.pairStatisticToString=pairStatisticToString;function parseStatistic(stat){const lowerStat=stat.toLowerCase(),statMap={average:stats_1.Stats.AVERAGE,avg:stats_1.Stats.AVERAGE,minimum:stats_1.Stats.MINIMUM,min:stats_1.Stats.MINIMUM,maximum:stats_1.Stats.MAXIMUM,max:stats_1.Stats.MAXIMUM,samplecount:stats_1.Stats.SAMPLE_COUNT,n:stats_1.Stats.SAMPLE_COUNT,sum:stats_1.Stats.SUM,iqm:stats_1.Stats.IQM};if(lowerStat in statMap)return{type:"simple",statistic:statMap[lowerStat]};let m;return m=parseSingleStatistic(stat,"p"),m?{...m,statName:"percentile"}:(m=parseSingleStatistic(stat,"tm")||parsePairStatistic(stat,"tm"),m?{...m,statName:"trimmedMean"}:(m=parseSingleStatistic(stat,"wm")||parsePairStatistic(stat,"wm"),m?{...m,statName:"winsorizedMean"}:(m=parseSingleStatistic(stat,"tc")||parsePairStatistic(stat,"tc"),m?{...m,statName:"trimmedCount"}:(m=parseSingleStatistic(stat,"ts")||parsePairStatistic(stat,"ts"),m?{...m,statName:"trimmedSum"}:{type:"generic",statistic:stat}))))}exports.parseStatistic=parseStatistic;function normalizeStatistic(parsed){return parsed.type==="simple"||parsed.type==="generic"?parsed.statistic:parsed.type==="single"?parsed.rawStatistic.toLowerCase():parsed.type==="pair"?parsed.rawStatistic.toUpperCase():""}exports.normalizeStatistic=normalizeStatistic;function normalizeRawStringStatistic(stat){const parsed=parseStatistic(stat);return normalizeStatistic(parsed)}exports.normalizeRawStringStatistic=normalizeRawStringStatistic;
