"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FilterGroup=exports.EventAction=exports.Source=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),source_types_1=require("./source-types"),iam=require("../../aws-iam");class Source{static s3(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_S3SourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.s3),error}return new S3Source(props)}static codeCommit(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_CodeCommitSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.codeCommit),error}return new CodeCommitSource(props)}static gitHub(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_GitHubSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.gitHub),error}return new GitHubSource(props)}static gitHubEnterprise(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_GitHubEnterpriseSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.gitHubEnterprise),error}return new GitHubEnterpriseSource(props)}static bitBucket(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_BitBucketSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bitBucket),error}return new BitBucketSource(props)}constructor(props){this.badgeSupported=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_SourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Source),error}this.identifier=props.identifier}bind(_scope,_project){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_IProject(_project)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}return{sourceProperty:{sourceIdentifier:this.identifier,type:this.type}}}}_a=JSII_RTTI_SYMBOL_1,Source[_a]={fqn:"aws-cdk-lib.aws_codebuild.Source",version:"2.87.0"},exports.Source=Source;class GitSource extends Source{constructor(props){super(props),this.cloneDepth=props.cloneDepth,this.branchOrRef=props.branchOrRef,this.fetchSubmodules=props.fetchSubmodules}bind(_scope,_project){const superConfig=super.bind(_scope,_project);return{sourceVersion:this.branchOrRef,sourceProperty:{...superConfig.sourceProperty,gitCloneDepth:this.cloneDepth,gitSubmodulesConfig:this.fetchSubmodules?{fetchSubmodules:this.fetchSubmodules}:void 0}}}}var EventAction;(function(EventAction2){EventAction2.PUSH="PUSH",EventAction2.PULL_REQUEST_CREATED="PULL_REQUEST_CREATED",EventAction2.PULL_REQUEST_UPDATED="PULL_REQUEST_UPDATED",EventAction2.PULL_REQUEST_MERGED="PULL_REQUEST_MERGED",EventAction2.PULL_REQUEST_REOPENED="PULL_REQUEST_REOPENED"})(EventAction=exports.EventAction||(exports.EventAction={}));var WebhookFilterTypes;(function(WebhookFilterTypes2){WebhookFilterTypes2.FILE_PATH="FILE_PATH",WebhookFilterTypes2.COMMIT_MESSAGE="COMMIT_MESSAGE",WebhookFilterTypes2.HEAD_REF="HEAD_REF",WebhookFilterTypes2.ACTOR_ACCOUNT_ID="ACTOR_ACCOUNT_ID",WebhookFilterTypes2.BASE_REF="BASE_REF"})(WebhookFilterTypes||(WebhookFilterTypes={}));class FilterGroup{static inEventOf(...actions){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codebuild_EventAction(actions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inEventOf),error}return new FilterGroup(new Set(actions),[])}constructor(actions,filters){if(actions.size===0)throw new Error("A filter group must contain at least one event action");this.actions=actions,this.filters=filters}andBranchIs(branchName){return this.addHeadBranchFilter(branchName,!0)}andBranchIsNot(branchName){return this.addHeadBranchFilter(branchName,!1)}andCommitMessageIs(commitMessage){return this.addCommitMessageFilter(commitMessage,!0)}andCommitMessageIsNot(commitMessage){return this.addCommitMessageFilter(commitMessage,!1)}andTagIs(tagName){return this.addHeadTagFilter(tagName,!0)}andTagIsNot(tagName){return this.addHeadTagFilter(tagName,!1)}andHeadRefIs(pattern){return this.addHeadRefFilter(pattern,!0)}andHeadRefIsNot(pattern){return this.addHeadRefFilter(pattern,!1)}andActorAccountIs(pattern){return this.addActorAccountId(pattern,!0)}andActorAccountIsNot(pattern){return this.addActorAccountId(pattern,!1)}andBaseBranchIs(branchName){return this.addBaseBranchFilter(branchName,!0)}andBaseBranchIsNot(branchName){return this.addBaseBranchFilter(branchName,!1)}andBaseRefIs(pattern){return this.addBaseRefFilter(pattern,!0)}andBaseRefIsNot(pattern){return this.addBaseRefFilter(pattern,!1)}andFilePathIs(pattern){return this.addFilePathFilter(pattern,!0)}andFilePathIsNot(pattern){return this.addFilePathFilter(pattern,!1)}get _actions(){return set2Array(this.actions)}get _filters(){return this.filters.slice()}_toJson(){return[{type:"EVENT",pattern:set2Array(this.actions).join(", ")}].concat(this.filters)}addCommitMessageFilter(commitMessage,include){return this.addFilter(WebhookFilterTypes.COMMIT_MESSAGE,commitMessage,include)}addHeadBranchFilter(branchName,include){return this.addHeadRefFilter(`refs/heads/${branchName}`,include)}addHeadTagFilter(tagName,include){return this.addHeadRefFilter(`refs/tags/${tagName}`,include)}addHeadRefFilter(refName,include){return this.addFilter(WebhookFilterTypes.HEAD_REF,refName,include)}addActorAccountId(accountId,include){return this.addFilter(WebhookFilterTypes.ACTOR_ACCOUNT_ID,accountId,include)}addBaseBranchFilter(branchName,include){return this.addBaseRefFilter(`refs/heads/${branchName}`,include)}addBaseRefFilter(refName,include){if(this.actions.has(EventAction.PUSH))throw new Error("A base reference condition cannot be added if a Group contains a PUSH event action");return this.addFilter(WebhookFilterTypes.BASE_REF,refName,include)}addFilePathFilter(pattern,include){return this.addFilter(WebhookFilterTypes.FILE_PATH,pattern,include)}addFilter(type,pattern,include){return new FilterGroup(this.actions,this.filters.concat([{type,pattern,excludeMatchedPattern:include?void 0:!0}]))}}_b=JSII_RTTI_SYMBOL_1,FilterGroup[_b]={fqn:"aws-cdk-lib.aws_codebuild.FilterGroup",version:"2.87.0"},exports.FilterGroup=FilterGroup;class ThirdPartyGitSource extends GitSource{constructor(props){super(props),this.badgeSupported=!0,this.webhook=props.webhook,this.reportBuildStatus=props.reportBuildStatus??!0,this.webhookFilters=props.webhookFilters||[],this.webhookTriggersBatchBuild=props.webhookTriggersBatchBuild,this.buildStatusUrl=props.buildStatusUrl}bind(_scope,project){const anyFilterGroupsProvided=this.webhookFilters.length>0,webhook=this.webhook??(anyFilterGroupsProvided?!0:void 0);if(!webhook&&anyFilterGroupsProvided)throw new Error("`webhookFilters` cannot be used when `webhook` is `false`");if(!webhook&&this.webhookTriggersBatchBuild)throw new Error("`webhookTriggersBatchBuild` cannot be used when `webhook` is `false`");const superConfig=super.bind(_scope,project);return this.webhookTriggersBatchBuild&&project.enableBatchBuilds(),{sourceProperty:{...superConfig.sourceProperty,reportBuildStatus:this.reportBuildStatus},sourceVersion:superConfig.sourceVersion,buildTriggers:webhook===void 0?void 0:{webhook,buildType:this.webhookTriggersBatchBuild?"BUILD_BATCH":void 0,filterGroups:anyFilterGroupsProvided?this.webhookFilters.map(fg=>fg._toJson()):void 0}}}}class CodeCommitSource extends GitSource{constructor(props){super(props),this.badgeSupported=!0,this.type=source_types_1.CODECOMMIT_SOURCE_TYPE,this.repo=props.repository}bind(_scope,project){project.addToRolePolicy(new iam.PolicyStatement({actions:["codecommit:GitPull"],resources:[this.repo.repositoryArn]}));const superConfig=super.bind(_scope,project);return{sourceProperty:{...superConfig.sourceProperty,location:this.repo.repositoryCloneUrlHttp},sourceVersion:superConfig.sourceVersion}}}class S3Source extends Source{constructor(props){super(props),this.type=source_types_1.S3_SOURCE_TYPE,this.bucket=props.bucket,this.path=props.path,this.version=props.version}bind(_scope,project){return this.bucket.grantRead(project,this.path),{sourceProperty:{...super.bind(_scope,project).sourceProperty,location:`${this.bucket.bucketName}/${this.path}`},sourceVersion:this.version}}}class CommonGithubSource extends ThirdPartyGitSource{constructor(props){super(props),this.buildStatusContext=props.buildStatusContext}bind(scope,project){const superConfig=super.bind(scope,project);return{sourceProperty:{...superConfig.sourceProperty,buildStatusConfig:this.buildStatusContext!==void 0||this.buildStatusUrl!==void 0?{context:this.buildStatusContext,targetUrl:this.buildStatusUrl}:void 0},sourceVersion:superConfig.sourceVersion,buildTriggers:superConfig.buildTriggers}}}class GitHubSource extends CommonGithubSource{constructor(props){super(props),this.type=source_types_1.GITHUB_SOURCE_TYPE,this.httpsCloneUrl=`https://github.com/${props.owner}/${props.repo}.git`}bind(_scope,project){const superConfig=super.bind(_scope,project);return{sourceProperty:{...superConfig.sourceProperty,location:this.httpsCloneUrl},sourceVersion:superConfig.sourceVersion,buildTriggers:superConfig.buildTriggers}}}class GitHubEnterpriseSource extends CommonGithubSource{constructor(props){super(props),this.type=source_types_1.GITHUB_ENTERPRISE_SOURCE_TYPE,this.httpsCloneUrl=props.httpsCloneUrl,this.ignoreSslErrors=props.ignoreSslErrors}bind(_scope,_project){if(this.hasCommitMessageFilterAndPrEvent())throw new Error("COMMIT_MESSAGE filters cannot be used with GitHub Enterprise Server pull request events");if(this.hasFilePathFilterAndPrEvent())throw new Error("FILE_PATH filters cannot be used with GitHub Enterprise Server pull request events");const superConfig=super.bind(_scope,_project);return{sourceProperty:{...superConfig.sourceProperty,location:this.httpsCloneUrl,insecureSsl:this.ignoreSslErrors},sourceVersion:superConfig.sourceVersion,buildTriggers:superConfig.buildTriggers}}hasCommitMessageFilterAndPrEvent(){return this.webhookFilters.some(fg=>fg._filters.some(fp=>fp.type===WebhookFilterTypes.COMMIT_MESSAGE)&&this.hasPrEvent(fg._actions))}hasFilePathFilterAndPrEvent(){return this.webhookFilters.some(fg=>fg._filters.some(fp=>fp.type===WebhookFilterTypes.FILE_PATH)&&this.hasPrEvent(fg._actions))}hasPrEvent(actions){return actions.includes(EventAction.PULL_REQUEST_CREATED||EventAction.PULL_REQUEST_MERGED||EventAction.PULL_REQUEST_REOPENED||EventAction.PULL_REQUEST_UPDATED)}}class BitBucketSource extends ThirdPartyGitSource{constructor(props){super(props),this.type=source_types_1.BITBUCKET_SOURCE_TYPE,this.httpsCloneUrl=`https://bitbucket.org/${props.owner}/${props.repo}.git`,this.buildStatusName=props.buildStatusName}bind(_scope,_project){if(this.anyWebhookFilterContainsPrReopenedEventAction())throw new Error("BitBucket sources do not support the PULL_REQUEST_REOPENED webhook event action");const superConfig=super.bind(_scope,_project);return{sourceProperty:{...superConfig.sourceProperty,location:this.httpsCloneUrl,buildStatusConfig:this.buildStatusName!==void 0||this.buildStatusUrl!==void 0?{context:this.buildStatusName,targetUrl:this.buildStatusUrl}:void 0},sourceVersion:superConfig.sourceVersion,buildTriggers:superConfig.buildTriggers}}anyWebhookFilterContainsPrReopenedEventAction(){return this.webhookFilters.findIndex(fg=>fg._actions.findIndex(a=>a===EventAction.PULL_REQUEST_REOPENED)!==-1)!==-1}}function set2Array(set){const ret=[];return set.forEach(el=>ret.push(el)),ret}
