"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.EcsDeploymentGroup=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),constructs_1=require("constructs"),application_1=require("./application"),deployment_config_1=require("./deployment-config"),ecs=require("../../../aws-ecs"),iam=require("../../../aws-iam"),cdk=require("../../../core"),cx_api_1=require("../../../cx-api"),codedeploy_generated_1=require("../codedeploy.generated"),base_deployment_group_1=require("../private/base-deployment-group"),utils_1=require("../private/utils");class EcsDeploymentGroup extends base_deployment_group_1.DeploymentGroupBase{static fromEcsDeploymentGroupAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_EcsDeploymentGroupAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEcsDeploymentGroupAttributes),error}return new ImportedEcsDeploymentGroup(scope,id,attrs)}constructor(scope,id,props){super(scope,id,{deploymentGroupName:props.deploymentGroupName,role:props.role,roleConstructId:"ServiceRole"});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_EcsDeploymentGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EcsDeploymentGroup),error}if(this.role=this._role,this.application=props.application||new application_1.EcsApplication(this,"Application"),this.alarms=props.alarms||[],this.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("AWSCodeDeployRoleForECS")),this.deploymentConfig=this._bindDeploymentConfig(props.deploymentConfig||deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE),cdk.Resource.isOwnedResource(props.service)){const cfnSvc=props.service.node.defaultChild;if(cfnSvc.deploymentController===void 0||cfnSvc.deploymentController.type!==ecs.DeploymentControllerType.CODE_DEPLOY)throw new Error("The ECS service associated with the deployment group must use the CODE_DEPLOY deployment controller type");if(cfnSvc.taskDefinition!==props.service.taskDefinition.family)throw new Error("The ECS service associated with the deployment group must specify the task definition using the task definition family name only. Otherwise, the task definition cannot be updated in the stack")}const removeAlarmsFromDeploymentGroup=cdk.FeatureFlags.of(this).isEnabled(cx_api_1.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP),resource=new codedeploy_generated_1.CfnDeploymentGroup(this,"Resource",{applicationName:this.application.applicationName,serviceRoleArn:this.role.roleArn,deploymentGroupName:this.physicalName,deploymentConfigName:this.deploymentConfig.deploymentConfigName,deploymentStyle:{deploymentType:"BLUE_GREEN",deploymentOption:"WITH_TRAFFIC_CONTROL"},ecsServices:[{clusterName:props.service.cluster.clusterName,serviceName:props.service.serviceName}],blueGreenDeploymentConfiguration:cdk.Lazy.any({produce:()=>this.renderBlueGreenDeploymentConfiguration(props.blueGreenDeploymentConfig)}),loadBalancerInfo:cdk.Lazy.any({produce:()=>this.renderLoadBalancerInfo(props.blueGreenDeploymentConfig)}),alarmConfiguration:cdk.Lazy.any({produce:()=>(0,utils_1.renderAlarmConfiguration)(this.alarms,props.ignorePollAlarmsFailure,removeAlarmsFromDeploymentGroup)}),autoRollbackConfiguration:cdk.Lazy.any({produce:()=>(0,utils_1.renderAutoRollbackConfiguration)(this.alarms,props.autoRollback)})});this._setNameAndArn(resource,this.application),constructs_1.Construct.isConstruct(this.deploymentConfig)&&this.node.addDependency(this.deploymentConfig)}addAlarm(alarm){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(alarm)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAlarm),error}this.alarms.push(alarm)}renderBlueGreenDeploymentConfiguration(options){return{deploymentReadyOption:{actionOnTimeout:options.deploymentApprovalWaitTime?"STOP_DEPLOYMENT":"CONTINUE_DEPLOYMENT",waitTimeInMinutes:options.deploymentApprovalWaitTime?.toMinutes()??0},terminateBlueInstancesOnDeploymentSuccess:{action:"TERMINATE",terminationWaitTimeInMinutes:options.terminationWaitTime?.toMinutes()??0}}}renderLoadBalancerInfo(options){return{targetGroupPairInfoList:[{targetGroups:[{name:options.blueTargetGroup.targetGroupName},{name:options.greenTargetGroup.targetGroupName}],prodTrafficRoute:{listenerArns:[options.listener.listenerArn]},testTrafficRoute:options.testListener?{listenerArns:[options.testListener.listenerArn]}:void 0}]}}}_a=JSII_RTTI_SYMBOL_1,EcsDeploymentGroup[_a]={fqn:"aws-cdk-lib.aws_codedeploy.EcsDeploymentGroup",version:"2.87.0"},exports.EcsDeploymentGroup=EcsDeploymentGroup;class ImportedEcsDeploymentGroup extends base_deployment_group_1.ImportedDeploymentGroupBase{constructor(scope,id,props){super(scope,id,{application:props.application,deploymentGroupName:props.deploymentGroupName}),this.application=props.application,this.deploymentConfig=this._bindDeploymentConfig(props.deploymentConfig||deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE)}}
