"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CustomLambdaDeploymentConfig=exports.CustomLambdaDeploymentConfigType=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),core_1=require("../../../core"),custom_resources_1=require("../../../custom-resources"),utils_1=require("../private/utils");var CustomLambdaDeploymentConfigType;(function(CustomLambdaDeploymentConfigType2){CustomLambdaDeploymentConfigType2.CANARY="Canary",CustomLambdaDeploymentConfigType2.LINEAR="Linear"})(CustomLambdaDeploymentConfigType=exports.CustomLambdaDeploymentConfigType||(exports.CustomLambdaDeploymentConfigType={}));class CustomLambdaDeploymentConfig extends core_1.Resource{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_codedeploy.CustomLambdaDeploymentConfig","CloudFormation now supports Lambda deployment configurations without custom resources. Use `LambdaDeploymentConfig`."),jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_CustomLambdaDeploymentConfigProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CustomLambdaDeploymentConfig),error}this.validateParameters(props);const deploymentType="TimeBased"+props.type.toString(),intervalMinutes=props.interval.toMinutes().toString(),percentage=props.percentage.toString();let routingConfig;props.type==CustomLambdaDeploymentConfigType.CANARY?routingConfig={type:deploymentType,timeBasedCanary:{canaryInterval:intervalMinutes,canaryPercentage:percentage}}:props.type==CustomLambdaDeploymentConfigType.LINEAR&&(routingConfig={type:deploymentType,timeBasedLinear:{linearInterval:intervalMinutes,linearPercentage:percentage}}),this.deploymentConfigName=props.deploymentConfigName??`${core_1.Names.uniqueId(this)}.Lambda${props.type}${props.percentage}Percent${props.type===CustomLambdaDeploymentConfigType.LINEAR?"Every":""}${props.interval.toMinutes()}Minutes`,this.deploymentConfigArn=(0,utils_1.arnForDeploymentConfig)(this.deploymentConfigName),new custom_resources_1.AwsCustomResource(this,"DeploymentConfig",{onCreate:{service:"CodeDeploy",action:"createDeploymentConfig",parameters:{deploymentConfigName:this.deploymentConfigName,computePlatform:"Lambda",trafficRoutingConfig:routingConfig},physicalResourceId:custom_resources_1.PhysicalResourceId.of(this.deploymentConfigName)},onUpdate:{service:"CodeDeploy",action:"createDeploymentConfig",parameters:{deploymentConfigName:this.deploymentConfigName,computePlatform:"Lambda",trafficRoutingConfig:routingConfig},physicalResourceId:custom_resources_1.PhysicalResourceId.of(this.deploymentConfigName)},onDelete:{service:"CodeDeploy",action:"deleteDeploymentConfig",parameters:{deploymentConfigName:this.deploymentConfigName}},policy:custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({resources:custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE}),installLatestAwsSdk:!1}),this.node.addValidation({validate:()=>(0,utils_1.validateName)("Deployment config",this.deploymentConfigName)})}validateParameters(props){if(!(1<=props.percentage&&props.percentage<=99))throw new Error(`Invalid deployment config percentage "${props.percentage.toString()}".         Step percentage must be an integer between 1 and 99.`);if(props.interval.toMinutes()>2880)throw new Error(`Invalid deployment config interval "${props.interval.toString()}".         Traffic shifting intervals must be positive integers up to 2880 (2 days).`)}}_a=JSII_RTTI_SYMBOL_1,CustomLambdaDeploymentConfig[_a]={fqn:"aws-cdk-lib.aws_codedeploy.CustomLambdaDeploymentConfig",version:"2.87.0"},exports.CustomLambdaDeploymentConfig=CustomLambdaDeploymentConfig;
