"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.DeploymentGroupBase=exports.ImportedDeploymentGroupBase=void 0;const predefined_deployment_config_1=require("./predefined-deployment-config"),utils_1=require("./utils"),iam=require("../../../aws-iam"),core_1=require("../../../core");class ImportedDeploymentGroupBase extends core_1.Resource{constructor(scope,id,props){const deploymentGroupName=props.deploymentGroupName,deploymentGroupArn=core_1.Arn.format({partition:core_1.Aws.PARTITION,account:props.application.env.account,region:props.application.env.region,service:"codedeploy",resource:"deploymentgroup",resourceName:`${props.application.applicationName}/${deploymentGroupName}`,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME});super(scope,id,{environmentFromArn:deploymentGroupArn}),this.deploymentGroupName=deploymentGroupName,this.deploymentGroupArn=deploymentGroupArn}_bindDeploymentConfig(config){return(0,predefined_deployment_config_1.isPredefinedDeploymentConfig)(config)?config.bindEnvironment(this):config}}exports.ImportedDeploymentGroupBase=ImportedDeploymentGroupBase;class DeploymentGroupBase extends core_1.Resource{constructor(scope,id,props){super(scope,id,{physicalName:props.deploymentGroupName}),this._role=props.role||new iam.Role(this,props.roleConstructId,{assumedBy:new iam.ServicePrincipal("codedeploy.amazonaws.com")}),this.node.addValidation({validate:()=>(0,utils_1.validateName)("Deployment group",this.physicalName)})}_bindDeploymentConfig(config){return(0,predefined_deployment_config_1.isPredefinedDeploymentConfig)(config)?config.bindEnvironment(this):config}_setNameAndArn(resource,application){this.deploymentGroupName=this.getResourceNameAttribute(resource.ref),this.deploymentGroupArn=this.getResourceArnAttribute(this.stack.formatArn({service:"codedeploy",resource:"deploymentgroup",resourceName:`${application.applicationName}/${resource.ref}`,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME}),{service:"codedeploy",resource:"deploymentgroup",resourceName:`${application.applicationName}/${this.physicalName}`,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}}exports.DeploymentGroupBase=DeploymentGroupBase;
