"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.UserPoolDomain=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cognito_generated_1=require("./cognito.generated"),core_1=require("../../core"),custom_resources_1=require("../../custom-resources");class UserPoolDomain extends core_1.Resource{static fromDomainName(scope,id,userPoolDomainName){class Import extends core_1.Resource{constructor(){super(...arguments),this.domainName=userPoolDomainName}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_UserPoolDomainProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,UserPoolDomain),error}if(!!props.customDomain==!!props.cognitoDomain)throw new Error("One of, and only one of, cognitoDomain or customDomain must be specified");if(props.cognitoDomain?.domainPrefix&&!core_1.Token.isUnresolved(props.cognitoDomain?.domainPrefix)&&!/^[a-z0-9-]+$/.test(props.cognitoDomain.domainPrefix))throw new Error("domainPrefix for cognitoDomain can contain only lowercase alphabets, numbers and hyphens");this.isCognitoDomain=!!props.cognitoDomain;const domainName=props.cognitoDomain?.domainPrefix||props.customDomain?.domainName,resource=new cognito_generated_1.CfnUserPoolDomain(this,"Resource",{userPoolId:props.userPool.userPoolId,domain:domainName,customDomainConfig:props.customDomain?{certificateArn:props.customDomain.certificate.certificateArn}:void 0});this.domainName=resource.ref}get cloudFrontDomainName(){if(!this.cloudFrontCustomResource){const sdkCall={service:"CognitoIdentityServiceProvider",action:"describeUserPoolDomain",parameters:{Domain:this.domainName},physicalResourceId:custom_resources_1.PhysicalResourceId.of(this.domainName)};this.cloudFrontCustomResource=new custom_resources_1.AwsCustomResource(this,"CloudFrontDomainName",{resourceType:"Custom::UserPoolCloudFrontDomainName",onCreate:sdkCall,onUpdate:sdkCall,policy:custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({resources:["*"]}),installLatestAwsSdk:!1})}return this.cloudFrontCustomResource.getResponseField("DomainDescription.CloudFrontDistribution")}baseUrl(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_BaseUrlOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.baseUrl),error}if(this.isCognitoDomain){const authDomain="auth"+(options?.fips?"-fips":"");return`https://${this.domainName}.${authDomain}.${core_1.Stack.of(this).region}.amazoncognito.com`}return`https://${this.domainName}`}signInUrl(client,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_UserPoolClient(client),jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_SignInUrlOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.signInUrl),error}let responseType;if(client.oAuthFlows.authorizationCodeGrant)responseType="code";else if(client.oAuthFlows.implicitCodeGrant)responseType="token";else throw new Error("signInUrl is not supported for clients without authorizationCodeGrant or implicitCodeGrant flow enabled");const path=options.signInPath??"/login";return`${this.baseUrl(options)}${path}?client_id=${client.userPoolClientId}&response_type=${responseType}&redirect_uri=${options.redirectUri}`}}_a=JSII_RTTI_SYMBOL_1,UserPoolDomain[_a]={fqn:"aws-cdk-lib.aws_cognito.UserPoolDomain",version:"2.87.0"},exports.UserPoolDomain=UserPoolDomain;
