"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.UserPoolEmail=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),punycode_1=require("punycode/"),core_1=require("../../core");class UserPoolEmail{static withCognito(replyTo){return new CognitoEmail(replyTo)}static withSES(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cognito_UserPoolSESOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.withSES),error}return new SESEmail(options)}}_a=JSII_RTTI_SYMBOL_1,UserPoolEmail[_a]={fqn:"aws-cdk-lib.aws_cognito.UserPoolEmail",version:"2.87.0"},exports.UserPoolEmail=UserPoolEmail;class CognitoEmail extends UserPoolEmail{constructor(replyTo){super(),this.replyTo=replyTo}_bind(_scope){return{replyToEmailAddress:encodeAndTest(this.replyTo),emailSendingAccount:"COGNITO_DEFAULT"}}}class SESEmail extends UserPoolEmail{constructor(options){super(),this.options=options}_bind(scope){const region=core_1.Stack.of(scope).region;if(core_1.Token.isUnresolved(region)&&!this.options.sesRegion)throw new Error('Your stack region cannot be determined so "sesRegion" is required in SESOptions');let from=encodeAndTest(this.options.fromEmail);if(this.options.fromName&&(from=`${formatFromName(this.options.fromName)} <${from}>`),this.options.sesVerifiedDomain&&this.options.fromEmail.split("@").pop()!==this.options.sesVerifiedDomain)throw new Error('"fromEmail" contains a different domain than the "sesVerifiedDomain"');return{from,replyToEmailAddress:encodeAndTest(this.options.replyTo),configurationSet:this.options.configurationSetName,emailSendingAccount:"DEVELOPER",sourceArn:core_1.Stack.of(scope).formatArn({service:"ses",resource:"identity",resourceName:encodeAndTest(this.options.sesVerifiedDomain??this.options.fromEmail),region:this.options.sesRegion??region})}}}function encodeAndTest(input){if(input){const local=input.split("@")[0];if(!/[\p{ASCII}]+/u.test(local))throw new Error("the local part of the email address must use ASCII characters only");return(0,punycode_1.toASCII)(input)}else return}function formatFromName(fromName){return isAscii(fromName)?isSimplePhrase(fromName)||isQuotedString(fromName)?fromName:`"${fromName.replace(/[\\"]/g,ch=>`\\${ch}`)}"`:`=?UTF-8?B?${Buffer.from(fromName,"utf-8").toString("base64")}?=`}function isAscii(input){return/^[\u0020-\u007E]+$/u.test(input)}function isSimplePhrase(input){return/^[\w !#$%&'*+-\/=?^_`{|}~]+$/.test(input)}function isQuotedString(input){return/^"(?:[^\\"]|\\.)*"$/.test(input)}
