"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DatabaseCluster=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),database_secret_1=require("./database-secret"),docdb_generated_1=require("./docdb.generated"),endpoint_1=require("./endpoint"),ec2=require("../../aws-ec2"),logs=require("../../aws-logs"),secretsmanager=require("../../aws-secretsmanager"),core_1=require("../../core");class DatabaseClusterBase extends core_1.Resource{asSecretAttachmentTarget(){return{targetId:this.clusterIdentifier,targetType:secretsmanager.AttachmentTargetType.DOCDB_DB_CLUSTER}}}class DatabaseCluster extends DatabaseClusterBase{static fromDatabaseClusterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_docdb_DatabaseClusterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDatabaseClusterAttributes),error}class Import extends DatabaseClusterBase{constructor(){super(...arguments),this.defaultPort=typeof attrs.port<"u"?ec2.Port.tcp(attrs.port):void 0,this.connections=new ec2.Connections({securityGroups:attrs.securityGroup?[attrs.securityGroup]:void 0,defaultPort:this.defaultPort}),this.clusterIdentifier=attrs.clusterIdentifier,this._instanceIdentifiers=attrs.instanceIdentifiers,this._clusterEndpoint=attrs.clusterEndpointAddress&&typeof attrs.port<"u"?new endpoint_1.Endpoint(attrs.clusterEndpointAddress,attrs.port):void 0,this._clusterReadEndpoint=attrs.readerEndpointAddress&&typeof attrs.port<"u"?new endpoint_1.Endpoint(attrs.readerEndpointAddress,attrs.port):void 0,this._instanceEndpoints=attrs.instanceEndpointAddresses&&typeof attrs.port<"u"?attrs.instanceEndpointAddresses.map(addr=>new endpoint_1.Endpoint(addr,attrs.port)):void 0,this._securityGroupId=attrs.securityGroup?.securityGroupId}get instanceIdentifiers(){if(!this._instanceIdentifiers)throw new Error("Cannot access `instanceIdentifiers` of an imported cluster without provided instanceIdentifiers");return this._instanceIdentifiers}get clusterEndpoint(){if(!this._clusterEndpoint)throw new Error("Cannot access `clusterEndpoint` of an imported cluster without an endpoint address and port");return this._clusterEndpoint}get clusterReadEndpoint(){if(!this._clusterReadEndpoint)throw new Error("Cannot access `clusterReadEndpoint` of an imported cluster without a readerEndpointAddress and port");return this._clusterReadEndpoint}get instanceEndpoints(){if(!this._instanceEndpoints)throw new Error("Cannot access `instanceEndpoints` of an imported cluster without instanceEndpointAddresses and port");return this._instanceEndpoints}get securityGroupId(){if(!this._securityGroupId)throw new Error("Cannot access `securityGroupId` of an imported cluster without securityGroupId");return this._securityGroupId}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id),this.instanceIdentifiers=[],this.instanceEndpoints=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_docdb_DatabaseClusterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DatabaseCluster),error}this.vpc=props.vpc,this.vpcSubnets=props.vpcSubnets;const{subnetIds,internetConnectivityEstablished}=this.vpc.selectSubnets(this.vpcSubnets);if(subnetIds.length<2)throw new Error(`Cluster requires at least 2 subnets, got ${subnetIds.length}`);const subnetGroup=new docdb_generated_1.CfnDBSubnetGroup(this,"Subnets",{dbSubnetGroupDescription:`Subnets for ${id} database`,subnetIds});let securityGroup;props.securityGroup?securityGroup=props.securityGroup:(securityGroup=new ec2.SecurityGroup(this,"SecurityGroup",{description:"DocumentDB security group",vpc:this.vpc}),securityGroup.node.defaultChild.applyRemovalPolicy(props.removalPolicy,{applyToUpdateReplacePolicy:!0})),this.securityGroupId=securityGroup.securityGroupId;const enableCloudwatchLogsExports=[];props.exportAuditLogsToCloudWatch&&enableCloudwatchLogsExports.push("audit"),props.exportProfilerLogsToCloudWatch&&enableCloudwatchLogsExports.push("profiler");let secret;props.masterUser.password||(secret=new database_secret_1.DatabaseSecret(this,"Secret",{username:props.masterUser.username,encryptionKey:props.masterUser.kmsKey,excludeCharacters:props.masterUser.excludeCharacters,secretName:props.masterUser.secretName}));const storageEncrypted=props.storageEncrypted??!0;if(props.kmsKey&&!storageEncrypted)throw new Error("KMS key supplied but storageEncrypted is false");this.cluster=new docdb_generated_1.CfnDBCluster(this,"Resource",{engineVersion:props.engineVersion,dbClusterIdentifier:props.dbClusterName,dbSubnetGroupName:subnetGroup.ref,port:props.port,vpcSecurityGroupIds:[this.securityGroupId],dbClusterParameterGroupName:props.parameterGroup?.parameterGroupName,deletionProtection:props.deletionProtection,masterUsername:secret?secret.secretValueFromJson("username").unsafeUnwrap():props.masterUser.username,masterUserPassword:secret?secret.secretValueFromJson("password").unsafeUnwrap():props.masterUser.password.unsafeUnwrap(),backupRetentionPeriod:props.backup?.retention?.toDays(),preferredBackupWindow:props.backup?.preferredWindow,preferredMaintenanceWindow:props.preferredMaintenanceWindow,enableCloudwatchLogsExports:enableCloudwatchLogsExports.length>0?enableCloudwatchLogsExports:void 0,kmsKeyId:props.kmsKey?.keyArn,storageEncrypted}),this.cluster.applyRemovalPolicy(props.removalPolicy,{applyToUpdateReplacePolicy:!0}),this.clusterIdentifier=this.cluster.ref,this.clusterResourceIdentifier=this.cluster.attrClusterResourceId;const port=core_1.Token.asNumber(this.cluster.attrPort);this.clusterEndpoint=new endpoint_1.Endpoint(this.cluster.attrEndpoint,port),this.clusterReadEndpoint=new endpoint_1.Endpoint(this.cluster.attrReadEndpoint,port),this.setLogRetention(this,props,enableCloudwatchLogsExports),secret&&(this.secret=secret.attach(this));const instanceCount=props.instances??DatabaseCluster.DEFAULT_NUM_INSTANCES;if(instanceCount<1)throw new Error("At least one instance is required");for(let i=0;i<instanceCount;i++){const instanceIndex=i+1,instanceIdentifier=props.instanceIdentifierBase!=null?`${props.instanceIdentifierBase}${instanceIndex}`:props.dbClusterName!=null?`${props.dbClusterName}instance${instanceIndex}`:void 0,instance=new docdb_generated_1.CfnDBInstance(this,`Instance${instanceIndex}`,{dbClusterIdentifier:this.cluster.ref,dbInstanceIdentifier:instanceIdentifier,dbInstanceClass:databaseInstanceType(props.instanceType),enablePerformanceInsights:props.enablePerformanceInsights});instance.applyRemovalPolicy(props.removalPolicy,{applyToUpdateReplacePolicy:!0}),instance.node.addDependency(internetConnectivityEstablished),this.instanceIdentifiers.push(instance.ref),this.instanceEndpoints.push(new endpoint_1.Endpoint(instance.attrEndpoint,port))}this.connections=new ec2.Connections({defaultPort:ec2.Port.tcp(port),securityGroups:[securityGroup]})}setLogRetention(cluster,props,cloudwatchLogsExports){if(props.cloudWatchLogsRetention)for(const log of cloudwatchLogsExports)new logs.LogRetention(cluster,`LogRetention${log}`,{logGroupName:`/aws/docdb/${cluster.clusterIdentifier}/${log}`,retention:props.cloudWatchLogsRetention,role:props.cloudWatchLogsRetentionRole})}addRotationSingleUser(automaticallyAfter){try{jsiiDeprecationWarnings.aws_cdk_lib_Duration(automaticallyAfter)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addRotationSingleUser),error}if(!this.secret)throw new Error("Cannot add single user rotation for a cluster without secret.");const id="RotationSingleUser";if(this.node.tryFindChild(id))throw new Error("A single user rotation was already added to this cluster.");return new secretsmanager.SecretRotation(this,id,{secret:this.secret,automaticallyAfter,application:DatabaseCluster.SINGLE_USER_ROTATION_APPLICATION,excludeCharacters:this.node.tryFindChild("Secret")._excludedCharacters,vpc:this.vpc,vpcSubnets:this.vpcSubnets,target:this})}addRotationMultiUser(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_docdb_RotationMultiUserOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addRotationMultiUser),error}if(!this.secret)throw new Error("Cannot add multi user rotation for a cluster without secret.");return new secretsmanager.SecretRotation(this,id,{secret:options.secret,masterSecret:this.secret,automaticallyAfter:options.automaticallyAfter,excludeCharacters:this.node.tryFindChild("Secret")._excludedCharacters,application:DatabaseCluster.MULTI_USER_ROTATION_APPLICATION,vpc:this.vpc,vpcSubnets:this.vpcSubnets,target:this})}addSecurityGroups(...securityGroups){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_ISecurityGroup(securityGroups)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecurityGroups),error}this.cluster.vpcSecurityGroupIds===void 0&&(this.cluster.vpcSecurityGroupIds=[]),this.cluster.vpcSecurityGroupIds.push(...securityGroups.map(sg=>sg.securityGroupId))}}_a=JSII_RTTI_SYMBOL_1,DatabaseCluster[_a]={fqn:"aws-cdk-lib.aws_docdb.DatabaseCluster",version:"2.87.0"},DatabaseCluster.DEFAULT_NUM_INSTANCES=1,DatabaseCluster.DEFAULT_PORT=27017,DatabaseCluster.SINGLE_USER_ROTATION_APPLICATION=secretsmanager.SecretRotationApplication.MONGODB_ROTATION_SINGLE_USER,DatabaseCluster.MULTI_USER_ROTATION_APPLICATION=secretsmanager.SecretRotationApplication.MONGODB_ROTATION_MULTI_USER,exports.DatabaseCluster=DatabaseCluster;function databaseInstanceType(instanceType){return"db."+instanceType.toString()}
