"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DatabaseInstance=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),docdb_generated_1=require("./docdb.generated"),endpoint_1=require("./endpoint"),ec2=require("../../aws-ec2"),core_1=require("../../core"),cdk=require("../../core");class DatabaseInstanceBase extends cdk.Resource{static fromDatabaseInstanceAttributes(scope,id,attrs){class Import extends DatabaseInstanceBase{constructor(){super(...arguments),this.defaultPort=ec2.Port.tcp(attrs.port),this.instanceIdentifier=attrs.instanceIdentifier,this.dbInstanceEndpointAddress=attrs.instanceEndpointAddress,this.dbInstanceEndpointPort=attrs.port.toString(),this.instanceEndpoint=new endpoint_1.Endpoint(attrs.instanceEndpointAddress,attrs.port)}}return new Import(scope,id)}get instanceArn(){return cdk.Stack.of(this).formatArn({service:"rds",resource:"db",arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME,resourceName:this.instanceIdentifier})}}class DatabaseInstance extends DatabaseInstanceBase{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_docdb_DatabaseInstanceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DatabaseInstance),error}const instance=new docdb_generated_1.CfnDBInstance(this,"Resource",{dbClusterIdentifier:props.cluster.clusterIdentifier,dbInstanceClass:`db.${props.instanceType}`,autoMinorVersionUpgrade:props.autoMinorVersionUpgrade??!0,availabilityZone:props.availabilityZone,dbInstanceIdentifier:props.dbInstanceName,preferredMaintenanceWindow:props.preferredMaintenanceWindow,enablePerformanceInsights:props.enablePerformanceInsights});this.cluster=props.cluster,this.instanceIdentifier=instance.ref,this.dbInstanceEndpointAddress=instance.attrEndpoint,this.dbInstanceEndpointPort=instance.attrPort;const portAttribute=cdk.Token.asNumber(instance.attrPort);this.instanceEndpoint=new endpoint_1.Endpoint(instance.attrEndpoint,portAttribute),instance.applyRemovalPolicy(props.removalPolicy,{applyToUpdateReplacePolicy:!0})}}_a=JSII_RTTI_SYMBOL_1,DatabaseInstance[_a]={fqn:"aws-cdk-lib.aws_docdb.DatabaseInstance",version:"2.87.0"},exports.DatabaseInstance=DatabaseInstance;
