"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Instance=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aspects_1=require("./aspects"),connections_1=require("./connections"),ec2_generated_1=require("./ec2.generated"),ebs_util_1=require("./private/ebs-util"),security_group_1=require("./security-group"),vpc_1=require("./vpc"),iam=require("../../aws-iam"),core_1=require("../../core"),helpers_internal_1=require("../../core/lib/helpers-internal"),NAME_TAG="Name";class Instance extends core_1.Resource{constructor(scope,id,props){super(scope,id),this.securityGroups=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InstanceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Instance),error}if(props.initOptions&&!props.init)throw new Error("Setting 'initOptions' requires that 'init' is also set");props.securityGroup?this.securityGroup=props.securityGroup:this.securityGroup=new security_group_1.SecurityGroup(this,"InstanceSecurityGroup",{vpc:props.vpc,allowAllOutbound:props.allowAllOutbound!==!1}),this.connections=new connections_1.Connections({securityGroups:[this.securityGroup]}),this.securityGroups.push(this.securityGroup),core_1.Tags.of(this).add(NAME_TAG,props.instanceName||this.node.path),this.role=props.role||new iam.Role(this,"InstanceRole",{assumedBy:new iam.ServicePrincipal("ec2.amazonaws.com")}),this.grantPrincipal=this.role,props.ssmSessionPermissions&&this.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("AmazonSSMManagedInstanceCore"));const iamProfile=new iam.CfnInstanceProfile(this,"InstanceProfile",{roles:[this.role.roleName]}),imageConfig=props.machineImage.getImage(this);this.userData=props.userData??imageConfig.userData;const userDataToken=core_1.Lazy.string({produce:()=>core_1.Fn.base64(this.userData.render())}),securityGroupsToken=core_1.Lazy.list({produce:()=>this.securityGroups.map(sg=>sg.securityGroupId)}),{subnets,hasPublic}=props.vpc.selectSubnets(props.vpcSubnets);let subnet;if(props.availabilityZone){const selected=subnets.filter(sn=>sn.availabilityZone===props.availabilityZone);selected.length===1?subnet=selected[0]:core_1.Annotations.of(this).addError(`Need exactly 1 subnet to match AZ '${props.availabilityZone}', found ${selected.length}. Use a different availabilityZone.`)}else subnets.length>0?subnet=subnets[0]:core_1.Annotations.of(this).addError(`Did not find any subnets matching '${JSON.stringify(props.vpcSubnets)}', please use a different selection.`);subnet||(subnet=vpc_1.Subnet.fromSubnetAttributes(this,"DummySubnet",{subnetId:"s-notfound",availabilityZone:"az-notfound"}));const networkInterfaces=props.associatePublicIpAddress!==void 0?[{deviceIndex:"0",associatePublicIpAddress:props.associatePublicIpAddress,subnetId:subnet.subnetId,groupSet:securityGroupsToken,privateIpAddress:props.privateIpAddress}]:void 0;if(this.instance=new ec2_generated_1.CfnInstance(this,"Resource",{imageId:imageConfig.imageId,keyName:props.keyName,instanceType:props.instanceType.toString(),subnetId:networkInterfaces?void 0:subnet.subnetId,securityGroupIds:networkInterfaces?void 0:securityGroupsToken,networkInterfaces,iamInstanceProfile:iamProfile.ref,userData:userDataToken,availabilityZone:subnet.availabilityZone,sourceDestCheck:props.sourceDestCheck,blockDeviceMappings:props.blockDevices!==void 0?(0,ebs_util_1.instanceBlockDeviceMappings)(this,props.blockDevices):void 0,privateIpAddress:networkInterfaces?void 0:props.privateIpAddress,propagateTagsToVolumeOnCreation:props.propagateTagsToVolumeOnCreation,monitoring:props.detailedMonitoring}),this.instance.node.addDependency(this.role),props.associatePublicIpAddress!==void 0&&props.associatePublicIpAddress){const internetConnected=props.vpc.selectSubnets(props.vpcSubnets).internetConnectivityEstablished;this.instance.node.addDependency(internetConnected)}if(!hasPublic&&props.associatePublicIpAddress)throw new Error("To set 'associatePublicIpAddress: true' you must select Public subnets (vpcSubnets: { subnetType: SubnetType.PUBLIC })");this.osType=imageConfig.osType,this.node.defaultChild=this.instance,this.instanceId=this.instance.ref,this.instanceAvailabilityZone=this.instance.attrAvailabilityZone,this.instancePrivateDnsName=this.instance.attrPrivateDnsName,this.instancePrivateIp=this.instance.attrPrivateIp,this.instancePublicDnsName=this.instance.attrPublicDnsName,this.instancePublicIp=this.instance.attrPublicIp,props.init&&this.applyCloudFormationInit(props.init,props.initOptions),this.applyUpdatePolicies(props);const originalLogicalId=core_1.Stack.of(this).getLogicalId(this.instance);let recursing=!1;this.instance.overrideLogicalId(core_1.Lazy.uncachedString({produce:context=>{if(recursing||!(props.userDataCausesReplacement??props.initOptions))return originalLogicalId;const fragments=new Array;recursing=!0;try{fragments.push(JSON.stringify(context.resolve(this.userData.render())))}finally{recursing=!1}const digest=(0,helpers_internal_1.md5hash)(fragments.join("")).slice(0,16);return`${originalLogicalId}${digest}`}})),props.requireImdsv2&&core_1.Aspects.of(this).add(new aspects_1.InstanceRequireImdsv2Aspect)}addSecurityGroup(securityGroup){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_ISecurityGroup(securityGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecurityGroup),error}this.securityGroups.push(securityGroup)}addUserData(...commands){this.userData.addCommands(...commands)}addToRolePolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToRolePolicy),error}this.role.addToPrincipalPolicy(statement)}applyCloudFormationInit(init,options={}){init.attach(this.instance,{platform:this.osType,instanceRole:this.role,userData:this.userData,configSets:options.configSets,embedFingerprint:options.embedFingerprint,printLog:options.printLog,ignoreFailures:options.ignoreFailures,includeRole:options.includeRole,includeUrl:options.includeUrl}),this.waitForResourceSignal(options.timeout??core_1.Duration.minutes(5))}waitForResourceSignal(timeout){const oldResourceSignal=this.instance.cfnOptions.creationPolicy?.resourceSignal;this.instance.cfnOptions.creationPolicy={...this.instance.cfnOptions.creationPolicy,resourceSignal:{count:(oldResourceSignal?.count??0)+1,timeout:(oldResourceSignal?.timeout?core_1.Duration.parse(oldResourceSignal?.timeout).plus(timeout):timeout).toIsoString()}}}applyUpdatePolicies(props){props.resourceSignalTimeout!==void 0&&(this.instance.cfnOptions.creationPolicy={...this.instance.cfnOptions.creationPolicy,resourceSignal:{timeout:props.resourceSignalTimeout&&props.resourceSignalTimeout.toIsoString()}})}}_a=JSII_RTTI_SYMBOL_1,Instance[_a]={fqn:"aws-cdk-lib.aws_ec2.Instance",version:"2.87.0"},exports.Instance=Instance;
