"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LaunchTemplate=exports.LaunchTemplateSpecialVersions=exports.LaunchTemplateHttpTokens=exports.SpotRequestType=exports.SpotInstanceInterruption=exports.InstanceInitiatedShutdownBehavior=exports.CpuCredits=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),connections_1=require("./connections"),ec2_generated_1=require("./ec2.generated"),ebs_util_1=require("./private/ebs-util"),iam=require("../../aws-iam"),core_1=require("../../core"),cxapi=require("../../cx-api"),NAME_TAG="Name";var CpuCredits;(function(CpuCredits2){CpuCredits2.STANDARD="standard",CpuCredits2.UNLIMITED="unlimited"})(CpuCredits=exports.CpuCredits||(exports.CpuCredits={}));var InstanceInitiatedShutdownBehavior;(function(InstanceInitiatedShutdownBehavior2){InstanceInitiatedShutdownBehavior2.STOP="stop",InstanceInitiatedShutdownBehavior2.TERMINATE="terminate"})(InstanceInitiatedShutdownBehavior=exports.InstanceInitiatedShutdownBehavior||(exports.InstanceInitiatedShutdownBehavior={}));var SpotInstanceInterruption;(function(SpotInstanceInterruption2){SpotInstanceInterruption2.STOP="stop",SpotInstanceInterruption2.TERMINATE="terminate",SpotInstanceInterruption2.HIBERNATE="hibernate"})(SpotInstanceInterruption=exports.SpotInstanceInterruption||(exports.SpotInstanceInterruption={}));var SpotRequestType;(function(SpotRequestType2){SpotRequestType2.ONE_TIME="one-time",SpotRequestType2.PERSISTENT="persistent"})(SpotRequestType=exports.SpotRequestType||(exports.SpotRequestType={}));var LaunchTemplateHttpTokens;(function(LaunchTemplateHttpTokens2){LaunchTemplateHttpTokens2.OPTIONAL="optional",LaunchTemplateHttpTokens2.REQUIRED="required"})(LaunchTemplateHttpTokens=exports.LaunchTemplateHttpTokens||(exports.LaunchTemplateHttpTokens={}));class LaunchTemplateSpecialVersions{}_a=JSII_RTTI_SYMBOL_1,LaunchTemplateSpecialVersions[_a]={fqn:"aws-cdk-lib.aws_ec2.LaunchTemplateSpecialVersions",version:"2.87.0"},LaunchTemplateSpecialVersions.LATEST_VERSION="$Latest",LaunchTemplateSpecialVersions.DEFAULT_VERSION="$Default",exports.LaunchTemplateSpecialVersions=LaunchTemplateSpecialVersions;class LaunchTemplate extends core_1.Resource{static fromLaunchTemplateAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_LaunchTemplateAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLaunchTemplateAttributes),error}const haveId=!!attrs.launchTemplateId,haveName=!!attrs.launchTemplateName;if(haveId==haveName)throw new Error("LaunchTemplate.fromLaunchTemplateAttributes() requires exactly one of launchTemplateId or launchTemplateName be provided.");class Import extends core_1.Resource{constructor(){super(...arguments),this.versionNumber=attrs.versionNumber??LaunchTemplateSpecialVersions.DEFAULT_VERSION,this.launchTemplateId=attrs.launchTemplateId,this.launchTemplateName=attrs.launchTemplateName}}return new Import(scope,id)}constructor(scope,id,props={}){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_LaunchTemplateProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,LaunchTemplate),error}const spotDuration=props?.spotOptions?.blockDuration?.toHours({integral:!0});spotDuration!==void 0&&(spotDuration<1||spotDuration>6)&&core_1.Annotations.of(this).addError("Spot block duration must be exactly 1, 2, 3, 4, 5, or 6 hours."),props.httpPutResponseHopLimit!==void 0&&(props.httpPutResponseHopLimit<1||props.httpPutResponseHopLimit>64)&&core_1.Annotations.of(this).addError("HttpPutResponseHopLimit must between 1 and 64"),this.role=props.role,this._grantPrincipal=this.role;const iamProfile=this.role?new iam.CfnInstanceProfile(this,"Profile",{roles:[this.role.roleName]}):void 0;props.securityGroup&&(this._connections=new connections_1.Connections({securityGroups:[props.securityGroup]}));const securityGroupsToken=core_1.Lazy.list({produce:()=>{if(this._connections&&this._connections.securityGroups.length>0)return this._connections.securityGroups.map(sg=>sg.securityGroupId)}}),imageConfig=props.machineImage?.getImage(this);imageConfig&&(this.osType=imageConfig.osType,this.imageId=imageConfig.imageId),core_1.FeatureFlags.of(this).isEnabled(cxapi.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA)?this.userData=props.userData??imageConfig?.userData:props.userData&&(this.userData=props.userData);const userDataToken=core_1.Lazy.string({produce:()=>{if(this.userData)return core_1.Fn.base64(this.userData.render())}});this.instanceType=props.instanceType;let marketOptions;props?.spotOptions&&(marketOptions={marketType:"spot",spotOptions:{blockDurationMinutes:spotDuration!==void 0?spotDuration*60:void 0,instanceInterruptionBehavior:props.spotOptions.interruptionBehavior,maxPrice:props.spotOptions.maxPrice?.toString(),spotInstanceType:props.spotOptions.requestType,validUntil:props.spotOptions.validUntil?.date.toUTCString()}},Object.keys(marketOptions.spotOptions).filter(k=>marketOptions.spotOptions[k]).length==0&&(marketOptions.spotOptions=void 0)),this.tags=new core_1.TagManager(core_1.TagType.KEY_VALUE,"AWS::EC2::LaunchTemplate");const tagsToken=core_1.Lazy.any({produce:()=>{if(this.tags.hasTags()){const lowerCaseRenderedTags=this.tags.renderTags().map(tag=>({key:tag.Key,value:tag.Value}));return[{resourceType:"instance",tags:lowerCaseRenderedTags},{resourceType:"volume",tags:lowerCaseRenderedTags}]}}}),ltTagsToken=core_1.Lazy.any({produce:()=>{if(this.tags.hasTags())return[{resourceType:"launch-template",tags:this.tags.renderTags().map(tag=>({key:tag.Key,value:tag.Value}))}]}}),resource=new ec2_generated_1.CfnLaunchTemplate(this,"Resource",{launchTemplateName:props?.launchTemplateName,launchTemplateData:{blockDeviceMappings:props?.blockDevices!==void 0?(0,ebs_util_1.launchTemplateBlockDeviceMappings)(this,props.blockDevices):void 0,creditSpecification:props?.cpuCredits!==void 0?{cpuCredits:props.cpuCredits}:void 0,disableApiTermination:props?.disableApiTermination,ebsOptimized:props?.ebsOptimized,enclaveOptions:props?.nitroEnclaveEnabled!==void 0?{enabled:props.nitroEnclaveEnabled}:void 0,hibernationOptions:props?.hibernationConfigured!==void 0?{configured:props.hibernationConfigured}:void 0,iamInstanceProfile:iamProfile!==void 0?{arn:iamProfile.getAtt("Arn").toString()}:void 0,imageId:imageConfig?.imageId,instanceType:props?.instanceType?.toString(),instanceInitiatedShutdownBehavior:props?.instanceInitiatedShutdownBehavior,instanceMarketOptions:marketOptions,keyName:props?.keyName,monitoring:props?.detailedMonitoring!==void 0?{enabled:props.detailedMonitoring}:void 0,securityGroupIds:securityGroupsToken,tagSpecifications:tagsToken,userData:userDataToken,metadataOptions:this.renderMetadataOptions(props)},tagSpecifications:ltTagsToken});core_1.Tags.of(this).add(NAME_TAG,this.node.path),this.defaultVersionNumber=resource.attrDefaultVersionNumber,this.latestVersionNumber=resource.attrLatestVersionNumber,this.launchTemplateId=resource.ref,this.versionNumber=core_1.Token.asString(resource.getAtt("LatestVersionNumber"))}renderMetadataOptions(props){let requireMetadataOptions=!1;if(props.requireImdsv2===!0&&props.httpTokens===LaunchTemplateHttpTokens.OPTIONAL&&core_1.Annotations.of(this).addError("httpTokens must be required when requireImdsv2 is true"),(props.httpEndpoint!==void 0||props.httpProtocolIpv6!==void 0||props.httpPutResponseHopLimit!==void 0||props.httpTokens!==void 0||props.instanceMetadataTags!==void 0||props.requireImdsv2===!0)&&(requireMetadataOptions=!0),requireMetadataOptions)return{httpEndpoint:props.httpEndpoint===!0?"enabled":props.httpEndpoint===!1?"disabled":void 0,httpProtocolIpv6:props.httpProtocolIpv6===!0?"enabled":props.httpProtocolIpv6===!1?"disabled":void 0,httpPutResponseHopLimit:props.httpPutResponseHopLimit,httpTokens:props.requireImdsv2===!0?LaunchTemplateHttpTokens.REQUIRED:props.httpTokens,instanceMetadataTags:props.instanceMetadataTags===!0?"enabled":props.instanceMetadataTags===!1?"disabled":void 0}}addSecurityGroup(securityGroup){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_ISecurityGroup(securityGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecurityGroup),error}if(!this._connections)throw new Error("LaunchTemplate can only be added a securityGroup if another securityGroup is initialized in the constructor.");this._connections.addSecurityGroup(securityGroup)}get connections(){if(!this._connections)throw new Error("LaunchTemplate can only be used as IConnectable if a securityGroup is provided when constructing it.");return this._connections}get grantPrincipal(){if(!this._grantPrincipal)throw new Error("LaunchTemplate can only be used as IGrantable if a role is provided when constructing it.");return this._grantPrincipal}}_b=JSII_RTTI_SYMBOL_1,LaunchTemplate[_b]={fqn:"aws-cdk-lib.aws_ec2.LaunchTemplate",version:"2.87.0"},exports.LaunchTemplate=LaunchTemplate;
