"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.CidrBlock=exports.NetworkBuilder=exports.NetworkUtils=exports.InvalidCidrRangeError=void 0;class InvalidCidrRangeError extends Error{constructor(cidr){super(cidr+" is not a valid VPC CIDR range (must be between /16 and /28)"),Object.setPrototypeOf(this,InvalidCidrRangeError.prototype)}}exports.InvalidCidrRangeError=InvalidCidrRangeError;class NetworkUtils{static validIp(ipAddress){const octets=ipAddress.split(".");return octets.length!==4?!1:octets.map(octet=>parseInt(octet,10)).filter(octet=>octet>=0&&octet<=255).length===4}static ipToNum(ipAddress){if(!this.validIp(ipAddress))throw new Error(`${ipAddress} is not valid`);return ipAddress.split(".").reduce((p,c,i)=>p+parseInt(c,10)*256**(3-i),0)}static numToIp(ipNum){let remaining=ipNum;const address=new Array;for(let i=0;i<4;i++)remaining!==0?(address.push(Math.floor(remaining/256**(3-i))),remaining=remaining%256**(3-i)):address.push(0);const ipAddress=address.join(".");if(!this.validIp(ipAddress))throw new Error(`${ipAddress} is not a valid IP Address`);return ipAddress}}exports.NetworkUtils=NetworkUtils;class NetworkBuilder{constructor(cidr){this.subnetCidrs=[],this.networkCidr=new CidrBlock(cidr),this.subnetCidrs=[],this.nextAvailableIp=this.networkCidr.minAddress()}addSubnet(mask){return this.addSubnets(mask,1)[0]}addSubnets(mask,count=1){if(mask<16||mask>28)throw new InvalidCidrRangeError(`x.x.x.x/${mask}`);const maxIp=this.nextAvailableIp+CidrBlock.calculateNetsize(mask)*count;if(this.networkCidr.maxAddress()<maxIp-1)throw new Error(`${count} of /${mask} exceeds remaining space of ${this.networkCidr.cidr}`);const subnets=[];for(let i=0;i<count;i++){const subnet=new CidrBlock(this.nextAvailableIp,mask);this.nextAvailableIp=subnet.nextBlock().minAddress(),this.subnetCidrs.push(subnet),subnets.push(subnet)}return subnets.map(subnet=>subnet.cidr)}get cidrStrings(){return this.subnetCidrs.map(subnet=>subnet.cidr)}maskForRemainingSubnets(subnetCount){const remaining=this.networkCidr.maxAddress()-this.nextAvailableIp+1,ipsPerSubnet=Math.floor(remaining/subnetCount);return 32-Math.floor(Math.log2(ipsPerSubnet))}}exports.NetworkBuilder=NetworkBuilder;class CidrBlock{static calculateNetmask(mask){return NetworkUtils.numToIp(2**32-2**(32-mask))}static calculateNetsize(mask){return 2**(32-mask)}constructor(ipAddressOrCidr,mask){typeof ipAddressOrCidr=="string"?(this.mask=parseInt(ipAddressOrCidr.split("/")[1],10),this.networkAddress=NetworkUtils.ipToNum(ipAddressOrCidr.split("/")[0])+CidrBlock.calculateNetsize(this.mask)-1):(typeof mask=="number"?this.mask=mask:this.mask=16,this.networkAddress=ipAddressOrCidr+CidrBlock.calculateNetsize(this.mask)-1,this.networkSize=2**(32-this.mask)),this.networkSize=2**(32-this.mask),this.cidr=`${this.minIp()}/${this.mask}`}maxIp(){return NetworkUtils.numToIp(this.maxAddress())}minIp(){return NetworkUtils.numToIp(this.minAddress())}minAddress(){const div=this.networkAddress%this.networkSize;return this.networkAddress-div}maxAddress(){return this.minAddress()+this.networkSize-1}nextBlock(){return new CidrBlock(this.maxAddress()+1,this.mask)}containsCidr(other){return this.maxAddress()>=other.maxAddress()&&this.minAddress()<=other.minAddress()}}exports.CidrBlock=CidrBlock;
