"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Volume=exports.EbsDeviceVolumeType=exports.BlockDeviceVolume=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2_generated_1=require("./ec2.generated"),aws_iam_1=require("../../aws-iam"),aws_kms_1=require("../../aws-kms"),core_1=require("../../core"),helpers_internal_1=require("../../core/lib/helpers-internal");class BlockDeviceVolume{static ebs(volumeSize,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_EbsDeviceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.ebs),error}return new this({...options,volumeSize})}static ebsFromSnapshot(snapshotId,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_EbsDeviceSnapshotOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.ebsFromSnapshot),error}return new this({...options,snapshotId})}static ephemeral(volumeIndex){if(volumeIndex<0)throw new Error(`volumeIndex must be a number starting from 0, got "${volumeIndex}"`);return new this(void 0,`ephemeral${volumeIndex}`)}constructor(ebsDevice,virtualName){this.ebsDevice=ebsDevice,this.virtualName=virtualName;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_EbsDeviceProps(ebsDevice)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BlockDeviceVolume),error}}}_a=JSII_RTTI_SYMBOL_1,BlockDeviceVolume[_a]={fqn:"aws-cdk-lib.aws_ec2.BlockDeviceVolume",version:"2.87.0"},exports.BlockDeviceVolume=BlockDeviceVolume;var EbsDeviceVolumeType;(function(EbsDeviceVolumeType2){EbsDeviceVolumeType2.STANDARD="standard",EbsDeviceVolumeType2.IO1="io1",EbsDeviceVolumeType2.IO2="io2",EbsDeviceVolumeType2.GP2="gp2",EbsDeviceVolumeType2.GP3="gp3",EbsDeviceVolumeType2.ST1="st1",EbsDeviceVolumeType2.SC1="sc1",EbsDeviceVolumeType2.GENERAL_PURPOSE_SSD="gp2",EbsDeviceVolumeType2.GENERAL_PURPOSE_SSD_GP3="gp3",EbsDeviceVolumeType2.PROVISIONED_IOPS_SSD="io1",EbsDeviceVolumeType2.PROVISIONED_IOPS_SSD_IO2="io2",EbsDeviceVolumeType2.THROUGHPUT_OPTIMIZED_HDD="st1",EbsDeviceVolumeType2.COLD_HDD="sc1",EbsDeviceVolumeType2.MAGNETIC="standard"})(EbsDeviceVolumeType=exports.EbsDeviceVolumeType||(exports.EbsDeviceVolumeType={}));class VolumeBase extends core_1.Resource{grantAttachVolume(grantee,instances){const result=aws_iam_1.Grant.addToPrincipal({grantee,actions:["ec2:AttachVolume"],resourceArns:this.collectGrantResourceArns(instances)});return this.encryptionKey&&this.encryptionKey.grant(grantee,"kms:CreateGrant").principalStatement.addConditions({Bool:{"kms:GrantIsForAWSResource":!0},StringEquals:{"kms:ViaService":`ec2.${core_1.Stack.of(this).region}.amazonaws.com`,"kms:GrantConstraintType":"EncryptionContextSubset"}}),result}grantAttachVolumeByResourceTag(grantee,constructs,tagKeySuffix){const tagValue=this.calculateResourceTagValue([this,...constructs]),tagKey=`VolumeGrantAttach-${tagKeySuffix??tagValue.slice(0,10).toUpperCase()}`,grantCondition={};grantCondition[`ec2:ResourceTag/${tagKey}`]=tagValue;const result=this.grantAttachVolume(grantee);return result.principalStatement.addCondition("ForAnyValue:StringEquals",grantCondition),core_1.Tags.of(this).add(tagKey,tagValue),constructs.forEach(construct=>core_1.Tags.of(construct).add(tagKey,tagValue)),result}grantDetachVolume(grantee,instances){return aws_iam_1.Grant.addToPrincipal({grantee,actions:["ec2:DetachVolume"],resourceArns:this.collectGrantResourceArns(instances)})}grantDetachVolumeByResourceTag(grantee,constructs,tagKeySuffix){const tagValue=this.calculateResourceTagValue([this,...constructs]),tagKey=`VolumeGrantDetach-${tagKeySuffix??tagValue.slice(0,10).toUpperCase()}`,grantCondition={};grantCondition[`ec2:ResourceTag/${tagKey}`]=tagValue;const result=this.grantDetachVolume(grantee);return result.principalStatement.addCondition("ForAnyValue:StringEquals",grantCondition),core_1.Tags.of(this).add(tagKey,tagValue),constructs.forEach(construct=>core_1.Tags.of(construct).add(tagKey,tagValue)),result}collectGrantResourceArns(instances){const stack=core_1.Stack.of(this),resourceArns=[`arn:${stack.partition}:ec2:${stack.region}:${stack.account}:volume/${this.volumeId}`],instanceArnPrefix=`arn:${stack.partition}:ec2:${stack.region}:${stack.account}:instance`;return instances?instances.forEach(instance=>resourceArns.push(`${instanceArnPrefix}/${instance?.instanceId}`)):resourceArns.push(`${instanceArnPrefix}/*`),resourceArns}calculateResourceTagValue(constructs){return(0,helpers_internal_1.md5hash)(constructs.map(c=>core_1.Names.uniqueId(c)).join(""))}}class Volume extends VolumeBase{static fromVolumeAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VolumeAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromVolumeAttributes),error}class Import extends VolumeBase{constructor(){super(...arguments),this.volumeId=attrs.volumeId,this.availabilityZone=attrs.availabilityZone,this.encryptionKey=attrs.encryptionKey}}if(!core_1.Token.isUnresolved(attrs.volumeId)&&!/^vol-[0-9a-fA-F]+$/.test(attrs.volumeId))throw new Error("`volumeId` does not match expected pattern. Expected `vol-<hexadecmial value>` (ex: `vol-05abe246af`) or a Token");return new Import(scope,id)}constructor(scope,id,props){super(scope,id,{physicalName:props.volumeName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VolumeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Volume),error}this.validateProps(props);const resource=new ec2_generated_1.CfnVolume(this,"Resource",{availabilityZone:props.availabilityZone,autoEnableIo:props.autoEnableIo,encrypted:props.encrypted,kmsKeyId:props.encryptionKey?.keyArn,iops:props.iops,multiAttachEnabled:props.enableMultiAttach??!1,size:props.size?.toGibibytes({rounding:core_1.SizeRoundingBehavior.FAIL}),snapshotId:props.snapshotId,throughput:props.throughput,volumeType:props.volumeType??EbsDeviceVolumeType.GENERAL_PURPOSE_SSD});if(resource.applyRemovalPolicy(props.removalPolicy),props.volumeName&&core_1.Tags.of(resource).add("Name",props.volumeName),this.volumeId=resource.ref,this.availabilityZone=props.availabilityZone,this.encryptionKey=props.encryptionKey,this.encryptionKey){const principal=new aws_kms_1.ViaServicePrincipal(`ec2.${core_1.Stack.of(this).region}.amazonaws.com`,new aws_iam_1.AccountRootPrincipal).withConditions({StringEquals:{"kms:CallerAccount":core_1.Stack.of(this).account}}),grant=this.encryptionKey.grant(principal,"kms:DescribeKey","kms:GenerateDataKeyWithoutPlainText");props.snapshotId&&grant.principalStatement?.addActions("kms:ReEncrypt*")}}validateProps(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VolumeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.validateProps),error}if(!(props.size||props.snapshotId))throw new Error("Must provide at least one of `size` or `snapshotId`");if(props.snapshotId&&!core_1.Token.isUnresolved(props.snapshotId)&&!/^snap-[0-9a-fA-F]+$/.test(props.snapshotId))throw new Error("`snapshotId` does match expected pattern. Expected `snap-<hexadecmial value>` (ex: `snap-05abe246af`) or Token");if(props.encryptionKey&&!props.encrypted)throw new Error("`encrypted` must be true when providing an `encryptionKey`.");if(props.volumeType&&[EbsDeviceVolumeType.PROVISIONED_IOPS_SSD,EbsDeviceVolumeType.PROVISIONED_IOPS_SSD_IO2].includes(props.volumeType)&&!props.iops)throw new Error("`iops` must be specified if the `volumeType` is `PROVISIONED_IOPS_SSD` or `PROVISIONED_IOPS_SSD_IO2`.");if(props.iops){const volumeType=props.volumeType??EbsDeviceVolumeType.GENERAL_PURPOSE_SSD;if(![EbsDeviceVolumeType.PROVISIONED_IOPS_SSD,EbsDeviceVolumeType.PROVISIONED_IOPS_SSD_IO2,EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3].includes(volumeType))throw new Error("`iops` may only be specified if the `volumeType` is `PROVISIONED_IOPS_SSD`, `PROVISIONED_IOPS_SSD_IO2` or `GENERAL_PURPOSE_SSD_GP3`.");const iopsRanges={};iopsRanges[EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3]={Min:3e3,Max:16e3},iopsRanges[EbsDeviceVolumeType.PROVISIONED_IOPS_SSD]={Min:100,Max:64e3},iopsRanges[EbsDeviceVolumeType.PROVISIONED_IOPS_SSD_IO2]={Min:100,Max:64e3};const{Min,Max}=iopsRanges[volumeType];if(props.iops<Min||props.iops>Max)throw new Error(`\`${volumeType}\` volumes iops must be between ${Min} and ${Max}.`);const maximumRatios={};maximumRatios[EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3]=500,maximumRatios[EbsDeviceVolumeType.PROVISIONED_IOPS_SSD]=50,maximumRatios[EbsDeviceVolumeType.PROVISIONED_IOPS_SSD_IO2]=500;const maximumRatio=maximumRatios[volumeType];if(props.size&&props.iops>maximumRatio*props.size.toGibibytes({rounding:core_1.SizeRoundingBehavior.FAIL}))throw new Error(`\`${volumeType}\` volumes iops has a maximum ratio of ${maximumRatio} IOPS/GiB.`);const maximumThroughputRatios={};maximumThroughputRatios[EbsDeviceVolumeType.GP3]=.25;const maximumThroughputRatio=maximumThroughputRatios[volumeType];if(props.throughput&&props.iops){const iopsRatio=props.throughput/props.iops;if(iopsRatio>maximumThroughputRatio)throw new Error(`Throughput (MiBps) to iops ratio of ${iopsRatio} is too high; maximum is ${maximumThroughputRatio} MiBps per iops`)}}if(props.enableMultiAttach){const volumeType=props.volumeType??EbsDeviceVolumeType.GENERAL_PURPOSE_SSD;if(![EbsDeviceVolumeType.PROVISIONED_IOPS_SSD,EbsDeviceVolumeType.PROVISIONED_IOPS_SSD_IO2].includes(volumeType))throw new Error("multi-attach is supported exclusively on `PROVISIONED_IOPS_SSD` and `PROVISIONED_IOPS_SSD_IO2` volumes.")}if(props.size){const size=props.size.toGibibytes({rounding:core_1.SizeRoundingBehavior.FAIL}),sizeRanges={};sizeRanges[EbsDeviceVolumeType.GENERAL_PURPOSE_SSD]={Min:1,Max:16384},sizeRanges[EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3]={Min:1,Max:16384},sizeRanges[EbsDeviceVolumeType.PROVISIONED_IOPS_SSD]={Min:4,Max:16384},sizeRanges[EbsDeviceVolumeType.PROVISIONED_IOPS_SSD_IO2]={Min:4,Max:16384},sizeRanges[EbsDeviceVolumeType.THROUGHPUT_OPTIMIZED_HDD]={Min:125,Max:16384},sizeRanges[EbsDeviceVolumeType.COLD_HDD]={Min:125,Max:16384},sizeRanges[EbsDeviceVolumeType.MAGNETIC]={Min:1,Max:1024};const volumeType=props.volumeType??EbsDeviceVolumeType.GENERAL_PURPOSE_SSD,{Min,Max}=sizeRanges[volumeType];if(size<Min||size>Max)throw new Error(`\`${volumeType}\` volumes must be between ${Min} GiB and ${Max} GiB in size.`)}if(props.throughput){const throughputRange={Min:125,Max:1e3},{Min,Max}=throughputRange;if(props.volumeType!=EbsDeviceVolumeType.GP3)throw new Error("throughput property requires volumeType: EbsDeviceVolumeType.GP3");if(props.throughput<Min||props.throughput>Max)throw new Error(`throughput property takes a minimum of ${Min} and a maximum of ${Max}`)}}}_b=JSII_RTTI_SYMBOL_1,Volume[_b]={fqn:"aws-cdk-lib.aws_ec2.Volume",version:"2.87.0"},exports.Volume=Volume;
