"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.VpcEndpointService=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2_generated_1=require("./ec2.generated"),core_1=require("../../core"),region_info_1=require("../../region-info");class VpcEndpointService extends core_1.Resource{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VpcEndpointServiceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,VpcEndpointService),error}if(props.vpcEndpointServiceLoadBalancers===void 0||props.vpcEndpointServiceLoadBalancers.length===0)throw new Error("VPC Endpoint Service must have at least one load balancer specified.");if(this.vpcEndpointServiceLoadBalancers=props.vpcEndpointServiceLoadBalancers,this.acceptanceRequired=props.acceptanceRequired??!0,props.allowedPrincipals&&props.whitelistedPrincipals)throw new Error("`whitelistedPrincipals` is deprecated; please use `allowedPrincipals` instead");this.allowedPrincipals=props.allowedPrincipals??props.whitelistedPrincipals??[],this.whitelistedPrincipals=this.allowedPrincipals,this.endpointService=new ec2_generated_1.CfnVPCEndpointService(this,id,{networkLoadBalancerArns:this.vpcEndpointServiceLoadBalancers.map(lb=>lb.loadBalancerArn),acceptanceRequired:this.acceptanceRequired}),this.vpcEndpointServiceId=this.endpointService.ref;const{region}=core_1.Stack.of(this),serviceNamePrefix=core_1.Token.isUnresolved(region)?region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX:region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix??region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;this.vpcEndpointServiceName=core_1.Fn.join(".",[serviceNamePrefix,core_1.Aws.REGION,this.vpcEndpointServiceId]),this.allowedPrincipals.length>0&&new ec2_generated_1.CfnVPCEndpointServicePermissions(this,"Permissions",{serviceId:this.endpointService.ref,allowedPrincipals:this.allowedPrincipals.map(x=>x.arn)})}}_a=JSII_RTTI_SYMBOL_1,VpcEndpointService[_a]={fqn:"aws-cdk-lib.aws_ec2.VpcEndpointService",version:"2.87.0"},exports.VpcEndpointService=VpcEndpointService;
