"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.QueueProcessingServiceBase=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),constructs_1=require("constructs"),aws_ecs_1=require("../../../aws-ecs"),aws_sqs_1=require("../../../aws-sqs"),core_1=require("../../../core"),cxapi=require("../../../cx-api");class QueueProcessingServiceBase extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_patterns_QueueProcessingServiceBaseProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,QueueProcessingServiceBase),error}if(props.cluster&&props.vpc)throw new Error("You can only specify either vpc or cluster. Alternatively, you can leave both blank");if(this.cluster=props.cluster||this.getDefaultCluster(this,props.vpc),props.queue&&(props.retentionPeriod||props.visibilityTimeout||props.maxReceiveCount)){const errorProps=["retentionPeriod","visibilityTimeout","maxReceiveCount"].filter(prop=>props.hasOwnProperty(prop));throw new Error(`${errorProps.join(", ")} can be set only when queue is not set. Specify them in the QueueProps of the queue`)}props.queue?this.sqsQueue=props.queue:(this.deadLetterQueue=new aws_sqs_1.Queue(this,"EcsProcessingDeadLetterQueue",{retentionPeriod:props.retentionPeriod||core_1.Duration.days(14)}),this.sqsQueue=new aws_sqs_1.Queue(this,"EcsProcessingQueue",{visibilityTimeout:props.visibilityTimeout,deadLetterQueue:{queue:this.deadLetterQueue,maxReceiveCount:props.maxReceiveCount||3}}),new core_1.CfnOutput(this,"SQSDeadLetterQueue",{value:this.deadLetterQueue.queueName}),new core_1.CfnOutput(this,"SQSDeadLetterQueueArn",{value:this.deadLetterQueue.queueArn}));const defaultScalingSteps=[{upper:0,change:-1},{lower:100,change:1},{lower:500,change:5}];this.scalingSteps=props.scalingSteps??defaultScalingSteps;const enableLogging=props.enableLogging??!0;if(this.logDriver=props.logDriver??(enableLogging?this.createAWSLogDriver(this.node.id):void 0),this.environment={...props.environment||{},QUEUE_NAME:this.sqsQueue.queueName},this.secrets=props.secrets,this.desiredCount=props.desiredTaskCount??1,core_1.FeatureFlags.of(this).isEnabled(cxapi.ECS_REMOVE_DEFAULT_DESIRED_COUNT)?props.desiredTaskCount!=null?(this.minCapacity=props.minScalingCapacity??this.desiredCount,this.maxCapacity=props.maxScalingCapacity||2*this.desiredCount):(this.minCapacity=props.minScalingCapacity??1,this.maxCapacity=props.maxScalingCapacity||2):(this.minCapacity=props.minScalingCapacity??this.desiredCount,this.maxCapacity=props.maxScalingCapacity||2*this.desiredCount),!this.desiredCount&&!this.maxCapacity)throw new Error("maxScalingCapacity must be set and greater than 0 if desiredCount is 0");new core_1.CfnOutput(this,"SQSQueue",{value:this.sqsQueue.queueName}),new core_1.CfnOutput(this,"SQSQueueArn",{value:this.sqsQueue.queueArn})}configureAutoscalingForService(service){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_BaseService(service)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureAutoscalingForService),error}const scalingTarget=service.autoScaleTaskCount({maxCapacity:this.maxCapacity,minCapacity:this.minCapacity});scalingTarget.scaleOnCpuUtilization("CpuScaling",{targetUtilizationPercent:50}),scalingTarget.scaleOnMetric("QueueMessagesVisibleScaling",{metric:this.sqsQueue.metricApproximateNumberOfMessagesVisible(),scalingSteps:this.scalingSteps})}grantPermissionsToService(service){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_BaseService(service)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantPermissionsToService),error}this.sqsQueue.grantConsumeMessages(service.taskDefinition.taskRole)}getDefaultCluster(scope,vpc){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IVpc(vpc)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getDefaultCluster),error}const DEFAULT_CLUSTER_ID=`EcsDefaultClusterMnL3mNNYN${vpc?vpc.node.id:""}`,stack=core_1.Stack.of(scope);return stack.node.tryFindChild(DEFAULT_CLUSTER_ID)||new aws_ecs_1.Cluster(stack,DEFAULT_CLUSTER_ID,{vpc})}createAWSLogDriver(prefix){return new aws_ecs_1.AwsLogDriver({streamPrefix:prefix})}}_a=JSII_RTTI_SYMBOL_1,QueueProcessingServiceBase[_a]={fqn:"aws-cdk-lib.aws_ecs_patterns.QueueProcessingServiceBase",version:"2.87.0"},exports.QueueProcessingServiceBase=QueueProcessingServiceBase;
