"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.isExternalCompatible=exports.isFargateCompatible=exports.isEc2Compatible=exports.Compatibility=exports.Scope=exports.PidMode=exports.IpcMode=exports.NetworkMode=exports.TaskDefinition=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),_imported_task_definition_1=require("./_imported-task-definition"),ec2=require("../../../aws-ec2"),iam=require("../../../aws-iam"),core_1=require("../../../core"),container_definition_1=require("../container-definition"),ecs_generated_1=require("../ecs.generated"),firelens_log_router_1=require("../firelens-log-router"),aws_log_driver_1=require("../log-drivers/aws-log-driver");class TaskDefinitionBase extends core_1.Resource{get isEc2Compatible(){return isEc2Compatible(this.compatibility)}get isFargateCompatible(){return isFargateCompatible(this.compatibility)}get isExternalCompatible(){return isExternalCompatible(this.compatibility)}}class TaskDefinition extends TaskDefinitionBase{static fromTaskDefinitionArn(scope,id,taskDefinitionArn){return new _imported_task_definition_1.ImportedTaskDefinition(scope,id,{taskDefinitionArn})}static fromTaskDefinitionAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_TaskDefinitionAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTaskDefinitionAttributes),error}return new _imported_task_definition_1.ImportedTaskDefinition(scope,id,{taskDefinitionArn:attrs.taskDefinitionArn,compatibility:attrs.compatibility,networkMode:attrs.networkMode,taskRole:attrs.taskRole,executionRole:attrs.executionRole})}constructor(scope,id,props){super(scope,id),this.containers=new Array,this.volumes=[],this.placementConstraints=new Array,this._inferenceAccelerators=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_TaskDefinitionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,TaskDefinition),error}if(this.family=props.family||core_1.Names.uniqueId(this),this.compatibility=props.compatibility,props.volumes&&props.volumes.forEach(v=>this.addVolume(v)),this.networkMode=props.networkMode??(this.isFargateCompatible?NetworkMode.AWS_VPC:NetworkMode.BRIDGE),this.isFargateCompatible&&this.networkMode!==NetworkMode.AWS_VPC)throw new Error(`Fargate tasks can only have AwsVpc network mode, got: ${this.networkMode}`);if(props.proxyConfiguration&&this.networkMode!==NetworkMode.AWS_VPC)throw new Error(`ProxyConfiguration can only be used with AwsVpc network mode, got: ${this.networkMode}`);if(props.placementConstraints&&props.placementConstraints.length>0&&this.isFargateCompatible)throw new Error("Cannot set placement constraints on tasks that run on Fargate");if(this.isFargateCompatible&&(!props.cpu||!props.memoryMiB))throw new Error(`Fargate-compatible tasks require both CPU (${props.cpu}) and memory (${props.memoryMiB}) specifications`);if(props.inferenceAccelerators&&props.inferenceAccelerators.length>0&&this.isFargateCompatible)throw new Error("Cannot use inference accelerators on tasks that run on Fargate");if(this.isExternalCompatible&&![NetworkMode.BRIDGE,NetworkMode.HOST,NetworkMode.NONE].includes(this.networkMode))throw new Error(`External tasks can only have Bridge, Host or None network mode, got: ${this.networkMode}`);if(!this.isFargateCompatible&&props.runtimePlatform)throw new Error("Cannot specify runtimePlatform in non-Fargate compatible tasks");this._executionRole=props.executionRole,this.taskRole=props.taskRole||new iam.Role(this,"TaskRole",{assumedBy:new iam.ServicePrincipal("ecs-tasks.amazonaws.com")}),props.inferenceAccelerators&&props.inferenceAccelerators.forEach(ia=>this.addInferenceAccelerator(ia)),this.ephemeralStorageGiB=props.ephemeralStorageGiB,props.runtimePlatform?.operatingSystemFamily?._operatingSystemFamily.includes("WINDOWS")&&this.checkFargateWindowsBasedTasksSize(props.cpu,props.memoryMiB,props.runtimePlatform),this.runtimePlatform=props.runtimePlatform,this._cpu=props.cpu,this._memory=props.memoryMiB;const taskDef=new ecs_generated_1.CfnTaskDefinition(this,"Resource",{containerDefinitions:core_1.Lazy.any({produce:()=>this.renderContainers()},{omitEmptyArray:!0}),volumes:core_1.Lazy.any({produce:()=>this.renderVolumes()},{omitEmptyArray:!0}),executionRoleArn:core_1.Lazy.string({produce:()=>this.executionRole&&this.executionRole.roleArn}),family:this.family,taskRoleArn:this.taskRole.roleArn,requiresCompatibilities:[...isEc2Compatible(props.compatibility)?["EC2"]:[],...isFargateCompatible(props.compatibility)?["FARGATE"]:[],...isExternalCompatible(props.compatibility)?["EXTERNAL"]:[]],networkMode:this.renderNetworkMode(this.networkMode),placementConstraints:core_1.Lazy.any({produce:()=>isFargateCompatible(this.compatibility)?void 0:this.placementConstraints},{omitEmptyArray:!0}),proxyConfiguration:props.proxyConfiguration?props.proxyConfiguration.bind(this.stack,this):void 0,cpu:props.cpu,memory:props.memoryMiB,ipcMode:props.ipcMode,pidMode:props.pidMode,inferenceAccelerators:core_1.Lazy.any({produce:()=>isFargateCompatible(this.compatibility)?void 0:this.renderInferenceAccelerators()},{omitEmptyArray:!0}),ephemeralStorage:this.ephemeralStorageGiB?{sizeInGiB:this.ephemeralStorageGiB}:void 0,runtimePlatform:this.isFargateCompatible&&this.runtimePlatform?{cpuArchitecture:this.runtimePlatform?.cpuArchitecture?._cpuArchitecture,operatingSystemFamily:this.runtimePlatform?.operatingSystemFamily?._operatingSystemFamily}:void 0});props.placementConstraints&&props.placementConstraints.forEach(pc=>this.addPlacementConstraint(pc)),this.taskDefinitionArn=taskDef.ref,this.node.addValidation({validate:()=>this.validateTaskDefinition()})}get executionRole(){return this._executionRole}get inferenceAccelerators(){return this._inferenceAccelerators}renderVolumes(){return this.volumes.map(renderVolume);function renderVolume(spec){return{host:spec.host,name:spec.name,dockerVolumeConfiguration:spec.dockerVolumeConfiguration&&{autoprovision:spec.dockerVolumeConfiguration.autoprovision,driver:spec.dockerVolumeConfiguration.driver,driverOpts:spec.dockerVolumeConfiguration.driverOpts,labels:spec.dockerVolumeConfiguration.labels,scope:spec.dockerVolumeConfiguration.scope},efsVolumeConfiguration:spec.efsVolumeConfiguration&&{filesystemId:spec.efsVolumeConfiguration.fileSystemId,authorizationConfig:spec.efsVolumeConfiguration.authorizationConfig,rootDirectory:spec.efsVolumeConfiguration.rootDirectory,transitEncryption:spec.efsVolumeConfiguration.transitEncryption,transitEncryptionPort:spec.efsVolumeConfiguration.transitEncryptionPort}}}}renderInferenceAccelerators(){return this._inferenceAccelerators.map(renderInferenceAccelerator);function renderInferenceAccelerator(inferenceAccelerator){return{deviceName:inferenceAccelerator.deviceName,deviceType:inferenceAccelerator.deviceType}}}_validateTarget(options){const targetContainer=this.findContainer(options.containerName);if(targetContainer===void 0)throw new Error(`No container named '${options.containerName}'. Did you call "addContainer()"?`);const targetProtocol=options.protocol||container_definition_1.Protocol.TCP,targetContainerPort=options.containerPort||targetContainer.containerPort,portMapping=targetContainer.findPortMapping(targetContainerPort,targetProtocol);if(portMapping===void 0)throw new Error(`Container '${targetContainer}' has no mapping for port ${options.containerPort} and protocol ${targetProtocol}. Did you call "container.addPortMappings()"?`);return{containerName:options.containerName,portMapping}}_portRangeFromPortMapping(portMapping){return portMapping.hostPort!==void 0&&portMapping.hostPort!==0?portMapping.protocol===container_definition_1.Protocol.UDP?ec2.Port.udp(portMapping.hostPort):ec2.Port.tcp(portMapping.hostPort):this.networkMode===NetworkMode.BRIDGE||this.networkMode===NetworkMode.NAT?EPHEMERAL_PORT_RANGE:portMapping.protocol===container_definition_1.Protocol.UDP?ec2.Port.udp(portMapping.containerPort):ec2.Port.tcp(portMapping.containerPort)}addToTaskRolePolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToTaskRolePolicy),error}this.taskRole.addToPrincipalPolicy(statement)}addToExecutionRolePolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToExecutionRolePolicy),error}this.obtainExecutionRole().addToPrincipalPolicy(statement)}addContainer(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDefinitionOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addContainer),error}return new container_definition_1.ContainerDefinition(this,id,{taskDefinition:this,...props})}addFirelensLogRouter(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_FirelensLogRouterDefinitionOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFirelensLogRouter),error}if(this.containers.find(x=>x instanceof firelens_log_router_1.FirelensLogRouter))throw new Error("Firelens log router is already added in this task.");return new firelens_log_router_1.FirelensLogRouter(this,id,{taskDefinition:this,...props})}_linkContainer(container){if(this._cpu){const taskCpu=Number(this._cpu),sumOfContainerCpu=[...this.containers,container].map(c=>c.cpu).filter(cpu=>typeof cpu=="number").reduce((a,c)=>a+c,0);if(taskCpu<sumOfContainerCpu)throw new Error("The sum of all container cpu values cannot be greater than the value of the task cpu")}this.containers.push(container),this.defaultContainer===void 0&&container.essential&&(this.defaultContainer=container)}addVolume(volume){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Volume(volume)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addVolume),error}this.volumes.push(volume)}addPlacementConstraint(constraint){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_PlacementConstraint(constraint)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPlacementConstraint),error}if(isFargateCompatible(this.compatibility))throw new Error("Cannot set placement constraints on tasks that run on Fargate");this.placementConstraints.push(...constraint.toJson())}addExtension(extension){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ITaskDefinitionExtension(extension)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addExtension),error}extension.extend(this)}addInferenceAccelerator(inferenceAccelerator){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_InferenceAccelerator(inferenceAccelerator)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addInferenceAccelerator),error}if(isFargateCompatible(this.compatibility))throw new Error("Cannot use inference accelerators on tasks that run on Fargate");this._inferenceAccelerators.push(inferenceAccelerator)}grantRun(grantee){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantRun),error}return grantee.grantPrincipal.addToPrincipalPolicy(this.passRoleStatement),iam.Grant.addToPrincipal({grantee,actions:["ecs:RunTask"],resourceArns:[this.taskDefinitionArn]})}obtainExecutionRole(){return this._executionRole||(this._executionRole=new iam.Role(this,"ExecutionRole",{assumedBy:new iam.ServicePrincipal("ecs-tasks.amazonaws.com"),roleName:core_1.PhysicalName.GENERATE_IF_NEEDED}),this.passRoleStatement.addResources(this._executionRole.roleArn)),this._executionRole}get referencesSecretJsonField(){for(const container of this.containers)if(container.referencesSecretJsonField)return!0;return!1}validateTaskDefinition(){const ret=new Array;if(isEc2Compatible(this.compatibility)&&!this._memory)for(const container of this.containers)container.memoryLimitSpecified||ret.push(`ECS Container ${container.containerName} must have at least one of 'memoryLimitMiB' or 'memoryReservationMiB' specified`);const portMappingNames=new Map;return this.containers.forEach(container=>{for(const pm of container.portMappings)pm.name&&(portMappingNames.has(pm.name)&&ret.push(`Port mapping name '${pm.name}' cannot appear in both '${container.containerName}' and '${portMappingNames.get(pm.name)}'`),portMappingNames.set(pm.name,container.containerName))}),ret}findPortMappingByName(name){let portMapping;return this.containers.forEach(container=>{const pm=container.findPortMappingByName(name);pm&&(portMapping=pm)}),portMapping}findContainer(containerName){return this.containers.find(c=>c.containerName===containerName)}get passRoleStatement(){return this._passRoleStatement||(this._passRoleStatement=new iam.PolicyStatement({effect:iam.Effect.ALLOW,actions:["iam:PassRole"],resources:this.executionRole?[this.taskRole.roleArn,this.executionRole.roleArn]:[this.taskRole.roleArn],conditions:{StringLike:{"iam:PassedToService":"ecs-tasks.amazonaws.com"}}})),this._passRoleStatement}renderNetworkMode(networkMode){return networkMode===NetworkMode.NAT?void 0:networkMode}renderContainers(){for(const container of this.containers)if(container.logDriverConfig&&container.logDriverConfig.logDriver==="awsfirelens"&&!this.containers.find(x=>x instanceof firelens_log_router_1.FirelensLogRouter)){this.addFirelensLogRouter("log-router",{image:(0,firelens_log_router_1.obtainDefaultFluentBitECRImage)(this,container.logDriverConfig),firelensConfig:{type:firelens_log_router_1.FirelensLogRouterType.FLUENTBIT},logging:new aws_log_driver_1.AwsLogDriver({streamPrefix:"firelens"}),memoryReservationMiB:50});break}return this.containers.map(x=>x.renderContainerDefinition())}checkFargateWindowsBasedTasksSize(cpu,memory,runtimePlatform){if(Number(cpu)===1024){if(Number(memory)<1024||Number(memory)>8192||Number(memory)%1024!==0)throw new Error(`If provided cpu is ${cpu}, then memoryMiB must have a min of 1024 and a max of 8192, in 1024 increments. Provided memoryMiB was ${Number(memory)}.`)}else if(Number(cpu)===2048){if(Number(memory)<4096||Number(memory)>16384||Number(memory)%1024!==0)throw new Error(`If provided cpu is ${cpu}, then memoryMiB must have a min of 4096 and max of 16384, in 1024 increments. Provided memoryMiB ${Number(memory)}.`)}else if(Number(cpu)===4096){if(Number(memory)<8192||Number(memory)>30720||Number(memory)%1024!==0)throw new Error(`If provided cpu is ${cpu}, then memoryMiB must have a min of 8192 and a max of 30720, in 1024 increments.Provided memoryMiB was ${Number(memory)}.`)}else throw new Error(`If operatingSystemFamily is ${runtimePlatform.operatingSystemFamily._operatingSystemFamily}, then cpu must be in 1024 (1 vCPU), 2048 (2 vCPU), or 4096 (4 vCPU). Provided value was: ${cpu}`)}}_a=JSII_RTTI_SYMBOL_1,TaskDefinition[_a]={fqn:"aws-cdk-lib.aws_ecs.TaskDefinition",version:"2.87.0"},exports.TaskDefinition=TaskDefinition;const EPHEMERAL_PORT_RANGE=ec2.Port.tcpRange(32768,65535);var NetworkMode;(function(NetworkMode2){NetworkMode2.NONE="none",NetworkMode2.BRIDGE="bridge",NetworkMode2.AWS_VPC="awsvpc",NetworkMode2.HOST="host",NetworkMode2.NAT="nat"})(NetworkMode=exports.NetworkMode||(exports.NetworkMode={}));var IpcMode;(function(IpcMode2){IpcMode2.NONE="none",IpcMode2.HOST="host",IpcMode2.TASK="task"})(IpcMode=exports.IpcMode||(exports.IpcMode={}));var PidMode;(function(PidMode2){PidMode2.HOST="host",PidMode2.TASK="task"})(PidMode=exports.PidMode||(exports.PidMode={}));var Scope;(function(Scope2){Scope2.TASK="task",Scope2.SHARED="shared"})(Scope=exports.Scope||(exports.Scope={}));var Compatibility;(function(Compatibility2){Compatibility2[Compatibility2.EC2=0]="EC2",Compatibility2[Compatibility2.FARGATE=1]="FARGATE",Compatibility2[Compatibility2.EC2_AND_FARGATE=2]="EC2_AND_FARGATE",Compatibility2[Compatibility2.EXTERNAL=3]="EXTERNAL"})(Compatibility=exports.Compatibility||(exports.Compatibility={}));function isEc2Compatible(compatibility){return[Compatibility.EC2,Compatibility.EC2_AND_FARGATE].includes(compatibility)}exports.isEc2Compatible=isEc2Compatible;function isFargateCompatible(compatibility){return[Compatibility.FARGATE,Compatibility.EC2_AND_FARGATE].includes(compatibility)}exports.isFargateCompatible=isFargateCompatible;function isExternalCompatible(compatibility){return[Compatibility.EXTERNAL].includes(compatibility)}exports.isExternalCompatible=isExternalCompatible;
