"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BuiltInAttributes=exports.Ec2Service=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../../aws-ec2"),core_1=require("../../../core"),base_service_1=require("../base/base-service"),from_service_attributes_1=require("../base/from-service-attributes"),task_definition_1=require("../base/task-definition");class Ec2Service extends base_service_1.BaseService{static fromEc2ServiceArn(scope,id,ec2ServiceArn){class Import extends core_1.Resource{constructor(){super(...arguments),this.serviceArn=ec2ServiceArn,this.serviceName=(0,from_service_attributes_1.extractServiceNameFromArn)(this,ec2ServiceArn)}}return new Import(scope,id)}static fromEc2ServiceAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Ec2ServiceAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEc2ServiceAttributes),error}return(0,from_service_attributes_1.fromServiceAttributes)(scope,id,attrs)}constructor(scope,id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Ec2ServiceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Ec2Service),error}if(props.daemon&&props.desiredCount!==void 0)throw new Error("Daemon mode launches one task on every instance. Don't supply desiredCount.");if(props.daemon&&props.maxHealthyPercent!==void 0&&props.maxHealthyPercent!==100)throw new Error("Maximum percent must be 100 for daemon mode.");if(props.minHealthyPercent!==void 0&&props.maxHealthyPercent!==void 0&&props.minHealthyPercent>=props.maxHealthyPercent)throw new Error("Minimum healthy percent must be less than maximum healthy percent.");if(!props.taskDefinition.isEc2Compatible)throw new Error("Supplied TaskDefinition is not configured for compatibility with EC2");if(props.securityGroup!==void 0&&props.securityGroups!==void 0)throw new Error("Only one of SecurityGroup or SecurityGroups can be populated.");super(scope,id,{...props,desiredCount:props.desiredCount,maxHealthyPercent:props.daemon&&props.maxHealthyPercent===void 0?100:props.maxHealthyPercent,minHealthyPercent:props.daemon&&props.minHealthyPercent===void 0?0:props.minHealthyPercent,launchType:base_service_1.LaunchType.EC2,enableECSManagedTags:props.enableECSManagedTags},{cluster:props.cluster.clusterName,taskDefinition:props.deploymentController?.type===base_service_1.DeploymentControllerType.EXTERNAL?void 0:props.taskDefinition.taskDefinitionArn,placementConstraints:core_1.Lazy.any({produce:()=>this.constraints},{omitEmptyArray:!0}),placementStrategies:core_1.Lazy.any({produce:()=>this.strategies},{omitEmptyArray:!0}),schedulingStrategy:props.daemon?"DAEMON":"REPLICA"},props.taskDefinition),this.constraints=[],this.strategies=[],this.daemon=props.daemon||!1;let securityGroups;props.securityGroup!==void 0?securityGroups=[props.securityGroup]:props.securityGroups!==void 0&&(securityGroups=props.securityGroups),props.taskDefinition.networkMode===task_definition_1.NetworkMode.AWS_VPC?this.configureAwsVpcNetworkingWithSecurityGroups(props.cluster.vpc,props.assignPublicIp,props.vpcSubnets,securityGroups):(validateNoNetworkingProps(props),this.connections.addSecurityGroup(...securityGroupsInThisStack(this,props.cluster.connections.securityGroups))),this.addPlacementConstraints(...props.placementConstraints||[]),this.addPlacementStrategies(...props.placementStrategies||[]),this.node.addValidation({validate:()=>this.taskDefinition.defaultContainer?[]:["A TaskDefinition must have at least one essential container"]}),this.node.addValidation({validate:this.validateEc2Service.bind(this)})}addPlacementStrategies(...strategies){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_PlacementStrategy(strategies)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPlacementStrategies),error}if(strategies.length>0&&this.daemon)throw new Error("Can't configure placement strategies when daemon=true");for(const strategy of strategies)this.strategies.push(...strategy.toJson())}addPlacementConstraints(...constraints){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_PlacementConstraint(constraints)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPlacementConstraints),error}for(const constraint of constraints)this.constraints.push(...constraint.toJson())}validateEc2Service(){const ret=new Array;return!this.daemon&&!this.cluster.hasEc2Capacity&&ret.push("Cluster for this service needs Ec2 capacity. Call addXxxCapacity() on the cluster."),ret}}_a=JSII_RTTI_SYMBOL_1,Ec2Service[_a]={fqn:"aws-cdk-lib.aws_ecs.Ec2Service",version:"2.87.0"},exports.Ec2Service=Ec2Service;function validateNoNetworkingProps(props){if(props.vpcSubnets!==void 0||props.securityGroup!==void 0||props.securityGroups!==void 0||props.assignPublicIp)throw new Error("vpcSubnets, securityGroup(s) and assignPublicIp can only be used in AwsVpc networking mode")}function securityGroupsInThisStack(scope,groups){const thisStack=core_1.Stack.of(scope);let i=1;return groups.map(group=>thisStack===core_1.Stack.of(group)?group:ec2.SecurityGroup.fromSecurityGroupId(scope,`SecurityGroup${i++}`,group.securityGroupId,{allowAllOutbound:group.allowAllOutbound,mutable:!0}))}class BuiltInAttributes{}_b=JSII_RTTI_SYMBOL_1,BuiltInAttributes[_b]={fqn:"aws-cdk-lib.aws_ecs.BuiltInAttributes",version:"2.87.0"},BuiltInAttributes.INSTANCE_ID="instanceId",BuiltInAttributes.AVAILABILITY_ZONE="attribute:ecs.availability-zone",BuiltInAttributes.AMI_ID="attribute:ecs.ami-id",BuiltInAttributes.INSTANCE_TYPE="attribute:ecs.instance-type",BuiltInAttributes.OS_TYPE="attribute:ecs.os-type",exports.BuiltInAttributes=BuiltInAttributes;
