"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FileSystem=exports.ThroughputMode=exports.PerformanceMode=exports.OutOfInfrequentAccessPolicy=exports.LifecyclePolicy=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),constructs_1=require("constructs"),access_point_1=require("./access-point"),efs_generated_1=require("./efs.generated"),ec2=require("../../aws-ec2"),iam=require("../../aws-iam"),core_1=require("../../core"),cxapi=require("../../cx-api");var LifecyclePolicy;(function(LifecyclePolicy2){LifecyclePolicy2.AFTER_1_DAY="AFTER_1_DAY",LifecyclePolicy2.AFTER_7_DAYS="AFTER_7_DAYS",LifecyclePolicy2.AFTER_14_DAYS="AFTER_14_DAYS",LifecyclePolicy2.AFTER_30_DAYS="AFTER_30_DAYS",LifecyclePolicy2.AFTER_60_DAYS="AFTER_60_DAYS",LifecyclePolicy2.AFTER_90_DAYS="AFTER_90_DAYS"})(LifecyclePolicy=exports.LifecyclePolicy||(exports.LifecyclePolicy={}));var OutOfInfrequentAccessPolicy;(function(OutOfInfrequentAccessPolicy2){OutOfInfrequentAccessPolicy2.AFTER_1_ACCESS="AFTER_1_ACCESS"})(OutOfInfrequentAccessPolicy=exports.OutOfInfrequentAccessPolicy||(exports.OutOfInfrequentAccessPolicy={}));var PerformanceMode;(function(PerformanceMode2){PerformanceMode2.GENERAL_PURPOSE="generalPurpose",PerformanceMode2.MAX_IO="maxIO"})(PerformanceMode=exports.PerformanceMode||(exports.PerformanceMode={}));var ThroughputMode;(function(ThroughputMode2){ThroughputMode2.BURSTING="bursting",ThroughputMode2.PROVISIONED="provisioned",ThroughputMode2.ELASTIC="elastic"})(ThroughputMode=exports.ThroughputMode||(exports.ThroughputMode={}));class FileSystemBase extends core_1.Resource{grant(grantee,...actions){return iam.Grant.addToPrincipal({grantee,actions,resourceArns:[this.fileSystemArn]})}addToResourcePolicy(statement){return this._resource?(this._fileSystemPolicy=this._fileSystemPolicy??new iam.PolicyDocument({statements:[]}),this._fileSystemPolicy.addStatements(statement),{statementAdded:!0,policyDependable:this}):{statementAdded:!1}}}class FileSystem extends FileSystemBase{static fromFileSystemAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_efs_FileSystemAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromFileSystemAttributes),error}return new ImportedFileSystem(scope,id,attrs)}constructor(scope,id,props){super(scope,id),this._mountTargetsAvailable=new constructs_1.DependencyGroup;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_efs_FileSystemProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,FileSystem),error}if(props.throughputMode===ThroughputMode.PROVISIONED&&props.provisionedThroughputPerSecond===void 0)throw new Error("Property provisionedThroughputPerSecond is required when throughputMode is PROVISIONED");if(props.throughputMode===ThroughputMode.ELASTIC&&props.performanceMode===PerformanceMode.MAX_IO)throw new Error("ThroughputMode ELASTIC is not supported for file systems with performanceMode MAX_IO");const encrypted=props.encrypted??(core_1.FeatureFlags.of(this).isEnabled(cxapi.EFS_DEFAULT_ENCRYPTION_AT_REST)?!0:void 0);let lifecyclePolicies=[];props.lifecyclePolicy&&lifecyclePolicies.push({transitionToIa:props.lifecyclePolicy}),props.outOfInfrequentAccessPolicy&&lifecyclePolicies.push({transitionToPrimaryStorageClass:props.outOfInfrequentAccessPolicy}),this._resource=new efs_generated_1.CfnFileSystem(this,"Resource",{encrypted,kmsKeyId:props.kmsKey?.keyArn,lifecyclePolicies:lifecyclePolicies.length>0?lifecyclePolicies:void 0,performanceMode:props.performanceMode,throughputMode:props.throughputMode,provisionedThroughputInMibps:props.provisionedThroughputPerSecond?.toMebibytes(),backupPolicy:props.enableAutomaticBackups?{status:"ENABLED"}:void 0,fileSystemPolicy:core_1.Lazy.any({produce:()=>this._fileSystemPolicy})}),this._resource.applyRemovalPolicy(props.removalPolicy),this.fileSystemId=this._resource.ref,this.fileSystemArn=this._resource.attrArn,this._fileSystemPolicy=props.fileSystemPolicy,core_1.Tags.of(this).add("Name",props.fileSystemName||this.node.path);const securityGroup=props.securityGroup||new ec2.SecurityGroup(this,"EfsSecurityGroup",{vpc:props.vpc});this.connections=new ec2.Connections({securityGroups:[securityGroup],defaultPort:ec2.Port.tcp(FileSystem.DEFAULT_PORT)});const subnets=props.vpc.selectSubnets(props.vpcSubnets??{onePerAz:!0});let mountTargetCount=0;this.mountTargetsAvailable=[],subnets.subnetIds.forEach(subnetId=>{const mountTarget=new efs_generated_1.CfnMountTarget(this,"EfsMountTarget"+ ++mountTargetCount,{fileSystemId:this.fileSystemId,securityGroups:Array.of(securityGroup.securityGroupId),subnetId});this._mountTargetsAvailable.add(mountTarget)}),this.mountTargetsAvailable=this._mountTargetsAvailable}addAccessPoint(id,accessPointOptions={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_efs_AccessPointOptions(accessPointOptions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAccessPoint),error}return new access_point_1.AccessPoint(this,id,{fileSystem:this,...accessPointOptions})}}_a=JSII_RTTI_SYMBOL_1,FileSystem[_a]={fqn:"aws-cdk-lib.aws_efs.FileSystem",version:"2.87.0"},FileSystem.DEFAULT_PORT=2049,exports.FileSystem=FileSystem;class ImportedFileSystem extends FileSystemBase{constructor(scope,id,attrs){if(super(scope,id),!!attrs.fileSystemId==!!attrs.fileSystemArn)throw new Error("One of fileSystemId or fileSystemArn, but not both, must be provided.");this.fileSystemArn=attrs.fileSystemArn??core_1.Stack.of(scope).formatArn({service:"elasticfilesystem",resource:"file-system",resourceName:attrs.fileSystemId});const parsedArn=core_1.Stack.of(scope).splitArn(this.fileSystemArn,core_1.ArnFormat.SLASH_RESOURCE_NAME);if(!parsedArn.resourceName)throw new Error(`Invalid FileSystem Arn ${this.fileSystemArn}`);this.fileSystemId=attrs.fileSystemId??parsedArn.resourceName,this.connections=new ec2.Connections({securityGroups:[attrs.securityGroup],defaultPort:ec2.Port.tcp(FileSystem.DEFAULT_PORT)}),this.mountTargetsAvailable=new constructs_1.DependencyGroup}}
