"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.isComplete=exports.onEvent=void 0;const client_eks_1=require("@aws-sdk/client-eks"),credential_providers_1=require("@aws-sdk/credential-providers"),node_http_handler_1=require("@aws-sdk/node-http-handler"),cluster_1=require("./cluster"),consts=require("./consts"),fargate_1=require("./fargate"),ProxyAgent=require("proxy-agent"),proxyAgent=new ProxyAgent,awsConfig={logger:console,requestHandler:new node_http_handler_1.NodeHttpHandler({httpAgent:proxyAgent,httpsAgent:proxyAgent})};let eks;const defaultEksClient={createCluster:req=>getEksClient().createCluster(req),deleteCluster:req=>getEksClient().deleteCluster(req),describeCluster:req=>getEksClient().describeCluster(req),describeUpdate:req=>getEksClient().describeUpdate(req),updateClusterConfig:req=>getEksClient().updateClusterConfig(req),updateClusterVersion:req=>getEksClient().updateClusterVersion(req),createFargateProfile:req=>getEksClient().createFargateProfile(req),deleteFargateProfile:req=>getEksClient().deleteFargateProfile(req),describeFargateProfile:req=>getEksClient().describeFargateProfile(req),configureAssumeRole:req=>{eks=new client_eks_1.EKS({...awsConfig,credentials:(0,credential_providers_1.fromTemporaryCredentials)({params:req})})}};function getEksClient(){if(!eks)throw new Error('EKS client not initialized (call "configureAssumeRole")');return eks}async function onEvent(event){return createResourceHandler(event).onEvent()}exports.onEvent=onEvent;async function isComplete(event){return createResourceHandler(event).isComplete()}exports.isComplete=isComplete;function createResourceHandler(event){switch(event.ResourceType){case consts.CLUSTER_RESOURCE_TYPE:return new cluster_1.ClusterResourceHandler(defaultEksClient,event);case consts.FARGATE_PROFILE_RESOURCE_TYPE:return new fargate_1.FargateProfileResourceHandler(defaultEksClient,event);default:throw new Error(`Unsupported resource type "${event.ResourceType}`)}}
