"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.ClusterResourceProvider=void 0;const path=require("path"),lambda=require("../../aws-lambda"),core_1=require("../../core"),cr=require("../../custom-resources"),lambda_layer_node_proxy_agent_1=require("../../lambda-layer-node-proxy-agent"),HANDLER_DIR=path.join(__dirname,"cluster-resource-handler");class ClusterResourceProvider extends core_1.NestedStack{static getOrCreate(scope,props){const stack=core_1.Stack.of(scope),uid="@aws-cdk/aws-eks.ClusterResourceProvider";return stack.node.tryFindChild(uid)??new ClusterResourceProvider(stack,uid,props)}constructor(scope,id,props){super(scope,id);const nodeProxyAgentLayer=new lambda_layer_node_proxy_agent_1.NodeProxyAgentLayer(this,"NodeProxyAgentLayer"),onEvent=new lambda.Function(this,"OnEventHandler",{code:lambda.Code.fromAsset(HANDLER_DIR),description:"onEvent handler for EKS cluster resource provider",runtime:lambda.Runtime.NODEJS_18_X,environment:{AWS_STS_REGIONAL_ENDPOINTS:"regional",...props.environment},handler:"index.onEvent",timeout:core_1.Duration.minutes(1),vpc:props.subnets?props.vpc:void 0,vpcSubnets:props.subnets?{subnets:props.subnets}:void 0,securityGroups:props.securityGroup?[props.securityGroup]:void 0,layers:props.onEventLayer?[props.onEventLayer]:[nodeProxyAgentLayer]}),isComplete=new lambda.Function(this,"IsCompleteHandler",{code:lambda.Code.fromAsset(HANDLER_DIR),description:"isComplete handler for EKS cluster resource provider",runtime:lambda.Runtime.NODEJS_18_X,environment:{AWS_STS_REGIONAL_ENDPOINTS:"regional",...props.environment},handler:"index.isComplete",timeout:core_1.Duration.minutes(1),vpc:props.subnets?props.vpc:void 0,vpcSubnets:props.subnets?{subnets:props.subnets}:void 0,securityGroups:props.securityGroup?[props.securityGroup]:void 0,layers:[nodeProxyAgentLayer]});this.provider=new cr.Provider(this,"Provider",{onEventHandler:onEvent,isCompleteHandler:isComplete,totalTimeout:core_1.Duration.hours(1),queryInterval:core_1.Duration.minutes(1),vpc:props.subnets?props.vpc:void 0,vpcSubnets:props.subnets?{subnets:props.subnets}:void 0,securityGroups:props.securityGroup?[props.securityGroup]:void 0})}get serviceToken(){return this.provider.serviceToken}}exports.ClusterResourceProvider=ClusterResourceProvider;
