"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.UnauthenticatedAction=exports.ListenerAction=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_ec2_1=require("../../../aws-ec2"),core_1=require("../../../core");class ListenerAction{static authenticateOidc(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_AuthenticateOidcOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.authenticateOidc),error}return new AuthenticateOidcAction(options)}static forward(targetGroups,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ForwardOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.forward),error}if(targetGroups.length===0)throw new Error("Need at least one targetGroup in a ListenerAction.forward()");return targetGroups.length===1&&options.stickinessDuration===void 0?new TargetGroupListenerAction(targetGroups,{type:"forward",targetGroupArn:targetGroups[0].targetGroupArn}):ListenerAction.weightedForward(targetGroups.map(g=>({targetGroup:g,weight:1})),options)}static weightedForward(targetGroups,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ForwardOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.weightedForward),error}if(targetGroups.length===0)throw new Error("Need at least one targetGroup in a ListenerAction.weightedForward()");return new TargetGroupListenerAction(targetGroups.map(g=>g.targetGroup),{type:"forward",forwardConfig:{targetGroups:targetGroups.map(g=>({targetGroupArn:g.targetGroup.targetGroupArn,weight:g.weight})),targetGroupStickinessConfig:options.stickinessDuration?{durationSeconds:options.stickinessDuration.toSeconds(),enabled:!0}:void 0}})}static fixedResponse(statusCode,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_FixedResponseOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fixedResponse),error}return new ListenerAction({type:"fixed-response",fixedResponseConfig:{statusCode:core_1.Tokenization.stringifyNumber(statusCode),contentType:options.contentType,messageBody:options.messageBody}})}static redirect(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_RedirectOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.redirect),error}if([options.host,options.path,options.port,options.protocol,options.query].findIndex(x=>x!==void 0)===-1)throw new Error("To prevent redirect loops, set at least one of 'protocol', 'host', 'port', 'path', or 'query'.");return new ListenerAction({type:"redirect",redirectConfig:{statusCode:options.permanent?"HTTP_301":"HTTP_302",host:options.host,path:options.path,port:options.port,protocol:options.protocol,query:options.query}})}constructor(defaultActionJson,next){this.defaultActionJson=defaultActionJson,this.next=next;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_CfnListener_ActionProperty(defaultActionJson),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ListenerAction(next)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ListenerAction),error}}renderRuleActions(){const actionJson=this._actionJson??this.defaultActionJson;return this._renumber([actionJson,...this.next?.renderRuleActions()??[]])}renderActions(){return this._renumber([this.defaultActionJson,...this.next?.renderActions()??[]])}bind(scope,listener,associatingConstruct){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_IApplicationListener(listener)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}this.next?.bind(scope,listener,associatingConstruct)}_renumber(actions){return actions.length<2?actions:actions.map((action,i)=>({...action,order:i+1}))}renumber(actions){return this._renumber(actions)}addRuleAction(actionJson){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_CfnListenerRule_ActionProperty(actionJson)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addRuleAction),error}if(this._actionJson)throw new Error("rule action is already set");this._actionJson=actionJson}}_a=JSII_RTTI_SYMBOL_1,ListenerAction[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.ListenerAction",version:"2.87.0"},exports.ListenerAction=ListenerAction;var UnauthenticatedAction;(function(UnauthenticatedAction2){UnauthenticatedAction2.DENY="deny",UnauthenticatedAction2.ALLOW="allow",UnauthenticatedAction2.AUTHENTICATE="authenticate"})(UnauthenticatedAction=exports.UnauthenticatedAction||(exports.UnauthenticatedAction={}));class TargetGroupListenerAction extends ListenerAction{constructor(targetGroups,defaultActionJson){super(defaultActionJson),this.targetGroups=targetGroups}bind(_scope,listener,associatingConstruct){for(const tg of this.targetGroups)tg.registerListener(listener,associatingConstruct)}}class AuthenticateOidcAction extends ListenerAction{constructor(options){const defaultActionConfig={authorizationEndpoint:options.authorizationEndpoint,clientId:options.clientId,clientSecret:options.clientSecret.unsafeUnwrap(),issuer:options.issuer,tokenEndpoint:options.tokenEndpoint,userInfoEndpoint:options.userInfoEndpoint,authenticationRequestExtraParams:options.authenticationRequestExtraParams,onUnauthenticatedRequest:options.onUnauthenticatedRequest,scope:options.scope,sessionCookieName:options.sessionCookieName,sessionTimeout:options.sessionTimeout?.toSeconds().toString()};super({type:"authenticate-oidc",authenticateOidcConfig:defaultActionConfig},options.next),this.allowHttpsOutbound=options.allowHttpsOutbound??!0,this.addRuleAction({type:"authenticate-oidc",authenticateOidcConfig:{...defaultActionConfig,sessionTimeout:options.sessionTimeout?.toSeconds()}})}bind(scope,listener,associatingConstruct){super.bind(scope,listener,associatingConstruct),this.allowHttpsOutbound&&listener.connections.allowToAnyIpv4(aws_ec2_1.Port.tcp(443),"Allow to IdP endpoint")}}
