"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ApplicationListener=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),application_listener_action_1=require("./application-listener-action"),application_listener_certificate_1=require("./application-listener-certificate"),application_listener_rule_1=require("./application-listener-rule"),application_target_group_1=require("./application-target-group"),ec2=require("../../../aws-ec2"),cxschema=require("../../../cloud-assembly-schema"),core_1=require("../../../core"),base_listener_1=require("../shared/base-listener"),enums_1=require("../shared/enums"),listener_certificate_1=require("../shared/listener-certificate"),util_1=require("../shared/util");class ApplicationListener extends base_listener_1.BaseListener{static fromLookup(scope,id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerLookupOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLookup),error}if(core_1.Token.isUnresolved(options.listenerArn))throw new Error("All arguments to look up a load balancer listener must be concrete (no Tokens)");let listenerProtocol;switch(options.listenerProtocol){case enums_1.ApplicationProtocol.HTTP:listenerProtocol=cxschema.LoadBalancerListenerProtocol.HTTP;break;case enums_1.ApplicationProtocol.HTTPS:listenerProtocol=cxschema.LoadBalancerListenerProtocol.HTTPS;break}const props=base_listener_1.BaseListener._queryContextProvider(scope,{userOptions:options,loadBalancerType:cxschema.LoadBalancerType.APPLICATION,listenerArn:options.listenerArn,listenerProtocol});return new LookedUpApplicationListener(scope,id,props)}static fromApplicationListenerAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromApplicationListenerAttributes),error}return new ImportedApplicationListener(scope,id,attrs)}constructor(scope,id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ApplicationListener),error}const[protocol,port]=(0,util_1.determineProtocolAndPort)(props.protocol,props.port);if(protocol===void 0||port===void 0)throw new Error("At least one of 'port' or 'protocol' is required");if(super(scope,id,{loadBalancerArn:props.loadBalancer.loadBalancerArn,certificates:core_1.Lazy.any({produce:()=>this.certificateArns.map(certificateArn=>({certificateArn}))},{omitEmptyArray:!0}),protocol,port,sslPolicy:props.sslPolicy}),this.loadBalancer=props.loadBalancer,this.protocol=protocol,this.certificateArns=[],props.certificateArns&&props.certificateArns.length>0&&this.addCertificateArns("ListenerCertificate",props.certificateArns),props.certificates&&props.certificates.length>0&&this.addCertificates("DefaultCertificates",props.certificates),this.connections=new ec2.Connections({securityGroups:props.loadBalancer.connections.securityGroups,defaultPort:ec2.Port.tcp(port)}),props.defaultAction&&props.defaultTargetGroups)throw new Error("Specify at most one of 'defaultAction' and 'defaultTargetGroups'");props.defaultAction&&this.setDefaultAction(props.defaultAction),props.defaultTargetGroups&&this.setDefaultAction(application_listener_action_1.ListenerAction.forward(props.defaultTargetGroups)),props.open!==!1&&(this.connections.allowDefaultPortFrom(ec2.Peer.anyIpv4(),`Allow from anyone on port ${port}`),this.loadBalancer.ipAddressType===enums_1.IpAddressType.DUAL_STACK&&this.connections.allowDefaultPortFrom(ec2.Peer.anyIpv6(),`Allow from anyone on port ${port}`))}addCertificateArns(id,arns){this.addCertificates(id,arns.map(listener_certificate_1.ListenerCertificate.fromArn))}addCertificates(id,certificates){const additionalCerts=[...certificates];if(this.certificateArns.length===0&&additionalCerts.length>0){const first=additionalCerts.splice(0,1)[0];this.certificateArns.push(first.certificateArn)}for(let i=0;i<additionalCerts.length;i++)new application_listener_certificate_1.ApplicationListenerCertificate(this,`${id}${i+1}`,{listener:this,certificates:[additionalCerts[i]]})}addAction(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_AddApplicationActionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAction),error}checkAddRuleProps(props),props.priority!==void 0?new application_listener_rule_1.ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,...props}):this.setDefaultAction(props.action)}addTargetGroups(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_AddApplicationTargetGroupsProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addTargetGroups),error}checkAddRuleProps(props),props.priority!==void 0?new application_listener_rule_1.ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,...props}):this.setDefaultAction(application_listener_action_1.ListenerAction.forward(props.targetGroups))}addTargets(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_AddApplicationTargetsProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addTargets),error}if(!this.loadBalancer.vpc)throw new Error("Can only call addTargets() when using a constructed Load Balancer or an imported Load Balancer with specified vpc; construct a new TargetGroup and use addTargetGroup");const group=new application_target_group_1.ApplicationTargetGroup(this,id+"Group",{vpc:this.loadBalancer.vpc,...props});return this.addTargetGroups(id,{targetGroups:[group],...props}),group}addFixedResponse(id,props){checkAddRuleProps(props);const fixedResponse={statusCode:props.statusCode,contentType:props.contentType,messageBody:props.messageBody};if(fixedResponse.statusCode&&!/^(2|4|5)\d\d$/.test(fixedResponse.statusCode))throw new Error("`statusCode` must be 2XX, 4XX or 5XX.");if(fixedResponse.messageBody&&fixedResponse.messageBody.length>1024)throw new Error("`messageBody` cannot have more than 1024 characters.");props.priority?new application_listener_rule_1.ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,fixedResponse,...props}):this.setDefaultAction(application_listener_action_1.ListenerAction.fixedResponse(core_1.Token.asNumber(props.statusCode),{contentType:props.contentType,messageBody:props.messageBody}))}addRedirectResponse(id,props){checkAddRuleProps(props);const redirectResponse={host:props.host,path:props.path,port:props.port,protocol:props.protocol,query:props.query,statusCode:props.statusCode};if(redirectResponse.protocol&&!/^(HTTPS?|#\{protocol\})$/i.test(redirectResponse.protocol))throw new Error("`protocol` must be HTTP, HTTPS, or #{protocol}.");if(!redirectResponse.statusCode||!/^HTTP_30[12]$/.test(redirectResponse.statusCode))throw new Error("`statusCode` must be HTTP_301 or HTTP_302.");props.priority?new application_listener_rule_1.ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,redirectResponse,...props}):this.setDefaultAction(application_listener_action_1.ListenerAction.redirect({host:props.host,path:props.path,port:props.port,protocol:props.protocol,query:props.query,permanent:props.statusCode==="HTTP_301"}))}registerConnectable(connectable,portRange){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IConnectable(connectable),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_Port(portRange)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.registerConnectable),error}connectable.connections.allowFrom(this.loadBalancer,portRange,"Load balancer to target")}validateListener(){const errors=super.validateListener();return this.protocol===enums_1.ApplicationProtocol.HTTPS&&this.certificateArns.length===0&&errors.push("HTTPS Listener needs at least one certificate (call addCertificates)"),errors}setDefaultAction(action){action.bind(this,this),this._setDefaultAction(action)}}_a=JSII_RTTI_SYMBOL_1,ApplicationListener[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener",version:"2.87.0"},exports.ApplicationListener=ApplicationListener;class ExternalApplicationListener extends core_1.Resource{constructor(scope,id){super(scope,id)}registerConnectable(connectable,portRange){this.connections.allowTo(connectable,portRange,"Load balancer to target")}addCertificateArns(id,arns){this.addCertificates(id,arns.map(listener_certificate_1.ListenerCertificate.fromArn))}addCertificates(id,certificates){new application_listener_certificate_1.ApplicationListenerCertificate(this,id,{listener:this,certificates})}addTargetGroups(id,props){if(checkAddRuleProps(props),props.priority!==void 0)new application_listener_rule_1.ApplicationListenerRule(this,id,{listener:this,priority:props.priority,...props});else throw new Error("Cannot add default Target Groups to imported ApplicationListener")}addTargets(_id,_props){throw new Error("Can only call addTargets() when using a constructed ApplicationListener; construct a new TargetGroup and use addTargetGroup.")}addAction(id,props){if(checkAddRuleProps(props),props.priority!==void 0)new application_listener_rule_1.ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,...props});else throw new Error("priority must be set for actions added to an imported listener")}}class ImportedApplicationListener extends ExternalApplicationListener{constructor(scope,id,props){super(scope,id),this.listenerArn=props.listenerArn;const defaultPort=props.defaultPort!==void 0?ec2.Port.tcp(props.defaultPort):void 0;this.connections=new ec2.Connections({securityGroups:[props.securityGroup],defaultPort})}}class LookedUpApplicationListener extends ExternalApplicationListener{constructor(scope,id,props){super(scope,id),this.listenerArn=props.listenerArn,this.connections=new ec2.Connections({defaultPort:ec2.Port.tcp(props.listenerPort)});for(const securityGroupId of props.securityGroupIds){const securityGroup=ec2.SecurityGroup.fromLookupById(this,`SecurityGroup-${securityGroupId}`,securityGroupId);this.connections.addSecurityGroup(securityGroup)}}}function checkAddRuleProps(props){const hasAnyConditions=(props.conditions?.length||0)!==0||props.hostHeader!==void 0||props.pathPattern!==void 0||props.pathPatterns!==void 0,hasPriority=props.priority!==void 0;if(hasAnyConditions!==hasPriority)throw new Error("Setting 'conditions', 'pathPattern' or 'hostHeader' also requires 'priority', and vice versa")}
