"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ApplicationTargetGroup=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../../aws-cloudwatch"),ec2=require("../../../aws-ec2"),core_1=require("../../../core"),elasticloadbalancingv2_canned_metrics_generated_1=require("../elasticloadbalancingv2-canned-metrics.generated"),base_target_group_1=require("../shared/base-target-group"),enums_1=require("../shared/enums"),imported_1=require("../shared/imported"),util_1=require("../shared/util");class ApplicationTargetGroupMetrics{constructor(scope,targetGroupFullName,loadBalancerFullName){this.scope=scope,this.targetGroupFullName=targetGroupFullName,this.loadBalancerFullName=loadBalancerFullName}custom(metricName,props){return new cloudwatch.Metric({namespace:"AWS/ApplicationELB",metricName,dimensionsMap:{TargetGroup:this.targetGroupFullName,LoadBalancer:this.loadBalancerFullName},...props}).attachTo(this.scope)}ipv6RequestCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.iPv6RequestCountSum,props)}requestCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.requestCountSum,props)}healthyHostCount(props){return this.custom("HealthyHostCount",{statistic:"Average",...props})}unhealthyHostCount(props){return this.custom("UnHealthyHostCount",{statistic:"Average",...props})}httpCodeTarget(code,props){return this.custom(code,{statistic:"Sum",...props})}requestCountPerTarget(props){return this.custom("RequestCountPerTarget",{statistic:"Sum",...props})}targetConnectionErrorCount(props){return this.custom("TargetConnectionErrorCount",{statistic:"Sum",...props})}targetResponseTime(props){return this.custom("TargetResponseTime",{statistic:"Average",...props})}targetTLSNegotiationErrorCount(props){return this.custom("TargetTLSNegotiationErrorCount",{statistic:"Sum",...props})}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({LoadBalancer:this.loadBalancerFullName,TargetGroup:this.targetGroupFullName}),...props}).attachTo(this.scope)}}class ApplicationTargetGroup extends base_target_group_1.TargetGroupBase{static fromTargetGroupAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_TargetGroupAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTargetGroupAttributes),error}return new ImportedApplicationTargetGroup(scope,id,attrs)}static import(scope,id,props){return ApplicationTargetGroup.fromTargetGroupAttributes(scope,id,props)}constructor(scope,id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationTargetGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ApplicationTargetGroup),error}const[protocol,port]=(0,util_1.determineProtocolAndPort)(props.protocol,props.port),{protocolVersion}=props;if(super(scope,id,{...props},{protocol,protocolVersion,port}),this.protocol=protocol,this.port=port,this.node.addValidation({validate:()=>this.targetType===enums_1.TargetType.LAMBDA&&(this.port||this.protocol)?["port/protocol should not be specified for Lambda targets"]:[]}),this.connectableMembers=[],this.listeners=[],props){if(props.slowStart!==void 0){if(props.slowStart.toSeconds()<30||props.slowStart.toSeconds()>900)throw new Error("Slow start duration value must be between 30 and 900 seconds.");this.setAttribute("slow_start.duration_seconds",props.slowStart.toSeconds().toString())}props.stickinessCookieDuration?this.enableCookieStickiness(props.stickinessCookieDuration,props.stickinessCookieName):this.setAttribute("stickiness.enabled","false"),props.loadBalancingAlgorithmType&&this.setAttribute("load_balancing.algorithm.type",props.loadBalancingAlgorithmType),this.addTarget(...props.targets||[])}}get metrics(){return this._metrics||(this._metrics=new ApplicationTargetGroupMetrics(this,this.targetGroupFullName,this.firstLoadBalancerFullName)),this._metrics}addTarget(...targets){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_IApplicationLoadBalancerTarget(targets)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addTarget),error}for(const target of targets){const result=target.attachToApplicationTargetGroup(this);this.addLoadBalancerTarget(result)}this.targetType===enums_1.TargetType.LAMBDA&&this.setAttribute("stickiness.enabled",void 0)}enableCookieStickiness(duration,cookieName){try{jsiiDeprecationWarnings.aws_cdk_lib_Duration(duration)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.enableCookieStickiness),error}if(duration.toSeconds()<1||duration.toSeconds()>604800)throw new Error("Stickiness cookie duration value must be between 1 second and 7 days (604800 seconds).");if(cookieName!==void 0){if(!core_1.Token.isUnresolved(cookieName)&&(cookieName.startsWith("AWSALB")||cookieName.startsWith("AWSALBAPP")||cookieName.startsWith("AWSALBTG")))throw new Error("App cookie names that start with the following prefixes are not allowed: AWSALB, AWSALBAPP, and AWSALBTG; they're reserved for use by the load balancer.");if(cookieName==="")throw new Error("App cookie name cannot be an empty string.")}this.setAttribute("stickiness.enabled","true"),cookieName?(this.setAttribute("stickiness.type","app_cookie"),this.setAttribute("stickiness.app_cookie.cookie_name",cookieName),this.setAttribute("stickiness.app_cookie.duration_seconds",duration.toSeconds().toString())):(this.setAttribute("stickiness.type","lb_cookie"),this.setAttribute("stickiness.lb_cookie.duration_seconds",duration.toSeconds().toString()))}registerConnectable(connectable,portRange){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IConnectable(connectable),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_Port(portRange)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.registerConnectable),error}portRange=portRange||ec2.Port.tcp(this.defaultPort),this.connectableMembers.push({connectable,portRange});for(const listener of this.listeners)listener.registerConnectable(connectable,portRange)}registerListener(listener,associatingConstruct){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_IApplicationListener(listener)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.registerListener),error}for(const member of this.connectableMembers)listener.registerConnectable(member.connectable,member.portRange);this.listeners.push(listener),this.loadBalancerAttachedDependencies.add(associatingConstruct??listener)}get firstLoadBalancerFullName(){if(this.listeners.length===0)throw new Error("The TargetGroup needs to be attached to a LoadBalancer before you can call this method");return(0,base_target_group_1.loadBalancerNameFromListenerArn)(this.listeners[0].listenerArn)}metric(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return this.metrics.custom(metricName,props)}metricIpv6RequestCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricIpv6RequestCount","Use ``ApplicationTargetGroup.metrics.ipv6RequestCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricIpv6RequestCount),error}return this.metrics.ipv6RequestCount(props)}metricRequestCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricRequestCount","Use ``ApplicationTargetGroup.metrics.requestCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricRequestCount),error}return this.metrics.requestCount(props)}metricHealthyHostCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricHealthyHostCount","Use ``ApplicationTargetGroup.metrics.healthyHostCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHealthyHostCount),error}return this.metrics.healthyHostCount(props)}metricUnhealthyHostCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricUnhealthyHostCount","Use ``ApplicationTargetGroup.metrics.unhealthyHostCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricUnhealthyHostCount),error}return this.metrics.unhealthyHostCount(props)}metricHttpCodeTarget(code,props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricHttpCodeTarget","Use ``ApplicationTargetGroup.metrics.httpCodeTarget`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_HttpCodeTarget(code),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHttpCodeTarget),error}return this.metrics.httpCodeTarget(code,props)}metricRequestCountPerTarget(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricRequestCountPerTarget","Use `ApplicationTargetGroup.metrics.requestCountPerTarget` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricRequestCountPerTarget),error}return this.metrics.requestCountPerTarget(props)}metricTargetConnectionErrorCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricTargetConnectionErrorCount","Use ``ApplicationTargetGroup.metrics.targetConnectionErrorCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTargetConnectionErrorCount),error}return this.metrics.targetConnectionErrorCount(props)}metricTargetResponseTime(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricTargetResponseTime","Use ``ApplicationTargetGroup.metrics.targetResponseTime`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTargetResponseTime),error}return this.metrics.targetResponseTime(props)}metricTargetTLSNegotiationErrorCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup#metricTargetTLSNegotiationErrorCount","Use ``ApplicationTargetGroup.metrics.tlsNegotiationErrorCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTargetTLSNegotiationErrorCount),error}return this.metrics.targetTLSNegotiationErrorCount(props)}validateTargetGroup(){const ret=super.validateTargetGroup();return this.targetType!==void 0&&this.targetType!==enums_1.TargetType.LAMBDA&&(this.protocol===void 0||this.port===void 0)&&ret.push("At least one of 'port' or 'protocol' is required for a non-Lambda TargetGroup"),this.healthCheck&&(this.healthCheck.interval&&this.healthCheck.timeout&&this.healthCheck.interval.toMilliseconds()<=this.healthCheck.timeout.toMilliseconds()&&ret.push(`Healthcheck interval ${this.healthCheck.interval.toHumanString()} must be greater than the timeout ${this.healthCheck.timeout.toHumanString()}`),this.healthCheck.protocol&&(ALB_HEALTH_CHECK_PROTOCOLS.includes(this.healthCheck.protocol)||ret.push([`Health check protocol '${this.healthCheck.protocol}' is not supported. `,`Must be one of [${ALB_HEALTH_CHECK_PROTOCOLS.join(", ")}]`].join("")))),ret}}_a=JSII_RTTI_SYMBOL_1,ApplicationTargetGroup[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup",version:"2.87.0"},exports.ApplicationTargetGroup=ApplicationTargetGroup;class ImportedApplicationTargetGroup extends imported_1.ImportedTargetGroupBase{constructor(scope,id,props){if(super(scope,id,props),this.loadBalancerArns!=core_1.Aws.NO_VALUE){const targetGroupFullName=(0,util_1.parseTargetGroupFullName)(this.targetGroupArn),firstLoadBalancerFullName=(0,util_1.parseLoadBalancerFullName)(this.loadBalancerArns);this._metrics=new ApplicationTargetGroupMetrics(this,targetGroupFullName,firstLoadBalancerFullName)}}registerListener(_listener,_associatingConstruct){core_1.Annotations.of(this).addWarning("Cannot register listener on imported target group -- security groups might need to be updated manually")}registerConnectable(_connectable,_portRange){core_1.Annotations.of(this).addWarning("Cannot register connectable on imported target group -- security groups might need to be updated manually")}addTarget(...targets){for(const target of targets)if(target.attachToApplicationTargetGroup(this).targetJson!==void 0)throw new Error("Cannot add a non-self registering target to an imported TargetGroup. Create a new TargetGroup instead.")}get metrics(){if(!this._metrics)throw new Error("The imported ApplicationTargetGroup needs the associated ApplicationBalancer to be able to provide metrics. Please specify the ARN value when importing it.");return this._metrics}}const ALB_HEALTH_CHECK_PROTOCOLS=[enums_1.Protocol.HTTP,enums_1.Protocol.HTTPS];
